package datafactory

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/satori/go.uuid"
	"net/http"
)

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// AuthenticationTypeAnonymous ...
	AuthenticationTypeAnonymous AuthenticationType = "Anonymous"
	// AuthenticationTypeBasic ...
	AuthenticationTypeBasic AuthenticationType = "Basic"
	// AuthenticationTypeClientCertificate ...
	AuthenticationTypeClientCertificate AuthenticationType = "ClientCertificate"
	// AuthenticationTypeWebLinkedServiceTypeProperties ...
	AuthenticationTypeWebLinkedServiceTypeProperties AuthenticationType = "WebLinkedServiceTypeProperties"
)

// AzureSearchIndexWriteBehaviorType enumerates the values for azure search index write behavior type.
type AzureSearchIndexWriteBehaviorType string

const (
	// Merge ...
	Merge AzureSearchIndexWriteBehaviorType = "Merge"
	// Upload ...
	Upload AzureSearchIndexWriteBehaviorType = "Upload"
)

// CassandraSourceReadConsistencyLevels enumerates the values for cassandra source read consistency levels.
type CassandraSourceReadConsistencyLevels string

const (
	// ALL ...
	ALL CassandraSourceReadConsistencyLevels = "ALL"
	// EACHQUORUM ...
	EACHQUORUM CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	// LOCALONE ...
	LOCALONE CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	// LOCALQUORUM ...
	LOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	// LOCALSERIAL ...
	LOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	// ONE ...
	ONE CassandraSourceReadConsistencyLevels = "ONE"
	// QUORUM ...
	QUORUM CassandraSourceReadConsistencyLevels = "QUORUM"
	// SERIAL ...
	SERIAL CassandraSourceReadConsistencyLevels = "SERIAL"
	// THREE ...
	THREE CassandraSourceReadConsistencyLevels = "THREE"
	// TWO ...
	TWO CassandraSourceReadConsistencyLevels = "TWO"
)

// CopyBehaviorType enumerates the values for copy behavior type.
type CopyBehaviorType string

const (
	// FlattenHierarchy ...
	FlattenHierarchy CopyBehaviorType = "FlattenHierarchy"
	// MergeFiles ...
	MergeFiles CopyBehaviorType = "MergeFiles"
	// PreserveHierarchy ...
	PreserveHierarchy CopyBehaviorType = "PreserveHierarchy"
)

// DatasetCompressionLevel enumerates the values for dataset compression level.
type DatasetCompressionLevel string

const (
	// Fastest ...
	Fastest DatasetCompressionLevel = "Fastest"
	// Optimal ...
	Optimal DatasetCompressionLevel = "Optimal"
)

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// Db2AuthenticationType enumerates the values for db 2 authentication type.
type Db2AuthenticationType string

const (
	// Basic ...
	Basic Db2AuthenticationType = "Basic"
)

// DependencyCondition enumerates the values for dependency condition.
type DependencyCondition string

const (
	// Completed ...
	Completed DependencyCondition = "Completed"
	// Failed ...
	Failed DependencyCondition = "Failed"
	// Skipped ...
	Skipped DependencyCondition = "Skipped"
	// Succeeded ...
	Succeeded DependencyCondition = "Succeeded"
)

// FtpAuthenticationType enumerates the values for ftp authentication type.
type FtpAuthenticationType string

const (
	// FtpAuthenticationTypeAnonymous ...
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	// FtpAuthenticationTypeBasic ...
	FtpAuthenticationTypeBasic FtpAuthenticationType = "Basic"
)

// GoogleBigQueryAuthenticationType enumerates the values for google big query authentication type.
type GoogleBigQueryAuthenticationType string

const (
	// ServiceAuthentication ...
	ServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	// UserAuthentication ...
	UserAuthentication GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// HBaseAuthenticationType enumerates the values for h base authentication type.
type HBaseAuthenticationType string

const (
	// HBaseAuthenticationTypeAnonymous ...
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	// HBaseAuthenticationTypeBasic ...
	HBaseAuthenticationTypeBasic HBaseAuthenticationType = "Basic"
)

// HDInsightActivityDebugInfoOption enumerates the values for hd insight activity debug info option.
type HDInsightActivityDebugInfoOption string

const (
	// Always ...
	Always HDInsightActivityDebugInfoOption = "Always"
	// Failure ...
	Failure HDInsightActivityDebugInfoOption = "Failure"
	// None ...
	None HDInsightActivityDebugInfoOption = "None"
)

// HiveAuthenticationType enumerates the values for hive authentication type.
type HiveAuthenticationType string

const (
	// Anonymous ...
	Anonymous HiveAuthenticationType = "Anonymous"
	// Username ...
	Username HiveAuthenticationType = "Username"
	// UsernameAndPassword ...
	UsernameAndPassword HiveAuthenticationType = "UsernameAndPassword"
	// WindowsAzureHDInsightService ...
	WindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// HiveServerType enumerates the values for hive server type.
type HiveServerType string

const (
	// HiveServer1 ...
	HiveServer1 HiveServerType = "HiveServer1"
	// HiveServer2 ...
	HiveServer2 HiveServerType = "HiveServer2"
	// HiveThriftServer ...
	HiveThriftServer HiveServerType = "HiveThriftServer"
)

// HiveThriftTransportProtocol enumerates the values for hive thrift transport protocol.
type HiveThriftTransportProtocol string

const (
	// Binary ...
	Binary HiveThriftTransportProtocol = "Binary"
	// HTTP ...
	HTTP HiveThriftTransportProtocol = "HTTP "
	// SASL ...
	SASL HiveThriftTransportProtocol = "SASL"
)

// HTTPAuthenticationType enumerates the values for http authentication type.
type HTTPAuthenticationType string

const (
	// HTTPAuthenticationTypeAnonymous ...
	HTTPAuthenticationTypeAnonymous HTTPAuthenticationType = "Anonymous"
	// HTTPAuthenticationTypeBasic ...
	HTTPAuthenticationTypeBasic HTTPAuthenticationType = "Basic"
	// HTTPAuthenticationTypeClientCertificate ...
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	// HTTPAuthenticationTypeDigest ...
	HTTPAuthenticationTypeDigest HTTPAuthenticationType = "Digest"
	// HTTPAuthenticationTypeWindows ...
	HTTPAuthenticationTypeWindows HTTPAuthenticationType = "Windows"
)

// ImpalaAuthenticationType enumerates the values for impala authentication type.
type ImpalaAuthenticationType string

const (
	// ImpalaAuthenticationTypeAnonymous ...
	ImpalaAuthenticationTypeAnonymous ImpalaAuthenticationType = "Anonymous"
	// ImpalaAuthenticationTypeSASLUsername ...
	ImpalaAuthenticationTypeSASLUsername ImpalaAuthenticationType = "SASLUsername"
	// ImpalaAuthenticationTypeUsernameAndPassword ...
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// IntegrationRuntimeAuthKeyName enumerates the values for integration runtime auth key name.
type IntegrationRuntimeAuthKeyName string

const (
	// AuthKey1 ...
	AuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	// AuthKey2 ...
	AuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// IntegrationRuntimeAutoUpdate enumerates the values for integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	// Off ...
	Off IntegrationRuntimeAutoUpdate = "Off"
	// On ...
	On IntegrationRuntimeAutoUpdate = "On"
)

// IntegrationRuntimeInternalChannelEncryptionMode enumerates the values for integration runtime internal channel
// encryption mode.
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	// NotEncrypted ...
	NotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	// NotSet ...
	NotSet IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	// SslEncrypted ...
	SslEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// IntegrationRuntimeLicenseType enumerates the values for integration runtime license type.
type IntegrationRuntimeLicenseType string

const (
	// BasePrice ...
	BasePrice IntegrationRuntimeLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// IntegrationRuntimeSsisCatalogPricingTier enumerates the values for integration runtime ssis catalog pricing tier.
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	// IntegrationRuntimeSsisCatalogPricingTierBasic ...
	IntegrationRuntimeSsisCatalogPricingTierBasic IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	// IntegrationRuntimeSsisCatalogPricingTierPremium ...
	IntegrationRuntimeSsisCatalogPricingTierPremium IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	// IntegrationRuntimeSsisCatalogPricingTierPremiumRS ...
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	// IntegrationRuntimeSsisCatalogPricingTierStandard ...
	IntegrationRuntimeSsisCatalogPricingTierStandard IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// IntegrationRuntimeState enumerates the values for integration runtime state.
type IntegrationRuntimeState string

const (
	// Initial ...
	Initial IntegrationRuntimeState = "Initial"
	// Limited ...
	Limited IntegrationRuntimeState = "Limited"
	// NeedRegistration ...
	NeedRegistration IntegrationRuntimeState = "NeedRegistration"
	// Offline ...
	Offline IntegrationRuntimeState = "Offline"
	// Online ...
	Online IntegrationRuntimeState = "Online"
	// Started ...
	Started IntegrationRuntimeState = "Started"
	// Starting ...
	Starting IntegrationRuntimeState = "Starting"
	// Stopped ...
	Stopped IntegrationRuntimeState = "Stopped"
	// Stopping ...
	Stopping IntegrationRuntimeState = "Stopping"
)

// IntegrationRuntimeType enumerates the values for integration runtime type.
type IntegrationRuntimeType string

const (
	// Managed ...
	Managed IntegrationRuntimeType = "Managed"
	// SelfHosted ...
	SelfHosted IntegrationRuntimeType = "SelfHosted"
)

// IntegrationRuntimeUpdateResult enumerates the values for integration runtime update result.
type IntegrationRuntimeUpdateResult string

const (
	// Fail ...
	Fail IntegrationRuntimeUpdateResult = "Fail"
	// Succeed ...
	Succeed IntegrationRuntimeUpdateResult = "Succeed"
)

// JSONFormatFilePattern enumerates the values for json format file pattern.
type JSONFormatFilePattern string

const (
	// ArrayOfObjects ...
	ArrayOfObjects JSONFormatFilePattern = "arrayOfObjects"
	// SetOfObjects ...
	SetOfObjects JSONFormatFilePattern = "setOfObjects"
)

// ManagedIntegrationRuntimeNodeStatus enumerates the values for managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	// ManagedIntegrationRuntimeNodeStatusAvailable ...
	ManagedIntegrationRuntimeNodeStatusAvailable ManagedIntegrationRuntimeNodeStatus = "Available"
	// ManagedIntegrationRuntimeNodeStatusRecycling ...
	ManagedIntegrationRuntimeNodeStatusRecycling ManagedIntegrationRuntimeNodeStatus = "Recycling"
	// ManagedIntegrationRuntimeNodeStatusStarting ...
	ManagedIntegrationRuntimeNodeStatusStarting ManagedIntegrationRuntimeNodeStatus = "Starting"
	// ManagedIntegrationRuntimeNodeStatusUnavailable ...
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// MongoDbAuthenticationType enumerates the values for mongo db authentication type.
type MongoDbAuthenticationType string

const (
	// MongoDbAuthenticationTypeAnonymous ...
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	// MongoDbAuthenticationTypeBasic ...
	MongoDbAuthenticationTypeBasic MongoDbAuthenticationType = "Basic"
)

// ODataAuthenticationType enumerates the values for o data authentication type.
type ODataAuthenticationType string

const (
	// ODataAuthenticationTypeAnonymous ...
	ODataAuthenticationTypeAnonymous ODataAuthenticationType = "Anonymous"
	// ODataAuthenticationTypeBasic ...
	ODataAuthenticationTypeBasic ODataAuthenticationType = "Basic"
)

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// Array ...
	Array ParameterType = "Array"
	// Bool ...
	Bool ParameterType = "Bool"
	// Float ...
	Float ParameterType = "Float"
	// Int ...
	Int ParameterType = "Int"
	// Object ...
	Object ParameterType = "Object"
	// String ...
	String ParameterType = "String"
)

// PhoenixAuthenticationType enumerates the values for phoenix authentication type.
type PhoenixAuthenticationType string

const (
	// PhoenixAuthenticationTypeAnonymous ...
	PhoenixAuthenticationTypeAnonymous PhoenixAuthenticationType = "Anonymous"
	// PhoenixAuthenticationTypeUsernameAndPassword ...
	PhoenixAuthenticationTypeUsernameAndPassword PhoenixAuthenticationType = "UsernameAndPassword"
	// PhoenixAuthenticationTypeWindowsAzureHDInsightService ...
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PipelineRunQueryFilterOperand enumerates the values for pipeline run query filter operand.
type PipelineRunQueryFilterOperand string

const (
	// PipelineName ...
	PipelineName PipelineRunQueryFilterOperand = "PipelineName"
	// RunEnd ...
	RunEnd PipelineRunQueryFilterOperand = "RunEnd"
	// RunStart ...
	RunStart PipelineRunQueryFilterOperand = "RunStart"
	// Status ...
	Status PipelineRunQueryFilterOperand = "Status"
)

// PipelineRunQueryFilterOperator enumerates the values for pipeline run query filter operator.
type PipelineRunQueryFilterOperator string

const (
	// Equals ...
	Equals PipelineRunQueryFilterOperator = "Equals"
	// In ...
	In PipelineRunQueryFilterOperator = "In"
	// NotEquals ...
	NotEquals PipelineRunQueryFilterOperator = "NotEquals"
	// NotIn ...
	NotIn PipelineRunQueryFilterOperator = "NotIn"
)

// PipelineRunQueryOrder enumerates the values for pipeline run query order.
type PipelineRunQueryOrder string

const (
	// ASC ...
	ASC PipelineRunQueryOrder = "ASC"
	// DESC ...
	DESC PipelineRunQueryOrder = "DESC"
)

// PipelineRunQueryOrderByField enumerates the values for pipeline run query order by field.
type PipelineRunQueryOrderByField string

const (
	// PipelineRunQueryOrderByFieldRunEnd ...
	PipelineRunQueryOrderByFieldRunEnd PipelineRunQueryOrderByField = "RunEnd"
	// PipelineRunQueryOrderByFieldRunStart ...
	PipelineRunQueryOrderByFieldRunStart PipelineRunQueryOrderByField = "RunStart"
)

// PolybaseSettingsRejectType enumerates the values for polybase settings reject type.
type PolybaseSettingsRejectType string

const (
	// Percentage ...
	Percentage PolybaseSettingsRejectType = "percentage"
	// Value ...
	Value PolybaseSettingsRejectType = "value"
)

// PrestoAuthenticationType enumerates the values for presto authentication type.
type PrestoAuthenticationType string

const (
	// PrestoAuthenticationTypeAnonymous ...
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	// PrestoAuthenticationTypeLDAP ...
	PrestoAuthenticationTypeLDAP PrestoAuthenticationType = "LDAP"
)

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day ...
	Day RecurrenceFrequency = "Day"
	// Hour ...
	Hour RecurrenceFrequency = "Hour"
	// Minute ...
	Minute RecurrenceFrequency = "Minute"
	// Month ...
	Month RecurrenceFrequency = "Month"
	// NotSpecified ...
	NotSpecified RecurrenceFrequency = "NotSpecified"
	// Week ...
	Week RecurrenceFrequency = "Week"
	// Year ...
	Year RecurrenceFrequency = "Year"
)

// SalesforceSinkWriteBehavior enumerates the values for salesforce sink write behavior.
type SalesforceSinkWriteBehavior string

const (
	// Insert ...
	Insert SalesforceSinkWriteBehavior = "Insert"
	// Upsert ...
	Upsert SalesforceSinkWriteBehavior = "Upsert"
)

// SalesforceSourceReadBehavior enumerates the values for salesforce source read behavior.
type SalesforceSourceReadBehavior string

const (
	// Query ...
	Query SalesforceSourceReadBehavior = "Query"
	// QueryAll ...
	QueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// SapCloudForCustomerSinkWriteBehavior enumerates the values for sap cloud for customer sink write behavior.
type SapCloudForCustomerSinkWriteBehavior string

const (
	// SapCloudForCustomerSinkWriteBehaviorInsert ...
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	// SapCloudForCustomerSinkWriteBehaviorUpdate ...
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// SapHanaAuthenticationType enumerates the values for sap hana authentication type.
type SapHanaAuthenticationType string

const (
	// SapHanaAuthenticationTypeBasic ...
	SapHanaAuthenticationTypeBasic SapHanaAuthenticationType = "Basic"
	// SapHanaAuthenticationTypeWindows ...
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// SelfHostedIntegrationRuntimeNodeStatus enumerates the values for self hosted integration runtime node status.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	// SelfHostedIntegrationRuntimeNodeStatusInitializeFailed ...
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	// SelfHostedIntegrationRuntimeNodeStatusInitializing ...
	SelfHostedIntegrationRuntimeNodeStatusInitializing SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	// SelfHostedIntegrationRuntimeNodeStatusLimited ...
	SelfHostedIntegrationRuntimeNodeStatusLimited SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	// SelfHostedIntegrationRuntimeNodeStatusNeedRegistration ...
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	// SelfHostedIntegrationRuntimeNodeStatusOffline ...
	SelfHostedIntegrationRuntimeNodeStatusOffline SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	// SelfHostedIntegrationRuntimeNodeStatusOnline ...
	SelfHostedIntegrationRuntimeNodeStatusOnline SelfHostedIntegrationRuntimeNodeStatus = "Online"
	// SelfHostedIntegrationRuntimeNodeStatusUpgrading ...
	SelfHostedIntegrationRuntimeNodeStatusUpgrading SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// ServiceNowAuthenticationType enumerates the values for service now authentication type.
type ServiceNowAuthenticationType string

const (
	// ServiceNowAuthenticationTypeBasic ...
	ServiceNowAuthenticationTypeBasic ServiceNowAuthenticationType = "Basic"
	// ServiceNowAuthenticationTypeOAuth2 ...
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// SftpAuthenticationType enumerates the values for sftp authentication type.
type SftpAuthenticationType string

const (
	// SftpAuthenticationTypeBasic ...
	SftpAuthenticationTypeBasic SftpAuthenticationType = "Basic"
	// SftpAuthenticationTypeSSHPublicKey ...
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// SparkAuthenticationType enumerates the values for spark authentication type.
type SparkAuthenticationType string

const (
	// SparkAuthenticationTypeAnonymous ...
	SparkAuthenticationTypeAnonymous SparkAuthenticationType = "Anonymous"
	// SparkAuthenticationTypeUsername ...
	SparkAuthenticationTypeUsername SparkAuthenticationType = "Username"
	// SparkAuthenticationTypeUsernameAndPassword ...
	SparkAuthenticationTypeUsernameAndPassword SparkAuthenticationType = "UsernameAndPassword"
	// SparkAuthenticationTypeWindowsAzureHDInsightService ...
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// SparkServerType enumerates the values for spark server type.
type SparkServerType string

const (
	// SharkServer ...
	SharkServer SparkServerType = "SharkServer"
	// SharkServer2 ...
	SharkServer2 SparkServerType = "SharkServer2"
	// SparkThriftServer ...
	SparkThriftServer SparkServerType = "SparkThriftServer"
)

// SparkThriftTransportProtocol enumerates the values for spark thrift transport protocol.
type SparkThriftTransportProtocol string

const (
	// SparkThriftTransportProtocolBinary ...
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	// SparkThriftTransportProtocolHTTP ...
	SparkThriftTransportProtocolHTTP SparkThriftTransportProtocol = "HTTP "
	// SparkThriftTransportProtocolSASL ...
	SparkThriftTransportProtocolSASL SparkThriftTransportProtocol = "SASL"
)

// SSISExecutionRuntime enumerates the values for ssis execution runtime.
type SSISExecutionRuntime string

const (
	// X64 ...
	X64 SSISExecutionRuntime = "x64"
	// X86 ...
	X86 SSISExecutionRuntime = "x86"
)

// StoredProcedureParameterType enumerates the values for stored procedure parameter type.
type StoredProcedureParameterType string

const (
	// StoredProcedureParameterTypeBoolean ...
	StoredProcedureParameterTypeBoolean StoredProcedureParameterType = "Boolean"
	// StoredProcedureParameterTypeDate ...
	StoredProcedureParameterTypeDate StoredProcedureParameterType = "Date"
	// StoredProcedureParameterTypeDecimal ...
	StoredProcedureParameterTypeDecimal StoredProcedureParameterType = "Decimal"
	// StoredProcedureParameterTypeGUID ...
	StoredProcedureParameterTypeGUID StoredProcedureParameterType = "Guid"
	// StoredProcedureParameterTypeInt ...
	StoredProcedureParameterTypeInt StoredProcedureParameterType = "Int"
	// StoredProcedureParameterTypeString ...
	StoredProcedureParameterTypeString StoredProcedureParameterType = "String"
)

// SybaseAuthenticationType enumerates the values for sybase authentication type.
type SybaseAuthenticationType string

const (
	// SybaseAuthenticationTypeBasic ...
	SybaseAuthenticationTypeBasic SybaseAuthenticationType = "Basic"
	// SybaseAuthenticationTypeWindows ...
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// TeradataAuthenticationType enumerates the values for teradata authentication type.
type TeradataAuthenticationType string

const (
	// TeradataAuthenticationTypeBasic ...
	TeradataAuthenticationTypeBasic TeradataAuthenticationType = "Basic"
	// TeradataAuthenticationTypeWindows ...
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// TriggerRunStatus enumerates the values for trigger run status.
type TriggerRunStatus string

const (
	// TriggerRunStatusFailed ...
	TriggerRunStatusFailed TriggerRunStatus = "Failed"
	// TriggerRunStatusInprogress ...
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	// TriggerRunStatusSucceeded ...
	TriggerRunStatusSucceeded TriggerRunStatus = "Succeeded"
)

// TriggerRuntimeState enumerates the values for trigger runtime state.
type TriggerRuntimeState string

const (
	// TriggerRuntimeStateDisabled ...
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	// TriggerRuntimeStateStarted ...
	TriggerRuntimeStateStarted TriggerRuntimeState = "Started"
	// TriggerRuntimeStateStopped ...
	TriggerRuntimeStateStopped TriggerRuntimeState = "Stopped"
)

// TumblingWindowFrequency enumerates the values for tumbling window frequency.
type TumblingWindowFrequency string

const (
	// TumblingWindowFrequencyHour ...
	TumblingWindowFrequencyHour TumblingWindowFrequency = "Hour"
	// TumblingWindowFrequencyMinute ...
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureKeyVaultSecret ...
	TypeAzureKeyVaultSecret Type = "AzureKeyVaultSecret"
	// TypeSecretBase ...
	TypeSecretBase Type = "SecretBase"
	// TypeSecureString ...
	TypeSecureString Type = "SecureString"
)

// TypeBasicActivity enumerates the values for type basic activity.
type TypeBasicActivity string

const (
	// TypeActivity ...
	TypeActivity TypeBasicActivity = "Activity"
	// TypeAzureMLBatchExecution ...
	TypeAzureMLBatchExecution TypeBasicActivity = "AzureMLBatchExecution"
	// TypeAzureMLUpdateResource ...
	TypeAzureMLUpdateResource TypeBasicActivity = "AzureMLUpdateResource"
	// TypeContainer ...
	TypeContainer TypeBasicActivity = "Container"
	// TypeCopy ...
	TypeCopy TypeBasicActivity = "Copy"
	// TypeCustom ...
	TypeCustom TypeBasicActivity = "Custom"
	// TypeDataLakeAnalyticsUSQL ...
	TypeDataLakeAnalyticsUSQL TypeBasicActivity = "DataLakeAnalyticsU-SQL"
	// TypeExecutePipeline ...
	TypeExecutePipeline TypeBasicActivity = "ExecutePipeline"
	// TypeExecuteSSISPackage ...
	TypeExecuteSSISPackage TypeBasicActivity = "ExecuteSSISPackage"
	// TypeExecution ...
	TypeExecution TypeBasicActivity = "Execution"
	// TypeForEach ...
	TypeForEach TypeBasicActivity = "ForEach"
	// TypeGetMetadata ...
	TypeGetMetadata TypeBasicActivity = "GetMetadata"
	// TypeHDInsightHive ...
	TypeHDInsightHive TypeBasicActivity = "HDInsightHive"
	// TypeHDInsightMapReduce ...
	TypeHDInsightMapReduce TypeBasicActivity = "HDInsightMapReduce"
	// TypeHDInsightPig ...
	TypeHDInsightPig TypeBasicActivity = "HDInsightPig"
	// TypeHDInsightSpark ...
	TypeHDInsightSpark TypeBasicActivity = "HDInsightSpark"
	// TypeHDInsightStreaming ...
	TypeHDInsightStreaming TypeBasicActivity = "HDInsightStreaming"
	// TypeIfCondition ...
	TypeIfCondition TypeBasicActivity = "IfCondition"
	// TypeLookup ...
	TypeLookup TypeBasicActivity = "Lookup"
	// TypeSQLServerStoredProcedure ...
	TypeSQLServerStoredProcedure TypeBasicActivity = "SqlServerStoredProcedure"
	// TypeUntil ...
	TypeUntil TypeBasicActivity = "Until"
	// TypeWait ...
	TypeWait TypeBasicActivity = "Wait"
	// TypeWebActivity ...
	TypeWebActivity TypeBasicActivity = "WebActivity"
)

// TypeBasicCopySink enumerates the values for type basic copy sink.
type TypeBasicCopySink string

const (
	// TypeAzureDataLakeStoreSink ...
	TypeAzureDataLakeStoreSink TypeBasicCopySink = "AzureDataLakeStoreSink"
	// TypeAzureQueueSink ...
	TypeAzureQueueSink TypeBasicCopySink = "AzureQueueSink"
	// TypeAzureSearchIndexSink ...
	TypeAzureSearchIndexSink TypeBasicCopySink = "AzureSearchIndexSink"
	// TypeAzureTableSink ...
	TypeAzureTableSink TypeBasicCopySink = "AzureTableSink"
	// TypeBlobSink ...
	TypeBlobSink TypeBasicCopySink = "BlobSink"
	// TypeCopySink ...
	TypeCopySink TypeBasicCopySink = "CopySink"
	// TypeDocumentDbCollectionSink ...
	TypeDocumentDbCollectionSink TypeBasicCopySink = "DocumentDbCollectionSink"
	// TypeDynamicsSink ...
	TypeDynamicsSink TypeBasicCopySink = "DynamicsSink"
	// TypeFileSystemSink ...
	TypeFileSystemSink TypeBasicCopySink = "FileSystemSink"
	// TypeOdbcSink ...
	TypeOdbcSink TypeBasicCopySink = "OdbcSink"
	// TypeOracleSink ...
	TypeOracleSink TypeBasicCopySink = "OracleSink"
	// TypeSalesforceSink ...
	TypeSalesforceSink TypeBasicCopySink = "SalesforceSink"
	// TypeSapCloudForCustomerSink ...
	TypeSapCloudForCustomerSink TypeBasicCopySink = "SapCloudForCustomerSink"
	// TypeSQLDWSink ...
	TypeSQLDWSink TypeBasicCopySink = "SqlDWSink"
	// TypeSQLSink ...
	TypeSQLSink TypeBasicCopySink = "SqlSink"
)

// TypeBasicCopySource enumerates the values for type basic copy source.
type TypeBasicCopySource string

const (
	// TypeAmazonMWSSource ...
	TypeAmazonMWSSource TypeBasicCopySource = "AmazonMWSSource"
	// TypeAmazonRedshiftSource ...
	TypeAmazonRedshiftSource TypeBasicCopySource = "AmazonRedshiftSource"
	// TypeAzureDataLakeStoreSource ...
	TypeAzureDataLakeStoreSource TypeBasicCopySource = "AzureDataLakeStoreSource"
	// TypeAzureMySQLSource ...
	TypeAzureMySQLSource TypeBasicCopySource = "AzureMySqlSource"
	// TypeAzurePostgreSQLSource ...
	TypeAzurePostgreSQLSource TypeBasicCopySource = "AzurePostgreSqlSource"
	// TypeAzureTableSource ...
	TypeAzureTableSource TypeBasicCopySource = "AzureTableSource"
	// TypeBlobSource ...
	TypeBlobSource TypeBasicCopySource = "BlobSource"
	// TypeCassandraSource ...
	TypeCassandraSource TypeBasicCopySource = "CassandraSource"
	// TypeConcurSource ...
	TypeConcurSource TypeBasicCopySource = "ConcurSource"
	// TypeCopySource ...
	TypeCopySource TypeBasicCopySource = "CopySource"
	// TypeCouchbaseSource ...
	TypeCouchbaseSource TypeBasicCopySource = "CouchbaseSource"
	// TypeDocumentDbCollectionSource ...
	TypeDocumentDbCollectionSource TypeBasicCopySource = "DocumentDbCollectionSource"
	// TypeDrillSource ...
	TypeDrillSource TypeBasicCopySource = "DrillSource"
	// TypeDynamicsSource ...
	TypeDynamicsSource TypeBasicCopySource = "DynamicsSource"
	// TypeEloquaSource ...
	TypeEloquaSource TypeBasicCopySource = "EloquaSource"
	// TypeFileSystemSource ...
	TypeFileSystemSource TypeBasicCopySource = "FileSystemSource"
	// TypeGoogleBigQuerySource ...
	TypeGoogleBigQuerySource TypeBasicCopySource = "GoogleBigQuerySource"
	// TypeGreenplumSource ...
	TypeGreenplumSource TypeBasicCopySource = "GreenplumSource"
	// TypeHBaseSource ...
	TypeHBaseSource TypeBasicCopySource = "HBaseSource"
	// TypeHdfsSource ...
	TypeHdfsSource TypeBasicCopySource = "HdfsSource"
	// TypeHiveSource ...
	TypeHiveSource TypeBasicCopySource = "HiveSource"
	// TypeHTTPSource ...
	TypeHTTPSource TypeBasicCopySource = "HttpSource"
	// TypeHubspotSource ...
	TypeHubspotSource TypeBasicCopySource = "HubspotSource"
	// TypeImpalaSource ...
	TypeImpalaSource TypeBasicCopySource = "ImpalaSource"
	// TypeJiraSource ...
	TypeJiraSource TypeBasicCopySource = "JiraSource"
	// TypeMagentoSource ...
	TypeMagentoSource TypeBasicCopySource = "MagentoSource"
	// TypeMariaDBSource ...
	TypeMariaDBSource TypeBasicCopySource = "MariaDBSource"
	// TypeMarketoSource ...
	TypeMarketoSource TypeBasicCopySource = "MarketoSource"
	// TypeMongoDbSource ...
	TypeMongoDbSource TypeBasicCopySource = "MongoDbSource"
	// TypeOracleSource ...
	TypeOracleSource TypeBasicCopySource = "OracleSource"
	// TypePaypalSource ...
	TypePaypalSource TypeBasicCopySource = "PaypalSource"
	// TypePhoenixSource ...
	TypePhoenixSource TypeBasicCopySource = "PhoenixSource"
	// TypePrestoSource ...
	TypePrestoSource TypeBasicCopySource = "PrestoSource"
	// TypeQuickBooksSource ...
	TypeQuickBooksSource TypeBasicCopySource = "QuickBooksSource"
	// TypeRelationalSource ...
	TypeRelationalSource TypeBasicCopySource = "RelationalSource"
	// TypeSalesforceSource ...
	TypeSalesforceSource TypeBasicCopySource = "SalesforceSource"
	// TypeSapCloudForCustomerSource ...
	TypeSapCloudForCustomerSource TypeBasicCopySource = "SapCloudForCustomerSource"
	// TypeServiceNowSource ...
	TypeServiceNowSource TypeBasicCopySource = "ServiceNowSource"
	// TypeShopifySource ...
	TypeShopifySource TypeBasicCopySource = "ShopifySource"
	// TypeSparkSource ...
	TypeSparkSource TypeBasicCopySource = "SparkSource"
	// TypeSQLDWSource ...
	TypeSQLDWSource TypeBasicCopySource = "SqlDWSource"
	// TypeSQLSource ...
	TypeSQLSource TypeBasicCopySource = "SqlSource"
	// TypeSquareSource ...
	TypeSquareSource TypeBasicCopySource = "SquareSource"
	// TypeWebSource ...
	TypeWebSource TypeBasicCopySource = "WebSource"
	// TypeXeroSource ...
	TypeXeroSource TypeBasicCopySource = "XeroSource"
	// TypeZohoSource ...
	TypeZohoSource TypeBasicCopySource = "ZohoSource"
)

// TypeBasicCopyTranslator enumerates the values for type basic copy translator.
type TypeBasicCopyTranslator string

const (
	// TypeCopyTranslator ...
	TypeCopyTranslator TypeBasicCopyTranslator = "CopyTranslator"
	// TypeTabularTranslator ...
	TypeTabularTranslator TypeBasicCopyTranslator = "TabularTranslator"
)

// TypeBasicDataset enumerates the values for type basic dataset.
type TypeBasicDataset string

const (
	// TypeAmazonMWSObject ...
	TypeAmazonMWSObject TypeBasicDataset = "AmazonMWSObject"
	// TypeAmazonS3Object ...
	TypeAmazonS3Object TypeBasicDataset = "AmazonS3Object"
	// TypeAzureBlob ...
	TypeAzureBlob TypeBasicDataset = "AzureBlob"
	// TypeAzureDataLakeStoreFile ...
	TypeAzureDataLakeStoreFile TypeBasicDataset = "AzureDataLakeStoreFile"
	// TypeAzureMySQLTable ...
	TypeAzureMySQLTable TypeBasicDataset = "AzureMySqlTable"
	// TypeAzurePostgreSQLTable ...
	TypeAzurePostgreSQLTable TypeBasicDataset = "AzurePostgreSqlTable"
	// TypeAzureSearchIndex ...
	TypeAzureSearchIndex TypeBasicDataset = "AzureSearchIndex"
	// TypeAzureSQLDWTable ...
	TypeAzureSQLDWTable TypeBasicDataset = "AzureSqlDWTable"
	// TypeAzureSQLTable ...
	TypeAzureSQLTable TypeBasicDataset = "AzureSqlTable"
	// TypeAzureTable ...
	TypeAzureTable TypeBasicDataset = "AzureTable"
	// TypeCassandraTable ...
	TypeCassandraTable TypeBasicDataset = "CassandraTable"
	// TypeConcurObject ...
	TypeConcurObject TypeBasicDataset = "ConcurObject"
	// TypeCouchbaseTable ...
	TypeCouchbaseTable TypeBasicDataset = "CouchbaseTable"
	// TypeCustomDataset ...
	TypeCustomDataset TypeBasicDataset = "CustomDataset"
	// TypeDataset ...
	TypeDataset TypeBasicDataset = "Dataset"
	// TypeDocumentDbCollection ...
	TypeDocumentDbCollection TypeBasicDataset = "DocumentDbCollection"
	// TypeDrillTable ...
	TypeDrillTable TypeBasicDataset = "DrillTable"
	// TypeDynamicsEntity ...
	TypeDynamicsEntity TypeBasicDataset = "DynamicsEntity"
	// TypeEloquaObject ...
	TypeEloquaObject TypeBasicDataset = "EloquaObject"
	// TypeFileShare ...
	TypeFileShare TypeBasicDataset = "FileShare"
	// TypeGoogleBigQueryObject ...
	TypeGoogleBigQueryObject TypeBasicDataset = "GoogleBigQueryObject"
	// TypeGreenplumTable ...
	TypeGreenplumTable TypeBasicDataset = "GreenplumTable"
	// TypeHBaseObject ...
	TypeHBaseObject TypeBasicDataset = "HBaseObject"
	// TypeHiveObject ...
	TypeHiveObject TypeBasicDataset = "HiveObject"
	// TypeHTTPFile ...
	TypeHTTPFile TypeBasicDataset = "HttpFile"
	// TypeHubspotObject ...
	TypeHubspotObject TypeBasicDataset = "HubspotObject"
	// TypeImpalaObject ...
	TypeImpalaObject TypeBasicDataset = "ImpalaObject"
	// TypeJiraObject ...
	TypeJiraObject TypeBasicDataset = "JiraObject"
	// TypeMagentoObject ...
	TypeMagentoObject TypeBasicDataset = "MagentoObject"
	// TypeMariaDBTable ...
	TypeMariaDBTable TypeBasicDataset = "MariaDBTable"
	// TypeMarketoObject ...
	TypeMarketoObject TypeBasicDataset = "MarketoObject"
	// TypeMongoDbCollection ...
	TypeMongoDbCollection TypeBasicDataset = "MongoDbCollection"
	// TypeODataResource ...
	TypeODataResource TypeBasicDataset = "ODataResource"
	// TypeOracleTable ...
	TypeOracleTable TypeBasicDataset = "OracleTable"
	// TypePaypalObject ...
	TypePaypalObject TypeBasicDataset = "PaypalObject"
	// TypePhoenixObject ...
	TypePhoenixObject TypeBasicDataset = "PhoenixObject"
	// TypePrestoObject ...
	TypePrestoObject TypeBasicDataset = "PrestoObject"
	// TypeQuickBooksObject ...
	TypeQuickBooksObject TypeBasicDataset = "QuickBooksObject"
	// TypeRelationalTable ...
	TypeRelationalTable TypeBasicDataset = "RelationalTable"
	// TypeSalesforceObject ...
	TypeSalesforceObject TypeBasicDataset = "SalesforceObject"
	// TypeSapCloudForCustomerResource ...
	TypeSapCloudForCustomerResource TypeBasicDataset = "SapCloudForCustomerResource"
	// TypeServiceNowObject ...
	TypeServiceNowObject TypeBasicDataset = "ServiceNowObject"
	// TypeShopifyObject ...
	TypeShopifyObject TypeBasicDataset = "ShopifyObject"
	// TypeSparkObject ...
	TypeSparkObject TypeBasicDataset = "SparkObject"
	// TypeSQLServerTable ...
	TypeSQLServerTable TypeBasicDataset = "SqlServerTable"
	// TypeSquareObject ...
	TypeSquareObject TypeBasicDataset = "SquareObject"
	// TypeWebTable ...
	TypeWebTable TypeBasicDataset = "WebTable"
	// TypeXeroObject ...
	TypeXeroObject TypeBasicDataset = "XeroObject"
	// TypeZohoObject ...
	TypeZohoObject TypeBasicDataset = "ZohoObject"
)

// TypeBasicDatasetCompression enumerates the values for type basic dataset compression.
type TypeBasicDatasetCompression string

const (
	// TypeBZip2 ...
	TypeBZip2 TypeBasicDatasetCompression = "BZip2"
	// TypeDatasetCompression ...
	TypeDatasetCompression TypeBasicDatasetCompression = "DatasetCompression"
	// TypeDeflate ...
	TypeDeflate TypeBasicDatasetCompression = "Deflate"
	// TypeGZip ...
	TypeGZip TypeBasicDatasetCompression = "GZip"
	// TypeZipDeflate ...
	TypeZipDeflate TypeBasicDatasetCompression = "ZipDeflate"
)

// TypeBasicDatasetStorageFormat enumerates the values for type basic dataset storage format.
type TypeBasicDatasetStorageFormat string

const (
	// TypeAvroFormat ...
	TypeAvroFormat TypeBasicDatasetStorageFormat = "AvroFormat"
	// TypeDatasetStorageFormat ...
	TypeDatasetStorageFormat TypeBasicDatasetStorageFormat = "DatasetStorageFormat"
	// TypeJSONFormat ...
	TypeJSONFormat TypeBasicDatasetStorageFormat = "JsonFormat"
	// TypeOrcFormat ...
	TypeOrcFormat TypeBasicDatasetStorageFormat = "OrcFormat"
	// TypeParquetFormat ...
	TypeParquetFormat TypeBasicDatasetStorageFormat = "ParquetFormat"
	// TypeTextFormat ...
	TypeTextFormat TypeBasicDatasetStorageFormat = "TextFormat"
)

// TypeBasicIntegrationRuntime enumerates the values for type basic integration runtime.
type TypeBasicIntegrationRuntime string

const (
	// TypeIntegrationRuntime ...
	TypeIntegrationRuntime TypeBasicIntegrationRuntime = "IntegrationRuntime"
	// TypeManaged ...
	TypeManaged TypeBasicIntegrationRuntime = "Managed"
	// TypeSelfHosted ...
	TypeSelfHosted TypeBasicIntegrationRuntime = "SelfHosted"
)

// TypeBasicIntegrationRuntimeStatus enumerates the values for type basic integration runtime status.
type TypeBasicIntegrationRuntimeStatus string

const (
	// TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus ...
	TypeBasicIntegrationRuntimeStatusTypeIntegrationRuntimeStatus TypeBasicIntegrationRuntimeStatus = "IntegrationRuntimeStatus"
	// TypeBasicIntegrationRuntimeStatusTypeManaged ...
	TypeBasicIntegrationRuntimeStatusTypeManaged TypeBasicIntegrationRuntimeStatus = "Managed"
	// TypeBasicIntegrationRuntimeStatusTypeSelfHosted ...
	TypeBasicIntegrationRuntimeStatusTypeSelfHosted TypeBasicIntegrationRuntimeStatus = "SelfHosted"
)

// TypeBasicLinkedService enumerates the values for type basic linked service.
type TypeBasicLinkedService string

const (
	// TypeAmazonMWS ...
	TypeAmazonMWS TypeBasicLinkedService = "AmazonMWS"
	// TypeAmazonRedshift ...
	TypeAmazonRedshift TypeBasicLinkedService = "AmazonRedshift"
	// TypeAmazonS3 ...
	TypeAmazonS3 TypeBasicLinkedService = "AmazonS3"
	// TypeAzureBatch ...
	TypeAzureBatch TypeBasicLinkedService = "AzureBatch"
	// TypeAzureDataLakeAnalytics ...
	TypeAzureDataLakeAnalytics TypeBasicLinkedService = "AzureDataLakeAnalytics"
	// TypeAzureDataLakeStore ...
	TypeAzureDataLakeStore TypeBasicLinkedService = "AzureDataLakeStore"
	// TypeAzureKeyVault ...
	TypeAzureKeyVault TypeBasicLinkedService = "AzureKeyVault"
	// TypeAzureML ...
	TypeAzureML TypeBasicLinkedService = "AzureML"
	// TypeAzureMySQL ...
	TypeAzureMySQL TypeBasicLinkedService = "AzureMySql"
	// TypeAzurePostgreSQL ...
	TypeAzurePostgreSQL TypeBasicLinkedService = "AzurePostgreSql"
	// TypeAzureSearch ...
	TypeAzureSearch TypeBasicLinkedService = "AzureSearch"
	// TypeAzureSQLDatabase ...
	TypeAzureSQLDatabase TypeBasicLinkedService = "AzureSqlDatabase"
	// TypeAzureSQLDW ...
	TypeAzureSQLDW TypeBasicLinkedService = "AzureSqlDW"
	// TypeAzureStorage ...
	TypeAzureStorage TypeBasicLinkedService = "AzureStorage"
	// TypeCassandra ...
	TypeCassandra TypeBasicLinkedService = "Cassandra"
	// TypeConcur ...
	TypeConcur TypeBasicLinkedService = "Concur"
	// TypeCosmosDb ...
	TypeCosmosDb TypeBasicLinkedService = "CosmosDb"
	// TypeCouchbase ...
	TypeCouchbase TypeBasicLinkedService = "Couchbase"
	// TypeCustomDataSource ...
	TypeCustomDataSource TypeBasicLinkedService = "CustomDataSource"
	// TypeDb2 ...
	TypeDb2 TypeBasicLinkedService = "Db2"
	// TypeDrill ...
	TypeDrill TypeBasicLinkedService = "Drill"
	// TypeDynamics ...
	TypeDynamics TypeBasicLinkedService = "Dynamics"
	// TypeEloqua ...
	TypeEloqua TypeBasicLinkedService = "Eloqua"
	// TypeFileServer ...
	TypeFileServer TypeBasicLinkedService = "FileServer"
	// TypeFtpServer ...
	TypeFtpServer TypeBasicLinkedService = "FtpServer"
	// TypeGoogleBigQuery ...
	TypeGoogleBigQuery TypeBasicLinkedService = "GoogleBigQuery"
	// TypeGreenplum ...
	TypeGreenplum TypeBasicLinkedService = "Greenplum"
	// TypeHBase ...
	TypeHBase TypeBasicLinkedService = "HBase"
	// TypeHdfs ...
	TypeHdfs TypeBasicLinkedService = "Hdfs"
	// TypeHDInsight ...
	TypeHDInsight TypeBasicLinkedService = "HDInsight"
	// TypeHDInsightOnDemand ...
	TypeHDInsightOnDemand TypeBasicLinkedService = "HDInsightOnDemand"
	// TypeHive ...
	TypeHive TypeBasicLinkedService = "Hive"
	// TypeHTTPServer ...
	TypeHTTPServer TypeBasicLinkedService = "HttpServer"
	// TypeHubspot ...
	TypeHubspot TypeBasicLinkedService = "Hubspot"
	// TypeImpala ...
	TypeImpala TypeBasicLinkedService = "Impala"
	// TypeJira ...
	TypeJira TypeBasicLinkedService = "Jira"
	// TypeLinkedService ...
	TypeLinkedService TypeBasicLinkedService = "LinkedService"
	// TypeMagento ...
	TypeMagento TypeBasicLinkedService = "Magento"
	// TypeMariaDB ...
	TypeMariaDB TypeBasicLinkedService = "MariaDB"
	// TypeMarketo ...
	TypeMarketo TypeBasicLinkedService = "Marketo"
	// TypeMongoDb ...
	TypeMongoDb TypeBasicLinkedService = "MongoDb"
	// TypeMySQL ...
	TypeMySQL TypeBasicLinkedService = "MySql"
	// TypeOData ...
	TypeOData TypeBasicLinkedService = "OData"
	// TypeOdbc ...
	TypeOdbc TypeBasicLinkedService = "Odbc"
	// TypeOracle ...
	TypeOracle TypeBasicLinkedService = "Oracle"
	// TypePaypal ...
	TypePaypal TypeBasicLinkedService = "Paypal"
	// TypePhoenix ...
	TypePhoenix TypeBasicLinkedService = "Phoenix"
	// TypePostgreSQL ...
	TypePostgreSQL TypeBasicLinkedService = "PostgreSql"
	// TypePresto ...
	TypePresto TypeBasicLinkedService = "Presto"
	// TypeQuickBooks ...
	TypeQuickBooks TypeBasicLinkedService = "QuickBooks"
	// TypeSalesforce ...
	TypeSalesforce TypeBasicLinkedService = "Salesforce"
	// TypeSapBW ...
	TypeSapBW TypeBasicLinkedService = "SapBW"
	// TypeSapCloudForCustomer ...
	TypeSapCloudForCustomer TypeBasicLinkedService = "SapCloudForCustomer"
	// TypeSapHana ...
	TypeSapHana TypeBasicLinkedService = "SapHana"
	// TypeServiceNow ...
	TypeServiceNow TypeBasicLinkedService = "ServiceNow"
	// TypeSftp ...
	TypeSftp TypeBasicLinkedService = "Sftp"
	// TypeShopify ...
	TypeShopify TypeBasicLinkedService = "Shopify"
	// TypeSpark ...
	TypeSpark TypeBasicLinkedService = "Spark"
	// TypeSQLServer ...
	TypeSQLServer TypeBasicLinkedService = "SqlServer"
	// TypeSquare ...
	TypeSquare TypeBasicLinkedService = "Square"
	// TypeSybase ...
	TypeSybase TypeBasicLinkedService = "Sybase"
	// TypeTeradata ...
	TypeTeradata TypeBasicLinkedService = "Teradata"
	// TypeWeb ...
	TypeWeb TypeBasicLinkedService = "Web"
	// TypeXero ...
	TypeXero TypeBasicLinkedService = "Xero"
	// TypeZoho ...
	TypeZoho TypeBasicLinkedService = "Zoho"
)

// TypeBasicTrigger enumerates the values for type basic trigger.
type TypeBasicTrigger string

const (
	// TypeBlobTrigger ...
	TypeBlobTrigger TypeBasicTrigger = "BlobTrigger"
	// TypeMultiplePipelineTrigger ...
	TypeMultiplePipelineTrigger TypeBasicTrigger = "MultiplePipelineTrigger"
	// TypeScheduleTrigger ...
	TypeScheduleTrigger TypeBasicTrigger = "ScheduleTrigger"
	// TypeTrigger ...
	TypeTrigger TypeBasicTrigger = "Trigger"
	// TypeTumblingWindowTrigger ...
	TypeTumblingWindowTrigger TypeBasicTrigger = "TumblingWindowTrigger"
)

// WebActivityMethod enumerates the values for web activity method.
type WebActivityMethod string

const (
	// GET ...
	GET WebActivityMethod = "GET"
	// POST ...
	POST WebActivityMethod = "POST"
	// PUT ...
	PUT WebActivityMethod = "PUT"
)

// BasicActivity a pipeline activity.
type BasicActivity interface {
	AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool)
	AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool)
	AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool)
	AsGetMetadataActivity() (*GetMetadataActivity, bool)
	AsWebActivity() (*WebActivity, bool)
	AsLookupActivity() (*LookupActivity, bool)
	AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool)
	AsCustomActivity() (*CustomActivity, bool)
	AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool)
	AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool)
	AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool)
	AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool)
	AsHDInsightPigActivity() (*HDInsightPigActivity, bool)
	AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool)
	AsCopyActivity() (*CopyActivity, bool)
	AsExecutionActivity() (*ExecutionActivity, bool)
	AsBasicExecutionActivity() (BasicExecutionActivity, bool)
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
	AsBasicControlActivity() (BasicControlActivity, bool)
	AsActivity() (*Activity, bool)
}

// Activity a pipeline activity.
type Activity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicActivity(body []byte) (BasicActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDataLakeAnalyticsUSQL):
		var dlaua DataLakeAnalyticsUSQLActivity
		err := json.Unmarshal(body, &dlaua)
		return dlaua, err
	case string(TypeAzureMLUpdateResource):
		var amura AzureMLUpdateResourceActivity
		err := json.Unmarshal(body, &amura)
		return amura, err
	case string(TypeAzureMLBatchExecution):
		var ambea AzureMLBatchExecutionActivity
		err := json.Unmarshal(body, &ambea)
		return ambea, err
	case string(TypeGetMetadata):
		var gma GetMetadataActivity
		err := json.Unmarshal(body, &gma)
		return gma, err
	case string(TypeWebActivity):
		var wa WebActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeLookup):
		var la LookupActivity
		err := json.Unmarshal(body, &la)
		return la, err
	case string(TypeSQLServerStoredProcedure):
		var ssspa SQLServerStoredProcedureActivity
		err := json.Unmarshal(body, &ssspa)
		return ssspa, err
	case string(TypeCustom):
		var ca CustomActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecuteSSISPackage):
		var espa ExecuteSSISPackageActivity
		err := json.Unmarshal(body, &espa)
		return espa, err
	case string(TypeHDInsightSpark):
		var hisa HDInsightSparkActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightStreaming):
		var hisa HDInsightStreamingActivity
		err := json.Unmarshal(body, &hisa)
		return hisa, err
	case string(TypeHDInsightMapReduce):
		var himra HDInsightMapReduceActivity
		err := json.Unmarshal(body, &himra)
		return himra, err
	case string(TypeHDInsightPig):
		var hipa HDInsightPigActivity
		err := json.Unmarshal(body, &hipa)
		return hipa, err
	case string(TypeHDInsightHive):
		var hiha HDInsightHiveActivity
		err := json.Unmarshal(body, &hiha)
		return hiha, err
	case string(TypeCopy):
		var ca CopyActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(TypeExecution):
		var ea ExecutionActivity
		err := json.Unmarshal(body, &ea)
		return ea, err
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	case string(TypeContainer):
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	default:
		var a Activity
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActivityArray(body []byte) ([]BasicActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	a.Type = TypeActivity
	type Alias Activity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for Activity.
func (a Activity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for Activity.
func (a Activity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for Activity.
func (a Activity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for Activity.
func (a Activity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for Activity.
func (a Activity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for Activity.
func (a Activity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for Activity.
func (a Activity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for Activity.
func (a Activity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for Activity.
func (a Activity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for Activity.
func (a Activity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for Activity.
func (a Activity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for Activity.
func (a Activity) AsActivity() (*Activity, bool) {
	return &a, true
}

// AsBasicActivity is the BasicActivity implementation for Activity.
func (a Activity) AsBasicActivity() (BasicActivity, bool) {
	return &a, true
}

// ActivityDependency activity dependency information.
type ActivityDependency struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Activity - Activity name.
	Activity *string `json:"activity,omitempty"`
	// DependencyConditions - Match-Condition for the dependency.
	DependencyConditions *[]DependencyCondition `json:"dependencyConditions,omitempty"`
}

// ActivityPolicy execution policy for an activity.
type ActivityPolicy struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Timeout - Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout *map[string]interface{} `json:"timeout,omitempty"`
	// Retry - Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry *map[string]interface{} `json:"retry,omitempty"`
	// RetryIntervalInSeconds - Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`
}

// ActivityRun information about an activity run in a pipeline.
type ActivityRun struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// PipelineName - The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty"`
	// PipelineRunID - The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty"`
	// ActivityName - The name of the activity.
	ActivityName *string `json:"activityName,omitempty"`
	// ActivityType - The type of the activity.
	ActivityType *string `json:"activityType,omitempty"`
	// ActivityRunID - The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty"`
	// LinkedServiceName - The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty"`
	// Status - The status of the activity run.
	Status *string `json:"status,omitempty"`
	// ActivityRunStart - The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *date.Time `json:"activityRunStart,omitempty"`
	// ActivityRunEnd - The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *date.Time `json:"activityRunEnd,omitempty"`
	// DurationInMs - The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty"`
	// Input - The input for the activity.
	Input *map[string]interface{} `json:"input,omitempty"`
	// Output - The output for the activity.
	Output *map[string]interface{} `json:"output,omitempty"`
	// Error - The error if any from the activity run.
	Error *map[string]interface{} `json:"error,omitempty"`
}

// ActivityRunsListResponse a list activity runs.
type ActivityRunsListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of activity runs.
	Value *[]ActivityRun `json:"value,omitempty"`
	// NextLink - The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// ActivityRunsListResponseIterator provides access to a complete listing of ActivityRun values.
type ActivityRunsListResponseIterator struct {
	i    int
	page ActivityRunsListResponsePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ActivityRunsListResponseIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ActivityRunsListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ActivityRunsListResponseIterator) Response() ActivityRunsListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ActivityRunsListResponseIterator) Value() ActivityRun {
	if !iter.page.NotDone() {
		return ActivityRun{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (arlr ActivityRunsListResponse) IsEmpty() bool {
	return arlr.Value == nil || len(*arlr.Value) == 0
}

// activityRunsListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (arlr ActivityRunsListResponse) activityRunsListResponsePreparer() (*http.Request, error) {
	if arlr.NextLink == nil || len(to.String(arlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(arlr.NextLink)))
}

// ActivityRunsListResponsePage contains a page of ActivityRun values.
type ActivityRunsListResponsePage struct {
	fn   func(ActivityRunsListResponse) (ActivityRunsListResponse, error)
	arlr ActivityRunsListResponse
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ActivityRunsListResponsePage) Next() error {
	next, err := page.fn(page.arlr)
	if err != nil {
		return err
	}
	page.arlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ActivityRunsListResponsePage) NotDone() bool {
	return !page.arlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ActivityRunsListResponsePage) Response() ActivityRunsListResponse {
	return page.arlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ActivityRunsListResponsePage) Values() []ActivityRun {
	if page.arlr.IsEmpty() {
		return nil
	}
	return *page.arlr.Value
}

// AmazonMWSLinkedService amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
	*AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAmazonMWS
	type Alias AmazonMWSLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return &amls, true
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonMWSLinkedService.
func (amls AmazonMWSLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedService struct.
func (amls *AmazonMWSLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AmazonMWSLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		amls.AmazonMWSLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		amls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		amls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		amls.Type = typeVar
	}

	return nil
}

// AmazonMWSLinkedServiceTypeProperties amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// Endpoint - The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint *map[string]interface{} `json:"endpoint,omitempty"`
	// MarketplaceID - The Amazon Marketplace ID you want to retrieve data from. To retrive data from multiple Marketplace IDs, seperate them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID *map[string]interface{} `json:"marketplaceID,omitempty"`
	// SellerID - The Amazon seller ID.
	SellerID *map[string]interface{} `json:"sellerID,omitempty"`
	// MwsAuthToken - The Amazon MWS authentication token.
	MwsAuthToken BasicSecretBase `json:"mwsAuthToken,omitempty"`
	// AccessKeyID - The access key id used to access data.
	AccessKeyID *map[string]interface{} `json:"accessKeyId,omitempty"`
	// SecretKey - The secret key used to access data.
	SecretKey BasicSecretBase `json:"secretKey,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints *map[string]interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification *map[string]interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification *map[string]interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonMWSLinkedServiceTypeProperties struct.
func (amlstp *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["endpoint"]
	if v != nil {
		var endpoint map[string]interface{}
		err = json.Unmarshal(*m["endpoint"], &endpoint)
		if err != nil {
			return err
		}
		amlstp.Endpoint = &endpoint
	}

	v = m["marketplaceID"]
	if v != nil {
		var marketplaceID map[string]interface{}
		err = json.Unmarshal(*m["marketplaceID"], &marketplaceID)
		if err != nil {
			return err
		}
		amlstp.MarketplaceID = &marketplaceID
	}

	v = m["sellerID"]
	if v != nil {
		var sellerID map[string]interface{}
		err = json.Unmarshal(*m["sellerID"], &sellerID)
		if err != nil {
			return err
		}
		amlstp.SellerID = &sellerID
	}

	v = m["mwsAuthToken"]
	if v != nil {
		mwsAuthToken, err := unmarshalBasicSecretBase(*m["mwsAuthToken"])
		if err != nil {
			return err
		}
		amlstp.MwsAuthToken = mwsAuthToken
	}

	v = m["accessKeyId"]
	if v != nil {
		var accessKeyID map[string]interface{}
		err = json.Unmarshal(*m["accessKeyId"], &accessKeyID)
		if err != nil {
			return err
		}
		amlstp.AccessKeyID = &accessKeyID
	}

	v = m["secretKey"]
	if v != nil {
		secretKey, err := unmarshalBasicSecretBase(*m["secretKey"])
		if err != nil {
			return err
		}
		amlstp.SecretKey = secretKey
	}

	v = m["useEncryptedEndpoints"]
	if v != nil {
		var useEncryptedEndpoints map[string]interface{}
		err = json.Unmarshal(*m["useEncryptedEndpoints"], &useEncryptedEndpoints)
		if err != nil {
			return err
		}
		amlstp.UseEncryptedEndpoints = &useEncryptedEndpoints
	}

	v = m["useHostVerification"]
	if v != nil {
		var useHostVerification map[string]interface{}
		err = json.Unmarshal(*m["useHostVerification"], &useHostVerification)
		if err != nil {
			return err
		}
		amlstp.UseHostVerification = &useHostVerification
	}

	v = m["usePeerVerification"]
	if v != nil {
		var usePeerVerification map[string]interface{}
		err = json.Unmarshal(*m["usePeerVerification"], &usePeerVerification)
		if err != nil {
			return err
		}
		amlstp.UsePeerVerification = &usePeerVerification
	}

	v = m["encryptedCredential"]
	if v != nil {
		var encryptedCredential map[string]interface{}
		err = json.Unmarshal(*m["encryptedCredential"], &encryptedCredential)
		if err != nil {
			return err
		}
		amlstp.EncryptedCredential = &encryptedCredential
	}

	return nil
}

// AmazonMWSObjectDataset amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	amod.Type = TypeAmazonMWSObject
	type Alias AmazonMWSObjectDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amod),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return &amod, true
}

// AsHTTPDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonMWSObjectDataset.
func (amod AmazonMWSObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amod, true
}

// AmazonMWSSource a copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonMWSSource.
func (ams AmazonMWSSource) MarshalJSON() ([]byte, error) {
	ams.Type = TypeAmazonMWSSource
	type Alias AmazonMWSSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ams),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return &ams, true
}

// AsHTTPSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonMWSSource.
func (ams AmazonMWSSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ams, true
}

// AmazonRedshiftLinkedService linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
	*AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	arls.Type = TypeAmazonRedshift
	type Alias AmazonRedshiftLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(arls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return &arls, true
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonRedshiftLinkedService.
func (arls AmazonRedshiftLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &arls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonRedshiftLinkedService struct.
func (arls *AmazonRedshiftLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AmazonRedshiftLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		arls.AmazonRedshiftLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		arls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		arls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		arls.Type = typeVar
	}

	return nil
}

// AmazonRedshiftLinkedServiceTypeProperties amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// Server - The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server *map[string]interface{} `json:"server,omitempty"`
	// Username - The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username *map[string]interface{} `json:"username,omitempty"`
	// Password - The password of the Amazon Redshift source.
	Password *SecureString `json:"password,omitempty"`
	// Database - The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database *map[string]interface{} `json:"database,omitempty"`
	// Port - The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type: integer (or Expression with resultType integer).
	Port *map[string]interface{} `json:"port,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AmazonRedshiftSource a copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - Database query. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
	// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	ars.Type = TypeAmazonRedshiftSource
	type Alias AmazonRedshiftSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ars),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return &ars, true
}

// AsZohoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AmazonRedshiftSource.
func (ars AmazonRedshiftSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ars, true
}

// AmazonS3Dataset a single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
	*AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3Dataset.
func (asd AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	asd.Type = TypeAmazonS3Object
	type Alias AmazonS3Dataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return &asd, true
}

// AsDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AmazonS3Dataset.
func (asd AmazonS3Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &asd, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3Dataset struct.
func (asd *AmazonS3Dataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AmazonS3DatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asd.AmazonS3DatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		asd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		asd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		asd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asd.Type = typeVar
	}

	return nil
}

// AmazonS3DatasetTypeProperties amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// BucketName - The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName *map[string]interface{} `json:"bucketName,omitempty"`
	// Key - The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key *map[string]interface{} `json:"key,omitempty"`
	// Prefix - The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix *map[string]interface{} `json:"prefix,omitempty"`
	// Version - The version for the S3 object. Type: string (or Expression with resultType string).
	Version *map[string]interface{} `json:"version,omitempty"`
	// Format - The format of files.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the Amazon S3 object.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3DatasetTypeProperties struct.
func (asdtp *AmazonS3DatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["bucketName"]
	if v != nil {
		var bucketName map[string]interface{}
		err = json.Unmarshal(*m["bucketName"], &bucketName)
		if err != nil {
			return err
		}
		asdtp.BucketName = &bucketName
	}

	v = m["key"]
	if v != nil {
		var key map[string]interface{}
		err = json.Unmarshal(*m["key"], &key)
		if err != nil {
			return err
		}
		asdtp.Key = &key
	}

	v = m["prefix"]
	if v != nil {
		var prefix map[string]interface{}
		err = json.Unmarshal(*m["prefix"], &prefix)
		if err != nil {
			return err
		}
		asdtp.Prefix = &prefix
	}

	v = m["version"]
	if v != nil {
		var version map[string]interface{}
		err = json.Unmarshal(*m["version"], &version)
		if err != nil {
			return err
		}
		asdtp.Version = &version
	}

	v = m["format"]
	if v != nil {
		formatVar, err := unmarshalBasicDatasetStorageFormat(*m["format"])
		if err != nil {
			return err
		}
		asdtp.Format = formatVar
	}

	v = m["compression"]
	if v != nil {
		compression, err := unmarshalBasicDatasetCompression(*m["compression"])
		if err != nil {
			return err
		}
		asdtp.Compression = compression
	}

	return nil
}

// AmazonS3LinkedService linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
	*AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAmazonS3
	type Alias AmazonS3LinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return &asls, true
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AmazonS3LinkedService.
func (asls AmazonS3LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AmazonS3LinkedService struct.
func (asls *AmazonS3LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AmazonS3LinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asls.AmazonS3LinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		asls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asls.Type = typeVar
	}

	return nil
}

// AmazonS3LinkedServiceTypeProperties amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// AccessKeyID - The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
	AccessKeyID *map[string]interface{} `json:"accessKeyId,omitempty"`
	// SecretAccessKey - The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey *SecureString `json:"secretAccessKey,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AvroFormat the data stored in Avro format.
type AvroFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer *map[string]interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer *map[string]interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeDatasetStorageFormat', 'TypeParquetFormat', 'TypeOrcFormat', 'TypeAvroFormat', 'TypeJSONFormat', 'TypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroFormat.
func (af AvroFormat) MarshalJSON() ([]byte, error) {
	af.Type = TypeAvroFormat
	type Alias AvroFormat
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(af),
	})
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsAvroFormat() (*AvroFormat, bool) {
	return &af, true
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return nil, false
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for AvroFormat.
func (af AvroFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &af, true
}

// AzureBatchLinkedService azure Batch linked service.
type AzureBatchLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
	*AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	abls.Type = TypeAzureBatch
	type Alias AzureBatchLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(abls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return &abls, true
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureBatchLinkedService.
func (abls AzureBatchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &abls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBatchLinkedService struct.
func (abls *AzureBatchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureBatchLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		abls.AzureBatchLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		abls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		abls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		abls.Type = typeVar
	}

	return nil
}

// AzureBatchLinkedServiceTypeProperties azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// AccountName - The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName *map[string]interface{} `json:"accountName,omitempty"`
	// AccessKey - The Azure Batch account access key.
	AccessKey *SecureString `json:"accessKey,omitempty"`
	// BatchURI - The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI *map[string]interface{} `json:"batchUri,omitempty"`
	// PoolName - The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName *map[string]interface{} `json:"poolName,omitempty"`
	// LinkedServiceName - The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureBlobDataset the Azure Blob storage.
type AzureBlobDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
	*AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBlobDataset.
func (abd AzureBlobDataset) MarshalJSON() ([]byte, error) {
	abd.Type = TypeAzureBlob
	type Alias AzureBlobDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(abd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return &abd, true
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureBlobDataset.
func (abd AzureBlobDataset) AsBasicDataset() (BasicDataset, bool) {
	return &abd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDataset struct.
func (abd *AzureBlobDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureBlobDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		abd.AzureBlobDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		abd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		abd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		abd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		abd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		abd.Type = typeVar
	}

	return nil
}

// AzureBlobDatasetTypeProperties azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// FolderPath - The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath *map[string]interface{} `json:"folderPath,omitempty"`
	// TableRootLocation - The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation *map[string]interface{} `json:"tableRootLocation,omitempty"`
	// FileName - The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName *map[string]interface{} `json:"fileName,omitempty"`
	// Format - The format of the Azure Blob storage.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the blob storage.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureBlobDatasetTypeProperties struct.
func (abdtp *AzureBlobDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["folderPath"]
	if v != nil {
		var folderPath map[string]interface{}
		err = json.Unmarshal(*m["folderPath"], &folderPath)
		if err != nil {
			return err
		}
		abdtp.FolderPath = &folderPath
	}

	v = m["tableRootLocation"]
	if v != nil {
		var tableRootLocation map[string]interface{}
		err = json.Unmarshal(*m["tableRootLocation"], &tableRootLocation)
		if err != nil {
			return err
		}
		abdtp.TableRootLocation = &tableRootLocation
	}

	v = m["fileName"]
	if v != nil {
		var fileName map[string]interface{}
		err = json.Unmarshal(*m["fileName"], &fileName)
		if err != nil {
			return err
		}
		abdtp.FileName = &fileName
	}

	v = m["format"]
	if v != nil {
		formatVar, err := unmarshalBasicDatasetStorageFormat(*m["format"])
		if err != nil {
			return err
		}
		abdtp.Format = formatVar
	}

	v = m["compression"]
	if v != nil {
		compression, err := unmarshalBasicDatasetCompression(*m["compression"])
		if err != nil {
			return err
		}
		abdtp.Compression = compression
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedService azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
	*AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	adlals.Type = TypeAzureDataLakeAnalytics
	type Alias AzureDataLakeAnalyticsLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlals),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return &adlals, true
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeAnalyticsLinkedService.
func (adlals AzureDataLakeAnalyticsLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlals, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeAnalyticsLinkedService struct.
func (adlals *AzureDataLakeAnalyticsLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureDataLakeAnalyticsLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		adlals.AzureDataLakeAnalyticsLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		adlals.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		adlals.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		adlals.Type = typeVar
	}

	return nil
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// AccountName - The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName *map[string]interface{} `json:"accountName,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression with resultType string).
	ServicePrincipalID *map[string]interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey *SecureString `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant *map[string]interface{} `json:"tenant,omitempty"`
	// SubscriptionID - Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID *map[string]interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName *map[string]interface{} `json:"resourceGroupName,omitempty"`
	// DataLakeAnalyticsURI - Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI *map[string]interface{} `json:"dataLakeAnalyticsUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureDataLakeStoreDataset azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
	*AzureDataLakeStoreDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) MarshalJSON() ([]byte, error) {
	adlsd.Type = TypeAzureDataLakeStoreFile
	type Alias AzureDataLakeStoreDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlsd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return &adlsd, true
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureDataLakeStoreDataset.
func (adlsd AzureDataLakeStoreDataset) AsBasicDataset() (BasicDataset, bool) {
	return &adlsd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDataset struct.
func (adlsd *AzureDataLakeStoreDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureDataLakeStoreDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		adlsd.AzureDataLakeStoreDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		adlsd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		adlsd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		adlsd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		adlsd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		adlsd.Type = typeVar
	}

	return nil
}

// AzureDataLakeStoreDatasetTypeProperties azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// FolderPath - Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath *map[string]interface{} `json:"folderPath,omitempty"`
	// FileName - The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName *map[string]interface{} `json:"fileName,omitempty"`
	// Format - The format of the Data Lake Store.
	Format BasicDatasetStorageFormat `json:"format,omitempty"`
	// Compression - The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression BasicDatasetCompression `json:"compression,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreDatasetTypeProperties struct.
func (adlsdtp *AzureDataLakeStoreDatasetTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["folderPath"]
	if v != nil {
		var folderPath map[string]interface{}
		err = json.Unmarshal(*m["folderPath"], &folderPath)
		if err != nil {
			return err
		}
		adlsdtp.FolderPath = &folderPath
	}

	v = m["fileName"]
	if v != nil {
		var fileName map[string]interface{}
		err = json.Unmarshal(*m["fileName"], &fileName)
		if err != nil {
			return err
		}
		adlsdtp.FileName = &fileName
	}

	v = m["format"]
	if v != nil {
		formatVar, err := unmarshalBasicDatasetStorageFormat(*m["format"])
		if err != nil {
			return err
		}
		adlsdtp.Format = formatVar
	}

	v = m["compression"]
	if v != nil {
		compression, err := unmarshalBasicDatasetCompression(*m["compression"])
		if err != nil {
			return err
		}
		adlsdtp.Compression = compression
	}

	return nil
}

// AzureDataLakeStoreLinkedService azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
	*AzureDataLakeStoreLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) MarshalJSON() ([]byte, error) {
	adlsls.Type = TypeAzureDataLakeStore
	type Alias AzureDataLakeStoreLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlsls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return &adlsls, true
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureDataLakeStoreLinkedService.
func (adlsls AzureDataLakeStoreLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &adlsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureDataLakeStoreLinkedService struct.
func (adlsls *AzureDataLakeStoreLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureDataLakeStoreLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		adlsls.AzureDataLakeStoreLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		adlsls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		adlsls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		adlsls.Type = typeVar
	}

	return nil
}

// AzureDataLakeStoreLinkedServiceTypeProperties azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// DataLakeStoreURI - Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI *map[string]interface{} `json:"dataLakeStoreUri,omitempty"`
	// ServicePrincipalID - The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with resultType string).
	ServicePrincipalID *map[string]interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey *SecureString `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant *map[string]interface{} `json:"tenant,omitempty"`
	// AccountName - Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName *map[string]interface{} `json:"accountName,omitempty"`
	// SubscriptionID - Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType string).
	SubscriptionID *map[string]interface{} `json:"subscriptionId,omitempty"`
	// ResourceGroupName - Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with resultType string).
	ResourceGroupName *map[string]interface{} `json:"resourceGroupName,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureDataLakeStoreSink a copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink. Possible values include: 'PreserveHierarchy', 'FlattenHierarchy', 'MergeFiles'
	CopyBehavior CopyBehaviorType `json:"copyBehavior,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSink
	type Alias AzureDataLakeStoreSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlss),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return &adlss, true
}

// AsOracleSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureDataLakeStoreSink.
func (adlss AzureDataLakeStoreSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &adlss, true
}

// AzureDataLakeStoreSource a copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive *map[string]interface{} `json:"recursive,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) MarshalJSON() ([]byte, error) {
	adlss.Type = TypeAzureDataLakeStoreSource
	type Alias AzureDataLakeStoreSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlss),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return &adlss, true
}

// AsMongoDbSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureDataLakeStoreSource.
func (adlss AzureDataLakeStoreSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &adlss, true
}

// AzureKeyVaultLinkedService azure Key Vault linked service.
type AzureKeyVaultLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureKeyVaultLinkedServiceTypeProperties - Azure Key Vault linked service properties.
	*AzureKeyVaultLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) MarshalJSON() ([]byte, error) {
	akvls.Type = TypeAzureKeyVault
	type Alias AzureKeyVaultLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(akvls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return &akvls, true
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureKeyVaultLinkedService.
func (akvls AzureKeyVaultLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &akvls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureKeyVaultLinkedService struct.
func (akvls *AzureKeyVaultLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureKeyVaultLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		akvls.AzureKeyVaultLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		akvls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		akvls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		akvls.Type = typeVar
	}

	return nil
}

// AzureKeyVaultLinkedServiceTypeProperties azure Key Vault linked service properties.
type AzureKeyVaultLinkedServiceTypeProperties struct {
	// BaseURL - The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType string).
	BaseURL *map[string]interface{} `json:"baseUrl,omitempty"`
}

// AzureKeyVaultSecretReference azure Key Vault secret reference.
type AzureKeyVaultSecretReference struct {
	// Type - Possible values include: 'TypeSecretBase', 'TypeSecureString', 'TypeAzureKeyVaultSecret'
	Type Type `json:"type,omitempty"`
	// Store - The Azure Key Vault linked service reference.
	Store *LinkedServiceReference `json:"store,omitempty"`
	// SecretName - The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
	SecretName *map[string]interface{} `json:"secretName,omitempty"`
	// SecretVersion - The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
	SecretVersion *map[string]interface{} `json:"secretVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	akvsr.Type = TypeAzureKeyVaultSecret
	type Alias AzureKeyVaultSecretReference
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(akvsr),
	})
}

// AsSecureString is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecureString() (*SecureString, bool) {
	return nil, false
}

// AsAzureKeyVaultSecretReference is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsAzureKeyVaultSecretReference() (*AzureKeyVaultSecretReference, bool) {
	return &akvsr, true
}

// AsSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsSecretBase() (*SecretBase, bool) {
	return nil, false
}

// AsBasicSecretBase is the BasicSecretBase implementation for AzureKeyVaultSecretReference.
func (akvsr AzureKeyVaultSecretReference) AsBasicSecretBase() (BasicSecretBase, bool) {
	return &akvsr, true
}

// AzureMLBatchExecutionActivity azure ML Batch Execution activity.
type AzureMLBatchExecutionActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AzureMLBatchExecutionActivityTypeProperties - Azure ML Batch Execution activity properties.
	*AzureMLBatchExecutionActivityTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) MarshalJSON() ([]byte, error) {
	ambea.Type = TypeAzureMLBatchExecution
	type Alias AzureMLBatchExecutionActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ambea),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return &ambea, true
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ambea, true
}

// AsUntilActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLBatchExecutionActivity.
func (ambea AzureMLBatchExecutionActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ambea, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLBatchExecutionActivity struct.
func (ambea *AzureMLBatchExecutionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureMLBatchExecutionActivityTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ambea.AzureMLBatchExecutionActivityTypeProperties = &typeProperties
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ambea.LinkedServiceName = &linkedServiceName
	}

	v = m["policy"]
	if v != nil {
		var policy ActivityPolicy
		err = json.Unmarshal(*m["policy"], &policy)
		if err != nil {
			return err
		}
		ambea.Policy = &policy
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ambea.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ambea.Description = &description
	}

	v = m["dependsOn"]
	if v != nil {
		var dependsOn []ActivityDependency
		err = json.Unmarshal(*m["dependsOn"], &dependsOn)
		if err != nil {
			return err
		}
		ambea.DependsOn = &dependsOn
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicActivity
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ambea.Type = typeVar
	}

	return nil
}

// AzureMLBatchExecutionActivityTypeProperties azure ML Batch Execution activity properties.
type AzureMLBatchExecutionActivityTypeProperties struct {
	// GlobalParameters - Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service parameters defined in the published Azure ML web service. Values will be passed in the GlobalParameters property of the Azure ML batch execution request.
	GlobalParameters *map[string]*map[string]interface{} `json:"globalParameters,omitempty"`
	// WebServiceOutputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying the output Blob locations. This information will be passed in the WebServiceOutputs property of the Azure ML batch execution request.
	WebServiceOutputs *map[string]*AzureMLWebServiceFile `json:"webServiceOutputs,omitempty"`
	// WebServiceInputs - Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying the input Blob locations.. This information will be passed in the WebServiceInputs property of the Azure ML batch execution request.
	WebServiceInputs *map[string]*AzureMLWebServiceFile `json:"webServiceInputs,omitempty"`
}

// AzureMLLinkedService azure ML Web Service linked service.
type AzureMLLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureMLLinkedServiceTypeProperties - Azure ML Web Service linked service properties.
	*AzureMLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLLinkedService.
func (amls AzureMLLinkedService) MarshalJSON() ([]byte, error) {
	amls.Type = TypeAzureML
	type Alias AzureMLLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return &amls, true
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMLLinkedService.
func (amls AzureMLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLLinkedService struct.
func (amls *AzureMLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureMLLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		amls.AzureMLLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		amls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		amls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		amls.Type = typeVar
	}

	return nil
}

// AzureMLLinkedServiceTypeProperties azure ML Web Service linked service properties.
type AzureMLLinkedServiceTypeProperties struct {
	// MlEndpoint - The Batch Execution REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	MlEndpoint *map[string]interface{} `json:"mlEndpoint,omitempty"`
	// APIKey - The API key for accessing the Azure ML model endpoint.
	APIKey *SecureString `json:"apiKey,omitempty"`
	// UpdateResourceEndpoint - The Update Resource REST URL for an Azure ML Web Service endpoint. Type: string (or Expression with resultType string).
	UpdateResourceEndpoint *map[string]interface{} `json:"updateResourceEndpoint,omitempty"`
	// ServicePrincipalID - The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service. Type: string (or Expression with resultType string).
	ServicePrincipalID *map[string]interface{} `json:"servicePrincipalId,omitempty"`
	// ServicePrincipalKey - The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML web service.
	ServicePrincipalKey *SecureString `json:"servicePrincipalKey,omitempty"`
	// Tenant - The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant *map[string]interface{} `json:"tenant,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureMLUpdateResourceActivity azure ML Update Resource management activity.
type AzureMLUpdateResourceActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// AzureMLUpdateResourceActivityTypeProperties - Azure ML Update Resource management activity properties.
	*AzureMLUpdateResourceActivityTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) MarshalJSON() ([]byte, error) {
	amura.Type = TypeAzureMLUpdateResource
	type Alias AzureMLUpdateResourceActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amura),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return &amura, true
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &amura, true
}

// AsUntilActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for AzureMLUpdateResourceActivity.
func (amura AzureMLUpdateResourceActivity) AsBasicActivity() (BasicActivity, bool) {
	return &amura, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMLUpdateResourceActivity struct.
func (amura *AzureMLUpdateResourceActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureMLUpdateResourceActivityTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		amura.AzureMLUpdateResourceActivityTypeProperties = &typeProperties
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		amura.LinkedServiceName = &linkedServiceName
	}

	v = m["policy"]
	if v != nil {
		var policy ActivityPolicy
		err = json.Unmarshal(*m["policy"], &policy)
		if err != nil {
			return err
		}
		amura.Policy = &policy
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		amura.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		amura.Description = &description
	}

	v = m["dependsOn"]
	if v != nil {
		var dependsOn []ActivityDependency
		err = json.Unmarshal(*m["dependsOn"], &dependsOn)
		if err != nil {
			return err
		}
		amura.DependsOn = &dependsOn
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicActivity
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		amura.Type = typeVar
	}

	return nil
}

// AzureMLUpdateResourceActivityTypeProperties azure ML Update Resource activity properties.
type AzureMLUpdateResourceActivityTypeProperties struct {
	// TrainedModelName - Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with resultType string).
	TrainedModelName *map[string]interface{} `json:"trainedModelName,omitempty"`
	// TrainedModelLinkedServiceName - Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
	TrainedModelLinkedServiceName *LinkedServiceReference `json:"trainedModelLinkedServiceName,omitempty"`
	// TrainedModelFilePath - The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by the update operation.  Type: string (or Expression with resultType string).
	TrainedModelFilePath *map[string]interface{} `json:"trainedModelFilePath,omitempty"`
}

// AzureMLWebServiceFile azure ML WebService Input/Output file
type AzureMLWebServiceFile struct {
	// FilePath - The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string).
	FilePath *map[string]interface{} `json:"filePath,omitempty"`
	// LinkedServiceName - Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
}

// AzureMySQLLinkedService azure MySQL database linked service.
type AzureMySQLLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureMySQLLinkedServiceTypeProperties - Azure MySQL database linked service properties.
	*AzureMySQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) MarshalJSON() ([]byte, error) {
	amsls.Type = TypeAzureMySQL
	type Alias AzureMySQLLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amsls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return &amsls, true
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureMySQLLinkedService.
func (amsls AzureMySQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &amsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLLinkedService struct.
func (amsls *AzureMySQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureMySQLLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		amsls.AzureMySQLLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		amsls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		amsls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		amsls.Type = typeVar
	}

	return nil
}

// AzureMySQLLinkedServiceTypeProperties azure MySQL database linked service properties.
type AzureMySQLLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string.
	ConnectionString *SecureString `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureMySQLSource a copy activity Azure MySQL source.
type AzureMySQLSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - Database query. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLSource.
func (amss AzureMySQLSource) MarshalJSON() ([]byte, error) {
	amss.Type = TypeAzureMySQLSource
	type Alias AzureMySQLSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amss),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return &amss, true
}

// AsHdfsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureMySQLSource.
func (amss AzureMySQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &amss, true
}

// AzureMySQLTableDataset the Azure MySQL database dataset.
type AzureMySQLTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureMySQLTableDatasetTypeProperties - Azure MySQL database dataset properties.
	*AzureMySQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) MarshalJSON() ([]byte, error) {
	amstd.Type = TypeAzureMySQLTable
	type Alias AzureMySQLTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amstd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return &amstd, true
}

// AsOracleTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureMySQLTableDataset.
func (amstd AzureMySQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &amstd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureMySQLTableDataset struct.
func (amstd *AzureMySQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureMySQLTableDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		amstd.AzureMySQLTableDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		amstd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		amstd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		amstd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		amstd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		amstd.Type = typeVar
	}

	return nil
}

// AzureMySQLTableDatasetTypeProperties azure MySQL database dataset properties.
type AzureMySQLTableDatasetTypeProperties struct {
	// TableName - The Azure MySQL database table name. Type: string (or Expression with resultType string).
	TableName *map[string]interface{} `json:"tableName,omitempty"`
}

// AzurePostgreSQLLinkedService azure PostgreSQL linked service.
type AzurePostgreSQLLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzurePostgreSQLLinkedServiceTypeProperties - Azure PostgreSQL linked service properties.
	*AzurePostgreSQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) MarshalJSON() ([]byte, error) {
	apsls.Type = TypeAzurePostgreSQL
	type Alias AzurePostgreSQLLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(apsls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return &apsls, true
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzurePostgreSQLLinkedService.
func (apsls AzurePostgreSQLLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &apsls, true
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLLinkedService struct.
func (apsls *AzurePostgreSQLLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzurePostgreSQLLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		apsls.AzurePostgreSQLLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		apsls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		apsls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		apsls.Type = typeVar
	}

	return nil
}

// AzurePostgreSQLLinkedServiceTypeProperties azure PostgreSQL linked service properties.
type AzurePostgreSQLLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string.
	ConnectionString BasicSecretBase `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AzurePostgreSQLLinkedServiceTypeProperties struct.
func (apslstp *AzurePostgreSQLLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["connectionString"]
	if v != nil {
		connectionString, err := unmarshalBasicSecretBase(*m["connectionString"])
		if err != nil {
			return err
		}
		apslstp.ConnectionString = connectionString
	}

	v = m["encryptedCredential"]
	if v != nil {
		var encryptedCredential map[string]interface{}
		err = json.Unmarshal(*m["encryptedCredential"], &encryptedCredential)
		if err != nil {
			return err
		}
		apslstp.EncryptedCredential = &encryptedCredential
	}

	return nil
}

// AzurePostgreSQLSource a copy activity Azure PostgreSQL source.
type AzurePostgreSQLSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) MarshalJSON() ([]byte, error) {
	apss.Type = TypeAzurePostgreSQLSource
	type Alias AzurePostgreSQLSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(apss),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return &apss, true
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzurePostgreSQLSource.
func (apss AzurePostgreSQLSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &apss, true
}

// AzurePostgreSQLTableDataset azure PostgreSQL dataset.
type AzurePostgreSQLTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) MarshalJSON() ([]byte, error) {
	apstd.Type = TypeAzurePostgreSQLTable
	type Alias AzurePostgreSQLTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(apstd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return &apstd, true
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzurePostgreSQLTableDataset.
func (apstd AzurePostgreSQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &apstd, true
}

// AzureQueueSink a copy activity Azure Queue sink.
type AzureQueueSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureQueueSink.
func (aqs AzureQueueSink) MarshalJSON() ([]byte, error) {
	aqs.Type = TypeAzureQueueSink
	type Alias AzureQueueSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aqs),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return &aqs, true
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureQueueSink.
func (aqs AzureQueueSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &aqs, true
}

// AzureSearchIndexDataset the Azure Search Index.
type AzureSearchIndexDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureSearchIndexDatasetTypeProperties - Properties specific to this dataset type.
	*AzureSearchIndexDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) MarshalJSON() ([]byte, error) {
	asid.Type = TypeAzureSearchIndex
	type Alias AzureSearchIndexDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asid),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return &asid, true
}

// AsWebTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSearchIndexDataset.
func (asid AzureSearchIndexDataset) AsBasicDataset() (BasicDataset, bool) {
	return &asid, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchIndexDataset struct.
func (asid *AzureSearchIndexDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSearchIndexDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asid.AzureSearchIndexDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asid.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		asid.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		asid.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		asid.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asid.Type = typeVar
	}

	return nil
}

// AzureSearchIndexDatasetTypeProperties properties specific to this dataset type.
type AzureSearchIndexDatasetTypeProperties struct {
	// IndexName - The name of the Azure Search Index. Type: string (or Expression with resultType string).
	IndexName *map[string]interface{} `json:"indexName,omitempty"`
}

// AzureSearchIndexSink a copy activity Azure Search Index sink.
type AzureSearchIndexSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
	// WriteBehavior - Specify the write behavior when upserting documents into Azure Search Index. Possible values include: 'Merge', 'Upload'
	WriteBehavior AzureSearchIndexWriteBehaviorType `json:"writeBehavior,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) MarshalJSON() ([]byte, error) {
	asis.Type = TypeAzureSearchIndexSink
	type Alias AzureSearchIndexSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asis),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return &asis, true
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureSearchIndexSink.
func (asis AzureSearchIndexSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &asis, true
}

// AzureSearchLinkedService linked service for Windows Azure Search Service.
type AzureSearchLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureSearchLinkedServiceTypeProperties - Windows Azure Search Service linked service properties.
	*AzureSearchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAzureSearch
	type Alias AzureSearchLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return &asls, true
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSearchLinkedService.
func (asls AzureSearchLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSearchLinkedService struct.
func (asls *AzureSearchLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSearchLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asls.AzureSearchLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		asls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asls.Type = typeVar
	}

	return nil
}

// AzureSearchLinkedServiceTypeProperties windows Azure Search Service linked service properties.
type AzureSearchLinkedServiceTypeProperties struct {
	// URL - URL for Azure Search service. Type: string (or Expression with resultType string).
	URL *map[string]interface{} `json:"url,omitempty"`
	// Key - Admin Key for Azure Search service
	Key *SecureString `json:"key,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureSQLDatabaseLinkedService microsoft Azure SQL Database linked service.
type AzureSQLDatabaseLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureSQLDatabaseLinkedServiceTypeProperties - Azure SQL Database linked service properties.
	*AzureSQLDatabaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDatabase
	type Alias AzureSQLDatabaseLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asdls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return &asdls, true
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSQLDatabaseLinkedService.
func (asdls AzureSQLDatabaseLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asdls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDatabaseLinkedService struct.
func (asdls *AzureSQLDatabaseLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSQLDatabaseLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asdls.AzureSQLDatabaseLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		asdls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asdls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asdls.Type = typeVar
	}

	return nil
}

// AzureSQLDatabaseLinkedServiceTypeProperties azure SQL Database linked service properties.
type AzureSQLDatabaseLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string.
	ConnectionString *SecureString `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureSQLDWLinkedService azure SQL Data Warehouse linked service.
type AzureSQLDWLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureSQLDWLinkedServiceTypeProperties - Azure SQL Data Warehouse linked service properties.
	*AzureSQLDWLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) MarshalJSON() ([]byte, error) {
	asdls.Type = TypeAzureSQLDW
	type Alias AzureSQLDWLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asdls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return &asdls, true
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureSQLDWLinkedService.
func (asdls AzureSQLDWLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asdls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDWLinkedService struct.
func (asdls *AzureSQLDWLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSQLDWLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asdls.AzureSQLDWLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		asdls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asdls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asdls.Type = typeVar
	}

	return nil
}

// AzureSQLDWLinkedServiceTypeProperties azure SQL Data Warehouse linked service properties.
type AzureSQLDWLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string.
	ConnectionString *SecureString `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureSQLDWTableDataset the Azure SQL Data Warehouse dataset.
type AzureSQLDWTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureSQLDWTableDatasetTypeProperties - Azure SQL Data Warehouse dataset properties.
	*AzureSQLDWTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) MarshalJSON() ([]byte, error) {
	asdtd.Type = TypeAzureSQLDWTable
	type Alias AzureSQLDWTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asdtd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return &asdtd, true
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSQLDWTableDataset.
func (asdtd AzureSQLDWTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &asdtd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLDWTableDataset struct.
func (asdtd *AzureSQLDWTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSQLDWTableDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asdtd.AzureSQLDWTableDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asdtd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		asdtd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		asdtd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		asdtd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asdtd.Type = typeVar
	}

	return nil
}

// AzureSQLDWTableDatasetTypeProperties azure SQL Data Warehouse dataset properties.
type AzureSQLDWTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	TableName *map[string]interface{} `json:"tableName,omitempty"`
}

// AzureSQLTableDataset the Azure SQL Server database dataset.
type AzureSQLTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureSQLTableDatasetTypeProperties - Azure SQL dataset properties.
	*AzureSQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) MarshalJSON() ([]byte, error) {
	astd.Type = TypeAzureSQLTable
	type Alias AzureSQLTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(astd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return &astd, true
}

// AsAzureTableDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureSQLTableDataset.
func (astd AzureSQLTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &astd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLTableDataset struct.
func (astd *AzureSQLTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureSQLTableDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		astd.AzureSQLTableDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		astd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		astd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		astd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		astd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		astd.Type = typeVar
	}

	return nil
}

// AzureSQLTableDatasetTypeProperties azure SQL dataset properties.
type AzureSQLTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure SQL database. Type: string (or Expression with resultType string).
	TableName *map[string]interface{} `json:"tableName,omitempty"`
}

// AzureStorageLinkedService the storage account linked service.
type AzureStorageLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// AzureStorageLinkedServiceTypeProperties - Azure Storage linked service properties.
	*AzureStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) MarshalJSON() ([]byte, error) {
	asls.Type = TypeAzureStorage
	type Alias AzureStorageLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return &asls, true
}

// AsLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for AzureStorageLinkedService.
func (asls AzureStorageLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &asls, true
}

// UnmarshalJSON is the custom unmarshaler for AzureStorageLinkedService struct.
func (asls *AzureStorageLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureStorageLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		asls.AzureStorageLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		asls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		asls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		asls.Type = typeVar
	}

	return nil
}

// AzureStorageLinkedServiceTypeProperties azure Storage linked service properties.
type AzureStorageLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string. It is mutually exclusive with sasUri property.
	ConnectionString *SecureString `json:"connectionString,omitempty"`
	// SasURI - SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property.
	SasURI *SecureString `json:"sasUri,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// AzureTableDataset the Azure Table storage dataset.
type AzureTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// AzureTableDatasetTypeProperties - Azure Table dataset properties.
	*AzureTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableDataset.
func (atd AzureTableDataset) MarshalJSON() ([]byte, error) {
	atd.Type = TypeAzureTable
	type Alias AzureTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(atd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return &atd, true
}

// AsAzureBlobDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for AzureTableDataset.
func (atd AzureTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &atd, true
}

// UnmarshalJSON is the custom unmarshaler for AzureTableDataset struct.
func (atd *AzureTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties AzureTableDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		atd.AzureTableDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		atd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		atd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		atd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		atd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		atd.Type = typeVar
	}

	return nil
}

// AzureTableDatasetTypeProperties azure Table dataset properties.
type AzureTableDatasetTypeProperties struct {
	// TableName - The table name of the Azure Table storage. Type: string (or Expression with resultType string).
	TableName *map[string]interface{} `json:"tableName,omitempty"`
}

// AzureTableSink a copy activity Azure Table sink.
type AzureTableSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
	// AzureTableDefaultPartitionKeyValue - Azure Table default partition key value. Type: string (or Expression with resultType string).
	AzureTableDefaultPartitionKeyValue *map[string]interface{} `json:"azureTableDefaultPartitionKeyValue,omitempty"`
	// AzureTablePartitionKeyName - Azure Table partition key name. Type: string (or Expression with resultType string).
	AzureTablePartitionKeyName *map[string]interface{} `json:"azureTablePartitionKeyName,omitempty"`
	// AzureTableRowKeyName - Azure Table row key name. Type: string (or Expression with resultType string).
	AzureTableRowKeyName *map[string]interface{} `json:"azureTableRowKeyName,omitempty"`
	// AzureTableInsertType - Azure Table insert type. Type: string (or Expression with resultType string).
	AzureTableInsertType *map[string]interface{} `json:"azureTableInsertType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableSink.
func (ats AzureTableSink) MarshalJSON() ([]byte, error) {
	ats.Type = TypeAzureTableSink
	type Alias AzureTableSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ats),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return &ats, true
}

// AsAzureQueueSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for AzureTableSink.
func (ats AzureTableSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ats, true
}

// AzureTableSource a copy activity Azure Table source.
type AzureTableSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// AzureTableSourceQuery - Azure Table source query. Type: string (or Expression with resultType string).
	AzureTableSourceQuery *map[string]interface{} `json:"azureTableSourceQuery,omitempty"`
	// AzureTableSourceIgnoreTableNotFound - Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
	AzureTableSourceIgnoreTableNotFound *map[string]interface{} `json:"azureTableSourceIgnoreTableNotFound,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableSource.
func (ats AzureTableSource) MarshalJSON() ([]byte, error) {
	ats.Type = TypeAzureTableSource
	type Alias AzureTableSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ats),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return &ats, true
}

// AsCopySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for AzureTableSource.
func (ats AzureTableSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ats, true
}

// BlobSink a copy activity Azure Blob sink.
type BlobSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
	// BlobWriterOverwriteFiles - Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
	BlobWriterOverwriteFiles *map[string]interface{} `json:"blobWriterOverwriteFiles,omitempty"`
	// BlobWriterDateTimeFormat - Blob writer date time format. Type: string (or Expression with resultType string).
	BlobWriterDateTimeFormat *map[string]interface{} `json:"blobWriterDateTimeFormat,omitempty"`
	// BlobWriterAddHeader - Blob writer add header. Type: boolean (or Expression with resultType boolean).
	BlobWriterAddHeader *map[string]interface{} `json:"blobWriterAddHeader,omitempty"`
	// CopyBehavior - The type of copy behavior for copy sink. Possible values include: 'PreserveHierarchy', 'FlattenHierarchy', 'MergeFiles'
	CopyBehavior CopyBehaviorType `json:"copyBehavior,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobSink.
func (bs BlobSink) MarshalJSON() ([]byte, error) {
	bs.Type = TypeBlobSink
	type Alias BlobSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(bs),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsBlobSink() (*BlobSink, bool) {
	return &bs, true
}

// AsAzureTableSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for BlobSink.
func (bs BlobSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &bs, true
}

// BlobSource a copy activity Azure Blob source.
type BlobSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// TreatEmptyAsNull - Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull *map[string]interface{} `json:"treatEmptyAsNull,omitempty"`
	// SkipHeaderLineCount - Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount *map[string]interface{} `json:"skipHeaderLineCount,omitempty"`
	// Recursive - If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
	Recursive *map[string]interface{} `json:"recursive,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobSource.
func (bs BlobSource) MarshalJSON() ([]byte, error) {
	bs.Type = TypeBlobSource
	type Alias BlobSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(bs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsBlobSource() (*BlobSource, bool) {
	return &bs, true
}

// AsAzureTableSource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for BlobSource.
func (bs BlobSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &bs, true
}

// BlobTrigger trigger that runs everytime the selected Blob container changes.
type BlobTrigger struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Trigger description.
	Description *string `json:"description,omitempty"`
	// RuntimeState - Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger. Possible values include: 'TriggerRuntimeStateStarted', 'TriggerRuntimeStateStopped', 'TriggerRuntimeStateDisabled'
	RuntimeState TriggerRuntimeState `json:"runtimeState,omitempty"`
	// Type - Possible values include: 'TypeTrigger', 'TypeTumblingWindowTrigger', 'TypeBlobTrigger', 'TypeScheduleTrigger', 'TypeMultiplePipelineTrigger'
	Type TypeBasicTrigger `json:"type,omitempty"`
	// Pipelines - Pipelines that need to be started.
	Pipelines *[]TriggerPipelineReference `json:"pipelines,omitempty"`
	// BlobTriggerTypeProperties - Blob Trigger properties.
	*BlobTriggerTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobTrigger.
func (bt BlobTrigger) MarshalJSON() ([]byte, error) {
	bt.Type = TypeBlobTrigger
	type Alias BlobTrigger
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(bt),
	})
}

// AsTumblingWindowTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsTumblingWindowTrigger() (*TumblingWindowTrigger, bool) {
	return nil, false
}

// AsBlobTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBlobTrigger() (*BlobTrigger, bool) {
	return &bt, true
}

// AsScheduleTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsScheduleTrigger() (*ScheduleTrigger, bool) {
	return nil, false
}

// AsMultiplePipelineTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsMultiplePipelineTrigger() (*MultiplePipelineTrigger, bool) {
	return nil, false
}

// AsBasicMultiplePipelineTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBasicMultiplePipelineTrigger() (BasicMultiplePipelineTrigger, bool) {
	return &bt, true
}

// AsTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsTrigger() (*Trigger, bool) {
	return nil, false
}

// AsBasicTrigger is the BasicTrigger implementation for BlobTrigger.
func (bt BlobTrigger) AsBasicTrigger() (BasicTrigger, bool) {
	return &bt, true
}

// UnmarshalJSON is the custom unmarshaler for BlobTrigger struct.
func (bt *BlobTrigger) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties BlobTriggerTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		bt.BlobTriggerTypeProperties = &typeProperties
	}

	v = m["pipelines"]
	if v != nil {
		var pipelines []TriggerPipelineReference
		err = json.Unmarshal(*m["pipelines"], &pipelines)
		if err != nil {
			return err
		}
		bt.Pipelines = &pipelines
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		bt.Description = &description
	}

	v = m["runtimeState"]
	if v != nil {
		var runtimeState TriggerRuntimeState
		err = json.Unmarshal(*m["runtimeState"], &runtimeState)
		if err != nil {
			return err
		}
		bt.RuntimeState = runtimeState
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicTrigger
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		bt.Type = typeVar
	}

	return nil
}

// BlobTriggerTypeProperties blob Trigger properties.
type BlobTriggerTypeProperties struct {
	// FolderPath - The path of the container/folder that will trigger the pipeline.
	FolderPath *string `json:"folderPath,omitempty"`
	// MaxConcurrency - The max number of parallel files to handle when it is triggered.
	MaxConcurrency *int32 `json:"maxConcurrency,omitempty"`
	// LinkedService - The Azure Storage linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`
}

// CassandraLinkedService linked service for Cassandra data source.
type CassandraLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// CassandraLinkedServiceTypeProperties - Cassandra linked service properties.
	*CassandraLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraLinkedService.
func (cls CassandraLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeCassandra
	type Alias CassandraLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return &cls, true
}

// AsWebLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CassandraLinkedService.
func (cls CassandraLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for CassandraLinkedService struct.
func (cls *CassandraLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CassandraLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		cls.CassandraLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		cls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cls.Type = typeVar
	}

	return nil
}

// CassandraLinkedServiceTypeProperties cassandra linked service properties.
type CassandraLinkedServiceTypeProperties struct {
	// Host - Host name for connection. Type: string (or Expression with resultType string).
	Host *map[string]interface{} `json:"host,omitempty"`
	// AuthenticationType - AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
	AuthenticationType *map[string]interface{} `json:"authenticationType,omitempty"`
	// Port - The port for the connection. Type: integer (or Expression with resultType integer).
	Port *map[string]interface{} `json:"port,omitempty"`
	// Username - Username for authentication. Type: string (or Expression with resultType string).
	Username *map[string]interface{} `json:"username,omitempty"`
	// Password - Password for authentication.
	Password *SecureString `json:"password,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// CassandraSource a copy activity source for a Cassandra database.
type CassandraSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
	// ConsistencyLevel - The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the client application. Cassandra checks the specified number of Cassandra servers for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'. It is case-insensitive. Possible values include: 'ALL', 'EACHQUORUM', 'QUORUM', 'LOCALQUORUM', 'ONE', 'TWO', 'THREE', 'LOCALONE', 'SERIAL', 'LOCALSERIAL'
	ConsistencyLevel CassandraSourceReadConsistencyLevels `json:"consistencyLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraSource.
func (cs CassandraSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCassandraSource
	type Alias CassandraSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCassandraSource() (*CassandraSource, bool) {
	return &cs, true
}

// AsWebSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for CassandraSource.
func (cs CassandraSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// CassandraTableDataset the Cassandra database dataset.
type CassandraTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// CassandraTableDatasetTypeProperties - Cassandra dataset properties.
	*CassandraTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableDataset.
func (ctd CassandraTableDataset) MarshalJSON() ([]byte, error) {
	ctd.Type = TypeCassandraTable
	type Alias CassandraTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ctd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return &ctd, true
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CassandraTableDataset.
func (ctd CassandraTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ctd, true
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableDataset struct.
func (ctd *CassandraTableDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CassandraTableDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ctd.CassandraTableDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ctd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		ctd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ctd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		ctd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ctd.Type = typeVar
	}

	return nil
}

// CassandraTableDatasetTypeProperties cassandra dataset properties.
type CassandraTableDatasetTypeProperties struct {
	// TableName - The table name of the Cassandra database. Type: string (or Expression with resultType string).
	TableName *map[string]interface{} `json:"tableName,omitempty"`
	// Keyspace - The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
	Keyspace *map[string]interface{} `json:"keyspace,omitempty"`
}

// ConcurLinkedService concur Serivce linked service.
type ConcurLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// ConcurLinkedServiceTypeProperties - Concur Serivce linked service properties.
	*ConcurLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurLinkedService.
func (cls ConcurLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeConcur
	type Alias ConcurLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return &cls, true
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for ConcurLinkedService.
func (cls ConcurLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for ConcurLinkedService struct.
func (cls *ConcurLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties ConcurLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		cls.ConcurLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		cls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cls.Type = typeVar
	}

	return nil
}

// ConcurLinkedServiceTypeProperties concur Serivce linked service properties.
type ConcurLinkedServiceTypeProperties struct {
	// ClientID - Application client_id supplied by Concur App Management.
	ClientID *map[string]interface{} `json:"clientId,omitempty"`
	// Username - The user name that you use to access Concur Service.
	Username *map[string]interface{} `json:"username,omitempty"`
	// Password - The password corresponding to the user name that you provided in the username field.
	Password BasicSecretBase `json:"password,omitempty"`
	// UseEncryptedEndpoints - Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints *map[string]interface{} `json:"useEncryptedEndpoints,omitempty"`
	// UseHostVerification - Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting over SSL. The default value is true.
	UseHostVerification *map[string]interface{} `json:"useHostVerification,omitempty"`
	// UsePeerVerification - Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification *map[string]interface{} `json:"usePeerVerification,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConcurLinkedServiceTypeProperties struct.
func (clstp *ConcurLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["clientId"]
	if v != nil {
		var clientID map[string]interface{}
		err = json.Unmarshal(*m["clientId"], &clientID)
		if err != nil {
			return err
		}
		clstp.ClientID = &clientID
	}

	v = m["username"]
	if v != nil {
		var username map[string]interface{}
		err = json.Unmarshal(*m["username"], &username)
		if err != nil {
			return err
		}
		clstp.Username = &username
	}

	v = m["password"]
	if v != nil {
		password, err := unmarshalBasicSecretBase(*m["password"])
		if err != nil {
			return err
		}
		clstp.Password = password
	}

	v = m["useEncryptedEndpoints"]
	if v != nil {
		var useEncryptedEndpoints map[string]interface{}
		err = json.Unmarshal(*m["useEncryptedEndpoints"], &useEncryptedEndpoints)
		if err != nil {
			return err
		}
		clstp.UseEncryptedEndpoints = &useEncryptedEndpoints
	}

	v = m["useHostVerification"]
	if v != nil {
		var useHostVerification map[string]interface{}
		err = json.Unmarshal(*m["useHostVerification"], &useHostVerification)
		if err != nil {
			return err
		}
		clstp.UseHostVerification = &useHostVerification
	}

	v = m["usePeerVerification"]
	if v != nil {
		var usePeerVerification map[string]interface{}
		err = json.Unmarshal(*m["usePeerVerification"], &usePeerVerification)
		if err != nil {
			return err
		}
		clstp.UsePeerVerification = &usePeerVerification
	}

	v = m["encryptedCredential"]
	if v != nil {
		var encryptedCredential map[string]interface{}
		err = json.Unmarshal(*m["encryptedCredential"], &encryptedCredential)
		if err != nil {
			return err
		}
		clstp.EncryptedCredential = &encryptedCredential
	}

	return nil
}

// ConcurObjectDataset concur Serivce dataset.
type ConcurObjectDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurObjectDataset.
func (cod ConcurObjectDataset) MarshalJSON() ([]byte, error) {
	cod.Type = TypeConcurObject
	type Alias ConcurObjectDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cod),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return &cod, true
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for ConcurObjectDataset.
func (cod ConcurObjectDataset) AsBasicDataset() (BasicDataset, bool) {
	return &cod, true
}

// ConcurSource a copy activity Concur Serivce source.
type ConcurSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for ConcurSource.
func (cs ConcurSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeConcurSource
	type Alias ConcurSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsConcurSource() (*ConcurSource, bool) {
	return &cs, true
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for ConcurSource.
func (cs ConcurSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// BasicControlActivity base class for all control activities like IfCondition, ForEach , Until.
type BasicControlActivity interface {
	AsUntilActivity() (*UntilActivity, bool)
	AsWaitActivity() (*WaitActivity, bool)
	AsForEachActivity() (*ForEachActivity, bool)
	AsIfConditionActivity() (*IfConditionActivity, bool)
	AsExecutePipelineActivity() (*ExecutePipelineActivity, bool)
	AsControlActivity() (*ControlActivity, bool)
}

// ControlActivity base class for all control activities like IfCondition, ForEach , Until.
type ControlActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
}

func unmarshalBasicControlActivity(body []byte) (BasicControlActivity, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeUntil):
		var ua UntilActivity
		err := json.Unmarshal(body, &ua)
		return ua, err
	case string(TypeWait):
		var wa WaitActivity
		err := json.Unmarshal(body, &wa)
		return wa, err
	case string(TypeForEach):
		var fea ForEachActivity
		err := json.Unmarshal(body, &fea)
		return fea, err
	case string(TypeIfCondition):
		var ica IfConditionActivity
		err := json.Unmarshal(body, &ica)
		return ica, err
	case string(TypeExecutePipeline):
		var epa ExecutePipelineActivity
		err := json.Unmarshal(body, &epa)
		return epa, err
	default:
		var ca ControlActivity
		err := json.Unmarshal(body, &ca)
		return ca, err
	}
}
func unmarshalBasicControlActivityArray(body []byte) ([]BasicControlActivity, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	caArray := make([]BasicControlActivity, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ca, err := unmarshalBasicControlActivity(*rawMessage)
		if err != nil {
			return nil, err
		}
		caArray[index] = ca
	}
	return caArray, nil
}

// MarshalJSON is the custom marshaler for ControlActivity.
func (ca ControlActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeContainer
	type Alias ControlActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ca),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return nil, false
}

// AsUntilActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsControlActivity() (*ControlActivity, bool) {
	return &ca, true
}

// AsBasicControlActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return &ca, true
}

// AsActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for ControlActivity.
func (ca ControlActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// CopyActivity copy activity.
type CopyActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// CopyActivityTypeProperties - Copy activity properties.
	*CopyActivityTypeProperties `json:"typeProperties,omitempty"`
	// Inputs - List of inputs for the activity.
	Inputs *[]DatasetReference `json:"inputs,omitempty"`
	// Outputs - List of outputs for the activity.
	Outputs *[]DatasetReference `json:"outputs,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyActivity.
func (ca CopyActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeCopy
	type Alias CopyActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ca),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsCopyActivity() (*CopyActivity, bool) {
	return &ca, true
}

// AsExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ca, true
}

// AsUntilActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for CopyActivity.
func (ca CopyActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CopyActivity struct.
func (ca *CopyActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CopyActivityTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ca.CopyActivityTypeProperties = &typeProperties
	}

	v = m["inputs"]
	if v != nil {
		var inputs []DatasetReference
		err = json.Unmarshal(*m["inputs"], &inputs)
		if err != nil {
			return err
		}
		ca.Inputs = &inputs
	}

	v = m["outputs"]
	if v != nil {
		var outputs []DatasetReference
		err = json.Unmarshal(*m["outputs"], &outputs)
		if err != nil {
			return err
		}
		ca.Outputs = &outputs
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ca.LinkedServiceName = &linkedServiceName
	}

	v = m["policy"]
	if v != nil {
		var policy ActivityPolicy
		err = json.Unmarshal(*m["policy"], &policy)
		if err != nil {
			return err
		}
		ca.Policy = &policy
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ca.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ca.Description = &description
	}

	v = m["dependsOn"]
	if v != nil {
		var dependsOn []ActivityDependency
		err = json.Unmarshal(*m["dependsOn"], &dependsOn)
		if err != nil {
			return err
		}
		ca.DependsOn = &dependsOn
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicActivity
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ca.Type = typeVar
	}

	return nil
}

// CopyActivityTypeProperties copy activity properties.
type CopyActivityTypeProperties struct {
	// Source - Copy activity source.
	Source BasicCopySource `json:"source,omitempty"`
	// Sink - Copy activity sink.
	Sink BasicCopySink `json:"sink,omitempty"`
	// Translator - Copy activity translator. If not specificed, tabular translator is used.
	Translator BasicCopyTranslator `json:"translator,omitempty"`
	// EnableStaging - Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableStaging *map[string]interface{} `json:"enableStaging,omitempty"`
	// StagingSettings - Specifies interim staging settings when EnableStaging is true.
	StagingSettings *StagingSettings `json:"stagingSettings,omitempty"`
	// ParallelCopies - Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or Expression with resultType integer), minimum: 0.
	ParallelCopies *map[string]interface{} `json:"parallelCopies,omitempty"`
	// CloudDataMovementUnits - Maximum number of cloud data movement units that can be used to perform this data movement. Type: integer (or Expression with resultType integer), minimum: 0.
	CloudDataMovementUnits *map[string]interface{} `json:"cloudDataMovementUnits,omitempty"`
	// EnableSkipIncompatibleRow - Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableSkipIncompatibleRow *map[string]interface{} `json:"enableSkipIncompatibleRow,omitempty"`
	// RedirectIncompatibleRowSettings - Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
	RedirectIncompatibleRowSettings *RedirectIncompatibleRowSettings `json:"redirectIncompatibleRowSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CopyActivityTypeProperties struct.
func (catp *CopyActivityTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["source"]
	if v != nil {
		source, err := unmarshalBasicCopySource(*m["source"])
		if err != nil {
			return err
		}
		catp.Source = source
	}

	v = m["sink"]
	if v != nil {
		sink, err := unmarshalBasicCopySink(*m["sink"])
		if err != nil {
			return err
		}
		catp.Sink = sink
	}

	v = m["translator"]
	if v != nil {
		translator, err := unmarshalBasicCopyTranslator(*m["translator"])
		if err != nil {
			return err
		}
		catp.Translator = translator
	}

	v = m["enableStaging"]
	if v != nil {
		var enableStaging map[string]interface{}
		err = json.Unmarshal(*m["enableStaging"], &enableStaging)
		if err != nil {
			return err
		}
		catp.EnableStaging = &enableStaging
	}

	v = m["stagingSettings"]
	if v != nil {
		var stagingSettings StagingSettings
		err = json.Unmarshal(*m["stagingSettings"], &stagingSettings)
		if err != nil {
			return err
		}
		catp.StagingSettings = &stagingSettings
	}

	v = m["parallelCopies"]
	if v != nil {
		var parallelCopies map[string]interface{}
		err = json.Unmarshal(*m["parallelCopies"], &parallelCopies)
		if err != nil {
			return err
		}
		catp.ParallelCopies = &parallelCopies
	}

	v = m["cloudDataMovementUnits"]
	if v != nil {
		var cloudDataMovementUnits map[string]interface{}
		err = json.Unmarshal(*m["cloudDataMovementUnits"], &cloudDataMovementUnits)
		if err != nil {
			return err
		}
		catp.CloudDataMovementUnits = &cloudDataMovementUnits
	}

	v = m["enableSkipIncompatibleRow"]
	if v != nil {
		var enableSkipIncompatibleRow map[string]interface{}
		err = json.Unmarshal(*m["enableSkipIncompatibleRow"], &enableSkipIncompatibleRow)
		if err != nil {
			return err
		}
		catp.EnableSkipIncompatibleRow = &enableSkipIncompatibleRow
	}

	v = m["redirectIncompatibleRowSettings"]
	if v != nil {
		var redirectIncompatibleRowSettings RedirectIncompatibleRowSettings
		err = json.Unmarshal(*m["redirectIncompatibleRowSettings"], &redirectIncompatibleRowSettings)
		if err != nil {
			return err
		}
		catp.RedirectIncompatibleRowSettings = &redirectIncompatibleRowSettings
	}

	return nil
}

// BasicCopySink a copy activity sink.
type BasicCopySink interface {
	AsSalesforceSink() (*SalesforceSink, bool)
	AsDynamicsSink() (*DynamicsSink, bool)
	AsOdbcSink() (*OdbcSink, bool)
	AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool)
	AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool)
	AsOracleSink() (*OracleSink, bool)
	AsSQLDWSink() (*SQLDWSink, bool)
	AsSQLSink() (*SQLSink, bool)
	AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool)
	AsFileSystemSink() (*FileSystemSink, bool)
	AsBlobSink() (*BlobSink, bool)
	AsAzureTableSink() (*AzureTableSink, bool)
	AsAzureQueueSink() (*AzureQueueSink, bool)
	AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool)
	AsCopySink() (*CopySink, bool)
}

// CopySink a copy activity sink.
type CopySink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
}

func unmarshalBasicCopySink(body []byte) (BasicCopySink, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeSalesforceSink):
		var ss SalesforceSink
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeDynamicsSink):
		var ds DynamicsSink
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeOdbcSink):
		var osVar OdbcSink
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeAzureSearchIndexSink):
		var asis AzureSearchIndexSink
		err := json.Unmarshal(body, &asis)
		return asis, err
	case string(TypeAzureDataLakeStoreSink):
		var adlss AzureDataLakeStoreSink
		err := json.Unmarshal(body, &adlss)
		return adlss, err
	case string(TypeOracleSink):
		var osVar OracleSink
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeSQLDWSink):
		var sds SQLDWSink
		err := json.Unmarshal(body, &sds)
		return sds, err
	case string(TypeSQLSink):
		var ss SQLSink
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeDocumentDbCollectionSink):
		var ddcs DocumentDbCollectionSink
		err := json.Unmarshal(body, &ddcs)
		return ddcs, err
	case string(TypeFileSystemSink):
		var fss FileSystemSink
		err := json.Unmarshal(body, &fss)
		return fss, err
	case string(TypeBlobSink):
		var bs BlobSink
		err := json.Unmarshal(body, &bs)
		return bs, err
	case string(TypeAzureTableSink):
		var ats AzureTableSink
		err := json.Unmarshal(body, &ats)
		return ats, err
	case string(TypeAzureQueueSink):
		var aqs AzureQueueSink
		err := json.Unmarshal(body, &aqs)
		return aqs, err
	case string(TypeSapCloudForCustomerSink):
		var scfcs SapCloudForCustomerSink
		err := json.Unmarshal(body, &scfcs)
		return scfcs, err
	default:
		var cs CopySink
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCopySinkArray(body []byte) ([]BasicCopySink, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCopySink, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCopySink(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CopySink.
func (cs CopySink) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCopySink
	type Alias CopySink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return nil, false
}

// AsFileSystemSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsCopySink() (*CopySink, bool) {
	return &cs, true
}

// AsBasicCopySink is the BasicCopySink implementation for CopySink.
func (cs CopySink) AsBasicCopySink() (BasicCopySink, bool) {
	return &cs, true
}

// BasicCopySource a copy activity source.
type BasicCopySource interface {
	AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool)
	AsZohoSource() (*ZohoSource, bool)
	AsXeroSource() (*XeroSource, bool)
	AsSquareSource() (*SquareSource, bool)
	AsSparkSource() (*SparkSource, bool)
	AsShopifySource() (*ShopifySource, bool)
	AsServiceNowSource() (*ServiceNowSource, bool)
	AsQuickBooksSource() (*QuickBooksSource, bool)
	AsPrestoSource() (*PrestoSource, bool)
	AsPhoenixSource() (*PhoenixSource, bool)
	AsPaypalSource() (*PaypalSource, bool)
	AsMarketoSource() (*MarketoSource, bool)
	AsMariaDBSource() (*MariaDBSource, bool)
	AsMagentoSource() (*MagentoSource, bool)
	AsJiraSource() (*JiraSource, bool)
	AsImpalaSource() (*ImpalaSource, bool)
	AsHubspotSource() (*HubspotSource, bool)
	AsHiveSource() (*HiveSource, bool)
	AsHBaseSource() (*HBaseSource, bool)
	AsGreenplumSource() (*GreenplumSource, bool)
	AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool)
	AsEloquaSource() (*EloquaSource, bool)
	AsDrillSource() (*DrillSource, bool)
	AsCouchbaseSource() (*CouchbaseSource, bool)
	AsConcurSource() (*ConcurSource, bool)
	AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool)
	AsAmazonMWSSource() (*AmazonMWSSource, bool)
	AsHTTPSource() (*HTTPSource, bool)
	AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool)
	AsMongoDbSource() (*MongoDbSource, bool)
	AsCassandraSource() (*CassandraSource, bool)
	AsWebSource() (*WebSource, bool)
	AsOracleSource() (*OracleSource, bool)
	AsAzureMySQLSource() (*AzureMySQLSource, bool)
	AsHdfsSource() (*HdfsSource, bool)
	AsFileSystemSource() (*FileSystemSource, bool)
	AsSQLDWSource() (*SQLDWSource, bool)
	AsSQLSource() (*SQLSource, bool)
	AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool)
	AsSalesforceSource() (*SalesforceSource, bool)
	AsRelationalSource() (*RelationalSource, bool)
	AsDynamicsSource() (*DynamicsSource, bool)
	AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool)
	AsBlobSource() (*BlobSource, bool)
	AsAzureTableSource() (*AzureTableSource, bool)
	AsCopySource() (*CopySource, bool)
}

// CopySource a copy activity source.
type CopySource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
}

func unmarshalBasicCopySource(body []byte) (BasicCopySource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAmazonRedshiftSource):
		var ars AmazonRedshiftSource
		err := json.Unmarshal(body, &ars)
		return ars, err
	case string(TypeZohoSource):
		var zs ZohoSource
		err := json.Unmarshal(body, &zs)
		return zs, err
	case string(TypeXeroSource):
		var xs XeroSource
		err := json.Unmarshal(body, &xs)
		return xs, err
	case string(TypeSquareSource):
		var ss SquareSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeSparkSource):
		var ss SparkSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeShopifySource):
		var ss ShopifySource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeServiceNowSource):
		var sns ServiceNowSource
		err := json.Unmarshal(body, &sns)
		return sns, err
	case string(TypeQuickBooksSource):
		var qbs QuickBooksSource
		err := json.Unmarshal(body, &qbs)
		return qbs, err
	case string(TypePrestoSource):
		var ps PrestoSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypePhoenixSource):
		var ps PhoenixSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypePaypalSource):
		var ps PaypalSource
		err := json.Unmarshal(body, &ps)
		return ps, err
	case string(TypeMarketoSource):
		var ms MarketoSource
		err := json.Unmarshal(body, &ms)
		return ms, err
	case string(TypeMariaDBSource):
		var mds MariaDBSource
		err := json.Unmarshal(body, &mds)
		return mds, err
	case string(TypeMagentoSource):
		var ms MagentoSource
		err := json.Unmarshal(body, &ms)
		return ms, err
	case string(TypeJiraSource):
		var js JiraSource
		err := json.Unmarshal(body, &js)
		return js, err
	case string(TypeImpalaSource):
		var is ImpalaSource
		err := json.Unmarshal(body, &is)
		return is, err
	case string(TypeHubspotSource):
		var hs HubspotSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeHiveSource):
		var hs HiveSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeHBaseSource):
		var hbs HBaseSource
		err := json.Unmarshal(body, &hbs)
		return hbs, err
	case string(TypeGreenplumSource):
		var gs GreenplumSource
		err := json.Unmarshal(body, &gs)
		return gs, err
	case string(TypeGoogleBigQuerySource):
		var gbqs GoogleBigQuerySource
		err := json.Unmarshal(body, &gbqs)
		return gbqs, err
	case string(TypeEloquaSource):
		var es EloquaSource
		err := json.Unmarshal(body, &es)
		return es, err
	case string(TypeDrillSource):
		var ds DrillSource
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeCouchbaseSource):
		var cs CouchbaseSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeConcurSource):
		var cs ConcurSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeAzurePostgreSQLSource):
		var apss AzurePostgreSQLSource
		err := json.Unmarshal(body, &apss)
		return apss, err
	case string(TypeAmazonMWSSource):
		var ams AmazonMWSSource
		err := json.Unmarshal(body, &ams)
		return ams, err
	case string(TypeHTTPSource):
		var hs HTTPSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeAzureDataLakeStoreSource):
		var adlss AzureDataLakeStoreSource
		err := json.Unmarshal(body, &adlss)
		return adlss, err
	case string(TypeMongoDbSource):
		var mds MongoDbSource
		err := json.Unmarshal(body, &mds)
		return mds, err
	case string(TypeCassandraSource):
		var cs CassandraSource
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeWebSource):
		var ws WebSource
		err := json.Unmarshal(body, &ws)
		return ws, err
	case string(TypeOracleSource):
		var osVar OracleSource
		err := json.Unmarshal(body, &osVar)
		return osVar, err
	case string(TypeAzureMySQLSource):
		var amss AzureMySQLSource
		err := json.Unmarshal(body, &amss)
		return amss, err
	case string(TypeHdfsSource):
		var hs HdfsSource
		err := json.Unmarshal(body, &hs)
		return hs, err
	case string(TypeFileSystemSource):
		var fss FileSystemSource
		err := json.Unmarshal(body, &fss)
		return fss, err
	case string(TypeSQLDWSource):
		var sds SQLDWSource
		err := json.Unmarshal(body, &sds)
		return sds, err
	case string(TypeSQLSource):
		var ss SQLSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeSapCloudForCustomerSource):
		var scfcs SapCloudForCustomerSource
		err := json.Unmarshal(body, &scfcs)
		return scfcs, err
	case string(TypeSalesforceSource):
		var ss SalesforceSource
		err := json.Unmarshal(body, &ss)
		return ss, err
	case string(TypeRelationalSource):
		var rs RelationalSource
		err := json.Unmarshal(body, &rs)
		return rs, err
	case string(TypeDynamicsSource):
		var ds DynamicsSource
		err := json.Unmarshal(body, &ds)
		return ds, err
	case string(TypeDocumentDbCollectionSource):
		var ddcs DocumentDbCollectionSource
		err := json.Unmarshal(body, &ddcs)
		return ddcs, err
	case string(TypeBlobSource):
		var bs BlobSource
		err := json.Unmarshal(body, &bs)
		return bs, err
	case string(TypeAzureTableSource):
		var ats AzureTableSource
		err := json.Unmarshal(body, &ats)
		return ats, err
	default:
		var cs CopySource
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCopySourceArray(body []byte) ([]BasicCopySource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCopySource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCopySource(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CopySource.
func (cs CopySource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCopySource
	type Alias CopySource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsCopySource() (*CopySource, bool) {
	return &cs, true
}

// AsBasicCopySource is the BasicCopySource implementation for CopySource.
func (cs CopySource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// BasicCopyTranslator a copy activity translator.
type BasicCopyTranslator interface {
	AsTabularTranslator() (*TabularTranslator, bool)
	AsCopyTranslator() (*CopyTranslator, bool)
}

// CopyTranslator a copy activity translator.
type CopyTranslator struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeCopyTranslator', 'TypeTabularTranslator'
	Type TypeBasicCopyTranslator `json:"type,omitempty"`
}

func unmarshalBasicCopyTranslator(body []byte) (BasicCopyTranslator, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeTabularTranslator):
		var tt TabularTranslator
		err := json.Unmarshal(body, &tt)
		return tt, err
	default:
		var ct CopyTranslator
		err := json.Unmarshal(body, &ct)
		return ct, err
	}
}
func unmarshalBasicCopyTranslatorArray(body []byte) ([]BasicCopyTranslator, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctArray := make([]BasicCopyTranslator, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ct, err := unmarshalBasicCopyTranslator(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctArray[index] = ct
	}
	return ctArray, nil
}

// MarshalJSON is the custom marshaler for CopyTranslator.
func (ct CopyTranslator) MarshalJSON() ([]byte, error) {
	ct.Type = TypeCopyTranslator
	type Alias CopyTranslator
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ct),
	})
}

// AsTabularTranslator is the BasicCopyTranslator implementation for CopyTranslator.
func (ct CopyTranslator) AsTabularTranslator() (*TabularTranslator, bool) {
	return nil, false
}

// AsCopyTranslator is the BasicCopyTranslator implementation for CopyTranslator.
func (ct CopyTranslator) AsCopyTranslator() (*CopyTranslator, bool) {
	return &ct, true
}

// AsBasicCopyTranslator is the BasicCopyTranslator implementation for CopyTranslator.
func (ct CopyTranslator) AsBasicCopyTranslator() (BasicCopyTranslator, bool) {
	return &ct, true
}

// CosmosDbLinkedService microsoft Azure Cosmos Database (CosmosDB) linked service.
type CosmosDbLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// CosmosDbLinkedServiceTypeProperties - CosmosDB linked service properties.
	*CosmosDbLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) MarshalJSON() ([]byte, error) {
	cdls.Type = TypeCosmosDb
	type Alias CosmosDbLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cdls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return &cdls, true
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CosmosDbLinkedService.
func (cdls CosmosDbLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cdls, true
}

// UnmarshalJSON is the custom unmarshaler for CosmosDbLinkedService struct.
func (cdls *CosmosDbLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CosmosDbLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		cdls.CosmosDbLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		cdls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cdls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cdls.Type = typeVar
	}

	return nil
}

// CosmosDbLinkedServiceTypeProperties cosmosDB linked service properties.
type CosmosDbLinkedServiceTypeProperties struct {
	// ConnectionString - The connection string.
	ConnectionString *SecureString `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// CouchbaseLinkedService couchbase server linked service.
type CouchbaseLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// CouchbaseLinkedServiceTypeProperties - Couchbase server linked service properties.
	*CouchbaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) MarshalJSON() ([]byte, error) {
	cls.Type = TypeCouchbase
	type Alias CouchbaseLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return &cls, true
}

// AsConcurLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CouchbaseLinkedService.
func (cls CouchbaseLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cls, true
}

// UnmarshalJSON is the custom unmarshaler for CouchbaseLinkedService struct.
func (cls *CouchbaseLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CouchbaseLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		cls.CouchbaseLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		cls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cls.Type = typeVar
	}

	return nil
}

// CouchbaseLinkedServiceTypeProperties couchbase server linked service properties.
type CouchbaseLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string.
	ConnectionString BasicSecretBase `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CouchbaseLinkedServiceTypeProperties struct.
func (clstp *CouchbaseLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["connectionString"]
	if v != nil {
		connectionString, err := unmarshalBasicSecretBase(*m["connectionString"])
		if err != nil {
			return err
		}
		clstp.ConnectionString = connectionString
	}

	v = m["encryptedCredential"]
	if v != nil {
		var encryptedCredential map[string]interface{}
		err = json.Unmarshal(*m["encryptedCredential"], &encryptedCredential)
		if err != nil {
			return err
		}
		clstp.EncryptedCredential = &encryptedCredential
	}

	return nil
}

// CouchbaseSource a copy activity Couchbase server source.
type CouchbaseSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseSource.
func (cs CouchbaseSource) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCouchbaseSource
	type Alias CouchbaseSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return &cs, true
}

// AsConcurSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for CouchbaseSource.
func (cs CouchbaseSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &cs, true
}

// CouchbaseTableDataset couchbase server dataset.
type CouchbaseTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) MarshalJSON() ([]byte, error) {
	ctd.Type = TypeCouchbaseTable
	type Alias CouchbaseTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ctd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return &ctd, true
}

// AsConcurObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CouchbaseTableDataset.
func (ctd CouchbaseTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ctd, true
}

// CreateRunResponse response body with a run identifier.
type CreateRunResponse struct {
	autorest.Response `json:"-"`
	// RunID - Identifier of a run.
	RunID *string `json:"runId,omitempty"`
}

// CustomActivity custom activity type.
type CustomActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// CustomActivityTypeProperties - Custom activity properties.
	*CustomActivityTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomActivity.
func (ca CustomActivity) MarshalJSON() ([]byte, error) {
	ca.Type = TypeCustom
	type Alias CustomActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ca),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return nil, false
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsCustomActivity() (*CustomActivity, bool) {
	return &ca, true
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &ca, true
}

// AsUntilActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for CustomActivity.
func (ca CustomActivity) AsBasicActivity() (BasicActivity, bool) {
	return &ca, true
}

// UnmarshalJSON is the custom unmarshaler for CustomActivity struct.
func (ca *CustomActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties CustomActivityTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ca.CustomActivityTypeProperties = &typeProperties
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ca.LinkedServiceName = &linkedServiceName
	}

	v = m["policy"]
	if v != nil {
		var policy ActivityPolicy
		err = json.Unmarshal(*m["policy"], &policy)
		if err != nil {
			return err
		}
		ca.Policy = &policy
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ca.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ca.Description = &description
	}

	v = m["dependsOn"]
	if v != nil {
		var dependsOn []ActivityDependency
		err = json.Unmarshal(*m["dependsOn"], &dependsOn)
		if err != nil {
			return err
		}
		ca.DependsOn = &dependsOn
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicActivity
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ca.Type = typeVar
	}

	return nil
}

// CustomActivityReferenceObject reference objects for custom activity
type CustomActivityReferenceObject struct {
	// LinkedServices - Linked service references.
	LinkedServices *[]LinkedServiceReference `json:"linkedServices,omitempty"`
	// Datasets - Dataset references.
	Datasets *[]DatasetReference `json:"datasets,omitempty"`
}

// CustomActivityTypeProperties custom activity properties.
type CustomActivityTypeProperties struct {
	// Command - Command for custom activity Type: string (or Expression with resultType string).
	Command *map[string]interface{} `json:"command,omitempty"`
	// ResourceLinkedService - Resource linked service reference.
	ResourceLinkedService *LinkedServiceReference `json:"resourceLinkedService,omitempty"`
	// FolderPath - Folder path for resource files Type: string (or Expression with resultType string).
	FolderPath *map[string]interface{} `json:"folderPath,omitempty"`
	// ReferenceObjects - Reference objects
	ReferenceObjects *CustomActivityReferenceObject `json:"referenceObjects,omitempty"`
	// ExtendedProperties - User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
	ExtendedProperties *map[string]*map[string]interface{} `json:"extendedProperties,omitempty"`
}

// CustomDataset the custom dataset.
type CustomDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// TypeProperties - Custom dataset properties.
	TypeProperties *map[string]interface{} `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDataset.
func (cd CustomDataset) MarshalJSON() ([]byte, error) {
	cd.Type = TypeCustomDataset
	type Alias CustomDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCustomDataset() (*CustomDataset, bool) {
	return &cd, true
}

// AsCassandraTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for CustomDataset.
func (cd CustomDataset) AsBasicDataset() (BasicDataset, bool) {
	return &cd, true
}

// CustomDataSourceLinkedService custom linked service.
type CustomDataSourceLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// TypeProperties - Custom linked service properties.
	TypeProperties *map[string]interface{} `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) MarshalJSON() ([]byte, error) {
	cdsls.Type = TypeCustomDataSource
	type Alias CustomDataSourceLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cdsls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return &cdsls, true
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for CustomDataSourceLinkedService.
func (cdsls CustomDataSourceLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &cdsls, true
}

// DataLakeAnalyticsUSQLActivity data Lake Analytics U-SQL activity.
type DataLakeAnalyticsUSQLActivity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Name - Activity name.
	Name *string `json:"name,omitempty"`
	// Description - Activity description.
	Description *string `json:"description,omitempty"`
	// DependsOn - Activity depends on condition.
	DependsOn *[]ActivityDependency `json:"dependsOn,omitempty"`
	// Type - Possible values include: 'TypeActivity', 'TypeDataLakeAnalyticsUSQL', 'TypeAzureMLUpdateResource', 'TypeAzureMLBatchExecution', 'TypeGetMetadata', 'TypeWebActivity', 'TypeLookup', 'TypeSQLServerStoredProcedure', 'TypeCustom', 'TypeExecuteSSISPackage', 'TypeHDInsightSpark', 'TypeHDInsightStreaming', 'TypeHDInsightMapReduce', 'TypeHDInsightPig', 'TypeHDInsightHive', 'TypeCopy', 'TypeExecution', 'TypeUntil', 'TypeWait', 'TypeForEach', 'TypeIfCondition', 'TypeExecutePipeline', 'TypeContainer'
	Type TypeBasicActivity `json:"type,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Policy - Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`
	// DataLakeAnalyticsUSQLActivityTypeProperties - Data Lake Analytics U-SQL activity properties.
	*DataLakeAnalyticsUSQLActivityTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) MarshalJSON() ([]byte, error) {
	dlaua.Type = TypeDataLakeAnalyticsUSQL
	type Alias DataLakeAnalyticsUSQLActivity
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dlaua),
	})
}

// AsDataLakeAnalyticsUSQLActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsDataLakeAnalyticsUSQLActivity() (*DataLakeAnalyticsUSQLActivity, bool) {
	return &dlaua, true
}

// AsAzureMLUpdateResourceActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsAzureMLUpdateResourceActivity() (*AzureMLUpdateResourceActivity, bool) {
	return nil, false
}

// AsAzureMLBatchExecutionActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsAzureMLBatchExecutionActivity() (*AzureMLBatchExecutionActivity, bool) {
	return nil, false
}

// AsGetMetadataActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsGetMetadataActivity() (*GetMetadataActivity, bool) {
	return nil, false
}

// AsWebActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsWebActivity() (*WebActivity, bool) {
	return nil, false
}

// AsLookupActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsLookupActivity() (*LookupActivity, bool) {
	return nil, false
}

// AsSQLServerStoredProcedureActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsSQLServerStoredProcedureActivity() (*SQLServerStoredProcedureActivity, bool) {
	return nil, false
}

// AsCustomActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsCustomActivity() (*CustomActivity, bool) {
	return nil, false
}

// AsExecuteSSISPackageActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsExecuteSSISPackageActivity() (*ExecuteSSISPackageActivity, bool) {
	return nil, false
}

// AsHDInsightSparkActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsHDInsightSparkActivity() (*HDInsightSparkActivity, bool) {
	return nil, false
}

// AsHDInsightStreamingActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsHDInsightStreamingActivity() (*HDInsightStreamingActivity, bool) {
	return nil, false
}

// AsHDInsightMapReduceActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsHDInsightMapReduceActivity() (*HDInsightMapReduceActivity, bool) {
	return nil, false
}

// AsHDInsightPigActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsHDInsightPigActivity() (*HDInsightPigActivity, bool) {
	return nil, false
}

// AsHDInsightHiveActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsHDInsightHiveActivity() (*HDInsightHiveActivity, bool) {
	return nil, false
}

// AsCopyActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsCopyActivity() (*CopyActivity, bool) {
	return nil, false
}

// AsExecutionActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsExecutionActivity() (*ExecutionActivity, bool) {
	return nil, false
}

// AsBasicExecutionActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsBasicExecutionActivity() (BasicExecutionActivity, bool) {
	return &dlaua, true
}

// AsUntilActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsUntilActivity() (*UntilActivity, bool) {
	return nil, false
}

// AsWaitActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsWaitActivity() (*WaitActivity, bool) {
	return nil, false
}

// AsForEachActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsForEachActivity() (*ForEachActivity, bool) {
	return nil, false
}

// AsIfConditionActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsIfConditionActivity() (*IfConditionActivity, bool) {
	return nil, false
}

// AsExecutePipelineActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsExecutePipelineActivity() (*ExecutePipelineActivity, bool) {
	return nil, false
}

// AsControlActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsControlActivity() (*ControlActivity, bool) {
	return nil, false
}

// AsBasicControlActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsBasicControlActivity() (BasicControlActivity, bool) {
	return nil, false
}

// AsActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsActivity() (*Activity, bool) {
	return nil, false
}

// AsBasicActivity is the BasicActivity implementation for DataLakeAnalyticsUSQLActivity.
func (dlaua DataLakeAnalyticsUSQLActivity) AsBasicActivity() (BasicActivity, bool) {
	return &dlaua, true
}

// UnmarshalJSON is the custom unmarshaler for DataLakeAnalyticsUSQLActivity struct.
func (dlaua *DataLakeAnalyticsUSQLActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties DataLakeAnalyticsUSQLActivityTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		dlaua.DataLakeAnalyticsUSQLActivityTypeProperties = &typeProperties
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		dlaua.LinkedServiceName = &linkedServiceName
	}

	v = m["policy"]
	if v != nil {
		var policy ActivityPolicy
		err = json.Unmarshal(*m["policy"], &policy)
		if err != nil {
			return err
		}
		dlaua.Policy = &policy
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		dlaua.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		dlaua.Description = &description
	}

	v = m["dependsOn"]
	if v != nil {
		var dependsOn []ActivityDependency
		err = json.Unmarshal(*m["dependsOn"], &dependsOn)
		if err != nil {
			return err
		}
		dlaua.DependsOn = &dependsOn
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicActivity
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		dlaua.Type = typeVar
	}

	return nil
}

// DataLakeAnalyticsUSQLActivityTypeProperties dataLakeAnalyticsU-SQL activity properties.
type DataLakeAnalyticsUSQLActivityTypeProperties struct {
	// ScriptPath - Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
	ScriptPath *map[string]interface{} `json:"scriptPath,omitempty"`
	// ScriptLinkedService - Script linked service reference.
	ScriptLinkedService *LinkedServiceReference `json:"scriptLinkedService,omitempty"`
	// DegreeOfParallelism - The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType integer), minimum: 1.
	DegreeOfParallelism *map[string]interface{} `json:"degreeOfParallelism,omitempty"`
	// Priority - Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the priority. Default value is 1000. Type: integer (or Expression with resultType integer), minimum: 1.
	Priority *map[string]interface{} `json:"priority,omitempty"`
	// Parameters - Parameters for U-SQL job request.
	Parameters *map[string]*map[string]interface{} `json:"parameters,omitempty"`
	// RuntimeVersion - Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
	RuntimeVersion *map[string]interface{} `json:"runtimeVersion,omitempty"`
	// CompilationMode - Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with resultType string).
	CompilationMode *map[string]interface{} `json:"compilationMode,omitempty"`
}

// BasicDataset the Azure Data Factory nested object which identifies data within different data stores, such as
// tables, files, folders, and documents.
type BasicDataset interface {
	AsZohoObjectDataset() (*ZohoObjectDataset, bool)
	AsXeroObjectDataset() (*XeroObjectDataset, bool)
	AsSquareObjectDataset() (*SquareObjectDataset, bool)
	AsSparkObjectDataset() (*SparkObjectDataset, bool)
	AsShopifyObjectDataset() (*ShopifyObjectDataset, bool)
	AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool)
	AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool)
	AsPrestoObjectDataset() (*PrestoObjectDataset, bool)
	AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool)
	AsPaypalObjectDataset() (*PaypalObjectDataset, bool)
	AsMarketoObjectDataset() (*MarketoObjectDataset, bool)
	AsMariaDBTableDataset() (*MariaDBTableDataset, bool)
	AsMagentoObjectDataset() (*MagentoObjectDataset, bool)
	AsJiraObjectDataset() (*JiraObjectDataset, bool)
	AsImpalaObjectDataset() (*ImpalaObjectDataset, bool)
	AsHubspotObjectDataset() (*HubspotObjectDataset, bool)
	AsHiveObjectDataset() (*HiveObjectDataset, bool)
	AsHBaseObjectDataset() (*HBaseObjectDataset, bool)
	AsGreenplumTableDataset() (*GreenplumTableDataset, bool)
	AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool)
	AsEloquaObjectDataset() (*EloquaObjectDataset, bool)
	AsDrillTableDataset() (*DrillTableDataset, bool)
	AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool)
	AsConcurObjectDataset() (*ConcurObjectDataset, bool)
	AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool)
	AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool)
	AsHTTPDataset() (*HTTPDataset, bool)
	AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool)
	AsWebTableDataset() (*WebTableDataset, bool)
	AsSQLServerTableDataset() (*SQLServerTableDataset, bool)
	AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool)
	AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool)
	AsRelationalTableDataset() (*RelationalTableDataset, bool)
	AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool)
	AsOracleTableDataset() (*OracleTableDataset, bool)
	AsODataResourceDataset() (*ODataResourceDataset, bool)
	AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool)
	AsFileShareDataset() (*FileShareDataset, bool)
	AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool)
	AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool)
	AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool)
	AsCustomDataset() (*CustomDataset, bool)
	AsCassandraTableDataset() (*CassandraTableDataset, bool)
	AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool)
	AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool)
	AsAzureTableDataset() (*AzureTableDataset, bool)
	AsAzureBlobDataset() (*AzureBlobDataset, bool)
	AsAmazonS3Dataset() (*AmazonS3Dataset, bool)
	AsDataset() (*Dataset, bool)
}

// Dataset the Azure Data Factory nested object which identifies data within different data stores, such as tables,
// files, folders, and documents.
type Dataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

func unmarshalBasicDataset(body []byte) (BasicDataset, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeZohoObject):
		var zod ZohoObjectDataset
		err := json.Unmarshal(body, &zod)
		return zod, err
	case string(TypeXeroObject):
		var xod XeroObjectDataset
		err := json.Unmarshal(body, &xod)
		return xod, err
	case string(TypeSquareObject):
		var sod SquareObjectDataset
		err := json.Unmarshal(body, &sod)
		return sod, err
	case string(TypeSparkObject):
		var sod SparkObjectDataset
		err := json.Unmarshal(body, &sod)
		return sod, err
	case string(TypeShopifyObject):
		var sod ShopifyObjectDataset
		err := json.Unmarshal(body, &sod)
		return sod, err
	case string(TypeServiceNowObject):
		var snod ServiceNowObjectDataset
		err := json.Unmarshal(body, &snod)
		return snod, err
	case string(TypeQuickBooksObject):
		var qbod QuickBooksObjectDataset
		err := json.Unmarshal(body, &qbod)
		return qbod, err
	case string(TypePrestoObject):
		var pod PrestoObjectDataset
		err := json.Unmarshal(body, &pod)
		return pod, err
	case string(TypePhoenixObject):
		var pod PhoenixObjectDataset
		err := json.Unmarshal(body, &pod)
		return pod, err
	case string(TypePaypalObject):
		var pod PaypalObjectDataset
		err := json.Unmarshal(body, &pod)
		return pod, err
	case string(TypeMarketoObject):
		var mod MarketoObjectDataset
		err := json.Unmarshal(body, &mod)
		return mod, err
	case string(TypeMariaDBTable):
		var mdtd MariaDBTableDataset
		err := json.Unmarshal(body, &mdtd)
		return mdtd, err
	case string(TypeMagentoObject):
		var mod MagentoObjectDataset
		err := json.Unmarshal(body, &mod)
		return mod, err
	case string(TypeJiraObject):
		var jod JiraObjectDataset
		err := json.Unmarshal(body, &jod)
		return jod, err
	case string(TypeImpalaObject):
		var iod ImpalaObjectDataset
		err := json.Unmarshal(body, &iod)
		return iod, err
	case string(TypeHubspotObject):
		var hod HubspotObjectDataset
		err := json.Unmarshal(body, &hod)
		return hod, err
	case string(TypeHiveObject):
		var hod HiveObjectDataset
		err := json.Unmarshal(body, &hod)
		return hod, err
	case string(TypeHBaseObject):
		var hbod HBaseObjectDataset
		err := json.Unmarshal(body, &hbod)
		return hbod, err
	case string(TypeGreenplumTable):
		var gtd GreenplumTableDataset
		err := json.Unmarshal(body, &gtd)
		return gtd, err
	case string(TypeGoogleBigQueryObject):
		var gbqod GoogleBigQueryObjectDataset
		err := json.Unmarshal(body, &gbqod)
		return gbqod, err
	case string(TypeEloquaObject):
		var eod EloquaObjectDataset
		err := json.Unmarshal(body, &eod)
		return eod, err
	case string(TypeDrillTable):
		var dtd DrillTableDataset
		err := json.Unmarshal(body, &dtd)
		return dtd, err
	case string(TypeCouchbaseTable):
		var ctd CouchbaseTableDataset
		err := json.Unmarshal(body, &ctd)
		return ctd, err
	case string(TypeConcurObject):
		var cod ConcurObjectDataset
		err := json.Unmarshal(body, &cod)
		return cod, err
	case string(TypeAzurePostgreSQLTable):
		var apstd AzurePostgreSQLTableDataset
		err := json.Unmarshal(body, &apstd)
		return apstd, err
	case string(TypeAmazonMWSObject):
		var amod AmazonMWSObjectDataset
		err := json.Unmarshal(body, &amod)
		return amod, err
	case string(TypeHTTPFile):
		var hd HTTPDataset
		err := json.Unmarshal(body, &hd)
		return hd, err
	case string(TypeAzureSearchIndex):
		var asid AzureSearchIndexDataset
		err := json.Unmarshal(body, &asid)
		return asid, err
	case string(TypeWebTable):
		var wtd WebTableDataset
		err := json.Unmarshal(body, &wtd)
		return wtd, err
	case string(TypeSQLServerTable):
		var sstd SQLServerTableDataset
		err := json.Unmarshal(body, &sstd)
		return sstd, err
	case string(TypeSapCloudForCustomerResource):
		var scfcrd SapCloudForCustomerResourceDataset
		err := json.Unmarshal(body, &scfcrd)
		return scfcrd, err
	case string(TypeSalesforceObject):
		var sod SalesforceObjectDataset
		err := json.Unmarshal(body, &sod)
		return sod, err
	case string(TypeRelationalTable):
		var rtd RelationalTableDataset
		err := json.Unmarshal(body, &rtd)
		return rtd, err
	case string(TypeAzureMySQLTable):
		var amstd AzureMySQLTableDataset
		err := json.Unmarshal(body, &amstd)
		return amstd, err
	case string(TypeOracleTable):
		var otd OracleTableDataset
		err := json.Unmarshal(body, &otd)
		return otd, err
	case string(TypeODataResource):
		var odrd ODataResourceDataset
		err := json.Unmarshal(body, &odrd)
		return odrd, err
	case string(TypeMongoDbCollection):
		var mdcd MongoDbCollectionDataset
		err := json.Unmarshal(body, &mdcd)
		return mdcd, err
	case string(TypeFileShare):
		var fsd FileShareDataset
		err := json.Unmarshal(body, &fsd)
		return fsd, err
	case string(TypeAzureDataLakeStoreFile):
		var adlsd AzureDataLakeStoreDataset
		err := json.Unmarshal(body, &adlsd)
		return adlsd, err
	case string(TypeDynamicsEntity):
		var ded DynamicsEntityDataset
		err := json.Unmarshal(body, &ded)
		return ded, err
	case string(TypeDocumentDbCollection):
		var ddcd DocumentDbCollectionDataset
		err := json.Unmarshal(body, &ddcd)
		return ddcd, err
	case string(TypeCustomDataset):
		var cd CustomDataset
		err := json.Unmarshal(body, &cd)
		return cd, err
	case string(TypeCassandraTable):
		var ctd CassandraTableDataset
		err := json.Unmarshal(body, &ctd)
		return ctd, err
	case string(TypeAzureSQLDWTable):
		var asdtd AzureSQLDWTableDataset
		err := json.Unmarshal(body, &asdtd)
		return asdtd, err
	case string(TypeAzureSQLTable):
		var astd AzureSQLTableDataset
		err := json.Unmarshal(body, &astd)
		return astd, err
	case string(TypeAzureTable):
		var atd AzureTableDataset
		err := json.Unmarshal(body, &atd)
		return atd, err
	case string(TypeAzureBlob):
		var abd AzureBlobDataset
		err := json.Unmarshal(body, &abd)
		return abd, err
	case string(TypeAmazonS3Object):
		var asd AmazonS3Dataset
		err := json.Unmarshal(body, &asd)
		return asd, err
	default:
		var d Dataset
		err := json.Unmarshal(body, &d)
		return d, err
	}
}
func unmarshalBasicDatasetArray(body []byte) ([]BasicDataset, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dArray := make([]BasicDataset, len(rawMessages))

	for index, rawMessage := range rawMessages {
		d, err := unmarshalBasicDataset(*rawMessage)
		if err != nil {
			return nil, err
		}
		dArray[index] = d
	}
	return dArray, nil
}

// MarshalJSON is the custom marshaler for Dataset.
func (d Dataset) MarshalJSON() ([]byte, error) {
	d.Type = TypeDataset
	type Alias Dataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(d),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsDataset() (*Dataset, bool) {
	return &d, true
}

// AsBasicDataset is the BasicDataset implementation for Dataset.
func (d Dataset) AsBasicDataset() (BasicDataset, bool) {
	return &d, true
}

// DatasetBZip2Compression the BZip2 compression method used on a dataset.
type DatasetBZip2Compression struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeDatasetCompression', 'TypeZipDeflate', 'TypeDeflate', 'TypeGZip', 'TypeBZip2'
	Type TypeBasicDatasetCompression `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) MarshalJSON() ([]byte, error) {
	dbz2c.Type = TypeBZip2
	type Alias DatasetBZip2Compression
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dbz2c),
	})
}

// AsDatasetZipDeflateCompression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool) {
	return nil, false
}

// AsDatasetDeflateCompression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool) {
	return nil, false
}

// AsDatasetGZipCompression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsDatasetGZipCompression() (*DatasetGZipCompression, bool) {
	return nil, false
}

// AsDatasetBZip2Compression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool) {
	return &dbz2c, true
}

// AsDatasetCompression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsDatasetCompression() (*DatasetCompression, bool) {
	return nil, false
}

// AsBasicDatasetCompression is the BasicDatasetCompression implementation for DatasetBZip2Compression.
func (dbz2c DatasetBZip2Compression) AsBasicDatasetCompression() (BasicDatasetCompression, bool) {
	return &dbz2c, true
}

// BasicDatasetCompression the compression method used on a dataset.
type BasicDatasetCompression interface {
	AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool)
	AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool)
	AsDatasetGZipCompression() (*DatasetGZipCompression, bool)
	AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool)
	AsDatasetCompression() (*DatasetCompression, bool)
}

// DatasetCompression the compression method used on a dataset.
type DatasetCompression struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeDatasetCompression', 'TypeZipDeflate', 'TypeDeflate', 'TypeGZip', 'TypeBZip2'
	Type TypeBasicDatasetCompression `json:"type,omitempty"`
}

func unmarshalBasicDatasetCompression(body []byte) (BasicDatasetCompression, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeZipDeflate):
		var dzdc DatasetZipDeflateCompression
		err := json.Unmarshal(body, &dzdc)
		return dzdc, err
	case string(TypeDeflate):
		var ddc DatasetDeflateCompression
		err := json.Unmarshal(body, &ddc)
		return ddc, err
	case string(TypeGZip):
		var dgzc DatasetGZipCompression
		err := json.Unmarshal(body, &dgzc)
		return dgzc, err
	case string(TypeBZip2):
		var dbz2c DatasetBZip2Compression
		err := json.Unmarshal(body, &dbz2c)
		return dbz2c, err
	default:
		var dc DatasetCompression
		err := json.Unmarshal(body, &dc)
		return dc, err
	}
}
func unmarshalBasicDatasetCompressionArray(body []byte) ([]BasicDatasetCompression, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dcArray := make([]BasicDatasetCompression, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dc, err := unmarshalBasicDatasetCompression(*rawMessage)
		if err != nil {
			return nil, err
		}
		dcArray[index] = dc
	}
	return dcArray, nil
}

// MarshalJSON is the custom marshaler for DatasetCompression.
func (dc DatasetCompression) MarshalJSON() ([]byte, error) {
	dc.Type = TypeDatasetCompression
	type Alias DatasetCompression
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dc),
	})
}

// AsDatasetZipDeflateCompression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool) {
	return nil, false
}

// AsDatasetDeflateCompression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool) {
	return nil, false
}

// AsDatasetGZipCompression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsDatasetGZipCompression() (*DatasetGZipCompression, bool) {
	return nil, false
}

// AsDatasetBZip2Compression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool) {
	return nil, false
}

// AsDatasetCompression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsDatasetCompression() (*DatasetCompression, bool) {
	return &dc, true
}

// AsBasicDatasetCompression is the BasicDatasetCompression implementation for DatasetCompression.
func (dc DatasetCompression) AsBasicDatasetCompression() (BasicDatasetCompression, bool) {
	return &dc, true
}

// DatasetDeflateCompression the Deflate compression method used on a dataset.
type DatasetDeflateCompression struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeDatasetCompression', 'TypeZipDeflate', 'TypeDeflate', 'TypeGZip', 'TypeBZip2'
	Type TypeBasicDatasetCompression `json:"type,omitempty"`
	// Level - The Deflate compression level. Possible values include: 'Optimal', 'Fastest'
	Level DatasetCompressionLevel `json:"level,omitempty"`
}

// MarshalJSON is the custom marshaler for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) MarshalJSON() ([]byte, error) {
	ddc.Type = TypeDeflate
	type Alias DatasetDeflateCompression
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddc),
	})
}

// AsDatasetZipDeflateCompression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool) {
	return nil, false
}

// AsDatasetDeflateCompression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool) {
	return &ddc, true
}

// AsDatasetGZipCompression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsDatasetGZipCompression() (*DatasetGZipCompression, bool) {
	return nil, false
}

// AsDatasetBZip2Compression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool) {
	return nil, false
}

// AsDatasetCompression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsDatasetCompression() (*DatasetCompression, bool) {
	return nil, false
}

// AsBasicDatasetCompression is the BasicDatasetCompression implementation for DatasetDeflateCompression.
func (ddc DatasetDeflateCompression) AsBasicDatasetCompression() (BasicDatasetCompression, bool) {
	return &ddc, true
}

// DatasetGZipCompression the GZip compression method used on a dataset.
type DatasetGZipCompression struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeDatasetCompression', 'TypeZipDeflate', 'TypeDeflate', 'TypeGZip', 'TypeBZip2'
	Type TypeBasicDatasetCompression `json:"type,omitempty"`
	// Level - The GZip compression level. Possible values include: 'Optimal', 'Fastest'
	Level DatasetCompressionLevel `json:"level,omitempty"`
}

// MarshalJSON is the custom marshaler for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) MarshalJSON() ([]byte, error) {
	dgzc.Type = TypeGZip
	type Alias DatasetGZipCompression
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dgzc),
	})
}

// AsDatasetZipDeflateCompression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool) {
	return nil, false
}

// AsDatasetDeflateCompression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool) {
	return nil, false
}

// AsDatasetGZipCompression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsDatasetGZipCompression() (*DatasetGZipCompression, bool) {
	return &dgzc, true
}

// AsDatasetBZip2Compression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool) {
	return nil, false
}

// AsDatasetCompression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsDatasetCompression() (*DatasetCompression, bool) {
	return nil, false
}

// AsBasicDatasetCompression is the BasicDatasetCompression implementation for DatasetGZipCompression.
func (dgzc DatasetGZipCompression) AsBasicDatasetCompression() (BasicDatasetCompression, bool) {
	return &dgzc, true
}

// DatasetListResponse a list of dataset resources.
type DatasetListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of datasets.
	Value *[]DatasetResource `json:"value,omitempty"`
	// NextLink - The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatasetListResponseIterator provides access to a complete listing of DatasetResource values.
type DatasetListResponseIterator struct {
	i    int
	page DatasetListResponsePage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatasetListResponseIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatasetListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatasetListResponseIterator) Response() DatasetListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatasetListResponseIterator) Value() DatasetResource {
	if !iter.page.NotDone() {
		return DatasetResource{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DatasetListResponse) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// datasetListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DatasetListResponse) datasetListResponsePreparer() (*http.Request, error) {
	if dlr.NextLink == nil || len(to.String(dlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DatasetListResponsePage contains a page of DatasetResource values.
type DatasetListResponsePage struct {
	fn  func(DatasetListResponse) (DatasetListResponse, error)
	dlr DatasetListResponse
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatasetListResponsePage) Next() error {
	next, err := page.fn(page.dlr)
	if err != nil {
		return err
	}
	page.dlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatasetListResponsePage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatasetListResponsePage) Response() DatasetListResponse {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatasetListResponsePage) Values() []DatasetResource {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// DatasetReference dataset reference type.
type DatasetReference struct {
	// Type - Dataset reference type.
	Type *string `json:"type,omitempty"`
	// ReferenceName - Reference dataset name.
	ReferenceName *string `json:"referenceName,omitempty"`
	// Parameters - Arguments for dataset.
	Parameters *map[string]*map[string]interface{} `json:"parameters,omitempty"`
}

// DatasetResource dataset resource type.
type DatasetResource struct {
	autorest.Response `json:"-"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Etag - Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty"`
	// Properties - Dataset properties.
	Properties BasicDataset `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DatasetResource struct.
func (dr *DatasetResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalBasicDataset(*m["properties"])
		if err != nil {
			return err
		}
		dr.Properties = properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		dr.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		dr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		dr.Type = &typeVar
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		dr.Etag = &etag
	}

	return nil
}

// BasicDatasetStorageFormat the format definition of a storage.
type BasicDatasetStorageFormat interface {
	AsParquetFormat() (*ParquetFormat, bool)
	AsOrcFormat() (*OrcFormat, bool)
	AsAvroFormat() (*AvroFormat, bool)
	AsJSONFormat() (*JSONFormat, bool)
	AsTextFormat() (*TextFormat, bool)
	AsDatasetStorageFormat() (*DatasetStorageFormat, bool)
}

// DatasetStorageFormat the format definition of a storage.
type DatasetStorageFormat struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Serializer - Serializer. Type: string (or Expression with resultType string).
	Serializer *map[string]interface{} `json:"serializer,omitempty"`
	// Deserializer - Deserializer. Type: string (or Expression with resultType string).
	Deserializer *map[string]interface{} `json:"deserializer,omitempty"`
	// Type - Possible values include: 'TypeDatasetStorageFormat', 'TypeParquetFormat', 'TypeOrcFormat', 'TypeAvroFormat', 'TypeJSONFormat', 'TypeTextFormat'
	Type TypeBasicDatasetStorageFormat `json:"type,omitempty"`
}

func unmarshalBasicDatasetStorageFormat(body []byte) (BasicDatasetStorageFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeParquetFormat):
		var pf ParquetFormat
		err := json.Unmarshal(body, &pf)
		return pf, err
	case string(TypeOrcFormat):
		var of OrcFormat
		err := json.Unmarshal(body, &of)
		return of, err
	case string(TypeAvroFormat):
		var af AvroFormat
		err := json.Unmarshal(body, &af)
		return af, err
	case string(TypeJSONFormat):
		var jf JSONFormat
		err := json.Unmarshal(body, &jf)
		return jf, err
	case string(TypeTextFormat):
		var tf TextFormat
		err := json.Unmarshal(body, &tf)
		return tf, err
	default:
		var dsf DatasetStorageFormat
		err := json.Unmarshal(body, &dsf)
		return dsf, err
	}
}
func unmarshalBasicDatasetStorageFormatArray(body []byte) ([]BasicDatasetStorageFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dsfArray := make([]BasicDatasetStorageFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dsf, err := unmarshalBasicDatasetStorageFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		dsfArray[index] = dsf
	}
	return dsfArray, nil
}

// MarshalJSON is the custom marshaler for DatasetStorageFormat.
func (dsf DatasetStorageFormat) MarshalJSON() ([]byte, error) {
	dsf.Type = TypeDatasetStorageFormat
	type Alias DatasetStorageFormat
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dsf),
	})
}

// AsParquetFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsParquetFormat() (*ParquetFormat, bool) {
	return nil, false
}

// AsOrcFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsOrcFormat() (*OrcFormat, bool) {
	return nil, false
}

// AsAvroFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsAvroFormat() (*AvroFormat, bool) {
	return nil, false
}

// AsJSONFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsJSONFormat() (*JSONFormat, bool) {
	return nil, false
}

// AsTextFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsTextFormat() (*TextFormat, bool) {
	return nil, false
}

// AsDatasetStorageFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsDatasetStorageFormat() (*DatasetStorageFormat, bool) {
	return &dsf, true
}

// AsBasicDatasetStorageFormat is the BasicDatasetStorageFormat implementation for DatasetStorageFormat.
func (dsf DatasetStorageFormat) AsBasicDatasetStorageFormat() (BasicDatasetStorageFormat, bool) {
	return &dsf, true
}

// DatasetZipDeflateCompression the ZipDeflate compression method used on a dataset.
type DatasetZipDeflateCompression struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Type - Possible values include: 'TypeDatasetCompression', 'TypeZipDeflate', 'TypeDeflate', 'TypeGZip', 'TypeBZip2'
	Type TypeBasicDatasetCompression `json:"type,omitempty"`
	// Level - The ZipDeflate compression level. Possible values include: 'Optimal', 'Fastest'
	Level DatasetCompressionLevel `json:"level,omitempty"`
}

// MarshalJSON is the custom marshaler for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) MarshalJSON() ([]byte, error) {
	dzdc.Type = TypeZipDeflate
	type Alias DatasetZipDeflateCompression
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dzdc),
	})
}

// AsDatasetZipDeflateCompression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsDatasetZipDeflateCompression() (*DatasetZipDeflateCompression, bool) {
	return &dzdc, true
}

// AsDatasetDeflateCompression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsDatasetDeflateCompression() (*DatasetDeflateCompression, bool) {
	return nil, false
}

// AsDatasetGZipCompression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsDatasetGZipCompression() (*DatasetGZipCompression, bool) {
	return nil, false
}

// AsDatasetBZip2Compression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsDatasetBZip2Compression() (*DatasetBZip2Compression, bool) {
	return nil, false
}

// AsDatasetCompression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsDatasetCompression() (*DatasetCompression, bool) {
	return nil, false
}

// AsBasicDatasetCompression is the BasicDatasetCompression implementation for DatasetZipDeflateCompression.
func (dzdc DatasetZipDeflateCompression) AsBasicDatasetCompression() (BasicDatasetCompression, bool) {
	return &dzdc, true
}

// Db2LinkedService linked service for DB2 data source.
type Db2LinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// Db2LinkedServiceTypeProperties - DB2 linked service properties.
	*Db2LinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for Db2LinkedService.
func (d2ls Db2LinkedService) MarshalJSON() ([]byte, error) {
	d2ls.Type = TypeDb2
	type Alias Db2LinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(d2ls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return &d2ls, true
}

// AsSybaseLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for Db2LinkedService.
func (d2ls Db2LinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &d2ls, true
}

// UnmarshalJSON is the custom unmarshaler for Db2LinkedService struct.
func (d2ls *Db2LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties Db2LinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		d2ls.Db2LinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		d2ls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		d2ls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		d2ls.Type = typeVar
	}

	return nil
}

// Db2LinkedServiceTypeProperties dB2 linked service properties.
type Db2LinkedServiceTypeProperties struct {
	// Server - Server name for connection. Type: string (or Expression with resultType string).
	Server *map[string]interface{} `json:"server,omitempty"`
	// Database - Database name for connection. Type: string (or Expression with resultType string).
	Database *map[string]interface{} `json:"database,omitempty"`
	// Schema - Schema name for connection. Type: string (or Expression with resultType string).
	Schema *map[string]interface{} `json:"schema,omitempty"`
	// AuthenticationType - AuthenticationType to be used for connection. Possible values include: 'Basic'
	AuthenticationType Db2AuthenticationType `json:"authenticationType,omitempty"`
	// Username - Username for authentication. Type: string (or Expression with resultType string).
	Username *map[string]interface{} `json:"username,omitempty"`
	// Password - Password for authentication.
	Password *SecureString `json:"password,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// DistcpSettings distcp settings.
type DistcpSettings struct {
	// ResourceManagerEndpoint - Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
	ResourceManagerEndpoint *map[string]interface{} `json:"resourceManagerEndpoint,omitempty"`
	// TempScriptPath - Specifies an existing folder path which will be used to store temp Distcp command script. The script file is generated by ADF and will be removed after Copy job finished. Type: string (or Expression with resultType string).
	TempScriptPath *map[string]interface{} `json:"tempScriptPath,omitempty"`
	// DistcpOptions - Specifies the Distcp options. Type: string (or Expression with resultType string).
	DistcpOptions *map[string]interface{} `json:"distcpOptions,omitempty"`
}

// DocumentDbCollectionDataset microsoft Azure Document Database Collection dataset.
type DocumentDbCollectionDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// DocumentDbCollectionDatasetTypeProperties - DocumentDB Collection dataset properties.
	*DocumentDbCollectionDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) MarshalJSON() ([]byte, error) {
	ddcd.Type = TypeDocumentDbCollection
	type Alias DocumentDbCollectionDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddcd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return &ddcd, true
}

// AsCustomDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for DocumentDbCollectionDataset.
func (ddcd DocumentDbCollectionDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ddcd, true
}

// UnmarshalJSON is the custom unmarshaler for DocumentDbCollectionDataset struct.
func (ddcd *DocumentDbCollectionDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties DocumentDbCollectionDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ddcd.DocumentDbCollectionDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ddcd.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		ddcd.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ddcd.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		ddcd.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ddcd.Type = typeVar
	}

	return nil
}

// DocumentDbCollectionDatasetTypeProperties documentDB Collection dataset properties.
type DocumentDbCollectionDatasetTypeProperties struct {
	// CollectionName - Document Database collection name. Type: string (or Expression with resultType string).
	CollectionName *map[string]interface{} `json:"collectionName,omitempty"`
}

// DocumentDbCollectionSink a copy activity Document Database Collection sink.
type DocumentDbCollectionSink struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// WriteBatchSize - Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize *map[string]interface{} `json:"writeBatchSize,omitempty"`
	// WriteBatchTimeout - Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout *map[string]interface{} `json:"writeBatchTimeout,omitempty"`
	// SinkRetryCount - Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount *map[string]interface{} `json:"sinkRetryCount,omitempty"`
	// SinkRetryWait - Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait *map[string]interface{} `json:"sinkRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySink', 'TypeSalesforceSink', 'TypeDynamicsSink', 'TypeOdbcSink', 'TypeAzureSearchIndexSink', 'TypeAzureDataLakeStoreSink', 'TypeOracleSink', 'TypeSQLDWSink', 'TypeSQLSink', 'TypeDocumentDbCollectionSink', 'TypeFileSystemSink', 'TypeBlobSink', 'TypeAzureTableSink', 'TypeAzureQueueSink', 'TypeSapCloudForCustomerSink'
	Type TypeBasicCopySink `json:"type,omitempty"`
	// NestingSeparator - Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
	NestingSeparator *map[string]interface{} `json:"nestingSeparator,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) MarshalJSON() ([]byte, error) {
	ddcs.Type = TypeDocumentDbCollectionSink
	type Alias DocumentDbCollectionSink
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddcs),
	})
}

// AsSalesforceSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsSalesforceSink() (*SalesforceSink, bool) {
	return nil, false
}

// AsDynamicsSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsDynamicsSink() (*DynamicsSink, bool) {
	return nil, false
}

// AsOdbcSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsOdbcSink() (*OdbcSink, bool) {
	return nil, false
}

// AsAzureSearchIndexSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsAzureSearchIndexSink() (*AzureSearchIndexSink, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsAzureDataLakeStoreSink() (*AzureDataLakeStoreSink, bool) {
	return nil, false
}

// AsOracleSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsOracleSink() (*OracleSink, bool) {
	return nil, false
}

// AsSQLDWSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsSQLDWSink() (*SQLDWSink, bool) {
	return nil, false
}

// AsSQLSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsSQLSink() (*SQLSink, bool) {
	return nil, false
}

// AsDocumentDbCollectionSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsDocumentDbCollectionSink() (*DocumentDbCollectionSink, bool) {
	return &ddcs, true
}

// AsFileSystemSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsFileSystemSink() (*FileSystemSink, bool) {
	return nil, false
}

// AsBlobSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsBlobSink() (*BlobSink, bool) {
	return nil, false
}

// AsAzureTableSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsAzureTableSink() (*AzureTableSink, bool) {
	return nil, false
}

// AsAzureQueueSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsAzureQueueSink() (*AzureQueueSink, bool) {
	return nil, false
}

// AsSapCloudForCustomerSink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsSapCloudForCustomerSink() (*SapCloudForCustomerSink, bool) {
	return nil, false
}

// AsCopySink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsCopySink() (*CopySink, bool) {
	return nil, false
}

// AsBasicCopySink is the BasicCopySink implementation for DocumentDbCollectionSink.
func (ddcs DocumentDbCollectionSink) AsBasicCopySink() (BasicCopySink, bool) {
	return &ddcs, true
}

// DocumentDbCollectionSource a copy activity Document Database Collection source.
type DocumentDbCollectionSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - Documents query. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
	// NestingSeparator - Nested properties separator. Type: string (or Expression with resultType string).
	NestingSeparator *map[string]interface{} `json:"nestingSeparator,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) MarshalJSON() ([]byte, error) {
	ddcs.Type = TypeDocumentDbCollectionSource
	type Alias DocumentDbCollectionSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddcs),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsDrillSource() (*DrillSource, bool) {
	return nil, false
}

// AsCouchbaseSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return &ddcs, true
}

// AsBlobSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for DocumentDbCollectionSource.
func (ddcs DocumentDbCollectionSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ddcs, true
}

// DrillLinkedService drill server linked service.
type DrillLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// DrillLinkedServiceTypeProperties - Drill server linked service properties.
	*DrillLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for DrillLinkedService.
func (dls DrillLinkedService) MarshalJSON() ([]byte, error) {
	dls.Type = TypeDrill
	type Alias DrillLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return &dls, true
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsWebLinkedService() (*WebLinkedService, bool) {
	return nil, false
}

// AsODataLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsODataLinkedService() (*ODataLinkedService, bool) {
	return nil, false
}

// AsHdfsLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHdfsLinkedService() (*HdfsLinkedService, bool) {
	return nil, false
}

// AsOdbcLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsOdbcLinkedService() (*OdbcLinkedService, bool) {
	return nil, false
}

// AsAzureMLLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureMLLinkedService() (*AzureMLLinkedService, bool) {
	return nil, false
}

// AsTeradataLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsTeradataLinkedService() (*TeradataLinkedService, bool) {
	return nil, false
}

// AsDb2LinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsDb2LinkedService() (*Db2LinkedService, bool) {
	return nil, false
}

// AsSybaseLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSybaseLinkedService() (*SybaseLinkedService, bool) {
	return nil, false
}

// AsPostgreSQLLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsPostgreSQLLinkedService() (*PostgreSQLLinkedService, bool) {
	return nil, false
}

// AsMySQLLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsMySQLLinkedService() (*MySQLLinkedService, bool) {
	return nil, false
}

// AsAzureMySQLLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureMySQLLinkedService() (*AzureMySQLLinkedService, bool) {
	return nil, false
}

// AsOracleLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsOracleLinkedService() (*OracleLinkedService, bool) {
	return nil, false
}

// AsFileServerLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsFileServerLinkedService() (*FileServerLinkedService, bool) {
	return nil, false
}

// AsHDInsightLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsHDInsightLinkedService() (*HDInsightLinkedService, bool) {
	return nil, false
}

// AsDynamicsLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsDynamicsLinkedService() (*DynamicsLinkedService, bool) {
	return nil, false
}

// AsCosmosDbLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsCosmosDbLinkedService() (*CosmosDbLinkedService, bool) {
	return nil, false
}

// AsAzureKeyVaultLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureKeyVaultLinkedService() (*AzureKeyVaultLinkedService, bool) {
	return nil, false
}

// AsAzureBatchLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureBatchLinkedService() (*AzureBatchLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDatabaseLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureSQLDatabaseLinkedService() (*AzureSQLDatabaseLinkedService, bool) {
	return nil, false
}

// AsSQLServerLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsSQLServerLinkedService() (*SQLServerLinkedService, bool) {
	return nil, false
}

// AsAzureSQLDWLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureSQLDWLinkedService() (*AzureSQLDWLinkedService, bool) {
	return nil, false
}

// AsAzureStorageLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsAzureStorageLinkedService() (*AzureStorageLinkedService, bool) {
	return nil, false
}

// AsLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsLinkedService() (*LinkedService, bool) {
	return nil, false
}

// AsBasicLinkedService is the BasicLinkedService implementation for DrillLinkedService.
func (dls DrillLinkedService) AsBasicLinkedService() (BasicLinkedService, bool) {
	return &dls, true
}

// UnmarshalJSON is the custom unmarshaler for DrillLinkedService struct.
func (dls *DrillLinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties DrillLinkedServiceTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		dls.DrillLinkedServiceTypeProperties = &typeProperties
	}

	v = m["connectVia"]
	if v != nil {
		var connectVia IntegrationRuntimeReference
		err = json.Unmarshal(*m["connectVia"], &connectVia)
		if err != nil {
			return err
		}
		dls.ConnectVia = &connectVia
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		dls.Description = &description
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicLinkedService
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		dls.Type = typeVar
	}

	return nil
}

// DrillLinkedServiceTypeProperties drill server linked service properties.
type DrillLinkedServiceTypeProperties struct {
	// ConnectionString - An ODBC connection string.
	ConnectionString BasicSecretBase `json:"connectionString,omitempty"`
	// EncryptedCredential - The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string).
	EncryptedCredential *map[string]interface{} `json:"encryptedCredential,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DrillLinkedServiceTypeProperties struct.
func (dlstp *DrillLinkedServiceTypeProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["connectionString"]
	if v != nil {
		connectionString, err := unmarshalBasicSecretBase(*m["connectionString"])
		if err != nil {
			return err
		}
		dlstp.ConnectionString = connectionString
	}

	v = m["encryptedCredential"]
	if v != nil {
		var encryptedCredential map[string]interface{}
		err = json.Unmarshal(*m["encryptedCredential"], &encryptedCredential)
		if err != nil {
			return err
		}
		dlstp.EncryptedCredential = &encryptedCredential
	}

	return nil
}

// DrillSource a copy activity Drill server source.
type DrillSource struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// SourceRetryCount - Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount *map[string]interface{} `json:"sourceRetryCount,omitempty"`
	// SourceRetryWait - Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait *map[string]interface{} `json:"sourceRetryWait,omitempty"`
	// Type - Possible values include: 'TypeCopySource', 'TypeAmazonRedshiftSource', 'TypeZohoSource', 'TypeXeroSource', 'TypeSquareSource', 'TypeSparkSource', 'TypeShopifySource', 'TypeServiceNowSource', 'TypeQuickBooksSource', 'TypePrestoSource', 'TypePhoenixSource', 'TypePaypalSource', 'TypeMarketoSource', 'TypeMariaDBSource', 'TypeMagentoSource', 'TypeJiraSource', 'TypeImpalaSource', 'TypeHubspotSource', 'TypeHiveSource', 'TypeHBaseSource', 'TypeGreenplumSource', 'TypeGoogleBigQuerySource', 'TypeEloquaSource', 'TypeDrillSource', 'TypeCouchbaseSource', 'TypeConcurSource', 'TypeAzurePostgreSQLSource', 'TypeAmazonMWSSource', 'TypeHTTPSource', 'TypeAzureDataLakeStoreSource', 'TypeMongoDbSource', 'TypeCassandraSource', 'TypeWebSource', 'TypeOracleSource', 'TypeAzureMySQLSource', 'TypeHdfsSource', 'TypeFileSystemSource', 'TypeSQLDWSource', 'TypeSQLSource', 'TypeSapCloudForCustomerSource', 'TypeSalesforceSource', 'TypeRelationalSource', 'TypeDynamicsSource', 'TypeDocumentDbCollectionSource', 'TypeBlobSource', 'TypeAzureTableSource'
	Type TypeBasicCopySource `json:"type,omitempty"`
	// Query - A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query *map[string]interface{} `json:"query,omitempty"`
}

// MarshalJSON is the custom marshaler for DrillSource.
func (ds DrillSource) MarshalJSON() ([]byte, error) {
	ds.Type = TypeDrillSource
	type Alias DrillSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ds),
	})
}

// AsAmazonRedshiftSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAmazonRedshiftSource() (*AmazonRedshiftSource, bool) {
	return nil, false
}

// AsZohoSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsZohoSource() (*ZohoSource, bool) {
	return nil, false
}

// AsXeroSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsXeroSource() (*XeroSource, bool) {
	return nil, false
}

// AsSquareSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSquareSource() (*SquareSource, bool) {
	return nil, false
}

// AsSparkSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSparkSource() (*SparkSource, bool) {
	return nil, false
}

// AsShopifySource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsShopifySource() (*ShopifySource, bool) {
	return nil, false
}

// AsServiceNowSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsServiceNowSource() (*ServiceNowSource, bool) {
	return nil, false
}

// AsQuickBooksSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsQuickBooksSource() (*QuickBooksSource, bool) {
	return nil, false
}

// AsPrestoSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsPrestoSource() (*PrestoSource, bool) {
	return nil, false
}

// AsPhoenixSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsPhoenixSource() (*PhoenixSource, bool) {
	return nil, false
}

// AsPaypalSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsPaypalSource() (*PaypalSource, bool) {
	return nil, false
}

// AsMarketoSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsMarketoSource() (*MarketoSource, bool) {
	return nil, false
}

// AsMariaDBSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsMariaDBSource() (*MariaDBSource, bool) {
	return nil, false
}

// AsMagentoSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsMagentoSource() (*MagentoSource, bool) {
	return nil, false
}

// AsJiraSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsJiraSource() (*JiraSource, bool) {
	return nil, false
}

// AsImpalaSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsImpalaSource() (*ImpalaSource, bool) {
	return nil, false
}

// AsHubspotSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsHubspotSource() (*HubspotSource, bool) {
	return nil, false
}

// AsHiveSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsHiveSource() (*HiveSource, bool) {
	return nil, false
}

// AsHBaseSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsHBaseSource() (*HBaseSource, bool) {
	return nil, false
}

// AsGreenplumSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsGreenplumSource() (*GreenplumSource, bool) {
	return nil, false
}

// AsGoogleBigQuerySource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsGoogleBigQuerySource() (*GoogleBigQuerySource, bool) {
	return nil, false
}

// AsEloquaSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsEloquaSource() (*EloquaSource, bool) {
	return nil, false
}

// AsDrillSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsDrillSource() (*DrillSource, bool) {
	return &ds, true
}

// AsCouchbaseSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsCouchbaseSource() (*CouchbaseSource, bool) {
	return nil, false
}

// AsConcurSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsConcurSource() (*ConcurSource, bool) {
	return nil, false
}

// AsAzurePostgreSQLSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAzurePostgreSQLSource() (*AzurePostgreSQLSource, bool) {
	return nil, false
}

// AsAmazonMWSSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAmazonMWSSource() (*AmazonMWSSource, bool) {
	return nil, false
}

// AsHTTPSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsHTTPSource() (*HTTPSource, bool) {
	return nil, false
}

// AsAzureDataLakeStoreSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAzureDataLakeStoreSource() (*AzureDataLakeStoreSource, bool) {
	return nil, false
}

// AsMongoDbSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsMongoDbSource() (*MongoDbSource, bool) {
	return nil, false
}

// AsCassandraSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsCassandraSource() (*CassandraSource, bool) {
	return nil, false
}

// AsWebSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsWebSource() (*WebSource, bool) {
	return nil, false
}

// AsOracleSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsOracleSource() (*OracleSource, bool) {
	return nil, false
}

// AsAzureMySQLSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAzureMySQLSource() (*AzureMySQLSource, bool) {
	return nil, false
}

// AsHdfsSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsHdfsSource() (*HdfsSource, bool) {
	return nil, false
}

// AsFileSystemSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsFileSystemSource() (*FileSystemSource, bool) {
	return nil, false
}

// AsSQLDWSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSQLDWSource() (*SQLDWSource, bool) {
	return nil, false
}

// AsSQLSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSQLSource() (*SQLSource, bool) {
	return nil, false
}

// AsSapCloudForCustomerSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSapCloudForCustomerSource() (*SapCloudForCustomerSource, bool) {
	return nil, false
}

// AsSalesforceSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsSalesforceSource() (*SalesforceSource, bool) {
	return nil, false
}

// AsRelationalSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsRelationalSource() (*RelationalSource, bool) {
	return nil, false
}

// AsDynamicsSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsDynamicsSource() (*DynamicsSource, bool) {
	return nil, false
}

// AsDocumentDbCollectionSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsDocumentDbCollectionSource() (*DocumentDbCollectionSource, bool) {
	return nil, false
}

// AsBlobSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsBlobSource() (*BlobSource, bool) {
	return nil, false
}

// AsAzureTableSource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsAzureTableSource() (*AzureTableSource, bool) {
	return nil, false
}

// AsCopySource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsCopySource() (*CopySource, bool) {
	return nil, false
}

// AsBasicCopySource is the BasicCopySource implementation for DrillSource.
func (ds DrillSource) AsBasicCopySource() (BasicCopySource, bool) {
	return &ds, true
}

// DrillTableDataset drill server dataset.
type DrillTableDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DrillTableDataset.
func (dtd DrillTableDataset) MarshalJSON() ([]byte, error) {
	dtd.Type = TypeDrillTable
	type Alias DrillTableDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dtd),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return &dtd, true
}

// AsCouchbaseTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return nil, false
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for DrillTableDataset.
func (dtd DrillTableDataset) AsBasicDataset() (BasicDataset, bool) {
	return &dtd, true
}

// DynamicsEntityDataset the Dynamics entity dataset.
type DynamicsEntityDataset struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Description - Dataset description.
	Description *string `json:"description,omitempty"`
	// Structure - Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure *map[string]interface{} `json:"structure,omitempty"`
	// LinkedServiceName - Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
	// Parameters - Parameters for dataset.
	Parameters *map[string]*ParameterSpecification `json:"parameters,omitempty"`
	// Type - Possible values include: 'TypeDataset', 'TypeZohoObject', 'TypeXeroObject', 'TypeSquareObject', 'TypeSparkObject', 'TypeShopifyObject', 'TypeServiceNowObject', 'TypeQuickBooksObject', 'TypePrestoObject', 'TypePhoenixObject', 'TypePaypalObject', 'TypeMarketoObject', 'TypeMariaDBTable', 'TypeMagentoObject', 'TypeJiraObject', 'TypeImpalaObject', 'TypeHubspotObject', 'TypeHiveObject', 'TypeHBaseObject', 'TypeGreenplumTable', 'TypeGoogleBigQueryObject', 'TypeEloquaObject', 'TypeDrillTable', 'TypeCouchbaseTable', 'TypeConcurObject', 'TypeAzurePostgreSQLTable', 'TypeAmazonMWSObject', 'TypeHTTPFile', 'TypeAzureSearchIndex', 'TypeWebTable', 'TypeSQLServerTable', 'TypeSapCloudForCustomerResource', 'TypeSalesforceObject', 'TypeRelationalTable', 'TypeAzureMySQLTable', 'TypeOracleTable', 'TypeODataResource', 'TypeMongoDbCollection', 'TypeFileShare', 'TypeAzureDataLakeStoreFile', 'TypeDynamicsEntity', 'TypeDocumentDbCollection', 'TypeCustomDataset', 'TypeCassandraTable', 'TypeAzureSQLDWTable', 'TypeAzureSQLTable', 'TypeAzureTable', 'TypeAzureBlob', 'TypeAmazonS3Object'
	Type TypeBasicDataset `json:"type,omitempty"`
	// DynamicsEntityDatasetTypeProperties - Dynamics entity dataset properties.
	*DynamicsEntityDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) MarshalJSON() ([]byte, error) {
	ded.Type = TypeDynamicsEntity
	type Alias DynamicsEntityDataset
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ded),
	})
}

// AsZohoObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsZohoObjectDataset() (*ZohoObjectDataset, bool) {
	return nil, false
}

// AsXeroObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsXeroObjectDataset() (*XeroObjectDataset, bool) {
	return nil, false
}

// AsSquareObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsSquareObjectDataset() (*SquareObjectDataset, bool) {
	return nil, false
}

// AsSparkObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsSparkObjectDataset() (*SparkObjectDataset, bool) {
	return nil, false
}

// AsShopifyObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsShopifyObjectDataset() (*ShopifyObjectDataset, bool) {
	return nil, false
}

// AsServiceNowObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsServiceNowObjectDataset() (*ServiceNowObjectDataset, bool) {
	return nil, false
}

// AsQuickBooksObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsQuickBooksObjectDataset() (*QuickBooksObjectDataset, bool) {
	return nil, false
}

// AsPrestoObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsPrestoObjectDataset() (*PrestoObjectDataset, bool) {
	return nil, false
}

// AsPhoenixObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsPhoenixObjectDataset() (*PhoenixObjectDataset, bool) {
	return nil, false
}

// AsPaypalObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsPaypalObjectDataset() (*PaypalObjectDataset, bool) {
	return nil, false
}

// AsMarketoObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsMarketoObjectDataset() (*MarketoObjectDataset, bool) {
	return nil, false
}

// AsMariaDBTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsMariaDBTableDataset() (*MariaDBTableDataset, bool) {
	return nil, false
}

// AsMagentoObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsMagentoObjectDataset() (*MagentoObjectDataset, bool) {
	return nil, false
}

// AsJiraObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsJiraObjectDataset() (*JiraObjectDataset, bool) {
	return nil, false
}

// AsImpalaObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsImpalaObjectDataset() (*ImpalaObjectDataset, bool) {
	return nil, false
}

// AsHubspotObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsHubspotObjectDataset() (*HubspotObjectDataset, bool) {
	return nil, false
}

// AsHiveObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsHiveObjectDataset() (*HiveObjectDataset, bool) {
	return nil, false
}

// AsHBaseObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsHBaseObjectDataset() (*HBaseObjectDataset, bool) {
	return nil, false
}

// AsGreenplumTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsGreenplumTableDataset() (*GreenplumTableDataset, bool) {
	return nil, false
}

// AsGoogleBigQueryObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsGoogleBigQueryObjectDataset() (*GoogleBigQueryObjectDataset, bool) {
	return nil, false
}

// AsEloquaObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsEloquaObjectDataset() (*EloquaObjectDataset, bool) {
	return nil, false
}

// AsDrillTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsDrillTableDataset() (*DrillTableDataset, bool) {
	return nil, false
}

// AsCouchbaseTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsCouchbaseTableDataset() (*CouchbaseTableDataset, bool) {
	return nil, false
}

// AsConcurObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsConcurObjectDataset() (*ConcurObjectDataset, bool) {
	return nil, false
}

// AsAzurePostgreSQLTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzurePostgreSQLTableDataset() (*AzurePostgreSQLTableDataset, bool) {
	return nil, false
}

// AsAmazonMWSObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAmazonMWSObjectDataset() (*AmazonMWSObjectDataset, bool) {
	return nil, false
}

// AsHTTPDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsHTTPDataset() (*HTTPDataset, bool) {
	return nil, false
}

// AsAzureSearchIndexDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureSearchIndexDataset() (*AzureSearchIndexDataset, bool) {
	return nil, false
}

// AsWebTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsWebTableDataset() (*WebTableDataset, bool) {
	return nil, false
}

// AsSQLServerTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsSQLServerTableDataset() (*SQLServerTableDataset, bool) {
	return nil, false
}

// AsSapCloudForCustomerResourceDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsSapCloudForCustomerResourceDataset() (*SapCloudForCustomerResourceDataset, bool) {
	return nil, false
}

// AsSalesforceObjectDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsSalesforceObjectDataset() (*SalesforceObjectDataset, bool) {
	return nil, false
}

// AsRelationalTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsRelationalTableDataset() (*RelationalTableDataset, bool) {
	return nil, false
}

// AsAzureMySQLTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureMySQLTableDataset() (*AzureMySQLTableDataset, bool) {
	return nil, false
}

// AsOracleTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsOracleTableDataset() (*OracleTableDataset, bool) {
	return nil, false
}

// AsODataResourceDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsODataResourceDataset() (*ODataResourceDataset, bool) {
	return nil, false
}

// AsMongoDbCollectionDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsMongoDbCollectionDataset() (*MongoDbCollectionDataset, bool) {
	return nil, false
}

// AsFileShareDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsFileShareDataset() (*FileShareDataset, bool) {
	return nil, false
}

// AsAzureDataLakeStoreDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureDataLakeStoreDataset() (*AzureDataLakeStoreDataset, bool) {
	return nil, false
}

// AsDynamicsEntityDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsDynamicsEntityDataset() (*DynamicsEntityDataset, bool) {
	return &ded, true
}

// AsDocumentDbCollectionDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsDocumentDbCollectionDataset() (*DocumentDbCollectionDataset, bool) {
	return nil, false
}

// AsCustomDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsCustomDataset() (*CustomDataset, bool) {
	return nil, false
}

// AsCassandraTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsCassandraTableDataset() (*CassandraTableDataset, bool) {
	return nil, false
}

// AsAzureSQLDWTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureSQLDWTableDataset() (*AzureSQLDWTableDataset, bool) {
	return nil, false
}

// AsAzureSQLTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureSQLTableDataset() (*AzureSQLTableDataset, bool) {
	return nil, false
}

// AsAzureTableDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureTableDataset() (*AzureTableDataset, bool) {
	return nil, false
}

// AsAzureBlobDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAzureBlobDataset() (*AzureBlobDataset, bool) {
	return nil, false
}

// AsAmazonS3Dataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsAmazonS3Dataset() (*AmazonS3Dataset, bool) {
	return nil, false
}

// AsDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsDataset() (*Dataset, bool) {
	return nil, false
}

// AsBasicDataset is the BasicDataset implementation for DynamicsEntityDataset.
func (ded DynamicsEntityDataset) AsBasicDataset() (BasicDataset, bool) {
	return &ded, true
}

// UnmarshalJSON is the custom unmarshaler for DynamicsEntityDataset struct.
func (ded *DynamicsEntityDataset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["typeProperties"]
	if v != nil {
		var typeProperties DynamicsEntityDatasetTypeProperties
		err = json.Unmarshal(*m["typeProperties"], &typeProperties)
		if err != nil {
			return err
		}
		ded.DynamicsEntityDatasetTypeProperties = &typeProperties
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ded.Description = &description
	}

	v = m["structure"]
	if v != nil {
		var structure map[string]interface{}
		err = json.Unmarshal(*m["structure"], &structure)
		if err != nil {
			return err
		}
		ded.Structure = &structure
	}

	v = m["linkedServiceName"]
	if v != nil {
		var linkedServiceName LinkedServiceReference
		err = json.Unmarshal(*m["linkedServiceName"], &linkedServiceName)
		if err != nil {
			return err
		}
		ded.LinkedServiceName = &linkedServiceName
	}

	v = m["parameters"]
	if v != nil {
		var parameters map[string]*ParameterSpecification
		err = json.Unmarshal(*m["parameters"], &parameters)
		if err != nil {
			return err
		}
		ded.Parameters = &parameters
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeBasicDataset
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		ded.Type = typeVar
	}

	return nil
}

// DynamicsEntityDatasetTypeProperties dynamics entity dataset properties.
type DynamicsEntityDatasetTypeProperties struct {
	// EntityName - The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName *map[string]interface{} `json:"entityName,omitempty"`
}

// DynamicsLinkedService dynamics linked service.
type DynamicsLinkedService struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// ConnectVia - The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`
	// Description - Linked service description.
	Description *string `json:"description,omitempty"`
	// Type - Possible values include: 'TypeLinkedService', 'TypeAzureDataLakeAnalytics', 'TypeHDInsightOnDemand', 'TypeZoho', 'TypeXero', 'TypeSquare', 'TypeSpark', 'TypeShopify', 'TypeServiceNow', 'TypeQuickBooks', 'TypePresto', 'TypePhoenix', 'TypePaypal', 'TypeMarketo', 'TypeMariaDB', 'TypeMagento', 'TypeJira', 'TypeImpala', 'TypeHubspot', 'TypeHive', 'TypeHBase', 'TypeGreenplum', 'TypeGoogleBigQuery', 'TypeEloqua', 'TypeDrill', 'TypeCouchbase', 'TypeConcur', 'TypeAzurePostgreSQL', 'TypeAmazonMWS', 'TypeSapHana', 'TypeSapBW', 'TypeSftp', 'TypeFtpServer', 'TypeHTTPServer', 'TypeAzureSearch', 'TypeCustomDataSource', 'TypeAmazonRedshift', 'TypeAmazonS3', 'TypeSapCloudForCustomer', 'TypeSalesforce', 'TypeAzureDataLakeStore', 'TypeMongoDb', 'TypeCassandra', 'TypeWeb', 'TypeOData', 'TypeHdfs', 'TypeOdbc', 'TypeAzureML', 'TypeTeradata', 'TypeDb2', 'TypeSybase', 'TypePostgreSQL', 'TypeMySQL', 'TypeAzureMySQL', 'TypeOracle', 'TypeFileServer', 'TypeHDInsight', 'TypeDynamics', 'TypeCosmosDb', 'TypeAzureKeyVault', 'TypeAzureBatch', 'TypeAzureSQLDatabase', 'TypeSQLServer', 'TypeAzureSQLDW', 'TypeAzureStorage'
	Type TypeBasicLinkedService `json:"type,omitempty"`
	// DynamicsLinkedServiceTypeProperties - Dynamics linked service properties.
	*DynamicsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for DynamicsLinkedService.
func (dls DynamicsLinkedService) MarshalJSON() ([]byte, error) {
	dls.Type = TypeDynamics
	type Alias DynamicsLinkedService
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dls),
	})
}

// AsAzureDataLakeAnalyticsLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAzureDataLakeAnalyticsLinkedService() (*AzureDataLakeAnalyticsLinkedService, bool) {
	return nil, false
}

// AsHDInsightOnDemandLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsHDInsightOnDemandLinkedService() (*HDInsightOnDemandLinkedService, bool) {
	return nil, false
}

// AsZohoLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsZohoLinkedService() (*ZohoLinkedService, bool) {
	return nil, false
}

// AsXeroLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsXeroLinkedService() (*XeroLinkedService, bool) {
	return nil, false
}

// AsSquareLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSquareLinkedService() (*SquareLinkedService, bool) {
	return nil, false
}

// AsSparkLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSparkLinkedService() (*SparkLinkedService, bool) {
	return nil, false
}

// AsShopifyLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsShopifyLinkedService() (*ShopifyLinkedService, bool) {
	return nil, false
}

// AsServiceNowLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsServiceNowLinkedService() (*ServiceNowLinkedService, bool) {
	return nil, false
}

// AsQuickBooksLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsQuickBooksLinkedService() (*QuickBooksLinkedService, bool) {
	return nil, false
}

// AsPrestoLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsPrestoLinkedService() (*PrestoLinkedService, bool) {
	return nil, false
}

// AsPhoenixLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsPhoenixLinkedService() (*PhoenixLinkedService, bool) {
	return nil, false
}

// AsPaypalLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsPaypalLinkedService() (*PaypalLinkedService, bool) {
	return nil, false
}

// AsMarketoLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsMarketoLinkedService() (*MarketoLinkedService, bool) {
	return nil, false
}

// AsMariaDBLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsMariaDBLinkedService() (*MariaDBLinkedService, bool) {
	return nil, false
}

// AsMagentoLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsMagentoLinkedService() (*MagentoLinkedService, bool) {
	return nil, false
}

// AsJiraLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsJiraLinkedService() (*JiraLinkedService, bool) {
	return nil, false
}

// AsImpalaLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsImpalaLinkedService() (*ImpalaLinkedService, bool) {
	return nil, false
}

// AsHubspotLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsHubspotLinkedService() (*HubspotLinkedService, bool) {
	return nil, false
}

// AsHiveLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsHiveLinkedService() (*HiveLinkedService, bool) {
	return nil, false
}

// AsHBaseLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsHBaseLinkedService() (*HBaseLinkedService, bool) {
	return nil, false
}

// AsGreenplumLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsGreenplumLinkedService() (*GreenplumLinkedService, bool) {
	return nil, false
}

// AsGoogleBigQueryLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsGoogleBigQueryLinkedService() (*GoogleBigQueryLinkedService, bool) {
	return nil, false
}

// AsEloquaLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsEloquaLinkedService() (*EloquaLinkedService, bool) {
	return nil, false
}

// AsDrillLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsDrillLinkedService() (*DrillLinkedService, bool) {
	return nil, false
}

// AsCouchbaseLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsCouchbaseLinkedService() (*CouchbaseLinkedService, bool) {
	return nil, false
}

// AsConcurLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsConcurLinkedService() (*ConcurLinkedService, bool) {
	return nil, false
}

// AsAzurePostgreSQLLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAzurePostgreSQLLinkedService() (*AzurePostgreSQLLinkedService, bool) {
	return nil, false
}

// AsAmazonMWSLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAmazonMWSLinkedService() (*AmazonMWSLinkedService, bool) {
	return nil, false
}

// AsSapHanaLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSapHanaLinkedService() (*SapHanaLinkedService, bool) {
	return nil, false
}

// AsSapBWLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSapBWLinkedService() (*SapBWLinkedService, bool) {
	return nil, false
}

// AsSftpServerLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSftpServerLinkedService() (*SftpServerLinkedService, bool) {
	return nil, false
}

// AsFtpServerLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsFtpServerLinkedService() (*FtpServerLinkedService, bool) {
	return nil, false
}

// AsHTTPLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsHTTPLinkedService() (*HTTPLinkedService, bool) {
	return nil, false
}

// AsAzureSearchLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAzureSearchLinkedService() (*AzureSearchLinkedService, bool) {
	return nil, false
}

// AsCustomDataSourceLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsCustomDataSourceLinkedService() (*CustomDataSourceLinkedService, bool) {
	return nil, false
}

// AsAmazonRedshiftLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAmazonRedshiftLinkedService() (*AmazonRedshiftLinkedService, bool) {
	return nil, false
}

// AsAmazonS3LinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAmazonS3LinkedService() (*AmazonS3LinkedService, bool) {
	return nil, false
}

// AsSapCloudForCustomerLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSapCloudForCustomerLinkedService() (*SapCloudForCustomerLinkedService, bool) {
	return nil, false
}

// AsSalesforceLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsSalesforceLinkedService() (*SalesforceLinkedService, bool) {
	return nil, false
}

// AsAzureDataLakeStoreLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsAzureDataLakeStoreLinkedService() (*AzureDataLakeStoreLinkedService, bool) {
	return nil, false
}

// AsMongoDbLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsMongoDbLinkedService() (*MongoDbLinkedService, bool) {
	return nil, false
}

// AsCassandraLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsCassandraLinkedService() (*CassandraLinkedService, bool) {
	return nil, false
}

// AsWebLinkedService is the BasicLinkedService implementation for DynamicsLinkedService.
func (dls DynamicsLinkedService) AsWebLink