package containerservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// OrchestratorTypes enumerates the values for orchestrator types.
type OrchestratorTypes string

const (
	// Custom ...
	Custom OrchestratorTypes = "Custom"
	// DCOS ...
	DCOS OrchestratorTypes = "DCOS"
	// DockerCE ...
	DockerCE OrchestratorTypes = "DockerCE"
	// Kubernetes ...
	Kubernetes OrchestratorTypes = "Kubernetes"
	// Swarm ...
	Swarm OrchestratorTypes = "Swarm"
)

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "Linux"
	// Windows ...
	Windows OSType = "Windows"
)

// StorageProfileTypes enumerates the values for storage profile types.
type StorageProfileTypes string

const (
	// ManagedDisks ...
	ManagedDisks StorageProfileTypes = "ManagedDisks"
	// StorageAccount ...
	StorageAccount StorageProfileTypes = "StorageAccount"
)

// VMSizeTypes enumerates the values for vm size types.
type VMSizeTypes string

const (
	// StandardA0 ...
	StandardA0 VMSizeTypes = "Standard_A0"
	// StandardA1 ...
	StandardA1 VMSizeTypes = "Standard_A1"
	// StandardA10 ...
	StandardA10 VMSizeTypes = "Standard_A10"
	// StandardA11 ...
	StandardA11 VMSizeTypes = "Standard_A11"
	// StandardA1V2 ...
	StandardA1V2 VMSizeTypes = "Standard_A1_v2"
	// StandardA2 ...
	StandardA2 VMSizeTypes = "Standard_A2"
	// StandardA2mV2 ...
	StandardA2mV2 VMSizeTypes = "Standard_A2m_v2"
	// StandardA2V2 ...
	StandardA2V2 VMSizeTypes = "Standard_A2_v2"
	// StandardA3 ...
	StandardA3 VMSizeTypes = "Standard_A3"
	// StandardA4 ...
	StandardA4 VMSizeTypes = "Standard_A4"
	// StandardA4mV2 ...
	StandardA4mV2 VMSizeTypes = "Standard_A4m_v2"
	// StandardA4V2 ...
	StandardA4V2 VMSizeTypes = "Standard_A4_v2"
	// StandardA5 ...
	StandardA5 VMSizeTypes = "Standard_A5"
	// StandardA6 ...
	StandardA6 VMSizeTypes = "Standard_A6"
	// StandardA7 ...
	StandardA7 VMSizeTypes = "Standard_A7"
	// StandardA8 ...
	StandardA8 VMSizeTypes = "Standard_A8"
	// StandardA8mV2 ...
	StandardA8mV2 VMSizeTypes = "Standard_A8m_v2"
	// StandardA8V2 ...
	StandardA8V2 VMSizeTypes = "Standard_A8_v2"
	// StandardA9 ...
	StandardA9 VMSizeTypes = "Standard_A9"
	// StandardD1 ...
	StandardD1 VMSizeTypes = "Standard_D1"
	// StandardD11 ...
	StandardD11 VMSizeTypes = "Standard_D11"
	// StandardD11V2 ...
	StandardD11V2 VMSizeTypes = "Standard_D11_v2"
	// StandardD11V2Promo ...
	StandardD11V2Promo VMSizeTypes = "Standard_D11_v2_Promo"
	// StandardD12 ...
	StandardD12 VMSizeTypes = "Standard_D12"
	// StandardD12V2 ...
	StandardD12V2 VMSizeTypes = "Standard_D12_v2"
	// StandardD12V2Promo ...
	StandardD12V2Promo VMSizeTypes = "Standard_D12_v2_Promo"
	// StandardD13 ...
	StandardD13 VMSizeTypes = "Standard_D13"
	// StandardD13V2 ...
	StandardD13V2 VMSizeTypes = "Standard_D13_v2"
	// StandardD13V2Promo ...
	StandardD13V2Promo VMSizeTypes = "Standard_D13_v2_Promo"
	// StandardD14 ...
	StandardD14 VMSizeTypes = "Standard_D14"
	// StandardD14V2 ...
	StandardD14V2 VMSizeTypes = "Standard_D14_v2"
	// StandardD14V2Promo ...
	StandardD14V2Promo VMSizeTypes = "Standard_D14_v2_Promo"
	// StandardD15V2 ...
	StandardD15V2 VMSizeTypes = "Standard_D15_v2"
	// StandardD16sV3 ...
	StandardD16sV3 VMSizeTypes = "Standard_D16s_v3"
	// StandardD16V3 ...
	StandardD16V3 VMSizeTypes = "Standard_D16_v3"
	// StandardD1V2 ...
	StandardD1V2 VMSizeTypes = "Standard_D1_v2"
	// StandardD2 ...
	StandardD2 VMSizeTypes = "Standard_D2"
	// StandardD2sV3 ...
	StandardD2sV3 VMSizeTypes = "Standard_D2s_v3"
	// StandardD2V2 ...
	StandardD2V2 VMSizeTypes = "Standard_D2_v2"
	// StandardD2V2Promo ...
	StandardD2V2Promo VMSizeTypes = "Standard_D2_v2_Promo"
	// StandardD2V3 ...
	StandardD2V3 VMSizeTypes = "Standard_D2_v3"
	// StandardD3 ...
	StandardD3 VMSizeTypes = "Standard_D3"
	// StandardD3V2 ...
	StandardD3V2 VMSizeTypes = "Standard_D3_v2"
	// StandardD3V2Promo ...
	StandardD3V2Promo VMSizeTypes = "Standard_D3_v2_Promo"
	// StandardD4 ...
	StandardD4 VMSizeTypes = "Standard_D4"
	// StandardD4sV3 ...
	StandardD4sV3 VMSizeTypes = "Standard_D4s_v3"
	// StandardD4V2 ...
	StandardD4V2 VMSizeTypes = "Standard_D4_v2"
	// StandardD4V2Promo ...
	StandardD4V2Promo VMSizeTypes = "Standard_D4_v2_Promo"
	// StandardD4V3 ...
	StandardD4V3 VMSizeTypes = "Standard_D4_v3"
	// StandardD5V2 ...
	StandardD5V2 VMSizeTypes = "Standard_D5_v2"
	// StandardD5V2Promo ...
	StandardD5V2Promo VMSizeTypes = "Standard_D5_v2_Promo"
	// StandardD8sV3 ...
	StandardD8sV3 VMSizeTypes = "Standard_D8s_v3"
	// StandardD8V3 ...
	StandardD8V3 VMSizeTypes = "Standard_D8_v3"
	// StandardDS1 ...
	StandardDS1 VMSizeTypes = "Standard_DS1"
	// StandardDS11 ...
	StandardDS11 VMSizeTypes = "Standard_DS11"
	// StandardDS11V2 ...
	StandardDS11V2 VMSizeTypes = "Standard_DS11_v2"
	// StandardDS11V2Promo ...
	StandardDS11V2Promo VMSizeTypes = "Standard_DS11_v2_Promo"
	// StandardDS12 ...
	StandardDS12 VMSizeTypes = "Standard_DS12"
	// StandardDS12V2 ...
	StandardDS12V2 VMSizeTypes = "Standard_DS12_v2"
	// StandardDS12V2Promo ...
	StandardDS12V2Promo VMSizeTypes = "Standard_DS12_v2_Promo"
	// StandardDS13 ...
	StandardDS13 VMSizeTypes = "Standard_DS13"
	// StandardDS13V2 ...
	StandardDS13V2 VMSizeTypes = "Standard_DS13_v2"
	// StandardDS13V2Promo ...
	StandardDS13V2Promo VMSizeTypes = "Standard_DS13_v2_Promo"
	// StandardDS14 ...
	StandardDS14 VMSizeTypes = "Standard_DS14"
	// StandardDS14V2 ...
	StandardDS14V2 VMSizeTypes = "Standard_DS14_v2"
	// StandardDS14V2Promo ...
	StandardDS14V2Promo VMSizeTypes = "Standard_DS14_v2_Promo"
	// StandardDS15V2 ...
	StandardDS15V2 VMSizeTypes = "Standard_DS15_v2"
	// StandardDS1V2 ...
	StandardDS1V2 VMSizeTypes = "Standard_DS1_v2"
	// StandardDS2 ...
	StandardDS2 VMSizeTypes = "Standard_DS2"
	// StandardDS2V2 ...
	StandardDS2V2 VMSizeTypes = "Standard_DS2_v2"
	// StandardDS2V2Promo ...
	StandardDS2V2Promo VMSizeTypes = "Standard_DS2_v2_Promo"
	// StandardDS3 ...
	StandardDS3 VMSizeTypes = "Standard_DS3"
	// StandardDS3V2 ...
	StandardDS3V2 VMSizeTypes = "Standard_DS3_v2"
	// StandardDS3V2Promo ...
	StandardDS3V2Promo VMSizeTypes = "Standard_DS3_v2_Promo"
	// StandardDS4 ...
	StandardDS4 VMSizeTypes = "Standard_DS4"
	// StandardDS4V2 ...
	StandardDS4V2 VMSizeTypes = "Standard_DS4_v2"
	// StandardDS4V2Promo ...
	StandardDS4V2Promo VMSizeTypes = "Standard_DS4_v2_Promo"
	// StandardDS5V2 ...
	StandardDS5V2 VMSizeTypes = "Standard_DS5_v2"
	// StandardDS5V2Promo ...
	StandardDS5V2Promo VMSizeTypes = "Standard_DS5_v2_Promo"
	// StandardE16sV3 ...
	StandardE16sV3 VMSizeTypes = "Standard_E16s_v3"
	// StandardE16V3 ...
	StandardE16V3 VMSizeTypes = "Standard_E16_v3"
	// StandardE2sV3 ...
	StandardE2sV3 VMSizeTypes = "Standard_E2s_v3"
	// StandardE2V3 ...
	StandardE2V3 VMSizeTypes = "Standard_E2_v3"
	// StandardE32sV3 ...
	StandardE32sV3 VMSizeTypes = "Standard_E32s_v3"
	// StandardE32V3 ...
	StandardE32V3 VMSizeTypes = "Standard_E32_v3"
	// StandardE4sV3 ...
	StandardE4sV3 VMSizeTypes = "Standard_E4s_v3"
	// StandardE4V3 ...
	StandardE4V3 VMSizeTypes = "Standard_E4_v3"
	// StandardE64sV3 ...
	StandardE64sV3 VMSizeTypes = "Standard_E64s_v3"
	// StandardE64V3 ...
	StandardE64V3 VMSizeTypes = "Standard_E64_v3"
	// StandardE8sV3 ...
	StandardE8sV3 VMSizeTypes = "Standard_E8s_v3"
	// StandardE8V3 ...
	StandardE8V3 VMSizeTypes = "Standard_E8_v3"
	// StandardF1 ...
	StandardF1 VMSizeTypes = "Standard_F1"
	// StandardF16 ...
	StandardF16 VMSizeTypes = "Standard_F16"
	// StandardF16s ...
	StandardF16s VMSizeTypes = "Standard_F16s"
	// StandardF1s ...
	StandardF1s VMSizeTypes = "Standard_F1s"
	// StandardF2 ...
	StandardF2 VMSizeTypes = "Standard_F2"
	// StandardF2s ...
	StandardF2s VMSizeTypes = "Standard_F2s"
	// StandardF4 ...
	StandardF4 VMSizeTypes = "Standard_F4"
	// StandardF4s ...
	StandardF4s VMSizeTypes = "Standard_F4s"
	// StandardF8 ...
	StandardF8 VMSizeTypes = "Standard_F8"
	// StandardF8s ...
	StandardF8s VMSizeTypes = "Standard_F8s"
	// StandardG1 ...
	StandardG1 VMSizeTypes = "Standard_G1"
	// StandardG2 ...
	StandardG2 VMSizeTypes = "Standard_G2"
	// StandardG3 ...
	StandardG3 VMSizeTypes = "Standard_G3"
	// StandardG4 ...
	StandardG4 VMSizeTypes = "Standard_G4"
	// StandardG5 ...
	StandardG5 VMSizeTypes = "Standard_G5"
	// StandardGS1 ...
	StandardGS1 VMSizeTypes = "Standard_GS1"
	// StandardGS2 ...
	StandardGS2 VMSizeTypes = "Standard_GS2"
	// StandardGS3 ...
	StandardGS3 VMSizeTypes = "Standard_GS3"
	// StandardGS4 ...
	StandardGS4 VMSizeTypes = "Standard_GS4"
	// StandardGS5 ...
	StandardGS5 VMSizeTypes = "Standard_GS5"
	// StandardH16 ...
	StandardH16 VMSizeTypes = "Standard_H16"
	// StandardH16m ...
	StandardH16m VMSizeTypes = "Standard_H16m"
	// StandardH16mr ...
	StandardH16mr VMSizeTypes = "Standard_H16mr"
	// StandardH16r ...
	StandardH16r VMSizeTypes = "Standard_H16r"
	// StandardH8 ...
	StandardH8 VMSizeTypes = "Standard_H8"
	// StandardH8m ...
	StandardH8m VMSizeTypes = "Standard_H8m"
	// StandardL16s ...
	StandardL16s VMSizeTypes = "Standard_L16s"
	// StandardL32s ...
	StandardL32s VMSizeTypes = "Standard_L32s"
	// StandardL4s ...
	StandardL4s VMSizeTypes = "Standard_L4s"
	// StandardL8s ...
	StandardL8s VMSizeTypes = "Standard_L8s"
	// StandardM128s ...
	StandardM128s VMSizeTypes = "Standard_M128s"
	// StandardM64ms ...
	StandardM64ms VMSizeTypes = "Standard_M64ms"
	// StandardNC12 ...
	StandardNC12 VMSizeTypes = "Standard_NC12"
	// StandardNC24 ...
	StandardNC24 VMSizeTypes = "Standard_NC24"
	// StandardNC24r ...
	StandardNC24r VMSizeTypes = "Standard_NC24r"
	// StandardNC6 ...
	StandardNC6 VMSizeTypes = "Standard_NC6"
	// StandardNV12 ...
	StandardNV12 VMSizeTypes = "Standard_NV12"
	// StandardNV24 ...
	StandardNV24 VMSizeTypes = "Standard_NV24"
	// StandardNV6 ...
	StandardNV6 VMSizeTypes = "Standard_NV6"
)

// AccessProfile profile for enabling a user to access a managed cluster.
type AccessProfile struct {
	// KubeConfig - Base64-encoded Kubernetes configuration file.
	KubeConfig *string `json:"kubeConfig,omitempty"`
}

// AgentPoolProfile profile for the container service agent pool.
type AgentPoolProfile struct {
	// Name - Unique name of the agent pool profile in the context of the subscription and resource group.
	Name *string `json:"name,omitempty"`
	// Count - Number of agents (VMs) to host docker containers. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'StandardA0', 'StandardA1', 'StandardA10', 'StandardA11', 'StandardA1V2', 'StandardA2', 'StandardA2V2', 'StandardA2mV2', 'StandardA3', 'StandardA4', 'StandardA4V2', 'StandardA4mV2', 'StandardA5', 'StandardA6', 'StandardA7', 'StandardA8', 'StandardA8V2', 'StandardA8mV2', 'StandardA9', 'StandardD1', 'StandardD11', 'StandardD11V2', 'StandardD11V2Promo', 'StandardD12', 'StandardD12V2', 'StandardD12V2Promo', 'StandardD13', 'StandardD13V2', 'StandardD13V2Promo', 'StandardD14', 'StandardD14V2', 'StandardD14V2Promo', 'StandardD15V2', 'StandardD16V3', 'StandardD16sV3', 'StandardD1V2', 'StandardD2', 'StandardD2V2', 'StandardD2V2Promo', 'StandardD2V3', 'StandardD2sV3', 'StandardD3', 'StandardD3V2', 'StandardD3V2Promo', 'StandardD4', 'StandardD4V2', 'StandardD4V2Promo', 'StandardD4V3', 'StandardD4sV3', 'StandardD5V2', 'StandardD5V2Promo', 'StandardD8V3', 'StandardD8sV3', 'StandardDS1', 'StandardDS11', 'StandardDS11V2', 'StandardDS11V2Promo', 'StandardDS12', 'StandardDS12V2', 'StandardDS12V2Promo', 'StandardDS13', 'StandardDS13V2', 'StandardDS13V2Promo', 'StandardDS14', 'StandardDS14V2', 'StandardDS14V2Promo', 'StandardDS15V2', 'StandardDS1V2', 'StandardDS2', 'StandardDS2V2', 'StandardDS2V2Promo', 'StandardDS3', 'StandardDS3V2', 'StandardDS3V2Promo', 'StandardDS4', 'StandardDS4V2', 'StandardDS4V2Promo', 'StandardDS5V2', 'StandardDS5V2Promo', 'StandardE16V3', 'StandardE16sV3', 'StandardE2V3', 'StandardE2sV3', 'StandardE32V3', 'StandardE32sV3', 'StandardE4V3', 'StandardE4sV3', 'StandardE64V3', 'StandardE64sV3', 'StandardE8V3', 'StandardE8sV3', 'StandardF1', 'StandardF16', 'StandardF16s', 'StandardF1s', 'StandardF2', 'StandardF2s', 'StandardF4', 'StandardF4s', 'StandardF8', 'StandardF8s', 'StandardG1', 'StandardG2', 'StandardG3', 'StandardG4', 'StandardG5', 'StandardGS1', 'StandardGS2', 'StandardGS3', 'StandardGS4', 'StandardGS5', 'StandardH16', 'StandardH16m', 'StandardH16mr', 'StandardH16r', 'StandardH8', 'StandardH8m', 'StandardL16s', 'StandardL32s', 'StandardL4s', 'StandardL8s', 'StandardM128s', 'StandardM64ms', 'StandardNC12', 'StandardNC24', 'StandardNC24r', 'StandardNC6', 'StandardNV12', 'StandardNV24', 'StandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the agent pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// Fqdn - FDQN for the agent pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// Ports - Ports number array used to expose on this agent pool. The default opened ports are different based on your choice of orchestrator.
	Ports *[]int32 `json:"ports,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageAccount', 'ManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the vnet's subnet identifier. If you specify either master VNet Subnet, or agent VNet Subnet, you need to specify both. And they have to be in the same VNet.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
}

// ContainerService container service.
type ContainerService struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// Properties - Properties of the container service.
	*Properties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ContainerService struct.
func (cs *ContainerService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties Properties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cs.Properties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cs.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cs.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cs.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		cs.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		cs.Tags = &tags
	}

	return nil
}

// ContainerServicesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ContainerServicesCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ContainerServicesCreateOrUpdateFuture) Result(client ContainerServicesClient) (cs ContainerService, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return cs, autorest.NewError("containerservice.ContainerServicesCreateOrUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		cs, err = client.CreateOrUpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	cs, err = client.CreateOrUpdateResponder(resp)
	return
}

// ContainerServicesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ContainerServicesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ContainerServicesDeleteFuture) Result(client ContainerServicesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("containerservice.ContainerServicesDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// CustomProfile properties to configure a custom container service cluster.
type CustomProfile struct {
	// Orchestrator - The name of the custom orchestrator to use.
	Orchestrator *string `json:"orchestrator,omitempty"`
}

// DiagnosticsProfile profile for diagnostics on the container service cluster.
type DiagnosticsProfile struct {
	// VMDiagnostics - Profile for diagnostics on the container service VMs.
	VMDiagnostics *VMDiagnostics `json:"vmDiagnostics,omitempty"`
}

// KeyVaultSecretRef reference to a secret stored in Azure Key Vault.
type KeyVaultSecretRef struct {
	// VaultID - Key vault identifier.
	VaultID *string `json:"vaultID,omitempty"`
	// SecretName - The secret name.
	SecretName *string `json:"secretName,omitempty"`
	// Version - The secret version.
	Version *string `json:"version,omitempty"`
}

// LinuxProfile profile for Linux VMs in the container service cluster.
type LinuxProfile struct {
	// AdminUsername - The administrator username to use for Linux VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// SSH - SSH configuration for Linux-based VMs running on Azure.
	SSH *SSHConfiguration `json:"ssh,omitempty"`
}

// ListResult the response from the List Container Services operation.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container services.
	Value *[]ContainerService `json:"value,omitempty"`
	// NextLink - The URL to get the next set of container service results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of ContainerService values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() ContainerService {
	if !iter.page.NotDone() {
		return ContainerService{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of ContainerService values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []ContainerService {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// ManagedCluster managed cluster.
type ManagedCluster struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// ManagedClusterProperties - Properties of a managed cluster.
	*ManagedClusterProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagedCluster struct.
func (mc *ManagedCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties ManagedClusterProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mc.ManagedClusterProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mc.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mc.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mc.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		mc.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		mc.Tags = &tags
	}

	return nil
}

// ManagedClusterAccessProfile managed cluster Access Profile.
type ManagedClusterAccessProfile struct {
	autorest.Response `json:"-"`
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
	// AccessProfile - AccessProfile of a managed cluster.
	*AccessProfile `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterAccessProfile struct.
func (mcap *ManagedClusterAccessProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties AccessProfile
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mcap.AccessProfile = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mcap.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mcap.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mcap.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		mcap.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		mcap.Tags = &tags
	}

	return nil
}

// ManagedClusterListResult the response from the List Managed Clusters operation.
type ManagedClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed clusters.
	Value *[]ManagedCluster `json:"value,omitempty"`
	// NextLink - The URL to get the next set of managed cluster results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedClusterListResultIterator provides access to a complete listing of ManagedCluster values.
type ManagedClusterListResultIterator struct {
	i    int
	page ManagedClusterListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedClusterListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedClusterListResultIterator) Response() ManagedClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedClusterListResultIterator) Value() ManagedCluster {
	if !iter.page.NotDone() {
		return ManagedCluster{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (mclr ManagedClusterListResult) IsEmpty() bool {
	return mclr.Value == nil || len(*mclr.Value) == 0
}

// managedClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mclr ManagedClusterListResult) managedClusterListResultPreparer() (*http.Request, error) {
	if mclr.NextLink == nil || len(to.String(mclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mclr.NextLink)))
}

// ManagedClusterListResultPage contains a page of ManagedCluster values.
type ManagedClusterListResultPage struct {
	fn   func(ManagedClusterListResult) (ManagedClusterListResult, error)
	mclr ManagedClusterListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedClusterListResultPage) Next() error {
	next, err := page.fn(page.mclr)
	if err != nil {
		return err
	}
	page.mclr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedClusterListResultPage) NotDone() bool {
	return !page.mclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedClusterListResultPage) Response() ManagedClusterListResult {
	return page.mclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedClusterListResultPage) Values() []ManagedCluster {
	if page.mclr.IsEmpty() {
		return nil
	}
	return *page.mclr.Value
}

// ManagedClusterPoolUpgradeProfile the list of available upgrade versions.
type ManagedClusterPoolUpgradeProfile struct {
	// KubernetesVersion - Kubernetes version (major, minor, patch).
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// Name - Pool name.
	Name *string `json:"name,omitempty"`
	// OsType - OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux. Possible values include: 'Linux', 'Windows'
	OsType OSType `json:"osType,omitempty"`
	// Upgrades - List of orchestrator types and versions available for upgrade.
	Upgrades *[]string `json:"upgrades,omitempty"`
}

// ManagedClusterProperties properties of the managed cluster.
type ManagedClusterProperties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DNSPrefix - DNS prefix specified when creating the managed cluster.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// Fqdn - FDQN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
	// KubernetesVersion - Version of Kubernetes specified when creating the managed cluster.
	KubernetesVersion *string `json:"kubernetesVersion,omitempty"`
	// AgentPoolProfiles - Properties of the agent pool.
	AgentPoolProfiles *[]AgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// LinuxProfile - Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs. Either secret or keyVaultSecretRef must be specified.
	ServicePrincipalProfile *ServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
}

// ManagedClustersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedClustersCreateOrUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ManagedClustersCreateOrUpdateFuture) Result(client ManagedClustersClient) (mc ManagedCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return mc, autorest.NewError("containerservice.ManagedClustersCreateOrUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		mc, err = client.CreateOrUpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	mc, err = client.CreateOrUpdateResponder(resp)
	return
}

// ManagedClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ManagedClustersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ManagedClustersDeleteFuture) Result(client ManagedClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("containerservice.ManagedClustersDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// ManagedClusterUpgradeProfile the list of available upgrades for compute pools.
type ManagedClusterUpgradeProfile struct {
	autorest.Response `json:"-"`
	// ID - Id of upgrade profile.
	ID *string `json:"id,omitempty"`
	// Name - Name of upgrade profile.
	Name *string `json:"name,omitempty"`
	// Type - Type of upgrade profile.
	Type *string `json:"type,omitempty"`
	// ManagedClusterUpgradeProfileProperties - Properties of upgrade profile.
	*ManagedClusterUpgradeProfileProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ManagedClusterUpgradeProfile struct.
func (mcup *ManagedClusterUpgradeProfile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mcup.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mcup.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		mcup.Type = &typeVar
	}

	v = m["properties"]
	if v != nil {
		var properties ManagedClusterUpgradeProfileProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		mcup.ManagedClusterUpgradeProfileProperties = &properties
	}

	return nil
}

// ManagedClusterUpgradeProfileProperties control plane and agent pool upgrade profiles.
type ManagedClusterUpgradeProfileProperties struct {
	// ControlPlaneProfile - The list of available upgrade versions for the control plane.
	ControlPlaneProfile *ManagedClusterPoolUpgradeProfile `json:"controlPlaneProfile,omitempty"`
	// AgentPoolProfiles - The list of available upgrade versions for agent pools.
	AgentPoolProfiles *[]ManagedClusterPoolUpgradeProfile `json:"agentPoolProfiles,omitempty"`
}

// MasterProfile profile for the container service master.
type MasterProfile struct {
	// Count - Number of masters (VMs) in the container service cluster. Allowed values are 1, 3, and 5. The default value is 1.
	Count *int32 `json:"count,omitempty"`
	// DNSPrefix - DNS prefix to be used to create the FQDN for the master pool.
	DNSPrefix *string `json:"dnsPrefix,omitempty"`
	// VMSize - Size of agent VMs. Possible values include: 'StandardA0', 'StandardA1', 'StandardA10', 'StandardA11', 'StandardA1V2', 'StandardA2', 'StandardA2V2', 'StandardA2mV2', 'StandardA3', 'StandardA4', 'StandardA4V2', 'StandardA4mV2', 'StandardA5', 'StandardA6', 'StandardA7', 'StandardA8', 'StandardA8V2', 'StandardA8mV2', 'StandardA9', 'StandardD1', 'StandardD11', 'StandardD11V2', 'StandardD11V2Promo', 'StandardD12', 'StandardD12V2', 'StandardD12V2Promo', 'StandardD13', 'StandardD13V2', 'StandardD13V2Promo', 'StandardD14', 'StandardD14V2', 'StandardD14V2Promo', 'StandardD15V2', 'StandardD16V3', 'StandardD16sV3', 'StandardD1V2', 'StandardD2', 'StandardD2V2', 'StandardD2V2Promo', 'StandardD2V3', 'StandardD2sV3', 'StandardD3', 'StandardD3V2', 'StandardD3V2Promo', 'StandardD4', 'StandardD4V2', 'StandardD4V2Promo', 'StandardD4V3', 'StandardD4sV3', 'StandardD5V2', 'StandardD5V2Promo', 'StandardD8V3', 'StandardD8sV3', 'StandardDS1', 'StandardDS11', 'StandardDS11V2', 'StandardDS11V2Promo', 'StandardDS12', 'StandardDS12V2', 'StandardDS12V2Promo', 'StandardDS13', 'StandardDS13V2', 'StandardDS13V2Promo', 'StandardDS14', 'StandardDS14V2', 'StandardDS14V2Promo', 'StandardDS15V2', 'StandardDS1V2', 'StandardDS2', 'StandardDS2V2', 'StandardDS2V2Promo', 'StandardDS3', 'StandardDS3V2', 'StandardDS3V2Promo', 'StandardDS4', 'StandardDS4V2', 'StandardDS4V2Promo', 'StandardDS5V2', 'StandardDS5V2Promo', 'StandardE16V3', 'StandardE16sV3', 'StandardE2V3', 'StandardE2sV3', 'StandardE32V3', 'StandardE32sV3', 'StandardE4V3', 'StandardE4sV3', 'StandardE64V3', 'StandardE64sV3', 'StandardE8V3', 'StandardE8sV3', 'StandardF1', 'StandardF16', 'StandardF16s', 'StandardF1s', 'StandardF2', 'StandardF2s', 'StandardF4', 'StandardF4s', 'StandardF8', 'StandardF8s', 'StandardG1', 'StandardG2', 'StandardG3', 'StandardG4', 'StandardG5', 'StandardGS1', 'StandardGS2', 'StandardGS3', 'StandardGS4', 'StandardGS5', 'StandardH16', 'StandardH16m', 'StandardH16mr', 'StandardH16r', 'StandardH8', 'StandardH8m', 'StandardL16s', 'StandardL32s', 'StandardL4s', 'StandardL8s', 'StandardM128s', 'StandardM64ms', 'StandardNC12', 'StandardNC24', 'StandardNC24r', 'StandardNC6', 'StandardNV12', 'StandardNV24', 'StandardNV6'
	VMSize VMSizeTypes `json:"vmSize,omitempty"`
	// OsDiskSizeGB - OS Disk Size in GB to be used to specify the disk size for every machine in this master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
	OsDiskSizeGB *int32 `json:"osDiskSizeGB,omitempty"`
	// VnetSubnetID - VNet SubnetID specifies the vnet's subnet identifier. If you specify either master VNet Subnet, or agent VNet Subnet, you need to specify both. And they have to be in the same VNet.
	VnetSubnetID *string `json:"vnetSubnetID,omitempty"`
	// FirstConsecutiveStaticIP - FirstConsecutiveStaticIP used to specify the first static ip of masters.
	FirstConsecutiveStaticIP *string `json:"firstConsecutiveStaticIP,omitempty"`
	// StorageProfile - Storage profile specifies what kind of storage used. Choose from StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the orchestrator choice. Possible values include: 'StorageAccount', 'ManagedDisks'
	StorageProfile StorageProfileTypes `json:"storageProfile,omitempty"`
	// Fqdn - FDQN for the master pool.
	Fqdn *string `json:"fqdn,omitempty"`
}

// OrchestratorProfile contains information about orchestrator.
type OrchestratorProfile struct {
	// OrchestratorType - Orchestrator type.
	OrchestratorType *string `json:"orchestratorType,omitempty"`
	// OrchestratorVersion - Orchestrator version (major, minor, patch).
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
}

// OrchestratorProfileType profile for the container service orchestrator.
type OrchestratorProfileType struct {
	// OrchestratorType - The orchestrator to use to manage container service cluster resources. Valid values are Kubernetes, Swarm, DCOS, DockerCE and Custom. Possible values include: 'Kubernetes', 'Swarm', 'DCOS', 'DockerCE', 'Custom'
	OrchestratorType OrchestratorTypes `json:"orchestratorType,omitempty"`
	// OrchestratorVersion - The version of the orchestrator to use. You can specify the major.minor.patch part of the actual version.For example, you can specify version as "1.6.11".
	OrchestratorVersion *string `json:"orchestratorVersion,omitempty"`
}

// Properties properties of the container service.
type Properties struct {
	// ProvisioningState - The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OrchestratorProfile - Profile for the container service orchestrator.
	OrchestratorProfile *OrchestratorProfileType `json:"orchestratorProfile,omitempty"`
	// CustomProfile - Properties to configure a custom container service cluster.
	CustomProfile *CustomProfile `json:"customProfile,omitempty"`
	// ServicePrincipalProfile - Information about a service principal identity for the cluster to use for manipulating Azure APIs. Exact one of secret or keyVaultSecretRef need to be specified.
	ServicePrincipalProfile *ServicePrincipalProfile `json:"servicePrincipalProfile,omitempty"`
	// MasterProfile - Profile for the container service master.
	MasterProfile *MasterProfile `json:"masterProfile,omitempty"`
	// AgentPoolProfiles - Properties of the agent pool.
	AgentPoolProfiles *[]AgentPoolProfile `json:"agentPoolProfiles,omitempty"`
	// WindowsProfile - Profile for Windows VMs in the container service cluster.
	WindowsProfile *WindowsProfile `json:"windowsProfile,omitempty"`
	// LinuxProfile - Profile for Linux VMs in the container service cluster.
	LinuxProfile *LinuxProfile `json:"linuxProfile,omitempty"`
	// DiagnosticsProfile - Profile for diagnostics in the container service cluster.
	DiagnosticsProfile *DiagnosticsProfile `json:"diagnosticsProfile,omitempty"`
}

// Resource the Resource model definition.
type Resource struct {
	// ID - Resource Id
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags *map[string]*string `json:"tags,omitempty"`
}

// ServicePrincipalProfile information about a service principal identity for the cluster to use for manipulating Azure
// APIs. Either secret or keyVaultSecretRef must be specified.
type ServicePrincipalProfile struct {
	// ClientID - The ID for the service principal.
	ClientID *string `json:"clientId,omitempty"`
	// Secret - The secret password associated with the service principal in plain text.
	Secret *string `json:"secret,omitempty"`
	// KeyVaultSecretRef - Reference to a secret stored in Azure Key Vault.
	KeyVaultSecretRef *KeyVaultSecretRef `json:"keyVaultSecretRef,omitempty"`
}

// SSHConfiguration SSH configuration for Linux-based VMs running on Azure.
type SSHConfiguration struct {
	// PublicKeys - The list of SSH public keys used to authenticate with Linux-based VMs. Only expect one key specified.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey contains information about SSH certificate public key data.
type SSHPublicKey struct {
	// KeyData - Certificate public key used to authenticate with VMs through SSH. The certificate must be in PEM format with or without headers.
	KeyData *string `json:"keyData,omitempty"`
}

// VMDiagnostics profile for diagnostics on the container service VMs.
type VMDiagnostics struct {
	// Enabled - Whether the VM diagnostic agent is provisioned on the VM.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageURI - The URI of the storage account where diagnostics are stored.
	StorageURI *string `json:"storageUri,omitempty"`
}

// WindowsProfile profile for Windows VMs in the container service cluster.
type WindowsProfile struct {
	// AdminUsername - The administrator username to use for Windows VMs.
	AdminUsername *string `json:"adminUsername,omitempty"`
	// AdminPassword - The administrator password to use for Windows VMs.
	AdminPassword *string `json:"adminPassword,omitempty"`
}
