package face

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// AttributeTypes enumerates the values for attribute types.
type AttributeTypes string

const (
	// AttributeTypesAccessories ...
	AttributeTypesAccessories AttributeTypes = "accessories"
	// AttributeTypesAge ...
	AttributeTypesAge AttributeTypes = "age"
	// AttributeTypesBlur ...
	AttributeTypesBlur AttributeTypes = "blur"
	// AttributeTypesEmotion ...
	AttributeTypesEmotion AttributeTypes = "emotion"
	// AttributeTypesExposure ...
	AttributeTypesExposure AttributeTypes = "exposure"
	// AttributeTypesFacialHair ...
	AttributeTypesFacialHair AttributeTypes = "facialHair"
	// AttributeTypesGender ...
	AttributeTypesGender AttributeTypes = "gender"
	// AttributeTypesGlasses ...
	AttributeTypesGlasses AttributeTypes = "glasses"
	// AttributeTypesHair ...
	AttributeTypesHair AttributeTypes = "hair"
	// AttributeTypesHeadPose ...
	AttributeTypesHeadPose AttributeTypes = "headPose"
	// AttributeTypesMakeup ...
	AttributeTypesMakeup AttributeTypes = "makeup"
	// AttributeTypesNoise ...
	AttributeTypesNoise AttributeTypes = "noise"
	// AttributeTypesOcclusion ...
	AttributeTypesOcclusion AttributeTypes = "occlusion"
	// AttributeTypesSmile ...
	AttributeTypesSmile AttributeTypes = "smile"
)

// AzureRegions enumerates the values for azure regions.
type AzureRegions string

const (
	// Australiaeast ...
	Australiaeast AzureRegions = "australiaeast"
	// Brazilsouth ...
	Brazilsouth AzureRegions = "brazilsouth"
	// Eastasia ...
	Eastasia AzureRegions = "eastasia"
	// Eastus ...
	Eastus AzureRegions = "eastus"
	// Eastus2 ...
	Eastus2 AzureRegions = "eastus2"
	// Northeurope ...
	Northeurope AzureRegions = "northeurope"
	// Southcentralus ...
	Southcentralus AzureRegions = "southcentralus"
	// Southeastasia ...
	Southeastasia AzureRegions = "southeastasia"
	// Westcentralus ...
	Westcentralus AzureRegions = "westcentralus"
	// Westeurope ...
	Westeurope AzureRegions = "westeurope"
	// Westus ...
	Westus AzureRegions = "westus"
	// Westus2 ...
	Westus2 AzureRegions = "westus2"
)

// BlurLevels enumerates the values for blur levels.
type BlurLevels string

const (
	// High ...
	High BlurLevels = "High"
	// Low ...
	Low BlurLevels = "Low"
	// Medium ...
	Medium BlurLevels = "Medium"
)

// ExposureLevels enumerates the values for exposure levels.
type ExposureLevels string

const (
	// GoodExposure ...
	GoodExposure ExposureLevels = "GoodExposure"
	// OverExposure ...
	OverExposure ExposureLevels = "OverExposure"
	// UnderExposure ...
	UnderExposure ExposureLevels = "UnderExposure"
)

// Gender enumerates the values for gender.
type Gender string

const (
	// Female ...
	Female Gender = "female"
	// Genderless ...
	Genderless Gender = "genderless"
	// Male ...
	Male Gender = "male"
)

// GlassesTypes enumerates the values for glasses types.
type GlassesTypes string

const (
	// NoGlasses ...
	NoGlasses GlassesTypes = "noGlasses"
	// ReadingGlasses ...
	ReadingGlasses GlassesTypes = "readingGlasses"
	// Sunglasses ...
	Sunglasses GlassesTypes = "sunglasses"
	// SwimmingGoggles ...
	SwimmingGoggles GlassesTypes = "swimmingGoggles"
)

// MatchingMode enumerates the values for matching mode.
type MatchingMode string

const (
	// MatchFace ...
	MatchFace MatchingMode = "matchFace"
	// MatchPerson ...
	MatchPerson MatchingMode = "matchPerson"
)

// NoiseLevels enumerates the values for noise levels.
type NoiseLevels string

const (
	// NoiseLevelsHigh ...
	NoiseLevelsHigh NoiseLevels = "High"
	// NoiseLevelsLow ...
	NoiseLevelsLow NoiseLevels = "Low"
	// NoiseLevelsMedium ...
	NoiseLevelsMedium NoiseLevels = "Medium"
)

// TrainingStatusType enumerates the values for training status type.
type TrainingStatusType string

const (
	// Failed ...
	Failed TrainingStatusType = "failed"
	// Nonstarted ...
	Nonstarted TrainingStatusType = "nonstarted"
	// Running ...
	Running TrainingStatusType = "running"
	// Succeeded ...
	Succeeded TrainingStatusType = "succeeded"
)

// AccessoryItem accessory item and corresponding confidence level.
type AccessoryItem struct {
	// Type - Description of an accessory
	Type       *string  `json:"type,omitempty"`
	Confidence *float64 `json:"confidence,omitempty"`
}

// APIError error information returned by the API
type APIError struct {
	Error *Error `json:"error,omitempty"`
}

// Attributes face Attributes
type Attributes struct {
	// Age - Age in years
	Age *float64 `json:"age,omitempty"`
	// Gender - Possible gender of the face. Possible values include: 'Male', 'Female', 'Genderless'
	Gender Gender `json:"gender,omitempty"`
	// Smile - Smile intensity, a number between [0,1]
	Smile      *float64              `json:"smile,omitempty"`
	FacialHair *FacialHairProperties `json:"facialHair,omitempty"`
	// Glasses - Glasses type if any of the face. Possible values include: 'NoGlasses', 'ReadingGlasses', 'Sunglasses', 'SwimmingGoggles'
	Glasses     GlassesTypes         `json:"glasses,omitempty"`
	HeadPose    *HeadPoseProperties  `json:"headPose,omitempty"`
	Emotion     *EmotionProperties   `json:"emotion,omitempty"`
	Hair        *HairProperties      `json:"hair,omitempty"`
	Makeup      *MakeupProperties    `json:"makeup,omitempty"`
	Occlusion   *OcclusionProperties `json:"occlusion,omitempty"`
	Accessories *[]AccessoryItem     `json:"accessories,omitempty"`
	Blur        *BlurProperties      `json:"blur,omitempty"`
	Exposure    *ExposureProperties  `json:"exposure,omitempty"`
	Noise       *NoiseProperties     `json:"noise,omitempty"`
}

// BlurProperties properties describing any presence of blur within the image.
type BlurProperties struct {
	// BlurLevel - An enum value indicating level of blurriness. Possible values include: 'Low', 'Medium', 'High'
	BlurLevel BlurLevels `json:"blurLevel,omitempty"`
	// Value - A number indicating level of blurriness ranging from 0 to 1.
	Value *float64 `json:"value,omitempty"`
}

// ColorProperty hair color and associated confidence
type ColorProperty struct {
	// Color - Name of the color.
	Color      *string  `json:"color,omitempty"`
	Confidence *float64 `json:"confidence,omitempty"`
}

// CreateFaceListRequest request to create a face list.
type CreateFaceListRequest struct {
	// Name - Name of the face list, maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - Optional user defined data for the face list. Length should not exceed 16KB.
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonGroupRequest request to create a person group.
type CreatePersonGroupRequest struct {
	// Name - Person group display name. The maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - User-provided data attached to the person group. The size limit is 16KB.
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonRequest request to create a person object.
type CreatePersonRequest struct {
	// Name - Display name of the target person. The maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - Optional fields for user-provided data attached to a person. Size limit is 16KB.
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonResult result of creating person.
type CreatePersonResult struct {
	autorest.Response `json:"-"`
	// PersonID - personID of the new created person.
	PersonID *string `json:"personId,omitempty"`
}

// DetectedFace detected Face object.
type DetectedFace struct {
	FaceID         *string     `json:"faceId,omitempty"`
	FaceRectangle  *Rectangle  `json:"faceRectangle,omitempty"`
	FaceLandmarks  *Landmarks  `json:"faceLandmarks,omitempty"`
	FaceAttributes *Attributes `json:"faceAttributes,omitempty"`
}

// EmotionProperties properties describing facial emotion in form of confidence ranging from 0 to 1.
type EmotionProperties struct {
	Anger     *float64 `json:"anger,omitempty"`
	Contempt  *float64 `json:"contempt,omitempty"`
	Disgust   *float64 `json:"disgust,omitempty"`
	Fear      *float64 `json:"fear,omitempty"`
	Happiness *float64 `json:"happiness,omitempty"`
	Neutral   *float64 `json:"neutral,omitempty"`
	Sadness   *float64 `json:"sadness,omitempty"`
	Surprise  *float64 `json:"surprise,omitempty"`
}

// Error error body.
type Error struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ExposureProperties properties describing exposure level of the image.
type ExposureProperties struct {
	// ExposureLevel - An enum value indicating level of exposure. Possible values include: 'UnderExposure', 'GoodExposure', 'OverExposure'
	ExposureLevel ExposureLevels `json:"exposureLevel,omitempty"`
	// Value - A number indicating level of exposure level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure.
	Value *float64 `json:"value,omitempty"`
}

// FacialHairProperties properties describing facial hair attributes.
type FacialHairProperties struct {
	Moustache *float64 `json:"moustache,omitempty"`
	Beard     *float64 `json:"beard,omitempty"`
	Sideburns *float64 `json:"sideburns,omitempty"`
}

// FindSimilarRequest request body for find similar operation.
type FindSimilarRequest struct {
	// FaceID - FaceId of the query face. User needs to call Face - Detect first to get a valid faceId. Note that this faceId is not persisted and will expire 24 hours after the detection call
	FaceID *string `json:"faceId,omitempty"`
	// FaceListID - An existing user-specified unique candidate face list, created in Face List - Create a Face List. Face list contains a set of persistedFaceIds which are persisted and will never expire. Parameter faceListId and faceIds should not be provided at the same time
	FaceListID *string `json:"faceListId,omitempty"`
	// FaceIds - An array of candidate faceIds. All of them are created by Face - Detect and the faceIds will expire 24 hours after the detection call.
	FaceIds *[]string `json:"faceIds,omitempty"`
	// MaxNumOfCandidatesReturned - The number of top similar faces returned. The valid range is [1, 1000].
	MaxNumOfCandidatesReturned *int32 `json:"maxNumOfCandidatesReturned,omitempty"`
	// Mode - Similar face searching mode. It can be "matchPerson" or "matchFace". Possible values include: 'MatchPerson', 'MatchFace'
	Mode MatchingMode `json:"mode,omitempty"`
}

// GetFaceListResult result of the GetFaceList operation.
type GetFaceListResult struct {
	autorest.Response `json:"-"`
	// FaceListID - faceListId of the target face list.
	FaceListID *string `json:"faceListId,omitempty"`
	// Name - Face list's display name, maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - User-provided data attached to this face list. Length should not exceed 16KB.
	UserData *string `json:"userData,omitempty"`
	// PersistedFaces - Persisted faces within the face list.
	PersistedFaces *[]PersonFaceResult `json:"persistedFaces,omitempty"`
}

// GroupRequest request body for group request.
type GroupRequest struct {
	// FaceIds - Array of candidate faceId created by Face - Detect. The maximum is 1000 faces
	FaceIds *[]string `json:"faceIds,omitempty"`
}

// GroupResponse an array of face groups based on face similarity.
type GroupResponse struct {
	autorest.Response `json:"-"`
	// Groups - A partition of the original faces based on face similarity. Groups are ranked by number of faces
	Groups *[][]string `json:"groups,omitempty"`
	// MessyGroup - Face ids array of faces that cannot find any similar faces from original faces.
	MessyGroup *[]string `json:"messyGroup,omitempty"`
}

// HairProperties properties describing hair attributes.
type HairProperties struct {
	// Bald - A number describing confidence level of whether the person is bald.
	Bald *float64 `json:"bald,omitempty"`
	// Invisible - A boolean value describing whether the hair is visible in the image.
	Invisible *bool            `json:"invisible,omitempty"`
	HairColor *[]ColorProperty `json:"hairColor,omitempty"`
}

// HeadPoseProperties properties indicating head pose of the face.
type HeadPoseProperties struct {
	Roll  *float64 `json:"roll,omitempty"`
	Yaw   *float64 `json:"yaw,omitempty"`
	Pitch *float64 `json:"pitch,omitempty"`
}

// IdentifyRequest request body for identify face operation.
type IdentifyRequest struct {
	// PersonGroupID - personGroupId of the target person group, created by PersonGroups.Create
	PersonGroupID *string `json:"personGroupId,omitempty"`
	// FaceIds - Array of candidate faceId created by Face - Detect.
	FaceIds *[]string `json:"faceIds,omitempty"`
	// MaxNumOfCandidatesReturned - The number of top similar faces returned.
	MaxNumOfCandidatesReturned *int32   `json:"maxNumOfCandidatesReturned,omitempty"`
	ConfidenceThreshold        *float64 `json:"confidenceThreshold,omitempty"`
}

// IdentifyResultCandidate all possible faces that may qualify.
type IdentifyResultCandidate struct {
	// PersonID - Id of candidate
	PersonID   *string  `json:"personId,omitempty"`
	Confidence *float64 `json:"confidence,omitempty"`
}

// IdentifyResultItem response body for identify face operation.
type IdentifyResultItem struct {
	// FaceID - faceId of the query face
	FaceID     *string                    `json:"faceId,omitempty"`
	Candidates *[]IdentifyResultCandidate `json:"candidates,omitempty"`
}

// ImageURL ...
type ImageURL struct {
	URL *string `json:"url,omitempty"`
}

// Landmarks a collection of 27-point face landmarks pointing to the important positions of face components.
type Landmarks struct {
	PupilLeft           *Position `json:"pupilLeft,omitempty"`
	PupilRight          *Position `json:"pupilRight,omitempty"`
	NoseTip             *Position `json:"noseTip,omitempty"`
	MouthLeft           *Position `json:"mouthLeft,omitempty"`
	MouthRight          *Position `json:"mouthRight,omitempty"`
	EyebrowLeftOuter    *Position `json:"eyebrowLeftOuter,omitempty"`
	EyebrowLeftInner    *Position `json:"eyebrowLeftInner,omitempty"`
	EyeLeftOuter        *Position `json:"eyeLeftOuter,omitempty"`
	EyeLeftTop          *Position `json:"eyeLeftTop,omitempty"`
	EyeLeftBottom       *Position `json:"eyeLeftBottom,omitempty"`
	EyeLeftInner        *Position `json:"eyeLeftInner,omitempty"`
	EyebrowRightInner   *Position `json:"eyebrowRightInner,omitempty"`
	EyebrowRightOuter   *Position `json:"eyebrowRightOuter,omitempty"`
	EyeRightInner       *Position `json:"eyeRightInner,omitempty"`
	EyeRightTop         *Position `json:"eyeRightTop,omitempty"`
	EyeRightBottom      *Position `json:"eyeRightBottom,omitempty"`
	EyeRightOuter       *Position `json:"eyeRightOuter,omitempty"`
	NoseRootLeft        *Position `json:"noseRootLeft,omitempty"`
	NoseRootRight       *Position `json:"noseRootRight,omitempty"`
	NoseLeftAlarTop     *Position `json:"noseLeftAlarTop,omitempty"`
	NoseRightAlarTop    *Position `json:"noseRightAlarTop,omitempty"`
	NoseLeftAlarOutTip  *Position `json:"noseLeftAlarOutTip,omitempty"`
	NoseRightAlarOutTip *Position `json:"noseRightAlarOutTip,omitempty"`
	UpperLipTop         *Position `json:"upperLipTop,omitempty"`
	UpperLipBottom      *Position `json:"upperLipBottom,omitempty"`
	UnderLipTop         *Position `json:"underLipTop,omitempty"`
	UnderLipBottom      *Position `json:"underLipBottom,omitempty"`
}

// ListDetectedFace ...
type ListDetectedFace struct {
	autorest.Response `json:"-"`
	Value             *[]DetectedFace `json:"value,omitempty"`
}

// ListGetFaceListResult ...
type ListGetFaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]GetFaceListResult `json:"value,omitempty"`
}

// ListIdentifyResultItem ...
type ListIdentifyResultItem struct {
	autorest.Response `json:"-"`
	Value             *[]IdentifyResultItem `json:"value,omitempty"`
}

// ListPersonGroupResult ...
type ListPersonGroupResult struct {
	autorest.Response `json:"-"`
	Value             *[]PersonGroupResult `json:"value,omitempty"`
}

// ListPersonResult ...
type ListPersonResult struct {
	autorest.Response `json:"-"`
	Value             *[]PersonResult `json:"value,omitempty"`
}

// ListSimilarFaceResult ...
type ListSimilarFaceResult struct {
	autorest.Response `json:"-"`
	Value             *[]SimilarFaceResult `json:"value,omitempty"`
}

// MakeupProperties properties describing present makeups on a given face.
type MakeupProperties struct {
	// EyeMakeup - A boolean value describing whether eye makeup is present on a face.
	EyeMakeup *bool `json:"eyeMakeup,omitempty"`
	// LipMakeup - A boolean value describing whether lip makeup is present on a face.
	LipMakeup *bool `json:"lipMakeup,omitempty"`
}

// NoiseProperties properties describing noise level of the image.
type NoiseProperties struct {
	// NoiseLevel - An enum value indicating level of noise. Possible values include: 'NoiseLevelsLow', 'NoiseLevelsMedium', 'NoiseLevelsHigh'
	NoiseLevel NoiseLevels `json:"noiseLevel,omitempty"`
	// Value - A number indicating level of noise level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise level.
	Value *float64 `json:"value,omitempty"`
}

// OcclusionProperties properties describing occulusions on a given face.
type OcclusionProperties struct {
	// ForeheadOccluded - A boolean value indicating whether forehead is occluded.
	ForeheadOccluded *bool `json:"foreheadOccluded,omitempty"`
	// EyeOccluded - A boolean value indicating whether eyes are occluded.
	EyeOccluded *bool `json:"eyeOccluded,omitempty"`
	// MouthOccluded - A boolean value indicating whether the mouth is occluded.
	MouthOccluded *bool `json:"mouthOccluded,omitempty"`
}

// PersistedFaceResult persisted face result.
type PersistedFaceResult struct {
	autorest.Response `json:"-"`
	// PersistedFaceID - persistedFaceId of candidate face when find by faceListId. persistedFaceId in face list is persisted and will not expire. As showed in below response
	PersistedFaceID *string `json:"persistedFaceId,omitempty"`
}

// PersonFaceResult personFace object.
type PersonFaceResult struct {
	autorest.Response `json:"-"`
	// PersistedFaceID - The persistedFaceId of the target face, which is persisted and will not expire. Different from faceId created by Face - Detect and will expire in 24 hours after the detection call.
	PersistedFaceID *string `json:"persistedFaceId,omitempty"`
	// UserData - User-provided data attached to the face. The size limit is 1KB.
	UserData *string `json:"userData,omitempty"`
}

// PersonGroupResult person group object.
type PersonGroupResult struct {
	autorest.Response `json:"-"`
	// PersonGroupID - personGroupId of the existing person groups.
	PersonGroupID *string `json:"personGroupId,omitempty"`
	// Name - Person group's display name, maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - User-provided data attached to this person group. Length should not exceed 16KB.
	UserData *string `json:"userData,omitempty"`
}

// PersonResult person object.
type PersonResult struct {
	autorest.Response `json:"-"`
	// PersonID - personId of the target face list.
	PersonID *string `json:"personId,omitempty"`
	// PersistedFaceIds - persistedFaceIds of registered faces in the person. These persistedFaceIds are returned from Person - Add a Person Face, and will not expire.
	PersistedFaceIds *[]string `json:"persistedFaceIds,omitempty"`
	// Name - Person's display name, maximum length is 128.
	Name *string `json:"name,omitempty"`
	// UserData - User-provided data attached to this person. Length should not exceed 16KB.
	UserData *string `json:"userData,omitempty"`
}

// Position coordinates within an image
type Position struct {
	// X - The horizontal component, in pixels.
	X *float64 `json:"x,omitempty"`
	// Y - The vertical component, in pixels.
	Y *float64 `json:"y,omitempty"`
}

// Rectangle a rectangle within which a face can be found
type Rectangle struct {
	// Width - The width of the rectangle, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the rectangle, in pixels.
	Height *int32 `json:"height,omitempty"`
	// Left - The distance from the left edge if the image to the left edge of the rectangle, in pixels.
	Left *int32 `json:"left,omitempty"`
	// Top - The distance from the top edge if the image to the top edge of the rectangle, in pixels.
	Top *int32 `json:"top,omitempty"`
}

// SimilarFaceResult response body for find similar face operation.
type SimilarFaceResult struct {
	// FaceID - faceId of candidate face when find by faceIds. faceId is created by Face - Detect and will expire 24 hours after the detection call
	FaceID *string `json:"faceId,omitempty"`
	// PersistedFaceID - persistedFaceId of candidate face when find by faceListId. persistedFaceId in face list is persisted and will not expire. As showed in below response
	PersistedFaceID *string  `json:"persistedFaceId,omitempty"`
	Confidence      *float64 `json:"confidence,omitempty"`
}

// TrainingStatus training status object.
type TrainingStatus struct {
	autorest.Response `json:"-"`
	// Status - Training status: notstarted, running, succeeded, failed. If the training process is waiting to perform, the status is notstarted. If the training is ongoing, the status is running. Status succeed means this person group is ready for Face - Identify. Status failed is often caused by no person or no persisted face exist in the person group. Possible values include: 'Nonstarted', 'Running', 'Succeeded', 'Failed'
	Status TrainingStatusType `json:"status,omitempty"`
	// Created - A combined UTC date and time string that describes person group created time.
	Created *date.Time `json:"createdDateTime,omitempty"`
	// LastAction - Person group last modify time in the UTC, could be null value when the person group is not successfully trained.
	LastAction *date.Time `json:"lastActionDateTime,omitempty"`
	// Message - Show failure message when training failed (omitted when training succeed).
	Message *string `json:"message,omitempty"`
}

// UpdatePersonFaceDataRequest request to update person face data.
type UpdatePersonFaceDataRequest struct {
	// UserData - User-provided data attached to the face. The size limit is 1KB.
	UserData *string `json:"userData,omitempty"`
}

// VerifyPersonGroupRequest request body for verify operation.
type VerifyPersonGroupRequest struct {
	// FaceID - faceId the face, comes from Face - Detect
	FaceID *string `json:"faceId,omitempty"`
	// PersonID - Specify a certain person in a person group. personId is created in Persons.Create.
	PersonID *string `json:"personId,omitempty"`
	// PersonGroupID - Using existing personGroupId and personId for fast loading a specified person. personGroupId is created in Person Groups.Create.
	PersonGroupID *string `json:"personGroupId,omitempty"`
}

// VerifyRequest request body for verify operation.
type VerifyRequest struct {
	// FaceID1 - faceId of the first face, comes from Face - Detect
	FaceID1 *string `json:"faceId1,omitempty"`
	// FaceID2 - faceId of the second face, comes from Face - Detect
	FaceID2 *string `json:"faceId2,omitempty"`
}

// VerifyResult result of the verify operation.
type VerifyResult struct {
	autorest.Response `json:"-"`
	// IsIdentical - True if the two faces belong to the same person or the face belongs to the person, otherwise false.
	IsIdentical *bool    `json:"isIdentical,omitempty"`
	Confidence  *float64 `json:"confidence,omitempty"`
}
