package contentmoderator

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// AzureRegionBaseURL enumerates the values for azure region base url.
type AzureRegionBaseURL string

const (
	// Australiaeastapicognitivemicrosoftcom ...
	Australiaeastapicognitivemicrosoftcom AzureRegionBaseURL = "australiaeast.api.cognitive.microsoft.com"
	// Brazilsouthapicognitivemicrosoftcom ...
	Brazilsouthapicognitivemicrosoftcom AzureRegionBaseURL = "brazilsouth.api.cognitive.microsoft.com"
	// ContentmoderatortestazureApinet ...
	ContentmoderatortestazureApinet AzureRegionBaseURL = "contentmoderatortest.azure-api.net"
	// Eastasiaapicognitivemicrosoftcom ...
	Eastasiaapicognitivemicrosoftcom AzureRegionBaseURL = "eastasia.api.cognitive.microsoft.com"
	// Eastus2apicognitivemicrosoftcom ...
	Eastus2apicognitivemicrosoftcom AzureRegionBaseURL = "eastus2.api.cognitive.microsoft.com"
	// Eastusapicognitivemicrosoftcom ...
	Eastusapicognitivemicrosoftcom AzureRegionBaseURL = "eastus.api.cognitive.microsoft.com"
	// Northeuropeapicognitivemicrosoftcom ...
	Northeuropeapicognitivemicrosoftcom AzureRegionBaseURL = "northeurope.api.cognitive.microsoft.com"
	// Southcentralusapicognitivemicrosoftcom ...
	Southcentralusapicognitivemicrosoftcom AzureRegionBaseURL = "southcentralus.api.cognitive.microsoft.com"
	// Southeastasiaapicognitivemicrosoftcom ...
	Southeastasiaapicognitivemicrosoftcom AzureRegionBaseURL = "southeastasia.api.cognitive.microsoft.com"
	// Westcentralusapicognitivemicrosoftcom ...
	Westcentralusapicognitivemicrosoftcom AzureRegionBaseURL = "westcentralus.api.cognitive.microsoft.com"
	// Westeuropeapicognitivemicrosoftcom ...
	Westeuropeapicognitivemicrosoftcom AzureRegionBaseURL = "westeurope.api.cognitive.microsoft.com"
	// Westus2apicognitivemicrosoftcom ...
	Westus2apicognitivemicrosoftcom AzureRegionBaseURL = "westus2.api.cognitive.microsoft.com"
	// Westusapicognitivemicrosoftcom ...
	Westusapicognitivemicrosoftcom AzureRegionBaseURL = "westus.api.cognitive.microsoft.com"
)

// StatusEnum enumerates the values for status enum.
type StatusEnum string

const (
	// Complete ...
	Complete StatusEnum = "Complete"
	// Pending ...
	Pending StatusEnum = "Pending"
	// Unpublished ...
	Unpublished StatusEnum = "Unpublished"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeImage ...
	TypeImage Type = "Image"
	// TypeText ...
	TypeText Type = "Text"
)

// Address address details.
type Address struct {
	// Text - Detected Address.
	Text *string `json:"Text,omitempty"`
	// Index - Index(Location) of the Address in the input text content.
	Index *int32 `json:"Index,omitempty"`
}

// APIError error information returned by the API
type APIError struct {
	Error *Error `json:"Error,omitempty"`
}

// Body ...
type Body struct {
	// Name - Name of the list.
	Name *string `json:"Name,omitempty"`
	// Description - Description of the list.
	Description *string `json:"Description,omitempty"`
	// Metadata - Metadata of the list.
	Metadata *BodyMetadata `json:"Metadata,omitempty"`
}

// BodyMetadata metadata of the list.
type BodyMetadata struct {
	// KeyOne - Optional key value pair to describe your list.
	KeyOne *string `json:"Key One,omitempty"`
	// KeyTwo - Optional key value pair to describe your list.
	KeyTwo *string `json:"Key Two,omitempty"`
}

// BodyModel ...
type BodyModel struct {
	DataRepresentation *string `json:"DataRepresentation,omitempty"`
	Value              *string `json:"Value,omitempty"`
}

// Candidate OCR candidate text.
type Candidate struct {
	// Text - The text found.
	Text *string `json:"Text,omitempty"`
	// Confidence - The confidence level.
	Confidence *float64 `json:"Confidence,omitempty"`
}

// Classification the classification details of the text.
type Classification struct {
	// AdultScore - The adult score.
	AdultScore *float64 `json:"AdultScore,omitempty"`
	// RacyScore - The racy score.
	RacyScore *float64 `json:"RacyScore,omitempty"`
	// OffensiveScore - The offensive score.
	OffensiveScore *float64 `json:"OffensiveScore,omitempty"`
	// ReviewRecommended - The review recommended flag.
	ReviewRecommended *bool `json:"ReviewRecommended,omitempty"`
}

// Content ...
type Content struct {
	// ContentValue - Content to evaluate for a job.
	ContentValue *string `json:"ContentValue,omitempty"`
}

// CreateReviewBodyItem schema items of the body.
type CreateReviewBodyItem struct {
	// Type - Type of the content. Possible values include: 'TypeImage', 'TypeText'
	Type Type `json:"Type,omitempty"`
	// Content - Content to review.
	Content *string `json:"Content,omitempty"`
	// ContentID - Content Identifier.
	ContentID *string `json:"ContentId,omitempty"`
	// CallbackEndpoint - Optional CallbackEndpoint.
	CallbackEndpoint *string `json:"CallbackEndpoint,omitempty"`
	// Metadata - Optional metadata details.
	Metadata *[]CreateReviewBodyItemMetadataItem `json:"Metadata,omitempty"`
}

// CreateReviewBodyItemMetadataItem ...
type CreateReviewBodyItemMetadataItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}

// CreateVideoReviewsBodyItem schema items of the body.
type CreateVideoReviewsBodyItem struct {
	// VideoFrames - Optional metadata details.
	VideoFrames *[]CreateVideoReviewsBodyItemVideoFramesItem `json:"VideoFrames,omitempty"`
	// Metadata - Optional metadata details.
	Metadata *[]CreateVideoReviewsBodyItemMetadataItem `json:"Metadata,omitempty"`
	// Type - Type of the content.
	Type *string `json:"Type,omitempty"`
	// Content - Video content url to review.
	Content *string `json:"Content,omitempty"`
	// ContentID - Content Identifier.
	ContentID *string `json:"ContentId,omitempty"`
	// Status - Status of the video(Complete,Unpublished,Pending). Possible values include: 'Complete', 'Unpublished', 'Pending'
	Status Status `json:"Status,omitempty"`
	// Timescale - Timescale of the video.
	Timescale *int32 `json:"Timescale,omitempty"`
	// CallbackEndpoint - Optional CallbackEndpoint.
	CallbackEndpoint *string `json:"CallbackEndpoint,omitempty"`
}

// CreateVideoReviewsBodyItemMetadataItem ...
type CreateVideoReviewsBodyItemMetadataItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}

// CreateVideoReviewsBodyItemVideoFramesItem ...
type CreateVideoReviewsBodyItemVideoFramesItem struct {
	// ID - Id of the frame.
	ID *string `json:"Id,omitempty"`
	// Timestamp - Timestamp of the frame.
	Timestamp *int32 `json:"Timestamp,omitempty"`
	// FrameImage - Frame image Url.
	FrameImage         *string                                                            `json:"FrameImage,omitempty"`
	ReviewerResultTags *[]CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem `json:"ReviewerResultTags,omitempty"`
	// Metadata - Optional metadata details.
	Metadata *[]CreateVideoReviewsBodyItemVideoFramesItemMetadataItem `json:"Metadata,omitempty"`
}

// CreateVideoReviewsBodyItemVideoFramesItemMetadataItem ...
type CreateVideoReviewsBodyItemVideoFramesItemMetadataItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}

// CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem ...
type CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}

// DetectedLanguage detect language result.
type DetectedLanguage struct {
	autorest.Response `json:"-"`
	// DetectedLanguage - The detected language.
	DetectedLanguage *string `json:"DetectedLanguage,omitempty"`
	// Status - The detect language status
	Status *Status `json:"Status,omitempty"`
	// TrackingID - The tracking id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// DetectedTerms detected Terms details.
type DetectedTerms struct {
	// Index - Index(Location) of the detected profanity term in the input text content.
	Index *int32 `json:"Index,omitempty"`
	// OriginalIndex - Original Index(Location) of the detected profanity term in the input text content.
	OriginalIndex *int32 `json:"OriginalIndex,omitempty"`
	// ListID - Matched Terms list Id.
	ListID *int32 `json:"ListId,omitempty"`
	// Term - Detected profanity term.
	Term *string `json:"Term,omitempty"`
}

// Email email Address details.
type Email struct {
	// Detected - Detected Email Address from the input text content.
	Detected *string `json:"Detected,omitempty"`
	// SubType - Subtype of the detected Email Address.
	SubType *string `json:"SubType,omitempty"`
	// Text - Email Address in the input text content.
	Text *string `json:"Text,omitempty"`
	// Index - Index(Location) of the Email address in the input text content.
	Index *int32 `json:"Index,omitempty"`
}

// Error error body.
type Error struct {
	Code    *string `json:"Code,omitempty"`
	Message *string `json:"Message,omitempty"`
}

// Evaluate evaluate response object.
type Evaluate struct {
	autorest.Response `json:"-"`
	// CacheID - The cache id.
	CacheID *string `json:"CacheID,omitempty"`
	// Result - Evaluate result.
	Result *bool `json:"Result,omitempty"`
	// TrackingID - The tracking id.
	TrackingID *string `json:"TrackingId,omitempty"`
	// AdultClassificationScore - The adult classification score.
	AdultClassificationScore *float64 `json:"AdultClassificationScore,omitempty"`
	// IsImageAdultClassified - Indicates if an image is classified as adult.
	IsImageAdultClassified *bool `json:"IsImageAdultClassified,omitempty"`
	// RacyClassificationScore - The racy classication score.
	RacyClassificationScore *float64 `json:"RacyClassificationScore,omitempty"`
	// IsImageRacyClassified - Indicates if the image is classified as racy.
	IsImageRacyClassified *bool `json:"IsImageRacyClassified,omitempty"`
	// AdvancedInfo - The advanced info.
	AdvancedInfo *[]KeyValuePair `json:"AdvancedInfo,omitempty"`
	// Status - The evaluate status
	Status *Status `json:"Status,omitempty"`
}

// Face coordinates to the found face.
type Face struct {
	// Bottom - The bottom coordinate.
	Bottom *int32 `json:"Bottom,omitempty"`
	// Left - The left coordinate.
	Left *int32 `json:"Left,omitempty"`
	// Right - The right coordinate.
	Right *int32 `json:"Right,omitempty"`
	// Top - The top coordinate.
	Top *int32 `json:"Top,omitempty"`
}

// FoundFaces request object the contains found faces.
type FoundFaces struct {
	autorest.Response `json:"-"`
	// Status - The evaluate status
	Status *Status `json:"Status,omitempty"`
	// TrackingID - The tracking id.
	TrackingID *string `json:"TrackingId,omitempty"`
	// CacheID - The cache id.
	CacheID *string `json:"CacheId,omitempty"`
	// Result - True if result was found.
	Result *bool `json:"Result,omitempty"`
	// Count - Number of faces found.
	Count *int32 `json:"Count,omitempty"`
	// AdvancedInfo - The advanced info.
	AdvancedInfo *[]KeyValuePair `json:"AdvancedInfo,omitempty"`
	// Faces - The list of faces.
	Faces *[]Face `json:"Faces,omitempty"`
}

// Frame video frame property details.
type Frame struct {
	// Timestamp - Timestamp of the frame.
	Timestamp *string `json:"Timestamp,omitempty"`
	// FrameImage - Frame image.
	FrameImage *string `json:"FrameImage,omitempty"`
	// Metadata - Array of KeyValue.
	Metadata *[]KeyValuePair `json:"Metadata,omitempty"`
	// ReviewerResultTags - Reviewer result tags.
	ReviewerResultTags *[]Tag `json:"ReviewerResultTags,omitempty"`
}

// Frames the response for a Get Frames request.
type Frames struct {
	autorest.Response `json:"-"`
	// ReviewID - Id of the review.
	ReviewID    *string  `json:"ReviewId,omitempty"`
	VideoFrames *[]Frame `json:"VideoFrames,omitempty"`
}

// Image image Properties.
type Image struct {
	autorest.Response `json:"-"`
	// ContentID - Content Id.
	ContentID *string `json:"ContentId,omitempty"`
	// AdditionalInfo - Advanced info list.
	AdditionalInfo *[]ImageAdditionalInfoItem `json:"AdditionalInfo,omitempty"`
	// Status - Status details.
	Status *Status `json:"Status,omitempty"`
	// TrackingID - Tracking Id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// ImageAdditionalInfoItem ...
type ImageAdditionalInfoItem struct {
	// Key - Key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Value parameter.
	Value *string `json:"Value,omitempty"`
}

// ImageIds image Id properties.
type ImageIds struct {
	autorest.Response `json:"-"`
	// ContentSource - Source of the content.
	ContentSource *string `json:"ContentSource,omitempty"`
	// ContentIds - Id of the contents.
	ContentIds *[]int32 `json:"ContentIds,omitempty"`
	// Status - Get Image status.
	Status *Status `json:"Status,omitempty"`
	// TrackingID - Tracking Id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// ImageList image List Properties.
type ImageList struct {
	autorest.Response `json:"-"`
	// ID - Image List Id.
	ID *int32 `json:"Id,omitempty"`
	// Name - Image List Name.
	Name *string `json:"Name,omitempty"`
	// Description - Description for image list.
	Description *string `json:"Description,omitempty"`
	// Metadata - Image List Metadata.
	Metadata *ImageListMetadata `json:"Metadata,omitempty"`
}

// ImageListMetadata image List Metadata.
type ImageListMetadata struct {
	// KeyOne - Optional Key value pair to describe your list.
	KeyOne *string `json:"Key One,omitempty"`
	// KeyTwo - Optional Key value pair to describe your list.
	KeyTwo *string `json:"Key Two,omitempty"`
}

// IPA IP Address details.
type IPA struct {
	// SubType - Subtype of the detected IP Address.
	SubType *string `json:"SubType,omitempty"`
	// Text - Detected IP Address.
	Text *string `json:"Text,omitempty"`
	// Index - Index(Location) of the IP Address in the input text content.
	Index *int32 `json:"Index,omitempty"`
}

// Job the Job object.
type Job struct {
	autorest.Response `json:"-"`
	// ID - The job id.
	ID *string `json:"Id,omitempty"`
	// TeamName - The team name associated with the job.
	TeamName *string `json:"TeamName,omitempty"`
	// Status - The status string (<Pending, Failed, Completed>).
	Status *string `json:"Status,omitempty"`
	// WorkflowID - The Id of the workflow.
	WorkflowID *string `json:"WorkflowId,omitempty"`
	// Type - Type of the content.
	Type *string `json:"Type,omitempty"`
	// CallBackEndpoint - The callback endpoint.
	CallBackEndpoint *string `json:"CallBackEndpoint,omitempty"`
	// ReviewID - Review Id if one is created.
	ReviewID *string `json:"ReviewId,omitempty"`
	// ResultMetaData - Array of KeyValue pairs.
	ResultMetaData *[]KeyValuePair `json:"ResultMetaData,omitempty"`
	// JobExecutionReport - Job execution report- Array of KeyValue pairs object.
	JobExecutionReport *[]JobExecutionReportDetails `json:"JobExecutionReport,omitempty"`
}

// JobExecutionReportDetails job Execution Report Values.
type JobExecutionReportDetails struct {
	// Ts - Time details.
	Ts *string `json:"Ts,omitempty"`
	// Msg - Message details.
	Msg *string `json:"Msg,omitempty"`
}

// JobID ...
type JobID struct {
	autorest.Response `json:"-"`
	// JobID - Id of the created job.
	JobID *string `json:"JobId,omitempty"`
}

// JobListResult the list of job ids.
type JobListResult struct {
	// Value - The job id.
	Value *[]string `json:"Value,omitempty"`
}

// KeyValuePair the key value pair object properties.
type KeyValuePair struct {
	// Key - The key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value parameter.
	Value *string `json:"Value,omitempty"`
}

// ListImageList ...
type ListImageList struct {
	autorest.Response `json:"-"`
	Value             *[]ImageList `json:"value,omitempty"`
}

// ListString ...
type ListString struct {
	autorest.Response `json:"-"`
	Value             *[]string `json:"value,omitempty"`
}

// ListTermList ...
type ListTermList struct {
	autorest.Response `json:"-"`
	Value             *[]TermList `json:"value,omitempty"`
}

// Match the match details.
type Match struct {
	// Score - Confidence score of the image match.
	Score *float64 `json:"Score,omitempty"`
	// MatchID - The match id.
	MatchID *int32 `json:"MatchId,omitempty"`
	// Source - The source.
	Source *string `json:"Source,omitempty"`
	// Tags - The tags for match details.
	Tags *[]int32 `json:"Tags,omitempty"`
	// Label - The label.
	Label *string `json:"Label,omitempty"`
}

// MatchResponse the response for a Match request.
type MatchResponse struct {
	autorest.Response `json:"-"`
	// TrackingID - The tracking id.
	TrackingID *string `json:"TrackingId,omitempty"`
	// CacheID - The cache id.
	CacheID *string `json:"CacheID,omitempty"`
	// IsMatch - Indicates if there is a match.
	IsMatch *bool `json:"IsMatch,omitempty"`
	// Matches - The match details.
	Matches *[]Match `json:"Matches,omitempty"`
	// Status - The evaluate status
	Status *Status `json:"Status,omitempty"`
}

// OCR contains the text found in image for the language specified.
type OCR struct {
	autorest.Response `json:"-"`
	// Status - The evaluate status
	Status *Status `json:"Status,omitempty"`
	// Metadata - Array of KeyValue.
	Metadata *[]KeyValuePair `json:"Metadata,omitempty"`
	// TrackingID - The tracking id.
	TrackingID *string `json:"TrackingId,omitempty"`
	// CacheID - The cache id.
	CacheID *string `json:"CacheId,omitempty"`
	// Language - The ISO 639-3 code.
	Language *string `json:"Language,omitempty"`
	// Text - The found text.
	Text *string `json:"Text,omitempty"`
	// Candidates - The list of candidate text.
	Candidates *[]Candidate `json:"Candidates,omitempty"`
}

// Phone phone Property details.
type Phone struct {
	// CountryCode - CountryCode of the detected Phone number.
	CountryCode *string `json:"CountryCode,omitempty"`
	// Text - Detected Phone number.
	Text *string `json:"Text,omitempty"`
	// Index - Index(Location) of the Phone number in the input text content.
	Index *int32 `json:"Index,omitempty"`
}

// PII personal Identifier Information details.
type PII struct {
	Email   *[]Email   `json:"Email,omitempty"`
	IPA     *[]IPA     `json:"IPA,omitempty"`
	Phone   *[]Phone   `json:"Phone,omitempty"`
	Address *[]Address `json:"Address,omitempty"`
}

// RefreshIndex refresh Index Response.
type RefreshIndex struct {
	autorest.Response `json:"-"`
	// ContentSourceID - Content source Id.
	ContentSourceID *string `json:"ContentSourceId,omitempty"`
	// IsUpdateSuccess - Update success status.
	IsUpdateSuccess *bool `json:"IsUpdateSuccess,omitempty"`
	// AdvancedInfo - Advanced info list.
	AdvancedInfo *[]RefreshIndexAdvancedInfoItem `json:"AdvancedInfo,omitempty"`
	// Status - Refresh index status.
	Status *Status `json:"Status,omitempty"`
	// TrackingID - Tracking Id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// RefreshIndexAdvancedInfoItem ...
type RefreshIndexAdvancedInfoItem struct {
	// KeyOne - Key parameter to describe advanced info.
	KeyOne *string `json:"Key One,omitempty"`
	// KeyTwo - Key parameter to describe advanced info.
	KeyTwo *string `json:"Key Two,omitempty"`
}

// Review the Review object.
type Review struct {
	autorest.Response `json:"-"`
	// ReviewID - Id of the review.
	ReviewID *string `json:"ReviewId,omitempty"`
	// SubTeam - Name of the subteam.
	SubTeam *string `json:"SubTeam,omitempty"`
	// Status - The status string (<Pending, Complete>).
	Status *string `json:"Status,omitempty"`
	// ReviewerResultTags - Array of KeyValue with Reviewer set Tags.
	ReviewerResultTags *[]KeyValuePair `json:"ReviewerResultTags,omitempty"`
	// CreatedBy - The reviewer name.
	CreatedBy *string `json:"CreatedBy,omitempty"`
	// Metadata - Array of KeyValue.
	Metadata *[]KeyValuePair `json:"Metadata,omitempty"`
	// Type - The type of content.
	Type *string `json:"Type,omitempty"`
	// Content - The content value.
	Content *string `json:"Content,omitempty"`
	// ContentID - Id of the content.
	ContentID *string `json:"ContentId,omitempty"`
	// CallbackEndpoint - The callback endpoint.
	CallbackEndpoint *string `json:"CallbackEndpoint,omitempty"`
}

// Screen the response for a Screen text request.
type Screen struct {
	autorest.Response `json:"-"`
	// OriginalText - The original text.
	OriginalText *string `json:"OriginalText,omitempty"`
	// NormalizedText - The normalized text.
	NormalizedText *string `json:"NormalizedText,omitempty"`
	// AutoCorrectedText - The autocorrected text
	AutoCorrectedText *string `json:"AutoCorrectedText,omitempty"`
	// Misrepresentation - The misrepresentation text.
	Misrepresentation *[]string `json:"Misrepresentation,omitempty"`
	// Classification - The classification details of the text.
	Classification *Classification `json:"Classification,omitempty"`
	// Status - The evaluate status.
	Status *Status `json:"Status,omitempty"`
	// PII - Personal Identifier Information details.
	PII *PII `json:"PII,omitempty"`
	// Language - Language of the input text content.
	Language *string          `json:"Language,omitempty"`
	Terms    *[]DetectedTerms `json:"Terms,omitempty"`
	// TrackingID - Unique Content Moderator transaction Id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             *map[string]interface{} `json:"value,omitempty"`
}

// Status status properties.
type Status struct {
	// Code - Status code.
	Code *int32 `json:"Code,omitempty"`
	// Description - Status description.
	Description *string `json:"Description,omitempty"`
	// Exception - Exception status.
	Exception *string `json:"Exception,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// Tag tag details.
type Tag struct {
	// Key - The key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - The value parameter.
	Value *string `json:"Value,omitempty"`
}

// TermList term List  Properties.
type TermList struct {
	autorest.Response `json:"-"`
	// ID - Term list Id.
	ID *int32 `json:"Id,omitempty"`
	// Name - Term list name.
	Name *string `json:"Name,omitempty"`
	// Description - Description for term list.
	Description *string `json:"Description,omitempty"`
	// Metadata - Term list metadata.
	Metadata *TermListMetadata `json:"Metadata,omitempty"`
}

// TermListMetadata term list metadata.
type TermListMetadata struct {
	// KeyOne - Optional Key value pair to describe your list.
	KeyOne *string `json:"Key One,omitempty"`
	// KeyTwo - Optional Key value pair to describe your list.
	KeyTwo *string `json:"Key Two,omitempty"`
}

// Terms terms properties.
type Terms struct {
	autorest.Response `json:"-"`
	// Data - Term data details.
	Data *TermsData `json:"Data,omitempty"`
	// Paging - Paging details.
	Paging *TermsPaging `json:"Paging,omitempty"`
}

// TermsData all term Id response properties.
type TermsData struct {
	// Language - Language of the terms.
	Language *string `json:"Language,omitempty"`
	// Terms - List of terms.
	Terms *[]TermsInList `json:"Terms,omitempty"`
	// Status - Term Status.
	Status *Status `json:"Status,omitempty"`
	// TrackingID - Tracking Id.
	TrackingID *string `json:"TrackingId,omitempty"`
}

// TermsInList terms in list Id passed.
type TermsInList struct {
	// Term - Added term details.
	Term *string `json:"Term,omitempty"`
}

// TermsPaging paging details.
type TermsPaging struct {
	// Total - Total details.
	Total *int32 `json:"Total,omitempty"`
	// Limit - Limit details.
	Limit *int32 `json:"Limit,omitempty"`
	// Offset - Offset details.
	Offset *int32 `json:"Offset,omitempty"`
	// Returned - Returned text details.
	Returned *int32 `json:"Returned,omitempty"`
}

// TranscriptModerationBodyItem schema items of the body.
type TranscriptModerationBodyItem struct {
	// Timestamp - Timestamp of the image.
	Timestamp *string `json:"Timestamp,omitempty"`
	// Terms - Optional metadata details.
	Terms *[]TranscriptModerationBodyItemTermsItem `json:"Terms,omitempty"`
}

// TranscriptModerationBodyItemTermsItem ...
type TranscriptModerationBodyItemTermsItem struct {
	// Index - Index of the word
	Index *int32 `json:"Index,omitempty"`
	// Term - Detected word.
	Term *string `json:"Term,omitempty"`
}

// VideoFrameBodyItem schema items of the body.
type VideoFrameBodyItem struct {
	// Timestamp - Timestamp of the frame.
	Timestamp *string `json:"Timestamp,omitempty"`
	// FrameImage - Content to review.
	FrameImage         *string                                     `json:"FrameImage,omitempty"`
	ReviewerResultTags *[]VideoFrameBodyItemReviewerResultTagsItem `json:"ReviewerResultTags,omitempty"`
	// Metadata - Optional metadata details.
	Metadata *[]VideoFrameBodyItemMetadataItem `json:"Metadata,omitempty"`
}

// VideoFrameBodyItemMetadataItem ...
type VideoFrameBodyItemMetadataItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}

// VideoFrameBodyItemReviewerResultTagsItem ...
type VideoFrameBodyItemReviewerResultTagsItem struct {
	// Key - Your key parameter.
	Key *string `json:"Key,omitempty"`
	// Value - Your value parameter.
	Value *string `json:"Value,omitempty"`
}
