package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// Active ...
	Active CustomDomainResourceState = "Active"
	// Creating ...
	Creating CustomDomainResourceState = "Creating"
	// Deleting ...
	Deleting CustomDomainResourceState = "Deleting"
)

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// Allow ...
	Allow GeoFilterActions = "Allow"
	// Block ...
	Block GeoFilterActions = "Block"
)

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// BypassCaching ...
	BypassCaching QueryStringCachingBehavior = "BypassCaching"
	// IgnoreQueryString ...
	IgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// NotSet ...
	NotSet QueryStringCachingBehavior = "NotSet"
	// UseQueryString ...
	UseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CidrIPAddress CIDR Ip address
type CidrIPAddress struct {
	// BaseIPAddress - Ip adress itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`
	// PrefixLength - The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// CustomDomain customer provided domain for branding purposes, e.g. www.consoto.com.
type CustomDomain struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*CustomDomainProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CustomDomain struct.
func (cd *CustomDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties CustomDomainProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cd.CustomDomainProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cd.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cd.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		cd.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		cd.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		cd.Tags = &tags
	}

	return nil
}

// CustomDomainListResult result of the request to list custom domains. It contains a list of custom domain objects and
// a URL link to get the next set of results.
type CustomDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN CustomDomains within an endpoint.
	Value *[]CustomDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainListResultIterator provides access to a complete listing of CustomDomain values.
type CustomDomainListResultIterator struct {
	i    int
	page CustomDomainListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainListResultIterator) Response() CustomDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainListResultIterator) Value() CustomDomain {
	if !iter.page.NotDone() {
		return CustomDomain{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cdlr CustomDomainListResult) IsEmpty() bool {
	return cdlr.Value == nil || len(*cdlr.Value) == 0
}

// customDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdlr CustomDomainListResult) customDomainListResultPreparer() (*http.Request, error) {
	if cdlr.NextLink == nil || len(to.String(cdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdlr.NextLink)))
}

// CustomDomainListResultPage contains a page of CustomDomain values.
type CustomDomainListResultPage struct {
	fn   func(CustomDomainListResult) (CustomDomainListResult, error)
	cdlr CustomDomainListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainListResultPage) Next() error {
	next, err := page.fn(page.cdlr)
	if err != nil {
		return err
	}
	page.cdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainListResultPage) NotDone() bool {
	return !page.cdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainListResultPage) Response() CustomDomainListResult {
	return page.cdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainListResultPage) Values() []CustomDomain {
	if page.cdlr.IsEmpty() {
		return nil
	}
	return *page.cdlr.Value
}

// CustomDomainParameters the customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	*CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainParameters struct.
func (cdp *CustomDomainParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties CustomDomainPropertiesParameters
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		cdp.CustomDomainPropertiesParameters = &properties
	}

	return nil
}

// CustomDomainProperties the JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ResourceState - Resource status of the custom domain. Possible values include: 'Creating', 'Active', 'Deleting'
	ResourceState CustomDomainResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - Provisioning state of Custom Https of the custom domain. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// ValidationData - Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`
	// ProvisioningState - Provisioning status of the custom domain.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CustomDomainPropertiesParameters the JSON object that contains the properties of the custom domain to create.
type CustomDomainPropertiesParameters struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CustomDomainsCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future CustomDomainsCreateFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return cd, autorest.NewError("cdn.CustomDomainsCreateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		cd, err = client.CreateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	cd, err = client.CreateResponder(resp)
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CustomDomainsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future CustomDomainsDeleteFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return cd, autorest.NewError("cdn.CustomDomainsDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		cd, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	cd, err = client.DeleteResponder(resp)
	return
}

// DeepCreatedOrigin origin to be added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// Name - Origin name
	Name                         *string `json:"name,omitempty"`
	*DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOrigin struct.
func (dco *DeepCreatedOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		dco.Name = &name
	}

	v = m["properties"]
	if v != nil {
		var properties DeepCreatedOriginProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		dco.DeepCreatedOriginProperties = &properties
	}

	return nil
}

// DeepCreatedOriginProperties properties of origin Properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// HostName - The address of the origin. It can be a domain names, IPv4 address, or IPv6 address.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// EdgeNode edge node of CDN service.
type EdgeNode struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags                *map[string]*string `json:"tags,omitempty"`
	*EdgeNodeProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EdgeNode struct.
func (en *EdgeNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties EdgeNodeProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		en.EdgeNodeProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		en.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		en.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		en.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		en.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		en.Tags = &tags
	}

	return nil
}

// EdgeNodeProperties the JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// IPAddressGroups - List of ip address groups.
	IPAddressGroups *[]IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgenodeResult result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to
// get the next set of results.
type EdgenodeResult struct {
	autorest.Response `json:"-"`
	// Value - Edge node of CDN service.
	Value *[]EdgeNode `json:"value,omitempty"`
	// NextLink - URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgenodeResultIterator provides access to a complete listing of EdgeNode values.
type EdgenodeResultIterator struct {
	i    int
	page EdgenodeResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgenodeResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgenodeResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgenodeResultIterator) Response() EdgenodeResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgenodeResultIterator) Value() EdgeNode {
	if !iter.page.NotDone() {
		return EdgeNode{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (er EdgenodeResult) IsEmpty() bool {
	return er.Value == nil || len(*er.Value) == 0
}

// edgenodeResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (er EdgenodeResult) edgenodeResultPreparer() (*http.Request, error) {
	if er.NextLink == nil || len(to.String(er.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(er.NextLink)))
}

// EdgenodeResultPage contains a page of EdgeNode values.
type EdgenodeResultPage struct {
	fn func(EdgenodeResult) (EdgenodeResult, error)
	er EdgenodeResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgenodeResultPage) Next() error {
	next, err := page.fn(page.er)
	if err != nil {
		return err
	}
	page.er = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgenodeResultPage) NotDone() bool {
	return !page.er.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgenodeResultPage) Response() EdgenodeResult {
	return page.er
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgenodeResultPage) Values() []EdgeNode {
	if page.er.IsEmpty() {
		return nil
	}
	return *page.er.Value
}

// Endpoint CDN endpoint is the entity within a CDN profile containing configuration information such as origin,
// protocol, content caching and delivery behavior. The CDN endpoint uses the URL format <endpointname>.azureedge.net.
type Endpoint struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags                *map[string]*string `json:"tags,omitempty"`
	*EndpointProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties EndpointProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		e.EndpointProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		e.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		e.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		e.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		e.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		e.Tags = &tags
	}

	return nil
}

// EndpointListResult result of the request to list endpoints. It contains a list of endpoint objects and a URL link to
// get the the next set of results.
type EndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN endpoints within a profile
	Value *[]Endpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointListResultIterator provides access to a complete listing of Endpoint values.
type EndpointListResultIterator struct {
	i    int
	page EndpointListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointListResultIterator) Response() EndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointListResultIterator) Value() Endpoint {
	if !iter.page.NotDone() {
		return Endpoint{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EndpointListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// endpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EndpointListResult) endpointListResultPreparer() (*http.Request, error) {
	if elr.NextLink == nil || len(to.String(elr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EndpointListResultPage contains a page of Endpoint values.
type EndpointListResultPage struct {
	fn  func(EndpointListResult) (EndpointListResult, error)
	elr EndpointListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointListResultPage) Next() error {
	next, err := page.fn(page.elr)
	if err != nil {
		return err
	}
	page.elr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointListResultPage) Response() EndpointListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointListResultPage) Values() []Endpoint {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// EndpointProperties the JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// OriginHostHeader - The host header CDN sends along with content requests to origin. The default value is the host name of the origin.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - The path used when CDN sends request to origin.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines the query string caching behavior. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Customer can specify what scenario they want this CDN endpoint to optimize, e.g. Download, Media services. With this information we can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// GeoFilters - List of rules defining user geo access within a CDN endpoint. Each geo filter defines an acess rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// HostName - The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. consoto.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// Origins - The source of the content being delivered via CDN.
	Origins *[]DeepCreatedOrigin `json:"origins,omitempty"`
	// ResourceState - Resource status of the endpoint. Possible values include: 'EndpointResourceStateCreating', 'EndpointResourceStateDeleting', 'EndpointResourceStateRunning', 'EndpointResourceStateStarting', 'EndpointResourceStateStopped', 'EndpointResourceStateStopping'
	ResourceState EndpointResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// EndpointPropertiesUpdateParameters result of the request to list endpoints. It contains a list of endpoints and a
// URL link to get the next set of results.
type EndpointPropertiesUpdateParameters struct {
	// OriginHostHeader - The host header CDN sends along with content requests to origin. The default value is the host name of the origin.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - The path used when CDN sends request to origin.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines the query string caching behavior. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Customer can specify what scenario they want this CDN endpoint to optimize, e.g. Download, Media services. With this information we can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// GeoFilters - List of rules defining user geo access within a CDN endpoint. Each geo filter defines an acess rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
}

// EndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsCreateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return e, autorest.NewError("cdn.EndpointsCreateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		e, err = client.CreateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	e, err = client.CreateResponder(resp)
	return
}

// EndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsDeleteFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("cdn.EndpointsDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// EndpointsLoadContentFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsLoadContentFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsLoadContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("cdn.EndpointsLoadContentFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.LoadContentResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.LoadContentResponder(resp)
	return
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsPurgeContentFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsPurgeContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("cdn.EndpointsPurgeContentFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.PurgeContentResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.PurgeContentResponder(resp)
	return
}

// EndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStartFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsStartFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return e, autorest.NewError("cdn.EndpointsStartFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		e, err = client.StartResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	e, err = client.StartResponder(resp)
	return
}

// EndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStopFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsStopFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return e, autorest.NewError("cdn.EndpointsStopFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		e, err = client.StopResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	e, err = client.StopResponder(resp)
	return
}

// EndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future EndpointsUpdateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return e, autorest.NewError("cdn.EndpointsUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		e, err = client.UpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	e, err = client.UpdateResponder(resp)
	return
}

// EndpointUpdateParameters properties required to create a new endpoint.
type EndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                *map[string]*string `json:"tags,omitempty"`
	*EndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EndpointUpdateParameters struct.
func (eup *EndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		eup.Tags = &tags
	}

	v = m["properties"]
	if v != nil {
		var properties EndpointPropertiesUpdateParameters
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		eup.EndpointPropertiesUpdateParameters = &properties
	}

	return nil
}

// ErrorResponse error reponse indicates CDN service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GeoFilter rules defining user geo access within a CDN endpoint.
type GeoFilter struct {
	// RelativePath - Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
	// Action - Action of the geo filter, i.e. allow or block access. Possible values include: 'Block', 'Allow'
	Action GeoFilterActions `json:"action,omitempty"`
	// CountryCodes - Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
	CountryCodes *[]string `json:"countryCodes,omitempty"`
}

// IPAddressGroup CDN Ip address group
type IPAddressGroup struct {
	// DeliveryRegion - The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`
	// Ipv4Addresses - The list of ip v4 addresses.
	Ipv4Addresses *[]CidrIPAddress `json:"ipv4Addresses,omitempty"`
	// Ipv6Addresses - The list of ip v6 addresses.
	Ipv6Addresses *[]CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// LoadParameters parameters required for content load.
type LoadParameters struct {
	// ContentPaths - The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Operation CDN REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list CDN operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Origin CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an
// endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured
// origins.
type Origin struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags              *map[string]*string `json:"tags,omitempty"`
	*OriginProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Origin struct.
func (o *Origin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties OriginProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		o.OriginProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		o.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		o.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		o.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		o.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		o.Tags = &tags
	}

	return nil
}

// OriginListResult result of the request to list origins. It contains a list of origin objects and a URL link to get
// the next set of results.
type OriginListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN origins within an endpoint
	Value *[]Origin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OriginListResultIterator provides access to a complete listing of Origin values.
type OriginListResultIterator struct {
	i    int
	page OriginListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginListResultIterator) Response() OriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginListResultIterator) Value() Origin {
	if !iter.page.NotDone() {
		return Origin{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OriginListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// originListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OriginListResult) originListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OriginListResultPage contains a page of Origin values.
type OriginListResultPage struct {
	fn  func(OriginListResult) (OriginListResult, error)
	olr OriginListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginListResultPage) Response() OriginListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginListResultPage) Values() []Origin {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OriginProperties the JSON object that contains the properties of the origin to create.
type OriginProperties struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the https port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// ResourceState - Resource status of the origin. Possible values include: 'OriginResourceStateCreating', 'OriginResourceStateActive', 'OriginResourceStateDeleting'
	ResourceState OriginResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the origin.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// OriginPropertiesParameters the JSON object that contains the properties of the origin to create.
type OriginPropertiesParameters struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// OriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OriginsUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future OriginsUpdateFuture) Result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return o, autorest.NewError("cdn.OriginsUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		o, err = client.UpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	o, err = client.UpdateResponder(resp)
	return
}

// OriginUpdateParameters origin properties needed for origin creation or update.
type OriginUpdateParameters struct {
	*OriginPropertiesParameters `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OriginUpdateParameters struct.
func (oup *OriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		var properties OriginPropertiesParameters
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		oup.OriginPropertiesParameters = &properties
	}

	return nil
}

// Profile CDN profile represents the top level resource and the entry point into the CDN API. This allows users to set
// up a logical grouping of endpoints in addition to creating shared configuration settings and selecting pricing tiers
// and providers.
type Profile struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
	Sku                *Sku `json:"sku,omitempty"`
	*ProfileProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["sku"]
	if v != nil {
		var sku Sku
		err = json.Unmarshal(*m["sku"], &sku)
		if err != nil {
			return err
		}
		p.Sku = &sku
	}

	v = m["properties"]
	if v != nil {
		var properties ProfileProperties
		err = json.Unmarshal(*m["properties"], &properties)
		if err != nil {
			return err
		}
		p.ProfileProperties = &properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		p.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		p.Type = &typeVar
	}

	v = m["location"]
	if v != nil {
		var location string
		err = json.Unmarshal(*m["location"], &location)
		if err != nil {
			return err
		}
		p.Location = &location
	}

	v = m["tags"]
	if v != nil {
		var tags map[string]*string
		err = json.Unmarshal(*m["tags"], &tags)
		if err != nil {
			return err
		}
		p.Tags = &tags
	}

	return nil
}

// ProfileListResult result of the request to list profiles. It contains a list of profile objects and a URL link to
// get the the next set of results.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN profiles within a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer() (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) Next() error {
	next, err := page.fn(page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// ProfileProperties the JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// ResourceState - Resource status of the profile. Possible values include: 'ProfileResourceStateCreating', 'ProfileResourceStateActive', 'ProfileResourceStateDeleting', 'ProfileResourceStateDisabled'
	ResourceState ProfileResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the profile.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ProfilesCreateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return p, autorest.NewError("cdn.ProfilesCreateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		p, err = client.CreateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	p, err = client.CreateResponder(resp)
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ProfilesDeleteFuture) Result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return ar, autorest.NewError("cdn.ProfilesDeleteFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	ar, err = client.DeleteResponder(resp)
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesUpdateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		return
	}
	if !done {
		return p, autorest.NewError("cdn.ProfilesUpdateFuture", "Result", "asynchronous operation has not completed")
	}
	if future.PollingMethod() == azure.PollingLocation {
		p, err = client.UpdateResponder(future.Response())
		return
	}
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, autorest.ChangeToGet(future.req),
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		return
	}
	p, err = client.UpdateResponder(resp)
	return
}

// ProfileUpdateParameters properties required to update a profile.
type ProfileUpdateParameters struct {
	// Tags - Profile tags
	Tags *map[string]*string `json:"tags,omitempty"`
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Resource the Resource definition.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags *map[string]*string `json:"tags,omitempty"`
}

// ResourceUsage output of check resource usage API.
type ResourceUsage struct {
	// ResourceType - Resource type of the usages.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit - Unit of the usage. e.g. Count.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Actual value of the resource type.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Quota of the resource type.
	Limit *int32 `json:"limit,omitempty"`
}

// ResourceUsageListResult output of check resource usage API.
type ResourceUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - List of resource usages.
	Value *[]ResourceUsage `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceUsageListResultIterator provides access to a complete listing of ResourceUsage values.
type ResourceUsageListResultIterator struct {
	i    int
	page ResourceUsageListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceUsageListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceUsageListResultIterator) Response() ResourceUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceUsageListResultIterator) Value() ResourceUsage {
	if !iter.page.NotDone() {
		return ResourceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rulr ResourceUsageListResult) IsEmpty() bool {
	return rulr.Value == nil || len(*rulr.Value) == 0
}

// resourceUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rulr ResourceUsageListResult) resourceUsageListResultPreparer() (*http.Request, error) {
	if rulr.NextLink == nil || len(to.String(rulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rulr.NextLink)))
}

// ResourceUsageListResultPage contains a page of ResourceUsage values.
type ResourceUsageListResultPage struct {
	fn   func(ResourceUsageListResult) (ResourceUsageListResult, error)
	rulr ResourceUsageListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceUsageListResultPage) Next() error {
	next, err := page.fn(page.rulr)
	if err != nil {
		return err
	}
	page.rulr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceUsageListResultPage) NotDone() bool {
	return !page.rulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceUsageListResultPage) Response() ResourceUsageListResult {
	return page.rulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceUsageListResultPage) Values() []ResourceUsage {
	if page.rulr.IsEmpty() {
		return nil
	}
	return *page.rulr.Value
}

// Sku the pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
type Sku struct {
	// Name - Name of the pricing tier. Possible values include: 'StandardVerizon', 'PremiumVerizon', 'CustomVerizon', 'StandardAkamai', 'StandardChinaCdn'
	Name SkuName `json:"name,omitempty"`
}

// SsoURI SSO URI required to login to the supplemental portal.
type SsoURI struct {
	autorest.Response `json:"-"`
	// SsoURIValue - The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty"`
}

// SupportedOptimizationTypesResult the result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesResult struct {
	autorest.Response `json:"-"`
	// SupportedOptimizationTypes - Supported optimization types for a profile.
	SupportedOptimizationTypes *[]OptimizationType `json:"supportedOptimizationTypes,omitempty"`
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - Indicates whether the custom domain is validated or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}
