// +build go1.9

// Copyright 2017 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder
// commit ID: 2014fbbf031942474ad27a5a66dffaed5347f3fb

package servicefabric

import original "github.com/Azure/azure-sdk-for-go/services/servicefabric/6.0/servicefabric"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type AggregatedHealthState = original.AggregatedHealthState

const (
	Error   AggregatedHealthState = original.Error
	Invalid AggregatedHealthState = original.Invalid
	Ok      AggregatedHealthState = original.Ok
	Unknown AggregatedHealthState = original.Unknown
	Warning AggregatedHealthState = original.Warning
)

type AggregatedHealthState1 = original.AggregatedHealthState1

const (
	AggregatedHealthState1Error   AggregatedHealthState1 = original.AggregatedHealthState1Error
	AggregatedHealthState1Invalid AggregatedHealthState1 = original.AggregatedHealthState1Invalid
	AggregatedHealthState1Ok      AggregatedHealthState1 = original.AggregatedHealthState1Ok
	AggregatedHealthState1Unknown AggregatedHealthState1 = original.AggregatedHealthState1Unknown
	AggregatedHealthState1Warning AggregatedHealthState1 = original.AggregatedHealthState1Warning
)

type AggregatedHealthState2 = original.AggregatedHealthState2

const (
	AggregatedHealthState2Error   AggregatedHealthState2 = original.AggregatedHealthState2Error
	AggregatedHealthState2Invalid AggregatedHealthState2 = original.AggregatedHealthState2Invalid
	AggregatedHealthState2Ok      AggregatedHealthState2 = original.AggregatedHealthState2Ok
	AggregatedHealthState2Unknown AggregatedHealthState2 = original.AggregatedHealthState2Unknown
	AggregatedHealthState2Warning AggregatedHealthState2 = original.AggregatedHealthState2Warning
)

type ApplicationDefinitionKind = original.ApplicationDefinitionKind

const (
	ApplicationDefinitionKindCompose                             ApplicationDefinitionKind = original.ApplicationDefinitionKindCompose
	ApplicationDefinitionKindInvalid                             ApplicationDefinitionKind = original.ApplicationDefinitionKindInvalid
	ApplicationDefinitionKindServiceFabricApplicationDescription ApplicationDefinitionKind = original.ApplicationDefinitionKindServiceFabricApplicationDescription
)

type ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKind

const (
	ApplicationTypeDefinitionKindCompose                         ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindCompose
	ApplicationTypeDefinitionKindInvalid                         ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindInvalid
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindServiceFabricApplicationPackage
)

type Code = original.Code

const (
	EABORT                                    Code = original.EABORT
	FABRICEAPPLICATIONALREADYEXISTS           Code = original.FABRICEAPPLICATIONALREADYEXISTS
	FABRICEAPPLICATIONALREADYINTARGETVERSION  Code = original.FABRICEAPPLICATIONALREADYINTARGETVERSION
	FABRICEAPPLICATIONNOTFOUND                Code = original.FABRICEAPPLICATIONNOTFOUND
	FABRICEAPPLICATIONNOTUPGRADING            Code = original.FABRICEAPPLICATIONNOTUPGRADING
	FABRICEAPPLICATIONTYPEALREADYEXISTS       Code = original.FABRICEAPPLICATIONTYPEALREADYEXISTS
	FABRICEAPPLICATIONTYPEINUSE               Code = original.FABRICEAPPLICATIONTYPEINUSE
	FABRICEAPPLICATIONTYPENOTFOUND            Code = original.FABRICEAPPLICATIONTYPENOTFOUND
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS Code = original.FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS
	FABRICEAPPLICATIONUPGRADEINPROGRESS       Code = original.FABRICEAPPLICATIONUPGRADEINPROGRESS
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR  Code = original.FABRICEAPPLICATIONUPGRADEVALIDATIONERROR
	FABRICECOMMUNICATIONERROR                 Code = original.FABRICECOMMUNICATIONERROR
	FABRICECONFIGURATIONPARAMETERNOTFOUND     Code = original.FABRICECONFIGURATIONPARAMETERNOTFOUND
	FABRICECONFIGURATIONSECTIONNOTFOUND       Code = original.FABRICECONFIGURATIONSECTIONNOTFOUND
	FABRICEDIRECTORYNOTFOUND                  Code = original.FABRICEDIRECTORYNOTFOUND
	FABRICEENUMERATIONCOMPLETED               Code = original.FABRICEENUMERATIONCOMPLETED
	FABRICEFABRICALREADYINTARGETVERSION       Code = original.FABRICEFABRICALREADYINTARGETVERSION
	FABRICEFABRICNOTUPGRADING                 Code = original.FABRICEFABRICNOTUPGRADING
	FABRICEFABRICUPGRADEINPROGRESS            Code = original.FABRICEFABRICUPGRADEINPROGRESS
	FABRICEFABRICUPGRADEVALIDATIONERROR       Code = original.FABRICEFABRICUPGRADEVALIDATIONERROR
	FABRICEFABRICVERSIONALREADYEXISTS         Code = original.FABRICEFABRICVERSIONALREADYEXISTS
	FABRICEFABRICVERSIONINUSE                 Code = original.FABRICEFABRICVERSIONINUSE
	FABRICEFABRICVERSIONNOTFOUND              Code = original.FABRICEFABRICVERSIONNOTFOUND
	FABRICEFILENOTFOUND                       Code = original.FABRICEFILENOTFOUND
	FABRICEHEALTHENTITYNOTFOUND               Code = original.FABRICEHEALTHENTITYNOTFOUND
	FABRICEHEALTHSTALEREPORT                  Code = original.FABRICEHEALTHSTALEREPORT
	FABRICEIMAGEBUILDERVALIDATIONERROR        Code = original.FABRICEIMAGEBUILDERVALIDATIONERROR
	FABRICEINSTANCEIDMISMATCH                 Code = original.FABRICEINSTANCEIDMISMATCH
	FABRICEINVALIDADDRESS                     Code = original.FABRICEINVALIDADDRESS
	FABRICEINVALIDATOMICGROUP                 Code = original.FABRICEINVALIDATOMICGROUP
	FABRICEINVALIDCONFIGURATION               Code = original.FABRICEINVALIDCONFIGURATION
	FABRICEINVALIDNAMEURI                     Code = original.FABRICEINVALIDNAMEURI
	FABRICEINVALIDPARTITIONKEY                Code = original.FABRICEINVALIDPARTITIONKEY
	FABRICEKEYNOTFOUND                        Code = original.FABRICEKEYNOTFOUND
	FABRICEKEYTOOLARGE                        Code = original.FABRICEKEYTOOLARGE
	FABRICENAMEALREADYEXISTS                  Code = original.FABRICENAMEALREADYEXISTS
	FABRICENAMEDOESNOTEXIST                   Code = original.FABRICENAMEDOESNOTEXIST
	FABRICENAMENOTEMPTY                       Code = original.FABRICENAMENOTEMPTY
	FABRICENODEHASNOTSTOPPEDYET               Code = original.FABRICENODEHASNOTSTOPPEDYET
	FABRICENODEISUP                           Code = original.FABRICENODEISUP
	FABRICENODENOTFOUND                       Code = original.FABRICENODENOTFOUND
	FABRICENOTPRIMARY                         Code = original.FABRICENOTPRIMARY
	FABRICENOTREADY                           Code = original.FABRICENOTREADY
	FABRICENOWRITEQUORUM                      Code = original.FABRICENOWRITEQUORUM
	FABRICEOPERATIONNOTCOMPLETE               Code = original.FABRICEOPERATIONNOTCOMPLETE
	FABRICEPARTITIONNOTFOUND                  Code = original.FABRICEPARTITIONNOTFOUND
	FABRICEPATHTOOLONG                        Code = original.FABRICEPATHTOOLONG
	FABRICEPROPERTYCHECKFAILED                Code = original.FABRICEPROPERTYCHECKFAILED
	FABRICEPROPERTYDOESNOTEXIST               Code = original.FABRICEPROPERTYDOESNOTEXIST
	FABRICERECONFIGURATIONPENDING             Code = original.FABRICERECONFIGURATIONPENDING
	FABRICEREPLICADOESNOTEXIST                Code = original.FABRICEREPLICADOESNOTEXIST
	FABRICESEQUENCENUMBERCHECKFAILED          Code = original.FABRICESEQUENCENUMBERCHECKFAILED
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED   Code = original.FABRICESERVICEAFFINITYCHAINNOTSUPPORTED
	FABRICESERVICEALREADYEXISTS               Code = original.FABRICESERVICEALREADYEXISTS
	FABRICESERVICEDOESNOTEXIST                Code = original.FABRICESERVICEDOESNOTEXIST
	FABRICESERVICEGROUPALREADYEXISTS          Code = original.FABRICESERVICEGROUPALREADYEXISTS
	FABRICESERVICEGROUPDOESNOTEXIST           Code = original.FABRICESERVICEGROUPDOESNOTEXIST
	FABRICESERVICEMANIFESTNOTFOUND            Code = original.FABRICESERVICEMANIFESTNOTFOUND
	FABRICESERVICEMETADATAMISMATCH            Code = original.FABRICESERVICEMETADATAMISMATCH
	FABRICESERVICEOFFLINE                     Code = original.FABRICESERVICEOFFLINE
	FABRICESERVICETYPEMISMATCH                Code = original.FABRICESERVICETYPEMISMATCH
	FABRICESERVICETYPENOTFOUND                Code = original.FABRICESERVICETYPENOTFOUND
	FABRICESERVICETYPETEMPLATENOTFOUND        Code = original.FABRICESERVICETYPETEMPLATENOTFOUND
	FABRICETIMEOUT                            Code = original.FABRICETIMEOUT
	FABRICEVALUEEMPTY                         Code = original.FABRICEVALUEEMPTY
	FABRICEVALUETOOLARGE                      Code = original.FABRICEVALUETOOLARGE
)

type CreateFabricDump = original.CreateFabricDump

const (
	False CreateFabricDump = original.False
	True  CreateFabricDump = original.True
)

type CurrentReplicatorOperation = original.CurrentReplicatorOperation

const (
	CurrentReplicatorOperationAbort          CurrentReplicatorOperation = original.CurrentReplicatorOperationAbort
	CurrentReplicatorOperationBuild          CurrentReplicatorOperation = original.CurrentReplicatorOperationBuild
	CurrentReplicatorOperationChangeRole     CurrentReplicatorOperation = original.CurrentReplicatorOperationChangeRole
	CurrentReplicatorOperationClose          CurrentReplicatorOperation = original.CurrentReplicatorOperationClose
	CurrentReplicatorOperationInvalid        CurrentReplicatorOperation = original.CurrentReplicatorOperationInvalid
	CurrentReplicatorOperationNone           CurrentReplicatorOperation = original.CurrentReplicatorOperationNone
	CurrentReplicatorOperationOnDataLoss     CurrentReplicatorOperation = original.CurrentReplicatorOperationOnDataLoss
	CurrentReplicatorOperationOpen           CurrentReplicatorOperation = original.CurrentReplicatorOperationOpen
	CurrentReplicatorOperationUpdateEpoch    CurrentReplicatorOperation = original.CurrentReplicatorOperationUpdateEpoch
	CurrentReplicatorOperationWaitForCatchup CurrentReplicatorOperation = original.CurrentReplicatorOperationWaitForCatchup
)

type CurrentServiceOperation = original.CurrentServiceOperation

const (
	CurrentServiceOperationAbort      CurrentServiceOperation = original.CurrentServiceOperationAbort
	CurrentServiceOperationChangeRole CurrentServiceOperation = original.CurrentServiceOperationChangeRole
	CurrentServiceOperationClose      CurrentServiceOperation = original.CurrentServiceOperationClose
	CurrentServiceOperationNone       CurrentServiceOperation = original.CurrentServiceOperationNone
	CurrentServiceOperationOpen       CurrentServiceOperation = original.CurrentServiceOperationOpen
	CurrentServiceOperationUnknown    CurrentServiceOperation = original.CurrentServiceOperationUnknown
)

type DeactivationIntent = original.DeactivationIntent

const (
	Pause      DeactivationIntent = original.Pause
	RemoveData DeactivationIntent = original.RemoveData
	Restart    DeactivationIntent = original.Restart
)

type DefaultMoveCost = original.DefaultMoveCost

const (
	High   DefaultMoveCost = original.High
	Low    DefaultMoveCost = original.Low
	Medium DefaultMoveCost = original.Medium
	Zero   DefaultMoveCost = original.Zero
)

type DefaultMoveCost1 = original.DefaultMoveCost1

const (
	DefaultMoveCost1High   DefaultMoveCost1 = original.DefaultMoveCost1High
	DefaultMoveCost1Low    DefaultMoveCost1 = original.DefaultMoveCost1Low
	DefaultMoveCost1Medium DefaultMoveCost1 = original.DefaultMoveCost1Medium
	DefaultMoveCost1Zero   DefaultMoveCost1 = original.DefaultMoveCost1Zero
)

type EntityKind = original.EntityKind

const (
	EntityKindApplication            EntityKind = original.EntityKindApplication
	EntityKindCluster                EntityKind = original.EntityKindCluster
	EntityKindDeployedApplication    EntityKind = original.EntityKindDeployedApplication
	EntityKindDeployedServicePackage EntityKind = original.EntityKindDeployedServicePackage
	EntityKindInvalid                EntityKind = original.EntityKindInvalid
	EntityKindNode                   EntityKind = original.EntityKindNode
	EntityKindPartition              EntityKind = original.EntityKindPartition
	EntityKindReplica                EntityKind = original.EntityKindReplica
	EntityKindService                EntityKind = original.EntityKindService
)

type FailureAction = original.FailureAction

const (
	FailureActionInvalid  FailureAction = original.FailureActionInvalid
	FailureActionManual   FailureAction = original.FailureActionManual
	FailureActionRollback FailureAction = original.FailureActionRollback
)

type FailureAction1 = original.FailureAction1

const (
	FailureAction1Invalid  FailureAction1 = original.FailureAction1Invalid
	FailureAction1Manual   FailureAction1 = original.FailureAction1Manual
	FailureAction1Rollback FailureAction1 = original.FailureAction1Rollback
)

type FailureReason = original.FailureReason

const (
	HealthCheck          FailureReason = original.HealthCheck
	Interrupted          FailureReason = original.Interrupted
	None                 FailureReason = original.None
	UpgradeDomainTimeout FailureReason = original.UpgradeDomainTimeout
	UpgradeTimeout       FailureReason = original.UpgradeTimeout
)

type FailureReason1 = original.FailureReason1

const (
	FailureReason1HealthCheck          FailureReason1 = original.FailureReason1HealthCheck
	FailureReason1Interrupted          FailureReason1 = original.FailureReason1Interrupted
	FailureReason1None                 FailureReason1 = original.FailureReason1None
	FailureReason1UpgradeDomainTimeout FailureReason1 = original.FailureReason1UpgradeDomainTimeout
	FailureReason1UpgradeTimeout       FailureReason1 = original.FailureReason1UpgradeTimeout
)

type FailureReason2 = original.FailureReason2

const (
	FailureReason2HealthCheck          FailureReason2 = original.FailureReason2HealthCheck
	FailureReason2Interrupted          FailureReason2 = original.FailureReason2Interrupted
	FailureReason2None                 FailureReason2 = original.FailureReason2None
	FailureReason2UpgradeDomainTimeout FailureReason2 = original.FailureReason2UpgradeDomainTimeout
	FailureReason2UpgradeTimeout       FailureReason2 = original.FailureReason2UpgradeTimeout
)

type HealthState = original.HealthState

const (
	HealthStateError   HealthState = original.HealthStateError
	HealthStateInvalid HealthState = original.HealthStateInvalid
	HealthStateOk      HealthState = original.HealthStateOk
	HealthStateUnknown HealthState = original.HealthStateUnknown
	HealthStateWarning HealthState = original.HealthStateWarning
)

type HealthState1 = original.HealthState1

const (
	HealthState1Error   HealthState1 = original.HealthState1Error
	HealthState1Invalid HealthState1 = original.HealthState1Invalid
	HealthState1Ok      HealthState1 = original.HealthState1Ok
	HealthState1Unknown HealthState1 = original.HealthState1Unknown
	HealthState1Warning HealthState1 = original.HealthState1Warning
)

type HealthState2 = original.HealthState2

const (
	HealthState2Error   HealthState2 = original.HealthState2Error
	HealthState2Invalid HealthState2 = original.HealthState2Invalid
	HealthState2Ok      HealthState2 = original.HealthState2Ok
	HealthState2Unknown HealthState2 = original.HealthState2Unknown
	HealthState2Warning HealthState2 = original.HealthState2Warning
)

type HealthState3 = original.HealthState3

const (
	HealthState3Error   HealthState3 = original.HealthState3Error
	HealthState3Invalid HealthState3 = original.HealthState3Invalid
	HealthState3Ok      HealthState3 = original.HealthState3Ok
	HealthState3Unknown HealthState3 = original.HealthState3Unknown
	HealthState3Warning HealthState3 = original.HealthState3Warning
)

type HealthState4 = original.HealthState4

const (
	HealthState4Error   HealthState4 = original.HealthState4Error
	HealthState4Invalid HealthState4 = original.HealthState4Invalid
	HealthState4Ok      HealthState4 = original.HealthState4Ok
	HealthState4Unknown HealthState4 = original.HealthState4Unknown
	HealthState4Warning HealthState4 = original.HealthState4Warning
)

type HealthState5 = original.HealthState5

const (
	HealthState5Error   HealthState5 = original.HealthState5Error
	HealthState5Invalid HealthState5 = original.HealthState5Invalid
	HealthState5Ok      HealthState5 = original.HealthState5Ok
	HealthState5Unknown HealthState5 = original.HealthState5Unknown
	HealthState5Warning HealthState5 = original.HealthState5Warning
)

type HealthState6 = original.HealthState6

const (
	HealthState6Error   HealthState6 = original.HealthState6Error
	HealthState6Invalid HealthState6 = original.HealthState6Invalid
	HealthState6Ok      HealthState6 = original.HealthState6Ok
	HealthState6Unknown HealthState6 = original.HealthState6Unknown
	HealthState6Warning HealthState6 = original.HealthState6Warning
)

type HealthState7 = original.HealthState7

const (
	HealthState7Error   HealthState7 = original.HealthState7Error
	HealthState7Invalid HealthState7 = original.HealthState7Invalid
	HealthState7Ok      HealthState7 = original.HealthState7Ok
	HealthState7Unknown HealthState7 = original.HealthState7Unknown
	HealthState7Warning HealthState7 = original.HealthState7Warning
)

type HostIsolationMode = original.HostIsolationMode

const (
	HostIsolationModeHyperV  HostIsolationMode = original.HostIsolationModeHyperV
	HostIsolationModeNone    HostIsolationMode = original.HostIsolationModeNone
	HostIsolationModeProcess HostIsolationMode = original.HostIsolationModeProcess
)

type HostType = original.HostType

const (
	HostTypeContainerHost HostType = original.HostTypeContainerHost
	HostTypeExeHost       HostType = original.HostTypeExeHost
	HostTypeInvalid       HostType = original.HostTypeInvalid
)

type ImpactLevel = original.ImpactLevel

const (
	ImpactLevelInvalid    ImpactLevel = original.ImpactLevelInvalid
	ImpactLevelNone       ImpactLevel = original.ImpactLevelNone
	ImpactLevelRemoveData ImpactLevel = original.ImpactLevelRemoveData
	ImpactLevelRemoveNode ImpactLevel = original.ImpactLevelRemoveNode
	ImpactLevelRestart    ImpactLevel = original.ImpactLevelRestart
)

type Kind = original.Kind

const (
	KindInvalid           Kind = original.KindInvalid
	KindStatefulPrimary   Kind = original.KindStatefulPrimary
	KindStatefulSecondary Kind = original.KindStatefulSecondary
	KindStateless         Kind = original.KindStateless
)

type KindBasicChaosEvent = original.KindBasicChaosEvent

const (
	KindChaosEvent       KindBasicChaosEvent = original.KindChaosEvent
	KindExecutingFaults  KindBasicChaosEvent = original.KindExecutingFaults
	KindStarted          KindBasicChaosEvent = original.KindStarted
	KindStopped          KindBasicChaosEvent = original.KindStopped
	KindTestError        KindBasicChaosEvent = original.KindTestError
	KindValidationFailed KindBasicChaosEvent = original.KindValidationFailed
	KindWaiting          KindBasicChaosEvent = original.KindWaiting
)

type KindBasicHealthEvaluation = original.KindBasicHealthEvaluation

const (
	KindApplication                  KindBasicHealthEvaluation = original.KindApplication
	KindApplications                 KindBasicHealthEvaluation = original.KindApplications
	KindApplicationTypeApplications  KindBasicHealthEvaluation = original.KindApplicationTypeApplications
	KindDeltaNodesCheck              KindBasicHealthEvaluation = original.KindDeltaNodesCheck
	KindDeployedApplication          KindBasicHealthEvaluation = original.KindDeployedApplication
	KindDeployedApplications         KindBasicHealthEvaluation = original.KindDeployedApplications
	KindDeployedServicePackage       KindBasicHealthEvaluation = original.KindDeployedServicePackage
	KindDeployedServicePackages      KindBasicHealthEvaluation = original.KindDeployedServicePackages
	KindEvent                        KindBasicHealthEvaluation = original.KindEvent
	KindHealthEvaluation             KindBasicHealthEvaluation = original.KindHealthEvaluation
	KindNode                         KindBasicHealthEvaluation = original.KindNode
	KindNodes                        KindBasicHealthEvaluation = original.KindNodes
	KindPartition                    KindBasicHealthEvaluation = original.KindPartition
	KindPartitions                   KindBasicHealthEvaluation = original.KindPartitions
	KindReplica                      KindBasicHealthEvaluation = original.KindReplica
	KindReplicas                     KindBasicHealthEvaluation = original.KindReplicas
	KindService                      KindBasicHealthEvaluation = original.KindService
	KindServices                     KindBasicHealthEvaluation = original.KindServices
	KindSystemApplication            KindBasicHealthEvaluation = original.KindSystemApplication
	KindUpgradeDomainDeltaNodesCheck KindBasicHealthEvaluation = original.KindUpgradeDomainDeltaNodesCheck
	KindUpgradeDomainNodes           KindBasicHealthEvaluation = original.KindUpgradeDomainNodes
)

type KindBasicPropertyBatchInfo = original.KindBasicPropertyBatchInfo

const (
	KindFailed            KindBasicPropertyBatchInfo = original.KindFailed
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = original.KindPropertyBatchInfo
	KindSuccessful        KindBasicPropertyBatchInfo = original.KindSuccessful
)

type KindBasicPropertyBatchOperation = original.KindBasicPropertyBatchOperation

const (
	KindCheckExists            KindBasicPropertyBatchOperation = original.KindCheckExists
	KindCheckSequence          KindBasicPropertyBatchOperation = original.KindCheckSequence
	KindCheckValue             KindBasicPropertyBatchOperation = original.KindCheckValue
	KindDelete                 KindBasicPropertyBatchOperation = original.KindDelete
	KindGet                    KindBasicPropertyBatchOperation = original.KindGet
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = original.KindPropertyBatchOperation
	KindPut                    KindBasicPropertyBatchOperation = original.KindPut
)

type KindBasicPropertyValue = original.KindBasicPropertyValue

const (
	KindBinary        KindBasicPropertyValue = original.KindBinary
	KindDouble        KindBasicPropertyValue = original.KindDouble
	KindGUID          KindBasicPropertyValue = original.KindGUID
	KindInt64         KindBasicPropertyValue = original.KindInt64
	KindPropertyValue KindBasicPropertyValue = original.KindPropertyValue
	KindString        KindBasicPropertyValue = original.KindString
)

type KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBase

const (
	KindBasicRepairImpactDescriptionBaseKindNode                        KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBaseKindNode
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase
)

type KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBase

const (
	KindBasicRepairTargetDescriptionBaseKindNode                        KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBaseKindNode
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase
)

type KindBasicReplicaStatusBase = original.KindBasicReplicaStatusBase

const (
	KindKeyValueStore     KindBasicReplicaStatusBase = original.KindKeyValueStore
	KindReplicaStatusBase KindBasicReplicaStatusBase = original.KindReplicaStatusBase
)

type KindBasicReplicatorStatus = original.KindBasicReplicatorStatus

const (
	KindActiveSecondary           KindBasicReplicatorStatus = original.KindActiveSecondary
	KindIdleSecondary             KindBasicReplicatorStatus = original.KindIdleSecondary
	KindPrimary                   KindBasicReplicatorStatus = original.KindPrimary
	KindReplicatorStatus          KindBasicReplicatorStatus = original.KindReplicatorStatus
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = original.KindSecondaryReplicatorStatus
)

type KindBasicSafetyCheck = original.KindBasicSafetyCheck

const (
	KindEnsureAvailability      KindBasicSafetyCheck = original.KindEnsureAvailability
	KindEnsurePartitionQuorum   KindBasicSafetyCheck = original.KindEnsurePartitionQuorum
	KindEnsureSeedNodeQuorum    KindBasicSafetyCheck = original.KindEnsureSeedNodeQuorum
	KindPartitionSafetyCheck    KindBasicSafetyCheck = original.KindPartitionSafetyCheck
	KindSafetyCheck             KindBasicSafetyCheck = original.KindSafetyCheck
	KindWaitForInbuildReplica   KindBasicSafetyCheck = original.KindWaitForInbuildReplica
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = original.KindWaitForPrimaryPlacement
	KindWaitForPrimarySwap      KindBasicSafetyCheck = original.KindWaitForPrimarySwap
	KindWaitForReconfiguration  KindBasicSafetyCheck = original.KindWaitForReconfiguration
)

type KindBasicServiceTypeDescription = original.KindBasicServiceTypeDescription

const (
	KindServiceTypeDescription KindBasicServiceTypeDescription = original.KindServiceTypeDescription
	KindStateful               KindBasicServiceTypeDescription = original.KindStateful
	KindStateless1             KindBasicServiceTypeDescription = original.KindStateless1
)

type NodeDeactivationIntent = original.NodeDeactivationIntent

const (
	NodeDeactivationIntentInvalid    NodeDeactivationIntent = original.NodeDeactivationIntentInvalid
	NodeDeactivationIntentPause      NodeDeactivationIntent = original.NodeDeactivationIntentPause
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = original.NodeDeactivationIntentRemoveData
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = original.NodeDeactivationIntentRemoveNode
	NodeDeactivationIntentRestart    NodeDeactivationIntent = original.NodeDeactivationIntentRestart
)

type NodeDeactivationIntent1 = original.NodeDeactivationIntent1

const (
	NodeDeactivationIntent1Invalid    NodeDeactivationIntent1 = original.NodeDeactivationIntent1Invalid
	NodeDeactivationIntent1Pause      NodeDeactivationIntent1 = original.NodeDeactivationIntent1Pause
	NodeDeactivationIntent1RemoveData NodeDeactivationIntent1 = original.NodeDeactivationIntent1RemoveData
	NodeDeactivationIntent1RemoveNode NodeDeactivationIntent1 = original.NodeDeactivationIntent1RemoveNode
	NodeDeactivationIntent1Restart    NodeDeactivationIntent1 = original.NodeDeactivationIntent1Restart
)

type NodeDeactivationStatus = original.NodeDeactivationStatus

const (
	NodeDeactivationStatusCompleted             NodeDeactivationStatus = original.NodeDeactivationStatusCompleted
	NodeDeactivationStatusNone                  NodeDeactivationStatus = original.NodeDeactivationStatusNone
	NodeDeactivationStatusSafetyCheckComplete   NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckComplete
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckInProgress
)

type NodeDeactivationTaskType = original.NodeDeactivationTaskType

const (
	NodeDeactivationTaskTypeClient         NodeDeactivationTaskType = original.NodeDeactivationTaskTypeClient
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = original.NodeDeactivationTaskTypeInfrastructure
	NodeDeactivationTaskTypeInvalid        NodeDeactivationTaskType = original.NodeDeactivationTaskTypeInvalid
	NodeDeactivationTaskTypeRepair         NodeDeactivationTaskType = original.NodeDeactivationTaskTypeRepair
)

type NodeStatus = original.NodeStatus

const (
	NodeStatusDisabled  NodeStatus = original.NodeStatusDisabled
	NodeStatusDisabling NodeStatus = original.NodeStatusDisabling
	NodeStatusDown      NodeStatus = original.NodeStatusDown
	NodeStatusEnabling  NodeStatus = original.NodeStatusEnabling
	NodeStatusInvalid   NodeStatus = original.NodeStatusInvalid
	NodeStatusRemoved   NodeStatus = original.NodeStatusRemoved
	NodeStatusUnknown   NodeStatus = original.NodeStatusUnknown
	NodeStatusUp        NodeStatus = original.NodeStatusUp
)

type PackageSharingScope = original.PackageSharingScope

const (
	PackageSharingScopeAll    PackageSharingScope = original.PackageSharingScopeAll
	PackageSharingScopeCode   PackageSharingScope = original.PackageSharingScopeCode
	PackageSharingScopeConfig PackageSharingScope = original.PackageSharingScopeConfig
	PackageSharingScopeData   PackageSharingScope = original.PackageSharingScopeData
	PackageSharingScopeNone   PackageSharingScope = original.PackageSharingScopeNone
)

type PartitionScheme = original.PartitionScheme

const (
	PartitionSchemeNamed                      PartitionScheme = original.PartitionSchemeNamed
	PartitionSchemePartitionSchemeDescription PartitionScheme = original.PartitionSchemePartitionSchemeDescription
	PartitionSchemeSingleton                  PartitionScheme = original.PartitionSchemeSingleton
	PartitionSchemeUniformInt64Range          PartitionScheme = original.PartitionSchemeUniformInt64Range
)

type PartitionStatus = original.PartitionStatus

const (
	PartitionStatusDeleting      PartitionStatus = original.PartitionStatusDeleting
	PartitionStatusInQuorumLoss  PartitionStatus = original.PartitionStatusInQuorumLoss
	PartitionStatusInvalid       PartitionStatus = original.PartitionStatusInvalid
	PartitionStatusNotReady      PartitionStatus = original.PartitionStatusNotReady
	PartitionStatusReady         PartitionStatus = original.PartitionStatusReady
	PartitionStatusReconfiguring PartitionStatus = original.PartitionStatusReconfiguring
)

type PreparingHealthCheckState = original.PreparingHealthCheckState

const (
	InProgress PreparingHealthCheckState = original.InProgress
	NotStarted PreparingHealthCheckState = original.NotStarted
	Skipped    PreparingHealthCheckState = original.Skipped
	Succeeded  PreparingHealthCheckState = original.Succeeded
	TimedOut   PreparingHealthCheckState = original.TimedOut
)

type PreviousConfigurationRole = original.PreviousConfigurationRole

const (
	PreviousConfigurationRoleActiveSecondary PreviousConfigurationRole = original.PreviousConfigurationRoleActiveSecondary
	PreviousConfigurationRoleIdleSecondary   PreviousConfigurationRole = original.PreviousConfigurationRoleIdleSecondary
	PreviousConfigurationRoleNone            PreviousConfigurationRole = original.PreviousConfigurationRoleNone
	PreviousConfigurationRolePrimary         PreviousConfigurationRole = original.PreviousConfigurationRolePrimary
	PreviousConfigurationRoleUnknown         PreviousConfigurationRole = original.PreviousConfigurationRoleUnknown
)

type ReadStatus = original.ReadStatus

const (
	ReadStatusGranted                ReadStatus = original.ReadStatusGranted
	ReadStatusInvalid                ReadStatus = original.ReadStatusInvalid
	ReadStatusNotPrimary             ReadStatus = original.ReadStatusNotPrimary
	ReadStatusNoWriteQuorum          ReadStatus = original.ReadStatusNoWriteQuorum
	ReadStatusReconfigurationPending ReadStatus = original.ReadStatusReconfigurationPending
)

type ReconfigurationPhase = original.ReconfigurationPhase

const (
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = original.ReconfigurationPhaseAbortPhaseZero
	ReconfigurationPhaseNone           ReconfigurationPhase = original.ReconfigurationPhaseNone
	ReconfigurationPhasePhase0         ReconfigurationPhase = original.ReconfigurationPhasePhase0
	ReconfigurationPhasePhase1         ReconfigurationPhase = original.ReconfigurationPhasePhase1
	ReconfigurationPhasePhase2         ReconfigurationPhase = original.ReconfigurationPhasePhase2
	ReconfigurationPhasePhase3         ReconfigurationPhase = original.ReconfigurationPhasePhase3
	ReconfigurationPhasePhase4         ReconfigurationPhase = original.ReconfigurationPhasePhase4
	ReconfigurationPhaseUnknown        ReconfigurationPhase = original.ReconfigurationPhaseUnknown
)

type ReconfigurationType = original.ReconfigurationType

const (
	ReconfigurationTypeFailover    ReconfigurationType = original.ReconfigurationTypeFailover
	ReconfigurationTypeOther       ReconfigurationType = original.ReconfigurationTypeOther
	ReconfigurationTypeSwapPrimary ReconfigurationType = original.ReconfigurationTypeSwapPrimary
	ReconfigurationTypeUnknown     ReconfigurationType = original.ReconfigurationTypeUnknown
)

type ReplicaRole = original.ReplicaRole

const (
	ReplicaRoleActiveSecondary ReplicaRole = original.ReplicaRoleActiveSecondary
	ReplicaRoleIdleSecondary   ReplicaRole = original.ReplicaRoleIdleSecondary
	ReplicaRoleNone            ReplicaRole = original.ReplicaRoleNone
	ReplicaRolePrimary         ReplicaRole = original.ReplicaRolePrimary
	ReplicaRoleUnknown         ReplicaRole = original.ReplicaRoleUnknown
)

type ReplicaRole1 = original.ReplicaRole1

const (
	ReplicaRole1ActiveSecondary ReplicaRole1 = original.ReplicaRole1ActiveSecondary
	ReplicaRole1IdleSecondary   ReplicaRole1 = original.ReplicaRole1IdleSecondary
	ReplicaRole1None            ReplicaRole1 = original.ReplicaRole1None
	ReplicaRole1Primary         ReplicaRole1 = original.ReplicaRole1Primary
	ReplicaRole1Unknown         ReplicaRole1 = original.ReplicaRole1Unknown
)

type ReplicaStatus = original.ReplicaStatus

const (
	ReplicaStatusDown    ReplicaStatus = original.ReplicaStatusDown
	ReplicaStatusDropped ReplicaStatus = original.ReplicaStatusDropped
	ReplicaStatusInBuild ReplicaStatus = original.ReplicaStatusInBuild
	ReplicaStatusInvalid ReplicaStatus = original.ReplicaStatusInvalid
	ReplicaStatusReady   ReplicaStatus = original.ReplicaStatusReady
	ReplicaStatusStandby ReplicaStatus = original.ReplicaStatusStandby
)

type ReplicaStatus1 = original.ReplicaStatus1

const (
	ReplicaStatus1Down    ReplicaStatus1 = original.ReplicaStatus1Down
	ReplicaStatus1Dropped ReplicaStatus1 = original.ReplicaStatus1Dropped
	ReplicaStatus1InBuild ReplicaStatus1 = original.ReplicaStatus1InBuild
	ReplicaStatus1Invalid ReplicaStatus1 = original.ReplicaStatus1Invalid
	ReplicaStatus1Ready   ReplicaStatus1 = original.ReplicaStatus1Ready
	ReplicaStatus1Standby ReplicaStatus1 = original.ReplicaStatus1Standby
)

type RestoringHealthCheckState = original.RestoringHealthCheckState

const (
	RestoringHealthCheckStateInProgress RestoringHealthCheckState = original.RestoringHealthCheckStateInProgress
	RestoringHealthCheckStateNotStarted RestoringHealthCheckState = original.RestoringHealthCheckStateNotStarted
	RestoringHealthCheckStateSkipped    RestoringHealthCheckState = original.RestoringHealthCheckStateSkipped
	RestoringHealthCheckStateSucceeded  RestoringHealthCheckState = original.RestoringHealthCheckStateSucceeded
	RestoringHealthCheckStateTimedOut   RestoringHealthCheckState = original.RestoringHealthCheckStateTimedOut
)

type ResultStatus = original.ResultStatus

const (
	ResultStatusCancelled   ResultStatus = original.ResultStatusCancelled
	ResultStatusFailed      ResultStatus = original.ResultStatusFailed
	ResultStatusInterrupted ResultStatus = original.ResultStatusInterrupted
	ResultStatusInvalid     ResultStatus = original.ResultStatusInvalid
	ResultStatusPending     ResultStatus = original.ResultStatusPending
	ResultStatusSucceeded   ResultStatus = original.ResultStatusSucceeded
)

type RollingUpgradeMode = original.RollingUpgradeMode

const (
	RollingUpgradeModeInvalid           RollingUpgradeMode = original.RollingUpgradeModeInvalid
	RollingUpgradeModeMonitored         RollingUpgradeMode = original.RollingUpgradeModeMonitored
	RollingUpgradeModeUnmonitoredAuto   RollingUpgradeMode = original.RollingUpgradeModeUnmonitoredAuto
	RollingUpgradeModeUnmonitoredManual RollingUpgradeMode = original.RollingUpgradeModeUnmonitoredManual
)

type RollingUpgradeMode1 = original.RollingUpgradeMode1

const (
	RollingUpgradeMode1Invalid           RollingUpgradeMode1 = original.RollingUpgradeMode1Invalid
	RollingUpgradeMode1Monitored         RollingUpgradeMode1 = original.RollingUpgradeMode1Monitored
	RollingUpgradeMode1UnmonitoredAuto   RollingUpgradeMode1 = original.RollingUpgradeMode1UnmonitoredAuto
	RollingUpgradeMode1UnmonitoredManual RollingUpgradeMode1 = original.RollingUpgradeMode1UnmonitoredManual
)

type RollingUpgradeMode2 = original.RollingUpgradeMode2

const (
	RollingUpgradeMode2Invalid           RollingUpgradeMode2 = original.RollingUpgradeMode2Invalid
	RollingUpgradeMode2Monitored         RollingUpgradeMode2 = original.RollingUpgradeMode2Monitored
	RollingUpgradeMode2UnmonitoredAuto   RollingUpgradeMode2 = original.RollingUpgradeMode2UnmonitoredAuto
	RollingUpgradeMode2UnmonitoredManual RollingUpgradeMode2 = original.RollingUpgradeMode2UnmonitoredManual
)

type RollingUpgradeMode3 = original.RollingUpgradeMode3

const (
	RollingUpgradeMode3Invalid           RollingUpgradeMode3 = original.RollingUpgradeMode3Invalid
	RollingUpgradeMode3Monitored         RollingUpgradeMode3 = original.RollingUpgradeMode3Monitored
	RollingUpgradeMode3UnmonitoredAuto   RollingUpgradeMode3 = original.RollingUpgradeMode3UnmonitoredAuto
	RollingUpgradeMode3UnmonitoredManual RollingUpgradeMode3 = original.RollingUpgradeMode3UnmonitoredManual
)

type RollingUpgradeMode4 = original.RollingUpgradeMode4

const (
	RollingUpgradeMode4Invalid           RollingUpgradeMode4 = original.RollingUpgradeMode4Invalid
	RollingUpgradeMode4Monitored         RollingUpgradeMode4 = original.RollingUpgradeMode4Monitored
	RollingUpgradeMode4UnmonitoredAuto   RollingUpgradeMode4 = original.RollingUpgradeMode4UnmonitoredAuto
	RollingUpgradeMode4UnmonitoredManual RollingUpgradeMode4 = original.RollingUpgradeMode4UnmonitoredManual
)

type RollingUpgradeMode5 = original.RollingUpgradeMode5

const (
	RollingUpgradeMode5Invalid           RollingUpgradeMode5 = original.RollingUpgradeMode5Invalid
	RollingUpgradeMode5Monitored         RollingUpgradeMode5 = original.RollingUpgradeMode5Monitored
	RollingUpgradeMode5UnmonitoredAuto   RollingUpgradeMode5 = original.RollingUpgradeMode5UnmonitoredAuto
	RollingUpgradeMode5UnmonitoredManual RollingUpgradeMode5 = original.RollingUpgradeMode5UnmonitoredManual
)

type RollingUpgradeMode6 = original.RollingUpgradeMode6

const (
	RollingUpgradeMode6Invalid           RollingUpgradeMode6 = original.RollingUpgradeMode6Invalid
	RollingUpgradeMode6Monitored         RollingUpgradeMode6 = original.RollingUpgradeMode6Monitored
	RollingUpgradeMode6UnmonitoredAuto   RollingUpgradeMode6 = original.RollingUpgradeMode6UnmonitoredAuto
	RollingUpgradeMode6UnmonitoredManual RollingUpgradeMode6 = original.RollingUpgradeMode6UnmonitoredManual
)

type RollingUpgradeMode7 = original.RollingUpgradeMode7

const (
	RollingUpgradeMode7Invalid           RollingUpgradeMode7 = original.RollingUpgradeMode7Invalid
	RollingUpgradeMode7Monitored         RollingUpgradeMode7 = original.RollingUpgradeMode7Monitored
	RollingUpgradeMode7UnmonitoredAuto   RollingUpgradeMode7 = original.RollingUpgradeMode7UnmonitoredAuto
	RollingUpgradeMode7UnmonitoredManual RollingUpgradeMode7 = original.RollingUpgradeMode7UnmonitoredManual
)

type Scheme = original.Scheme

const (
	SchemeAffinity           Scheme = original.SchemeAffinity
	SchemeAlignedAffinity    Scheme = original.SchemeAlignedAffinity
	SchemeInvalid            Scheme = original.SchemeInvalid
	SchemeNonAlignedAffinity Scheme = original.SchemeNonAlignedAffinity
)

type ServiceKind = original.ServiceKind

const (
	ServiceKindDeployedServiceReplicaInfo ServiceKind = original.ServiceKindDeployedServiceReplicaInfo
	ServiceKindStateful                   ServiceKind = original.ServiceKindStateful
	ServiceKindStateless                  ServiceKind = original.ServiceKindStateless
)

type ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindBasicDeployedServiceReplicaDetailInfo

const (
	ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindDeployedServiceReplicaDetailInfo
	ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindStateful                         ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindStateful
	ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindStateless                        ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindBasicDeployedServiceReplicaDetailInfoServiceKindStateless
)

type ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealth

const (
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindReplicaHealth
	ServiceKindBasicReplicaHealthServiceKindStateful      ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindStateful
	ServiceKindBasicReplicaHealthServiceKindStateless     ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindStateless
)

type ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthState

const (
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState
	ServiceKindBasicReplicaHealthStateServiceKindStateful           ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindStateful
	ServiceKindBasicReplicaHealthStateServiceKindStateless          ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindStateless
)

type ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfo

const (
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindReplicaInfo
	ServiceKindBasicReplicaInfoServiceKindStateful    ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindStateful
	ServiceKindBasicReplicaInfoServiceKindStateless   ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindStateless
)

type ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescription

const (
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindServiceDescription
	ServiceKindBasicServiceDescriptionServiceKindStateful           ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateful
	ServiceKindBasicServiceDescriptionServiceKindStateless          ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateless
)

type ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfo

const (
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindServiceInfo
	ServiceKindBasicServiceInfoServiceKindStateful    ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindStateful
	ServiceKindBasicServiceInfoServiceKindStateless   ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindStateless
)

type ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfo

const (
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo
	ServiceKindBasicServicePartitionInfoServiceKindStateful             ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindStateful
	ServiceKindBasicServicePartitionInfoServiceKindStateless            ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindStateless
)

type ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescription

const (
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful                 ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindStateful
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless                ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindStateless
)

type ServicePackageActivationMode = original.ServicePackageActivationMode

const (
	ExclusiveProcess ServicePackageActivationMode = original.ExclusiveProcess
	SharedProcess    ServicePackageActivationMode = original.SharedProcess
)

type ServicePackageActivationMode1 = original.ServicePackageActivationMode1

const (
	ServicePackageActivationMode1ExclusiveProcess ServicePackageActivationMode1 = original.ServicePackageActivationMode1ExclusiveProcess
	ServicePackageActivationMode1SharedProcess    ServicePackageActivationMode1 = original.ServicePackageActivationMode1SharedProcess
)

type ServicePartitionKind = original.ServicePartitionKind

const (
	ServicePartitionKindInt64Range           ServicePartitionKind = original.ServicePartitionKindInt64Range
	ServicePartitionKindNamed                ServicePartitionKind = original.ServicePartitionKindNamed
	ServicePartitionKindPartitionInformation ServicePartitionKind = original.ServicePartitionKindPartitionInformation
	ServicePartitionKindSingleton            ServicePartitionKind = original.ServicePartitionKindSingleton
)

type ServiceStatus = original.ServiceStatus

const (
	ServiceStatusActive    ServiceStatus = original.ServiceStatusActive
	ServiceStatusCreating  ServiceStatus = original.ServiceStatusCreating
	ServiceStatusDeleting  ServiceStatus = original.ServiceStatusDeleting
	ServiceStatusFailed    ServiceStatus = original.ServiceStatusFailed
	ServiceStatusUnknown   ServiceStatus = original.ServiceStatusUnknown
	ServiceStatusUpgrading ServiceStatus = original.ServiceStatusUpgrading
)

type State = original.State

const (
	StateCompleted  State = original.StateCompleted
	StateInProgress State = original.StateInProgress
	StateInvalid    State = original.StateInvalid
	StatePending    State = original.StatePending
)

type State1 = original.State1

const (
	State1Cancelled      State1 = original.State1Cancelled
	State1Completed      State1 = original.State1Completed
	State1Faulted        State1 = original.State1Faulted
	State1ForceCancelled State1 = original.State1ForceCancelled
	State1Invalid        State1 = original.State1Invalid
	State1RollingBack    State1 = original.State1RollingBack
	State1Running        State1 = original.State1Running
)

type State2 = original.State2

const (
	State2Cancelled      State2 = original.State2Cancelled
	State2Completed      State2 = original.State2Completed
	State2Faulted        State2 = original.State2Faulted
	State2ForceCancelled State2 = original.State2ForceCancelled
	State2Invalid        State2 = original.State2Invalid
	State2RollingBack    State2 = original.State2RollingBack
	State2Running        State2 = original.State2Running
)

type State3 = original.State3

const (
	State3Cancelled      State3 = original.State3Cancelled
	State3Completed      State3 = original.State3Completed
	State3Faulted        State3 = original.State3Faulted
	State3ForceCancelled State3 = original.State3ForceCancelled
	State3Invalid        State3 = original.State3Invalid
	State3RollingBack    State3 = original.State3RollingBack
	State3Running        State3 = original.State3Running
)

type State4 = original.State4

const (
	State4Cancelled      State4 = original.State4Cancelled
	State4Completed      State4 = original.State4Completed
	State4Faulted        State4 = original.State4Faulted
	State4ForceCancelled State4 = original.State4ForceCancelled
	State4Invalid        State4 = original.State4Invalid
	State4RollingBack    State4 = original.State4RollingBack
	State4Running        State4 = original.State4Running
)

type State5 = original.State5

const (
	State5Cancelled      State5 = original.State5Cancelled
	State5Completed      State5 = original.State5Completed
	State5Faulted        State5 = original.State5Faulted
	State5ForceCancelled State5 = original.State5ForceCancelled
	State5Invalid        State5 = original.State5Invalid
	State5RollingBack    State5 = original.State5RollingBack
	State5Running        State5 = original.State5Running
)

type State6 = original.State6

const (
	State6Approved  State6 = original.State6Approved
	State6Claimed   State6 = original.State6Claimed
	State6Completed State6 = original.State6Completed
	State6Created   State6 = original.State6Created
	State6Executing State6 = original.State6Executing
	State6Invalid   State6 = original.State6Invalid
	State6Preparing State6 = original.State6Preparing
	State6Restoring State6 = original.State6Restoring
)

type Status = original.Status

const (
	StatusCreating  Status = original.StatusCreating
	StatusDeleting  Status = original.StatusDeleting
	StatusFailed    Status = original.StatusFailed
	StatusInvalid   Status = original.StatusInvalid
	StatusReady     Status = original.StatusReady
	StatusUpgrading Status = original.StatusUpgrading
)

type Status1 = original.Status1

const (
	Status1Available      Status1 = original.Status1Available
	Status1Failed         Status1 = original.Status1Failed
	Status1Invalid        Status1 = original.Status1Invalid
	Status1Provisioning   Status1 = original.Status1Provisioning
	Status1Unprovisioning Status1 = original.Status1Unprovisioning
)

type Status2 = original.Status2

const (
	Status2Activating   Status2 = original.Status2Activating
	Status2Active       Status2 = original.Status2Active
	Status2Deactivating Status2 = original.Status2Deactivating
	Status2Downloading  Status2 = original.Status2Downloading
	Status2Invalid      Status2 = original.Status2Invalid
	Status2Upgrading    Status2 = original.Status2Upgrading
)

type Status3 = original.Status3

const (
	Status3Invalid  Status3 = original.Status3Invalid
	Status3Pending  Status3 = original.Status3Pending
	Status3Started  Status3 = original.Status3Started
	Status3Starting Status3 = original.Status3Starting
	Status3Stopped  Status3 = original.Status3Stopped
	Status3Stopping Status3 = original.Status3Stopping
)

type Status4 = original.Status4

const (
	Status4Activating   Status4 = original.Status4Activating
	Status4Active       Status4 = original.Status4Active
	Status4Deactivating Status4 = original.Status4Deactivating
	Status4Downloading  Status4 = original.Status4Downloading
	Status4Invalid      Status4 = original.Status4Invalid
	Status4Upgrading    Status4 = original.Status4Upgrading
)

type Status5 = original.Status5

const (
	Status5Invalid Status5 = original.Status5Invalid
	Status5Running Status5 = original.Status5Running
	Status5Stopped Status5 = original.Status5Stopped
)

type Status6 = original.Status6

const (
	Status6Creating       Status6 = original.Status6Creating
	Status6Deleting       Status6 = original.Status6Deleting
	Status6Failed         Status6 = original.Status6Failed
	Status6Invalid        Status6 = original.Status6Invalid
	Status6Provisioning   Status6 = original.Status6Provisioning
	Status6Ready          Status6 = original.Status6Ready
	Status6Unprovisioning Status6 = original.Status6Unprovisioning
	Status6Upgrading      Status6 = original.Status6Upgrading
)

type Status7 = original.Status7

const (
	Status7Activating   Status7 = original.Status7Activating
	Status7Active       Status7 = original.Status7Active
	Status7Deactivating Status7 = original.Status7Deactivating
	Status7Downloading  Status7 = original.Status7Downloading
	Status7Invalid      Status7 = original.Status7Invalid
	Status7Upgrading    Status7 = original.Status7Upgrading
)

type Status8 = original.Status8

const (
	Status8Disabled   Status8 = original.Status8Disabled
	Status8Enabled    Status8 = original.Status8Enabled
	Status8Invalid    Status8 = original.Status8Invalid
	Status8Registered Status8 = original.Status8Registered
)

type Type = original.Type

const (
	TypeInvalid             Type = original.TypeInvalid
	TypeNodeTransition      Type = original.TypeNodeTransition
	TypePartitionDataLoss   Type = original.TypePartitionDataLoss
	TypePartitionQuorumLoss Type = original.TypePartitionQuorumLoss
	TypePartitionRestart    Type = original.TypePartitionRestart
)

type TypeBasicServicePlacementPolicyDescription = original.TypeBasicServicePlacementPolicyDescription

const (
	TypeInvalidDomain                     TypeBasicServicePlacementPolicyDescription = original.TypeInvalidDomain
	TypeNonPartiallyPlaceService          TypeBasicServicePlacementPolicyDescription = original.TypeNonPartiallyPlaceService
	TypePreferPrimaryDomain               TypeBasicServicePlacementPolicyDescription = original.TypePreferPrimaryDomain
	TypeRequireDomain                     TypeBasicServicePlacementPolicyDescription = original.TypeRequireDomain
	TypeRequireDomainDistribution         TypeBasicServicePlacementPolicyDescription = original.TypeRequireDomainDistribution
	TypeServicePlacementPolicyDescription TypeBasicServicePlacementPolicyDescription = original.TypeServicePlacementPolicyDescription
)

type TypeID = original.TypeID

const (
	TypeIDBinary  TypeID = original.TypeIDBinary
	TypeIDDouble  TypeID = original.TypeIDDouble
	TypeIDGUID    TypeID = original.TypeIDGUID
	TypeIDInt64   TypeID = original.TypeIDInt64
	TypeIDInvalid TypeID = original.TypeIDInvalid
	TypeIDString  TypeID = original.TypeIDString
)

type UpgradeKind = original.UpgradeKind

const (
	UpgradeKindInvalid UpgradeKind = original.UpgradeKindInvalid
	UpgradeKindRolling UpgradeKind = original.UpgradeKindRolling
)

type UpgradeKind1 = original.UpgradeKind1

const (
	UpgradeKind1Invalid UpgradeKind1 = original.UpgradeKind1Invalid
	UpgradeKind1Rolling UpgradeKind1 = original.UpgradeKind1Rolling
)

type UpgradeKind2 = original.UpgradeKind2

const (
	UpgradeKind2Invalid             UpgradeKind2 = original.UpgradeKind2Invalid
	UpgradeKind2Rolling             UpgradeKind2 = original.UpgradeKind2Rolling
	UpgradeKind2RollingForceRestart UpgradeKind2 = original.UpgradeKind2RollingForceRestart
)

type UpgradeKind3 = original.UpgradeKind3

const (
	UpgradeKind3Invalid UpgradeKind3 = original.UpgradeKind3Invalid
	UpgradeKind3Rolling UpgradeKind3 = original.UpgradeKind3Rolling
)

type UpgradeKind4 = original.UpgradeKind4

const (
	UpgradeKind4Invalid UpgradeKind4 = original.UpgradeKind4Invalid
	UpgradeKind4Rolling UpgradeKind4 = original.UpgradeKind4Rolling
)

type UpgradeKind5 = original.UpgradeKind5

const (
	UpgradeKind5Invalid UpgradeKind5 = original.UpgradeKind5Invalid
	UpgradeKind5Rolling UpgradeKind5 = original.UpgradeKind5Rolling
)

type UpgradeKind6 = original.UpgradeKind6

const (
	UpgradeKind6Invalid UpgradeKind6 = original.UpgradeKind6Invalid
	UpgradeKind6Rolling UpgradeKind6 = original.UpgradeKind6Rolling
)

type UpgradePhase = original.UpgradePhase

const (
	UpgradePhaseInvalid                UpgradePhase = original.UpgradePhaseInvalid
	UpgradePhasePostUpgradeSafetyCheck UpgradePhase = original.UpgradePhasePostUpgradeSafetyCheck
	UpgradePhasePreUpgradeSafetyCheck  UpgradePhase = original.UpgradePhasePreUpgradeSafetyCheck
	UpgradePhaseUpgrading              UpgradePhase = original.UpgradePhaseUpgrading
)

type UpgradeState = original.UpgradeState

const (
	UpgradeStateFailed                   UpgradeState = original.UpgradeStateFailed
	UpgradeStateInvalid                  UpgradeState = original.UpgradeStateInvalid
	UpgradeStateRollingBackCompleted     UpgradeState = original.UpgradeStateRollingBackCompleted
	UpgradeStateRollingBackInProgress    UpgradeState = original.UpgradeStateRollingBackInProgress
	UpgradeStateRollingForwardCompleted  UpgradeState = original.UpgradeStateRollingForwardCompleted
	UpgradeStateRollingForwardInProgress UpgradeState = original.UpgradeStateRollingForwardInProgress
	UpgradeStateRollingForwardPending    UpgradeState = original.UpgradeStateRollingForwardPending
)

type UpgradeState1 = original.UpgradeState1

const (
	UpgradeState1Failed                   UpgradeState1 = original.UpgradeState1Failed
	UpgradeState1Invalid                  UpgradeState1 = original.UpgradeState1Invalid
	UpgradeState1RollingBackCompleted     UpgradeState1 = original.UpgradeState1RollingBackCompleted
	UpgradeState1RollingBackInProgress    UpgradeState1 = original.UpgradeState1RollingBackInProgress
	UpgradeState1RollingForwardCompleted  UpgradeState1 = original.UpgradeState1RollingForwardCompleted
	UpgradeState1RollingForwardInProgress UpgradeState1 = original.UpgradeState1RollingForwardInProgress
	UpgradeState1RollingForwardPending    UpgradeState1 = original.UpgradeState1RollingForwardPending
)

type UpgradeState2 = original.UpgradeState2

const (
	UpgradeState2Failed                   UpgradeState2 = original.UpgradeState2Failed
	UpgradeState2Invalid                  UpgradeState2 = original.UpgradeState2Invalid
	UpgradeState2RollingBackCompleted     UpgradeState2 = original.UpgradeState2RollingBackCompleted
	UpgradeState2RollingBackInProgress    UpgradeState2 = original.UpgradeState2RollingBackInProgress
	UpgradeState2RollingForwardCompleted  UpgradeState2 = original.UpgradeState2RollingForwardCompleted
	UpgradeState2RollingForwardInProgress UpgradeState2 = original.UpgradeState2RollingForwardInProgress
	UpgradeState2RollingForwardPending    UpgradeState2 = original.UpgradeState2RollingForwardPending
)

type UpgradeState3 = original.UpgradeState3

const (
	UpgradeState3Failed                   UpgradeState3 = original.UpgradeState3Failed
	UpgradeState3Invalid                  UpgradeState3 = original.UpgradeState3Invalid
	UpgradeState3ProvisioningTarget       UpgradeState3 = original.UpgradeState3ProvisioningTarget
	UpgradeState3RollingBackCompleted     UpgradeState3 = original.UpgradeState3RollingBackCompleted
	UpgradeState3RollingBackInProgress    UpgradeState3 = original.UpgradeState3RollingBackInProgress
	UpgradeState3RollingForwardCompleted  UpgradeState3 = original.UpgradeState3RollingForwardCompleted
	UpgradeState3RollingForwardInProgress UpgradeState3 = original.UpgradeState3RollingForwardInProgress
	UpgradeState3RollingForwardPending    UpgradeState3 = original.UpgradeState3RollingForwardPending
	UpgradeState3UnprovisioningCurrent    UpgradeState3 = original.UpgradeState3UnprovisioningCurrent
	UpgradeState3UnprovisioningTarget     UpgradeState3 = original.UpgradeState3UnprovisioningTarget
)

type Weight = original.Weight

const (
	WeightHigh   Weight = original.WeightHigh
	WeightLow    Weight = original.WeightLow
	WeightMedium Weight = original.WeightMedium
	WeightZero   Weight = original.WeightZero
)

type WriteStatus = original.WriteStatus

const (
	WriteStatusGranted                WriteStatus = original.WriteStatusGranted
	WriteStatusInvalid                WriteStatus = original.WriteStatusInvalid
	WriteStatusNotPrimary             WriteStatus = original.WriteStatusNotPrimary
	WriteStatusNoWriteQuorum          WriteStatus = original.WriteStatusNoWriteQuorum
	WriteStatusReconfigurationPending WriteStatus = original.WriteStatusReconfigurationPending
)

type AadMetadata = original.AadMetadata
type AadMetadataObject = original.AadMetadataObject
type ApplicationCapacityDescription = original.ApplicationCapacityDescription
type ApplicationDescription = original.ApplicationDescription
type ApplicationHealth = original.ApplicationHealth
type ApplicationHealthEvaluation = original.ApplicationHealthEvaluation
type ApplicationHealthPolicies = original.ApplicationHealthPolicies
type ApplicationHealthPolicy = original.ApplicationHealthPolicy
type ApplicationHealthPolicyMapItem = original.ApplicationHealthPolicyMapItem
type ApplicationHealthState = original.ApplicationHealthState
type ApplicationHealthStateChunk = original.ApplicationHealthStateChunk
type ApplicationHealthStateChunkList = original.ApplicationHealthStateChunkList
type ApplicationHealthStateFilter = original.ApplicationHealthStateFilter
type ApplicationInfo = original.ApplicationInfo
type ApplicationLoadInfo = original.ApplicationLoadInfo
type ApplicationMetricDescription = original.ApplicationMetricDescription
type ApplicationNameInfo = original.ApplicationNameInfo
type ApplicationParameter = original.ApplicationParameter
type ApplicationsHealthEvaluation = original.ApplicationsHealthEvaluation
type ApplicationTypeApplicationsHealthEvaluation = original.ApplicationTypeApplicationsHealthEvaluation
type ApplicationTypeHealthPolicyMapItem = original.ApplicationTypeHealthPolicyMapItem
type ApplicationTypeImageStorePath = original.ApplicationTypeImageStorePath
type ApplicationTypeImageStoreVersion = original.ApplicationTypeImageStoreVersion
type ApplicationTypeInfo = original.ApplicationTypeInfo
type ApplicationTypeManifest = original.ApplicationTypeManifest
type ApplicationUpgradeDescription = original.ApplicationUpgradeDescription
type ApplicationUpgradeProgressInfo = original.ApplicationUpgradeProgressInfo
type ApplicationUpgradeUpdateDescription = original.ApplicationUpgradeUpdateDescription
type BinaryPropertyValue = original.BinaryPropertyValue
type ChaosContext = original.ChaosContext
type ChaosContextMapItem = original.ChaosContextMapItem
type BasicChaosEvent = original.BasicChaosEvent
type ChaosEvent = original.ChaosEvent
type ChaosEventWrapper = original.ChaosEventWrapper
type ChaosParameters = original.ChaosParameters
type ChaosReport = original.ChaosReport
type CheckExistsPropertyBatchOperation = original.CheckExistsPropertyBatchOperation
type CheckSequencePropertyBatchOperation = original.CheckSequencePropertyBatchOperation
type CheckValuePropertyBatchOperation = original.CheckValuePropertyBatchOperation
type ClusterConfiguration = original.ClusterConfiguration
type ClusterConfigurationUpgradeDescription = original.ClusterConfigurationUpgradeDescription
type ClusterConfigurationUpgradeStatusInfo = original.ClusterConfigurationUpgradeStatusInfo
type ClusterHealth = original.ClusterHealth
type ClusterHealthChunk = original.ClusterHealthChunk
type ClusterHealthChunkQueryDescription = original.ClusterHealthChunkQueryDescription
type ClusterHealthPolicies = original.ClusterHealthPolicies
type ClusterHealthPolicy = original.ClusterHealthPolicy
type ClusterManifest = original.ClusterManifest
type ClusterUpgradeDescriptionObject = original.ClusterUpgradeDescriptionObject
type ClusterUpgradeHealthPolicyObject = original.ClusterUpgradeHealthPolicyObject
type ClusterUpgradeProgressObject = original.ClusterUpgradeProgressObject
type CodePackageEntryPoint = original.CodePackageEntryPoint
type CodePackageEntryPointStatistics = original.CodePackageEntryPointStatistics
type ComposeDeploymentStatusInfo = original.ComposeDeploymentStatusInfo
type ComposeDeploymentUpgradeDescription = original.ComposeDeploymentUpgradeDescription
type ComposeDeploymentUpgradeProgressInfo = original.ComposeDeploymentUpgradeProgressInfo
type CreateComposeDeploymentDescription = original.CreateComposeDeploymentDescription
type CurrentUpgradeDomainProgressInfo = original.CurrentUpgradeDomainProgressInfo
type DeactivationIntentDescription = original.DeactivationIntentDescription
type DeletePropertyBatchOperation = original.DeletePropertyBatchOperation
type DeltaNodesCheckHealthEvaluation = original.DeltaNodesCheckHealthEvaluation
type DeployedApplicationHealth = original.DeployedApplicationHealth
type DeployedApplicationHealthEvaluation = original.DeployedApplicationHealthEvaluation
type DeployedApplicationHealthState = original.DeployedApplicationHealthState
type DeployedApplicationHealthStateChunk = original.DeployedApplicationHealthStateChunk
type DeployedApplicationHealthStateChunkList = original.DeployedApplicationHealthStateChunkList
type DeployedApplicationHealthStateFilter = original.DeployedApplicationHealthStateFilter
type DeployedApplicationInfo = original.DeployedApplicationInfo
type DeployedApplicationsHealthEvaluation = original.DeployedApplicationsHealthEvaluation
type DeployedCodePackageInfo = original.DeployedCodePackageInfo
type DeployedServicePackageHealth = original.DeployedServicePackageHealth
type DeployedServicePackageHealthEvaluation = original.DeployedServicePackageHealthEvaluation
type DeployedServicePackageHealthState = original.DeployedServicePackageHealthState
type DeployedServicePackageHealthStateChunk = original.DeployedServicePackageHealthStateChunk
type DeployedServicePackageHealthStateChunkList = original.DeployedServicePackageHealthStateChunkList
type DeployedServicePackageHealthStateFilter = original.DeployedServicePackageHealthStateFilter
type DeployedServicePackageInfo = original.DeployedServicePackageInfo
type DeployedServicePackagesHealthEvaluation = original.DeployedServicePackagesHealthEvaluation
type BasicDeployedServiceReplicaDetailInfo = original.BasicDeployedServiceReplicaDetailInfo
type DeployedServiceReplicaDetailInfo = original.DeployedServiceReplicaDetailInfo
type DeployedServiceReplicaDetailInfoModel = original.DeployedServiceReplicaDetailInfoModel
type BasicDeployedServiceReplicaInfo = original.BasicDeployedServiceReplicaInfo
type DeployedServiceReplicaInfo = original.DeployedServiceReplicaInfo
type DeployedServiceTypeInfo = original.DeployedServiceTypeInfo
type DeployedStatefulServiceReplicaDetailInfo = original.DeployedStatefulServiceReplicaDetailInfo
type DeployedStatefulServiceReplicaInfo = original.DeployedStatefulServiceReplicaInfo
type DeployedStatelessServiceInstanceDetailInfo = original.DeployedStatelessServiceInstanceDetailInfo
type DeployedStatelessServiceInstanceInfo = original.DeployedStatelessServiceInstanceInfo
type DeployServicePackageToNodeDescription = original.DeployServicePackageToNodeDescription
type DoublePropertyValue = original.DoublePropertyValue
type EnsureAvailabilitySafetyCheck = original.EnsureAvailabilitySafetyCheck
type EnsurePartitionQurumSafetyCheck = original.EnsurePartitionQurumSafetyCheck
type EntityHealth = original.EntityHealth
type EntityHealthState = original.EntityHealthState
type EntityHealthStateChunk = original.EntityHealthStateChunk
type EntityHealthStateChunkList = original.EntityHealthStateChunkList
type EntityKindHealthStateCount = original.EntityKindHealthStateCount
type Epoch = original.Epoch
type EventHealthEvaluation = original.EventHealthEvaluation
type ExecutingFaultsChaosEvent = original.ExecutingFaultsChaosEvent
type FabricCodeVersionInfo = original.FabricCodeVersionInfo
type FabricConfigVersionInfo = original.FabricConfigVersionInfo
type FabricError = original.FabricError
type FabricErrorError = original.FabricErrorError
type FailedPropertyBatchInfo = original.FailedPropertyBatchInfo
type FailedUpgradeDomainProgressObject = original.FailedUpgradeDomainProgressObject
type FailureUpgradeDomainProgressInfo = original.FailureUpgradeDomainProgressInfo
type FileInfo = original.FileInfo
type FileVersion = original.FileVersion
type FolderInfo = original.FolderInfo
type GetPropertyBatchOperation = original.GetPropertyBatchOperation
type GUIDPropertyValue = original.GUIDPropertyValue
type BasicHealthEvaluation = original.BasicHealthEvaluation
type HealthEvaluation = original.HealthEvaluation
type HealthEvaluationWrapper = original.HealthEvaluationWrapper
type HealthEvent = original.HealthEvent
type HealthInformation = original.HealthInformation
type HealthStateCount = original.HealthStateCount
type HealthStatistics = original.HealthStatistics
type ImageStoreContent = original.ImageStoreContent
type ImageStoreCopyDescription = original.ImageStoreCopyDescription
type Int64PropertyValue = original.Int64PropertyValue
type Int64RangePartitionInformation = original.Int64RangePartitionInformation
type InvokeDataLossResult = original.InvokeDataLossResult
type InvokeQuorumLossResult = original.InvokeQuorumLossResult
type KeyValueStoreReplicaStatus = original.KeyValueStoreReplicaStatus
type ListDeployedApplicationInfo = original.ListDeployedApplicationInfo
type ListDeployedCodePackageInfo = original.ListDeployedCodePackageInfo
type ListDeployedServicePackageInfo = original.ListDeployedServicePackageInfo
type ListDeployedServiceReplicaInfo = original.ListDeployedServiceReplicaInfo
type ListDeployedServiceTypeInfo = original.ListDeployedServiceTypeInfo
type ListFabricCodeVersionInfo = original.ListFabricCodeVersionInfo
type ListFabricConfigVersionInfo = original.ListFabricConfigVersionInfo
type ListOperationStatus = original.ListOperationStatus
type ListRepairTask = original.ListRepairTask
type ListServiceTypeInfo = original.ListServiceTypeInfo
type LoadMetricReport = original.LoadMetricReport
type LoadMetricReportInfo = original.LoadMetricReportInfo
type MonitoringPolicyDescription = original.MonitoringPolicyDescription
type NameDescription = original.NameDescription
type NamedPartitionInformation = original.NamedPartitionInformation
type NamedPartitionSchemeDescription = original.NamedPartitionSchemeDescription
type NodeDeactivationInfo = original.NodeDeactivationInfo
type NodeDeactivationTask = original.NodeDeactivationTask
type NodeDeactivationTaskID = original.NodeDeactivationTaskID
type NodeHealth = original.NodeHealth
type NodeHealthEvaluation = original.NodeHealthEvaluation
type NodeHealthState = original.NodeHealthState
type NodeHealthStateChunk = original.NodeHealthStateChunk
type NodeHealthStateChunkList = original.NodeHealthStateChunkList
type NodeHealthStateFilter = original.NodeHealthStateFilter
type NodeID = original.NodeID
type NodeImpact = original.NodeImpact
type NodeInfo = original.NodeInfo
type NodeLoadInfo = original.NodeLoadInfo
type NodeLoadMetricInformation = original.NodeLoadMetricInformation
type NodeRepairImpactDescription = original.NodeRepairImpactDescription
type NodeRepairTargetDescription = original.NodeRepairTargetDescription
type NodeResult = original.NodeResult
type NodesHealthEvaluation = original.NodesHealthEvaluation
type NodeTransitionProgress = original.NodeTransitionProgress
type NodeTransitionResult = original.NodeTransitionResult
type NodeUpgradeProgressInfo = original.NodeUpgradeProgressInfo
type OperationStatus = original.OperationStatus
type PackageSharingPolicyInfo = original.PackageSharingPolicyInfo
type PagedApplicationInfoList = original.PagedApplicationInfoList
type PagedApplicationTypeInfoList = original.PagedApplicationTypeInfoList
type PagedComposeDeploymentStatusInfoList = original.PagedComposeDeploymentStatusInfoList
type PagedNodeInfoList = original.PagedNodeInfoList
type PagedPropertyInfoList = original.PagedPropertyInfoList
type PagedReplicaInfoList = original.PagedReplicaInfoList
type PagedServiceInfoList = original.PagedServiceInfoList
type PagedServicePartitionInfoList = original.PagedServicePartitionInfoList
type PagedSubNameInfoList = original.PagedSubNameInfoList
type PartitionDataLossProgress = original.PartitionDataLossProgress
type PartitionHealth = original.PartitionHealth
type PartitionHealthEvaluation = original.PartitionHealthEvaluation
type PartitionHealthState = original.PartitionHealthState
type PartitionHealthStateChunk = original.PartitionHealthStateChunk
type PartitionHealthStateChunkList = original.PartitionHealthStateChunkList
type PartitionHealthStateFilter = original.PartitionHealthStateFilter
type BasicPartitionInformation = original.BasicPartitionInformation
type PartitionInformation = original.PartitionInformation
type PartitionLoadInformation = original.PartitionLoadInformation
type PartitionQuorumLossProgress = original.PartitionQuorumLossProgress
type PartitionRestartProgress = original.PartitionRestartProgress
type BasicPartitionSafetyCheck = original.BasicPartitionSafetyCheck
type PartitionSafetyCheck = original.PartitionSafetyCheck
type BasicPartitionSchemeDescription = original.BasicPartitionSchemeDescription
type PartitionSchemeDescription = original.PartitionSchemeDescription
type PartitionsHealthEvaluation = original.PartitionsHealthEvaluation
type PrimaryReplicatorStatus = original.PrimaryReplicatorStatus
type PropertyBatchDescriptionList = original.PropertyBatchDescriptionList
type BasicPropertyBatchInfo = original.BasicPropertyBatchInfo
type PropertyBatchInfo = original.PropertyBatchInfo
type PropertyBatchInfoModel = original.PropertyBatchInfoModel
type BasicPropertyBatchOperation = original.BasicPropertyBatchOperation
type PropertyBatchOperation = original.PropertyBatchOperation
type PropertyDescription = original.PropertyDescription
type PropertyInfo = original.PropertyInfo
type PropertyMetadata = original.PropertyMetadata
type BasicPropertyValue = original.BasicPropertyValue
type PropertyValue = original.PropertyValue
type ProvisionFabricDescription = original.ProvisionFabricDescription
type PutPropertyBatchOperation = original.PutPropertyBatchOperation
type ReconfigurationInformation = original.ReconfigurationInformation
type RegistryCredential = original.RegistryCredential
type RemoteReplicatorAcknowledgementDetail = original.RemoteReplicatorAcknowledgementDetail
type RemoteReplicatorAcknowledgementStatus = original.RemoteReplicatorAcknowledgementStatus
type RemoteReplicatorStatus = original.RemoteReplicatorStatus
type BasicRepairImpactDescriptionBase = original.BasicRepairImpactDescriptionBase
type RepairImpactDescriptionBase = original.RepairImpactDescriptionBase
type BasicRepairTargetDescriptionBase = original.BasicRepairTargetDescriptionBase
type RepairTargetDescriptionBase = original.RepairTargetDescriptionBase
type RepairTask = original.RepairTask
type RepairTaskApproveDescription = original.RepairTaskApproveDescription
type RepairTaskCancelDescription = original.RepairTaskCancelDescription
type RepairTaskDeleteDescription = original.RepairTaskDeleteDescription
type RepairTaskHistory = original.RepairTaskHistory
type RepairTaskUpdateHealthPolicyDescription = original.RepairTaskUpdateHealthPolicyDescription
type RepairTaskUpdateInfo = original.RepairTaskUpdateInfo
type BasicReplicaHealth = original.BasicReplicaHealth
type ReplicaHealth = original.ReplicaHealth
type ReplicaHealthEvaluation = original.ReplicaHealthEvaluation
type ReplicaHealthModel = original.ReplicaHealthModel
type BasicReplicaHealthState = original.BasicReplicaHealthState
type ReplicaHealthState = original.ReplicaHealthState
type ReplicaHealthStateChunk = original.ReplicaHealthStateChunk
type ReplicaHealthStateChunkList = original.ReplicaHealthStateChunkList
type ReplicaHealthStateFilter = original.ReplicaHealthStateFilter
type BasicReplicaInfo = original.BasicReplicaInfo
type ReplicaInfo = original.ReplicaInfo
type ReplicaInfoModel = original.ReplicaInfoModel
type ReplicasHealthEvaluation = original.ReplicasHealthEvaluation
type BasicReplicaStatusBase = original.BasicReplicaStatusBase
type ReplicaStatusBase = original.ReplicaStatusBase
type ReplicatorQueueStatus = original.ReplicatorQueueStatus
type BasicReplicatorStatus = original.BasicReplicatorStatus
type ReplicatorStatus = original.ReplicatorStatus
type ResolvedServiceEndpoint = original.ResolvedServiceEndpoint
type ResolvedServicePartition = original.ResolvedServicePartition
type RestartDeployedCodePackageDescription = original.RestartDeployedCodePackageDescription
type RestartNodeDescription = original.RestartNodeDescription
type RestartPartitionResult = original.RestartPartitionResult
type ResumeApplicationUpgradeDescription = original.ResumeApplicationUpgradeDescription
type ResumeClusterUpgradeDescription = original.ResumeClusterUpgradeDescription
type RollingUpgradeUpdateDescription = original.RollingUpgradeUpdateDescription
type BasicSafetyCheck = original.BasicSafetyCheck
type SafetyCheck = original.SafetyCheck
type SafetyCheckWrapper = original.SafetyCheckWrapper
type SecondaryActiveReplicatorStatus = original.SecondaryActiveReplicatorStatus
type SecondaryIdleReplicatorStatus = original.SecondaryIdleReplicatorStatus
type BasicSecondaryReplicatorStatus = original.BasicSecondaryReplicatorStatus
type SecondaryReplicatorStatus = original.SecondaryReplicatorStatus
type SeedNodeSafetyCheck = original.SeedNodeSafetyCheck
type SelectedPartition = original.SelectedPartition
type ServiceCorrelationDescription = original.ServiceCorrelationDescription
type BasicServiceDescription = original.BasicServiceDescription
type ServiceDescription = original.ServiceDescription
type ServiceDescriptionModel = original.ServiceDescriptionModel
type ServiceFromTemplateDescription = original.ServiceFromTemplateDescription
type ServiceHealth = original.ServiceHealth
type ServiceHealthEvaluation = original.ServiceHealthEvaluation
type ServiceHealthState = original.ServiceHealthState
type ServiceHealthStateChunk = original.ServiceHealthStateChunk
type ServiceHealthStateChunkList = original.ServiceHealthStateChunkList
type ServiceHealthStateFilter = original.ServiceHealthStateFilter
type BasicServiceInfo = original.BasicServiceInfo
type ServiceInfo = original.ServiceInfo
type ServiceInfoModel = original.ServiceInfoModel
type ServiceLoadMetricDescription = original.ServiceLoadMetricDescription
type ServiceNameInfo = original.ServiceNameInfo
type BasicServicePartitionInfo = original.BasicServicePartitionInfo
type ServicePartitionInfo = original.ServicePartitionInfo
type ServicePartitionInfoModel = original.ServicePartitionInfoModel
type ServicePlacementInvalidDomainPolicyDescription = original.ServicePlacementInvalidDomainPolicyDescription
type ServicePlacementNonPartiallyPlaceServicePolicyDescription = original.ServicePlacementNonPartiallyPlaceServicePolicyDescription
type BasicServicePlacementPolicyDescription = original.BasicServicePlacementPolicyDescription
type ServicePlacementPolicyDescription = original.ServicePlacementPolicyDescription
type ServicePlacementPreferPrimaryDomainPolicyDescription = original.ServicePlacementPreferPrimaryDomainPolicyDescription
type ServicePlacementRequiredDomainPolicyDescription = original.ServicePlacementRequiredDomainPolicyDescription
type ServicePlacementRequireDomainDistributionPolicyDescription = original.ServicePlacementRequireDomainDistributionPolicyDescription
type ServicesHealthEvaluation = original.ServicesHealthEvaluation
type BasicServiceTypeDescription = original.BasicServiceTypeDescription
type ServiceTypeDescription = original.ServiceTypeDescription
type ServiceTypeExtensionDescription = original.ServiceTypeExtensionDescription
type ServiceTypeHealthPolicy = original.ServiceTypeHealthPolicy
type ServiceTypeHealthPolicyMapItem = original.ServiceTypeHealthPolicyMapItem
type ServiceTypeInfo = original.ServiceTypeInfo
type ServiceTypeManifest = original.ServiceTypeManifest
type BasicServiceUpdateDescription = original.BasicServiceUpdateDescription
type ServiceUpdateDescription = original.ServiceUpdateDescription
type SingletonPartitionInformation = original.SingletonPartitionInformation
type SingletonPartitionSchemeDescription = original.SingletonPartitionSchemeDescription
type StartClusterUpgradeDescription = original.StartClusterUpgradeDescription
type StartedChaosEvent = original.StartedChaosEvent
type StatefulServiceDescription = original.StatefulServiceDescription
type StatefulServiceInfo = original.StatefulServiceInfo
type StatefulServicePartitionInfo = original.StatefulServicePartitionInfo
type StatefulServiceReplicaHealth = original.StatefulServiceReplicaHealth
type StatefulServiceReplicaHealthState = original.StatefulServiceReplicaHealthState
type StatefulServiceReplicaInfo = original.StatefulServiceReplicaInfo
type StatefulServiceTypeDescription = original.StatefulServiceTypeDescription
type StatefulServiceUpdateDescription = original.StatefulServiceUpdateDescription
type StatelessServiceDescription = original.StatelessServiceDescription
type StatelessServiceInfo = original.StatelessServiceInfo
type StatelessServiceInstanceHealth = original.StatelessServiceInstanceHealth
type StatelessServiceInstanceHealthState = original.StatelessServiceInstanceHealthState
type StatelessServiceInstanceInfo = original.StatelessServiceInstanceInfo
type StatelessServicePartitionInfo = original.StatelessServicePartitionInfo
type StatelessServiceTypeDescription = original.StatelessServiceTypeDescription
type StatelessServiceUpdateDescription = original.StatelessServiceUpdateDescription
type StoppedChaosEvent = original.StoppedChaosEvent
type String = original.String
type StringPropertyValue = original.StringPropertyValue
type SuccessfulPropertyBatchInfo = original.SuccessfulPropertyBatchInfo
type SystemApplicationHealthEvaluation = original.SystemApplicationHealthEvaluation
type TestErrorChaosEvent = original.TestErrorChaosEvent
type UniformInt64RangePartitionSchemeDescription = original.UniformInt64RangePartitionSchemeDescription
type UnprovisionFabricDescription = original.UnprovisionFabricDescription
type UpdateClusterUpgradeDescription = original.UpdateClusterUpgradeDescription
type UpgradeDomainDeltaNodesCheckHealthEvaluation = original.UpgradeDomainDeltaNodesCheckHealthEvaluation
type UpgradeDomainInfo = original.UpgradeDomainInfo
type UpgradeDomainNodesHealthEvaluation = original.UpgradeDomainNodesHealthEvaluation
type ValidationFailedChaosEvent = original.ValidationFailedChaosEvent
type WaitForInbuildReplicaSafetyCheck = original.WaitForInbuildReplicaSafetyCheck
type WaitForPrimaryPlacementSafetyCheck = original.WaitForPrimaryPlacementSafetyCheck
type WaitForPrimarySwapSafetyCheck = original.WaitForPrimarySwapSafetyCheck
type WaitForReconfigurationSafetyCheck = original.WaitForReconfigurationSafetyCheck
type WaitingChaosEvent = original.WaitingChaosEvent

func New() BaseClient {
	return original.New()
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
