package face

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// AzureRegions enumerates the values for azure regions.
type AzureRegions string

const (
	// Eastus2 specifies the eastus 2 state for azure regions.
	Eastus2 AzureRegions = "eastus2"
	// Southeastasia specifies the southeastasia state for azure regions.
	Southeastasia AzureRegions = "southeastasia"
	// Westcentralus specifies the westcentralus state for azure regions.
	Westcentralus AzureRegions = "westcentralus"
	// Westeurope specifies the westeurope state for azure regions.
	Westeurope AzureRegions = "westeurope"
	// Westus specifies the westus state for azure regions.
	Westus AzureRegions = "westus"
)

// Gender enumerates the values for gender.
type Gender string

const (
	// Female specifies the female state for gender.
	Female Gender = "female"
	// Male specifies the male state for gender.
	Male Gender = "male"
)

// Glasses enumerates the values for glasses.
type Glasses string

const (
	// NoGlasses specifies the no glasses state for glasses.
	NoGlasses Glasses = "noGlasses"
	// ReadingGlasses specifies the reading glasses state for glasses.
	ReadingGlasses Glasses = "readingGlasses"
	// Sunglasses specifies the sunglasses state for glasses.
	Sunglasses Glasses = "sunglasses"
	// SwimmingGoggles specifies the swimming goggles state for glasses.
	SwimmingGoggles Glasses = "swimmingGoggles"
)

// Mode enumerates the values for mode.
type Mode string

const (
	// MatchFace specifies the match face state for mode.
	MatchFace Mode = "matchFace"
	// MatchPerson specifies the match person state for mode.
	MatchPerson Mode = "matchPerson"
)

// Status enumerates the values for status.
type Status string

const (
	// Failed specifies the failed state for status.
	Failed Status = "failed"
	// Nonstarted specifies the nonstarted state for status.
	Nonstarted Status = "nonstarted"
	// Running specifies the running state for status.
	Running Status = "running"
	// Succeeded specifies the succeeded state for status.
	Succeeded Status = "succeeded"
)

// APIError is error information returned by the API
type APIError struct {
	Error *Error `json:"error,omitempty"`
}

// Attributes is face Attributes
type Attributes struct {
	Age        *float64              `json:"age,omitempty"`
	Gender     Gender                `json:"gender,omitempty"`
	Smile      *float64              `json:"smile,omitempty"`
	Glasses    Glasses               `json:"glasses,omitempty"`
	FacialHair *FacialHairProperties `json:"facialHair,omitempty"`
	HeadPose   *HeadPoseProperties   `json:"headPose,omitempty"`
	Emotion    *EmotionProperties    `json:"emotion,omitempty"`
}

// CreateFaceListRequest is request to create a face list.
type CreateFaceListRequest struct {
	Name     *string `json:"name,omitempty"`
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonGroupRequest is request to create a person group.
type CreatePersonGroupRequest struct {
	Name     *string `json:"name,omitempty"`
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonRequest is request to create a person object.
type CreatePersonRequest struct {
	Name     *string `json:"name,omitempty"`
	UserData *string `json:"userData,omitempty"`
}

// CreatePersonResult is result of creating person.
type CreatePersonResult struct {
	autorest.Response `json:"-"`
	PersonID          *string `json:"personId,omitempty"`
}

// DetectedFace is detected Face object.
type DetectedFace struct {
	FaceID        *string    `json:"faceId,omitempty"`
	FaceRectangle *Rectangle `json:"faceRectangle,omitempty"`
	FaceLandmarks *Landmarks `json:"faceLandmarks,omitempty"`
}

// EmotionProperties is properties describing facial emotion.
type EmotionProperties struct {
	Anger     *float64 `json:"anger,omitempty"`
	Contempt  *float64 `json:"contempt,omitempty"`
	Disgust   *float64 `json:"disgust,omitempty"`
	Fear      *float64 `json:"fear,omitempty"`
	Happiness *float64 `json:"happiness,omitempty"`
	Neutral   *float64 `json:"neutral,omitempty"`
	Sadness   *float64 `json:"sadness,omitempty"`
	Surprise  *float64 `json:"surprise,omitempty"`
}

// Error is error body.
type Error struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// FacialHairProperties is properties describing facial hair attributes.
type FacialHairProperties struct {
	Mustache  *float64 `json:"mustache,omitempty"`
	Beard     *float64 `json:"beard,omitempty"`
	Sideburns *float64 `json:"sideburns,omitempty"`
}

// FindSimilarRequest is request body for find similar operation.
type FindSimilarRequest struct {
	FaceID                     *string   `json:"faceId,omitempty"`
	FaceListID                 *string   `json:"faceListId,omitempty"`
	FaceIds                    *[]string `json:"faceIds,omitempty"`
	MaxNumOfCandidatesReturned *int32    `json:"maxNumOfCandidatesReturned,omitempty"`
	Mode                       Mode      `json:"mode,omitempty"`
}

// GetFaceListResult is result of the GetFaceList operation.
type GetFaceListResult struct {
	autorest.Response `json:"-"`
	FaceListID        *string `json:"faceListId,omitempty"`
	Name              *string `json:"name,omitempty"`
	UserData          *string `json:"userData,omitempty"`
}

// GroupRequest is request body for group request.
type GroupRequest struct {
	FaceIds *[]string `json:"faceIds,omitempty"`
}

// GroupResponse is an array of face groups based on face similarity.
type GroupResponse struct {
	autorest.Response `json:"-"`
	Groups            *[][]string `json:"groups,omitempty"`
	MessyGroup        *[]string   `json:"messyGroup,omitempty"`
}

// HeadPoseProperties is properties indicating head pose of the face.
type HeadPoseProperties struct {
	Roll  *float64 `json:"roll,omitempty"`
	Yaw   *float64 `json:"yaw,omitempty"`
	Pitch *float64 `json:"pitch,omitempty"`
}

// IdentifyRequest is request body for identify face operation.
type IdentifyRequest struct {
	PersonGroupID              *string   `json:"personGroupId,omitempty"`
	FaceIds                    *[]string `json:"faceIds,omitempty"`
	MaxNumOfCandidatesReturned *int32    `json:"maxNumOfCandidatesReturned,omitempty"`
	ConfidenceThreshold        *float64  `json:"confidenceThreshold,omitempty"`
}

// IdentifyResultCandidate is all possible faces that may qualify.
type IdentifyResultCandidate struct {
	PersonID   *string  `json:"personId,omitempty"`
	Confidence *float64 `json:"confidence,omitempty"`
}

// IdentifyResultItem is response body for identify face operation.
type IdentifyResultItem struct {
	FaceID     *string                    `json:"faceId,omitempty"`
	Candidates *[]IdentifyResultCandidate `json:"candidates,omitempty"`
}

// ImageURL is
type ImageURL struct {
	URL *string `json:"url,omitempty"`
}

// Landmarks is a collection of 27-point face landmarks pointing to the important positions of face components.
type Landmarks struct {
	PupilLeft           *Position `json:"pupilLeft,omitempty"`
	PupilRight          *Position `json:"pupilRight,omitempty"`
	NoseTip             *Position `json:"noseTip,omitempty"`
	MouthLeft           *Position `json:"mouthLeft,omitempty"`
	MouthRight          *Position `json:"mouthRight,omitempty"`
	EyebrowLeftOuter    *Position `json:"eyebrowLeftOuter,omitempty"`
	EyebrowLeftInner    *Position `json:"eyebrowLeftInner,omitempty"`
	EyeLeftOuter        *Position `json:"eyeLeftOuter,omitempty"`
	EyeLeftTop          *Position `json:"eyeLeftTop,omitempty"`
	EyeLeftBottom       *Position `json:"eyeLeftBottom,omitempty"`
	EyeLeftInner        *Position `json:"eyeLeftInner,omitempty"`
	EyebrowRightInner   *Position `json:"eyebrowRightInner,omitempty"`
	EyebrowRightOuter   *Position `json:"eyebrowRightOuter,omitempty"`
	EyeRightInner       *Position `json:"eyeRightInner,omitempty"`
	EyeRightTop         *Position `json:"eyeRightTop,omitempty"`
	EyeRightBottom      *Position `json:"eyeRightBottom,omitempty"`
	EyeRightOuter       *Position `json:"eyeRightOuter,omitempty"`
	NoseRootLeft        *Position `json:"noseRootLeft,omitempty"`
	NoseRootRight       *Position `json:"noseRootRight,omitempty"`
	NoseLeftAlarTop     *Position `json:"noseLeftAlarTop,omitempty"`
	NoseRightAlarTop    *Position `json:"noseRightAlarTop,omitempty"`
	NoseLeftAlarOutTip  *Position `json:"noseLeftAlarOutTip,omitempty"`
	NoseRightAlarOutTip *Position `json:"noseRightAlarOutTip,omitempty"`
	UpperLipTop         *Position `json:"upperLipTop,omitempty"`
	UpperLipBottom      *Position `json:"upperLipBottom,omitempty"`
	UnderLipTop         *Position `json:"underLipTop,omitempty"`
	UnderLipBottom      *Position `json:"underLipBottom,omitempty"`
}

// ListDetectedFace is
type ListDetectedFace struct {
	autorest.Response `json:"-"`
	Value             *[]DetectedFace `json:"value,omitempty"`
}

// ListGetFaceListResult is
type ListGetFaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]GetFaceListResult `json:"value,omitempty"`
}

// ListIdentifyResultItem is
type ListIdentifyResultItem struct {
	autorest.Response `json:"-"`
	Value             *[]IdentifyResultItem `json:"value,omitempty"`
}

// ListPersonGroupResult is
type ListPersonGroupResult struct {
	autorest.Response `json:"-"`
	Value             *[]PersonGroupResult `json:"value,omitempty"`
}

// ListPersonResult is
type ListPersonResult struct {
	autorest.Response `json:"-"`
	Value             *[]PersonResult `json:"value,omitempty"`
}

// ListSimilarFaceResult is
type ListSimilarFaceResult struct {
	autorest.Response `json:"-"`
	Value             *[]SimilarFaceResult `json:"value,omitempty"`
}

// PersonFaceResult is personFace object.
type PersonFaceResult struct {
	autorest.Response `json:"-"`
	PersistedFaceID   *string `json:"persistedFaceId,omitempty"`
	UserData          *string `json:"userData,omitempty"`
}

// PersonGroupResult is person group object.
type PersonGroupResult struct {
	autorest.Response `json:"-"`
	PersonGroupID     *string `json:"personGroupId,omitempty"`
	Name              *string `json:"name,omitempty"`
	UserData          *string `json:"userData,omitempty"`
}

// PersonResult is person object.
type PersonResult struct {
	autorest.Response `json:"-"`
	PersonID          *string   `json:"personId,omitempty"`
	PersistedFaceIds  *[]string `json:"persistedFaceIds,omitempty"`
	Name              *string   `json:"name,omitempty"`
	UserData          *string   `json:"userData,omitempty"`
}

// Position is coordinates within an image
type Position struct {
	X *int32 `json:"x,omitempty"`
	Y *int32 `json:"y,omitempty"`
}

// Rectangle is a rectangle within which a face can be found
type Rectangle struct {
	Width  *int32 `json:"width,omitempty"`
	Height *int32 `json:"height,omitempty"`
	Left   *int32 `json:"left,omitempty"`
	Top    *int32 `json:"top,omitempty"`
}

// SimilarFaceResult is response body for find similar face operation.
type SimilarFaceResult struct {
	FaceID          *string  `json:"faceId,omitempty"`
	PersistedFaceID *string  `json:"persistedFaceId,omitempty"`
	Confidence      *float64 `json:"confidence,omitempty"`
}

// TrainingStatus is training status object.
type TrainingStatus struct {
	autorest.Response `json:"-"`
	Status            Status     `json:"status,omitempty"`
	Created           *date.Time `json:"createdDateTime,omitempty"`
	LastAction        *date.Time `json:"lastActionDateTime,omitempty"`
	Message           *string    `json:"message,omitempty"`
}

// UpdatePersonFaceDataRequest is request to update person face data.
type UpdatePersonFaceDataRequest struct {
	UserData *string `json:"userData,omitempty"`
}

// VerifyRequest is request body for verify operation.
type VerifyRequest struct {
	FaceID        *string `json:"faceId,omitempty"`
	PersonID      *string `json:"personId,omitempty"`
	PersonGroupID *string `json:"personGroupId,omitempty"`
}

// VerifyResult is result of the verify operation.
type VerifyResult struct {
	autorest.Response `json:"-"`
	IsIdentical       *bool    `json:"isIdentical,omitempty"`
	Confidence        *float64 `json:"confidence,omitempty"`
}
