package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	uuid "github.com/satori/go.uuid"
	"io"
	"net/http"
)

// AccessControlEntryAction enumerates the values for access control entry action.
type AccessControlEntryAction string

const (
	// Deny specifies the deny state for access control entry action.
	Deny AccessControlEntryAction = "Deny"
	// Permit specifies the permit state for access control entry action.
	Permit AccessControlEntryAction = "Permit"
)

// AppServicePlanRestrictions enumerates the values for app service plan restrictions.
type AppServicePlanRestrictions string

const (
	// Basic specifies the basic state for app service plan restrictions.
	Basic AppServicePlanRestrictions = "Basic"
	// Free specifies the free state for app service plan restrictions.
	Free AppServicePlanRestrictions = "Free"
	// None specifies the none state for app service plan restrictions.
	None AppServicePlanRestrictions = "None"
	// Premium specifies the premium state for app service plan restrictions.
	Premium AppServicePlanRestrictions = "Premium"
	// Shared specifies the shared state for app service plan restrictions.
	Shared AppServicePlanRestrictions = "Shared"
	// Standard specifies the standard state for app service plan restrictions.
	Standard AppServicePlanRestrictions = "Standard"
)

// AutoHealActionType enumerates the values for auto heal action type.
type AutoHealActionType string

const (
	// CustomAction specifies the custom action state for auto heal action type.
	CustomAction AutoHealActionType = "CustomAction"
	// LogEvent specifies the log event state for auto heal action type.
	LogEvent AutoHealActionType = "LogEvent"
	// Recycle specifies the recycle state for auto heal action type.
	Recycle AutoHealActionType = "Recycle"
)

// AzureResourceType enumerates the values for azure resource type.
type AzureResourceType string

const (
	// TrafficManager specifies the traffic manager state for azure resource type.
	TrafficManager AzureResourceType = "TrafficManager"
	// Website specifies the website state for azure resource type.
	Website AzureResourceType = "Website"
)

// BackupItemStatus enumerates the values for backup item status.
type BackupItemStatus string

const (
	// Created specifies the created state for backup item status.
	Created BackupItemStatus = "Created"
	// Deleted specifies the deleted state for backup item status.
	Deleted BackupItemStatus = "Deleted"
	// DeleteFailed specifies the delete failed state for backup item status.
	DeleteFailed BackupItemStatus = "DeleteFailed"
	// DeleteInProgress specifies the delete in progress state for backup item status.
	DeleteInProgress BackupItemStatus = "DeleteInProgress"
	// Failed specifies the failed state for backup item status.
	Failed BackupItemStatus = "Failed"
	// InProgress specifies the in progress state for backup item status.
	InProgress BackupItemStatus = "InProgress"
	// PartiallySucceeded specifies the partially succeeded state for backup item status.
	PartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	// Skipped specifies the skipped state for backup item status.
	Skipped BackupItemStatus = "Skipped"
	// Succeeded specifies the succeeded state for backup item status.
	Succeeded BackupItemStatus = "Succeeded"
	// TimedOut specifies the timed out state for backup item status.
	TimedOut BackupItemStatus = "TimedOut"
)

// BackupRestoreOperationType enumerates the values for backup restore operation type.
type BackupRestoreOperationType string

const (
	// BackupRestoreOperationTypeClone specifies the backup restore operation type clone state for backup restore operation
	// type.
	BackupRestoreOperationTypeClone BackupRestoreOperationType = "Clone"
	// BackupRestoreOperationTypeDefault specifies the backup restore operation type default state for backup restore
	// operation type.
	BackupRestoreOperationTypeDefault BackupRestoreOperationType = "Default"
	// BackupRestoreOperationTypeRelocation specifies the backup restore operation type relocation state for backup restore
	// operation type.
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = "Relocation"
	// BackupRestoreOperationTypeSnapshot specifies the backup restore operation type snapshot state for backup restore
	// operation type.
	BackupRestoreOperationTypeSnapshot BackupRestoreOperationType = "Snapshot"
)

// BuiltInAuthenticationProvider enumerates the values for built in authentication provider.
type BuiltInAuthenticationProvider string

const (
	// AzureActiveDirectory specifies the azure active directory state for built in authentication provider.
	AzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	// Facebook specifies the facebook state for built in authentication provider.
	Facebook BuiltInAuthenticationProvider = "Facebook"
	// Google specifies the google state for built in authentication provider.
	Google BuiltInAuthenticationProvider = "Google"
	// MicrosoftAccount specifies the microsoft account state for built in authentication provider.
	MicrosoftAccount BuiltInAuthenticationProvider = "MicrosoftAccount"
	// Twitter specifies the twitter state for built in authentication provider.
	Twitter BuiltInAuthenticationProvider = "Twitter"
)

// CertificateOrderActionType enumerates the values for certificate order action type.
type CertificateOrderActionType string

const (
	// CertificateExpirationWarning specifies the certificate expiration warning state for certificate order action type.
	CertificateExpirationWarning CertificateOrderActionType = "CertificateExpirationWarning"
	// CertificateExpired specifies the certificate expired state for certificate order action type.
	CertificateExpired CertificateOrderActionType = "CertificateExpired"
	// CertificateIssued specifies the certificate issued state for certificate order action type.
	CertificateIssued CertificateOrderActionType = "CertificateIssued"
	// CertificateOrderCanceled specifies the certificate order canceled state for certificate order action type.
	CertificateOrderCanceled CertificateOrderActionType = "CertificateOrderCanceled"
	// CertificateOrderCreated specifies the certificate order created state for certificate order action type.
	CertificateOrderCreated CertificateOrderActionType = "CertificateOrderCreated"
	// CertificateRevoked specifies the certificate revoked state for certificate order action type.
	CertificateRevoked CertificateOrderActionType = "CertificateRevoked"
	// DomainValidationComplete specifies the domain validation complete state for certificate order action type.
	DomainValidationComplete CertificateOrderActionType = "DomainValidationComplete"
	// FraudCleared specifies the fraud cleared state for certificate order action type.
	FraudCleared CertificateOrderActionType = "FraudCleared"
	// FraudDetected specifies the fraud detected state for certificate order action type.
	FraudDetected CertificateOrderActionType = "FraudDetected"
	// FraudDocumentationRequired specifies the fraud documentation required state for certificate order action type.
	FraudDocumentationRequired CertificateOrderActionType = "FraudDocumentationRequired"
	// OrgNameChange specifies the org name change state for certificate order action type.
	OrgNameChange CertificateOrderActionType = "OrgNameChange"
	// OrgValidationComplete specifies the org validation complete state for certificate order action type.
	OrgValidationComplete CertificateOrderActionType = "OrgValidationComplete"
	// SanDrop specifies the san drop state for certificate order action type.
	SanDrop CertificateOrderActionType = "SanDrop"
	// Unknown specifies the unknown state for certificate order action type.
	Unknown CertificateOrderActionType = "Unknown"
)

// CertificateOrderStatus enumerates the values for certificate order status.
type CertificateOrderStatus string

const (
	// Canceled specifies the canceled state for certificate order status.
	Canceled CertificateOrderStatus = "Canceled"
	// Denied specifies the denied state for certificate order status.
	Denied CertificateOrderStatus = "Denied"
	// Expired specifies the expired state for certificate order status.
	Expired CertificateOrderStatus = "Expired"
	// Issued specifies the issued state for certificate order status.
	Issued CertificateOrderStatus = "Issued"
	// NotSubmitted specifies the not submitted state for certificate order status.
	NotSubmitted CertificateOrderStatus = "NotSubmitted"
	// Pendingissuance specifies the pendingissuance state for certificate order status.
	Pendingissuance CertificateOrderStatus = "Pendingissuance"
	// PendingRekey specifies the pending rekey state for certificate order status.
	PendingRekey CertificateOrderStatus = "PendingRekey"
	// Pendingrevocation specifies the pendingrevocation state for certificate order status.
	Pendingrevocation CertificateOrderStatus = "Pendingrevocation"
	// Revoked specifies the revoked state for certificate order status.
	Revoked CertificateOrderStatus = "Revoked"
	// Unused specifies the unused state for certificate order status.
	Unused CertificateOrderStatus = "Unused"
)

// CertificateProductType enumerates the values for certificate product type.
type CertificateProductType string

const (
	// StandardDomainValidatedSsl specifies the standard domain validated ssl state for certificate product type.
	StandardDomainValidatedSsl CertificateProductType = "StandardDomainValidatedSsl"
	// StandardDomainValidatedWildCardSsl specifies the standard domain validated wild card ssl state for certificate
	// product type.
	StandardDomainValidatedWildCardSsl CertificateProductType = "StandardDomainValidatedWildCardSsl"
)

// Channels enumerates the values for channels.
type Channels string

const (
	// All specifies the all state for channels.
	All Channels = "All"
	// API specifies the api state for channels.
	API Channels = "Api"
	// Email specifies the email state for channels.
	Email Channels = "Email"
	// Notification specifies the notification state for channels.
	Notification Channels = "Notification"
	// Webhook specifies the webhook state for channels.
	Webhook Channels = "Webhook"
)

// CheckNameResourceTypes enumerates the values for check name resource types.
type CheckNameResourceTypes string

const (
	// CheckNameResourceTypesHostingEnvironment specifies the check name resource types hosting environment state for check
	// name resource types.
	CheckNameResourceTypesHostingEnvironment CheckNameResourceTypes = "HostingEnvironment"
	// CheckNameResourceTypesSite specifies the check name resource types site state for check name resource types.
	CheckNameResourceTypesSite CheckNameResourceTypes = "Site"
	// CheckNameResourceTypesSlot specifies the check name resource types slot state for check name resource types.
	CheckNameResourceTypesSlot CheckNameResourceTypes = "Slot"
)

// CloneAbilityResult enumerates the values for clone ability result.
type CloneAbilityResult string

const (
	// Cloneable specifies the cloneable state for clone ability result.
	Cloneable CloneAbilityResult = "Cloneable"
	// NotCloneable specifies the not cloneable state for clone ability result.
	NotCloneable CloneAbilityResult = "NotCloneable"
	// PartiallyCloneable specifies the partially cloneable state for clone ability result.
	PartiallyCloneable CloneAbilityResult = "PartiallyCloneable"
)

// ComputeModeOptions enumerates the values for compute mode options.
type ComputeModeOptions string

const (
	// ComputeModeOptionsDedicated specifies the compute mode options dedicated state for compute mode options.
	ComputeModeOptionsDedicated ComputeModeOptions = "Dedicated"
	// ComputeModeOptionsDynamic specifies the compute mode options dynamic state for compute mode options.
	ComputeModeOptionsDynamic ComputeModeOptions = "Dynamic"
	// ComputeModeOptionsShared specifies the compute mode options shared state for compute mode options.
	ComputeModeOptionsShared ComputeModeOptions = "Shared"
)

// ConnectionStringType enumerates the values for connection string type.
type ConnectionStringType string

const (
	// APIHub specifies the api hub state for connection string type.
	APIHub ConnectionStringType = "ApiHub"
	// Custom specifies the custom state for connection string type.
	Custom ConnectionStringType = "Custom"
	// DocDb specifies the doc db state for connection string type.
	DocDb ConnectionStringType = "DocDb"
	// EventHub specifies the event hub state for connection string type.
	EventHub ConnectionStringType = "EventHub"
	// MySQL specifies the my sql state for connection string type.
	MySQL ConnectionStringType = "MySql"
	// NotificationHub specifies the notification hub state for connection string type.
	NotificationHub ConnectionStringType = "NotificationHub"
	// PostgreSQL specifies the postgre sql state for connection string type.
	PostgreSQL ConnectionStringType = "PostgreSQL"
	// RedisCache specifies the redis cache state for connection string type.
	RedisCache ConnectionStringType = "RedisCache"
	// ServiceBus specifies the service bus state for connection string type.
	ServiceBus ConnectionStringType = "ServiceBus"
	// SQLAzure specifies the sql azure state for connection string type.
	SQLAzure ConnectionStringType = "SQLAzure"
	// SQLServer specifies the sql server state for connection string type.
	SQLServer ConnectionStringType = "SQLServer"
)

// ContinuousWebJobStatus enumerates the values for continuous web job status.
type ContinuousWebJobStatus string

const (
	// Initializing specifies the initializing state for continuous web job status.
	Initializing ContinuousWebJobStatus = "Initializing"
	// PendingRestart specifies the pending restart state for continuous web job status.
	PendingRestart ContinuousWebJobStatus = "PendingRestart"
	// Running specifies the running state for continuous web job status.
	Running ContinuousWebJobStatus = "Running"
	// Starting specifies the starting state for continuous web job status.
	Starting ContinuousWebJobStatus = "Starting"
	// Stopped specifies the stopped state for continuous web job status.
	Stopped ContinuousWebJobStatus = "Stopped"
)

// CustomHostNameDNSRecordType enumerates the values for custom host name dns record type.
type CustomHostNameDNSRecordType string

const (
	// A specifies the a state for custom host name dns record type.
	A CustomHostNameDNSRecordType = "A"
	// CName specifies the c name state for custom host name dns record type.
	CName CustomHostNameDNSRecordType = "CName"
)

// DatabaseType enumerates the values for database type.
type DatabaseType string

const (
	// DatabaseTypeLocalMySQL specifies the database type local my sql state for database type.
	DatabaseTypeLocalMySQL DatabaseType = "LocalMySql"
	// DatabaseTypeMySQL specifies the database type my sql state for database type.
	DatabaseTypeMySQL DatabaseType = "MySql"
	// DatabaseTypePostgreSQL specifies the database type postgre sql state for database type.
	DatabaseTypePostgreSQL DatabaseType = "PostgreSql"
	// DatabaseTypeSQLAzure specifies the database type sql azure state for database type.
	DatabaseTypeSQLAzure DatabaseType = "SqlAzure"
)

// DNSType enumerates the values for dns type.
type DNSType string

const (
	// AzureDNS specifies the azure dns state for dns type.
	AzureDNS DNSType = "AzureDns"
	// DefaultDomainRegistrarDNS specifies the default domain registrar dns state for dns type.
	DefaultDomainRegistrarDNS DNSType = "DefaultDomainRegistrarDns"
)

// DNSVerificationTestResult enumerates the values for dns verification test result.
type DNSVerificationTestResult string

const (
	// DNSVerificationTestResultFailed specifies the dns verification test result failed state for dns verification test
	// result.
	DNSVerificationTestResultFailed DNSVerificationTestResult = "Failed"
	// DNSVerificationTestResultPassed specifies the dns verification test result passed state for dns verification test
	// result.
	DNSVerificationTestResultPassed DNSVerificationTestResult = "Passed"
	// DNSVerificationTestResultSkipped specifies the dns verification test result skipped state for dns verification test
	// result.
	DNSVerificationTestResultSkipped DNSVerificationTestResult = "Skipped"
)

// DomainStatus enumerates the values for domain status.
type DomainStatus string

const (
	// DomainStatusActive specifies the domain status active state for domain status.
	DomainStatusActive DomainStatus = "Active"
	// DomainStatusAwaiting specifies the domain status awaiting state for domain status.
	DomainStatusAwaiting DomainStatus = "Awaiting"
	// DomainStatusCancelled specifies the domain status cancelled state for domain status.
	DomainStatusCancelled DomainStatus = "Cancelled"
	// DomainStatusConfiscated specifies the domain status confiscated state for domain status.
	DomainStatusConfiscated DomainStatus = "Confiscated"
	// DomainStatusDisabled specifies the domain status disabled state for domain status.
	DomainStatusDisabled DomainStatus = "Disabled"
	// DomainStatusExcluded specifies the domain status excluded state for domain status.
	DomainStatusExcluded DomainStatus = "Excluded"
	// DomainStatusExpired specifies the domain status expired state for domain status.
	DomainStatusExpired DomainStatus = "Expired"
	// DomainStatusFailed specifies the domain status failed state for domain status.
	DomainStatusFailed DomainStatus = "Failed"
	// DomainStatusHeld specifies the domain status held state for domain status.
	DomainStatusHeld DomainStatus = "Held"
	// DomainStatusJSONConverterFailed specifies the domain status json converter failed state for domain status.
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
	// DomainStatusLocked specifies the domain status locked state for domain status.
	DomainStatusLocked DomainStatus = "Locked"
	// DomainStatusParked specifies the domain status parked state for domain status.
	DomainStatusParked DomainStatus = "Parked"
	// DomainStatusPending specifies the domain status pending state for domain status.
	DomainStatusPending DomainStatus = "Pending"
	// DomainStatusReserved specifies the domain status reserved state for domain status.
	DomainStatusReserved DomainStatus = "Reserved"
	// DomainStatusReverted specifies the domain status reverted state for domain status.
	DomainStatusReverted DomainStatus = "Reverted"
	// DomainStatusSuspended specifies the domain status suspended state for domain status.
	DomainStatusSuspended DomainStatus = "Suspended"
	// DomainStatusTransferred specifies the domain status transferred state for domain status.
	DomainStatusTransferred DomainStatus = "Transferred"
	// DomainStatusUnknown specifies the domain status unknown state for domain status.
	DomainStatusUnknown DomainStatus = "Unknown"
	// DomainStatusUnlocked specifies the domain status unlocked state for domain status.
	DomainStatusUnlocked DomainStatus = "Unlocked"
	// DomainStatusUnparked specifies the domain status unparked state for domain status.
	DomainStatusUnparked DomainStatus = "Unparked"
	// DomainStatusUpdated specifies the domain status updated state for domain status.
	DomainStatusUpdated DomainStatus = "Updated"
)

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Regular specifies the regular state for domain type.
	Regular DomainType = "Regular"
	// SoftDeleted specifies the soft deleted state for domain type.
	SoftDeleted DomainType = "SoftDeleted"
)

// FrequencyUnit enumerates the values for frequency unit.
type FrequencyUnit string

const (
	// Day specifies the day state for frequency unit.
	Day FrequencyUnit = "Day"
	// Hour specifies the hour state for frequency unit.
	Hour FrequencyUnit = "Hour"
)

// HostingEnvironmentStatus enumerates the values for hosting environment status.
type HostingEnvironmentStatus string

const (
	// Deleting specifies the deleting state for hosting environment status.
	Deleting HostingEnvironmentStatus = "Deleting"
	// Preparing specifies the preparing state for hosting environment status.
	Preparing HostingEnvironmentStatus = "Preparing"
	// Ready specifies the ready state for hosting environment status.
	Ready HostingEnvironmentStatus = "Ready"
	// Scaling specifies the scaling state for hosting environment status.
	Scaling HostingEnvironmentStatus = "Scaling"
)

// HostNameType enumerates the values for host name type.
type HostNameType string

const (
	// Managed specifies the managed state for host name type.
	Managed HostNameType = "Managed"
	// Verified specifies the verified state for host name type.
	Verified HostNameType = "Verified"
)

// HostType enumerates the values for host type.
type HostType string

const (
	// HostTypeRepository specifies the host type repository state for host type.
	HostTypeRepository HostType = "Repository"
	// HostTypeStandard specifies the host type standard state for host type.
	HostTypeStandard HostType = "Standard"
)

// InAvailabilityReasonType enumerates the values for in availability reason type.
type InAvailabilityReasonType string

const (
	// AlreadyExists specifies the already exists state for in availability reason type.
	AlreadyExists InAvailabilityReasonType = "AlreadyExists"
	// Invalid specifies the invalid state for in availability reason type.
	Invalid InAvailabilityReasonType = "Invalid"
)

// InternalLoadBalancingMode enumerates the values for internal load balancing mode.
type InternalLoadBalancingMode string

const (
	// InternalLoadBalancingModeNone specifies the internal load balancing mode none state for internal load balancing
	// mode.
	InternalLoadBalancingModeNone InternalLoadBalancingMode = "None"
	// InternalLoadBalancingModePublishing specifies the internal load balancing mode publishing state for internal load
	// balancing mode.
	InternalLoadBalancingModePublishing InternalLoadBalancingMode = "Publishing"
	// InternalLoadBalancingModeWeb specifies the internal load balancing mode web state for internal load balancing mode.
	InternalLoadBalancingModeWeb InternalLoadBalancingMode = "Web"
)

// JobType enumerates the values for job type.
type JobType string

const (
	// Continuous specifies the continuous state for job type.
	Continuous JobType = "Continuous"
	// Triggered specifies the triggered state for job type.
	Triggered JobType = "Triggered"
)

// KeyVaultSecretStatus enumerates the values for key vault secret status.
type KeyVaultSecretStatus string

const (
	// KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault specifies the key vault secret status azure service
	// unauthorized to access key vault state for key vault secret status.
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = "AzureServiceUnauthorizedToAccessKeyVault"
	// KeyVaultSecretStatusCertificateOrderFailed specifies the key vault secret status certificate order failed state for
	// key vault secret status.
	KeyVaultSecretStatusCertificateOrderFailed KeyVaultSecretStatus = "CertificateOrderFailed"
	// KeyVaultSecretStatusExternalPrivateKey specifies the key vault secret status external private key state for key
	// vault secret status.
	KeyVaultSecretStatusExternalPrivateKey KeyVaultSecretStatus = "ExternalPrivateKey"
	// KeyVaultSecretStatusInitialized specifies the key vault secret status initialized state for key vault secret status.
	KeyVaultSecretStatusInitialized KeyVaultSecretStatus = "Initialized"
	// KeyVaultSecretStatusKeyVaultDoesNotExist specifies the key vault secret status key vault does not exist state for
	// key vault secret status.
	KeyVaultSecretStatusKeyVaultDoesNotExist KeyVaultSecretStatus = "KeyVaultDoesNotExist"
	// KeyVaultSecretStatusKeyVaultSecretDoesNotExist specifies the key vault secret status key vault secret does not exist
	// state for key vault secret status.
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist KeyVaultSecretStatus = "KeyVaultSecretDoesNotExist"
	// KeyVaultSecretStatusOperationNotPermittedOnKeyVault specifies the key vault secret status operation not permitted on
	// key vault state for key vault secret status.
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault KeyVaultSecretStatus = "OperationNotPermittedOnKeyVault"
	// KeyVaultSecretStatusSucceeded specifies the key vault secret status succeeded state for key vault secret status.
	KeyVaultSecretStatusSucceeded KeyVaultSecretStatus = "Succeeded"
	// KeyVaultSecretStatusUnknown specifies the key vault secret status unknown state for key vault secret status.
	KeyVaultSecretStatusUnknown KeyVaultSecretStatus = "Unknown"
	// KeyVaultSecretStatusUnknownError specifies the key vault secret status unknown error state for key vault secret
	// status.
	KeyVaultSecretStatusUnknownError KeyVaultSecretStatus = "UnknownError"
	// KeyVaultSecretStatusWaitingOnCertificateOrder specifies the key vault secret status waiting on certificate order
	// state for key vault secret status.
	KeyVaultSecretStatusWaitingOnCertificateOrder KeyVaultSecretStatus = "WaitingOnCertificateOrder"
)

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// Error specifies the error state for log level.
	Error LogLevel = "Error"
	// Information specifies the information state for log level.
	Information LogLevel = "Information"
	// Off specifies the off state for log level.
	Off LogLevel = "Off"
	// Verbose specifies the verbose state for log level.
	Verbose LogLevel = "Verbose"
	// Warning specifies the warning state for log level.
	Warning LogLevel = "Warning"
)

// ManagedPipelineMode enumerates the values for managed pipeline mode.
type ManagedPipelineMode string

const (
	// Classic specifies the classic state for managed pipeline mode.
	Classic ManagedPipelineMode = "Classic"
	// Integrated specifies the integrated state for managed pipeline mode.
	Integrated ManagedPipelineMode = "Integrated"
)

// MSDeployLogEntryType enumerates the values for ms deploy log entry type.
type MSDeployLogEntryType string

const (
	// MSDeployLogEntryTypeError specifies the ms deploy log entry type error state for ms deploy log entry type.
	MSDeployLogEntryTypeError MSDeployLogEntryType = "Error"
	// MSDeployLogEntryTypeMessage specifies the ms deploy log entry type message state for ms deploy log entry type.
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = "Message"
	// MSDeployLogEntryTypeWarning specifies the ms deploy log entry type warning state for ms deploy log entry type.
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = "Warning"
)

// MSDeployProvisioningState enumerates the values for ms deploy provisioning state.
type MSDeployProvisioningState string

const (
	// MSDeployProvisioningStateAccepted specifies the ms deploy provisioning state accepted state for ms deploy
	// provisioning state.
	MSDeployProvisioningStateAccepted MSDeployProvisioningState = "accepted"
	// MSDeployProvisioningStateCanceled specifies the ms deploy provisioning state canceled state for ms deploy
	// provisioning state.
	MSDeployProvisioningStateCanceled MSDeployProvisioningState = "canceled"
	// MSDeployProvisioningStateFailed specifies the ms deploy provisioning state failed state for ms deploy provisioning
	// state.
	MSDeployProvisioningStateFailed MSDeployProvisioningState = "failed"
	// MSDeployProvisioningStateRunning specifies the ms deploy provisioning state running state for ms deploy provisioning
	// state.
	MSDeployProvisioningStateRunning MSDeployProvisioningState = "running"
	// MSDeployProvisioningStateSucceeded specifies the ms deploy provisioning state succeeded state for ms deploy
	// provisioning state.
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = "succeeded"
)

// MySQLMigrationType enumerates the values for my sql migration type.
type MySQLMigrationType string

const (
	// LocalToRemote specifies the local to remote state for my sql migration type.
	LocalToRemote MySQLMigrationType = "LocalToRemote"
	// RemoteToLocal specifies the remote to local state for my sql migration type.
	RemoteToLocal MySQLMigrationType = "RemoteToLocal"
)

// NotificationLevel enumerates the values for notification level.
type NotificationLevel string

const (
	// NotificationLevelCritical specifies the notification level critical state for notification level.
	NotificationLevelCritical NotificationLevel = "Critical"
	// NotificationLevelInformation specifies the notification level information state for notification level.
	NotificationLevelInformation NotificationLevel = "Information"
	// NotificationLevelNonUrgentSuggestion specifies the notification level non urgent suggestion state for notification
	// level.
	NotificationLevelNonUrgentSuggestion NotificationLevel = "NonUrgentSuggestion"
	// NotificationLevelWarning specifies the notification level warning state for notification level.
	NotificationLevelWarning NotificationLevel = "Warning"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusCreated specifies the operation status created state for operation status.
	OperationStatusCreated OperationStatus = "Created"
	// OperationStatusFailed specifies the operation status failed state for operation status.
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress specifies the operation status in progress state for operation status.
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded specifies the operation status succeeded state for operation status.
	OperationStatusSucceeded OperationStatus = "Succeeded"
	// OperationStatusTimedOut specifies the operation status timed out state for operation status.
	OperationStatusTimedOut OperationStatus = "TimedOut"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled specifies the provisioning state canceled state for provisioning state.
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateDeleting specifies the provisioning state deleting state for provisioning state.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed specifies the provisioning state failed state for provisioning state.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress specifies the provisioning state in progress state for provisioning state.
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded specifies the provisioning state succeeded state for provisioning state.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PublicCertificateLocation enumerates the values for public certificate location.
type PublicCertificateLocation string

const (
	// PublicCertificateLocationCurrentUserMy specifies the public certificate location current user my state for public
	// certificate location.
	PublicCertificateLocationCurrentUserMy PublicCertificateLocation = "CurrentUserMy"
	// PublicCertificateLocationLocalMachineMy specifies the public certificate location local machine my state for public
	// certificate location.
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = "LocalMachineMy"
	// PublicCertificateLocationUnknown specifies the public certificate location unknown state for public certificate
	// location.
	PublicCertificateLocationUnknown PublicCertificateLocation = "Unknown"
)

// PublishingProfileFormat enumerates the values for publishing profile format.
type PublishingProfileFormat string

const (
	// FileZilla3 specifies the file zilla 3 state for publishing profile format.
	FileZilla3 PublishingProfileFormat = "FileZilla3"
	// Ftp specifies the ftp state for publishing profile format.
	Ftp PublishingProfileFormat = "Ftp"
	// WebDeploy specifies the web deploy state for publishing profile format.
	WebDeploy PublishingProfileFormat = "WebDeploy"
)

// ResourceScopeType enumerates the values for resource scope type.
type ResourceScopeType string

const (
	// ServerFarm specifies the server farm state for resource scope type.
	ServerFarm ResourceScopeType = "ServerFarm"
	// Subscription specifies the subscription state for resource scope type.
	Subscription ResourceScopeType = "Subscription"
	// WebSite specifies the web site state for resource scope type.
	WebSite ResourceScopeType = "WebSite"
)

// RouteType enumerates the values for route type.
type RouteType string

const (
	// DEFAULT specifies the default state for route type.
	DEFAULT RouteType = "DEFAULT"
	// INHERITED specifies the inherited state for route type.
	INHERITED RouteType = "INHERITED"
	// STATIC specifies the static state for route type.
	STATIC RouteType = "STATIC"
)

// ScmType enumerates the values for scm type.
type ScmType string

const (
	// ScmTypeBitbucketGit specifies the scm type bitbucket git state for scm type.
	ScmTypeBitbucketGit ScmType = "BitbucketGit"
	// ScmTypeBitbucketHg specifies the scm type bitbucket hg state for scm type.
	ScmTypeBitbucketHg ScmType = "BitbucketHg"
	// ScmTypeCodePlexGit specifies the scm type code plex git state for scm type.
	ScmTypeCodePlexGit ScmType = "CodePlexGit"
	// ScmTypeCodePlexHg specifies the scm type code plex hg state for scm type.
	ScmTypeCodePlexHg ScmType = "CodePlexHg"
	// ScmTypeDropbox specifies the scm type dropbox state for scm type.
	ScmTypeDropbox ScmType = "Dropbox"
	// ScmTypeExternalGit specifies the scm type external git state for scm type.
	ScmTypeExternalGit ScmType = "ExternalGit"
	// ScmTypeExternalHg specifies the scm type external hg state for scm type.
	ScmTypeExternalHg ScmType = "ExternalHg"
	// ScmTypeGitHub specifies the scm type git hub state for scm type.
	ScmTypeGitHub ScmType = "GitHub"
	// ScmTypeLocalGit specifies the scm type local git state for scm type.
	ScmTypeLocalGit ScmType = "LocalGit"
	// ScmTypeNone specifies the scm type none state for scm type.
	ScmTypeNone ScmType = "None"
	// ScmTypeOneDrive specifies the scm type one drive state for scm type.
	ScmTypeOneDrive ScmType = "OneDrive"
	// ScmTypeTfs specifies the scm type tfs state for scm type.
	ScmTypeTfs ScmType = "Tfs"
	// ScmTypeVSO specifies the scm type vso state for scm type.
	ScmTypeVSO ScmType = "VSO"
)

// SiteAvailabilityState enumerates the values for site availability state.
type SiteAvailabilityState string

const (
	// DisasterRecoveryMode specifies the disaster recovery mode state for site availability state.
	DisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
	// Limited specifies the limited state for site availability state.
	Limited SiteAvailabilityState = "Limited"
	// Normal specifies the normal state for site availability state.
	Normal SiteAvailabilityState = "Normal"
)

// SiteExtensionType enumerates the values for site extension type.
type SiteExtensionType string

const (
	// Gallery specifies the gallery state for site extension type.
	Gallery SiteExtensionType = "Gallery"
	// WebRoot specifies the web root state for site extension type.
	WebRoot SiteExtensionType = "WebRoot"
)

// SiteLoadBalancing enumerates the values for site load balancing.
type SiteLoadBalancing string

const (
	// LeastRequests specifies the least requests state for site load balancing.
	LeastRequests SiteLoadBalancing = "LeastRequests"
	// LeastResponseTime specifies the least response time state for site load balancing.
	LeastResponseTime SiteLoadBalancing = "LeastResponseTime"
	// RequestHash specifies the request hash state for site load balancing.
	RequestHash SiteLoadBalancing = "RequestHash"
	// WeightedRoundRobin specifies the weighted round robin state for site load balancing.
	WeightedRoundRobin SiteLoadBalancing = "WeightedRoundRobin"
	// WeightedTotalTraffic specifies the weighted total traffic state for site load balancing.
	WeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic specifies the sku name basic state for sku name.
	SkuNameBasic SkuName = "Basic"
	// SkuNameDynamic specifies the sku name dynamic state for sku name.
	SkuNameDynamic SkuName = "Dynamic"
	// SkuNameFree specifies the sku name free state for sku name.
	SkuNameFree SkuName = "Free"
	// SkuNameIsolated specifies the sku name isolated state for sku name.
	SkuNameIsolated SkuName = "Isolated"
	// SkuNamePremium specifies the sku name premium state for sku name.
	SkuNamePremium SkuName = "Premium"
	// SkuNamePremiumV2 specifies the sku name premium v2 state for sku name.
	SkuNamePremiumV2 SkuName = "PremiumV2"
	// SkuNameShared specifies the sku name shared state for sku name.
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard specifies the sku name standard state for sku name.
	SkuNameStandard SkuName = "Standard"
)

// SslState enumerates the values for ssl state.
type SslState string

const (
	// Disabled specifies the disabled state for ssl state.
	Disabled SslState = "Disabled"
	// IPBasedEnabled specifies the ip based enabled state for ssl state.
	IPBasedEnabled SslState = "IpBasedEnabled"
	// SniEnabled specifies the sni enabled state for ssl state.
	SniEnabled SslState = "SniEnabled"
)

// StatusOptions enumerates the values for status options.
type StatusOptions string

const (
	// StatusOptionsPending specifies the status options pending state for status options.
	StatusOptionsPending StatusOptions = "Pending"
	// StatusOptionsReady specifies the status options ready state for status options.
	StatusOptionsReady StatusOptions = "Ready"
)

// TriggeredWebJobStatus enumerates the values for triggered web job status.
type TriggeredWebJobStatus string

const (
	// TriggeredWebJobStatusError specifies the triggered web job status error state for triggered web job status.
	TriggeredWebJobStatusError TriggeredWebJobStatus = "Error"
	// TriggeredWebJobStatusFailed specifies the triggered web job status failed state for triggered web job status.
	TriggeredWebJobStatusFailed TriggeredWebJobStatus = "Failed"
	// TriggeredWebJobStatusSuccess specifies the triggered web job status success state for triggered web job status.
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = "Success"
)

// UnauthenticatedClientAction enumerates the values for unauthenticated client action.
type UnauthenticatedClientAction string

const (
	// AllowAnonymous specifies the allow anonymous state for unauthenticated client action.
	AllowAnonymous UnauthenticatedClientAction = "AllowAnonymous"
	// RedirectToLoginPage specifies the redirect to login page state for unauthenticated client action.
	RedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
)

// UsageState enumerates the values for usage state.
type UsageState string

const (
	// UsageStateExceeded specifies the usage state exceeded state for usage state.
	UsageStateExceeded UsageState = "Exceeded"
	// UsageStateNormal specifies the usage state normal state for usage state.
	UsageStateNormal UsageState = "Normal"
)

// ValidateResourceTypes enumerates the values for validate resource types.
type ValidateResourceTypes string

const (
	// ValidateResourceTypesServerFarm specifies the validate resource types server farm state for validate resource types.
	ValidateResourceTypesServerFarm ValidateResourceTypes = "ServerFarm"
	// ValidateResourceTypesSite specifies the validate resource types site state for validate resource types.
	ValidateResourceTypesSite ValidateResourceTypes = "Site"
)

// WorkerSizeOptions enumerates the values for worker size options.
type WorkerSizeOptions string

const (
	// Default specifies the default state for worker size options.
	Default WorkerSizeOptions = "Default"
	// Large specifies the large state for worker size options.
	Large WorkerSizeOptions = "Large"
	// Medium specifies the medium state for worker size options.
	Medium WorkerSizeOptions = "Medium"
	// Small specifies the small state for worker size options.
	Small WorkerSizeOptions = "Small"
)

// Address is address information for domain registration.
type Address struct {
	Address1   *string `json:"address1,omitempty"`
	Address2   *string `json:"address2,omitempty"`
	City       *string `json:"city,omitempty"`
	Country    *string `json:"country,omitempty"`
	PostalCode *string `json:"postalCode,omitempty"`
	State      *string `json:"state,omitempty"`
}

// AddressResponse is describes main public IP address and any extra virtual IPs.
type AddressResponse struct {
	autorest.Response   `json:"-"`
	ServiceIPAddress    *string             `json:"serviceIpAddress,omitempty"`
	InternalIPAddress   *string             `json:"internalIpAddress,omitempty"`
	OutboundIPAddresses *[]string           `json:"outboundIpAddresses,omitempty"`
	VipMappings         *[]VirtualIPMapping `json:"vipMappings,omitempty"`
}

// APIDefinitionInfo is information about the formal API definition for the app.
type APIDefinitionInfo struct {
	URL *string `json:"url,omitempty"`
}

// AppCollection is collection of App Service apps.
type AppCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Site `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// AppCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppCollection) AppCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppInstanceCollection is collection of app instances.
type AppInstanceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SiteInstance `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// AppInstanceCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppInstanceCollection) AppInstanceCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ApplicationLogsConfig is application logs configuration.
type ApplicationLogsConfig struct {
	FileSystem        *FileSystemApplicationLogsConfig        `json:"fileSystem,omitempty"`
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`
	AzureBlobStorage  *AzureBlobStorageApplicationLogsConfig  `json:"azureBlobStorage,omitempty"`
}

// AppServiceCertificate is key Vault container for a certificate that is purchased through Azure.
type AppServiceCertificate struct {
	KeyVaultID         *string              `json:"keyVaultId,omitempty"`
	KeyVaultSecretName *string              `json:"keyVaultSecretName,omitempty"`
	ProvisioningState  KeyVaultSecretStatus `json:"provisioningState,omitempty"`
}

// AppServiceCertificateCollection is collection of certitificateorder certificates.
type AppServiceCertificateCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AppServiceCertificateResource `json:"value,omitempty"`
	NextLink          *string                          `json:"nextLink,omitempty"`
}

// AppServiceCertificateCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppServiceCertificateCollection) AppServiceCertificateCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppServiceCertificateOrder is SSL certificate purchase order.
type AppServiceCertificateOrder struct {
	autorest.Response                     `json:"-"`
	ID                                    *string             `json:"id,omitempty"`
	Name                                  *string             `json:"name,omitempty"`
	Kind                                  *string             `json:"kind,omitempty"`
	Location                              *string             `json:"location,omitempty"`
	Type                                  *string             `json:"type,omitempty"`
	Tags                                  *map[string]*string `json:"tags,omitempty"`
	*AppServiceCertificateOrderProperties `json:"properties,omitempty"`
}

// AppServiceCertificateOrderCollection is collection of certitificate orders.
type AppServiceCertificateOrderCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AppServiceCertificateOrder `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// AppServiceCertificateOrderCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppServiceCertificateOrderCollection) AppServiceCertificateOrderCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppServiceCertificateOrderProperties is appServiceCertificateOrder resource specific properties
type AppServiceCertificateOrderProperties struct {
	Certificates                             *map[string]*AppServiceCertificate `json:"certificates,omitempty"`
	DistinguishedName                        *string                            `json:"distinguishedName,omitempty"`
	DomainVerificationToken                  *string                            `json:"domainVerificationToken,omitempty"`
	ValidityInYears                          *int32                             `json:"validityInYears,omitempty"`
	KeySize                                  *int32                             `json:"keySize,omitempty"`
	ProductType                              CertificateProductType             `json:"productType,omitempty"`
	AutoRenew                                *bool                              `json:"autoRenew,omitempty"`
	ProvisioningState                        ProvisioningState                  `json:"provisioningState,omitempty"`
	Status                                   CertificateOrderStatus             `json:"status,omitempty"`
	SignedCertificate                        *CertificateDetails                `json:"signedCertificate,omitempty"`
	Csr                                      *string                            `json:"csr,omitempty"`
	Intermediate                             *CertificateDetails                `json:"intermediate,omitempty"`
	Root                                     *CertificateDetails                `json:"root,omitempty"`
	SerialNumber                             *string                            `json:"serialNumber,omitempty"`
	LastCertificateIssuanceTime              *date.Time                         `json:"lastCertificateIssuanceTime,omitempty"`
	ExpirationTime                           *date.Time                         `json:"expirationTime,omitempty"`
	IsPrivateKeyExternal                     *bool                              `json:"isPrivateKeyExternal,omitempty"`
	AppServiceCertificateNotRenewableReasons *[]string                          `json:"appServiceCertificateNotRenewableReasons,omitempty"`
	NextAutoRenewalTimeStamp                 *date.Time                         `json:"nextAutoRenewalTimeStamp,omitempty"`
}

// AppServiceCertificateResource is key Vault container ARM resource for a certificate that is purchased through Azure.
type AppServiceCertificateResource struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Kind                   *string             `json:"kind,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*AppServiceCertificate `json:"properties,omitempty"`
}

// AppServiceEnvironment is description of an App Service Environment.
type AppServiceEnvironment struct {
	Name                       *string                      `json:"name,omitempty"`
	Location                   *string                      `json:"location,omitempty"`
	ProvisioningState          ProvisioningState            `json:"provisioningState,omitempty"`
	Status                     HostingEnvironmentStatus     `json:"status,omitempty"`
	VnetName                   *string                      `json:"vnetName,omitempty"`
	VnetResourceGroupName      *string                      `json:"vnetResourceGroupName,omitempty"`
	VnetSubnetName             *string                      `json:"vnetSubnetName,omitempty"`
	VirtualNetwork             *VirtualNetworkProfile       `json:"virtualNetwork,omitempty"`
	InternalLoadBalancingMode  InternalLoadBalancingMode    `json:"internalLoadBalancingMode,omitempty"`
	MultiSize                  *string                      `json:"multiSize,omitempty"`
	MultiRoleCount             *int32                       `json:"multiRoleCount,omitempty"`
	WorkerPools                *[]WorkerPool                `json:"workerPools,omitempty"`
	IpsslAddressCount          *int32                       `json:"ipsslAddressCount,omitempty"`
	DatabaseEdition            *string                      `json:"databaseEdition,omitempty"`
	DatabaseServiceObjective   *string                      `json:"databaseServiceObjective,omitempty"`
	UpgradeDomains             *int32                       `json:"upgradeDomains,omitempty"`
	SubscriptionID             *string                      `json:"subscriptionId,omitempty"`
	DNSSuffix                  *string                      `json:"dnsSuffix,omitempty"`
	LastAction                 *string                      `json:"lastAction,omitempty"`
	LastActionResult           *string                      `json:"lastActionResult,omitempty"`
	AllowedMultiSizes          *string                      `json:"allowedMultiSizes,omitempty"`
	AllowedWorkerSizes         *string                      `json:"allowedWorkerSizes,omitempty"`
	MaximumNumberOfMachines    *int32                       `json:"maximumNumberOfMachines,omitempty"`
	VipMappings                *[]VirtualIPMapping          `json:"vipMappings,omitempty"`
	EnvironmentCapacities      *[]StampCapacity             `json:"environmentCapacities,omitempty"`
	NetworkAccessControlList   *[]NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`
	EnvironmentIsHealthy       *bool                        `json:"environmentIsHealthy,omitempty"`
	EnvironmentStatus          *string                      `json:"environmentStatus,omitempty"`
	ResourceGroup              *string                      `json:"resourceGroup,omitempty"`
	FrontEndScaleFactor        *int32                       `json:"frontEndScaleFactor,omitempty"`
	DefaultFrontEndScaleFactor *int32                       `json:"defaultFrontEndScaleFactor,omitempty"`
	APIManagementAccountID     *string                      `json:"apiManagementAccountId,omitempty"`
	Suspended                  *bool                        `json:"suspended,omitempty"`
	DynamicCacheEnabled        *bool                        `json:"dynamicCacheEnabled,omitempty"`
	ClusterSettings            *[]NameValuePair             `json:"clusterSettings,omitempty"`
}

// AppServiceEnvironmentCollection is collection of App Service Environments.
type AppServiceEnvironmentCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AppServiceEnvironment `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// AppServiceEnvironmentCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppServiceEnvironmentCollection) AppServiceEnvironmentCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppServiceEnvironmentResource is app Service Environment ARM resource.
type AppServiceEnvironmentResource struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Kind                   *string             `json:"kind,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*AppServiceEnvironment `json:"properties,omitempty"`
}

// AppServicePlan is app Service plan.
type AppServicePlan struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Kind                      *string             `json:"kind,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	*AppServicePlanProperties `json:"properties,omitempty"`
	Sku                       *SkuDescription `json:"sku,omitempty"`
}

// AppServicePlanCollection is collection of App Service plans.
type AppServicePlanCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AppServicePlan `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// AppServicePlanCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppServicePlanCollection) AppServicePlanCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppServicePlanProperties is appServicePlan resource specific properties
type AppServicePlanProperties struct {
	Name                      *string                    `json:"name,omitempty"`
	WorkerTierName            *string                    `json:"workerTierName,omitempty"`
	Status                    StatusOptions              `json:"status,omitempty"`
	Subscription              *string                    `json:"subscription,omitempty"`
	AdminSiteName             *string                    `json:"adminSiteName,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MaximumNumberOfWorkers    *int32                     `json:"maximumNumberOfWorkers,omitempty"`
	GeoRegion                 *string                    `json:"geoRegion,omitempty"`
	PerSiteScaling            *bool                      `json:"perSiteScaling,omitempty"`
	NumberOfSites             *int32                     `json:"numberOfSites,omitempty"`
	ResourceGroup             *string                    `json:"resourceGroup,omitempty"`
	Reserved                  *bool                      `json:"reserved,omitempty"`
	TargetWorkerCount         *int32                     `json:"targetWorkerCount,omitempty"`
	TargetWorkerSizeID        *int32                     `json:"targetWorkerSizeId,omitempty"`
	ProvisioningState         ProvisioningState          `json:"provisioningState,omitempty"`
}

// AutoHealActions is actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	ActionType              AutoHealActionType    `json:"actionType,omitempty"`
	CustomAction            *AutoHealCustomAction `json:"customAction,omitempty"`
	MinProcessExecutionTime *string               `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction is custom action to be executed
// when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	Exe        *string `json:"exe,omitempty"`
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules is rules that can be defined for auto-heal.
type AutoHealRules struct {
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
	Actions  *AutoHealActions  `json:"actions,omitempty"`
}

// AutoHealTriggers is triggers for auto-heal.
type AutoHealTriggers struct {
	Requests         *RequestsBasedTrigger      `json:"requests,omitempty"`
	PrivateBytesInKB *int32                     `json:"privateBytesInKB,omitempty"`
	StatusCodes      *[]StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
	SlowRequests     *SlowRequestsBasedTrigger  `json:"slowRequests,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig is application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	Level           LogLevel `json:"level,omitempty"`
	SasURL          *string  `json:"sasUrl,omitempty"`
	RetentionInDays *int32   `json:"retentionInDays,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig is http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	SasURL          *string `json:"sasUrl,omitempty"`
	RetentionInDays *int32  `json:"retentionInDays,omitempty"`
	Enabled         *bool   `json:"enabled,omitempty"`
}

// AzureTableStorageApplicationLogsConfig is application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	Level  LogLevel `json:"level,omitempty"`
	SasURL *string  `json:"sasUrl,omitempty"`
}

// BackupItem is backup description.
type BackupItem struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	Kind                  *string `json:"kind,omitempty"`
	Type                  *string `json:"type,omitempty"`
	*BackupItemProperties `json:"properties,omitempty"`
}

// BackupItemCollection is collection of backup items.
type BackupItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]BackupItem `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// BackupItemCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client BackupItemCollection) BackupItemCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// BackupItemProperties is backupItem resource specific properties
type BackupItemProperties struct {
	BackupID             *int32                   `json:"id,omitempty"`
	StorageAccountURL    *string                  `json:"storageAccountUrl,omitempty"`
	BlobName             *string                  `json:"blobName,omitempty"`
	Name                 *string                  `json:"name,omitempty"`
	Status               BackupItemStatus         `json:"status,omitempty"`
	SizeInBytes          *int64                   `json:"sizeInBytes,omitempty"`
	Created              *date.Time               `json:"created,omitempty"`
	Log                  *string                  `json:"log,omitempty"`
	Databases            *[]DatabaseBackupSetting `json:"databases,omitempty"`
	Scheduled            *bool                    `json:"scheduled,omitempty"`
	LastRestoreTimeStamp *date.Time               `json:"lastRestoreTimeStamp,omitempty"`
	FinishedTimeStamp    *date.Time               `json:"finishedTimeStamp,omitempty"`
	CorrelationID        *string                  `json:"correlationId,omitempty"`
	WebsiteSizeInBytes   *int64                   `json:"websiteSizeInBytes,omitempty"`
}

// BackupRequest is description of a backup which will be performed.
type BackupRequest struct {
	autorest.Response        `json:"-"`
	ID                       *string `json:"id,omitempty"`
	Name                     *string `json:"name,omitempty"`
	Kind                     *string `json:"kind,omitempty"`
	Type                     *string `json:"type,omitempty"`
	*BackupRequestProperties `json:"properties,omitempty"`
}

// BackupRequestProperties is backupRequest resource specific properties
type BackupRequestProperties struct {
	BackupRequestName *string                    `json:"name,omitempty"`
	Enabled           *bool                      `json:"enabled,omitempty"`
	StorageAccountURL *string                    `json:"storageAccountUrl,omitempty"`
	BackupSchedule    *BackupSchedule            `json:"backupSchedule,omitempty"`
	Databases         *[]DatabaseBackupSetting   `json:"databases,omitempty"`
	Type              BackupRestoreOperationType `json:"type,omitempty"`
}

// BackupSchedule is description of a backup schedule. Describes how often should be the backup performed and what
// should be the retention policy.
type BackupSchedule struct {
	FrequencyInterval     *int32        `json:"frequencyInterval,omitempty"`
	FrequencyUnit         FrequencyUnit `json:"frequencyUnit,omitempty"`
	KeepAtLeastOneBackup  *bool         `json:"keepAtLeastOneBackup,omitempty"`
	RetentionPeriodInDays *int32        `json:"retentionPeriodInDays,omitempty"`
	StartTime             *date.Time    `json:"startTime,omitempty"`
	LastExecutionTime     *date.Time    `json:"lastExecutionTime,omitempty"`
}

// Capability is describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	Name   *string `json:"name,omitempty"`
	Value  *string `json:"value,omitempty"`
	Reason *string `json:"reason,omitempty"`
}

// Certificate is SSL certificate for an app.
type Certificate struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Kind                   *string             `json:"kind,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*CertificateProperties `json:"properties,omitempty"`
}

// CertificateCollection is collection of certificates.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Certificate `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// CertificateCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CertificateCollection) CertificateCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CertificateDetails is SSL certificate details.
type CertificateDetails struct {
	Version            *int32     `json:"version,omitempty"`
	SerialNumber       *string    `json:"serialNumber,omitempty"`
	Thumbprint         *string    `json:"thumbprint,omitempty"`
	Subject            *string    `json:"subject,omitempty"`
	NotBefore          *date.Time `json:"notBefore,omitempty"`
	NotAfter           *date.Time `json:"notAfter,omitempty"`
	SignatureAlgorithm *string    `json:"signatureAlgorithm,omitempty"`
	Issuer             *string    `json:"issuer,omitempty"`
	RawData            *string    `json:"rawData,omitempty"`
}

// CertificateEmail is SSL certificate email.
type CertificateEmail struct {
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*CertificateEmailProperties `json:"properties,omitempty"`
}

// CertificateEmailProperties is certificateEmail resource specific properties
type CertificateEmailProperties struct {
	EmailID   *string    `json:"emailId,omitempty"`
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
}

// CertificateOrderAction is certificate order action.
type CertificateOrderAction struct {
	ID                                *string             `json:"id,omitempty"`
	Name                              *string             `json:"name,omitempty"`
	Kind                              *string             `json:"kind,omitempty"`
	Location                          *string             `json:"location,omitempty"`
	Type                              *string             `json:"type,omitempty"`
	Tags                              *map[string]*string `json:"tags,omitempty"`
	*CertificateOrderActionProperties `json:"properties,omitempty"`
}

// CertificateOrderActionProperties is certificateOrderAction resource specific properties
type CertificateOrderActionProperties struct {
	Type      CertificateOrderActionType `json:"type,omitempty"`
	CreatedAt *date.Time                 `json:"createdAt,omitempty"`
}

// CertificateProperties is certificate resource specific properties
type CertificateProperties struct {
	FriendlyName              *string                    `json:"friendlyName,omitempty"`
	SubjectName               *string                    `json:"subjectName,omitempty"`
	HostNames                 *[]string                  `json:"hostNames,omitempty"`
	PfxBlob                   *[]byte                    `json:"pfxBlob,omitempty"`
	SiteName                  *string                    `json:"siteName,omitempty"`
	SelfLink                  *string                    `json:"selfLink,omitempty"`
	Issuer                    *string                    `json:"issuer,omitempty"`
	IssueDate                 *date.Time                 `json:"issueDate,omitempty"`
	ExpirationDate            *date.Time                 `json:"expirationDate,omitempty"`
	Password                  *string                    `json:"password,omitempty"`
	Thumbprint                *string                    `json:"thumbprint,omitempty"`
	Valid                     *bool                      `json:"valid,omitempty"`
	CerBlob                   *string                    `json:"cerBlob,omitempty"`
	PublicKeyHash             *string                    `json:"publicKeyHash,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	KeyVaultID                *string                    `json:"keyVaultId,omitempty"`
	KeyVaultSecretName        *string                    `json:"keyVaultSecretName,omitempty"`
	KeyVaultSecretStatus      KeyVaultSecretStatus       `json:"keyVaultSecretStatus,omitempty"`
	GeoRegion                 *string                    `json:"geoRegion,omitempty"`
	Name                      *string                    `json:"name,omitempty"`
	ServerFarmID              *string                    `json:"serverFarmId,omitempty"`
}

// CloningInfo is information needed for cloning operation.
type CloningInfo struct {
	CorrelationID             *string             `json:"correlationId,omitempty"`
	Overwrite                 *bool               `json:"overwrite,omitempty"`
	CloneCustomHostNames      *bool               `json:"cloneCustomHostNames,omitempty"`
	CloneSourceControl        *bool               `json:"cloneSourceControl,omitempty"`
	SourceWebAppID            *string             `json:"sourceWebAppId,omitempty"`
	HostingEnvironment        *string             `json:"hostingEnvironment,omitempty"`
	AppSettingsOverrides      *map[string]*string `json:"appSettingsOverrides,omitempty"`
	ConfigureLoadBalancing    *bool               `json:"configureLoadBalancing,omitempty"`
	TrafficManagerProfileID   *string             `json:"trafficManagerProfileId,omitempty"`
	TrafficManagerProfileName *string             `json:"trafficManagerProfileName,omitempty"`
	IgnoreQuotas              *bool               `json:"ignoreQuotas,omitempty"`
}

// ConnectionStringDictionary is string dictionary resource.
type ConnectionStringDictionary struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Kind              *string                              `json:"kind,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Properties        *map[string]*ConnStringValueTypePair `json:"properties,omitempty"`
}

// ConnStringInfo is database connection string information.
type ConnStringInfo struct {
	Name             *string              `json:"name,omitempty"`
	ConnectionString *string              `json:"connectionString,omitempty"`
	Type             ConnectionStringType `json:"type,omitempty"`
}

// ConnStringValueTypePair is database connection string value to type pair.
type ConnStringValueTypePair struct {
	Value *string              `json:"value,omitempty"`
	Type  ConnectionStringType `json:"type,omitempty"`
}

// Contact is contact information for domain registration. If 'Domain Privacy' option is not selected then the contact
// information is made publicly available through the Whois
// directories as per ICANN requirements.
type Contact struct {
	AddressMailing *Address `json:"addressMailing,omitempty"`
	Email          *string  `json:"email,omitempty"`
	Fax            *string  `json:"fax,omitempty"`
	JobTitle       *string  `json:"jobTitle,omitempty"`
	NameFirst      *string  `json:"nameFirst,omitempty"`
	NameLast       *string  `json:"nameLast,omitempty"`
	NameMiddle     *string  `json:"nameMiddle,omitempty"`
	Organization   *string  `json:"organization,omitempty"`
	Phone          *string  `json:"phone,omitempty"`
}

// ContinuousWebJob is continuous Web Job Information.
type ContinuousWebJob struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*ContinuousWebJobProperties `json:"properties,omitempty"`
}

// ContinuousWebJobCollection is collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ContinuousWebJob `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// ContinuousWebJobCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ContinuousWebJobCollection) ContinuousWebJobCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ContinuousWebJobProperties is continuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	Status         ContinuousWebJobStatus  `json:"status,omitempty"`
	DetailedStatus *string                 `json:"detailedStatus,omitempty"`
	LogURL         *string                 `json:"logUrl,omitempty"`
	Name           *string                 `json:"name,omitempty"`
	RunCommand     *string                 `json:"runCommand,omitempty"`
	URL            *string                 `json:"url,omitempty"`
	ExtraInfoURL   *string                 `json:"extraInfoUrl,omitempty"`
	JobType        JobType                 `json:"jobType,omitempty"`
	Error          *string                 `json:"error,omitempty"`
	UsingSdk       *bool                   `json:"usingSdk,omitempty"`
	Settings       *map[string]interface{} `json:"settings,omitempty"`
}

// CorsSettings is cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
}

// CsmMoveResourceEnvelope is object with a list of the resources that need to be moved and the resource group they
// should be moved to.
type CsmMoveResourceEnvelope struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// CsmOperationCollection is collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	autorest.Response `json:"-"`
	Value             *[]CsmOperationDescription `json:"value,omitempty"`
	NextLink          *string                    `json:"nextLink,omitempty"`
}

// CsmOperationCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CsmOperationCollection) CsmOperationCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CsmOperationDescription is
type CsmOperationDescription struct {
	Name       *string                            `json:"name,omitempty"`
	Display    *CsmOperationDisplay               `json:"display,omitempty"`
	Origin     *string                            `json:"origin,omitempty"`
	Properties *CsmOperationDescriptionProperties `json:"properties,omitempty"`
}

// CsmOperationDescriptionProperties is
type CsmOperationDescriptionProperties struct {
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// CsmOperationDisplay is
type CsmOperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// CsmPublishingProfileOptions is publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	Format PublishingProfileFormat `json:"format,omitempty"`
}

// CsmSlotEntity is deployment slot parameters.
type CsmSlotEntity struct {
	TargetSlot   *string `json:"targetSlot,omitempty"`
	PreserveVnet *bool   `json:"preserveVnet,omitempty"`
}

// CsmUsageQuota is usage of the quota resource.
type CsmUsageQuota struct {
	Unit          *string            `json:"unit,omitempty"`
	NextResetTime *date.Time         `json:"nextResetTime,omitempty"`
	CurrentValue  *int64             `json:"currentValue,omitempty"`
	Limit         *int64             `json:"limit,omitempty"`
	Name          *LocalizableString `json:"name,omitempty"`
}

// CsmUsageQuotaCollection is collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	autorest.Response `json:"-"`
	Value             *[]CsmUsageQuota `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// CsmUsageQuotaCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CsmUsageQuotaCollection) CsmUsageQuotaCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CustomHostnameAnalysisResult is custom domain analysis.
type CustomHostnameAnalysisResult struct {
	autorest.Response                       `json:"-"`
	ID                                      *string `json:"id,omitempty"`
	Name                                    *string `json:"name,omitempty"`
	Kind                                    *string `json:"kind,omitempty"`
	Type                                    *string `json:"type,omitempty"`
	*CustomHostnameAnalysisResultProperties `json:"properties,omitempty"`
}

// CustomHostnameAnalysisResultProperties is customHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	IsHostnameAlreadyVerified           *bool                     `json:"isHostnameAlreadyVerified,omitempty"`
	CustomDomainVerificationTest        DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty"`
	CustomDomainVerificationFailureInfo *ErrorEntity              `json:"customDomainVerificationFailureInfo,omitempty"`
	HasConflictOnScaleUnit              *bool                     `json:"hasConflictOnScaleUnit,omitempty"`
	HasConflictAcrossSubscription       *bool                     `json:"hasConflictAcrossSubscription,omitempty"`
	ConflictingAppResourceID            *string                   `json:"conflictingAppResourceId,omitempty"`
	CNameRecords                        *[]string                 `json:"cNameRecords,omitempty"`
	TxtRecords                          *[]string                 `json:"txtRecords,omitempty"`
	ARecords                            *[]string                 `json:"aRecords,omitempty"`
	AlternateCNameRecords               *[]string                 `json:"alternateCNameRecords,omitempty"`
	AlternateTxtRecords                 *[]string                 `json:"alternateTxtRecords,omitempty"`
}

// DatabaseBackupSetting is database backup settings.
type DatabaseBackupSetting struct {
	DatabaseType         DatabaseType `json:"databaseType,omitempty"`
	Name                 *string      `json:"name,omitempty"`
	ConnectionStringName *string      `json:"connectionStringName,omitempty"`
	ConnectionString     *string      `json:"connectionString,omitempty"`
}

// DeletedSite is a deleted app.
type DeletedSite struct {
	ID               *int32  `json:"id,omitempty"`
	DeletedTimestamp *string `json:"deletedTimestamp,omitempty"`
	Subscription     *string `json:"subscription,omitempty"`
	ResourceGroup    *string `json:"resourceGroup,omitempty"`
	Name             *string `json:"name,omitempty"`
}

// DeletedWebAppCollection is collection of deleted apps.
type DeletedWebAppCollection struct {
	autorest.Response `json:"-"`
	Value             *[]DeletedSite `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// DeletedWebAppCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DeletedWebAppCollection) DeletedWebAppCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Deployment is user crendentials used for publishing activity.
type Deployment struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	Kind                  *string `json:"kind,omitempty"`
	Type                  *string `json:"type,omitempty"`
	*DeploymentProperties `json:"properties,omitempty"`
}

// DeploymentCollection is collection of app deployments.
type DeploymentCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Deployment `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// DeploymentCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DeploymentCollection) DeploymentCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DeploymentProperties is deployment resource specific properties
type DeploymentProperties struct {
	ID          *string    `json:"id,omitempty"`
	Status      *int32     `json:"status,omitempty"`
	Message     *string    `json:"message,omitempty"`
	Author      *string    `json:"author,omitempty"`
	Deployer    *string    `json:"deployer,omitempty"`
	AuthorEmail *string    `json:"authorEmail,omitempty"`
	StartTime   *date.Time `json:"startTime,omitempty"`
	EndTime     *date.Time `json:"endTime,omitempty"`
	Active      *bool      `json:"active,omitempty"`
	Details     *string    `json:"details,omitempty"`
}

// Dimension is
type Dimension struct {
	Name                   *string `json:"name,omitempty"`
	DisplayName            *string `json:"displayName,omitempty"`
	InternalName           *string `json:"internalName,omitempty"`
	ToBeExportedForShoebox *bool   `json:"toBeExportedForShoebox,omitempty"`
}

// Domain is information about a domain.
type Domain struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*DomainProperties `json:"properties,omitempty"`
}

// DomainAvailablilityCheckResult is domain availablility check result.
type DomainAvailablilityCheckResult struct {
	autorest.Response `json:"-"`
	Name              *string    `json:"name,omitempty"`
	Available         *bool      `json:"available,omitempty"`
	DomainType        DomainType `json:"domainType,omitempty"`
}

// DomainCollection is collection of domains.
type DomainCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Domain `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// DomainCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DomainCollection) DomainCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DomainControlCenterSsoRequest is single sign-on request information for domain management.
type DomainControlCenterSsoRequest struct {
	autorest.Response  `json:"-"`
	URL                *string `json:"url,omitempty"`
	PostParameterKey   *string `json:"postParameterKey,omitempty"`
	PostParameterValue *string `json:"postParameterValue,omitempty"`
}

// DomainOwnershipIdentifier is domain ownership Identifier.
type DomainOwnershipIdentifier struct {
	autorest.Response                    `json:"-"`
	ID                                   *string             `json:"id,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Kind                                 *string             `json:"kind,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	*DomainOwnershipIdentifierProperties `json:"properties,omitempty"`
}

// DomainOwnershipIdentifierCollection is collection of domain ownership identifiers.
type DomainOwnershipIdentifierCollection struct {
	autorest.Response `json:"-"`
	Value             *[]DomainOwnershipIdentifier `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// DomainOwnershipIdentifierCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DomainOwnershipIdentifierCollection) DomainOwnershipIdentifierCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DomainOwnershipIdentifierProperties is domainOwnershipIdentifier resource specific properties
type DomainOwnershipIdentifierProperties struct {
	OwnershipID *string `json:"ownershipId,omitempty"`
}

// DomainProperties is domain resource specific properties
type DomainProperties struct {
	ContactAdmin                *Contact               `json:"contactAdmin,omitempty"`
	ContactBilling              *Contact               `json:"contactBilling,omitempty"`
	ContactRegistrant           *Contact               `json:"contactRegistrant,omitempty"`
	ContactTech                 *Contact               `json:"contactTech,omitempty"`
	RegistrationStatus          DomainStatus           `json:"registrationStatus,omitempty"`
	ProvisioningState           ProvisioningState      `json:"provisioningState,omitempty"`
	NameServers                 *[]string              `json:"nameServers,omitempty"`
	Privacy                     *bool                  `json:"privacy,omitempty"`
	CreatedTime                 *date.Time             `json:"createdTime,omitempty"`
	ExpirationTime              *date.Time             `json:"expirationTime,omitempty"`
	LastRenewedTime             *date.Time             `json:"lastRenewedTime,omitempty"`
	AutoRenew                   *bool                  `json:"autoRenew,omitempty"`
	ReadyForDNSRecordManagement *bool                  `json:"readyForDnsRecordManagement,omitempty"`
	ManagedHostNames            *[]HostName            `json:"managedHostNames,omitempty"`
	Consent                     *DomainPurchaseConsent `json:"consent,omitempty"`
	DomainNotRenewableReasons   *[]string              `json:"domainNotRenewableReasons,omitempty"`
	DNSType                     DNSType                `json:"dnsType,omitempty"`
	DNSZoneID                   *string                `json:"dnsZoneId,omitempty"`
	TargetDNSType               DNSType                `json:"targetDnsType,omitempty"`
	AuthCode                    *string                `json:"authCode,omitempty"`
}

// DomainPurchaseConsent is domain purchase consent object, representing acceptance of applicable legal agreements.
type DomainPurchaseConsent struct {
	AgreementKeys *[]string  `json:"agreementKeys,omitempty"`
	AgreedBy      *string    `json:"agreedBy,omitempty"`
	AgreedAt      *date.Time `json:"agreedAt,omitempty"`
}

// DomainRecommendationSearchParameters is domain recommendation search parameters.
type DomainRecommendationSearchParameters struct {
	Keywords                 *string `json:"keywords,omitempty"`
	MaxDomainRecommendations *int32  `json:"maxDomainRecommendations,omitempty"`
}

// EnabledConfig is enabled configuration.
type EnabledConfig struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// ErrorEntity is body of the error response returned from the API.
type ErrorEntity struct {
	Code            *string        `json:"code,omitempty"`
	Message         *string        `json:"message,omitempty"`
	ExtendedCode    *string        `json:"extendedCode,omitempty"`
	MessageTemplate *string        `json:"messageTemplate,omitempty"`
	Parameters      *[]string      `json:"parameters,omitempty"`
	InnerErrors     *[]ErrorEntity `json:"innerErrors,omitempty"`
}

// Experiments is routing rules in production experiments.
type Experiments struct {
	RampUpRules *[]RampUpRule `json:"rampUpRules,omitempty"`
}

// FileSystemApplicationLogsConfig is application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	Level LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig is http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	RetentionInMb   *int32 `json:"retentionInMb,omitempty"`
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	Enabled         *bool  `json:"enabled,omitempty"`
}

// FunctionEnvelope is web Job Information.
type FunctionEnvelope struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*FunctionEnvelopeProperties `json:"properties,omitempty"`
}

// FunctionEnvelopeCollection is collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	autorest.Response `json:"-"`
	Value             *[]FunctionEnvelope `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// FunctionEnvelopeCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FunctionEnvelopeCollection) FunctionEnvelopeCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FunctionEnvelopeProperties is functionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	Name               *string                 `json:"name,omitempty"`
	FunctionAppID      *string                 `json:"functionAppId,omitempty"`
	ScriptRootPathHref *string                 `json:"scriptRootPathHref,omitempty"`
	ScriptHref         *string                 `json:"scriptHref,omitempty"`
	ConfigHref         *string                 `json:"configHref,omitempty"`
	SecretsFileHref    *string                 `json:"secretsFileHref,omitempty"`
	Href               *string                 `json:"href,omitempty"`
	Config             *map[string]interface{} `json:"config,omitempty"`
	Files              *map[string]*string     `json:"files,omitempty"`
	TestData           *string                 `json:"testData,omitempty"`
}

// FunctionSecrets is function secrets.
type FunctionSecrets struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*FunctionSecretsProperties `json:"properties,omitempty"`
}

// FunctionSecretsProperties is functionSecrets resource specific properties
type FunctionSecretsProperties struct {
	Key        *string `json:"key,omitempty"`
	TriggerURL *string `json:"triggerUrl,omitempty"`
}

// GeoRegion is geographical region.
type GeoRegion struct {
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Kind                 *string `json:"kind,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*GeoRegionProperties `json:"properties,omitempty"`
}

// GeoRegionCollection is collection of geographical regions.
type GeoRegionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]GeoRegion `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// GeoRegionCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client GeoRegionCollection) GeoRegionCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// GeoRegionProperties is geoRegion resource specific properties
type GeoRegionProperties struct {
	Name        *string `json:"name,omitempty"`
	Description *string `json:"description,omitempty"`
	DisplayName *string `json:"displayName,omitempty"`
}

// GlobalCsmSkuDescription is a Global SKU Description.
type GlobalCsmSkuDescription struct {
	Name         *string       `json:"name,omitempty"`
	Tier         *string       `json:"tier,omitempty"`
	Capacity     *SkuCapacity  `json:"capacity,omitempty"`
	Locations    *[]string     `json:"locations,omitempty"`
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// HandlerMapping is the IIS handler mappings used to define which handler processes HTTP requests with certain
// extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
type HandlerMapping struct {
	Extension       *string `json:"extension,omitempty"`
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
	Arguments       *string `json:"arguments,omitempty"`
}

// HostingEnvironmentDiagnostics is diagnostics for an App Service Environment.
type HostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Name              *string `json:"name,omitempty"`
	DiagnosicsOutput  *string `json:"diagnosicsOutput,omitempty"`
}

// HostingEnvironmentProfile is specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// HostName is details of a hostname derived from a domain.
type HostName struct {
	Name                        *string                     `json:"name,omitempty"`
	SiteNames                   *[]string                   `json:"siteNames,omitempty"`
	AzureResourceName           *string                     `json:"azureResourceName,omitempty"`
	AzureResourceType           AzureResourceType           `json:"azureResourceType,omitempty"`
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	HostNameType                HostNameType                `json:"hostNameType,omitempty"`
}

// HostNameBinding is a hostname binding object.
type HostNameBinding struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*HostNameBindingProperties `json:"properties,omitempty"`
}

// HostNameBindingCollection is collection of hostname bindings.
type HostNameBindingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]HostNameBinding `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// HostNameBindingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client HostNameBindingCollection) HostNameBindingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// HostNameBindingProperties is hostNameBinding resource specific properties
type HostNameBindingProperties struct {
	Name                        *string                     `json:"name,omitempty"`
	SiteName                    *string                     `json:"siteName,omitempty"`
	DomainID                    *string                     `json:"domainId,omitempty"`
	AzureResourceName           *string                     `json:"azureResourceName,omitempty"`
	AzureResourceType           AzureResourceType           `json:"azureResourceType,omitempty"`
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	HostNameType                HostNameType                `json:"hostNameType,omitempty"`
	SslState                    SslState                    `json:"sslState,omitempty"`
	Thumbprint                  *string                     `json:"thumbprint,omitempty"`
	VirtualIP                   *string                     `json:"virtualIP,omitempty"`
}

// HostNameSslState is SSL-enabled hostname.
type HostNameSslState struct {
	Name       *string  `json:"name,omitempty"`
	SslState   SslState `json:"sslState,omitempty"`
	VirtualIP  *string  `json:"virtualIP,omitempty"`
	Thumbprint *string  `json:"thumbprint,omitempty"`
	ToUpdate   *bool    `json:"toUpdate,omitempty"`
	HostType   HostType `json:"hostType,omitempty"`
}

// HTTPLogsConfig is http logs configuration.
type HTTPLogsConfig struct {
	FileSystem       *FileSystemHTTPLogsConfig       `json:"fileSystem,omitempty"`
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`
}

// HybridConnection is hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*HybridConnectionProperties `json:"properties,omitempty"`
}

// HybridConnectionCollection is collection of hostname bindings.
type HybridConnectionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]HybridConnection `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// HybridConnectionCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client HybridConnectionCollection) HybridConnectionCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// HybridConnectionKey is hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
type HybridConnectionKey struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Kind                           *string `json:"kind,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*HybridConnectionKeyProperties `json:"properties,omitempty"`
}

// HybridConnectionKeyProperties is hybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	SendKeyName  *string `json:"sendKeyName,omitempty"`
	SendKeyValue *string `json:"sendKeyValue,omitempty"`
}

// HybridConnectionLimits is hybrid Connection limits contract. This is used to return the plan limits of Hybrid
// Connections.
type HybridConnectionLimits struct {
	autorest.Response                 `json:"-"`
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Kind                              *string `json:"kind,omitempty"`
	Type                              *string `json:"type,omitempty"`
	*HybridConnectionLimitsProperties `json:"properties,omitempty"`
}

// HybridConnectionLimitsProperties is hybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	Current *int32 `json:"current,omitempty"`
	Maximum *int32 `json:"maximum,omitempty"`
}

// HybridConnectionProperties is hybridConnection resource specific properties
type HybridConnectionProperties struct {
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	RelayName           *string `json:"relayName,omitempty"`
	RelayArmURI         *string `json:"relayArmUri,omitempty"`
	Hostname            *string `json:"hostname,omitempty"`
	Port                *int32  `json:"port,omitempty"`
	SendKeyName         *string `json:"sendKeyName,omitempty"`
	SendKeyValue        *string `json:"sendKeyValue,omitempty"`
	ServiceBusSuffix    *string `json:"serviceBusSuffix,omitempty"`
}

// Identifier is identifier.
type Identifier struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	Kind                  *string `json:"kind,omitempty"`
	Type                  *string `json:"type,omitempty"`
	*IdentifierProperties `json:"properties,omitempty"`
}

// IdentifierCollection is collection of identifiers.
type IdentifierCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Identifier `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// IdentifierCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client IdentifierCollection) IdentifierCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// IdentifierProperties is identifier resource specific properties
type IdentifierProperties struct {
	ID *string `json:"id,omitempty"`
}

// IPSecurityRestriction is IP security restriction on an app.
type IPSecurityRestriction struct {
	IPAddress  *string `json:"ipAddress,omitempty"`
	SubnetMask *string `json:"subnetMask,omitempty"`
}

// Job is web Job Information.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Kind              *string `json:"kind,omitempty"`
	Type              *string `json:"type,omitempty"`
	*JobProperties    `json:"properties,omitempty"`
}

// JobCollection is collection of Kudu web job information elements.
type JobCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Job  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// JobCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobCollection) JobCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobProperties is webJob resource specific properties
type JobProperties struct {
	Name         *string                 `json:"name,omitempty"`
	RunCommand   *string                 `json:"runCommand,omitempty"`
	URL          *string                 `json:"url,omitempty"`
	ExtraInfoURL *string                 `json:"extraInfoUrl,omitempty"`
	JobType      JobType                 `json:"jobType,omitempty"`
	Error        *string                 `json:"error,omitempty"`
	UsingSdk     *bool                   `json:"usingSdk,omitempty"`
	Settings     *map[string]interface{} `json:"settings,omitempty"`
}

// ListCapability is
type ListCapability struct {
	autorest.Response `json:"-"`
	Value             *[]Capability `json:"value,omitempty"`
}

// ListCertificateEmail is
type ListCertificateEmail struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateEmail `json:"value,omitempty"`
}

// ListCertificateOrderAction is
type ListCertificateOrderAction struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateOrderAction `json:"value,omitempty"`
}

// ListHostingEnvironmentDiagnostics is
type ListHostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironmentDiagnostics `json:"value,omitempty"`
}

// ListOperation is
type ListOperation struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// ListRecommendation is
type ListRecommendation struct {
	autorest.Response `json:"-"`
	Value             *[]Recommendation `json:"value,omitempty"`
}

// ListSiteConfigurationSnapshotInfo is
type ListSiteConfigurationSnapshotInfo struct {
	autorest.Response `json:"-"`
	Value             *[]SiteConfigurationSnapshotInfo `json:"value,omitempty"`
}

// ListVnetInfo is
type ListVnetInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VnetInfo `json:"value,omitempty"`
}

// ListVnetRoute is
type ListVnetRoute struct {
	autorest.Response `json:"-"`
	Value             *[]VnetRoute `json:"value,omitempty"`
}

// LocalizableString is localizable string object containing the name and a localized value.
type LocalizableString struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricAvailabilily is metric availability and retention.
type MetricAvailabilily struct {
	TimeGrain *string `json:"timeGrain,omitempty"`
	Retention *string `json:"retention,omitempty"`
}

// MetricAvailability is
type MetricAvailability struct {
	TimeGrain    *string `json:"timeGrain,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricDefinition is metadata for a metric.
type MetricDefinition struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*MetricDefinitionProperties `json:"properties,omitempty"`
}

// MetricDefinitionProperties is metricDefinition resource specific properties
type MetricDefinitionProperties struct {
	Name                   *string               `json:"name,omitempty"`
	Unit                   *string               `json:"unit,omitempty"`
	PrimaryAggregationType *string               `json:"primaryAggregationType,omitempty"`
	MetricAvailabilities   *[]MetricAvailabilily `json:"metricAvailabilities,omitempty"`
	DisplayName            *string               `json:"displayName,omitempty"`
}

// MetricSpecification is
type MetricSpecification struct {
	Name                             *string               `json:"name,omitempty"`
	DisplayName                      *string               `json:"displayName,omitempty"`
	DisplayDescription               *string               `json:"displayDescription,omitempty"`
	Unit                             *string               `json:"unit,omitempty"`
	AggregationType                  *string               `json:"aggregationType,omitempty"`
	SupportsInstanceLevelAggregation *bool                 `json:"supportsInstanceLevelAggregation,omitempty"`
	EnableRegionalMdmAccount         *bool                 `json:"enableRegionalMdmAccount,omitempty"`
	SourceMdmAccount                 *string               `json:"sourceMdmAccount,omitempty"`
	SourceMdmNamespace               *string               `json:"sourceMdmNamespace,omitempty"`
	MetricFilterPattern              *string               `json:"metricFilterPattern,omitempty"`
	FillGapWithZero                  *bool                 `json:"fillGapWithZero,omitempty"`
	IsInternal                       *bool                 `json:"isInternal,omitempty"`
	Dimensions                       *[]Dimension          `json:"dimensions,omitempty"`
	Category                         *string               `json:"category,omitempty"`
	Availabilities                   *[]MetricAvailability `json:"availabilities,omitempty"`
}

// MigrateMySQLRequest is mySQL migration request.
type MigrateMySQLRequest struct {
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Kind                           *string `json:"kind,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*MigrateMySQLRequestProperties `json:"properties,omitempty"`
}

// MigrateMySQLRequestProperties is migrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	ConnectionString *string            `json:"connectionString,omitempty"`
	MigrationType    MySQLMigrationType `json:"migrationType,omitempty"`
}

// MigrateMySQLStatus is mySQL migration status.
type MigrateMySQLStatus struct {
	autorest.Response             `json:"-"`
	ID                            *string `json:"id,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Kind                          *string `json:"kind,omitempty"`
	Type                          *string `json:"type,omitempty"`
	*MigrateMySQLStatusProperties `json:"properties,omitempty"`
}

// MigrateMySQLStatusProperties is migrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	MigrationOperationStatus OperationStatus `json:"migrationOperationStatus,omitempty"`
	OperationID              *string         `json:"operationId,omitempty"`
	LocalMySQLEnabled        *bool           `json:"localMySqlEnabled,omitempty"`
}

// MSDeploy is mSDeploy ARM PUT information
type MSDeploy struct {
	ID            *string `json:"id,omitempty"`
	Name          *string `json:"name,omitempty"`
	Kind          *string `json:"kind,omitempty"`
	Type          *string `json:"type,omitempty"`
	*MSDeployCore `json:"properties,omitempty"`
}

// MSDeployCore is mSDeploy ARM PUT core information
type MSDeployCore struct {
	PackageURI              *string             `json:"packageUri,omitempty"`
	ConnectionString        *string             `json:"connectionString,omitempty"`
	DbType                  *string             `json:"dbType,omitempty"`
	SetParametersXMLFileURI *string             `json:"setParametersXmlFileUri,omitempty"`
	SetParameters           *map[string]*string `json:"setParameters,omitempty"`
	SkipAppData             *bool               `json:"skipAppData,omitempty"`
	AppOffline              *bool               `json:"appOffline,omitempty"`
}

// MSDeployLog is mSDeploy log
type MSDeployLog struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Kind                   *string `json:"kind,omitempty"`
	Type                   *string `json:"type,omitempty"`
	*MSDeployLogProperties `json:"properties,omitempty"`
}

// MSDeployLogEntry is mSDeploy log entry
type MSDeployLogEntry struct {
	Time    *date.Time           `json:"time,omitempty"`
	Type    MSDeployLogEntryType `json:"type,omitempty"`
	Message *string              `json:"message,omitempty"`
}

// MSDeployLogProperties is mSDeployLog resource specific properties
type MSDeployLogProperties struct {
	Entries *[]MSDeployLogEntry `json:"entries,omitempty"`
}

// MSDeployStatus is mSDeploy ARM response
type MSDeployStatus struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*MSDeployStatusProperties `json:"properties,omitempty"`
}

// MSDeployStatusProperties is mSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	Deployer          *string                   `json:"deployer,omitempty"`
	ProvisioningState MSDeployProvisioningState `json:"provisioningState,omitempty"`
	StartTime         *date.Time                `json:"startTime,omitempty"`
	EndTime           *date.Time                `json:"endTime,omitempty"`
	Complete          *bool                     `json:"complete,omitempty"`
}

// NameIdentifier is identifies an object.
type NameIdentifier struct {
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection is collection of domain name identifiers.
type NameIdentifierCollection struct {
	autorest.Response `json:"-"`
	Value             *[]NameIdentifier `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// NameIdentifierCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NameIdentifierCollection) NameIdentifierCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NameValuePair is name value pair.
type NameValuePair struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry is network access control entry.
type NetworkAccessControlEntry struct {
	Action       AccessControlEntryAction `json:"action,omitempty"`
	Description  *string                  `json:"description,omitempty"`
	Order        *int32                   `json:"order,omitempty"`
	RemoteSubnet *string                  `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures is full view of network features for an app (presently VNET integration and Hybrid Connections).
type NetworkFeatures struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*NetworkFeaturesProperties `json:"properties,omitempty"`
}

// NetworkFeaturesProperties is networkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	VirtualNetworkName       *string                         `json:"virtualNetworkName,omitempty"`
	VirtualNetworkConnection *VnetInfo                       `json:"virtualNetworkConnection,omitempty"`
	HybridConnections        *[]RelayServiceConnectionEntity `json:"hybridConnections,omitempty"`
	HybridConnectionsV2      *[]HybridConnection             `json:"hybridConnectionsV2,omitempty"`
}

// Operation is operation.
type Operation struct {
	autorest.Response    `json:"-"`
	ID                   *string         `json:"id,omitempty"`
	Name                 *string         `json:"name,omitempty"`
	Status               OperationStatus `json:"status,omitempty"`
	Errors               *[]ErrorEntity  `json:"errors,omitempty"`
	CreatedTime          *date.Time      `json:"createdTime,omitempty"`
	ModifiedTime         *date.Time      `json:"modifiedTime,omitempty"`
	ExpirationTime       *date.Time      `json:"expirationTime,omitempty"`
	GeoMasterOperationID *string         `json:"geoMasterOperationId,omitempty"`
}

// PerfMonCounterCollection is collection of performance monitor counters.
type PerfMonCounterCollection struct {
	autorest.Response `json:"-"`
	Value             *[]PerfMonResponse `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// PerfMonCounterCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PerfMonCounterCollection) PerfMonCounterCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PerfMonResponse is performance monitor API response.
type PerfMonResponse struct {
	Code    *string     `json:"code,omitempty"`
	Message *string     `json:"message,omitempty"`
	Data    *PerfMonSet `json:"data,omitempty"`
}

// PerfMonSample is performance monitor sample in a set.
type PerfMonSample struct {
	Time         *date.Time `json:"time,omitempty"`
	InstanceName *string    `json:"instanceName,omitempty"`
	Value        *float64   `json:"value,omitempty"`
	CoreCount    *int32     `json:"coreCount,omitempty"`
}

// PerfMonSet is metric information.
type PerfMonSet struct {
	Name      *string          `json:"name,omitempty"`
	StartTime *date.Time       `json:"startTime,omitempty"`
	EndTime   *date.Time       `json:"endTime,omitempty"`
	TimeGrain *string          `json:"timeGrain,omitempty"`
	Values    *[]PerfMonSample `json:"values,omitempty"`
}

// PremierAddOn is premier add-on.
type PremierAddOn struct {
	autorest.Response       `json:"-"`
	ID                      *string             `json:"id,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Kind                    *string             `json:"kind,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*PremierAddOnProperties `json:"properties,omitempty"`
}

// PremierAddOnOffer is premier add-on offer.
type PremierAddOnOffer struct {
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*PremierAddOnOfferProperties `json:"properties,omitempty"`
}

// PremierAddOnOfferCollection is collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	autorest.Response `json:"-"`
	Value             *[]PremierAddOnOffer `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// PremierAddOnOfferCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PremierAddOnOfferCollection) PremierAddOnOfferCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PremierAddOnOfferProperties is premierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	Sku                        *string                    `json:"sku,omitempty"`
	Product                    *string                    `json:"product,omitempty"`
	Vendor                     *string                    `json:"vendor,omitempty"`
	Name                       *string                    `json:"name,omitempty"`
	PromoCodeRequired          *bool                      `json:"promoCodeRequired,omitempty"`
	Quota                      *int32                     `json:"quota,omitempty"`
	WebHostingPlanRestrictions AppServicePlanRestrictions `json:"webHostingPlanRestrictions,omitempty"`
	PrivacyPolicyURL           *string                    `json:"privacyPolicyUrl,omitempty"`
	LegalTermsURL              *string                    `json:"legalTermsUrl,omitempty"`
	MarketplacePublisher       *string                    `json:"marketplacePublisher,omitempty"`
	MarketplaceOffer           *string                    `json:"marketplaceOffer,omitempty"`
}

// PremierAddOnProperties is premierAddOn resource specific properties
type PremierAddOnProperties struct {
	Sku                  *string             `json:"sku,omitempty"`
	Product              *string             `json:"product,omitempty"`
	Vendor               *string             `json:"vendor,omitempty"`
	PremierAddOnName     *string             `json:"name,omitempty"`
	Location             *string             `json:"location,omitempty"`
	Tags                 *map[string]*string `json:"tags,omitempty"`
	MarketplacePublisher *string             `json:"marketplacePublisher,omitempty"`
	MarketplaceOffer     *string             `json:"marketplaceOffer,omitempty"`
}

// ProcessInfo is process Information.
type ProcessInfo struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Kind                   *string `json:"kind,omitempty"`
	Type                   *string `json:"type,omitempty"`
	*ProcessInfoProperties `json:"properties,omitempty"`
}

// ProcessInfoCollection is collection of Kudu process information elements.
type ProcessInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProcessInfo `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// ProcessInfoCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProcessInfoCollection) ProcessInfoCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProcessInfoProperties is processInfo resource specific properties
type ProcessInfoProperties struct {
	ID                         *int32               `json:"id,omitempty"`
	Name                       *string              `json:"name,omitempty"`
	Href                       *string              `json:"href,omitempty"`
	MiniDump                   *string              `json:"miniDump,omitempty"`
	IsProfileRunning           *bool                `json:"isProfileRunning,omitempty"`
	IsIisProfileRunning        *bool                `json:"isIisProfileRunning,omitempty"`
	IisProfileTimeoutInSeconds *float64             `json:"iisProfileTimeoutInSeconds,omitempty"`
	Parent                     *string              `json:"parent,omitempty"`
	Children                   *[]string            `json:"children,omitempty"`
	Threads                    *[]ProcessThreadInfo `json:"threads,omitempty"`
	OpenFileHandles            *[]string            `json:"openFileHandles,omitempty"`
	Modules                    *[]ProcessModuleInfo `json:"modules,omitempty"`
	FileName                   *string              `json:"fileName,omitempty"`
	CommandLine                *string              `json:"commandLine,omitempty"`
	UserName                   *string              `json:"userName,omitempty"`
	HandleCount                *int32               `json:"handleCount,omitempty"`
	ModuleCount                *int32               `json:"moduleCount,omitempty"`
	ThreadCount                *int32               `json:"threadCount,omitempty"`
	StartTime                  *date.Time           `json:"startTime,omitempty"`
	TotalProcessorTime         *string              `json:"totalProcessorTime,omitempty"`
	UserProcessorTime          *string              `json:"userProcessorTime,omitempty"`
	PrivilegedProcessorTime    *string              `json:"privilegedProcessorTime,omitempty"`
	WorkingSet64               *int64               `json:"workingSet64,omitempty"`
	PeakWorkingSet64           *int64               `json:"peakWorkingSet64,omitempty"`
	PrivateMemorySize64        *int64               `json:"privateMemorySize64,omitempty"`
	VirtualMemorySize64        *int64               `json:"virtualMemorySize64,omitempty"`
	PeakVirtualMemorySize64    *int64               `json:"peakVirtualMemorySize64,omitempty"`
	PagedSystemMemorySize64    *int64               `json:"pagedSystemMemorySize64,omitempty"`
	NonpagedSystemMemorySize64 *int64               `json:"nonpagedSystemMemorySize64,omitempty"`
	PagedMemorySize64          *int64               `json:"pagedMemorySize64,omitempty"`
	PeakPagedMemorySize64      *int64               `json:"peakPagedMemorySize64,omitempty"`
	TimeStamp                  *date.Time           `json:"timeStamp,omitempty"`
	EnvironmentVariables       *map[string]*string  `json:"environmentVariables,omitempty"`
	IsScmSite                  *bool                `json:"isScmSite,omitempty"`
	IsWebJob                   *bool                `json:"isWebJob,omitempty"`
	Description                *string              `json:"description,omitempty"`
}

// ProcessModuleInfo is process Module Information.
type ProcessModuleInfo struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*ProcessModuleInfoProperties `json:"properties,omitempty"`
}

// ProcessModuleInfoCollection is collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProcessModuleInfo `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// ProcessModuleInfoCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProcessModuleInfoCollection) ProcessModuleInfoCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProcessModuleInfoProperties is processModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	BaseAddress      *string `json:"baseAddress,omitempty"`
	FileName         *string `json:"fileName,omitempty"`
	Href             *string `json:"href,omitempty"`
	FilePath         *string `json:"filePath,omitempty"`
	ModuleMemorySize *int32  `json:"moduleMemorySize,omitempty"`
	FileVersion      *string `json:"fileVersion,omitempty"`
	FileDescription  *string `json:"fileDescription,omitempty"`
	Product          *string `json:"product,omitempty"`
	ProductVersion   *string `json:"productVersion,omitempty"`
	IsDebug          *bool   `json:"isDebug,omitempty"`
	Language         *string `json:"language,omitempty"`
}

// ProcessThreadInfo is process Thread Information.
type ProcessThreadInfo struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*ProcessThreadInfoProperties `json:"properties,omitempty"`
}

// ProcessThreadInfoCollection is collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProcessThreadInfo `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// ProcessThreadInfoCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProcessThreadInfoCollection) ProcessThreadInfoCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProcessThreadInfoProperties is processThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	ID                       *int32     `json:"id,omitempty"`
	Href                     *string    `json:"href,omitempty"`
	Process                  *string    `json:"process,omitempty"`
	StartAddress             *string    `json:"startAddress,omitempty"`
	CurrentPriority          *int32     `json:"currentPriority,omitempty"`
	PriorityLevel            *string    `json:"priorityLevel,omitempty"`
	BasePriority             *int32     `json:"basePriority,omitempty"`
	StartTime                *date.Time `json:"startTime,omitempty"`
	TotalProcessorTime       *string    `json:"totalProcessorTime,omitempty"`
	UserProcessorTime        *string    `json:"userProcessorTime,omitempty"`
	PriviledgedProcessorTime *string    `json:"priviledgedProcessorTime,omitempty"`
	State                    *string    `json:"state,omitempty"`
	WaitReason               *string    `json:"waitReason,omitempty"`
}

// ProxyOnlyResource is azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Kind *string `json:"kind,omitempty"`
	Type *string `json:"type,omitempty"`
}

// PublicCertificate is public certificate object
type PublicCertificate struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*PublicCertificateProperties `json:"properties,omitempty"`
}

// PublicCertificateCollection is collection of public certificates
type PublicCertificateCollection struct {
	autorest.Response `json:"-"`
	Value             *[]PublicCertificate `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// PublicCertificateCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PublicCertificateCollection) PublicCertificateCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PublicCertificateProperties is publicCertificate resource specific properties
type PublicCertificateProperties struct {
	Blob                      *string                   `json:"blob,omitempty"`
	PublicCertificateLocation PublicCertificateLocation `json:"publicCertificateLocation,omitempty"`
	Thumbprint                *string                   `json:"thumbprint,omitempty"`
}

// PushSettings is push settings for the App.
type PushSettings struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Kind                    *string `json:"kind,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*PushSettingsProperties `json:"properties,omitempty"`
}

// PushSettingsProperties is pushSettings resource specific properties
type PushSettingsProperties struct {
	IsPushEnabled     *bool   `json:"isPushEnabled,omitempty"`
	TagWhitelistJSON  *string `json:"tagWhitelistJson,omitempty"`
	TagsRequiringAuth *string `json:"tagsRequiringAuth,omitempty"`
	DynamicTagsJSON   *string `json:"dynamicTagsJson,omitempty"`
}

// RampUpRule is routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to
// gradually change routing % based on performance.
type RampUpRule struct {
	ActionHostName            *string  `json:"actionHostName,omitempty"`
	ReroutePercentage         *float64 `json:"reroutePercentage,omitempty"`
	ChangeStep                *float64 `json:"changeStep,omitempty"`
	ChangeIntervalInMinutes   *int32   `json:"changeIntervalInMinutes,omitempty"`
	MinReroutePercentage      *float64 `json:"minReroutePercentage,omitempty"`
	MaxReroutePercentage      *float64 `json:"maxReroutePercentage,omitempty"`
	ChangeDecisionCallbackURL *string  `json:"changeDecisionCallbackUrl,omitempty"`
	Name                      *string  `json:"name,omitempty"`
}

// ReadCloser is
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Recommendation is represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	CreationTime               *date.Time        `json:"creationTime,omitempty"`
	RecommendationID           *string           `json:"recommendationId,omitempty"`
	ResourceID                 *string           `json:"resourceId,omitempty"`
	ResourceScope              ResourceScopeType `json:"resourceScope,omitempty"`
	RuleName                   *string           `json:"ruleName,omitempty"`
	DisplayName                *string           `json:"displayName,omitempty"`
	Message                    *string           `json:"message,omitempty"`
	Level                      NotificationLevel `json:"level,omitempty"`
	Channels                   Channels          `json:"channels,omitempty"`
	Tags                       *[]string         `json:"tags,omitempty"`
	ActionName                 *string           `json:"actionName,omitempty"`
	StartTime                  *date.Time        `json:"startTime,omitempty"`
	EndTime                    *date.Time        `json:"endTime,omitempty"`
	NextNotificationTime       *date.Time        `json:"nextNotificationTime,omitempty"`
	NotificationExpirationTime *date.Time        `json:"notificationExpirationTime,omitempty"`
	NotifiedTime               *date.Time        `json:"notifiedTime,omitempty"`
	Score                      *float64          `json:"score,omitempty"`
	IsDynamic                  *bool             `json:"isDynamic,omitempty"`
	ExtensionName              *string           `json:"extensionName,omitempty"`
	BladeName                  *string           `json:"bladeName,omitempty"`
	ForwardLink                *string           `json:"forwardLink,omitempty"`
}

// RecommendationRule is represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	autorest.Response `json:"-"`
	Name              *string           `json:"name,omitempty"`
	DisplayName       *string           `json:"displayName,omitempty"`
	Message           *string           `json:"message,omitempty"`
	RecommendationID  *uuid.UUID        `json:"recommendationId,omitempty"`
	Description       *string           `json:"description,omitempty"`
	ActionName        *string           `json:"actionName,omitempty"`
	Level             NotificationLevel `json:"level,omitempty"`
	Channels          Channels          `json:"channels,omitempty"`
	Tags              *[]string         `json:"tags,omitempty"`
	IsDynamic         *bool             `json:"isDynamic,omitempty"`
	ExtensionName     *string           `json:"extensionName,omitempty"`
	BladeName         *string           `json:"bladeName,omitempty"`
	ForwardLink       *string           `json:"forwardLink,omitempty"`
}

// ReissueCertificateOrderRequest is class representing certificate reissue request.
type ReissueCertificateOrderRequest struct {
	ID                                        *string             `json:"id,omitempty"`
	Name                                      *string             `json:"name,omitempty"`
	Kind                                      *string             `json:"kind,omitempty"`
	Location                                  *string             `json:"location,omitempty"`
	Type                                      *string             `json:"type,omitempty"`
	Tags                                      *map[string]*string `json:"tags,omitempty"`
	*ReissueCertificateOrderRequestProperties `json:"properties,omitempty"`
}

// ReissueCertificateOrderRequestProperties is reissueCertificateOrderRequest resource specific properties
type ReissueCertificateOrderRequestProperties struct {
	KeySize                    *int32  `json:"keySize,omitempty"`
	DelayExistingRevokeInHours *int32  `json:"delayExistingRevokeInHours,omitempty"`
	Csr                        *string `json:"csr,omitempty"`
	IsPrivateKeyExternal       *bool   `json:"isPrivateKeyExternal,omitempty"`
}

// RelayServiceConnectionEntity is hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	autorest.Response                       `json:"-"`
	ID                                      *string `json:"id,omitempty"`
	Name                                    *string `json:"name,omitempty"`
	Kind                                    *string `json:"kind,omitempty"`
	Type                                    *string `json:"type,omitempty"`
	*RelayServiceConnectionEntityProperties `json:"properties,omitempty"`
}

// RelayServiceConnectionEntityProperties is relayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	EntityName               *string `json:"entityName,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
}

// RenewCertificateOrderRequest is class representing certificate renew request.
type RenewCertificateOrderRequest struct {
	ID                                      *string             `json:"id,omitempty"`
	Name                                    *string             `json:"name,omitempty"`
	Kind                                    *string             `json:"kind,omitempty"`
	Location                                *string             `json:"location,omitempty"`
	Type                                    *string             `json:"type,omitempty"`
	Tags                                    *map[string]*string `json:"tags,omitempty"`
	*RenewCertificateOrderRequestProperties `json:"properties,omitempty"`
}

// RenewCertificateOrderRequestProperties is renewCertificateOrderRequest resource specific properties
type RenewCertificateOrderRequestProperties struct {
	KeySize              *int32  `json:"keySize,omitempty"`
	Csr                  *string `json:"csr,omitempty"`
	IsPrivateKeyExternal *bool   `json:"isPrivateKeyExternal,omitempty"`
}

// RequestsBasedTrigger is trigger based on total requests.
type RequestsBasedTrigger struct {
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource is azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Kind     *string             `json:"kind,omitempty"`
	Location *string             `json:"location,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceCollection is collection of resources.
type ResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]string `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ResourceCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResourceCollection) ResourceCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResourceMetric is object representing a metric for any resource .
type ResourceMetric struct {
	Name         *ResourceMetricName       `json:"name,omitempty"`
	Unit         *string                   `json:"unit,omitempty"`
	TimeGrain    *string                   `json:"timeGrain,omitempty"`
	StartTime    *date.Time                `json:"startTime,omitempty"`
	EndTime      *date.Time                `json:"endTime,omitempty"`
	ResourceID   *string                   `json:"resourceId,omitempty"`
	ID           *string                   `json:"id,omitempty"`
	MetricValues *[]ResourceMetricValue    `json:"metricValues,omitempty"`
	Properties   *[]ResourceMetricProperty `json:"properties,omitempty"`
}

// ResourceMetricAvailability is metrics availability and retention.
type ResourceMetricAvailability struct {
	TimeGrain *string `json:"timeGrain,omitempty"`
	Retention *string `json:"retention,omitempty"`
}

// ResourceMetricCollection is collection of metric responses.
type ResourceMetricCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceMetric `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ResourceMetricCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResourceMetricCollection) ResourceMetricCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResourceMetricDefinition is metadata for the metrics.
type ResourceMetricDefinition struct {
	ID                                  *string `json:"id,omitempty"`
	Name                                *string `json:"name,omitempty"`
	Kind                                *string `json:"kind,omitempty"`
	Type                                *string `json:"type,omitempty"`
	*ResourceMetricDefinitionProperties `json:"properties,omitempty"`
}

// ResourceMetricDefinitionCollection is collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceMetricDefinition `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// ResourceMetricDefinitionCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ResourceMetricDefinitionCollection) ResourceMetricDefinitionCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ResourceMetricDefinitionProperties is resourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	Name                   *ResourceMetricName           `json:"name,omitempty"`
	Unit                   *string                       `json:"unit,omitempty"`
	PrimaryAggregationType *string                       `json:"primaryAggregationType,omitempty"`
	MetricAvailabilities   *[]ResourceMetricAvailability `json:"metricAvailabilities,omitempty"`
	ResourceURI            *string                       `json:"resourceUri,omitempty"`
	ID                     *string                       `json:"id,omitempty"`
	Properties             *map[string]*string           `json:"properties,omitempty"`
}

// ResourceMetricName is name of a metric for any resource .
type ResourceMetricName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ResourceMetricProperty is resource metric property.
type ResourceMetricProperty struct {
	Key   *string `json:"key,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ResourceMetricValue is value of resource metric.
type ResourceMetricValue struct {
	Timestamp  *string                   `json:"timestamp,omitempty"`
	Average    *float64                  `json:"average,omitempty"`
	Minimum    *float64                  `json:"minimum,omitempty"`
	Maximum    *float64                  `json:"maximum,omitempty"`
	Total      *float64                  `json:"total,omitempty"`
	Count      *float64                  `json:"count,omitempty"`
	Properties *[]ResourceMetricProperty `json:"properties,omitempty"`
}

// ResourceNameAvailability is information regarding availbility of a resource name.
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool                    `json:"nameAvailable,omitempty"`
	Reason            InAvailabilityReasonType `json:"reason,omitempty"`
	Message           *string                  `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest is resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	Name   *string                `json:"name,omitempty"`
	Type   CheckNameResourceTypes `json:"type,omitempty"`
	IsFqdn *bool                  `json:"isFqdn,omitempty"`
}

// RestoreRequest is description of a restore request.
type RestoreRequest struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*RestoreRequestProperties `json:"properties,omitempty"`
}

// RestoreRequestProperties is restoreRequest resource specific properties
type RestoreRequestProperties struct {
	StorageAccountURL          *string                    `json:"storageAccountUrl,omitempty"`
	BlobName                   *string                    `json:"blobName,omitempty"`
	Overwrite                  *bool                      `json:"overwrite,omitempty"`
	SiteName                   *string                    `json:"siteName,omitempty"`
	Databases                  *[]DatabaseBackupSetting   `json:"databases,omitempty"`
	IgnoreConflictingHostNames *bool                      `json:"ignoreConflictingHostNames,omitempty"`
	IgnoreDatabases            *bool                      `json:"ignoreDatabases,omitempty"`
	AppServicePlan             *string                    `json:"appServicePlan,omitempty"`
	OperationType              BackupRestoreOperationType `json:"operationType,omitempty"`
	AdjustConnectionStrings    *bool                      `json:"adjustConnectionStrings,omitempty"`
	HostingEnvironment         *string                    `json:"hostingEnvironment,omitempty"`
}

// RestoreResponse is response for an app restore request.
type RestoreResponse struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*RestoreResponseProperties `json:"properties,omitempty"`
}

// RestoreResponseProperties is restoreResponse resource specific properties
type RestoreResponseProperties struct {
	OperationID *string `json:"operationId,omitempty"`
}

// ServiceSpecification is
type ServiceSpecification struct {
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SetObject is
type SetObject struct {
	autorest.Response `json:"-"`
	Value             *map[string]interface{} `json:"value,omitempty"`
}

// Site is a web app, a mobile app backend, or an API app.
type Site struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*SiteProperties   `json:"properties,omitempty"`
}

// SiteAuthSettings is configuration settings for the Azure App Service Authentication / Authorization feature.
type SiteAuthSettings struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Kind                        *string `json:"kind,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*SiteAuthSettingsProperties `json:"properties,omitempty"`
}

// SiteAuthSettingsProperties is siteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	Enabled                      *bool                         `json:"enabled,omitempty"`
	RuntimeVersion               *string                       `json:"runtimeVersion,omitempty"`
	UnauthenticatedClientAction  UnauthenticatedClientAction   `json:"unauthenticatedClientAction,omitempty"`
	TokenStoreEnabled            *bool                         `json:"tokenStoreEnabled,omitempty"`
	AllowedExternalRedirectUrls  *[]string                     `json:"allowedExternalRedirectUrls,omitempty"`
	DefaultProvider              BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`
	TokenRefreshExtensionHours   *float64                      `json:"tokenRefreshExtensionHours,omitempty"`
	ClientID                     *string                       `json:"clientId,omitempty"`
	ClientSecret                 *string                       `json:"clientSecret,omitempty"`
	Issuer                       *string                       `json:"issuer,omitempty"`
	AllowedAudiences             *[]string                     `json:"allowedAudiences,omitempty"`
	AdditionalLoginParams        *[]string                     `json:"additionalLoginParams,omitempty"`
	GoogleClientID               *string                       `json:"googleClientId,omitempty"`
	GoogleClientSecret           *string                       `json:"googleClientSecret,omitempty"`
	GoogleOAuthScopes            *[]string                     `json:"googleOAuthScopes,omitempty"`
	FacebookAppID                *string                       `json:"facebookAppId,omitempty"`
	FacebookAppSecret            *string                       `json:"facebookAppSecret,omitempty"`
	FacebookOAuthScopes          *[]string                     `json:"facebookOAuthScopes,omitempty"`
	TwitterConsumerKey           *string                       `json:"twitterConsumerKey,omitempty"`
	TwitterConsumerSecret        *string                       `json:"twitterConsumerSecret,omitempty"`
	MicrosoftAccountClientID     *string                       `json:"microsoftAccountClientId,omitempty"`
	MicrosoftAccountClientSecret *string                       `json:"microsoftAccountClientSecret,omitempty"`
	MicrosoftAccountOAuthScopes  *[]string                     `json:"microsoftAccountOAuthScopes,omitempty"`
}

// SiteCloneability is represents whether or not an app is cloneable.
type SiteCloneability struct {
	autorest.Response       `json:"-"`
	Result                  CloneAbilityResult           `json:"result,omitempty"`
	BlockingFeatures        *[]SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`
	UnsupportedFeatures     *[]SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
	BlockingCharacteristics *[]SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`
}

// SiteCloneabilityCriterion is an app cloneability criterion.
type SiteCloneabilityCriterion struct {
	Name        *string `json:"name,omitempty"`
	Description *string `json:"description,omitempty"`
}

// SiteConfig is configuration of an App Service app.
type SiteConfig struct {
	NumberOfWorkers              *int32                   `json:"numberOfWorkers,omitempty"`
	DefaultDocuments             *[]string                `json:"defaultDocuments,omitempty"`
	NetFrameworkVersion          *string                  `json:"netFrameworkVersion,omitempty"`
	PhpVersion                   *string                  `json:"phpVersion,omitempty"`
	PythonVersion                *string                  `json:"pythonVersion,omitempty"`
	NodeVersion                  *string                  `json:"nodeVersion,omitempty"`
	LinuxFxVersion               *string                  `json:"linuxFxVersion,omitempty"`
	RequestTracingEnabled        *bool                    `json:"requestTracingEnabled,omitempty"`
	RequestTracingExpirationTime *date.Time               `json:"requestTracingExpirationTime,omitempty"`
	RemoteDebuggingEnabled       *bool                    `json:"remoteDebuggingEnabled,omitempty"`
	RemoteDebuggingVersion       *string                  `json:"remoteDebuggingVersion,omitempty"`
	HTTPLoggingEnabled           *bool                    `json:"httpLoggingEnabled,omitempty"`
	LogsDirectorySizeLimit       *int32                   `json:"logsDirectorySizeLimit,omitempty"`
	DetailedErrorLoggingEnabled  *bool                    `json:"detailedErrorLoggingEnabled,omitempty"`
	PublishingUsername           *string                  `json:"publishingUsername,omitempty"`
	AppSettings                  *[]NameValuePair         `json:"appSettings,omitempty"`
	ConnectionStrings            *[]ConnStringInfo        `json:"connectionStrings,omitempty"`
	MachineKey                   *SiteMachineKey          `json:"machineKey,omitempty"`
	HandlerMappings              *[]HandlerMapping        `json:"handlerMappings,omitempty"`
	DocumentRoot                 *string                  `json:"documentRoot,omitempty"`
	ScmType                      ScmType                  `json:"scmType,omitempty"`
	Use32BitWorkerProcess        *bool                    `json:"use32BitWorkerProcess,omitempty"`
	WebSocketsEnabled            *bool                    `json:"webSocketsEnabled,omitempty"`
	AlwaysOn                     *bool                    `json:"alwaysOn,omitempty"`
	JavaVersion                  *string                  `json:"javaVersion,omitempty"`
	JavaContainer                *string                  `json:"javaContainer,omitempty"`
	JavaContainerVersion         *string                  `json:"javaContainerVersion,omitempty"`
	AppCommandLine               *string                  `json:"appCommandLine,omitempty"`
	ManagedPipelineMode          ManagedPipelineMode      `json:"managedPipelineMode,omitempty"`
	VirtualApplications          *[]VirtualApplication    `json:"virtualApplications,omitempty"`
	LoadBalancing                SiteLoadBalancing        `json:"loadBalancing,omitempty"`
	Experiments                  *Experiments             `json:"experiments,omitempty"`
	Limits                       *SiteLimits              `json:"limits,omitempty"`
	AutoHealEnabled              *bool                    `json:"autoHealEnabled,omitempty"`
	AutoHealRules                *AutoHealRules           `json:"autoHealRules,omitempty"`
	TracingOptions               *string                  `json:"tracingOptions,omitempty"`
	VnetName                     *string                  `json:"vnetName,omitempty"`
	Cors                         *CorsSettings            `json:"cors,omitempty"`
	Push                         *PushSettings            `json:"push,omitempty"`
	APIDefinition                *APIDefinitionInfo       `json:"apiDefinition,omitempty"`
	AutoSwapSlotName             *string                  `json:"autoSwapSlotName,omitempty"`
	LocalMySQLEnabled            *bool                    `json:"localMySqlEnabled,omitempty"`
	IPSecurityRestrictions       *[]IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`
}

// SiteConfigResource is web app configuration ARM resource.
type SiteConfigResource struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Kind              *string `json:"kind,omitempty"`
	Type              *string `json:"type,omitempty"`
	*SiteConfig       `json:"properties,omitempty"`
}

// SiteConfigResourceCollection is collection of site configurations.
type SiteConfigResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SiteConfigResource `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// SiteConfigResourceCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SiteConfigResourceCollection) SiteConfigResourceCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SiteConfigurationSnapshotInfo is a snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	ID                                       *string `json:"id,omitempty"`
	Name                                     *string `json:"name,omitempty"`
	Kind                                     *string `json:"kind,omitempty"`
	Type                                     *string `json:"type,omitempty"`
	*SiteConfigurationSnapshotInfoProperties `json:"properties,omitempty"`
}

// SiteConfigurationSnapshotInfoProperties is siteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	Time *date.Time `json:"time,omitempty"`
	ID   *int32     `json:"id,omitempty"`
}

// SiteExtensionInfo is site Extension Information.
type SiteExtensionInfo struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*SiteExtensionInfoProperties `json:"properties,omitempty"`
}

// SiteExtensionInfoCollection is collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SiteExtensionInfo `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// SiteExtensionInfoCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SiteExtensionInfoCollection) SiteExtensionInfoCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SiteExtensionInfoProperties is siteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	ID                   *string           `json:"id,omitempty"`
	Title                *string           `json:"title,omitempty"`
	Type                 SiteExtensionType `json:"type,omitempty"`
	Summary              *string           `json:"summary,omitempty"`
	Description          *string           `json:"description,omitempty"`
	Version              *string           `json:"version,omitempty"`
	ExtensionURL         *string           `json:"extensionUrl,omitempty"`
	ProjectURL           *string           `json:"projectUrl,omitempty"`
	IconURL              *string           `json:"iconUrl,omitempty"`
	LicenseURL           *string           `json:"licenseUrl,omitempty"`
	FeedURL              *string           `json:"feedUrl,omitempty"`
	Authors              *[]string         `json:"authors,omitempty"`
	InstallationArgs     *string           `json:"installationArgs,omitempty"`
	PublishedDateTime    *date.Time        `json:"publishedDateTime,omitempty"`
	DownloadCount        *int32            `json:"downloadCount,omitempty"`
	LocalIsLatestVersion *bool             `json:"localIsLatestVersion,omitempty"`
	LocalPath            *string           `json:"localPath,omitempty"`
	InstalledDateTime    *date.Time        `json:"installedDateTime,omitempty"`
	ProvisioningState    *string           `json:"provisioningState,omitempty"`
	Comment              *string           `json:"comment,omitempty"`
}

// SiteInstance is instance of an app.
type SiteInstance struct {
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Kind                    *string `json:"kind,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*SiteInstanceProperties `json:"properties,omitempty"`
}

// SiteInstanceProperties is siteInstance resource specific properties
type SiteInstanceProperties struct {
	Name *string `json:"name,omitempty"`
}

// SiteLimits is metric limits set on an app.
type SiteLimits struct {
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
	MaxMemoryInMb    *int64   `json:"maxMemoryInMb,omitempty"`
	MaxDiskSizeInMb  *int64   `json:"maxDiskSizeInMb,omitempty"`
}

// SiteLogsConfig is configuration of App Service site logs.
type SiteLogsConfig struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*SiteLogsConfigProperties `json:"properties,omitempty"`
}

// SiteLogsConfigProperties is siteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	ApplicationLogs       *ApplicationLogsConfig `json:"applicationLogs,omitempty"`
	HTTPLogs              *HTTPLogsConfig        `json:"httpLogs,omitempty"`
	FailedRequestsTracing *EnabledConfig         `json:"failedRequestsTracing,omitempty"`
	DetailedErrorMessages *EnabledConfig         `json:"detailedErrorMessages,omitempty"`
}

// SiteMachineKey is machineKey of an app.
type SiteMachineKey struct {
	Validation    *string `json:"validation,omitempty"`
	ValidationKey *string `json:"validationKey,omitempty"`
	Decryption    *string `json:"decryption,omitempty"`
	DecryptionKey *string `json:"decryptionKey,omitempty"`
}

// SitePhpErrorLogFlag is used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Kind                           *string `json:"kind,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*SitePhpErrorLogFlagProperties `json:"properties,omitempty"`
}

// SitePhpErrorLogFlagProperties is sitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	LocalLogErrors           *string `json:"localLogErrors,omitempty"`
	MasterLogErrors          *string `json:"masterLogErrors,omitempty"`
	LocalLogErrorsMaxLength  *string `json:"localLogErrorsMaxLength,omitempty"`
	MasterLogErrorsMaxLength *string `json:"masterLogErrorsMaxLength,omitempty"`
}

// SiteProperties is site resource specific properties
type SiteProperties struct {
	State                     *string                    `json:"state,omitempty"`
	HostNames                 *[]string                  `json:"hostNames,omitempty"`
	RepositorySiteName        *string                    `json:"repositorySiteName,omitempty"`
	UsageState                UsageState                 `json:"usageState,omitempty"`
	Enabled                   *bool                      `json:"enabled,omitempty"`
	EnabledHostNames          *[]string                  `json:"enabledHostNames,omitempty"`
	AvailabilityState         SiteAvailabilityState      `json:"availabilityState,omitempty"`
	HostNameSslStates         *[]HostNameSslState        `json:"hostNameSslStates,omitempty"`
	ServerFarmID              *string                    `json:"serverFarmId,omitempty"`
	Reserved                  *bool                      `json:"reserved,omitempty"`
	LastModifiedTimeUtc       *date.Time                 `json:"lastModifiedTimeUtc,omitempty"`
	SiteConfig                *SiteConfig                `json:"siteConfig,omitempty"`
	TrafficManagerHostNames   *[]string                  `json:"trafficManagerHostNames,omitempty"`
	ScmSiteAlsoStopped        *bool                      `json:"scmSiteAlsoStopped,omitempty"`
	TargetSwapSlot            *string                    `json:"targetSwapSlot,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	ClientAffinityEnabled     *bool                      `json:"clientAffinityEnabled,omitempty"`
	ClientCertEnabled         *bool                      `json:"clientCertEnabled,omitempty"`
	HostNamesDisabled         *bool                      `json:"hostNamesDisabled,omitempty"`
	OutboundIPAddresses       *string                    `json:"outboundIpAddresses,omitempty"`
	ContainerSize             *int32                     `json:"containerSize,omitempty"`
	DailyMemoryTimeQuota      *int32                     `json:"dailyMemoryTimeQuota,omitempty"`
	SuspendedTill             *date.Time                 `json:"suspendedTill,omitempty"`
	MaxNumberOfWorkers        *int32                     `json:"maxNumberOfWorkers,omitempty"`
	CloningInfo               *CloningInfo               `json:"cloningInfo,omitempty"`
	SnapshotInfo              *SnapshotRecoveryRequest   `json:"snapshotInfo,omitempty"`
	ResourceGroup             *string                    `json:"resourceGroup,omitempty"`
	IsDefaultContainer        *bool                      `json:"isDefaultContainer,omitempty"`
	DefaultHostName           *string                    `json:"defaultHostName,omitempty"`
	SlotSwapStatus            *SlotSwapStatus            `json:"slotSwapStatus,omitempty"`
	PremiumAppDeployed        *bool                      `json:"premiumAppDeployed,omitempty"`
	MicroService              *string                    `json:"microService,omitempty"`
	GatewaySiteName           *string                    `json:"gatewaySiteName,omitempty"`
}

// SiteSeal is site seal
type SiteSeal struct {
	autorest.Response `json:"-"`
	*string           `json:"html,omitempty"`
}

// SiteSealRequest is site seal request.
type SiteSealRequest struct {
	LightTheme *bool   `json:"lightTheme,omitempty"`
	Locale     *string `json:"locale,omitempty"`
}

// SiteSourceControl is source control configuration for an app.
type SiteSourceControl struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*SiteSourceControlProperties `json:"properties,omitempty"`
}

// SiteSourceControlProperties is siteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	RepoURL                   *string `json:"repoUrl,omitempty"`
	Branch                    *string `json:"branch,omitempty"`
	IsManualIntegration       *bool   `json:"isManualIntegration,omitempty"`
	DeploymentRollbackEnabled *bool   `json:"deploymentRollbackEnabled,omitempty"`
	IsMercurial               *bool   `json:"isMercurial,omitempty"`
}

// SkuCapacity is description of the App Service plan scale options.
type SkuCapacity struct {
	Minimum   *int32  `json:"minimum,omitempty"`
	Maximum   *int32  `json:"maximum,omitempty"`
	Default   *int32  `json:"default,omitempty"`
	ScaleType *string `json:"scaleType,omitempty"`
}

// SkuDescription is description of a SKU for a scalable resource.
type SkuDescription struct {
	Name         *string       `json:"name,omitempty"`
	Tier         *string       `json:"tier,omitempty"`
	Size         *string       `json:"size,omitempty"`
	Family       *string       `json:"family,omitempty"`
	Capacity     *int32        `json:"capacity,omitempty"`
	SkuCapacity  *SkuCapacity  `json:"skuCapacity,omitempty"`
	Locations    *[]string     `json:"locations,omitempty"`
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// SkuInfo is SKU discovery information.
type SkuInfo struct {
	ResourceType *string         `json:"resourceType,omitempty"`
	Sku          *SkuDescription `json:"sku,omitempty"`
	Capacity     *SkuCapacity    `json:"capacity,omitempty"`
}

// SkuInfoCollection is collection of SKU information.
type SkuInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SkuInfo `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// SkuInfoCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SkuInfoCollection) SkuInfoCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SkuInfos is collection of SKU information.
type SkuInfos struct {
	autorest.Response `json:"-"`
	ResourceType      *string                    `json:"resourceType,omitempty"`
	Skus              *[]GlobalCsmSkuDescription `json:"skus,omitempty"`
}

// SlotConfigNames is names for connection strings and application settings to be marked as sticky to the deployment
// slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	AppSettingNames       *[]string `json:"appSettingNames,omitempty"`
}

// SlotConfigNamesResource is slot Config names azure resource.
type SlotConfigNamesResource struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Kind              *string `json:"kind,omitempty"`
	Type              *string `json:"type,omitempty"`
	*SlotConfigNames  `json:"properties,omitempty"`
}

// SlotDifference is a setting difference between two deployment slots of an app.
type SlotDifference struct {
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*SlotDifferenceProperties `json:"properties,omitempty"`
}

// SlotDifferenceCollection is collection of slot differences.
type SlotDifferenceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SlotDifference `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// SlotDifferenceCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SlotDifferenceCollection) SlotDifferenceCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SlotDifferenceProperties is slotDifference resource specific properties
type SlotDifferenceProperties struct {
	Type               *string `json:"type,omitempty"`
	SettingType        *string `json:"settingType,omitempty"`
	DiffRule           *string `json:"diffRule,omitempty"`
	SettingName        *string `json:"settingName,omitempty"`
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty"`
	ValueInTargetSlot  *string `json:"valueInTargetSlot,omitempty"`
	Description        *string `json:"description,omitempty"`
}

// SlotSwapStatus is the status of the last successfull slot swap operation.
type SlotSwapStatus struct {
	TimestampUtc        *date.Time `json:"timestampUtc,omitempty"`
	SourceSlotName      *string    `json:"sourceSlotName,omitempty"`
	DestinationSlotName *string    `json:"destinationSlotName,omitempty"`
}

// SlowRequestsBasedTrigger is trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	TimeTaken    *string `json:"timeTaken,omitempty"`
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Snapshot is a snapshot of an app.
type Snapshot struct {
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	Kind                *string `json:"kind,omitempty"`
	Type                *string `json:"type,omitempty"`
	*SnapshotProperties `json:"properties,omitempty"`
}

// SnapshotCollection is collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Snapshot `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// SnapshotCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SnapshotCollection) SnapshotCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SnapshotProperties is snapshot resource specific properties
type SnapshotProperties struct {
	Time *string `json:"time,omitempty"`
}

// SnapshotRecoveryRequest is details about app recovery operation.
type SnapshotRecoveryRequest struct {
	ID                                 *string `json:"id,omitempty"`
	Name                               *string `json:"name,omitempty"`
	Kind                               *string `json:"kind,omitempty"`
	Type                               *string `json:"type,omitempty"`
	*SnapshotRecoveryRequestProperties `json:"properties,omitempty"`
}

// SnapshotRecoveryRequestProperties is snapshotRecoveryRequest resource specific properties
type SnapshotRecoveryRequestProperties struct {
	SnapshotTime               *string                 `json:"snapshotTime,omitempty"`
	RecoveryTarget             *SnapshotRecoveryTarget `json:"recoveryTarget,omitempty"`
	Overwrite                  *bool                   `json:"overwrite,omitempty"`
	RecoverConfiguration       *bool                   `json:"recoverConfiguration,omitempty"`
	IgnoreConflictingHostNames *bool                   `json:"ignoreConflictingHostNames,omitempty"`
}

// SnapshotRecoveryTarget is specifies the web app that snapshot contents will be written to.
type SnapshotRecoveryTarget struct {
	Location *string `json:"location,omitempty"`
	ID       *string `json:"id,omitempty"`
}

// SourceControl is the source control OAuth token.
type SourceControl struct {
	autorest.Response        `json:"-"`
	ID                       *string `json:"id,omitempty"`
	Name                     *string `json:"name,omitempty"`
	Kind                     *string `json:"kind,omitempty"`
	Type                     *string `json:"type,omitempty"`
	*SourceControlProperties `json:"properties,omitempty"`
}

// SourceControlCollection is collection of source controls.
type SourceControlCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SourceControl `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// SourceControlCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SourceControlCollection) SourceControlCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SourceControlProperties is sourceControl resource specific properties
type SourceControlProperties struct {
	Name           *string    `json:"name,omitempty"`
	Token          *string    `json:"token,omitempty"`
	TokenSecret    *string    `json:"tokenSecret,omitempty"`
	RefreshToken   *string    `json:"refreshToken,omitempty"`
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// StampCapacity is stamp capacity information.
type StampCapacity struct {
	Name                           *string            `json:"name,omitempty"`
	AvailableCapacity              *int64             `json:"availableCapacity,omitempty"`
	TotalCapacity                  *int64             `json:"totalCapacity,omitempty"`
	Unit                           *string            `json:"unit,omitempty"`
	ComputeMode                    ComputeModeOptions `json:"computeMode,omitempty"`
	WorkerSize                     WorkerSizeOptions  `json:"workerSize,omitempty"`
	WorkerSizeID                   *int32             `json:"workerSizeId,omitempty"`
	ExcludeFromCapacityAllocation  *bool              `json:"excludeFromCapacityAllocation,omitempty"`
	IsApplicableForAllComputeModes *bool              `json:"isApplicableForAllComputeModes,omitempty"`
	SiteMode                       *string            `json:"siteMode,omitempty"`
}

// StampCapacityCollection is collection of stamp capacities.
type StampCapacityCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StampCapacity `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// StampCapacityCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StampCapacityCollection) StampCapacityCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StatusCodesBasedTrigger is trigger based on status code.
type StatusCodesBasedTrigger struct {
	Status       *int32  `json:"status,omitempty"`
	SubStatus    *int32  `json:"subStatus,omitempty"`
	Win32Status  *int32  `json:"win32Status,omitempty"`
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StorageMigrationOptions is options for app content migration.
type StorageMigrationOptions struct {
	ID                                 *string `json:"id,omitempty"`
	Name                               *string `json:"name,omitempty"`
	Kind                               *string `json:"kind,omitempty"`
	Type                               *string `json:"type,omitempty"`
	*StorageMigrationOptionsProperties `json:"properties,omitempty"`
}

// StorageMigrationOptionsProperties is storageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	AzurefilesConnectionString *string `json:"azurefilesConnectionString,omitempty"`
	AzurefilesShare            *string `json:"azurefilesShare,omitempty"`
	SwitchSiteAfterMigration   *bool   `json:"switchSiteAfterMigration,omitempty"`
	BlockWriteAccessToSite     *bool   `json:"blockWriteAccessToSite,omitempty"`
}

// StorageMigrationResponse is response for a migration of app content request.
type StorageMigrationResponse struct {
	autorest.Response                   `json:"-"`
	ID                                  *string `json:"id,omitempty"`
	Name                                *string `json:"name,omitempty"`
	Kind                                *string `json:"kind,omitempty"`
	Type                                *string `json:"type,omitempty"`
	*StorageMigrationResponseProperties `json:"properties,omitempty"`
}

// StorageMigrationResponseProperties is storageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	OperationID *string `json:"operationId,omitempty"`
}

// String is
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// StringDictionary is string dictionary resource.
type StringDictionary struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Properties        *map[string]*string `json:"properties,omitempty"`
}

// TldLegalAgreement is legal agreement for a top level domain.
type TldLegalAgreement struct {
	AgreementKey *string `json:"agreementKey,omitempty"`
	Title        *string `json:"title,omitempty"`
	Content      *string `json:"content,omitempty"`
	URL          *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection is collection of top-level domain legal agreements.
type TldLegalAgreementCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TldLegalAgreement `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// TldLegalAgreementCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client TldLegalAgreementCollection) TldLegalAgreementCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// TopLevelDomain is a top level domain object.
type TopLevelDomain struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*TopLevelDomainProperties `json:"properties,omitempty"`
}

// TopLevelDomainAgreementOption is options for retrieving the list of top level domain legal agreements.
type TopLevelDomainAgreementOption struct {
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
	ForTransfer    *bool `json:"forTransfer,omitempty"`
}

// TopLevelDomainCollection is collection of Top-level domains.
type TopLevelDomainCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TopLevelDomain `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// TopLevelDomainCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client TopLevelDomainCollection) TopLevelDomainCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// TopLevelDomainProperties is topLevelDomain resource specific properties
type TopLevelDomainProperties struct {
	DomainName *string `json:"name,omitempty"`
	Privacy    *bool   `json:"privacy,omitempty"`
}

// TriggeredJobHistory is triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Kind                           *string `json:"kind,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*TriggeredJobHistoryProperties `json:"properties,omitempty"`
}

// TriggeredJobHistoryCollection is collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TriggeredJobHistory `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// TriggeredJobHistoryCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client TriggeredJobHistoryCollection) TriggeredJobHistoryCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// TriggeredJobHistoryProperties is triggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	TriggeredJobRuns *[]TriggeredJobRun `json:"triggeredJobRuns,omitempty"`
}

// TriggeredJobRun is triggered Web Job Run Information.
type TriggeredJobRun struct {
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*TriggeredJobRunProperties `json:"properties,omitempty"`
}

// TriggeredJobRunProperties is triggeredJobRun resource specific properties
type TriggeredJobRunProperties struct {
	ID        *string               `json:"id,omitempty"`
	Name      *string               `json:"name,omitempty"`
	Status    TriggeredWebJobStatus `json:"status,omitempty"`
	StartTime *date.Time            `json:"startTime,omitempty"`
	EndTime   *date.Time            `json:"endTime,omitempty"`
	Duration  *string               `json:"duration,omitempty"`
	OutputURL *string               `json:"outputUrl,omitempty"`
	ErrorURL  *string               `json:"errorUrl,omitempty"`
	URL       *string               `json:"url,omitempty"`
	JobName   *string               `json:"jobName,omitempty"`
	Trigger   *string               `json:"trigger,omitempty"`
}

// TriggeredWebJob is triggered Web Job Information.
type TriggeredWebJob struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*TriggeredWebJobProperties `json:"properties,omitempty"`
}

// TriggeredWebJobCollection is collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TriggeredWebJob `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// TriggeredWebJobCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client TriggeredWebJobCollection) TriggeredWebJobCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// TriggeredWebJobProperties is triggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	LatestRun        *TriggeredJobRun        `json:"latestRun,omitempty"`
	HistoryURL       *string                 `json:"historyUrl,omitempty"`
	SchedulerLogsURL *string                 `json:"schedulerLogsUrl,omitempty"`
	Name             *string                 `json:"name,omitempty"`
	RunCommand       *string                 `json:"runCommand,omitempty"`
	URL              *string                 `json:"url,omitempty"`
	ExtraInfoURL     *string                 `json:"extraInfoUrl,omitempty"`
	JobType          JobType                 `json:"jobType,omitempty"`
	Error            *string                 `json:"error,omitempty"`
	UsingSdk         *bool                   `json:"usingSdk,omitempty"`
	Settings         *map[string]interface{} `json:"settings,omitempty"`
}

// Usage is usage of the quota resource.
type Usage struct {
	ID               *string `json:"id,omitempty"`
	Name             *string `json:"name,omitempty"`
	Kind             *string `json:"kind,omitempty"`
	Type             *string `json:"type,omitempty"`
	*UsageProperties `json:"properties,omitempty"`
}

// UsageCollection is collection of usages.
type UsageCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// UsageCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client UsageCollection) UsageCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// UsageProperties is usage resource specific properties
type UsageProperties struct {
	DisplayName   *string            `json:"displayName,omitempty"`
	Name          *string            `json:"name,omitempty"`
	ResourceName  *string            `json:"resourceName,omitempty"`
	Unit          *string            `json:"unit,omitempty"`
	CurrentValue  *int64             `json:"currentValue,omitempty"`
	Limit         *int64             `json:"limit,omitempty"`
	NextResetTime *date.Time         `json:"nextResetTime,omitempty"`
	ComputeMode   ComputeModeOptions `json:"computeMode,omitempty"`
	SiteMode      *string            `json:"siteMode,omitempty"`
}

// User is user crendentials used for publishing activity.
type User struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Kind              *string `json:"kind,omitempty"`
	Type              *string `json:"type,omitempty"`
	*UserProperties   `json:"properties,omitempty"`
}

// UserProperties is user resource specific properties
type UserProperties struct {
	UserName                   *string `json:"name,omitempty"`
	PublishingUserName         *string `json:"publishingUserName,omitempty"`
	PublishingPassword         *string `json:"publishingPassword,omitempty"`
	PublishingPasswordHash     *string `json:"publishingPasswordHash,omitempty"`
	PublishingPasswordHashSalt *string `json:"publishingPasswordHashSalt,omitempty"`
}

// ValidateProperties is app properties used for validation.
type ValidateProperties struct {
	ServerFarmID       *string `json:"serverFarmId,omitempty"`
	SkuName            *string `json:"skuName,omitempty"`
	NeedLinuxWorkers   *bool   `json:"needLinuxWorkers,omitempty"`
	Capacity           *int32  `json:"capacity,omitempty"`
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// ValidateRequest is resource validation request content.
type ValidateRequest struct {
	Name                *string               `json:"name,omitempty"`
	Type                ValidateResourceTypes `json:"type,omitempty"`
	Location            *string               `json:"location,omitempty"`
	*ValidateProperties `json:"properties,omitempty"`
}

// ValidateResponse is describes the result of resource validation.
type ValidateResponse struct {
	autorest.Response `json:"-"`
	Status            *string                `json:"status,omitempty"`
	Error             *ValidateResponseError `json:"error,omitempty"`
}

// ValidateResponseError is error details for when validation fails.
type ValidateResponseError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// VirtualApplication is virtual application in an app.
type VirtualApplication struct {
	VirtualPath        *string             `json:"virtualPath,omitempty"`
	PhysicalPath       *string             `json:"physicalPath,omitempty"`
	PreloadEnabled     *bool               `json:"preloadEnabled,omitempty"`
	VirtualDirectories *[]VirtualDirectory `json:"virtualDirectories,omitempty"`
}

// VirtualDirectory is directory for virtual application.
type VirtualDirectory struct {
	VirtualPath  *string `json:"virtualPath,omitempty"`
	PhysicalPath *string `json:"physicalPath,omitempty"`
}

// VirtualIPMapping is virtual IP mapping.
type VirtualIPMapping struct {
	VirtualIP         *string `json:"virtualIP,omitempty"`
	InternalHTTPPort  *int32  `json:"internalHttpPort,omitempty"`
	InternalHTTPSPort *int32  `json:"internalHttpsPort,omitempty"`
	InUse             *bool   `json:"inUse,omitempty"`
}

// VirtualNetworkProfile is specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	ID     *string `json:"id,omitempty"`
	Name   *string `json:"name,omitempty"`
	Type   *string `json:"type,omitempty"`
	Subnet *string `json:"subnet,omitempty"`
}

// VnetGateway is the Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the
// VPN package.
type VnetGateway struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Kind                   *string `json:"kind,omitempty"`
	Type                   *string `json:"type,omitempty"`
	*VnetGatewayProperties `json:"properties,omitempty"`
}

// VnetGatewayProperties is vnetGateway resource specific properties
type VnetGatewayProperties struct {
	VnetName      *string `json:"vnetName,omitempty"`
	VpnPackageURI *string `json:"vpnPackageUri,omitempty"`
}

// VnetInfo is virtual Network information contract.
type VnetInfo struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	Kind                *string `json:"kind,omitempty"`
	Type                *string `json:"type,omitempty"`
	*VnetInfoProperties `json:"properties,omitempty"`
}

// VnetInfoProperties is vnetInfo resource specific properties
type VnetInfoProperties struct {
	VnetResourceID *string      `json:"vnetResourceId,omitempty"`
	CertThumbprint *string      `json:"certThumbprint,omitempty"`
	CertBlob       *string      `json:"certBlob,omitempty"`
	Routes         *[]VnetRoute `json:"routes,omitempty"`
	ResyncRequired *bool        `json:"resyncRequired,omitempty"`
	DNSServers     *string      `json:"dnsServers,omitempty"`
}

// VnetParameters is the required set of inputs to validate a VNET
type VnetParameters struct {
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Kind                      *string `json:"kind,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*VnetParametersProperties `json:"properties,omitempty"`
}

// VnetParametersProperties is vnetParameters resource specific properties
type VnetParametersProperties struct {
	VnetResourceGroup *string `json:"vnetResourceGroup,omitempty"`
	VnetName          *string `json:"vnetName,omitempty"`
	VnetSubnetName    *string `json:"vnetSubnetName,omitempty"`
}

// VnetRoute is virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Kind                 *string `json:"kind,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*VnetRouteProperties `json:"properties,omitempty"`
}

// VnetRouteProperties is vnetRoute resource specific properties
type VnetRouteProperties struct {
	VnetRouteName *string   `json:"name,omitempty"`
	StartAddress  *string   `json:"startAddress,omitempty"`
	EndAddress    *string   `json:"endAddress,omitempty"`
	RouteType     RouteType `json:"routeType,omitempty"`
}

// VnetValidationFailureDetails is a class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	autorest.Response                       `json:"-"`
	ID                                      *string `json:"id,omitempty"`
	Name                                    *string `json:"name,omitempty"`
	Kind                                    *string `json:"kind,omitempty"`
	Type                                    *string `json:"type,omitempty"`
	*VnetValidationFailureDetailsProperties `json:"properties,omitempty"`
}

// VnetValidationFailureDetailsProperties is vnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	Failed      *bool                        `json:"failed,omitempty"`
	FailedTests *[]VnetValidationTestFailure `json:"failedTests,omitempty"`
}

// VnetValidationTestFailure is a class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	ID                                   *string `json:"id,omitempty"`
	Name                                 *string `json:"name,omitempty"`
	Kind                                 *string `json:"kind,omitempty"`
	Type                                 *string `json:"type,omitempty"`
	*VnetValidationTestFailureProperties `json:"properties,omitempty"`
}

// VnetValidationTestFailureProperties is vnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	TestName *string `json:"testName,omitempty"`
	Details  *string `json:"details,omitempty"`
}

// WorkerPool is worker pool of an App Service Environment.
type WorkerPool struct {
	WorkerSizeID  *int32             `json:"workerSizeId,omitempty"`
	ComputeMode   ComputeModeOptions `json:"computeMode,omitempty"`
	WorkerSize    *string            `json:"workerSize,omitempty"`
	WorkerCount   *int32             `json:"workerCount,omitempty"`
	InstanceNames *[]string          `json:"instanceNames,omitempty"`
}

// WorkerPoolCollection is collection of worker pools.
type WorkerPoolCollection struct {
	autorest.Response `json:"-"`
	Value             *[]WorkerPoolResource `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// WorkerPoolCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WorkerPoolCollection) WorkerPoolCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WorkerPoolResource is worker pool of an App Service Environment ARM resource.
type WorkerPoolResource struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Kind              *string `json:"kind,omitempty"`
	Type              *string `json:"type,omitempty"`
	*WorkerPool       `json:"properties,omitempty"`
	Sku               *SkuDescription `json:"sku,omitempty"`
}
