package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// DomainsClient is the webSite Management Client
type DomainsClient struct {
	ManagementClient
}

// NewDomainsClient creates an instance of the DomainsClient client.
func NewDomainsClient(subscriptionID string) DomainsClient {
	return NewDomainsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDomainsClientWithBaseURI creates an instance of the DomainsClient client.
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return DomainsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckAvailability check if a domain is available for registration.
//
// identifier is name of the domain.
func (client DomainsClient) CheckAvailability(identifier NameIdentifier) (result DomainAvailablilityCheckResult, err error) {
	req, err := client.CheckAvailabilityPreparer(identifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", resp, "Failure sending request")
		return
	}

	result, err = client.CheckAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CheckAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckAvailabilityPreparer prepares the CheckAvailability request.
func (client DomainsClient) CheckAvailabilityPreparer(identifier NameIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability", pathParameters),
		autorest.WithJSON(identifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CheckAvailabilitySender sends the CheckAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CheckAvailabilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CheckAvailabilityResponder handles the response to the CheckAvailability request. The method always
// closes the http.Response Body.
func (client DomainsClient) CheckAvailabilityResponder(resp *http.Response) (result DomainAvailablilityCheckResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates or updates a domain. This method may poll for completion. Polling can be canceled by passing
// the cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of the domain.
// domain is domain registration information.
func (client DomainsClient) CreateOrUpdate(resourceGroupName string, domainName string, domain Domain, cancel <-chan struct{}) (<-chan Domain, <-chan error) {
	resultChan := make(chan Domain, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: domainName,
			Constraints: []validation.Constraint{{Target: "domainName", Name: validation.Pattern, Rule: `[a-zA-Z0-9][a-zA-Z0-9\.-]+`, Chain: nil}}},
		{TargetValue: domain,
			Constraints: []validation.Constraint{{Target: "domain.DomainProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin.AddressMailing", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactAdmin.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
						}},
						{Target: "domain.DomainProperties.ContactAdmin.Email", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.NameLast", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "domain.DomainProperties.ContactAdmin.Phone", Name: validation.Null, Rule: true, Chain: nil},
					}},
					{Target: "domain.DomainProperties.ContactBilling", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactBilling.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactBilling.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactBilling.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactBilling.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactBilling.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "domain.DomainProperties.ContactRegistrant", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactRegistrant.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactRegistrant.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactRegistrant.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "domain.DomainProperties.ContactTech", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactTech.AddressMailing", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "domain.DomainProperties.ContactTech.AddressMailing.Address1", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.City", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.Country", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.PostalCode", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "domain.DomainProperties.ContactTech.AddressMailing.State", Name: validation.Null, Rule: true, Chain: nil},
							}},
							{Target: "domain.DomainProperties.ContactTech.Email", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.NameFirst", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.NameLast", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "domain.DomainProperties.ContactTech.Phone", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.DomainsClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Domain
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, domainName, domain, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client DomainsClient) CreateOrUpdatePreparer(resourceGroupName string, domainName string, domain Domain, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithJSON(domain),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client DomainsClient) CreateOrUpdateResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusAccepted, http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateOwnershipIdentifier creates an ownership identifier for a domain or updates identifier details for an
// existing identifer
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of domain. name is
// name of identifier. domainOwnershipIdentifier is a JSON representation of the domain ownership properties.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifier(resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (result DomainOwnershipIdentifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier")
	}

	req, err := client.CreateOrUpdateOwnershipIdentifierPreparer(resourceGroupName, domainName, name, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "CreateOrUpdateOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateOwnershipIdentifierPreparer prepares the CreateOrUpdateOwnershipIdentifier request.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierPreparer(resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateOwnershipIdentifierSender sends the CreateOrUpdateOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateOwnershipIdentifierResponder handles the response to the CreateOrUpdateOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) CreateOrUpdateOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a domain.
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of the domain.
// forceHardDeleteDomain is specify <code>true</code> to delete the domain immediately. The default is
// <code>false</code> which deletes the domain after 24 hours.
func (client DomainsClient) Delete(resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, domainName, forceHardDeleteDomain)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client DomainsClient) DeletePreparer(resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if forceHardDeleteDomain != nil {
		queryParameters["forceHardDeleteDomain"] = autorest.Encode("query", *forceHardDeleteDomain)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client DomainsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteOwnershipIdentifier delete ownership identifier for domain
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of domain. name is
// name of identifier.
func (client DomainsClient) DeleteOwnershipIdentifier(resourceGroupName string, domainName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "DeleteOwnershipIdentifier")
	}

	req, err := client.DeleteOwnershipIdentifierPreparer(resourceGroupName, domainName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "DeleteOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// DeleteOwnershipIdentifierPreparer prepares the DeleteOwnershipIdentifier request.
func (client DomainsClient) DeleteOwnershipIdentifierPreparer(resourceGroupName string, domainName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteOwnershipIdentifierSender sends the DeleteOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) DeleteOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteOwnershipIdentifierResponder handles the response to the DeleteOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) DeleteOwnershipIdentifierResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get a domain.
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of the domain.
func (client DomainsClient) Get(resourceGroupName string, domainName string) (result Domain, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client DomainsClient) GetPreparer(resourceGroupName string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetControlCenterSsoRequest generate a single sign-on request for the domain management portal.
func (client DomainsClient) GetControlCenterSsoRequest() (result DomainControlCenterSsoRequest, err error) {
	req, err := client.GetControlCenterSsoRequestPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetControlCenterSsoRequestSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", resp, "Failure sending request")
		return
	}

	result, err = client.GetControlCenterSsoRequestResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetControlCenterSsoRequest", resp, "Failure responding to request")
	}

	return
}

// GetControlCenterSsoRequestPreparer prepares the GetControlCenterSsoRequest request.
func (client DomainsClient) GetControlCenterSsoRequestPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetControlCenterSsoRequestSender sends the GetControlCenterSsoRequest request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetControlCenterSsoRequestSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetControlCenterSsoRequestResponder handles the response to the GetControlCenterSsoRequest request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetControlCenterSsoRequestResponder(resp *http.Response) (result DomainControlCenterSsoRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOwnershipIdentifier get ownership identifier for domain
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of domain. name is
// name of identifier.
func (client DomainsClient) GetOwnershipIdentifier(resourceGroupName string, domainName string, name string) (result DomainOwnershipIdentifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "GetOwnershipIdentifier")
	}

	req, err := client.GetOwnershipIdentifierPreparer(resourceGroupName, domainName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.GetOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "GetOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// GetOwnershipIdentifierPreparer prepares the GetOwnershipIdentifier request.
func (client DomainsClient) GetOwnershipIdentifierPreparer(resourceGroupName string, domainName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetOwnershipIdentifierSender sends the GetOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) GetOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetOwnershipIdentifierResponder handles the response to the GetOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) GetOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all domains in a subscription.
func (client DomainsClient) List() (result DomainCollection, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client DomainsClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListResponder(resp *http.Response) (result DomainCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client DomainsClient) ListNextResults(lastResults DomainCollection) (result DomainCollection, err error) {
	req, err := lastResults.DomainCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListComplete gets all elements from the list without paging.
func (client DomainsClient) ListComplete(cancel <-chan struct{}) (<-chan Domain, <-chan error) {
	resultChan := make(chan Domain)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.List()
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListByResourceGroup get all domains in a resource group.
//
// resourceGroupName is name of the resource group to which the resource belongs.
func (client DomainsClient) ListByResourceGroup(resourceGroupName string) (result DomainCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "ListByResourceGroup")
	}

	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client DomainsClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListByResourceGroupResponder(resp *http.Response) (result DomainCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client DomainsClient) ListByResourceGroupNextResults(lastResults DomainCollection) (result DomainCollection, err error) {
	req, err := lastResults.DomainCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListByResourceGroupComplete gets all elements from the list without paging.
func (client DomainsClient) ListByResourceGroupComplete(resourceGroupName string, cancel <-chan struct{}) (<-chan Domain, <-chan error) {
	resultChan := make(chan Domain)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListByResourceGroup(resourceGroupName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListByResourceGroupNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListOwnershipIdentifiers lists domain ownership identifiers.
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of domain.
func (client DomainsClient) ListOwnershipIdentifiers(resourceGroupName string, domainName string) (result DomainOwnershipIdentifierCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "ListOwnershipIdentifiers")
	}

	req, err := client.ListOwnershipIdentifiersPreparer(resourceGroupName, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure sending request")
		return
	}

	result, err = client.ListOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListOwnershipIdentifiersPreparer prepares the ListOwnershipIdentifiers request.
func (client DomainsClient) ListOwnershipIdentifiersPreparer(resourceGroupName string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListOwnershipIdentifiersSender sends the ListOwnershipIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListOwnershipIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListOwnershipIdentifiersResponder handles the response to the ListOwnershipIdentifiers request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListOwnershipIdentifiersResponder(resp *http.Response) (result DomainOwnershipIdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListOwnershipIdentifiersNextResults retrieves the next set of results, if any.
func (client DomainsClient) ListOwnershipIdentifiersNextResults(lastResults DomainOwnershipIdentifierCollection) (result DomainOwnershipIdentifierCollection, err error) {
	req, err := lastResults.DomainOwnershipIdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure sending next results request")
	}

	result, err = client.ListOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListOwnershipIdentifiers", resp, "Failure responding to next results request")
	}

	return
}

// ListOwnershipIdentifiersComplete gets all elements from the list without paging.
func (client DomainsClient) ListOwnershipIdentifiersComplete(resourceGroupName string, domainName string, cancel <-chan struct{}) (<-chan DomainOwnershipIdentifier, <-chan error) {
	resultChan := make(chan DomainOwnershipIdentifier)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListOwnershipIdentifiers(resourceGroupName, domainName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListOwnershipIdentifiersNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListRecommendations get domain name recommendations based on keywords.
//
// parameters is search parameters for domain name recommendations.
func (client DomainsClient) ListRecommendations(parameters DomainRecommendationSearchParameters) (result NameIdentifierCollection, err error) {
	req, err := client.ListRecommendationsPreparer(parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRecommendationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure sending request")
		return
	}

	result, err = client.ListRecommendationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure responding to request")
	}

	return
}

// ListRecommendationsPreparer prepares the ListRecommendations request.
func (client DomainsClient) ListRecommendationsPreparer(parameters DomainRecommendationSearchParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRecommendationsSender sends the ListRecommendations request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) ListRecommendationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRecommendationsResponder handles the response to the ListRecommendations request. The method always
// closes the http.Response Body.
func (client DomainsClient) ListRecommendationsResponder(resp *http.Response) (result NameIdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRecommendationsNextResults retrieves the next set of results, if any.
func (client DomainsClient) ListRecommendationsNextResults(lastResults NameIdentifierCollection) (result NameIdentifierCollection, err error) {
	req, err := lastResults.NameIdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListRecommendationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure sending next results request")
	}

	result, err = client.ListRecommendationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "ListRecommendations", resp, "Failure responding to next results request")
	}

	return
}

// ListRecommendationsComplete gets all elements from the list without paging.
func (client DomainsClient) ListRecommendationsComplete(parameters DomainRecommendationSearchParameters, cancel <-chan struct{}) (<-chan NameIdentifier, <-chan error) {
	resultChan := make(chan NameIdentifier)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListRecommendations(parameters)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListRecommendationsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// UpdateOwnershipIdentifier creates an ownership identifier for a domain or updates identifier details for an existing
// identifer
//
// resourceGroupName is name of the resource group to which the resource belongs. domainName is name of domain. name is
// name of identifier. domainOwnershipIdentifier is a JSON representation of the domain ownership properties.
func (client DomainsClient) UpdateOwnershipIdentifier(resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (result DomainOwnershipIdentifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.DomainsClient", "UpdateOwnershipIdentifier")
	}

	req, err := client.UpdateOwnershipIdentifierPreparer(resourceGroupName, domainName, name, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.DomainsClient", "UpdateOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// UpdateOwnershipIdentifierPreparer prepares the UpdateOwnershipIdentifier request.
func (client DomainsClient) UpdateOwnershipIdentifierPreparer(resourceGroupName string, domainName string, name string, domainOwnershipIdentifier DomainOwnershipIdentifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateOwnershipIdentifierSender sends the UpdateOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client DomainsClient) UpdateOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateOwnershipIdentifierResponder handles the response to the UpdateOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client DomainsClient) UpdateOwnershipIdentifierResponder(resp *http.Response) (result DomainOwnershipIdentifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
