package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// AppsClient is the webSite Management Client
type AppsClient struct {
	ManagementClient
}

// NewAppsClient creates an instance of the AppsClient client.
func NewAppsClient(subscriptionID string) AppsClient {
	return NewAppsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppsClientWithBaseURI creates an instance of the AppsClient client.
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return AppsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddPremierAddOn updates a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name. premierAddOn is a JSON representation of the edited premier add-on.
func (client AppsClient) AddPremierAddOn(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AddPremierAddOn")
	}

	req, err := client.AddPremierAddOnPreparer(resourceGroupName, name, premierAddOnName, premierAddOn)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnPreparer prepares the AddPremierAddOn request.
func (client AppsClient) AddPremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddPremierAddOnSender sends the AddPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// AddPremierAddOnResponder handles the response to the AddPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPremierAddOnSlot updates a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name. premierAddOn is a JSON representation of the edited premier add-on. slot is name of
// the deployment slot. If a slot is not specified, the API will update the named add-on for the production slot.
func (client AppsClient) AddPremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AddPremierAddOnSlot")
	}

	req, err := client.AddPremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, premierAddOn, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AddPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AddPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// AddPremierAddOnSlotPreparer prepares the AddPremierAddOnSlot request.
func (client AppsClient) AddPremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOn, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AddPremierAddOnSlotSender sends the AddPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// AddPremierAddOnSlotResponder handles the response to the AddPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AddPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostname analyze a custom hostname.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. hostName is
// custom hostname.
func (client AppsClient) AnalyzeCustomHostname(resourceGroupName string, name string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AnalyzeCustomHostname")
	}

	req, err := client.AnalyzeCustomHostnamePreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostname", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnamePreparer prepares the AnalyzeCustomHostname request.
func (client AppsClient) AnalyzeCustomHostnamePreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AnalyzeCustomHostnameSender sends the AnalyzeCustomHostname request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// AnalyzeCustomHostnameResponder handles the response to the AnalyzeCustomHostname request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AnalyzeCustomHostnameSlot analyze a custom hostname.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. hostName is custom hostname.
func (client AppsClient) AnalyzeCustomHostnameSlot(resourceGroupName string, name string, slot string, hostName string) (result CustomHostnameAnalysisResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot")
	}

	req, err := client.AnalyzeCustomHostnameSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AnalyzeCustomHostnameSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AnalyzeCustomHostnameSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "AnalyzeCustomHostnameSlot", resp, "Failure responding to request")
	}

	return
}

// AnalyzeCustomHostnameSlotPreparer prepares the AnalyzeCustomHostnameSlot request.
func (client AppsClient) AnalyzeCustomHostnameSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(hostName) > 0 {
		queryParameters["hostName"] = autorest.Encode("query", hostName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// AnalyzeCustomHostnameSlotSender sends the AnalyzeCustomHostnameSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AnalyzeCustomHostnameSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// AnalyzeCustomHostnameSlotResponder handles the response to the AnalyzeCustomHostnameSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) AnalyzeCustomHostnameSlotResponder(resp *http.Response) (result CustomHostnameAnalysisResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigToProduction applies the configuration settings from the target slot onto the current slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// slotSwapEntity is JSON object that contains the target slot name. See example.
func (client AppsClient) ApplySlotConfigToProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ApplySlotConfigToProduction")
	}

	req, err := client.ApplySlotConfigToProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigToProductionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigToProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigToProduction", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigToProductionPreparer prepares the ApplySlotConfigToProduction request.
func (client AppsClient) ApplySlotConfigToProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigToProductionSender sends the ApplySlotConfigToProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigToProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigToProductionResponder handles the response to the ApplySlotConfigToProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigToProductionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ApplySlotConfigurationSlot applies the configuration settings from the target slot onto the current slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// slotSwapEntity is JSON object that contains the target slot name. See example. slot is name of the source slot. If a
// slot is not specified, the production slot is used as the source slot.
func (client AppsClient) ApplySlotConfigurationSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ApplySlotConfigurationSlot")
	}

	req, err := client.ApplySlotConfigurationSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ApplySlotConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// ApplySlotConfigurationSlotPreparer prepares the ApplySlotConfigurationSlot request.
func (client AppsClient) ApplySlotConfigurationSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ApplySlotConfigurationSlotSender sends the ApplySlotConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ApplySlotConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigurationSlotResponder handles the response to the ApplySlotConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ApplySlotConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Backup creates a backup of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. request is
// backup configuration. You can use the JSON response from the POST action as input here.
func (client AppsClient) Backup(resourceGroupName string, name string, request BackupRequest) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Backup")
	}

	req, err := client.BackupPreparer(resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure sending request")
		return
	}

	result, err = client.BackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Backup", resp, "Failure responding to request")
	}

	return
}

// BackupPreparer prepares the Backup request.
func (client AppsClient) BackupPreparer(resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSender sends the Backup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// BackupResponder handles the response to the Backup request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSlot creates a backup of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. request is
// backup configuration. You can use the JSON response from the POST action as input here. slot is name of the
// deployment slot. If a slot is not specified, the API will create a backup for the production slot.
func (client AppsClient) BackupSlot(resourceGroupName string, name string, request BackupRequest, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "BackupSlot")
	}

	req, err := client.BackupSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.BackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "BackupSlot", resp, "Failure responding to request")
	}

	return
}

// BackupSlotPreparer prepares the BackupSlot request.
func (client AppsClient) BackupSlotPreparer(resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// BackupSlotSender sends the BackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) BackupSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// BackupSlotResponder handles the response to the BackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) BackupSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeployment create a deployment for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is ID of
// an existing deployment. deployment is deployment details.
func (client AppsClient) CreateDeployment(resourceGroupName string, name string, ID string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateDeployment")
	}

	req, err := client.CreateDeploymentPreparer(resourceGroupName, name, ID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeployment", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentPreparer prepares the CreateDeployment request.
func (client AppsClient) CreateDeploymentPreparer(resourceGroupName string, name string, ID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSender sends the CreateDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentResponder handles the response to the CreateDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeploymentSlot create a deployment for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is ID of
// an existing deployment. slot is name of the deployment slot. If a slot is not specified, the API creates a
// deployment for the production slot. deployment is deployment details.
func (client AppsClient) CreateDeploymentSlot(resourceGroupName string, name string, ID string, slot string, deployment Deployment) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateDeploymentSlot")
	}

	req, err := client.CreateDeploymentSlotPreparer(resourceGroupName, name, ID, slot, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// CreateDeploymentSlotPreparer prepares the CreateDeploymentSlot request.
func (client AppsClient) CreateDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateDeploymentSlotSender sends the CreateDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentSlotResponder handles the response to the CreateDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateFunction create function for web site, or a deployment slot. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name. functionEnvelope is function details.
func (client AppsClient) CreateFunction(resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope, cancel <-chan struct{}) (<-chan FunctionEnvelope, <-chan error) {
	resultChan := make(chan FunctionEnvelope, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateFunction")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result FunctionEnvelope
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateFunctionPreparer(resourceGroupName, name, functionName, functionEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateFunction", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateFunctionSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateFunction", resp, "Failure sending request")
			return
		}

		result, err = client.CreateFunctionResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateFunction", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateFunctionPreparer prepares the CreateFunction request.
func (client AppsClient) CreateFunctionPreparer(resourceGroupName string, name string, functionName string, functionEnvelope FunctionEnvelope, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithJSON(functionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateFunctionSender sends the CreateFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateFunctionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateFunctionResponder handles the response to the CreateFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateFunctionResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceFunctionSlot create function for web site, or a deployment slot. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot. functionEnvelope is function details.
func (client AppsClient) CreateInstanceFunctionSlot(resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope, cancel <-chan struct{}) (<-chan FunctionEnvelope, <-chan error) {
	resultChan := make(chan FunctionEnvelope, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateInstanceFunctionSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result FunctionEnvelope
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateInstanceFunctionSlotPreparer(resourceGroupName, name, functionName, slot, functionEnvelope, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceFunctionSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateInstanceFunctionSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceFunctionSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateInstanceFunctionSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceFunctionSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateInstanceFunctionSlotPreparer prepares the CreateInstanceFunctionSlot request.
func (client AppsClient) CreateInstanceFunctionSlotPreparer(resourceGroupName string, name string, functionName string, slot string, functionEnvelope FunctionEnvelope, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithJSON(functionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateInstanceFunctionSlotSender sends the CreateInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceFunctionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateInstanceFunctionSlotResponder handles the response to the CreateInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceFunctionSlotResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceMSDeployOperation invoke the MSDeploy web app extension. This method may poll for completion. Polling
// can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. instanceID
// is ID of web app instance. mSDeploy is details of MSDeploy operation
func (client AppsClient) CreateInstanceMSDeployOperation(resourceGroupName string, name string, instanceID string, mSDeploy MSDeploy, cancel <-chan struct{}) (<-chan MSDeployStatus, <-chan error) {
	resultChan := make(chan MSDeployStatus, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateInstanceMSDeployOperation")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result MSDeployStatus
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateInstanceMSDeployOperationPreparer(resourceGroupName, name, instanceID, mSDeploy, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperation", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateInstanceMSDeployOperationSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperation", resp, "Failure sending request")
			return
		}

		result, err = client.CreateInstanceMSDeployOperationResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperation", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateInstanceMSDeployOperationPreparer prepares the CreateInstanceMSDeployOperation request.
func (client AppsClient) CreateInstanceMSDeployOperationPreparer(resourceGroupName string, name string, instanceID string, mSDeploy MSDeploy, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateInstanceMSDeployOperationSender sends the CreateInstanceMSDeployOperation request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceMSDeployOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateInstanceMSDeployOperationResponder handles the response to the CreateInstanceMSDeployOperation request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceMSDeployOperationResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceMSDeployOperationSlot invoke the MSDeploy web app extension. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. instanceID is ID of web app instance.
// mSDeploy is details of MSDeploy operation
func (client AppsClient) CreateInstanceMSDeployOperationSlot(resourceGroupName string, name string, slot string, instanceID string, mSDeploy MSDeploy, cancel <-chan struct{}) (<-chan MSDeployStatus, <-chan error) {
	resultChan := make(chan MSDeployStatus, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result MSDeployStatus
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateInstanceMSDeployOperationSlotPreparer(resourceGroupName, name, slot, instanceID, mSDeploy, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateInstanceMSDeployOperationSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateInstanceMSDeployOperationSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateInstanceMSDeployOperationSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateInstanceMSDeployOperationSlotPreparer prepares the CreateInstanceMSDeployOperationSlot request.
func (client AppsClient) CreateInstanceMSDeployOperationSlotPreparer(resourceGroupName string, name string, slot string, instanceID string, mSDeploy MSDeploy, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateInstanceMSDeployOperationSlotSender sends the CreateInstanceMSDeployOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateInstanceMSDeployOperationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateInstanceMSDeployOperationSlotResponder handles the response to the CreateInstanceMSDeployOperationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateInstanceMSDeployOperationSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateMSDeployOperation invoke the MSDeploy web app extension. This method may poll for completion. Polling can be
// canceled by passing the cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. mSDeploy is
// details of MSDeploy operation
func (client AppsClient) CreateMSDeployOperation(resourceGroupName string, name string, mSDeploy MSDeploy, cancel <-chan struct{}) (<-chan MSDeployStatus, <-chan error) {
	resultChan := make(chan MSDeployStatus, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateMSDeployOperation")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result MSDeployStatus
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateMSDeployOperationPreparer(resourceGroupName, name, mSDeploy, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperation", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateMSDeployOperationSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperation", resp, "Failure sending request")
			return
		}

		result, err = client.CreateMSDeployOperationResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperation", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateMSDeployOperationPreparer prepares the CreateMSDeployOperation request.
func (client AppsClient) CreateMSDeployOperationPreparer(resourceGroupName string, name string, mSDeploy MSDeploy, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateMSDeployOperationSender sends the CreateMSDeployOperation request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateMSDeployOperationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateMSDeployOperationResponder handles the response to the CreateMSDeployOperation request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateMSDeployOperationResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateMSDeployOperationSlot invoke the MSDeploy web app extension. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. mSDeploy is details of MSDeploy operation
func (client AppsClient) CreateMSDeployOperationSlot(resourceGroupName string, name string, slot string, mSDeploy MSDeploy, cancel <-chan struct{}) (<-chan MSDeployStatus, <-chan error) {
	resultChan := make(chan MSDeployStatus, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateMSDeployOperationSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result MSDeployStatus
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateMSDeployOperationSlotPreparer(resourceGroupName, name, slot, mSDeploy, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperationSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateMSDeployOperationSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperationSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateMSDeployOperationSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateMSDeployOperationSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateMSDeployOperationSlotPreparer prepares the CreateMSDeployOperationSlot request.
func (client AppsClient) CreateMSDeployOperationSlotPreparer(resourceGroupName string, name string, slot string, mSDeploy MSDeploy, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", pathParameters),
		autorest.WithJSON(mSDeploy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateMSDeployOperationSlotSender sends the CreateMSDeployOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateMSDeployOperationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateMSDeployOperationSlotResponder handles the response to the CreateMSDeployOperationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateMSDeployOperationSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusConflict),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate creates a new web, mobile, or API app in an existing resource group, or updates an existing app. This
// method may poll for completion. Polling can be canceled by passing the cancel channel argument. The channel will be
// used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is unique name of the app to
// create or update. To create or update a deployment slot, use the {slot} parameter. siteEnvelope is a JSON
// representation of the app properties. See example. skipDNSRegistration is if true web app hostname is not registered
// with DNS on creation. This parameter is
// only used for app creation. skipCustomDomainVerification is if true, custom (non *.azurewebsites.net) domains
// associated with web app are not verified. forceDNSRegistration is if true, web app hostname is force registered with
// DNS. TTLInSeconds is time to live in seconds for web app's default domain name.
func (client AppsClient) CreateOrUpdate(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Site
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, name, siteEnvelope, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppsClient) CreateOrUpdatePreparer(resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}
	if skipCustomDomainVerification != nil {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", *skipCustomDomainVerification)
	}
	if forceDNSRegistration != nil {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", *forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfiguration updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. siteConfig
// is JSON representation of a SiteConfig object. See example.
func (client AppsClient) CreateOrUpdateConfiguration(resourceGroupName string, name string, siteConfig SiteConfigResource) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateConfiguration")
	}

	req, err := client.CreateOrUpdateConfigurationPreparer(resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfiguration", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationPreparer prepares the CreateOrUpdateConfiguration request.
func (client AppsClient) CreateOrUpdateConfigurationPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateConfigurationSender sends the CreateOrUpdateConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateConfigurationResponder handles the response to the CreateOrUpdateConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateConfigurationSlot updates the configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. siteConfig
// is JSON representation of a SiteConfig object. See example. slot is name of the deployment slot. If a slot is not
// specified, the API will update configuration for the production slot.
func (client AppsClient) CreateOrUpdateConfigurationSlot(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot")
	}

	req, err := client.CreateOrUpdateConfigurationSlotPreparer(resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateConfigurationSlotPreparer prepares the CreateOrUpdateConfigurationSlot request.
func (client AppsClient) CreateOrUpdateConfigurationSlotPreparer(resourceGroupName string, name string, siteConfig SiteConfigResource, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateConfigurationSlotSender sends the CreateOrUpdateConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateConfigurationSlotResponder handles the response to the CreateOrUpdateConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifier creates a domain ownership identifier for web app, or updates an existing
// ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier")
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierPreparer prepares the CreateOrUpdateDomainOwnershipIdentifier request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateDomainOwnershipIdentifierSender sends the CreateOrUpdateDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateDomainOwnershipIdentifierResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlot creates a domain ownership identifier for web app, or updates an
// existing ownership identifier.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier. domainOwnershipIdentifier is a JSON
// representation of the domain ownership properties. slot is name of the deployment slot. If a slot is not specified,
// the API will delete the binding for the production slot.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot")
	}

	req, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateDomainOwnershipIdentifierSlotPreparer prepares the CreateOrUpdateDomainOwnershipIdentifierSlot request.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier Identifier, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithJSON(domainOwnershipIdentifier),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateDomainOwnershipIdentifierSlotSender sends the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateDomainOwnershipIdentifierSlotResponder handles the response to the CreateOrUpdateDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBinding creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. hostName is
// hostname in the hostname binding. hostNameBinding is binding details. This is the JSON representation of a
// HostNameBinding object.
func (client AppsClient) CreateOrUpdateHostNameBinding(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding")
	}

	req, err := client.CreateOrUpdateHostNameBindingPreparer(resourceGroupName, name, hostName, hostNameBinding)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingPreparer prepares the CreateOrUpdateHostNameBinding request.
func (client AppsClient) CreateOrUpdateHostNameBindingPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHostNameBindingSender sends the CreateOrUpdateHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostNameBindingResponder handles the response to the CreateOrUpdateHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHostNameBindingSlot creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. hostName is
// hostname in the hostname binding. hostNameBinding is binding details. This is the JSON representation of a
// HostNameBinding object. slot is name of the deployment slot. If a slot is not specified, the API will create a
// binding for the production slot.
func (client AppsClient) CreateOrUpdateHostNameBindingSlot(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot")
	}

	req, err := client.CreateOrUpdateHostNameBindingSlotPreparer(resourceGroupName, name, hostName, hostNameBinding, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHostNameBindingSlotPreparer prepares the CreateOrUpdateHostNameBindingSlot request.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotPreparer(resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHostNameBindingSlotSender sends the CreateOrUpdateHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHostNameBindingSlotResponder handles the response to the CreateOrUpdateHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnection creates a new Hybrid Connection using a Service Bus relay.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
// connectionEnvelope is the details of the hybrid connection.
func (client AppsClient) CreateOrUpdateHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHybridConnection")
	}

	req, err := client.CreateOrUpdateHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionPreparer prepares the CreateOrUpdateHybridConnection request.
func (client AppsClient) CreateOrUpdateHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHybridConnectionSender sends the CreateOrUpdateHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHybridConnectionResponder handles the response to the CreateOrUpdateHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateHybridConnectionSlot creates a new Hybrid Connection using a Service Bus relay.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
// connectionEnvelope is the details of the hybrid connection. slot is the name of the slot for the web app.
func (client AppsClient) CreateOrUpdateHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot")
	}

	req, err := client.CreateOrUpdateHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateHybridConnectionSlotPreparer prepares the CreateOrUpdateHybridConnectionSlot request.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope HybridConnection, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateHybridConnectionSlotSender sends the CreateOrUpdateHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateHybridConnectionSlotResponder handles the response to the CreateOrUpdateHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdatePublicCertificate creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publicCertificateName is public certificate name. publicCertificate is public certificate details. This is the JSON
// representation of a PublicCertificate object.
func (client AppsClient) CreateOrUpdatePublicCertificate(resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate) (result PublicCertificate, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate")
	}

	req, err := client.CreateOrUpdatePublicCertificatePreparer(resourceGroupName, name, publicCertificateName, publicCertificate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdatePublicCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdatePublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePublicCertificatePreparer prepares the CreateOrUpdatePublicCertificate request.
func (client AppsClient) CreateOrUpdatePublicCertificatePreparer(resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithJSON(publicCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdatePublicCertificateSender sends the CreateOrUpdatePublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdatePublicCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdatePublicCertificateResponder handles the response to the CreateOrUpdatePublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdatePublicCertificateResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdatePublicCertificateSlot creates a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publicCertificateName is public certificate name. publicCertificate is public certificate details. This is the JSON
// representation of a PublicCertificate object. slot is name of the deployment slot. If a slot is not specified, the
// API will create a binding for the production slot.
func (client AppsClient) CreateOrUpdatePublicCertificateSlot(resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, slot string) (result PublicCertificate, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot")
	}

	req, err := client.CreateOrUpdatePublicCertificateSlotPreparer(resourceGroupName, name, publicCertificateName, publicCertificate, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdatePublicCertificateSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdatePublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdatePublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePublicCertificateSlotPreparer prepares the CreateOrUpdatePublicCertificateSlot request.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotPreparer(resourceGroupName string, name string, publicCertificateName string, publicCertificate PublicCertificate, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithJSON(publicCertificate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdatePublicCertificateSlotSender sends the CreateOrUpdatePublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdatePublicCertificateSlotResponder handles the response to the CreateOrUpdatePublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdatePublicCertificateSlotResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnection creates a new hybrid connection configuration (PUT), or updates an existing one
// (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection configuration. connectionEnvelope is details of the hybrid connection
// configuration.
func (client AppsClient) CreateOrUpdateRelayServiceConnection(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection")
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionPreparer(resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionPreparer prepares the CreateOrUpdateRelayServiceConnection request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateRelayServiceConnectionSender sends the CreateOrUpdateRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateRelayServiceConnectionResponder handles the response to the CreateOrUpdateRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateRelayServiceConnectionSlot creates a new hybrid connection configuration (PUT), or updates an existing
// one (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection configuration. connectionEnvelope is details of the hybrid connection
// configuration. slot is name of the deployment slot. If a slot is not specified, the API will create or update a
// hybrid connection for the production slot.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot")
	}

	req, err := client.CreateOrUpdateRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateRelayServiceConnectionSlotPreparer prepares the CreateOrUpdateRelayServiceConnectionSlot request.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateRelayServiceConnectionSlotSender sends the CreateOrUpdateRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateRelayServiceConnectionSlotResponder handles the response to the CreateOrUpdateRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSlot creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
// This method may poll for completion. Polling can be canceled by passing the cancel channel argument. The channel
// will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is unique name of the app to
// create or update. To create or update a deployment slot, use the {slot} parameter. siteEnvelope is a JSON
// representation of the app properties. See example. slot is name of the deployment slot to create or update. By
// default, this API attempts to create or modify the production slot. skipDNSRegistration is if true web app hostname
// is not registered with DNS on creation. This parameter is
// only used for app creation. skipCustomDomainVerification is if true, custom (non *.azurewebsites.net) domains
// associated with web app are not verified. forceDNSRegistration is if true, web app hostname is force registered with
// DNS. TTLInSeconds is time to live in seconds for web app's default domain name.
func (client AppsClient) CreateOrUpdateSlot(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: siteEnvelope,
			Constraints: []validation.Constraint{{Target: "siteEnvelope.SiteProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "siteEnvelope.SiteProperties.CloningInfo.SourceWebAppID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result Site
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSlotPreparer(resourceGroupName, name, siteEnvelope, slot, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSlotPreparer prepares the CreateOrUpdateSlot request.
func (client AppsClient) CreateOrUpdateSlotPreparer(resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration *bool, skipCustomDomainVerification *bool, forceDNSRegistration *bool, TTLInSeconds string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}
	if skipCustomDomainVerification != nil {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", *skipCustomDomainVerification)
	}
	if forceDNSRegistration != nil {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", *forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSlotSender sends the CreateOrUpdateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSlotResponder handles the response to the CreateOrUpdateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControl updates the source control configuration of an app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// siteSourceControl is JSON representation of a SiteSourceControl object. See example.
func (client AppsClient) CreateOrUpdateSourceControl(resourceGroupName string, name string, siteSourceControl SiteSourceControl, cancel <-chan struct{}) (<-chan SiteSourceControl, <-chan error) {
	resultChan := make(chan SiteSourceControl, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSourceControl")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteSourceControl
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSourceControlPreparer(resourceGroupName, name, siteSourceControl, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSourceControlSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSourceControlResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControl", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSourceControlPreparer prepares the CreateOrUpdateSourceControl request.
func (client AppsClient) CreateOrUpdateSourceControlPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSourceControlSender sends the CreateOrUpdateSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSourceControlResponder handles the response to the CreateOrUpdateSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSourceControlSlot updates the source control configuration of an app. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// siteSourceControl is JSON representation of a SiteSourceControl object. See example. slot is name of the deployment
// slot. If a slot is not specified, the API will update the source control configuration for the production slot.
func (client AppsClient) CreateOrUpdateSourceControlSlot(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string, cancel <-chan struct{}) (<-chan SiteSourceControl, <-chan error) {
	resultChan := make(chan SiteSourceControl, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteSourceControl
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateSourceControlSlotPreparer(resourceGroupName, name, siteSourceControl, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSourceControlSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateSourceControlSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateSourceControlSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateSourceControlSlotPreparer prepares the CreateOrUpdateSourceControlSlot request.
func (client AppsClient) CreateOrUpdateSourceControlSlotPreparer(resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSourceControlSlotSender sends the CreateOrUpdateSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateSourceControlSlotResponder handles the response to the CreateOrUpdateSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnection adds a Virtual Network connection to an app or slot (PUT) or updates the connection
// properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of an existing Virtual Network. connectionEnvelope is properties of the Virtual Network connection. See
// example.
func (client AppsClient) CreateOrUpdateVnetConnection(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnection")
	}

	req, err := client.CreateOrUpdateVnetConnectionPreparer(resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnection", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionPreparer prepares the CreateOrUpdateVnetConnection request.
func (client AppsClient) CreateOrUpdateVnetConnectionPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionSender sends the CreateOrUpdateVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionResponder handles the response to the CreateOrUpdateVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGateway adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the Virtual Network. gatewayName is name of the gateway. Currently, the only supported string is "primary".
// connectionEnvelope is the properties to update this gateway with.
func (client AppsClient) CreateOrUpdateVnetConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway")
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewayPreparer prepares the CreateOrUpdateVnetConnectionGateway request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionGatewaySender sends the CreateOrUpdateVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionGatewayResponder handles the response to the CreateOrUpdateVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionGatewaySlot adds a gateway to a connected Virtual Network (PUT) or updates it (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the Virtual Network. gatewayName is name of the gateway. Currently, the only supported string is "primary".
// connectionEnvelope is the properties to update this gateway with. slot is name of the deployment slot. If a slot is
// not specified, the API will add or update a gateway for the production slot's Virtual Network.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot")
	}

	req, err := client.CreateOrUpdateVnetConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionGatewaySlotPreparer prepares the CreateOrUpdateVnetConnectionGatewaySlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionGatewaySlotSender sends the CreateOrUpdateVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionGatewaySlotResponder handles the response to the CreateOrUpdateVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetConnectionSlot adds a Virtual Network connection to an app or slot (PUT) or updates the connection
// properties (PATCH).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of an existing Virtual Network. connectionEnvelope is properties of the Virtual Network connection. See
// example. slot is name of the deployment slot. If a slot is not specified, the API will add or update connections for
// the production slot.
func (client AppsClient) CreateOrUpdateVnetConnectionSlot(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot")
	}

	req, err := client.CreateOrUpdateVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "CreateOrUpdateVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetConnectionSlotPreparer prepares the CreateOrUpdateVnetConnectionSlot request.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetConnectionSlotSender sends the CreateOrUpdateVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetConnectionSlotResponder handles the response to the CreateOrUpdateVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) CreateOrUpdateVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a web, mobile, or API app, or one of the deployment slots.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app to delete.
// deleteMetrics is if true, web app metrics are also deleted. deleteEmptyServerFarm is specify true if the App Service
// plan will be empty after app deletion and you want to delete the empty App Service plan. By default, the empty App
// Service plan is not deleted. skipDNSRegistration is if true, DNS registration is skipped.
func (client AppsClient) Delete(resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppsClient) DeletePreparer(resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackup deletes a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. backupID is
// ID of the backup.
func (client AppsClient) DeleteBackup(resourceGroupName string, name string, backupID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackup")
	}

	req, err := client.DeleteBackupPreparer(resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackup", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupPreparer prepares the DeleteBackup request.
func (client AppsClient) DeleteBackupPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSender sends the DeleteBackup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupResponder handles the response to the DeleteBackup request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfiguration deletes the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) DeleteBackupConfiguration(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupConfiguration")
	}

	req, err := client.DeleteBackupConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationPreparer prepares the DeleteBackupConfiguration request.
func (client AppsClient) DeleteBackupConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupConfigurationSender sends the DeleteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupConfigurationResponder handles the response to the DeleteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupConfigurationSlot deletes the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will delete the backup configuration for the production
// slot.
func (client AppsClient) DeleteBackupConfigurationSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupConfigurationSlot")
	}

	req, err := client.DeleteBackupConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupConfigurationSlotPreparer prepares the DeleteBackupConfigurationSlot request.
func (client AppsClient) DeleteBackupConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupConfigurationSlotSender sends the DeleteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupConfigurationSlotResponder handles the response to the DeleteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupConfigurationSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteBackupSlot deletes a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. backupID is
// ID of the backup. slot is name of the deployment slot. If a slot is not specified, the API will delete a backup of
// the production slot.
func (client AppsClient) DeleteBackupSlot(resourceGroupName string, name string, backupID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteBackupSlot")
	}

	req, err := client.DeleteBackupSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteBackupSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteBackupSlotPreparer prepares the DeleteBackupSlot request.
func (client AppsClient) DeleteBackupSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteBackupSlotSender sends the DeleteBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteBackupSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupSlotResponder handles the response to the DeleteBackupSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteBackupSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteContinuousWebJob delete a continuous web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID.
func (client AppsClient) DeleteContinuousWebJob(resourceGroupName string, name string, webJobID string, webJobName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteContinuousWebJob")
	}

	req, err := client.DeleteContinuousWebJobPreparer(resourceGroupName, name, webJobID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteContinuousWebJobSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteContinuousWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJob", resp, "Failure responding to request")
	}

	return
}

// DeleteContinuousWebJobPreparer prepares the DeleteContinuousWebJob request.
func (client AppsClient) DeleteContinuousWebJobPreparer(resourceGroupName string, name string, webJobID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteContinuousWebJobSender sends the DeleteContinuousWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteContinuousWebJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteContinuousWebJobResponder handles the response to the DeleteContinuousWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteContinuousWebJobResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteContinuousWebJobSlot delete a continuous web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteContinuousWebJobSlot(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteContinuousWebJobSlot")
	}

	req, err := client.DeleteContinuousWebJobSlotPreparer(resourceGroupName, name, webJobID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteContinuousWebJobSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteContinuousWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteContinuousWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteContinuousWebJobSlotPreparer prepares the DeleteContinuousWebJobSlot request.
func (client AppsClient) DeleteContinuousWebJobSlotPreparer(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteContinuousWebJobSlotSender sends the DeleteContinuousWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteContinuousWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteContinuousWebJobSlotResponder handles the response to the DeleteContinuousWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteContinuousWebJobSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeployment delete a deployment by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is
// deployment ID.
func (client AppsClient) DeleteDeployment(resourceGroupName string, name string, ID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDeployment")
	}

	req, err := client.DeleteDeploymentPreparer(resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeployment", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentPreparer prepares the DeleteDeployment request.
func (client AppsClient) DeleteDeploymentPreparer(resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSender sends the DeleteDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentResponder handles the response to the DeleteDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDeploymentSlot delete a deployment by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is
// deployment ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteDeploymentSlot(resourceGroupName string, name string, ID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDeploymentSlot")
	}

	req, err := client.DeleteDeploymentSlotPreparer(resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDeploymentSlotPreparer prepares the DeleteDeploymentSlot request.
func (client AppsClient) DeleteDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDeploymentSlotSender sends the DeleteDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentSlotResponder handles the response to the DeleteDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDeploymentSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifier deletes a domain ownership identifier for a web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier.
func (client AppsClient) DeleteDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier")
	}

	req, err := client.DeleteDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierPreparer prepares the DeleteDomainOwnershipIdentifier request.
func (client AppsClient) DeleteDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDomainOwnershipIdentifierSender sends the DeleteDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteDomainOwnershipIdentifierResponder handles the response to the DeleteDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteDomainOwnershipIdentifierSlot deletes a domain ownership identifier for a web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier. slot is name of the deployment slot. If a slot
// is not specified, the API will delete the binding for the production slot.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot")
	}

	req, err := client.DeleteDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteDomainOwnershipIdentifierSlotPreparer prepares the DeleteDomainOwnershipIdentifierSlot request.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteDomainOwnershipIdentifierSlotSender sends the DeleteDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteDomainOwnershipIdentifierSlotResponder handles the response to the DeleteDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteFunction delete a function for web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name.
func (client AppsClient) DeleteFunction(resourceGroupName string, name string, functionName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteFunction")
	}

	req, err := client.DeleteFunctionPreparer(resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteFunctionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteFunction", resp, "Failure responding to request")
	}

	return
}

// DeleteFunctionPreparer prepares the DeleteFunction request.
func (client AppsClient) DeleteFunctionPreparer(resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteFunctionSender sends the DeleteFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteFunctionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteFunctionResponder handles the response to the DeleteFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteFunctionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBinding deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. hostName is
// hostname in the hostname binding.
func (client AppsClient) DeleteHostNameBinding(resourceGroupName string, name string, hostName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHostNameBinding")
	}

	req, err := client.DeleteHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingPreparer prepares the DeleteHostNameBinding request.
func (client AppsClient) DeleteHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHostNameBindingSender sends the DeleteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostNameBindingResponder handles the response to the DeleteHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHostNameBindingSlot deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// hostName is hostname in the hostname binding.
func (client AppsClient) DeleteHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHostNameBindingSlot")
	}

	req, err := client.DeleteHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHostNameBindingSlotPreparer prepares the DeleteHostNameBindingSlot request.
func (client AppsClient) DeleteHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHostNameBindingSlotSender sends the DeleteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHostNameBindingSlotResponder handles the response to the DeleteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHostNameBindingSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnection removes a Hybrid Connection from this site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
func (client AppsClient) DeleteHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHybridConnection")
	}

	req, err := client.DeleteHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionPreparer prepares the DeleteHybridConnection request.
func (client AppsClient) DeleteHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHybridConnectionSender sends the DeleteHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionResponder handles the response to the DeleteHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnectionSlot removes a Hybrid Connection from this site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
// slot is the name of the slot for the web app.
func (client AppsClient) DeleteHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteHybridConnectionSlot")
	}

	req, err := client.DeleteHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionSlotPreparer prepares the DeleteHybridConnectionSlot request.
func (client AppsClient) DeleteHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHybridConnectionSlotSender sends the DeleteHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionSlotResponder handles the response to the DeleteHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteHybridConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceFunctionSlot delete a function for web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteInstanceFunctionSlot(resourceGroupName string, name string, functionName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteInstanceFunctionSlot")
	}

	req, err := client.DeleteInstanceFunctionSlotPreparer(resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceFunctionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceFunctionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceFunctionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceFunctionSlotPreparer prepares the DeleteInstanceFunctionSlot request.
func (client AppsClient) DeleteInstanceFunctionSlotPreparer(resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceFunctionSlotSender sends the DeleteInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceFunctionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceFunctionSlotResponder handles the response to the DeleteInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceFunctionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceProcess terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON response from
// "GET api/sites/{siteName}/instances".
func (client AppsClient) DeleteInstanceProcess(resourceGroupName string, name string, processID string, instanceID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteInstanceProcess")
	}

	req, err := client.DeleteInstanceProcessPreparer(resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceProcessSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcess", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceProcessPreparer prepares the DeleteInstanceProcess request.
func (client AppsClient) DeleteInstanceProcessPreparer(resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceProcessSender sends the DeleteInstanceProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceProcessSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceProcessResponder handles the response to the DeleteInstanceProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceProcessResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteInstanceProcessSlot terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) DeleteInstanceProcessSlot(resourceGroupName string, name string, processID string, slot string, instanceID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteInstanceProcessSlot")
	}

	req, err := client.DeleteInstanceProcessSlotPreparer(resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceProcessSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteInstanceProcessSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteInstanceProcessSlotPreparer prepares the DeleteInstanceProcessSlot request.
func (client AppsClient) DeleteInstanceProcessSlotPreparer(resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteInstanceProcessSlotSender sends the DeleteInstanceProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteInstanceProcessSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceProcessSlotResponder handles the response to the DeleteInstanceProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteInstanceProcessSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOn delete a premier add-on from an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name.
func (client AppsClient) DeletePremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePremierAddOn")
	}

	req, err := client.DeletePremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOn", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnPreparer prepares the DeletePremierAddOn request.
func (client AppsClient) DeletePremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePremierAddOnSender sends the DeletePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeletePremierAddOnResponder handles the response to the DeletePremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePremierAddOnSlot delete a premier add-on from an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name. slot is name of the deployment slot. If a slot is not specified, the API will
// delete the named add-on for the production slot.
func (client AppsClient) DeletePremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePremierAddOnSlot")
	}

	req, err := client.DeletePremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// DeletePremierAddOnSlotPreparer prepares the DeletePremierAddOnSlot request.
func (client AppsClient) DeletePremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePremierAddOnSlotSender sends the DeletePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeletePremierAddOnSlotResponder handles the response to the DeletePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePremierAddOnSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteProcess terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out instance in
// a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
func (client AppsClient) DeleteProcess(resourceGroupName string, name string, processID string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteProcess")
	}

	req, err := client.DeleteProcessPreparer(resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteProcessSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcess", resp, "Failure responding to request")
	}

	return
}

// DeleteProcessPreparer prepares the DeleteProcess request.
func (client AppsClient) DeleteProcessPreparer(resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteProcessSender sends the DeleteProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteProcessSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteProcessResponder handles the response to the DeleteProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteProcessResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteProcessSlot terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot.
func (client AppsClient) DeleteProcessSlot(resourceGroupName string, name string, processID string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteProcessSlot")
	}

	req, err := client.DeleteProcessSlotPreparer(resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteProcessSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteProcessSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteProcessSlotPreparer prepares the DeleteProcessSlot request.
func (client AppsClient) DeleteProcessSlotPreparer(resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteProcessSlotSender sends the DeleteProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteProcessSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteProcessSlotResponder handles the response to the DeleteProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteProcessSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePublicCertificate deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publicCertificateName is public certificate name.
func (client AppsClient) DeletePublicCertificate(resourceGroupName string, name string, publicCertificateName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePublicCertificate")
	}

	req, err := client.DeletePublicCertificatePreparer(resourceGroupName, name, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePublicCertificateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificate", resp, "Failure responding to request")
	}

	return
}

// DeletePublicCertificatePreparer prepares the DeletePublicCertificate request.
func (client AppsClient) DeletePublicCertificatePreparer(resourceGroupName string, name string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePublicCertificateSender sends the DeletePublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePublicCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeletePublicCertificateResponder handles the response to the DeletePublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePublicCertificateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePublicCertificateSlot deletes a hostname binding for an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
// publicCertificateName is public certificate name.
func (client AppsClient) DeletePublicCertificateSlot(resourceGroupName string, name string, slot string, publicCertificateName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeletePublicCertificateSlot")
	}

	req, err := client.DeletePublicCertificateSlotPreparer(resourceGroupName, name, slot, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePublicCertificateSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeletePublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// DeletePublicCertificateSlotPreparer prepares the DeletePublicCertificateSlot request.
func (client AppsClient) DeletePublicCertificateSlotPreparer(resourceGroupName string, name string, slot string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeletePublicCertificateSlotSender sends the DeletePublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeletePublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeletePublicCertificateSlotResponder handles the response to the DeletePublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeletePublicCertificateSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnection deletes a relay service connection by its name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection configuration.
func (client AppsClient) DeleteRelayServiceConnection(resourceGroupName string, name string, entityName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteRelayServiceConnection")
	}

	req, err := client.DeleteRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionPreparer prepares the DeleteRelayServiceConnection request.
func (client AppsClient) DeleteRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteRelayServiceConnectionSender sends the DeleteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteRelayServiceConnectionResponder handles the response to the DeleteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteRelayServiceConnectionSlot deletes a relay service connection by its name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection configuration. slot is name of the deployment slot. If a slot is not specified, the
// API will delete a hybrid connection for the production slot.
func (client AppsClient) DeleteRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot")
	}

	req, err := client.DeleteRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteRelayServiceConnectionSlotPreparer prepares the DeleteRelayServiceConnectionSlot request.
func (client AppsClient) DeleteRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteRelayServiceConnectionSlotSender sends the DeleteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteRelayServiceConnectionSlotResponder handles the response to the DeleteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteRelayServiceConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSiteExtension remove a site extension from a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name.
func (client AppsClient) DeleteSiteExtension(resourceGroupName string, name string, siteExtensionID string, extensionName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSiteExtension")
	}

	req, err := client.DeleteSiteExtensionPreparer(resourceGroupName, name, siteExtensionID, extensionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteExtensionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteExtensionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtension", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteExtensionPreparer prepares the DeleteSiteExtension request.
func (client AppsClient) DeleteSiteExtensionPreparer(resourceGroupName string, name string, siteExtensionID string, extensionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteExtensionSender sends the DeleteSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSiteExtensionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteExtensionResponder handles the response to the DeleteSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSiteExtensionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSiteExtensionSlot remove a site extension from a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment
// for the production slot.
func (client AppsClient) DeleteSiteExtensionSlot(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSiteExtensionSlot")
	}

	req, err := client.DeleteSiteExtensionSlotPreparer(resourceGroupName, name, siteExtensionID, slot, extensionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteExtensionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteExtensionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSiteExtensionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSiteExtensionSlotPreparer prepares the DeleteSiteExtensionSlot request.
func (client AppsClient) DeleteSiteExtensionSlotPreparer(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSiteExtensionSlotSender sends the DeleteSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSiteExtensionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteExtensionSlotResponder handles the response to the DeleteSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSiteExtensionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSlot deletes a web, mobile, or API app, or one of the deployment slots.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app to delete.
// slot is name of the deployment slot to delete. By default, the API deletes the production slot. deleteMetrics is if
// true, web app metrics are also deleted. deleteEmptyServerFarm is specify true if the App Service plan will be empty
// after app deletion and you want to delete the empty App Service plan. By default, the empty App Service plan is not
// deleted. skipDNSRegistration is if true, DNS registration is skipped.
func (client AppsClient) DeleteSlot(resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSlot")
	}

	req, err := client.DeleteSlotPreparer(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSlotPreparer prepares the DeleteSlot request.
func (client AppsClient) DeleteSlotPreparer(resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool, skipDNSRegistration *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if deleteMetrics != nil {
		queryParameters["deleteMetrics"] = autorest.Encode("query", *deleteMetrics)
	}
	if deleteEmptyServerFarm != nil {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", *deleteEmptyServerFarm)
	}
	if skipDNSRegistration != nil {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", *skipDNSRegistration)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSlotSender sends the DeleteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteSlotResponder handles the response to the DeleteSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControl deletes the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) DeleteSourceControl(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSourceControl")
	}

	req, err := client.DeleteSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControl", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlPreparer prepares the DeleteSourceControl request.
func (client AppsClient) DeleteSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSourceControlSender sends the DeleteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteSourceControlResponder handles the response to the DeleteSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteSourceControlSlot deletes the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will delete the source control configuration for the
// production slot.
func (client AppsClient) DeleteSourceControlSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteSourceControlSlot")
	}

	req, err := client.DeleteSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSourceControlSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteSourceControlSlotPreparer prepares the DeleteSourceControlSlot request.
func (client AppsClient) DeleteSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSourceControlSlotSender sends the DeleteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteSourceControlSlotResponder handles the response to the DeleteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteSourceControlSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteTriggeredWebJob delete a triggered web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID.
func (client AppsClient) DeleteTriggeredWebJob(resourceGroupName string, name string, webJobID string, webJobName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteTriggeredWebJob")
	}

	req, err := client.DeleteTriggeredWebJobPreparer(resourceGroupName, name, webJobID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteTriggeredWebJobSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteTriggeredWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJob", resp, "Failure responding to request")
	}

	return
}

// DeleteTriggeredWebJobPreparer prepares the DeleteTriggeredWebJob request.
func (client AppsClient) DeleteTriggeredWebJobPreparer(resourceGroupName string, name string, webJobID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteTriggeredWebJobSender sends the DeleteTriggeredWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteTriggeredWebJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteTriggeredWebJobResponder handles the response to the DeleteTriggeredWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteTriggeredWebJobResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteTriggeredWebJobSlot delete a triggered web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) DeleteTriggeredWebJobSlot(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot")
	}

	req, err := client.DeleteTriggeredWebJobSlotPreparer(resourceGroupName, name, webJobID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteTriggeredWebJobSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteTriggeredWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteTriggeredWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteTriggeredWebJobSlotPreparer prepares the DeleteTriggeredWebJobSlot request.
func (client AppsClient) DeleteTriggeredWebJobSlotPreparer(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteTriggeredWebJobSlotSender sends the DeleteTriggeredWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteTriggeredWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteTriggeredWebJobSlotResponder handles the response to the DeleteTriggeredWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteTriggeredWebJobSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnection deletes a connection from an app (or deployment slot to a named virtual network.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the virtual network.
func (client AppsClient) DeleteVnetConnection(resourceGroupName string, name string, vnetName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteVnetConnection")
	}

	req, err := client.DeleteVnetConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionPreparer prepares the DeleteVnetConnection request.
func (client AppsClient) DeleteVnetConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteVnetConnectionSender sends the DeleteVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetConnectionResponder handles the response to the DeleteVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetConnectionSlot deletes a connection from an app (or deployment slot to a named virtual network.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the virtual network. slot is name of the deployment slot. If a slot is not specified, the API will delete
// the connection for the production slot.
func (client AppsClient) DeleteVnetConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DeleteVnetConnectionSlot")
	}

	req, err := client.DeleteVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DeleteVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetConnectionSlotPreparer prepares the DeleteVnetConnectionSlot request.
func (client AppsClient) DeleteVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteVnetConnectionSlotSender sends the DeleteVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetConnectionSlotResponder handles the response to the DeleteVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteVnetConnectionSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DiscoverRestore discovers an existing app backup that can be restored from a blob in Azure storage.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. request is a
// RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
func (client AppsClient) DiscoverRestore(resourceGroupName string, name string, request RestoreRequest) (result RestoreRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DiscoverRestore")
	}

	req, err := client.DiscoverRestorePreparer(resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverRestoreSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverRestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestore", resp, "Failure responding to request")
	}

	return
}

// DiscoverRestorePreparer prepares the DiscoverRestore request.
func (client AppsClient) DiscoverRestorePreparer(resourceGroupName string, name string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverRestoreSender sends the DiscoverRestore request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverRestoreSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DiscoverRestoreResponder handles the response to the DiscoverRestore request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverRestoreResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverRestoreSlot discovers an existing app backup that can be restored from a blob in Azure storage.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. request is a
// RestoreRequest object that includes Azure storage URL and blog name for discovery of backup. slot is name of the
// deployment slot. If a slot is not specified, the API will perform discovery for the production slot.
func (client AppsClient) DiscoverRestoreSlot(resourceGroupName string, name string, request RestoreRequest, slot string) (result RestoreRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "DiscoverRestoreSlot")
	}

	req, err := client.DiscoverRestoreSlotPreparer(resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverRestoreSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverRestoreSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "DiscoverRestoreSlot", resp, "Failure responding to request")
	}

	return
}

// DiscoverRestoreSlotPreparer prepares the DiscoverRestoreSlot request.
func (client AppsClient) DiscoverRestoreSlotPreparer(resourceGroupName string, name string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DiscoverRestoreSlotSender sends the DiscoverRestoreSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DiscoverRestoreSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DiscoverRestoreSlotResponder handles the response to the DiscoverRestoreSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) DiscoverRestoreSlotResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPassword generates a new publishing password for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GenerateNewSitePublishingPassword(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GenerateNewSitePublishingPassword")
	}

	req, err := client.GenerateNewSitePublishingPasswordPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPassword", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordPreparer prepares the GenerateNewSitePublishingPassword request.
func (client AppsClient) GenerateNewSitePublishingPasswordPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSender sends the GenerateNewSitePublishingPassword request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordResponder handles the response to the GenerateNewSitePublishingPassword request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GenerateNewSitePublishingPasswordSlot generates a new publishing password for an app (or deployment slot, if
// specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API generate a new publishing password for the production
// slot.
func (client AppsClient) GenerateNewSitePublishingPasswordSlot(resourceGroupName string, name string, slot string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot")
	}

	req, err := client.GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSlotSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure responding to request")
	}

	return
}

// GenerateNewSitePublishingPasswordSlotPreparer prepares the GenerateNewSitePublishingPasswordSlot request.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GenerateNewSitePublishingPasswordSlotSender sends the GenerateNewSitePublishingPasswordSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordSlotResponder handles the response to the GenerateNewSitePublishingPasswordSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GenerateNewSitePublishingPasswordSlotResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the details of a web, mobile, or API app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) Get(resourceGroupName string, name string) (result Site, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppsClient) GetPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettings gets the Authentication/Authorization settings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GetAuthSettings(resourceGroupName string, name string) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetAuthSettings")
	}

	req, err := client.GetAuthSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettings", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsPreparer prepares the GetAuthSettings request.
func (client AppsClient) GetAuthSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetAuthSettingsSender sends the GetAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAuthSettingsResponder handles the response to the GetAuthSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAuthSettingsSlot gets the Authentication/Authorization settings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the settings for the production slot.
func (client AppsClient) GetAuthSettingsSlot(resourceGroupName string, name string, slot string) (result SiteAuthSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetAuthSettingsSlot")
	}

	req, err := client.GetAuthSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetAuthSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// GetAuthSettingsSlotPreparer prepares the GetAuthSettingsSlot request.
func (client AppsClient) GetAuthSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetAuthSettingsSlotSender sends the GetAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAuthSettingsSlotResponder handles the response to the GetAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfiguration gets the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GetBackupConfiguration(resourceGroupName string, name string) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupConfiguration")
	}

	req, err := client.GetBackupConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationPreparer prepares the GetBackupConfiguration request.
func (client AppsClient) GetBackupConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupConfigurationSender sends the GetBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetBackupConfigurationResponder handles the response to the GetBackupConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupConfigurationSlot gets the backup configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the backup configuration for the production
// slot.
func (client AppsClient) GetBackupConfigurationSlot(resourceGroupName string, name string, slot string) (result BackupRequest, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupConfigurationSlot")
	}

	req, err := client.GetBackupConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupConfigurationSlotPreparer prepares the GetBackupConfigurationSlot request.
func (client AppsClient) GetBackupConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupConfigurationSlotSender sends the GetBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetBackupConfigurationSlotResponder handles the response to the GetBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatus gets a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. backupID is
// ID of the backup.
func (client AppsClient) GetBackupStatus(resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupStatus")
	}

	req, err := client.GetBackupStatusPreparer(resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatus", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusPreparer prepares the GetBackupStatus request.
func (client AppsClient) GetBackupStatusPreparer(resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupStatusSender sends the GetBackupStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetBackupStatusResponder handles the response to the GetBackupStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupStatusSlot gets a backup of an app by its ID.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. backupID is
// ID of the backup. slot is name of the deployment slot. If a slot is not specified, the API will get a backup of the
// production slot.
func (client AppsClient) GetBackupStatusSlot(resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetBackupStatusSlot")
	}

	req, err := client.GetBackupStatusSlotPreparer(resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetBackupStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetBackupStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetBackupStatusSlotPreparer prepares the GetBackupStatusSlot request.
func (client AppsClient) GetBackupStatusSlotPreparer(resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetBackupStatusSlotSender sends the GetBackupStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetBackupStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetBackupStatusSlotResponder handles the response to the GetBackupStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetBackupStatusSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfiguration gets the configuration of an app, such as platform version and bitness, default documents, virtual
// applications, Always On, etc.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GetConfiguration(resourceGroupName string, name string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfiguration")
	}

	req, err := client.GetConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationPreparer prepares the GetConfiguration request.
func (client AppsClient) GetConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSender sends the GetConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationResponder handles the response to the GetConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSlot gets the configuration of an app, such as platform version and bitness, default documents,
// virtual applications, Always On, etc.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
func (client AppsClient) GetConfigurationSlot(resourceGroupName string, name string, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSlot")
	}

	req, err := client.GetConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSlotPreparer prepares the GetConfigurationSlot request.
func (client AppsClient) GetConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSlotSender sends the GetConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSlotResponder handles the response to the GetConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshot gets a snapshot of the configuration of an app at a previous point in time.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. snapshotID
// is the ID of the snapshot to read.
func (client AppsClient) GetConfigurationSnapshot(resourceGroupName string, name string, snapshotID string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSnapshot")
	}

	req, err := client.GetConfigurationSnapshotPreparer(resourceGroupName, name, snapshotID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotPreparer prepares the GetConfigurationSnapshot request.
func (client AppsClient) GetConfigurationSnapshotPreparer(resourceGroupName string, name string, snapshotID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSnapshotSender sends the GetConfigurationSnapshot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSnapshotResponder handles the response to the GetConfigurationSnapshot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConfigurationSnapshotSlot gets a snapshot of the configuration of an app at a previous point in time.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. snapshotID
// is the ID of the snapshot to read. slot is name of the deployment slot. If a slot is not specified, the API will
// return configuration for the production slot.
func (client AppsClient) GetConfigurationSnapshotSlot(resourceGroupName string, name string, snapshotID string, slot string) (result SiteConfigResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetConfigurationSnapshotSlot")
	}

	req, err := client.GetConfigurationSnapshotSlotPreparer(resourceGroupName, name, snapshotID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConfigurationSnapshotSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetConfigurationSnapshotSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetConfigurationSnapshotSlot", resp, "Failure responding to request")
	}

	return
}

// GetConfigurationSnapshotSlotPreparer prepares the GetConfigurationSnapshotSlot request.
func (client AppsClient) GetConfigurationSnapshotSlotPreparer(resourceGroupName string, name string, snapshotID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"snapshotId":        autorest.Encode("path", snapshotID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots/{snapshotId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetConfigurationSnapshotSlotSender sends the GetConfigurationSnapshotSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetConfigurationSnapshotSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetConfigurationSnapshotSlotResponder handles the response to the GetConfigurationSnapshotSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetConfigurationSnapshotSlotResponder(resp *http.Response) (result SiteConfigResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContinuousWebJob gets a continuous web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID.
func (client AppsClient) GetContinuousWebJob(resourceGroupName string, name string, webJobID string, webJobName string) (result ContinuousWebJob, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetContinuousWebJob")
	}

	req, err := client.GetContinuousWebJobPreparer(resourceGroupName, name, webJobID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContinuousWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetContinuousWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJob", resp, "Failure responding to request")
	}

	return
}

// GetContinuousWebJobPreparer prepares the GetContinuousWebJob request.
func (client AppsClient) GetContinuousWebJobPreparer(resourceGroupName string, name string, webJobID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetContinuousWebJobSender sends the GetContinuousWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContinuousWebJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetContinuousWebJobResponder handles the response to the GetContinuousWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContinuousWebJobResponder(resp *http.Response) (result ContinuousWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetContinuousWebJobSlot gets a continuous web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) GetContinuousWebJobSlot(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (result ContinuousWebJob, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetContinuousWebJobSlot")
	}

	req, err := client.GetContinuousWebJobSlotPreparer(resourceGroupName, name, webJobID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetContinuousWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetContinuousWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetContinuousWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetContinuousWebJobSlotPreparer prepares the GetContinuousWebJobSlot request.
func (client AppsClient) GetContinuousWebJobSlotPreparer(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetContinuousWebJobSlotSender sends the GetContinuousWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetContinuousWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetContinuousWebJobSlotResponder handles the response to the GetContinuousWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetContinuousWebJobSlotResponder(resp *http.Response) (result ContinuousWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployment get a deployment by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is
// deployment ID.
func (client AppsClient) GetDeployment(resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDeployment")
	}

	req, err := client.GetDeploymentPreparer(resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeployment", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentPreparer prepares the GetDeployment request.
func (client AppsClient) GetDeploymentPreparer(resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSender sends the GetDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentResponder handles the response to the GetDeployment request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentSlot get a deployment by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is
// deployment ID. slot is name of the deployment slot. If a slot is not specified, the API gets a deployment for the
// production slot.
func (client AppsClient) GetDeploymentSlot(resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDeploymentSlot")
	}

	req, err := client.GetDeploymentSlotPreparer(resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDeploymentSlot", resp, "Failure responding to request")
	}

	return
}

// GetDeploymentSlotPreparer prepares the GetDeploymentSlot request.
func (client AppsClient) GetDeploymentSlotPreparer(resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDeploymentSlotSender sends the GetDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentSlotResponder handles the response to the GetDeploymentSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfiguration gets the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GetDiagnosticLogsConfiguration(resourceGroupName string, name string) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration")
	}

	req, err := client.GetDiagnosticLogsConfigurationPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfiguration", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationPreparer prepares the GetDiagnosticLogsConfiguration request.
func (client AppsClient) GetDiagnosticLogsConfigurationPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDiagnosticLogsConfigurationSender sends the GetDiagnosticLogsConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDiagnosticLogsConfigurationResponder handles the response to the GetDiagnosticLogsConfiguration request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDiagnosticLogsConfigurationSlot gets the logging configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the logging configuration for the production
// slot.
func (client AppsClient) GetDiagnosticLogsConfigurationSlot(resourceGroupName string, name string, slot string) (result SiteLogsConfig, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot")
	}

	req, err := client.GetDiagnosticLogsConfigurationSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDiagnosticLogsConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDiagnosticLogsConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDiagnosticLogsConfigurationSlot", resp, "Failure responding to request")
	}

	return
}

// GetDiagnosticLogsConfigurationSlotPreparer prepares the GetDiagnosticLogsConfigurationSlot request.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDiagnosticLogsConfigurationSlotSender sends the GetDiagnosticLogsConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDiagnosticLogsConfigurationSlotResponder handles the response to the GetDiagnosticLogsConfigurationSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDiagnosticLogsConfigurationSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifier get domain ownership identifier for web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier.
func (client AppsClient) GetDomainOwnershipIdentifier(resourceGroupName string, name string, domainOwnershipIdentifierName string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDomainOwnershipIdentifier")
	}

	req, err := client.GetDomainOwnershipIdentifierPreparer(resourceGroupName, name, domainOwnershipIdentifierName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifier", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierPreparer prepares the GetDomainOwnershipIdentifier request.
func (client AppsClient) GetDomainOwnershipIdentifierPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDomainOwnershipIdentifierSender sends the GetDomainOwnershipIdentifier request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDomainOwnershipIdentifierResponder handles the response to the GetDomainOwnershipIdentifier request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomainOwnershipIdentifierSlot get domain ownership identifier for web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// domainOwnershipIdentifierName is name of domain ownership identifier. slot is name of the deployment slot. If a slot
// is not specified, the API will delete the binding for the production slot.
func (client AppsClient) GetDomainOwnershipIdentifierSlot(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result Identifier, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot")
	}

	req, err := client.GetDomainOwnershipIdentifierSlotPreparer(resourceGroupName, name, domainOwnershipIdentifierName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainOwnershipIdentifierSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainOwnershipIdentifierSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetDomainOwnershipIdentifierSlot", resp, "Failure responding to request")
	}

	return
}

// GetDomainOwnershipIdentifierSlotPreparer prepares the GetDomainOwnershipIdentifierSlot request.
func (client AppsClient) GetDomainOwnershipIdentifierSlotPreparer(resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainOwnershipIdentifierName": autorest.Encode("path", domainOwnershipIdentifierName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetDomainOwnershipIdentifierSlotSender sends the GetDomainOwnershipIdentifierSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetDomainOwnershipIdentifierSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetDomainOwnershipIdentifierSlotResponder handles the response to the GetDomainOwnershipIdentifierSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetDomainOwnershipIdentifierSlotResponder(resp *http.Response) (result Identifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunction get function information by its ID for web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name.
func (client AppsClient) GetFunction(resourceGroupName string, name string, functionName string) (result FunctionEnvelope, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetFunction")
	}

	req, err := client.GetFunctionPreparer(resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunction", resp, "Failure responding to request")
	}

	return
}

// GetFunctionPreparer prepares the GetFunction request.
func (client AppsClient) GetFunctionPreparer(resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetFunctionSender sends the GetFunction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionResponder handles the response to the GetFunction request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunctionsAdminToken fetch a short lived token that can be exchanged for a master key.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) GetFunctionsAdminToken(resourceGroupName string, name string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetFunctionsAdminToken")
	}

	req, err := client.GetFunctionsAdminTokenPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionsAdminTokenSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionsAdminTokenResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminToken", resp, "Failure responding to request")
	}

	return
}

// GetFunctionsAdminTokenPreparer prepares the GetFunctionsAdminToken request.
func (client AppsClient) GetFunctionsAdminTokenPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetFunctionsAdminTokenSender sends the GetFunctionsAdminToken request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionsAdminTokenSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionsAdminTokenResponder handles the response to the GetFunctionsAdminToken request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionsAdminTokenResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetFunctionsAdminTokenSlot fetch a short lived token that can be exchanged for a master key.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetFunctionsAdminTokenSlot(resourceGroupName string, name string, slot string) (result String, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot")
	}

	req, err := client.GetFunctionsAdminTokenSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetFunctionsAdminTokenSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetFunctionsAdminTokenSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetFunctionsAdminTokenSlot", resp, "Failure responding to request")
	}

	return
}

// GetFunctionsAdminTokenSlotPreparer prepares the GetFunctionsAdminTokenSlot request.
func (client AppsClient) GetFunctionsAdminTokenSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/admin/token", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetFunctionsAdminTokenSlotSender sends the GetFunctionsAdminTokenSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetFunctionsAdminTokenSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetFunctionsAdminTokenSlotResponder handles the response to the GetFunctionsAdminTokenSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetFunctionsAdminTokenSlotResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBinding get the named hostname binding for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. hostName is
// hostname in the hostname binding.
func (client AppsClient) GetHostNameBinding(resourceGroupName string, name string, hostName string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHostNameBinding")
	}

	req, err := client.GetHostNameBindingPreparer(resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBinding", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingPreparer prepares the GetHostNameBinding request.
func (client AppsClient) GetHostNameBindingPreparer(resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostNameBindingSender sends the GetHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHostNameBindingResponder handles the response to the GetHostNameBinding request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHostNameBindingSlot get the named hostname binding for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API the named binding for the production slot. hostName is
// hostname in the hostname binding.
func (client AppsClient) GetHostNameBindingSlot(resourceGroupName string, name string, slot string, hostName string) (result HostNameBinding, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHostNameBindingSlot")
	}

	req, err := client.GetHostNameBindingSlotPreparer(resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHostNameBindingSlot", resp, "Failure responding to request")
	}

	return
}

// GetHostNameBindingSlotPreparer prepares the GetHostNameBindingSlot request.
func (client AppsClient) GetHostNameBindingSlotPreparer(resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHostNameBindingSlotSender sends the GetHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHostNameBindingSlotResponder handles the response to the GetHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnection retrieves a specific Service Bus Hybrid Connection used by this Web App.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
func (client AppsClient) GetHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHybridConnection")
	}

	req, err := client.GetHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnection", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPreparer prepares the GetHybridConnection request.
func (client AppsClient) GetHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionSender sends the GetHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionResponder handles the response to the GetHybridConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnectionSlot retrieves a specific Service Bus Hybrid Connection used by this Web App.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
// slot is the name of the slot for the web app.
func (client AppsClient) GetHybridConnectionSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetHybridConnectionSlot")
	}

	req, err := client.GetHybridConnectionSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetHybridConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionSlotPreparer prepares the GetHybridConnectionSlot request.
func (client AppsClient) GetHybridConnectionSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionSlotSender sends the GetHybridConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetHybridConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionSlotResponder handles the response to the GetHybridConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetHybridConnectionSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceFunctionSlot get function information by its ID for web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) GetInstanceFunctionSlot(resourceGroupName string, name string, functionName string, slot string) (result FunctionEnvelope, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceFunctionSlot")
	}

	req, err := client.GetInstanceFunctionSlotPreparer(resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceFunctionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceFunctionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceFunctionSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceFunctionSlotPreparer prepares the GetInstanceFunctionSlot request.
func (client AppsClient) GetInstanceFunctionSlotPreparer(resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceFunctionSlotSender sends the GetInstanceFunctionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceFunctionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceFunctionSlotResponder handles the response to the GetInstanceFunctionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceFunctionSlotResponder(resp *http.Response) (result FunctionEnvelope, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMSDeployLog get the MSDeploy Log for the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. instanceID
// is ID of web app instance.
func (client AppsClient) GetInstanceMSDeployLog(resourceGroupName string, name string, instanceID string) (result MSDeployLog, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceMSDeployLog")
	}

	req, err := client.GetInstanceMSDeployLogPreparer(resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMSDeployLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMSDeployLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLog", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMSDeployLogPreparer prepares the GetInstanceMSDeployLog request.
func (client AppsClient) GetInstanceMSDeployLogPreparer(resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceMSDeployLogSender sends the GetInstanceMSDeployLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMSDeployLogSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMSDeployLogResponder handles the response to the GetInstanceMSDeployLog request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMSDeployLogResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMSDeployLogSlot get the MSDeploy Log for the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. instanceID is ID of web app instance.
func (client AppsClient) GetInstanceMSDeployLogSlot(resourceGroupName string, name string, slot string, instanceID string) (result MSDeployLog, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot")
	}

	req, err := client.GetInstanceMSDeployLogSlotPreparer(resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMSDeployLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMSDeployLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMSDeployLogSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMSDeployLogSlotPreparer prepares the GetInstanceMSDeployLogSlot request.
func (client AppsClient) GetInstanceMSDeployLogSlotPreparer(resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceMSDeployLogSlotSender sends the GetInstanceMSDeployLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMSDeployLogSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMSDeployLogSlotResponder handles the response to the GetInstanceMSDeployLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMSDeployLogSlotResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMsDeployStatus get the status of the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. instanceID
// is ID of web app instance.
func (client AppsClient) GetInstanceMsDeployStatus(resourceGroupName string, name string, instanceID string) (result MSDeployStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceMsDeployStatus")
	}

	req, err := client.GetInstanceMsDeployStatusPreparer(resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMsDeployStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMsDeployStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatus", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMsDeployStatusPreparer prepares the GetInstanceMsDeployStatus request.
func (client AppsClient) GetInstanceMsDeployStatusPreparer(resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceMsDeployStatusSender sends the GetInstanceMsDeployStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMsDeployStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMsDeployStatusResponder handles the response to the GetInstanceMsDeployStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMsDeployStatusResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceMsDeployStatusSlot get the status of the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. instanceID is ID of web app instance.
func (client AppsClient) GetInstanceMsDeployStatusSlot(resourceGroupName string, name string, slot string, instanceID string) (result MSDeployStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot")
	}

	req, err := client.GetInstanceMsDeployStatusSlotPreparer(resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceMsDeployStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceMsDeployStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceMsDeployStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceMsDeployStatusSlotPreparer prepares the GetInstanceMsDeployStatusSlot request.
func (client AppsClient) GetInstanceMsDeployStatusSlotPreparer(resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceMsDeployStatusSlotSender sends the GetInstanceMsDeployStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceMsDeployStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceMsDeployStatusSlotResponder handles the response to the GetInstanceMsDeployStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceMsDeployStatusSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcess get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON response from
// "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcess(resourceGroupName string, name string, processID string, instanceID string) (result ProcessInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcess")
	}

	req, err := client.GetInstanceProcessPreparer(resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcess", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessPreparer prepares the GetInstanceProcess request.
func (client AppsClient) GetInstanceProcessPreparer(resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessSender sends the GetInstanceProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessResponder handles the response to the GetInstanceProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessDump get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON response from
// "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessDump(resourceGroupName string, name string, processID string, instanceID string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessDump")
	}

	req, err := client.GetInstanceProcessDumpPreparer(resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessDumpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessDumpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDump", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessDumpPreparer prepares the GetInstanceProcessDump request.
func (client AppsClient) GetInstanceProcessDumpPreparer(resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessDumpSender sends the GetInstanceProcessDump request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessDumpSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessDumpResponder handles the response to the GetInstanceProcessDump request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessDumpResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessDumpSlot get a memory dump of a process by its ID for a specific scaled-out instance in a web
// site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessDumpSlot(resourceGroupName string, name string, processID string, slot string, instanceID string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessDumpSlot")
	}

	req, err := client.GetInstanceProcessDumpSlotPreparer(resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessDumpSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessDumpSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessDumpSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessDumpSlotPreparer prepares the GetInstanceProcessDumpSlot request.
func (client AppsClient) GetInstanceProcessDumpSlotPreparer(resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessDumpSlotSender sends the GetInstanceProcessDumpSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessDumpSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessDumpSlotResponder handles the response to the GetInstanceProcessDumpSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessDumpSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessModule get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// baseAddress is module base address. instanceID is ID of a specific scaled-out instance. This is the value of the
// name property in the JSON response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessModule(resourceGroupName string, name string, processID string, baseAddress string, instanceID string, baseAddress1 string) (result ProcessModuleInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessModule")
	}

	req, err := client.GetInstanceProcessModulePreparer(resourceGroupName, name, processID, baseAddress, instanceID, baseAddress1)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessModuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessModuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModule", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessModulePreparer prepares the GetInstanceProcessModule request.
func (client AppsClient) GetInstanceProcessModulePreparer(resourceGroupName string, name string, processID string, baseAddress string, instanceID string, baseAddress1 string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"base_address":      autorest.Encode("path", baseAddress1),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"baseAddress": autorest.Encode("query", baseAddress),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{base_address}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessModuleSender sends the GetInstanceProcessModule request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessModuleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessModuleResponder handles the response to the GetInstanceProcessModule request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessModuleResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessModuleSlot get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// baseAddress is module base address. slot is name of the deployment slot. If a slot is not specified, the API returns
// deployments for the production slot. instanceID is ID of a specific scaled-out instance. This is the value of the
// name property in the JSON response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessModuleSlot(resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string, baseAddress1 string) (result ProcessModuleInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessModuleSlot")
	}

	req, err := client.GetInstanceProcessModuleSlotPreparer(resourceGroupName, name, processID, baseAddress, slot, instanceID, baseAddress1)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessModuleSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessModuleSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessModuleSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessModuleSlotPreparer prepares the GetInstanceProcessModuleSlot request.
func (client AppsClient) GetInstanceProcessModuleSlotPreparer(resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string, baseAddress1 string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"base_address":      autorest.Encode("path", baseAddress1),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"baseAddress": autorest.Encode("query", baseAddress),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules/{base_address}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessModuleSlotSender sends the GetInstanceProcessModuleSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessModuleSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessModuleSlotResponder handles the response to the GetInstanceProcessModuleSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessModuleSlotResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessSlot get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessSlot(resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessSlot")
	}

	req, err := client.GetInstanceProcessSlotPreparer(resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessSlotPreparer prepares the GetInstanceProcessSlot request.
func (client AppsClient) GetInstanceProcessSlotPreparer(resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessSlotSender sends the GetInstanceProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessSlotResponder handles the response to the GetInstanceProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessSlotResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessThread get thread information by Thread ID for a specific process, in a specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// threadID is tID. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the
// JSON response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessThread(resourceGroupName string, name string, processID string, threadID string, instanceID string) (result ProcessThreadInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessThread")
	}

	req, err := client.GetInstanceProcessThreadPreparer(resourceGroupName, name, processID, threadID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThread", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessThreadSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThread", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessThreadResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThread", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessThreadPreparer prepares the GetInstanceProcessThread request.
func (client AppsClient) GetInstanceProcessThreadPreparer(resourceGroupName string, name string, processID string, threadID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"threadId":          autorest.Encode("path", threadID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads/{threadId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessThreadSender sends the GetInstanceProcessThread request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessThreadSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessThreadResponder handles the response to the GetInstanceProcessThread request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessThreadResponder(resp *http.Response) (result ProcessThreadInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceProcessThreadSlot get thread information by Thread ID for a specific process, in a specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// threadID is tID. slot is name of the deployment slot. If a slot is not specified, the API returns deployments for
// the production slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in
// the JSON response from "GET api/sites/{siteName}/instances".
func (client AppsClient) GetInstanceProcessThreadSlot(resourceGroupName string, name string, processID string, threadID string, slot string, instanceID string) (result ProcessThreadInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetInstanceProcessThreadSlot")
	}

	req, err := client.GetInstanceProcessThreadSlotPreparer(resourceGroupName, name, processID, threadID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThreadSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceProcessThreadSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThreadSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceProcessThreadSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetInstanceProcessThreadSlot", resp, "Failure responding to request")
	}

	return
}

// GetInstanceProcessThreadSlotPreparer prepares the GetInstanceProcessThreadSlot request.
func (client AppsClient) GetInstanceProcessThreadSlotPreparer(resourceGroupName string, name string, processID string, threadID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"threadId":          autorest.Encode("path", threadID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads/{threadId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetInstanceProcessThreadSlotSender sends the GetInstanceProcessThreadSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetInstanceProcessThreadSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceProcessThreadSlotResponder handles the response to the GetInstanceProcessThreadSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetInstanceProcessThreadSlotResponder(resp *http.Response) (result ProcessThreadInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatus returns the status of MySql in app migration, if one is active, and whether or not MySql in
// app is enabled
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) GetMigrateMySQLStatus(resourceGroupName string, name string) (result MigrateMySQLStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMigrateMySQLStatus")
	}

	req, err := client.GetMigrateMySQLStatusPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatus", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusPreparer prepares the GetMigrateMySQLStatus request.
func (client AppsClient) GetMigrateMySQLStatusPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMigrateMySQLStatusSender sends the GetMigrateMySQLStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMigrateMySQLStatusResponder handles the response to the GetMigrateMySQLStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMigrateMySQLStatusSlot returns the status of MySql in app migration, if one is active, and whether or not MySql
// in app is enabled
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of the deployment slot.
func (client AppsClient) GetMigrateMySQLStatusSlot(resourceGroupName string, name string, slot string) (result MigrateMySQLStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot")
	}

	req, err := client.GetMigrateMySQLStatusSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMigrateMySQLStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMigrateMySQLStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMigrateMySQLStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetMigrateMySQLStatusSlotPreparer prepares the GetMigrateMySQLStatusSlot request.
func (client AppsClient) GetMigrateMySQLStatusSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/migratemysql/status", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMigrateMySQLStatusSlotSender sends the GetMigrateMySQLStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMigrateMySQLStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMigrateMySQLStatusSlotResponder handles the response to the GetMigrateMySQLStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMigrateMySQLStatusSlotResponder(resp *http.Response) (result MigrateMySQLStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployLog get the MSDeploy Log for the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) GetMSDeployLog(resourceGroupName string, name string) (result MSDeployLog, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMSDeployLog")
	}

	req, err := client.GetMSDeployLogPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLog", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployLogPreparer prepares the GetMSDeployLog request.
func (client AppsClient) GetMSDeployLogPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMSDeployLogSender sends the GetMSDeployLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployLogSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployLogResponder handles the response to the GetMSDeployLog request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployLogResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployLogSlot get the MSDeploy Log for the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetMSDeployLogSlot(resourceGroupName string, name string, slot string) (result MSDeployLog, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMSDeployLogSlot")
	}

	req, err := client.GetMSDeployLogSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployLogSlot", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployLogSlotPreparer prepares the GetMSDeployLogSlot request.
func (client AppsClient) GetMSDeployLogSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMSDeployLogSlotSender sends the GetMSDeployLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployLogSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployLogSlotResponder handles the response to the GetMSDeployLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployLogSlotResponder(resp *http.Response) (result MSDeployLog, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployStatus get the status of the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) GetMSDeployStatus(resourceGroupName string, name string) (result MSDeployStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMSDeployStatus")
	}

	req, err := client.GetMSDeployStatusPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatus", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployStatusPreparer prepares the GetMSDeployStatus request.
func (client AppsClient) GetMSDeployStatusPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMSDeployStatusSender sends the GetMSDeployStatus request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployStatusResponder handles the response to the GetMSDeployStatus request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployStatusResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMSDeployStatusSlot get the status of the last MSDeploy operation.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetMSDeployStatusSlot(resourceGroupName string, name string, slot string) (result MSDeployStatus, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetMSDeployStatusSlot")
	}

	req, err := client.GetMSDeployStatusSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMSDeployStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetMSDeployStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetMSDeployStatusSlot", resp, "Failure responding to request")
	}

	return
}

// GetMSDeployStatusSlotPreparer prepares the GetMSDeployStatusSlot request.
func (client AppsClient) GetMSDeployStatusSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/extensions/MSDeploy", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetMSDeployStatusSlotSender sends the GetMSDeployStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetMSDeployStatusSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetMSDeployStatusSlotResponder handles the response to the GetMSDeployStatusSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetMSDeployStatusSlotResponder(resp *http.Response) (result MSDeployStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOn gets a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name.
func (client AppsClient) GetPremierAddOn(resourceGroupName string, name string, premierAddOnName string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPremierAddOn")
	}

	req, err := client.GetPremierAddOnPreparer(resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOn", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnPreparer prepares the GetPremierAddOn request.
func (client AppsClient) GetPremierAddOnPreparer(resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPremierAddOnSender sends the GetPremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetPremierAddOnResponder handles the response to the GetPremierAddOn request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPremierAddOnSlot gets a named add-on of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// premierAddOnName is add-on name. slot is name of the deployment slot. If a slot is not specified, the API will get
// the named add-on for the production slot.
func (client AppsClient) GetPremierAddOnSlot(resourceGroupName string, name string, premierAddOnName string, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPremierAddOnSlot")
	}

	req, err := client.GetPremierAddOnSlotPreparer(resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPremierAddOnSlot", resp, "Failure responding to request")
	}

	return
}

// GetPremierAddOnSlotPreparer prepares the GetPremierAddOnSlot request.
func (client AppsClient) GetPremierAddOnSlotPreparer(resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPremierAddOnSlotSender sends the GetPremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetPremierAddOnSlotResponder handles the response to the GetPremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPremierAddOnSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcess get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
func (client AppsClient) GetProcess(resourceGroupName string, name string, processID string) (result ProcessInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcess")
	}

	req, err := client.GetProcessPreparer(resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcess", resp, "Failure responding to request")
	}

	return
}

// GetProcessPreparer prepares the GetProcess request.
func (client AppsClient) GetProcessPreparer(resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessSender sends the GetProcess request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessResponder handles the response to the GetProcess request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessDump get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
func (client AppsClient) GetProcessDump(resourceGroupName string, name string, processID string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessDump")
	}

	req, err := client.GetProcessDumpPreparer(resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessDumpSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessDumpResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDump", resp, "Failure responding to request")
	}

	return
}

// GetProcessDumpPreparer prepares the GetProcessDump request.
func (client AppsClient) GetProcessDumpPreparer(resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessDumpSender sends the GetProcessDump request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessDumpSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessDumpResponder handles the response to the GetProcessDump request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessDumpResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessDumpSlot get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot.
func (client AppsClient) GetProcessDumpSlot(resourceGroupName string, name string, processID string, slot string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessDumpSlot")
	}

	req, err := client.GetProcessDumpSlotPreparer(resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessDumpSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessDumpSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessDumpSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessDumpSlotPreparer prepares the GetProcessDumpSlot request.
func (client AppsClient) GetProcessDumpSlotPreparer(resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/dump", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessDumpSlotSender sends the GetProcessDumpSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessDumpSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessDumpSlotResponder handles the response to the GetProcessDumpSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessDumpSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessModule get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// baseAddress is module base address.
func (client AppsClient) GetProcessModule(resourceGroupName string, name string, processID string, baseAddress string, baseAddress1 string) (result ProcessModuleInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessModule")
	}

	req, err := client.GetProcessModulePreparer(resourceGroupName, name, processID, baseAddress, baseAddress1)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessModuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessModuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModule", resp, "Failure responding to request")
	}

	return
}

// GetProcessModulePreparer prepares the GetProcessModule request.
func (client AppsClient) GetProcessModulePreparer(resourceGroupName string, name string, processID string, baseAddress string, baseAddress1 string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"base_address":      autorest.Encode("path", baseAddress1),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"baseAddress": autorest.Encode("query", baseAddress),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{base_address}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessModuleSender sends the GetProcessModule request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessModuleSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessModuleResponder handles the response to the GetProcessModule request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessModuleResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessModuleSlot get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// baseAddress is module base address. slot is name of the deployment slot. If a slot is not specified, the API returns
// deployments for the production slot.
func (client AppsClient) GetProcessModuleSlot(resourceGroupName string, name string, processID string, baseAddress string, slot string, baseAddress1 string) (result ProcessModuleInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessModuleSlot")
	}

	req, err := client.GetProcessModuleSlotPreparer(resourceGroupName, name, processID, baseAddress, slot, baseAddress1)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessModuleSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessModuleSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessModuleSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessModuleSlotPreparer prepares the GetProcessModuleSlot request.
func (client AppsClient) GetProcessModuleSlotPreparer(resourceGroupName string, name string, processID string, baseAddress string, slot string, baseAddress1 string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"base_address":      autorest.Encode("path", baseAddress1),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"baseAddress": autorest.Encode("query", baseAddress),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules/{base_address}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessModuleSlotSender sends the GetProcessModuleSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessModuleSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessModuleSlotResponder handles the response to the GetProcessModuleSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessModuleSlotResponder(resp *http.Response) (result ProcessModuleInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessSlot get process information by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot.
func (client AppsClient) GetProcessSlot(resourceGroupName string, name string, processID string, slot string) (result ProcessInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessSlot")
	}

	req, err := client.GetProcessSlotPreparer(resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessSlotPreparer prepares the GetProcessSlot request.
func (client AppsClient) GetProcessSlotPreparer(resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessSlotSender sends the GetProcessSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessSlotResponder handles the response to the GetProcessSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessSlotResponder(resp *http.Response) (result ProcessInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessThread get thread information by Thread ID for a specific process, in a specific scaled-out instance in a
// web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// threadID is tID.
func (client AppsClient) GetProcessThread(resourceGroupName string, name string, processID string, threadID string) (result ProcessThreadInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessThread")
	}

	req, err := client.GetProcessThreadPreparer(resourceGroupName, name, processID, threadID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThread", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessThreadSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThread", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessThreadResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThread", resp, "Failure responding to request")
	}

	return
}

// GetProcessThreadPreparer prepares the GetProcessThread request.
func (client AppsClient) GetProcessThreadPreparer(resourceGroupName string, name string, processID string, threadID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"threadId":          autorest.Encode("path", threadID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads/{threadId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessThreadSender sends the GetProcessThread request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessThreadSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessThreadResponder handles the response to the GetProcessThread request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessThreadResponder(resp *http.Response) (result ProcessThreadInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProcessThreadSlot get thread information by Thread ID for a specific process, in a specific scaled-out instance
// in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// threadID is tID. slot is name of the deployment slot. If a slot is not specified, the API returns deployments for
// the production slot.
func (client AppsClient) GetProcessThreadSlot(resourceGroupName string, name string, processID string, threadID string, slot string) (result ProcessThreadInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetProcessThreadSlot")
	}

	req, err := client.GetProcessThreadSlotPreparer(resourceGroupName, name, processID, threadID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThreadSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProcessThreadSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThreadSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetProcessThreadSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetProcessThreadSlot", resp, "Failure responding to request")
	}

	return
}

// GetProcessThreadSlotPreparer prepares the GetProcessThreadSlot request.
func (client AppsClient) GetProcessThreadSlotPreparer(resourceGroupName string, name string, processID string, threadID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"threadId":          autorest.Encode("path", threadID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads/{threadId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetProcessThreadSlotSender sends the GetProcessThreadSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetProcessThreadSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetProcessThreadSlotResponder handles the response to the GetProcessThreadSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetProcessThreadSlotResponder(resp *http.Response) (result ProcessThreadInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicCertificate get the named public certificate for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publicCertificateName is public certificate name.
func (client AppsClient) GetPublicCertificate(resourceGroupName string, name string, publicCertificateName string) (result PublicCertificate, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPublicCertificate")
	}

	req, err := client.GetPublicCertificatePreparer(resourceGroupName, name, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicCertificateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicCertificateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificate", resp, "Failure responding to request")
	}

	return
}

// GetPublicCertificatePreparer prepares the GetPublicCertificate request.
func (client AppsClient) GetPublicCertificatePreparer(resourceGroupName string, name string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPublicCertificateSender sends the GetPublicCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPublicCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetPublicCertificateResponder handles the response to the GetPublicCertificate request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPublicCertificateResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublicCertificateSlot get the named public certificate for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API the named binding for the production slot.
// publicCertificateName is public certificate name.
func (client AppsClient) GetPublicCertificateSlot(resourceGroupName string, name string, slot string, publicCertificateName string) (result PublicCertificate, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetPublicCertificateSlot")
	}

	req, err := client.GetPublicCertificateSlotPreparer(resourceGroupName, name, slot, publicCertificateName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublicCertificateSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublicCertificateSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetPublicCertificateSlot", resp, "Failure responding to request")
	}

	return
}

// GetPublicCertificateSlotPreparer prepares the GetPublicCertificateSlot request.
func (client AppsClient) GetPublicCertificateSlotPreparer(resourceGroupName string, name string, slot string, publicCertificateName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                  autorest.Encode("path", name),
		"publicCertificateName": autorest.Encode("path", publicCertificateName),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"slot":                  autorest.Encode("path", slot),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates/{publicCertificateName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetPublicCertificateSlotSender sends the GetPublicCertificateSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPublicCertificateSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetPublicCertificateSlotResponder handles the response to the GetPublicCertificateSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPublicCertificateSlotResponder(resp *http.Response) (result PublicCertificate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnection gets a hybrid connection configuration by its name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection.
func (client AppsClient) GetRelayServiceConnection(resourceGroupName string, name string, entityName string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetRelayServiceConnection")
	}

	req, err := client.GetRelayServiceConnectionPreparer(resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnection", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionPreparer prepares the GetRelayServiceConnection request.
func (client AppsClient) GetRelayServiceConnectionPreparer(resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetRelayServiceConnectionSender sends the GetRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetRelayServiceConnectionResponder handles the response to the GetRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRelayServiceConnectionSlot gets a hybrid connection configuration by its name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. entityName
// is name of the hybrid connection. slot is name of the deployment slot. If a slot is not specified, the API will get
// a hybrid connection for the production slot.
func (client AppsClient) GetRelayServiceConnectionSlot(resourceGroupName string, name string, entityName string, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetRelayServiceConnectionSlot")
	}

	req, err := client.GetRelayServiceConnectionSlotPreparer(resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetRelayServiceConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetRelayServiceConnectionSlotPreparer prepares the GetRelayServiceConnectionSlot request.
func (client AppsClient) GetRelayServiceConnectionSlotPreparer(resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetRelayServiceConnectionSlotSender sends the GetRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetRelayServiceConnectionSlotResponder handles the response to the GetRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteExtension get site extension information by its ID for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name.
func (client AppsClient) GetSiteExtension(resourceGroupName string, name string, siteExtensionID string, extensionName string) (result SiteExtensionInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSiteExtension")
	}

	req, err := client.GetSiteExtensionPreparer(resourceGroupName, name, siteExtensionID, extensionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteExtensionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteExtensionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtension", resp, "Failure responding to request")
	}

	return
}

// GetSiteExtensionPreparer prepares the GetSiteExtension request.
func (client AppsClient) GetSiteExtensionPreparer(resourceGroupName string, name string, siteExtensionID string, extensionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteExtensionSender sends the GetSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSiteExtensionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteExtensionResponder handles the response to the GetSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSiteExtensionResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteExtensionSlot get site extension information by its ID for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment
// for the production slot.
func (client AppsClient) GetSiteExtensionSlot(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string) (result SiteExtensionInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSiteExtensionSlot")
	}

	req, err := client.GetSiteExtensionSlotPreparer(resourceGroupName, name, siteExtensionID, slot, extensionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteExtensionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteExtensionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSiteExtensionSlot", resp, "Failure responding to request")
	}

	return
}

// GetSiteExtensionSlotPreparer prepares the GetSiteExtensionSlot request.
func (client AppsClient) GetSiteExtensionSlotPreparer(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSiteExtensionSlotSender sends the GetSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSiteExtensionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSiteExtensionSlotResponder handles the response to the GetSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSiteExtensionSlotResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlag gets web app's event logs.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) GetSitePhpErrorLogFlag(resourceGroupName string, name string) (result SitePhpErrorLogFlag, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSitePhpErrorLogFlag")
	}

	req, err := client.GetSitePhpErrorLogFlagPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlag", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagPreparer prepares the GetSitePhpErrorLogFlag request.
func (client AppsClient) GetSitePhpErrorLogFlagPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePhpErrorLogFlagSender sends the GetSitePhpErrorLogFlag request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSitePhpErrorLogFlagResponder handles the response to the GetSitePhpErrorLogFlag request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePhpErrorLogFlagSlot gets web app's event logs.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot.
func (client AppsClient) GetSitePhpErrorLogFlagSlot(resourceGroupName string, name string, slot string) (result SitePhpErrorLogFlag, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot")
	}

	req, err := client.GetSitePhpErrorLogFlagSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePhpErrorLogFlagSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePhpErrorLogFlagSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSitePhpErrorLogFlagSlot", resp, "Failure responding to request")
	}

	return
}

// GetSitePhpErrorLogFlagSlotPreparer prepares the GetSitePhpErrorLogFlagSlot request.
func (client AppsClient) GetSitePhpErrorLogFlagSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSitePhpErrorLogFlagSlotSender sends the GetSitePhpErrorLogFlagSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSitePhpErrorLogFlagSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSitePhpErrorLogFlagSlotResponder handles the response to the GetSitePhpErrorLogFlagSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSitePhpErrorLogFlagSlotResponder(resp *http.Response) (result SitePhpErrorLogFlag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlot gets the details of a web, mobile, or API app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. By default, this API returns the production slot.
func (client AppsClient) GetSlot(resourceGroupName string, name string, slot string) (result Site, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSlot")
	}

	req, err := client.GetSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSlot", resp, "Failure responding to request")
	}

	return
}

// GetSlotPreparer prepares the GetSlot request.
func (client AppsClient) GetSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSlotSender sends the GetSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSlotResponder handles the response to the GetSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControl gets the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) GetSourceControl(resourceGroupName string, name string) (result SiteSourceControl, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSourceControl")
	}

	req, err := client.GetSourceControlPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControl", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlPreparer prepares the GetSourceControl request.
func (client AppsClient) GetSourceControlPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSourceControlSender sends the GetSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSourceControlResponder handles the response to the GetSourceControl request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSourceControlSlot gets the source control configuration of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the source control configuration for the
// production slot.
func (client AppsClient) GetSourceControlSlot(resourceGroupName string, name string, slot string) (result SiteSourceControl, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetSourceControlSlot")
	}

	req, err := client.GetSourceControlSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetSourceControlSlot", resp, "Failure responding to request")
	}

	return
}

// GetSourceControlSlotPreparer prepares the GetSourceControlSlot request.
func (client AppsClient) GetSourceControlSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSourceControlSlotSender sends the GetSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSourceControlSlotResponder handles the response to the GetSourceControlSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJob gets a triggered web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID.
func (client AppsClient) GetTriggeredWebJob(resourceGroupName string, name string, webJobID string, webJobName string) (result TriggeredWebJob, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetTriggeredWebJob")
	}

	req, err := client.GetTriggeredWebJobPreparer(resourceGroupName, name, webJobID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJob", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobPreparer prepares the GetTriggeredWebJob request.
func (client AppsClient) GetTriggeredWebJobPreparer(resourceGroupName string, name string, webJobID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTriggeredWebJobSender sends the GetTriggeredWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobResponder handles the response to the GetTriggeredWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobResponder(resp *http.Response) (result TriggeredWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobHistory gets a triggered web job's history by its ID for an app, , or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. ID is history ID.
func (client AppsClient) GetTriggeredWebJobHistory(resourceGroupName string, name string, webJobID string, ID string, webJobName string) (result TriggeredJobHistory, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetTriggeredWebJobHistory")
	}

	req, err := client.GetTriggeredWebJobHistoryPreparer(resourceGroupName, name, webJobID, ID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistory", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobHistoryPreparer prepares the GetTriggeredWebJobHistory request.
func (client AppsClient) GetTriggeredWebJobHistoryPreparer(resourceGroupName string, name string, webJobID string, ID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTriggeredWebJobHistorySender sends the GetTriggeredWebJobHistory request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobHistorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobHistoryResponder handles the response to the GetTriggeredWebJobHistory request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobHistoryResponder(resp *http.Response) (result TriggeredJobHistory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobHistorySlot gets a triggered web job's history by its ID for an app, , or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. ID is history ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a
// deployment for the production slot.
func (client AppsClient) GetTriggeredWebJobHistorySlot(resourceGroupName string, name string, webJobID string, ID string, slot string, webJobName string) (result TriggeredJobHistory, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot")
	}

	req, err := client.GetTriggeredWebJobHistorySlotPreparer(resourceGroupName, name, webJobID, ID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobHistorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobHistorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobHistorySlot", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobHistorySlotPreparer prepares the GetTriggeredWebJobHistorySlot request.
func (client AppsClient) GetTriggeredWebJobHistorySlotPreparer(resourceGroupName string, name string, webJobID string, ID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTriggeredWebJobHistorySlotSender sends the GetTriggeredWebJobHistorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobHistorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobHistorySlotResponder handles the response to the GetTriggeredWebJobHistorySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobHistorySlotResponder(resp *http.Response) (result TriggeredJobHistory, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTriggeredWebJobSlot gets a triggered web job by its ID for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) GetTriggeredWebJobSlot(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (result TriggeredWebJob, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetTriggeredWebJobSlot")
	}

	req, err := client.GetTriggeredWebJobSlotPreparer(resourceGroupName, name, webJobID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTriggeredWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetTriggeredWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetTriggeredWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetTriggeredWebJobSlotPreparer prepares the GetTriggeredWebJobSlot request.
func (client AppsClient) GetTriggeredWebJobSlotPreparer(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTriggeredWebJobSlotSender sends the GetTriggeredWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetTriggeredWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTriggeredWebJobSlotResponder handles the response to the GetTriggeredWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetTriggeredWebJobSlotResponder(resp *http.Response) (result TriggeredWebJob, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnection gets a virtual network the app (or deployment slot) is connected to by name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the virtual network.
func (client AppsClient) GetVnetConnection(resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnection")
	}

	req, err := client.GetVnetConnectionPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnection", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionPreparer prepares the GetVnetConnection request.
func (client AppsClient) GetVnetConnectionPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionSender sends the GetVnetConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionResponder handles the response to the GetVnetConnection request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGateway gets an app's Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the Virtual Network. gatewayName is name of the gateway. Currently, the only supported string is "primary".
func (client AppsClient) GetVnetConnectionGateway(resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionGateway")
	}

	req, err := client.GetVnetConnectionGatewayPreparer(resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGateway", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewayPreparer prepares the GetVnetConnectionGateway request.
func (client AppsClient) GetVnetConnectionGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionGatewaySender sends the GetVnetConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionGatewayResponder handles the response to the GetVnetConnectionGateway request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionGatewaySlot gets an app's Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the Virtual Network. gatewayName is name of the gateway. Currently, the only supported string is "primary".
// slot is name of the deployment slot. If a slot is not specified, the API will get a gateway for the production
// slot's Virtual Network.
func (client AppsClient) GetVnetConnectionGatewaySlot(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot")
	}

	req, err := client.GetVnetConnectionGatewaySlotPreparer(resourceGroupName, name, vnetName, gatewayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionGatewaySlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionGatewaySlotPreparer prepares the GetVnetConnectionGatewaySlot request.
func (client AppsClient) GetVnetConnectionGatewaySlotPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionGatewaySlotSender sends the GetVnetConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionGatewaySlotResponder handles the response to the GetVnetConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetConnectionSlot gets a virtual network the app (or deployment slot) is connected to by name.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. vnetName is
// name of the virtual network. slot is name of the deployment slot. If a slot is not specified, the API will get the
// named virtual network for the production slot.
func (client AppsClient) GetVnetConnectionSlot(resourceGroupName string, name string, vnetName string, slot string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetVnetConnectionSlot")
	}

	req, err := client.GetVnetConnectionSlotPreparer(resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetVnetConnectionSlot", resp, "Failure responding to request")
	}

	return
}

// GetVnetConnectionSlotPreparer prepares the GetVnetConnectionSlot request.
func (client AppsClient) GetVnetConnectionSlotPreparer(resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetConnectionSlotSender sends the GetVnetConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetVnetConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetConnectionSlotResponder handles the response to the GetVnetConnectionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetVnetConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebJob get webjob information for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobName is name
// of the web job.
func (client AppsClient) GetWebJob(resourceGroupName string, name string, webJobName string) (result Job, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetWebJob")
	}

	req, err := client.GetWebJobPreparer(resourceGroupName, name, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJob", resp, "Failure responding to request")
	}

	return
}

// GetWebJobPreparer prepares the GetWebJob request.
func (client AppsClient) GetWebJobPreparer(resourceGroupName string, name string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWebJobSender sends the GetWebJob request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetWebJobResponder handles the response to the GetWebJob request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebJobResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetWebJobSlot get webjob information for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobName is name
// of the web job. slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the
// production slot.
func (client AppsClient) GetWebJobSlot(resourceGroupName string, name string, webJobName string, slot string) (result Job, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "GetWebJobSlot")
	}

	req, err := client.GetWebJobSlotPreparer(resourceGroupName, name, webJobName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetWebJobSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetWebJobSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "GetWebJobSlot", resp, "Failure responding to request")
	}

	return
}

// GetWebJobSlotPreparer prepares the GetWebJobSlot request.
func (client AppsClient) GetWebJobSlotPreparer(resourceGroupName string, name string, webJobName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/webjobs/{webJobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetWebJobSlotSender sends the GetWebJobSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetWebJobSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetWebJobSlotResponder handles the response to the GetWebJobSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) GetWebJobSlotResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InstallSiteExtension install site extension on a web site, or a deployment slot. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name.
func (client AppsClient) InstallSiteExtension(resourceGroupName string, name string, siteExtensionID string, extensionName string, cancel <-chan struct{}) (<-chan SiteExtensionInfo, <-chan error) {
	resultChan := make(chan SiteExtensionInfo, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "InstallSiteExtension")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteExtensionInfo
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.InstallSiteExtensionPreparer(resourceGroupName, name, siteExtensionID, extensionName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtension", nil, "Failure preparing request")
			return
		}

		resp, err := client.InstallSiteExtensionSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtension", resp, "Failure sending request")
			return
		}

		result, err = client.InstallSiteExtensionResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtension", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// InstallSiteExtensionPreparer prepares the InstallSiteExtension request.
func (client AppsClient) InstallSiteExtensionPreparer(resourceGroupName string, name string, siteExtensionID string, extensionName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// InstallSiteExtensionSender sends the InstallSiteExtension request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) InstallSiteExtensionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// InstallSiteExtensionResponder handles the response to the InstallSiteExtension request. The method always
// closes the http.Response Body.
func (client AppsClient) InstallSiteExtensionResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusCreated, http.StatusOK, http.StatusTooManyRequests),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InstallSiteExtensionSlot install site extension on a web site, or a deployment slot. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. siteExtensionID is
// site extension name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment
// for the production slot.
func (client AppsClient) InstallSiteExtensionSlot(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string, cancel <-chan struct{}) (<-chan SiteExtensionInfo, <-chan error) {
	resultChan := make(chan SiteExtensionInfo, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "InstallSiteExtensionSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SiteExtensionInfo
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.InstallSiteExtensionSlotPreparer(resourceGroupName, name, siteExtensionID, slot, extensionName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtensionSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.InstallSiteExtensionSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtensionSlot", resp, "Failure sending request")
			return
		}

		result, err = client.InstallSiteExtensionSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "InstallSiteExtensionSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// InstallSiteExtensionSlotPreparer prepares the InstallSiteExtensionSlot request.
func (client AppsClient) InstallSiteExtensionSlotPreparer(resourceGroupName string, name string, siteExtensionID string, slot string, extensionName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"extensionName":     autorest.Encode("path", extensionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version":     APIVersion,
		"siteExtensionId": autorest.Encode("query", siteExtensionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions/{extensionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// InstallSiteExtensionSlotSender sends the InstallSiteExtensionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) InstallSiteExtensionSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// InstallSiteExtensionSlotResponder handles the response to the InstallSiteExtensionSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) InstallSiteExtensionSlotResponder(resp *http.Response) (result SiteExtensionInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusCreated, http.StatusOK, http.StatusTooManyRequests),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneable shows whether an app can be cloned to another resource group or subscription.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) IsCloneable(resourceGroupName string, name string) (result SiteCloneability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "IsCloneable")
	}

	req, err := client.IsCloneablePreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneable", resp, "Failure responding to request")
	}

	return
}

// IsCloneablePreparer prepares the IsCloneable request.
func (client AppsClient) IsCloneablePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsCloneableSender sends the IsCloneable request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// IsCloneableResponder handles the response to the IsCloneable request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsCloneableSlot shows whether an app can be cloned to another resource group or subscription.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. By default, this API returns information on the production slot.
func (client AppsClient) IsCloneableSlot(resourceGroupName string, name string, slot string) (result SiteCloneability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "IsCloneableSlot")
	}

	req, err := client.IsCloneableSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsCloneableSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure sending request")
		return
	}

	result, err = client.IsCloneableSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "IsCloneableSlot", resp, "Failure responding to request")
	}

	return
}

// IsCloneableSlotPreparer prepares the IsCloneableSlot request.
func (client AppsClient) IsCloneableSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// IsCloneableSlotSender sends the IsCloneableSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) IsCloneableSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// IsCloneableSlotResponder handles the response to the IsCloneableSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) IsCloneableSlotResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all apps for a subscription.
func (client AppsClient) List() (result AppCollection, err error) {
	req, err := client.ListPreparer()
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppsClient) ListPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppsClient) ListResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client AppsClient) ListNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListComplete gets all elements from the list without paging.
func (client AppsClient) ListComplete(cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.List()
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListApplicationSettings gets the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListApplicationSettings(resourceGroupName string, name string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListApplicationSettings")
	}

	req, err := client.ListApplicationSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettings", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsPreparer prepares the ListApplicationSettings request.
func (client AppsClient) ListApplicationSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListApplicationSettingsSender sends the ListApplicationSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListApplicationSettingsResponder handles the response to the ListApplicationSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListApplicationSettingsSlot gets the application settings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the application settings for the production
// slot.
func (client AppsClient) ListApplicationSettingsSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListApplicationSettingsSlot")
	}

	req, err := client.ListApplicationSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListApplicationSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListApplicationSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListApplicationSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListApplicationSettingsSlotPreparer prepares the ListApplicationSettingsSlot request.
func (client AppsClient) ListApplicationSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListApplicationSettingsSlotSender sends the ListApplicationSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListApplicationSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListApplicationSettingsSlotResponder handles the response to the ListApplicationSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListApplicationSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackups gets existing backups of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListBackups(resourceGroupName string, name string) (result BackupItemCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackups")
	}

	req, err := client.ListBackupsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure responding to request")
	}

	return
}

// ListBackupsPreparer prepares the ListBackups request.
func (client AppsClient) ListBackupsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupsSender sends the ListBackups request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBackupsResponder handles the response to the ListBackups request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListBackupsNextResults(lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.BackupItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure sending next results request")
	}

	result, err = client.ListBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackups", resp, "Failure responding to next results request")
	}

	return
}

// ListBackupsComplete gets all elements from the list without paging.
func (client AppsClient) ListBackupsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan BackupItem, <-chan error) {
	resultChan := make(chan BackupItem)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListBackups(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListBackupsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListBackupsSlot gets existing backups of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get backups of the production slot.
func (client AppsClient) ListBackupsSlot(resourceGroupName string, name string, slot string) (result BackupItemCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupsSlot")
	}

	req, err := client.ListBackupsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupsSlotPreparer prepares the ListBackupsSlot request.
func (client AppsClient) ListBackupsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupsSlotSender sends the ListBackupsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBackupsSlotResponder handles the response to the ListBackupsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupsSlotResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListBackupsSlotNextResults(lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.BackupItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListBackupsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListBackupsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan BackupItem, <-chan error) {
	resultChan := make(chan BackupItem)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListBackupsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListBackupsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListBackupStatusSecrets gets status of a web app backup that may be in progress, including secrets associated with
// the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
// passed in the request body.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. backupID is
// ID of backup. request is information on backup request.
func (client AppsClient) ListBackupStatusSecrets(resourceGroupName string, name string, backupID string, request BackupRequest) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupStatusSecrets")
	}

	req, err := client.ListBackupStatusSecretsPreparer(resourceGroupName, name, backupID, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecrets", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsPreparer prepares the ListBackupStatusSecrets request.
func (client AppsClient) ListBackupStatusSecretsPreparer(resourceGroupName string, name string, backupID string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupStatusSecretsSender sends the ListBackupStatusSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBackupStatusSecretsResponder handles the response to the ListBackupStatusSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBackupStatusSecretsSlot gets status of a web app backup that may be in progress, including secrets associated
// with the backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new
// URL is passed in the request body.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. backupID is
// ID of backup. request is information on backup request. slot is name of web app slot. If not specified then will
// default to production slot.
func (client AppsClient) ListBackupStatusSecretsSlot(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (result BackupItem, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: request,
			Constraints: []validation.Constraint{{Target: "request.BackupRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "request.BackupRequestProperties.BackupSchedule.FrequencyInterval", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.KeepAtLeastOneBackup", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "request.BackupRequestProperties.BackupSchedule.RetentionPeriodInDays", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListBackupStatusSecretsSlot")
	}

	req, err := client.ListBackupStatusSecretsSlotPreparer(resourceGroupName, name, backupID, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBackupStatusSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListBackupStatusSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListBackupStatusSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListBackupStatusSecretsSlotPreparer prepares the ListBackupStatusSecretsSlot request.
func (client AppsClient) ListBackupStatusSecretsSlotPreparer(resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBackupStatusSecretsSlotSender sends the ListBackupStatusSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListBackupStatusSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBackupStatusSecretsSlotResponder handles the response to the ListBackupStatusSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListBackupStatusSecretsSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup gets all web, mobile, and API apps in the specified resource group.
//
// resourceGroupName is name of the resource group to which the resource belongs. includeSlots is specify
// <strong>true</strong> to include deployment slots in results. The default is false, which only gives you the
// production slot of all apps.
func (client AppsClient) ListByResourceGroup(resourceGroupName string, includeSlots *bool) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListByResourceGroup")
	}

	req, err := client.ListByResourceGroupPreparer(resourceGroupName, includeSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppsClient) ListByResourceGroupPreparer(resourceGroupName string, includeSlots *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if includeSlots != nil {
		queryParameters["includeSlots"] = autorest.Encode("query", *includeSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppsClient) ListByResourceGroupResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppsClient) ListByResourceGroupNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListByResourceGroupComplete gets all elements from the list without paging.
func (client AppsClient) ListByResourceGroupComplete(resourceGroupName string, includeSlots *bool, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListByResourceGroup(resourceGroupName, includeSlots)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListByResourceGroupNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListConfigurations list the configurations of an app
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListConfigurations(resourceGroupName string, name string) (result SiteConfigResourceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurations")
	}

	req, err := client.ListConfigurationsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsPreparer prepares the ListConfigurations request.
func (client AppsClient) ListConfigurationsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationsSender sends the ListConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationsResponder handles the response to the ListConfigurations request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListConfigurationsNextResults(lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.SiteConfigResourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure sending next results request")
	}

	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurations", resp, "Failure responding to next results request")
	}

	return
}

// ListConfigurationsComplete gets all elements from the list without paging.
func (client AppsClient) ListConfigurationsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan SiteConfigResource, <-chan error) {
	resultChan := make(chan SiteConfigResource)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListConfigurations(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListConfigurationsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListConfigurationSnapshotInfo gets a list of web app configuration snapshots identifiers. Each element of the list
// contains a timestamp and the ID of the snapshot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListConfigurationSnapshotInfo(resourceGroupName string, name string) (result ListSiteConfigurationSnapshotInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationSnapshotInfo")
	}

	req, err := client.ListConfigurationSnapshotInfoPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationSnapshotInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfo", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoPreparer prepares the ListConfigurationSnapshotInfo request.
func (client AppsClient) ListConfigurationSnapshotInfoPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationSnapshotInfoSender sends the ListConfigurationSnapshotInfo request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationSnapshotInfoResponder handles the response to the ListConfigurationSnapshotInfo request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoResponder(resp *http.Response) (result ListSiteConfigurationSnapshotInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationSnapshotInfoSlot gets a list of web app configuration snapshots identifiers. Each element of the
// list contains a timestamp and the ID of the snapshot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
func (client AppsClient) ListConfigurationSnapshotInfoSlot(resourceGroupName string, name string, slot string) (result ListSiteConfigurationSnapshotInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot")
	}

	req, err := client.ListConfigurationSnapshotInfoSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationSnapshotInfoSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationSnapshotInfoSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationSnapshotInfoSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationSnapshotInfoSlotPreparer prepares the ListConfigurationSnapshotInfoSlot request.
func (client AppsClient) ListConfigurationSnapshotInfoSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationSnapshotInfoSlotSender sends the ListConfigurationSnapshotInfoSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationSnapshotInfoSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationSnapshotInfoSlotResponder handles the response to the ListConfigurationSnapshotInfoSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationSnapshotInfoSlotResponder(resp *http.Response) (result ListSiteConfigurationSnapshotInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsSlot list the configurations of an app
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will return configuration for the production slot.
func (client AppsClient) ListConfigurationsSlot(resourceGroupName string, name string, slot string) (result SiteConfigResourceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConfigurationsSlot")
	}

	req, err := client.ListConfigurationsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConfigurationsSlotPreparer prepares the ListConfigurationsSlot request.
func (client AppsClient) ListConfigurationsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConfigurationsSlotSender sends the ListConfigurationsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConfigurationsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationsSlotResponder handles the response to the ListConfigurationsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConfigurationsSlotResponder(resp *http.Response) (result SiteConfigResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConfigurationsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListConfigurationsSlotNextResults(lastResults SiteConfigResourceCollection) (result SiteConfigResourceCollection, err error) {
	req, err := lastResults.SiteConfigResourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListConfigurationsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListConfigurationsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConfigurationsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListConfigurationsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListConfigurationsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan SiteConfigResource, <-chan error) {
	resultChan := make(chan SiteConfigResource)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListConfigurationsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListConfigurationsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListConnectionStrings gets the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListConnectionStrings(resourceGroupName string, name string) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConnectionStrings")
	}

	req, err := client.ListConnectionStringsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStrings", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsPreparer prepares the ListConnectionStrings request.
func (client AppsClient) ListConnectionStringsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConnectionStringsSender sends the ListConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConnectionStringsResponder handles the response to the ListConnectionStrings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListConnectionStringsSlot gets the connection strings of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the connection settings for the production
// slot.
func (client AppsClient) ListConnectionStringsSlot(resourceGroupName string, name string, slot string) (result ConnectionStringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListConnectionStringsSlot")
	}

	req, err := client.ListConnectionStringsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListConnectionStringsSlot", resp, "Failure responding to request")
	}

	return
}

// ListConnectionStringsSlotPreparer prepares the ListConnectionStringsSlot request.
func (client AppsClient) ListConnectionStringsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListConnectionStringsSlotSender sends the ListConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListConnectionStringsSlotResponder handles the response to the ListConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListContinuousWebJobs list continuous web jobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListContinuousWebJobs(resourceGroupName string, name string) (result ContinuousWebJobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListContinuousWebJobs")
	}

	req, err := client.ListContinuousWebJobsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListContinuousWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure sending request")
		return
	}

	result, err = client.ListContinuousWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure responding to request")
	}

	return
}

// ListContinuousWebJobsPreparer prepares the ListContinuousWebJobs request.
func (client AppsClient) ListContinuousWebJobsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListContinuousWebJobsSender sends the ListContinuousWebJobs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListContinuousWebJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListContinuousWebJobsResponder handles the response to the ListContinuousWebJobs request. The method always
// closes the http.Response Body.
func (client AppsClient) ListContinuousWebJobsResponder(resp *http.Response) (result ContinuousWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListContinuousWebJobsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListContinuousWebJobsNextResults(lastResults ContinuousWebJobCollection) (result ContinuousWebJobCollection, err error) {
	req, err := lastResults.ContinuousWebJobCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListContinuousWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure sending next results request")
	}

	result, err = client.ListContinuousWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobs", resp, "Failure responding to next results request")
	}

	return
}

// ListContinuousWebJobsComplete gets all elements from the list without paging.
func (client AppsClient) ListContinuousWebJobsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan ContinuousWebJob, <-chan error) {
	resultChan := make(chan ContinuousWebJob)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListContinuousWebJobs(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListContinuousWebJobsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListContinuousWebJobsSlot list continuous web jobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
func (client AppsClient) ListContinuousWebJobsSlot(resourceGroupName string, name string, slot string) (result ContinuousWebJobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListContinuousWebJobsSlot")
	}

	req, err := client.ListContinuousWebJobsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListContinuousWebJobsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListContinuousWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure responding to request")
	}

	return
}

// ListContinuousWebJobsSlotPreparer prepares the ListContinuousWebJobsSlot request.
func (client AppsClient) ListContinuousWebJobsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/continuouswebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListContinuousWebJobsSlotSender sends the ListContinuousWebJobsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListContinuousWebJobsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListContinuousWebJobsSlotResponder handles the response to the ListContinuousWebJobsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListContinuousWebJobsSlotResponder(resp *http.Response) (result ContinuousWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListContinuousWebJobsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListContinuousWebJobsSlotNextResults(lastResults ContinuousWebJobCollection) (result ContinuousWebJobCollection, err error) {
	req, err := lastResults.ContinuousWebJobCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListContinuousWebJobsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListContinuousWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListContinuousWebJobsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListContinuousWebJobsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListContinuousWebJobsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan ContinuousWebJob, <-chan error) {
	resultChan := make(chan ContinuousWebJob)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListContinuousWebJobsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListContinuousWebJobsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListDeploymentLog list deployment log for specific deployment for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is the ID
// of a specific deployment. This is the value of the name property in the JSON response from "GET
// /api/sites/{siteName}/deployments".
func (client AppsClient) ListDeploymentLog(resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeploymentLog")
	}

	req, err := client.ListDeploymentLogPreparer(resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLog", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentLogPreparer prepares the ListDeploymentLog request.
func (client AppsClient) ListDeploymentLogPreparer(resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentLogSender sends the ListDeploymentLog request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentLogSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentLogResponder handles the response to the ListDeploymentLog request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentLogResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentLogSlot list deployment log for specific deployment for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. ID is the ID
// of a specific deployment. This is the value of the name property in the JSON response from "GET
// /api/sites/{siteName}/deployments". slot is name of the deployment slot. If a slot is not specified, the API returns
// deployments for the production slot.
func (client AppsClient) ListDeploymentLogSlot(resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeploymentLogSlot")
	}

	req, err := client.ListDeploymentLogSlotPreparer(resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentLogSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentLogSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentLogSlot", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentLogSlotPreparer prepares the ListDeploymentLogSlot request.
func (client AppsClient) ListDeploymentLogSlotPreparer(resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentLogSlotSender sends the ListDeploymentLogSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentLogSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentLogSlotResponder handles the response to the ListDeploymentLogSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentLogSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeployments list deployments for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListDeployments(resourceGroupName string, name string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeployments")
	}

	req, err := client.ListDeploymentsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsPreparer prepares the ListDeployments request.
func (client AppsClient) ListDeploymentsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentsSender sends the ListDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsResponder handles the response to the ListDeployments request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDeploymentsNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure sending next results request")
	}

	result, err = client.ListDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeployments", resp, "Failure responding to next results request")
	}

	return
}

// ListDeploymentsComplete gets all elements from the list without paging.
func (client AppsClient) ListDeploymentsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan Deployment, <-chan error) {
	resultChan := make(chan Deployment)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListDeployments(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListDeploymentsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListDeploymentsSlot list deployments for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
func (client AppsClient) ListDeploymentsSlot(resourceGroupName string, name string, slot string) (result DeploymentCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDeploymentsSlot")
	}

	req, err := client.ListDeploymentsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure responding to request")
	}

	return
}

// ListDeploymentsSlotPreparer prepares the ListDeploymentsSlot request.
func (client AppsClient) ListDeploymentsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDeploymentsSlotSender sends the ListDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDeploymentsSlotResponder handles the response to the ListDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDeploymentsSlotNextResults(lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.DeploymentCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDeploymentsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListDeploymentsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListDeploymentsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan Deployment, <-chan error) {
	resultChan := make(chan Deployment)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListDeploymentsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListDeploymentsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListDomainOwnershipIdentifiers lists ownership identifiers for domain associated with web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListDomainOwnershipIdentifiers(resourceGroupName string, name string) (result IdentifierCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers")
	}

	req, err := client.ListDomainOwnershipIdentifiersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure sending request")
		return
	}

	result, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersPreparer prepares the ListDomainOwnershipIdentifiers request.
func (client AppsClient) ListDomainOwnershipIdentifiersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDomainOwnershipIdentifiersSender sends the ListDomainOwnershipIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDomainOwnershipIdentifiersResponder handles the response to the ListDomainOwnershipIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDomainOwnershipIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDomainOwnershipIdentifiersNextResults(lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.IdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure sending next results request")
	}

	result, err = client.ListDomainOwnershipIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiers", resp, "Failure responding to next results request")
	}

	return
}

// ListDomainOwnershipIdentifiersComplete gets all elements from the list without paging.
func (client AppsClient) ListDomainOwnershipIdentifiersComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan Identifier, <-chan error) {
	resultChan := make(chan Identifier)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListDomainOwnershipIdentifiers(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListDomainOwnershipIdentifiersNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListDomainOwnershipIdentifiersSlot lists ownership identifiers for domain associated with web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will delete the binding for the production slot.
func (client AppsClient) ListDomainOwnershipIdentifiersSlot(resourceGroupName string, name string, slot string) (result IdentifierCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot")
	}

	req, err := client.ListDomainOwnershipIdentifiersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListDomainOwnershipIdentifiersSlotPreparer prepares the ListDomainOwnershipIdentifiersSlot request.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/domainOwnershipIdentifiers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListDomainOwnershipIdentifiersSlotSender sends the ListDomainOwnershipIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListDomainOwnershipIdentifiersSlotResponder handles the response to the ListDomainOwnershipIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotResponder(resp *http.Response) (result IdentifierCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDomainOwnershipIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotNextResults(lastResults IdentifierCollection) (result IdentifierCollection, err error) {
	req, err := lastResults.IdentifierCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListDomainOwnershipIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListDomainOwnershipIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListDomainOwnershipIdentifiersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListDomainOwnershipIdentifiersSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListDomainOwnershipIdentifiersSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan Identifier, <-chan error) {
	resultChan := make(chan Identifier)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListDomainOwnershipIdentifiersSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListDomainOwnershipIdentifiersSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListFunctions list the functions for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListFunctions(resourceGroupName string, name string) (result FunctionEnvelopeCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListFunctions")
	}

	req, err := client.ListFunctionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure responding to request")
	}

	return
}

// ListFunctionsPreparer prepares the ListFunctions request.
func (client AppsClient) ListFunctionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListFunctionsSender sends the ListFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionsResponder handles the response to the ListFunctions request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionsResponder(resp *http.Response) (result FunctionEnvelopeCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFunctionsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListFunctionsNextResults(lastResults FunctionEnvelopeCollection) (result FunctionEnvelopeCollection, err error) {
	req, err := lastResults.FunctionEnvelopeCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure sending next results request")
	}

	result, err = client.ListFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctions", resp, "Failure responding to next results request")
	}

	return
}

// ListFunctionsComplete gets all elements from the list without paging.
func (client AppsClient) ListFunctionsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan FunctionEnvelope, <-chan error) {
	resultChan := make(chan FunctionEnvelope)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListFunctions(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListFunctionsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListFunctionSecrets get function secrets for a function in a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name.
func (client AppsClient) ListFunctionSecrets(resourceGroupName string, name string, functionName string) (result FunctionSecrets, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListFunctionSecrets")
	}

	req, err := client.ListFunctionSecretsPreparer(resourceGroupName, name, functionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecrets", resp, "Failure responding to request")
	}

	return
}

// ListFunctionSecretsPreparer prepares the ListFunctionSecrets request.
func (client AppsClient) ListFunctionSecretsPreparer(resourceGroupName string, name string, functionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListFunctionSecretsSender sends the ListFunctionSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionSecretsResponder handles the response to the ListFunctionSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionSecretsResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListFunctionSecretsSlot get function secrets for a function in a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. functionName is
// function name. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) ListFunctionSecretsSlot(resourceGroupName string, name string, functionName string, slot string) (result FunctionSecrets, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListFunctionSecretsSlot")
	}

	req, err := client.ListFunctionSecretsSlotPreparer(resourceGroupName, name, functionName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListFunctionSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListFunctionSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListFunctionSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListFunctionSecretsSlotPreparer prepares the ListFunctionSecretsSlot request.
func (client AppsClient) ListFunctionSecretsSlotPreparer(resourceGroupName string, name string, functionName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"functionName":      autorest.Encode("path", functionName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions/{functionName}/listsecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListFunctionSecretsSlotSender sends the ListFunctionSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListFunctionSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListFunctionSecretsSlotResponder handles the response to the ListFunctionSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListFunctionSecretsSlotResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindings get hostname bindings for an app or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListHostNameBindings(resourceGroupName string, name string) (result HostNameBindingCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHostNameBindings")
	}

	req, err := client.ListHostNameBindingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsPreparer prepares the ListHostNameBindings request.
func (client AppsClient) ListHostNameBindingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHostNameBindingsSender sends the ListHostNameBindings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHostNameBindingsResponder handles the response to the ListHostNameBindings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindingsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListHostNameBindingsNextResults(lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.HostNameBindingCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure sending next results request")
	}

	result, err = client.ListHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindings", resp, "Failure responding to next results request")
	}

	return
}

// ListHostNameBindingsComplete gets all elements from the list without paging.
func (client AppsClient) ListHostNameBindingsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan HostNameBinding, <-chan error) {
	resultChan := make(chan HostNameBinding)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListHostNameBindings(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListHostNameBindingsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListHostNameBindingsSlot get hostname bindings for an app or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API gets hostname bindings for the production slot.
func (client AppsClient) ListHostNameBindingsSlot(resourceGroupName string, name string, slot string) (result HostNameBindingCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHostNameBindingsSlot")
	}

	req, err := client.ListHostNameBindingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHostNameBindingsSlotPreparer prepares the ListHostNameBindingsSlot request.
func (client AppsClient) ListHostNameBindingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHostNameBindingsSlotSender sends the ListHostNameBindingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHostNameBindingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHostNameBindingsSlotResponder handles the response to the ListHostNameBindingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHostNameBindingsSlotResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHostNameBindingsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListHostNameBindingsSlotNextResults(lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.HostNameBindingCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHostNameBindingsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListHostNameBindingsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListHostNameBindingsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan HostNameBinding, <-chan error) {
	resultChan := make(chan HostNameBinding)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListHostNameBindingsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListHostNameBindingsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListHybridConnectionKeys gets the send key name and value for a Hybrid Connection.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
func (client AppsClient) ListHybridConnectionKeys(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionKeys")
	}

	req, err := client.ListHybridConnectionKeysPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeys", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysPreparer prepares the ListHybridConnectionKeys request.
func (client AppsClient) ListHybridConnectionKeysPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionKeysSender sends the ListHybridConnectionKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionKeysResponder handles the response to the ListHybridConnectionKeys request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionKeysResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionKeysSlot gets the send key name and value for a Hybrid Connection.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
// namespaceName is the namespace for this hybrid connection. relayName is the relay name for this hybrid connection.
// slot is the name of the slot for the web app.
func (client AppsClient) ListHybridConnectionKeysSlot(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionKeysSlot")
	}

	req, err := client.ListHybridConnectionKeysSlotPreparer(resourceGroupName, name, namespaceName, relayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionKeysSlot", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysSlotPreparer prepares the ListHybridConnectionKeysSlot request.
func (client AppsClient) ListHybridConnectionKeysSlotPreparer(resourceGroupName string, name string, namespaceName string, relayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionKeysSlotSender sends the ListHybridConnectionKeysSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionKeysSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionKeysSlotResponder handles the response to the ListHybridConnectionKeysSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionKeysSlotResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnections retrieves all Service Bus Hybrid Connections used by this Web App.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app.
func (client AppsClient) ListHybridConnections(resourceGroupName string, name string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnections")
	}

	req, err := client.ListHybridConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnections", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsPreparer prepares the ListHybridConnections request.
func (client AppsClient) ListHybridConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionsSender sends the ListHybridConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsResponder handles the response to the ListHybridConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionsSlot retrieves all Service Bus Hybrid Connections used by this Web App.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is the name of the web app. slot
// is the name of the slot for the web app.
func (client AppsClient) ListHybridConnectionsSlot(resourceGroupName string, name string, slot string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListHybridConnectionsSlot")
	}

	req, err := client.ListHybridConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListHybridConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsSlotPreparer prepares the ListHybridConnectionsSlot request.
func (client AppsClient) ListHybridConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionsSlotSender sends the ListHybridConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListHybridConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsSlotResponder handles the response to the ListHybridConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListHybridConnectionsSlotResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceFunctionsSlot list the functions for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
func (client AppsClient) ListInstanceFunctionsSlot(resourceGroupName string, name string, slot string) (result FunctionEnvelopeCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceFunctionsSlot")
	}

	req, err := client.ListInstanceFunctionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceFunctionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceFunctionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceFunctionsSlotPreparer prepares the ListInstanceFunctionsSlot request.
func (client AppsClient) ListInstanceFunctionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceFunctionsSlotSender sends the ListInstanceFunctionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceFunctionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceFunctionsSlotResponder handles the response to the ListInstanceFunctionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceFunctionsSlotResponder(resp *http.Response) (result FunctionEnvelopeCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceFunctionsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceFunctionsSlotNextResults(lastResults FunctionEnvelopeCollection) (result FunctionEnvelopeCollection, err error) {
	req, err := lastResults.FunctionEnvelopeCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceFunctionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceFunctionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceFunctionsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceFunctionsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceFunctionsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan FunctionEnvelope, <-chan error) {
	resultChan := make(chan FunctionEnvelope)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceFunctionsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceFunctionsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceIdentifiers gets all scale-out instances of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListInstanceIdentifiers(resourceGroupName string, name string) (result AppInstanceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceIdentifiers")
	}

	req, err := client.ListInstanceIdentifiersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersPreparer prepares the ListInstanceIdentifiers request.
func (client AppsClient) ListInstanceIdentifiersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceIdentifiersSender sends the ListInstanceIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceIdentifiersResponder handles the response to the ListInstanceIdentifiers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceIdentifiersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceIdentifiersNextResults(lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.AppInstanceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiers", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceIdentifiersComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceIdentifiersComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan SiteInstance, <-chan error) {
	resultChan := make(chan SiteInstance)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceIdentifiers(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceIdentifiersNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceIdentifiersSlot gets all scale-out instances of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API gets the production slot instances.
func (client AppsClient) ListInstanceIdentifiersSlot(resourceGroupName string, name string, slot string) (result AppInstanceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceIdentifiersSlot")
	}

	req, err := client.ListInstanceIdentifiersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceIdentifiersSlotPreparer prepares the ListInstanceIdentifiersSlot request.
func (client AppsClient) ListInstanceIdentifiersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceIdentifiersSlotSender sends the ListInstanceIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceIdentifiersSlotResponder handles the response to the ListInstanceIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceIdentifiersSlotResponder(resp *http.Response) (result AppInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceIdentifiersSlotNextResults(lastResults AppInstanceCollection) (result AppInstanceCollection, err error) {
	req, err := lastResults.AppInstanceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceIdentifiersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceIdentifiersSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceIdentifiersSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan SiteInstance, <-chan error) {
	resultChan := make(chan SiteInstance)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceIdentifiersSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceIdentifiersSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcesses get list of processes for a web site, or a deployment slot, or for a specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. instanceID is ID
// of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcesses(resourceGroupName string, name string, instanceID string) (result ProcessInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcesses")
	}

	req, err := client.ListInstanceProcessesPreparer(resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessesPreparer prepares the ListInstanceProcesses request.
func (client AppsClient) ListInstanceProcessesPreparer(resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessesSender sends the ListInstanceProcesses request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessesResponder handles the response to the ListInstanceProcesses request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessesResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessesNextResults(lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.ProcessInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcesses", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessesComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessesComplete(resourceGroupName string, name string, instanceID string, cancel <-chan struct{}) (<-chan ProcessInfo, <-chan error) {
	resultChan := make(chan ProcessInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcesses(resourceGroupName, name, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcessesSlot get list of processes for a web site, or a deployment slot, or for a specific scaled-out
// instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API returns deployments for the production slot. instanceID is
// ID of a specific scaled-out instance. This is the value of the name property in the JSON response from "GET
// api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessesSlot(resourceGroupName string, name string, slot string, instanceID string) (result ProcessInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcessesSlot")
	}

	req, err := client.ListInstanceProcessesSlotPreparer(resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessesSlotPreparer prepares the ListInstanceProcessesSlot request.
func (client AppsClient) ListInstanceProcessesSlotPreparer(resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessesSlotSender sends the ListInstanceProcessesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessesSlotResponder handles the response to the ListInstanceProcessesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessesSlotResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessesSlotNextResults(lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.ProcessInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessesSlotComplete(resourceGroupName string, name string, slot string, instanceID string, cancel <-chan struct{}) (<-chan ProcessInfo, <-chan error) {
	resultChan := make(chan ProcessInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcessesSlot(resourceGroupName, name, slot, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcessModules list module information for a process by its ID for a specific scaled-out instance in a
// web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON response from
// "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessModules(resourceGroupName string, name string, processID string, instanceID string) (result ProcessModuleInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcessModules")
	}

	req, err := client.ListInstanceProcessModulesPreparer(resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessModulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessModulesPreparer prepares the ListInstanceProcessModules request.
func (client AppsClient) ListInstanceProcessModulesPreparer(resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessModulesSender sends the ListInstanceProcessModules request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessModulesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessModulesResponder handles the response to the ListInstanceProcessModules request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessModulesResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessModulesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessModulesNextResults(lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.ProcessModuleInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessModulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModules", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessModulesComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessModulesComplete(resourceGroupName string, name string, processID string, instanceID string, cancel <-chan struct{}) (<-chan ProcessModuleInfo, <-chan error) {
	resultChan := make(chan ProcessModuleInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcessModules(resourceGroupName, name, processID, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessModulesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcessModulesSlot list module information for a process by its ID for a specific scaled-out instance in
// a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessModulesSlot(resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessModuleInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcessModulesSlot")
	}

	req, err := client.ListInstanceProcessModulesSlotPreparer(resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessModulesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessModulesSlotPreparer prepares the ListInstanceProcessModulesSlot request.
func (client AppsClient) ListInstanceProcessModulesSlotPreparer(resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessModulesSlotSender sends the ListInstanceProcessModulesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessModulesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessModulesSlotResponder handles the response to the ListInstanceProcessModulesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessModulesSlotResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessModulesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessModulesSlotNextResults(lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.ProcessModuleInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessModulesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessModulesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessModulesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessModulesSlotComplete(resourceGroupName string, name string, processID string, slot string, instanceID string, cancel <-chan struct{}) (<-chan ProcessModuleInfo, <-chan error) {
	resultChan := make(chan ProcessModuleInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcessModulesSlot(resourceGroupName, name, processID, slot, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessModulesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcessThreads list the threads in a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON response from
// "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessThreads(resourceGroupName string, name string, processID string, instanceID string) (result ProcessThreadInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcessThreads")
	}

	req, err := client.ListInstanceProcessThreadsPreparer(resourceGroupName, name, processID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessThreadsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessThreadsPreparer prepares the ListInstanceProcessThreads request.
func (client AppsClient) ListInstanceProcessThreadsPreparer(resourceGroupName string, name string, processID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessThreadsSender sends the ListInstanceProcessThreads request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessThreadsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessThreadsResponder handles the response to the ListInstanceProcessThreads request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessThreadsResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessThreadsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessThreadsNextResults(lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.ProcessThreadInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessThreadsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreads", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessThreadsComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessThreadsComplete(resourceGroupName string, name string, processID string, instanceID string, cancel <-chan struct{}) (<-chan ProcessThreadInfo, <-chan error) {
	resultChan := make(chan ProcessThreadInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcessThreads(resourceGroupName, name, processID, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessThreadsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListInstanceProcessThreadsSlot list the threads in a process by its ID for a specific scaled-out instance in a web
// site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot. instanceID is ID of a specific scaled-out instance. This is the value of the name property in the JSON
// response from "GET api/sites/{siteName}/instances".
func (client AppsClient) ListInstanceProcessThreadsSlot(resourceGroupName string, name string, processID string, slot string, instanceID string) (result ProcessThreadInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot")
	}

	req, err := client.ListInstanceProcessThreadsSlotPreparer(resourceGroupName, name, processID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListInstanceProcessThreadsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListInstanceProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure responding to request")
	}

	return
}

// ListInstanceProcessThreadsSlotPreparer prepares the ListInstanceProcessThreadsSlot request.
func (client AppsClient) ListInstanceProcessThreadsSlotPreparer(resourceGroupName string, name string, processID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInstanceProcessThreadsSlotSender sends the ListInstanceProcessThreadsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListInstanceProcessThreadsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListInstanceProcessThreadsSlotResponder handles the response to the ListInstanceProcessThreadsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListInstanceProcessThreadsSlotResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInstanceProcessThreadsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListInstanceProcessThreadsSlotNextResults(lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.ProcessThreadInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListInstanceProcessThreadsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListInstanceProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListInstanceProcessThreadsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListInstanceProcessThreadsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListInstanceProcessThreadsSlotComplete(resourceGroupName string, name string, processID string, slot string, instanceID string, cancel <-chan struct{}) (<-chan ProcessThreadInfo, <-chan error) {
	resultChan := make(chan ProcessThreadInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListInstanceProcessThreadsSlot(resourceGroupName, name, processID, slot, instanceID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListInstanceProcessThreadsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetadata gets the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListMetadata(resourceGroupName string, name string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetadata")
	}

	req, err := client.ListMetadataPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadata", resp, "Failure responding to request")
	}

	return
}

// ListMetadataPreparer prepares the ListMetadata request.
func (client AppsClient) ListMetadataPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetadataSender sends the ListMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetadataResponder handles the response to the ListMetadata request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetadataSlot gets the metadata of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the metadata for the production slot.
func (client AppsClient) ListMetadataSlot(resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetadataSlot")
	}

	req, err := client.ListMetadataSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetadataSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetadataSlotPreparer prepares the ListMetadataSlot request.
func (client AppsClient) ListMetadataSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetadataSlotSender sends the ListMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetadataSlotResponder handles the response to the ListMetadataSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitions gets all metric definitions of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListMetricDefinitions(resourceGroupName string, name string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricDefinitions")
	}

	req, err := client.ListMetricDefinitionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsPreparer prepares the ListMetricDefinitions request.
func (client AppsClient) ListMetricDefinitionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionsSender sends the ListMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricDefinitionsResponder handles the response to the ListMetricDefinitions request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricDefinitionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricDefinitionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitions", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricDefinitionsComplete gets all elements from the list without paging.
func (client AppsClient) ListMetricDefinitionsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan ResourceMetricDefinition, <-chan error) {
	resultChan := make(chan ResourceMetricDefinition)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetricDefinitions(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricDefinitionsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetricDefinitionsSlot gets all metric definitions of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get metric definitions of the production slot.
func (client AppsClient) ListMetricDefinitionsSlot(resourceGroupName string, name string, slot string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricDefinitionsSlot")
	}

	req, err := client.ListMetricDefinitionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefinitionsSlotPreparer prepares the ListMetricDefinitionsSlot request.
func (client AppsClient) ListMetricDefinitionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefinitionsSlotSender sends the ListMetricDefinitionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricDefinitionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricDefinitionsSlotResponder handles the response to the ListMetricDefinitionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricDefinitionsSlotResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefinitionsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricDefinitionsSlotNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricDefinitionsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricDefinitionsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListMetricDefinitionsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan ResourceMetricDefinition, <-chan error) {
	resultChan := make(chan ResourceMetricDefinition)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetricDefinitionsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricDefinitionsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetrics gets performance metrics of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. details is
// specify "true" to include metric details in the response. It is "false" by default. filter is return only metrics
// specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
// 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client AppsClient) ListMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetrics")
	}

	req, err := client.ListMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppsClient) ListMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricsComplete gets all elements from the list without paging.
func (client AppsClient) ListMetricsComplete(resourceGroupName string, name string, details *bool, filter string, cancel <-chan struct{}) (<-chan ResourceMetric, <-chan error) {
	resultChan := make(chan ResourceMetric)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetrics(resourceGroupName, name, details, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetricsSlot gets performance metrics of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get metrics of the production slot. details is
// specify "true" to include metric details in the response. It is "false" by default. filter is return only metrics
// specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or name.value eq
// 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
// duration'[Hour|Minute|Day]'.
func (client AppsClient) ListMetricsSlot(resourceGroupName string, name string, slot string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListMetricsSlot")
	}

	req, err := client.ListMetricsSlotPreparer(resourceGroupName, name, slot, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure responding to request")
	}

	return
}

// ListMetricsSlotPreparer prepares the ListMetricsSlot request.
func (client AppsClient) ListMetricsSlotPreparer(resourceGroupName string, name string, slot string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSlotSender sends the ListMetricsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListMetricsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricsSlotResponder handles the response to the ListMetricsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListMetricsSlotResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListMetricsSlotNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListMetricsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListMetricsSlotComplete(resourceGroupName string, name string, slot string, details *bool, filter string, cancel <-chan struct{}) (<-chan ResourceMetric, <-chan error) {
	resultChan := make(chan ResourceMetric)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetricsSlot(resourceGroupName, name, slot, details, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListNetworkFeatures gets all network features used by the app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. view is the
// type of view. This can either be "summary" or "detailed".
func (client AppsClient) ListNetworkFeatures(resourceGroupName string, name string, view string) (result NetworkFeatures, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListNetworkFeatures")
	}

	req, err := client.ListNetworkFeaturesPreparer(resourceGroupName, name, view)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeatures", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesPreparer prepares the ListNetworkFeatures request.
func (client AppsClient) ListNetworkFeaturesPreparer(resourceGroupName string, name string, view string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListNetworkFeaturesSender sends the ListNetworkFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListNetworkFeaturesResponder handles the response to the ListNetworkFeatures request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNetworkFeaturesSlot gets all network features used by the app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. view is the
// type of view. This can either be "summary" or "detailed". slot is name of the deployment slot. If a slot is not
// specified, the API will get network features for the production slot.
func (client AppsClient) ListNetworkFeaturesSlot(resourceGroupName string, name string, view string, slot string) (result NetworkFeatures, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListNetworkFeaturesSlot")
	}

	req, err := client.ListNetworkFeaturesSlotPreparer(resourceGroupName, name, view, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListNetworkFeaturesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListNetworkFeaturesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListNetworkFeaturesSlot", resp, "Failure responding to request")
	}

	return
}

// ListNetworkFeaturesSlotPreparer prepares the ListNetworkFeaturesSlot request.
func (client AppsClient) ListNetworkFeaturesSlotPreparer(resourceGroupName string, name string, view string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListNetworkFeaturesSlotSender sends the ListNetworkFeaturesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListNetworkFeaturesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListNetworkFeaturesSlotResponder handles the response to the ListNetworkFeaturesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListNetworkFeaturesSlotResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCounters gets perfmon counters for web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. filter is
// return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq
// '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCounters(resourceGroupName string, name string, filter string) (result PerfMonCounterCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPerfMonCounters")
	}

	req, err := client.ListPerfMonCountersPreparer(resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure sending request")
		return
	}

	result, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersPreparer prepares the ListPerfMonCounters request.
func (client AppsClient) ListPerfMonCountersPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPerfMonCountersSender sends the ListPerfMonCounters request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPerfMonCountersResponder handles the response to the ListPerfMonCounters request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCountersNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPerfMonCountersNextResults(lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.PerfMonCounterCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPerfMonCountersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure sending next results request")
	}

	result, err = client.ListPerfMonCountersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCounters", resp, "Failure responding to next results request")
	}

	return
}

// ListPerfMonCountersComplete gets all elements from the list without paging.
func (client AppsClient) ListPerfMonCountersComplete(resourceGroupName string, name string, filter string, cancel <-chan struct{}) (<-chan PerfMonResponse, <-chan error) {
	resultChan := make(chan PerfMonResponse)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListPerfMonCounters(resourceGroupName, name, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListPerfMonCountersNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListPerfMonCountersSlot gets perfmon counters for web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot. filter is return only usages/metrics
// specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListPerfMonCountersSlot(resourceGroupName string, name string, slot string, filter string) (result PerfMonCounterCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPerfMonCountersSlot")
	}

	req, err := client.ListPerfMonCountersSlotPreparer(resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure responding to request")
	}

	return
}

// ListPerfMonCountersSlotPreparer prepares the ListPerfMonCountersSlot request.
func (client AppsClient) ListPerfMonCountersSlotPreparer(resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPerfMonCountersSlotSender sends the ListPerfMonCountersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPerfMonCountersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPerfMonCountersSlotResponder handles the response to the ListPerfMonCountersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPerfMonCountersSlotResponder(resp *http.Response) (result PerfMonCounterCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPerfMonCountersSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPerfMonCountersSlotNextResults(lastResults PerfMonCounterCollection) (result PerfMonCounterCollection, err error) {
	req, err := lastResults.PerfMonCounterCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPerfMonCountersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListPerfMonCountersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPerfMonCountersSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListPerfMonCountersSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListPerfMonCountersSlotComplete(resourceGroupName string, name string, slot string, filter string, cancel <-chan struct{}) (<-chan PerfMonResponse, <-chan error) {
	resultChan := make(chan PerfMonResponse)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListPerfMonCountersSlot(resourceGroupName, name, slot, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListPerfMonCountersSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListPremierAddOns gets the premier add-ons of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListPremierAddOns(resourceGroupName string, name string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPremierAddOns")
	}

	req, err := client.ListPremierAddOnsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOns", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsPreparer prepares the ListPremierAddOns request.
func (client AppsClient) ListPremierAddOnsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPremierAddOnsSender sends the ListPremierAddOns request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnsResponder handles the response to the ListPremierAddOns request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPremierAddOnsSlot gets the premier add-ons of an app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the premier add-ons for the production slot.
func (client AppsClient) ListPremierAddOnsSlot(resourceGroupName string, name string, slot string) (result PremierAddOn, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPremierAddOnsSlot")
	}

	req, err := client.ListPremierAddOnsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPremierAddOnsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPremierAddOnsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPremierAddOnsSlot", resp, "Failure responding to request")
	}

	return
}

// ListPremierAddOnsSlotPreparer prepares the ListPremierAddOnsSlot request.
func (client AppsClient) ListPremierAddOnsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPremierAddOnsSlotSender sends the ListPremierAddOnsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPremierAddOnsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPremierAddOnsSlotResponder handles the response to the ListPremierAddOnsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPremierAddOnsSlotResponder(resp *http.Response) (result PremierAddOn, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcesses get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance in a
// web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListProcesses(resourceGroupName string, name string) (result ProcessInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcesses")
	}

	req, err := client.ListProcessesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure responding to request")
	}

	return
}

// ListProcessesPreparer prepares the ListProcesses request.
func (client AppsClient) ListProcessesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessesSender sends the ListProcesses request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessesResponder handles the response to the ListProcesses request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessesResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessesNextResults(lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.ProcessInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcesses", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessesComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessesComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan ProcessInfo, <-chan error) {
	resultChan := make(chan ProcessInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcesses(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListProcessesSlot get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
// in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
func (client AppsClient) ListProcessesSlot(resourceGroupName string, name string, slot string) (result ProcessInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcessesSlot")
	}

	req, err := client.ListProcessesSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", resp, "Failure responding to request")
	}

	return
}

// ListProcessesSlotPreparer prepares the ListProcessesSlot request.
func (client AppsClient) ListProcessesSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessesSlotSender sends the ListProcessesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessesSlotResponder handles the response to the ListProcessesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessesSlotResponder(resp *http.Response) (result ProcessInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessesSlotNextResults(lastResults ProcessInfoCollection) (result ProcessInfoCollection, err error) {
	req, err := lastResults.ProcessInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessesSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan ProcessInfo, <-chan error) {
	resultChan := make(chan ProcessInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcessesSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListProcessModules list module information for a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
func (client AppsClient) ListProcessModules(resourceGroupName string, name string, processID string) (result ProcessModuleInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcessModules")
	}

	req, err := client.ListProcessModulesPreparer(resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessModulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", resp, "Failure responding to request")
	}

	return
}

// ListProcessModulesPreparer prepares the ListProcessModules request.
func (client AppsClient) ListProcessModulesPreparer(resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessModulesSender sends the ListProcessModules request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessModulesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessModulesResponder handles the response to the ListProcessModules request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessModulesResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessModulesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessModulesNextResults(lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.ProcessModuleInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessModulesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessModulesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModules", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessModulesComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessModulesComplete(resourceGroupName string, name string, processID string, cancel <-chan struct{}) (<-chan ProcessModuleInfo, <-chan error) {
	resultChan := make(chan ProcessModuleInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcessModules(resourceGroupName, name, processID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessModulesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListProcessModulesSlot list module information for a process by its ID for a specific scaled-out instance in a web
// site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot.
func (client AppsClient) ListProcessModulesSlot(resourceGroupName string, name string, processID string, slot string) (result ProcessModuleInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcessModulesSlot")
	}

	req, err := client.ListProcessModulesSlotPreparer(resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessModulesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", resp, "Failure responding to request")
	}

	return
}

// ListProcessModulesSlotPreparer prepares the ListProcessModulesSlot request.
func (client AppsClient) ListProcessModulesSlotPreparer(resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/modules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessModulesSlotSender sends the ListProcessModulesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessModulesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessModulesSlotResponder handles the response to the ListProcessModulesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessModulesSlotResponder(resp *http.Response) (result ProcessModuleInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessModulesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessModulesSlotNextResults(lastResults ProcessModuleInfoCollection) (result ProcessModuleInfoCollection, err error) {
	req, err := lastResults.ProcessModuleInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessModulesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessModulesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessModulesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessModulesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessModulesSlotComplete(resourceGroupName string, name string, processID string, slot string, cancel <-chan struct{}) (<-chan ProcessModuleInfo, <-chan error) {
	resultChan := make(chan ProcessModuleInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcessModulesSlot(resourceGroupName, name, processID, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessModulesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListProcessThreads list the threads in a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
func (client AppsClient) ListProcessThreads(resourceGroupName string, name string, processID string) (result ProcessThreadInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcessThreads")
	}

	req, err := client.ListProcessThreadsPreparer(resourceGroupName, name, processID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessThreadsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", resp, "Failure responding to request")
	}

	return
}

// ListProcessThreadsPreparer prepares the ListProcessThreads request.
func (client AppsClient) ListProcessThreadsPreparer(resourceGroupName string, name string, processID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessThreadsSender sends the ListProcessThreads request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessThreadsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessThreadsResponder handles the response to the ListProcessThreads request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessThreadsResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessThreadsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessThreadsNextResults(lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.ProcessThreadInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessThreadsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessThreadsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreads", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessThreadsComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessThreadsComplete(resourceGroupName string, name string, processID string, cancel <-chan struct{}) (<-chan ProcessThreadInfo, <-chan error) {
	resultChan := make(chan ProcessThreadInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcessThreads(resourceGroupName, name, processID)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessThreadsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListProcessThreadsSlot list the threads in a process by its ID for a specific scaled-out instance in a web site.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. processID is pID.
// slot is name of the deployment slot. If a slot is not specified, the API returns deployments for the production
// slot.
func (client AppsClient) ListProcessThreadsSlot(resourceGroupName string, name string, processID string, slot string) (result ProcessThreadInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListProcessThreadsSlot")
	}

	req, err := client.ListProcessThreadsSlotPreparer(resourceGroupName, name, processID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProcessThreadsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", resp, "Failure responding to request")
	}

	return
}

// ListProcessThreadsSlotPreparer prepares the ListProcessThreadsSlot request.
func (client AppsClient) ListProcessThreadsSlotPreparer(resourceGroupName string, name string, processID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"processId":         autorest.Encode("path", processID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/processes/{processId}/threads", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListProcessThreadsSlotSender sends the ListProcessThreadsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListProcessThreadsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListProcessThreadsSlotResponder handles the response to the ListProcessThreadsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListProcessThreadsSlotResponder(resp *http.Response) (result ProcessThreadInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListProcessThreadsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListProcessThreadsSlotNextResults(lastResults ProcessThreadInfoCollection) (result ProcessThreadInfoCollection, err error) {
	req, err := lastResults.ProcessThreadInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListProcessThreadsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListProcessThreadsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListProcessThreadsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListProcessThreadsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListProcessThreadsSlotComplete(resourceGroupName string, name string, processID string, slot string, cancel <-chan struct{}) (<-chan ProcessThreadInfo, <-chan error) {
	resultChan := make(chan ProcessThreadInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListProcessThreadsSlot(resourceGroupName, name, processID, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListProcessThreadsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListPublicCertificates get public certificates for an app or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListPublicCertificates(resourceGroupName string, name string) (result PublicCertificateCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublicCertificates")
	}

	req, err := client.ListPublicCertificatesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublicCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublicCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", resp, "Failure responding to request")
	}

	return
}

// ListPublicCertificatesPreparer prepares the ListPublicCertificates request.
func (client AppsClient) ListPublicCertificatesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublicCertificatesSender sends the ListPublicCertificates request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublicCertificatesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPublicCertificatesResponder handles the response to the ListPublicCertificates request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublicCertificatesResponder(resp *http.Response) (result PublicCertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublicCertificatesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPublicCertificatesNextResults(lastResults PublicCertificateCollection) (result PublicCertificateCollection, err error) {
	req, err := lastResults.PublicCertificateCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPublicCertificatesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", resp, "Failure sending next results request")
	}

	result, err = client.ListPublicCertificatesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificates", resp, "Failure responding to next results request")
	}

	return
}

// ListPublicCertificatesComplete gets all elements from the list without paging.
func (client AppsClient) ListPublicCertificatesComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan PublicCertificate, <-chan error) {
	resultChan := make(chan PublicCertificate)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListPublicCertificates(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListPublicCertificatesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListPublicCertificatesSlot get public certificates for an app or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API gets hostname bindings for the production slot.
func (client AppsClient) ListPublicCertificatesSlot(resourceGroupName string, name string, slot string) (result PublicCertificateCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublicCertificatesSlot")
	}

	req, err := client.ListPublicCertificatesSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublicCertificatesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublicCertificatesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", resp, "Failure responding to request")
	}

	return
}

// ListPublicCertificatesSlotPreparer prepares the ListPublicCertificatesSlot request.
func (client AppsClient) ListPublicCertificatesSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publicCertificates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublicCertificatesSlotSender sends the ListPublicCertificatesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublicCertificatesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPublicCertificatesSlotResponder handles the response to the ListPublicCertificatesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublicCertificatesSlotResponder(resp *http.Response) (result PublicCertificateCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublicCertificatesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListPublicCertificatesSlotNextResults(lastResults PublicCertificateCollection) (result PublicCertificateCollection, err error) {
	req, err := lastResults.PublicCertificateCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListPublicCertificatesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListPublicCertificatesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublicCertificatesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListPublicCertificatesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListPublicCertificatesSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan PublicCertificate, <-chan error) {
	resultChan := make(chan PublicCertificate)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListPublicCertificatesSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListPublicCertificatesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListPublishingCredentials gets the Git/FTP publishing credentials of an app. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListPublishingCredentials(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan User, <-chan error) {
	resultChan := make(chan User, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingCredentials")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result User
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ListPublishingCredentialsPreparer(resourceGroupName, name, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", nil, "Failure preparing request")
			return
		}

		resp, err := client.ListPublishingCredentialsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", resp, "Failure sending request")
			return
		}

		result, err = client.ListPublishingCredentialsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentials", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ListPublishingCredentialsPreparer prepares the ListPublishingCredentials request.
func (client AppsClient) ListPublishingCredentialsPreparer(resourceGroupName string, name string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListPublishingCredentialsSender sends the ListPublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingCredentialsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListPublishingCredentialsResponder handles the response to the ListPublishingCredentials request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingCredentialsResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingCredentialsSlot gets the Git/FTP publishing credentials of an app. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get the publishing credentials for the production
// slot.
func (client AppsClient) ListPublishingCredentialsSlot(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan User, <-chan error) {
	resultChan := make(chan User, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingCredentialsSlot")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result User
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.ListPublishingCredentialsSlotPreparer(resourceGroupName, name, slot, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", nil, "Failure preparing request")
			return
		}

		resp, err := client.ListPublishingCredentialsSlotSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", resp, "Failure sending request")
			return
		}

		result, err = client.ListPublishingCredentialsSlotResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingCredentialsSlot", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// ListPublishingCredentialsSlotPreparer prepares the ListPublishingCredentialsSlot request.
func (client AppsClient) ListPublishingCredentialsSlotPreparer(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// ListPublishingCredentialsSlotSender sends the ListPublishingCredentialsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingCredentialsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// ListPublishingCredentialsSlotResponder handles the response to the ListPublishingCredentialsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingCredentialsSlotResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingProfileXMLWithSecrets gets the publishing profile for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publishingProfileOptions is specifies publishingProfileOptions for publishing profile. For example, use {"format":
// "FileZilla3"} to get a FileZilla publishing profile.
func (client AppsClient) ListPublishingProfileXMLWithSecrets(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions) (result ReadCloser, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets")
	}

	req, err := client.ListPublishingProfileXMLWithSecretsPreparer(resourceGroupName, name, publishingProfileOptions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublishingProfileXMLWithSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublishingProfileXMLWithSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecrets", resp, "Failure responding to request")
	}

	return
}

// ListPublishingProfileXMLWithSecretsPreparer prepares the ListPublishingProfileXMLWithSecrets request.
func (client AppsClient) ListPublishingProfileXMLWithSecretsPreparer(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml", pathParameters),
		autorest.WithJSON(publishingProfileOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublishingProfileXMLWithSecretsSender sends the ListPublishingProfileXMLWithSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPublishingProfileXMLWithSecretsResponder handles the response to the ListPublishingProfileXMLWithSecrets request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingProfileXMLWithSecretsResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPublishingProfileXMLWithSecretsSlot gets the publishing profile for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// publishingProfileOptions is specifies publishingProfileOptions for publishing profile. For example, use {"format":
// "FileZilla3"} to get a FileZilla publishing profile. slot is name of the deployment slot. If a slot is not
// specified, the API will get the publishing profile for the production slot.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlot(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, slot string) (result ReadCloser, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot")
	}

	req, err := client.ListPublishingProfileXMLWithSecretsSlotPreparer(resourceGroupName, name, publishingProfileOptions, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPublishingProfileXMLWithSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListPublishingProfileXMLWithSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListPublishingProfileXMLWithSecretsSlot", resp, "Failure responding to request")
	}

	return
}

// ListPublishingProfileXMLWithSecretsSlotPreparer prepares the ListPublishingProfileXMLWithSecretsSlot request.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotPreparer(resourceGroupName string, name string, publishingProfileOptions CsmPublishingProfileOptions, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml", pathParameters),
		autorest.WithJSON(publishingProfileOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListPublishingProfileXMLWithSecretsSlotSender sends the ListPublishingProfileXMLWithSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListPublishingProfileXMLWithSecretsSlotResponder handles the response to the ListPublishingProfileXMLWithSecretsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListPublishingProfileXMLWithSecretsSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRelayServiceConnections gets hybrid connections configured for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListRelayServiceConnections(resourceGroupName string, name string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListRelayServiceConnections")
	}

	req, err := client.ListRelayServiceConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRelayServiceConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListRelayServiceConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnections", resp, "Failure responding to request")
	}

	return
}

// ListRelayServiceConnectionsPreparer prepares the ListRelayServiceConnections request.
func (client AppsClient) ListRelayServiceConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRelayServiceConnectionsSender sends the ListRelayServiceConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListRelayServiceConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRelayServiceConnectionsResponder handles the response to the ListRelayServiceConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListRelayServiceConnectionsResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRelayServiceConnectionsSlot gets hybrid connections configured for an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get hybrid connections for the production slot.
func (client AppsClient) ListRelayServiceConnectionsSlot(resourceGroupName string, name string, slot string) (result RelayServiceConnectionEntity, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot")
	}

	req, err := client.ListRelayServiceConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRelayServiceConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListRelayServiceConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListRelayServiceConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListRelayServiceConnectionsSlotPreparer prepares the ListRelayServiceConnectionsSlot request.
func (client AppsClient) ListRelayServiceConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRelayServiceConnectionsSlotSender sends the ListRelayServiceConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListRelayServiceConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRelayServiceConnectionsSlotResponder handles the response to the ListRelayServiceConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListRelayServiceConnectionsSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteExtensions get list of siteextensions for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListSiteExtensions(resourceGroupName string, name string) (result SiteExtensionInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSiteExtensions")
	}

	req, err := client.ListSiteExtensionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteExtensionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteExtensionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", resp, "Failure responding to request")
	}

	return
}

// ListSiteExtensionsPreparer prepares the ListSiteExtensions request.
func (client AppsClient) ListSiteExtensionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteExtensionsSender sends the ListSiteExtensions request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSiteExtensionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteExtensionsResponder handles the response to the ListSiteExtensions request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSiteExtensionsResponder(resp *http.Response) (result SiteExtensionInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteExtensionsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSiteExtensionsNextResults(lastResults SiteExtensionInfoCollection) (result SiteExtensionInfoCollection, err error) {
	req, err := lastResults.SiteExtensionInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSiteExtensionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", resp, "Failure sending next results request")
	}

	result, err = client.ListSiteExtensionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensions", resp, "Failure responding to next results request")
	}

	return
}

// ListSiteExtensionsComplete gets all elements from the list without paging.
func (client AppsClient) ListSiteExtensionsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan SiteExtensionInfo, <-chan error) {
	resultChan := make(chan SiteExtensionInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSiteExtensions(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSiteExtensionsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSiteExtensionsSlot get list of siteextensions for a web site, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
func (client AppsClient) ListSiteExtensionsSlot(resourceGroupName string, name string, slot string) (result SiteExtensionInfoCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSiteExtensionsSlot")
	}

	req, err := client.ListSiteExtensionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteExtensionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteExtensionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSiteExtensionsSlotPreparer prepares the ListSiteExtensionsSlot request.
func (client AppsClient) ListSiteExtensionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/siteextensions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSiteExtensionsSlotSender sends the ListSiteExtensionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSiteExtensionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSiteExtensionsSlotResponder handles the response to the ListSiteExtensionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSiteExtensionsSlotResponder(resp *http.Response) (result SiteExtensionInfoCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteExtensionsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSiteExtensionsSlotNextResults(lastResults SiteExtensionInfoCollection) (result SiteExtensionInfoCollection, err error) {
	req, err := lastResults.SiteExtensionInfoCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSiteExtensionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListSiteExtensionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSiteExtensionsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListSiteExtensionsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListSiteExtensionsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan SiteExtensionInfo, <-chan error) {
	resultChan := make(chan SiteExtensionInfo)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSiteExtensionsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSiteExtensionsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSitePushSettings gets the Push settings associated with web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app.
func (client AppsClient) ListSitePushSettings(resourceGroupName string, name string) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSitePushSettings")
	}

	req, err := client.ListSitePushSettingsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePushSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePushSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettings", resp, "Failure responding to request")
	}

	return
}

// ListSitePushSettingsPreparer prepares the ListSitePushSettings request.
func (client AppsClient) ListSitePushSettingsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePushSettingsSender sends the ListSitePushSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSitePushSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSitePushSettingsResponder handles the response to the ListSitePushSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSitePushSettingsResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePushSettingsSlot gets the Push settings associated with web app.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of web app. slot is name
// of web app slot. If not specified then will default to production slot.
func (client AppsClient) ListSitePushSettingsSlot(resourceGroupName string, name string, slot string) (result PushSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSitePushSettingsSlot")
	}

	req, err := client.ListSitePushSettingsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePushSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePushSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSitePushSettingsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSitePushSettingsSlotPreparer prepares the ListSitePushSettingsSlot request.
func (client AppsClient) ListSitePushSettingsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSitePushSettingsSlotSender sends the ListSitePushSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSitePushSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSitePushSettingsSlotResponder handles the response to the ListSitePushSettingsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSitePushSettingsSlotResponder(resp *http.Response) (result PushSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotConfigurationNames gets the names of app settings and connection strings that stick to the slot (not
// swapped).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListSlotConfigurationNames(resourceGroupName string, name string) (result SlotConfigNamesResource, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotConfigurationNames")
	}

	req, err := client.ListSlotConfigurationNamesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotConfigurationNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotConfigurationNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotConfigurationNames", resp, "Failure responding to request")
	}

	return
}

// ListSlotConfigurationNamesPreparer prepares the ListSlotConfigurationNames request.
func (client AppsClient) ListSlotConfigurationNamesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotConfigurationNamesSender sends the ListSlotConfigurationNames request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotConfigurationNamesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSlotConfigurationNamesResponder handles the response to the ListSlotConfigurationNames request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotConfigurationNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesFromProduction get the difference in configuration settings between two web app slots.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// slotSwapEntity is JSON object that contains the target slot name. See example.
func (client AppsClient) ListSlotDifferencesFromProduction(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SlotDifferenceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotDifferencesFromProduction")
	}

	req, err := client.ListSlotDifferencesFromProductionPreparer(resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure responding to request")
	}

	return
}

// ListSlotDifferencesFromProductionPreparer prepares the ListSlotDifferencesFromProduction request.
func (client AppsClient) ListSlotDifferencesFromProductionPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotDifferencesFromProductionSender sends the ListSlotDifferencesFromProduction request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotDifferencesFromProductionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSlotDifferencesFromProductionResponder handles the response to the ListSlotDifferencesFromProduction request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotDifferencesFromProductionResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesFromProductionNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotDifferencesFromProductionNextResults(lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.SlotDifferenceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesFromProduction", resp, "Failure responding to next results request")
	}

	return
}

// ListSlotDifferencesFromProductionComplete gets all elements from the list without paging.
func (client AppsClient) ListSlotDifferencesFromProductionComplete(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, cancel <-chan struct{}) (<-chan SlotDifference, <-chan error) {
	resultChan := make(chan SlotDifference)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSlotDifferencesFromProduction(resourceGroupName, name, slotSwapEntity)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSlotDifferencesFromProductionNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSlotDifferencesSlot get the difference in configuration settings between two web app slots.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
// slotSwapEntity is JSON object that contains the target slot name. See example. slot is name of the source slot. If a
// slot is not specified, the production slot is used as the source slot.
func (client AppsClient) ListSlotDifferencesSlot(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SlotDifferenceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: slotSwapEntity,
			Constraints: []validation.Constraint{{Target: "slotSwapEntity.TargetSlot", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "slotSwapEntity.PreserveVnet", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlotDifferencesSlot")
	}

	req, err := client.ListSlotDifferencesSlotPreparer(resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure responding to request")
	}

	return
}

// ListSlotDifferencesSlotPreparer prepares the ListSlotDifferencesSlot request.
func (client AppsClient) ListSlotDifferencesSlotPreparer(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotDifferencesSlotSender sends the ListSlotDifferencesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotDifferencesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSlotDifferencesSlotResponder handles the response to the ListSlotDifferencesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotDifferencesSlotResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotDifferencesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotDifferencesSlotNextResults(lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.SlotDifferenceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlotDifferencesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListSlotDifferencesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListSlotDifferencesSlotComplete(resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string, cancel <-chan struct{}) (<-chan SlotDifference, <-chan error) {
	resultChan := make(chan SlotDifference)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSlotDifferencesSlot(resourceGroupName, name, slotSwapEntity, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSlotDifferencesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSlots gets an app's deployment slots.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListSlots(resourceGroupName string, name string) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSlots")
	}

	req, err := client.ListSlotsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure sending request")
		return
	}

	result, err = client.ListSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure responding to request")
	}

	return
}

// ListSlotsPreparer prepares the ListSlots request.
func (client AppsClient) ListSlotsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSlotsSender sends the ListSlots request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSlotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSlotsResponder handles the response to the ListSlots request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSlotsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSlotsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSlotsNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure sending next results request")
	}

	result, err = client.ListSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSlots", resp, "Failure responding to next results request")
	}

	return
}

// ListSlotsComplete gets all elements from the list without paging.
func (client AppsClient) ListSlotsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSlots(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSlotsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSnapshots returns all Snapshots to the user.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is website Name.
func (client AppsClient) ListSnapshots(resourceGroupName string, name string) (result SnapshotCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSnapshots")
	}

	req, err := client.ListSnapshotsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure sending request")
		return
	}

	result, err = client.ListSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure responding to request")
	}

	return
}

// ListSnapshotsPreparer prepares the ListSnapshots request.
func (client AppsClient) ListSnapshotsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSnapshotsSender sends the ListSnapshots request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSnapshotsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSnapshotsResponder handles the response to the ListSnapshots request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSnapshotsResponder(resp *http.Response) (result SnapshotCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSnapshotsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSnapshotsNextResults(lastResults SnapshotCollection) (result SnapshotCollection, err error) {
	req, err := lastResults.SnapshotCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure sending next results request")
	}

	result, err = client.ListSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshots", resp, "Failure responding to next results request")
	}

	return
}

// ListSnapshotsComplete gets all elements from the list without paging.
func (client AppsClient) ListSnapshotsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan Snapshot, <-chan error) {
	resultChan := make(chan Snapshot)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSnapshots(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSnapshotsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSnapshotsSlot returns all Snapshots to the user.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is website Name. slot is website
// Slot.
func (client AppsClient) ListSnapshotsSlot(resourceGroupName string, name string, slot string) (result SnapshotCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSnapshotsSlot")
	}

	req, err := client.ListSnapshotsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure responding to request")
	}

	return
}

// ListSnapshotsSlotPreparer prepares the ListSnapshotsSlot request.
func (client AppsClient) ListSnapshotsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSnapshotsSlotSender sends the ListSnapshotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSnapshotsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSnapshotsSlotResponder handles the response to the ListSnapshotsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSnapshotsSlotResponder(resp *http.Response) (result SnapshotCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSnapshotsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListSnapshotsSlotNextResults(lastResults SnapshotCollection) (result SnapshotCollection, err error) {
	req, err := lastResults.SnapshotCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSnapshotsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListSnapshotsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListSnapshotsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan Snapshot, <-chan error) {
	resultChan := make(chan Snapshot)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListSnapshotsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListSnapshotsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListSyncFunctionTriggers this is to allow calling via powershell and ARM template.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListSyncFunctionTriggers(resourceGroupName string, name string) (result FunctionSecrets, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSyncFunctionTriggers")
	}

	req, err := client.ListSyncFunctionTriggersPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSyncFunctionTriggersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggers", resp, "Failure sending request")
		return
	}

	result, err = client.ListSyncFunctionTriggersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggers", resp, "Failure responding to request")
	}

	return
}

// ListSyncFunctionTriggersPreparer prepares the ListSyncFunctionTriggers request.
func (client AppsClient) ListSyncFunctionTriggersPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listsyncfunctiontriggerstatus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSyncFunctionTriggersSender sends the ListSyncFunctionTriggers request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSyncFunctionTriggersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSyncFunctionTriggersResponder handles the response to the ListSyncFunctionTriggers request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSyncFunctionTriggersResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSyncFunctionTriggersSlot this is to allow calling via powershell and ARM template.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will restore a backup of the production slot.
func (client AppsClient) ListSyncFunctionTriggersSlot(resourceGroupName string, name string, slot string) (result FunctionSecrets, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListSyncFunctionTriggersSlot")
	}

	req, err := client.ListSyncFunctionTriggersSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSyncFunctionTriggersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggersSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSyncFunctionTriggersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListSyncFunctionTriggersSlot", resp, "Failure responding to request")
	}

	return
}

// ListSyncFunctionTriggersSlotPreparer prepares the ListSyncFunctionTriggersSlot request.
func (client AppsClient) ListSyncFunctionTriggersSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/listsyncfunctiontriggerstatus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSyncFunctionTriggersSlotSender sends the ListSyncFunctionTriggersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSyncFunctionTriggersSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListSyncFunctionTriggersSlotResponder handles the response to the ListSyncFunctionTriggersSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSyncFunctionTriggersSlotResponder(resp *http.Response) (result FunctionSecrets, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTriggeredWebJobHistory list a triggered web job's history for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID.
func (client AppsClient) ListTriggeredWebJobHistory(resourceGroupName string, name string, webJobID string, webJobName string) (result TriggeredJobHistoryCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListTriggeredWebJobHistory")
	}

	req, err := client.ListTriggeredWebJobHistoryPreparer(resourceGroupName, name, webJobID, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTriggeredWebJobHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", resp, "Failure sending request")
		return
	}

	result, err = client.ListTriggeredWebJobHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", resp, "Failure responding to request")
	}

	return
}

// ListTriggeredWebJobHistoryPreparer prepares the ListTriggeredWebJobHistory request.
func (client AppsClient) ListTriggeredWebJobHistoryPreparer(resourceGroupName string, name string, webJobID string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs/{webJobName}/history", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListTriggeredWebJobHistorySender sends the ListTriggeredWebJobHistory request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListTriggeredWebJobHistorySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListTriggeredWebJobHistoryResponder handles the response to the ListTriggeredWebJobHistory request. The method always
// closes the http.Response Body.
func (client AppsClient) ListTriggeredWebJobHistoryResponder(resp *http.Response) (result TriggeredJobHistoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTriggeredWebJobHistoryNextResults retrieves the next set of results, if any.
func (client AppsClient) ListTriggeredWebJobHistoryNextResults(lastResults TriggeredJobHistoryCollection) (result TriggeredJobHistoryCollection, err error) {
	req, err := lastResults.TriggeredJobHistoryCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListTriggeredWebJobHistorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", resp, "Failure sending next results request")
	}

	result, err = client.ListTriggeredWebJobHistoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistory", resp, "Failure responding to next results request")
	}

	return
}

// ListTriggeredWebJobHistoryComplete gets all elements from the list without paging.
func (client AppsClient) ListTriggeredWebJobHistoryComplete(resourceGroupName string, name string, webJobID string, webJobName string, cancel <-chan struct{}) (<-chan TriggeredJobHistory, <-chan error) {
	resultChan := make(chan TriggeredJobHistory)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListTriggeredWebJobHistory(resourceGroupName, name, webJobID, webJobName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListTriggeredWebJobHistoryNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListTriggeredWebJobHistorySlot list a triggered web job's history for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. webJobID is web
// job ID. slot is name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
// production slot.
func (client AppsClient) ListTriggeredWebJobHistorySlot(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (result TriggeredJobHistoryCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot")
	}

	req, err := client.ListTriggeredWebJobHistorySlotPreparer(resourceGroupName, name, webJobID, slot, webJobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTriggeredWebJobHistorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListTriggeredWebJobHistorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", resp, "Failure responding to request")
	}

	return
}

// ListTriggeredWebJobHistorySlotPreparer prepares the ListTriggeredWebJobHistorySlot request.
func (client AppsClient) ListTriggeredWebJobHistorySlotPreparer(resourceGroupName string, name string, webJobID string, slot string, webJobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webJobName":        autorest.Encode("path", webJobName),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"webJobId":    autorest.Encode("query", webJobID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs/{webJobName}/history", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListTriggeredWebJobHistorySlotSender sends the ListTriggeredWebJobHistorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListTriggeredWebJobHistorySlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListTriggeredWebJobHistorySlotResponder handles the response to the ListTriggeredWebJobHistorySlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListTriggeredWebJobHistorySlotResponder(resp *http.Response) (result TriggeredJobHistoryCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTriggeredWebJobHistorySlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListTriggeredWebJobHistorySlotNextResults(lastResults TriggeredJobHistoryCollection) (result TriggeredJobHistoryCollection, err error) {
	req, err := lastResults.TriggeredJobHistoryCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListTriggeredWebJobHistorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", resp, "Failure sending next results request")
	}

	result, err = client.ListTriggeredWebJobHistorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobHistorySlot", resp, "Failure responding to next results request")
	}

	return
}

// ListTriggeredWebJobHistorySlotComplete gets all elements from the list without paging.
func (client AppsClient) ListTriggeredWebJobHistorySlotComplete(resourceGroupName string, name string, webJobID string, slot string, webJobName string, cancel <-chan struct{}) (<-chan TriggeredJobHistory, <-chan error) {
	resultChan := make(chan TriggeredJobHistory)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListTriggeredWebJobHistorySlot(resourceGroupName, name, webJobID, slot, webJobName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListTriggeredWebJobHistorySlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListTriggeredWebJobs list triggered web jobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListTriggeredWebJobs(resourceGroupName string, name string) (result TriggeredWebJobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListTriggeredWebJobs")
	}

	req, err := client.ListTriggeredWebJobsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTriggeredWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", resp, "Failure sending request")
		return
	}

	result, err = client.ListTriggeredWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", resp, "Failure responding to request")
	}

	return
}

// ListTriggeredWebJobsPreparer prepares the ListTriggeredWebJobs request.
func (client AppsClient) ListTriggeredWebJobsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/triggeredwebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListTriggeredWebJobsSender sends the ListTriggeredWebJobs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListTriggeredWebJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListTriggeredWebJobsResponder handles the response to the ListTriggeredWebJobs request. The method always
// closes the http.Response Body.
func (client AppsClient) ListTriggeredWebJobsResponder(resp *http.Response) (result TriggeredWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTriggeredWebJobsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListTriggeredWebJobsNextResults(lastResults TriggeredWebJobCollection) (result TriggeredWebJobCollection, err error) {
	req, err := lastResults.TriggeredWebJobCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListTriggeredWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", resp, "Failure sending next results request")
	}

	result, err = client.ListTriggeredWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobs", resp, "Failure responding to next results request")
	}

	return
}

// ListTriggeredWebJobsComplete gets all elements from the list without paging.
func (client AppsClient) ListTriggeredWebJobsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan TriggeredWebJob, <-chan error) {
	resultChan := make(chan TriggeredWebJob)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListTriggeredWebJobs(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListTriggeredWebJobsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListTriggeredWebJobsSlot list triggered web jobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API deletes a deployment for the production slot.
func (client AppsClient) ListTriggeredWebJobsSlot(resourceGroupName string, name string, slot string) (result TriggeredWebJobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListTriggeredWebJobsSlot")
	}

	req, err := client.ListTriggeredWebJobsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListTriggeredWebJobsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListTriggeredWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", resp, "Failure responding to request")
	}

	return
}

// ListTriggeredWebJobsSlotPreparer prepares the ListTriggeredWebJobsSlot request.
func (client AppsClient) ListTriggeredWebJobsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/triggeredwebjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListTriggeredWebJobsSlotSender sends the ListTriggeredWebJobsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListTriggeredWebJobsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListTriggeredWebJobsSlotResponder handles the response to the ListTriggeredWebJobsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListTriggeredWebJobsSlotResponder(resp *http.Response) (result TriggeredWebJobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListTriggeredWebJobsSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListTriggeredWebJobsSlotNextResults(lastResults TriggeredWebJobCollection) (result TriggeredWebJobCollection, err error) {
	req, err := lastResults.TriggeredWebJobCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListTriggeredWebJobsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListTriggeredWebJobsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListTriggeredWebJobsSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListTriggeredWebJobsSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListTriggeredWebJobsSlotComplete(resourceGroupName string, name string, slot string, cancel <-chan struct{}) (<-chan TriggeredWebJob, <-chan error) {
	resultChan := make(chan TriggeredWebJob)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListTriggeredWebJobsSlot(resourceGroupName, name, slot)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListTriggeredWebJobsSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListUsages gets the quota usage information of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. filter is
// return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1'
// or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and
// timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListUsages(resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListUsages")
	}

	req, err := client.ListUsagesPreparer(resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client AppsClient) ListUsagesPreparer(resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client AppsClient) ListUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsagesNextResults retrieves the next set of results, if any.
func (client AppsClient) ListUsagesNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure sending next results request")
	}

	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsages", resp, "Failure responding to next results request")
	}

	return
}

// ListUsagesComplete gets all elements from the list without paging.
func (client AppsClient) ListUsagesComplete(resourceGroupName string, name string, filter string, cancel <-chan struct{}) (<-chan CsmUsageQuota, <-chan error) {
	resultChan := make(chan CsmUsageQuota)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListUsages(resourceGroupName, name, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListUsagesNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListUsagesSlot gets the quota usage information of an app (or deployment slot, if specified).
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get quota information of the production slot.
// filter is return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq
// 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppsClient) ListUsagesSlot(resourceGroupName string, name string, slot string, filter string) (result CsmUsageQuotaCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListUsagesSlot")
	}

	req, err := client.ListUsagesSlotPreparer(resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure responding to request")
	}

	return
}

// ListUsagesSlotPreparer prepares the ListUsagesSlot request.
func (client AppsClient) ListUsagesSlotPreparer(resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListUsagesSlotSender sends the ListUsagesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListUsagesSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListUsagesSlotResponder handles the response to the ListUsagesSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListUsagesSlotResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsagesSlotNextResults retrieves the next set of results, if any.
func (client AppsClient) ListUsagesSlotNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.CsmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure sending next results request")
	}

	result, err = client.ListUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListUsagesSlot", resp, "Failure responding to next results request")
	}

	return
}

// ListUsagesSlotComplete gets all elements from the list without paging.
func (client AppsClient) ListUsagesSlotComplete(resourceGroupName string, name string, slot string, filter string, cancel <-chan struct{}) (<-chan CsmUsageQuota, <-chan error) {
	resultChan := make(chan CsmUsageQuota)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListUsagesSlot(resourceGroupName, name, slot, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListUsagesSlotNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListVnetConnections gets the virtual networks the app (or deployment slot) is connected to.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app.
func (client AppsClient) ListVnetConnections(resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListVnetConnections")
	}

	req, err := client.ListVnetConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnections", resp, "Failure responding to request")
	}

	return
}

// ListVnetConnectionsPreparer prepares the ListVnetConnections request.
func (client AppsClient) ListVnetConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVnetConnectionsSender sends the ListVnetConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListVnetConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListVnetConnectionsResponder handles the response to the ListVnetConnections request. The method always
// closes the http.Response Body.
func (client AppsClient) ListVnetConnectionsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListVnetConnectionsSlot gets the virtual networks the app (or deployment slot) is connected to.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the app. slot is name
// of the deployment slot. If a slot is not specified, the API will get virtual network connections for the production
// slot.
func (client AppsClient) ListVnetConnectionsSlot(resourceGroupName string, name string, slot string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListVnetConnectionsSlot")
	}

	req, err := client.ListVnetConnectionsSlotPreparer(resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListVnetConnectionsSlot", resp, "Failure responding to request")
	}

	return
}

// ListVnetConnectionsSlotPreparer prepares the ListVnetConnectionsSlot request.
func (client AppsClient) ListVnetConnectionsSlotPreparer(resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVnetConnectionsSlotSender sends the ListVnetConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListVnetConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListVnetConnectionsSlotResponder handles the response to the ListVnetConnectionsSlot request. The method always
// closes the http.Response Body.
func (client AppsClient) ListVnetConnectionsSlotResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebJobs list webjobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name.
func (client AppsClient) ListWebJobs(resourceGroupName string, name string) (result JobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListWebJobs")
	}

	req, err := client.ListWebJobsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", resp, "Failure responding to request")
	}

	return
}

// ListWebJobsPreparer prepares the ListWebJobs request.
func (client AppsClient) ListWebJobsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/webjobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebJobsSender sends the ListWebJobs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListWebJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListWebJobsResponder handles the response to the ListWebJobs request. The method always
// closes the http.Response Body.
func (client AppsClient) ListWebJobsResponder(resp *http.Response) (result JobCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebJobsNextResults retrieves the next set of results, if any.
func (client AppsClient) ListWebJobsNextResults(lastResults JobCollection) (result JobCollection, err error) {
	req, err := lastResults.JobCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", resp, "Failure sending next results request")
	}

	result, err = client.ListWebJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppsClient", "ListWebJobs", resp, "Failure responding to next results request")
	}

	return
}

// ListWebJobsComplete gets all elements from the list without paging.
func (client AppsClient) ListWebJobsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan Job, <-chan error) {
	resultChan := make(chan Job)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListWebJobs(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListWebJobsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListWebJobsSlot list webjobs for an app, or a deployment slot.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is site name. slot is name of
// the deployment slot. If a slot is not specified, the API returns deployments for the production slot.
func (client AppsClient) ListWebJobsSlot(resourceGroupName string, name string, slot string) (result JobCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppsClient", "ListWebJobsSlot")
	}

	req, err := client.ListWebJobsSlot