package storageimportexport

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// DriveState enumerates the values for drive state.
type DriveState string

const (
	// Completed specifies the completed state for drive state.
	Completed DriveState = "Completed"
	// CompletedMoreInfo specifies the completed more info state for drive state.
	CompletedMoreInfo DriveState = "CompletedMoreInfo"
	// NeverReceived specifies the never received state for drive state.
	NeverReceived DriveState = "NeverReceived"
	// Received specifies the received state for drive state.
	Received DriveState = "Received"
	// ShippedBack specifies the shipped back state for drive state.
	ShippedBack DriveState = "ShippedBack"
	// Specified specifies the specified state for drive state.
	Specified DriveState = "Specified"
	// Transferring specifies the transferring state for drive state.
	Transferring DriveState = "Transferring"
)

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateClosed specifies the job state closed state for job state.
	JobStateClosed JobState = "Closed"
	// JobStateCompleted specifies the job state completed state for job state.
	JobStateCompleted JobState = "Completed"
	// JobStateCreating specifies the job state creating state for job state.
	JobStateCreating JobState = "Creating"
	// JobStatePackaging specifies the job state packaging state for job state.
	JobStatePackaging JobState = "Packaging"
	// JobStateReceived specifies the job state received state for job state.
	JobStateReceived JobState = "Received"
	// JobStateShipping specifies the job state shipping state for job state.
	JobStateShipping JobState = "Shipping"
	// JobStateTransferring specifies the job state transferring state for job state.
	JobStateTransferring JobState = "Transferring"
)

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeExport specifies the job type export state for job type.
	JobTypeExport JobType = "Export"
	// JobTypeImport specifies the job type import state for job type.
	JobTypeImport JobType = "Import"
)

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// Error specifies the error state for log level.
	Error LogLevel = "Error"
	// Verbose specifies the verbose state for log level.
	Verbose LogLevel = "Verbose"
)

// MutableJobState enumerates the values for mutable job state.
type MutableJobState string

const (
	// Shipping specifies the shipping state for mutable job state.
	Shipping MutableJobState = "Shipping"
)

// BitLockerKeysListResult is list of BitLocker keys for the specified import/export job.
type BitLockerKeysListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DriveStatus `json:"value,omitempty"`
}

// Drive is provides information about the drive that contains information about the import/export jobs.
type Drive struct {
	DriveID      *string `json:"driveId,omitempty"`
	BitLockerKey *string `json:"bitLockerKey,omitempty"`
	ManifestFile *string `json:"manifestFile,omitempty"`
	ManifestHash *string `json:"manifestHash,omitempty"`
}

// DriveStatus is provides information about the drive's status.
type DriveStatus struct {
	DriveID         *string    `json:"driveId,omitempty"`
	BitLockerKey    *string    `json:"bitLockerKey,omitempty"`
	ManifestFile    *string    `json:"manifestFile,omitempty"`
	ManifestHash    *string    `json:"manifestHash,omitempty"`
	State           DriveState `json:"state,omitempty"`
	CopyStatus      *string    `json:"copyStatus,omitempty"`
	PercentComplete *int32     `json:"percentComplete,omitempty"`
	VerboseLogURI   *string    `json:"verboseLogUri,omitempty"`
	ErrorLogURI     *string    `json:"errorLogUri,omitempty"`
	ManifestURI     *string    `json:"manifestUri,omitempty"`
}

// ErrorBase is describes the common properties of the Error object
type ErrorBase struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
}

// ErrorInfo is describes the error information.
type ErrorInfo struct {
	Code    *string      `json:"code,omitempty"`
	Message *string      `json:"message,omitempty"`
	Target  *string      `json:"target,omitempty"`
	Details *[]ErrorBase `json:"details,omitempty"`
}

// ErrorResponse is describes the model for Error Response.
type ErrorResponse struct {
	Error *ErrorInfo `json:"error,omitempty"`
}

// Export is a property containing information about the blobs to be exported for an export job. This property is
// required for export jobs, but must not be specified for import jobs.
type Export struct {
	*ExportBlobList  `json:"blobList,omitempty"`
	BlobListblobPath *string `json:"blobListblobPath,omitempty"`
}

// ExportBlobList is a list of the blobs to be exported.
type ExportBlobList struct {
	BlobPath       *[]string `json:"blobPath,omitempty"`
	BlobPathPrefix *[]string `json:"blobPathPrefix,omitempty"`
}

// Job is describes an import/export job.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Type              *string                 `json:"type,omitempty"`
	Location          *string                 `json:"location,omitempty"`
	Tags              *map[string]interface{} `json:"tags,omitempty"`
	*JobProperties    `json:"properties,omitempty"`
}

// JobListResult is list of import/export jobs.
type JobListResult struct {
	autorest.Response `json:"-"`
	NextLink          *string `json:"nextLink,omitempty"`
	Value             *[]Job  `json:"value,omitempty"`
}

// JobListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobListResult) JobListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobProperties is import/export job specific properties.
type JobProperties struct {
	StorageAccountID      *string              `json:"storageAccountId,omitempty"`
	ContainerSas          *string              `json:"containerSas,omitempty"`
	JobType               JobType              `json:"jobType,omitempty"`
	ReturnAddress         *ReturnAddress       `json:"returnAddress,omitempty"`
	ReturnShipping        *ReturnShipping      `json:"returnShipping,omitempty"`
	ShippingInformation   *ShippingInformation `json:"shippingInformation,omitempty"`
	DeliveryPackage       *PackageInfomation   `json:"deliveryPackage,omitempty"`
	ReturnPackage         *PackageInfomation   `json:"returnPackage,omitempty"`
	DiagnosticsPath       *string              `json:"diagnosticsPath,omitempty"`
	LogLevel              LogLevel             `json:"logLevel,omitempty"`
	BackupDriveManifest   *bool                `json:"backupDriveManifest,omitempty"`
	State                 JobState             `json:"state,omitempty"`
	CancelRequested       *bool                `json:"cancelRequested,omitempty"`
	PercentComplete       *int32               `json:"percentComplete,omitempty"`
	IncompleteBlobListURI *string              `json:"incompleteBlobListUri,omitempty"`
	DriveList             *[]DriveStatus       `json:"driveList,omitempty"`
	Export                *Export              `json:"export,omitempty"`
	ProvisioningState     *string              `json:"provisioningState,omitempty"`
}

// Location is provides information about an Azure data center location.
type Location struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	Type                *string `json:"type,omitempty"`
	*LocationProperties `json:"properties,omitempty"`
}

// LocationProperties is describes the properties of a location.
type LocationProperties struct {
	RecipientName      *string   `json:"recipientName,omitempty"`
	StreetAddress1     *string   `json:"streetAddress1,omitempty"`
	StreetAddress2     *string   `json:"streetAddress2,omitempty"`
	City               *string   `json:"city,omitempty"`
	StateOrProvince    *string   `json:"stateOrProvince,omitempty"`
	PostalCode         *string   `json:"postalCode,omitempty"`
	CountryOrRegion    *string   `json:"countryOrRegion,omitempty"`
	Phone              *string   `json:"phone,omitempty"`
	SupportedCarriers  *[]string `json:"supportedCarriers,omitempty"`
	AlternateLocations *[]string `json:"alternateLocations,omitempty"`
}

// LocationsListResult is list of locations.
type LocationsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Location `json:"value,omitempty"`
}

// MoveJobParameters is defines the parameters that need to be provided for moving an import/export job from one
// reesource group to another.
type MoveJobParameters struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// MutableJob is describes the updatable properties of the job
type MutableJob struct {
	Tags                  *map[string]interface{} `json:"tags,omitempty"`
	*MutableJobProperties `json:"properties,omitempty"`
}

// MutableJobProperties is properties of the job that can be updated.
type MutableJobProperties struct {
	CancelRequested     *bool              `json:"cancelRequested,omitempty"`
	State               MutableJobState    `json:"state,omitempty"`
	ReturnAddress       *ReturnAddress     `json:"returnAddress,omitempty"`
	ReturnShipping      *ReturnShipping    `json:"returnShipping,omitempty"`
	DeliveryPackage     *PackageInfomation `json:"deliveryPackage,omitempty"`
	LogLevel            *string            `json:"logLevel,omitempty"`
	BackupDriveManifest *bool              `json:"backupDriveManifest,omitempty"`
}

// Operation is describes a supported operation by the Storage Import/Export job API.
type Operation struct {
	Name                         *string `json:"name,omitempty"`
	*OperationDisplayInformation `json:"display,omitempty"`
}

// OperationDisplayInformation is display information about the operation.
type OperationDisplayInformation struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// PackageInfomation is provides information about the package being shipped by the customer to the Microsoft data
// center.
type PackageInfomation struct {
	CarrierName    *string `json:"carrierName,omitempty"`
	TrackingNumber *string `json:"trackingNumber,omitempty"`
	DriveCount     *int32  `json:"driveCount,omitempty"`
	ShipDate       *string `json:"shipDate,omitempty"`
}

// Resource is the Resource model definition.
type Resource struct {
	ID       *string                 `json:"id,omitempty"`
	Name     *string                 `json:"name,omitempty"`
	Type     *string                 `json:"type,omitempty"`
	Location *string                 `json:"location,omitempty"`
	Tags     *map[string]interface{} `json:"tags,omitempty"`
}

// ReturnAddress is specifies the return address information for the job.
type ReturnAddress struct {
	RecipientName   *string `json:"recipientName,omitempty"`
	StreetAddress1  *string `json:"streetAddress1,omitempty"`
	StreetAddress2  *string `json:"streetAddress2,omitempty"`
	City            *string `json:"city,omitempty"`
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	PostalCode      *string `json:"postalCode,omitempty"`
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`
	Phone           *string `json:"phone,omitempty"`
	Email           *string `json:"email,omitempty"`
}

// ReturnShipping is specifies the return carrier and customer's account with the carrier.
type ReturnShipping struct {
	CarrierName          *string `json:"carrierName,omitempty"`
	CarrierAccountNumber *string `json:"carrierAccountNumber,omitempty"`
}

// ShippingInformation is provides information about the Microsoft datacenter to which the drives should be shipped.
type ShippingInformation struct {
	Name    *string `json:"name,omitempty"`
	Address *string `json:"address,omitempty"`
}

// SupportedOperationsListResult is list of supported operations by the import/export resource provider.
type SupportedOperationsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}
