package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	uuid "github.com/satori/go.uuid"
	"net/http"
)

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ADPassword specifies the ad password state for authentication type.
	ADPassword AuthenticationType = "ADPassword"
	// SQL specifies the sql state for authentication type.
	SQL AuthenticationType = "SQL"
)

// BackupLongTermRetentionPolicyState enumerates the values for backup long term retention policy state.
type BackupLongTermRetentionPolicyState string

const (
	// Disabled specifies the disabled state for backup long term retention policy state.
	Disabled BackupLongTermRetentionPolicyState = "Disabled"
	// Enabled specifies the enabled state for backup long term retention policy state.
	Enabled BackupLongTermRetentionPolicyState = "Enabled"
)

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled specifies the blob auditing policy state disabled state for blob auditing policy
	// state.
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled specifies the blob auditing policy state enabled state for blob auditing policy
	// state.
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable specifies the capability status available state for capability status.
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault specifies the capability status default state for capability status.
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled specifies the capability status disabled state for capability status.
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible specifies the capability status visible state for capability status.
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// AlreadyExists specifies the already exists state for check name availability reason.
	AlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// Invalid specifies the invalid state for check name availability reason.
	Invalid CheckNameAvailabilityReason = "Invalid"
)

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// Copy specifies the copy state for create mode.
	Copy CreateMode = "Copy"
	// Default specifies the default state for create mode.
	Default CreateMode = "Default"
	// NonReadableSecondary specifies the non readable secondary state for create mode.
	NonReadableSecondary CreateMode = "NonReadableSecondary"
	// OnlineSecondary specifies the online secondary state for create mode.
	OnlineSecondary CreateMode = "OnlineSecondary"
	// PointInTimeRestore specifies the point in time restore state for create mode.
	PointInTimeRestore CreateMode = "PointInTimeRestore"
	// Recovery specifies the recovery state for create mode.
	Recovery CreateMode = "Recovery"
	// Restore specifies the restore state for create mode.
	Restore CreateMode = "Restore"
	// RestoreLongTermRetentionBackup specifies the restore long term retention backup state for create mode.
	RestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
)

// DatabaseEdition enumerates the values for database edition.
type DatabaseEdition string

const (
	// Basic specifies the basic state for database edition.
	Basic DatabaseEdition = "Basic"
	// Business specifies the business state for database edition.
	Business DatabaseEdition = "Business"
	// DataWarehouse specifies the data warehouse state for database edition.
	DataWarehouse DatabaseEdition = "DataWarehouse"
	// Free specifies the free state for database edition.
	Free DatabaseEdition = "Free"
	// Premium specifies the premium state for database edition.
	Premium DatabaseEdition = "Premium"
	// Standard specifies the standard state for database edition.
	Standard DatabaseEdition = "Standard"
	// Stretch specifies the stretch state for database edition.
	Stretch DatabaseEdition = "Stretch"
	// System specifies the system state for database edition.
	System DatabaseEdition = "System"
	// System2 specifies the system 2 state for database edition.
	System2 DatabaseEdition = "System2"
	// Web specifies the web state for database edition.
	Web DatabaseEdition = "Web"
)

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN specifies the data masking function ccn state for data masking function.
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault specifies the data masking function default state for data masking function.
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail specifies the data masking function email state for data masking function.
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber specifies the data masking function number state for data masking function.
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN specifies the data masking function ssn state for data masking function.
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText specifies the data masking function text state for data masking function.
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled specifies the data masking rule state disabled state for data masking rule state.
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled specifies the data masking rule state enabled state for data masking rule state.
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled specifies the data masking state disabled state for data masking state.
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled specifies the data masking state enabled state for data masking state.
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// ElasticPoolEditionBasic specifies the elastic pool edition basic state for elastic pool edition.
	ElasticPoolEditionBasic ElasticPoolEdition = "Basic"
	// ElasticPoolEditionPremium specifies the elastic pool edition premium state for elastic pool edition.
	ElasticPoolEditionPremium ElasticPoolEdition = "Premium"
	// ElasticPoolEditionStandard specifies the elastic pool edition standard state for elastic pool edition.
	ElasticPoolEditionStandard ElasticPoolEdition = "Standard"
)

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating specifies the elastic pool state creating state for elastic pool state.
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled specifies the elastic pool state disabled state for elastic pool state.
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady specifies the elastic pool state ready state for elastic pool state.
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// FailoverGroupReplicationRole enumerates the values for failover group replication role.
type FailoverGroupReplicationRole string

const (
	// Primary specifies the primary state for failover group replication role.
	Primary FailoverGroupReplicationRole = "Primary"
	// Secondary specifies the secondary state for failover group replication role.
	Secondary FailoverGroupReplicationRole = "Secondary"
)

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled specifies the geo backup policy state disabled state for geo backup policy state.
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled specifies the geo backup policy state enabled state for geo backup policy state.
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// SystemAssigned specifies the system assigned state for identity type.
	SystemAssigned IdentityType = "SystemAssigned"
)

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// CancelInProgress specifies the cancel in progress state for management operation state.
	CancelInProgress ManagementOperationState = "CancelInProgress"
	// Cancelled specifies the cancelled state for management operation state.
	Cancelled ManagementOperationState = "Cancelled"
	// Failed specifies the failed state for management operation state.
	Failed ManagementOperationState = "Failed"
	// InProgress specifies the in progress state for management operation state.
	InProgress ManagementOperationState = "InProgress"
	// Pending specifies the pending state for management operation state.
	Pending ManagementOperationState = "Pending"
	// Succeeded specifies the succeeded state for management operation state.
	Succeeded ManagementOperationState = "Succeeded"
)

// MaxSizeUnits enumerates the values for max size units.
type MaxSizeUnits string

const (
	// Gigabytes specifies the gigabytes state for max size units.
	Gigabytes MaxSizeUnits = "Gigabytes"
	// Megabytes specifies the megabytes state for max size units.
	Megabytes MaxSizeUnits = "Megabytes"
	// Petabytes specifies the petabytes state for max size units.
	Petabytes MaxSizeUnits = "Petabytes"
	// Terabytes specifies the terabytes state for max size units.
	Terabytes MaxSizeUnits = "Terabytes"
)

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem specifies the operation origin system state for operation origin.
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser specifies the operation origin user state for operation origin.
	OperationOriginUser OperationOrigin = "user"
)

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU specifies the dtu state for performance level unit.
	DTU PerformanceLevelUnit = "DTU"
)

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// Average specifies the average state for primary aggregation type.
	Average PrimaryAggregationType = "Average"
	// Count specifies the count state for primary aggregation type.
	Count PrimaryAggregationType = "Count"
	// Maximum specifies the maximum state for primary aggregation type.
	Maximum PrimaryAggregationType = "Maximum"
	// Minimum specifies the minimum state for primary aggregation type.
	Minimum PrimaryAggregationType = "Minimum"
	// None specifies the none state for primary aggregation type.
	None PrimaryAggregationType = "None"
	// Total specifies the total state for primary aggregation type.
	Total PrimaryAggregationType = "Total"
)

// ReadOnlyEndpointFailoverPolicy enumerates the values for read only endpoint failover policy.
type ReadOnlyEndpointFailoverPolicy string

const (
	// ReadOnlyEndpointFailoverPolicyDisabled specifies the read only endpoint failover policy disabled state for read only
	// endpoint failover policy.
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	// ReadOnlyEndpointFailoverPolicyEnabled specifies the read only endpoint failover policy enabled state for read only
	// endpoint failover policy.
	ReadOnlyEndpointFailoverPolicyEnabled ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// ReadScale enumerates the values for read scale.
type ReadScale string

const (
	// ReadScaleDisabled specifies the read scale disabled state for read scale.
	ReadScaleDisabled ReadScale = "Disabled"
	// ReadScaleEnabled specifies the read scale enabled state for read scale.
	ReadScaleEnabled ReadScale = "Enabled"
)

// ReadWriteEndpointFailoverPolicy enumerates the values for read write endpoint failover policy.
type ReadWriteEndpointFailoverPolicy string

const (
	// Automatic specifies the automatic state for read write endpoint failover policy.
	Automatic ReadWriteEndpointFailoverPolicy = "Automatic"
	// Manual specifies the manual state for read write endpoint failover policy.
	Manual ReadWriteEndpointFailoverPolicy = "Manual"
)

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create specifies the create state for recommended index action.
	Create RecommendedIndexAction = "Create"
	// Drop specifies the drop state for recommended index action.
	Drop RecommendedIndexAction = "Drop"
	// Rebuild specifies the rebuild state for recommended index action.
	Rebuild RecommendedIndexAction = "Rebuild"
)

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// RecommendedIndexStateActive specifies the recommended index state active state for recommended index state.
	RecommendedIndexStateActive RecommendedIndexState = "Active"
	// RecommendedIndexStateBlocked specifies the recommended index state blocked state for recommended index state.
	RecommendedIndexStateBlocked RecommendedIndexState = "Blocked"
	// RecommendedIndexStateExecuting specifies the recommended index state executing state for recommended index state.
	RecommendedIndexStateExecuting RecommendedIndexState = "Executing"
	// RecommendedIndexStateExpired specifies the recommended index state expired state for recommended index state.
	RecommendedIndexStateExpired RecommendedIndexState = "Expired"
	// RecommendedIndexStateIgnored specifies the recommended index state ignored state for recommended index state.
	RecommendedIndexStateIgnored RecommendedIndexState = "Ignored"
	// RecommendedIndexStatePending specifies the recommended index state pending state for recommended index state.
	RecommendedIndexStatePending RecommendedIndexState = "Pending"
	// RecommendedIndexStatePendingRevert specifies the recommended index state pending revert state for recommended index
	// state.
	RecommendedIndexStatePendingRevert RecommendedIndexState = "Pending Revert"
	// RecommendedIndexStateReverted specifies the recommended index state reverted state for recommended index state.
	RecommendedIndexStateReverted RecommendedIndexState = "Reverted"
	// RecommendedIndexStateReverting specifies the recommended index state reverting state for recommended index state.
	RecommendedIndexStateReverting RecommendedIndexState = "Reverting"
	// RecommendedIndexStateSuccess specifies the recommended index state success state for recommended index state.
	RecommendedIndexStateSuccess RecommendedIndexState = "Success"
	// RecommendedIndexStateVerifying specifies the recommended index state verifying state for recommended index state.
	RecommendedIndexStateVerifying RecommendedIndexState = "Verifying"
)

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED specifies the clustered state for recommended index type.
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE specifies the clusteredcolumnstore state for recommended index type.
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE specifies the columnstore state for recommended index type.
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED specifies the nonclustered state for recommended index type.
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy specifies the replication role copy state for replication role.
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary specifies the replication role non readable secondary state for replication
	// role.
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary specifies the replication role primary state for replication role.
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary specifies the replication role secondary state for replication role.
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource specifies the replication role source state for replication role.
	ReplicationRoleSource ReplicationRole = "Source"
)

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP specifies the catchup state for replication state.
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING specifies the pending state for replication state.
	PENDING ReplicationState = "PENDING"
	// SEEDING specifies the seeding state for replication state.
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED specifies the suspended state for replication state.
	SUSPENDED ReplicationState = "SUSPENDED"
)

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS specifies the continuous state for restore point type.
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE specifies the discrete state for restore point type.
	DISCRETE RestorePointType = "DISCRETE"
)

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT specifies the adventure works lt state for sample name.
	AdventureWorksLT SampleName = "AdventureWorksLT"
)

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled specifies the security alert policy email account admins disabled
	// state for security alert policy email account admins.
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled specifies the security alert policy email account admins enabled state
	// for security alert policy email account admins.
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled specifies the security alert policy state disabled state for security alert policy
	// state.
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled specifies the security alert policy state enabled state for security alert policy
	// state.
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew specifies the security alert policy state new state for security alert policy state.
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled specifies the security alert policy use server default disabled state
	// for security alert policy use server default.
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled specifies the security alert policy use server default enabled state for
	// security alert policy use server default.
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault specifies the server connection type default state for server connection type.
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy specifies the server connection type proxy state for server connection type.
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect specifies the server connection type redirect state for server connection type.
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// AzureKeyVault specifies the azure key vault state for server key type.
	AzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServiceManaged specifies the service managed state for server key type.
	ServiceManaged ServerKeyType = "ServiceManaged"
)

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic specifies the service objective name basic state for service objective name.
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameElasticPool specifies the service objective name elastic pool state for service objective name.
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameP1 specifies the service objective name p1 state for service objective name.
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 specifies the service objective name p11 state for service objective name.
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 specifies the service objective name p15 state for service objective name.
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 specifies the service objective name p2 state for service objective name.
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 specifies the service objective name p3 state for service objective name.
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 specifies the service objective name p4 state for service objective name.
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 specifies the service objective name p6 state for service objective name.
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNameS0 specifies the service objective name s0 state for service objective name.
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 specifies the service objective name s1 state for service objective name.
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS2 specifies the service objective name s2 state for service objective name.
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 specifies the service objective name s3 state for service objective name.
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameSystem specifies the service objective name system state for service objective name.
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem2 specifies the service objective name system 2 state for service objective name.
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
)

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey specifies the shared access key state for storage key type.
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey specifies the storage access key state for storage key type.
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// SyncAgentState enumerates the values for sync agent state.
type SyncAgentState string

const (
	// NeverConnected specifies the never connected state for sync agent state.
	NeverConnected SyncAgentState = "NeverConnected"
	// Offline specifies the offline state for sync agent state.
	Offline SyncAgentState = "Offline"
	// Online specifies the online state for sync agent state.
	Online SyncAgentState = "Online"
)

// SyncConflictResolutionPolicy enumerates the values for sync conflict resolution policy.
type SyncConflictResolutionPolicy string

const (
	// HubWin specifies the hub win state for sync conflict resolution policy.
	HubWin SyncConflictResolutionPolicy = "HubWin"
	// MemberWin specifies the member win state for sync conflict resolution policy.
	MemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// SyncDirection enumerates the values for sync direction.
type SyncDirection string

const (
	// Bidirectional specifies the bidirectional state for sync direction.
	Bidirectional SyncDirection = "Bidirectional"
	// OneWayHubToMember specifies the one way hub to member state for sync direction.
	OneWayHubToMember SyncDirection = "OneWayHubToMember"
	// OneWayMemberToHub specifies the one way member to hub state for sync direction.
	OneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// SyncGroupLogType enumerates the values for sync group log type.
type SyncGroupLogType string

const (
	// All specifies the all state for sync group log type.
	All SyncGroupLogType = "All"
	// Error specifies the error state for sync group log type.
	Error SyncGroupLogType = "Error"
	// Success specifies the success state for sync group log type.
	Success SyncGroupLogType = "Success"
	// Warning specifies the warning state for sync group log type.
	Warning SyncGroupLogType = "Warning"
)

// SyncGroupState enumerates the values for sync group state.
type SyncGroupState string

const (
	// SyncGroupStateError specifies the sync group state error state for sync group state.
	SyncGroupStateError SyncGroupState = "Error"
	// SyncGroupStateGood specifies the sync group state good state for sync group state.
	SyncGroupStateGood SyncGroupState = "Good"
	// SyncGroupStateNotReady specifies the sync group state not ready state for sync group state.
	SyncGroupStateNotReady SyncGroupState = "NotReady"
	// SyncGroupStateProgressing specifies the sync group state progressing state for sync group state.
	SyncGroupStateProgressing SyncGroupState = "Progressing"
	// SyncGroupStateWarning specifies the sync group state warning state for sync group state.
	SyncGroupStateWarning SyncGroupState = "Warning"
)

// SyncMemberDbType enumerates the values for sync member db type.
type SyncMemberDbType string

const (
	// AzureSQLDatabase specifies the azure sql database state for sync member db type.
	AzureSQLDatabase SyncMemberDbType = "AzureSqlDatabase"
	// SQLServerDatabase specifies the sql server database state for sync member db type.
	SQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// SyncMemberState enumerates the values for sync member state.
type SyncMemberState string

const (
	// DeProvisioned specifies the de provisioned state for sync member state.
	DeProvisioned SyncMemberState = "DeProvisioned"
	// DeProvisionFailed specifies the de provision failed state for sync member state.
	DeProvisionFailed SyncMemberState = "DeProvisionFailed"
	// DeProvisioning specifies the de provisioning state for sync member state.
	DeProvisioning SyncMemberState = "DeProvisioning"
	// DisabledBackupRestore specifies the disabled backup restore state for sync member state.
	DisabledBackupRestore SyncMemberState = "DisabledBackupRestore"
	// DisabledTombstoneCleanup specifies the disabled tombstone cleanup state for sync member state.
	DisabledTombstoneCleanup SyncMemberState = "DisabledTombstoneCleanup"
	// Provisioned specifies the provisioned state for sync member state.
	Provisioned SyncMemberState = "Provisioned"
	// ProvisionFailed specifies the provision failed state for sync member state.
	ProvisionFailed SyncMemberState = "ProvisionFailed"
	// Provisioning specifies the provisioning state for sync member state.
	Provisioning SyncMemberState = "Provisioning"
	// ReprovisionFailed specifies the reprovision failed state for sync member state.
	ReprovisionFailed SyncMemberState = "ReprovisionFailed"
	// Reprovisioning specifies the reprovisioning state for sync member state.
	Reprovisioning SyncMemberState = "Reprovisioning"
	// SyncCancelled specifies the sync cancelled state for sync member state.
	SyncCancelled SyncMemberState = "SyncCancelled"
	// SyncCancelling specifies the sync cancelling state for sync member state.
	SyncCancelling SyncMemberState = "SyncCancelling"
	// SyncFailed specifies the sync failed state for sync member state.
	SyncFailed SyncMemberState = "SyncFailed"
	// SyncInProgress specifies the sync in progress state for sync member state.
	SyncInProgress SyncMemberState = "SyncInProgress"
	// SyncSucceeded specifies the sync succeeded state for sync member state.
	SyncSucceeded SyncMemberState = "SyncSucceeded"
	// SyncSucceededWithWarnings specifies the sync succeeded with warnings state for sync member state.
	SyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	// UnProvisioned specifies the un provisioned state for sync member state.
	UnProvisioned SyncMemberState = "UnProvisioned"
	// UnReprovisioned specifies the un reprovisioned state for sync member state.
	UnReprovisioned SyncMemberState = "UnReprovisioned"
)

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting specifies the decrypting state for transparent data encryption activity status.
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting specifies the encrypting state for transparent data encryption activity status.
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled specifies the transparent data encryption status disabled state for
	// transparent data encryption status.
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled specifies the transparent data encryption status enabled state for
	// transparent data encryption status.
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// UnitDefinitionTypeBytes specifies the unit definition type bytes state for unit definition type.
	UnitDefinitionTypeBytes UnitDefinitionType = "Bytes"
	// UnitDefinitionTypeBytesPerSecond specifies the unit definition type bytes per second state for unit definition type.
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// UnitDefinitionTypeCount specifies the unit definition type count state for unit definition type.
	UnitDefinitionTypeCount UnitDefinitionType = "Count"
	// UnitDefinitionTypeCountPerSecond specifies the unit definition type count per second state for unit definition type.
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	// UnitDefinitionTypePercent specifies the unit definition type percent state for unit definition type.
	UnitDefinitionTypePercent UnitDefinitionType = "Percent"
	// UnitDefinitionTypeSeconds specifies the unit definition type seconds state for unit definition type.
	UnitDefinitionTypeSeconds UnitDefinitionType = "Seconds"
)

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes specifies the unit type bytes state for unit type.
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond specifies the unit type bytes per second state for unit type.
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount specifies the unit type count state for unit type.
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond specifies the unit type count per second state for unit type.
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent specifies the unit type percent state for unit type.
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds specifies the unit type seconds state for unit type.
	UnitTypeSeconds UnitType = "seconds"
)

// VirtualNetworkRuleState enumerates the values for virtual network rule state.
type VirtualNetworkRuleState string

const (
	// VirtualNetworkRuleStateDeleting specifies the virtual network rule state deleting state for virtual network rule
	// state.
	VirtualNetworkRuleStateDeleting VirtualNetworkRuleState = "Deleting"
	// VirtualNetworkRuleStateInitializing specifies the virtual network rule state initializing state for virtual network
	// rule state.
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = "Initializing"
	// VirtualNetworkRuleStateInProgress specifies the virtual network rule state in progress state for virtual network
	// rule state.
	VirtualNetworkRuleStateInProgress VirtualNetworkRuleState = "InProgress"
	// VirtualNetworkRuleStateReady specifies the virtual network rule state ready state for virtual network rule state.
	VirtualNetworkRuleStateReady VirtualNetworkRuleState = "Ready"
	// VirtualNetworkRuleStateUnknown specifies the virtual network rule state unknown state for virtual network rule
	// state.
	VirtualNetworkRuleStateUnknown VirtualNetworkRuleState = "Unknown"
)

// BackupLongTermRetentionPolicy is a backup long term retention policy
type BackupLongTermRetentionPolicy struct {
	autorest.Response                        `json:"-"`
	ID                                       *string `json:"id,omitempty"`
	Name                                     *string `json:"name,omitempty"`
	Type                                     *string `json:"type,omitempty"`
	Location                                 *string `json:"location,omitempty"`
	*BackupLongTermRetentionPolicyProperties `json:"properties,omitempty"`
}

// BackupLongTermRetentionPolicyProperties is the properties of a backup long term retention policy
type BackupLongTermRetentionPolicyProperties struct {
	State                                  BackupLongTermRetentionPolicyState `json:"state,omitempty"`
	RecoveryServicesBackupPolicyResourceID *string                            `json:"recoveryServicesBackupPolicyResourceId,omitempty"`
}

// BackupLongTermRetentionVault is a backup long term retention vault
type BackupLongTermRetentionVault struct {
	autorest.Response                       `json:"-"`
	ID                                      *string `json:"id,omitempty"`
	Name                                    *string `json:"name,omitempty"`
	Type                                    *string `json:"type,omitempty"`
	Location                                *string `json:"location,omitempty"`
	*BackupLongTermRetentionVaultProperties `json:"properties,omitempty"`
}

// BackupLongTermRetentionVaultProperties is the properties of a backup long term retention vault.
type BackupLongTermRetentionVaultProperties struct {
	RecoveryServicesVaultResourceID *string `json:"recoveryServicesVaultResourceId,omitempty"`
}

// CheckNameAvailabilityRequest is a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse is a response indicating whether the specified name for a resource is available.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	Available         *bool                       `json:"available,omitempty"`
	Message           *string                     `json:"message,omitempty"`
	Name              *string                     `json:"name,omitempty"`
	Reason            CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// Database is represents a database.
type Database struct {
	autorest.Response   `json:"-"`
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	Location            *string             `json:"location,omitempty"`
	Kind                *string             `json:"kind,omitempty"`
	*DatabaseProperties `json:"properties,omitempty"`
}

// DatabaseBlobAuditingPolicy is a database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response                     `json:"-"`
	ID                                    *string `json:"id,omitempty"`
	Name                                  *string `json:"name,omitempty"`
	Type                                  *string `json:"type,omitempty"`
	Kind                                  *string `json:"kind,omitempty"`
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
}

// DatabaseBlobAuditingPolicyProperties is properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	State                        BlobAuditingPolicyState `json:"state,omitempty"`
	StorageEndpoint              *string                 `json:"storageEndpoint,omitempty"`
	StorageAccountAccessKey      *string                 `json:"storageAccountAccessKey,omitempty"`
	RetentionDays                *int32                  `json:"retentionDays,omitempty"`
	AuditActionsAndGroups        *[]string               `json:"auditActionsAndGroups,omitempty"`
	StorageAccountSubscriptionID *uuid.UUID              `json:"storageAccountSubscriptionId,omitempty"`
	IsStorageSecondaryKeyInUse   *bool                   `json:"isStorageSecondaryKeyInUse,omitempty"`
}

// DatabaseListResult is represents the response to a list database request.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Database `json:"value,omitempty"`
}

// DatabaseOperation is a database operation.
type DatabaseOperation struct {
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*DatabaseOperationProperties `json:"properties,omitempty"`
}

// DatabaseOperationListResult is the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DatabaseOperation `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// DatabaseOperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DatabaseOperationListResult) DatabaseOperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DatabaseOperationProperties is the properties of a database operation.
type DatabaseOperationProperties struct {
	DatabaseName          *string                  `json:"databaseName,omitempty"`
	Operation             *string                  `json:"operation,omitempty"`
	OperationFriendlyName *string                  `json:"operationFriendlyName,omitempty"`
	PercentComplete       *int32                   `json:"percentComplete,omitempty"`
	ServerName            *string                  `json:"serverName,omitempty"`
	StartTime             *date.Time               `json:"startTime,omitempty"`
	State                 ManagementOperationState `json:"state,omitempty"`
	ErrorCode             *int32                   `json:"errorCode,omitempty"`
	ErrorDescription      *string                  `json:"errorDescription,omitempty"`
	ErrorSeverity         *int32                   `json:"errorSeverity,omitempty"`
	IsUserError           *bool                    `json:"isUserError,omitempty"`
}

// DatabaseProperties is represents the properties of a database.
type DatabaseProperties struct {
	Collation                               *string                      `json:"collation,omitempty"`
	CreationDate                            *date.Time                   `json:"creationDate,omitempty"`
	ContainmentState                        *int64                       `json:"containmentState,omitempty"`
	CurrentServiceObjectiveID               *uuid.UUID                   `json:"currentServiceObjectiveId,omitempty"`
	DatabaseID                              *uuid.UUID                   `json:"databaseId,omitempty"`
	EarliestRestoreDate                     *date.Time                   `json:"earliestRestoreDate,omitempty"`
	CreateMode                              CreateMode                   `json:"createMode,omitempty"`
	SourceDatabaseID                        *string                      `json:"sourceDatabaseId,omitempty"`
	SourceDatabaseDeletionDate              *date.Time                   `json:"sourceDatabaseDeletionDate,omitempty"`
	RestorePointInTime                      *date.Time                   `json:"restorePointInTime,omitempty"`
	RecoveryServicesRecoveryPointResourceID *string                      `json:"recoveryServicesRecoveryPointResourceId,omitempty"`
	Edition                                 DatabaseEdition              `json:"edition,omitempty"`
	MaxSizeBytes                            *string                      `json:"maxSizeBytes,omitempty"`
	RequestedServiceObjectiveID             *uuid.UUID                   `json:"requestedServiceObjectiveId,omitempty"`
	RequestedServiceObjectiveName           ServiceObjectiveName         `json:"requestedServiceObjectiveName,omitempty"`
	ServiceLevelObjective                   ServiceObjectiveName         `json:"serviceLevelObjective,omitempty"`
	Status                                  *string                      `json:"status,omitempty"`
	ElasticPoolName                         *string                      `json:"elasticPoolName,omitempty"`
	DefaultSecondaryLocation                *string                      `json:"defaultSecondaryLocation,omitempty"`
	ServiceTierAdvisors                     *[]ServiceTierAdvisor        `json:"serviceTierAdvisors,omitempty"`
	TransparentDataEncryption               *[]TransparentDataEncryption `json:"transparentDataEncryption,omitempty"`
	RecommendedIndex                        *[]RecommendedIndex          `json:"recommendedIndex,omitempty"`
	FailoverGroupID                         *string                      `json:"failoverGroupId,omitempty"`
	ReadScale                               ReadScale                    `json:"readScale,omitempty"`
	SampleName                              SampleName                   `json:"sampleName,omitempty"`
}

// DatabaseSecurityAlertPolicy is contains information about a database Threat Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response                      `json:"-"`
	ID                                     *string `json:"id,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Type                                   *string `json:"type,omitempty"`
	Location                               *string `json:"location,omitempty"`
	Kind                                   *string `json:"kind,omitempty"`
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
}

// DatabaseSecurityAlertPolicyProperties is properties for a database Threat Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	State                   SecurityAlertPolicyState              `json:"state,omitempty"`
	DisabledAlerts          *string                               `json:"disabledAlerts,omitempty"`
	EmailAddresses          *string                               `json:"emailAddresses,omitempty"`
	EmailAccountAdmins      SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	StorageEndpoint         *string                               `json:"storageEndpoint,omitempty"`
	StorageAccountAccessKey *string                               `json:"storageAccountAccessKey,omitempty"`
	RetentionDays           *int32                                `json:"retentionDays,omitempty"`
	UseServerDefault        SecurityAlertPolicyUseServerDefault   `json:"useServerDefault,omitempty"`
}

// DatabaseUpdate is represents a database update.
type DatabaseUpdate struct {
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	*DatabaseProperties `json:"properties,omitempty"`
}

// DatabaseUsage is the database usages.
type DatabaseUsage struct {
	Name          *string    `json:"name,omitempty"`
	ResourceName  *string    `json:"resourceName,omitempty"`
	DisplayName   *string    `json:"displayName,omitempty"`
	CurrentValue  *float64   `json:"currentValue,omitempty"`
	Limit         *float64   `json:"limit,omitempty"`
	Unit          *string    `json:"unit,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// DatabaseUsageListResult is the response to a list database metrics request.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DatabaseUsage `json:"value,omitempty"`
}

// DataMaskingPolicy is represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	Location                     *string `json:"location,omitempty"`
	Kind                         *string `json:"kind,omitempty"`
}

// DataMaskingPolicyProperties is the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	DataMaskingState      DataMaskingState `json:"dataMaskingState,omitempty"`
	ExemptPrincipals      *string          `json:"exemptPrincipals,omitempty"`
	ApplicationPrincipals *string          `json:"applicationPrincipals,omitempty"`
	MaskingLevel          *string          `json:"maskingLevel,omitempty"`
}

// DataMaskingRule is represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	Location                   *string `json:"location,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
}

// DataMaskingRuleListResult is the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties is the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	ID                *string              `json:"id,omitempty"`
	AliasName         *string              `json:"aliasName,omitempty"`
	RuleState         DataMaskingRuleState `json:"ruleState,omitempty"`
	SchemaName        *string              `json:"schemaName,omitempty"`
	TableName         *string              `json:"tableName,omitempty"`
	ColumnName        *string              `json:"columnName,omitempty"`
	MaskingFunction   DataMaskingFunction  `json:"maskingFunction,omitempty"`
	NumberFrom        *string              `json:"numberFrom,omitempty"`
	NumberTo          *string              `json:"numberTo,omitempty"`
	PrefixSize        *string              `json:"prefixSize,omitempty"`
	SuffixSize        *string              `json:"suffixSize,omitempty"`
	ReplacementString *string              `json:"replacementString,omitempty"`
}

// EditionCapability is the database edition capabilities.
type EditionCapability struct {
	Name                            *string                       `json:"name,omitempty"`
	Status                          CapabilityStatus              `json:"status,omitempty"`
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
}

// ElasticPool is represents a database elastic pool.
type ElasticPool struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	Location               *string             `json:"location,omitempty"`
	*ElasticPoolProperties `json:"properties,omitempty"`
	Kind                   *string `json:"kind,omitempty"`
}

// ElasticPoolActivity is represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	Location                       *string `json:"location,omitempty"`
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
}

// ElasticPoolActivityListResult is represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties is represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	EndTime                       *date.Time `json:"endTime,omitempty"`
	ErrorCode                     *int32     `json:"errorCode,omitempty"`
	ErrorMessage                  *string    `json:"errorMessage,omitempty"`
	ErrorSeverity                 *int32     `json:"errorSeverity,omitempty"`
	Operation                     *string    `json:"operation,omitempty"`
	OperationID                   *uuid.UUID `json:"operationId,omitempty"`
	PercentComplete               *int32     `json:"percentComplete,omitempty"`
	RequestedDatabaseDtuMax       *int32     `json:"requestedDatabaseDtuMax,omitempty"`
	RequestedDatabaseDtuMin       *int32     `json:"requestedDatabaseDtuMin,omitempty"`
	RequestedDtu                  *int32     `json:"requestedDtu,omitempty"`
	RequestedElasticPoolName      *string    `json:"requestedElasticPoolName,omitempty"`
	RequestedStorageLimitInGB     *int64     `json:"requestedStorageLimitInGB,omitempty"`
	ElasticPoolName               *string    `json:"elasticPoolName,omitempty"`
	ServerName                    *string    `json:"serverName,omitempty"`
	StartTime                     *date.Time `json:"startTime,omitempty"`
	State                         *string    `json:"state,omitempty"`
	RequestedStorageLimitInMB     *int32     `json:"requestedStorageLimitInMB,omitempty"`
	RequestedDatabaseDtuGuarantee *int32     `json:"requestedDatabaseDtuGuarantee,omitempty"`
	RequestedDatabaseDtuCap       *int32     `json:"requestedDatabaseDtuCap,omitempty"`
	RequestedDtuGuarantee         *int32     `json:"requestedDtuGuarantee,omitempty"`
}

// ElasticPoolDatabaseActivity is represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	ID                                     *string `json:"id,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Type                                   *string `json:"type,omitempty"`
	Location                               *string `json:"location,omitempty"`
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
}

// ElasticPoolDatabaseActivityListResult is represents the response to a list elastic pool database activity request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties is represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	DatabaseName              *string    `json:"databaseName,omitempty"`
	EndTime                   *date.Time `json:"endTime,omitempty"`
	ErrorCode                 *int32     `json:"errorCode,omitempty"`
	ErrorMessage              *string    `json:"errorMessage,omitempty"`
	ErrorSeverity             *int32     `json:"errorSeverity,omitempty"`
	Operation                 *string    `json:"operation,omitempty"`
	OperationID               *uuid.UUID `json:"operationId,omitempty"`
	PercentComplete           *int32     `json:"percentComplete,omitempty"`
	RequestedElasticPoolName  *string    `json:"requestedElasticPoolName,omitempty"`
	CurrentElasticPoolName    *string    `json:"currentElasticPoolName,omitempty"`
	CurrentServiceObjective   *string    `json:"currentServiceObjective,omitempty"`
	RequestedServiceObjective *string    `json:"requestedServiceObjective,omitempty"`
	ServerName                *string    `json:"serverName,omitempty"`
	StartTime                 *date.Time `json:"startTime,omitempty"`
	State                     *string    `json:"state,omitempty"`
}

// ElasticPoolDtuCapability is the Elastic Pool DTU capability.
type ElasticPoolDtuCapability struct {
	Limit                        *int64                                    `json:"limit,omitempty"`
	MaxDatabaseCount             *int64                                    `json:"maxDatabaseCount,omitempty"`
	Status                       CapabilityStatus                          `json:"status,omitempty"`
	SupportedMaxSizes            *[]MaxSizeCapability                      `json:"supportedMaxSizes,omitempty"`
	IncludedMaxSize              *MaxSizeCapability                        `json:"includedMaxSize,omitempty"`
	SupportedPerDatabaseMaxSizes *[]MaxSizeCapability                      `json:"supportedPerDatabaseMaxSizes,omitempty"`
	SupportedPerDatabaseMaxDtus  *[]ElasticPoolPerDatabaseMaxDtuCapability `json:"supportedPerDatabaseMaxDtus,omitempty"`
}

// ElasticPoolEditionCapability is the elastic pool edition capabilities.
type ElasticPoolEditionCapability struct {
	Name                     *string                     `json:"name,omitempty"`
	Status                   CapabilityStatus            `json:"status,omitempty"`
	SupportedElasticPoolDtus *[]ElasticPoolDtuCapability `json:"supportedElasticPoolDtus,omitempty"`
}

// ElasticPoolListResult is represents the response to a list elastic pool request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPool `json:"value,omitempty"`
}

// ElasticPoolPerDatabaseMaxDtuCapability is the max per-database DTU capability.
type ElasticPoolPerDatabaseMaxDtuCapability struct {
	Limit                       *int64                                    `json:"limit,omitempty"`
	Status                      CapabilityStatus                          `json:"status,omitempty"`
	SupportedPerDatabaseMinDtus *[]ElasticPoolPerDatabaseMinDtuCapability `json:"supportedPerDatabaseMinDtus,omitempty"`
}

// ElasticPoolPerDatabaseMinDtuCapability is the minimum per-database DTU capability.
type ElasticPoolPerDatabaseMinDtuCapability struct {
	Limit  *int64           `json:"limit,omitempty"`
	Status CapabilityStatus `json:"status,omitempty"`
}

// ElasticPoolProperties is represents the properties of an elastic pool.
type ElasticPoolProperties struct {
	CreationDate   *date.Time         `json:"creationDate,omitempty"`
	State          ElasticPoolState   `json:"state,omitempty"`
	Edition        ElasticPoolEdition `json:"edition,omitempty"`
	Dtu            *int32             `json:"dtu,omitempty"`
	DatabaseDtuMax *int32             `json:"databaseDtuMax,omitempty"`
	DatabaseDtuMin *int32             `json:"databaseDtuMin,omitempty"`
	StorageMB      *int32             `json:"storageMB,omitempty"`
}

// ElasticPoolUpdate is represents an elastic pool update.
type ElasticPoolUpdate struct {
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*ElasticPoolProperties `json:"properties,omitempty"`
}

// EncryptionProtector is the server encryption protector.
type EncryptionProtector struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	Kind                           *string `json:"kind,omitempty"`
	Location                       *string `json:"location,omitempty"`
	*EncryptionProtectorProperties `json:"properties,omitempty"`
}

// EncryptionProtectorListResult is a list of server encryption protectors.
type EncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EncryptionProtector `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// EncryptionProtectorListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EncryptionProtectorListResult) EncryptionProtectorListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EncryptionProtectorProperties is properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	Subregion     *string       `json:"subregion,omitempty"`
	ServerKeyName *string       `json:"serverKeyName,omitempty"`
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	URI           *string       `json:"uri,omitempty"`
	Thumbprint    *string       `json:"thumbprint,omitempty"`
}

// ExportRequest is export database parameters.
type ExportRequest struct {
	StorageKeyType             StorageKeyType     `json:"storageKeyType,omitempty"`
	StorageKey                 *string            `json:"storageKey,omitempty"`
	StorageURI                 *string            `json:"storageUri,omitempty"`
	AdministratorLogin         *string            `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string            `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType `json:"authenticationType,omitempty"`
}

// FailoverGroup is a failover group.
type FailoverGroup struct {
	autorest.Response        `json:"-"`
	ID                       *string             `json:"id,omitempty"`
	Name                     *string             `json:"name,omitempty"`
	Type                     *string             `json:"type,omitempty"`
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
	*FailoverGroupProperties `json:"properties,omitempty"`
}

// FailoverGroupListResult is a list of failover groups.
type FailoverGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]FailoverGroup `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// FailoverGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FailoverGroupListResult) FailoverGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FailoverGroupProperties is properties of a failover group.
type FailoverGroupProperties struct {
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	ReadOnlyEndpoint  *FailoverGroupReadOnlyEndpoint  `json:"readOnlyEndpoint,omitempty"`
	ReplicationRole   FailoverGroupReplicationRole    `json:"replicationRole,omitempty"`
	ReplicationState  *string                         `json:"replicationState,omitempty"`
	PartnerServers    *[]PartnerInfo                  `json:"partnerServers,omitempty"`
	Databases         *[]string                       `json:"databases,omitempty"`
}

// FailoverGroupReadOnlyEndpoint is read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint is read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	FailoverPolicy                         ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	FailoverWithDataLossGracePeriodMinutes *int32                          `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupUpdate is a failover group update request.
type FailoverGroupUpdate struct {
	*FailoverGroupUpdateProperties `json:"properties,omitempty"`
	Tags                           *map[string]*string `json:"tags,omitempty"`
}

// FailoverGroupUpdateProperties is properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	ReadOnlyEndpoint  *FailoverGroupReadOnlyEndpoint  `json:"readOnlyEndpoint,omitempty"`
	Databases         *[]string                       `json:"databases,omitempty"`
}

// FirewallRule is represents a server firewall rule.
type FirewallRule struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	Kind                    *string `json:"kind,omitempty"`
	Location                *string `json:"location,omitempty"`
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// FirewallRuleListResult is represents the response to a List Firewall Rules request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties is represents the properties of a server firewall rule.
type FirewallRuleProperties struct {
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	EndIPAddress   *string `json:"endIpAddress,omitempty"`
}

// GeoBackupPolicy is a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	Kind                       *string `json:"kind,omitempty"`
	Location                   *string `json:"location,omitempty"`
}

// GeoBackupPolicyListResult is the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	Value             *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties is the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	State       GeoBackupPolicyState `json:"state,omitempty"`
	StorageType *string              `json:"storageType,omitempty"`
}

// ImportExportResponse is response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response               `json:"-"`
	ID                              *string `json:"id,omitempty"`
	Name                            *string `json:"name,omitempty"`
	Type                            *string `json:"type,omitempty"`
	*ImportExportResponseProperties `json:"properties,omitempty"`
}

// ImportExportResponseProperties is response for Import/Export Status operation.
type ImportExportResponseProperties struct {
	RequestType      *string    `json:"requestType,omitempty"`
	RequestID        *uuid.UUID `json:"requestId,omitempty"`
	ServerName       *string    `json:"serverName,omitempty"`
	DatabaseName     *string    `json:"databaseName,omitempty"`
	Status           *string    `json:"status,omitempty"`
	LastModifiedTime *string    `json:"lastModifiedTime,omitempty"`
	QueuedTime       *string    `json:"queuedTime,omitempty"`
	BlobURI          *string    `json:"blobUri,omitempty"`
	ErrorMessage     *string    `json:"errorMessage,omitempty"`
}

// ImportExtensionProperties is represents the properties for an import operation
type ImportExtensionProperties struct {
	StorageKeyType             StorageKeyType     `json:"storageKeyType,omitempty"`
	StorageKey                 *string            `json:"storageKey,omitempty"`
	StorageURI                 *string            `json:"storageUri,omitempty"`
	AdministratorLogin         *string            `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string            `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType `json:"authenticationType,omitempty"`
	OperationMode              *string            `json:"operationMode,omitempty"`
}

// ImportExtensionRequest is import database parameters.
type ImportExtensionRequest struct {
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// ImportRequest is import database parameters.
type ImportRequest struct {
	StorageKeyType             StorageKeyType       `json:"storageKeyType,omitempty"`
	StorageKey                 *string              `json:"storageKey,omitempty"`
	StorageURI                 *string              `json:"storageUri,omitempty"`
	AdministratorLogin         *string              `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string              `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType   `json:"authenticationType,omitempty"`
	DatabaseName               *string              `json:"databaseName,omitempty"`
	Edition                    DatabaseEdition      `json:"edition,omitempty"`
	ServiceObjectiveName       ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	MaxSizeBytes               *string              `json:"maxSizeBytes,omitempty"`
}

// LocationCapabilities is the capabilities for a location.
type LocationCapabilities struct {
	autorest.Response       `json:"-"`
	Name                    *string                    `json:"name,omitempty"`
	Status                  CapabilityStatus           `json:"status,omitempty"`
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// MaxSizeCapability is the maximum size limits for a database.
type MaxSizeCapability struct {
	Limit  *int64           `json:"limit,omitempty"`
	Unit   MaxSizeUnits     `json:"unit,omitempty"`
	Status CapabilityStatus `json:"status,omitempty"`
}

// Metric is database metrics.
type Metric struct {
	StartTime    *date.Time     `json:"startTime,omitempty"`
	EndTime      *date.Time     `json:"endTime,omitempty"`
	TimeGrain    *string        `json:"timeGrain,omitempty"`
	Unit         UnitType       `json:"unit,omitempty"`
	Name         *MetricName    `json:"name,omitempty"`
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability is a metric availability value.
type MetricAvailability struct {
	Retention *string `json:"retention,omitempty"`
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricDefinition is a database metric definition.
type MetricDefinition struct {
	Name                   *MetricName            `json:"name,omitempty"`
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	ResourceURI            *string                `json:"resourceUri,omitempty"`
	Unit                   UnitDefinitionType     `json:"unit,omitempty"`
	MetricAvailabilities   *[]MetricAvailability  `json:"metricAvailabilities,omitempty"`
}

// MetricDefinitionListResult is the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult is the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Metric `json:"value,omitempty"`
}

// MetricName is a database metric name.
type MetricName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue is represents database metrics.
type MetricValue struct {
	Count     *float64   `json:"count,omitempty"`
	Average   *float64   `json:"average,omitempty"`
	Maximum   *float64   `json:"maximum,omitempty"`
	Minimum   *float64   `json:"minimum,omitempty"`
	Timestamp *date.Time `json:"timestamp,omitempty"`
	Total     *float64   `json:"total,omitempty"`
}

// Operation is SQL REST API operation definition.
type Operation struct {
	Name       *string                             `json:"name,omitempty"`
	Display    *OperationDisplay                   `json:"display,omitempty"`
	Origin     OperationOrigin                     `json:"origin,omitempty"`
	Properties *map[string]*map[string]interface{} `json:"properties,omitempty"`
}

// OperationDisplay is display metadata associated with the operation.
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationImpact is the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	Name                *string  `json:"name,omitempty"`
	Unit                *string  `json:"unit,omitempty"`
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// OperationListResult is result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PartnerInfo is partner server information for the failover group.
type PartnerInfo struct {
	ID              *string                      `json:"id,omitempty"`
	Location        *string                      `json:"location,omitempty"`
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// PerformanceLevel is a possible performance level of a service objective capability.
type PerformanceLevel struct {
	Unit  PerformanceLevelUnit `json:"unit,omitempty"`
	Value *int32               `json:"value,omitempty"`
}

// ProxyResource is ARM proxy resource.
type ProxyResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// RecommendedElasticPool is represents a recommented elastic pool.
type RecommendedElasticPool struct {
	autorest.Response                 `json:"-"`
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
	*RecommendedElasticPoolProperties `json:"properties,omitempty"`
}

// RecommendedElasticPoolListMetricsResult is represents the response to a list recommended elastic pool metrics
// request.
type RecommendedElasticPoolListMetricsResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecommendedElasticPoolMetric `json:"value,omitempty"`
}

// RecommendedElasticPoolListResult is represents the response to a list recommended elastic pool request.
type RecommendedElasticPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecommendedElasticPool `json:"value,omitempty"`
}

// RecommendedElasticPoolMetric is represents recommended elastic pool metric.
type RecommendedElasticPoolMetric struct {
	DateTime *date.Time `json:"dateTime,omitempty"`
	Dtu      *float64   `json:"dtu,omitempty"`
	SizeGB   *float64   `json:"sizeGB,omitempty"`
}

// RecommendedElasticPoolProperties is represents the properties of a recommented elastic pool.
type RecommendedElasticPoolProperties struct {
	DatabaseEdition        ElasticPoolEdition              `json:"databaseEdition,omitempty"`
	Dtu                    *float64                        `json:"dtu,omitempty"`
	DatabaseDtuMin         *float64                        `json:"databaseDtuMin,omitempty"`
	DatabaseDtuMax         *float64                        `json:"databaseDtuMax,omitempty"`
	StorageMB              *float64                        `json:"storageMB,omitempty"`
	ObservationPeriodStart *date.Time                      `json:"observationPeriodStart,omitempty"`
	ObservationPeriodEnd   *date.Time                      `json:"observationPeriodEnd,omitempty"`
	MaxObservedDtu         *float64                        `json:"maxObservedDtu,omitempty"`
	MaxObservedStorageMB   *float64                        `json:"maxObservedStorageMB,omitempty"`
	Databases              *[]Database                     `json:"databases,omitempty"`
	Metrics                *[]RecommendedElasticPoolMetric `json:"metrics,omitempty"`
}

// RecommendedIndex is represents a database recommended index.
type RecommendedIndex struct {
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*RecommendedIndexProperties `json:"properties,omitempty"`
}

// RecommendedIndexProperties is represents the properties of a database recommended index.
type RecommendedIndexProperties struct {
	Action          RecommendedIndexAction `json:"action,omitempty"`
	State           RecommendedIndexState  `json:"state,omitempty"`
	Created         *date.Time             `json:"created,omitempty"`
	LastModified    *date.Time             `json:"lastModified,omitempty"`
	IndexType       RecommendedIndexType   `json:"indexType,omitempty"`
	Schema          *string                `json:"schema,omitempty"`
	Table           *string                `json:"table,omitempty"`
	Columns         *[]string              `json:"columns,omitempty"`
	IncludedColumns *[]string              `json:"includedColumns,omitempty"`
	IndexScript     *string                `json:"indexScript,omitempty"`
	EstimatedImpact *[]OperationImpact     `json:"estimatedImpact,omitempty"`
	ReportedImpact  *[]OperationImpact     `json:"reportedImpact,omitempty"`
}

// RecoverableDatabase is a recoverable database
type RecoverableDatabase struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*RecoverableDatabaseProperties `json:"properties,omitempty"`
}

// RecoverableDatabaseListResult is the response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties is the properties of a recoverable database
type RecoverableDatabaseProperties struct {
	Edition                 *string    `json:"edition,omitempty"`
	ServiceLevelObjective   *string    `json:"serviceLevelObjective,omitempty"`
	ElasticPoolName         *string    `json:"elasticPoolName,omitempty"`
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// ReplicationLink is represents a database replication link.
type ReplicationLink struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	Location                   *string `json:"location,omitempty"`
	*ReplicationLinkProperties `json:"properties,omitempty"`
}

// ReplicationLinkListResult is represents the response to a List database replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties is represents the properties of a database replication link.
type ReplicationLinkProperties struct {
	IsTerminationAllowed *bool            `json:"isTerminationAllowed,omitempty"`
	ReplicationMode      *string          `json:"replicationMode,omitempty"`
	PartnerServer        *string          `json:"partnerServer,omitempty"`
	PartnerDatabase      *string          `json:"partnerDatabase,omitempty"`
	PartnerLocation      *string          `json:"partnerLocation,omitempty"`
	Role                 ReplicationRole  `json:"role,omitempty"`
	PartnerRole          ReplicationRole  `json:"partnerRole,omitempty"`
	StartTime            *date.Time       `json:"startTime,omitempty"`
	PercentComplete      *int32           `json:"percentComplete,omitempty"`
	ReplicationState     ReplicationState `json:"replicationState,omitempty"`
}

// Resource is ARM resource.
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity is azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	PrincipalID *uuid.UUID   `json:"principalId,omitempty"`
	Type        IdentityType `json:"type,omitempty"`
	TenantID    *uuid.UUID   `json:"tenantId,omitempty"`
}

// RestorableDroppedDatabase is a restorable dropped database
type RestorableDroppedDatabase struct {
	autorest.Response                    `json:"-"`
	ID                                   *string `json:"id,omitempty"`
	Name                                 *string `json:"name,omitempty"`
	Type                                 *string `json:"type,omitempty"`
	Location                             *string `json:"location,omitempty"`
	*RestorableDroppedDatabaseProperties `json:"properties,omitempty"`
}

// RestorableDroppedDatabaseListResult is the response to a list restorable dropped databases request
type RestorableDroppedDatabaseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RestorableDroppedDatabase `json:"value,omitempty"`
}

// RestorableDroppedDatabaseProperties is the properties of a restorable dropped database
type RestorableDroppedDatabaseProperties struct {
	DatabaseName          *string    `json:"databaseName,omitempty"`
	Edition               *string    `json:"edition,omitempty"`
	MaxSizeBytes          *string    `json:"maxSizeBytes,omitempty"`
	ServiceLevelObjective *string    `json:"serviceLevelObjective,omitempty"`
	ElasticPoolName       *string    `json:"elasticPoolName,omitempty"`
	CreationDate          *date.Time `json:"creationDate,omitempty"`
	DeletionDate          *date.Time `json:"deletionDate,omitempty"`
	EarliestRestoreDate   *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorePoint is a database restore point.
type RestorePoint struct {
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*RestorePointProperties `json:"properties,omitempty"`
}

// RestorePointListResult is the response to a list database restore points request.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RestorePoint `json:"value,omitempty"`
}

// RestorePointProperties is represents the properties of a database restore point.
type RestorePointProperties struct {
	RestorePointType         RestorePointType `json:"restorePointType,omitempty"`
	RestorePointCreationDate *date.Time       `json:"restorePointCreationDate,omitempty"`
	EarliestRestoreDate      *date.Time       `json:"earliestRestoreDate,omitempty"`
}

// Server is an Azure SQL Database server.
type Server struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Identity          *ResourceIdentity   `json:"identity,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	*ServerProperties `json:"properties,omitempty"`
}

// ServerAdministratorListResult is the response to a list Active Directory Administrators request.
type ServerAdministratorListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServerAzureADAdministrator `json:"value,omitempty"`
}

// ServerAdministratorProperties is the properties of an server Administrator.
type ServerAdministratorProperties struct {
	AdministratorType *string    `json:"administratorType,omitempty"`
	Login             *string    `json:"login,omitempty"`
	Sid               *uuid.UUID `json:"sid,omitempty"`
	TenantID          *uuid.UUID `json:"tenantId,omitempty"`
}

// ServerAzureADAdministrator is an server Active Directory Administrator.
type ServerAzureADAdministrator struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*ServerAdministratorProperties `json:"properties,omitempty"`
}

// ServerCommunicationLink is server communication link.
type ServerCommunicationLink struct {
	autorest.Response                  `json:"-"`
	ID                                 *string `json:"id,omitempty"`
	Name                               *string `json:"name,omitempty"`
	Type                               *string `json:"type,omitempty"`
	*ServerCommunicationLinkProperties `json:"properties,omitempty"`
	Location                           *string `json:"location,omitempty"`
	Kind                               *string `json:"kind,omitempty"`
}

// ServerCommunicationLinkListResult is a list of server communication links.
type ServerCommunicationLinkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties is the properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	State         *string `json:"state,omitempty"`
	PartnerServer *string `json:"partnerServer,omitempty"`
}

// ServerConnectionPolicy is a server secure connection policy.
type ServerConnectionPolicy struct {
	autorest.Response                 `json:"-"`
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
	Kind                              *string `json:"kind,omitempty"`
	Location                          *string `json:"location,omitempty"`
	*ServerConnectionPolicyProperties `json:"properties,omitempty"`
}

// ServerConnectionPolicyProperties is the properties of a server secure connection policy.
type ServerConnectionPolicyProperties struct {
	ConnectionType ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerKey is a server key.
type ServerKey struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	Kind                 *string `json:"kind,omitempty"`
	Location             *string `json:"location,omitempty"`
	*ServerKeyProperties `json:"properties,omitempty"`
}

// ServerKeyListResult is a list of server keys.
type ServerKeyListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServerKey `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// ServerKeyListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ServerKeyListResult) ServerKeyListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ServerKeyProperties is properties for a server key execution.
type ServerKeyProperties struct {
	Subregion     *string       `json:"subregion,omitempty"`
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	URI           *string       `json:"uri,omitempty"`
	Thumbprint    *string       `json:"thumbprint,omitempty"`
	CreationDate  *date.Time    `json:"creationDate,omitempty"`
}

// ServerListResult is a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Server `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ServerListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ServerListResult) ServerListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ServerProperties is the properties of a server.
type ServerProperties struct {
	AdministratorLogin         *string `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	Version                    *string `json:"version,omitempty"`
	State                      *string `json:"state,omitempty"`
	FullyQualifiedDomainName   *string `json:"fullyQualifiedDomainName,omitempty"`
}

// ServerUpdate is an update request for an Azure SQL Database server.
type ServerUpdate struct {
	*ServerProperties `json:"properties,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
}

// ServerUsage is represents server metrics.
type ServerUsage struct {
	Name          *string    `json:"name,omitempty"`
	ResourceName  *string    `json:"resourceName,omitempty"`
	DisplayName   *string    `json:"displayName,omitempty"`
	CurrentValue  *float64   `json:"currentValue,omitempty"`
	Limit         *float64   `json:"limit,omitempty"`
	Unit          *string    `json:"unit,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerUsageListResult is represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServerUsage `json:"value,omitempty"`
}

// ServerVersionCapability is the server capabilities.
type ServerVersionCapability struct {
	Name                         *string                         `json:"name,omitempty"`
	Status                       CapabilityStatus                `json:"status,omitempty"`
	SupportedEditions            *[]EditionCapability            `json:"supportedEditions,omitempty"`
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
}

// ServiceObjective is represents a database service objective.
type ServiceObjective struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*ServiceObjectiveProperties `json:"properties,omitempty"`
}

// ServiceObjectiveCapability is the service objectives capability.
type ServiceObjectiveCapability struct {
	Name              *string          `json:"name,omitempty"`
	Status            CapabilityStatus `json:"status,omitempty"`
	*PerformanceLevel `json:"performanceLevel,omitempty"`
	ID                *uuid.UUID           `json:"id,omitempty"`
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	IncludedMaxSize   *MaxSizeCapability   `json:"includedMaxSize,omitempty"`
}

// ServiceObjectiveListResult is represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties is represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	IsDefault            *bool   `json:"isDefault,omitempty"`
	IsSystem             *bool   `json:"isSystem,omitempty"`
	Description          *string `json:"description,omitempty"`
	Enabled              *bool   `json:"enabled,omitempty"`
}

// ServiceTierAdvisor is represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response             `json:"-"`
	ID                            *string `json:"id,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Type                          *string `json:"type,omitempty"`
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
}

// ServiceTierAdvisorListResult is represents the response to a list service tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties is represents the properties of a Service Tier Advisor.
type ServiceTierAdvisorProperties struct {
	ObservationPeriodStart                                 *date.Time        `json:"observationPeriodStart,omitempty"`
	ObservationPeriodEnd                                   *date.Time        `json:"observationPeriodEnd,omitempty"`
	ActiveTimeRatio                                        *float64          `json:"activeTimeRatio,omitempty"`
	MinDtu                                                 *float64          `json:"minDtu,omitempty"`
	AvgDtu                                                 *float64          `json:"avgDtu,omitempty"`
	MaxDtu                                                 *float64          `json:"maxDtu,omitempty"`
	MaxSizeInGB                                            *float64          `json:"maxSizeInGB,omitempty"`
	ServiceLevelObjectiveUsageMetrics                      *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	CurrentServiceLevelObjective                           *string           `json:"currentServiceLevelObjective,omitempty"`
	CurrentServiceLevelObjectiveID                         *uuid.UUID        `json:"currentServiceLevelObjectiveId,omitempty"`
	UsageBasedRecommendationServiceLevelObjective          *string           `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	UsageBasedRecommendationServiceLevelObjectiveID        *uuid.UUID        `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	DatabaseSizeBasedRecommendationServiceLevelObjective   *string           `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID        `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	DisasterPlanBasedRecommendationServiceLevelObjective   *string           `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID        `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	OverallRecommendationServiceLevelObjective             *string           `json:"overallRecommendationServiceLevelObjective,omitempty"`
	OverallRecommendationServiceLevelObjectiveID           *uuid.UUID        `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	Confidence                                             *float64          `json:"confidence,omitempty"`
}

// SloUsageMetric is a Slo Usage Metric.
type SloUsageMetric struct {
	ServiceLevelObjective   ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	ServiceLevelObjectiveID *uuid.UUID           `json:"serviceLevelObjectiveId,omitempty"`
	InRangeTimeRatio        *float64             `json:"inRangeTimeRatio,omitempty"`
}

// SyncAgent is an Azure SQL Database sync agent.
type SyncAgent struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*SyncAgentProperties `json:"properties,omitempty"`
}

// SyncAgentKeyProperties is properties of an Azure SQL Database sync agent key.
type SyncAgentKeyProperties struct {
	autorest.Response `json:"-"`
	SyncAgentKey      *string `json:"syncAgentKey,omitempty"`
}

// SyncAgentLinkedDatabase is an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabase struct {
	ID                                 *string `json:"id,omitempty"`
	Name                               *string `json:"name,omitempty"`
	Type                               *string `json:"type,omitempty"`
	*SyncAgentLinkedDatabaseProperties `json:"properties,omitempty"`
}

// SyncAgentLinkedDatabaseListResult is a list of sync agent linked databases.
type SyncAgentLinkedDatabaseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncAgentLinkedDatabase `json:"value,omitempty"`
	NextLink          *string                    `json:"nextLink,omitempty"`
}

// SyncAgentLinkedDatabaseListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncAgentLinkedDatabaseListResult) SyncAgentLinkedDatabaseListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncAgentLinkedDatabaseProperties is properties of an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabaseProperties struct {
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	DatabaseID   *string          `json:"databaseId,omitempty"`
	Description  *string          `json:"description,omitempty"`
	ServerName   *string          `json:"serverName,omitempty"`
	DatabaseName *string          `json:"databaseName,omitempty"`
	UserName     *string          `json:"userName,omitempty"`
}

// SyncAgentListResult is a list of sync agents.
type SyncAgentListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncAgent `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// SyncAgentListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncAgentListResult) SyncAgentListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncAgentProperties is properties of an Azure SQL Database sync agent.
type SyncAgentProperties struct {
	Name           *string        `json:"name,omitempty"`
	SyncDatabaseID *string        `json:"syncDatabaseId,omitempty"`
	LastAliveTime  *date.Time     `json:"lastAliveTime,omitempty"`
	State          SyncAgentState `json:"state,omitempty"`
	IsUpToDate     *bool          `json:"isUpToDate,omitempty"`
	ExpiryTime     *date.Time     `json:"expiryTime,omitempty"`
	Version        *string        `json:"version,omitempty"`
}

// SyncDatabaseIDListResult is a list of sync database ID properties.
type SyncDatabaseIDListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncDatabaseIDProperties `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// SyncDatabaseIDListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncDatabaseIDListResult) SyncDatabaseIDListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncDatabaseIDProperties is properties of the sync database id.
type SyncDatabaseIDProperties struct {
	ID *string `json:"id,omitempty"`
}

// SyncFullSchemaProperties is properties of the database full schema.
type SyncFullSchemaProperties struct {
	Tables         *[]SyncFullSchemaTable `json:"tables,omitempty"`
	LastUpdateTime *date.Time             `json:"lastUpdateTime,omitempty"`
}

// SyncFullSchemaPropertiesListResult is a list of sync schema properties.
type SyncFullSchemaPropertiesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncFullSchemaProperties `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// SyncFullSchemaPropertiesListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncFullSchemaPropertiesListResult) SyncFullSchemaPropertiesListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncFullSchemaTable is properties of the table in the database full schema.
type SyncFullSchemaTable struct {
	Columns    *[]SyncFullSchemaTableColumn `json:"columns,omitempty"`
	ErrorID    *string                      `json:"errorId,omitempty"`
	HasError   *bool                        `json:"hasError,omitempty"`
	Name       *string                      `json:"name,omitempty"`
	QuotedName *string                      `json:"quotedName,omitempty"`
}

// SyncFullSchemaTableColumn is properties of the column in the table of database full schema.
type SyncFullSchemaTableColumn struct {
	DataSize     *string `json:"dataSize,omitempty"`
	DataType     *string `json:"dataType,omitempty"`
	ErrorID      *string `json:"errorId,omitempty"`
	HasError     *bool   `json:"hasError,omitempty"`
	IsPrimaryKey *bool   `json:"isPrimaryKey,omitempty"`
	Name         *string `json:"name,omitempty"`
	QuotedName   *string `json:"quotedName,omitempty"`
}

// SyncGroup is an Azure SQL Database sync group.
type SyncGroup struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*SyncGroupProperties `json:"properties,omitempty"`
}

// SyncGroupListResult is a list of sync groups.
type SyncGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncGroup `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// SyncGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncGroupListResult) SyncGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncGroupLogListResult is a list of sync group log properties.
type SyncGroupLogListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncGroupLogProperties `json:"value,omitempty"`
	NextLink          *string                   `json:"nextLink,omitempty"`
}

// SyncGroupLogListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncGroupLogListResult) SyncGroupLogListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncGroupLogProperties is properties of an Azure SQL Database sync group log.
type SyncGroupLogProperties struct {
	Timestamp       *date.Time       `json:"timestamp,omitempty"`
	Type            SyncGroupLogType `json:"type,omitempty"`
	Source          *string          `json:"source,omitempty"`
	Details         *string          `json:"details,omitempty"`
	TracingID       *uuid.UUID       `json:"tracingId,omitempty"`
	OperationStatus *string          `json:"operationStatus,omitempty"`
}

// SyncGroupProperties is properties of a sync group.
type SyncGroupProperties struct {
	Interval                 *int32                       `json:"interval,omitempty"`
	LastSyncTime             *date.Time                   `json:"lastSyncTime,omitempty"`
	ConflictResolutionPolicy SyncConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	SyncDatabaseID           *string                      `json:"syncDatabaseId,omitempty"`
	HubDatabaseUserName      *string                      `json:"hubDatabaseUserName,omitempty"`
	HubDatabasePassword      *string                      `json:"hubDatabasePassword,omitempty"`
	SyncState                SyncGroupState               `json:"syncState,omitempty"`
	Schema                   *SyncGroupSchema             `json:"schema,omitempty"`
}

// SyncGroupSchema is properties of sync group schema.
type SyncGroupSchema struct {
	Tables               *[]SyncGroupSchemaTable `json:"tables,omitempty"`
	MasterSyncMemberName *string                 `json:"masterSyncMemberName,omitempty"`
}

// SyncGroupSchemaTable is properties of table in sync group schema.
type SyncGroupSchemaTable struct {
	Columns    *[]SyncGroupSchemaTableColumn `json:"columns,omitempty"`
	QuotedName *string                       `json:"quotedName,omitempty"`
}

// SyncGroupSchemaTableColumn is properties of column in sync group table.
type SyncGroupSchemaTableColumn struct {
	QuotedName *string `json:"quotedName,omitempty"`
	DataSize   *string `json:"dataSize,omitempty"`
	DataType   *string `json:"dataType,omitempty"`
}

// SyncMember is an Azure SQL Database sync member.
type SyncMember struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	Type                  *string `json:"type,omitempty"`
	*SyncMemberProperties `json:"properties,omitempty"`
}

// SyncMemberListResult is a list of Azure SQL Database sync members.
type SyncMemberListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SyncMember `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// SyncMemberListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SyncMemberListResult) SyncMemberListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SyncMemberProperties is properties of a sync member.
type SyncMemberProperties struct {
	DatabaseType        SyncMemberDbType `json:"databaseType,omitempty"`
	SyncAgentID         *string          `json:"syncAgentId,omitempty"`
	SQLServerDatabaseID *uuid.UUID       `json:"sqlServerDatabaseId,omitempty"`
	ServerName          *string          `json:"serverName,omitempty"`
	DatabaseName        *string          `json:"databaseName,omitempty"`
	UserName            *string          `json:"userName,omitempty"`
	Password            *string          `json:"password,omitempty"`
	SyncDirection       SyncDirection    `json:"syncDirection,omitempty"`
	SyncState           SyncMemberState  `json:"syncState,omitempty"`
}

// TrackedResource is ARM tracked top level resource.
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
	Location *string             `json:"location,omitempty"`
}

// TransparentDataEncryption is represents a database transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response                    `json:"-"`
	ID                                   *string `json:"id,omitempty"`
	Name                                 *string `json:"name,omitempty"`
	Type                                 *string `json:"type,omitempty"`
	Location                             *string `json:"location,omitempty"`
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
}

// TransparentDataEncryptionActivity is represents a database transparent data encryption Scan.
type TransparentDataEncryptionActivity struct {
	ID                                           *string `json:"id,omitempty"`
	Name                                         *string `json:"name,omitempty"`
	Type                                         *string `json:"type,omitempty"`
	Location                                     *string `json:"location,omitempty"`
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
}

// TransparentDataEncryptionActivityListResult is represents the response to a list database transparent data
// encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties is represents the properties of a database transparent data encryption
// Scan.
type TransparentDataEncryptionActivityProperties struct {
	Status          TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	PercentComplete *float64                                `json:"percentComplete,omitempty"`
}

// TransparentDataEncryptionProperties is represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// VirtualNetworkRule is a virtual network rule.
type VirtualNetworkRule struct {
	autorest.Response             `json:"-"`
	ID                            *string `json:"id,omitempty"`
	Name                          *string `json:"name,omitempty"`
	Type                          *string `json:"type,omitempty"`
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
}

// VirtualNetworkRuleListResult is a list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]VirtualNetworkRule `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VirtualNetworkRuleListResult) VirtualNetworkRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VirtualNetworkRuleProperties is properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	VirtualNetworkSubnetID           *string                 `json:"virtualNetworkSubnetId,omitempty"`
	IgnoreMissingVnetServiceEndpoint *bool                   `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
	State                            VirtualNetworkRuleState `json:"state,omitempty"`
}
