package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen specifies the listen state for access rights.
	Listen AccessRights = "Listen"
	// Manage specifies the manage state for access rights.
	Manage AccessRights = "Manage"
	// Send specifies the send state for access rights.
	Send AccessRights = "Send"
)

// EncodingCaptureDescription enumerates the values for encoding capture description.
type EncodingCaptureDescription string

const (
	// Avro specifies the avro state for encoding capture description.
	Avro EncodingCaptureDescription = "Avro"
	// AvroDeflate specifies the avro deflate state for encoding capture description.
	AvroDeflate EncodingCaptureDescription = "AvroDeflate"
)

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Active specifies the active state for entity status.
	Active EntityStatus = "Active"
	// Creating specifies the creating state for entity status.
	Creating EntityStatus = "Creating"
	// Deleting specifies the deleting state for entity status.
	Deleting EntityStatus = "Deleting"
	// Disabled specifies the disabled state for entity status.
	Disabled EntityStatus = "Disabled"
	// ReceiveDisabled specifies the receive disabled state for entity status.
	ReceiveDisabled EntityStatus = "ReceiveDisabled"
	// Renaming specifies the renaming state for entity status.
	Renaming EntityStatus = "Renaming"
	// Restoring specifies the restoring state for entity status.
	Restoring EntityStatus = "Restoring"
	// SendDisabled specifies the send disabled state for entity status.
	SendDisabled EntityStatus = "SendDisabled"
	// Unknown specifies the unknown state for entity status.
	Unknown EntityStatus = "Unknown"
)

// FilterType enumerates the values for filter type.
type FilterType string

const (
	// FilterTypeCorrelationFilter specifies the filter type correlation filter state for filter type.
	FilterTypeCorrelationFilter FilterType = "CorrelationFilter"
	// FilterTypeSQLFilter specifies the filter type sql filter state for filter type.
	FilterTypeSQLFilter FilterType = "SqlFilter"
)

// KeyType enumerates the values for key type.
type KeyType string

const (
	// PrimaryKey specifies the primary key state for key type.
	PrimaryKey KeyType = "PrimaryKey"
	// SecondaryKey specifies the secondary key state for key type.
	SecondaryKey KeyType = "SecondaryKey"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic specifies the basic state for sku name.
	Basic SkuName = "Basic"
	// Premium specifies the premium state for sku name.
	Premium SkuName = "Premium"
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic specifies the sku tier basic state for sku tier.
	SkuTierBasic SkuTier = "Basic"
	// SkuTierPremium specifies the sku tier premium state for sku tier.
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard specifies the sku tier standard state for sku tier.
	SkuTierStandard SkuTier = "Standard"
)

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName specifies the invalid name state for unavailable reason.
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown specifies the name in lockdown state for unavailable reason.
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse specifies the name in use state for unavailable reason.
	NameInUse UnavailableReason = "NameInUse"
	// None specifies the none state for unavailable reason.
	None UnavailableReason = "None"
	// SubscriptionIsDisabled specifies the subscription is disabled state for unavailable reason.
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription specifies the too many namespace in current subscription state for unavailable
	// reason.
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// AccessKeys is namespace/ServiceBus Connection String
type AccessKeys struct {
	autorest.Response         `json:"-"`
	PrimaryConnectionString   *string `json:"primaryConnectionString,omitempty"`
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	PrimaryKey                *string `json:"primaryKey,omitempty"`
	SecondaryKey              *string `json:"secondaryKey,omitempty"`
	KeyName                   *string `json:"keyName,omitempty"`
}

// Action is represents the filter actions which are allowed for the transformation of a message that have been matched
// by a filter expression.
type Action struct {
	SQLExpression         *string `json:"sqlExpression,omitempty"`
	CompatibilityLevel    *int32  `json:"compatibilityLevel,omitempty"`
	RequiresPreprocessing *bool   `json:"requiresPreprocessing,omitempty"`
}

// AuthorizationRuleProperties is authorizationRule properties.
type AuthorizationRuleProperties struct {
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// CaptureDescription is properties to configure capture description for eventhub
type CaptureDescription struct {
	Enabled           *bool                      `json:"enabled,omitempty"`
	Encoding          EncodingCaptureDescription `json:"encoding,omitempty"`
	IntervalInSeconds *int32                     `json:"intervalInSeconds,omitempty"`
	SizeLimitInBytes  *int32                     `json:"sizeLimitInBytes,omitempty"`
	Destination       *Destination               `json:"destination,omitempty"`
}

// CheckNameAvailability is description of a Check Name availability request properties.
type CheckNameAvailability struct {
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult is description of a Check Name availability request properties.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	Message           *string           `json:"message,omitempty"`
	NameAvailable     *bool             `json:"nameAvailable,omitempty"`
	Reason            UnavailableReason `json:"reason,omitempty"`
}

// CorrelationFilter is represents the correlation filter expression.
type CorrelationFilter struct {
	CorrelationID         *string `json:"correlationId,omitempty"`
	MessageID             *string `json:"messageId,omitempty"`
	To                    *string `json:"to,omitempty"`
	ReplyTo               *string `json:"replyTo,omitempty"`
	Label                 *string `json:"label,omitempty"`
	SessionID             *string `json:"sessionId,omitempty"`
	ReplyToSessionID      *string `json:"replyToSessionId,omitempty"`
	ContentType           *string `json:"contentType,omitempty"`
	RequiresPreprocessing *bool   `json:"requiresPreprocessing,omitempty"`
}

// Destination is capture storage details for capture description
type Destination struct {
	Name                   *string `json:"name,omitempty"`
	*DestinationProperties `json:"properties,omitempty"`
}

// DestinationProperties is properties describing the storage account, blob container and acrchive name format for
// capture destination
type DestinationProperties struct {
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	BlobContainer            *string `json:"blobContainer,omitempty"`
	ArchiveNameFormat        *string `json:"archiveNameFormat,omitempty"`
}

// ErrorResponse is error reponse indicates ServiceBus service is not able to process the incoming request. The reason
// is provided in the error message.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Eventhub is single item in List or Get Event Hub operation
type Eventhub struct {
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	Type                *string `json:"type,omitempty"`
	*EventhubProperties `json:"properties,omitempty"`
}

// EventHubListResult is the result of the List EventHubs operation.
type EventHubListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Eventhub `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// EventHubListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EventHubListResult) EventHubListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EventhubProperties is properties supplied to the Create Or Update Event Hub operation.
type EventhubProperties struct {
	PartitionIds           *[]string           `json:"partitionIds,omitempty"`
	CreatedAt              *date.Time          `json:"createdAt,omitempty"`
	UpdatedAt              *date.Time          `json:"updatedAt,omitempty"`
	MessageRetentionInDays *int64              `json:"messageRetentionInDays,omitempty"`
	PartitionCount         *int64              `json:"partitionCount,omitempty"`
	Status                 EntityStatus        `json:"status,omitempty"`
	CaptureDescription     *CaptureDescription `json:"captureDescription,omitempty"`
}

// MessageCountDetails is message Count Details.
type MessageCountDetails struct {
	ActiveMessageCount             *int64 `json:"activeMessageCount,omitempty"`
	DeadLetterMessageCount         *int64 `json:"deadLetterMessageCount,omitempty"`
	ScheduledMessageCount          *int64 `json:"scheduledMessageCount,omitempty"`
	TransferMessageCount           *int64 `json:"transferMessageCount,omitempty"`
	TransferDeadLetterMessageCount *int64 `json:"transferDeadLetterMessageCount,omitempty"`
}

// Operation is a ServiceBus REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is the object that represents the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list ServiceBus operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PremiumMessagingRegions is premium Messaging Region
type PremiumMessagingRegions struct {
	ID         *string                            `json:"id,omitempty"`
	Name       *string                            `json:"name,omitempty"`
	Type       *string                            `json:"type,omitempty"`
	Location   *string                            `json:"location,omitempty"`
	Tags       *map[string]*string                `json:"tags,omitempty"`
	Properties *PremiumMessagingRegionsProperties `json:"properties,omitempty"`
}

// PremiumMessagingRegionsListResult is the response of the List PremiumMessagingRegions operation.
type PremiumMessagingRegionsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PremiumMessagingRegions `json:"value,omitempty"`
	NextLink          *string                    `json:"nextLink,omitempty"`
}

// PremiumMessagingRegionsListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PremiumMessagingRegionsListResult) PremiumMessagingRegionsListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PremiumMessagingRegionsProperties is
type PremiumMessagingRegionsProperties struct {
	Code     *string `json:"code,omitempty"`
	FullName *string `json:"fullName,omitempty"`
}

// RegenerateAccessKeyParameters is parameters supplied to the Regenerate Authorization Rule operation, specifies which
// key neeeds to be reset.
type RegenerateAccessKeyParameters struct {
	KeyType KeyType `json:"keyType,omitempty"`
	Key     *string `json:"key,omitempty"`
}

// Resource is the Resource definition for other than namespace.
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// ResourceNamespacePatch is the Resource definition.
type ResourceNamespacePatch struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// Rule is description of Rule Resource.
type Rule struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*Ruleproperties   `json:"properties,omitempty"`
}

// RuleListResult is the response of the List rule operation.
type RuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Rule `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// RuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RuleListResult) RuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Ruleproperties is description of Rule Resource.
type Ruleproperties struct {
	Action            *Action            `json:"action,omitempty"`
	FilterType        FilterType         `json:"filterType,omitempty"`
	SQLFilter         *SQLFilter         `json:"sqlFilter,omitempty"`
	CorrelationFilter *CorrelationFilter `json:"correlationFilter,omitempty"`
}

// SBAuthorizationRule is description of a namespace authorization rule.
type SBAuthorizationRule struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	*SBAuthorizationRuleProperties `json:"properties,omitempty"`
}

// SBAuthorizationRuleListResult is the response to the List Namespace operation.
type SBAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SBAuthorizationRule `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// SBAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SBAuthorizationRuleListResult) SBAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SBAuthorizationRuleProperties is authorizationRule properties.
type SBAuthorizationRuleProperties struct {
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SBNamespace is description of a namespace resource.
type SBNamespace struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	Sku                    *SBSku              `json:"sku,omitempty"`
	*SBNamespaceProperties `json:"properties,omitempty"`
}

// SBNamespaceListResult is the response of the List Namespace operation.
type SBNamespaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SBNamespace `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// SBNamespaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SBNamespaceListResult) SBNamespaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SBNamespaceProperties is properties of the namespace.
type SBNamespaceProperties struct {
	ProvisioningState  *string    `json:"provisioningState,omitempty"`
	CreatedAt          *date.Time `json:"createdAt,omitempty"`
	UpdatedAt          *date.Time `json:"updatedAt,omitempty"`
	ServiceBusEndpoint *string    `json:"serviceBusEndpoint,omitempty"`
	MetricID           *string    `json:"metricId,omitempty"`
}

// SBNamespaceUpdateParameters is description of a namespace resource.
type SBNamespaceUpdateParameters struct {
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	Sku                    *SBSku              `json:"sku,omitempty"`
	*SBNamespaceProperties `json:"properties,omitempty"`
}

// SBQueue is description of queue Resource.
type SBQueue struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	Type               *string `json:"type,omitempty"`
	*SBQueueProperties `json:"properties,omitempty"`
}

// SBQueueListResult is the response to the List Queues operation.
type SBQueueListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SBQueue `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// SBQueueListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SBQueueListResult) SBQueueListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SBQueueProperties is the Queue Properties definition.
type SBQueueProperties struct {
	CountDetails                        *MessageCountDetails `json:"countDetails,omitempty"`
	CreatedAt                           *date.Time           `json:"createdAt,omitempty"`
	UpdatedAt                           *date.Time           `json:"updatedAt,omitempty"`
	AccessedAt                          *date.Time           `json:"accessedAt,omitempty"`
	SizeInBytes                         *int64               `json:"sizeInBytes,omitempty"`
	MessageCount                        *int64               `json:"messageCount,omitempty"`
	LockDuration                        *string              `json:"lockDuration,omitempty"`
	MaxSizeInMegabytes                  *int32               `json:"maxSizeInMegabytes,omitempty"`
	RequiresDuplicateDetection          *bool                `json:"requiresDuplicateDetection,omitempty"`
	RequiresSession                     *bool                `json:"requiresSession,omitempty"`
	DefaultMessageTimeToLive            *string              `json:"defaultMessageTimeToLive,omitempty"`
	DeadLetteringOnMessageExpiration    *bool                `json:"deadLetteringOnMessageExpiration,omitempty"`
	DuplicateDetectionHistoryTimeWindow *string              `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	MaxDeliveryCount                    *int32               `json:"maxDeliveryCount,omitempty"`
	Status                              EntityStatus         `json:"status,omitempty"`
	AutoDeleteOnIdle                    *string              `json:"autoDeleteOnIdle,omitempty"`
	EnablePartitioning                  *bool                `json:"enablePartitioning,omitempty"`
	EnableExpress                       *bool                `json:"enableExpress,omitempty"`
}

// SBSku is SKU of the namespace.
type SBSku struct {
	Name     SkuName `json:"name,omitempty"`
	Tier     SkuTier `json:"tier,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// SBSubscription is description of subscription resource.
type SBSubscription struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*SBSubscriptionProperties `json:"properties,omitempty"`
}

// SBSubscriptionListResult is the response to the List Subscriptions operation.
type SBSubscriptionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SBSubscription `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// SBSubscriptionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SBSubscriptionListResult) SBSubscriptionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SBSubscriptionProperties is description of Subscription Resource.
type SBSubscriptionProperties struct {
	MessageCount                        *int64               `json:"messageCount,omitempty"`
	CreatedAt                           *date.Time           `json:"createdAt,omitempty"`
	AccessedAt                          *date.Time           `json:"accessedAt,omitempty"`
	UpdatedAt                           *date.Time           `json:"updatedAt,omitempty"`
	CountDetails                        *MessageCountDetails `json:"countDetails,omitempty"`
	LockDuration                        *string              `json:"lockDuration,omitempty"`
	RequiresSession                     *bool                `json:"requiresSession,omitempty"`
	DefaultMessageTimeToLive            *string              `json:"defaultMessageTimeToLive,omitempty"`
	DeadLetteringOnMessageExpiration    *bool                `json:"deadLetteringOnMessageExpiration,omitempty"`
	DuplicateDetectionHistoryTimeWindow *string              `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	MaxDeliveryCount                    *int32               `json:"maxDeliveryCount,omitempty"`
	Status                              EntityStatus         `json:"status,omitempty"`
	EnableBatchedOperations             *bool                `json:"enableBatchedOperations,omitempty"`
	AutoDeleteOnIdle                    *string              `json:"autoDeleteOnIdle,omitempty"`
}

// SBTopic is description of topic resource.
type SBTopic struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	Type               *string `json:"type,omitempty"`
	*SBTopicProperties `json:"properties,omitempty"`
}

// SBTopicListResult is the response to the List Topics operation.
type SBTopicListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SBTopic `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// SBTopicListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SBTopicListResult) SBTopicListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SBTopicProperties is the Tpoic Properties definition.
type SBTopicProperties struct {
	SizeInBytes                         *int64               `json:"sizeInBytes,omitempty"`
	CreatedAt                           *date.Time           `json:"createdAt,omitempty"`
	UpdatedAt                           *date.Time           `json:"updatedAt,omitempty"`
	AccessedAt                          *date.Time           `json:"accessedAt,omitempty"`
	SubscriptionCount                   *int32               `json:"subscriptionCount,omitempty"`
	CountDetails                        *MessageCountDetails `json:"countDetails,omitempty"`
	DefaultMessageTimeToLive            *string              `json:"defaultMessageTimeToLive,omitempty"`
	MaxSizeInMegabytes                  *int32               `json:"maxSizeInMegabytes,omitempty"`
	RequiresDuplicateDetection          *bool                `json:"requiresDuplicateDetection,omitempty"`
	DuplicateDetectionHistoryTimeWindow *string              `json:"duplicateDetectionHistoryTimeWindow,omitempty"`
	EnableBatchedOperations             *bool                `json:"enableBatchedOperations,omitempty"`
	Status                              EntityStatus         `json:"status,omitempty"`
	SupportOrdering                     *bool                `json:"supportOrdering,omitempty"`
	AutoDeleteOnIdle                    *string              `json:"autoDeleteOnIdle,omitempty"`
	EnablePartitioning                  *bool                `json:"enablePartitioning,omitempty"`
	EnableExpress                       *bool                `json:"enableExpress,omitempty"`
}

// SQLFilter is represents a filter which is a composition of an expression and an action that is executed in the
// pub/sub pipeline.
type SQLFilter struct {
	SQLExpression         *string `json:"sqlExpression,omitempty"`
	CompatibilityLevel    *int32  `json:"compatibilityLevel,omitempty"`
	RequiresPreprocessing *bool   `json:"requiresPreprocessing,omitempty"`
}

// SQLRuleAction is represents set of actions written in SQL language-based syntax that is performed against a
// ServiceBus.Messaging.BrokeredMessage
type SQLRuleAction struct {
	SQLExpression         *string `json:"sqlExpression,omitempty"`
	CompatibilityLevel    *int32  `json:"compatibilityLevel,omitempty"`
	RequiresPreprocessing *bool   `json:"requiresPreprocessing,omitempty"`
}

// TrackedResource is the Resource definition.
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}
