package recoveryservicessiterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// A2ARpRecoveryPointType enumerates the values for a2a rp recovery point type.
type A2ARpRecoveryPointType string

const (
	// Latest specifies the latest state for a2a rp recovery point type.
	Latest A2ARpRecoveryPointType = "Latest"
	// LatestApplicationConsistent specifies the latest application consistent state for a2a rp recovery point type.
	LatestApplicationConsistent A2ARpRecoveryPointType = "LatestApplicationConsistent"
	// LatestCrashConsistent specifies the latest crash consistent state for a2a rp recovery point type.
	LatestCrashConsistent A2ARpRecoveryPointType = "LatestCrashConsistent"
	// LatestProcessed specifies the latest processed state for a2a rp recovery point type.
	LatestProcessed A2ARpRecoveryPointType = "LatestProcessed"
)

// AlternateLocationRecoveryOption enumerates the values for alternate location recovery option.
type AlternateLocationRecoveryOption string

const (
	// CreateVMIfNotFound specifies the create vm if not found state for alternate location recovery option.
	CreateVMIfNotFound AlternateLocationRecoveryOption = "CreateVmIfNotFound"
	// NoAction specifies the no action state for alternate location recovery option.
	NoAction AlternateLocationRecoveryOption = "NoAction"
)

// DataSyncStatus enumerates the values for data sync status.
type DataSyncStatus string

const (
	// ForDownTime specifies the for down time state for data sync status.
	ForDownTime DataSyncStatus = "ForDownTime"
	// ForSynchronization specifies the for synchronization state for data sync status.
	ForSynchronization DataSyncStatus = "ForSynchronization"
)

// DisableProtectionReason enumerates the values for disable protection reason.
type DisableProtectionReason string

const (
	// MigrationComplete specifies the migration complete state for disable protection reason.
	MigrationComplete DisableProtectionReason = "MigrationComplete"
	// NotSpecified specifies the not specified state for disable protection reason.
	NotSpecified DisableProtectionReason = "NotSpecified"
)

// FailoverDeploymentModel enumerates the values for failover deployment model.
type FailoverDeploymentModel string

const (
	// Classic specifies the classic state for failover deployment model.
	Classic FailoverDeploymentModel = "Classic"
	// NotApplicable specifies the not applicable state for failover deployment model.
	NotApplicable FailoverDeploymentModel = "NotApplicable"
	// ResourceManager specifies the resource manager state for failover deployment model.
	ResourceManager FailoverDeploymentModel = "ResourceManager"
)

// HealthErrorCategory enumerates the values for health error category.
type HealthErrorCategory string

const (
	// Configuration specifies the configuration state for health error category.
	Configuration HealthErrorCategory = "Configuration"
	// Replication specifies the replication state for health error category.
	Replication HealthErrorCategory = "Replication"
	// TestFailover specifies the test failover state for health error category.
	TestFailover HealthErrorCategory = "TestFailover"
)

// HyperVReplicaAzureRpRecoveryPointType enumerates the values for hyper v replica azure rp recovery point type.
type HyperVReplicaAzureRpRecoveryPointType string

const (
	// HyperVReplicaAzureRpRecoveryPointTypeLatest specifies the hyper v replica azure rp recovery point type latest state
	// for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatest HyperVReplicaAzureRpRecoveryPointType = "Latest"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent specifies the hyper v replica azure rp recovery
	// point type latest application consistent state for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = "LatestApplicationConsistent"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed specifies the hyper v replica azure rp recovery point type
	// latest processed state for hyper v replica azure rp recovery point type.
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed HyperVReplicaAzureRpRecoveryPointType = "LatestProcessed"
)

// IdentityProviderType enumerates the values for identity provider type.
type IdentityProviderType string

const (
	// CustomerActiveDirectory specifies the customer active directory state for identity provider type.
	CustomerActiveDirectory IdentityProviderType = "CustomerActiveDirectory"
	// RecoveryServicesActiveDirectory specifies the recovery services active directory state for identity provider type.
	RecoveryServicesActiveDirectory IdentityProviderType = "RecoveryServicesActiveDirectory"
)

// InMageV2RpRecoveryPointType enumerates the values for in mage v2 rp recovery point type.
type InMageV2RpRecoveryPointType string

const (
	// InMageV2RpRecoveryPointTypeLatest specifies the in mage v2 rp recovery point type latest state for in mage v2 rp
	// recovery point type.
	InMageV2RpRecoveryPointTypeLatest InMageV2RpRecoveryPointType = "Latest"
	// InMageV2RpRecoveryPointTypeLatestApplicationConsistent specifies the in mage v2 rp recovery point type latest
	// application consistent state for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = "LatestApplicationConsistent"
	// InMageV2RpRecoveryPointTypeLatestCrashConsistent specifies the in mage v2 rp recovery point type latest crash
	// consistent state for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestCrashConsistent InMageV2RpRecoveryPointType = "LatestCrashConsistent"
	// InMageV2RpRecoveryPointTypeLatestProcessed specifies the in mage v2 rp recovery point type latest processed state
	// for in mage v2 rp recovery point type.
	InMageV2RpRecoveryPointTypeLatestProcessed InMageV2RpRecoveryPointType = "LatestProcessed"
)

// InstanceType enumerates the values for instance type.
type InstanceType string

const (
	// InstanceTypeA2A specifies the instance type a2a state for instance type.
	InstanceTypeA2A InstanceType = "A2A"
	// InstanceTypeHyperVReplica2012 specifies the instance type hyper v replica 2012 state for instance type.
	InstanceTypeHyperVReplica2012 InstanceType = "HyperVReplica2012"
	// InstanceTypeHyperVReplica2012R2 specifies the instance type hyper v replica 2012r2 state for instance type.
	InstanceTypeHyperVReplica2012R2 InstanceType = "HyperVReplica2012R2"
	// InstanceTypeHyperVReplicaAzure specifies the instance type hyper v replica azure state for instance type.
	InstanceTypeHyperVReplicaAzure InstanceType = "HyperVReplicaAzure"
	// InstanceTypeHyperVReplicaBaseEventDetails specifies the instance type hyper v replica base event details state for
	// instance type.
	InstanceTypeHyperVReplicaBaseEventDetails InstanceType = "HyperVReplicaBaseEventDetails"
	// InstanceTypeInMageAzureV2 specifies the instance type in mage azure v2 state for instance type.
	InstanceTypeInMageAzureV2 InstanceType = "InMageAzureV2"
)

// InstanceTypeConfigurationSettings enumerates the values for instance type configuration settings.
type InstanceTypeConfigurationSettings string

const (
	// InstanceTypeHyperVVirtualMachine specifies the instance type hyper v virtual machine state for instance type
	// configuration settings.
	InstanceTypeHyperVVirtualMachine InstanceTypeConfigurationSettings = "HyperVVirtualMachine"
	// InstanceTypeReplicationGroupDetails specifies the instance type replication group details state for instance type
	// configuration settings.
	InstanceTypeReplicationGroupDetails InstanceTypeConfigurationSettings = "ReplicationGroupDetails"
	// InstanceTypeVMwareVirtualMachine specifies the instance type v mware virtual machine state for instance type
	// configuration settings.
	InstanceTypeVMwareVirtualMachine InstanceTypeConfigurationSettings = "VMwareVirtualMachine"
)

// InstanceTypeDisableProtectionProviderSpecificInput enumerates the values for instance type disable protection
// provider specific input.
type InstanceTypeDisableProtectionProviderSpecificInput string

const (
	// InstanceTypeInMage specifies the instance type in mage state for instance type disable protection provider specific
	// input.
	InstanceTypeInMage InstanceTypeDisableProtectionProviderSpecificInput = "InMage"
)

// InstanceTypeEnableProtectionProviderSpecificInput enumerates the values for instance type enable protection provider
// specific input.
type InstanceTypeEnableProtectionProviderSpecificInput string

const (
	// InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeA2A specifies the instance type enable protection
	// provider specific input instance type a2a state for instance type enable protection provider specific input.
	InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeA2A InstanceTypeEnableProtectionProviderSpecificInput = "A2A"
	// InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure specifies the instance type enable
	// protection provider specific input instance type hyper v replica azure state for instance type enable protection
	// provider specific input.
	InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeEnableProtectionProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMage specifies the instance type enable protection
	// provider specific input instance type in mage state for instance type enable protection provider specific input.
	InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMage InstanceTypeEnableProtectionProviderSpecificInput = "InMage"
	// InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 specifies the instance type enable
	// protection provider specific input instance type in mage azure v2 state for instance type enable protection provider
	// specific input.
	InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeEnableProtectionProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeSan specifies the instance type enable protection
	// provider specific input instance type san state for instance type enable protection provider specific input.
	InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeSan InstanceTypeEnableProtectionProviderSpecificInput = "San"
)

// InstanceTypeEventSpecificDetails enumerates the values for instance type event specific details.
type InstanceTypeEventSpecificDetails string

const (
	// InstanceTypeJobStatus specifies the instance type job status state for instance type event specific details.
	InstanceTypeJobStatus InstanceTypeEventSpecificDetails = "JobStatus"
)

// InstanceTypeFabricSpecificCreateNetworkMappingInput enumerates the values for instance type fabric specific create
// network mapping input.
type InstanceTypeFabricSpecificCreateNetworkMappingInput string

const (
	// InstanceTypeAzureToAzure specifies the instance type azure to azure state for instance type fabric specific create
	// network mapping input.
	InstanceTypeAzureToAzure InstanceTypeFabricSpecificCreateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeVmmToAzure specifies the instance type vmm to azure state for instance type fabric specific create
	// network mapping input.
	InstanceTypeVmmToAzure InstanceTypeFabricSpecificCreateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeVmmToVmm specifies the instance type vmm to vmm state for instance type fabric specific create network
	// mapping input.
	InstanceTypeVmmToVmm InstanceTypeFabricSpecificCreateNetworkMappingInput = "VmmToVmm"
)

// InstanceTypeFabricSpecificCreationInput enumerates the values for instance type fabric specific creation input.
type InstanceTypeFabricSpecificCreationInput string

const (
	// InstanceTypeFabricSpecificCreationInputInstanceTypeA2A specifies the instance type fabric specific creation input
	// instance type a2a state for instance type fabric specific creation input.
	InstanceTypeFabricSpecificCreationInputInstanceTypeA2A InstanceTypeFabricSpecificCreationInput = "A2A"
	// InstanceTypeFabricSpecificCreationInputInstanceTypeVMwareV2 specifies the instance type fabric specific creation
	// input instance type v mware v2 state for instance type fabric specific creation input.
	InstanceTypeFabricSpecificCreationInputInstanceTypeVMwareV2 InstanceTypeFabricSpecificCreationInput = "VMwareV2"
)

// InstanceTypeFabricSpecificDetails enumerates the values for instance type fabric specific details.
type InstanceTypeFabricSpecificDetails string

const (
	// InstanceTypeAzure specifies the instance type azure state for instance type fabric specific details.
	InstanceTypeAzure InstanceTypeFabricSpecificDetails = "Azure"
	// InstanceTypeHyperVSite specifies the instance type hyper v site state for instance type fabric specific details.
	InstanceTypeHyperVSite InstanceTypeFabricSpecificDetails = "HyperVSite"
	// InstanceTypeVMM specifies the instance type vmm state for instance type fabric specific details.
	InstanceTypeVMM InstanceTypeFabricSpecificDetails = "VMM"
	// InstanceTypeVMware specifies the instance type v mware state for instance type fabric specific details.
	InstanceTypeVMware InstanceTypeFabricSpecificDetails = "VMware"
	// InstanceTypeVMwareV2 specifies the instance type v mware v2 state for instance type fabric specific details.
	InstanceTypeVMwareV2 InstanceTypeFabricSpecificDetails = "VMwareV2"
)

// InstanceTypeFabricSpecificUpdateNetworkMappingInput enumerates the values for instance type fabric specific update
// network mapping input.
type InstanceTypeFabricSpecificUpdateNetworkMappingInput string

const (
	// InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure specifies the instance type fabric
	// specific update network mapping input instance type azure to azure state for instance type fabric specific update
	// network mapping input.
	InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure InstanceTypeFabricSpecificUpdateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure specifies the instance type fabric
	// specific update network mapping input instance type vmm to azure state for instance type fabric specific update
	// network mapping input.
	InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure InstanceTypeFabricSpecificUpdateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm specifies the instance type fabric specific
	// update network mapping input instance type vmm to vmm state for instance type fabric specific update network mapping
	// input.
	InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm InstanceTypeFabricSpecificUpdateNetworkMappingInput = "VmmToVmm"
)

// InstanceTypeGroupTaskDetails enumerates the values for instance type group task details.
type InstanceTypeGroupTaskDetails string

const (
	// InstanceTypeInlineWorkflowTaskDetails specifies the instance type inline workflow task details state for instance
	// type group task details.
	InstanceTypeInlineWorkflowTaskDetails InstanceTypeGroupTaskDetails = "InlineWorkflowTaskDetails"
	// InstanceTypeRecoveryPlanGroupTaskDetails specifies the instance type recovery plan group task details state for
	// instance type group task details.
	InstanceTypeRecoveryPlanGroupTaskDetails InstanceTypeGroupTaskDetails = "RecoveryPlanGroupTaskDetails"
	// InstanceTypeRecoveryPlanShutdownGroupTaskDetails specifies the instance type recovery plan shutdown group task
	// details state for instance type group task details.
	InstanceTypeRecoveryPlanShutdownGroupTaskDetails InstanceTypeGroupTaskDetails = "RecoveryPlanShutdownGroupTaskDetails"
)

// InstanceTypeJobDetails enumerates the values for instance type job details.
type InstanceTypeJobDetails string

const (
	// InstanceTypeAsrJobDetails specifies the instance type asr job details state for instance type job details.
	InstanceTypeAsrJobDetails InstanceTypeJobDetails = "AsrJobDetails"
	// InstanceTypeExportJobDetails specifies the instance type export job details state for instance type job details.
	InstanceTypeExportJobDetails InstanceTypeJobDetails = "ExportJobDetails"
	// InstanceTypeFailoverJobDetails specifies the instance type failover job details state for instance type job details.
	InstanceTypeFailoverJobDetails InstanceTypeJobDetails = "FailoverJobDetails"
	// InstanceTypeSwitchProtectionJobDetails specifies the instance type switch protection job details state for instance
	// type job details.
	InstanceTypeSwitchProtectionJobDetails InstanceTypeJobDetails = "SwitchProtectionJobDetails"
	// InstanceTypeTestFailoverJobDetails specifies the instance type test failover job details state for instance type job
	// details.
	InstanceTypeTestFailoverJobDetails InstanceTypeJobDetails = "TestFailoverJobDetails"
)

// InstanceTypeNetworkMappingFabricSpecificSettings enumerates the values for instance type network mapping fabric
// specific settings.
type InstanceTypeNetworkMappingFabricSpecificSettings string

const (
	// InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure specifies the instance type network mapping
	// fabric specific settings instance type azure to azure state for instance type network mapping fabric specific
	// settings.
	InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure InstanceTypeNetworkMappingFabricSpecificSettings = "AzureToAzure"
	// InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure specifies the instance type network mapping
	// fabric specific settings instance type vmm to azure state for instance type network mapping fabric specific
	// settings.
	InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure InstanceTypeNetworkMappingFabricSpecificSettings = "VmmToAzure"
	// InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm specifies the instance type network mapping
	// fabric specific settings instance type vmm to vmm state for instance type network mapping fabric specific settings.
	InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm InstanceTypeNetworkMappingFabricSpecificSettings = "VmmToVmm"
)

// InstanceTypePolicyProviderSpecificDetails enumerates the values for instance type policy provider specific details.
type InstanceTypePolicyProviderSpecificDetails string

const (
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeA2A specifies the instance type policy provider specific
	// details instance type a2a state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeA2A InstanceTypePolicyProviderSpecificDetails = "A2A"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 specifies the instance type policy provider
	// specific details instance type hyper v replica 2012 state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 InstanceTypePolicyProviderSpecificDetails = "HyperVReplica2012"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 specifies the instance type policy provider
	// specific details instance type hyper v replica 2012r2 state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 InstanceTypePolicyProviderSpecificDetails = "HyperVReplica2012R2"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure specifies the instance type policy provider
	// specific details instance type hyper v replica azure state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure InstanceTypePolicyProviderSpecificDetails = "HyperVReplicaAzure"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails specifies the instance type
	// policy provider specific details instance type hyper v replica base policy details state for instance type policy
	// provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails InstanceTypePolicyProviderSpecificDetails = "HyperVReplicaBasePolicyDetails"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMage specifies the instance type policy provider specific
	// details instance type in mage state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMage InstanceTypePolicyProviderSpecificDetails = "InMage"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 specifies the instance type policy provider
	// specific details instance type in mage azure v2 state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 InstanceTypePolicyProviderSpecificDetails = "InMageAzureV2"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails specifies the instance type policy
	// provider specific details instance type in mage base policy details state for instance type policy provider specific
	// details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails InstanceTypePolicyProviderSpecificDetails = "InMageBasePolicyDetails"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration specifies the instance type policy provider
	// specific details instance type rcm azure migration state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration InstanceTypePolicyProviderSpecificDetails = "RcmAzureMigration"
	// InstanceTypePolicyProviderSpecificDetailsInstanceTypeVMwareCbt specifies the instance type policy provider specific
	// details instance type v mware cbt state for instance type policy provider specific details.
	InstanceTypePolicyProviderSpecificDetailsInstanceTypeVMwareCbt InstanceTypePolicyProviderSpecificDetails = "VMwareCbt"
)

// InstanceTypePolicyProviderSpecificInput enumerates the values for instance type policy provider specific input.
type InstanceTypePolicyProviderSpecificInput string

const (
	// InstanceTypePolicyProviderSpecificInputInstanceTypeA2A specifies the instance type policy provider specific input
	// instance type a2a state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeA2A InstanceTypePolicyProviderSpecificInput = "A2A"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012 specifies the instance type policy provider
	// specific input instance type hyper v replica 2012 state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012 InstanceTypePolicyProviderSpecificInput = "HyperVReplica2012"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 specifies the instance type policy provider
	// specific input instance type hyper v replica 2012r2 state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 InstanceTypePolicyProviderSpecificInput = "HyperVReplica2012R2"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure specifies the instance type policy provider
	// specific input instance type hyper v replica azure state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypePolicyProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeInMage specifies the instance type policy provider specific input
	// instance type in mage state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeInMage InstanceTypePolicyProviderSpecificInput = "InMage"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeInMageAzureV2 specifies the instance type policy provider
	// specific input instance type in mage azure v2 state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypePolicyProviderSpecificInput = "InMageAzureV2"
	// InstanceTypePolicyProviderSpecificInputInstanceTypeVMwareCbt specifies the instance type policy provider specific
	// input instance type v mware cbt state for instance type policy provider specific input.
	InstanceTypePolicyProviderSpecificInputInstanceTypeVMwareCbt InstanceTypePolicyProviderSpecificInput = "VMwareCbt"
)

// InstanceTypeProviderSpecificFailoverInput enumerates the values for instance type provider specific failover input.
type InstanceTypeProviderSpecificFailoverInput string

const (
	// InstanceTypeProviderSpecificFailoverInputInstanceTypeA2A specifies the instance type provider specific failover
	// input instance type a2a state for instance type provider specific failover input.
	InstanceTypeProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeProviderSpecificFailoverInput = "A2A"
	// InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure specifies the instance type provider
	// specific failover input instance type hyper v replica azure state for instance type provider specific failover
	// input.
	InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback specifies the instance type provider
	// specific failover input instance type hyper v replica azure failback state for instance type provider specific
	// failover input.
	InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeProviderSpecificFailoverInputInstanceTypeInMage specifies the instance type provider specific failover
	// input instance type in mage state for instance type provider specific failover input.
	InstanceTypeProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeProviderSpecificFailoverInput = "InMage"
	// InstanceTypeProviderSpecificFailoverInputInstanceTypeInMageAzureV2 specifies the instance type provider specific
	// failover input instance type in mage azure v2 state for instance type provider specific failover input.
	InstanceTypeProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeProviderSpecificFailoverInput = "InMageAzureV2"
)

// InstanceTypeRecoveryPlanActionDetails enumerates the values for instance type recovery plan action details.
type InstanceTypeRecoveryPlanActionDetails string

const (
	// InstanceTypeAutomationRunbookActionDetails specifies the instance type automation runbook action details state for
	// instance type recovery plan action details.
	InstanceTypeAutomationRunbookActionDetails InstanceTypeRecoveryPlanActionDetails = "AutomationRunbookActionDetails"
	// InstanceTypeManualActionDetails specifies the instance type manual action details state for instance type recovery
	// plan action details.
	InstanceTypeManualActionDetails InstanceTypeRecoveryPlanActionDetails = "ManualActionDetails"
	// InstanceTypeScriptActionDetails specifies the instance type script action details state for instance type recovery
	// plan action details.
	InstanceTypeScriptActionDetails InstanceTypeRecoveryPlanActionDetails = "ScriptActionDetails"
)

// InstanceTypeRecoveryPlanProviderSpecificFailoverInput enumerates the values for instance type recovery plan provider
// specific failover input.
type InstanceTypeRecoveryPlanProviderSpecificFailoverInput string

const (
	// InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A specifies the instance type recovery plan
	// provider specific failover input instance type a2a state for instance type recovery plan provider specific failover
	// input.
	InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeRecoveryPlanProviderSpecificFailoverInput = "A2A"
	// InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure specifies the instance type
	// recovery plan provider specific failover input instance type hyper v replica azure state for instance type recovery
	// plan provider specific failover input.
	InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback specifies the instance
	// type recovery plan provider specific failover input instance type hyper v replica azure failback state for instance
	// type recovery plan provider specific failover input.
	InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage specifies the instance type recovery plan
	// provider specific failover input instance type in mage state for instance type recovery plan provider specific
	// failover input.
	InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeRecoveryPlanProviderSpecificFailoverInput = "InMage"
	// InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 specifies the instance type recovery
	// plan provider specific failover input instance type in mage azure v2 state for instance type recovery plan provider
	// specific failover input.
	InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeRecoveryPlanProviderSpecificFailoverInput = "InMageAzureV2"
)

// InstanceTypeReplicationProviderSpecificSettings enumerates the values for instance type replication provider
// specific settings.
type InstanceTypeReplicationProviderSpecificSettings string

const (
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeA2A specifies the instance type replication provider
	// specific settings instance type a2a state for instance type replication provider specific settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeA2A InstanceTypeReplicationProviderSpecificSettings = "A2A"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 specifies the instance type replication
	// provider specific settings instance type hyper v replica 2012 state for instance type replication provider specific
	// settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 InstanceTypeReplicationProviderSpecificSettings = "HyperVReplica2012"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 specifies the instance type
	// replication provider specific settings instance type hyper v replica 2012r2 state for instance type replication
	// provider specific settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 InstanceTypeReplicationProviderSpecificSettings = "HyperVReplica2012R2"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure specifies the instance type
	// replication provider specific settings instance type hyper v replica azure state for instance type replication
	// provider specific settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure InstanceTypeReplicationProviderSpecificSettings = "HyperVReplicaAzure"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails specifies the
	// instance type replication provider specific settings instance type hyper v replica base replication details state
	// for instance type replication provider specific settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails InstanceTypeReplicationProviderSpecificSettings = "HyperVReplicaBaseReplicationDetails"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMage specifies the instance type replication provider
	// specific settings instance type in mage state for instance type replication provider specific settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMage InstanceTypeReplicationProviderSpecificSettings = "InMage"
	// InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 specifies the instance type replication
	// provider specific settings instance type in mage azure v2 state for instance type replication provider specific
	// settings.
	InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 InstanceTypeReplicationProviderSpecificSettings = "InMageAzureV2"
)

// InstanceTypeReverseReplicationProviderSpecificInput enumerates the values for instance type reverse replication
// provider specific input.
type InstanceTypeReverseReplicationProviderSpecificInput string

const (
	// InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeA2A specifies the instance type reverse replication
	// provider specific input instance type a2a state for instance type reverse replication provider specific input.
	InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeA2A InstanceTypeReverseReplicationProviderSpecificInput = "A2A"
	// InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure specifies the instance type
	// reverse replication provider specific input instance type hyper v replica azure state for instance type reverse
	// replication provider specific input.
	InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeReverseReplicationProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMage specifies the instance type reverse
	// replication provider specific input instance type in mage state for instance type reverse replication provider
	// specific input.
	InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMage InstanceTypeReverseReplicationProviderSpecificInput = "InMage"
	// InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 specifies the instance type reverse
	// replication provider specific input instance type in mage azure v2 state for instance type reverse replication
	// provider specific input.
	InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeReverseReplicationProviderSpecificInput = "InMageAzureV2"
)

// InstanceTypeTaskTypeDetails enumerates the values for instance type task type details.
type InstanceTypeTaskTypeDetails string

const (
	// InstanceTypeAutomationRunbookTaskDetails specifies the instance type automation runbook task details state for
	// instance type task type details.
	InstanceTypeAutomationRunbookTaskDetails InstanceTypeTaskTypeDetails = "AutomationRunbookTaskDetails"
	// InstanceTypeConsistencyCheckTaskDetails specifies the instance type consistency check task details state for
	// instance type task type details.
	InstanceTypeConsistencyCheckTaskDetails InstanceTypeTaskTypeDetails = "ConsistencyCheckTaskDetails"
	// InstanceTypeFabricReplicationGroupTaskDetails specifies the instance type fabric replication group task details
	// state for instance type task type details.
	InstanceTypeFabricReplicationGroupTaskDetails InstanceTypeTaskTypeDetails = "FabricReplicationGroupTaskDetails"
	// InstanceTypeJobTaskDetails specifies the instance type job task details state for instance type task type details.
	InstanceTypeJobTaskDetails InstanceTypeTaskTypeDetails = "JobTaskDetails"
	// InstanceTypeManualActionTaskDetails specifies the instance type manual action task details state for instance type
	// task type details.
	InstanceTypeManualActionTaskDetails InstanceTypeTaskTypeDetails = "ManualActionTaskDetails"
	// InstanceTypeScriptActionTaskDetails specifies the instance type script action task details state for instance type
	// task type details.
	InstanceTypeScriptActionTaskDetails InstanceTypeTaskTypeDetails = "ScriptActionTaskDetails"
	// InstanceTypeVirtualMachineTaskDetails specifies the instance type virtual machine task details state for instance
	// type task type details.
	InstanceTypeVirtualMachineTaskDetails InstanceTypeTaskTypeDetails = "VirtualMachineTaskDetails"
	// InstanceTypeVMNicUpdatesTaskDetails specifies the instance type vm nic updates task details state for instance type
	// task type details.
	InstanceTypeVMNicUpdatesTaskDetails InstanceTypeTaskTypeDetails = "VmNicUpdatesTaskDetails"
)

// LicenseType enumerates the values for license type.
type LicenseType string

const (
	// LicenseTypeNoLicenseType specifies the license type no license type state for license type.
	LicenseTypeNoLicenseType LicenseType = "NoLicenseType"
	// LicenseTypeNotSpecified specifies the license type not specified state for license type.
	LicenseTypeNotSpecified LicenseType = "NotSpecified"
	// LicenseTypeWindowsServer specifies the license type windows server state for license type.
	LicenseTypeWindowsServer LicenseType = "WindowsServer"
)

// MultiVMSyncStatus enumerates the values for multi vm sync status.
type MultiVMSyncStatus string

const (
	// Disabled specifies the disabled state for multi vm sync status.
	Disabled MultiVMSyncStatus = "Disabled"
	// Enabled specifies the enabled state for multi vm sync status.
	Enabled MultiVMSyncStatus = "Enabled"
)

// PossibleOperationsDirections enumerates the values for possible operations directions.
type PossibleOperationsDirections string

const (
	// PrimaryToRecovery specifies the primary to recovery state for possible operations directions.
	PrimaryToRecovery PossibleOperationsDirections = "PrimaryToRecovery"
	// RecoveryToPrimary specifies the recovery to primary state for possible operations directions.
	RecoveryToPrimary PossibleOperationsDirections = "RecoveryToPrimary"
)

// RecoveryPlanActionLocation enumerates the values for recovery plan action location.
type RecoveryPlanActionLocation string

const (
	// Primary specifies the primary state for recovery plan action location.
	Primary RecoveryPlanActionLocation = "Primary"
	// Recovery specifies the recovery state for recovery plan action location.
	Recovery RecoveryPlanActionLocation = "Recovery"
)

// RecoveryPlanGroupType enumerates the values for recovery plan group type.
type RecoveryPlanGroupType string

const (
	// Boot specifies the boot state for recovery plan group type.
	Boot RecoveryPlanGroupType = "Boot"
	// Failover specifies the failover state for recovery plan group type.
	Failover RecoveryPlanGroupType = "Failover"
	// Shutdown specifies the shutdown state for recovery plan group type.
	Shutdown RecoveryPlanGroupType = "Shutdown"
)

// RecoveryPointType enumerates the values for recovery point type.
type RecoveryPointType string

const (
	// Custom specifies the custom state for recovery point type.
	Custom RecoveryPointType = "Custom"
	// LatestTag specifies the latest tag state for recovery point type.
	LatestTag RecoveryPointType = "LatestTag"
	// LatestTime specifies the latest time state for recovery point type.
	LatestTime RecoveryPointType = "LatestTime"
)

// ReplicationProtectedItemOperation enumerates the values for replication protected item operation.
type ReplicationProtectedItemOperation string

const (
	// ReplicationProtectedItemOperationChangePit specifies the replication protected item operation change pit state for
	// replication protected item operation.
	ReplicationProtectedItemOperationChangePit ReplicationProtectedItemOperation = "ChangePit"
	// ReplicationProtectedItemOperationCommit specifies the replication protected item operation commit state for
	// replication protected item operation.
	ReplicationProtectedItemOperationCommit ReplicationProtectedItemOperation = "Commit"
	// ReplicationProtectedItemOperationCompleteMigration specifies the replication protected item operation complete
	// migration state for replication protected item operation.
	ReplicationProtectedItemOperationCompleteMigration ReplicationProtectedItemOperation = "CompleteMigration"
	// ReplicationProtectedItemOperationDisableProtection specifies the replication protected item operation disable
	// protection state for replication protected item operation.
	ReplicationProtectedItemOperationDisableProtection ReplicationProtectedItemOperation = "DisableProtection"
	// ReplicationProtectedItemOperationFailback specifies the replication protected item operation failback state for
	// replication protected item operation.
	ReplicationProtectedItemOperationFailback ReplicationProtectedItemOperation = "Failback"
	// ReplicationProtectedItemOperationFinalizeFailback specifies the replication protected item operation finalize
	// failback state for replication protected item operation.
	ReplicationProtectedItemOperationFinalizeFailback ReplicationProtectedItemOperation = "FinalizeFailback"
	// ReplicationProtectedItemOperationPlannedFailover specifies the replication protected item operation planned failover
	// state for replication protected item operation.
	ReplicationProtectedItemOperationPlannedFailover ReplicationProtectedItemOperation = "PlannedFailover"
	// ReplicationProtectedItemOperationRepairReplication specifies the replication protected item operation repair
	// replication state for replication protected item operation.
	ReplicationProtectedItemOperationRepairReplication ReplicationProtectedItemOperation = "RepairReplication"
	// ReplicationProtectedItemOperationReverseReplicate specifies the replication protected item operation reverse
	// replicate state for replication protected item operation.
	ReplicationProtectedItemOperationReverseReplicate ReplicationProtectedItemOperation = "ReverseReplicate"
	// ReplicationProtectedItemOperationSwitchProtection specifies the replication protected item operation switch
	// protection state for replication protected item operation.
	ReplicationProtectedItemOperationSwitchProtection ReplicationProtectedItemOperation = "SwitchProtection"
	// ReplicationProtectedItemOperationTestFailover specifies the replication protected item operation test failover state
	// for replication protected item operation.
	ReplicationProtectedItemOperationTestFailover ReplicationProtectedItemOperation = "TestFailover"
	// ReplicationProtectedItemOperationTestFailoverCleanup specifies the replication protected item operation test
	// failover cleanup state for replication protected item operation.
	ReplicationProtectedItemOperationTestFailoverCleanup ReplicationProtectedItemOperation = "TestFailoverCleanup"
	// ReplicationProtectedItemOperationUnplannedFailover specifies the replication protected item operation unplanned
	// failover state for replication protected item operation.
	ReplicationProtectedItemOperationUnplannedFailover ReplicationProtectedItemOperation = "UnplannedFailover"
)

// RpInMageRecoveryPointType enumerates the values for rp in mage recovery point type.
type RpInMageRecoveryPointType string

const (
	// RpInMageRecoveryPointTypeCustom specifies the rp in mage recovery point type custom state for rp in mage recovery
	// point type.
	RpInMageRecoveryPointTypeCustom RpInMageRecoveryPointType = "Custom"
	// RpInMageRecoveryPointTypeLatestTag specifies the rp in mage recovery point type latest tag state for rp in mage
	// recovery point type.
	RpInMageRecoveryPointTypeLatestTag RpInMageRecoveryPointType = "LatestTag"
	// RpInMageRecoveryPointTypeLatestTime specifies the rp in mage recovery point type latest time state for rp in mage
	// recovery point type.
	RpInMageRecoveryPointTypeLatestTime RpInMageRecoveryPointType = "LatestTime"
)

// SetMultiVMSyncStatus enumerates the values for set multi vm sync status.
type SetMultiVMSyncStatus string

const (
	// Disable specifies the disable state for set multi vm sync status.
	Disable SetMultiVMSyncStatus = "Disable"
	// Enable specifies the enable state for set multi vm sync status.
	Enable SetMultiVMSyncStatus = "Enable"
)

// Severity enumerates the values for severity.
type Severity string

const (
	// Error specifies the error state for severity.
	Error Severity = "Error"
	// Info specifies the info state for severity.
	Info Severity = "Info"
	// NONE specifies the none state for severity.
	NONE Severity = "NONE"
	// Warning specifies the warning state for severity.
	Warning Severity = "Warning"
)

// SourceSiteOperations enumerates the values for source site operations.
type SourceSiteOperations string

const (
	// NotRequired specifies the not required state for source site operations.
	NotRequired SourceSiteOperations = "NotRequired"
	// Required specifies the required state for source site operations.
	Required SourceSiteOperations = "Required"
)

// A2AApplyRecoveryPointInput is applyRecoveryPoint input specific to A2A provider.
type A2AApplyRecoveryPointInput struct {
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	aarpi.InstanceType = InstanceTypeA2A
	type Alias A2AApplyRecoveryPointInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aarpi),
	})
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsA2AApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for A2AApplyRecoveryPointInput.
func (aarpi A2AApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return &aarpi, true
}

// A2AContainerCreationInput is a2A cloud creation input.
type A2AContainerCreationInput struct {
	InstanceType InstanceType `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) MarshalJSON() ([]byte, error) {
	acci.InstanceType = InstanceTypeA2A
	type Alias A2AContainerCreationInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(acci),
	})
}

// AsA2AContainerCreationInput is the ReplicationProviderSpecificContainerCreationInput implementation for A2AContainerCreationInput.
func (acci A2AContainerCreationInput) AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool) {
	return &acci, true
}

// A2AEnableProtectionInput is a2A enable protection input.
type A2AEnableProtectionInput struct {
	InstanceType              InstanceTypeEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
	FabricObjectID            *string                                           `json:"fabricObjectId,omitempty"`
	RecoveryContainerID       *string                                           `json:"recoveryContainerId,omitempty"`
	RecoveryResourceGroupID   *string                                           `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                                           `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                                           `json:"recoveryAvailabilitySetId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails                          `json:"vmDisks,omitempty"`
	VMManagedDisks            *[]A2AVMManagedDiskInputDetails                   `json:"vmManagedDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) MarshalJSON() ([]byte, error) {
	aepi.InstanceType = InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeA2A
	type Alias A2AEnableProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aepi),
	})
}

// AsHyperVReplicaAzureEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for A2AEnableProtectionInput.
func (aepi A2AEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return &aepi, true
}

// A2AEventDetails is model class for event details of a A2A event.
type A2AEventDetails struct {
	InstanceType         InstanceType `json:"instanceType,omitempty"`
	ProtectedItemName    *string      `json:"protectedItemName,omitempty"`
	FabricObjectID       *string      `json:"fabricObjectId,omitempty"`
	FabricName           *string      `json:"fabricName,omitempty"`
	FabricLocation       *string      `json:"fabricLocation,omitempty"`
	RemoteFabricName     *string      `json:"remoteFabricName,omitempty"`
	RemoteFabricLocation *string      `json:"remoteFabricLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AEventDetails.
func (aed A2AEventDetails) MarshalJSON() ([]byte, error) {
	aed.InstanceType = InstanceTypeA2A
	type Alias A2AEventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aed),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return &aed, true
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for A2AEventDetails.
func (aed A2AEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// A2AFailoverProviderInput is a2A provider specific input for failover.
type A2AFailoverProviderInput struct {
	InstanceType               InstanceTypeProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	RecoveryPointID            *string                                   `json:"recoveryPointId,omitempty"`
	CloudServiceCreationOption *string                                   `json:"cloudServiceCreationOption,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) MarshalJSON() ([]byte, error) {
	afpi.InstanceType = InstanceTypeProviderSpecificFailoverInputInstanceTypeA2A
	type Alias A2AFailoverProviderInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(afpi),
	})
}

// AsHyperVReplicaAzureFailoverProviderInput is the ProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the ProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the ProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the ProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the ProviderSpecificFailoverInput implementation for A2AFailoverProviderInput.
func (afpi A2AFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return &afpi, true
}

// A2APolicyCreationInput is a2A Policy creation input.
type A2APolicyCreationInput struct {
	InstanceType                      InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPointHistory              *int32                                  `json:"recoveryPointHistory,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                  `json:"crashConsistentFrequencyInMinutes,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 SetMultiVMSyncStatus                    `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) MarshalJSON() ([]byte, error) {
	apci.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeA2A
	type Alias A2APolicyCreationInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(apci),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return &apci, true
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for A2APolicyCreationInput.
func (apci A2APolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// A2APolicyDetails is a2A specific policy details.
type A2APolicyDetails struct {
	InstanceType                      InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes   *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 *string                                   `json:"multiVmSyncStatus,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                    `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// MarshalJSON is the custom marshaler for A2APolicyDetails.
func (apd A2APolicyDetails) MarshalJSON() ([]byte, error) {
	apd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeA2A
	type Alias A2APolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(apd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return &apd, true
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for A2APolicyDetails.
func (apd A2APolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// A2AProtectedDiskDetails is a2A protected disk details.
type A2AProtectedDiskDetails struct {
	DiskURI                                *string  `json:"diskUri,omitempty"`
	RecoveryAzureStorageAccountID          *string  `json:"recoveryAzureStorageAccountId,omitempty"`
	PrimaryDiskAzureStorageAccountID       *string  `json:"primaryDiskAzureStorageAccountId,omitempty"`
	RecoveryDiskURI                        *string  `json:"recoveryDiskUri,omitempty"`
	DiskName                               *string  `json:"diskName,omitempty"`
	DiskCapacityInBytes                    *int64   `json:"diskCapacityInBytes,omitempty"`
	PrimaryStagingAzureStorageAccountID    *string  `json:"primaryStagingAzureStorageAccountId,omitempty"`
	DiskType                               *string  `json:"diskType,omitempty"`
	ResyncRequired                         *bool    `json:"resyncRequired,omitempty"`
	MonitoringPercentageCompletion         *int32   `json:"monitoringPercentageCompletion,omitempty"`
	MonitoringJobType                      *string  `json:"monitoringJobType,omitempty"`
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	DataPendingAtSourceAgentInMB           *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
}

// A2AProtectedManagedDiskDetails is a2A protected managed disk details.
type A2AProtectedManagedDiskDetails struct {
	DiskID                                 *string  `json:"diskId,omitempty"`
	RecoveryAzureResourceGroupID           *string  `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryDiskID                         *string  `json:"recoveryDiskId,omitempty"`
	DiskName                               *string  `json:"diskName,omitempty"`
	DiskCapacityInBytes                    *int64   `json:"diskCapacityInBytes,omitempty"`
	PrimaryStagingAzureStorageAccountID    *string  `json:"primaryStagingAzureStorageAccountId,omitempty"`
	DiskType                               *string  `json:"diskType,omitempty"`
	ResyncRequired                         *bool    `json:"resyncRequired,omitempty"`
	MonitoringPercentageCompletion         *int32   `json:"monitoringPercentageCompletion,omitempty"`
	MonitoringJobType                      *string  `json:"monitoringJobType,omitempty"`
	DataPendingInStagingStorageAccountInMB *float64 `json:"dataPendingInStagingStorageAccountInMB,omitempty"`
	DataPendingAtSourceAgentInMB           *float64 `json:"dataPendingAtSourceAgentInMB,omitempty"`
}

// A2AReplicationDetails is a2A provider specific settings.
type A2AReplicationDetails struct {
	InstanceType                       InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	FabricObjectID                     *string                                         `json:"fabricObjectId,omitempty"`
	MultiVMGroupID                     *string                                         `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName                   *string                                         `json:"multiVmGroupName,omitempty"`
	ManagementID                       *string                                         `json:"managementId,omitempty"`
	ProtectedDisks                     *[]A2AProtectedDiskDetails                      `json:"protectedDisks,omitempty"`
	ProtectedManagedDisks              *[]A2AProtectedManagedDiskDetails               `json:"protectedManagedDisks,omitempty"`
	PrimaryFabricLocation              *string                                         `json:"primaryFabricLocation,omitempty"`
	RecoveryFabricLocation             *string                                         `json:"recoveryFabricLocation,omitempty"`
	OsType                             *string                                         `json:"osType,omitempty"`
	RecoveryAzureVMSize                *string                                         `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureVMName                *string                                         `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureResourceGroupID       *string                                         `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryCloudService               *string                                         `json:"recoveryCloudService,omitempty"`
	RecoveryAvailabilitySet            *string                                         `json:"recoveryAvailabilitySet,omitempty"`
	SelectedRecoveryAzureNetworkID     *string                                         `json:"selectedRecoveryAzureNetworkId,omitempty"`
	VMNics                             *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	VMSyncedConfigDetails              *AzureToAzureVMSyncedConfigDetails              `json:"vmSyncedConfigDetails,omitempty"`
	MonitoringPercentageCompletion     *int32                                          `json:"monitoringPercentageCompletion,omitempty"`
	MonitoringJobType                  *string                                         `json:"monitoringJobType,omitempty"`
	LastHeartbeat                      *date.Time                                      `json:"lastHeartbeat,omitempty"`
	AgentVersion                       *string                                         `json:"agentVersion,omitempty"`
	IsReplicationAgentUpdateRequired   *bool                                           `json:"isReplicationAgentUpdateRequired,omitempty"`
	RecoveryFabricObjectID             *string                                         `json:"recoveryFabricObjectId,omitempty"`
	VMProtectionState                  *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription       *string                                         `json:"vmProtectionStateDescription,omitempty"`
	LifecycleID                        *string                                         `json:"lifecycleId,omitempty"`
	TestFailoverRecoveryFabricObjectID *string                                         `json:"testFailoverRecoveryFabricObjectId,omitempty"`
	RpoInSeconds                       *int64                                          `json:"rpoInSeconds,omitempty"`
	LastRpoCalculatedTime              *date.Time                                      `json:"lastRpoCalculatedTime,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReplicationDetails.
func (ard A2AReplicationDetails) MarshalJSON() ([]byte, error) {
	ard.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeA2A
	type Alias A2AReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ard),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for A2AReplicationDetails.
func (ard A2AReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return &ard, true
}

// A2AReprotectInput is azure specific reprotect input.
type A2AReprotectInput struct {
	InstanceType              InstanceTypeReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryContainerID       *string                                             `json:"recoveryContainerId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails                            `json:"vmDisks,omitempty"`
	RecoveryResourceGroupID   *string                                             `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                                             `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                                             `json:"recoveryAvailabilitySetId,omitempty"`
	PolicyID                  *string                                             `json:"policyId,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AReprotectInput.
func (ari A2AReprotectInput) MarshalJSON() ([]byte, error) {
	ari.InstanceType = InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeA2A
	type Alias A2AReprotectInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ari),
	})
}

// AsHyperVReplicaAzureReprotectInput is the ReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the ReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the ReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the ReverseReplicationProviderSpecificInput implementation for A2AReprotectInput.
func (ari A2AReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return &ari, true
}

// A2ASwitchProtectionInput is a2A specific switch protection input.
type A2ASwitchProtectionInput struct {
	InstanceType              InstanceType                    `json:"instanceType,omitempty"`
	RecoveryContainerID       *string                         `json:"recoveryContainerId,omitempty"`
	VMDisks                   *[]A2AVMDiskInputDetails        `json:"vmDisks,omitempty"`
	VMManagedDisks            *[]A2AVMManagedDiskInputDetails `json:"vmManagedDisks,omitempty"`
	RecoveryResourceGroupID   *string                         `json:"recoveryResourceGroupId,omitempty"`
	RecoveryCloudServiceID    *string                         `json:"recoveryCloudServiceId,omitempty"`
	RecoveryAvailabilitySetID *string                         `json:"recoveryAvailabilitySetId,omitempty"`
	PolicyID                  *string                         `json:"policyId,omitempty"`
}

// MarshalJSON is the custom marshaler for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) MarshalJSON() ([]byte, error) {
	aspi.InstanceType = InstanceTypeA2A
	type Alias A2ASwitchProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aspi),
	})
}

// AsA2ASwitchProtectionInput is the SwitchProtectionProviderSpecificInput implementation for A2ASwitchProtectionInput.
func (aspi A2ASwitchProtectionInput) AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool) {
	return &aspi, true
}

// A2AUpdateReplicationProtectedItemInput is inMage Azure V2 input to update replication protected item.
type A2AUpdateReplicationProtectedItemInput struct {
	InstanceType            InstanceType `json:"instanceType,omitempty"`
	RecoveryCloudServiceID  *string      `json:"recoveryCloudServiceId,omitempty"`
	RecoveryResourceGroupID *string      `json:"recoveryResourceGroupId,omitempty"`
}

// MarshalJSON is the custom marshaler for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	aurpii.InstanceType = InstanceTypeA2A
	type Alias A2AUpdateReplicationProtectedItemInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aurpii),
	})
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsA2AUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for A2AUpdateReplicationProtectedItemInput.
func (aurpii A2AUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return &aurpii, true
}

// A2AVMDiskInputDetails is azure VM disk input details.
type A2AVMDiskInputDetails struct {
	DiskURI                             *string `json:"diskUri,omitempty"`
	RecoveryAzureStorageAccountID       *string `json:"recoveryAzureStorageAccountId,omitempty"`
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
}

// A2AVMManagedDiskInputDetails is azure VM managed disk input details.
type A2AVMManagedDiskInputDetails struct {
	DiskID                              *string `json:"diskId,omitempty"`
	PrimaryStagingAzureStorageAccountID *string `json:"primaryStagingAzureStorageAccountId,omitempty"`
	RecoveryResourceGroupID             *string `json:"recoveryResourceGroupId,omitempty"`
}

// AddVCenterRequest is input required to add vCenter.
type AddVCenterRequest struct {
	Properties *AddVCenterRequestProperties `json:"properties,omitempty"`
}

// AddVCenterRequestProperties is the properties of an add vCenter request.
type AddVCenterRequestProperties struct {
	FriendlyName    *string `json:"friendlyName,omitempty"`
	IPAddress       *string `json:"ipAddress,omitempty"`
	ProcessServerID *string `json:"processServerId,omitempty"`
	Port            *string `json:"port,omitempty"`
	RunAsAccountID  *string `json:"runAsAccountId,omitempty"`
}

// Alert is implements the Alert class.
type Alert struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Location          *string          `json:"location,omitempty"`
	Properties        *AlertProperties `json:"properties,omitempty"`
}

// AlertCollection is collection of alerts.
type AlertCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Alert `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// AlertCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AlertCollection) AlertCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AlertProperties is the proprties of an alert.
type AlertProperties struct {
	SendToOwners         *string   `json:"sendToOwners,omitempty"`
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	Locale               *string   `json:"locale,omitempty"`
}

// ApplyRecoveryPointInput is input to apply recovery point.
type ApplyRecoveryPointInput struct {
	Properties *ApplyRecoveryPointInputProperties `json:"properties,omitempty"`
}

// ApplyRecoveryPointInputProperties is input properties to apply recovery point.
type ApplyRecoveryPointInputProperties struct {
	RecoveryPointID         *string                                 `json:"recoveryPointId,omitempty"`
	ProviderSpecificDetails ApplyRecoveryPointProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ApplyRecoveryPointInputProperties struct.
func (arpip *ApplyRecoveryPointInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["recoveryPointId"]
	if v != nil {
		var recoveryPointID string
		err = json.Unmarshal(*m["recoveryPointId"], &recoveryPointID)
		if err != nil {
			return err
		}
		arpip.RecoveryPointID = &recoveryPointID
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalApplyRecoveryPointProviderSpecificInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		arpip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// ApplyRecoveryPointProviderSpecificInput is provider specific input for apply recovery point.
type ApplyRecoveryPointProviderSpecificInput interface {
	AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool)
	AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool)
	AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool)
}

func unmarshalApplyRecoveryPointProviderSpecificInput(body []byte) (ApplyRecoveryPointProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVReplicaAzure):
		var hvraarpi HyperVReplicaAzureApplyRecoveryPointInput
		err := json.Unmarshal(body, &hvraarpi)
		return hvraarpi, err
	case string(InstanceTypeInMageAzureV2):
		var imavarpi InMageAzureV2ApplyRecoveryPointInput
		err := json.Unmarshal(body, &imavarpi)
		return imavarpi, err
	case string(InstanceTypeA2A):
		var aarpi A2AApplyRecoveryPointInput
		err := json.Unmarshal(body, &aarpi)
		return aarpi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalApplyRecoveryPointProviderSpecificInputArray(body []byte) ([]ApplyRecoveryPointProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	arppsiArray := make([]ApplyRecoveryPointProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		arppsi, err := unmarshalApplyRecoveryPointProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		arppsiArray[index] = arppsi
	}
	return arppsiArray, nil
}

// ARMException is ARM inner exception class.
type ARMException struct {
	Code       *string                `json:"code,omitempty"`
	Message    *string                `json:"message,omitempty"`
	Target     *string                `json:"target,omitempty"`
	Details    *[]ARMExceptionDetails `json:"details,omitempty"`
	Innererror *ARMInnerError         `json:"innererror,omitempty"`
}

// ARMExceptionDetails is service based exception details.
type ARMExceptionDetails struct {
	Code              *string `json:"code,omitempty"`
	Message           *string `json:"message,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	ClientRequestID   *string `json:"clientRequestId,omitempty"`
	ActivityID        *string `json:"activityId,omitempty"`
	Target            *string `json:"target,omitempty"`
}

// ARMInnerError is ARM internal error class for providing additional debug data.
type ARMInnerError struct {
	Trace                   *string           `json:"trace,omitempty"`
	Source                  *string           `json:"source,omitempty"`
	MethodStatus            *MethodCallStatus `json:"methodStatus,omitempty"`
	CloudID                 *string           `json:"cloudId,omitempty"`
	HVHostID                *string           `json:"hVHostId,omitempty"`
	HVClusterID             *string           `json:"hVClusterId,omitempty"`
	NetworkID               *string           `json:"networkId,omitempty"`
	VMID                    *string           `json:"vmId,omitempty"`
	FabricID                *string           `json:"fabricId,omitempty"`
	LiveID                  *string           `json:"liveId,omitempty"`
	ContainerID             *string           `json:"containerId,omitempty"`
	ResourceID              *string           `json:"resourceId,omitempty"`
	ResourceName            *string           `json:"resourceName,omitempty"`
	SubscriptionID          *string           `json:"subscriptionId,omitempty"`
	SerializedSRSLogContext *string           `json:"serializedSRSLogContext,omitempty"`
}

// AsrJobDetails is this class represents job details based on specific job type.
type AsrJobDetails struct {
	AffectedObjectDetails *map[string]*string    `json:"affectedObjectDetails,omitempty"`
	InstanceType          InstanceTypeJobDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AsrJobDetails.
func (ajd AsrJobDetails) MarshalJSON() ([]byte, error) {
	ajd.InstanceType = InstanceTypeAsrJobDetails
	type Alias AsrJobDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ajd),
	})
}

// AsAsrJobDetails is the JobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return &ajd, true
}

// AsTestFailoverJobDetails is the JobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the JobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the JobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the JobDetails implementation for AsrJobDetails.
func (ajd AsrJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// ASRTask is task of the Job.
type ASRTask struct {
	TaskID                 *string            `json:"taskId,omitempty"`
	Name                   *string            `json:"name,omitempty"`
	StartTime              *date.Time         `json:"startTime,omitempty"`
	EndTime                *date.Time         `json:"endTime,omitempty"`
	AllowedActions         *[]string          `json:"allowedActions,omitempty"`
	FriendlyName           *string            `json:"friendlyName,omitempty"`
	State                  *string            `json:"state,omitempty"`
	StateDescription       *string            `json:"stateDescription,omitempty"`
	TaskType               *string            `json:"taskType,omitempty"`
	CustomDetails          TaskTypeDetails    `json:"customDetails,omitempty"`
	GroupTaskCustomDetails GroupTaskDetails   `json:"groupTaskCustomDetails,omitempty"`
	Errors                 *[]JobErrorDetails `json:"errors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ASRTask struct.
func (at *ASRTask) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["taskId"]
	if v != nil {
		var taskID string
		err = json.Unmarshal(*m["taskId"], &taskID)
		if err != nil {
			return err
		}
		at.TaskID = &taskID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		at.Name = &name
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		at.StartTime = &startTime
	}

	v = m["endTime"]
	if v != nil {
		var endTime date.Time
		err = json.Unmarshal(*m["endTime"], &endTime)
		if err != nil {
			return err
		}
		at.EndTime = &endTime
	}

	v = m["allowedActions"]
	if v != nil {
		var allowedActions []string
		err = json.Unmarshal(*m["allowedActions"], &allowedActions)
		if err != nil {
			return err
		}
		at.AllowedActions = &allowedActions
	}

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		at.FriendlyName = &friendlyName
	}

	v = m["state"]
	if v != nil {
		var state string
		err = json.Unmarshal(*m["state"], &state)
		if err != nil {
			return err
		}
		at.State = &state
	}

	v = m["stateDescription"]
	if v != nil {
		var stateDescription string
		err = json.Unmarshal(*m["stateDescription"], &stateDescription)
		if err != nil {
			return err
		}
		at.StateDescription = &stateDescription
	}

	v = m["taskType"]
	if v != nil {
		var taskType string
		err = json.Unmarshal(*m["taskType"], &taskType)
		if err != nil {
			return err
		}
		at.TaskType = &taskType
	}

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalTaskTypeDetails(*m["customDetails"])
		if err != nil {
			return err
		}
		at.CustomDetails = customDetails
	}

	v = m["groupTaskCustomDetails"]
	if v != nil {
		groupTaskCustomDetails, err := unmarshalGroupTaskDetails(*m["groupTaskCustomDetails"])
		if err != nil {
			return err
		}
		at.GroupTaskCustomDetails = groupTaskCustomDetails
	}

	v = m["errors"]
	if v != nil {
		var errorsVar []JobErrorDetails
		err = json.Unmarshal(*m["errors"], &errorsVar)
		if err != nil {
			return err
		}
		at.Errors = &errorsVar
	}

	return nil
}

// AutomationRunbookTaskDetails is this class represents the task details for an automation runbook.
type AutomationRunbookTaskDetails struct {
	InstanceType        InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	Name                *string                     `json:"name,omitempty"`
	CloudServiceName    *string                     `json:"cloudServiceName,omitempty"`
	SubscriptionID      *string                     `json:"subscriptionId,omitempty"`
	AccountName         *string                     `json:"accountName,omitempty"`
	RunbookID           *string                     `json:"runbookId,omitempty"`
	RunbookName         *string                     `json:"runbookName,omitempty"`
	JobID               *string                     `json:"jobId,omitempty"`
	JobOutput           *string                     `json:"jobOutput,omitempty"`
	IsPrimarySideScript *bool                       `json:"isPrimarySideScript,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) MarshalJSON() ([]byte, error) {
	artd.InstanceType = InstanceTypeAutomationRunbookTaskDetails
	type Alias AutomationRunbookTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(artd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for AutomationRunbookTaskDetails.
func (artd AutomationRunbookTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return &artd, true
}

// AzureFabricCreationInput is fabric provider specific settings.
type AzureFabricCreationInput struct {
	InstanceType InstanceTypeFabricSpecificCreationInput `json:"instanceType,omitempty"`
	Location     *string                                 `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) MarshalJSON() ([]byte, error) {
	afci.InstanceType = InstanceTypeFabricSpecificCreationInputInstanceTypeA2A
	type Alias AzureFabricCreationInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(afci),
	})
}

// AsAzureFabricCreationInput is the FabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return &afci, true
}

// AsVMwareV2FabricCreationInput is the FabricSpecificCreationInput implementation for AzureFabricCreationInput.
func (afci AzureFabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return nil, false
}

// AzureFabricSpecificDetails is azure Fabric Specific Details.
type AzureFabricSpecificDetails struct {
	InstanceType InstanceTypeFabricSpecificDetails `json:"instanceType,omitempty"`
	Location     *string                           `json:"location,omitempty"`
	ContainerIds *[]string                         `json:"containerIds,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) MarshalJSON() ([]byte, error) {
	afsd.InstanceType = InstanceTypeAzure
	type Alias AzureFabricSpecificDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(afsd),
	})
}

// AsAzureFabricSpecificDetails is the FabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return &afsd, true
}

// AsVmmDetails is the FabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the FabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the FabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the FabricSpecificDetails implementation for AzureFabricSpecificDetails.
func (afsd AzureFabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// AzureToAzureCreateNetworkMappingInput is create network mappings input properties/behaviour specific to Azure to
// Azure Network mapping.
type AzureToAzureCreateNetworkMappingInput struct {
	InstanceType     InstanceTypeFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
	PrimaryNetworkID *string                                             `json:"primaryNetworkId,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	atacnmi.InstanceType = InstanceTypeAzureToAzure
	type Alias AzureToAzureCreateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(atacnmi),
	})
}

// AsAzureToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return &atacnmi, true
}

// AsVmmToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for AzureToAzureCreateNetworkMappingInput.
func (atacnmi AzureToAzureCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// AzureToAzureNetworkMappingSettings is a2A Network Mapping fabric specific settings.
type AzureToAzureNetworkMappingSettings struct {
	InstanceType           InstanceTypeNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
	PrimaryFabricLocation  *string                                          `json:"primaryFabricLocation,omitempty"`
	RecoveryFabricLocation *string                                          `json:"recoveryFabricLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	atanms.InstanceType = InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure
	type Alias AzureToAzureNetworkMappingSettings
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(atanms),
	})
}

// AsAzureToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return &atanms, true
}

// AsVmmToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for AzureToAzureNetworkMappingSettings.
func (atanms AzureToAzureNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// AzureToAzureUpdateNetworkMappingInput is updates network mappings input.
type AzureToAzureUpdateNetworkMappingInput struct {
	InstanceType     InstanceTypeFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
	PrimaryNetworkID *string                                             `json:"primaryNetworkId,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	ataunmi.InstanceType = InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure
	type Alias AzureToAzureUpdateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ataunmi),
	})
}

// AsAzureToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return &ataunmi, true
}

// AsVmmToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for AzureToAzureUpdateNetworkMappingInput.
func (ataunmi AzureToAzureUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AzureToAzureVMSyncedConfigDetails is azure to Azure VM synced configuration details.
type AzureToAzureVMSyncedConfigDetails struct {
	Tags            *map[string]*string `json:"tags,omitempty"`
	RoleAssignments *[]RoleAssignment   `json:"roleAssignments,omitempty"`
	InputEndpoints  *[]InputEndpoint    `json:"inputEndpoints,omitempty"`
}

// AzureVMDiskDetails is disk details for E2A provider.
type AzureVMDiskDetails struct {
	VhdType            *string `json:"vhdType,omitempty"`
	VhdID              *string `json:"vhdId,omitempty"`
	VhdName            *string `json:"vhdName,omitempty"`
	MaxSizeMB          *string `json:"maxSizeMB,omitempty"`
	TargetDiskLocation *string `json:"targetDiskLocation,omitempty"`
	TargetDiskName     *string `json:"targetDiskName,omitempty"`
	LunID              *string `json:"lunId,omitempty"`
}

// ConfigurationSettings is replication provider specific settings.
type ConfigurationSettings interface {
	AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool)
	AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool)
	AsReplicationGroupDetails() (*ReplicationGroupDetails, bool)
}

func unmarshalConfigurationSettings(body []byte) (ConfigurationSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVVirtualMachine):
		var hvvmd HyperVVirtualMachineDetails
		err := json.Unmarshal(body, &hvvmd)
		return hvvmd, err
	case string(InstanceTypeVMwareVirtualMachine):
		var vmvmd VMwareVirtualMachineDetails
		err := json.Unmarshal(body, &vmvmd)
		return vmvmd, err
	case string(InstanceTypeReplicationGroupDetails):
		var rgd ReplicationGroupDetails
		err := json.Unmarshal(body, &rgd)
		return rgd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalConfigurationSettingsArray(body []byte) ([]ConfigurationSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]ConfigurationSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalConfigurationSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// ConfigureAlertRequest is request to configure alerts for the system.
type ConfigureAlertRequest struct {
	Properties *ConfigureAlertRequestProperties `json:"properties,omitempty"`
}

// ConfigureAlertRequestProperties is properties of a configure alert request.
type ConfigureAlertRequestProperties struct {
	SendToOwners         *string   `json:"sendToOwners,omitempty"`
	CustomEmailAddresses *[]string `json:"customEmailAddresses,omitempty"`
	Locale               *string   `json:"locale,omitempty"`
}

// ConsistencyCheckTaskDetails is this class contains monitoring details of all the inconsistent Protected Entites in
// Vmm.
type ConsistencyCheckTaskDetails struct {
	InstanceType InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	VMDetails    *[]InconsistentVMDetails    `json:"vmDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) MarshalJSON() ([]byte, error) {
	cctd.InstanceType = InstanceTypeConsistencyCheckTaskDetails
	type Alias ConsistencyCheckTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cctd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return &cctd, true
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for ConsistencyCheckTaskDetails.
func (cctd ConsistencyCheckTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// CreateNetworkMappingInput is create network mappings input.
type CreateNetworkMappingInput struct {
	Properties *CreateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// CreateNetworkMappingInputProperties is common input details for network mapping operation.
type CreateNetworkMappingInputProperties struct {
	RecoveryFabricName    *string                                 `json:"recoveryFabricName,omitempty"`
	RecoveryNetworkID     *string                                 `json:"recoveryNetworkId,omitempty"`
	FabricSpecificDetails FabricSpecificCreateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateNetworkMappingInputProperties struct.
func (cnmip *CreateNetworkMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["recoveryFabricName"]
	if v != nil {
		var recoveryFabricName string
		err = json.Unmarshal(*m["recoveryFabricName"], &recoveryFabricName)
		if err != nil {
			return err
		}
		cnmip.RecoveryFabricName = &recoveryFabricName
	}

	v = m["recoveryNetworkId"]
	if v != nil {
		var recoveryNetworkID string
		err = json.Unmarshal(*m["recoveryNetworkId"], &recoveryNetworkID)
		if err != nil {
			return err
		}
		cnmip.RecoveryNetworkID = &recoveryNetworkID
	}

	v = m["fabricSpecificDetails"]
	if v != nil {
		fabricSpecificDetails, err := unmarshalFabricSpecificCreateNetworkMappingInput(*m["fabricSpecificDetails"])
		if err != nil {
			return err
		}
		cnmip.FabricSpecificDetails = fabricSpecificDetails
	}

	return nil
}

// CreatePolicyInput is protection profile input.
type CreatePolicyInput struct {
	Properties *CreatePolicyInputProperties `json:"properties,omitempty"`
}

// CreatePolicyInputProperties is policy creation properties.
type CreatePolicyInputProperties struct {
	ProviderSpecificInput PolicyProviderSpecificInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreatePolicyInputProperties struct.
func (cpip *CreatePolicyInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["providerSpecificInput"]
	if v != nil {
		providerSpecificInput, err := unmarshalPolicyProviderSpecificInput(*m["providerSpecificInput"])
		if err != nil {
			return err
		}
		cpip.ProviderSpecificInput = providerSpecificInput
	}

	return nil
}

// CreateProtectionContainerInput is create protection container input.
type CreateProtectionContainerInput struct {
	Properties *CreateProtectionContainerInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerInputProperties is create protection container input properties.
type CreateProtectionContainerInputProperties struct {
	ProviderSpecificInput *[]ReplicationProviderSpecificContainerCreationInput `json:"providerSpecificInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CreateProtectionContainerInputProperties struct.
func (cpcip *CreateProtectionContainerInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["providerSpecificInput"]
	if v != nil {
		providerSpecificInput, err := unmarshalReplicationProviderSpecificContainerCreationInputArray(*m["providerSpecificInput"])
		if err != nil {
			return err
		}
		cpcip.ProviderSpecificInput = &providerSpecificInput
	}

	return nil
}

// CreateProtectionContainerMappingInput is configure pairing input.
type CreateProtectionContainerMappingInput struct {
	Properties *CreateProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// CreateProtectionContainerMappingInputProperties is configure pairing input properties.
type CreateProtectionContainerMappingInputProperties struct {
	TargetProtectionContainerID *string                                           `json:"targetProtectionContainerId,omitempty"`
	PolicyID                    *string                                           `json:"PolicyId,omitempty"`
	ProviderSpecificInput       *ReplicationProviderSpecificContainerMappingInput `json:"providerSpecificInput,omitempty"`
}

// CreateRecoveryPlanInput is create recovery plan input class.
type CreateRecoveryPlanInput struct {
	Properties *CreateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// CreateRecoveryPlanInputProperties is recovery plan creation properties.
type CreateRecoveryPlanInputProperties struct {
	PrimaryFabricID         *string                 `json:"primaryFabricId,omitempty"`
	RecoveryFabricID        *string                 `json:"recoveryFabricId,omitempty"`
	FailoverDeploymentModel FailoverDeploymentModel `json:"failoverDeploymentModel,omitempty"`
	Groups                  *[]RecoveryPlanGroup    `json:"groups,omitempty"`
}

// CurrentScenarioDetails is current scenario details of the protected entity.
type CurrentScenarioDetails struct {
	ScenarioName *string    `json:"scenarioName,omitempty"`
	JobID        *string    `json:"jobId,omitempty"`
	StartTime    *date.Time `json:"startTime,omitempty"`
}

// DataStore is the datastore details of the MT.
type DataStore struct {
	SymbolicName *string `json:"symbolicName,omitempty"`
	UUID         *string `json:"uuid,omitempty"`
	Capacity     *string `json:"capacity,omitempty"`
	FreeSpace    *string `json:"freeSpace,omitempty"`
	Type         *string `json:"type,omitempty"`
}

// DisableProtectionInput is disable protection input.
type DisableProtectionInput struct {
	Properties *DisableProtectionInputProperties `json:"properties,omitempty"`
}

// DisableProtectionInputProperties is disable protection input properties.
type DisableProtectionInputProperties struct {
	DisableProtectionReason  DisableProtectionReason                `json:"disableProtectionReason,omitempty"`
	ReplicationProviderInput DisableProtectionProviderSpecificInput `json:"replicationProviderInput,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DisableProtectionInputProperties struct.
func (dpip *DisableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["disableProtectionReason"]
	if v != nil {
		var disableProtectionReason DisableProtectionReason
		err = json.Unmarshal(*m["disableProtectionReason"], &disableProtectionReason)
		if err != nil {
			return err
		}
		dpip.DisableProtectionReason = disableProtectionReason
	}

	v = m["replicationProviderInput"]
	if v != nil {
		replicationProviderInput, err := unmarshalDisableProtectionProviderSpecificInput(*m["replicationProviderInput"])
		if err != nil {
			return err
		}
		dpip.ReplicationProviderInput = replicationProviderInput
	}

	return nil
}

// DisableProtectionProviderSpecificInput is disable protection provider specific input.
type DisableProtectionProviderSpecificInput interface {
	AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool)
}

func unmarshalDisableProtectionProviderSpecificInput(body []byte) (DisableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInMage):
		var imdppsi InMageDisableProtectionProviderSpecificInput
		err := json.Unmarshal(body, &imdppsi)
		return imdppsi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalDisableProtectionProviderSpecificInputArray(body []byte) ([]DisableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dppsiArray := make([]DisableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dppsi, err := unmarshalDisableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		dppsiArray[index] = dppsi
	}
	return dppsiArray, nil
}

// DiscoverProtectableItemRequest is request to add a physical machine as a protectable item in a container.
type DiscoverProtectableItemRequest struct {
	Properties *DiscoverProtectableItemRequestProperties `json:"properties,omitempty"`
}

// DiscoverProtectableItemRequestProperties is discover protectable item properties.
type DiscoverProtectableItemRequestProperties struct {
	FriendlyName *string `json:"friendlyName,omitempty"`
	IPAddress    *string `json:"ipAddress,omitempty"`
	OsType       *string `json:"osType,omitempty"`
}

// DiskDetails is onprem disk details data.
type DiskDetails struct {
	MaxSizeMB *int64  `json:"maxSizeMB,omitempty"`
	VhdType   *string `json:"vhdType,omitempty"`
	VhdID     *string `json:"vhdId,omitempty"`
	VhdName   *string `json:"vhdName,omitempty"`
}

// DiskVolumeDetails is volume details.
type DiskVolumeDetails struct {
	Label *string `json:"label,omitempty"`
	Name  *string `json:"name,omitempty"`
}

// Display is contains the localized display information for this particular operation / action. These value will be
// used by several clients for (1) custom role definitions for RBAC; (2) complex query filters for the event service;
// and (3) audit history / records for management operations.
type Display struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// EnableProtectionInput is enable protection input.
type EnableProtectionInput struct {
	Properties *EnableProtectionInputProperties `json:"properties,omitempty"`
}

// EnableProtectionInputProperties is enable protection input properties.
type EnableProtectionInputProperties struct {
	PolicyID                *string                               `json:"policyId,omitempty"`
	ProtectableItemID       *string                               `json:"protectableItemId,omitempty"`
	ProviderSpecificDetails EnableProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EnableProtectionInputProperties struct.
func (epip *EnableProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["policyId"]
	if v != nil {
		var policyID string
		err = json.Unmarshal(*m["policyId"], &policyID)
		if err != nil {
			return err
		}
		epip.PolicyID = &policyID
	}

	v = m["protectableItemId"]
	if v != nil {
		var protectableItemID string
		err = json.Unmarshal(*m["protectableItemId"], &protectableItemID)
		if err != nil {
			return err
		}
		epip.ProtectableItemID = &protectableItemID
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalEnableProtectionProviderSpecificInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		epip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// EnableProtectionProviderSpecificInput is enable protection provider specific input.
type EnableProtectionProviderSpecificInput interface {
	AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool)
	AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool)
	AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool)
	AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool)
	AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool)
}

func unmarshalEnableProtectionProviderSpecificInput(body []byte) (EnableProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvraepi HyperVReplicaAzureEnableProtectionInput
		err := json.Unmarshal(body, &hvraepi)
		return hvraepi, err
	case string(InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeSan):
		var sepi SanEnableProtectionInput
		err := json.Unmarshal(body, &sepi)
		return sepi, err
	case string(InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavepi InMageAzureV2EnableProtectionInput
		err := json.Unmarshal(body, &imavepi)
		return imavepi, err
	case string(InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMage):
		var imepi InMageEnableProtectionInput
		err := json.Unmarshal(body, &imepi)
		return imepi, err
	case string(InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeA2A):
		var aepi A2AEnableProtectionInput
		err := json.Unmarshal(body, &aepi)
		return aepi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalEnableProtectionProviderSpecificInputArray(body []byte) ([]EnableProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	eppsiArray := make([]EnableProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eppsi, err := unmarshalEnableProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		eppsiArray[index] = eppsi
	}
	return eppsiArray, nil
}

// EncryptionDetails is encryption details for the fabric.
type EncryptionDetails struct {
	KekState          *string    `json:"kekState,omitempty"`
	KekCertThumbprint *string    `json:"kekCertThumbprint,omitempty"`
	KekCertExpiryDate *date.Time `json:"kekCertExpiryDate,omitempty"`
}

// Event is implements the Event class.
type Event struct {
	autorest.Response `json:"-"`
	ID                *string          `json:"id,omitempty"`
	Name              *string          `json:"name,omitempty"`
	Type              *string          `json:"type,omitempty"`
	Location          *string          `json:"location,omitempty"`
	Properties        *EventProperties `json:"properties,omitempty"`
}

// EventCollection is collection of fabric details.
type EventCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Event `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// EventCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EventCollection) EventCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EventProperties is the properties of a monitoring event.
type EventProperties struct {
	EventCode                  *string                      `json:"eventCode,omitempty"`
	Description                *string                      `json:"description,omitempty"`
	EventType                  *string                      `json:"eventType,omitempty"`
	AffectedObjectFriendlyName *string                      `json:"affectedObjectFriendlyName,omitempty"`
	Severity                   *string                      `json:"severity,omitempty"`
	TimeOfOccurrence           *date.Time                   `json:"timeOfOccurrence,omitempty"`
	FabricID                   *string                      `json:"fabricId,omitempty"`
	ProviderSpecificDetails    EventProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	EventSpecificDetails       EventSpecificDetails         `json:"eventSpecificDetails,omitempty"`
	HealthErrors               *[]HealthError               `json:"healthErrors,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventProperties struct.
func (ep *EventProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["eventCode"]
	if v != nil {
		var eventCode string
		err = json.Unmarshal(*m["eventCode"], &eventCode)
		if err != nil {
			return err
		}
		ep.EventCode = &eventCode
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ep.Description = &description
	}

	v = m["eventType"]
	if v != nil {
		var eventType string
		err = json.Unmarshal(*m["eventType"], &eventType)
		if err != nil {
			return err
		}
		ep.EventType = &eventType
	}

	v = m["affectedObjectFriendlyName"]
	if v != nil {
		var affectedObjectFriendlyName string
		err = json.Unmarshal(*m["affectedObjectFriendlyName"], &affectedObjectFriendlyName)
		if err != nil {
			return err
		}
		ep.AffectedObjectFriendlyName = &affectedObjectFriendlyName
	}

	v = m["severity"]
	if v != nil {
		var severity string
		err = json.Unmarshal(*m["severity"], &severity)
		if err != nil {
			return err
		}
		ep.Severity = &severity
	}

	v = m["timeOfOccurrence"]
	if v != nil {
		var timeOfOccurrence date.Time
		err = json.Unmarshal(*m["timeOfOccurrence"], &timeOfOccurrence)
		if err != nil {
			return err
		}
		ep.TimeOfOccurrence = &timeOfOccurrence
	}

	v = m["fabricId"]
	if v != nil {
		var fabricID string
		err = json.Unmarshal(*m["fabricId"], &fabricID)
		if err != nil {
			return err
		}
		ep.FabricID = &fabricID
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalEventProviderSpecificDetails(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		ep.ProviderSpecificDetails = providerSpecificDetails
	}

	v = m["eventSpecificDetails"]
	if v != nil {
		eventSpecificDetails, err := unmarshalEventSpecificDetails(*m["eventSpecificDetails"])
		if err != nil {
			return err
		}
		ep.EventSpecificDetails = eventSpecificDetails
	}

	v = m["healthErrors"]
	if v != nil {
		var healthErrors []HealthError
		err = json.Unmarshal(*m["healthErrors"], &healthErrors)
		if err != nil {
			return err
		}
		ep.HealthErrors = &healthErrors
	}

	return nil
}

// EventProviderSpecificDetails is model class for provider specific details for an event.
type EventProviderSpecificDetails interface {
	AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool)
	AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool)
	AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool)
	AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool)
	AsA2AEventDetails() (*A2AEventDetails, bool)
	AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool)
}

func unmarshalEventProviderSpecificDetails(body []byte) (EventProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVReplicaBaseEventDetails):
		var hvrbed HyperVReplicaBaseEventDetails
		err := json.Unmarshal(body, &hvrbed)
		return hvrbed, err
	case string(InstanceTypeHyperVReplica2012):
		var hvr2ed HyperVReplica2012EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeHyperVReplica2012R2):
		var hvr2ed HyperVReplica2012R2EventDetails
		err := json.Unmarshal(body, &hvr2ed)
		return hvr2ed, err
	case string(InstanceTypeHyperVReplicaAzure):
		var hvraed HyperVReplicaAzureEventDetails
		err := json.Unmarshal(body, &hvraed)
		return hvraed, err
	case string(InstanceTypeA2A):
		var aed A2AEventDetails
		err := json.Unmarshal(body, &aed)
		return aed, err
	case string(InstanceTypeInMageAzureV2):
		var imaved InMageAzureV2EventDetails
		err := json.Unmarshal(body, &imaved)
		return imaved, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalEventProviderSpecificDetailsArray(body []byte) ([]EventProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	epsdArray := make([]EventProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		epsd, err := unmarshalEventProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		epsdArray[index] = epsd
	}
	return epsdArray, nil
}

// EventQueryParameter is implements the event query parameter.
type EventQueryParameter struct {
	EventCode                  *string    `json:"EventCode,omitempty"`
	Severity                   *string    `json:"Severity,omitempty"`
	EventType                  *string    `json:"EventType,omitempty"`
	FabricName                 *string    `json:"FabricName,omitempty"`
	AffectedObjectFriendlyName *string    `json:"AffectedObjectFriendlyName,omitempty"`
	StartTime                  *date.Time `json:"StartTime,omitempty"`
	EndTime                    *date.Time `json:"EndTime,omitempty"`
}

// EventSpecificDetails is model class for event specific details for an event.
type EventSpecificDetails interface {
	AsJobStatusEventDetails() (*JobStatusEventDetails, bool)
}

func unmarshalEventSpecificDetails(body []byte) (EventSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeJobStatus):
		var jsed JobStatusEventDetails
		err := json.Unmarshal(body, &jsed)
		return jsed, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalEventSpecificDetailsArray(body []byte) ([]EventSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]EventSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalEventSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// ExportJobDetails is this class represents details for export jobs workflow.
type ExportJobDetails struct {
	AffectedObjectDetails *map[string]*string    `json:"affectedObjectDetails,omitempty"`
	InstanceType          InstanceTypeJobDetails `json:"instanceType,omitempty"`
	BlobURI               *string                `json:"blobUri,omitempty"`
	SasToken              *string                `json:"sasToken,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportJobDetails.
func (ejd ExportJobDetails) MarshalJSON() ([]byte, error) {
	ejd.InstanceType = InstanceTypeExportJobDetails
	type Alias ExportJobDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ejd),
	})
}

// AsAsrJobDetails is the JobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the JobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the JobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the JobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return &ejd, true
}

// AsSwitchProtectionJobDetails is the JobDetails implementation for ExportJobDetails.
func (ejd ExportJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// Fabric is fabric definition.
type Fabric struct {
	autorest.Response `json:"-"`
	ID                *string           `json:"id,omitempty"`
	Name              *string           `json:"name,omitempty"`
	Type              *string           `json:"type,omitempty"`
	Location          *string           `json:"location,omitempty"`
	Properties        *FabricProperties `json:"properties,omitempty"`
}

// FabricCollection is collection of fabric details.
type FabricCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Fabric `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// FabricCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FabricCollection) FabricCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FabricCreationInput is site details provided during the time of site creation
type FabricCreationInput struct {
	Properties *FabricCreationInputProperties `json:"properties,omitempty"`
}

// FabricCreationInputProperties is properties of site details provided during the time of site creation
type FabricCreationInputProperties struct {
	CustomDetails FabricSpecificCreationInput `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricCreationInputProperties struct.
func (fcip *FabricCreationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalFabricSpecificCreationInput(*m["customDetails"])
		if err != nil {
			return err
		}
		fcip.CustomDetails = customDetails
	}

	return nil
}

// FabricProperties is fabric properties.
type FabricProperties struct {
	FriendlyName              *string               `json:"friendlyName,omitempty"`
	EncryptionDetails         *EncryptionDetails    `json:"encryptionDetails,omitempty"`
	RolloverEncryptionDetails *EncryptionDetails    `json:"rolloverEncryptionDetails,omitempty"`
	InternalIdentifier        *string               `json:"internalIdentifier,omitempty"`
	BcdrState                 *string               `json:"bcdrState,omitempty"`
	CustomDetails             FabricSpecificDetails `json:"customDetails,omitempty"`
	HealthErrorDetails        *[]HealthError        `json:"healthErrorDetails,omitempty"`
	Health                    *string               `json:"health,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for FabricProperties struct.
func (fp *FabricProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		fp.FriendlyName = &friendlyName
	}

	v = m["encryptionDetails"]
	if v != nil {
		var encryptionDetails EncryptionDetails
		err = json.Unmarshal(*m["encryptionDetails"], &encryptionDetails)
		if err != nil {
			return err
		}
		fp.EncryptionDetails = &encryptionDetails
	}

	v = m["rolloverEncryptionDetails"]
	if v != nil {
		var rolloverEncryptionDetails EncryptionDetails
		err = json.Unmarshal(*m["rolloverEncryptionDetails"], &rolloverEncryptionDetails)
		if err != nil {
			return err
		}
		fp.RolloverEncryptionDetails = &rolloverEncryptionDetails
	}

	v = m["internalIdentifier"]
	if v != nil {
		var internalIdentifier string
		err = json.Unmarshal(*m["internalIdentifier"], &internalIdentifier)
		if err != nil {
			return err
		}
		fp.InternalIdentifier = &internalIdentifier
	}

	v = m["bcdrState"]
	if v != nil {
		var bcdrState string
		err = json.Unmarshal(*m["bcdrState"], &bcdrState)
		if err != nil {
			return err
		}
		fp.BcdrState = &bcdrState
	}

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalFabricSpecificDetails(*m["customDetails"])
		if err != nil {
			return err
		}
		fp.CustomDetails = customDetails
	}

	v = m["healthErrorDetails"]
	if v != nil {
		var healthErrorDetails []HealthError
		err = json.Unmarshal(*m["healthErrorDetails"], &healthErrorDetails)
		if err != nil {
			return err
		}
		fp.HealthErrorDetails = &healthErrorDetails
	}

	v = m["health"]
	if v != nil {
		var health string
		err = json.Unmarshal(*m["health"], &health)
		if err != nil {
			return err
		}
		fp.Health = &health
	}

	return nil
}

// FabricReplicationGroupTaskDetails is this class represents the fabric replication group task details.
type FabricReplicationGroupTaskDetails struct {
	InstanceType        InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	SkippedReason       *string                     `json:"skippedReason,omitempty"`
	SkippedReasonString *string                     `json:"skippedReasonString,omitempty"`
	JobTask             *JobEntity                  `json:"jobTask,omitempty"`
}

// MarshalJSON is the custom marshaler for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) MarshalJSON() ([]byte, error) {
	frgtd.InstanceType = InstanceTypeFabricReplicationGroupTaskDetails
	type Alias FabricReplicationGroupTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(frgtd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return &frgtd, true
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for FabricReplicationGroupTaskDetails.
func (frgtd FabricReplicationGroupTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// FabricSpecificCreateNetworkMappingInput is input details specific to fabrics during Network Mapping.
type FabricSpecificCreateNetworkMappingInput interface {
	AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool)
	AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool)
	AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool)
}

func unmarshalFabricSpecificCreateNetworkMappingInput(body []byte) (FabricSpecificCreateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzureToAzure):
		var atacnmi AzureToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &atacnmi)
		return atacnmi, err
	case string(InstanceTypeVmmToAzure):
		var vtacnmi VmmToAzureCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtacnmi)
		return vtacnmi, err
	case string(InstanceTypeVmmToVmm):
		var vtvcnmi VmmToVmmCreateNetworkMappingInput
		err := json.Unmarshal(body, &vtvcnmi)
		return vtvcnmi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFabricSpecificCreateNetworkMappingInputArray(body []byte) ([]FabricSpecificCreateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fscnmiArray := make([]FabricSpecificCreateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fscnmi, err := unmarshalFabricSpecificCreateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fscnmiArray[index] = fscnmi
	}
	return fscnmiArray, nil
}

// FabricSpecificCreationInput is fabric provider specific settings.
type FabricSpecificCreationInput interface {
	AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool)
	AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool)
}

func unmarshalFabricSpecificCreationInput(body []byte) (FabricSpecificCreationInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeFabricSpecificCreationInputInstanceTypeA2A):
		var afci AzureFabricCreationInput
		err := json.Unmarshal(body, &afci)
		return afci, err
	case string(InstanceTypeFabricSpecificCreationInputInstanceTypeVMwareV2):
		var vmvfci VMwareV2FabricCreationInput
		err := json.Unmarshal(body, &vmvfci)
		return vmvfci, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFabricSpecificCreationInputArray(body []byte) ([]FabricSpecificCreationInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsciArray := make([]FabricSpecificCreationInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsci, err := unmarshalFabricSpecificCreationInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsciArray[index] = fsci
	}
	return fsciArray, nil
}

// FabricSpecificDetails is fabric specific details.
type FabricSpecificDetails interface {
	AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool)
	AsVmmDetails() (*VmmDetails, bool)
	AsHyperVSiteDetails() (*HyperVSiteDetails, bool)
	AsVMwareDetails() (*VMwareDetails, bool)
	AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool)
}

func unmarshalFabricSpecificDetails(body []byte) (FabricSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAzure):
		var afsd AzureFabricSpecificDetails
		err := json.Unmarshal(body, &afsd)
		return afsd, err
	case string(InstanceTypeVMM):
		var vd VmmDetails
		err := json.Unmarshal(body, &vd)
		return vd, err
	case string(InstanceTypeHyperVSite):
		var hvsd HyperVSiteDetails
		err := json.Unmarshal(body, &hvsd)
		return hvsd, err
	case string(InstanceTypeVMware):
		var vmd VMwareDetails
		err := json.Unmarshal(body, &vmd)
		return vmd, err
	case string(InstanceTypeVMwareV2):
		var vmvfsd VMwareV2FabricSpecificDetails
		err := json.Unmarshal(body, &vmvfsd)
		return vmvfsd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFabricSpecificDetailsArray(body []byte) ([]FabricSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsdArray := make([]FabricSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsd, err := unmarshalFabricSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsdArray[index] = fsd
	}
	return fsdArray, nil
}

// FabricSpecificUpdateNetworkMappingInput is input details specific to fabrics during Network Mapping.
type FabricSpecificUpdateNetworkMappingInput interface {
	AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool)
	AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool)
	AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool)
}

func unmarshalFabricSpecificUpdateNetworkMappingInput(body []byte) (FabricSpecificUpdateNetworkMappingInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure):
		var ataunmi AzureToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &ataunmi)
		return ataunmi, err
	case string(InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure):
		var vtaunmi VmmToAzureUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtaunmi)
		return vtaunmi, err
	case string(InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm):
		var vtvunmi VmmToVmmUpdateNetworkMappingInput
		err := json.Unmarshal(body, &vtvunmi)
		return vtvunmi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFabricSpecificUpdateNetworkMappingInputArray(body []byte) ([]FabricSpecificUpdateNetworkMappingInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fsunmiArray := make([]FabricSpecificUpdateNetworkMappingInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fsunmi, err := unmarshalFabricSpecificUpdateNetworkMappingInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		fsunmiArray[index] = fsunmi
	}
	return fsunmiArray, nil
}

// FailoverJobDetails is this class represents the details for a failover job.
type FailoverJobDetails struct {
	AffectedObjectDetails *map[string]*string                        `json:"affectedObjectDetails,omitempty"`
	InstanceType          InstanceTypeJobDetails                     `json:"instanceType,omitempty"`
	ProtectedItemDetails  *[]FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverJobDetails.
func (fjd FailoverJobDetails) MarshalJSON() ([]byte, error) {
	fjd.InstanceType = InstanceTypeFailoverJobDetails
	type Alias FailoverJobDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(fjd),
	})
}

// AsAsrJobDetails is the JobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the JobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the JobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return &fjd, true
}

// AsExportJobDetails is the JobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the JobDetails implementation for FailoverJobDetails.
func (fjd FailoverJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// FailoverProcessServerRequest is request to failover a process server.
type FailoverProcessServerRequest struct {
	Properties *FailoverProcessServerRequestProperties `json:"properties,omitempty"`
}

// FailoverProcessServerRequestProperties is the properties of the Failover Process Server request.
type FailoverProcessServerRequestProperties struct {
	ContainerName         *string   `json:"containerName,omitempty"`
	SourceProcessServerID *string   `json:"sourceProcessServerId,omitempty"`
	TargetProcessServerID *string   `json:"targetProcessServerId,omitempty"`
	VmsToMigrate          *[]string `json:"vmsToMigrate,omitempty"`
	UpdateType            *string   `json:"updateType,omitempty"`
}

// FailoverReplicationProtectedItemDetails is failover details for a replication protected item.
type FailoverReplicationProtectedItemDetails struct {
	Name                    *string    `json:"name,omitempty"`
	FriendlyName            *string    `json:"friendlyName,omitempty"`
	TestVMName              *string    `json:"testVmName,omitempty"`
	TestVMFriendlyName      *string    `json:"testVmFriendlyName,omitempty"`
	NetworkConnectionStatus *string    `json:"networkConnectionStatus,omitempty"`
	NetworkFriendlyName     *string    `json:"networkFriendlyName,omitempty"`
	Subnet                  *string    `json:"subnet,omitempty"`
	RecoveryPointID         *string    `json:"recoveryPointId,omitempty"`
	RecoveryPointTime       *date.Time `json:"recoveryPointTime,omitempty"`
}

// GroupTaskDetails is this class represents the group task details when parent child relationship exists in the drill
// down.
type GroupTaskDetails interface {
	AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool)
	AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool)
	AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool)
}

func unmarshalGroupTaskDetails(body []byte) (GroupTaskDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeInlineWorkflowTaskDetails):
		var iwtd InlineWorkflowTaskDetails
		err := json.Unmarshal(body, &iwtd)
		return iwtd, err
	case string(InstanceTypeRecoveryPlanGroupTaskDetails):
		var rpgtd RecoveryPlanGroupTaskDetails
		err := json.Unmarshal(body, &rpgtd)
		return rpgtd, err
	case string(InstanceTypeRecoveryPlanShutdownGroupTaskDetails):
		var rpsgtd RecoveryPlanShutdownGroupTaskDetails
		err := json.Unmarshal(body, &rpsgtd)
		return rpsgtd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalGroupTaskDetailsArray(body []byte) ([]GroupTaskDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	gtdArray := make([]GroupTaskDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		gtd, err := unmarshalGroupTaskDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		gtdArray[index] = gtd
	}
	return gtdArray, nil
}

// HealthError is health Error
type HealthError struct {
	ErrorSource                  *string        `json:"errorSource,omitempty"`
	ErrorType                    *string        `json:"errorType,omitempty"`
	ErrorLevel                   *string        `json:"errorLevel,omitempty"`
	ErrorCode                    *string        `json:"errorCode,omitempty"`
	ErrorMessage                 *string        `json:"errorMessage,omitempty"`
	PossibleCauses               *string        `json:"possibleCauses,omitempty"`
	RecommendedAction            *string        `json:"recommendedAction,omitempty"`
	CreationTimeUtc              *date.Time     `json:"creationTimeUtc,omitempty"`
	RecoveryProviderErrorMessage *string        `json:"recoveryProviderErrorMessage,omitempty"`
	EntityID                     *string        `json:"entityId,omitempty"`
	ChildErrors                  *[]HealthError `json:"childErrors,omitempty"`
}

// HealthErrorSummary is class to define the summary of the health error details.
type HealthErrorSummary struct {
	SummaryCode                    *string             `json:"summaryCode,omitempty"`
	Category                       HealthErrorCategory `json:"category,omitempty"`
	Severity                       Severity            `json:"severity,omitempty"`
	SummaryMessage                 *string             `json:"summaryMessage,omitempty"`
	AffectedResourceType           *string             `json:"affectedResourceType,omitempty"`
	AffectedResourceSubtype        *string             `json:"affectedResourceSubtype,omitempty"`
	AffectedResourceCorrelationIds *[]string           `json:"affectedResourceCorrelationIds,omitempty"`
}

// HyperVReplica2012EventDetails is model class for event details of a HyperVReplica E2E event.
type HyperVReplica2012EventDetails struct {
	InstanceType        InstanceType `json:"instanceType,omitempty"`
	ContainerName       *string      `json:"containerName,omitempty"`
	FabricName          *string      `json:"fabricName,omitempty"`
	RemoteContainerName *string      `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string      `json:"remoteFabricName,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeHyperVReplica2012
	type Alias HyperVReplica2012EventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvr2ed),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012EventDetails.
func (hvr2ed HyperVReplica2012EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// HyperVReplica2012R2EventDetails is model class for event details of a HyperVReplica blue E2E event.
type HyperVReplica2012R2EventDetails struct {
	InstanceType        InstanceType `json:"instanceType,omitempty"`
	ContainerName       *string      `json:"containerName,omitempty"`
	FabricName          *string      `json:"fabricName,omitempty"`
	RemoteContainerName *string      `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string      `json:"remoteFabricName,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) MarshalJSON() ([]byte, error) {
	hvr2ed.InstanceType = InstanceTypeHyperVReplica2012R2
	type Alias HyperVReplica2012R2EventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvr2ed),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return &hvr2ed, true
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplica2012R2EventDetails.
func (hvr2ed HyperVReplica2012R2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// HyperVReplicaAzureApplyRecoveryPointInput is applyRecoveryPoint input specific to HyperVReplicaAzure provider.
type HyperVReplicaAzureApplyRecoveryPointInput struct {
	InstanceType               InstanceType `json:"instanceType,omitempty"`
	VaultLocation              *string      `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string      `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string      `json:"secondaryKekCertificatePfx,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	hvraarpi.InstanceType = InstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureApplyRecoveryPointInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvraarpi),
	})
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return &hvraarpi, true
}

// AsInMageAzureV2ApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsA2AApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for HyperVReplicaAzureApplyRecoveryPointInput.
func (hvraarpi HyperVReplicaAzureApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// HyperVReplicaAzureEnableProtectionInput is azure specific enable protection input.
type HyperVReplicaAzureEnableProtectionInput struct {
	InstanceType                 InstanceTypeEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
	HvHostVMID                   *string                                           `json:"hvHostVmId,omitempty"`
	VMName                       *string                                           `json:"vmName,omitempty"`
	OsType                       *string                                           `json:"osType,omitempty"`
	VhdID                        *string                                           `json:"vhdId,omitempty"`
	TargetStorageAccountID       *string                                           `json:"targetStorageAccountId,omitempty"`
	TargetAzureNetworkID         *string                                           `json:"targetAzureNetworkId,omitempty"`
	TargetAzureSubnetID          *string                                           `json:"targetAzureSubnetId,omitempty"`
	EnableRDPOnTargetOption      *string                                           `json:"enableRDPOnTargetOption,omitempty"`
	TargetAzureVMName            *string                                           `json:"targetAzureVmName,omitempty"`
	LogStorageAccountID          *string                                           `json:"logStorageAccountId,omitempty"`
	DisksToInclude               *[]string                                         `json:"disksToInclude,omitempty"`
	TargetAzureV1ResourceGroupID *string                                           `json:"targetAzureV1ResourceGroupId,omitempty"`
	TargetAzureV2ResourceGroupID *string                                           `json:"targetAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks              *string                                           `json:"useManagedDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) MarshalJSON() ([]byte, error) {
	hvraepi.InstanceType = InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureEnableProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvraepi),
	})
}

// AsHyperVReplicaAzureEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return &hvraepi, true
}

// AsSanEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for HyperVReplicaAzureEnableProtectionInput.
func (hvraepi HyperVReplicaAzureEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// HyperVReplicaAzureEventDetails is model class for event details of a HyperVReplica E2A event.
type HyperVReplicaAzureEventDetails struct {
	InstanceType        InstanceType `json:"instanceType,omitempty"`
	ContainerName       *string      `json:"containerName,omitempty"`
	FabricName          *string      `json:"fabricName,omitempty"`
	RemoteContainerName *string      `json:"remoteContainerName,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) MarshalJSON() ([]byte, error) {
	hvraed.InstanceType = InstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureEventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvraed),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return &hvraed, true
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaAzureEventDetails.
func (hvraed HyperVReplicaAzureEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// HyperVReplicaAzureFailbackProviderInput is hvrA provider specific input for failback.
type HyperVReplicaAzureFailbackProviderInput struct {
	InstanceType                   InstanceTypeProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	DataSyncOption                 *string                                   `json:"dataSyncOption,omitempty"`
	RecoveryVMCreationOption       *string                                   `json:"recoveryVmCreationOption,omitempty"`
	ProviderIDForAlternateRecovery *string                                   `json:"providerIdForAlternateRecovery,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	type Alias HyperVReplicaAzureFailbackProviderInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrafpi),
	})
}

// AsHyperVReplicaAzureFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return &hvrafpi, true
}

// AsInMageAzureV2FailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailbackProviderInput.
func (hvrafpi HyperVReplicaAzureFailbackProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// HyperVReplicaAzureFailoverProviderInput is hvrA provider specific input for failover.
type HyperVReplicaAzureFailoverProviderInput struct {
	InstanceType               InstanceTypeProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	VaultLocation              *string                                   `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string                                   `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string                                   `json:"secondaryKekCertificatePfx,omitempty"`
	RecoveryPointID            *string                                   `json:"recoveryPointId,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) MarshalJSON() ([]byte, error) {
	hvrafpi.InstanceType = InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureFailoverProviderInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrafpi),
	})
}

// AsHyperVReplicaAzureFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return &hvrafpi, true
}

// AsHyperVReplicaAzureFailbackProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the ProviderSpecificFailoverInput implementation for HyperVReplicaAzureFailoverProviderInput.
func (hvrafpi HyperVReplicaAzureFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// HyperVReplicaAzurePolicyDetails is hyper-V Replica Azure specific protection profile details.
type HyperVReplicaAzurePolicyDetails struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointHistoryDurationInHours           *int32                                    `json:"recoveryPointHistoryDurationInHours,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                    `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	ReplicationInterval                           *int32                                    `json:"replicationInterval,omitempty"`
	OnlineReplicationStartTime                    *string                                   `json:"onlineReplicationStartTime,omitempty"`
	Encryption                                    *string                                   `json:"encryption,omitempty"`
	ActiveStorageAccountID                        *string                                   `json:"activeStorageAccountId,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrapd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzurePolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrapd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return &hvrapd, true
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaAzurePolicyDetails.
func (hvrapd HyperVReplicaAzurePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// HyperVReplicaAzurePolicyInput is hyper-V Replica Azure specific input for creating a protection profile.
type HyperVReplicaAzurePolicyInput struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPointHistoryDuration                  *int32                                  `json:"recoveryPointHistoryDuration,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	ReplicationInterval                           *int32                                  `json:"replicationInterval,omitempty"`
	OnlineReplicationStartTime                    *string                                 `json:"onlineReplicationStartTime,omitempty"`
	Encryption                                    *string                                 `json:"encryption,omitempty"`
	StorageAccounts                               *[]string                               `json:"storageAccounts,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) MarshalJSON() ([]byte, error) {
	hvrapi.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzurePolicyInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrapi),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return &hvrapi, true
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaAzurePolicyInput.
func (hvrapi HyperVReplicaAzurePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// HyperVReplicaAzureReplicationDetails is hyper V Replica Azure provider specific settings.
type HyperVReplicaAzureReplicationDetails struct {
	InstanceType                     InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	AzureVMDiskDetails               *[]AzureVMDiskDetails                           `json:"azureVMDiskDetails,omitempty"`
	RecoveryAzureVMName              *string                                         `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize              *string                                         `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureStorageAccount      *string                                         `json:"recoveryAzureStorageAccount,omitempty"`
	RecoveryAzureLogStorageAccountID *string                                         `json:"recoveryAzureLogStorageAccountId,omitempty"`
	LastReplicatedTime               *date.Time                                      `json:"lastReplicatedTime,omitempty"`
	VMID                             *string                                         `json:"vmId,omitempty"`
	VMProtectionState                *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription     *string                                         `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails        *InitialReplicationDetails                      `json:"initialReplicationDetails,omitempty"`
	VMNics                           *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	SelectedRecoveryAzureNetworkID   *string                                         `json:"selectedRecoveryAzureNetworkId,omitempty"`
	Encryption                       *string                                         `json:"encryption,omitempty"`
	OSDetails                        *OSDetails                                      `json:"oSDetails,omitempty"`
	SourceVMRAMSizeInMB              *int32                                          `json:"sourceVmRAMSizeInMB,omitempty"`
	SourceVMCPUCount                 *int32                                          `json:"sourceVmCPUCount,omitempty"`
	EnableRDPOnTargetOption          *string                                         `json:"enableRDPOnTargetOption,omitempty"`
	RecoveryAzureResourceGroupID     *string                                         `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryAvailabilitySetID        *string                                         `json:"recoveryAvailabilitySetId,omitempty"`
	UseManagedDisks                  *string                                         `json:"useManagedDisks,omitempty"`
	LicenseType                      *string                                         `json:"licenseType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrard.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrard),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return &hvrard, true
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaAzureReplicationDetails.
func (hvrard HyperVReplicaAzureReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// HyperVReplicaAzureReprotectInput is azure specific reprotect input.
type HyperVReplicaAzureReprotectInput struct {
	InstanceType        InstanceTypeReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
	HvHostVMID          *string                                             `json:"hvHostVmId,omitempty"`
	VMName              *string                                             `json:"vmName,omitempty"`
	OsType              *string                                             `json:"osType,omitempty"`
	VHDID               *string                                             `json:"vHDId,omitempty"`
	StorageAccountID    *string                                             `json:"storageAccountId,omitempty"`
	LogStorageAccountID *string                                             `json:"logStorageAccountId,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) MarshalJSON() ([]byte, error) {
	hvrari.InstanceType = InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureReprotectInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrari),
	})
}

// AsHyperVReplicaAzureReprotectInput is the ReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return &hvrari, true
}

// AsInMageAzureV2ReprotectInput is the ReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the ReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the ReverseReplicationProviderSpecificInput implementation for HyperVReplicaAzureReprotectInput.
func (hvrari HyperVReplicaAzureReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// HyperVReplicaAzureUpdateReplicationProtectedItemInput is hyperV replica Azure input to update replication protected
// item.
type HyperVReplicaAzureUpdateReplicationProtectedItemInput struct {
	InstanceType                   InstanceType `json:"instanceType,omitempty"`
	RecoveryAzureV1ResourceGroupID *string      `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	RecoveryAzureV2ResourceGroupID *string      `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks                *string      `json:"useManagedDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	hvraurpii.InstanceType = InstanceTypeHyperVReplicaAzure
	type Alias HyperVReplicaAzureUpdateReplicationProtectedItemInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvraurpii),
	})
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return &hvraurpii, true
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsA2AUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for HyperVReplicaAzureUpdateReplicationProtectedItemInput.
func (hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// HyperVReplicaBaseEventDetails is abstract model class for event details of a HyperVReplica E2E event.
type HyperVReplicaBaseEventDetails struct {
	InstanceType        InstanceType `json:"instanceType,omitempty"`
	ContainerName       *string      `json:"containerName,omitempty"`
	FabricName          *string      `json:"fabricName,omitempty"`
	RemoteContainerName *string      `json:"remoteContainerName,omitempty"`
	RemoteFabricName    *string      `json:"remoteFabricName,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) MarshalJSON() ([]byte, error) {
	hvrbed.InstanceType = InstanceTypeHyperVReplicaBaseEventDetails
	type Alias HyperVReplicaBaseEventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbed),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return &hvrbed, true
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for HyperVReplicaBaseEventDetails.
func (hvrbed HyperVReplicaBaseEventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return nil, false
}

// HyperVReplicaBasePolicyDetails is base class for HyperVReplica policy details.
type HyperVReplicaBasePolicyDetails struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPoints                                *int32                                    `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                    `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string                                   `json:"compression,omitempty"`
	InitialReplicationMethod                      *string                                   `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string                                   `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string                                   `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string                                   `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32                                    `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32                                    `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string                                   `json:"replicaDeletionOption,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails
	type Alias HyperVReplicaBasePolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBasePolicyDetails.
func (hvrbpd HyperVReplicaBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// HyperVReplicaBaseReplicationDetails is hyper V replica provider specific settings base class.
type HyperVReplicaBaseReplicationDetails struct {
	InstanceType                 InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	LastReplicatedTime           *date.Time                                      `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	VMID                         *string                                         `json:"vmId,omitempty"`
	VMProtectionState            *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                                         `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails                      `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails                                  `json:"vMDiskDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails
	type Alias HyperVReplicaBaseReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbrd),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBaseReplicationDetails.
func (hvrbrd HyperVReplicaBaseReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// HyperVReplicaBluePolicyDetails is hyper-V Replica Blue specific protection profile details.
type HyperVReplicaBluePolicyDetails struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	ReplicationFrequencyInSeconds                 *int32                                    `json:"replicationFrequencyInSeconds,omitempty"`
	RecoveryPoints                                *int32                                    `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                    `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string                                   `json:"compression,omitempty"`
	InitialReplicationMethod                      *string                                   `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string                                   `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string                                   `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string                                   `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32                                    `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32                                    `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string                                   `json:"replicaDeletionOption,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) MarshalJSON() ([]byte, error) {
	hvrbpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2
	type Alias HyperVReplicaBluePolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return &hvrbpd, true
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaBluePolicyDetails.
func (hvrbpd HyperVReplicaBluePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// HyperVReplicaBluePolicyInput is hyperV Replica Blue policy input.
type HyperVReplicaBluePolicyInput struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	ReplicationFrequencyInSeconds                 *int32                                  `json:"replicationFrequencyInSeconds,omitempty"`
	RecoveryPoints                                *int32                                  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string                                 `json:"compression,omitempty"`
	InitialReplicationMethod                      *string                                 `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string                                 `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string                                 `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string                                 `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32                                  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32                                  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletion                               *string                                 `json:"replicaDeletion,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) MarshalJSON() ([]byte, error) {
	hvrbpi.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2
	type Alias HyperVReplicaBluePolicyInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbpi),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return &hvrbpi, true
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaBluePolicyInput.
func (hvrbpi HyperVReplicaBluePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// HyperVReplicaBlueReplicationDetails is hyperV replica 2012 R2 (Blue) replication details.
type HyperVReplicaBlueReplicationDetails struct {
	InstanceType                 InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	LastReplicatedTime           *date.Time                                      `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	VMID                         *string                                         `json:"vmId,omitempty"`
	VMProtectionState            *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                                         `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails                      `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails                                  `json:"vMDiskDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrbrd.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2
	type Alias HyperVReplicaBlueReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrbrd),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return &hvrbrd, true
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaBlueReplicationDetails.
func (hvrbrd HyperVReplicaBlueReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// HyperVReplicaPolicyDetails is hyper-V Replica Blue specific protection profile details.
type HyperVReplicaPolicyDetails struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPoints                                *int32                                    `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                    `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string                                   `json:"compression,omitempty"`
	InitialReplicationMethod                      *string                                   `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string                                   `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string                                   `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string                                   `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32                                    `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32                                    `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletionOption                         *string                                   `json:"replicaDeletionOption,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) MarshalJSON() ([]byte, error) {
	hvrpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012
	type Alias HyperVReplicaPolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return &hvrpd, true
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for HyperVReplicaPolicyDetails.
func (hvrpd HyperVReplicaPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// HyperVReplicaPolicyInput is hyper-V Replica specific protection profile Input.
type HyperVReplicaPolicyInput struct {
	InstanceType                                  InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPoints                                *int32                                  `json:"recoveryPoints,omitempty"`
	ApplicationConsistentSnapshotFrequencyInHours *int32                                  `json:"applicationConsistentSnapshotFrequencyInHours,omitempty"`
	Compression                                   *string                                 `json:"compression,omitempty"`
	InitialReplicationMethod                      *string                                 `json:"initialReplicationMethod,omitempty"`
	OnlineReplicationStartTime                    *string                                 `json:"onlineReplicationStartTime,omitempty"`
	OfflineReplicationImportPath                  *string                                 `json:"offlineReplicationImportPath,omitempty"`
	OfflineReplicationExportPath                  *string                                 `json:"offlineReplicationExportPath,omitempty"`
	ReplicationPort                               *int32                                  `json:"replicationPort,omitempty"`
	AllowedAuthenticationType                     *int32                                  `json:"allowedAuthenticationType,omitempty"`
	ReplicaDeletion                               *string                                 `json:"replicaDeletion,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) MarshalJSON() ([]byte, error) {
	hvrpi.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012
	type Alias HyperVReplicaPolicyInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrpi),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return &hvrpi, true
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for HyperVReplicaPolicyInput.
func (hvrpi HyperVReplicaPolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// HyperVReplicaReplicationDetails is hyperV replica 2012 replication details.
type HyperVReplicaReplicationDetails struct {
	InstanceType                 InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	LastReplicatedTime           *date.Time                                      `json:"lastReplicatedTime,omitempty"`
	VMNics                       *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	VMID                         *string                                         `json:"vmId,omitempty"`
	VMProtectionState            *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                                         `json:"vmProtectionStateDescription,omitempty"`
	InitialReplicationDetails    *InitialReplicationDetails                      `json:"initialReplicationDetails,omitempty"`
	VMDiskDetails                *[]DiskDetails                                  `json:"vMDiskDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) MarshalJSON() ([]byte, error) {
	hvrrd.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012
	type Alias HyperVReplicaReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvrrd),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return &hvrrd, true
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for HyperVReplicaReplicationDetails.
func (hvrrd HyperVReplicaReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// HyperVSiteDetails is hyperVSite fabric specific details.
type HyperVSiteDetails struct {
	InstanceType InstanceTypeFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) MarshalJSON() ([]byte, error) {
	hvsd.InstanceType = InstanceTypeHyperVSite
	type Alias HyperVSiteDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvsd),
	})
}

// AsAzureFabricSpecificDetails is the FabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the FabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the FabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return &hvsd, true
}

// AsVMwareDetails is the FabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the FabricSpecificDetails implementation for HyperVSiteDetails.
func (hvsd HyperVSiteDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// HyperVVirtualMachineDetails is hyper V replica provider specific settings
type HyperVVirtualMachineDetails struct {
	InstanceType InstanceTypeConfigurationSettings `json:"instanceType,omitempty"`
	SourceItemID *string                           `json:"sourceItemId,omitempty"`
	Generation   *string                           `json:"generation,omitempty"`
	OsDetails    *OSDetails                        `json:"osDetails,omitempty"`
	DiskDetails  *[]DiskDetails                    `json:"diskDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	hvvmd.InstanceType = InstanceTypeHyperVVirtualMachine
	type Alias HyperVVirtualMachineDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(hvvmd),
	})
}

// AsHyperVVirtualMachineDetails is the ConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return &hvvmd, true
}

// AsVMwareVirtualMachineDetails is the ConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the ConfigurationSettings implementation for HyperVVirtualMachineDetails.
func (hvvmd HyperVVirtualMachineDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}

// IdentityInformation is identity details.
type IdentityInformation struct {
	IdentityProviderType  IdentityProviderType `json:"identityProviderType,omitempty"`
	TenantID              *string              `json:"tenantId,omitempty"`
	ApplicationID         *string              `json:"applicationId,omitempty"`
	ObjectID              *string              `json:"objectId,omitempty"`
	Audience              *string              `json:"audience,omitempty"`
	AadAuthority          *string              `json:"aadAuthority,omitempty"`
	CertificateThumbprint *string              `json:"certificateThumbprint,omitempty"`
}

// InconsistentVMDetails is this class stores the monitoring details for consistency check of inconsistent Protected
// Entity.
type InconsistentVMDetails struct {
	VMName    *string   `json:"vmName,omitempty"`
	CloudName *string   `json:"cloudName,omitempty"`
	Details   *[]string `json:"details,omitempty"`
	ErrorIds  *[]string `json:"errorIds,omitempty"`
}

// InitialReplicationDetails is initial replication details.
type InitialReplicationDetails struct {
	InitialReplicationType               *string `json:"initialReplicationType,omitempty"`
	InitialReplicationProgressPercentage *string `json:"initialReplicationProgressPercentage,omitempty"`
}

// InlineWorkflowTaskDetails is this class represents the inline workflow task details.
type InlineWorkflowTaskDetails struct {
	ChildTasks   *[]ASRTask                   `json:"childTasks,omitempty"`
	InstanceType InstanceTypeGroupTaskDetails `json:"instanceType,omitempty"`
	WorkflowIds  *[]string                    `json:"workflowIds,omitempty"`
}

// MarshalJSON is the custom marshaler for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) MarshalJSON() ([]byte, error) {
	iwtd.InstanceType = InstanceTypeInlineWorkflowTaskDetails
	type Alias InlineWorkflowTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(iwtd),
	})
}

// AsInlineWorkflowTaskDetails is the GroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return &iwtd, true
}

// AsRecoveryPlanGroupTaskDetails is the GroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the GroupTaskDetails implementation for InlineWorkflowTaskDetails.
func (iwtd InlineWorkflowTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// InMageAgentDetails is the details of the InMage agent.
type InMageAgentDetails struct {
	AgentVersion           *string `json:"agentVersion,omitempty"`
	AgentUpdateStatus      *string `json:"agentUpdateStatus,omitempty"`
	PostUpdateRebootStatus *string `json:"postUpdateRebootStatus,omitempty"`
}

// InMageAzureV2ApplyRecoveryPointInput is applyRecoveryPoint input specific to InMageAzureV2 provider.
type InMageAzureV2ApplyRecoveryPointInput struct {
	InstanceType  InstanceType `json:"instanceType,omitempty"`
	VaultLocation *string      `json:"vaultLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) MarshalJSON() ([]byte, error) {
	imavarpi.InstanceType = InstanceTypeInMageAzureV2
	type Alias InMageAzureV2ApplyRecoveryPointInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavarpi),
	})
}

// AsHyperVReplicaAzureApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsHyperVReplicaAzureApplyRecoveryPointInput() (*HyperVReplicaAzureApplyRecoveryPointInput, bool) {
	return nil, false
}

// AsInMageAzureV2ApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsInMageAzureV2ApplyRecoveryPointInput() (*InMageAzureV2ApplyRecoveryPointInput, bool) {
	return &imavarpi, true
}

// AsA2AApplyRecoveryPointInput is the ApplyRecoveryPointProviderSpecificInput implementation for InMageAzureV2ApplyRecoveryPointInput.
func (imavarpi InMageAzureV2ApplyRecoveryPointInput) AsA2AApplyRecoveryPointInput() (*A2AApplyRecoveryPointInput, bool) {
	return nil, false
}

// InMageAzureV2EnableProtectionInput is vMware Azure specific enable protection input.
type InMageAzureV2EnableProtectionInput struct {
	InstanceType                 InstanceTypeEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
	MasterTargetID               *string                                           `json:"masterTargetId,omitempty"`
	ProcessServerID              *string                                           `json:"processServerId,omitempty"`
	StorageAccountID             *string                                           `json:"storageAccountId,omitempty"`
	RunAsAccountID               *string                                           `json:"runAsAccountId,omitempty"`
	MultiVMGroupID               *string                                           `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName             *string                                           `json:"multiVmGroupName,omitempty"`
	DisksToInclude               *[]string                                         `json:"disksToInclude,omitempty"`
	TargetAzureNetworkID         *string                                           `json:"targetAzureNetworkId,omitempty"`
	TargetAzureSubnetID          *string                                           `json:"targetAzureSubnetId,omitempty"`
	EnableRDPOnTargetOption      *string                                           `json:"enableRDPOnTargetOption,omitempty"`
	TargetAzureVMName            *string                                           `json:"targetAzureVmName,omitempty"`
	LogStorageAccountID          *string                                           `json:"logStorageAccountId,omitempty"`
	TargetAzureV1ResourceGroupID *string                                           `json:"targetAzureV1ResourceGroupId,omitempty"`
	TargetAzureV2ResourceGroupID *string                                           `json:"targetAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks              *string                                           `json:"useManagedDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) MarshalJSON() ([]byte, error) {
	imavepi.InstanceType = InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2
	type Alias InMageAzureV2EnableProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavepi),
	})
}

// AsHyperVReplicaAzureEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return &imavepi, true
}

// AsInMageEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageAzureV2EnableProtectionInput.
func (imavepi InMageAzureV2EnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// InMageAzureV2EventDetails is model class for event details of a VMwareAzureV2 event.
type InMageAzureV2EventDetails struct {
	InstanceType     InstanceType `json:"instanceType,omitempty"`
	EventType        *string      `json:"eventType,omitempty"`
	Category         *string      `json:"category,omitempty"`
	Component        *string      `json:"component,omitempty"`
	CorrectiveAction *string      `json:"correctiveAction,omitempty"`
	Details          *string      `json:"details,omitempty"`
	Summary          *string      `json:"summary,omitempty"`
	SiteName         *string      `json:"siteName,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) MarshalJSON() ([]byte, error) {
	imaved.InstanceType = InstanceTypeInMageAzureV2
	type Alias InMageAzureV2EventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imaved),
	})
}

// AsHyperVReplicaBaseEventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaBaseEventDetails() (*HyperVReplicaBaseEventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012EventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012EventDetails() (*HyperVReplica2012EventDetails, bool) {
	return nil, false
}

// AsHyperVReplica2012R2EventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplica2012R2EventDetails() (*HyperVReplica2012R2EventDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureEventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsHyperVReplicaAzureEventDetails() (*HyperVReplicaAzureEventDetails, bool) {
	return nil, false
}

// AsA2AEventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsA2AEventDetails() (*A2AEventDetails, bool) {
	return nil, false
}

// AsInMageAzureV2EventDetails is the EventProviderSpecificDetails implementation for InMageAzureV2EventDetails.
func (imaved InMageAzureV2EventDetails) AsInMageAzureV2EventDetails() (*InMageAzureV2EventDetails, bool) {
	return &imaved, true
}

// InMageAzureV2FailoverProviderInput is inMageAzureV2 provider specific input for failover.
type InMageAzureV2FailoverProviderInput struct {
	InstanceType    InstanceTypeProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	VaultLocation   *string                                   `json:"vaultLocation,omitempty"`
	RecoveryPointID *string                                   `json:"recoveryPointId,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) MarshalJSON() ([]byte, error) {
	imavfpi.InstanceType = InstanceTypeProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	type Alias InMageAzureV2FailoverProviderInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavfpi),
	})
}

// AsHyperVReplicaAzureFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the ProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return &imavfpi, true
}

// AsInMageFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return nil, false
}

// AsA2AFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageAzureV2FailoverProviderInput.
func (imavfpi InMageAzureV2FailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// InMageAzureV2PolicyDetails is inMage Azure v2 specific protection profile details.
type InMageAzureV2PolicyDetails struct {
	InstanceType                      InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                    `json:"crashConsistentFrequencyInMinutes,omitempty"`
	RecoveryPointThresholdInMinutes   *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 *string                                   `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) MarshalJSON() ([]byte, error) {
	imavpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageAzureV2
	type Alias InMageAzureV2PolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return &imavpd, true
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageAzureV2PolicyDetails.
func (imavpd InMageAzureV2PolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// InMageAzureV2PolicyInput is vMWare Azure specific protection profile Input.
type InMageAzureV2PolicyInput struct {
	InstanceType                      InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes   *int32                                  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32                                  `json:"recoveryPointHistory,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                  `json:"crashConsistentFrequencyInMinutes,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 SetMultiVMSyncStatus                    `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) MarshalJSON() ([]byte, error) {
	imavpi.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeInMageAzureV2
	type Alias InMageAzureV2PolicyInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavpi),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return &imavpi, true
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for InMageAzureV2PolicyInput.
func (imavpi InMageAzureV2PolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// InMageAzureV2ProtectedDiskDetails is inMageAzureV2 protected disk details.
type InMageAzureV2ProtectedDiskDetails struct {
	DiskID                    *string    `json:"diskId,omitempty"`
	DiskName                  *string    `json:"diskName,omitempty"`
	ProtectionStage           *string    `json:"protectionStage,omitempty"`
	HealthErrorCode           *string    `json:"healthErrorCode,omitempty"`
	RpoInSeconds              *int64     `json:"rpoInSeconds,omitempty"`
	ResyncRequired            *string    `json:"resyncRequired,omitempty"`
	ResyncProgressPercentage  *int32     `json:"resyncProgressPercentage,omitempty"`
	ResyncDurationInSeconds   *int64     `json:"resyncDurationInSeconds,omitempty"`
	DiskCapacityInBytes       *int64     `json:"diskCapacityInBytes,omitempty"`
	FileSystemCapacityInBytes *int64     `json:"fileSystemCapacityInBytes,omitempty"`
	SourceDataInMegaBytes     *float64   `json:"sourceDataInMegaBytes,omitempty"`
	PsDataInMegaBytes         *float64   `json:"psDataInMegaBytes,omitempty"`
	TargetDataInMegaBytes     *float64   `json:"targetDataInMegaBytes,omitempty"`
	DiskResized               *string    `json:"diskResized,omitempty"`
	LastRpoCalculatedTime     *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageAzureV2RecoveryPointDetails is inMage Azure V2 provider specific recovery point details.
type InMageAzureV2RecoveryPointDetails struct {
	Type               *string `json:"Type,omitempty"`
	InstanceType       *string `json:"instanceType,omitempty"`
	IsMultiVMSyncPoint *string `json:"isMultiVmSyncPoint,omitempty"`
}

// InMageAzureV2ReplicationDetails is inMageAzureV2 provider specific settings
type InMageAzureV2ReplicationDetails struct {
	InstanceType                     InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	InfrastructureVMID               *string                                         `json:"infrastructureVmId,omitempty"`
	VCenterInfrastructureID          *string                                         `json:"vCenterInfrastructureId,omitempty"`
	ProtectionStage                  *string                                         `json:"protectionStage,omitempty"`
	VMID                             *string                                         `json:"vmId,omitempty"`
	VMProtectionState                *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription     *string                                         `json:"vmProtectionStateDescription,omitempty"`
	ResyncProgressPercentage         *int32                                          `json:"resyncProgressPercentage,omitempty"`
	RpoInSeconds                     *int64                                          `json:"rpoInSeconds,omitempty"`
	CompressedDataRateInMB           *float64                                        `json:"compressedDataRateInMB,omitempty"`
	UncompressedDataRateInMB         *float64                                        `json:"uncompressedDataRateInMB,omitempty"`
	IPAddress                        *string                                         `json:"ipAddress,omitempty"`
	AgentVersion                     *string                                         `json:"agentVersion,omitempty"`
	IsAgentUpdateRequired            *string                                         `json:"isAgentUpdateRequired,omitempty"`
	IsRebootAfterUpdateRequired      *string                                         `json:"isRebootAfterUpdateRequired,omitempty"`
	LastHeartbeat                    *date.Time                                      `json:"lastHeartbeat,omitempty"`
	ProcessServerID                  *string                                         `json:"processServerId,omitempty"`
	MultiVMGroupID                   *string                                         `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName                 *string                                         `json:"multiVmGroupName,omitempty"`
	MultiVMSyncStatus                *string                                         `json:"multiVmSyncStatus,omitempty"`
	ProtectedDisks                   *[]InMageAzureV2ProtectedDiskDetails            `json:"protectedDisks,omitempty"`
	DiskResized                      *string                                         `json:"diskResized,omitempty"`
	MasterTargetID                   *string                                         `json:"masterTargetId,omitempty"`
	SourceVMCPUCount                 *int32                                          `json:"sourceVmCPUCount,omitempty"`
	SourceVMRAMSizeInMB              *int32                                          `json:"sourceVmRAMSizeInMB,omitempty"`
	OsType                           *string                                         `json:"osType,omitempty"`
	VhdName                          *string                                         `json:"vhdName,omitempty"`
	OsDiskID                         *string                                         `json:"osDiskId,omitempty"`
	AzureVMDiskDetails               *[]AzureVMDiskDetails                           `json:"azureVMDiskDetails,omitempty"`
	RecoveryAzureVMName              *string                                         `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize              *string                                         `json:"recoveryAzureVMSize,omitempty"`
	RecoveryAzureStorageAccount      *string                                         `json:"recoveryAzureStorageAccount,omitempty"`
	RecoveryAzureLogStorageAccountID *string                                         `json:"recoveryAzureLogStorageAccountId,omitempty"`
	VMNics                           *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	SelectedRecoveryAzureNetworkID   *string                                         `json:"selectedRecoveryAzureNetworkId,omitempty"`
	DiscoveryType                    *string                                         `json:"discoveryType,omitempty"`
	EnableRDPOnTargetOption          *string                                         `json:"enableRDPOnTargetOption,omitempty"`
	Datastores                       *[]string                                       `json:"datastores,omitempty"`
	TargetVMID                       *string                                         `json:"targetVmId,omitempty"`
	RecoveryAzureResourceGroupID     *string                                         `json:"recoveryAzureResourceGroupId,omitempty"`
	RecoveryAvailabilitySetID        *string                                         `json:"recoveryAvailabilitySetId,omitempty"`
	UseManagedDisks                  *string                                         `json:"useManagedDisks,omitempty"`
	LicenseType                      *string                                         `json:"licenseType,omitempty"`
	ValidationErrors                 *[]HealthError                                  `json:"validationErrors,omitempty"`
	LastRpoCalculatedTime            *date.Time                                      `json:"lastRpoCalculatedTime,omitempty"`
	LastUpdateReceivedTime           *date.Time                                      `json:"lastUpdateReceivedTime,omitempty"`
	ReplicaID                        *string                                         `json:"replicaId,omitempty"`
	OsVersion                        *string                                         `json:"osVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) MarshalJSON() ([]byte, error) {
	imavrd.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2
	type Alias InMageAzureV2ReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavrd),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return &imavrd, true
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return nil, false
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageAzureV2ReplicationDetails.
func (imavrd InMageAzureV2ReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// InMageAzureV2ReprotectInput is inMageAzureV2 specific provider input.
type InMageAzureV2ReprotectInput struct {
	InstanceType        InstanceTypeReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
	MasterTargetID      *string                                             `json:"masterTargetId,omitempty"`
	ProcessServerID     *string                                             `json:"processServerId,omitempty"`
	StorageAccountID    *string                                             `json:"storageAccountId,omitempty"`
	RunAsAccountID      *string                                             `json:"runAsAccountId,omitempty"`
	PolicyID            *string                                             `json:"policyId,omitempty"`
	LogStorageAccountID *string                                             `json:"logStorageAccountId,omitempty"`
	DisksToInclude      *[]string                                           `json:"disksToInclude,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) MarshalJSON() ([]byte, error) {
	imavri.InstanceType = InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2
	type Alias InMageAzureV2ReprotectInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavri),
	})
}

// AsHyperVReplicaAzureReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return &imavri, true
}

// AsInMageReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return nil, false
}

// AsA2AReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageAzureV2ReprotectInput.
func (imavri InMageAzureV2ReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// InMageAzureV2UpdateReplicationProtectedItemInput is inMage Azure V2 input to update replication protected item.
type InMageAzureV2UpdateReplicationProtectedItemInput struct {
	InstanceType                   InstanceType `json:"instanceType,omitempty"`
	RecoveryAzureV1ResourceGroupID *string      `json:"recoveryAzureV1ResourceGroupId,omitempty"`
	RecoveryAzureV2ResourceGroupID *string      `json:"recoveryAzureV2ResourceGroupId,omitempty"`
	UseManagedDisks                *string      `json:"useManagedDisks,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) MarshalJSON() ([]byte, error) {
	imavurpii.InstanceType = InstanceTypeInMageAzureV2
	type Alias InMageAzureV2UpdateReplicationProtectedItemInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imavurpii),
	})
}

// AsHyperVReplicaAzureUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// AsInMageAzureV2UpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool) {
	return &imavurpii, true
}

// AsA2AUpdateReplicationProtectedItemInput is the UpdateReplicationProtectedItemProviderInput implementation for InMageAzureV2UpdateReplicationProtectedItemInput.
func (imavurpii InMageAzureV2UpdateReplicationProtectedItemInput) AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool) {
	return nil, false
}

// InMageBasePolicyDetails is base class for the policies of providers using InMage replication.
type InMageBasePolicyDetails struct {
	InstanceType                    InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               *string                                   `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) MarshalJSON() ([]byte, error) {
	imbpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails
	type Alias InMageBasePolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imbpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return &imbpd, true
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for InMageBasePolicyDetails.
func (imbpd InMageBasePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// InMageDisableProtectionProviderSpecificInput is inMage disable protection provider specific input.
type InMageDisableProtectionProviderSpecificInput struct {
	InstanceType            InstanceTypeDisableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
	ReplicaVMDeletionStatus *string                                            `json:"replicaVmDeletionStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) MarshalJSON() ([]byte, error) {
	imdppsi.InstanceType = InstanceTypeInMage
	type Alias InMageDisableProtectionProviderSpecificInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imdppsi),
	})
}

// AsInMageDisableProtectionProviderSpecificInput is the DisableProtectionProviderSpecificInput implementation for InMageDisableProtectionProviderSpecificInput.
func (imdppsi InMageDisableProtectionProviderSpecificInput) AsInMageDisableProtectionProviderSpecificInput() (*InMageDisableProtectionProviderSpecificInput, bool) {
	return &imdppsi, true
}

// InMageDiskDetails is vMware/Physical specific Disk Details
type InMageDiskDetails struct {
	DiskID            *string              `json:"diskId,omitempty"`
	DiskName          *string              `json:"diskName,omitempty"`
	DiskSizeInMB      *string              `json:"diskSizeInMB,omitempty"`
	DiskType          *string              `json:"diskType,omitempty"`
	DiskConfiguration *string              `json:"diskConfiguration,omitempty"`
	VolumeList        *[]DiskVolumeDetails `json:"volumeList,omitempty"`
}

// InMageDiskExclusionInput is diskExclusionInput when doing enable protection of virtual machine in InMage provider.
type InMageDiskExclusionInput struct {
	VolumeOptions        *[]InMageVolumeExclusionOptions        `json:"volumeOptions,omitempty"`
	DiskSignatureOptions *[]InMageDiskSignatureExclusionOptions `json:"diskSignatureOptions,omitempty"`
}

// InMageDiskSignatureExclusionOptions is guest disk signature based disk exclusion option when doing enable protection
// of virtual machine in InMage provider.
type InMageDiskSignatureExclusionOptions struct {
	DiskSignature *string `json:"diskSignature,omitempty"`
}

// InMageEnableProtectionInput is vMware Azure specific enable protection input.
type InMageEnableProtectionInput struct {
	InstanceType       InstanceTypeEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
	VMFriendlyName     *string                                           `json:"vmFriendlyName,omitempty"`
	MasterTargetID     *string                                           `json:"masterTargetId,omitempty"`
	ProcessServerID    *string                                           `json:"processServerId,omitempty"`
	RetentionDrive     *string                                           `json:"retentionDrive,omitempty"`
	RunAsAccountID     *string                                           `json:"runAsAccountId,omitempty"`
	MultiVMGroupID     *string                                           `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName   *string                                           `json:"multiVmGroupName,omitempty"`
	DatastoreName      *string                                           `json:"datastoreName,omitempty"`
	DiskExclusionInput *InMageDiskExclusionInput                         `json:"diskExclusionInput,omitempty"`
	DisksToInclude     *[]string                                         `json:"disksToInclude,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) MarshalJSON() ([]byte, error) {
	imepi.InstanceType = InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeInMage
	type Alias InMageEnableProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imepi),
	})
}

// AsHyperVReplicaAzureEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return nil, false
}

// AsInMageAzureV2EnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return &imepi, true
}

// AsA2AEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for InMageEnableProtectionInput.
func (imepi InMageEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// InMageFailoverProviderInput is provider specific input for InMage failover.
type InMageFailoverProviderInput struct {
	InstanceType      InstanceTypeProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	RecoveryPointType RecoveryPointType                         `json:"recoveryPointType,omitempty"`
	RecoveryPointID   *string                                   `json:"recoveryPointId,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) MarshalJSON() ([]byte, error) {
	imfpi.InstanceType = InstanceTypeProviderSpecificFailoverInputInstanceTypeInMage
	type Alias InMageFailoverProviderInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imfpi),
	})
}

// AsHyperVReplicaAzureFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool) {
	return nil, false
}

// AsHyperVReplicaAzureFailbackProviderInput is the ProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool) {
	return nil, false
}

// AsInMageAzureV2FailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool) {
	return nil, false
}

// AsInMageFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool) {
	return &imfpi, true
}

// AsA2AFailoverProviderInput is the ProviderSpecificFailoverInput implementation for InMageFailoverProviderInput.
func (imfpi InMageFailoverProviderInput) AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool) {
	return nil, false
}

// InMagePolicyDetails is inMage specific protection profile details.
type InMagePolicyDetails struct {
	InstanceType                    InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               *string                                   `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyDetails.
func (impd InMagePolicyDetails) MarshalJSON() ([]byte, error) {
	impd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMage
	type Alias InMagePolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(impd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return &impd, true
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for InMagePolicyDetails.
func (impd InMagePolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// InMagePolicyInput is vMWare Azure specific protection profile Input.
type InMagePolicyInput struct {
	InstanceType                    InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes *int32                                  `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory            *int32                                  `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes *int32                                  `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus               SetMultiVMSyncStatus                    `json:"multiVmSyncStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for InMagePolicyInput.
func (impi InMagePolicyInput) MarshalJSON() ([]byte, error) {
	impi.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeInMage
	type Alias InMagePolicyInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(impi),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return &impi, true
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for InMagePolicyInput.
func (impi InMagePolicyInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return nil, false
}

// InMageProtectedDiskDetails is inMage protected disk details.
type InMageProtectedDiskDetails struct {
	DiskID                    *string    `json:"diskId,omitempty"`
	DiskName                  *string    `json:"diskName,omitempty"`
	ProtectionStage           *string    `json:"protectionStage,omitempty"`
	HealthErrorCode           *string    `json:"healthErrorCode,omitempty"`
	RpoInSeconds              *int64     `json:"rpoInSeconds,omitempty"`
	ResyncRequired            *string    `json:"resyncRequired,omitempty"`
	ResyncProgressPercentage  *int32     `json:"resyncProgressPercentage,omitempty"`
	ResyncDurationInSeconds   *int64     `json:"resyncDurationInSeconds,omitempty"`
	DiskCapacityInBytes       *int64     `json:"diskCapacityInBytes,omitempty"`
	FileSystemCapacityInBytes *int64     `json:"fileSystemCapacityInBytes,omitempty"`
	SourceDataInMB            *float64   `json:"sourceDataInMB,omitempty"`
	PsDataInMB                *float64   `json:"psDataInMB,omitempty"`
	TargetDataInMB            *float64   `json:"targetDataInMB,omitempty"`
	DiskResized               *string    `json:"diskResized,omitempty"`
	LastRpoCalculatedTime     *date.Time `json:"lastRpoCalculatedTime,omitempty"`
}

// InMageReplicationDetails is inMage provider specific settings
type InMageReplicationDetails struct {
	InstanceType                 InstanceTypeReplicationProviderSpecificSettings `json:"instanceType,omitempty"`
	ActiveSiteType               *string                                         `json:"activeSiteType,omitempty"`
	SourceVMCPUCount             *int32                                          `json:"sourceVmCPUCount,omitempty"`
	SourceVMRAMSizeInMB          *int32                                          `json:"sourceVmRAMSizeInMB,omitempty"`
	OsDetails                    *OSDiskDetails                                  `json:"osDetails,omitempty"`
	ProtectionStage              *string                                         `json:"protectionStage,omitempty"`
	VMID                         *string                                         `json:"vmId,omitempty"`
	VMProtectionState            *string                                         `json:"vmProtectionState,omitempty"`
	VMProtectionStateDescription *string                                         `json:"vmProtectionStateDescription,omitempty"`
	ResyncDetails                *InitialReplicationDetails                      `json:"resyncDetails,omitempty"`
	RetentionWindowStart         *date.Time                                      `json:"retentionWindowStart,omitempty"`
	RetentionWindowEnd           *date.Time                                      `json:"retentionWindowEnd,omitempty"`
	CompressedDataRateInMB       *float64                                        `json:"compressedDataRateInMB,omitempty"`
	UncompressedDataRateInMB     *float64                                        `json:"uncompressedDataRateInMB,omitempty"`
	RpoInSeconds                 *int64                                          `json:"rpoInSeconds,omitempty"`
	ProtectedDisks               *[]InMageProtectedDiskDetails                   `json:"protectedDisks,omitempty"`
	IPAddress                    *string                                         `json:"ipAddress,omitempty"`
	LastHeartbeat                *date.Time                                      `json:"lastHeartbeat,omitempty"`
	ProcessServerID              *string                                         `json:"processServerId,omitempty"`
	MasterTargetID               *string                                         `json:"masterTargetId,omitempty"`
	ConsistencyPoints            *map[string]*date.Time                          `json:"consistencyPoints,omitempty"`
	DiskResized                  *string                                         `json:"diskResized,omitempty"`
	RebootAfterUpdateStatus      *string                                         `json:"rebootAfterUpdateStatus,omitempty"`
	MultiVMGroupID               *string                                         `json:"multiVmGroupId,omitempty"`
	MultiVMGroupName             *string                                         `json:"multiVmGroupName,omitempty"`
	MultiVMSyncStatus            *string                                         `json:"multiVmSyncStatus,omitempty"`
	AgentDetails                 *InMageAgentDetails                             `json:"agentDetails,omitempty"`
	VCenterInfrastructureID      *string                                         `json:"vCenterInfrastructureId,omitempty"`
	InfrastructureVMID           *string                                         `json:"infrastructureVmId,omitempty"`
	VMNics                       *[]VMNicDetails                                 `json:"vmNics,omitempty"`
	DiscoveryType                *string                                         `json:"discoveryType,omitempty"`
	AzureStorageAccountID        *string                                         `json:"azureStorageAccountId,omitempty"`
	Datastores                   *[]string                                       `json:"datastores,omitempty"`
	ValidationErrors             *[]HealthError                                  `json:"validationErrors,omitempty"`
	LastRpoCalculatedTime        *date.Time                                      `json:"lastRpoCalculatedTime,omitempty"`
	LastUpdateReceivedTime       *date.Time                                      `json:"lastUpdateReceivedTime,omitempty"`
	ReplicaID                    *string                                         `json:"replicaId,omitempty"`
	OsVersion                    *string                                         `json:"osVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReplicationDetails.
func (imrd InMageReplicationDetails) MarshalJSON() ([]byte, error) {
	imrd.InstanceType = InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMage
	type Alias InMageReplicationDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imrd),
	})
}

// AsHyperVReplicaBaseReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBlueReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool) {
	return nil, false
}

// AsHyperVReplicaAzureReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool) {
	return nil, false
}

// AsInMageAzureV2ReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool) {
	return nil, false
}

// AsInMageReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsInMageReplicationDetails() (*InMageReplicationDetails, bool) {
	return &imrd, true
}

// AsA2AReplicationDetails is the ReplicationProviderSpecificSettings implementation for InMageReplicationDetails.
func (imrd InMageReplicationDetails) AsA2AReplicationDetails() (*A2AReplicationDetails, bool) {
	return nil, false
}

// InMageReprotectInput is inMageAzureV2 specific provider input.
type InMageReprotectInput struct {
	InstanceType       InstanceTypeReverseReplicationProviderSpecificInput `json:"instanceType,omitempty"`
	MasterTargetID     *string                                             `json:"masterTargetId,omitempty"`
	ProcessServerID    *string                                             `json:"processServerId,omitempty"`
	RetentionDrive     *string                                             `json:"retentionDrive,omitempty"`
	RunAsAccountID     *string                                             `json:"runAsAccountId,omitempty"`
	DatastoreName      *string                                             `json:"datastoreName,omitempty"`
	DiskExclusionInput *InMageDiskExclusionInput                           `json:"diskExclusionInput,omitempty"`
	ProfileID          *string                                             `json:"profileId,omitempty"`
	DisksToInclude     *[]string                                           `json:"disksToInclude,omitempty"`
}

// MarshalJSON is the custom marshaler for InMageReprotectInput.
func (imri InMageReprotectInput) MarshalJSON() ([]byte, error) {
	imri.InstanceType = InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMage
	type Alias InMageReprotectInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(imri),
	})
}

// AsHyperVReplicaAzureReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool) {
	return nil, false
}

// AsInMageAzureV2ReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool) {
	return nil, false
}

// AsInMageReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsInMageReprotectInput() (*InMageReprotectInput, bool) {
	return &imri, true
}

// AsA2AReprotectInput is the ReverseReplicationProviderSpecificInput implementation for InMageReprotectInput.
func (imri InMageReprotectInput) AsA2AReprotectInput() (*A2AReprotectInput, bool) {
	return nil, false
}

// InMageVolumeExclusionOptions is guest disk signature based disk exclusion option when doing enable protection of
// virtual machine in InMage provider.
type InMageVolumeExclusionOptions struct {
	VolumeLabel               *string `json:"volumeLabel,omitempty"`
	OnlyExcludeIfSingleVolume *string `json:"OnlyExcludeIfSingleVolume,omitempty"`
}

// InputEndpoint is azure VM input endpoint details.
type InputEndpoint struct {
	EndpointName *string `json:"endpointName,omitempty"`
	PrivatePort  *int32  `json:"privatePort,omitempty"`
	PublicPort   *int32  `json:"publicPort,omitempty"`
	Protocol     *string `json:"protocol,omitempty"`
}

// Job is job details.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string        `json:"id,omitempty"`
	Name              *string        `json:"name,omitempty"`
	Type              *string        `json:"type,omitempty"`
	Location          *string        `json:"location,omitempty"`
	Properties        *JobProperties `json:"properties,omitempty"`
	Status            *string        `json:"status,omitempty"`
	Error             *ARMException  `json:"error,omitempty"`
	StartTime         *string        `json:"startTime,omitempty"`
	EndTime           *string        `json:"endTime,omitempty"`
}

// JobCollection is collection of jobs.
type JobCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Job  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// JobCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobCollection) JobCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobDetails is job details based on specific job type.
type JobDetails interface {
	AsAsrJobDetails() (*AsrJobDetails, bool)
	AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool)
	AsFailoverJobDetails() (*FailoverJobDetails, bool)
	AsExportJobDetails() (*ExportJobDetails, bool)
	AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool)
}

func unmarshalJobDetails(body []byte) (JobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeAsrJobDetails):
		var ajd AsrJobDetails
		err := json.Unmarshal(body, &ajd)
		return ajd, err
	case string(InstanceTypeTestFailoverJobDetails):
		var tfjd TestFailoverJobDetails
		err := json.Unmarshal(body, &tfjd)
		return tfjd, err
	case string(InstanceTypeFailoverJobDetails):
		var fjd FailoverJobDetails
		err := json.Unmarshal(body, &fjd)
		return fjd, err
	case string(InstanceTypeExportJobDetails):
		var ejd ExportJobDetails
		err := json.Unmarshal(body, &ejd)
		return ejd, err
	case string(InstanceTypeSwitchProtectionJobDetails):
		var spjd SwitchProtectionJobDetails
		err := json.Unmarshal(body, &spjd)
		return spjd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalJobDetailsArray(body []byte) ([]JobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]JobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// JobEntity is this class contains the minimal job details required to navigate to the desired drill down.
type JobEntity struct {
	JobID              *string `json:"jobId,omitempty"`
	JobFriendlyName    *string `json:"jobFriendlyName,omitempty"`
	TargetObjectID     *string `json:"targetObjectId,omitempty"`
	TargetObjectName   *string `json:"targetObjectName,omitempty"`
	TargetInstanceType *string `json:"targetInstanceType,omitempty"`
	JobScenarioName    *string `json:"jobScenarioName,omitempty"`
}

// JobErrorDetails is this class contains the error details per object.
type JobErrorDetails struct {
	ServiceErrorDetails  *ServiceError  `json:"serviceErrorDetails,omitempty"`
	ProviderErrorDetails *ProviderError `json:"providerErrorDetails,omitempty"`
	ErrorLevel           *string        `json:"errorLevel,omitempty"`
	CreationTime         *date.Time     `json:"creationTime,omitempty"`
	TaskID               *string        `json:"taskId,omitempty"`
}

// JobProperties is job custom data details.
type JobProperties struct {
	ActivityID         *string            `json:"activityId,omitempty"`
	ScenarioName       *string            `json:"scenarioName,omitempty"`
	FriendlyName       *string            `json:"friendlyName,omitempty"`
	State              *string            `json:"state,omitempty"`
	StateDescription   *string            `json:"stateDescription,omitempty"`
	Tasks              *[]ASRTask         `json:"tasks,omitempty"`
	Errors             *[]JobErrorDetails `json:"errors,omitempty"`
	StartTime          *date.Time         `json:"startTime,omitempty"`
	EndTime            *date.Time         `json:"endTime,omitempty"`
	AllowedActions     *[]string          `json:"allowedActions,omitempty"`
	TargetObjectID     *string            `json:"targetObjectId,omitempty"`
	TargetObjectName   *string            `json:"targetObjectName,omitempty"`
	TargetInstanceType *string            `json:"targetInstanceType,omitempty"`
	CustomDetails      JobDetails         `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["activityId"]
	if v != nil {
		var activityID string
		err = json.Unmarshal(*m["activityId"], &activityID)
		if err != nil {
			return err
		}
		jp.ActivityID = &activityID
	}

	v = m["scenarioName"]
	if v != nil {
		var scenarioName string
		err = json.Unmarshal(*m["scenarioName"], &scenarioName)
		if err != nil {
			return err
		}
		jp.ScenarioName = &scenarioName
	}

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		jp.FriendlyName = &friendlyName
	}

	v = m["state"]
	if v != nil {
		var state string
		err = json.Unmarshal(*m["state"], &state)
		if err != nil {
			return err
		}
		jp.State = &state
	}

	v = m["stateDescription"]
	if v != nil {
		var stateDescription string
		err = json.Unmarshal(*m["stateDescription"], &stateDescription)
		if err != nil {
			return err
		}
		jp.StateDescription = &stateDescription
	}

	v = m["tasks"]
	if v != nil {
		var tasks []ASRTask
		err = json.Unmarshal(*m["tasks"], &tasks)
		if err != nil {
			return err
		}
		jp.Tasks = &tasks
	}

	v = m["errors"]
	if v != nil {
		var errorsVar []JobErrorDetails
		err = json.Unmarshal(*m["errors"], &errorsVar)
		if err != nil {
			return err
		}
		jp.Errors = &errorsVar
	}

	v = m["startTime"]
	if v != nil {
		var startTime date.Time
		err = json.Unmarshal(*m["startTime"], &startTime)
		if err != nil {
			return err
		}
		jp.StartTime = &startTime
	}

	v = m["endTime"]
	if v != nil {
		var endTime date.Time
		err = json.Unmarshal(*m["endTime"], &endTime)
		if err != nil {
			return err
		}
		jp.EndTime = &endTime
	}

	v = m["allowedActions"]
	if v != nil {
		var allowedActions []string
		err = json.Unmarshal(*m["allowedActions"], &allowedActions)
		if err != nil {
			return err
		}
		jp.AllowedActions = &allowedActions
	}

	v = m["targetObjectId"]
	if v != nil {
		var targetObjectID string
		err = json.Unmarshal(*m["targetObjectId"], &targetObjectID)
		if err != nil {
			return err
		}
		jp.TargetObjectID = &targetObjectID
	}

	v = m["targetObjectName"]
	if v != nil {
		var targetObjectName string
		err = json.Unmarshal(*m["targetObjectName"], &targetObjectName)
		if err != nil {
			return err
		}
		jp.TargetObjectName = &targetObjectName
	}

	v = m["targetInstanceType"]
	if v != nil {
		var targetInstanceType string
		err = json.Unmarshal(*m["targetInstanceType"], &targetInstanceType)
		if err != nil {
			return err
		}
		jp.TargetInstanceType = &targetInstanceType
	}

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalJobDetails(*m["customDetails"])
		if err != nil {
			return err
		}
		jp.CustomDetails = customDetails
	}

	return nil
}

// JobQueryParameter is query parameter to enumerate jobs.
type JobQueryParameter struct {
	StartTime           *string   `json:"startTime,omitempty"`
	EndTime             *string   `json:"endTime,omitempty"`
	FabricID            *string   `json:"fabricId,omitempty"`
	AffectedObjectTypes *[]string `json:"affectedObjectTypes,omitempty"`
	JobStatus           *[]string `json:"jobStatus,omitempty"`
}

// JobStatusEventDetails is model class for event details of a job status event.
type JobStatusEventDetails struct {
	InstanceType       InstanceTypeEventSpecificDetails `json:"instanceType,omitempty"`
	JobID              *string                          `json:"jobId,omitempty"`
	JobFriendlyName    *string                          `json:"jobFriendlyName,omitempty"`
	JobStatus          *string                          `json:"jobStatus,omitempty"`
	AffectedObjectType *string                          `json:"affectedObjectType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStatusEventDetails.
func (jsed JobStatusEventDetails) MarshalJSON() ([]byte, error) {
	jsed.InstanceType = InstanceTypeJobStatus
	type Alias JobStatusEventDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(jsed),
	})
}

// AsJobStatusEventDetails is the EventSpecificDetails implementation for JobStatusEventDetails.
func (jsed JobStatusEventDetails) AsJobStatusEventDetails() (*JobStatusEventDetails, bool) {
	return &jsed, true
}

// JobTaskDetails is this class represents a task which is actually a workflow so that one can navigate to its
// individual drill down.
type JobTaskDetails struct {
	InstanceType InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	JobTask      *JobEntity                  `json:"jobTask,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTaskDetails.
func (jtd JobTaskDetails) MarshalJSON() ([]byte, error) {
	jtd.InstanceType = InstanceTypeJobTaskDetails
	type Alias JobTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(jtd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return &jtd, true
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for JobTaskDetails.
func (jtd JobTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// LogicalNetwork is logical network data model.
type LogicalNetwork struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Properties        *LogicalNetworkProperties `json:"properties,omitempty"`
}

// LogicalNetworkCollection is list of logical networks.
type LogicalNetworkCollection struct {
	autorest.Response `json:"-"`
	Value             *[]LogicalNetwork `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// LogicalNetworkCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LogicalNetworkCollection) LogicalNetworkCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LogicalNetworkProperties is logical Network Properties.
type LogicalNetworkProperties struct {
	FriendlyName                    *string `json:"friendlyName,omitempty"`
	NetworkVirtualizationStatus     *string `json:"networkVirtualizationStatus,omitempty"`
	LogicalNetworkUsage             *string `json:"logicalNetworkUsage,omitempty"`
	LogicalNetworkDefinitionsStatus *string `json:"logicalNetworkDefinitionsStatus,omitempty"`
}

// ManualActionTaskDetails is this class represents the manual action task details.
type ManualActionTaskDetails struct {
	InstanceType InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	Name         *string                     `json:"name,omitempty"`
	Instructions *string                     `json:"instructions,omitempty"`
	Observation  *string                     `json:"observation,omitempty"`
}

// MarshalJSON is the custom marshaler for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) MarshalJSON() ([]byte, error) {
	matd.InstanceType = InstanceTypeManualActionTaskDetails
	type Alias ManualActionTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(matd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return &matd, true
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for ManualActionTaskDetails.
func (matd ManualActionTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// MasterTargetServer is details of a Master Target Server.
type MasterTargetServer struct {
	ID               *string            `json:"id,omitempty"`
	IPAddress        *string            `json:"ipAddress,omitempty"`
	Name             *string            `json:"name,omitempty"`
	OsType           *string            `json:"osType,omitempty"`
	AgentVersion     *string            `json:"agentVersion,omitempty"`
	LastHeartbeat    *date.Time         `json:"lastHeartbeat,omitempty"`
	VersionStatus    *string            `json:"versionStatus,omitempty"`
	RetentionVolumes *[]RetentionVolume `json:"retentionVolumes,omitempty"`
	DataStores       *[]DataStore       `json:"dataStores,omitempty"`
	ValidationErrors *[]HealthError     `json:"validationErrors,omitempty"`
	DiskCount        *int32             `json:"diskCount,omitempty"`
	OsVersion        *string            `json:"osVersion,omitempty"`
}

// MethodCallStatus is reports method status where exception was raised.
type MethodCallStatus struct {
	IsVirtual                 *string   `json:"isVirtual,omitempty"`
	Parameters                *[]string `json:"parameters,omitempty"`
	ContainsGenericParameters *string   `json:"containsGenericParameters,omitempty"`
}

// MobilityServiceUpdate is the Mobility Service update details.
type MobilityServiceUpdate struct {
	Version      *string `json:"version,omitempty"`
	RebootStatus *string `json:"rebootStatus,omitempty"`
	OsType       *string `json:"osType,omitempty"`
}

// Network is network model.
type Network struct {
	autorest.Response `json:"-"`
	ID                *string            `json:"id,omitempty"`
	Name              *string            `json:"name,omitempty"`
	Type              *string            `json:"type,omitempty"`
	Location          *string            `json:"location,omitempty"`
	Properties        *NetworkProperties `json:"properties,omitempty"`
}

// NetworkCollection is list of networks.
type NetworkCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Network `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// NetworkCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NetworkCollection) NetworkCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NetworkMapping is network Mapping model. Ideally it should have been possible to inherit this class from prev
// version in InheritedModels as long as there is no difference in structure or method signature. Since there were no
// base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the
// class has been introduced in its entirety with references to base models to facilitate exensions in subsequent
// versions.
type NetworkMapping struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Properties        *NetworkMappingProperties `json:"properties,omitempty"`
}

// NetworkMappingCollection is list of network mappings. As with NetworkMapping, it should be possible to reuse a prev
// version of this class. It doesn't seem likely this class could be anything more than a slightly bespoke collection
// of NetworkMapping. Hence it makes sense to override Load with Base.NetworkMapping instead of existing
// CurrentVersion.NetworkMapping.
type NetworkMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]NetworkMapping `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// NetworkMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NetworkMappingCollection) NetworkMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NetworkMappingFabricSpecificSettings is network Mapping fabric specific settings.
type NetworkMappingFabricSpecificSettings interface {
	AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool)
	AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool)
	AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool)
}

func unmarshalNetworkMappingFabricSpecificSettings(body []byte) (NetworkMappingFabricSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure):
		var atanms AzureToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &atanms)
		return atanms, err
	case string(InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure):
		var vtanms VmmToAzureNetworkMappingSettings
		err := json.Unmarshal(body, &vtanms)
		return vtanms, err
	case string(InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm):
		var vtvnms VmmToVmmNetworkMappingSettings
		err := json.Unmarshal(body, &vtvnms)
		return vtvnms, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalNetworkMappingFabricSpecificSettingsArray(body []byte) ([]NetworkMappingFabricSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	nmfssArray := make([]NetworkMappingFabricSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		nmfss, err := unmarshalNetworkMappingFabricSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		nmfssArray[index] = nmfss
	}
	return nmfssArray, nil
}

// NetworkMappingProperties is network Mapping Properties.
type NetworkMappingProperties struct {
	State                       *string                              `json:"state,omitempty"`
	PrimaryNetworkFriendlyName  *string                              `json:"primaryNetworkFriendlyName,omitempty"`
	PrimaryNetworkID            *string                              `json:"primaryNetworkId,omitempty"`
	PrimaryFabricFriendlyName   *string                              `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryNetworkFriendlyName *string                              `json:"recoveryNetworkFriendlyName,omitempty"`
	RecoveryNetworkID           *string                              `json:"recoveryNetworkId,omitempty"`
	RecoveryFabricArmID         *string                              `json:"recoveryFabricArmId,omitempty"`
	RecoveryFabricFriendlyName  *string                              `json:"recoveryFabricFriendlyName,omitempty"`
	FabricSpecificSettings      NetworkMappingFabricSpecificSettings `json:"fabricSpecificSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for NetworkMappingProperties struct.
func (nmp *NetworkMappingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["state"]
	if v != nil {
		var state string
		err = json.Unmarshal(*m["state"], &state)
		if err != nil {
			return err
		}
		nmp.State = &state
	}

	v = m["primaryNetworkFriendlyName"]
	if v != nil {
		var primaryNetworkFriendlyName string
		err = json.Unmarshal(*m["primaryNetworkFriendlyName"], &primaryNetworkFriendlyName)
		if err != nil {
			return err
		}
		nmp.PrimaryNetworkFriendlyName = &primaryNetworkFriendlyName
	}

	v = m["primaryNetworkId"]
	if v != nil {
		var primaryNetworkID string
		err = json.Unmarshal(*m["primaryNetworkId"], &primaryNetworkID)
		if err != nil {
			return err
		}
		nmp.PrimaryNetworkID = &primaryNetworkID
	}

	v = m["primaryFabricFriendlyName"]
	if v != nil {
		var primaryFabricFriendlyName string
		err = json.Unmarshal(*m["primaryFabricFriendlyName"], &primaryFabricFriendlyName)
		if err != nil {
			return err
		}
		nmp.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
	}

	v = m["recoveryNetworkFriendlyName"]
	if v != nil {
		var recoveryNetworkFriendlyName string
		err = json.Unmarshal(*m["recoveryNetworkFriendlyName"], &recoveryNetworkFriendlyName)
		if err != nil {
			return err
		}
		nmp.RecoveryNetworkFriendlyName = &recoveryNetworkFriendlyName
	}

	v = m["recoveryNetworkId"]
	if v != nil {
		var recoveryNetworkID string
		err = json.Unmarshal(*m["recoveryNetworkId"], &recoveryNetworkID)
		if err != nil {
			return err
		}
		nmp.RecoveryNetworkID = &recoveryNetworkID
	}

	v = m["recoveryFabricArmId"]
	if v != nil {
		var recoveryFabricArmID string
		err = json.Unmarshal(*m["recoveryFabricArmId"], &recoveryFabricArmID)
		if err != nil {
			return err
		}
		nmp.RecoveryFabricArmID = &recoveryFabricArmID
	}

	v = m["recoveryFabricFriendlyName"]
	if v != nil {
		var recoveryFabricFriendlyName string
		err = json.Unmarshal(*m["recoveryFabricFriendlyName"], &recoveryFabricFriendlyName)
		if err != nil {
			return err
		}
		nmp.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
	}

	v = m["fabricSpecificSettings"]
	if v != nil {
		fabricSpecificSettings, err := unmarshalNetworkMappingFabricSpecificSettings(*m["fabricSpecificSettings"])
		if err != nil {
			return err
		}
		nmp.FabricSpecificSettings = fabricSpecificSettings
	}

	return nil
}

// NetworkProperties is network Properties
type NetworkProperties struct {
	FabricType   *string   `json:"fabricType,omitempty"`
	Subnets      *[]Subnet `json:"subnets,omitempty"`
	FriendlyName *string   `json:"friendlyName,omitempty"`
	NetworkType  *string   `json:"networkType,omitempty"`
}

// OperationsDiscovery is operations discovery class.
type OperationsDiscovery struct {
	Name       *string                 `json:"name,omitempty"`
	Display    *Display                `json:"display,omitempty"`
	Origin     *string                 `json:"origin,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection is collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	autorest.Response `json:"-"`
	Value             *[]OperationsDiscovery `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// OperationsDiscoveryCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationsDiscoveryCollection) OperationsDiscoveryCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OSDetails is disk Details.
type OSDetails struct {
	OsType         *string `json:"osType,omitempty"`
	ProductType    *string `json:"productType,omitempty"`
	OsEdition      *string `json:"osEdition,omitempty"`
	OSVersion      *string `json:"oSVersion,omitempty"`
	OSMajorVersion *string `json:"oSMajorVersion,omitempty"`
	OSMinorVersion *string `json:"oSMinorVersion,omitempty"`
}

// OSDiskDetails is details of the OS Disk.
type OSDiskDetails struct {
	OsVhdID *string `json:"osVhdId,omitempty"`
	OsType  *string `json:"osType,omitempty"`
	VhdName *string `json:"vhdName,omitempty"`
}

// PlannedFailoverInput is input definition for planned failover.
type PlannedFailoverInput struct {
	Properties *PlannedFailoverInputProperties `json:"properties,omitempty"`
}

// PlannedFailoverInputProperties is input definition for planned failover input properties.
type PlannedFailoverInputProperties struct {
	FailoverDirection       *string                       `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PlannedFailoverInputProperties struct.
func (pfip *PlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection string
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		pfip.FailoverDirection = &failoverDirection
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalProviderSpecificFailoverInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		pfip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// Policy is protection profile details.
type Policy struct {
	autorest.Response `json:"-"`
	ID                *string           `json:"id,omitempty"`
	Name              *string           `json:"name,omitempty"`
	Type              *string           `json:"type,omitempty"`
	Location          *string           `json:"location,omitempty"`
	Properties        *PolicyProperties `json:"properties,omitempty"`
}

// PolicyCollection is protection Profile Collection details.
type PolicyCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Policy `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// PolicyCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PolicyCollection) PolicyCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PolicyProperties is protection profile custom data details.
type PolicyProperties struct {
	FriendlyName            *string                       `json:"friendlyName,omitempty"`
	ProviderSpecificDetails PolicyProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for PolicyProperties struct.
func (pp *PolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		pp.FriendlyName = &friendlyName
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalPolicyProviderSpecificDetails(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		pp.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// PolicyProviderSpecificDetails is base class for Provider specific details for policies.
type PolicyProviderSpecificDetails interface {
	AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool)
	AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool)
	AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool)
	AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool)
	AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool)
	AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool)
	AsInMagePolicyDetails() (*InMagePolicyDetails, bool)
	AsA2APolicyDetails() (*A2APolicyDetails, bool)
	AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool)
	AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool)
}

func unmarshalPolicyProviderSpecificDetails(body []byte) (PolicyProviderSpecificDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure):
		var hvrapd HyperVReplicaAzurePolicyDetails
		err := json.Unmarshal(body, &hvrapd)
		return hvrapd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails):
		var hvrbpd HyperVReplicaBasePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012):
		var hvrpd HyperVReplicaPolicyDetails
		err := json.Unmarshal(body, &hvrpd)
		return hvrpd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2):
		var hvrbpd HyperVReplicaBluePolicyDetails
		err := json.Unmarshal(body, &hvrbpd)
		return hvrbpd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails):
		var imbpd InMageBasePolicyDetails
		err := json.Unmarshal(body, &imbpd)
		return imbpd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMageAzureV2):
		var imavpd InMageAzureV2PolicyDetails
		err := json.Unmarshal(body, &imavpd)
		return imavpd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeInMage):
		var impd InMagePolicyDetails
		err := json.Unmarshal(body, &impd)
		return impd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeA2A):
		var apd A2APolicyDetails
		err := json.Unmarshal(body, &apd)
		return apd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration):
		var rampd RcmAzureMigrationPolicyDetails
		err := json.Unmarshal(body, &rampd)
		return rampd, err
	case string(InstanceTypePolicyProviderSpecificDetailsInstanceTypeVMwareCbt):
		var vcpd VmwareCbtPolicyDetails
		err := json.Unmarshal(body, &vcpd)
		return vcpd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalPolicyProviderSpecificDetailsArray(body []byte) ([]PolicyProviderSpecificDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsdArray := make([]PolicyProviderSpecificDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsd, err := unmarshalPolicyProviderSpecificDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsdArray[index] = ppsd
	}
	return ppsdArray, nil
}

// PolicyProviderSpecificInput is base class for provider specific input
type PolicyProviderSpecificInput interface {
	AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool)
	AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool)
	AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool)
	AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool)
	AsInMagePolicyInput() (*InMagePolicyInput, bool)
	AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool)
	AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool)
}

func unmarshalPolicyProviderSpecificInput(body []byte) (PolicyProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvrapi HyperVReplicaAzurePolicyInput
		err := json.Unmarshal(body, &hvrapi)
		return hvrapi, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012):
		var hvrpi HyperVReplicaPolicyInput
		err := json.Unmarshal(body, &hvrpi)
		return hvrpi, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2):
		var hvrbpi HyperVReplicaBluePolicyInput
		err := json.Unmarshal(body, &hvrbpi)
		return hvrbpi, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavpi InMageAzureV2PolicyInput
		err := json.Unmarshal(body, &imavpi)
		return imavpi, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeInMage):
		var impi InMagePolicyInput
		err := json.Unmarshal(body, &impi)
		return impi, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeA2A):
		var apci A2APolicyCreationInput
		err := json.Unmarshal(body, &apci)
		return apci, err
	case string(InstanceTypePolicyProviderSpecificInputInstanceTypeVMwareCbt):
		var vmcpci VMwareCbtPolicyCreationInput
		err := json.Unmarshal(body, &vmcpci)
		return vmcpci, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalPolicyProviderSpecificInputArray(body []byte) ([]PolicyProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppsiArray := make([]PolicyProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ppsi, err := unmarshalPolicyProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppsiArray[index] = ppsi
	}
	return ppsiArray, nil
}

// ProcessServer is details of the Process Server.
type ProcessServer struct {
	FriendlyName               *string                  `json:"friendlyName,omitempty"`
	ID                         *string                  `json:"id,omitempty"`
	IPAddress                  *string                  `json:"ipAddress,omitempty"`
	OsType                     *string                  `json:"osType,omitempty"`
	AgentVersion               *string                  `json:"agentVersion,omitempty"`
	LastHeartbeat              *date.Time               `json:"lastHeartbeat,omitempty"`
	VersionStatus              *string                  `json:"versionStatus,omitempty"`
	MobilityServiceUpdates     *[]MobilityServiceUpdate `json:"mobilityServiceUpdates,omitempty"`
	HostID                     *string                  `json:"hostId,omitempty"`
	MachineCount               *string                  `json:"machineCount,omitempty"`
	ReplicationPairCount       *string                  `json:"replicationPairCount,omitempty"`
	SystemLoad                 *string                  `json:"systemLoad,omitempty"`
	SystemLoadStatus           *string                  `json:"systemLoadStatus,omitempty"`
	CPULoad                    *string                  `json:"cpuLoad,omitempty"`
	CPULoadStatus              *string                  `json:"cpuLoadStatus,omitempty"`
	TotalMemoryInBytes         *int64                   `json:"totalMemoryInBytes,omitempty"`
	AvailableMemoryInBytes     *int64                   `json:"availableMemoryInBytes,omitempty"`
	MemoryUsageStatus          *string                  `json:"memoryUsageStatus,omitempty"`
	TotalSpaceInBytes          *int64                   `json:"totalSpaceInBytes,omitempty"`
	AvailableSpaceInBytes      *int64                   `json:"availableSpaceInBytes,omitempty"`
	SpaceUsageStatus           *string                  `json:"spaceUsageStatus,omitempty"`
	PsServiceStatus            *string                  `json:"psServiceStatus,omitempty"`
	SslCertExpiryDate          *date.Time               `json:"sslCertExpiryDate,omitempty"`
	SslCertExpiryRemainingDays *int32                   `json:"sslCertExpiryRemainingDays,omitempty"`
	OsVersion                  *string                  `json:"osVersion,omitempty"`
}

// ProtectableItem is replication protected item
type ProtectableItem struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Properties        *ProtectableItemProperties `json:"properties,omitempty"`
}

// ProtectableItemCollection is protectable item collection.
type ProtectableItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectableItem `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// ProtectableItemCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectableItemCollection) ProtectableItemCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectableItemProperties is replication protected item custom data details.
type ProtectableItemProperties struct {
	FriendlyName                  *string               `json:"friendlyName,omitempty"`
	ProtectionStatus              *string               `json:"protectionStatus,omitempty"`
	ReplicationProtectedItemID    *string               `json:"replicationProtectedItemId,omitempty"`
	RecoveryServicesProviderID    *string               `json:"recoveryServicesProviderId,omitempty"`
	ProtectionReadinessErrors     *[]string             `json:"protectionReadinessErrors,omitempty"`
	SupportedReplicationProviders *[]string             `json:"supportedReplicationProviders,omitempty"`
	CustomDetails                 ConfigurationSettings `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ProtectableItemProperties struct.
func (pip *ProtectableItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		pip.FriendlyName = &friendlyName
	}

	v = m["protectionStatus"]
	if v != nil {
		var protectionStatus string
		err = json.Unmarshal(*m["protectionStatus"], &protectionStatus)
		if err != nil {
			return err
		}
		pip.ProtectionStatus = &protectionStatus
	}

	v = m["replicationProtectedItemId"]
	if v != nil {
		var replicationProtectedItemID string
		err = json.Unmarshal(*m["replicationProtectedItemId"], &replicationProtectedItemID)
		if err != nil {
			return err
		}
		pip.ReplicationProtectedItemID = &replicationProtectedItemID
	}

	v = m["recoveryServicesProviderId"]
	if v != nil {
		var recoveryServicesProviderID string
		err = json.Unmarshal(*m["recoveryServicesProviderId"], &recoveryServicesProviderID)
		if err != nil {
			return err
		}
		pip.RecoveryServicesProviderID = &recoveryServicesProviderID
	}

	v = m["protectionReadinessErrors"]
	if v != nil {
		var protectionReadinessErrors []string
		err = json.Unmarshal(*m["protectionReadinessErrors"], &protectionReadinessErrors)
		if err != nil {
			return err
		}
		pip.ProtectionReadinessErrors = &protectionReadinessErrors
	}

	v = m["supportedReplicationProviders"]
	if v != nil {
		var supportedReplicationProviders []string
		err = json.Unmarshal(*m["supportedReplicationProviders"], &supportedReplicationProviders)
		if err != nil {
			return err
		}
		pip.SupportedReplicationProviders = &supportedReplicationProviders
	}

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalConfigurationSettings(*m["customDetails"])
		if err != nil {
			return err
		}
		pip.CustomDetails = customDetails
	}

	return nil
}

// ProtectedItemsQueryParameter is query parameter to enumerate protected items.
type ProtectedItemsQueryParameter struct {
	SourceFabricName *string `json:"sourceFabricName,omitempty"`
	RecoveryPlanName *string `json:"recoveryPlanName,omitempty"`
	VCenterName      *string `json:"vCenterName,omitempty"`
}

// ProtectionContainer is protection container details.
type ProtectionContainer struct {
	autorest.Response `json:"-"`
	ID                *string                        `json:"id,omitempty"`
	Name              *string                        `json:"name,omitempty"`
	Type              *string                        `json:"type,omitempty"`
	Location          *string                        `json:"location,omitempty"`
	Properties        *ProtectionContainerProperties `json:"properties,omitempty"`
}

// ProtectionContainerCollection is protection Container collection.
type ProtectionContainerCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectionContainer `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ProtectionContainerCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionContainerCollection) ProtectionContainerCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionContainerFabricSpecificDetails is base class for fabric specific details of container.
type ProtectionContainerFabricSpecificDetails struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerMapping is protection container mapping object.
type ProtectionContainerMapping struct {
	autorest.Response `json:"-"`
	ID                *string                               `json:"id,omitempty"`
	Name              *string                               `json:"name,omitempty"`
	Type              *string                               `json:"type,omitempty"`
	Location          *string                               `json:"location,omitempty"`
	Properties        *ProtectionContainerMappingProperties `json:"properties,omitempty"`
}

// ProtectionContainerMappingCollection is protection container mapping collection class.
type ProtectionContainerMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ProtectionContainerMapping `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// ProtectionContainerMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProtectionContainerMappingCollection) ProtectionContainerMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProtectionContainerMappingProperties is protection container mapping properties.
type ProtectionContainerMappingProperties struct {
	TargetProtectionContainerID           *string                                            `json:"targetProtectionContainerId,omitempty"`
	TargetProtectionContainerFriendlyName *string                                            `json:"targetProtectionContainerFriendlyName,omitempty"`
	ProviderSpecificDetails               *ProtectionContainerMappingProviderSpecificDetails `json:"providerSpecificDetails,omitempty"`
	Health                                *string                                            `json:"health,omitempty"`
	HealthErrorDetails                    *[]HealthError                                     `json:"healthErrorDetails,omitempty"`
	PolicyID                              *string                                            `json:"policyId,omitempty"`
	State                                 *string                                            `json:"state,omitempty"`
	SourceProtectionContainerFriendlyName *string                                            `json:"sourceProtectionContainerFriendlyName,omitempty"`
	SourceFabricFriendlyName              *string                                            `json:"sourceFabricFriendlyName,omitempty"`
	TargetFabricFriendlyName              *string                                            `json:"targetFabricFriendlyName,omitempty"`
	PolicyFriendlyName                    *string                                            `json:"policyFriendlyName,omitempty"`
}

// ProtectionContainerMappingProviderSpecificDetails is container mapping provider specific details.
type ProtectionContainerMappingProviderSpecificDetails struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ProtectionContainerProperties is protection profile custom data details.
type ProtectionContainerProperties struct {
	FabricFriendlyName    *string                                   `json:"fabricFriendlyName,omitempty"`
	FriendlyName          *string                                   `json:"friendlyName,omitempty"`
	FabricType            *string                                   `json:"fabricType,omitempty"`
	ProtectedItemCount    *int32                                    `json:"protectedItemCount,omitempty"`
	PairingStatus         *string                                   `json:"pairingStatus,omitempty"`
	Role                  *string                                   `json:"role,omitempty"`
	FabricSpecificDetails *ProtectionContainerFabricSpecificDetails `json:"fabricSpecificDetails,omitempty"`
}

// ProviderError is this class contains the error details per object.
type ProviderError struct {
	ErrorCode         *int32  `json:"errorCode,omitempty"`
	ErrorMessage      *string `json:"errorMessage,omitempty"`
	ErrorID           *string `json:"errorId,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
}

// ProviderSpecificFailoverInput is provider specific failover input.
type ProviderSpecificFailoverInput interface {
	AsHyperVReplicaAzureFailoverProviderInput() (*HyperVReplicaAzureFailoverProviderInput, bool)
	AsHyperVReplicaAzureFailbackProviderInput() (*HyperVReplicaAzureFailbackProviderInput, bool)
	AsInMageAzureV2FailoverProviderInput() (*InMageAzureV2FailoverProviderInput, bool)
	AsInMageFailoverProviderInput() (*InMageFailoverProviderInput, bool)
	AsA2AFailoverProviderInput() (*A2AFailoverProviderInput, bool)
}

func unmarshalProviderSpecificFailoverInput(body []byte) (ProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var hvrafpi HyperVReplicaAzureFailoverProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var hvrafpi HyperVReplicaAzureFailbackProviderInput
		err := json.Unmarshal(body, &hvrafpi)
		return hvrafpi, err
	case string(InstanceTypeProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var imavfpi InMageAzureV2FailoverProviderInput
		err := json.Unmarshal(body, &imavfpi)
		return imavfpi, err
	case string(InstanceTypeProviderSpecificFailoverInputInstanceTypeInMage):
		var imfpi InMageFailoverProviderInput
		err := json.Unmarshal(body, &imfpi)
		return imfpi, err
	case string(InstanceTypeProviderSpecificFailoverInputInstanceTypeA2A):
		var afpi A2AFailoverProviderInput
		err := json.Unmarshal(body, &afpi)
		return afpi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalProviderSpecificFailoverInputArray(body []byte) ([]ProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	psfiArray := make([]ProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		psfi, err := unmarshalProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		psfiArray[index] = psfi
	}
	return psfiArray, nil
}

// ProviderSpecificRecoveryPointDetails is replication provider specific recovery point details.
type ProviderSpecificRecoveryPointDetails struct {
	Type *string `json:"Type,omitempty"`
}

// RcmAzureMigrationPolicyDetails is RCM based Azure migration specific policy details.
type RcmAzureMigrationPolicyDetails struct {
	InstanceType                      InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes   *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	MultiVMSyncStatus                 MultiVMSyncStatus                         `json:"multiVmSyncStatus,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                    `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// MarshalJSON is the custom marshaler for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) MarshalJSON() ([]byte, error) {
	rampd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration
	type Alias RcmAzureMigrationPolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rampd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return &rampd, true
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for RcmAzureMigrationPolicyDetails.
func (rampd RcmAzureMigrationPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return nil, false
}

// RecoveryPlan is recovery plan details.
type RecoveryPlan struct {
	autorest.Response `json:"-"`
	ID                *string                 `json:"id,omitempty"`
	Name              *string                 `json:"name,omitempty"`
	Type              *string                 `json:"type,omitempty"`
	Location          *string                 `json:"location,omitempty"`
	Properties        *RecoveryPlanProperties `json:"properties,omitempty"`
}

// RecoveryPlanA2AFailoverInput is recovery plan A2A failover input.
type RecoveryPlanA2AFailoverInput struct {
	InstanceType               InstanceTypeRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	RecoveryPointType          A2ARpRecoveryPointType                                `json:"recoveryPointType,omitempty"`
	CloudServiceCreationOption *string                                               `json:"cloudServiceCreationOption,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) MarshalJSON() ([]byte, error) {
	rpafi.InstanceType = InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A
	type Alias RecoveryPlanA2AFailoverInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpafi),
	})
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanA2AFailoverInput.
func (rpafi RecoveryPlanA2AFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return &rpafi, true
}

// RecoveryPlanAction is recovery plan action details.
type RecoveryPlanAction struct {
	ActionName         *string                              `json:"actionName,omitempty"`
	FailoverTypes      *[]ReplicationProtectedItemOperation `json:"failoverTypes,omitempty"`
	FailoverDirections *[]PossibleOperationsDirections      `json:"failoverDirections,omitempty"`
	CustomDetails      RecoveryPlanActionDetails            `json:"customDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanAction struct.
func (rpa *RecoveryPlanAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["actionName"]
	if v != nil {
		var actionName string
		err = json.Unmarshal(*m["actionName"], &actionName)
		if err != nil {
			return err
		}
		rpa.ActionName = &actionName
	}

	v = m["failoverTypes"]
	if v != nil {
		var failoverTypes []ReplicationProtectedItemOperation
		err = json.Unmarshal(*m["failoverTypes"], &failoverTypes)
		if err != nil {
			return err
		}
		rpa.FailoverTypes = &failoverTypes
	}

	v = m["failoverDirections"]
	if v != nil {
		var failoverDirections []PossibleOperationsDirections
		err = json.Unmarshal(*m["failoverDirections"], &failoverDirections)
		if err != nil {
			return err
		}
		rpa.FailoverDirections = &failoverDirections
	}

	v = m["customDetails"]
	if v != nil {
		customDetails, err := unmarshalRecoveryPlanActionDetails(*m["customDetails"])
		if err != nil {
			return err
		}
		rpa.CustomDetails = customDetails
	}

	return nil
}

// RecoveryPlanActionDetails is recovery plan action custom details.
type RecoveryPlanActionDetails interface {
	AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool)
	AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool)
	AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool)
}

func unmarshalRecoveryPlanActionDetails(body []byte) (RecoveryPlanActionDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeScriptActionDetails):
		var rpsad RecoveryPlanScriptActionDetails
		err := json.Unmarshal(body, &rpsad)
		return rpsad, err
	case string(InstanceTypeAutomationRunbookActionDetails):
		var rparad RecoveryPlanAutomationRunbookActionDetails
		err := json.Unmarshal(body, &rparad)
		return rparad, err
	case string(InstanceTypeManualActionDetails):
		var rpmad RecoveryPlanManualActionDetails
		err := json.Unmarshal(body, &rpmad)
		return rpmad, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalRecoveryPlanActionDetailsArray(body []byte) ([]RecoveryPlanActionDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpadArray := make([]RecoveryPlanActionDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpad, err := unmarshalRecoveryPlanActionDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpadArray[index] = rpad
	}
	return rpadArray, nil
}

// RecoveryPlanAutomationRunbookActionDetails is recovery plan Automation runbook action details.
type RecoveryPlanAutomationRunbookActionDetails struct {
	InstanceType   InstanceTypeRecoveryPlanActionDetails `json:"instanceType,omitempty"`
	RunbookID      *string                               `json:"runbookId,omitempty"`
	Timeout        *string                               `json:"timeout,omitempty"`
	FabricLocation RecoveryPlanActionLocation            `json:"fabricLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) MarshalJSON() ([]byte, error) {
	rparad.InstanceType = InstanceTypeAutomationRunbookActionDetails
	type Alias RecoveryPlanAutomationRunbookActionDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rparad),
	})
}

// AsRecoveryPlanScriptActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanAutomationRunbookActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return &rparad, true
}

// AsRecoveryPlanManualActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanAutomationRunbookActionDetails.
func (rparad RecoveryPlanAutomationRunbookActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// RecoveryPlanCollection is recovery plan collection details.
type RecoveryPlanCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryPlan `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// RecoveryPlanCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryPlanCollection) RecoveryPlanCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPlanGroup is recovery plan group details.
type RecoveryPlanGroup struct {
	GroupType                 RecoveryPlanGroupType        `json:"groupType,omitempty"`
	ReplicationProtectedItems *[]RecoveryPlanProtectedItem `json:"replicationProtectedItems,omitempty"`
	StartGroupActions         *[]RecoveryPlanAction        `json:"startGroupActions,omitempty"`
	EndGroupActions           *[]RecoveryPlanAction        `json:"endGroupActions,omitempty"`
}

// RecoveryPlanGroupTaskDetails is this class represents the recovery plan group task.
type RecoveryPlanGroupTaskDetails struct {
	ChildTasks   *[]ASRTask                   `json:"childTasks,omitempty"`
	InstanceType InstanceTypeGroupTaskDetails `json:"instanceType,omitempty"`
	Name         *string                      `json:"name,omitempty"`
	GroupID      *string                      `json:"groupId,omitempty"`
	RpGroupType  *string                      `json:"rpGroupType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpgtd.InstanceType = InstanceTypeRecoveryPlanGroupTaskDetails
	type Alias RecoveryPlanGroupTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpgtd),
	})
}

// AsInlineWorkflowTaskDetails is the GroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the GroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return &rpgtd, true
}

// AsRecoveryPlanShutdownGroupTaskDetails is the GroupTaskDetails implementation for RecoveryPlanGroupTaskDetails.
func (rpgtd RecoveryPlanGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return nil, false
}

// RecoveryPlanHyperVReplicaAzureFailbackInput is recovery plan HVR Azure failback input.
type RecoveryPlanHyperVReplicaAzureFailbackInput struct {
	InstanceType             InstanceTypeRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	DataSyncOption           DataSyncStatus                                        `json:"dataSyncOption,omitempty"`
	RecoveryVMCreationOption AlternateLocationRecoveryOption                       `json:"recoveryVmCreationOption,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback
	type Alias RecoveryPlanHyperVReplicaAzureFailbackInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rphvrafi),
	})
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailbackInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// RecoveryPlanHyperVReplicaAzureFailoverInput is recovery plan HVR Azure failover input.
type RecoveryPlanHyperVReplicaAzureFailoverInput struct {
	InstanceType               InstanceTypeRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	VaultLocation              *string                                               `json:"vaultLocation,omitempty"`
	PrimaryKekCertificatePfx   *string                                               `json:"primaryKekCertificatePfx,omitempty"`
	SecondaryKekCertificatePfx *string                                               `json:"secondaryKekCertificatePfx,omitempty"`
	RecoveryPointType          HyperVReplicaAzureRpRecoveryPointType                 `json:"recoveryPointType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) MarshalJSON() ([]byte, error) {
	rphvrafi.InstanceType = InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure
	type Alias RecoveryPlanHyperVReplicaAzureFailoverInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rphvrafi),
	})
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return &rphvrafi, true
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanHyperVReplicaAzureFailoverInput.
func (rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// RecoveryPlanInMageAzureV2FailoverInput is recovery plan InMageAzureV2 failover input.
type RecoveryPlanInMageAzureV2FailoverInput struct {
	InstanceType        InstanceTypeRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	VaultLocation       *string                                               `json:"vaultLocation,omitempty"`
	RecoveryPointType   InMageV2RpRecoveryPointType                           `json:"recoveryPointType,omitempty"`
	UseMultiVMSyncPoint *string                                               `json:"useMultiVmSyncPoint,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) MarshalJSON() ([]byte, error) {
	rpimavfi.InstanceType = InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2
	type Alias RecoveryPlanInMageAzureV2FailoverInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpimavfi),
	})
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return &rpimavfi, true
}

// AsRecoveryPlanInMageFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanA2AFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageAzureV2FailoverInput.
func (rpimavfi RecoveryPlanInMageAzureV2FailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// RecoveryPlanInMageFailoverInput is recovery plan InMage failover input.
type RecoveryPlanInMageFailoverInput struct {
	InstanceType      InstanceTypeRecoveryPlanProviderSpecificFailoverInput `json:"instanceType,omitempty"`
	RecoveryPointType RpInMageRecoveryPointType                             `json:"recoveryPointType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) MarshalJSON() ([]byte, error) {
	rpimfi.InstanceType = InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage
	type Alias RecoveryPlanInMageFailoverInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpimfi),
	})
}

// AsRecoveryPlanHyperVReplicaAzureFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanHyperVReplicaAzureFailbackInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageAzureV2FailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool) {
	return nil, false
}

// AsRecoveryPlanInMageFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool) {
	return &rpimfi, true
}

// AsRecoveryPlanA2AFailoverInput is the RecoveryPlanProviderSpecificFailoverInput implementation for RecoveryPlanInMageFailoverInput.
func (rpimfi RecoveryPlanInMageFailoverInput) AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool) {
	return nil, false
}

// RecoveryPlanManualActionDetails is recovery plan manual action details.
type RecoveryPlanManualActionDetails struct {
	InstanceType InstanceTypeRecoveryPlanActionDetails `json:"instanceType,omitempty"`
	Description  *string                               `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) MarshalJSON() ([]byte, error) {
	rpmad.InstanceType = InstanceTypeManualActionDetails
	type Alias RecoveryPlanManualActionDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpmad),
	})
}

// AsRecoveryPlanScriptActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanAutomationRunbookActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanManualActionDetails.
func (rpmad RecoveryPlanManualActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return &rpmad, true
}

// RecoveryPlanPlannedFailoverInput is recovery plan planned failover input.
type RecoveryPlanPlannedFailoverInput struct {
	Properties *RecoveryPlanPlannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanPlannedFailoverInputProperties is recovery plan planned failover input properties.
type RecoveryPlanPlannedFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanPlannedFailoverInputProperties struct.
func (rppfip *RecoveryPlanPlannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection PossibleOperationsDirections
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		rppfip.FailoverDirection = failoverDirection
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalRecoveryPlanProviderSpecificFailoverInputArray(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		rppfip.ProviderSpecificDetails = &providerSpecificDetails
	}

	return nil
}

// RecoveryPlanProperties is recovery plan custom details.
type RecoveryPlanProperties struct {
	FriendlyName                     *string                 `json:"friendlyName,omitempty"`
	PrimaryFabricID                  *string                 `json:"primaryFabricId,omitempty"`
	PrimaryFabricFriendlyName        *string                 `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryFabricID                 *string                 `json:"recoveryFabricId,omitempty"`
	RecoveryFabricFriendlyName       *string                 `json:"recoveryFabricFriendlyName,omitempty"`
	FailoverDeploymentModel          *string                 `json:"failoverDeploymentModel,omitempty"`
	ReplicationProviders             *[]string               `json:"replicationProviders,omitempty"`
	AllowedOperations                *[]string               `json:"allowedOperations,omitempty"`
	LastPlannedFailoverTime          *date.Time              `json:"lastPlannedFailoverTime,omitempty"`
	LastUnplannedFailoverTime        *date.Time              `json:"lastUnplannedFailoverTime,omitempty"`
	LastTestFailoverTime             *date.Time              `json:"lastTestFailoverTime,omitempty"`
	CurrentScenario                  *CurrentScenarioDetails `json:"currentScenario,omitempty"`
	CurrentScenarioStatus            *string                 `json:"currentScenarioStatus,omitempty"`
	CurrentScenarioStatusDescription *string                 `json:"currentScenarioStatusDescription,omitempty"`
	Groups                           *[]RecoveryPlanGroup    `json:"groups,omitempty"`
}

// RecoveryPlanProtectedItem is recovery plan protected item.
type RecoveryPlanProtectedItem struct {
	ID               *string `json:"id,omitempty"`
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
}

// RecoveryPlanProviderSpecificFailoverInput is recovery plan provider specific failover input base class.
type RecoveryPlanProviderSpecificFailoverInput interface {
	AsRecoveryPlanHyperVReplicaAzureFailoverInput() (*RecoveryPlanHyperVReplicaAzureFailoverInput, bool)
	AsRecoveryPlanHyperVReplicaAzureFailbackInput() (*RecoveryPlanHyperVReplicaAzureFailbackInput, bool)
	AsRecoveryPlanInMageAzureV2FailoverInput() (*RecoveryPlanInMageAzureV2FailoverInput, bool)
	AsRecoveryPlanInMageFailoverInput() (*RecoveryPlanInMageFailoverInput, bool)
	AsRecoveryPlanA2AFailoverInput() (*RecoveryPlanA2AFailoverInput, bool)
}

func unmarshalRecoveryPlanProviderSpecificFailoverInput(body []byte) (RecoveryPlanProviderSpecificFailoverInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailoverInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback):
		var rphvrafi RecoveryPlanHyperVReplicaAzureFailbackInput
		err := json.Unmarshal(body, &rphvrafi)
		return rphvrafi, err
	case string(InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2):
		var rpimavfi RecoveryPlanInMageAzureV2FailoverInput
		err := json.Unmarshal(body, &rpimavfi)
		return rpimavfi, err
	case string(InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage):
		var rpimfi RecoveryPlanInMageFailoverInput
		err := json.Unmarshal(body, &rpimfi)
		return rpimfi, err
	case string(InstanceTypeRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A):
		var rpafi RecoveryPlanA2AFailoverInput
		err := json.Unmarshal(body, &rpafi)
		return rpafi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalRecoveryPlanProviderSpecificFailoverInputArray(body []byte) ([]RecoveryPlanProviderSpecificFailoverInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rppsfiArray := make([]RecoveryPlanProviderSpecificFailoverInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rppsfi, err := unmarshalRecoveryPlanProviderSpecificFailoverInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rppsfiArray[index] = rppsfi
	}
	return rppsfiArray, nil
}

// RecoveryPlanScriptActionDetails is recovery plan script action details.
type RecoveryPlanScriptActionDetails struct {
	InstanceType   InstanceTypeRecoveryPlanActionDetails `json:"instanceType,omitempty"`
	Path           *string                               `json:"path,omitempty"`
	Timeout        *string                               `json:"timeout,omitempty"`
	FabricLocation RecoveryPlanActionLocation            `json:"fabricLocation,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) MarshalJSON() ([]byte, error) {
	rpsad.InstanceType = InstanceTypeScriptActionDetails
	type Alias RecoveryPlanScriptActionDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpsad),
	})
}

// AsRecoveryPlanScriptActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanScriptActionDetails() (*RecoveryPlanScriptActionDetails, bool) {
	return &rpsad, true
}

// AsRecoveryPlanAutomationRunbookActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanAutomationRunbookActionDetails() (*RecoveryPlanAutomationRunbookActionDetails, bool) {
	return nil, false
}

// AsRecoveryPlanManualActionDetails is the RecoveryPlanActionDetails implementation for RecoveryPlanScriptActionDetails.
func (rpsad RecoveryPlanScriptActionDetails) AsRecoveryPlanManualActionDetails() (*RecoveryPlanManualActionDetails, bool) {
	return nil, false
}

// RecoveryPlanShutdownGroupTaskDetails is this class represents the recovery plan shutdown group task details.
type RecoveryPlanShutdownGroupTaskDetails struct {
	ChildTasks   *[]ASRTask                   `json:"childTasks,omitempty"`
	InstanceType InstanceTypeGroupTaskDetails `json:"instanceType,omitempty"`
	Name         *string                      `json:"name,omitempty"`
	GroupID      *string                      `json:"groupId,omitempty"`
	RpGroupType  *string                      `json:"rpGroupType,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) MarshalJSON() ([]byte, error) {
	rpsgtd.InstanceType = InstanceTypeRecoveryPlanShutdownGroupTaskDetails
	type Alias RecoveryPlanShutdownGroupTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rpsgtd),
	})
}

// AsInlineWorkflowTaskDetails is the GroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsInlineWorkflowTaskDetails() (*InlineWorkflowTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanGroupTaskDetails is the GroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanGroupTaskDetails() (*RecoveryPlanGroupTaskDetails, bool) {
	return nil, false
}

// AsRecoveryPlanShutdownGroupTaskDetails is the GroupTaskDetails implementation for RecoveryPlanShutdownGroupTaskDetails.
func (rpsgtd RecoveryPlanShutdownGroupTaskDetails) AsRecoveryPlanShutdownGroupTaskDetails() (*RecoveryPlanShutdownGroupTaskDetails, bool) {
	return &rpsgtd, true
}

// RecoveryPlanTestFailoverCleanupInput is recovery plan test failover cleanup input.
type RecoveryPlanTestFailoverCleanupInput struct {
	Properties *RecoveryPlanTestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverCleanupInputProperties is recovery plan test failover cleanup input properties.
type RecoveryPlanTestFailoverCleanupInputProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// RecoveryPlanTestFailoverInput is recovery plan test failover input.
type RecoveryPlanTestFailoverInput struct {
	Properties *RecoveryPlanTestFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanTestFailoverInputProperties is recovery plan test failover input properties.
type RecoveryPlanTestFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	NetworkType             *string                                      `json:"networkType,omitempty"`
	NetworkID               *string                                      `json:"networkId,omitempty"`
	SkipTestFailoverCleanup *string                                      `json:"skipTestFailoverCleanup,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanTestFailoverInputProperties struct.
func (rptfip *RecoveryPlanTestFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection PossibleOperationsDirections
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		rptfip.FailoverDirection = failoverDirection
	}

	v = m["networkType"]
	if v != nil {
		var networkType string
		err = json.Unmarshal(*m["networkType"], &networkType)
		if err != nil {
			return err
		}
		rptfip.NetworkType = &networkType
	}

	v = m["networkId"]
	if v != nil {
		var networkID string
		err = json.Unmarshal(*m["networkId"], &networkID)
		if err != nil {
			return err
		}
		rptfip.NetworkID = &networkID
	}

	v = m["skipTestFailoverCleanup"]
	if v != nil {
		var skipTestFailoverCleanup string
		err = json.Unmarshal(*m["skipTestFailoverCleanup"], &skipTestFailoverCleanup)
		if err != nil {
			return err
		}
		rptfip.SkipTestFailoverCleanup = &skipTestFailoverCleanup
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalRecoveryPlanProviderSpecificFailoverInputArray(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		rptfip.ProviderSpecificDetails = &providerSpecificDetails
	}

	return nil
}

// RecoveryPlanUnplannedFailoverInput is recovery plan unplanned failover input.
type RecoveryPlanUnplannedFailoverInput struct {
	Properties *RecoveryPlanUnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// RecoveryPlanUnplannedFailoverInputProperties is recovery plan unplanned failover input properties.
type RecoveryPlanUnplannedFailoverInputProperties struct {
	FailoverDirection       PossibleOperationsDirections                 `json:"failoverDirection,omitempty"`
	SourceSiteOperations    SourceSiteOperations                         `json:"sourceSiteOperations,omitempty"`
	ProviderSpecificDetails *[]RecoveryPlanProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPlanUnplannedFailoverInputProperties struct.
func (rpufip *RecoveryPlanUnplannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection PossibleOperationsDirections
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		rpufip.FailoverDirection = failoverDirection
	}

	v = m["sourceSiteOperations"]
	if v != nil {
		var sourceSiteOperations SourceSiteOperations
		err = json.Unmarshal(*m["sourceSiteOperations"], &sourceSiteOperations)
		if err != nil {
			return err
		}
		rpufip.SourceSiteOperations = sourceSiteOperations
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalRecoveryPlanProviderSpecificFailoverInputArray(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		rpufip.ProviderSpecificDetails = &providerSpecificDetails
	}

	return nil
}

// RecoveryPoint is base class representing a recovery point.
type RecoveryPoint struct {
	autorest.Response `json:"-"`
	ID                *string                  `json:"id,omitempty"`
	Name              *string                  `json:"name,omitempty"`
	Type              *string                  `json:"type,omitempty"`
	Location          *string                  `json:"location,omitempty"`
	Properties        *RecoveryPointProperties `json:"properties,omitempty"`
}

// RecoveryPointCollection is collection of recovery point details.
type RecoveryPointCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryPoint `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// RecoveryPointCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryPointCollection) RecoveryPointCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryPointProperties is recovery point properties.
type RecoveryPointProperties struct {
	RecoveryPointTime       *date.Time                            `json:"recoveryPointTime,omitempty"`
	RecoveryPointType       *string                               `json:"recoveryPointType,omitempty"`
	ProviderSpecificDetails *ProviderSpecificRecoveryPointDetails `json:"providerSpecificDetails,omitempty"`
}

// RecoveryServicesProvider is provider details.
type RecoveryServicesProvider struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Properties        *RecoveryServicesProviderProperties `json:"properties,omitempty"`
}

// RecoveryServicesProviderCollection is collection of providers.
type RecoveryServicesProviderCollection struct {
	autorest.Response `json:"-"`
	Value             *[]RecoveryServicesProvider `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// RecoveryServicesProviderCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecoveryServicesProviderCollection) RecoveryServicesProviderCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecoveryServicesProviderProperties is recovery services provider properties.
type RecoveryServicesProviderProperties struct {
	FabricType                *string              `json:"fabricType,omitempty"`
	FriendlyName              *string              `json:"friendlyName,omitempty"`
	ProviderVersion           *string              `json:"providerVersion,omitempty"`
	ServerVersion             *string              `json:"serverVersion,omitempty"`
	ProviderVersionState      *string              `json:"providerVersionState,omitempty"`
	ProviderVersionExpiryDate *date.Time           `json:"providerVersionExpiryDate,omitempty"`
	FabricFriendlyName        *string              `json:"fabricFriendlyName,omitempty"`
	LastHeartBeat             *date.Time           `json:"lastHeartBeat,omitempty"`
	ConnectionStatus          *string              `json:"connectionStatus,omitempty"`
	ProtectedItemCount        *int32               `json:"protectedItemCount,omitempty"`
	AllowedScenarios          *[]string            `json:"allowedScenarios,omitempty"`
	HealthErrorDetails        *[]HealthError       `json:"healthErrorDetails,omitempty"`
	DraIdentifier             *string              `json:"draIdentifier,omitempty"`
	IdentityDetails           *IdentityInformation `json:"identityDetails,omitempty"`
}

// RemoveProtectionContainerMappingInput is container unpairing input.
type RemoveProtectionContainerMappingInput struct {
	Properties *RemoveProtectionContainerMappingInputProperties `json:"properties,omitempty"`
}

// RemoveProtectionContainerMappingInputProperties is unpairing input properties.
type RemoveProtectionContainerMappingInputProperties struct {
	ProviderSpecificInput *ReplicationProviderContainerUnmappingInput `json:"providerSpecificInput,omitempty"`
}

// RenewCertificateInput is certificate renewal input.
type RenewCertificateInput struct {
	Properties *RenewCertificateInputProperties `json:"properties,omitempty"`
}

// RenewCertificateInputProperties is renew Certificate input properties.
type RenewCertificateInputProperties struct {
	RenewCertificateType *string `json:"renewCertificateType,omitempty"`
}

// ReplicationGroupDetails is replication group details. This will be used in case of San and Wvr.
type ReplicationGroupDetails struct {
	InstanceType InstanceTypeConfigurationSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) MarshalJSON() ([]byte, error) {
	rgd.InstanceType = InstanceTypeReplicationGroupDetails
	type Alias ReplicationGroupDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rgd),
	})
}

// AsHyperVVirtualMachineDetails is the ConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the ConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return nil, false
}

// AsReplicationGroupDetails is the ConfigurationSettings implementation for ReplicationGroupDetails.
func (rgd ReplicationGroupDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return &rgd, true
}

// ReplicationProtectedItem is replication protected item.
type ReplicationProtectedItem struct {
	autorest.Response `json:"-"`
	ID                *string                             `json:"id,omitempty"`
	Name              *string                             `json:"name,omitempty"`
	Type              *string                             `json:"type,omitempty"`
	Location          *string                             `json:"location,omitempty"`
	Properties        *ReplicationProtectedItemProperties `json:"properties,omitempty"`
}

// ReplicationProtectedItemCollection is replication protected item collection.
type ReplicationProtectedItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ReplicationProtectedItem `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// ReplicationProtectedItemCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ReplicationProtectedItemCollection) ReplicationProtectedItemCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ReplicationProtectedItemProperties is replication protected item custom data details.
type ReplicationProtectedItemProperties struct {
	FriendlyName                            *string                             `json:"friendlyName,omitempty"`
	ProtectedItemType                       *string                             `json:"protectedItemType,omitempty"`
	ProtectableItemID                       *string                             `json:"protectableItemId,omitempty"`
	RecoveryServicesProviderID              *string                             `json:"recoveryServicesProviderId,omitempty"`
	PrimaryFabricFriendlyName               *string                             `json:"primaryFabricFriendlyName,omitempty"`
	RecoveryFabricFriendlyName              *string                             `json:"recoveryFabricFriendlyName,omitempty"`
	RecoveryFabricID                        *string                             `json:"recoveryFabricId,omitempty"`
	PrimaryProtectionContainerFriendlyName  *string                             `json:"primaryProtectionContainerFriendlyName,omitempty"`
	RecoveryProtectionContainerFriendlyName *string                             `json:"recoveryProtectionContainerFriendlyName,omitempty"`
	ProtectionState                         *string                             `json:"protectionState,omitempty"`
	ProtectionStateDescription              *string                             `json:"protectionStateDescription,omitempty"`
	ActiveLocation                          *string                             `json:"activeLocation,omitempty"`
	TestFailoverState                       *string                             `json:"testFailoverState,omitempty"`
	TestFailoverStateDescription            *string                             `json:"testFailoverStateDescription,omitempty"`
	AllowedOperations                       *[]string                           `json:"allowedOperations,omitempty"`
	ReplicationHealth                       *string                             `json:"replicationHealth,omitempty"`
	FailoverHealth                          *string                             `json:"failoverHealth,omitempty"`
	ReplicationHealthErrors                 *[]HealthError                      `json:"replicationHealthErrors,omitempty"`
	FailoverHealthErrors                    *[]HealthError                      `json:"failoverHealthErrors,omitempty"`
	PolicyID                                *string                             `json:"policyId,omitempty"`
	PolicyFriendlyName                      *string                             `json:"policyFriendlyName,omitempty"`
	LastSuccessfulFailoverTime              *date.Time                          `json:"lastSuccessfulFailoverTime,omitempty"`
	LastSuccessfulTestFailoverTime          *date.Time                          `json:"lastSuccessfulTestFailoverTime,omitempty"`
	CurrentScenario                         *CurrentScenarioDetails             `json:"currentScenario,omitempty"`
	FailoverRecoveryPointID                 *string                             `json:"failoverRecoveryPointId,omitempty"`
	ProviderSpecificDetails                 ReplicationProviderSpecificSettings `json:"providerSpecificDetails,omitempty"`
	RecoveryContainerID                     *string                             `json:"recoveryContainerId,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ReplicationProtectedItemProperties struct.
func (rpip *ReplicationProtectedItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["friendlyName"]
	if v != nil {
		var friendlyName string
		err = json.Unmarshal(*m["friendlyName"], &friendlyName)
		if err != nil {
			return err
		}
		rpip.FriendlyName = &friendlyName
	}

	v = m["protectedItemType"]
	if v != nil {
		var protectedItemType string
		err = json.Unmarshal(*m["protectedItemType"], &protectedItemType)
		if err != nil {
			return err
		}
		rpip.ProtectedItemType = &protectedItemType
	}

	v = m["protectableItemId"]
	if v != nil {
		var protectableItemID string
		err = json.Unmarshal(*m["protectableItemId"], &protectableItemID)
		if err != nil {
			return err
		}
		rpip.ProtectableItemID = &protectableItemID
	}

	v = m["recoveryServicesProviderId"]
	if v != nil {
		var recoveryServicesProviderID string
		err = json.Unmarshal(*m["recoveryServicesProviderId"], &recoveryServicesProviderID)
		if err != nil {
			return err
		}
		rpip.RecoveryServicesProviderID = &recoveryServicesProviderID
	}

	v = m["primaryFabricFriendlyName"]
	if v != nil {
		var primaryFabricFriendlyName string
		err = json.Unmarshal(*m["primaryFabricFriendlyName"], &primaryFabricFriendlyName)
		if err != nil {
			return err
		}
		rpip.PrimaryFabricFriendlyName = &primaryFabricFriendlyName
	}

	v = m["recoveryFabricFriendlyName"]
	if v != nil {
		var recoveryFabricFriendlyName string
		err = json.Unmarshal(*m["recoveryFabricFriendlyName"], &recoveryFabricFriendlyName)
		if err != nil {
			return err
		}
		rpip.RecoveryFabricFriendlyName = &recoveryFabricFriendlyName
	}

	v = m["recoveryFabricId"]
	if v != nil {
		var recoveryFabricID string
		err = json.Unmarshal(*m["recoveryFabricId"], &recoveryFabricID)
		if err != nil {
			return err
		}
		rpip.RecoveryFabricID = &recoveryFabricID
	}

	v = m["primaryProtectionContainerFriendlyName"]
	if v != nil {
		var primaryProtectionContainerFriendlyName string
		err = json.Unmarshal(*m["primaryProtectionContainerFriendlyName"], &primaryProtectionContainerFriendlyName)
		if err != nil {
			return err
		}
		rpip.PrimaryProtectionContainerFriendlyName = &primaryProtectionContainerFriendlyName
	}

	v = m["recoveryProtectionContainerFriendlyName"]
	if v != nil {
		var recoveryProtectionContainerFriendlyName string
		err = json.Unmarshal(*m["recoveryProtectionContainerFriendlyName"], &recoveryProtectionContainerFriendlyName)
		if err != nil {
			return err
		}
		rpip.RecoveryProtectionContainerFriendlyName = &recoveryProtectionContainerFriendlyName
	}

	v = m["protectionState"]
	if v != nil {
		var protectionState string
		err = json.Unmarshal(*m["protectionState"], &protectionState)
		if err != nil {
			return err
		}
		rpip.ProtectionState = &protectionState
	}

	v = m["protectionStateDescription"]
	if v != nil {
		var protectionStateDescription string
		err = json.Unmarshal(*m["protectionStateDescription"], &protectionStateDescription)
		if err != nil {
			return err
		}
		rpip.ProtectionStateDescription = &protectionStateDescription
	}

	v = m["activeLocation"]
	if v != nil {
		var activeLocation string
		err = json.Unmarshal(*m["activeLocation"], &activeLocation)
		if err != nil {
			return err
		}
		rpip.ActiveLocation = &activeLocation
	}

	v = m["testFailoverState"]
	if v != nil {
		var testFailoverState string
		err = json.Unmarshal(*m["testFailoverState"], &testFailoverState)
		if err != nil {
			return err
		}
		rpip.TestFailoverState = &testFailoverState
	}

	v = m["testFailoverStateDescription"]
	if v != nil {
		var testFailoverStateDescription string
		err = json.Unmarshal(*m["testFailoverStateDescription"], &testFailoverStateDescription)
		if err != nil {
			return err
		}
		rpip.TestFailoverStateDescription = &testFailoverStateDescription
	}

	v = m["allowedOperations"]
	if v != nil {
		var allowedOperations []string
		err = json.Unmarshal(*m["allowedOperations"], &allowedOperations)
		if err != nil {
			return err
		}
		rpip.AllowedOperations = &allowedOperations
	}

	v = m["replicationHealth"]
	if v != nil {
		var replicationHealth string
		err = json.Unmarshal(*m["replicationHealth"], &replicationHealth)
		if err != nil {
			return err
		}
		rpip.ReplicationHealth = &replicationHealth
	}

	v = m["failoverHealth"]
	if v != nil {
		var failoverHealth string
		err = json.Unmarshal(*m["failoverHealth"], &failoverHealth)
		if err != nil {
			return err
		}
		rpip.FailoverHealth = &failoverHealth
	}

	v = m["replicationHealthErrors"]
	if v != nil {
		var replicationHealthErrors []HealthError
		err = json.Unmarshal(*m["replicationHealthErrors"], &replicationHealthErrors)
		if err != nil {
			return err
		}
		rpip.ReplicationHealthErrors = &replicationHealthErrors
	}

	v = m["failoverHealthErrors"]
	if v != nil {
		var failoverHealthErrors []HealthError
		err = json.Unmarshal(*m["failoverHealthErrors"], &failoverHealthErrors)
		if err != nil {
			return err
		}
		rpip.FailoverHealthErrors = &failoverHealthErrors
	}

	v = m["policyId"]
	if v != nil {
		var policyID string
		err = json.Unmarshal(*m["policyId"], &policyID)
		if err != nil {
			return err
		}
		rpip.PolicyID = &policyID
	}

	v = m["policyFriendlyName"]
	if v != nil {
		var policyFriendlyName string
		err = json.Unmarshal(*m["policyFriendlyName"], &policyFriendlyName)
		if err != nil {
			return err
		}
		rpip.PolicyFriendlyName = &policyFriendlyName
	}

	v = m["lastSuccessfulFailoverTime"]
	if v != nil {
		var lastSuccessfulFailoverTime date.Time
		err = json.Unmarshal(*m["lastSuccessfulFailoverTime"], &lastSuccessfulFailoverTime)
		if err != nil {
			return err
		}
		rpip.LastSuccessfulFailoverTime = &lastSuccessfulFailoverTime
	}

	v = m["lastSuccessfulTestFailoverTime"]
	if v != nil {
		var lastSuccessfulTestFailoverTime date.Time
		err = json.Unmarshal(*m["lastSuccessfulTestFailoverTime"], &lastSuccessfulTestFailoverTime)
		if err != nil {
			return err
		}
		rpip.LastSuccessfulTestFailoverTime = &lastSuccessfulTestFailoverTime
	}

	v = m["currentScenario"]
	if v != nil {
		var currentScenario CurrentScenarioDetails
		err = json.Unmarshal(*m["currentScenario"], &currentScenario)
		if err != nil {
			return err
		}
		rpip.CurrentScenario = &currentScenario
	}

	v = m["failoverRecoveryPointId"]
	if v != nil {
		var failoverRecoveryPointID string
		err = json.Unmarshal(*m["failoverRecoveryPointId"], &failoverRecoveryPointID)
		if err != nil {
			return err
		}
		rpip.FailoverRecoveryPointID = &failoverRecoveryPointID
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalReplicationProviderSpecificSettings(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		rpip.ProviderSpecificDetails = providerSpecificDetails
	}

	v = m["recoveryContainerId"]
	if v != nil {
		var recoveryContainerID string
		err = json.Unmarshal(*m["recoveryContainerId"], &recoveryContainerID)
		if err != nil {
			return err
		}
		rpip.RecoveryContainerID = &recoveryContainerID
	}

	return nil
}

// ReplicationProviderContainerUnmappingInput is provider specific input for unpairing operations.
type ReplicationProviderContainerUnmappingInput struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ReplicationProviderSpecificContainerCreationInput is provider specific input for container creation operation.
type ReplicationProviderSpecificContainerCreationInput interface {
	AsA2AContainerCreationInput() (*A2AContainerCreationInput, bool)
}

func unmarshalReplicationProviderSpecificContainerCreationInput(body []byte) (ReplicationProviderSpecificContainerCreationInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeA2A):
		var acci A2AContainerCreationInput
		err := json.Unmarshal(body, &acci)
		return acci, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalReplicationProviderSpecificContainerCreationInputArray(body []byte) ([]ReplicationProviderSpecificContainerCreationInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpscciArray := make([]ReplicationProviderSpecificContainerCreationInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpscci, err := unmarshalReplicationProviderSpecificContainerCreationInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpscciArray[index] = rpscci
	}
	return rpscciArray, nil
}

// ReplicationProviderSpecificContainerMappingInput is provider specific input for pairing operations.
type ReplicationProviderSpecificContainerMappingInput struct {
	InstanceType *string `json:"instanceType,omitempty"`
}

// ReplicationProviderSpecificSettings is replication provider specific settings.
type ReplicationProviderSpecificSettings interface {
	AsHyperVReplicaBaseReplicationDetails() (*HyperVReplicaBaseReplicationDetails, bool)
	AsHyperVReplicaReplicationDetails() (*HyperVReplicaReplicationDetails, bool)
	AsHyperVReplicaBlueReplicationDetails() (*HyperVReplicaBlueReplicationDetails, bool)
	AsHyperVReplicaAzureReplicationDetails() (*HyperVReplicaAzureReplicationDetails, bool)
	AsInMageAzureV2ReplicationDetails() (*InMageAzureV2ReplicationDetails, bool)
	AsInMageReplicationDetails() (*InMageReplicationDetails, bool)
	AsA2AReplicationDetails() (*A2AReplicationDetails, bool)
}

func unmarshalReplicationProviderSpecificSettings(body []byte) (ReplicationProviderSpecificSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails):
		var hvrbrd HyperVReplicaBaseReplicationDetails
		err := json.Unmarshal(body, &hvrbrd)
		return hvrbrd, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012):
		var hvrrd HyperVReplicaReplicationDetails
		err := json.Unmarshal(body, &hvrrd)
		return hvrrd, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2):
		var hvrbrd HyperVReplicaBlueReplicationDetails
		err := json.Unmarshal(body, &hvrbrd)
		return hvrbrd, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure):
		var hvrard HyperVReplicaAzureReplicationDetails
		err := json.Unmarshal(body, &hvrard)
		return hvrard, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2):
		var imavrd InMageAzureV2ReplicationDetails
		err := json.Unmarshal(body, &imavrd)
		return imavrd, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeInMage):
		var imrd InMageReplicationDetails
		err := json.Unmarshal(body, &imrd)
		return imrd, err
	case string(InstanceTypeReplicationProviderSpecificSettingsInstanceTypeA2A):
		var ard A2AReplicationDetails
		err := json.Unmarshal(body, &ard)
		return ard, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalReplicationProviderSpecificSettingsArray(body []byte) ([]ReplicationProviderSpecificSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpssArray := make([]ReplicationProviderSpecificSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rpss, err := unmarshalReplicationProviderSpecificSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpssArray[index] = rpss
	}
	return rpssArray, nil
}

// Resource is azure resource.
type Resource struct {
	ID       *string `json:"id,omitempty"`
	Name     *string `json:"name,omitempty"`
	Type     *string `json:"type,omitempty"`
	Location *string `json:"location,omitempty"`
}

// ResourceHealthSummary is base class to define the health summary of the resources contained under an Arm resource.
type ResourceHealthSummary struct {
	ResourceCount *int32                `json:"resourceCount,omitempty"`
	Issues        *[]HealthErrorSummary `json:"issues,omitempty"`
}

// ResumeJobParams is resume job params.
type ResumeJobParams struct {
	Properties *ResumeJobParamsProperties `json:"properties,omitempty"`
}

// ResumeJobParamsProperties is resume job properties.
type ResumeJobParamsProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// RetentionVolume is the retention details of the MT.
type RetentionVolume struct {
	VolumeName          *string `json:"volumeName,omitempty"`
	CapacityInBytes     *int64  `json:"capacityInBytes,omitempty"`
	FreeSpaceInBytes    *int64  `json:"freeSpaceInBytes,omitempty"`
	ThresholdPercentage *int32  `json:"thresholdPercentage,omitempty"`
}

// ReverseReplicationInput is reverse replication input.
type ReverseReplicationInput struct {
	Properties *ReverseReplicationInputProperties `json:"properties,omitempty"`
}

// ReverseReplicationInputProperties is reverse replication input properties.
type ReverseReplicationInputProperties struct {
	FailoverDirection       *string                                 `json:"failoverDirection,omitempty"`
	ProviderSpecificDetails ReverseReplicationProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ReverseReplicationInputProperties struct.
func (rrip *ReverseReplicationInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection string
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		rrip.FailoverDirection = &failoverDirection
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalReverseReplicationProviderSpecificInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		rrip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// ReverseReplicationProviderSpecificInput is provider specific reverse replication input.
type ReverseReplicationProviderSpecificInput interface {
	AsHyperVReplicaAzureReprotectInput() (*HyperVReplicaAzureReprotectInput, bool)
	AsInMageAzureV2ReprotectInput() (*InMageAzureV2ReprotectInput, bool)
	AsInMageReprotectInput() (*InMageReprotectInput, bool)
	AsA2AReprotectInput() (*A2AReprotectInput, bool)
}

func unmarshalReverseReplicationProviderSpecificInput(body []byte) (ReverseReplicationProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure):
		var hvrari HyperVReplicaAzureReprotectInput
		err := json.Unmarshal(body, &hvrari)
		return hvrari, err
	case string(InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2):
		var imavri InMageAzureV2ReprotectInput
		err := json.Unmarshal(body, &imavri)
		return imavri, err
	case string(InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeInMage):
		var imri InMageReprotectInput
		err := json.Unmarshal(body, &imri)
		return imri, err
	case string(InstanceTypeReverseReplicationProviderSpecificInputInstanceTypeA2A):
		var ari A2AReprotectInput
		err := json.Unmarshal(body, &ari)
		return ari, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalReverseReplicationProviderSpecificInputArray(body []byte) ([]ReverseReplicationProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrpsiArray := make([]ReverseReplicationProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rrpsi, err := unmarshalReverseReplicationProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrpsiArray[index] = rrpsi
	}
	return rrpsiArray, nil
}

// RoleAssignment is azure role assignment details.
type RoleAssignment struct {
	ID               *string `json:"id,omitempty"`
	Name             *string `json:"name,omitempty"`
	Scope            *string `json:"scope,omitempty"`
	PrincipalID      *string `json:"principalId,omitempty"`
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// RunAsAccount is CS Accounts Details.
type RunAsAccount struct {
	AccountID   *string `json:"accountId,omitempty"`
	AccountName *string `json:"accountName,omitempty"`
}

// SanEnableProtectionInput is san enable protection provider specific input.
type SanEnableProtectionInput struct {
	InstanceType InstanceTypeEnableProtectionProviderSpecificInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) MarshalJSON() ([]byte, error) {
	sepi.InstanceType = InstanceTypeEnableProtectionProviderSpecificInputInstanceTypeSan
	type Alias SanEnableProtectionInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sepi),
	})
}

// AsHyperVReplicaAzureEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsHyperVReplicaAzureEnableProtectionInput() (*HyperVReplicaAzureEnableProtectionInput, bool) {
	return nil, false
}

// AsSanEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsSanEnableProtectionInput() (*SanEnableProtectionInput, bool) {
	return &sepi, true
}

// AsInMageAzureV2EnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsInMageAzureV2EnableProtectionInput() (*InMageAzureV2EnableProtectionInput, bool) {
	return nil, false
}

// AsInMageEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsInMageEnableProtectionInput() (*InMageEnableProtectionInput, bool) {
	return nil, false
}

// AsA2AEnableProtectionInput is the EnableProtectionProviderSpecificInput implementation for SanEnableProtectionInput.
func (sepi SanEnableProtectionInput) AsA2AEnableProtectionInput() (*A2AEnableProtectionInput, bool) {
	return nil, false
}

// ScriptActionTaskDetails is this class represents the script action task details.
type ScriptActionTaskDetails struct {
	InstanceType        InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	Name                *string                     `json:"name,omitempty"`
	Path                *string                     `json:"path,omitempty"`
	Output              *string                     `json:"output,omitempty"`
	IsPrimarySideScript *bool                       `json:"isPrimarySideScript,omitempty"`
}

// MarshalJSON is the custom marshaler for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) MarshalJSON() ([]byte, error) {
	satd.InstanceType = InstanceTypeScriptActionTaskDetails
	type Alias ScriptActionTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(satd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return &satd, true
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for ScriptActionTaskDetails.
func (satd ScriptActionTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// ServiceError is ASR error model
type ServiceError struct {
	Code              *string `json:"code,omitempty"`
	Message           *string `json:"message,omitempty"`
	PossibleCauses    *string `json:"possibleCauses,omitempty"`
	RecommendedAction *string `json:"recommendedAction,omitempty"`
	ActivityID        *string `json:"activityId,omitempty"`
}

// StorageClassification is storage object definition.
type StorageClassification struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Properties        *StorageClassificationProperties `json:"properties,omitempty"`
}

// StorageClassificationCollection is collection of storage details.
type StorageClassificationCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StorageClassification `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// StorageClassificationCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StorageClassificationCollection) StorageClassificationCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StorageClassificationMapping is storage mapping object.
type StorageClassificationMapping struct {
	autorest.Response `json:"-"`
	ID                *string                                 `json:"id,omitempty"`
	Name              *string                                 `json:"name,omitempty"`
	Type              *string                                 `json:"type,omitempty"`
	Location          *string                                 `json:"location,omitempty"`
	Properties        *StorageClassificationMappingProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingCollection is collection of storage mapping details.
type StorageClassificationMappingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StorageClassificationMapping `json:"value,omitempty"`
	NextLink          *string                         `json:"nextLink,omitempty"`
}

// StorageClassificationMappingCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StorageClassificationMappingCollection) StorageClassificationMappingCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StorageClassificationMappingInput is storage mapping input.
type StorageClassificationMappingInput struct {
	Properties *StorageMappingInputProperties `json:"properties,omitempty"`
}

// StorageClassificationMappingProperties is storage mapping properties.
type StorageClassificationMappingProperties struct {
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// StorageClassificationProperties is storage object properties.
type StorageClassificationProperties struct {
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// StorageMappingInputProperties is storage mapping input properties.
type StorageMappingInputProperties struct {
	TargetStorageClassificationID *string `json:"targetStorageClassificationId,omitempty"`
}

// Subnet is subnets of the network.
type Subnet struct {
	Name         *string   `json:"name,omitempty"`
	FriendlyName *string   `json:"friendlyName,omitempty"`
	AddressList  *[]string `json:"addressList,omitempty"`
}

// SwitchProtectionInput is switch protection input.
type SwitchProtectionInput struct {
	Properties *SwitchProtectionInputProperties `json:"properties,omitempty"`
}

// SwitchProtectionInputProperties is switch protection input properties.
type SwitchProtectionInputProperties struct {
	ReplicationProtectedItemName *string                               `json:"replicationProtectedItemName,omitempty"`
	ProviderSpecificDetails      SwitchProtectionProviderSpecificInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SwitchProtectionInputProperties struct.
func (spip *SwitchProtectionInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["replicationProtectedItemName"]
	if v != nil {
		var replicationProtectedItemName string
		err = json.Unmarshal(*m["replicationProtectedItemName"], &replicationProtectedItemName)
		if err != nil {
			return err
		}
		spip.ReplicationProtectedItemName = &replicationProtectedItemName
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalSwitchProtectionProviderSpecificInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		spip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// SwitchProtectionJobDetails is this class represents details for switch protection job.
type SwitchProtectionJobDetails struct {
	AffectedObjectDetails         *map[string]*string    `json:"affectedObjectDetails,omitempty"`
	InstanceType                  InstanceTypeJobDetails `json:"instanceType,omitempty"`
	NewReplicationProtectedItemID *string                `json:"newReplicationProtectedItemId,omitempty"`
}

// MarshalJSON is the custom marshaler for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) MarshalJSON() ([]byte, error) {
	spjd.InstanceType = InstanceTypeSwitchProtectionJobDetails
	type Alias SwitchProtectionJobDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(spjd),
	})
}

// AsAsrJobDetails is the JobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the JobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return nil, false
}

// AsFailoverJobDetails is the JobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the JobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the JobDetails implementation for SwitchProtectionJobDetails.
func (spjd SwitchProtectionJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return &spjd, true
}

// SwitchProtectionProviderSpecificInput is provider specific switch protection input.
type SwitchProtectionProviderSpecificInput interface {
	AsA2ASwitchProtectionInput() (*A2ASwitchProtectionInput, bool)
}

func unmarshalSwitchProtectionProviderSpecificInput(body []byte) (SwitchProtectionProviderSpecificInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeA2A):
		var aspi A2ASwitchProtectionInput
		err := json.Unmarshal(body, &aspi)
		return aspi, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalSwitchProtectionProviderSpecificInputArray(body []byte) ([]SwitchProtectionProviderSpecificInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sppsiArray := make([]SwitchProtectionProviderSpecificInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sppsi, err := unmarshalSwitchProtectionProviderSpecificInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		sppsiArray[index] = sppsi
	}
	return sppsiArray, nil
}

// TaskTypeDetails is task details based on specific task type.
type TaskTypeDetails interface {
	AsJobTaskDetails() (*JobTaskDetails, bool)
	AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool)
	AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool)
	AsManualActionTaskDetails() (*ManualActionTaskDetails, bool)
	AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool)
	AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool)
	AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool)
	AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool)
}

func unmarshalTaskTypeDetails(body []byte) (TaskTypeDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeJobTaskDetails):
		var jtd JobTaskDetails
		err := json.Unmarshal(body, &jtd)
		return jtd, err
	case string(InstanceTypeVirtualMachineTaskDetails):
		var vmtd VirtualMachineTaskDetails
		err := json.Unmarshal(body, &vmtd)
		return vmtd, err
	case string(InstanceTypeFabricReplicationGroupTaskDetails):
		var frgtd FabricReplicationGroupTaskDetails
		err := json.Unmarshal(body, &frgtd)
		return frgtd, err
	case string(InstanceTypeManualActionTaskDetails):
		var matd ManualActionTaskDetails
		err := json.Unmarshal(body, &matd)
		return matd, err
	case string(InstanceTypeScriptActionTaskDetails):
		var satd ScriptActionTaskDetails
		err := json.Unmarshal(body, &satd)
		return satd, err
	case string(InstanceTypeVMNicUpdatesTaskDetails):
		var vnutd VMNicUpdatesTaskDetails
		err := json.Unmarshal(body, &vnutd)
		return vnutd, err
	case string(InstanceTypeConsistencyCheckTaskDetails):
		var cctd ConsistencyCheckTaskDetails
		err := json.Unmarshal(body, &cctd)
		return cctd, err
	case string(InstanceTypeAutomationRunbookTaskDetails):
		var artd AutomationRunbookTaskDetails
		err := json.Unmarshal(body, &artd)
		return artd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalTaskTypeDetailsArray(body []byte) ([]TaskTypeDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ttdArray := make([]TaskTypeDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ttd, err := unmarshalTaskTypeDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		ttdArray[index] = ttd
	}
	return ttdArray, nil
}

// TestFailoverCleanupInput is input definition for test failover cleanup.
type TestFailoverCleanupInput struct {
	Properties *TestFailoverCleanupInputProperties `json:"properties,omitempty"`
}

// TestFailoverCleanupInputProperties is input definition for test failover cleanup input properties.
type TestFailoverCleanupInputProperties struct {
	Comments *string `json:"comments,omitempty"`
}

// TestFailoverInput is input definition for planned failover.
type TestFailoverInput struct {
	Properties *TestFailoverInputProperties `json:"properties,omitempty"`
}

// TestFailoverInputProperties is input definition for planned failover input properties.
type TestFailoverInputProperties struct {
	FailoverDirection       *string                       `json:"failoverDirection,omitempty"`
	NetworkType             *string                       `json:"networkType,omitempty"`
	NetworkID               *string                       `json:"networkId,omitempty"`
	SkipTestFailoverCleanup *string                       `json:"skipTestFailoverCleanup,omitempty"`
	ProviderSpecificDetails ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TestFailoverInputProperties struct.
func (tfip *TestFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection string
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		tfip.FailoverDirection = &failoverDirection
	}

	v = m["networkType"]
	if v != nil {
		var networkType string
		err = json.Unmarshal(*m["networkType"], &networkType)
		if err != nil {
			return err
		}
		tfip.NetworkType = &networkType
	}

	v = m["networkId"]
	if v != nil {
		var networkID string
		err = json.Unmarshal(*m["networkId"], &networkID)
		if err != nil {
			return err
		}
		tfip.NetworkID = &networkID
	}

	v = m["skipTestFailoverCleanup"]
	if v != nil {
		var skipTestFailoverCleanup string
		err = json.Unmarshal(*m["skipTestFailoverCleanup"], &skipTestFailoverCleanup)
		if err != nil {
			return err
		}
		tfip.SkipTestFailoverCleanup = &skipTestFailoverCleanup
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalProviderSpecificFailoverInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		tfip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// TestFailoverJobDetails is this class represents the details for a test failover job.
type TestFailoverJobDetails struct {
	AffectedObjectDetails *map[string]*string                        `json:"affectedObjectDetails,omitempty"`
	InstanceType          InstanceTypeJobDetails                     `json:"instanceType,omitempty"`
	TestFailoverStatus    *string                                    `json:"testFailoverStatus,omitempty"`
	Comments              *string                                    `json:"comments,omitempty"`
	NetworkName           *string                                    `json:"networkName,omitempty"`
	NetworkFriendlyName   *string                                    `json:"networkFriendlyName,omitempty"`
	NetworkType           *string                                    `json:"networkType,omitempty"`
	ProtectedItemDetails  *[]FailoverReplicationProtectedItemDetails `json:"protectedItemDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) MarshalJSON() ([]byte, error) {
	tfjd.InstanceType = InstanceTypeTestFailoverJobDetails
	type Alias TestFailoverJobDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(tfjd),
	})
}

// AsAsrJobDetails is the JobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsAsrJobDetails() (*AsrJobDetails, bool) {
	return nil, false
}

// AsTestFailoverJobDetails is the JobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsTestFailoverJobDetails() (*TestFailoverJobDetails, bool) {
	return &tfjd, true
}

// AsFailoverJobDetails is the JobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsFailoverJobDetails() (*FailoverJobDetails, bool) {
	return nil, false
}

// AsExportJobDetails is the JobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsExportJobDetails() (*ExportJobDetails, bool) {
	return nil, false
}

// AsSwitchProtectionJobDetails is the JobDetails implementation for TestFailoverJobDetails.
func (tfjd TestFailoverJobDetails) AsSwitchProtectionJobDetails() (*SwitchProtectionJobDetails, bool) {
	return nil, false
}

// UnplannedFailoverInput is input definition for planned failover.
type UnplannedFailoverInput struct {
	Properties *UnplannedFailoverInputProperties `json:"properties,omitempty"`
}

// UnplannedFailoverInputProperties is input definition for planned failover input properties.
type UnplannedFailoverInputProperties struct {
	FailoverDirection       *string                       `json:"failoverDirection,omitempty"`
	SourceSiteOperations    *string                       `json:"sourceSiteOperations,omitempty"`
	ProviderSpecificDetails ProviderSpecificFailoverInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnplannedFailoverInputProperties struct.
func (ufip *UnplannedFailoverInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["failoverDirection"]
	if v != nil {
		var failoverDirection string
		err = json.Unmarshal(*m["failoverDirection"], &failoverDirection)
		if err != nil {
			return err
		}
		ufip.FailoverDirection = &failoverDirection
	}

	v = m["sourceSiteOperations"]
	if v != nil {
		var sourceSiteOperations string
		err = json.Unmarshal(*m["sourceSiteOperations"], &sourceSiteOperations)
		if err != nil {
			return err
		}
		ufip.SourceSiteOperations = &sourceSiteOperations
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalProviderSpecificFailoverInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		ufip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// UpdateMobilityServiceRequest is request to update the mobility service on a protected item.
type UpdateMobilityServiceRequest struct {
	Properties *UpdateMobilityServiceRequestProperties `json:"properties,omitempty"`
}

// UpdateMobilityServiceRequestProperties is the properties of an update mobility service request.
type UpdateMobilityServiceRequestProperties struct {
	RunAsAccountID *string `json:"runAsAccountId,omitempty"`
}

// UpdateNetworkMappingInput is update network mapping input.
type UpdateNetworkMappingInput struct {
	Properties *UpdateNetworkMappingInputProperties `json:"properties,omitempty"`
}

// UpdateNetworkMappingInputProperties is common input details for network mapping operation.
type UpdateNetworkMappingInputProperties struct {
	RecoveryFabricName    *string                                 `json:"recoveryFabricName,omitempty"`
	RecoveryNetworkID     *string                                 `json:"recoveryNetworkId,omitempty"`
	FabricSpecificDetails FabricSpecificUpdateNetworkMappingInput `json:"fabricSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateNetworkMappingInputProperties struct.
func (unmip *UpdateNetworkMappingInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["recoveryFabricName"]
	if v != nil {
		var recoveryFabricName string
		err = json.Unmarshal(*m["recoveryFabricName"], &recoveryFabricName)
		if err != nil {
			return err
		}
		unmip.RecoveryFabricName = &recoveryFabricName
	}

	v = m["recoveryNetworkId"]
	if v != nil {
		var recoveryNetworkID string
		err = json.Unmarshal(*m["recoveryNetworkId"], &recoveryNetworkID)
		if err != nil {
			return err
		}
		unmip.RecoveryNetworkID = &recoveryNetworkID
	}

	v = m["fabricSpecificDetails"]
	if v != nil {
		fabricSpecificDetails, err := unmarshalFabricSpecificUpdateNetworkMappingInput(*m["fabricSpecificDetails"])
		if err != nil {
			return err
		}
		unmip.FabricSpecificDetails = fabricSpecificDetails
	}

	return nil
}

// UpdatePolicyInput is update protection profile input.
type UpdatePolicyInput struct {
	Properties *UpdatePolicyInputProperties `json:"properties,omitempty"`
}

// UpdatePolicyInputProperties is policy update properties.
type UpdatePolicyInputProperties struct {
	ReplicationProviderSettings PolicyProviderSpecificInput `json:"replicationProviderSettings,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdatePolicyInputProperties struct.
func (upip *UpdatePolicyInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["replicationProviderSettings"]
	if v != nil {
		replicationProviderSettings, err := unmarshalPolicyProviderSpecificInput(*m["replicationProviderSettings"])
		if err != nil {
			return err
		}
		upip.ReplicationProviderSettings = replicationProviderSettings
	}

	return nil
}

// UpdateRecoveryPlanInput is update recovery plan input class.
type UpdateRecoveryPlanInput struct {
	Properties *UpdateRecoveryPlanInputProperties `json:"properties,omitempty"`
}

// UpdateRecoveryPlanInputProperties is recovery plan updation properties.
type UpdateRecoveryPlanInputProperties struct {
	Groups *[]RecoveryPlanGroup `json:"groups,omitempty"`
}

// UpdateReplicationProtectedItemInput is update replication protected item input.
type UpdateReplicationProtectedItemInput struct {
	Properties *UpdateReplicationProtectedItemInputProperties `json:"properties,omitempty"`
}

// UpdateReplicationProtectedItemInputProperties is update protected item input properties.
type UpdateReplicationProtectedItemInputProperties struct {
	RecoveryAzureVMName            *string                                     `json:"recoveryAzureVMName,omitempty"`
	RecoveryAzureVMSize            *string                                     `json:"recoveryAzureVMSize,omitempty"`
	SelectedRecoveryAzureNetworkID *string                                     `json:"selectedRecoveryAzureNetworkId,omitempty"`
	EnableRDPOnTargetOption        *string                                     `json:"enableRDPOnTargetOption,omitempty"`
	VMNics                         *[]VMNicInputDetails                        `json:"vmNics,omitempty"`
	LicenseType                    LicenseType                                 `json:"licenseType,omitempty"`
	RecoveryAvailabilitySetID      *string                                     `json:"recoveryAvailabilitySetId,omitempty"`
	ProviderSpecificDetails        UpdateReplicationProtectedItemProviderInput `json:"providerSpecificDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UpdateReplicationProtectedItemInputProperties struct.
func (urpiip *UpdateReplicationProtectedItemInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["recoveryAzureVMName"]
	if v != nil {
		var recoveryAzureVMName string
		err = json.Unmarshal(*m["recoveryAzureVMName"], &recoveryAzureVMName)
		if err != nil {
			return err
		}
		urpiip.RecoveryAzureVMName = &recoveryAzureVMName
	}

	v = m["recoveryAzureVMSize"]
	if v != nil {
		var recoveryAzureVMSize string
		err = json.Unmarshal(*m["recoveryAzureVMSize"], &recoveryAzureVMSize)
		if err != nil {
			return err
		}
		urpiip.RecoveryAzureVMSize = &recoveryAzureVMSize
	}

	v = m["selectedRecoveryAzureNetworkId"]
	if v != nil {
		var selectedRecoveryAzureNetworkID string
		err = json.Unmarshal(*m["selectedRecoveryAzureNetworkId"], &selectedRecoveryAzureNetworkID)
		if err != nil {
			return err
		}
		urpiip.SelectedRecoveryAzureNetworkID = &selectedRecoveryAzureNetworkID
	}

	v = m["enableRDPOnTargetOption"]
	if v != nil {
		var enableRDPOnTargetOption string
		err = json.Unmarshal(*m["enableRDPOnTargetOption"], &enableRDPOnTargetOption)
		if err != nil {
			return err
		}
		urpiip.EnableRDPOnTargetOption = &enableRDPOnTargetOption
	}

	v = m["vmNics"]
	if v != nil {
		var VMNics []VMNicInputDetails
		err = json.Unmarshal(*m["vmNics"], &VMNics)
		if err != nil {
			return err
		}
		urpiip.VMNics = &VMNics
	}

	v = m["licenseType"]
	if v != nil {
		var licenseType LicenseType
		err = json.Unmarshal(*m["licenseType"], &licenseType)
		if err != nil {
			return err
		}
		urpiip.LicenseType = licenseType
	}

	v = m["recoveryAvailabilitySetId"]
	if v != nil {
		var recoveryAvailabilitySetID string
		err = json.Unmarshal(*m["recoveryAvailabilitySetId"], &recoveryAvailabilitySetID)
		if err != nil {
			return err
		}
		urpiip.RecoveryAvailabilitySetID = &recoveryAvailabilitySetID
	}

	v = m["providerSpecificDetails"]
	if v != nil {
		providerSpecificDetails, err := unmarshalUpdateReplicationProtectedItemProviderInput(*m["providerSpecificDetails"])
		if err != nil {
			return err
		}
		urpiip.ProviderSpecificDetails = providerSpecificDetails
	}

	return nil
}

// UpdateReplicationProtectedItemProviderInput is update replication protected item provider specific input.
type UpdateReplicationProtectedItemProviderInput interface {
	AsHyperVReplicaAzureUpdateReplicationProtectedItemInput() (*HyperVReplicaAzureUpdateReplicationProtectedItemInput, bool)
	AsInMageAzureV2UpdateReplicationProtectedItemInput() (*InMageAzureV2UpdateReplicationProtectedItemInput, bool)
	AsA2AUpdateReplicationProtectedItemInput() (*A2AUpdateReplicationProtectedItemInput, bool)
}

func unmarshalUpdateReplicationProtectedItemProviderInput(body []byte) (UpdateReplicationProtectedItemProviderInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["instanceType"] {
	case string(InstanceTypeHyperVReplicaAzure):
		var hvraurpii HyperVReplicaAzureUpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &hvraurpii)
		return hvraurpii, err
	case string(InstanceTypeInMageAzureV2):
		var imavurpii InMageAzureV2UpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &imavurpii)
		return imavurpii, err
	case string(InstanceTypeA2A):
		var aurpii A2AUpdateReplicationProtectedItemInput
		err := json.Unmarshal(body, &aurpii)
		return aurpii, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalUpdateReplicationProtectedItemProviderInputArray(body []byte) ([]UpdateReplicationProtectedItemProviderInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	urpipiArray := make([]UpdateReplicationProtectedItemProviderInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		urpipi, err := unmarshalUpdateReplicationProtectedItemProviderInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		urpipiArray[index] = urpipi
	}
	return urpipiArray, nil
}

// UpdateVCenterRequest is input required to update vCenter.
type UpdateVCenterRequest struct {
	Properties *UpdateVCenterRequestProperties `json:"properties,omitempty"`
}

// UpdateVCenterRequestProperties is the properties of an update vCenter request.
type UpdateVCenterRequestProperties struct {
	FriendlyName    *string `json:"friendlyName,omitempty"`
	IPAddress       *string `json:"ipAddress,omitempty"`
	ProcessServerID *string `json:"processServerId,omitempty"`
	Port            *string `json:"port,omitempty"`
	RunAsAccountID  *string `json:"runAsAccountId,omitempty"`
}

// VaultHealthDetails is vault health details definition.
type VaultHealthDetails struct {
	autorest.Response `json:"-"`
	ID                *string                `json:"id,omitempty"`
	Name              *string                `json:"name,omitempty"`
	Type              *string                `json:"type,omitempty"`
	Location          *string                `json:"location,omitempty"`
	Properties        *VaultHealthProperties `json:"properties,omitempty"`
}

// VaultHealthProperties is class to define the health summary of the Vault.
type VaultHealthProperties struct {
	VaultErrors          *[]HealthError         `json:"vaultErrors,omitempty"`
	ProtectedItemsHealth *ResourceHealthSummary `json:"protectedItemsHealth,omitempty"`
	FabricsHealth        *ResourceHealthSummary `json:"fabricsHealth,omitempty"`
}

// VCenter is vCenter definition.
type VCenter struct {
	autorest.Response `json:"-"`
	ID                *string            `json:"id,omitempty"`
	Name              *string            `json:"name,omitempty"`
	Type              *string            `json:"type,omitempty"`
	Location          *string            `json:"location,omitempty"`
	Properties        *VCenterProperties `json:"properties,omitempty"`
}

// VCenterCollection is collection of vCenter details.
type VCenterCollection struct {
	autorest.Response `json:"-"`
	Value             *[]VCenter `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// VCenterCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VCenterCollection) VCenterCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VCenterProperties is vCenter properties.
type VCenterProperties struct {
	FriendlyName          *string    `json:"friendlyName,omitempty"`
	InternalID            *string    `json:"internalId,omitempty"`
	LastHeartbeat         *date.Time `json:"lastHeartbeat,omitempty"`
	DiscoveryStatus       *string    `json:"discoveryStatus,omitempty"`
	ProcessServerID       *string    `json:"processServerId,omitempty"`
	IPAddress             *string    `json:"ipAddress,omitempty"`
	InfrastructureID      *string    `json:"infrastructureId,omitempty"`
	Port                  *string    `json:"port,omitempty"`
	RunAsAccountID        *string    `json:"runAsAccountId,omitempty"`
	FabricArmResourceName *string    `json:"fabricArmResourceName,omitempty"`
}

// VirtualMachineTaskDetails is this class represents the virtual machine task details.
type VirtualMachineTaskDetails struct {
	InstanceType        InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	SkippedReason       *string                     `json:"skippedReason,omitempty"`
	SkippedReasonString *string                     `json:"skippedReasonString,omitempty"`
	JobTask             *JobEntity                  `json:"jobTask,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) MarshalJSON() ([]byte, error) {
	vmtd.InstanceType = InstanceTypeVirtualMachineTaskDetails
	type Alias VirtualMachineTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmtd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return &vmtd, true
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return nil, false
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for VirtualMachineTaskDetails.
func (vmtd VirtualMachineTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// VmmDetails is VMM fabric specific details.
type VmmDetails struct {
	InstanceType InstanceTypeFabricSpecificDetails `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmDetails.
func (vd VmmDetails) MarshalJSON() ([]byte, error) {
	vd.InstanceType = InstanceTypeVMM
	type Alias VmmDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vd),
	})
}

// AsAzureFabricSpecificDetails is the FabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the FabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVmmDetails() (*VmmDetails, bool) {
	return &vd, true
}

// AsHyperVSiteDetails is the FabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the FabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the FabricSpecificDetails implementation for VmmDetails.
func (vd VmmDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// VmmToAzureCreateNetworkMappingInput is create network mappings input properties/behaviour specific to Vmm to Azure
// Network mapping.
type VmmToAzureCreateNetworkMappingInput struct {
	InstanceType InstanceTypeFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtacnmi.InstanceType = InstanceTypeVmmToAzure
	type Alias VmmToAzureCreateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtacnmi),
	})
}

// AsAzureToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return &vtacnmi, true
}

// AsVmmToVmmCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToAzureCreateNetworkMappingInput.
func (vtacnmi VmmToAzureCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return nil, false
}

// VmmToAzureNetworkMappingSettings is e2A Network Mapping fabric specific settings.
type VmmToAzureNetworkMappingSettings struct {
	InstanceType InstanceTypeNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	vtanms.InstanceType = InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure
	type Alias VmmToAzureNetworkMappingSettings
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtanms),
	})
}

// AsAzureToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return &vtanms, true
}

// AsVmmToVmmNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToAzureNetworkMappingSettings.
func (vtanms VmmToAzureNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return nil, false
}

// VmmToAzureUpdateNetworkMappingInput is update network mappings input properties/behaviour specific to vmm to azure.
type VmmToAzureUpdateNetworkMappingInput struct {
	InstanceType InstanceTypeFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtaunmi.InstanceType = InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure
	type Alias VmmToAzureUpdateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtaunmi),
	})
}

// AsAzureToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return &vtaunmi, true
}

// AsVmmToVmmUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToAzureUpdateNetworkMappingInput.
func (vtaunmi VmmToAzureUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return nil, false
}

// VmmToVmmCreateNetworkMappingInput is create network mappings input properties/behaviour specific to vmm to vmm
// Network mapping.
type VmmToVmmCreateNetworkMappingInput struct {
	InstanceType InstanceTypeFabricSpecificCreateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtvcnmi.InstanceType = InstanceTypeVmmToVmm
	type Alias VmmToVmmCreateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtvcnmi),
	})
}

// AsAzureToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsAzureToAzureCreateNetworkMappingInput() (*AzureToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsVmmToAzureCreateNetworkMappingInput() (*VmmToAzureCreateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmCreateNetworkMappingInput is the FabricSpecificCreateNetworkMappingInput implementation for VmmToVmmCreateNetworkMappingInput.
func (vtvcnmi VmmToVmmCreateNetworkMappingInput) AsVmmToVmmCreateNetworkMappingInput() (*VmmToVmmCreateNetworkMappingInput, bool) {
	return &vtvcnmi, true
}

// VmmToVmmNetworkMappingSettings is e2E Network Mapping fabric specific settings.
type VmmToVmmNetworkMappingSettings struct {
	InstanceType InstanceTypeNetworkMappingFabricSpecificSettings `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) MarshalJSON() ([]byte, error) {
	vtvnms.InstanceType = InstanceTypeNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm
	type Alias VmmToVmmNetworkMappingSettings
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtvnms),
	})
}

// AsAzureToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsAzureToAzureNetworkMappingSettings() (*AzureToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToAzureNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsVmmToAzureNetworkMappingSettings() (*VmmToAzureNetworkMappingSettings, bool) {
	return nil, false
}

// AsVmmToVmmNetworkMappingSettings is the NetworkMappingFabricSpecificSettings implementation for VmmToVmmNetworkMappingSettings.
func (vtvnms VmmToVmmNetworkMappingSettings) AsVmmToVmmNetworkMappingSettings() (*VmmToVmmNetworkMappingSettings, bool) {
	return &vtvnms, true
}

// VmmToVmmUpdateNetworkMappingInput is update network mappings input properties/behaviour specific to vmm to vmm.
type VmmToVmmUpdateNetworkMappingInput struct {
	InstanceType InstanceTypeFabricSpecificUpdateNetworkMappingInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) MarshalJSON() ([]byte, error) {
	vtvunmi.InstanceType = InstanceTypeFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm
	type Alias VmmToVmmUpdateNetworkMappingInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vtvunmi),
	})
}

// AsAzureToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsAzureToAzureUpdateNetworkMappingInput() (*AzureToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToAzureUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsVmmToAzureUpdateNetworkMappingInput() (*VmmToAzureUpdateNetworkMappingInput, bool) {
	return nil, false
}

// AsVmmToVmmUpdateNetworkMappingInput is the FabricSpecificUpdateNetworkMappingInput implementation for VmmToVmmUpdateNetworkMappingInput.
func (vtvunmi VmmToVmmUpdateNetworkMappingInput) AsVmmToVmmUpdateNetworkMappingInput() (*VmmToVmmUpdateNetworkMappingInput, bool) {
	return &vtvunmi, true
}

// VMNicDetails is hyper V VM network details.
type VMNicDetails struct {
	NicID                     *string `json:"nicId,omitempty"`
	ReplicaNicID              *string `json:"replicaNicId,omitempty"`
	SourceNicArmID            *string `json:"sourceNicArmId,omitempty"`
	VMSubnetName              *string `json:"vMSubnetName,omitempty"`
	VMNetworkName             *string `json:"vMNetworkName,omitempty"`
	RecoveryVMNetworkID       *string `json:"recoveryVMNetworkId,omitempty"`
	RecoveryVMSubnetName      *string `json:"recoveryVMSubnetName,omitempty"`
	IPAddressType             *string `json:"ipAddressType,omitempty"`
	PrimaryNicStaticIPAddress *string `json:"primaryNicStaticIPAddress,omitempty"`
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	SelectionType             *string `json:"selectionType,omitempty"`
	RecoveryNicIPAddressType  *string `json:"recoveryNicIpAddressType,omitempty"`
}

// VMNicInputDetails is hyper V VM network input details.
type VMNicInputDetails struct {
	NicID                     *string `json:"nicId,omitempty"`
	RecoveryVMSubnetName      *string `json:"recoveryVMSubnetName,omitempty"`
	ReplicaNicStaticIPAddress *string `json:"replicaNicStaticIPAddress,omitempty"`
	SelectionType             *string `json:"selectionType,omitempty"`
}

// VMNicUpdatesTaskDetails is this class represents the vm NicUpdates task details.
type VMNicUpdatesTaskDetails struct {
	InstanceType InstanceTypeTaskTypeDetails `json:"instanceType,omitempty"`
	VMID         *string                     `json:"vmId,omitempty"`
	NicID        *string                     `json:"nicId,omitempty"`
	Name         *string                     `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) MarshalJSON() ([]byte, error) {
	vnutd.InstanceType = InstanceTypeVMNicUpdatesTaskDetails
	type Alias VMNicUpdatesTaskDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vnutd),
	})
}

// AsJobTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsJobTaskDetails() (*JobTaskDetails, bool) {
	return nil, false
}

// AsVirtualMachineTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsVirtualMachineTaskDetails() (*VirtualMachineTaskDetails, bool) {
	return nil, false
}

// AsFabricReplicationGroupTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsFabricReplicationGroupTaskDetails() (*FabricReplicationGroupTaskDetails, bool) {
	return nil, false
}

// AsManualActionTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsManualActionTaskDetails() (*ManualActionTaskDetails, bool) {
	return nil, false
}

// AsScriptActionTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsScriptActionTaskDetails() (*ScriptActionTaskDetails, bool) {
	return nil, false
}

// AsVMNicUpdatesTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsVMNicUpdatesTaskDetails() (*VMNicUpdatesTaskDetails, bool) {
	return &vnutd, true
}

// AsConsistencyCheckTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsConsistencyCheckTaskDetails() (*ConsistencyCheckTaskDetails, bool) {
	return nil, false
}

// AsAutomationRunbookTaskDetails is the TaskTypeDetails implementation for VMNicUpdatesTaskDetails.
func (vnutd VMNicUpdatesTaskDetails) AsAutomationRunbookTaskDetails() (*AutomationRunbookTaskDetails, bool) {
	return nil, false
}

// VMwareCbtPolicyCreationInput is vMware Cbt Policy creation input.
type VMwareCbtPolicyCreationInput struct {
	InstanceType                      InstanceTypePolicyProviderSpecificInput `json:"instanceType,omitempty"`
	RecoveryPointHistory              *int32                                  `json:"recoveryPointHistory,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                  `json:"crashConsistentFrequencyInMinutes,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                  `json:"appConsistentFrequencyInMinutes,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) MarshalJSON() ([]byte, error) {
	vmcpci.InstanceType = InstanceTypePolicyProviderSpecificInputInstanceTypeVMwareCbt
	type Alias VMwareCbtPolicyCreationInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmcpci),
	})
}

// AsHyperVReplicaAzurePolicyInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaAzurePolicyInput() (*HyperVReplicaAzurePolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaPolicyInput() (*HyperVReplicaPolicyInput, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsHyperVReplicaBluePolicyInput() (*HyperVReplicaBluePolicyInput, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsInMageAzureV2PolicyInput() (*InMageAzureV2PolicyInput, bool) {
	return nil, false
}

// AsInMagePolicyInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsInMagePolicyInput() (*InMagePolicyInput, bool) {
	return nil, false
}

// AsA2APolicyCreationInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsA2APolicyCreationInput() (*A2APolicyCreationInput, bool) {
	return nil, false
}

// AsVMwareCbtPolicyCreationInput is the PolicyProviderSpecificInput implementation for VMwareCbtPolicyCreationInput.
func (vmcpci VMwareCbtPolicyCreationInput) AsVMwareCbtPolicyCreationInput() (*VMwareCbtPolicyCreationInput, bool) {
	return &vmcpci, true
}

// VmwareCbtPolicyDetails is vMware Cbt specific policy details.
type VmwareCbtPolicyDetails struct {
	InstanceType                      InstanceTypePolicyProviderSpecificDetails `json:"instanceType,omitempty"`
	RecoveryPointThresholdInMinutes   *int32                                    `json:"recoveryPointThresholdInMinutes,omitempty"`
	RecoveryPointHistory              *int32                                    `json:"recoveryPointHistory,omitempty"`
	AppConsistentFrequencyInMinutes   *int32                                    `json:"appConsistentFrequencyInMinutes,omitempty"`
	CrashConsistentFrequencyInMinutes *int32                                    `json:"crashConsistentFrequencyInMinutes,omitempty"`
}

// MarshalJSON is the custom marshaler for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) MarshalJSON() ([]byte, error) {
	vcpd.InstanceType = InstanceTypePolicyProviderSpecificDetailsInstanceTypeVMwareCbt
	type Alias VmwareCbtPolicyDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vcpd),
	})
}

// AsHyperVReplicaAzurePolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaAzurePolicyDetails() (*HyperVReplicaAzurePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBasePolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaBasePolicyDetails() (*HyperVReplicaBasePolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaPolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaPolicyDetails() (*HyperVReplicaPolicyDetails, bool) {
	return nil, false
}

// AsHyperVReplicaBluePolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsHyperVReplicaBluePolicyDetails() (*HyperVReplicaBluePolicyDetails, bool) {
	return nil, false
}

// AsInMageBasePolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMageBasePolicyDetails() (*InMageBasePolicyDetails, bool) {
	return nil, false
}

// AsInMageAzureV2PolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMageAzureV2PolicyDetails() (*InMageAzureV2PolicyDetails, bool) {
	return nil, false
}

// AsInMagePolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsInMagePolicyDetails() (*InMagePolicyDetails, bool) {
	return nil, false
}

// AsA2APolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsA2APolicyDetails() (*A2APolicyDetails, bool) {
	return nil, false
}

// AsRcmAzureMigrationPolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsRcmAzureMigrationPolicyDetails() (*RcmAzureMigrationPolicyDetails, bool) {
	return nil, false
}

// AsVmwareCbtPolicyDetails is the PolicyProviderSpecificDetails implementation for VmwareCbtPolicyDetails.
func (vcpd VmwareCbtPolicyDetails) AsVmwareCbtPolicyDetails() (*VmwareCbtPolicyDetails, bool) {
	return &vcpd, true
}

// VMwareDetails is store the fabric details specific to the VMware fabric.
type VMwareDetails struct {
	InstanceType               InstanceTypeFabricSpecificDetails `json:"instanceType,omitempty"`
	ProcessServers             *[]ProcessServer                  `json:"processServers,omitempty"`
	MasterTargetServers        *[]MasterTargetServer             `json:"masterTargetServers,omitempty"`
	RunAsAccounts              *[]RunAsAccount                   `json:"runAsAccounts,omitempty"`
	ReplicationPairCount       *string                           `json:"replicationPairCount,omitempty"`
	ProcessServerCount         *string                           `json:"processServerCount,omitempty"`
	AgentCount                 *string                           `json:"agentCount,omitempty"`
	ProtectedServers           *string                           `json:"protectedServers,omitempty"`
	SystemLoad                 *string                           `json:"systemLoad,omitempty"`
	SystemLoadStatus           *string                           `json:"systemLoadStatus,omitempty"`
	CPULoad                    *string                           `json:"cpuLoad,omitempty"`
	CPULoadStatus              *string                           `json:"cpuLoadStatus,omitempty"`
	TotalMemoryInBytes         *int64                            `json:"totalMemoryInBytes,omitempty"`
	AvailableMemoryInBytes     *int64                            `json:"availableMemoryInBytes,omitempty"`
	MemoryUsageStatus          *string                           `json:"memoryUsageStatus,omitempty"`
	TotalSpaceInBytes          *int64                            `json:"totalSpaceInBytes,omitempty"`
	AvailableSpaceInBytes      *int64                            `json:"availableSpaceInBytes,omitempty"`
	SpaceUsageStatus           *string                           `json:"spaceUsageStatus,omitempty"`
	WebLoad                    *string                           `json:"webLoad,omitempty"`
	WebLoadStatus              *string                           `json:"webLoadStatus,omitempty"`
	DatabaseServerLoad         *string                           `json:"databaseServerLoad,omitempty"`
	DatabaseServerLoadStatus   *string                           `json:"databaseServerLoadStatus,omitempty"`
	CsServiceStatus            *string                           `json:"csServiceStatus,omitempty"`
	IPAddress                  *string                           `json:"ipAddress,omitempty"`
	AgentVersion               *string                           `json:"agentVersion,omitempty"`
	HostName                   *string                           `json:"hostName,omitempty"`
	LastHeartbeat              *date.Time                        `json:"lastHeartbeat,omitempty"`
	VersionStatus              *string                           `json:"versionStatus,omitempty"`
	SslCertExpiryDate          *date.Time                        `json:"sslCertExpiryDate,omitempty"`
	SslCertExpiryRemainingDays *int32                            `json:"sslCertExpiryRemainingDays,omitempty"`
	PsTemplateVersion          *string                           `json:"psTemplateVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareDetails.
func (vmd VMwareDetails) MarshalJSON() ([]byte, error) {
	vmd.InstanceType = InstanceTypeVMware
	type Alias VMwareDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmd),
	})
}

// AsAzureFabricSpecificDetails is the FabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the FabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the FabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the FabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return &vmd, true
}

// AsVMwareV2FabricSpecificDetails is the FabricSpecificDetails implementation for VMwareDetails.
func (vmd VMwareDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return nil, false
}

// VMwareV2FabricCreationInput is fabric provider specific settings.
type VMwareV2FabricCreationInput struct {
	InstanceType InstanceTypeFabricSpecificCreationInput `json:"instanceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) MarshalJSON() ([]byte, error) {
	vmvfci.InstanceType = InstanceTypeFabricSpecificCreationInputInstanceTypeVMwareV2
	type Alias VMwareV2FabricCreationInput
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmvfci),
	})
}

// AsAzureFabricCreationInput is the FabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsAzureFabricCreationInput() (*AzureFabricCreationInput, bool) {
	return nil, false
}

// AsVMwareV2FabricCreationInput is the FabricSpecificCreationInput implementation for VMwareV2FabricCreationInput.
func (vmvfci VMwareV2FabricCreationInput) AsVMwareV2FabricCreationInput() (*VMwareV2FabricCreationInput, bool) {
	return &vmvfci, true
}

// VMwareV2FabricSpecificDetails is vMwareV2 fabric Specific Details.
type VMwareV2FabricSpecificDetails struct {
	InstanceType       InstanceTypeFabricSpecificDetails `json:"instanceType,omitempty"`
	SrsServiceEndpoint *string                           `json:"srsServiceEndpoint,omitempty"`
	RcmServiceEndpoint *string                           `json:"rcmServiceEndpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) MarshalJSON() ([]byte, error) {
	vmvfsd.InstanceType = InstanceTypeVMwareV2
	type Alias VMwareV2FabricSpecificDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmvfsd),
	})
}

// AsAzureFabricSpecificDetails is the FabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsAzureFabricSpecificDetails() (*AzureFabricSpecificDetails, bool) {
	return nil, false
}

// AsVmmDetails is the FabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVmmDetails() (*VmmDetails, bool) {
	return nil, false
}

// AsHyperVSiteDetails is the FabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsHyperVSiteDetails() (*HyperVSiteDetails, bool) {
	return nil, false
}

// AsVMwareDetails is the FabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVMwareDetails() (*VMwareDetails, bool) {
	return nil, false
}

// AsVMwareV2FabricSpecificDetails is the FabricSpecificDetails implementation for VMwareV2FabricSpecificDetails.
func (vmvfsd VMwareV2FabricSpecificDetails) AsVMwareV2FabricSpecificDetails() (*VMwareV2FabricSpecificDetails, bool) {
	return &vmvfsd, true
}

// VMwareVirtualMachineDetails is vMware provider specific settings
type VMwareVirtualMachineDetails struct {
	InstanceType            InstanceTypeConfigurationSettings `json:"instanceType,omitempty"`
	AgentGeneratedID        *string                           `json:"agentGeneratedId,omitempty"`
	AgentInstalled          *string                           `json:"agentInstalled,omitempty"`
	OsType                  *string                           `json:"osType,omitempty"`
	AgentVersion            *string                           `json:"agentVersion,omitempty"`
	IPAddress               *string                           `json:"ipAddress,omitempty"`
	PoweredOn               *string                           `json:"poweredOn,omitempty"`
	VCenterInfrastructureID *string                           `json:"vCenterInfrastructureId,omitempty"`
	DiscoveryType           *string                           `json:"discoveryType,omitempty"`
	DiskDetails             *[]InMageDiskDetails              `json:"diskDetails,omitempty"`
	ValidationErrors        *[]HealthError                    `json:"validationErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) MarshalJSON() ([]byte, error) {
	vmvmd.InstanceType = InstanceTypeVMwareVirtualMachine
	type Alias VMwareVirtualMachineDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(vmvmd),
	})
}

// AsHyperVVirtualMachineDetails is the ConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsHyperVVirtualMachineDetails() (*HyperVVirtualMachineDetails, bool) {
	return nil, false
}

// AsVMwareVirtualMachineDetails is the ConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsVMwareVirtualMachineDetails() (*VMwareVirtualMachineDetails, bool) {
	return &vmvmd, true
}

// AsReplicationGroupDetails is the ConfigurationSettings implementation for VMwareVirtualMachineDetails.
func (vmvmd VMwareVirtualMachineDetails) AsReplicationGroupDetails() (*ReplicationGroupDetails, bool) {
	return nil, false
}
