package operationsmanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// CodeMessageError is the error body contract.
type CodeMessageError struct {
	Error *CodeMessageErrorError `json:"error,omitempty"`
}

// CodeMessageErrorError is the error details for a failed request.
type CodeMessageErrorError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Operation is supported operation of OperationsManagement resource provider.
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is display metadata associated with the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list solution operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// Solution is the container for solution.
type Solution struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Plan              *SolutionPlan       `json:"plan,omitempty"`
	Properties        *SolutionProperties `json:"properties,omitempty"`
}

// SolutionPlan is plan for solution object supported by the OperationsManagement resource provider.
type SolutionPlan struct {
	Name          *string `json:"name,omitempty"`
	Publisher     *string `json:"publisher,omitempty"`
	PromotionCode *string `json:"promotionCode,omitempty"`
	Product       *string `json:"product,omitempty"`
}

// SolutionProperties is solution properties supported by the OperationsManagement resource provider.
type SolutionProperties struct {
	WorkspaceResourceID *string   `json:"workspaceResourceId,omitempty"`
	ProvisioningState   *string   `json:"provisioningState,omitempty"`
	ContainedResources  *[]string `json:"containedResources,omitempty"`
	ReferencedResources *[]string `json:"referencedResources,omitempty"`
}

// SolutionPropertiesList is the list of solution response
type SolutionPropertiesList struct {
	autorest.Response `json:"-"`
	Value             *[]Solution `json:"value,omitempty"`
}
