package monitor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// Logs specifies the logs state for category type.
	Logs CategoryType = "Logs"
	// Metrics specifies the metrics state for category type.
	Metrics CategoryType = "Metrics"
)

// ComparisonOperationType enumerates the values for comparison operation type.
type ComparisonOperationType string

const (
	// Equals specifies the equals state for comparison operation type.
	Equals ComparisonOperationType = "Equals"
	// GreaterThan specifies the greater than state for comparison operation type.
	GreaterThan ComparisonOperationType = "GreaterThan"
	// GreaterThanOrEqual specifies the greater than or equal state for comparison operation type.
	GreaterThanOrEqual ComparisonOperationType = "GreaterThanOrEqual"
	// LessThan specifies the less than state for comparison operation type.
	LessThan ComparisonOperationType = "LessThan"
	// LessThanOrEqual specifies the less than or equal state for comparison operation type.
	LessThanOrEqual ComparisonOperationType = "LessThanOrEqual"
	// NotEquals specifies the not equals state for comparison operation type.
	NotEquals ComparisonOperationType = "NotEquals"
)

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// ConditionOperatorGreaterThan specifies the condition operator greater than state for condition operator.
	ConditionOperatorGreaterThan ConditionOperator = "GreaterThan"
	// ConditionOperatorGreaterThanOrEqual specifies the condition operator greater than or equal state for condition
	// operator.
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// ConditionOperatorLessThan specifies the condition operator less than state for condition operator.
	ConditionOperatorLessThan ConditionOperator = "LessThan"
	// ConditionOperatorLessThanOrEqual specifies the condition operator less than or equal state for condition operator.
	ConditionOperatorLessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// MetricStatisticType enumerates the values for metric statistic type.
type MetricStatisticType string

const (
	// Average specifies the average state for metric statistic type.
	Average MetricStatisticType = "Average"
	// Max specifies the max state for metric statistic type.
	Max MetricStatisticType = "Max"
	// Min specifies the min state for metric statistic type.
	Min MetricStatisticType = "Min"
	// Sum specifies the sum state for metric statistic type.
	Sum MetricStatisticType = "Sum"
)

// OdataType enumerates the values for odata type.
type OdataType string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource specifies the odata type microsoft
	// azure management insights models rule management event data source state for odata type.
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource specifies the odata type microsoft azure
	// management insights models rule metric data source state for odata type.
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource OdataType = "Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource"
)

// OdataType1 enumerates the values for odata type 1.
type OdataType1 string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition specifies the odata type microsoft
	// azure management insights models location threshold rule condition state for odata type 1.
	OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition OdataType1 = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition specifies the odata type microsoft azure
	// management insights models management event rule condition state for odata type 1.
	OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition OdataType1 = "Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition"
	// OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition specifies the odata type microsoft azure
	// management insights models threshold rule condition state for odata type 1.
	OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition OdataType1 = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition"
)

// OdataType2 enumerates the values for odata type 2.
type OdataType2 string

const (
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction specifies the odata type microsoft azure management
	// insights models rule email action state for odata type 2.
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction OdataType2 = "Microsoft.Azure.Management.Insights.Models.RuleEmailAction"
	// OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction specifies the odata type microsoft azure management
	// insights models rule webhook action state for odata type 2.
	OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction OdataType2 = "Microsoft.Azure.Management.Insights.Models.RuleWebhookAction"
)

// ReceiverStatus enumerates the values for receiver status.
type ReceiverStatus string

const (
	// Disabled specifies the disabled state for receiver status.
	Disabled ReceiverStatus = "Disabled"
	// Enabled specifies the enabled state for receiver status.
	Enabled ReceiverStatus = "Enabled"
	// NotSpecified specifies the not specified state for receiver status.
	NotSpecified ReceiverStatus = "NotSpecified"
)

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// Day specifies the day state for recurrence frequency.
	Day RecurrenceFrequency = "Day"
	// Hour specifies the hour state for recurrence frequency.
	Hour RecurrenceFrequency = "Hour"
	// Minute specifies the minute state for recurrence frequency.
	Minute RecurrenceFrequency = "Minute"
	// Month specifies the month state for recurrence frequency.
	Month RecurrenceFrequency = "Month"
	// None specifies the none state for recurrence frequency.
	None RecurrenceFrequency = "None"
	// Second specifies the second state for recurrence frequency.
	Second RecurrenceFrequency = "Second"
	// Week specifies the week state for recurrence frequency.
	Week RecurrenceFrequency = "Week"
	// Year specifies the year state for recurrence frequency.
	Year RecurrenceFrequency = "Year"
)

// ScaleDirection enumerates the values for scale direction.
type ScaleDirection string

const (
	// ScaleDirectionDecrease specifies the scale direction decrease state for scale direction.
	ScaleDirectionDecrease ScaleDirection = "Decrease"
	// ScaleDirectionIncrease specifies the scale direction increase state for scale direction.
	ScaleDirectionIncrease ScaleDirection = "Increase"
	// ScaleDirectionNone specifies the scale direction none state for scale direction.
	ScaleDirectionNone ScaleDirection = "None"
)

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ChangeCount specifies the change count state for scale type.
	ChangeCount ScaleType = "ChangeCount"
	// ExactCount specifies the exact count state for scale type.
	ExactCount ScaleType = "ExactCount"
	// PercentChangeCount specifies the percent change count state for scale type.
	PercentChangeCount ScaleType = "PercentChangeCount"
)

// TimeAggregationOperator enumerates the values for time aggregation operator.
type TimeAggregationOperator string

const (
	// TimeAggregationOperatorAverage specifies the time aggregation operator average state for time aggregation operator.
	TimeAggregationOperatorAverage TimeAggregationOperator = "Average"
	// TimeAggregationOperatorLast specifies the time aggregation operator last state for time aggregation operator.
	TimeAggregationOperatorLast TimeAggregationOperator = "Last"
	// TimeAggregationOperatorMaximum specifies the time aggregation operator maximum state for time aggregation operator.
	TimeAggregationOperatorMaximum TimeAggregationOperator = "Maximum"
	// TimeAggregationOperatorMinimum specifies the time aggregation operator minimum state for time aggregation operator.
	TimeAggregationOperatorMinimum TimeAggregationOperator = "Minimum"
	// TimeAggregationOperatorTotal specifies the time aggregation operator total state for time aggregation operator.
	TimeAggregationOperatorTotal TimeAggregationOperator = "Total"
)

// TimeAggregationType enumerates the values for time aggregation type.
type TimeAggregationType string

const (
	// TimeAggregationTypeAverage specifies the time aggregation type average state for time aggregation type.
	TimeAggregationTypeAverage TimeAggregationType = "Average"
	// TimeAggregationTypeCount specifies the time aggregation type count state for time aggregation type.
	TimeAggregationTypeCount TimeAggregationType = "Count"
	// TimeAggregationTypeMaximum specifies the time aggregation type maximum state for time aggregation type.
	TimeAggregationTypeMaximum TimeAggregationType = "Maximum"
	// TimeAggregationTypeMinimum specifies the time aggregation type minimum state for time aggregation type.
	TimeAggregationTypeMinimum TimeAggregationType = "Minimum"
	// TimeAggregationTypeTotal specifies the time aggregation type total state for time aggregation type.
	TimeAggregationTypeTotal TimeAggregationType = "Total"
)

// ActionGroup is an Azure action group.
type ActionGroup struct {
	GroupShortName   *string            `json:"groupShortName,omitempty"`
	Enabled          *bool              `json:"enabled,omitempty"`
	EmailReceivers   *[]EmailReceiver   `json:"emailReceivers,omitempty"`
	SmsReceivers     *[]SmsReceiver     `json:"smsReceivers,omitempty"`
	WebhookReceivers *[]WebhookReceiver `json:"webhookReceivers,omitempty"`
}

// ActionGroupList is a list of action groups.
type ActionGroupList struct {
	autorest.Response `json:"-"`
	Value             *[]ActionGroupResource `json:"value,omitempty"`
	NextLink          *string                `json:"nextLink,omitempty"`
}

// ActionGroupResource is an action group resource.
type ActionGroupResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*ActionGroup      `json:"properties,omitempty"`
}

// ActivityLogAlert is an Azure activity log alert.
type ActivityLogAlert struct {
	Scopes      *[]string                       `json:"scopes,omitempty"`
	Enabled     *bool                           `json:"enabled,omitempty"`
	Condition   *ActivityLogAlertAllOfCondition `json:"condition,omitempty"`
	Actions     *ActivityLogAlertActionList     `json:"actions,omitempty"`
	Description *string                         `json:"description,omitempty"`
}

// ActivityLogAlertActionGroup is a pointer to an Azure Action Group.
type ActivityLogAlertActionGroup struct {
	ActionGroupID     *string             `json:"actionGroupId,omitempty"`
	WebhookProperties *map[string]*string `json:"webhookProperties,omitempty"`
}

// ActivityLogAlertActionList is a list of activity log alert actions.
type ActivityLogAlertActionList struct {
	ActionGroups *[]ActivityLogAlertActionGroup `json:"actionGroups,omitempty"`
}

// ActivityLogAlertAllOfCondition is an Activity Log alert condition that is met when all its member conditions are
// met.
type ActivityLogAlertAllOfCondition struct {
	AllOf *[]ActivityLogAlertLeafCondition `json:"allOf,omitempty"`
}

// ActivityLogAlertLeafCondition is an Activity Log alert condition that is met by comparing an activity log field and
// value.
type ActivityLogAlertLeafCondition struct {
	Field  *string `json:"field,omitempty"`
	Equals *string `json:"equals,omitempty"`
}

// ActivityLogAlertList is a list of activity log alerts.
type ActivityLogAlertList struct {
	autorest.Response `json:"-"`
	Value             *[]ActivityLogAlertResource `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// ActivityLogAlertPatch is an Azure activity log alert for patch operations.
type ActivityLogAlertPatch struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// ActivityLogAlertPatchBody is an activity log alert object for the body of patch operations.
type ActivityLogAlertPatchBody struct {
	Tags                   *map[string]*string `json:"tags,omitempty"`
	*ActivityLogAlertPatch `json:"properties,omitempty"`
}

// ActivityLogAlertResource is an activity log alert resource.
type ActivityLogAlertResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*ActivityLogAlert `json:"properties,omitempty"`
}

// AlertRule is an alert rule.
type AlertRule struct {
	Name            *string       `json:"name,omitempty"`
	Description     *string       `json:"description,omitempty"`
	IsEnabled       *bool         `json:"isEnabled,omitempty"`
	Condition       RuleCondition `json:"condition,omitempty"`
	Actions         *[]RuleAction `json:"actions,omitempty"`
	LastUpdatedTime *date.Time    `json:"lastUpdatedTime,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertRule struct.
func (ar *AlertRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ar.Name = &name
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ar.Description = &description
	}

	v = m["isEnabled"]
	if v != nil {
		var isEnabled bool
		err = json.Unmarshal(*m["isEnabled"], &isEnabled)
		if err != nil {
			return err
		}
		ar.IsEnabled = &isEnabled
	}

	v = m["condition"]
	if v != nil {
		condition, err := unmarshalRuleCondition(*m["condition"])
		if err != nil {
			return err
		}
		ar.Condition = condition
	}

	v = m["actions"]
	if v != nil {
		actions, err := unmarshalRuleActionArray(*m["actions"])
		if err != nil {
			return err
		}
		ar.Actions = &actions
	}

	v = m["lastUpdatedTime"]
	if v != nil {
		var lastUpdatedTime date.Time
		err = json.Unmarshal(*m["lastUpdatedTime"], &lastUpdatedTime)
		if err != nil {
			return err
		}
		ar.LastUpdatedTime = &lastUpdatedTime
	}

	return nil
}

// AlertRuleResource is the alert rule resource.
type AlertRuleResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*AlertRule        `json:"properties,omitempty"`
}

// AlertRuleResourceCollection is represents a collection of alert rule resources.
type AlertRuleResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AlertRuleResource `json:"value,omitempty"`
}

// AlertRuleResourcePatch is the alert rule object for patch operations.
type AlertRuleResourcePatch struct {
	Tags       *map[string]*string `json:"tags,omitempty"`
	*AlertRule `json:"properties,omitempty"`
}

// AutoscaleNotification is autoscale notification.
type AutoscaleNotification struct {
	Operation *string                `json:"operation,omitempty"`
	Email     *EmailNotification     `json:"email,omitempty"`
	Webhooks  *[]WebhookNotification `json:"webhooks,omitempty"`
}

// AutoscaleProfile is autoscale profile.
type AutoscaleProfile struct {
	Name       *string        `json:"name,omitempty"`
	Capacity   *ScaleCapacity `json:"capacity,omitempty"`
	Rules      *[]ScaleRule   `json:"rules,omitempty"`
	FixedDate  *TimeWindow    `json:"fixedDate,omitempty"`
	Recurrence *Recurrence    `json:"recurrence,omitempty"`
}

// AutoscaleSetting is a setting that contains all of the configuration for the automatic scaling of a resource.
type AutoscaleSetting struct {
	Profiles          *[]AutoscaleProfile      `json:"profiles,omitempty"`
	Notifications     *[]AutoscaleNotification `json:"notifications,omitempty"`
	Enabled           *bool                    `json:"enabled,omitempty"`
	Name              *string                  `json:"name,omitempty"`
	TargetResourceURI *string                  `json:"targetResourceUri,omitempty"`
}

// AutoscaleSettingResource is the autoscale setting resource.
type AutoscaleSettingResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*AutoscaleSetting `json:"properties,omitempty"`
}

// AutoscaleSettingResourceCollection is represents a collection of autoscale setting resources.
type AutoscaleSettingResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]AutoscaleSettingResource `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// AutoscaleSettingResourceCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AutoscaleSettingResourceCollection) AutoscaleSettingResourceCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AutoscaleSettingResourcePatch is the autoscale setting object for patch operations.
type AutoscaleSettingResourcePatch struct {
	Tags              *map[string]*string `json:"tags,omitempty"`
	*AutoscaleSetting `json:"properties,omitempty"`
}

// DiagnosticSettings is the diagnostic settings.
type DiagnosticSettings struct {
	StorageAccountID            *string           `json:"storageAccountId,omitempty"`
	EventHubAuthorizationRuleID *string           `json:"eventHubAuthorizationRuleId,omitempty"`
	EventHubName                *string           `json:"eventHubName,omitempty"`
	Metrics                     *[]MetricSettings `json:"metrics,omitempty"`
	Logs                        *[]LogSettings    `json:"logs,omitempty"`
	WorkspaceID                 *string           `json:"workspaceId,omitempty"`
}

// DiagnosticSettingsCategory is the diagnostic settings Category.
type DiagnosticSettingsCategory struct {
	CategoryType CategoryType `json:"categoryType,omitempty"`
}

// DiagnosticSettingsCategoryResource is the diagnostic settings category resource.
type DiagnosticSettingsCategoryResource struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*DiagnosticSettingsCategory `json:"properties,omitempty"`
}

// DiagnosticSettingsCategoryResourceCollection is represents a collection of diagnostic setting category resources.
type DiagnosticSettingsCategoryResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]DiagnosticSettingsCategoryResource `json:"value,omitempty"`
}

// DiagnosticSettingsResource is the diagnostic setting resource.
type DiagnosticSettingsResource struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	Type                *string `json:"type,omitempty"`
	*DiagnosticSettings `json:"properties,omitempty"`
}

// DiagnosticSettingsResourceCollection is represents a collection of alert rule resources.
type DiagnosticSettingsResourceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]DiagnosticSettingsResource `json:"value,omitempty"`
}

// EmailNotification is email notification of an autoscale event.
type EmailNotification struct {
	SendToSubscriptionAdministrator    *bool     `json:"sendToSubscriptionAdministrator,omitempty"`
	SendToSubscriptionCoAdministrators *bool     `json:"sendToSubscriptionCoAdministrators,omitempty"`
	CustomEmails                       *[]string `json:"customEmails,omitempty"`
}

// EmailReceiver is an email receiver.
type EmailReceiver struct {
	Name         *string        `json:"name,omitempty"`
	EmailAddress *string        `json:"emailAddress,omitempty"`
	Status       ReceiverStatus `json:"status,omitempty"`
}

// EnableRequest is describes a receiver that should be resubscribed.
type EnableRequest struct {
	ReceiverName *string `json:"receiverName,omitempty"`
}

// ErrorResponse is describes the format of Error response.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Incident is an alert incident indicates the activation status of an alert rule.
type Incident struct {
	autorest.Response `json:"-"`
	Name              *string    `json:"name,omitempty"`
	RuleName          *string    `json:"ruleName,omitempty"`
	IsActive          *bool      `json:"isActive,omitempty"`
	ActivatedTime     *date.Time `json:"activatedTime,omitempty"`
	ResolvedTime      *date.Time `json:"resolvedTime,omitempty"`
}

// IncidentListResult is the List incidents operation response.
type IncidentListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Incident `json:"value,omitempty"`
}

// LocationThresholdRuleCondition is a rule condition based on a certain number of locations failing.
type LocationThresholdRuleCondition struct {
	DataSource          RuleDataSource `json:"dataSource,omitempty"`
	OdataType           OdataType1     `json:"odata.type,omitempty"`
	WindowSize          *string        `json:"windowSize,omitempty"`
	FailedLocationCount *int32         `json:"failedLocationCount,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	ltrc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition
	type Alias LocationThresholdRuleCondition
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ltrc),
	})
}

// AsThresholdRuleCondition is the RuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the RuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return &ltrc, true
}

// AsManagementEventRuleCondition is the RuleCondition implementation for LocationThresholdRuleCondition.
func (ltrc LocationThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for LocationThresholdRuleCondition struct.
func (ltrc *LocationThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["windowSize"]
	if v != nil {
		var windowSize string
		err = json.Unmarshal(*m["windowSize"], &windowSize)
		if err != nil {
			return err
		}
		ltrc.WindowSize = &windowSize
	}

	v = m["failedLocationCount"]
	if v != nil {
		var failedLocationCount int32
		err = json.Unmarshal(*m["failedLocationCount"], &failedLocationCount)
		if err != nil {
			return err
		}
		ltrc.FailedLocationCount = &failedLocationCount
	}

	v = m["dataSource"]
	if v != nil {
		dataSource, err := unmarshalRuleDataSource(*m["dataSource"])
		if err != nil {
			return err
		}
		ltrc.DataSource = dataSource
	}

	v = m["odata.type"]
	if v != nil {
		var odatatype OdataType1
		err = json.Unmarshal(*m["odata.type"], &odatatype)
		if err != nil {
			return err
		}
		ltrc.OdataType = odatatype
	}

	return nil
}

// LogProfileCollection is represents a collection of log profiles.
type LogProfileCollection struct {
	autorest.Response `json:"-"`
	Value             *[]LogProfileResource `json:"value,omitempty"`
}

// LogProfileProperties is the log profile properties.
type LogProfileProperties struct {
	StorageAccountID *string          `json:"storageAccountId,omitempty"`
	ServiceBusRuleID *string          `json:"serviceBusRuleId,omitempty"`
	Locations        *[]string        `json:"locations,omitempty"`
	Categories       *[]string        `json:"categories,omitempty"`
	RetentionPolicy  *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// LogProfileResource is the log profile resource.
type LogProfileResource struct {
	autorest.Response     `json:"-"`
	ID                    *string             `json:"id,omitempty"`
	Name                  *string             `json:"name,omitempty"`
	Type                  *string             `json:"type,omitempty"`
	Location              *string             `json:"location,omitempty"`
	Tags                  *map[string]*string `json:"tags,omitempty"`
	*LogProfileProperties `json:"properties,omitempty"`
}

// LogProfileResourcePatch is the log profile resource for patch operations.
type LogProfileResourcePatch struct {
	Tags                  *map[string]*string `json:"tags,omitempty"`
	*LogProfileProperties `json:"properties,omitempty"`
}

// LogSettings is part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
type LogSettings struct {
	Category        *string          `json:"category,omitempty"`
	Enabled         *bool            `json:"enabled,omitempty"`
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// ManagementEventAggregationCondition is how the data that is collected should be combined over time.
type ManagementEventAggregationCondition struct {
	Operator   ConditionOperator `json:"operator,omitempty"`
	Threshold  *float64          `json:"threshold,omitempty"`
	WindowSize *string           `json:"windowSize,omitempty"`
}

// ManagementEventRuleCondition is a management event rule condition.
type ManagementEventRuleCondition struct {
	DataSource  RuleDataSource                       `json:"dataSource,omitempty"`
	OdataType   OdataType1                           `json:"odata.type,omitempty"`
	Aggregation *ManagementEventAggregationCondition `json:"aggregation,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) MarshalJSON() ([]byte, error) {
	merc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition
	type Alias ManagementEventRuleCondition
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(merc),
	})
}

// AsThresholdRuleCondition is the RuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return nil, false
}

// AsLocationThresholdRuleCondition is the RuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the RuleCondition implementation for ManagementEventRuleCondition.
func (merc ManagementEventRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return &merc, true
}

// UnmarshalJSON is the custom unmarshaler for ManagementEventRuleCondition struct.
func (merc *ManagementEventRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["aggregation"]
	if v != nil {
		var aggregation ManagementEventAggregationCondition
		err = json.Unmarshal(*m["aggregation"], &aggregation)
		if err != nil {
			return err
		}
		merc.Aggregation = &aggregation
	}

	v = m["dataSource"]
	if v != nil {
		dataSource, err := unmarshalRuleDataSource(*m["dataSource"])
		if err != nil {
			return err
		}
		merc.DataSource = dataSource
	}

	v = m["odata.type"]
	if v != nil {
		var odatatype OdataType1
		err = json.Unmarshal(*m["odata.type"], &odatatype)
		if err != nil {
			return err
		}
		merc.OdataType = odatatype
	}

	return nil
}

// MetricSettings is part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
type MetricSettings struct {
	TimeGrain       *string          `json:"timeGrain,omitempty"`
	Category        *string          `json:"category,omitempty"`
	Enabled         *bool            `json:"enabled,omitempty"`
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// MetricTrigger is the trigger that results in a scaling action.
type MetricTrigger struct {
	MetricName        *string                 `json:"metricName,omitempty"`
	MetricResourceURI *string                 `json:"metricResourceUri,omitempty"`
	TimeGrain         *string                 `json:"timeGrain,omitempty"`
	Statistic         MetricStatisticType     `json:"statistic,omitempty"`
	TimeWindow        *string                 `json:"timeWindow,omitempty"`
	TimeAggregation   TimeAggregationType     `json:"timeAggregation,omitempty"`
	Operator          ComparisonOperationType `json:"operator,omitempty"`
	Threshold         *float64                `json:"threshold,omitempty"`
}

// Operation is microsoft Insights API operation definition.
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is display metadata associated with the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list Microsoft.Insights operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// ProxyOnlyResource is a proxy only azure resource object
type ProxyOnlyResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// Recurrence is the repeating times at which this profile begins. This element is not used if the FixedDate element is
// used.
type Recurrence struct {
	Frequency RecurrenceFrequency `json:"frequency,omitempty"`
	Schedule  *RecurrentSchedule  `json:"schedule,omitempty"`
}

// RecurrentSchedule is the scheduling constraints for when the profile begins.
type RecurrentSchedule struct {
	TimeZone *string   `json:"timeZone,omitempty"`
	Days     *[]string `json:"days,omitempty"`
	Hours    *[]int32  `json:"hours,omitempty"`
	Minutes  *[]int32  `json:"minutes,omitempty"`
}

// Resource is an azure resource object
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// RetentionPolicy is specifies the retention policy for the log.
type RetentionPolicy struct {
	Enabled *bool  `json:"enabled,omitempty"`
	Days    *int32 `json:"days,omitempty"`
}

// RuleAction is the action that is performed when the alert rule becomes active, and when an alert condition is
// resolved.
type RuleAction interface {
	AsRuleEmailAction() (*RuleEmailAction, bool)
	AsRuleWebhookAction() (*RuleWebhookAction, bool)
}

func unmarshalRuleAction(body []byte) (RuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction):
		var rea RuleEmailAction
		err := json.Unmarshal(body, &rea)
		return rea, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction):
		var rwa RuleWebhookAction
		err := json.Unmarshal(body, &rwa)
		return rwa, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalRuleActionArray(body []byte) ([]RuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	raArray := make([]RuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ra, err := unmarshalRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		raArray[index] = ra
	}
	return raArray, nil
}

// RuleCondition is the condition that results in the alert rule being activated.
type RuleCondition interface {
	AsThresholdRuleCondition() (*ThresholdRuleCondition, bool)
	AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool)
	AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool)
}

func unmarshalRuleCondition(body []byte) (RuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition):
		var trc ThresholdRuleCondition
		err := json.Unmarshal(body, &trc)
		return trc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsLocationThresholdRuleCondition):
		var ltrc LocationThresholdRuleCondition
		err := json.Unmarshal(body, &ltrc)
		return ltrc, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsManagementEventRuleCondition):
		var merc ManagementEventRuleCondition
		err := json.Unmarshal(body, &merc)
		return merc, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalRuleConditionArray(body []byte) ([]RuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcArray := make([]RuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rc, err := unmarshalRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcArray[index] = rc
	}
	return rcArray, nil
}

// RuleDataSource is the resource from which the rule collects its data.
type RuleDataSource interface {
	AsRuleMetricDataSource() (*RuleMetricDataSource, bool)
	AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool)
}

func unmarshalRuleDataSource(body []byte) (RuleDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["odata.type"] {
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource):
		var rmds RuleMetricDataSource
		err := json.Unmarshal(body, &rmds)
		return rmds, err
	case string(OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource):
		var rmeds RuleManagementEventDataSource
		err := json.Unmarshal(body, &rmeds)
		return rmeds, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalRuleDataSourceArray(body []byte) ([]RuleDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdsArray := make([]RuleDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rds, err := unmarshalRuleDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdsArray[index] = rds
	}
	return rdsArray, nil
}

// RuleEmailAction is specifies the action to send email when the rule condition is evaluated. The discriminator is
// always RuleEmailAction in this case.
type RuleEmailAction struct {
	OdataType           OdataType2 `json:"odata.type,omitempty"`
	SendToServiceOwners *bool      `json:"sendToServiceOwners,omitempty"`
	CustomEmails        *[]string  `json:"customEmails,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleEmailAction.
func (rea RuleEmailAction) MarshalJSON() ([]byte, error) {
	rea.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleEmailAction
	type Alias RuleEmailAction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rea),
	})
}

// AsRuleEmailAction is the RuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return &rea, true
}

// AsRuleWebhookAction is the RuleAction implementation for RuleEmailAction.
func (rea RuleEmailAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return nil, false
}

// RuleManagementEventClaimsDataSource is the claims for a rule management event data source.
type RuleManagementEventClaimsDataSource struct {
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// RuleManagementEventDataSource is a rule management event data source. The discriminator fields is always
// RuleManagementEventDataSource in this case.
type RuleManagementEventDataSource struct {
	ResourceURI          *string                              `json:"resourceUri,omitempty"`
	OdataType            OdataType                            `json:"odata.type,omitempty"`
	EventName            *string                              `json:"eventName,omitempty"`
	EventSource          *string                              `json:"eventSource,omitempty"`
	Level                *string                              `json:"level,omitempty"`
	OperationName        *string                              `json:"operationName,omitempty"`
	ResourceGroupName    *string                              `json:"resourceGroupName,omitempty"`
	ResourceProviderName *string                              `json:"resourceProviderName,omitempty"`
	Status               *string                              `json:"status,omitempty"`
	SubStatus            *string                              `json:"subStatus,omitempty"`
	Claims               *RuleManagementEventClaimsDataSource `json:"claims,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) MarshalJSON() ([]byte, error) {
	rmeds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleManagementEventDataSource
	type Alias RuleManagementEventDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rmeds),
	})
}

// AsRuleMetricDataSource is the RuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return nil, false
}

// AsRuleManagementEventDataSource is the RuleDataSource implementation for RuleManagementEventDataSource.
func (rmeds RuleManagementEventDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return &rmeds, true
}

// RuleMetricDataSource is a rule metric data source. The discriminator value is always RuleMetricDataSource in this
// case.
type RuleMetricDataSource struct {
	ResourceURI *string   `json:"resourceUri,omitempty"`
	OdataType   OdataType `json:"odata.type,omitempty"`
	MetricName  *string   `json:"metricName,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleMetricDataSource.
func (rmds RuleMetricDataSource) MarshalJSON() ([]byte, error) {
	rmds.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleMetricDataSource
	type Alias RuleMetricDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rmds),
	})
}

// AsRuleMetricDataSource is the RuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleMetricDataSource() (*RuleMetricDataSource, bool) {
	return &rmds, true
}

// AsRuleManagementEventDataSource is the RuleDataSource implementation for RuleMetricDataSource.
func (rmds RuleMetricDataSource) AsRuleManagementEventDataSource() (*RuleManagementEventDataSource, bool) {
	return nil, false
}

// RuleWebhookAction is specifies the action to post to service when the rule condition is evaluated. The discriminator
// is always RuleWebhookAction in this case.
type RuleWebhookAction struct {
	OdataType  OdataType2          `json:"odata.type,omitempty"`
	ServiceURI *string             `json:"serviceUri,omitempty"`
	Properties *map[string]*string `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleWebhookAction.
func (rwa RuleWebhookAction) MarshalJSON() ([]byte, error) {
	rwa.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsRuleWebhookAction
	type Alias RuleWebhookAction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rwa),
	})
}

// AsRuleEmailAction is the RuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleEmailAction() (*RuleEmailAction, bool) {
	return nil, false
}

// AsRuleWebhookAction is the RuleAction implementation for RuleWebhookAction.
func (rwa RuleWebhookAction) AsRuleWebhookAction() (*RuleWebhookAction, bool) {
	return &rwa, true
}

// ScaleAction is the parameters for the scaling action.
type ScaleAction struct {
	Direction ScaleDirection `json:"direction,omitempty"`
	Type      ScaleType      `json:"type,omitempty"`
	Value     *string        `json:"value,omitempty"`
	Cooldown  *string        `json:"cooldown,omitempty"`
}

// ScaleCapacity is the number of instances that can be used during this profile.
type ScaleCapacity struct {
	Minimum *string `json:"minimum,omitempty"`
	Maximum *string `json:"maximum,omitempty"`
	Default *string `json:"default,omitempty"`
}

// ScaleRule is a rule that provide the triggers and parameters for the scaling action.
type ScaleRule struct {
	MetricTrigger *MetricTrigger `json:"metricTrigger,omitempty"`
	ScaleAction   *ScaleAction   `json:"scaleAction,omitempty"`
}

// SmsReceiver is an SMS receiver.
type SmsReceiver struct {
	Name        *string        `json:"name,omitempty"`
	CountryCode *string        `json:"countryCode,omitempty"`
	PhoneNumber *string        `json:"phoneNumber,omitempty"`
	Status      ReceiverStatus `json:"status,omitempty"`
}

// ThresholdRuleCondition is a rule condition based on a metric crossing a threshold.
type ThresholdRuleCondition struct {
	DataSource      RuleDataSource          `json:"dataSource,omitempty"`
	OdataType       OdataType1              `json:"odata.type,omitempty"`
	Operator        ConditionOperator       `json:"operator,omitempty"`
	Threshold       *float64                `json:"threshold,omitempty"`
	WindowSize      *string                 `json:"windowSize,omitempty"`
	TimeAggregation TimeAggregationOperator `json:"timeAggregation,omitempty"`
}

// MarshalJSON is the custom marshaler for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) MarshalJSON() ([]byte, error) {
	trc.OdataType = OdataTypeMicrosoftAzureManagementInsightsModelsThresholdRuleCondition
	type Alias ThresholdRuleCondition
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(trc),
	})
}

// AsThresholdRuleCondition is the RuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsThresholdRuleCondition() (*ThresholdRuleCondition, bool) {
	return &trc, true
}

// AsLocationThresholdRuleCondition is the RuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsLocationThresholdRuleCondition() (*LocationThresholdRuleCondition, bool) {
	return nil, false
}

// AsManagementEventRuleCondition is the RuleCondition implementation for ThresholdRuleCondition.
func (trc ThresholdRuleCondition) AsManagementEventRuleCondition() (*ManagementEventRuleCondition, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for ThresholdRuleCondition struct.
func (trc *ThresholdRuleCondition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["operator"]
	if v != nil {
		var operator ConditionOperator
		err = json.Unmarshal(*m["operator"], &operator)
		if err != nil {
			return err
		}
		trc.Operator = operator
	}

	v = m["threshold"]
	if v != nil {
		var threshold float64
		err = json.Unmarshal(*m["threshold"], &threshold)
		if err != nil {
			return err
		}
		trc.Threshold = &threshold
	}

	v = m["windowSize"]
	if v != nil {
		var windowSize string
		err = json.Unmarshal(*m["windowSize"], &windowSize)
		if err != nil {
			return err
		}
		trc.WindowSize = &windowSize
	}

	v = m["timeAggregation"]
	if v != nil {
		var timeAggregation TimeAggregationOperator
		err = json.Unmarshal(*m["timeAggregation"], &timeAggregation)
		if err != nil {
			return err
		}
		trc.TimeAggregation = timeAggregation
	}

	v = m["dataSource"]
	if v != nil {
		dataSource, err := unmarshalRuleDataSource(*m["dataSource"])
		if err != nil {
			return err
		}
		trc.DataSource = dataSource
	}

	v = m["odata.type"]
	if v != nil {
		var odatatype OdataType1
		err = json.Unmarshal(*m["odata.type"], &odatatype)
		if err != nil {
			return err
		}
		trc.OdataType = odatatype
	}

	return nil
}

// TimeWindow is a specific date-time for the profile.
type TimeWindow struct {
	TimeZone *string    `json:"timeZone,omitempty"`
	Start    *date.Time `json:"start,omitempty"`
	End      *date.Time `json:"end,omitempty"`
}

// WebhookNotification is webhook notification of an autoscale event.
type WebhookNotification struct {
	ServiceURI *string             `json:"serviceUri,omitempty"`
	Properties *map[string]*string `json:"properties,omitempty"`
}

// WebhookReceiver is a webhook receiver.
type WebhookReceiver struct {
	Name       *string `json:"name,omitempty"`
	ServiceURI *string `json:"serviceUri,omitempty"`
}
