package mobileengagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AudienceOperators enumerates the values for audience operators.
type AudienceOperators string

const (
	// EQ specifies the eq state for audience operators.
	EQ AudienceOperators = "EQ"
	// GE specifies the ge state for audience operators.
	GE AudienceOperators = "GE"
	// GT specifies the gt state for audience operators.
	GT AudienceOperators = "GT"
	// LE specifies the le state for audience operators.
	LE AudienceOperators = "LE"
	// LT specifies the lt state for audience operators.
	LT AudienceOperators = "LT"
)

// CampaignFeedbacks enumerates the values for campaign feedbacks.
type CampaignFeedbacks string

const (
	// Actioned specifies the actioned state for campaign feedbacks.
	Actioned CampaignFeedbacks = "actioned"
	// Exited specifies the exited state for campaign feedbacks.
	Exited CampaignFeedbacks = "exited"
	// Pushed specifies the pushed state for campaign feedbacks.
	Pushed CampaignFeedbacks = "pushed"
	// Replied specifies the replied state for campaign feedbacks.
	Replied CampaignFeedbacks = "replied"
)

// CampaignKinds enumerates the values for campaign kinds.
type CampaignKinds string

const (
	// Announcements specifies the announcements state for campaign kinds.
	Announcements CampaignKinds = "announcements"
	// DataPushes specifies the data pushes state for campaign kinds.
	DataPushes CampaignKinds = "dataPushes"
	// NativePushes specifies the native pushes state for campaign kinds.
	NativePushes CampaignKinds = "nativePushes"
	// Polls specifies the polls state for campaign kinds.
	Polls CampaignKinds = "polls"
)

// CampaignStates enumerates the values for campaign states.
type CampaignStates string

const (
	// Draft specifies the draft state for campaign states.
	Draft CampaignStates = "draft"
	// Finished specifies the finished state for campaign states.
	Finished CampaignStates = "finished"
	// InProgress specifies the in progress state for campaign states.
	InProgress CampaignStates = "in-progress"
	// Queued specifies the queued state for campaign states.
	Queued CampaignStates = "queued"
	// Scheduled specifies the scheduled state for campaign states.
	Scheduled CampaignStates = "scheduled"
)

// CampaignType enumerates the values for campaign type.
type CampaignType string

const (
	// Announcement specifies the announcement state for campaign type.
	Announcement CampaignType = "Announcement"
	// DataPush specifies the data push state for campaign type.
	DataPush CampaignType = "DataPush"
	// NativePush specifies the native push state for campaign type.
	NativePush CampaignType = "NativePush"
	// Poll specifies the poll state for campaign type.
	Poll CampaignType = "Poll"
)

// CampaignTypes enumerates the values for campaign types.
type CampaignTypes string

const (
	// OnlyNotif specifies the only notif state for campaign types.
	OnlyNotif CampaignTypes = "only_notif"
	// Textbase64 specifies the textbase 64 state for campaign types.
	Textbase64 CampaignTypes = "text/base64"
	// Texthtml specifies the texthtml state for campaign types.
	Texthtml CampaignTypes = "text/html"
	// Textplain specifies the textplain state for campaign types.
	Textplain CampaignTypes = "text/plain"
)

// DeliveryTimes enumerates the values for delivery times.
type DeliveryTimes string

const (
	// Any specifies the any state for delivery times.
	Any DeliveryTimes = "any"
	// Background specifies the background state for delivery times.
	Background DeliveryTimes = "background"
	// Session specifies the session state for delivery times.
	Session DeliveryTimes = "session"
)

// ExportFormat enumerates the values for export format.
type ExportFormat string

const (
	// CsvBlob specifies the csv blob state for export format.
	CsvBlob ExportFormat = "CsvBlob"
	// JSONBlob specifies the json blob state for export format.
	JSONBlob ExportFormat = "JsonBlob"
)

// ExportState enumerates the values for export state.
type ExportState string

const (
	// ExportStateFailed specifies the export state failed state for export state.
	ExportStateFailed ExportState = "Failed"
	// ExportStateQueued specifies the export state queued state for export state.
	ExportStateQueued ExportState = "Queued"
	// ExportStateStarted specifies the export state started state for export state.
	ExportStateStarted ExportState = "Started"
	// ExportStateSucceeded specifies the export state succeeded state for export state.
	ExportStateSucceeded ExportState = "Succeeded"
)

// ExportType enumerates the values for export type.
type ExportType string

const (
	// ExportTypeActivity specifies the export type activity state for export type.
	ExportTypeActivity ExportType = "Activity"
	// ExportTypeCrash specifies the export type crash state for export type.
	ExportTypeCrash ExportType = "Crash"
	// ExportTypeError specifies the export type error state for export type.
	ExportTypeError ExportType = "Error"
	// ExportTypeEvent specifies the export type event state for export type.
	ExportTypeEvent ExportType = "Event"
	// ExportTypeJob specifies the export type job state for export type.
	ExportTypeJob ExportType = "Job"
	// ExportTypePush specifies the export type push state for export type.
	ExportTypePush ExportType = "Push"
	// ExportTypeSession specifies the export type session state for export type.
	ExportTypeSession ExportType = "Session"
	// ExportTypeTag specifies the export type tag state for export type.
	ExportTypeTag ExportType = "Tag"
	// ExportTypeToken specifies the export type token state for export type.
	ExportTypeToken ExportType = "Token"
)

// JobStates enumerates the values for job states.
type JobStates string

const (
	// JobStatesFailed specifies the job states failed state for job states.
	JobStatesFailed JobStates = "Failed"
	// JobStatesQueued specifies the job states queued state for job states.
	JobStatesQueued JobStates = "Queued"
	// JobStatesStarted specifies the job states started state for job states.
	JobStatesStarted JobStates = "Started"
	// JobStatesSucceeded specifies the job states succeeded state for job states.
	JobStatesSucceeded JobStates = "Succeeded"
)

// NotificationTypes enumerates the values for notification types.
type NotificationTypes string

const (
	// Popup specifies the popup state for notification types.
	Popup NotificationTypes = "popup"
	// System specifies the system state for notification types.
	System NotificationTypes = "system"
)

// ProvisioningStates enumerates the values for provisioning states.
type ProvisioningStates string

const (
	// Creating specifies the creating state for provisioning states.
	Creating ProvisioningStates = "Creating"
	// Succeeded specifies the succeeded state for provisioning states.
	Succeeded ProvisioningStates = "Succeeded"
)

// PushModes enumerates the values for push modes.
type PushModes string

const (
	// Manual specifies the manual state for push modes.
	Manual PushModes = "manual"
	// OneShot specifies the one shot state for push modes.
	OneShot PushModes = "one-shot"
	// RealTime specifies the real time state for push modes.
	RealTime PushModes = "real-time"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAnnouncementFeedback specifies the type announcement feedback state for type.
	TypeAnnouncementFeedback Type = "announcement-feedback"
	// TypeApplicationVersion specifies the type application version state for type.
	TypeApplicationVersion Type = "application-version"
	// TypeBooleanTag specifies the type boolean tag state for type.
	TypeBooleanTag Type = "boolean-tag"
	// TypeCarrierCountry specifies the type carrier country state for type.
	TypeCarrierCountry Type = "carrier-country"
	// TypeCarrierName specifies the type carrier name state for type.
	TypeCarrierName Type = "carrier-name"
	// TypeDatapushFeedback specifies the type datapush feedback state for type.
	TypeDatapushFeedback Type = "datapush-feedback"
	// TypeDateTag specifies the type date tag state for type.
	TypeDateTag Type = "date-tag"
	// TypeDeviceManufacturer specifies the type device manufacturer state for type.
	TypeDeviceManufacturer Type = "device-manufacturer"
	// TypeDeviceModel specifies the type device model state for type.
	TypeDeviceModel Type = "device-model"
	// TypeFirmwareVersion specifies the type firmware version state for type.
	TypeFirmwareVersion Type = "firmware-version"
	// TypeGeoFencing specifies the type geo fencing state for type.
	TypeGeoFencing Type = "geo-fencing"
	// TypeIntegerTag specifies the type integer tag state for type.
	TypeIntegerTag Type = "integer-tag"
	// TypeLanguage specifies the type language state for type.
	TypeLanguage Type = "language"
	// TypeLocation specifies the type location state for type.
	TypeLocation Type = "location"
	// TypeNetworkType specifies the type network type state for type.
	TypeNetworkType Type = "network-type"
	// TypePollAnswerFeedback specifies the type poll answer feedback state for type.
	TypePollAnswerFeedback Type = "poll-answer-feedback"
	// TypePollFeedback specifies the type poll feedback state for type.
	TypePollFeedback Type = "poll-feedback"
	// TypeScreenSize specifies the type screen size state for type.
	TypeScreenSize Type = "screen-size"
	// TypeSegment specifies the type segment state for type.
	TypeSegment Type = "segment"
	// TypeStringTag specifies the type string tag state for type.
	TypeStringTag Type = "string-tag"
)

// TypeFilter enumerates the values for type filter.
type TypeFilter string

const (
	// TypeAppInfo specifies the type app info state for type filter.
	TypeAppInfo TypeFilter = "app-info"
	// TypeEngageActiveUsers specifies the type engage active users state for type filter.
	TypeEngageActiveUsers TypeFilter = "engage-active-users"
	// TypeEngageIdleUsers specifies the type engage idle users state for type filter.
	TypeEngageIdleUsers TypeFilter = "engage-idle-users"
	// TypeEngageNewUsers specifies the type engage new users state for type filter.
	TypeEngageNewUsers TypeFilter = "engage-new-users"
	// TypeEngageOldUsers specifies the type engage old users state for type filter.
	TypeEngageOldUsers TypeFilter = "engage-old-users"
	// TypeEngageSubset specifies the type engage subset state for type filter.
	TypeEngageSubset TypeFilter = "engage-subset"
	// TypeNativePushEnabled specifies the type native push enabled state for type filter.
	TypeNativePushEnabled TypeFilter = "native-push-enabled"
	// TypePushQuota specifies the type push quota state for type filter.
	TypePushQuota TypeFilter = "push-quota"
)

// AnnouncementFeedbackCriterion is used to target devices who received an announcement.
type AnnouncementFeedbackCriterion struct {
	Type      Type              `json:"type,omitempty"`
	ContentID *int32            `json:"content-id,omitempty"`
	Action    CampaignFeedbacks `json:"action,omitempty"`
}

// MarshalJSON is the custom marshaler for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) MarshalJSON() ([]byte, error) {
	afc.Type = TypeAnnouncementFeedback
	type Alias AnnouncementFeedbackCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(afc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return &afc, true
}

// AsPollFeedbackCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for AnnouncementFeedbackCriterion.
func (afc AnnouncementFeedbackCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// APIError is
type APIError struct {
	Error *APIErrorError `json:"error,omitempty"`
}

// APIErrorError is
type APIErrorError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// App is the Mobile Engagement App resource.
type App struct {
	ID             *string             `json:"id,omitempty"`
	Name           *string             `json:"name,omitempty"`
	Type           *string             `json:"type,omitempty"`
	Location       *string             `json:"location,omitempty"`
	Tags           *map[string]*string `json:"tags,omitempty"`
	*AppProperties `json:"properties,omitempty"`
}

// AppCollection is the AppCollection resource.
type AppCollection struct {
	ID                       *string             `json:"id,omitempty"`
	Name                     *string             `json:"name,omitempty"`
	Type                     *string             `json:"type,omitempty"`
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
	*AppCollectionProperties `json:"properties,omitempty"`
}

// AppCollectionListResult is the list AppCollections operation response.
type AppCollectionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]AppCollection `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// AppCollectionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppCollectionListResult) AppCollectionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppCollectionNameAvailability is
type AppCollectionNameAvailability struct {
	autorest.Response    `json:"-"`
	Name                 *string `json:"name,omitempty"`
	Available            *bool   `json:"available,omitempty"`
	UnavailabilityReason *string `json:"unavailabilityReason,omitempty"`
}

// AppCollectionProperties is
type AppCollectionProperties struct {
	ProvisioningState ProvisioningStates `json:"provisioningState,omitempty"`
}

// AppInfoFilter is send only to users who have some app info set. This is a special filter that is automatically added
// if your campaign contains appInfo parameters. It is not intended to be public and should not be used as it could be
// removed or replaced by the API.
type AppInfoFilter struct {
	Type    TypeFilter `json:"type,omitempty"`
	AppInfo *[]string  `json:"appInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for AppInfoFilter.
func (aif AppInfoFilter) MarshalJSON() ([]byte, error) {
	aif.Type = TypeAppInfo
	type Alias AppInfoFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(aif),
	})
}

// AsEngageSubsetFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for AppInfoFilter.
func (aif AppInfoFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return &aif, true
}

// ApplicationVersionCriterion is used to target devices based on the version of the application they are using.
type ApplicationVersionCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) MarshalJSON() ([]byte, error) {
	avc.Type = TypeApplicationVersion
	type Alias ApplicationVersionCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(avc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return &avc, true
}

// AsNetworkTypeCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for ApplicationVersionCriterion.
func (avc ApplicationVersionCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// AppListResult is the list Apps operation response.
type AppListResult struct {
	autorest.Response `json:"-"`
	Value             *[]App  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// AppListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AppListResult) AppListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AppProperties is
type AppProperties struct {
	BackendID *string `json:"backendId,omitempty"`
	Platform  *string `json:"platform,omitempty"`
	AppState  *string `json:"appState,omitempty"`
}

// BooleanTagCriterion is target devices based on a boolean tag value.
type BooleanTagCriterion struct {
	Type  Type    `json:"type,omitempty"`
	Name  *string `json:"name,omitempty"`
	Value *bool   `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for BooleanTagCriterion.
func (btc BooleanTagCriterion) MarshalJSON() ([]byte, error) {
	btc.Type = TypeBooleanTag
	type Alias BooleanTagCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(btc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for BooleanTagCriterion.
func (btc BooleanTagCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return &btc, true
}

// Campaign is
type Campaign struct {
	NotificationTitle     *string                           `json:"notificationTitle,omitempty"`
	NotificationMessage   *string                           `json:"notificationMessage,omitempty"`
	NotificationImage     *[]byte                           `json:"notificationImage,omitempty"`
	NotificationOptions   *NotificationOptions              `json:"notificationOptions,omitempty"`
	Title                 *string                           `json:"title,omitempty"`
	Body                  *string                           `json:"body,omitempty"`
	ActionButtonText      *string                           `json:"actionButtonText,omitempty"`
	ExitButtonText        *string                           `json:"exitButtonText,omitempty"`
	ActionURL             *string                           `json:"actionUrl,omitempty"`
	Payload               *map[string]interface{}           `json:"payload,omitempty"`
	Name                  *string                           `json:"name,omitempty"`
	Audience              *CampaignAudience                 `json:"audience,omitempty"`
	Category              *string                           `json:"category,omitempty"`
	PushMode              PushModes                         `json:"pushMode,omitempty"`
	Type                  CampaignTypes                     `json:"type,omitempty"`
	DeliveryTime          DeliveryTimes                     `json:"deliveryTime,omitempty"`
	DeliveryActivities    *[]string                         `json:"deliveryActivities,omitempty"`
	StartTime             *string                           `json:"startTime,omitempty"`
	EndTime               *string                           `json:"endTime,omitempty"`
	Timezone              *string                           `json:"timezone,omitempty"`
	NotificationType      NotificationTypes                 `json:"notificationType,omitempty"`
	NotificationIcon      *bool                             `json:"notificationIcon,omitempty"`
	NotificationCloseable *bool                             `json:"notificationCloseable,omitempty"`
	NotificationVibrate   *bool                             `json:"notificationVibrate,omitempty"`
	NotificationSound     *bool                             `json:"notificationSound,omitempty"`
	NotificationBadge     *bool                             `json:"notificationBadge,omitempty"`
	Localization          *map[string]*CampaignLocalization `json:"localization,omitempty"`
	Questions             *[]PollQuestion                   `json:"questions,omitempty"`
}

// CampaignAudience is specify which users will be targeted by this campaign. By default, all users will be targeted.
// If you set `pushMode` property to `manual`, the only thing you can specify in the audience is the push quota filter.
// An audience is a boolean expression made of criteria (variables) operators (`not`, `and` or `or`) and parenthesis.
// Additionally, a set of filters can be added to an audience. 65535 bytes max as per JSON encoding.
type CampaignAudience struct {
	Expression *string                `json:"expression,omitempty"`
	Criteria   *map[string]*Criterion `json:"criteria,omitempty"`
	Filters    *[]Filter              `json:"filters,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for CampaignAudience struct.
func (c *CampaignAudience) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["expression"]
	if v != nil {
		var expression string
		err = json.Unmarshal(*m["expression"], &expression)
		if err != nil {
			return err
		}
		c.Expression = &expression
	}

	v = m["criteria"]
	if v != nil {
		var criteria map[string]*Criterion
		err = json.Unmarshal(*m["criteria"], &criteria)
		if err != nil {
			return err
		}
		c.Criteria = &criteria
	}

	v = m["filters"]
	if v != nil {
		filters, err := unmarshalFilterArray(*m["filters"])
		if err != nil {
			return err
		}
		c.Filters = &filters
	}

	return nil
}

// CampaignListResult is
type CampaignListResult struct {
	State         CampaignStates `json:"state,omitempty"`
	ID            *int32         `json:"id,omitempty"`
	Name          *string        `json:"name,omitempty"`
	ActivatedDate *date.Time     `json:"activatedDate,omitempty"`
	FinishedDate  *date.Time     `json:"finishedDate,omitempty"`
	StartTime     *date.Time     `json:"startTime,omitempty"`
	EndTime       *date.Time     `json:"endTime,omitempty"`
	Timezone      *string        `json:"timezone,omitempty"`
}

// CampaignLocalization is
type CampaignLocalization struct {
	NotificationTitle   *string                 `json:"notificationTitle,omitempty"`
	NotificationMessage *string                 `json:"notificationMessage,omitempty"`
	NotificationImage   *[]byte                 `json:"notificationImage,omitempty"`
	NotificationOptions *NotificationOptions    `json:"notificationOptions,omitempty"`
	Title               *string                 `json:"title,omitempty"`
	Body                *string                 `json:"body,omitempty"`
	ActionButtonText    *string                 `json:"actionButtonText,omitempty"`
	ExitButtonText      *string                 `json:"exitButtonText,omitempty"`
	ActionURL           *string                 `json:"actionUrl,omitempty"`
	Payload             *map[string]interface{} `json:"payload,omitempty"`
}

// CampaignPushParameters is
type CampaignPushParameters struct {
	DeviceIds *[]string `json:"deviceIds,omitempty"`
	Data      *Campaign `json:"data,omitempty"`
}

// CampaignPushResult is
type CampaignPushResult struct {
	autorest.Response `json:"-"`
	InvalidDeviceIds  *[]string `json:"invalidDeviceIds,omitempty"`
}

// CampaignResult is
type CampaignResult struct {
	autorest.Response     `json:"-"`
	NotificationTitle     *string                           `json:"notificationTitle,omitempty"`
	NotificationMessage   *string                           `json:"notificationMessage,omitempty"`
	NotificationImage     *[]byte                           `json:"notificationImage,omitempty"`
	NotificationOptions   *NotificationOptions              `json:"notificationOptions,omitempty"`
	Title                 *string                           `json:"title,omitempty"`
	Body                  *string                           `json:"body,omitempty"`
	ActionButtonText      *string                           `json:"actionButtonText,omitempty"`
	ExitButtonText        *string                           `json:"exitButtonText,omitempty"`
	ActionURL             *string                           `json:"actionUrl,omitempty"`
	Payload               *map[string]interface{}           `json:"payload,omitempty"`
	Name                  *string                           `json:"name,omitempty"`
	Audience              *CampaignAudience                 `json:"audience,omitempty"`
	Category              *string                           `json:"category,omitempty"`
	PushMode              PushModes                         `json:"pushMode,omitempty"`
	Type                  CampaignTypes                     `json:"type,omitempty"`
	DeliveryTime          DeliveryTimes                     `json:"deliveryTime,omitempty"`
	DeliveryActivities    *[]string                         `json:"deliveryActivities,omitempty"`
	StartTime             *string                           `json:"startTime,omitempty"`
	EndTime               *string                           `json:"endTime,omitempty"`
	Timezone              *string                           `json:"timezone,omitempty"`
	NotificationType      NotificationTypes                 `json:"notificationType,omitempty"`
	NotificationIcon      *bool                             `json:"notificationIcon,omitempty"`
	NotificationCloseable *bool                             `json:"notificationCloseable,omitempty"`
	NotificationVibrate   *bool                             `json:"notificationVibrate,omitempty"`
	NotificationSound     *bool                             `json:"notificationSound,omitempty"`
	NotificationBadge     *bool                             `json:"notificationBadge,omitempty"`
	Localization          *map[string]*CampaignLocalization `json:"localization,omitempty"`
	Questions             *[]PollQuestion                   `json:"questions,omitempty"`
	ID                    *int32                            `json:"id,omitempty"`
	State                 CampaignStates                    `json:"state,omitempty"`
	ActivatedDate         *date.Time                        `json:"activatedDate,omitempty"`
	FinishedDate          *date.Time                        `json:"finishedDate,omitempty"`
}

// CampaignsListResult is the campaigns list result.
type CampaignsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]CampaignListResult `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// CampaignsListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CampaignsListResult) CampaignsListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CampaignState is
type CampaignState struct {
	autorest.Response `json:"-"`
	State             CampaignStates `json:"state,omitempty"`
}

// CampaignStateResult is
type CampaignStateResult struct {
	autorest.Response `json:"-"`
	State             CampaignStates `json:"state,omitempty"`
	ID                *int32         `json:"id,omitempty"`
}

// CampaignStatisticsResult is
type CampaignStatisticsResult struct {
	autorest.Response           `json:"-"`
	Queued                      *int32                              `json:"queued,omitempty"`
	Pushed                      *int32                              `json:"pushed,omitempty"`
	PushedNative                *int32                              `json:"pushed-native,omitempty"`
	PushedNativeGoogle          *int32                              `json:"pushed-native-google,omitempty"`
	PushedNativeAdm             *int32                              `json:"pushed-native-adm,omitempty"`
	Delivered                   *int32                              `json:"delivered,omitempty"`
	Dropped                     *int32                              `json:"dropped,omitempty"`
	SystemNotificationDisplayed *int32                              `json:"system-notification-displayed,omitempty"`
	InAppNotificationDisplayed  *int32                              `json:"in-app-notification-displayed,omitempty"`
	ContentDisplayed            *int32                              `json:"content-displayed,omitempty"`
	SystemNotificationActioned  *int32                              `json:"system-notification-actioned,omitempty"`
	SystemNotificationExited    *int32                              `json:"system-notification-exited,omitempty"`
	InAppNotificationActioned   *int32                              `json:"in-app-notification-actioned,omitempty"`
	InAppNotificationExited     *int32                              `json:"in-app-notification-exited,omitempty"`
	ContentActioned             *int32                              `json:"content-actioned,omitempty"`
	ContentExited               *int32                              `json:"content-exited,omitempty"`
	Answers                     *map[string]*map[string]interface{} `json:"answers,omitempty"`
}

// CampaignTestNewParameters is
type CampaignTestNewParameters struct {
	DeviceID *string   `json:"deviceId,omitempty"`
	Lang     *string   `json:"lang,omitempty"`
	Data     *Campaign `json:"data,omitempty"`
}

// CampaignTestSavedParameters is
type CampaignTestSavedParameters struct {
	DeviceID *string `json:"deviceId,omitempty"`
	Lang     *string `json:"lang,omitempty"`
}

// CarrierCountryCriterion is used to target devices based on their carrier country.
type CarrierCountryCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) MarshalJSON() ([]byte, error) {
	ccc.Type = TypeCarrierCountry
	type Alias CarrierCountryCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ccc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return &ccc, true
}

// AsFirmwareVersionCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for CarrierCountryCriterion.
func (ccc CarrierCountryCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// CarrierNameCriterion is used to target devices based on their carrier name.
type CarrierNameCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for CarrierNameCriterion.
func (cnc CarrierNameCriterion) MarshalJSON() ([]byte, error) {
	cnc.Type = TypeCarrierName
	type Alias CarrierNameCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cnc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return &cnc, true
}

// AsCarrierCountryCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for CarrierNameCriterion.
func (cnc CarrierNameCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// Criterion is
type Criterion interface {
	AsCarrierNameCriterion() (*CarrierNameCriterion, bool)
	AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool)
	AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool)
	AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool)
	AsDeviceModelCriterion() (*DeviceModelCriterion, bool)
	AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool)
	AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool)
	AsLanguageCriterion() (*LanguageCriterion, bool)
	AsScreenSizeCriterion() (*ScreenSizeCriterion, bool)
	AsLocationCriterion() (*LocationCriterion, bool)
	AsGeoFencingCriterion() (*GeoFencingCriterion, bool)
	AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool)
	AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool)
	AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool)
	AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool)
	AsSegmentCriterion() (*SegmentCriterion, bool)
	AsStringTagCriterion() (*StringTagCriterion, bool)
	AsDateTagCriterion() (*DateTagCriterion, bool)
	AsIntegerTagCriterion() (*IntegerTagCriterion, bool)
	AsBooleanTagCriterion() (*BooleanTagCriterion, bool)
}

func unmarshalCriterion(body []byte) (Criterion, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeCarrierName):
		var cnc CarrierNameCriterion
		err := json.Unmarshal(body, &cnc)
		return cnc, err
	case string(TypeCarrierCountry):
		var ccc CarrierCountryCriterion
		err := json.Unmarshal(body, &ccc)
		return ccc, err
	case string(TypeFirmwareVersion):
		var fvc FirmwareVersionCriterion
		err := json.Unmarshal(body, &fvc)
		return fvc, err
	case string(TypeDeviceManufacturer):
		var dmc DeviceManufacturerCriterion
		err := json.Unmarshal(body, &dmc)
		return dmc, err
	case string(TypeDeviceModel):
		var dmc DeviceModelCriterion
		err := json.Unmarshal(body, &dmc)
		return dmc, err
	case string(TypeApplicationVersion):
		var avc ApplicationVersionCriterion
		err := json.Unmarshal(body, &avc)
		return avc, err
	case string(TypeNetworkType):
		var ntc NetworkTypeCriterion
		err := json.Unmarshal(body, &ntc)
		return ntc, err
	case string(TypeLanguage):
		var lc LanguageCriterion
		err := json.Unmarshal(body, &lc)
		return lc, err
	case string(TypeScreenSize):
		var ssc ScreenSizeCriterion
		err := json.Unmarshal(body, &ssc)
		return ssc, err
	case string(TypeLocation):
		var lc LocationCriterion
		err := json.Unmarshal(body, &lc)
		return lc, err
	case string(TypeGeoFencing):
		var gfc GeoFencingCriterion
		err := json.Unmarshal(body, &gfc)
		return gfc, err
	case string(TypeAnnouncementFeedback):
		var afc AnnouncementFeedbackCriterion
		err := json.Unmarshal(body, &afc)
		return afc, err
	case string(TypePollFeedback):
		var pfc PollFeedbackCriterion
		err := json.Unmarshal(body, &pfc)
		return pfc, err
	case string(TypePollAnswerFeedback):
		var pafc PollAnswerFeedbackCriterion
		err := json.Unmarshal(body, &pafc)
		return pafc, err
	case string(TypeDatapushFeedback):
		var dfc DatapushFeedbackCriterion
		err := json.Unmarshal(body, &dfc)
		return dfc, err
	case string(TypeSegment):
		var sc SegmentCriterion
		err := json.Unmarshal(body, &sc)
		return sc, err
	case string(TypeStringTag):
		var stc StringTagCriterion
		err := json.Unmarshal(body, &stc)
		return stc, err
	case string(TypeDateTag):
		var dtc DateTagCriterion
		err := json.Unmarshal(body, &dtc)
		return dtc, err
	case string(TypeIntegerTag):
		var itc IntegerTagCriterion
		err := json.Unmarshal(body, &itc)
		return itc, err
	case string(TypeBooleanTag):
		var btc BooleanTagCriterion
		err := json.Unmarshal(body, &btc)
		return btc, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalCriterionArray(body []byte) ([]Criterion, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]Criterion, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalCriterion(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// DatapushFeedbackCriterion is used to target devices who received a data push.
type DatapushFeedbackCriterion struct {
	Type      Type              `json:"type,omitempty"`
	ContentID *int32            `json:"content-id,omitempty"`
	Action    CampaignFeedbacks `json:"action,omitempty"`
}

// MarshalJSON is the custom marshaler for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) MarshalJSON() ([]byte, error) {
	dfc.Type = TypeDatapushFeedback
	type Alias DatapushFeedbackCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dfc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return &dfc, true
}

// AsSegmentCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for DatapushFeedbackCriterion.
func (dfc DatapushFeedbackCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// DateRangeExportTaskParameter is
type DateRangeExportTaskParameter struct {
	ContainerURL *string      `json:"containerUrl,omitempty"`
	Description  *string      `json:"description,omitempty"`
	StartDate    *date.Date   `json:"startDate,omitempty"`
	EndDate      *date.Date   `json:"endDate,omitempty"`
	ExportFormat ExportFormat `json:"exportFormat,omitempty"`
}

// DateTagCriterion is target devices based on a date tag value.
type DateTagCriterion struct {
	Type  Type              `json:"type,omitempty"`
	Name  *string           `json:"name,omitempty"`
	Value *date.Date        `json:"value,omitempty"`
	Op    AudienceOperators `json:"op,omitempty"`
}

// MarshalJSON is the custom marshaler for DateTagCriterion.
func (dtc DateTagCriterion) MarshalJSON() ([]byte, error) {
	dtc.Type = TypeDateTag
	type Alias DateTagCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dtc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return &dtc, true
}

// AsIntegerTagCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for DateTagCriterion.
func (dtc DateTagCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// Device is
type Device struct {
	autorest.Response `json:"-"`
	DeviceID          *string             `json:"deviceId,omitempty"`
	Meta              *DeviceMeta         `json:"meta,omitempty"`
	Info              *DeviceInfo         `json:"info,omitempty"`
	Location          *DeviceLocation     `json:"location,omitempty"`
	AppInfo           *map[string]*string `json:"appInfo,omitempty"`
}

// DeviceInfo is
type DeviceInfo struct {
	PhoneModel             *string `json:"phoneModel,omitempty"`
	PhoneManufacturer      *string `json:"phoneManufacturer,omitempty"`
	FirmwareVersion        *string `json:"firmwareVersion,omitempty"`
	FirmwareName           *string `json:"firmwareName,omitempty"`
	AndroidAPILevel        *int32  `json:"androidAPILevel,omitempty"`
	CarrierCountry         *string `json:"carrierCountry,omitempty"`
	Locale                 *string `json:"locale,omitempty"`
	CarrierName            *string `json:"carrierName,omitempty"`
	NetworkType            *string `json:"networkType,omitempty"`
	NetworkSubtype         *string `json:"networkSubtype,omitempty"`
	ApplicationVersionName *string `json:"applicationVersionName,omitempty"`
	ApplicationVersionCode *int32  `json:"applicationVersionCode,omitempty"`
	TimeZoneOffset         *int32  `json:"timeZoneOffset,omitempty"`
	ServiceVersion         *string `json:"serviceVersion,omitempty"`
}

// DeviceLocation is
type DeviceLocation struct {
	Countrycode *string `json:"countrycode,omitempty"`
	Region      *string `json:"region,omitempty"`
	Locality    *string `json:"locality,omitempty"`
}

// DeviceManufacturerCriterion is used to target devices based on the device manufacturer.
type DeviceManufacturerCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) MarshalJSON() ([]byte, error) {
	dmc.Type = TypeDeviceManufacturer
	type Alias DeviceManufacturerCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dmc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return &dmc, true
}

// AsDeviceModelCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for DeviceManufacturerCriterion.
func (dmc DeviceManufacturerCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// DeviceMeta is
type DeviceMeta struct {
	FirstSeen         *int64 `json:"firstSeen,omitempty"`
	LastSeen          *int64 `json:"lastSeen,omitempty"`
	LastInfo          *int64 `json:"lastInfo,omitempty"`
	LastLocation      *int64 `json:"lastLocation,omitempty"`
	NativePushEnabled *bool  `json:"nativePushEnabled,omitempty"`
}

// DeviceModelCriterion is used to target devices based on the device model.
type DeviceModelCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceModelCriterion.
func (dmc DeviceModelCriterion) MarshalJSON() ([]byte, error) {
	dmc.Type = TypeDeviceModel
	type Alias DeviceModelCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(dmc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return &dmc, true
}

// AsApplicationVersionCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for DeviceModelCriterion.
func (dmc DeviceModelCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// DeviceQueryResult is
type DeviceQueryResult struct {
	DeviceID *string             `json:"deviceId,omitempty"`
	Meta     *DeviceMeta         `json:"meta,omitempty"`
	AppInfo  *map[string]*string `json:"appInfo,omitempty"`
}

// DevicesQueryResult is the campaigns list result.
type DevicesQueryResult struct {
	autorest.Response `json:"-"`
	Value             *[]DeviceQueryResult `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// DevicesQueryResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DevicesQueryResult) DevicesQueryResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DeviceTagsParameters is
type DeviceTagsParameters struct {
	Tags         *map[string]map[string]*string `json:"tags,omitempty"`
	DeleteOnNull *bool                          `json:"deleteOnNull,omitempty"`
}

// DeviceTagsResult is
type DeviceTagsResult struct {
	autorest.Response `json:"-"`
	InvalidIds        *[]string `json:"invalidIds,omitempty"`
}

// EngageActiveUsersFilter is send only to users who have used the app in the last {threshold} days.
type EngageActiveUsersFilter struct {
	Type      TypeFilter `json:"type,omitempty"`
	Threshold *int32     `json:"threshold,omitempty"`
}

// MarshalJSON is the custom marshaler for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) MarshalJSON() ([]byte, error) {
	eauf.Type = TypeEngageActiveUsers
	type Alias EngageActiveUsersFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(eauf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return &eauf, true
}

// AsEngageIdleUsersFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for EngageActiveUsersFilter.
func (eauf EngageActiveUsersFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// EngageIdleUsersFilter is send only to users who haven't used the app in the last {threshold} days.
type EngageIdleUsersFilter struct {
	Type      TypeFilter `json:"type,omitempty"`
	Threshold *int32     `json:"threshold,omitempty"`
}

// MarshalJSON is the custom marshaler for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) MarshalJSON() ([]byte, error) {
	eiuf.Type = TypeEngageIdleUsers
	type Alias EngageIdleUsersFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(eiuf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return &eiuf, true
}

// AsNativePushEnabledFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for EngageIdleUsersFilter.
func (eiuf EngageIdleUsersFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// EngageNewUsersFilter is send only to users whose first app use is less than {threshold} days old.
type EngageNewUsersFilter struct {
	Type      TypeFilter `json:"type,omitempty"`
	Threshold *int32     `json:"threshold,omitempty"`
}

// MarshalJSON is the custom marshaler for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) MarshalJSON() ([]byte, error) {
	enuf.Type = TypeEngageNewUsers
	type Alias EngageNewUsersFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(enuf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return &enuf, true
}

// AsEngageActiveUsersFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for EngageNewUsersFilter.
func (enuf EngageNewUsersFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// EngageOldUsersFilter is send only to users whose first app use is more than {threshold} days old.
type EngageOldUsersFilter struct {
	Type      TypeFilter `json:"type,omitempty"`
	Threshold *int32     `json:"threshold,omitempty"`
}

// MarshalJSON is the custom marshaler for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) MarshalJSON() ([]byte, error) {
	eouf.Type = TypeEngageOldUsers
	type Alias EngageOldUsersFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(eouf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return &eouf, true
}

// AsEngageNewUsersFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for EngageOldUsersFilter.
func (eouf EngageOldUsersFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// EngageSubsetFilter is send only to a maximum of max users.
type EngageSubsetFilter struct {
	Type TypeFilter `json:"type,omitempty"`
	Max  *int32     `json:"max,omitempty"`
}

// MarshalJSON is the custom marshaler for EngageSubsetFilter.
func (esf EngageSubsetFilter) MarshalJSON() ([]byte, error) {
	esf.Type = TypeEngageSubset
	type Alias EngageSubsetFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(esf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return &esf, true
}

// AsEngageOldUsersFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for EngageSubsetFilter.
func (esf EngageSubsetFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// ExportOptions is options to control export generation.
type ExportOptions struct {
	ExportUserID *bool `json:"exportUserId,omitempty"`
}

// ExportTaskListResult is gets a paged list of ExportTasks.
type ExportTaskListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ExportTaskResult `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// ExportTaskListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ExportTaskListResult) ExportTaskListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ExportTaskParameter is
type ExportTaskParameter struct {
	ContainerURL *string      `json:"containerUrl,omitempty"`
	Description  *string      `json:"description,omitempty"`
	ExportFormat ExportFormat `json:"exportFormat,omitempty"`
}

// ExportTaskResult is
type ExportTaskResult struct {
	autorest.Response `json:"-"`
	ID                *string     `json:"id,omitempty"`
	Description       *string     `json:"description,omitempty"`
	State             ExportState `json:"state,omitempty"`
	DateCreated       *date.Time  `json:"dateCreated,omitempty"`
	DateCompleted     *date.Time  `json:"dateCompleted,omitempty"`
	ExportType        ExportType  `json:"exportType,omitempty"`
	ErrorDetails      *string     `json:"errorDetails,omitempty"`
}

// FeedbackByCampaignParameter is
type FeedbackByCampaignParameter struct {
	ContainerURL *string      `json:"containerUrl,omitempty"`
	Description  *string      `json:"description,omitempty"`
	CampaignType CampaignType `json:"campaignType,omitempty"`
	CampaignIds  *[]int32     `json:"campaignIds,omitempty"`
	ExportFormat ExportFormat `json:"exportFormat,omitempty"`
}

// FeedbackByDateRangeParameter is
type FeedbackByDateRangeParameter struct {
	ContainerURL        *string      `json:"containerUrl,omitempty"`
	Description         *string      `json:"description,omitempty"`
	CampaignType        CampaignType `json:"campaignType,omitempty"`
	CampaignWindowStart *date.Time   `json:"campaignWindowStart,omitempty"`
	CampaignWindowEnd   *date.Time   `json:"campaignWindowEnd,omitempty"`
	ExportFormat        ExportFormat `json:"exportFormat,omitempty"`
}

// Filter is
type Filter interface {
	AsEngageSubsetFilter() (*EngageSubsetFilter, bool)
	AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool)
	AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool)
	AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool)
	AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool)
	AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool)
	AsPushQuotaFilter() (*PushQuotaFilter, bool)
	AsAppInfoFilter() (*AppInfoFilter, bool)
}

func unmarshalFilter(body []byte) (Filter, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeEngageSubset):
		var esf EngageSubsetFilter
		err := json.Unmarshal(body, &esf)
		return esf, err
	case string(TypeEngageOldUsers):
		var eouf EngageOldUsersFilter
		err := json.Unmarshal(body, &eouf)
		return eouf, err
	case string(TypeEngageNewUsers):
		var enuf EngageNewUsersFilter
		err := json.Unmarshal(body, &enuf)
		return enuf, err
	case string(TypeEngageActiveUsers):
		var eauf EngageActiveUsersFilter
		err := json.Unmarshal(body, &eauf)
		return eauf, err
	case string(TypeEngageIdleUsers):
		var eiuf EngageIdleUsersFilter
		err := json.Unmarshal(body, &eiuf)
		return eiuf, err
	case string(TypeNativePushEnabled):
		var npef NativePushEnabledFilter
		err := json.Unmarshal(body, &npef)
		return npef, err
	case string(TypePushQuota):
		var pqf PushQuotaFilter
		err := json.Unmarshal(body, &pqf)
		return pqf, err
	case string(TypeAppInfo):
		var aif AppInfoFilter
		err := json.Unmarshal(body, &aif)
		return aif, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFilterArray(body []byte) ([]Filter, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fArray := make([]Filter, len(rawMessages))

	for index, rawMessage := range rawMessages {
		f, err := unmarshalFilter(*rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

// FirmwareVersionCriterion is used to target devices based on their firmware version.
type FirmwareVersionCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) MarshalJSON() ([]byte, error) {
	fvc.Type = TypeFirmwareVersion
	type Alias FirmwareVersionCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(fvc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return &fvc, true
}

// AsDeviceManufacturerCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for FirmwareVersionCriterion.
func (fvc FirmwareVersionCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// GeoFencingCriterion is used to target devices based on a specific region. A center point (defined by a latitude and
// longitude) and a radius form the boundary for the region. This criterion will be met when the user crosses the
// boundaries of the region.
type GeoFencingCriterion struct {
	Type       Type     `json:"type,omitempty"`
	Lat        *float64 `json:"lat,omitempty"`
	Lon        *float64 `json:"lon,omitempty"`
	Radius     *int32   `json:"radius,omitempty"`
	Expiration *int32   `json:"expiration,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoFencingCriterion.
func (gfc GeoFencingCriterion) MarshalJSON() ([]byte, error) {
	gfc.Type = TypeGeoFencing
	type Alias GeoFencingCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(gfc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return &gfc, true
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for GeoFencingCriterion.
func (gfc GeoFencingCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// ImportTask is
type ImportTask struct {
	StorageURL *string `json:"storageUrl,omitempty"`
}

// ImportTaskListResult is gets a paged list of import tasks.
type ImportTaskListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ImportTaskResult `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// ImportTaskListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ImportTaskListResult) ImportTaskListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ImportTaskResult is
type ImportTaskResult struct {
	autorest.Response `json:"-"`
	StorageURL        *string    `json:"storageUrl,omitempty"`
	ID                *string    `json:"id,omitempty"`
	State             JobStates  `json:"state,omitempty"`
	DateCreated       *date.Time `json:"dateCreated,omitempty"`
	DateCompleted     *date.Time `json:"dateCompleted,omitempty"`
	ErrorDetails      *string    `json:"errorDetails,omitempty"`
}

// IntegerTagCriterion is target devices based on an integer tag value.
type IntegerTagCriterion struct {
	Type  Type              `json:"type,omitempty"`
	Name  *string           `json:"name,omitempty"`
	Value *int32            `json:"value,omitempty"`
	Op    AudienceOperators `json:"op,omitempty"`
}

// MarshalJSON is the custom marshaler for IntegerTagCriterion.
func (itc IntegerTagCriterion) MarshalJSON() ([]byte, error) {
	itc.Type = TypeIntegerTag
	type Alias IntegerTagCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(itc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return &itc, true
}

// AsBooleanTagCriterion is the Criterion implementation for IntegerTagCriterion.
func (itc IntegerTagCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// LanguageCriterion is used to target devices based on the language of their device.
type LanguageCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for LanguageCriterion.
func (lc LanguageCriterion) MarshalJSON() ([]byte, error) {
	lc.Type = TypeLanguage
	type Alias LanguageCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(lc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return &lc, true
}

// AsScreenSizeCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for LanguageCriterion.
func (lc LanguageCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// LocationCriterion is used to target devices based on their last know area.
type LocationCriterion struct {
	Type     Type    `json:"type,omitempty"`
	Country  *string `json:"country,omitempty"`
	Region   *string `json:"region,omitempty"`
	Locality *string `json:"locality,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationCriterion.
func (lc LocationCriterion) MarshalJSON() ([]byte, error) {
	lc.Type = TypeLocation
	type Alias LocationCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(lc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return &lc, true
}

// AsGeoFencingCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for LocationCriterion.
func (lc LocationCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// NativePushEnabledFilter is engage only users with native push enabled.
type NativePushEnabledFilter struct {
	Type TypeFilter `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) MarshalJSON() ([]byte, error) {
	npef.Type = TypeNativePushEnabled
	type Alias NativePushEnabledFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(npef),
	})
}

// AsEngageSubsetFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return &npef, true
}

// AsPushQuotaFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return nil, false
}

// AsAppInfoFilter is the Filter implementation for NativePushEnabledFilter.
func (npef NativePushEnabledFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// NetworkTypeCriterion is used to target devices based their network type.
type NetworkTypeCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) MarshalJSON() ([]byte, error) {
	ntc.Type = TypeNetworkType
	type Alias NetworkTypeCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ntc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return &ntc, true
}

// AsLanguageCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for NetworkTypeCriterion.
func (ntc NetworkTypeCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// NotificationOptions is
type NotificationOptions struct {
	BigText    *string `json:"bigText,omitempty"`
	BigPicture *string `json:"bigPicture,omitempty"`
	Sound      *string `json:"sound,omitempty"`
	ActionText *string `json:"actionText,omitempty"`
}

// PollAnswerFeedbackCriterion is used to target devices who answered X to a given question.
type PollAnswerFeedbackCriterion struct {
	Type      Type   `json:"type,omitempty"`
	ContentID *int32 `json:"content-id,omitempty"`
	ChoiceID  *int32 `json:"choice-id,omitempty"`
}

// MarshalJSON is the custom marshaler for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) MarshalJSON() ([]byte, error) {
	pafc.Type = TypePollAnswerFeedback
	type Alias PollAnswerFeedbackCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pafc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return &pafc, true
}

// AsDatapushFeedbackCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for PollAnswerFeedbackCriterion.
func (pafc PollAnswerFeedbackCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// PollFeedbackCriterion is used to target devices who received a poll.
type PollFeedbackCriterion struct {
	Type      Type              `json:"type,omitempty"`
	ContentID *int32            `json:"content-id,omitempty"`
	Action    CampaignFeedbacks `json:"action,omitempty"`
}

// MarshalJSON is the custom marshaler for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) MarshalJSON() ([]byte, error) {
	pfc.Type = TypePollFeedback
	type Alias PollFeedbackCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pfc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return &pfc, true
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for PollFeedbackCriterion.
func (pfc PollFeedbackCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// PollQuestion is
type PollQuestion struct {
	Title        *string                               `json:"title,omitempty"`
	ID           *int32                                `json:"id,omitempty"`
	Localization *map[string]*PollQuestionLocalization `json:"localization,omitempty"`
	Choices      *[]PollQuestionChoice                 `json:"choices,omitempty"`
}

// PollQuestionChoice is
type PollQuestionChoice struct {
	Title        *string                                     `json:"title,omitempty"`
	ID           *int32                                      `json:"id,omitempty"`
	Localization *map[string]*PollQuestionChoiceLocalization `json:"localization,omitempty"`
	IsDefault    *bool                                       `json:"isDefault,omitempty"`
}

// PollQuestionChoiceLocalization is
type PollQuestionChoiceLocalization struct {
	Title *string `json:"title,omitempty"`
}

// PollQuestionLocalization is
type PollQuestionLocalization struct {
	Title *string `json:"title,omitempty"`
}

// PushQuotaFilter is engage only users for whom the push quota is not reached.
type PushQuotaFilter struct {
	Type TypeFilter `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PushQuotaFilter.
func (pqf PushQuotaFilter) MarshalJSON() ([]byte, error) {
	pqf.Type = TypePushQuota
	type Alias PushQuotaFilter
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pqf),
	})
}

// AsEngageSubsetFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsEngageSubsetFilter() (*EngageSubsetFilter, bool) {
	return nil, false
}

// AsEngageOldUsersFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsEngageOldUsersFilter() (*EngageOldUsersFilter, bool) {
	return nil, false
}

// AsEngageNewUsersFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsEngageNewUsersFilter() (*EngageNewUsersFilter, bool) {
	return nil, false
}

// AsEngageActiveUsersFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsEngageActiveUsersFilter() (*EngageActiveUsersFilter, bool) {
	return nil, false
}

// AsEngageIdleUsersFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsEngageIdleUsersFilter() (*EngageIdleUsersFilter, bool) {
	return nil, false
}

// AsNativePushEnabledFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsNativePushEnabledFilter() (*NativePushEnabledFilter, bool) {
	return nil, false
}

// AsPushQuotaFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsPushQuotaFilter() (*PushQuotaFilter, bool) {
	return &pqf, true
}

// AsAppInfoFilter is the Filter implementation for PushQuotaFilter.
func (pqf PushQuotaFilter) AsAppInfoFilter() (*AppInfoFilter, bool) {
	return nil, false
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ScreenSizeCriterion is used to target devices based on the screen resolution of their device.
type ScreenSizeCriterion struct {
	Type Type    `json:"type,omitempty"`
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) MarshalJSON() ([]byte, error) {
	ssc.Type = TypeScreenSize
	type Alias ScreenSizeCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ssc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return &ssc, true
}

// AsLocationCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for ScreenSizeCriterion.
func (ssc ScreenSizeCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// SegmentCriterion is target devices based on an existing segment.
type SegmentCriterion struct {
	Type    Type   `json:"type,omitempty"`
	ID      *int32 `json:"id,omitempty"`
	Exclude *bool  `json:"exclude,omitempty"`
}

// MarshalJSON is the custom marshaler for SegmentCriterion.
func (sc SegmentCriterion) MarshalJSON() ([]byte, error) {
	sc.Type = TypeSegment
	type Alias SegmentCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return &sc, true
}

// AsStringTagCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return nil, false
}

// AsDateTagCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for SegmentCriterion.
func (sc SegmentCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// StringTagCriterion is target devices based on a string tag value.
type StringTagCriterion struct {
	Type  Type    `json:"type,omitempty"`
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for StringTagCriterion.
func (stc StringTagCriterion) MarshalJSON() ([]byte, error) {
	stc.Type = TypeStringTag
	type Alias StringTagCriterion
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(stc),
	})
}

// AsCarrierNameCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsCarrierNameCriterion() (*CarrierNameCriterion, bool) {
	return nil, false
}

// AsCarrierCountryCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsCarrierCountryCriterion() (*CarrierCountryCriterion, bool) {
	return nil, false
}

// AsFirmwareVersionCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsFirmwareVersionCriterion() (*FirmwareVersionCriterion, bool) {
	return nil, false
}

// AsDeviceManufacturerCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsDeviceManufacturerCriterion() (*DeviceManufacturerCriterion, bool) {
	return nil, false
}

// AsDeviceModelCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsDeviceModelCriterion() (*DeviceModelCriterion, bool) {
	return nil, false
}

// AsApplicationVersionCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsApplicationVersionCriterion() (*ApplicationVersionCriterion, bool) {
	return nil, false
}

// AsNetworkTypeCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsNetworkTypeCriterion() (*NetworkTypeCriterion, bool) {
	return nil, false
}

// AsLanguageCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsLanguageCriterion() (*LanguageCriterion, bool) {
	return nil, false
}

// AsScreenSizeCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsScreenSizeCriterion() (*ScreenSizeCriterion, bool) {
	return nil, false
}

// AsLocationCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsLocationCriterion() (*LocationCriterion, bool) {
	return nil, false
}

// AsGeoFencingCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsGeoFencingCriterion() (*GeoFencingCriterion, bool) {
	return nil, false
}

// AsAnnouncementFeedbackCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsAnnouncementFeedbackCriterion() (*AnnouncementFeedbackCriterion, bool) {
	return nil, false
}

// AsPollFeedbackCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsPollFeedbackCriterion() (*PollFeedbackCriterion, bool) {
	return nil, false
}

// AsPollAnswerFeedbackCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsPollAnswerFeedbackCriterion() (*PollAnswerFeedbackCriterion, bool) {
	return nil, false
}

// AsDatapushFeedbackCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsDatapushFeedbackCriterion() (*DatapushFeedbackCriterion, bool) {
	return nil, false
}

// AsSegmentCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsSegmentCriterion() (*SegmentCriterion, bool) {
	return nil, false
}

// AsStringTagCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsStringTagCriterion() (*StringTagCriterion, bool) {
	return &stc, true
}

// AsDateTagCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsDateTagCriterion() (*DateTagCriterion, bool) {
	return nil, false
}

// AsIntegerTagCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsIntegerTagCriterion() (*IntegerTagCriterion, bool) {
	return nil, false
}

// AsBooleanTagCriterion is the Criterion implementation for StringTagCriterion.
func (stc StringTagCriterion) AsBooleanTagCriterion() (*BooleanTagCriterion, bool) {
	return nil, false
}

// SupportedPlatformsListResult is
type SupportedPlatformsListResult struct {
	autorest.Response `json:"-"`
	Platforms         *[]string `json:"platforms,omitempty"`
}
