package commitmentplans

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CommitmentAssociation is represents the association between a commitment plan and some other resource, such as a
// Machine Learning web service.
type CommitmentAssociation struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Tags              *map[string]*string              `json:"tags,omitempty"`
	Etag              *string                          `json:"etag,omitempty"`
	Properties        *CommitmentAssociationProperties `json:"properties,omitempty"`
}

// CommitmentAssociationListResult is a page of commitment association resources.
type CommitmentAssociationListResult struct {
	autorest.Response `json:"-"`
	NextLink          *string                  `json:"nextLink,omitempty"`
	Value             *[]CommitmentAssociation `json:"value,omitempty"`
}

// CommitmentAssociationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CommitmentAssociationListResult) CommitmentAssociationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CommitmentAssociationProperties is properties of an Azure ML commitment association.
type CommitmentAssociationProperties struct {
	AssociatedResourceID *string    `json:"associatedResourceId,omitempty"`
	CommitmentPlanID     *string    `json:"commitmentPlanId,omitempty"`
	CreationDate         *date.Time `json:"creationDate,omitempty"`
}

// CommitmentPlan is an Azure ML commitment plan resource.
type CommitmentPlan struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	Properties        *Properties         `json:"properties,omitempty"`
	Sku               *ResourceSku        `json:"sku,omitempty"`
}

// ListResult is a page of commitment plan resources.
type ListResult struct {
	autorest.Response `json:"-"`
	NextLink          *string           `json:"nextLink,omitempty"`
	Value             *[]CommitmentPlan `json:"value,omitempty"`
}

// ListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ListResult) ListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// MoveCommitmentAssociationRequest is specifies the destination Azure ML commitment plan for a move operation.
type MoveCommitmentAssociationRequest struct {
	DestinationPlanID *string `json:"destinationPlanId,omitempty"`
}

// PatchPayload is the properties of a commitment plan which may be updated via PATCH.
type PatchPayload struct {
	Tags *map[string]*string `json:"tags,omitempty"`
	Sku  *ResourceSku        `json:"sku,omitempty"`
}

// PlanQuantity is represents the quantity a commitment plan provides of a metered resource.
type PlanQuantity struct {
	Allowance             *float64 `json:"allowance,omitempty"`
	Amount                *float64 `json:"amount,omitempty"`
	IncludedQuantityMeter *string  `json:"includedQuantityMeter,omitempty"`
	OverageMeter          *string  `json:"overageMeter,omitempty"`
}

// PlanUsageHistory is represents historical information about usage of the Azure resources associated with a
// commitment plan.
type PlanUsageHistory struct {
	PlanDeletionOverage       *map[string]*float64 `json:"planDeletionOverage,omitempty"`
	PlanMigrationOverage      *map[string]*float64 `json:"planMigrationOverage,omitempty"`
	PlanQuantitiesAfterUsage  *map[string]*float64 `json:"planQuantitiesAfterUsage,omitempty"`
	PlanQuantitiesBeforeUsage *map[string]*float64 `json:"planQuantitiesBeforeUsage,omitempty"`
	PlanUsageOverage          *map[string]*float64 `json:"planUsageOverage,omitempty"`
	Usage                     *map[string]*float64 `json:"usage,omitempty"`
	UsageDate                 *date.Time           `json:"usageDate,omitempty"`
}

// PlanUsageHistoryListResult is a page of usage history.
type PlanUsageHistoryListResult struct {
	autorest.Response `json:"-"`
	NextLink          *string             `json:"nextLink,omitempty"`
	Value             *[]PlanUsageHistory `json:"value,omitempty"`
}

// PlanUsageHistoryListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PlanUsageHistoryListResult) PlanUsageHistoryListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Properties is properties of an Azure ML commitment plan.
type Properties struct {
	ChargeForOverage      *bool                     `json:"chargeForOverage,omitempty"`
	ChargeForPlan         *bool                     `json:"chargeForPlan,omitempty"`
	CreationDate          *date.Time                `json:"creationDate,omitempty"`
	IncludedQuantities    *map[string]*PlanQuantity `json:"includedQuantities,omitempty"`
	MaxAssociationLimit   *int32                    `json:"maxAssociationLimit,omitempty"`
	MaxCapacityLimit      *int32                    `json:"maxCapacityLimit,omitempty"`
	MinCapacityLimit      *int32                    `json:"minCapacityLimit,omitempty"`
	PlanMeter             *string                   `json:"planMeter,omitempty"`
	RefillFrequencyInDays *int32                    `json:"refillFrequencyInDays,omitempty"`
	SuspendPlanOnOverage  *bool                     `json:"suspendPlanOnOverage,omitempty"`
}

// Resource is common properties of an ARM resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Location *string             `json:"location,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceSku is the SKU of a resource.
type ResourceSku struct {
	Capacity *int32  `json:"capacity,omitempty"`
	Name     *string `json:"name,omitempty"`
	Tier     *string `json:"tier,omitempty"`
}
