package customerinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// PredictionsClient is the the Azure Customer Insights management API provides a RESTful set of web services that
// interact with Azure Customer Insights service to manage your resources. The API has entities that capture the
// relationship between an end user and the Azure Customer Insights service.
type PredictionsClient struct {
	ManagementClient
}

// NewPredictionsClient creates an instance of the PredictionsClient client.
func NewPredictionsClient(subscriptionID string) PredictionsClient {
	return NewPredictionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPredictionsClientWithBaseURI creates an instance of the PredictionsClient client.
func NewPredictionsClientWithBaseURI(baseURI string, subscriptionID string) PredictionsClient {
	return PredictionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates a Prediction or updates an existing Prediction in the hub. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction. parameters is parameters supplied to the create/update Prediction operation.
func (client PredictionsClient) CreateOrUpdate(resourceGroupName string, hubName string, predictionName string, parameters PredictionResourceFormat, cancel <-chan struct{}) (<-chan PredictionResourceFormat, <-chan error) {
	resultChan := make(chan PredictionResourceFormat, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: predictionName,
			Constraints: []validation.Constraint{{Target: "predictionName", Name: validation.MaxLength, Rule: 512, Chain: nil},
				{Target: "predictionName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Prediction", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.Prediction.NegativeOutcomeExpression", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.PositiveOutcomeExpression", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.PrimaryProfileType", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.ScopeExpression", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.AutoAnalyze", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.Mappings", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.Prediction.ScoreLabel", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "customerinsights.PredictionsClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result PredictionResourceFormat
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, hubName, predictionName, parameters, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client PredictionsClient) CreateOrUpdatePreparer(resourceGroupName string, hubName string, predictionName string, parameters PredictionResourceFormat, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client PredictionsClient) CreateOrUpdateResponder(resp *http.Response) (result PredictionResourceFormat, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a Prediction in the hub. This method may poll for completion. Polling can be canceled by passing the
// cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction.
func (client PredictionsClient) Delete(resourceGroupName string, hubName string, predictionName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	go func() {
		var err error
		var result autorest.Response
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.DeletePreparer(resourceGroupName, hubName, predictionName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Delete", nil, "Failure preparing request")
			return
		}

		resp, err := client.DeleteSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Delete", resp, "Failure sending request")
			return
		}

		result, err = client.DeleteResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Delete", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// DeletePreparer prepares the Delete request.
func (client PredictionsClient) DeletePreparer(resourceGroupName string, hubName string, predictionName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client PredictionsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a Prediction in the hub.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction.
func (client PredictionsClient) Get(resourceGroupName string, hubName string, predictionName string) (result PredictionResourceFormat, err error) {
	req, err := client.GetPreparer(resourceGroupName, hubName, predictionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client PredictionsClient) GetPreparer(resourceGroupName string, hubName string, predictionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PredictionsClient) GetResponder(resp *http.Response) (result PredictionResourceFormat, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetModelStatus gets model status of the prediction.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction.
func (client PredictionsClient) GetModelStatus(resourceGroupName string, hubName string, predictionName string) (result PredictionModelStatus, err error) {
	req, err := client.GetModelStatusPreparer(resourceGroupName, hubName, predictionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetModelStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetModelStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetModelStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetModelStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetModelStatus", resp, "Failure responding to request")
	}

	return
}

// GetModelStatusPreparer prepares the GetModelStatus request.
func (client PredictionsClient) GetModelStatusPreparer(resourceGroupName string, hubName string, predictionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getModelStatus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetModelStatusSender sends the GetModelStatus request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) GetModelStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetModelStatusResponder handles the response to the GetModelStatus request. The method always
// closes the http.Response Body.
func (client PredictionsClient) GetModelStatusResponder(resp *http.Response) (result PredictionModelStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTrainingResults gets training results.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction.
func (client PredictionsClient) GetTrainingResults(resourceGroupName string, hubName string, predictionName string) (result PredictionTrainingResults, err error) {
	req, err := client.GetTrainingResultsPreparer(resourceGroupName, hubName, predictionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetTrainingResults", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTrainingResultsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetTrainingResults", resp, "Failure sending request")
		return
	}

	result, err = client.GetTrainingResultsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "GetTrainingResults", resp, "Failure responding to request")
	}

	return
}

// GetTrainingResultsPreparer prepares the GetTrainingResults request.
func (client PredictionsClient) GetTrainingResultsPreparer(resourceGroupName string, hubName string, predictionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/getTrainingResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTrainingResultsSender sends the GetTrainingResults request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) GetTrainingResultsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTrainingResultsResponder handles the response to the GetTrainingResults request. The method always
// closes the http.Response Body.
func (client PredictionsClient) GetTrainingResultsResponder(resp *http.Response) (result PredictionTrainingResults, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByHub gets all the predictions in the specified hub.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub.
func (client PredictionsClient) ListByHub(resourceGroupName string, hubName string) (result PredictionListResult, err error) {
	req, err := client.ListByHubPreparer(resourceGroupName, hubName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByHubSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", resp, "Failure sending request")
		return
	}

	result, err = client.ListByHubResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", resp, "Failure responding to request")
	}

	return
}

// ListByHubPreparer prepares the ListByHub request.
func (client PredictionsClient) ListByHubPreparer(resourceGroupName string, hubName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByHubSender sends the ListByHub request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) ListByHubSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByHubResponder handles the response to the ListByHub request. The method always
// closes the http.Response Body.
func (client PredictionsClient) ListByHubResponder(resp *http.Response) (result PredictionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByHubNextResults retrieves the next set of results, if any.
func (client PredictionsClient) ListByHubNextResults(lastResults PredictionListResult) (result PredictionListResult, err error) {
	req, err := lastResults.PredictionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByHubSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", resp, "Failure sending next results request")
	}

	result, err = client.ListByHubResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ListByHub", resp, "Failure responding to next results request")
	}

	return
}

// ListByHubComplete gets all elements from the list without paging.
func (client PredictionsClient) ListByHubComplete(resourceGroupName string, hubName string, cancel <-chan struct{}) (<-chan PredictionResourceFormat, <-chan error) {
	resultChan := make(chan PredictionResourceFormat)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListByHub(resourceGroupName, hubName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListByHubNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ModelStatus creates or updates the model status of prediction.
//
// resourceGroupName is the name of the resource group. hubName is the name of the hub. predictionName is the name of
// the Prediction. parameters is parameters supplied to the create/update prediction model status operation.
func (client PredictionsClient) ModelStatus(resourceGroupName string, hubName string, predictionName string, parameters PredictionModelStatus) (result autorest.Response, err error) {
	req, err := client.ModelStatusPreparer(resourceGroupName, hubName, predictionName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ModelStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ModelStatusSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ModelStatus", resp, "Failure sending request")
		return
	}

	result, err = client.ModelStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "customerinsights.PredictionsClient", "ModelStatus", resp, "Failure responding to request")
	}

	return
}

// ModelStatusPreparer prepares the ModelStatus request.
func (client PredictionsClient) ModelStatusPreparer(resourceGroupName string, hubName string, predictionName string, parameters PredictionModelStatus) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hubName":           autorest.Encode("path", hubName),
		"predictionName":    autorest.Encode("path", predictionName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-26"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}/modelStatus", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ModelStatusSender sends the ModelStatus request. The method will close the
// http.Response Body if it receives an error.
func (client PredictionsClient) ModelStatusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ModelStatusResponder handles the response to the ModelStatus request. The method always
// closes the http.Response Body.
func (client PredictionsClient) ModelStatusResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
