package customerinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/shopspring/decimal"
	"net/http"
)

// CalculationWindowTypes enumerates the values for calculation window types.
type CalculationWindowTypes string

const (
	// Day specifies the day state for calculation window types.
	Day CalculationWindowTypes = "Day"
	// Hour specifies the hour state for calculation window types.
	Hour CalculationWindowTypes = "Hour"
	// Lifetime specifies the lifetime state for calculation window types.
	Lifetime CalculationWindowTypes = "Lifetime"
	// Month specifies the month state for calculation window types.
	Month CalculationWindowTypes = "Month"
	// Week specifies the week state for calculation window types.
	Week CalculationWindowTypes = "Week"
)

// CanonicalPropertyValueType enumerates the values for canonical property value type.
type CanonicalPropertyValueType string

const (
	// Categorical specifies the categorical state for canonical property value type.
	Categorical CanonicalPropertyValueType = "Categorical"
	// DerivedCategorical specifies the derived categorical state for canonical property value type.
	DerivedCategorical CanonicalPropertyValueType = "DerivedCategorical"
	// DerivedNumeric specifies the derived numeric state for canonical property value type.
	DerivedNumeric CanonicalPropertyValueType = "DerivedNumeric"
	// Numeric specifies the numeric state for canonical property value type.
	Numeric CanonicalPropertyValueType = "Numeric"
)

// CardinalityTypes enumerates the values for cardinality types.
type CardinalityTypes string

const (
	// ManyToMany specifies the many to many state for cardinality types.
	ManyToMany CardinalityTypes = "ManyToMany"
	// OneToMany specifies the one to many state for cardinality types.
	OneToMany CardinalityTypes = "OneToMany"
	// OneToOne specifies the one to one state for cardinality types.
	OneToOne CardinalityTypes = "OneToOne"
)

// CompletionOperationTypes enumerates the values for completion operation types.
type CompletionOperationTypes string

const (
	// DeleteFile specifies the delete file state for completion operation types.
	DeleteFile CompletionOperationTypes = "DeleteFile"
	// DoNothing specifies the do nothing state for completion operation types.
	DoNothing CompletionOperationTypes = "DoNothing"
	// MoveFile specifies the move file state for completion operation types.
	MoveFile CompletionOperationTypes = "MoveFile"
)

// ConnectorMappingStates enumerates the values for connector mapping states.
type ConnectorMappingStates string

const (
	// Created specifies the created state for connector mapping states.
	Created ConnectorMappingStates = "Created"
	// Creating specifies the creating state for connector mapping states.
	Creating ConnectorMappingStates = "Creating"
	// Expiring specifies the expiring state for connector mapping states.
	Expiring ConnectorMappingStates = "Expiring"
	// Failed specifies the failed state for connector mapping states.
	Failed ConnectorMappingStates = "Failed"
	// Ready specifies the ready state for connector mapping states.
	Ready ConnectorMappingStates = "Ready"
	// Running specifies the running state for connector mapping states.
	Running ConnectorMappingStates = "Running"
	// Stopped specifies the stopped state for connector mapping states.
	Stopped ConnectorMappingStates = "Stopped"
)

// ConnectorStates enumerates the values for connector states.
type ConnectorStates string

const (
	// ConnectorStatesCreated specifies the connector states created state for connector states.
	ConnectorStatesCreated ConnectorStates = "Created"
	// ConnectorStatesCreating specifies the connector states creating state for connector states.
	ConnectorStatesCreating ConnectorStates = "Creating"
	// ConnectorStatesDeleting specifies the connector states deleting state for connector states.
	ConnectorStatesDeleting ConnectorStates = "Deleting"
	// ConnectorStatesExpiring specifies the connector states expiring state for connector states.
	ConnectorStatesExpiring ConnectorStates = "Expiring"
	// ConnectorStatesFailed specifies the connector states failed state for connector states.
	ConnectorStatesFailed ConnectorStates = "Failed"
	// ConnectorStatesReady specifies the connector states ready state for connector states.
	ConnectorStatesReady ConnectorStates = "Ready"
)

// ConnectorTypes enumerates the values for connector types.
type ConnectorTypes string

const (
	// AzureBlob specifies the azure blob state for connector types.
	AzureBlob ConnectorTypes = "AzureBlob"
	// CRM specifies the crm state for connector types.
	CRM ConnectorTypes = "CRM"
	// ExchangeOnline specifies the exchange online state for connector types.
	ExchangeOnline ConnectorTypes = "ExchangeOnline"
	// None specifies the none state for connector types.
	None ConnectorTypes = "None"
	// Outbound specifies the outbound state for connector types.
	Outbound ConnectorTypes = "Outbound"
	// Salesforce specifies the salesforce state for connector types.
	Salesforce ConnectorTypes = "Salesforce"
)

// DataSourceType enumerates the values for data source type.
type DataSourceType string

const (
	// DataSourceTypeConnector specifies the data source type connector state for data source type.
	DataSourceTypeConnector DataSourceType = "Connector"
	// DataSourceTypeLinkInteraction specifies the data source type link interaction state for data source type.
	DataSourceTypeLinkInteraction DataSourceType = "LinkInteraction"
	// DataSourceTypeSystemDefault specifies the data source type system default state for data source type.
	DataSourceTypeSystemDefault DataSourceType = "SystemDefault"
)

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeInteraction specifies the entity type interaction state for entity type.
	EntityTypeInteraction EntityType = "Interaction"
	// EntityTypeNone specifies the entity type none state for entity type.
	EntityTypeNone EntityType = "None"
	// EntityTypeProfile specifies the entity type profile state for entity type.
	EntityTypeProfile EntityType = "Profile"
	// EntityTypeRelationship specifies the entity type relationship state for entity type.
	EntityTypeRelationship EntityType = "Relationship"
)

// EntityTypes enumerates the values for entity types.
type EntityTypes string

const (
	// EntityTypesInteraction specifies the entity types interaction state for entity types.
	EntityTypesInteraction EntityTypes = "Interaction"
	// EntityTypesNone specifies the entity types none state for entity types.
	EntityTypesNone EntityTypes = "None"
	// EntityTypesProfile specifies the entity types profile state for entity types.
	EntityTypesProfile EntityTypes = "Profile"
	// EntityTypesRelationship specifies the entity types relationship state for entity types.
	EntityTypesRelationship EntityTypes = "Relationship"
)

// ErrorManagementTypes enumerates the values for error management types.
type ErrorManagementTypes string

const (
	// RejectAndContinue specifies the reject and continue state for error management types.
	RejectAndContinue ErrorManagementTypes = "RejectAndContinue"
	// RejectUntilLimit specifies the reject until limit state for error management types.
	RejectUntilLimit ErrorManagementTypes = "RejectUntilLimit"
	// StopImport specifies the stop import state for error management types.
	StopImport ErrorManagementTypes = "StopImport"
)

// FrequencyTypes enumerates the values for frequency types.
type FrequencyTypes string

const (
	// FrequencyTypesDay specifies the frequency types day state for frequency types.
	FrequencyTypesDay FrequencyTypes = "Day"
	// FrequencyTypesHour specifies the frequency types hour state for frequency types.
	FrequencyTypesHour FrequencyTypes = "Hour"
	// FrequencyTypesMinute specifies the frequency types minute state for frequency types.
	FrequencyTypesMinute FrequencyTypes = "Minute"
	// FrequencyTypesMonth specifies the frequency types month state for frequency types.
	FrequencyTypesMonth FrequencyTypes = "Month"
	// FrequencyTypesWeek specifies the frequency types week state for frequency types.
	FrequencyTypesWeek FrequencyTypes = "Week"
)

// InstanceOperationType enumerates the values for instance operation type.
type InstanceOperationType string

const (
	// Delete specifies the delete state for instance operation type.
	Delete InstanceOperationType = "Delete"
	// Upsert specifies the upsert state for instance operation type.
	Upsert InstanceOperationType = "Upsert"
)

// KpiFunctions enumerates the values for kpi functions.
type KpiFunctions string

const (
	// KpiFunctionsAvg specifies the kpi functions avg state for kpi functions.
	KpiFunctionsAvg KpiFunctions = "Avg"
	// KpiFunctionsCount specifies the kpi functions count state for kpi functions.
	KpiFunctionsCount KpiFunctions = "Count"
	// KpiFunctionsCountDistinct specifies the kpi functions count distinct state for kpi functions.
	KpiFunctionsCountDistinct KpiFunctions = "CountDistinct"
	// KpiFunctionsLast specifies the kpi functions last state for kpi functions.
	KpiFunctionsLast KpiFunctions = "Last"
	// KpiFunctionsMax specifies the kpi functions max state for kpi functions.
	KpiFunctionsMax KpiFunctions = "Max"
	// KpiFunctionsMin specifies the kpi functions min state for kpi functions.
	KpiFunctionsMin KpiFunctions = "Min"
	// KpiFunctionsNone specifies the kpi functions none state for kpi functions.
	KpiFunctionsNone KpiFunctions = "None"
	// KpiFunctionsSum specifies the kpi functions sum state for kpi functions.
	KpiFunctionsSum KpiFunctions = "Sum"
)

// LinkTypes enumerates the values for link types.
type LinkTypes string

const (
	// CopyIfNull specifies the copy if null state for link types.
	CopyIfNull LinkTypes = "CopyIfNull"
	// UpdateAlways specifies the update always state for link types.
	UpdateAlways LinkTypes = "UpdateAlways"
)

// PermissionTypes enumerates the values for permission types.
type PermissionTypes string

const (
	// Manage specifies the manage state for permission types.
	Manage PermissionTypes = "Manage"
	// Read specifies the read state for permission types.
	Read PermissionTypes = "Read"
	// Write specifies the write state for permission types.
	Write PermissionTypes = "Write"
)

// PredictionModelLifeCycle enumerates the values for prediction model life cycle.
type PredictionModelLifeCycle string

const (
	// PredictionModelLifeCycleActive specifies the prediction model life cycle active state for prediction model life
	// cycle.
	PredictionModelLifeCycleActive PredictionModelLifeCycle = "Active"
	// PredictionModelLifeCycleDeleted specifies the prediction model life cycle deleted state for prediction model life
	// cycle.
	PredictionModelLifeCycleDeleted PredictionModelLifeCycle = "Deleted"
	// PredictionModelLifeCycleDiscovering specifies the prediction model life cycle discovering state for prediction model
	// life cycle.
	PredictionModelLifeCycleDiscovering PredictionModelLifeCycle = "Discovering"
	// PredictionModelLifeCycleEvaluating specifies the prediction model life cycle evaluating state for prediction model
	// life cycle.
	PredictionModelLifeCycleEvaluating PredictionModelLifeCycle = "Evaluating"
	// PredictionModelLifeCycleEvaluatingFailed specifies the prediction model life cycle evaluating failed state for
	// prediction model life cycle.
	PredictionModelLifeCycleEvaluatingFailed PredictionModelLifeCycle = "EvaluatingFailed"
	// PredictionModelLifeCycleFailed specifies the prediction model life cycle failed state for prediction model life
	// cycle.
	PredictionModelLifeCycleFailed PredictionModelLifeCycle = "Failed"
	// PredictionModelLifeCycleFeaturing specifies the prediction model life cycle featuring state for prediction model
	// life cycle.
	PredictionModelLifeCycleFeaturing PredictionModelLifeCycle = "Featuring"
	// PredictionModelLifeCycleFeaturingFailed specifies the prediction model life cycle featuring failed state for
	// prediction model life cycle.
	PredictionModelLifeCycleFeaturingFailed PredictionModelLifeCycle = "FeaturingFailed"
	// PredictionModelLifeCycleHumanIntervention specifies the prediction model life cycle human intervention state for
	// prediction model life cycle.
	PredictionModelLifeCycleHumanIntervention PredictionModelLifeCycle = "HumanIntervention"
	// PredictionModelLifeCycleNew specifies the prediction model life cycle new state for prediction model life cycle.
	PredictionModelLifeCycleNew PredictionModelLifeCycle = "New"
	// PredictionModelLifeCyclePendingDiscovering specifies the prediction model life cycle pending discovering state for
	// prediction model life cycle.
	PredictionModelLifeCyclePendingDiscovering PredictionModelLifeCycle = "PendingDiscovering"
	// PredictionModelLifeCyclePendingFeaturing specifies the prediction model life cycle pending featuring state for
	// prediction model life cycle.
	PredictionModelLifeCyclePendingFeaturing PredictionModelLifeCycle = "PendingFeaturing"
	// PredictionModelLifeCyclePendingModelConfirmation specifies the prediction model life cycle pending model
	// confirmation state for prediction model life cycle.
	PredictionModelLifeCyclePendingModelConfirmation PredictionModelLifeCycle = "PendingModelConfirmation"
	// PredictionModelLifeCyclePendingTraining specifies the prediction model life cycle pending training state for
	// prediction model life cycle.
	PredictionModelLifeCyclePendingTraining PredictionModelLifeCycle = "PendingTraining"
	// PredictionModelLifeCycleProvisioning specifies the prediction model life cycle provisioning state for prediction
	// model life cycle.
	PredictionModelLifeCycleProvisioning PredictionModelLifeCycle = "Provisioning"
	// PredictionModelLifeCycleProvisioningFailed specifies the prediction model life cycle provisioning failed state for
	// prediction model life cycle.
	PredictionModelLifeCycleProvisioningFailed PredictionModelLifeCycle = "ProvisioningFailed"
	// PredictionModelLifeCycleTraining specifies the prediction model life cycle training state for prediction model life
	// cycle.
	PredictionModelLifeCycleTraining PredictionModelLifeCycle = "Training"
	// PredictionModelLifeCycleTrainingFailed specifies the prediction model life cycle training failed state for
	// prediction model life cycle.
	PredictionModelLifeCycleTrainingFailed PredictionModelLifeCycle = "TrainingFailed"
)

// ProvisioningStates enumerates the values for provisioning states.
type ProvisioningStates string

const (
	// ProvisioningStatesDeleting specifies the provisioning states deleting state for provisioning states.
	ProvisioningStatesDeleting ProvisioningStates = "Deleting"
	// ProvisioningStatesExpiring specifies the provisioning states expiring state for provisioning states.
	ProvisioningStatesExpiring ProvisioningStates = "Expiring"
	// ProvisioningStatesFailed specifies the provisioning states failed state for provisioning states.
	ProvisioningStatesFailed ProvisioningStates = "Failed"
	// ProvisioningStatesHumanIntervention specifies the provisioning states human intervention state for provisioning
	// states.
	ProvisioningStatesHumanIntervention ProvisioningStates = "HumanIntervention"
	// ProvisioningStatesProvisioning specifies the provisioning states provisioning state for provisioning states.
	ProvisioningStatesProvisioning ProvisioningStates = "Provisioning"
	// ProvisioningStatesSucceeded specifies the provisioning states succeeded state for provisioning states.
	ProvisioningStatesSucceeded ProvisioningStates = "Succeeded"
)

// RoleTypes enumerates the values for role types.
type RoleTypes string

const (
	// Admin specifies the admin state for role types.
	Admin RoleTypes = "Admin"
	// DataAdmin specifies the data admin state for role types.
	DataAdmin RoleTypes = "DataAdmin"
	// DataReader specifies the data reader state for role types.
	DataReader RoleTypes = "DataReader"
	// ManageAdmin specifies the manage admin state for role types.
	ManageAdmin RoleTypes = "ManageAdmin"
	// ManageReader specifies the manage reader state for role types.
	ManageReader RoleTypes = "ManageReader"
	// Reader specifies the reader state for role types.
	Reader RoleTypes = "Reader"
)

// Status enumerates the values for status.
type Status string

const (
	// StatusActive specifies the status active state for status.
	StatusActive Status = "Active"
	// StatusDeleted specifies the status deleted state for status.
	StatusDeleted Status = "Deleted"
	// StatusNone specifies the status none state for status.
	StatusNone Status = "None"
)

// AssignmentPrincipal is the AssignmentPrincipal
type AssignmentPrincipal struct {
	PrincipalID       *string             `json:"principalId,omitempty"`
	PrincipalType     *string             `json:"principalType,omitempty"`
	PrincipalMetadata *map[string]*string `json:"principalMetadata,omitempty"`
}

// AuthorizationPolicy is the authorization policy.
type AuthorizationPolicy struct {
	autorest.Response `json:"-"`
	PolicyName        *string            `json:"policyName,omitempty"`
	Permissions       *[]PermissionTypes `json:"permissions,omitempty"`
	PrimaryKey        *string            `json:"primaryKey,omitempty"`
	SecondaryKey      *string            `json:"secondaryKey,omitempty"`
}

// AuthorizationPolicyListResult is the response of list authorization policy operation.
type AuthorizationPolicyListResult struct {
	autorest.Response `json:"-"`
	Value             *[]AuthorizationPolicyResourceFormat `json:"value,omitempty"`
	NextLink          *string                              `json:"nextLink,omitempty"`
}

// AuthorizationPolicyListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AuthorizationPolicyListResult) AuthorizationPolicyListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AuthorizationPolicyResourceFormat is the authorization policy resource format.
type AuthorizationPolicyResourceFormat struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*AuthorizationPolicy `json:"properties,omitempty"`
}

// AzureBlobConnectorProperties is the Azure Blob connector properties.
type AzureBlobConnectorProperties struct {
	ConnectionKeyVaultURL *string `json:"connectionKeyVaultUrl,omitempty"`
}

// CanonicalProfileDefinition is definition of canonical profile.
type CanonicalProfileDefinition struct {
	CanonicalProfileID *int32                                      `json:"canonicalProfileId,omitempty"`
	Properties         *[]CanonicalProfileDefinitionPropertiesItem `json:"properties,omitempty"`
}

// CanonicalProfileDefinitionPropertiesItem is the definition of a canonical profile property.
type CanonicalProfileDefinitionPropertiesItem struct {
	ProfileName         *string                    `json:"profileName,omitempty"`
	ProfilePropertyName *string                    `json:"profilePropertyName,omitempty"`
	Rank                *int32                     `json:"rank,omitempty"`
	Type                CanonicalPropertyValueType `json:"type,omitempty"`
	Value               *string                    `json:"value,omitempty"`
}

// Connector is properties of connector.
type Connector struct {
	ConnectorID         *int32                              `json:"connectorId,omitempty"`
	ConnectorName       *string                             `json:"connectorName,omitempty"`
	ConnectorType       ConnectorTypes                      `json:"connectorType,omitempty"`
	DisplayName         *string                             `json:"displayName,omitempty"`
	Description         *string                             `json:"description,omitempty"`
	ConnectorProperties *map[string]*map[string]interface{} `json:"connectorProperties,omitempty"`
	Created             *date.Time                          `json:"created,omitempty"`
	LastModified        *date.Time                          `json:"lastModified,omitempty"`
	State               ConnectorStates                     `json:"state,omitempty"`
	TenantID            *string                             `json:"tenantId,omitempty"`
	IsInternal          *bool                               `json:"isInternal,omitempty"`
}

// ConnectorListResult is the response of list connector operation.
type ConnectorListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ConnectorResourceFormat `json:"value,omitempty"`
	NextLink          *string                    `json:"nextLink,omitempty"`
}

// ConnectorListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ConnectorListResult) ConnectorListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ConnectorMapping is the connector mapping definition.
type ConnectorMapping struct {
	ConnectorName        *string                     `json:"connectorName,omitempty"`
	ConnectorType        ConnectorTypes              `json:"connectorType,omitempty"`
	Created              *date.Time                  `json:"created,omitempty"`
	LastModified         *date.Time                  `json:"lastModified,omitempty"`
	EntityType           EntityTypes                 `json:"entityType,omitempty"`
	EntityTypeName       *string                     `json:"entityTypeName,omitempty"`
	ConnectorMappingName *string                     `json:"connectorMappingName,omitempty"`
	DisplayName          *string                     `json:"displayName,omitempty"`
	Description          *string                     `json:"description,omitempty"`
	DataFormatID         *string                     `json:"dataFormatId,omitempty"`
	MappingProperties    *ConnectorMappingProperties `json:"mappingProperties,omitempty"`
	NextRunTime          *date.Time                  `json:"nextRunTime,omitempty"`
	RunID                *string                     `json:"runId,omitempty"`
	State                ConnectorMappingStates      `json:"state,omitempty"`
	TenantID             *string                     `json:"tenantId,omitempty"`
}

// ConnectorMappingAvailability is connector mapping property availability.
type ConnectorMappingAvailability struct {
	Frequency FrequencyTypes `json:"frequency,omitempty"`
	Interval  *int32         `json:"interval,omitempty"`
}

// ConnectorMappingCompleteOperation is the complete operation.
type ConnectorMappingCompleteOperation struct {
	CompletionOperationType CompletionOperationTypes `json:"completionOperationType,omitempty"`
	DestinationFolder       *string                  `json:"destinationFolder,omitempty"`
}

// ConnectorMappingErrorManagement is the error mangement.
type ConnectorMappingErrorManagement struct {
	ErrorManagementType ErrorManagementTypes `json:"errorManagementType,omitempty"`
	ErrorLimit          *int32               `json:"errorLimit,omitempty"`
}

// ConnectorMappingFormat is connector mapping property format.
type ConnectorMappingFormat struct {
	FormatType           *string `json:"formatType,omitempty"`
	ColumnDelimiter      *string `json:"columnDelimiter,omitempty"`
	AcceptLanguage       *string `json:"acceptLanguage,omitempty"`
	QuoteCharacter       *string `json:"quoteCharacter,omitempty"`
	QuoteEscapeCharacter *string `json:"quoteEscapeCharacter,omitempty"`
	ArraySeparator       *string `json:"arraySeparator,omitempty"`
}

// ConnectorMappingListResult is the response of list connector mapping operation.
type ConnectorMappingListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ConnectorMappingResourceFormat `json:"value,omitempty"`
	NextLink          *string                           `json:"nextLink,omitempty"`
}

// ConnectorMappingListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ConnectorMappingListResult) ConnectorMappingListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ConnectorMappingProperties is the connector mapping properties.
type ConnectorMappingProperties struct {
	FolderPath        *string                            `json:"folderPath,omitempty"`
	FileFilter        *string                            `json:"fileFilter,omitempty"`
	HasHeader         *bool                              `json:"hasHeader,omitempty"`
	ErrorManagement   *ConnectorMappingErrorManagement   `json:"errorManagement,omitempty"`
	Format            *ConnectorMappingFormat            `json:"format,omitempty"`
	Availability      *ConnectorMappingAvailability      `json:"availability,omitempty"`
	Structure         *[]ConnectorMappingStructure       `json:"structure,omitempty"`
	CompleteOperation *ConnectorMappingCompleteOperation `json:"completeOperation,omitempty"`
}

// ConnectorMappingResourceFormat is the c onnector mapping resource format.
type ConnectorMappingResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*ConnectorMapping `json:"properties,omitempty"`
}

// ConnectorMappingStructure is connector mapping property structure.
type ConnectorMappingStructure struct {
	PropertyName          *string `json:"propertyName,omitempty"`
	ColumnName            *string `json:"columnName,omitempty"`
	CustomFormatSpecifier *string `json:"customFormatSpecifier,omitempty"`
	IsEncrypted           *bool   `json:"isEncrypted,omitempty"`
}

// ConnectorResourceFormat is the connector resource format.
type ConnectorResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*Connector        `json:"properties,omitempty"`
}

// CrmConnectorEntities is the CRM connector entities.
type CrmConnectorEntities struct {
	LogicalName *string `json:"logicalName,omitempty"`
	DisplayName *string `json:"displayName,omitempty"`
	IsProfile   *bool   `json:"isProfile,omitempty"`
}

// CrmConnectorProperties is the CRM connector properties.
type CrmConnectorProperties struct {
	ConnectionString *string                 `json:"connectionString,omitempty"`
	OrganizationID   *string                 `json:"organizationId,omitempty"`
	OrganizationURL  *string                 `json:"organizationUrl,omitempty"`
	Entities         *[]CrmConnectorEntities `json:"entities,omitempty"`
	AccessToken      *string                 `json:"accessToken,omitempty"`
}

// DataSource is data Source is a way for us to know the source of instances. A single type can have data coming in
// from multiple places. In activities we use this to determine precedence rules.
type DataSource struct {
	Name                  *string        `json:"name,omitempty"`
	DataSourceType        DataSourceType `json:"dataSourceType,omitempty"`
	Status                Status         `json:"status,omitempty"`
	ID                    *int32         `json:"id,omitempty"`
	DataSourceReferenceID *string        `json:"dataSourceReferenceId,omitempty"`
}

// DataSourcePrecedence is the data source precedence is a way to know the precedence of each data source.
type DataSourcePrecedence struct {
	*DataSource `json:"dataSource,omitempty"`
	Precedence  *int32 `json:"precedence,omitempty"`
}

// EnrichingKpi is the enriching KPI definition.
type EnrichingKpi struct {
	EntityType                  EntityTypes                       `json:"entityType,omitempty"`
	EntityTypeName              *string                           `json:"entityTypeName,omitempty"`
	TenantID                    *string                           `json:"tenantId,omitempty"`
	KpiName                     *string                           `json:"kpiName,omitempty"`
	DisplayName                 *map[string]*string               `json:"displayName,omitempty"`
	Description                 *map[string]*string               `json:"description,omitempty"`
	CalculationWindow           CalculationWindowTypes            `json:"calculationWindow,omitempty"`
	CalculationWindowFieldName  *string                           `json:"calculationWindowFieldName,omitempty"`
	Function                    KpiFunctions                      `json:"function,omitempty"`
	Expression                  *string                           `json:"expression,omitempty"`
	Unit                        *string                           `json:"unit,omitempty"`
	Filter                      *string                           `json:"filter,omitempty"`
	GroupBy                     *[]string                         `json:"groupBy,omitempty"`
	GroupByMetadata             *[]KpiGroupByMetadata             `json:"groupByMetadata,omitempty"`
	ParticipantProfilesMetadata *[]KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty"`
	ProvisioningState           ProvisioningStates                `json:"provisioningState,omitempty"`
	ThresHolds                  *KpiThresholds                    `json:"thresHolds,omitempty"`
	Aliases                     *[]KpiAlias                       `json:"aliases,omitempty"`
	Extracts                    *[]KpiExtract                     `json:"extracts,omitempty"`
}

// EntityTypeDefinition is describes an entity.
type EntityTypeDefinition struct {
	Attributes          *map[string][]string           `json:"attributes,omitempty"`
	Description         *map[string]*string            `json:"description,omitempty"`
	DisplayName         *map[string]*string            `json:"displayName,omitempty"`
	LocalizedAttributes *map[string]map[string]*string `json:"localizedAttributes,omitempty"`
	SmallImage          *string                        `json:"smallImage,omitempty"`
	MediumImage         *string                        `json:"mediumImage,omitempty"`
	LargeImage          *string                        `json:"largeImage,omitempty"`
	APIEntitySetName    *string                        `json:"apiEntitySetName,omitempty"`
	EntityType          EntityTypes                    `json:"entityType,omitempty"`
	Fields              *[]PropertyDefinition          `json:"fields,omitempty"`
	InstancesCount      *int32                         `json:"instancesCount,omitempty"`
	LastChangedUtc      *date.Time                     `json:"lastChangedUtc,omitempty"`
	ProvisioningState   ProvisioningStates             `json:"provisioningState,omitempty"`
	SchemaItemTypeLink  *string                        `json:"schemaItemTypeLink,omitempty"`
	TenantID            *string                        `json:"tenantId,omitempty"`
	TimestampFieldName  *string                        `json:"timestampFieldName,omitempty"`
	TypeName            *string                        `json:"typeName,omitempty"`
}

// GetImageUploadURLInput is input type for getting image upload url.
type GetImageUploadURLInput struct {
	EntityType     *string `json:"entityType,omitempty"`
	EntityTypeName *string `json:"entityTypeName,omitempty"`
	RelativePath   *string `json:"relativePath,omitempty"`
}

// Hub is hub resource.
type Hub struct {
	autorest.Response    `json:"-"`
	ID                   *string             `json:"id,omitempty"`
	Name                 *string             `json:"name,omitempty"`
	Type                 *string             `json:"type,omitempty"`
	Location             *string             `json:"location,omitempty"`
	Tags                 *map[string]*string `json:"tags,omitempty"`
	*HubPropertiesFormat `json:"properties,omitempty"`
}

// HubBillingInfoFormat is hub billing info.
type HubBillingInfoFormat struct {
	SkuName  *string `json:"skuName,omitempty"`
	MinUnits *int32  `json:"minUnits,omitempty"`
	MaxUnits *int32  `json:"maxUnits,omitempty"`
}

// HubListResult is response of list hub operation.
type HubListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Hub  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// HubListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client HubListResult) HubListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// HubPropertiesFormat is properties of hub.
type HubPropertiesFormat struct {
	APIEndpoint       *string               `json:"apiEndpoint,omitempty"`
	WebEndpoint       *string               `json:"webEndpoint,omitempty"`
	ProvisioningState *string               `json:"provisioningState,omitempty"`
	TenantFeatures    *int32                `json:"tenantFeatures,omitempty"`
	HubBillingInfo    *HubBillingInfoFormat `json:"hubBillingInfo,omitempty"`
}

// ImageDefinition is the image definition.
type ImageDefinition struct {
	autorest.Response `json:"-"`
	ImageExists       *bool   `json:"imageExists,omitempty"`
	ContentURL        *string `json:"contentUrl,omitempty"`
	RelativePath      *string `json:"relativePath,omitempty"`
}

// InteractionListResult is the response of list interaction operation.
type InteractionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]InteractionResourceFormat `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// InteractionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InteractionListResult) InteractionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InteractionResourceFormat is the interaction resource format.
type InteractionResourceFormat struct {
	autorest.Response          `json:"-"`
	ID                         *string `json:"id,omitempty"`
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*InteractionTypeDefinition `json:"properties,omitempty"`
}

// InteractionTypeDefinition is the Interaction Type Definition
type InteractionTypeDefinition struct {
	Attributes                            *map[string][]string           `json:"attributes,omitempty"`
	Description                           *map[string]*string            `json:"description,omitempty"`
	DisplayName                           *map[string]*string            `json:"displayName,omitempty"`
	LocalizedAttributes                   *map[string]map[string]*string `json:"localizedAttributes,omitempty"`
	SmallImage                            *string                        `json:"smallImage,omitempty"`
	MediumImage                           *string                        `json:"mediumImage,omitempty"`
	LargeImage                            *string                        `json:"largeImage,omitempty"`
	APIEntitySetName                      *string                        `json:"apiEntitySetName,omitempty"`
	EntityType                            EntityTypes                    `json:"entityType,omitempty"`
	Fields                                *[]PropertyDefinition          `json:"fields,omitempty"`
	InstancesCount                        *int32                         `json:"instancesCount,omitempty"`
	LastChangedUtc                        *date.Time                     `json:"lastChangedUtc,omitempty"`
	ProvisioningState                     ProvisioningStates             `json:"provisioningState,omitempty"`
	SchemaItemTypeLink                    *string                        `json:"schemaItemTypeLink,omitempty"`
	TenantID                              *string                        `json:"tenantId,omitempty"`
	TimestampFieldName                    *string                        `json:"timestampFieldName,omitempty"`
	TypeName                              *string                        `json:"typeName,omitempty"`
	IDPropertyNames                       *[]string                      `json:"idPropertyNames,omitempty"`
	ParticipantProfiles                   *[]Participant                 `json:"participantProfiles,omitempty"`
	PrimaryParticipantProfilePropertyName *string                        `json:"primaryParticipantProfilePropertyName,omitempty"`
	DataSourcePrecedenceRules             *[]DataSourcePrecedence        `json:"dataSourcePrecedenceRules,omitempty"`
	*DataSource                           `json:"defaultDataSource,omitempty"`
	IsActivity                            *bool `json:"isActivity,omitempty"`
}

// KpiAlias is the KPI alias.
type KpiAlias struct {
	AliasName  *string `json:"aliasName,omitempty"`
	Expression *string `json:"expression,omitempty"`
}

// KpiDefinition is defines the KPI Threshold limits.
type KpiDefinition struct {
	EntityType                  EntityTypes                       `json:"entityType,omitempty"`
	EntityTypeName              *string                           `json:"entityTypeName,omitempty"`
	TenantID                    *string                           `json:"tenantId,omitempty"`
	KpiName                     *string                           `json:"kpiName,omitempty"`
	DisplayName                 *map[string]*string               `json:"displayName,omitempty"`
	Description                 *map[string]*string               `json:"description,omitempty"`
	CalculationWindow           CalculationWindowTypes            `json:"calculationWindow,omitempty"`
	CalculationWindowFieldName  *string                           `json:"calculationWindowFieldName,omitempty"`
	Function                    KpiFunctions                      `json:"function,omitempty"`
	Expression                  *string                           `json:"expression,omitempty"`
	Unit                        *string                           `json:"unit,omitempty"`
	Filter                      *string                           `json:"filter,omitempty"`
	GroupBy                     *[]string                         `json:"groupBy,omitempty"`
	GroupByMetadata             *[]KpiGroupByMetadata             `json:"groupByMetadata,omitempty"`
	ParticipantProfilesMetadata *[]KpiParticipantProfilesMetadata `json:"participantProfilesMetadata,omitempty"`
	ProvisioningState           ProvisioningStates                `json:"provisioningState,omitempty"`
	ThresHolds                  *KpiThresholds                    `json:"thresHolds,omitempty"`
	Aliases                     *[]KpiAlias                       `json:"aliases,omitempty"`
	Extracts                    *[]KpiExtract                     `json:"extracts,omitempty"`
}

// KpiExtract is the KPI extract.
type KpiExtract struct {
	ExtractName *string `json:"extractName,omitempty"`
	Expression  *string `json:"expression,omitempty"`
}

// KpiGroupByMetadata is the KPI GroupBy field metadata.
type KpiGroupByMetadata struct {
	DisplayName *map[string]*string `json:"displayName,omitempty"`
	FieldName   *string             `json:"fieldName,omitempty"`
	FieldType   *string             `json:"fieldType,omitempty"`
}

// KpiListResult is the response of list KPI operation.
type KpiListResult struct {
	autorest.Response `json:"-"`
	Value             *[]KpiResourceFormat `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// KpiListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client KpiListResult) KpiListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// KpiParticipantProfilesMetadata is the KPI participant profile metadata.
type KpiParticipantProfilesMetadata struct {
	TypeName *string `json:"typeName,omitempty"`
}

// KpiResourceFormat is the KPI resource format.
type KpiResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*KpiDefinition    `json:"properties,omitempty"`
}

// KpiThresholds is defines the KPI Threshold limits.
type KpiThresholds struct {
	LowerLimit    *decimal.Decimal `json:"lowerLimit,omitempty"`
	UpperLimit    *decimal.Decimal `json:"upperLimit,omitempty"`
	IncreasingKpi *bool            `json:"increasingKpi,omitempty"`
}

// LinkDefinition is the definition of Link.
type LinkDefinition struct {
	TenantID                      *string                         `json:"tenantId,omitempty"`
	LinkName                      *string                         `json:"linkName,omitempty"`
	SourceEntityType              EntityType                      `json:"sourceEntityType,omitempty"`
	TargetEntityType              EntityType                      `json:"targetEntityType,omitempty"`
	SourceEntityTypeName          *string                         `json:"sourceEntityTypeName,omitempty"`
	TargetEntityTypeName          *string                         `json:"targetEntityTypeName,omitempty"`
	DisplayName                   *map[string]*string             `json:"displayName,omitempty"`
	Description                   *map[string]*string             `json:"description,omitempty"`
	Mappings                      *[]TypePropertiesMapping        `json:"mappings,omitempty"`
	ParticipantPropertyReferences *[]ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`
	ProvisioningState             ProvisioningStates              `json:"provisioningState,omitempty"`
	ReferenceOnly                 *bool                           `json:"referenceOnly,omitempty"`
	OperationType                 InstanceOperationType           `json:"operationType,omitempty"`
}

// LinkListResult is the response of list link operation.
type LinkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]LinkResourceFormat `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// LinkListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client LinkListResult) LinkListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LinkResourceFormat is the link resource format.
type LinkResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*LinkDefinition   `json:"properties,omitempty"`
}

// ListKpiDefinition is
type ListKpiDefinition struct {
	autorest.Response `json:"-"`
	Value             *[]KpiDefinition `json:"value,omitempty"`
}

// MetadataDefinitionBase is the Metadata definition base.
type MetadataDefinitionBase struct {
	Attributes          *map[string][]string           `json:"attributes,omitempty"`
	Description         *map[string]*string            `json:"description,omitempty"`
	DisplayName         *map[string]*string            `json:"displayName,omitempty"`
	LocalizedAttributes *map[string]map[string]*string `json:"localizedAttributes,omitempty"`
	SmallImage          *string                        `json:"smallImage,omitempty"`
	MediumImage         *string                        `json:"mediumImage,omitempty"`
	LargeImage          *string                        `json:"largeImage,omitempty"`
}

// Participant is describes a profile type participating in an interaction.
type Participant struct {
	ProfileTypeName               *string                         `json:"profileTypeName,omitempty"`
	ParticipantPropertyReferences *[]ParticipantPropertyReference `json:"participantPropertyReferences,omitempty"`
	ParticipantName               *string                         `json:"participantName,omitempty"`
	DisplayName                   *map[string]*string             `json:"displayName,omitempty"`
	Description                   *map[string]*string             `json:"description,omitempty"`
	Role                          *string                         `json:"role,omitempty"`
}

// ParticipantProfilePropertyReference is the participant profile property reference.
type ParticipantProfilePropertyReference struct {
	InteractionPropertyName *string `json:"interactionPropertyName,omitempty"`
	ProfilePropertyName     *string `json:"profilePropertyName,omitempty"`
}

// ParticipantPropertyReference is the participant property reference.
type ParticipantPropertyReference struct {
	SourcePropertyName *string `json:"sourcePropertyName,omitempty"`
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
}

// Prediction is the prediction definition.
type Prediction struct {
	Description               *map[string]*string                `json:"description,omitempty"`
	DisplayName               *map[string]*string                `json:"displayName,omitempty"`
	InvolvedInteractionTypes  *[]string                          `json:"involvedInteractionTypes,omitempty"`
	InvolvedKpiTypes          *[]string                          `json:"involvedKpiTypes,omitempty"`
	InvolvedRelationships     *[]string                          `json:"involvedRelationships,omitempty"`
	NegativeOutcomeExpression *string                            `json:"negativeOutcomeExpression,omitempty"`
	PositiveOutcomeExpression *string                            `json:"positiveOutcomeExpression,omitempty"`
	PrimaryProfileType        *string                            `json:"primaryProfileType,omitempty"`
	ProvisioningState         ProvisioningStates                 `json:"provisioningState,omitempty"`
	PredictionName            *string                            `json:"predictionName,omitempty"`
	ScopeExpression           *string                            `json:"scopeExpression,omitempty"`
	TenantID                  *string                            `json:"tenantId,omitempty"`
	AutoAnalyze               *bool                              `json:"autoAnalyze,omitempty"`
	Mappings                  *PredictionMappings                `json:"mappings,omitempty"`
	ScoreLabel                *string                            `json:"scoreLabel,omitempty"`
	Grades                    *[]PredictionGradesItem            `json:"grades,omitempty"`
	SystemGeneratedEntities   *PredictionSystemGeneratedEntities `json:"systemGeneratedEntities,omitempty"`
}

// PredictionDistributionDefinition is the definition of the prediction distribution.
type PredictionDistributionDefinition struct {
	TotalPositives *int64                                               `json:"totalPositives,omitempty"`
	TotalNegatives *int64                                               `json:"totalNegatives,omitempty"`
	Distributions  *[]PredictionDistributionDefinitionDistributionsItem `json:"distributions,omitempty"`
}

// PredictionDistributionDefinitionDistributionsItem is the definition of a prediction distribution.
type PredictionDistributionDefinitionDistributionsItem struct {
	ScoreThreshold          *int32 `json:"scoreThreshold,omitempty"`
	Positives               *int64 `json:"positives,omitempty"`
	Negatives               *int64 `json:"negatives,omitempty"`
	PositivesAboveThreshold *int64 `json:"positivesAboveThreshold,omitempty"`
	NegativesAboveThreshold *int64 `json:"negativesAboveThreshold,omitempty"`
}

// PredictionGradesItem is the definition of a prediction grade.
type PredictionGradesItem struct {
	GradeName         *string `json:"gradeName,omitempty"`
	MinScoreThreshold *int32  `json:"minScoreThreshold,omitempty"`
	MaxScoreThreshold *int32  `json:"maxScoreThreshold,omitempty"`
}

// PredictionListResult is the response of list predictions operation.
type PredictionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]PredictionResourceFormat `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// PredictionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client PredictionListResult) PredictionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PredictionMappings is definition of the link mapping of prediction.
type PredictionMappings struct {
	Score  *string `json:"score,omitempty"`
	Grade  *string `json:"grade,omitempty"`
	Reason *string `json:"reason,omitempty"`
}

// PredictionModelStatus is the prediction model status.
type PredictionModelStatus struct {
	autorest.Response  `json:"-"`
	TenantID           *string                  `json:"tenantId,omitempty"`
	PredictionName     *string                  `json:"predictionName,omitempty"`
	PredictionGUIDID   *string                  `json:"predictionGuidId,omitempty"`
	Status             PredictionModelLifeCycle `json:"status,omitempty"`
	Message            *string                  `json:"message,omitempty"`
	TrainingSetCount   *int32                   `json:"trainingSetCount,omitempty"`
	TestSetCount       *int32                   `json:"testSetCount,omitempty"`
	ValidationSetCount *int32                   `json:"validationSetCount,omitempty"`
	TrainingAccuracy   *int32                   `json:"trainingAccuracy,omitempty"`
	SignalsUsed        *int32                   `json:"signalsUsed,omitempty"`
	ModelVersion       *string                  `json:"modelVersion,omitempty"`
}

// PredictionResourceFormat is the prediction resource format.
type PredictionResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*Prediction       `json:"properties,omitempty"`
}

// PredictionSystemGeneratedEntities is system generated entities.
type PredictionSystemGeneratedEntities struct {
	GeneratedInteractionTypes *[]string           `json:"generatedInteractionTypes,omitempty"`
	GeneratedLinks            *[]string           `json:"generatedLinks,omitempty"`
	GeneratedKpis             *map[string]*string `json:"generatedKpis,omitempty"`
}

// PredictionTrainingResults is the training results of the prediction.
type PredictionTrainingResults struct {
	autorest.Response           `json:"-"`
	TenantID                    *string                           `json:"tenantId,omitempty"`
	ScoreName                   *string                           `json:"scoreName,omitempty"`
	PredictionDistribution      *PredictionDistributionDefinition `json:"predictionDistribution,omitempty"`
	CanonicalProfiles           *[]CanonicalProfileDefinition     `json:"canonicalProfiles,omitempty"`
	PrimaryProfileInstanceCount *int64                            `json:"primaryProfileInstanceCount,omitempty"`
}

// ProfileEnumValidValuesFormat is valid enum values in case of an enum property.
type ProfileEnumValidValuesFormat struct {
	Value               *int32              `json:"value,omitempty"`
	LocalizedValueNames *map[string]*string `json:"localizedValueNames,omitempty"`
}

// ProfileListResult is the response of list profile operation.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ProfileResourceFormat `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// ProfileListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ProfileListResult) ProfileListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ProfileResourceFormat is the profile resource format.
type ProfileResourceFormat struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	Name                   *string `json:"name,omitempty"`
	Type                   *string `json:"type,omitempty"`
	*ProfileTypeDefinition `json:"properties,omitempty"`
}

// ProfileTypeDefinition is the profile type definition.
type ProfileTypeDefinition struct {
	Attributes          *map[string][]string           `json:"attributes,omitempty"`
	Description         *map[string]*string            `json:"description,omitempty"`
	DisplayName         *map[string]*string            `json:"displayName,omitempty"`
	LocalizedAttributes *map[string]map[string]*string `json:"localizedAttributes,omitempty"`
	SmallImage          *string                        `json:"smallImage,omitempty"`
	MediumImage         *string                        `json:"mediumImage,omitempty"`
	LargeImage          *string                        `json:"largeImage,omitempty"`
	APIEntitySetName    *string                        `json:"apiEntitySetName,omitempty"`
	EntityType          EntityTypes                    `json:"entityType,omitempty"`
	Fields              *[]PropertyDefinition          `json:"fields,omitempty"`
	InstancesCount      *int32                         `json:"instancesCount,omitempty"`
	LastChangedUtc      *date.Time                     `json:"lastChangedUtc,omitempty"`
	ProvisioningState   ProvisioningStates             `json:"provisioningState,omitempty"`
	SchemaItemTypeLink  *string                        `json:"schemaItemTypeLink,omitempty"`
	TenantID            *string                        `json:"tenantId,omitempty"`
	TimestampFieldName  *string                        `json:"timestampFieldName,omitempty"`
	TypeName            *string                        `json:"typeName,omitempty"`
	StrongIds           *[]StrongID                    `json:"strongIds,omitempty"`
}

// PropertyDefinition is property definition.
type PropertyDefinition struct {
	ArrayValueSeparator       *string                         `json:"arrayValueSeparator,omitempty"`
	EnumValidValues           *[]ProfileEnumValidValuesFormat `json:"enumValidValues,omitempty"`
	FieldName                 *string                         `json:"fieldName,omitempty"`
	FieldType                 *string                         `json:"fieldType,omitempty"`
	IsArray                   *bool                           `json:"isArray,omitempty"`
	IsEnum                    *bool                           `json:"isEnum,omitempty"`
	IsFlagEnum                *bool                           `json:"isFlagEnum,omitempty"`
	IsImage                   *bool                           `json:"isImage,omitempty"`
	IsLocalizedString         *bool                           `json:"isLocalizedString,omitempty"`
	IsName                    *bool                           `json:"isName,omitempty"`
	IsRequired                *bool                           `json:"isRequired,omitempty"`
	PropertyID                *string                         `json:"propertyId,omitempty"`
	SchemaItemPropLink        *string                         `json:"schemaItemPropLink,omitempty"`
	MaxLength                 *int32                          `json:"maxLength,omitempty"`
	IsAvailableInGraph        *bool                           `json:"isAvailableInGraph,omitempty"`
	DataSourcePrecedenceRules *[]DataSourcePrecedence         `json:"dataSourcePrecedenceRules,omitempty"`
}

// ProxyResource is common properties of proxy resource.
type ProxyResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// RelationshipDefinition is the definition of Relationship.
type RelationshipDefinition struct {
	Cardinality        CardinalityTypes           `json:"cardinality,omitempty"`
	DisplayName        *map[string]*string        `json:"displayName,omitempty"`
	Description        *map[string]*string        `json:"description,omitempty"`
	ExpiryDateTimeUtc  *date.Time                 `json:"expiryDateTimeUtc,omitempty"`
	Fields             *[]PropertyDefinition      `json:"fields,omitempty"`
	LookupMappings     *[]RelationshipTypeMapping `json:"lookupMappings,omitempty"`
	ProfileType        *string                    `json:"profileType,omitempty"`
	ProvisioningState  ProvisioningStates         `json:"provisioningState,omitempty"`
	RelationshipName   *string                    `json:"relationshipName,omitempty"`
	RelatedProfileType *string                    `json:"relatedProfileType,omitempty"`
	RelationshipGUIDID *string                    `json:"relationshipGuidId,omitempty"`
	TenantID           *string                    `json:"tenantId,omitempty"`
}

// RelationshipLinkDefinition is the definition of relationship link.
type RelationshipLinkDefinition struct {
	DisplayName                      *map[string]*string                    `json:"displayName,omitempty"`
	Description                      *map[string]*string                    `json:"description,omitempty"`
	InteractionType                  *string                                `json:"interactionType,omitempty"`
	LinkName                         *string                                `json:"linkName,omitempty"`
	Mappings                         *[]RelationshipLinkFieldMapping        `json:"mappings,omitempty"`
	ProfilePropertyReferences        *[]ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty"`
	ProvisioningState                ProvisioningStates                     `json:"provisioningState,omitempty"`
	RelatedProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty"`
	RelationshipName                 *string                                `json:"relationshipName,omitempty"`
	RelationshipGUIDID               *string                                `json:"relationshipGuidId,omitempty"`
	TenantID                         *string                                `json:"tenantId,omitempty"`
}

// RelationshipLinkFieldMapping is the fields mapping for Relationships.
type RelationshipLinkFieldMapping struct {
	InteractionFieldName  *string   `json:"interactionFieldName,omitempty"`
	LinkType              LinkTypes `json:"linkType,omitempty"`
	RelationshipFieldName *string   `json:"relationshipFieldName,omitempty"`
}

// RelationshipLinkListResult is the response of list relationship link operation.
type RelationshipLinkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RelationshipLinkResourceFormat `json:"value,omitempty"`
	NextLink          *string                           `json:"nextLink,omitempty"`
}

// RelationshipLinkListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RelationshipLinkListResult) RelationshipLinkListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RelationshipLinkResourceFormat is the relationship link resource format.
type RelationshipLinkResourceFormat struct {
	autorest.Response           `json:"-"`
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*RelationshipLinkDefinition `json:"properties,omitempty"`
}

// RelationshipListResult is the response of list relationship operation.
type RelationshipListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RelationshipResourceFormat `json:"value,omitempty"`
	NextLink          *string                       `json:"nextLink,omitempty"`
}

// RelationshipListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RelationshipListResult) RelationshipListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RelationshipResourceFormat is the relationship resource format.
type RelationshipResourceFormat struct {
	autorest.Response       `json:"-"`
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*RelationshipDefinition `json:"properties,omitempty"`
}

// RelationshipsLookup is the definition of suggested relationship for the type.
type RelationshipsLookup struct {
	ProfileName                      *string                                `json:"profileName,omitempty"`
	ProfilePropertyReferences        *[]ParticipantProfilePropertyReference `json:"profilePropertyReferences,omitempty"`
	RelatedProfileName               *string                                `json:"relatedProfileName,omitempty"`
	RelatedProfilePropertyReferences *[]ParticipantProfilePropertyReference `json:"relatedProfilePropertyReferences,omitempty"`
	ExistingRelationshipName         *string                                `json:"existingRelationshipName,omitempty"`
}

// RelationshipTypeFieldMapping is map a field of profile to its corresponding StrongId in Related Profile.
type RelationshipTypeFieldMapping struct {
	ProfileFieldName          *string `json:"profileFieldName,omitempty"`
	RelatedProfileKeyProperty *string `json:"relatedProfileKeyProperty,omitempty"`
}

// RelationshipTypeMapping is maps fields in Profile to their corresponding StrongIds in Related Profile.
type RelationshipTypeMapping struct {
	FieldMappings *[]RelationshipTypeFieldMapping `json:"fieldMappings,omitempty"`
}

// Resource is common properties of Azure resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceSetDescription is the resource set description.
type ResourceSetDescription struct {
	Elements   *[]string `json:"elements,omitempty"`
	Exceptions *[]string `json:"exceptions,omitempty"`
}

// Role is the Role definition.
type Role struct {
	RoleName    *string `json:"roleName,omitempty"`
	Description *string `json:"description,omitempty"`
}

// RoleAssignment is the Role Assignment definition.
type RoleAssignment struct {
	TenantID           *string                 `json:"tenantId,omitempty"`
	AssignmentName     *string                 `json:"assignmentName,omitempty"`
	DisplayName        *map[string]*string     `json:"displayName,omitempty"`
	Description        *map[string]*string     `json:"description,omitempty"`
	ProvisioningState  ProvisioningStates      `json:"provisioningState,omitempty"`
	Role               RoleTypes               `json:"role,omitempty"`
	Principals         *[]AssignmentPrincipal  `json:"principals,omitempty"`
	Profiles           *ResourceSetDescription `json:"profiles,omitempty"`
	Interactions       *ResourceSetDescription `json:"interactions,omitempty"`
	Links              *ResourceSetDescription `json:"links,omitempty"`
	Kpis               *ResourceSetDescription `json:"kpis,omitempty"`
	SasPolicies        *ResourceSetDescription `json:"sasPolicies,omitempty"`
	Connectors         *ResourceSetDescription `json:"connectors,omitempty"`
	Views              *ResourceSetDescription `json:"views,omitempty"`
	RelationshipLinks  *ResourceSetDescription `json:"relationshipLinks,omitempty"`
	Relationships      *ResourceSetDescription `json:"relationships,omitempty"`
	WidgetTypes        *ResourceSetDescription `json:"widgetTypes,omitempty"`
	RoleAssignments    *ResourceSetDescription `json:"roleAssignments,omitempty"`
	ConflationPolicies *ResourceSetDescription `json:"conflationPolicies,omitempty"`
	Segments           *ResourceSetDescription `json:"segments,omitempty"`
}

// RoleAssignmentListResult is the response of list role assignment operation.
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RoleAssignmentResourceFormat `json:"value,omitempty"`
	NextLink          *string                         `json:"nextLink,omitempty"`
}

// RoleAssignmentListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RoleAssignmentListResult) RoleAssignmentListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RoleAssignmentResourceFormat is the Role Assignment resource format.
type RoleAssignmentResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*RoleAssignment   `json:"properties,omitempty"`
}

// RoleListResult is the response of list role assignment operation.
type RoleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RoleResourceFormat `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// RoleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RoleListResult) RoleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RoleResourceFormat is the role resource format.
type RoleResourceFormat struct {
	ID    *string `json:"id,omitempty"`
	Name  *string `json:"name,omitempty"`
	Type  *string `json:"type,omitempty"`
	*Role `json:"properties,omitempty"`
}

// SalesforceConnectorProperties is the Salesforce connector properties.
type SalesforceConnectorProperties struct {
	Usersetting      *SalesforceDiscoverSetting `json:"usersetting,omitempty"`
	Salesforcetables *[]SalesforceTable         `json:"salesforcetables,omitempty"`
}

// SalesforceDiscoverSetting is salesforce discover setting.
type SalesforceDiscoverSetting struct {
	SalesforceConnectionStringSecretURL *string `json:"salesforceConnectionStringSecretUrl,omitempty"`
}

// SalesforceTable is salesforce table.
type SalesforceTable struct {
	IsProfile     *string `json:"isProfile,omitempty"`
	TableCategory *string `json:"tableCategory,omitempty"`
	TableName     *string `json:"tableName,omitempty"`
	TableRemarks  *string `json:"tableRemarks,omitempty"`
	TableSchema   *string `json:"tableSchema,omitempty"`
}

// StrongID is property/Properties which represent a unique ID.
type StrongID struct {
	KeyPropertyNames *[]string           `json:"keyPropertyNames,omitempty"`
	StrongIDName     *string             `json:"strongIdName,omitempty"`
	DisplayName      *map[string]*string `json:"displayName,omitempty"`
	Description      *map[string]*string `json:"description,omitempty"`
}

// SuggestRelationshipLinksResponse is the response of suggest relationship links operation.
type SuggestRelationshipLinksResponse struct {
	autorest.Response      `json:"-"`
	InteractionName        *string                `json:"interactionName,omitempty"`
	SuggestedRelationships *[]RelationshipsLookup `json:"suggestedRelationships,omitempty"`
}

// TypePropertiesMapping is metadata for a Link's property mapping.
type TypePropertiesMapping struct {
	SourcePropertyName *string   `json:"sourcePropertyName,omitempty"`
	TargetPropertyName *string   `json:"targetPropertyName,omitempty"`
	LinkType           LinkTypes `json:"linkType,omitempty"`
}

// View is the view in Customer 360 web application.
type View struct {
	ViewName    *string             `json:"viewName,omitempty"`
	UserID      *string             `json:"userId,omitempty"`
	TenantID    *string             `json:"tenantId,omitempty"`
	DisplayName *map[string]*string `json:"displayName,omitempty"`
	Definition  *string             `json:"definition,omitempty"`
	Changed     *date.Time          `json:"changed,omitempty"`
	Created     *date.Time          `json:"created,omitempty"`
}

// ViewListResult is the response of list view operation.
type ViewListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ViewResourceFormat `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// ViewListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ViewListResult) ViewListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ViewResourceFormat is the view resource format.
type ViewResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*View             `json:"properties,omitempty"`
}

// WidgetType is definition of WidgetType.
type WidgetType struct {
	WidgetTypeName *string             `json:"widgetTypeName,omitempty"`
	Definition     *string             `json:"definition,omitempty"`
	Description    *string             `json:"description,omitempty"`
	DisplayName    *map[string]*string `json:"displayName,omitempty"`
	ImageURL       *string             `json:"imageUrl,omitempty"`
	TenantID       *string             `json:"tenantId,omitempty"`
	WidgetVersion  *string             `json:"widgetVersion,omitempty"`
	Changed        *date.Time          `json:"changed,omitempty"`
	Created        *date.Time          `json:"created,omitempty"`
}

// WidgetTypeListResult is the response of list widget type operation.
type WidgetTypeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]WidgetTypeResourceFormat `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// WidgetTypeListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WidgetTypeListResult) WidgetTypeListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WidgetTypeResourceFormat is the WidgetTypeResourceFormat
type WidgetTypeResourceFormat struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*WidgetType       `json:"properties,omitempty"`
}
