package containerinstance

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ContainerGroupNetworkProtocol enumerates the values for container group network protocol.
type ContainerGroupNetworkProtocol string

const (
	// TCP specifies the tcp state for container group network protocol.
	TCP ContainerGroupNetworkProtocol = "TCP"
	// UDP specifies the udp state for container group network protocol.
	UDP ContainerGroupNetworkProtocol = "UDP"
)

// ContainerRestartPolicy enumerates the values for container restart policy.
type ContainerRestartPolicy string

const (
	// Always specifies the always state for container restart policy.
	Always ContainerRestartPolicy = "always"
)

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux specifies the linux state for operating system types.
	Linux OperatingSystemTypes = "Linux"
	// Windows specifies the windows state for operating system types.
	Windows OperatingSystemTypes = "Windows"
)

// AzureFileVolume is the properties of the Azure File volume. Azure File shares are mounted as volumes.
type AzureFileVolume struct {
	ShareName          *string `json:"shareName,omitempty"`
	ReadOnly           *bool   `json:"readOnly,omitempty"`
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	StorageAccountKey  *string `json:"storageAccountKey,omitempty"`
}

// Container is a container instance.
type Container struct {
	Name                 *string `json:"name,omitempty"`
	*ContainerProperties `json:"properties,omitempty"`
}

// ContainerEvent is a container instance event.
type ContainerEvent struct {
	Count          *int32     `json:"count,omitempty"`
	FirstTimestamp *date.Time `json:"firstTimestamp,omitempty"`
	LastTimestamp  *date.Time `json:"lastTimestamp,omitempty"`
	Message        *string    `json:"message,omitempty"`
	Type           *string    `json:"type,omitempty"`
}

// ContainerGroup is a container group.
type ContainerGroup struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	*ContainerGroupProperties `json:"properties,omitempty"`
}

// ContainerGroupListResult is the container group list response that contains the container group properties.
type ContainerGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ContainerGroup `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ContainerGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ContainerGroupListResult) ContainerGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ContainerGroupProperties is
type ContainerGroupProperties struct {
	ProvisioningState        *string                    `json:"provisioningState,omitempty"`
	Containers               *[]Container               `json:"containers,omitempty"`
	ImageRegistryCredentials *[]ImageRegistryCredential `json:"imageRegistryCredentials,omitempty"`
	RestartPolicy            ContainerRestartPolicy     `json:"restartPolicy,omitempty"`
	IPAddress                *IPAddress                 `json:"ipAddress,omitempty"`
	OsType                   OperatingSystemTypes       `json:"osType,omitempty"`
	State                    *string                    `json:"state,omitempty"`
	Volumes                  *[]Volume                  `json:"volumes,omitempty"`
}

// ContainerPort is the port exposed on the container instance.
type ContainerPort struct {
	Port *int32 `json:"port,omitempty"`
}

// ContainerProperties is the container instance properties.
type ContainerProperties struct {
	Image                *string                          `json:"image,omitempty"`
	Command              *[]string                        `json:"command,omitempty"`
	Ports                *[]ContainerPort                 `json:"ports,omitempty"`
	EnvironmentVariables *[]EnvironmentVariable           `json:"environmentVariables,omitempty"`
	InstanceView         *ContainerPropertiesInstanceView `json:"instanceView,omitempty"`
	Resources            *ResourceRequirements            `json:"resources,omitempty"`
	VolumeMounts         *[]VolumeMount                   `json:"volumeMounts,omitempty"`
}

// ContainerPropertiesInstanceView is the instance view of the container instance. Only valid in response.
type ContainerPropertiesInstanceView struct {
	RestartCount  *int32            `json:"restartCount,omitempty"`
	CurrentState  *ContainerState   `json:"currentState,omitempty"`
	PreviousState *ContainerState   `json:"previousState,omitempty"`
	Events        *[]ContainerEvent `json:"events,omitempty"`
}

// ContainerState is the container instance state.
type ContainerState struct {
	State        *string    `json:"state,omitempty"`
	StartTime    *date.Time `json:"startTime,omitempty"`
	ExitCode     *int32     `json:"exitCode,omitempty"`
	FinishTime   *date.Time `json:"finishTime,omitempty"`
	DetailStatus *string    `json:"detailStatus,omitempty"`
}

// EnvironmentVariable is the environment variable to set within the container instance.
type EnvironmentVariable struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ImageRegistryCredential is image registry credential.
type ImageRegistryCredential struct {
	Server   *string `json:"server,omitempty"`
	Username *string `json:"username,omitempty"`
	Password *string `json:"password,omitempty"`
}

// IPAddress is IP address for the container group.
type IPAddress struct {
	Ports *[]Port `json:"ports,omitempty"`
	Type  *string `json:"type,omitempty"`
	IP    *string `json:"ip,omitempty"`
}

// Logs is the logs.
type Logs struct {
	autorest.Response `json:"-"`
	Content           *string `json:"content,omitempty"`
}

// Port is the port exposed on the container group.
type Port struct {
	Protocol ContainerGroupNetworkProtocol `json:"protocol,omitempty"`
	Port     *int32                        `json:"port,omitempty"`
}

// Resource is the Resource model definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceLimits is the resource limits.
type ResourceLimits struct {
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	CPU        *float64 `json:"cpu,omitempty"`
}

// ResourceRequests is the resource requests.
type ResourceRequests struct {
	MemoryInGB *float64 `json:"memoryInGB,omitempty"`
	CPU        *float64 `json:"cpu,omitempty"`
}

// ResourceRequirements is the resource requirements.
type ResourceRequirements struct {
	Requests *ResourceRequests `json:"requests,omitempty"`
	Limits   *ResourceLimits   `json:"limits,omitempty"`
}

// Volume is the properties of the volume.
type Volume struct {
	Name      *string          `json:"name,omitempty"`
	AzureFile *AzureFileVolume `json:"azureFile,omitempty"`
}

// VolumeMount is the properties of the volume mount.
type VolumeMount struct {
	Name      *string `json:"name,omitempty"`
	MountPath *string `json:"mountPath,omitempty"`
	ReadOnly  *bool   `json:"readOnly,omitempty"`
}
