package batch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccountKeyType enumerates the values for account key type.
type AccountKeyType string

const (
	// Primary specifies the primary state for account key type.
	Primary AccountKeyType = "Primary"
	// Secondary specifies the secondary state for account key type.
	Secondary AccountKeyType = "Secondary"
)

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists specifies the already exists state for name availability reason.
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid specifies the invalid state for name availability reason.
	Invalid NameAvailabilityReason = "Invalid"
)

// PackageState enumerates the values for package state.
type PackageState string

const (
	// Active specifies the active state for package state.
	Active PackageState = "active"
	// Pending specifies the pending state for package state.
	Pending PackageState = "pending"
	// Unmapped specifies the unmapped state for package state.
	Unmapped PackageState = "unmapped"
)

// PoolAllocationMode enumerates the values for pool allocation mode.
type PoolAllocationMode string

const (
	// BatchService specifies the batch service state for pool allocation mode.
	BatchService PoolAllocationMode = "BatchService"
	// UserSubscription specifies the user subscription state for pool allocation mode.
	UserSubscription PoolAllocationMode = "UserSubscription"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCancelled specifies the provisioning state cancelled state for provisioning state.
	ProvisioningStateCancelled ProvisioningState = "Cancelled"
	// ProvisioningStateCreating specifies the provisioning state creating state for provisioning state.
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting specifies the provisioning state deleting state for provisioning state.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed specifies the provisioning state failed state for provisioning state.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInvalid specifies the provisioning state invalid state for provisioning state.
	ProvisioningStateInvalid ProvisioningState = "Invalid"
	// ProvisioningStateSucceeded specifies the provisioning state succeeded state for provisioning state.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// Account is contains information about an Azure Batch account.
type Account struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*AccountProperties `json:"properties,omitempty"`
}

// AccountCreateParameters is parameters supplied to the Create operation.
type AccountCreateParameters struct {
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
	*AccountCreateProperties `json:"properties,omitempty"`
}

// AccountCreateProperties is the properties of a Batch account.
type AccountCreateProperties struct {
	AutoStorage        *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
	PoolAllocationMode PoolAllocationMode         `json:"poolAllocationMode,omitempty"`
	KeyVaultReference  *KeyVaultReference         `json:"keyVaultReference,omitempty"`
}

// AccountKeys is a set of Azure Batch account keys.
type AccountKeys struct {
	autorest.Response `json:"-"`
	AccountName       *string `json:"accountName,omitempty"`
	Primary           *string `json:"primary,omitempty"`
	Secondary         *string `json:"secondary,omitempty"`
}

// AccountListResult is values returned by the List operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Account `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// AccountListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AccountListResult) AccountListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AccountProperties is account specific properties.
type AccountProperties struct {
	AccountEndpoint              *string                `json:"accountEndpoint,omitempty"`
	ProvisioningState            ProvisioningState      `json:"provisioningState,omitempty"`
	PoolAllocationMode           PoolAllocationMode     `json:"poolAllocationMode,omitempty"`
	KeyVaultReference            *KeyVaultReference     `json:"keyVaultReference,omitempty"`
	AutoStorage                  *AutoStorageProperties `json:"autoStorage,omitempty"`
	DedicatedCoreQuota           *int32                 `json:"dedicatedCoreQuota,omitempty"`
	LowPriorityCoreQuota         *int32                 `json:"lowPriorityCoreQuota,omitempty"`
	PoolQuota                    *int32                 `json:"poolQuota,omitempty"`
	ActiveJobAndJobScheduleQuota *int32                 `json:"activeJobAndJobScheduleQuota,omitempty"`
}

// AccountRegenerateKeyParameters is parameters supplied to the RegenerateKey operation.
type AccountRegenerateKeyParameters struct {
	KeyName AccountKeyType `json:"keyName,omitempty"`
}

// AccountUpdateParameters is parameters for updating an Azure Batch account.
type AccountUpdateParameters struct {
	Tags                     *map[string]*string `json:"tags,omitempty"`
	*AccountUpdateProperties `json:"properties,omitempty"`
}

// AccountUpdateProperties is the properties of a Batch account.
type AccountUpdateProperties struct {
	AutoStorage *AutoStorageBaseProperties `json:"autoStorage,omitempty"`
}

// ActivateApplicationPackageParameters is parameters for an activating an application package.
type ActivateApplicationPackageParameters struct {
	Format *string `json:"format,omitempty"`
}

// Application is contains information about an application in a Batch account.
type Application struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	DisplayName       *string               `json:"displayName,omitempty"`
	Packages          *[]ApplicationPackage `json:"packages,omitempty"`
	AllowUpdates      *bool                 `json:"allowUpdates,omitempty"`
	DefaultVersion    *string               `json:"defaultVersion,omitempty"`
}

// ApplicationCreateParameters is parameters for adding an Application.
type ApplicationCreateParameters struct {
	AllowUpdates *bool   `json:"allowUpdates,omitempty"`
	DisplayName  *string `json:"displayName,omitempty"`
}

// ApplicationPackage is an application package which represents a particular version of an application.
type ApplicationPackage struct {
	autorest.Response  `json:"-"`
	ID                 *string      `json:"id,omitempty"`
	Version            *string      `json:"version,omitempty"`
	State              PackageState `json:"state,omitempty"`
	Format             *string      `json:"format,omitempty"`
	StorageURL         *string      `json:"storageUrl,omitempty"`
	StorageURLExpiry   *date.Time   `json:"storageUrlExpiry,omitempty"`
	LastActivationTime *date.Time   `json:"lastActivationTime,omitempty"`
}

// ApplicationUpdateParameters is parameters for an update application request.
type ApplicationUpdateParameters struct {
	AllowUpdates   *bool   `json:"allowUpdates,omitempty"`
	DefaultVersion *string `json:"defaultVersion,omitempty"`
	DisplayName    *string `json:"displayName,omitempty"`
}

// AutoStorageBaseProperties is the properties related to the auto-storage account.
type AutoStorageBaseProperties struct {
	StorageAccountID *string `json:"storageAccountId,omitempty"`
}

// AutoStorageProperties is contains information about the auto-storage account associated with a Batch account.
type AutoStorageProperties struct {
	StorageAccountID *string    `json:"storageAccountId,omitempty"`
	LastKeySync      *date.Time `json:"lastKeySync,omitempty"`
}

// CheckNameAvailabilityParameters is parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult is the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool                  `json:"nameAvailable,omitempty"`
	Reason            NameAvailabilityReason `json:"reason,omitempty"`
	Message           *string                `json:"message,omitempty"`
}

// CloudError is an error response from the Batch service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody is an error response from the Batch service.
type CloudErrorBody struct {
	Code    *string           `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
	Target  *string           `json:"target,omitempty"`
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// KeyVaultReference is identifies the Azure key vault associated with a Batch account.
type KeyVaultReference struct {
	ID  *string `json:"id,omitempty"`
	URL *string `json:"url,omitempty"`
}

// ListApplicationsResult is the result of performing list applications.
type ListApplicationsResult struct {
	autorest.Response `json:"-"`
	Value             *[]Application `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// ListApplicationsResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ListApplicationsResult) ListApplicationsResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// LocationQuota is quotas associated with a Batch region for a particular subscription.
type LocationQuota struct {
	autorest.Response `json:"-"`
	AccountQuota      *int32 `json:"accountQuota,omitempty"`
}

// Operation is
type Operation struct {
	Name       *string                 `json:"name,omitempty"`
	Display    *OperationDisplay       `json:"display,omitempty"`
	Origin     *string                 `json:"origin,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// OperationDisplay is
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult is
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Resource is a definition of an Azure resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}
