/* SHSQL.H
 * Copyright 1998-2002 Stephen C. Grubb  
 * This code is covered under the GNU General Public License (GPL);
 * see the file ./Copyright for details. */

#include <stdlib.h>

#ifndef DBPACKAGE
#define DBPACKAGE 1

/* sql command size */
#define MAXSQLCOMMANDLEN 2050

/* default max number of retrieval rows.. may be overridden using SELECT .. MAXROWS = n */
#define DEFAULT_MAXROWS_SELECT 2000  

/* default max number of rows allowed to be affected by UPDATE or DELETE.. may be overridden using MAXROWS = n */
#define DEFAULT_MAXROWS_UPDATE 2000  

/* maximum number of records that may be locked by a single SELECT .. FOR UPDATE command */
#define MAXRECORDLOCK 200

/* max number of 'connections' per process.. if this is increased, initialize all members to 1 in api.c, 
						and also maintain static variables in dbfunc.c */
#define MAXCONNECTS 4

/* max number of tables that can be referenced in a select 'from' clause.. */
#define MAXCATTAB 20

/* errors */
#define SHSQL_EOF 1
#define SHSQL_RECORDLOCKED 7
#define SHSQL_TABLELOCKED 9

/* minimum number of delim chars to put at end of new record */
#define RECPADLEN 12


#define isdelim(c)	SHSQL_isdelim(c)
#define fieldmap( f )	TDH_fieldmap( "shsql_header", f )
#define BLANK ' '

/* access modes */
#define READSEQUENTIAL 0
#define READISAM 1
#define READISAM_D 2
#define LATE_ISAM_CANCEL 10

/* these are defined and commented in shsqlconfig.c */
extern char SHSQL_projdir[];
extern char SHSQL_tmptabledir[];
extern char SHSQL_bin[];
extern char SHSQL_wildchar;
extern char SHSQL_wildchar1;
extern int SHSQL_debug;
extern long SHSQL_rlocktimeout;
extern int SHSQL_nrows;
extern char SHSQL_tmptblpfx[];
extern int SHSQL_translog;
extern int SHSQL_splitlog;
extern int SHSQL_readonly;
extern char SHSQL_delim;
extern char SHSQL_delims[];
extern int SHSQL_maxrows_select, SHSQL_maxrows_update;
extern int SHSQL_ixtrunclen;
extern char SHSQL_commonwordsfile[];
extern int SHSQL_mustix;
extern int SHSQL_suppressix;
extern char SHSQL_spacerep;
extern int SHSQL_writelock_ntries;
extern int SHSQL_retainund;


/* ======== select parms ======== */
struct selectparms {
	int nrows;		/* number of rows of results (before DISTINCT & LIMIT).  
				   If 0, rows[] array should not be directly accessed (SQ_rows call is ok) */
	int firstrow;		/* first row (LIMIT) */
	int lastrow;        	/* last row (LIMIT) */
	char *itemlist[MAXITEMS]; /* names of requested items */
	int fldpos[MAXITEMS];   /* positions of requested items */
	int nitems;		/* number of members in above lists */
	FILE *outfp;		/* destination for SELECT INTO results */
	int distinct;		/* 1 = select distinct  */
	int nfdf;		/* number of fields in raw records */
	int irow;		/* current row */
	int ngbflds;		/* number of 'group by' fields */
	int gbflds[MAXSORTFIELDS]; /* 'group by' fields */
	char aggflag[MAXITEMS];	/* flags for aggregate processing, one per itemlist member */
	int nagg;		/* number of fields to which aggregate processing will be applied */
	int aggcount[MAXITEMS];	/* counts */
	double aggaccum[MAXITEMS]; /* accumulators */
	char *aggbuf;		/* will point to malloc'ed storage for char reps of aggregate values */
	int finalrowcount;	/* row count after all rows gotten */
	int intermed;		/* 1 if result is being captured (eg select into or join result);
					certain conversions on result fields are suppressed */
	} ;


#endif

/* functions: */
extern char *TDH_getvarp();

extern int SHSQL_sql();
extern int SHSQL_getrow();
extern int SHSQL_pushrow();
extern int SHSQL_getnames();
extern int SHSQL_tabdef();
extern int SHSQL_getnrows();
extern int SHSQL_writable();
extern int SHSQL_getitem();
extern int SHSQL_getitems();
extern int SHSQL_loadfieldmap();
extern int SHSQL_lfmcurtable();
extern int SHSQL_err();
extern int SHSQL_logdberr();
extern int SHSQL_log();
extern int SHSQL_atvar();
extern int SHSQL_isdelim();
extern int SHSQL_getfld();
extern int SHSQL_use_index();
extern int SHSQL_indexlook();
extern int SHSQL_get_ovfl();
extern int SHSQL_getixfields();
extern int SHSQL_sfu_init();
extern int SHSQL_sfu_rec();
extern int SHSQL_sfu();
extern int SHSQL_sfu_close();
extern int SHSQL_check_rlock();
extern int SHSQL_check_rlock_rec();
extern int SHSQL_sequence();
extern int SHSQL_allconfig();
extern int SHSQL_readconfig();
extern int SHSQL_command();
extern int SHSQL_fetchrows();
extern int SHSQL_rowcount();
extern int SHSQL_query_already_dequoted();
extern int SHSQL_delete();
extern int SHSQL_insert();
extern int SHSQL_newrec();
extern int SHSQL_select();
extern int SHSQL_row();
extern int SHSQL_free();
extern int SHSQL_freeloclist();
extern int SHSQL_loclistmode();
extern int SHSQL_nextloc();
extern int SHSQL_update();
extern int SHSQL_lock();
extern int SHSQL_unlock();
extern int SHSQL_err();
extern int SHSQL_readlock();
extern int SHSQL_l_to_b64();
extern int SHSQL_b64_to_l();

