/*
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTAwBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WKPopupItem_h
#define WKPopupItem_h

#include <WebKit2/WKBase.h>

#ifdef __cplusplus
extern "C" {
#endif

enum {
    kWKPopupItemTypeSeparator,
    kWKPopupItemTypeItem
};
typedef uint32_t WKPopupItemType;

enum {
    kWKPopupItemTextDirectionRTL,
    kWKPopupItemTextDirectionLTR
};
typedef uint32_t WKPopupItemTextDirection;

WK_EXPORT WKPopupItemType WKPopupItemGetType(WKPopupItemRef item);

WK_EXPORT WKPopupItemTextDirection WKPopupItemGetTextDirection(WKPopupItemRef item);
WK_EXPORT bool WKPopupItemHasTextDirectionOverride(WKPopupItemRef item);

WK_EXPORT WKStringRef WKPopupItemCopyText(WKPopupItemRef item);
WK_EXPORT WKStringRef WKPopupItemCopyToolTipText(WKPopupItemRef item);
WK_EXPORT WKStringRef WKPopupItemCopyAccessibilityText(WKPopupItemRef item);

WK_EXPORT bool WKPopupItemIsEnabled(WKPopupItemRef item);
WK_EXPORT bool WKPopupItemIsLabel(WKPopupItemRef item);
WK_EXPORT bool WKPopupItemIsSelected(WKPopupItemRef item);

#ifdef __cplusplus
}
#endif

#endif /* WKPopupItem_h */
