# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'dependencies': [
    '<(DEPTH)/third_party/khronos/khronos.gyp:khronos_headers',
    '../base/base.gyp:base',
    '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
    '../cc/cc.gyp:cc',
    '../cc/blink/cc_blink.gyp:cc_blink',
    '../components/scheduler/scheduler.gyp:scheduler',
    '../device/battery/battery.gyp:device_battery',
    '../device/battery/battery.gyp:device_battery_mojo_bindings',
    '../device/vibration/vibration.gyp:device_vibration',
    '../device/vibration/vibration.gyp:device_vibration_mojo_bindings',
    '../gin/gin.gyp:gin',
    '../gpu/gpu.gyp:gpu',
    '../jingle/jingle.gyp:jingle_glue',
    '../media/blink/media_blink.gyp:media_blink',
    '../media/media.gyp:media',
    '../mojo/mojo_base.gyp:mojo_environment_chromium',
    '../mojo/mojo_base.gyp:mojo_geometry_lib',
    '../mojo/mojo_base.gyp:mojo_url_type_converters',
    '../net/net.gyp:net',
    '../skia/skia.gyp:skia',
    '../skia/skia.gyp:skia_mojo',
    '../storage/storage_common.gyp:storage_common',
    '../third_party/WebKit/public/blink.gyp:blink',
    '../third_party/icu/icu.gyp:icui18n',
    '../third_party/icu/icu.gyp:icuuc',
    '../third_party/libjingle/libjingle.gyp:libjingle',
    '../third_party/mojo/mojo_edk.gyp:mojo_js_lib',
    '../third_party/npapi/npapi.gyp:npapi',
    '../third_party/widevine/cdm/widevine_cdm.gyp:widevine_cdm_version_h',
    '../ui/accessibility/accessibility.gyp:accessibility',
    '../ui/events/events.gyp:dom_keycode_converter',
    '../ui/gfx/gfx.gyp:gfx',
    '../ui/gfx/gfx.gyp:gfx_geometry',
    '../ui/native_theme/native_theme.gyp:native_theme',
    '../ui/surface/surface.gyp:surface',
    '../v8/tools/gyp/v8.gyp:v8',
    'content_common_mojo_bindings.gyp:content_common_mojo_bindings',
  ],
  'include_dirs': [
    '..',
    '<(SHARED_INTERMEDIATE_DIR)',  # Needed by key_systems.cc.
  ],
  'variables': {
    'public_renderer_sources': [
      'public/renderer/android_content_detection_prefixes.cc',
      'public/renderer/android_content_detection_prefixes.h',
      'public/renderer/browser_plugin_delegate.cc',
      'public/renderer/browser_plugin_delegate.h',
      'public/renderer/content_renderer_client.cc',
      'public/renderer/content_renderer_client.h',
      'public/renderer/context_menu_client.h',
      'public/renderer/document_state.cc',
      'public/renderer/document_state.h',
      'public/renderer/media_stream_audio_renderer.h',
      'public/renderer/navigation_state.cc',
      'public/renderer/navigation_state.h',
      'public/renderer/pepper_plugin_instance.h',
      'public/renderer/platform_event_observer.h',
      'public/renderer/render_font_warmup_win.h',
      'public/renderer/render_frame.h',
      'public/renderer/render_frame_observer.cc',
      'public/renderer/render_frame_observer.h',
      'public/renderer/render_frame_observer_tracker.h',
      'public/renderer/render_process_observer.cc',
      'public/renderer/render_process_observer.h',
      'public/renderer/render_thread.cc',
      'public/renderer/render_thread.h',
      'public/renderer/render_view.h',
      'public/renderer/render_view_observer.cc',
      'public/renderer/render_view_observer.h',
      'public/renderer/render_view_observer_tracker.h',
      'public/renderer/render_view_visitor.h',
      'public/renderer/renderer_ppapi_host.h',
      'public/renderer/resource_fetcher.h',
      'public/renderer/video_encode_accelerator.cc',
      'public/renderer/video_encode_accelerator.h',
      'public/renderer/video_frame_provider.h',
    ],
    'public_renderer_plugin_sources': [
      'public/renderer/plugin_instance_throttler.h',
    ],
    'private_renderer_sources': [
      'renderer/accessibility/blink_ax_enum_conversion.cc',
      'renderer/accessibility/blink_ax_enum_conversion.h',
      'renderer/accessibility/blink_ax_tree_source.cc',
      'renderer/accessibility/blink_ax_tree_source.h',
      'renderer/accessibility/renderer_accessibility.cc',
      'renderer/accessibility/renderer_accessibility.h',
      'renderer/android/address_detector.cc',
      'renderer/android/address_detector.h',
      'renderer/android/content_detector.cc',
      'renderer/android/content_detector.h',
      'renderer/android/email_detector.cc',
      'renderer/android/email_detector.h',
      'renderer/android/phone_number_detector.cc',
      'renderer/android/phone_number_detector.h',
      'renderer/android/renderer_date_time_picker.cc',
      'renderer/android/renderer_date_time_picker.h',
      'renderer/android/synchronous_compositor_factory.cc',
      'renderer/android/synchronous_compositor_factory.h',
      'renderer/battery_status/battery_status_dispatcher.cc',
      'renderer/battery_status/battery_status_dispatcher.h',
      'renderer/browser_plugin/browser_plugin.cc',
      'renderer/browser_plugin/browser_plugin.h',
      'renderer/browser_plugin/browser_plugin_manager.cc',
      'renderer/browser_plugin/browser_plugin_manager.h',
      'renderer/cache_storage/cache_storage_dispatcher.cc',
      'renderer/cache_storage/cache_storage_dispatcher.h',
      'renderer/cache_storage/cache_storage_message_filter.cc',
      'renderer/cache_storage/cache_storage_message_filter.h',
      'renderer/cache_storage/webserviceworkercachestorage_impl.cc',
      'renderer/cache_storage/webserviceworkercachestorage_impl.h',
      'renderer/child_frame_compositing_helper.cc',
      'renderer/child_frame_compositing_helper.h',
      'renderer/chrome_object_extensions_utils.cc',
      'renderer/chrome_object_extensions_utils.h',
      'renderer/clipboard_utils.cc',
      'renderer/clipboard_utils.h',
      'renderer/context_menu_params_builder.cc',
      'renderer/context_menu_params_builder.h',
      'renderer/cursor_utils.cc',
      'renderer/cursor_utils.h',
      'renderer/date_time_suggestion_builder.cc',
      'renderer/date_time_suggestion_builder.h',
      'renderer/device_sensors/device_light_event_pump.cc',
      'renderer/device_sensors/device_light_event_pump.h',
      'renderer/device_sensors/device_motion_event_pump.cc',
      'renderer/device_sensors/device_motion_event_pump.h',
      'renderer/device_sensors/device_orientation_event_pump.cc',
      'renderer/device_sensors/device_orientation_event_pump.h',
      'renderer/device_sensors/device_sensor_event_pump.h',
      'renderer/devtools/devtools_agent.cc',
      'renderer/devtools/devtools_agent.h',
      'renderer/devtools/devtools_agent_filter.cc',
      'renderer/devtools/devtools_agent_filter.h',
      'renderer/devtools/devtools_client.cc',
      'renderer/devtools/devtools_client.h',
      'renderer/devtools/lock_free_circular_queue.h',
      'renderer/devtools/v8_sampling_profiler.cc',
      'renderer/devtools/v8_sampling_profiler.h',
      'renderer/disambiguation_popup_helper.cc',
      'renderer/disambiguation_popup_helper.h',
      'renderer/dom_automation_controller.cc',
      'renderer/dom_automation_controller.h',
      'renderer/dom_storage/dom_storage_cached_area.cc',
      'renderer/dom_storage/dom_storage_cached_area.h',
      'renderer/dom_storage/dom_storage_dispatcher.cc',
      'renderer/dom_storage/dom_storage_dispatcher.h',
      'renderer/dom_storage/dom_storage_proxy.h',
      'renderer/dom_storage/webstoragearea_impl.cc',
      'renderer/dom_storage/webstoragearea_impl.h',
      'renderer/dom_storage/webstoragenamespace_impl.cc',
      'renderer/dom_storage/webstoragenamespace_impl.h',
      'renderer/drop_data_builder.cc',
      'renderer/drop_data_builder.h',
      'renderer/fetchers/manifest_fetcher.cc',
      'renderer/fetchers/manifest_fetcher.h',
      'renderer/fetchers/multi_resolution_image_resource_fetcher.cc',
      'renderer/fetchers/multi_resolution_image_resource_fetcher.h',
      'renderer/fetchers/resource_fetcher_impl.cc',
      'renderer/fetchers/resource_fetcher_impl.h',
      'renderer/fetchers/web_url_loader_client_impl.cc',
      'renderer/fetchers/web_url_loader_client_impl.h',
      'renderer/gamepad_shared_memory_reader.cc',
      'renderer/gamepad_shared_memory_reader.h',
      'renderer/geolocation_dispatcher.cc',
      'renderer/geolocation_dispatcher.h',
      'renderer/gpu/compositor_dependencies.h',
      'renderer/gpu/compositor_external_begin_frame_source.cc',
      'renderer/gpu/compositor_external_begin_frame_source.h',
      'renderer/gpu/compositor_forwarding_message_filter.cc',
      'renderer/gpu/compositor_forwarding_message_filter.h',
      'renderer/gpu/compositor_output_surface.cc',
      'renderer/gpu/compositor_output_surface.h',
      'renderer/gpu/delegated_compositor_output_surface.cc',
      'renderer/gpu/delegated_compositor_output_surface.h',
      'renderer/gpu/frame_swap_message_queue.cc',
      'renderer/gpu/frame_swap_message_queue.h',
      'renderer/gpu/gpu_benchmarking_extension.cc',
      'renderer/gpu/gpu_benchmarking_extension.h',
      'renderer/gpu/mailbox_output_surface.cc',
      'renderer/gpu/mailbox_output_surface.h',
      'renderer/gpu/queue_message_swap_promise.cc',
      'renderer/gpu/queue_message_swap_promise.h',
      'renderer/gpu/render_widget_compositor.cc',
      'renderer/gpu/render_widget_compositor.h',
      'renderer/gpu/stream_texture_host_android.cc',
      'renderer/gpu/stream_texture_host_android.h',
      'renderer/history_controller.cc',
      'renderer/history_controller.h',
      'renderer/history_entry.cc',
      'renderer/history_entry.h',
      'renderer/history_serialization.cc',
      'renderer/history_serialization.h',
      'renderer/idle_user_detector.cc',
      'renderer/idle_user_detector.h',
      'renderer/image_downloader/image_downloader_impl.cc',
      'renderer/image_downloader/image_downloader_impl.h',
      'renderer/ime_event_guard.cc',
      'renderer/ime_event_guard.h',
      'renderer/in_process_renderer_thread.cc',
      'renderer/in_process_renderer_thread.h',
      'renderer/input/input_event_filter.cc',
      'renderer/input/input_event_filter.h',
      'renderer/input/input_handler_manager.cc',
      'renderer/input/input_handler_manager.h',
      'renderer/input/input_handler_manager_client.h',
      'renderer/input/input_handler_proxy.cc',
      'renderer/input/input_handler_proxy.h',
      'renderer/input/input_handler_wrapper.cc',
      'renderer/input/input_handler_wrapper.h',
      'renderer/input/input_scroll_elasticity_controller.cc',
      'renderer/input/input_scroll_elasticity_controller.h',
      'renderer/input/main_thread_input_event_filter.cc',
      'renderer/input/main_thread_input_event_filter.h',
      'renderer/internal_document_state_data.cc',
      'renderer/internal_document_state_data.h',
      'renderer/java/gin_java_bridge_dispatcher.cc',
      'renderer/java/gin_java_bridge_dispatcher.h',
      'renderer/java/gin_java_bridge_object.cc',
      'renderer/java/gin_java_bridge_object.h',
      'renderer/java/gin_java_bridge_value_converter.cc',
      'renderer/java/gin_java_bridge_value_converter.h',
      'renderer/java/gin_java_function_invocation_helper.cc',
      'renderer/java/gin_java_function_invocation_helper.h',
      'renderer/manifest/manifest_manager.cc',
      'renderer/manifest/manifest_manager.h',
      'renderer/manifest/manifest_parser.cc',
      'renderer/manifest/manifest_parser.h',
      'renderer/manifest/manifest_uma_util.cc',
      'renderer/manifest/manifest_uma_util.h',
      'renderer/media/aec_dump_message_filter.cc',
      'renderer/media/aec_dump_message_filter.h',
      'renderer/media/android/audio_decoder_android.cc',
      'renderer/media/android/audio_decoder_android.h',
      'renderer/media/android/media_info_loader.cc',
      'renderer/media/android/media_info_loader.h',
      'renderer/media/android/media_source_delegate.cc',
      'renderer/media/android/media_source_delegate.h',
      'renderer/media/android/renderer_demuxer_android.cc',
      'renderer/media/android/renderer_demuxer_android.h',
      'renderer/media/android/renderer_media_player_manager.cc',
      'renderer/media/android/renderer_media_player_manager.h',
      'renderer/media/android/stream_texture_factory.h',
      'renderer/media/android/stream_texture_factory_impl.cc',
      'renderer/media/android/stream_texture_factory_impl.h',
      'renderer/media/android/stream_texture_factory_synchronous_impl.cc',
      'renderer/media/android/stream_texture_factory_synchronous_impl.h',
      'renderer/media/android/webmediaplayer_android.cc',
      'renderer/media/android/webmediaplayer_android.h',
      'renderer/media/audio_decoder.cc',
      'renderer/media/audio_decoder.h',
      'renderer/media/audio_device_factory.cc',
      'renderer/media/audio_device_factory.h',
      'renderer/media/audio_input_message_filter.cc',
      'renderer/media/audio_input_message_filter.h',
      'renderer/media/audio_message_filter.cc',
      'renderer/media/audio_message_filter.h',
      'renderer/media/audio_renderer_mixer_manager.cc',
      'renderer/media/audio_renderer_mixer_manager.h',
      'renderer/media/crypto/pepper_cdm_wrapper.h',
      'renderer/media/crypto/pepper_cdm_wrapper_impl.cc',
      'renderer/media/crypto/pepper_cdm_wrapper_impl.h',
      'renderer/media/crypto/ppapi_decryptor.cc',
      'renderer/media/crypto/ppapi_decryptor.h',
      'renderer/media/crypto/render_cdm_factory.cc',
      'renderer/media/crypto/render_cdm_factory.h',
      'renderer/media/media_permission_dispatcher.cc',
      'renderer/media/media_permission_dispatcher.h',
      'renderer/media/media_stream_audio_level_calculator.cc',
      'renderer/media/media_stream_audio_level_calculator.h',
      'renderer/media/media_stream_center.h',
      'renderer/media/media_stream_constraints_util.cc',
      'renderer/media/media_stream_constraints_util.h',
      'renderer/media/media_stream_dispatcher.h',
      'renderer/media/media_stream_dispatcher_eventhandler.h',
      'renderer/media/media_stream_track.cc',
      'renderer/media/media_stream_track.h',
      'renderer/media/midi_dispatcher.cc',
      'renderer/media/midi_dispatcher.h',
      'renderer/media/midi_message_filter.cc',
      'renderer/media/midi_message_filter.h',
      'renderer/media/render_media_client.cc',
      'renderer/media/render_media_client.h',
      'renderer/media/render_media_log.cc',
      'renderer/media/render_media_log.h',
      'renderer/media/renderer_gpu_video_accelerator_factories.cc',
      'renderer/media/renderer_gpu_video_accelerator_factories.h',
      'renderer/media/renderer_webaudiodevice_impl.cc',
      'renderer/media/renderer_webaudiodevice_impl.h',
      'renderer/media/renderer_webmidiaccessor_impl.cc',
      'renderer/media/renderer_webmidiaccessor_impl.h',
      'renderer/media/video_capture_impl.cc',
      'renderer/media/video_capture_impl.h',
      'renderer/media/video_capture_impl_manager.cc',
      'renderer/media/video_capture_impl_manager.h',
      'renderer/media/video_capture_message_filter.cc',
      'renderer/media/video_capture_message_filter.h',
      'renderer/media/webmediaplayer_ms.cc',
      'renderer/media/webmediaplayer_ms.h',
      'renderer/memory_benchmarking_extension.cc',
      'renderer/memory_benchmarking_extension.h',
      'renderer/menu_item_builder.cc',
      'renderer/menu_item_builder.h',
      'renderer/mhtml_generator.cc',
      'renderer/mhtml_generator.h',
      'renderer/mojo/service_registry_js_wrapper.cc',
      'renderer/mojo/service_registry_js_wrapper.h',
      'renderer/mouse_lock_dispatcher.cc',
      'renderer/mouse_lock_dispatcher.h',
      'renderer/navigation_state_impl.cc',
      'renderer/navigation_state_impl.h',
      'renderer/net_info_helper.cc',
      'renderer/net_info_helper.h',
      'renderer/notification_permission_dispatcher.cc',
      'renderer/notification_permission_dispatcher.h',
      'renderer/presentation/presentation_dispatcher.cc',
      'renderer/presentation/presentation_dispatcher.h',
      'renderer/presentation/presentation_session_client.cc',
      'renderer/presentation/presentation_session_client.h',
      'renderer/push_messaging/push_messaging_dispatcher.cc',
      'renderer/push_messaging/push_messaging_dispatcher.h',
      'renderer/render_font_warmup_win.cc',
      'renderer/render_frame_impl.cc',
      'renderer/render_frame_impl.h',
      'renderer/render_frame_proxy.cc',
      'renderer/render_frame_proxy.h',
      'renderer/render_process.h',
      'renderer/render_process_impl.cc',
      'renderer/render_process_impl.h',
      'renderer/render_thread_impl.cc',
      'renderer/render_thread_impl.h',
      'renderer/render_view_impl.cc',
      'renderer/render_view_impl.h',
      'renderer/render_view_impl_android.cc',
      'renderer/render_view_linux.cc',
      'renderer/render_view_mouse_lock_dispatcher.cc',
      'renderer/render_view_mouse_lock_dispatcher.h',
      'renderer/render_view_win.cc',
      'renderer/render_widget.cc',
      'renderer/render_widget.h',
      'renderer/render_widget_fullscreen.cc',
      'renderer/render_widget_fullscreen.h',
      'renderer/renderer_blink_platform_impl.cc',
      'renderer/renderer_blink_platform_impl.h',
      'renderer/renderer_clipboard_delegate.cc',
      'renderer/renderer_clipboard_delegate.h',
      'renderer/renderer_main.cc',
      'renderer/renderer_main_platform_delegate.h',
      'renderer/renderer_main_platform_delegate_android.cc',
      'renderer/renderer_main_platform_delegate_linux.cc',
      'renderer/renderer_main_platform_delegate_mac.mm',
      'renderer/renderer_main_platform_delegate_win.cc',
      'renderer/renderer_webapplicationcachehost_impl.cc',
      'renderer/renderer_webapplicationcachehost_impl.h',
      'renderer/renderer_webcolorchooser_impl.cc',
      'renderer/renderer_webcolorchooser_impl.h',
      'renderer/renderer_webcookiejar_impl.cc',
      'renderer/renderer_webcookiejar_impl.h',
      'renderer/resizing_mode_selector.cc',
      'renderer/resizing_mode_selector.h',
      'renderer/sad_plugin.cc',
      'renderer/sad_plugin.h',
      'renderer/savable_resources.cc',
      'renderer/savable_resources.h',
      'renderer/scheduler/resource_dispatch_throttler.cc',
      'renderer/scheduler/resource_dispatch_throttler.h',
      'renderer/screen_orientation/screen_orientation_dispatcher.cc',
      'renderer/screen_orientation/screen_orientation_dispatcher.h',
      'renderer/screen_orientation/screen_orientation_observer.cc',
      'renderer/screen_orientation/screen_orientation_observer.h',
      'renderer/service_worker/embedded_worker_devtools_agent.cc',
      'renderer/service_worker/embedded_worker_devtools_agent.h',
      'renderer/service_worker/embedded_worker_dispatcher.cc',
      'renderer/service_worker/embedded_worker_dispatcher.h',
      'renderer/service_worker/service_worker_context_client.cc',
      'renderer/service_worker/service_worker_context_client.h',
      'renderer/service_worker/service_worker_context_message_filter.cc',
      'renderer/service_worker/service_worker_context_message_filter.h',
      'renderer/service_worker/service_worker_type_util.cc',
      'renderer/service_worker/service_worker_type_util.h',
      'renderer/shared_memory_seqlock_reader.cc',
      'renderer/shared_memory_seqlock_reader.h',
      'renderer/shared_worker/embedded_shared_worker_content_settings_client_proxy.cc',
      'renderer/shared_worker/embedded_shared_worker_content_settings_client_proxy.h',
      'renderer/shared_worker/embedded_shared_worker_stub.cc',
      'renderer/shared_worker/embedded_shared_worker_stub.h',
      'renderer/shared_worker_repository.cc',
      'renderer/shared_worker_repository.h',
      'renderer/skia_benchmarking_extension.cc',
      'renderer/skia_benchmarking_extension.h',
      'renderer/speech_recognition_dispatcher.cc',
      'renderer/speech_recognition_dispatcher.h',
      'renderer/stats_collection_controller.cc',
      'renderer/stats_collection_controller.h',
      'renderer/stats_collection_observer.cc',
      'renderer/stats_collection_observer.h',
      'renderer/text_input_client_observer.cc',
      'renderer/text_input_client_observer.h',
      'renderer/web_ui_extension.cc',
      'renderer/web_ui_extension.h',
      'renderer/web_ui_extension_data.cc',
      'renderer/web_ui_extension_data.h',
      'renderer/web_ui_mojo.cc',
      'renderer/web_ui_mojo.h',
      'renderer/web_ui_mojo_context_state.cc',
      'renderer/web_ui_mojo_context_state.h',
      'renderer/web_ui_runner.cc',
      'renderer/web_ui_runner.h',
      'renderer/webclipboard_impl.cc',
      'renderer/webclipboard_impl.h',
      'renderer/webgraphicscontext3d_provider_impl.cc',
      'renderer/webgraphicscontext3d_provider_impl.h',
      'renderer/webpublicsuffixlist_impl.cc',
      'renderer/webpublicsuffixlist_impl.h',
      'renderer/webscrollbarbehavior_impl_gtkoraura.cc',
      'renderer/webscrollbarbehavior_impl_gtkoraura.h',
      'renderer/webscrollbarbehavior_impl_mac.h',
      'renderer/webscrollbarbehavior_impl_mac.mm',
      'renderer/websharedworker_proxy.cc',
      'renderer/websharedworker_proxy.h',
    ],
    # Put WebRTC-related sources in the plugin+WebRTC section below.
    'private_renderer_plugin_sources': [
      'renderer/npapi/plugin_channel_host.cc',
      'renderer/npapi/plugin_channel_host.h',
      'renderer/npapi/webplugin_delegate_proxy.cc',
      'renderer/npapi/webplugin_delegate_proxy.h',
      'renderer/npapi/webplugin_impl.cc',
      'renderer/npapi/webplugin_impl.h',
      'renderer/pepper/audio_helper.cc',
      'renderer/pepper/audio_helper.h',
      'renderer/pepper/content_decryptor_delegate.cc',
      'renderer/pepper/content_decryptor_delegate.h',
      'renderer/pepper/content_renderer_pepper_host_factory.cc',
      'renderer/pepper/content_renderer_pepper_host_factory.h',
      'renderer/pepper/event_conversion.cc',
      'renderer/pepper/event_conversion.h',
      'renderer/pepper/fullscreen_container.h',
      'renderer/pepper/gfx_conversion.h',
      'renderer/pepper/host_array_buffer_var.cc',
      'renderer/pepper/host_array_buffer_var.h',
      'renderer/pepper/host_dispatcher_wrapper.cc',
      'renderer/pepper/host_dispatcher_wrapper.h',
      'renderer/pepper/host_globals.cc',
      'renderer/pepper/host_globals.h',
      'renderer/pepper/host_resource_var.cc',
      'renderer/pepper/host_resource_var.h',
      'renderer/pepper/host_var_tracker.cc',
      'renderer/pepper/host_var_tracker.h',
      'renderer/pepper/message_channel.cc',
      'renderer/pepper/message_channel.h',
      'renderer/pepper/pepper_audio_input_host.cc',
      'renderer/pepper/pepper_audio_input_host.h',
      'renderer/pepper/pepper_broker.cc',
      'renderer/pepper/pepper_broker.h',
      'renderer/pepper/pepper_browser_connection.cc',
      'renderer/pepper/pepper_browser_connection.h',
      'renderer/pepper/pepper_camera_device_host.cc',
      'renderer/pepper/pepper_camera_device_host.h',
      'renderer/pepper/pepper_compositor_host.cc',
      'renderer/pepper/pepper_compositor_host.h',
      'renderer/pepper/pepper_device_enumeration_host_helper.cc',
      'renderer/pepper/pepper_device_enumeration_host_helper.h',
      'renderer/pepper/pepper_file_chooser_host.cc',
      'renderer/pepper/pepper_file_chooser_host.h',
      'renderer/pepper/pepper_file_ref_renderer_host.cc',
      'renderer/pepper/pepper_file_ref_renderer_host.h',
      'renderer/pepper/pepper_file_system_host.cc',
      'renderer/pepper/pepper_file_system_host.h',
      'renderer/pepper/pepper_graphics_2d_host.cc',
      'renderer/pepper/pepper_graphics_2d_host.h',
      'renderer/pepper/pepper_hung_plugin_filter.cc',
      'renderer/pepper/pepper_hung_plugin_filter.h',
      'renderer/pepper/pepper_in_process_resource_creation.cc',
      'renderer/pepper/pepper_in_process_resource_creation.h',
      'renderer/pepper/pepper_in_process_router.cc',
      'renderer/pepper/pepper_in_process_router.h',
      'renderer/pepper/pepper_media_device_manager.cc',
      'renderer/pepper/pepper_media_device_manager.h',
      'renderer/pepper/pepper_platform_audio_input.cc',
      'renderer/pepper/pepper_platform_audio_input.h',
      'renderer/pepper/pepper_platform_audio_output.cc',
      'renderer/pepper/pepper_platform_audio_output.h',
      'renderer/pepper/pepper_platform_camera_device.cc',
      'renderer/pepper/pepper_platform_camera_device.h',
      'renderer/pepper/pepper_platform_video_capture.cc',
      'renderer/pepper/pepper_platform_video_capture.h',
      'renderer/pepper/pepper_plugin_instance_impl.cc',
      'renderer/pepper/pepper_plugin_instance_impl.h',
      'renderer/pepper/pepper_plugin_instance_metrics.cc',
      'renderer/pepper/pepper_plugin_instance_metrics.h',
      'renderer/pepper/pepper_plugin_registry.cc',
      'renderer/pepper/pepper_plugin_registry.h',
      'renderer/pepper/pepper_proxy_channel_delegate_impl.cc',
      'renderer/pepper/pepper_proxy_channel_delegate_impl.h',
      'renderer/pepper/pepper_try_catch.cc',
      'renderer/pepper/pepper_try_catch.h',
      'renderer/pepper/pepper_url_loader_host.cc',
      'renderer/pepper/pepper_url_loader_host.h',
      'renderer/pepper/pepper_video_capture_host.cc',
      'renderer/pepper/pepper_video_capture_host.h',
      'renderer/pepper/pepper_video_decoder_host.cc',
      'renderer/pepper/pepper_video_decoder_host.h',
      'renderer/pepper/pepper_video_encoder_host.cc',
      'renderer/pepper/pepper_video_encoder_host.h',
      'renderer/pepper/pepper_webplugin_impl.cc',
      'renderer/pepper/pepper_webplugin_impl.h',
      'renderer/pepper/pepper_websocket_host.cc',
      'renderer/pepper/pepper_websocket_host.h',
      'renderer/pepper/plugin_instance_throttler_impl.cc',
      'renderer/pepper/plugin_instance_throttler_impl.h',
      'renderer/pepper/plugin_module.cc',
      'renderer/pepper/plugin_module.h',
      'renderer/pepper/plugin_object.cc',
      'renderer/pepper/plugin_object.h',
      'renderer/pepper/plugin_power_saver_helper.cc',
      'renderer/pepper/plugin_power_saver_helper.h',
      'renderer/pepper/ppapi_preferences_builder.cc',
      'renderer/pepper/ppapi_preferences_builder.h',
      'renderer/pepper/ppb_audio_impl.cc',
      'renderer/pepper/ppb_audio_impl.h',
      'renderer/pepper/ppb_broker_impl.cc',
      'renderer/pepper/ppb_broker_impl.h',
      'renderer/pepper/ppb_buffer_impl.cc',
      'renderer/pepper/ppb_buffer_impl.h',
      'renderer/pepper/ppb_flash_message_loop_impl.cc',
      'renderer/pepper/ppb_flash_message_loop_impl.h',
      'renderer/pepper/ppb_graphics_3d_impl.cc',
      'renderer/pepper/ppb_graphics_3d_impl.h',
      'renderer/pepper/ppb_image_data_impl.cc',
      'renderer/pepper/ppb_image_data_impl.h',
      'renderer/pepper/ppb_proxy_impl.cc',
      'renderer/pepper/ppb_proxy_impl.h',
      'renderer/pepper/ppb_var_deprecated_impl.cc',
      'renderer/pepper/ppb_var_deprecated_impl.h',
      'renderer/pepper/ppb_video_decoder_impl.cc',
      'renderer/pepper/ppb_video_decoder_impl.h',
      'renderer/pepper/renderer_ppapi_host_impl.cc',
      'renderer/pepper/renderer_ppapi_host_impl.h',
      'renderer/pepper/renderer_restrict_dispatch_group.h',
      'renderer/pepper/resource_converter.cc',
      'renderer/pepper/resource_converter.h',
      'renderer/pepper/resource_creation_impl.cc',
      'renderer/pepper/resource_creation_impl.h',
      'renderer/pepper/url_request_info_util.cc',
      'renderer/pepper/url_request_info_util.h',
      'renderer/pepper/url_response_info_util.cc',
      'renderer/pepper/url_response_info_util.h',
      'renderer/pepper/v8_var_converter.cc',
      'renderer/pepper/v8_var_converter.h',
      'renderer/pepper/v8object_var.cc',
      'renderer/pepper/v8object_var.h',
      'renderer/pepper/video_decoder_shim.cc',
      'renderer/pepper/video_decoder_shim.h',
      'renderer/pepper/video_encoder_shim.cc',
      'renderer/pepper/video_encoder_shim.h',
      'renderer/render_widget_fullscreen_pepper.cc',
      'renderer/render_widget_fullscreen_pepper.h',
    ],
    'public_renderer_webrtc_sources': [
      'public/renderer/media_stream_api.cc',
      'public/renderer/media_stream_api.h',
      'public/renderer/media_stream_audio_sink.cc',
      'public/renderer/media_stream_audio_sink.h',
      'public/renderer/media_stream_renderer_factory.h',
      'public/renderer/media_stream_sink.h',
      'public/renderer/media_stream_video_sink.cc',
      'public/renderer/media_stream_video_sink.h',
      'public/renderer/webrtc_log_message_delegate.h',
    ],
    # WebRTC-specific sources. Put WebRTC plugin-related stuff in the
    # Plugin+WebRTC section below.
    'private_renderer_webrtc_sources': [
      'renderer/media/media_stream.cc',
      'renderer/media/media_stream.h',
      'renderer/media/media_stream_audio_processor.cc',
      'renderer/media/media_stream_audio_processor.h',
      'renderer/media/media_stream_audio_processor_options.cc',
      'renderer/media/media_stream_audio_processor_options.h',
      'renderer/media/media_stream_audio_sink_owner.cc',
      'renderer/media/media_stream_audio_sink_owner.h',
      'renderer/media/media_stream_audio_source.cc',
      'renderer/media/media_stream_audio_source.h',
      'renderer/media/media_stream_audio_track_sink.h',
      'renderer/media/media_stream_center.cc',
      'renderer/media/media_stream_dispatcher.cc',
      'renderer/media/media_stream_registry_interface.h',
      'renderer/media/media_stream_renderer_factory_impl.cc',
      'renderer/media/media_stream_renderer_factory_impl.h',
      'renderer/media/media_stream_source.cc',
      'renderer/media/media_stream_source.h',
      'renderer/media/media_stream_video_capturer_source.cc',
      'renderer/media/media_stream_video_capturer_source.h',
      'renderer/media/media_stream_video_source.cc',
      'renderer/media/media_stream_video_source.h',
      'renderer/media/media_stream_video_track.cc',
      'renderer/media/media_stream_video_track.h',
      'renderer/media/peer_connection_identity_service.cc',
      'renderer/media/peer_connection_identity_service.h',
      'renderer/media/peer_connection_tracker.cc',
      'renderer/media/peer_connection_tracker.h',
      'renderer/media/remote_media_stream_impl.cc',
      'renderer/media/remote_media_stream_impl.h',
      'renderer/media/rtc_data_channel_handler.cc',
      'renderer/media/rtc_data_channel_handler.h',
      'renderer/media/rtc_dtmf_sender_handler.cc',
      'renderer/media/rtc_dtmf_sender_handler.h',
      'renderer/media/rtc_media_constraints.cc',
      'renderer/media/rtc_media_constraints.h',
      'renderer/media/rtc_peer_connection_handler.cc',
      'renderer/media/rtc_peer_connection_handler.h',
      'renderer/media/rtc_video_decoder.cc',
      'renderer/media/rtc_video_decoder.h',
      'renderer/media/rtc_video_decoder_factory.cc',
      'renderer/media/rtc_video_decoder_factory.h',
      'renderer/media/rtc_video_encoder.cc',
      'renderer/media/rtc_video_encoder.h',
      'renderer/media/rtc_video_encoder_factory.cc',
      'renderer/media/rtc_video_encoder_factory.h',
      'renderer/media/rtc_video_renderer.cc',
      'renderer/media/rtc_video_renderer.h',
      'renderer/media/speech_recognition_audio_sink.cc',
      'renderer/media/speech_recognition_audio_sink.h',
      'renderer/media/user_media_client_impl.cc',
      'renderer/media/video_source_handler.cc',
      'renderer/media/video_source_handler.h',
      'renderer/media/video_track_adapter.cc',
      'renderer/media/video_track_adapter.h',
      'renderer/media/webaudio_capturer_source.cc',
      'renderer/media/webaudio_capturer_source.h',
      'renderer/media/webrtc/media_stream_remote_video_source.cc',
      'renderer/media/webrtc/media_stream_remote_video_source.h',
      'renderer/media/webrtc/media_stream_track_metrics.cc',
      'renderer/media/webrtc/media_stream_track_metrics.h',
      'renderer/media/webrtc/peer_connection_dependency_factory.cc',
      'renderer/media/webrtc/peer_connection_dependency_factory.h',
      'renderer/media/webrtc/stun_field_trial.cc',
      'renderer/media/webrtc/stun_field_trial.h',
      'renderer/media/webrtc/track_observer.cc',
      'renderer/media/webrtc/track_observer.h',
      'renderer/media/webrtc/video_destination_handler.cc',
      'renderer/media/webrtc/video_destination_handler.h',
      'renderer/media/webrtc/webrtc_audio_sink_adapter.cc',
      'renderer/media/webrtc/webrtc_audio_sink_adapter.h',
      'renderer/media/webrtc/webrtc_local_audio_track_adapter.cc',
      'renderer/media/webrtc/webrtc_local_audio_track_adapter.h',
      'renderer/media/webrtc/webrtc_media_stream_adapter.cc',
      'renderer/media/webrtc/webrtc_media_stream_adapter.h',
      'renderer/media/webrtc/webrtc_video_capturer_adapter.cc',
      'renderer/media/webrtc/webrtc_video_capturer_adapter.h',
      'renderer/media/webrtc/webrtc_video_frame_adapter.cc',
      'renderer/media/webrtc/webrtc_video_frame_adapter.h',
      'renderer/media/webrtc/webrtc_video_track_adapter.cc',
      'renderer/media/webrtc/webrtc_video_track_adapter.h',
      'renderer/media/webrtc_audio_capturer.cc',
      'renderer/media/webrtc_audio_capturer.h',
      'renderer/media/webrtc_audio_device_impl.cc',
      'renderer/media/webrtc_audio_device_impl.h',
      'renderer/media/webrtc_audio_device_not_impl.cc',
      'renderer/media/webrtc_audio_device_not_impl.h',
      'renderer/media/webrtc_audio_renderer.cc',
      'renderer/media/webrtc_audio_renderer.h',
      'renderer/media/webrtc_identity_service.cc',
      'renderer/media/webrtc_identity_service.h',
      'renderer/media/webrtc_local_audio_renderer.cc',
      'renderer/media/webrtc_local_audio_renderer.h',
      'renderer/media/webrtc_local_audio_source_provider.cc',
      'renderer/media/webrtc_local_audio_source_provider.h',
      'renderer/media/webrtc_local_audio_track.cc',
      'renderer/media/webrtc_local_audio_track.h',
      'renderer/media/webrtc_logging.cc',
      'renderer/media/webrtc_logging.h',
      'renderer/media/webrtc_uma_histograms.cc',
      'renderer/media/webrtc_uma_histograms.h',
      'renderer/p2p/host_address_request.cc',
      'renderer/p2p/host_address_request.h',
      'renderer/p2p/ipc_network_manager.cc',
      'renderer/p2p/ipc_network_manager.h',
      'renderer/p2p/ipc_socket_factory.cc',
      'renderer/p2p/ipc_socket_factory.h',
      'renderer/p2p/network_list_observer.h',
      'renderer/p2p/port_allocator.cc',
      'renderer/p2p/port_allocator.h',
      'renderer/p2p/socket_client_impl.cc',
      'renderer/p2p/socket_client_impl.h',
      'renderer/p2p/socket_dispatcher.cc',
      'renderer/p2p/socket_dispatcher.h',
    ],
    # Stuff only used when both WebRTC and plugins are enabled.
    'private_renderer_plugin_webrtc_sources': [
      'renderer/pepper/pepper_media_stream_audio_track_host.cc',
      'renderer/pepper/pepper_media_stream_audio_track_host.h',
      'renderer/pepper/pepper_media_stream_track_host_base.cc',
      'renderer/pepper/pepper_media_stream_track_host_base.h',
      'renderer/pepper/pepper_media_stream_video_track_host.cc',
      'renderer/pepper/pepper_media_stream_video_track_host.h',
      'renderer/pepper/pepper_video_destination_host.cc',
      'renderer/pepper/pepper_video_destination_host.h',
      'renderer/pepper/pepper_video_source_host.cc',
      'renderer/pepper/pepper_video_source_host.h',
    ]
  },
  'sources': [
    '<@(public_renderer_sources)',
    '<@(private_renderer_sources)',
  ],
  'conditions': [
    ['OS=="mac"', {
      'sources!': [
        'common/process_watcher_posix.cc',
        'renderer/webscrollbarbehavior_impl_gtkoraura.cc',
        'renderer/webscrollbarbehavior_impl_gtkoraura.h',
      ],
      'sources': [
        'renderer/external_popup_menu.cc',
        'renderer/external_popup_menu.h',
      ],
    }, {
      'sources!': [
        'renderer/webscrollbarbehavior_impl_mac.h',
        'renderer/webscrollbarbehavior_impl_mac.mm',
      ],
    }],
    ['OS=="win" and win_use_allocator_shim==1', {
      'dependencies': [
          '../base/allocator/allocator.gyp:allocator',
      ],
    }],
    ['OS=="android"', {
      'sources!': [
        'renderer/media/audio_decoder.cc',
      ],
      'sources': [
        'renderer/external_popup_menu.cc',
        'renderer/external_popup_menu.h',
      ],
      'dependencies': [
        '../build/android/ndk.gyp:cpu_features',
        '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
      ],
    }, {
      'sources!': [
        'renderer/java/gin_java_bridge_dispatcher.cc',
        'renderer/java/gin_java_bridge_dispatcher.h',
        'renderer/java/gin_java_bridge_object.cc',
        'renderer/java/gin_java_bridge_object.h',
        'renderer/java/gin_java_bridge_value_converter.cc',
        'renderer/java/gin_java_bridge_value_converter.h',
        'renderer/java/gin_java_function_invocation_helper.cc',
        'renderer/java/gin_java_function_invocation_helper.h',
      ],
      'dependencies': [
        '../media/cast/cast.gyp:cast_sender',
      ]
    }],
    # TODO(jrg): remove the OS=="android" section?
    # http://crbug.com/113172
    # Understand better how media_stream_ is tied into Chromium.
    ['enable_webrtc==0 and OS=="android"', {
      'sources/': [
        ['exclude', '^renderer/media/media_stream_'],
      ],
    }],
    ['enable_webrtc==1', {
      'dependencies': [
        '../third_party/libjingle/libjingle.gyp:libjingle_webrtc',
        '../third_party/libjingle/libjingle.gyp:libpeerconnection',
        '../third_party/libyuv/libyuv.gyp:libyuv',
        '../third_party/webrtc/modules/modules.gyp:audio_device',
        '../third_party/webrtc/modules/modules.gyp:audio_processing',
        '../third_party/webrtc/p2p/p2p.gyp:libstunprober',
        '<(DEPTH)/crypto/crypto.gyp:crypto',
      ],
      'sources': [
        '<@(public_renderer_webrtc_sources)',
        '<@(private_renderer_webrtc_sources)',
      ],
    },{  # enable_webrtc==0
      'sources': [
        'renderer/media/webrtc_logging.h',
        'renderer/media/webrtc_logging_noop.cc',
      ],
    }],
    ['enable_plugins==1', {
      'sources': [
        '<@(public_renderer_plugin_sources)',
        '<@(private_renderer_plugin_sources)',
      ],
      'conditions': [
        ['OS=="android"', {
          'sources!': [
            # Android does not build FFmpeg, which these depend on.
            'renderer/pepper/video_decoder_shim.cc',
            'renderer/pepper/video_decoder_shim.h',
            'renderer/pepper/video_encoder_shim.cc',
            'renderer/pepper/video_encoder_shim.h',
          ],
        }],
      ],
      'dependencies': [
        '../ppapi/ppapi_internal.gyp:ppapi_host',
        '../ppapi/ppapi_internal.gyp:ppapi_proxy',
        '../ppapi/ppapi_internal.gyp:ppapi_shared',
        '../third_party/libyuv/libyuv.gyp:libyuv',
      ],
    }, {  # enable_plugins==0
      'sources!': [
        # These are not in the plugins sources list since it also requires webrtc.
        'renderer/media/webrtc/video_destination_handler.cc',
        'renderer/media/webrtc/video_destination_handler.h',
      ],
    }],
    ['enable_plugins==1 and enable_webrtc==1', {
      'sources': [
        '<@(private_renderer_plugin_webrtc_sources)',
      ],
    }],
    ['enable_pepper_cdms != 1', {
      'sources!': [
        'renderer/media/crypto/pepper_cdm_wrapper.h',
        'renderer/media/crypto/pepper_cdm_wrapper_impl.cc',
        'renderer/media/crypto/pepper_cdm_wrapper_impl.h',
        'renderer/media/crypto/ppapi_decryptor.cc',
        'renderer/media/crypto/ppapi_decryptor.h',
      ],
    }],
    ['enable_browser_cdms==1', {
      'sources': [
        'renderer/media/crypto/proxy_media_keys.cc',
        'renderer/media/crypto/proxy_media_keys.h',
        'renderer/media/crypto/renderer_cdm_manager.cc',
        'renderer/media/crypto/renderer_cdm_manager.h',
      ],
    }],
    ['use_seccomp_bpf==1', {
      'defines': ['USE_SECCOMP_BPF'],
    }],
    ['enable_webvr==1', {
      'sources': [
        'renderer/vr/vr_dispatcher.cc',
        'renderer/vr/vr_dispatcher.h',
        'renderer/vr/vr_type_converters.cc',
        'renderer/vr/vr_type_converters.h',
      ]
    }],
  ],
  'target_conditions': [
    ['OS=="android"', {
      'sources/': [
        ['include', '^renderer/render_view_linux\\.cc$'],
      ],
    }],
  ],
}
