/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Set;

public class ClassResolver {
    private final String pkg;
    private final Set<String> imports;
    private final ClassLoader loader;

    public ClassResolver(ClassLoader loader, String pkg, Set<String> imports) {
        this.loader = loader;
        this.pkg = pkg;
        this.imports = imports;
        imports.add("java.lang.*");
    }

    public Class<?> resolve(String name, String currentClass) throws ClassNotFoundException {
        String innerClass;
        Class<?> clazz = this.resolveQualifiedName(name);
        if (clazz != null) {
            return clazz;
        }
        for (String imp : this.imports) {
            if (!imp.endsWith("." + name) || (clazz = this.resolveQualifiedName(imp)) == null) continue;
            return clazz;
        }
        if (!"".equals(this.pkg) && (clazz = this.resolveQualifiedName(this.pkg + "." + name)) != null) {
            return clazz;
        }
        if (!"".equals(currentClass) && this.isLoadable(innerClass = (!"".equals(this.pkg) ? this.pkg + "." : "") + currentClass + "$" + name)) {
            return this.safeLoad(innerClass);
        }
        for (String imp : this.imports) {
            String fqn;
            if (!imp.endsWith(".*") || (clazz = this.resolveQualifiedName(fqn = imp.substring(0, imp.lastIndexOf(46) + 1) + name)) == null) continue;
            return clazz;
        }
        return this.safeLoad(name);
    }

    public boolean isLoadable(String name) {
        try {
            this.safeLoad(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Class<?> safeLoad(String name) throws ClassNotFoundException {
        return Class.forName(name, false, this.loader);
    }

    private Class<?> resolveQualifiedName(String name) {
        try {
            String innerName;
            if (this.isLoadable(name)) {
                return this.safeLoad(name);
            }
            int dot = name.lastIndexOf(".");
            if (dot != -1 && this.isLoadable(innerName = name.substring(0, dot) + "$" + name.substring(dot + 1))) {
                return this.safeLoad(innerName);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }
}

