/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class MemberDefHandler
extends ExpressionHandler {
    public MemberDefHandler(IndentationCheck indentCheck, DetailAST ast, ExpressionHandler parent) {
        super(indentCheck, "member def", ast, parent);
    }

    @Override
    public void checkIndentation() {
        DetailAST modifiersNode = this.getMainAst().findFirstToken(5);
        if (modifiersNode.getChildCount() != 0) {
            this.checkModifiers();
        } else {
            this.checkType();
        }
        LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst(), MemberDefHandler.getVarDefStatementSemicolon(this.getMainAst()));
        if (lineWrap.getLastNode() != null && !this.isArrayDeclaration(this.getMainAst())) {
            lineWrap.checkIndentation();
        }
    }

    @Override
    public IndentLevel suggestedChildLevel(ExpressionHandler child) {
        return this.getLevel();
    }

    @Override
    protected void checkModifiers() {
        DetailAST modifier = this.getMainAst().findFirstToken(5);
        if (this.startsLine(modifier) && !this.getLevel().accept(this.expandedTabsColumnNo(modifier))) {
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    private void checkType() {
        DetailAST type = this.getMainAst().findFirstToken(13);
        DetailAST ident = ExpressionHandler.getFirstToken(type);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.startsLine(ident) && !this.getLevel().accept(columnNo)) {
            this.logError(ident, "type", columnNo);
        }
    }

    private boolean isArrayDeclaration(DetailAST variableDef) {
        return variableDef.findFirstToken(13).findFirstToken(17) != null;
    }

    private static DetailAST getVarDefStatementSemicolon(DetailAST variableDef) {
        DetailAST lastNode = variableDef.getLastChild();
        if (lastNode.getType() != 45) {
            lastNode = variableDef.getNextSibling();
        }
        return lastNode;
    }
}

