// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_KEYCODES_XKB_KEYSYM_H_
#define UI_EVENTS_KEYCODES_XKB_KEYSYM_H_

#include "ui/base/buildflags.h"

// This file provides definitions of the xkbcommon keysym type (xkb_keysym_t)
// and values (XKB_KEY_...) for both xkbcommon and traditional X11.

#if BUILDFLAG(USE_XKBCOMMON)

#include <xkbcommon/xkbcommon.h>
#include <xkbcommon/xkbcommon-keysyms.h>

#else  // !BUILDFLAG(USE_XKBCOMMON)

#include "ui/gfx/x/x11.h"

using xkb_keysym_t = uint32_t;

#define XKB_KEY_3270_Duplicate                    XK_3270_Duplicate
#define XKB_KEY_3270_FieldMark                    XK_3270_FieldMark
#define XKB_KEY_3270_Right2                       XK_3270_Right2
#define XKB_KEY_3270_Left2                        XK_3270_Left2
#define XKB_KEY_3270_BackTab                      XK_3270_BackTab
#define XKB_KEY_3270_EraseEOF                     XK_3270_EraseEOF
#define XKB_KEY_3270_EraseInput                   XK_3270_EraseInput
#define XKB_KEY_3270_Reset                        XK_3270_Reset
#define XKB_KEY_3270_Quit                         XK_3270_Quit
#define XKB_KEY_3270_PA1                          XK_3270_PA1
#define XKB_KEY_3270_PA2                          XK_3270_PA2
#define XKB_KEY_3270_PA3                          XK_3270_PA3
#define XKB_KEY_3270_Test                         XK_3270_Test
#define XKB_KEY_3270_Attn                         XK_3270_Attn
#define XKB_KEY_3270_CursorBlink                  XK_3270_CursorBlink
#define XKB_KEY_3270_AltCursor                    XK_3270_AltCursor
#define XKB_KEY_3270_KeyClick                     XK_3270_KeyClick
#define XKB_KEY_3270_Jump                         XK_3270_Jump
#define XKB_KEY_3270_Ident                        XK_3270_Ident
#define XKB_KEY_3270_Rule                         XK_3270_Rule
#define XKB_KEY_3270_Copy                         XK_3270_Copy
#define XKB_KEY_3270_Play                         XK_3270_Play
#define XKB_KEY_3270_Setup                        XK_3270_Setup
#define XKB_KEY_3270_Record                       XK_3270_Record
#define XKB_KEY_3270_ChangeScreen                 XK_3270_ChangeScreen
#define XKB_KEY_3270_DeleteWord                   XK_3270_DeleteWord
#define XKB_KEY_3270_ExSelect                     XK_3270_ExSelect
#define XKB_KEY_3270_CursorSelect                 XK_3270_CursorSelect
#define XKB_KEY_3270_PrintScreen                  XK_3270_PrintScreen
#define XKB_KEY_3270_Enter                        XK_3270_Enter
#define XKB_KEY_ISO_Lock                          XK_ISO_Lock
#define XKB_KEY_ISO_Level2_Latch                  XK_ISO_Level2_Latch
#define XKB_KEY_ISO_Level3_Shift                  XK_ISO_Level3_Shift
#define XKB_KEY_ISO_Level3_Latch                  XK_ISO_Level3_Latch
#define XKB_KEY_ISO_Level3_Lock                   XK_ISO_Level3_Lock
#define XKB_KEY_ISO_Group_Latch                   XK_ISO_Group_Latch
#define XKB_KEY_ISO_Group_Lock                    XK_ISO_Group_Lock
#define XKB_KEY_ISO_Next_Group                    XK_ISO_Next_Group
#define XKB_KEY_ISO_Next_Group_Lock               XK_ISO_Next_Group_Lock
#define XKB_KEY_ISO_Prev_Group                    XK_ISO_Prev_Group
#define XKB_KEY_ISO_Prev_Group_Lock               XK_ISO_Prev_Group_Lock
#define XKB_KEY_ISO_First_Group                   XK_ISO_First_Group
#define XKB_KEY_ISO_First_Group_Lock              XK_ISO_First_Group_Lock
#define XKB_KEY_ISO_Last_Group                    XK_ISO_Last_Group
#define XKB_KEY_ISO_Last_Group_Lock               XK_ISO_Last_Group_Lock
#define XKB_KEY_ISO_Level5_Shift                  XK_ISO_Level5_Shift
#define XKB_KEY_ISO_Level5_Latch                  XK_ISO_Level5_Latch
#define XKB_KEY_ISO_Level5_Lock                   XK_ISO_Level5_Lock
#define XKB_KEY_ISO_Left_Tab                      XK_ISO_Left_Tab
#define XKB_KEY_ISO_Move_Line_Up                  XK_ISO_Move_Line_Up
#define XKB_KEY_ISO_Move_Line_Down                XK_ISO_Move_Line_Down
#define XKB_KEY_ISO_Partial_Line_Up               XK_ISO_Partial_Line_Up
#define XKB_KEY_ISO_Partial_Line_Down             XK_ISO_Partial_Line_Down
#define XKB_KEY_ISO_Partial_Space_Left            XK_ISO_Partial_Space_Left
#define XKB_KEY_ISO_Partial_Space_Right           XK_ISO_Partial_Space_Right
#define XKB_KEY_ISO_Set_Margin_Left               XK_ISO_Set_Margin_Left
#define XKB_KEY_ISO_Set_Margin_Right              XK_ISO_Set_Margin_Right
#define XKB_KEY_ISO_Release_Margin_Left           XK_ISO_Release_Margin_Left
#define XKB_KEY_ISO_Release_Margin_Right          XK_ISO_Release_Margin_Right
#define XKB_KEY_ISO_Release_Both_Margins          XK_ISO_Release_Both_Margins
#define XKB_KEY_ISO_Fast_Cursor_Left              XK_ISO_Fast_Cursor_Left
#define XKB_KEY_ISO_Fast_Cursor_Right             XK_ISO_Fast_Cursor_Right
#define XKB_KEY_ISO_Fast_Cursor_Up                XK_ISO_Fast_Cursor_Up
#define XKB_KEY_ISO_Fast_Cursor_Down              XK_ISO_Fast_Cursor_Down
#define XKB_KEY_ISO_Continuous_Underline          XK_ISO_Continuous_Underline
#define XKB_KEY_ISO_Discontinuous_Underline       XK_ISO_Discontinuous_Underline
#define XKB_KEY_ISO_Emphasize                     XK_ISO_Emphasize
#define XKB_KEY_ISO_Center_Object                 XK_ISO_Center_Object
#define XKB_KEY_ISO_Enter                         XK_ISO_Enter
#define XKB_KEY_dead_grave                        XK_dead_grave
#define XKB_KEY_dead_acute                        XK_dead_acute
#define XKB_KEY_dead_circumflex                   XK_dead_circumflex
#define XKB_KEY_dead_tilde                        XK_dead_tilde
#define XKB_KEY_dead_macron                       XK_dead_macron
#define XKB_KEY_dead_breve                        XK_dead_breve
#define XKB_KEY_dead_abovedot                     XK_dead_abovedot
#define XKB_KEY_dead_diaeresis                    XK_dead_diaeresis
#define XKB_KEY_dead_abovering                    XK_dead_abovering
#define XKB_KEY_dead_doubleacute                  XK_dead_doubleacute
#define XKB_KEY_dead_caron                        XK_dead_caron
#define XKB_KEY_dead_cedilla                      XK_dead_cedilla
#define XKB_KEY_dead_ogonek                       XK_dead_ogonek
#define XKB_KEY_dead_iota                         XK_dead_iota
#define XKB_KEY_dead_voiced_sound                 XK_dead_voiced_sound
#define XKB_KEY_dead_semivoiced_sound             XK_dead_semivoiced_sound
#define XKB_KEY_dead_belowdot                     XK_dead_belowdot
#define XKB_KEY_dead_hook                         XK_dead_hook
#define XKB_KEY_dead_horn                         XK_dead_horn
#define XKB_KEY_dead_stroke                       XK_dead_stroke
#define XKB_KEY_dead_abovecomma                   XK_dead_abovecomma
#define XKB_KEY_dead_abovereversedcomma           XK_dead_abovereversedcomma
#define XKB_KEY_dead_doublegrave                  XK_dead_doublegrave
#define XKB_KEY_dead_belowring                    XK_dead_belowring
#define XKB_KEY_dead_belowmacron                  XK_dead_belowmacron
#define XKB_KEY_dead_belowcircumflex              XK_dead_belowcircumflex
#define XKB_KEY_dead_belowtilde                   XK_dead_belowtilde
#define XKB_KEY_dead_belowbreve                   XK_dead_belowbreve
#define XKB_KEY_dead_belowdiaeresis               XK_dead_belowdiaeresis
#define XKB_KEY_dead_invertedbreve                XK_dead_invertedbreve
#define XKB_KEY_dead_belowcomma                   XK_dead_belowcomma
#define XKB_KEY_dead_currency                     XK_dead_currency
#define XKB_KEY_AccessX_Enable                    XK_AccessX_Enable
#define XKB_KEY_AccessX_Feedback_Enable           XK_AccessX_Feedback_Enable
#define XKB_KEY_RepeatKeys_Enable                 XK_RepeatKeys_Enable
#define XKB_KEY_SlowKeys_Enable                   XK_SlowKeys_Enable
#define XKB_KEY_BounceKeys_Enable                 XK_BounceKeys_Enable
#define XKB_KEY_StickyKeys_Enable                 XK_StickyKeys_Enable
#define XKB_KEY_MouseKeys_Enable                  XK_MouseKeys_Enable
#define XKB_KEY_MouseKeys_Accel_Enable            XK_MouseKeys_Accel_Enable
#define XKB_KEY_Overlay1_Enable                   XK_Overlay1_Enable
#define XKB_KEY_Overlay2_Enable                   XK_Overlay2_Enable
#define XKB_KEY_AudibleBell_Enable                XK_AudibleBell_Enable
#define XKB_KEY_dead_a                            XK_dead_a
#define XKB_KEY_dead_A                            XK_dead_A
#define XKB_KEY_dead_e                            XK_dead_e
#define XKB_KEY_dead_E                            XK_dead_E
#define XKB_KEY_dead_i                            XK_dead_i
#define XKB_KEY_dead_I                            XK_dead_I
#define XKB_KEY_dead_o                            XK_dead_o
#define XKB_KEY_dead_O                            XK_dead_O
#define XKB_KEY_dead_u                            XK_dead_u
#define XKB_KEY_dead_U                            XK_dead_U
#define XKB_KEY_dead_small_schwa                  XK_dead_small_schwa
#define XKB_KEY_dead_capital_schwa                XK_dead_capital_schwa
#define XKB_KEY_dead_greek                        XK_dead_greek
#define XKB_KEY_dead_lowline                      XK_dead_lowline
#define XKB_KEY_dead_aboveverticalline            XK_dead_aboveverticalline
#define XKB_KEY_dead_belowverticalline            XK_dead_belowverticalline
#define XKB_KEY_dead_longsolidusoverlay           XK_dead_longsolidusoverlay
#define XKB_KEY_First_Virtual_Screen              XK_First_Virtual_Screen
#define XKB_KEY_Prev_Virtual_Screen               XK_Prev_Virtual_Screen
#define XKB_KEY_Next_Virtual_Screen               XK_Next_Virtual_Screen
#define XKB_KEY_Last_Virtual_Screen               XK_Last_Virtual_Screen
#define XKB_KEY_Terminate_Server                  XK_Terminate_Server
#define XKB_KEY_Pointer_Left                      XK_Pointer_Left
#define XKB_KEY_Pointer_Right                     XK_Pointer_Right
#define XKB_KEY_Pointer_Up                        XK_Pointer_Up
#define XKB_KEY_Pointer_Down                      XK_Pointer_Down
#define XKB_KEY_Pointer_UpLeft                    XK_Pointer_UpLeft
#define XKB_KEY_Pointer_UpRight                   XK_Pointer_UpRight
#define XKB_KEY_Pointer_DownLeft                  XK_Pointer_DownLeft
#define XKB_KEY_Pointer_DownRight                 XK_Pointer_DownRight
#define XKB_KEY_Pointer_Button_Dflt               XK_Pointer_Button_Dflt
#define XKB_KEY_Pointer_Button1                   XK_Pointer_Button1
#define XKB_KEY_Pointer_Button2                   XK_Pointer_Button2
#define XKB_KEY_Pointer_Button3                   XK_Pointer_Button3
#define XKB_KEY_Pointer_Button4                   XK_Pointer_Button4
#define XKB_KEY_Pointer_Button5                   XK_Pointer_Button5
#define XKB_KEY_Pointer_DblClick_Dflt             XK_Pointer_DblClick_Dflt
#define XKB_KEY_Pointer_DblClick1                 XK_Pointer_DblClick1
#define XKB_KEY_Pointer_DblClick2                 XK_Pointer_DblClick2
#define XKB_KEY_Pointer_DblClick3                 XK_Pointer_DblClick3
#define XKB_KEY_Pointer_DblClick4                 XK_Pointer_DblClick4
#define XKB_KEY_Pointer_DblClick5                 XK_Pointer_DblClick5
#define XKB_KEY_Pointer_Drag_Dflt                 XK_Pointer_Drag_Dflt
#define XKB_KEY_Pointer_Drag1                     XK_Pointer_Drag1
#define XKB_KEY_Pointer_Drag2                     XK_Pointer_Drag2
#define XKB_KEY_Pointer_Drag3                     XK_Pointer_Drag3
#define XKB_KEY_Pointer_Drag4                     XK_Pointer_Drag4
#define XKB_KEY_Pointer_EnableKeys                XK_Pointer_EnableKeys
#define XKB_KEY_Pointer_Accelerate                XK_Pointer_Accelerate
#define XKB_KEY_Pointer_DfltBtnNext               XK_Pointer_DfltBtnNext
#define XKB_KEY_Pointer_DfltBtnPrev               XK_Pointer_DfltBtnPrev
#define XKB_KEY_Pointer_Drag5                     XK_Pointer_Drag5
#define XKB_KEY_BackSpace                         XK_BackSpace
#define XKB_KEY_Tab                               XK_Tab
#define XKB_KEY_Linefeed                          XK_Linefeed
#define XKB_KEY_Clear                             XK_Clear
#define XKB_KEY_Return                            XK_Return
#define XKB_KEY_Pause                             XK_Pause
#define XKB_KEY_Scroll_Lock                       XK_Scroll_Lock
#define XKB_KEY_Sys_Req                           XK_Sys_Req
#define XKB_KEY_Escape                            XK_Escape
#define XKB_KEY_Multi_key                         XK_Multi_key
#define XKB_KEY_Kanji                             XK_Kanji
#define XKB_KEY_Muhenkan                          XK_Muhenkan
#define XKB_KEY_Henkan_Mode                       XK_Henkan_Mode
#define XKB_KEY_Romaji                            XK_Romaji
#define XKB_KEY_Hiragana                          XK_Hiragana
#define XKB_KEY_Katakana                          XK_Katakana
#define XKB_KEY_Hiragana_Katakana                 XK_Hiragana_Katakana
#define XKB_KEY_Zenkaku                           XK_Zenkaku
#define XKB_KEY_Hankaku                           XK_Hankaku
#define XKB_KEY_Zenkaku_Hankaku                   XK_Zenkaku_Hankaku
#define XKB_KEY_Touroku                           XK_Touroku
#define XKB_KEY_Massyo                            XK_Massyo
#define XKB_KEY_Kana_Lock                         XK_Kana_Lock
#define XKB_KEY_Kana_Shift                        XK_Kana_Shift
#define XKB_KEY_Eisu_Shift                        XK_Eisu_Shift
#define XKB_KEY_Eisu_toggle                       XK_Eisu_toggle
#define XKB_KEY_Hangul                            XK_Hangul
#define XKB_KEY_Hangul_Start                      XK_Hangul_Start
#define XKB_KEY_Hangul_End                        XK_Hangul_End
#define XKB_KEY_Hangul_Hanja                      XK_Hangul_Hanja
#define XKB_KEY_Hangul_Jamo                       XK_Hangul_Jamo
#define XKB_KEY_Hangul_Romaja                     XK_Hangul_Romaja
#define XKB_KEY_Codeinput                         XK_Codeinput
#define XKB_KEY_Hangul_Jeonja                     XK_Hangul_Jeonja
#define XKB_KEY_Hangul_Banja                      XK_Hangul_Banja
#define XKB_KEY_Hangul_PreHanja                   XK_Hangul_PreHanja
#define XKB_KEY_Hangul_PostHanja                  XK_Hangul_PostHanja
#define XKB_KEY_SingleCandidate                   XK_SingleCandidate
#define XKB_KEY_MultipleCandidate                 XK_MultipleCandidate
#define XKB_KEY_PreviousCandidate                 XK_PreviousCandidate
#define XKB_KEY_Hangul_Special                    XK_Hangul_Special
#define XKB_KEY_Home                              XK_Home
#define XKB_KEY_Left                              XK_Left
#define XKB_KEY_Up                                XK_Up
#define XKB_KEY_Right                             XK_Right
#define XKB_KEY_Down                              XK_Down
#define XKB_KEY_Prior                             XK_Prior
#define XKB_KEY_Next                              XK_Next
#define XKB_KEY_End                               XK_End
#define XKB_KEY_Begin                             XK_Begin
#define XKB_KEY_Select                            XK_Select
#define XKB_KEY_Print                             XK_Print
#define XKB_KEY_Execute                           XK_Execute
#define XKB_KEY_Insert                            XK_Insert
#define XKB_KEY_Undo                              XK_Undo
#define XKB_KEY_Redo                              XK_Redo
#define XKB_KEY_Menu                              XK_Menu
#define XKB_KEY_Find                              XK_Find
#define XKB_KEY_Cancel                            XK_Cancel
#define XKB_KEY_Help                              XK_Help
#define XKB_KEY_Break                             XK_Break
#define XKB_KEY_Mode_switch                       XK_Mode_switch
#define XKB_KEY_Num_Lock                          XK_Num_Lock
#define XKB_KEY_KP_Space                          XK_KP_Space
#define XKB_KEY_KP_Tab                            XK_KP_Tab
#define XKB_KEY_KP_Enter                          XK_KP_Enter
#define XKB_KEY_KP_F1                             XK_KP_F1
#define XKB_KEY_KP_F2                             XK_KP_F2
#define XKB_KEY_KP_F3                             XK_KP_F3
#define XKB_KEY_KP_F4                             XK_KP_F4
#define XKB_KEY_KP_Home                           XK_KP_Home
#define XKB_KEY_KP_Left                           XK_KP_Left
#define XKB_KEY_KP_Up                             XK_KP_Up
#define XKB_KEY_KP_Right                          XK_KP_Right
#define XKB_KEY_KP_Down                           XK_KP_Down
#define XKB_KEY_KP_Prior                          XK_KP_Prior
#define XKB_KEY_KP_Next                           XK_KP_Next
#define XKB_KEY_KP_End                            XK_KP_End
#define XKB_KEY_KP_Begin                          XK_KP_Begin
#define XKB_KEY_KP_Insert                         XK_KP_Insert
#define XKB_KEY_KP_Delete                         XK_KP_Delete
#define XKB_KEY_KP_Multiply                       XK_KP_Multiply
#define XKB_KEY_KP_Add                            XK_KP_Add
#define XKB_KEY_KP_Separator                      XK_KP_Separator
#define XKB_KEY_KP_Subtract                       XK_KP_Subtract
#define XKB_KEY_KP_Decimal                        XK_KP_Decimal
#define XKB_KEY_KP_Divide                         XK_KP_Divide
#define XKB_KEY_KP_0                              XK_KP_0
#define XKB_KEY_KP_1                              XK_KP_1
#define XKB_KEY_KP_2                              XK_KP_2
#define XKB_KEY_KP_3                              XK_KP_3
#define XKB_KEY_KP_4                              XK_KP_4
#define XKB_KEY_KP_5                              XK_KP_5
#define XKB_KEY_KP_6                              XK_KP_6
#define XKB_KEY_KP_7                              XK_KP_7
#define XKB_KEY_KP_8                              XK_KP_8
#define XKB_KEY_KP_9                              XK_KP_9
#define XKB_KEY_KP_Equal                          XK_KP_Equal
#define XKB_KEY_F1                                XK_F1
#define XKB_KEY_F2                                XK_F2
#define XKB_KEY_F3                                XK_F3
#define XKB_KEY_F4                                XK_F4
#define XKB_KEY_F5                                XK_F5
#define XKB_KEY_F6                                XK_F6
#define XKB_KEY_F7                                XK_F7
#define XKB_KEY_F8                                XK_F8
#define XKB_KEY_F9                                XK_F9
#define XKB_KEY_F10                               XK_F10
#define XKB_KEY_F11                               XK_F11
#define XKB_KEY_F12                               XK_F12
#define XKB_KEY_F13                               XK_F13
#define XKB_KEY_F14                               XK_F14
#define XKB_KEY_F15                               XK_F15
#define XKB_KEY_F16                               XK_F16
#define XKB_KEY_F17                               XK_F17
#define XKB_KEY_F18                               XK_F18
#define XKB_KEY_F19                               XK_F19
#define XKB_KEY_F20                               XK_F20
#define XKB_KEY_F21                               XK_F21
#define XKB_KEY_F22                               XK_F22
#define XKB_KEY_F23                               XK_F23
#define XKB_KEY_F24                               XK_F24
#define XKB_KEY_F25                               XK_F25
#define XKB_KEY_F26                               XK_F26
#define XKB_KEY_F27                               XK_F27
#define XKB_KEY_F28                               XK_F28
#define XKB_KEY_F29                               XK_F29
#define XKB_KEY_F30                               XK_F30
#define XKB_KEY_F31                               XK_F31
#define XKB_KEY_F32                               XK_F32
#define XKB_KEY_F33                               XK_F33
#define XKB_KEY_F34                               XK_F34
#define XKB_KEY_F35                               XK_F35
#define XKB_KEY_Shift_L                           XK_Shift_L
#define XKB_KEY_Shift_R                           XK_Shift_R
#define XKB_KEY_Control_L                         XK_Control_L
#define XKB_KEY_Control_R                         XK_Control_R
#define XKB_KEY_Caps_Lock                         XK_Caps_Lock
#define XKB_KEY_Shift_Lock                        XK_Shift_Lock
#define XKB_KEY_Meta_L                            XK_Meta_L
#define XKB_KEY_Meta_R                            XK_Meta_R
#define XKB_KEY_Alt_L                             XK_Alt_L
#define XKB_KEY_Alt_R                             XK_Alt_R
#define XKB_KEY_Super_L                           XK_Super_L
#define XKB_KEY_Super_R                           XK_Super_R
#define XKB_KEY_Hyper_L                           XK_Hyper_L
#define XKB_KEY_Hyper_R                           XK_Hyper_R
#define XKB_KEY_braille_dot_1                     XK_braille_dot_1
#define XKB_KEY_braille_dot_2                     XK_braille_dot_2
#define XKB_KEY_braille_dot_3                     XK_braille_dot_3
#define XKB_KEY_braille_dot_4                     XK_braille_dot_4
#define XKB_KEY_braille_dot_5                     XK_braille_dot_5
#define XKB_KEY_braille_dot_6                     XK_braille_dot_6
#define XKB_KEY_braille_dot_7                     XK_braille_dot_7
#define XKB_KEY_braille_dot_8                     XK_braille_dot_8
#define XKB_KEY_braille_dot_9                     XK_braille_dot_9
#define XKB_KEY_braille_dot_10                    XK_braille_dot_10
#define XKB_KEY_Delete                            XK_Delete
#define XKB_KEY_VoidSymbol                        XK_VoidSymbol
#define XKB_KEY_SunProps                          SunXK_Props
#define XKB_KEY_SunFront                          SunXK_Front
#define XKB_KEY_SunCopy                           SunXK_Copy
#define XKB_KEY_SunOpen                           SunXK_Open
#define XKB_KEY_SunPaste                          SunXK_Paste
#define XKB_KEY_SunCut                            SunXK_Cut
#define XKB_KEY_XF86Switch_VT_1                   XF86XK_Switch_VT_1
#define XKB_KEY_XF86Switch_VT_2                   XF86XK_Switch_VT_2
#define XKB_KEY_XF86Switch_VT_3                   XF86XK_Switch_VT_3
#define XKB_KEY_XF86Switch_VT_4                   XF86XK_Switch_VT_4
#define XKB_KEY_XF86Switch_VT_5                   XF86XK_Switch_VT_5
#define XKB_KEY_XF86Switch_VT_6                   XF86XK_Switch_VT_6
#define XKB_KEY_XF86Switch_VT_7                   XF86XK_Switch_VT_7
#define XKB_KEY_XF86Switch_VT_8                   XF86XK_Switch_VT_8
#define XKB_KEY_XF86Switch_VT_9                   XF86XK_Switch_VT_9
#define XKB_KEY_XF86Switch_VT_10                  XF86XK_Switch_VT_10
#define XKB_KEY_XF86Switch_VT_11                  XF86XK_Switch_VT_11
#define XKB_KEY_XF86Switch_VT_12                  XF86XK_Switch_VT_12
#define XKB_KEY_XF86Ungrab                        XF86XK_Ungrab
#define XKB_KEY_XF86ClearGrab                     XF86XK_ClearGrab
#define XKB_KEY_XF86Next_VMode                    XF86XK_Next_VMode
#define XKB_KEY_XF86Prev_VMode                    XF86XK_Prev_VMode
#define XKB_KEY_XF86LogWindowTree                 XF86XK_LogWindowTree
#define XKB_KEY_XF86LogGrabInfo                   XF86XK_LogGrabInfo
#define XKB_KEY_XF86ModeLock                      XF86XK_ModeLock
#define XKB_KEY_XF86MonBrightnessUp               XF86XK_MonBrightnessUp
#define XKB_KEY_XF86MonBrightnessDown             XF86XK_MonBrightnessDown
#define XKB_KEY_XF86KbdLightOnOff                 XF86XK_KbdLightOnOff
#define XKB_KEY_XF86KbdBrightnessUp               XF86XK_KbdBrightnessUp
#define XKB_KEY_XF86KbdBrightnessDown             XF86XK_KbdBrightnessDown
#define XKB_KEY_XF86Standby                       XF86XK_Standby
#define XKB_KEY_XF86AudioLowerVolume              XF86XK_AudioLowerVolume
#define XKB_KEY_XF86AudioMute                     XF86XK_AudioMute
#define XKB_KEY_XF86AudioRaiseVolume              XF86XK_AudioRaiseVolume
#define XKB_KEY_XF86AudioPlay                     XF86XK_AudioPlay
#define XKB_KEY_XF86AudioStop                     XF86XK_AudioStop
#define XKB_KEY_XF86AudioPrev                     XF86XK_AudioPrev
#define XKB_KEY_XF86AudioNext                     XF86XK_AudioNext
#define XKB_KEY_XF86HomePage                      XF86XK_HomePage
#define XKB_KEY_XF86Mail                          XF86XK_Mail
#define XKB_KEY_XF86Start                         XF86XK_Start
#define XKB_KEY_XF86Search                        XF86XK_Search
#define XKB_KEY_XF86AudioRecord                   XF86XK_AudioRecord
#define XKB_KEY_XF86Calculator                    XF86XK_Calculator
#define XKB_KEY_XF86Memo                          XF86XK_Memo
#define XKB_KEY_XF86ToDoList                      XF86XK_ToDoList
#define XKB_KEY_XF86Calendar                      XF86XK_Calendar
#define XKB_KEY_XF86PowerDown                     XF86XK_PowerDown
#define XKB_KEY_XF86ContrastAdjust                XF86XK_ContrastAdjust
#define XKB_KEY_XF86RockerUp                      XF86XK_RockerUp
#define XKB_KEY_XF86RockerDown                    XF86XK_RockerDown
#define XKB_KEY_XF86RockerEnter                   XF86XK_RockerEnter
#define XKB_KEY_XF86Back                          XF86XK_Back
#define XKB_KEY_XF86Forward                       XF86XK_Forward
#define XKB_KEY_XF86Stop                          XF86XK_Stop
#define XKB_KEY_XF86Refresh                       XF86XK_Refresh
#define XKB_KEY_XF86PowerOff                      XF86XK_PowerOff
#define XKB_KEY_XF86WakeUp                        XF86XK_WakeUp
#define XKB_KEY_XF86Eject                         XF86XK_Eject
#define XKB_KEY_XF86ScreenSaver                   XF86XK_ScreenSaver
#define XKB_KEY_XF86WWW                           XF86XK_WWW
#define XKB_KEY_XF86Sleep                         XF86XK_Sleep
#define XKB_KEY_XF86Favorites                     XF86XK_Favorites
#define XKB_KEY_XF86AudioPause                    XF86XK_AudioPause
#define XKB_KEY_XF86AudioMedia                    XF86XK_AudioMedia
#define XKB_KEY_XF86MyComputer                    XF86XK_MyComputer
#define XKB_KEY_XF86VendorHome                    XF86XK_VendorHome
#define XKB_KEY_XF86LightBulb                     XF86XK_LightBulb
#define XKB_KEY_XF86Shop                          XF86XK_Shop
#define XKB_KEY_XF86History                       XF86XK_History
#define XKB_KEY_XF86OpenURL                       XF86XK_OpenURL
#define XKB_KEY_XF86AddFavorite                   XF86XK_AddFavorite
#define XKB_KEY_XF86HotLinks                      XF86XK_HotLinks
#define XKB_KEY_XF86BrightnessAdjust              XF86XK_BrightnessAdjust
#define XKB_KEY_XF86Finance                       XF86XK_Finance
#define XKB_KEY_XF86Community                     XF86XK_Community
#define XKB_KEY_XF86AudioRewind                   XF86XK_AudioRewind
#define XKB_KEY_XF86BackForward                   XF86XK_BackForward
#define XKB_KEY_XF86Launch0                       XF86XK_Launch0
#define XKB_KEY_XF86Launch1                       XF86XK_Launch1
#define XKB_KEY_XF86Launch2                       XF86XK_Launch2
#define XKB_KEY_XF86Launch3                       XF86XK_Launch3
#define XKB_KEY_XF86Launch4                       XF86XK_Launch4
#define XKB_KEY_XF86Launch5                       XF86XK_Launch5
#define XKB_KEY_XF86Launch6                       XF86XK_Launch6
#define XKB_KEY_XF86Launch7                       XF86XK_Launch7
#define XKB_KEY_XF86Launch8                       XF86XK_Launch8
#define XKB_KEY_XF86Launch9                       XF86XK_Launch9
#define XKB_KEY_XF86LaunchA                       XF86XK_LaunchA
#define XKB_KEY_XF86LaunchB                       XF86XK_LaunchB
#define XKB_KEY_XF86LaunchC                       XF86XK_LaunchC
#define XKB_KEY_XF86LaunchD                       XF86XK_LaunchD
#define XKB_KEY_XF86LaunchE                       XF86XK_LaunchE
#define XKB_KEY_XF86LaunchF                       XF86XK_LaunchF
#define XKB_KEY_XF86ApplicationLeft               XF86XK_ApplicationLeft
#define XKB_KEY_XF86ApplicationRight              XF86XK_ApplicationRight
#define XKB_KEY_XF86Book                          XF86XK_Book
#define XKB_KEY_XF86CD                            XF86XK_CD
#define XKB_KEY_XF86Calculater                    XF86XK_Calculater
#define XKB_KEY_XF86Clear                         XF86XK_Clear
#define XKB_KEY_XF86Close                         XF86XK_Close
#define XKB_KEY_XF86Copy                          XF86XK_Copy
#define XKB_KEY_XF86Cut                           XF86XK_Cut
#define XKB_KEY_XF86Display                       XF86XK_Display
#define XKB_KEY_XF86DOS                           XF86XK_DOS
#define XKB_KEY_XF86Documents                     XF86XK_Documents
#define XKB_KEY_XF86Excel                         XF86XK_Excel
#define XKB_KEY_XF86Explorer                      XF86XK_Explorer
#define XKB_KEY_XF86Game                          XF86XK_Game
#define XKB_KEY_XF86Go                            XF86XK_Go
#define XKB_KEY_XF86iTouch                        XF86XK_iTouch
#define XKB_KEY_XF86LogOff                        XF86XK_LogOff
#define XKB_KEY_XF86Market                        XF86XK_Market
#define XKB_KEY_XF86Meeting                       XF86XK_Meeting
#define XKB_KEY_XF86MenuKB                        XF86XK_MenuKB
#define XKB_KEY_XF86MenuPB                        XF86XK_MenuPB
#define XKB_KEY_XF86MySites                       XF86XK_MySites
#define XKB_KEY_XF86New                           XF86XK_New
#define XKB_KEY_XF86News                          XF86XK_News
#define XKB_KEY_XF86OfficeHome                    XF86XK_OfficeHome
#define XKB_KEY_XF86Open                          XF86XK_Open
#define XKB_KEY_XF86Option                        XF86XK_Option
#define XKB_KEY_XF86Paste                         XF86XK_Paste
#define XKB_KEY_XF86Phone                         XF86XK_Phone
#define XKB_KEY_XF86Q                             XF86XK_Q
#define XKB_KEY_XF86Reply                         XF86XK_Reply
#define XKB_KEY_XF86Reload                        XF86XK_Reload
#define XKB_KEY_XF86RotateWindows                 XF86XK_RotateWindows
#define XKB_KEY_XF86RotationPB                    XF86XK_RotationPB
#define XKB_KEY_XF86RotationKB                    XF86XK_RotationKB
#define XKB_KEY_XF86Save                          XF86XK_Save
#define XKB_KEY_XF86ScrollUp                      XF86XK_ScrollUp
#define XKB_KEY_XF86ScrollDown                    XF86XK_ScrollDown
#define XKB_KEY_XF86ScrollClick                   XF86XK_ScrollClick
#define XKB_KEY_XF86Send                          XF86XK_Send
#define XKB_KEY_XF86Spell                         XF86XK_Spell
#define XKB_KEY_XF86SplitScreen                   XF86XK_SplitScreen
#define XKB_KEY_XF86Support                       XF86XK_Support
#define XKB_KEY_XF86TaskPane                      XF86XK_TaskPane
#define XKB_KEY_XF86Terminal                      XF86XK_Terminal
#define XKB_KEY_XF86Tools                         XF86XK_Tools
#define XKB_KEY_XF86Travel                        XF86XK_Travel
#define XKB_KEY_XF86UserPB                        XF86XK_UserPB
#define XKB_KEY_XF86User1KB                       XF86XK_User1KB
#define XKB_KEY_XF86User2KB                       XF86XK_User2KB
#define XKB_KEY_XF86Video                         XF86XK_Video
#define XKB_KEY_XF86WheelButton                   XF86XK_WheelButton
#define XKB_KEY_XF86Word                          XF86XK_Word
#define XKB_KEY_XF86Xfer                          XF86XK_Xfer
#define XKB_KEY_XF86ZoomIn                        XF86XK_ZoomIn
#define XKB_KEY_XF86ZoomOut                       XF86XK_ZoomOut
#define XKB_KEY_XF86Away                          XF86XK_Away
#define XKB_KEY_XF86Messenger                     XF86XK_Messenger
#define XKB_KEY_XF86WebCam                        XF86XK_WebCam
#define XKB_KEY_XF86MailForward                   XF86XK_MailForward
#define XKB_KEY_XF86Pictures                      XF86XK_Pictures
#define XKB_KEY_XF86Music                         XF86XK_Music
#define XKB_KEY_XF86Battery                       XF86XK_Battery
#define XKB_KEY_XF86Bluetooth                     XF86XK_Bluetooth
#define XKB_KEY_XF86WLAN                          XF86XK_WLAN
#define XKB_KEY_XF86UWB                           XF86XK_UWB
#define XKB_KEY_XF86AudioForward                  XF86XK_AudioForward
#define XKB_KEY_XF86AudioRepeat                   XF86XK_AudioRepeat
#define XKB_KEY_XF86AudioRandomPlay               XF86XK_AudioRandomPlay
#define XKB_KEY_XF86Subtitle                      XF86XK_Subtitle
#define XKB_KEY_XF86AudioCycleTrack               XF86XK_AudioCycleTrack
#define XKB_KEY_XF86CycleAngle                    XF86XK_CycleAngle
#define XKB_KEY_XF86FrameBack                     XF86XK_FrameBack
#define XKB_KEY_XF86FrameForward                  XF86XK_FrameForward
#define XKB_KEY_XF86Time                          XF86XK_Time
#define XKB_KEY_XF86Select                        XF86XK_Select
#define XKB_KEY_XF86View                          XF86XK_View
#define XKB_KEY_XF86TopMenu                       XF86XK_TopMenu
#define XKB_KEY_XF86Red                           XF86XK_Red
#define XKB_KEY_XF86Green                         XF86XK_Green
#define XKB_KEY_XF86Yellow                        XF86XK_Yellow
#define XKB_KEY_XF86Blue                          XF86XK_Blue
#define XKB_KEY_XF86Suspend                       XF86XK_Suspend
#define XKB_KEY_XF86Hibernate                     XF86XK_Hibernate
#define XKB_KEY_XF86TouchpadToggle                XF86XK_TouchpadToggle
#define XKB_KEY_XF86TouchpadOn                    XF86XK_TouchpadOn
#define XKB_KEY_XF86TouchpadOff                   XF86XK_TouchpadOff
#define XKB_KEY_XF86AudioMicMute                  XF86XK_AudioMicMute

#endif

#endif  // UI_EVENTS_KEYCODES_XKB_KEYSYM_H_

