/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 * Copyright (c) 2010, Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef THIRD_PARTY_BLINK_RENDERER_PLATFORM_WTF_TYPED_ARRAYS_INTEGRAL_TYPED_ARRAY_BASE_H_
#define THIRD_PARTY_BLINK_RENDERER_PLATFORM_WTF_TYPED_ARRAYS_INTEGRAL_TYPED_ARRAY_BASE_H_

#include <limits>
#include "third_party/blink/renderer/platform/wtf/math_extras.h"
#include "third_party/blink/renderer/platform/wtf/typed_arrays/typed_array_base.h"

namespace WTF {

// Base class for all WebGL<T>Array types holding integral
// (non-floating-point) values.
template <typename T>
class IntegralTypedArrayBase : public TypedArrayBase<T> {
 public:
  void Set(unsigned index, double value) {
    if (index >= TypedArrayBase<T>::length_)
      return;
    if (std::isnan(value))  // Clamp NaN to 0
      value = 0;
    // The double cast is necessary to get the correct wrapping
    // for out-of-range values with Int32Array and Uint32Array.
    TypedArrayBase<T>::Data()[index] =
        static_cast<T>(static_cast<int64_t>(value));
  }

 protected:
  IntegralTypedArrayBase(scoped_refptr<ArrayBuffer> buffer,
                         unsigned byte_offset,
                         unsigned length)
      : TypedArrayBase<T>(std::move(buffer), byte_offset, length) {}
};

}  // namespace WTF

using WTF::IntegralTypedArrayBase;

#endif  // THIRD_PARTY_BLINK_RENDERER_PLATFORM_WTF_TYPED_ARRAYS_INTEGRAL_TYPED_ARRAY_BASE_H_
