/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;

public class ClassNameParser
implements StringParser {
    private static final char[] INTERNAL_PRIMITIVE_TYPES = new char[]{'V', 'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D'};

    @Override
    public StringMatcher parse(String string) {
        int n;
        StringMatcher stringMatcher = new EmptyStringMatcher();
        for (n = 0; n < string.length(); ++n) {
            if (string.regionMatches(n, "L///;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                stringMatcher = new OrMatcher(this.parse(string.substring(n + 5)), this.createAnyTypeMatcher(settableMatcher));
                settableMatcher.setMatcher(stringMatcher);
                break;
            }
            if (string.regionMatches(n, "L***;", 0, 5)) {
                stringMatcher = this.createAnyTypeMatcher(this.parse(string.substring(n + 5)));
                break;
            }
            if (string.regionMatches(n, "**", 0, 2)) {
                stringMatcher = new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, this.parse(string.substring(n + 2)));
                break;
            }
            if (string.charAt(n) == '*') {
                stringMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 0, Integer.MAX_VALUE, this.parse(string.substring(n + 1)));
                break;
            }
            if (string.charAt(n) == '?') {
                stringMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 1, 1, this.parse(string.substring(n + 1)));
                break;
            }
            if (string.charAt(n) != '%') continue;
            stringMatcher = new VariableStringMatcher(INTERNAL_PRIMITIVE_TYPES, null, 1, 1, this.parse(string.substring(n + 1)));
            break;
        }
        return n != 0 ? new FixedStringMatcher(string.substring(0, n), stringMatcher) : stringMatcher;
    }

    private VariableStringMatcher createAnyTypeMatcher(StringMatcher stringMatcher) {
        return new VariableStringMatcher(new char[]{'['}, null, 0, 255, new OrMatcher(new VariableStringMatcher(INTERNAL_PRIMITIVE_TYPES, null, 1, 1, stringMatcher), new VariableStringMatcher(new char[]{'L'}, null, 1, 1, new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, new VariableStringMatcher(new char[]{';'}, null, 1, 1, stringMatcher)))));
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Regular expression [" + stringArray[0] + "]");
            ClassNameParser classNameParser = new ClassNameParser();
            StringMatcher stringMatcher = classNameParser.parse(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + stringMatcher.matches(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

