/****************************************************************************
**
** Copyright (C) 2014 BogDan Vatra <bogdan@kde.org>
** Contact: http://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QANDROIDEVENTDISPATCHER_H
#define QANDROIDEVENTDISPATCHER_H

#include <QtCore/QMutex>
#include <QtCore/QSemaphore>
#include <QtPlatformSupport/private/qunixeventdispatcher_qpa_p.h>

class QAndroidEventDispatcher : public QUnixEventDispatcherQPA
{
    Q_OBJECT
public:
    explicit QAndroidEventDispatcher(QObject *parent = 0);
    ~QAndroidEventDispatcher();
    void start();
    void stop();

    void goingToStop(bool stop);

protected:
    int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
               timespec *timeout) override;

    bool processEvents(QEventLoop::ProcessEventsFlags flags) override;

private:
    QAtomicInt m_stopRequest;
    QAtomicInt m_goingToStop;
    QSemaphore m_semaphore;
};

class QAndroidEventDispatcherStopper
{
public:
    static QAndroidEventDispatcherStopper *instance();
    static bool stopped() {return !instance()->started; }
    void startAll();
    void stopAll();
    void addEventDispatcher(QAndroidEventDispatcher *dispatcher);
    void removeEventDispatcher(QAndroidEventDispatcher *dispatcher);
    void goingToStop(bool stop);

private:
    QMutex m_mutex;
    bool started = true;
    QVector<QAndroidEventDispatcher *> m_dispatchers;
};


#endif // QANDROIDEVENTDISPATCHER_H
