/* -*- mode: c++; indent-tabs-mode: nil -*- */
/*
    ql_oracle.qpp

    Oracle OCI Interface to Qore DBI layer

    Qore Programming Language

    Copyright 2003 - 2022 Qore Technologies, s.r.o.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "oracle.h"
#include "oracle-module.h"
# 30 "ql_oracle.qpp"
# 35 "ql_oracle.qpp"
# 64 "ql_oracle.qpp"
# 86 "ql_oracle.qpp"
# 105 "ql_oracle.qpp"
# 127 "ql_oracle.qpp"
// hash bindInOut(auto value, *string type) {}
static QoreValue f_bindInOut_VANs(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    QoreValue value = get_param_value(args, 0);
    const QoreStringNode* type = get_param_value(args, 1).get<const QoreStringNode>();
# 56 "ql_oracle.qpp"
    QoreHashNode *h = new QoreHashNode;
    if (type)
       h->setKeyValue("type", type->refSelf(), xsink);
    h->setKeyValue("value", value.refSelf(), xsink);
    return h;
}

// hash bindOracleCollection(string tname, list<auto> values) {}
static QoreValue f_bindOracleCollection_VsC10list_auto_(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* tname = HARD_QORE_VALUE_STRING(args, 0);
    const QoreListNode* values = HARD_QORE_VALUE_LIST(args, 1);
# 119 "ql_oracle.qpp"
    QoreHashNode * h = new QoreHashNode;
    h->setKeyValue("type", new QoreStringNode(ORACLE_COLLECTION), xsink);
    h->setKeyValue("^oratype^", tname->refSelf(), xsink);
    h->setKeyValue("^values^", values->refSelf(), xsink);
    return h;
}

// hash bindOracleObject(string tname, hash<auto> values) {}
static QoreValue f_bindOracleObject_VsC10hash_auto_(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* tname = HARD_QORE_VALUE_STRING(args, 0);
    const QoreHashNode* values = HARD_QORE_VALUE_HASH(args, 1);
# 78 "ql_oracle.qpp"
    QoreHashNode* h = new QoreHashNode;
    h->setKeyValue("type", new QoreStringNode(ORACLE_OBJECT), xsink);
    h->setKeyValue("^oratype^", tname->refSelf(), xsink);
    h->setKeyValue("^values^", values->refSelf(), xsink);
    return h;
}

// hash placeholderOracleCollection(string tname) {}
static QoreValue f_placeholderOracleCollection_Vs(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* tname = HARD_QORE_VALUE_STRING(args, 0);
# 139 "ql_oracle.qpp"
    QoreHashNode * h = new QoreHashNode;
    h->setKeyValue("type", new QoreStringNode(ORACLE_COLLECTION), xsink);
    h->setKeyValue("value", tname->refSelf(), xsink);
    return h;
}

// hash placeholderOracleObject(string tname) {}
static QoreValue f_placeholderOracleObject_Vs(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* tname = HARD_QORE_VALUE_STRING(args, 0);
# 98 "ql_oracle.qpp"
    QoreHashNode* h = new QoreHashNode;
    h->setKeyValue("type", new QoreStringNode(ORACLE_OBJECT), xsink);
    h->setKeyValue("value", tname->refSelf(), xsink);
    return h;
}


DLLLOCAL void init_oracle_functions(QoreNamespace& ns) {
    // hash bindInOut(auto value, *string type) {}
    ns.addBuiltinVariant("bindInOut", (q_func_n_t)f_bindInOut_VANs, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo, 2, autoTypeInfo, QORE_PARAM_NO_ARG, "value", stringOrNothingTypeInfo, QORE_PARAM_NO_ARG, "type");
    // hash bindOracleCollection(string tname, list<auto> values) {}
    ns.addBuiltinVariant("bindOracleCollection", (q_func_n_t)f_bindOracleCollection_VsC10list_auto_, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo, 2, stringTypeInfo, QORE_PARAM_NO_ARG, "tname", autoListTypeInfo, QORE_PARAM_NO_ARG, "values");
    // hash bindOracleObject(string tname, hash<auto> values) {}
    ns.addBuiltinVariant("bindOracleObject", (q_func_n_t)f_bindOracleObject_VsC10hash_auto_, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo, 2, stringTypeInfo, QORE_PARAM_NO_ARG, "tname", autoHashTypeInfo, QORE_PARAM_NO_ARG, "values");
    // hash placeholderOracleCollection(string tname) {}
    ns.addBuiltinVariant("placeholderOracleCollection", (q_func_n_t)f_placeholderOracleCollection_Vs, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "tname");
    // hash placeholderOracleObject(string tname) {}
    ns.addBuiltinVariant("placeholderOracleObject", (q_func_n_t)f_placeholderOracleObject_Vs, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "tname");

}
