/* -*- mode: c++; indent-tabs-mode: nil -*- */
/*
  QC_LdapClient.qpp
  
  Qore Programming Language
  
  Copyright 2003 - 2012 David Nichols

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "openldap-module.h"

#include "QoreLdapClient.h"

QoreLdapParseResultHelper::QoreLdapParseResultHelper(const char *n_meth, const char* n_f, QoreLdapClient* n_l, LDAPMessage* msg, ExceptionSink* xs) : meth(n_meth), f(n_f), l(n_l), xsink(xs), err(0), matched(0), text(0), refs(0) {
   l->checkLdapError(meth, f, ldap_parse_result(l->ldp, msg, &err, &matched, &text, &refs, 0, 1), xsink);
}

int QoreLdapParseResultHelper::check() const {
   if (err == LDAP_SUCCESS)
      return 0;

   QoreStringNode* desc = l->getErrorText(meth, f, err);
   if (text)
      desc->sprintf(": %s", text);
   if (matched)
      desc->sprintf(" (matched: '%s')", matched);
   //if (refs) { }
   
   xsink->raiseException("LDAP-RESULT-ERROR", desc);
   return -1;
}

class LdapClientHolder {
protected:
   QoreLdapClient* ldap;
   ExceptionSink* xsink;

public:
   DLLLOCAL LdapClientHolder(QoreLdapClient* l, ExceptionSink* xs) : ldap(l), xsink(xs) {
   }

   DLLLOCAL ~LdapClientHolder() {
      if (ldap) {
         ldap->destructor(xsink);
         ldap->deref(xsink);
      }
   }

   DLLLOCAL QoreLdapClient* release() {
      QoreLdapClient* l = ldap;
      ldap = 0;
      return l;
   }
};
/* Qore class OpenLdap::LdapClient */

qore_classid_t CID_LDAPCLIENT;
QoreClass* QC_LDAPCLIENT;

// nothing LdapClient::add(string dn, hash attrs, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_add_VsVhNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreHashNode* attrs = HARD_QORE_HASH(args, 1);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 2));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 269 "QC_LdapClient.qpp"
ldap->add(xsink, dn, attrs, timeout_ms);
   return 0;
}

// nothing LdapClient::bind(hash bind, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_bind_VhNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreHashNode* bind = HARD_QORE_HASH(args, 0);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 1));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 198 "QC_LdapClient.qpp"
ldap->bind(xsink, *bind, timeout_ms);
   return 0;
}

// bool LdapClient::compare(string dn, string attr, softlist vals, *timeout timeout_ms){}
static bool LdapClient_compare_VsVsvlNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreStringNode* attr = HARD_QORE_STRING(args, 1);
   const QoreListNode* vals = HARD_QORE_LIST(args, 2);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 3));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 335 "QC_LdapClient.qpp"
return ldap->compare(xsink, dn, attr, vals, timeout_ms);
}

// LdapClient::constructor(string uri, *hash options) {}
static void LdapClient_constructor_VsNh(QoreObject* self, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* uri = HARD_QORE_STRING(args, 0);
   const QoreHashNode* options = reinterpret_cast<const QoreHashNode*>(get_param(args, 1));
# 146 "QC_LdapClient.qpp"
LdapClientHolder ldap(new QoreLdapClient(uri, options, xsink), xsink);
   if (!*xsink)
      self->setPrivate(CID_LDAPCLIENT, ldap.release());
}

// LdapClient::copy() {}
static void LdapClient_copy(QoreObject* self, QoreObject* old, QoreLdapClient* ldap, ExceptionSink* xsink) {
# 172 "QC_LdapClient.qpp"
LdapClientHolder ldp(new QoreLdapClient(*ldap, xsink), xsink);
   if (!*xsink)
      self->setPrivate(CID_LDAPCLIENT, ldp.release());
}

// nothing LdapClient::del(string dn, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_del_VsNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 1));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 312 "QC_LdapClient.qpp"
ldap->del(xsink, dn, timeout_ms);
   return 0;
}

// LdapClient::destructor() {}
static void LdapClient_destructor(QoreObject* self, QoreLdapClient* ldap, ExceptionSink* xsink) {
# 158 "QC_LdapClient.qpp"
ldap->destructor(xsink);
   ldap->deref(xsink);
}

// string LdapClient::getUri(){}
static AbstractQoreNode* LdapClient_getUri(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
# 390 "QC_LdapClient.qpp"
return ldap->getUriStr();
}

// bool LdapClient::isSecure(){}
static bool LdapClient_isSecure(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
# 404 "QC_LdapClient.qpp"
return ldap->isSecure(xsink);
}

// nothing LdapClient::modify(string dn, softlist mods, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_modify_VsvlNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreListNode* mods = HARD_QORE_LIST(args, 1);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 2));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 293 "QC_LdapClient.qpp"
ldap->modify(xsink, dn, mods, timeout_ms);
   return 0;
}

// nothing LdapClient::passwd(string dn, string oldpwd, string newpwd, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_passwd_VsVsVsNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreStringNode* oldpwd = HARD_QORE_STRING(args, 1);
   const QoreStringNode* newpwd = HARD_QORE_STRING(args, 2);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 3));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 378 "QC_LdapClient.qpp"
ldap->passwd(xsink, dn, oldpwd, newpwd, timeout_ms);
   return 0;
}

// nothing LdapClient::rename(string dn, string newrdn, string newparent, softbool deleteoldrdn = True, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_rename_VsVsVsvbNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreStringNode* dn = HARD_QORE_STRING(args, 0);
   const QoreStringNode* newrdn = HARD_QORE_STRING(args, 1);
   const QoreStringNode* newparent = HARD_QORE_STRING(args, 2);
   bool deleteoldrdn = HARD_QORE_BOOL(args, 3);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 4));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 357 "QC_LdapClient.qpp"
ldap->rename(xsink, dn, newrdn, newparent, deleteoldrdn, timeout_ms);
   return 0;
}

// hash LdapClient::search(hash h, *timeout timeout_ms){}
static AbstractQoreNode* LdapClient_search_VhNt(QoreObject* self, QoreLdapClient* ldap, const QoreListNode* args, ExceptionSink* xsink) {
   const QoreHashNode* h = HARD_QORE_HASH(args, 0);
   const QoreBigIntNode* tmp_timeout_ms = reinterpret_cast<const QoreBigIntNode*>(get_param(args, 1));
   int64 timeout_ms = tmp_timeout_ms ? tmp_timeout_ms->val : 0;
# 223 "QC_LdapClient.qpp"
const QoreStringNode* base = check_hash_key<QoreStringNode>(xsink, *h, "base", "LDAP-SEARCH-ERROR");
   const QoreStringNode* filter = check_hash_key<QoreStringNode>(xsink, *h, "filter", "LDAP-SEARCH-ERROR");
   const AbstractQoreNode* n = h->getKeyValue("attributes");
   ReferenceHolder<QoreListNode> attrl(xsink);
   if (n) {
      if (n->getType() == NT_STRING) {
         attrl = new QoreListNode;
         attrl->push(n->refSelf());
      }
      else if (n->getType() == NT_LIST)
         attrl = reinterpret_cast<const QoreListNode*>(n)->listRefSelf();
      else {
         xsink->raiseException("LDAPCLIENT-SEARCH-ERROR", "the 'attributes' key of the search hash contains type '%s' (expecting 'list' or 'string')", get_type_name(n));
         return 0;
      }
   }

   // get scope
   n = h->getKeyValue("scope");
   int scope = n ? n->getAsInt() : 0;
   if (!scope)
      scope = LDAP_SCOPE_SUBTREE;
   
   return ldap->search(xsink, base, scope, filter, *attrl, false, timeout_ms);
}

// static nothing LdapClient::getInfo(){}
static AbstractQoreNode* static_LdapClient_getInfo(const QoreListNode* args, ExceptionSink* xsink) {
# 417 "QC_LdapClient.qpp"
return QoreLdapClient::getInfo();
}

DLLLOCAL QoreClass* initLdapClientClass(QoreNamespace& ns) {
   QC_LDAPCLIENT = new QoreClass("LdapClient", QDOM_NETWORK);
   CID_LDAPCLIENT = QC_LDAPCLIENT->getID();

   // nothing LdapClient::add(string dn, hash attrs, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("add", (q_method_t)LdapClient_add_VsVhNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 3, stringTypeInfo, NULL, "dn", hashTypeInfo, NULL, "attrs", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // nothing LdapClient::bind(hash bind, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("bind", (q_method_t)LdapClient_bind_VhNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 2, hashTypeInfo, NULL, "bind", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // bool LdapClient::compare(string dn, string attr, softlist vals, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("compare", (q_method_bool_t)LdapClient_compare_VsVsvlNt, false, QC_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo, 4, stringTypeInfo, NULL, "dn", stringTypeInfo, NULL, "attr", softListTypeInfo, NULL, "vals", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // LdapClient::constructor(string uri, *hash options) {}
   QC_LDAPCLIENT->setConstructorExtended3(LdapClient_constructor_VsNh, false, QC_NO_FLAGS, QDOM_DEFAULT, 2, stringTypeInfo, NULL, "uri", hashOrNothingTypeInfo, NULL, "options");

   // LdapClient::copy() {}
   QC_LDAPCLIENT->setCopy((q_copy_t)LdapClient_copy);

   // nothing LdapClient::del(string dn, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("del", (q_method_t)LdapClient_del_VsNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 2, stringTypeInfo, NULL, "dn", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // LdapClient::destructor() {}
   QC_LDAPCLIENT->setDestructor((q_destructor_t)LdapClient_destructor);

   // string LdapClient::getUri(){}
   QC_LDAPCLIENT->addMethodExtended3("getUri", (q_method_t)LdapClient_getUri, false, QC_CONSTANT, QDOM_DEFAULT, stringTypeInfo);

   // bool LdapClient::isSecure(){}
   QC_LDAPCLIENT->addMethodExtended3("isSecure", (q_method_bool_t)LdapClient_isSecure, false, QC_RET_VALUE_ONLY, QDOM_DEFAULT, boolTypeInfo);

   // nothing LdapClient::modify(string dn, softlist mods, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("modify", (q_method_t)LdapClient_modify_VsvlNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 3, stringTypeInfo, NULL, "dn", softListTypeInfo, NULL, "mods", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // nothing LdapClient::passwd(string dn, string oldpwd, string newpwd, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("passwd", (q_method_t)LdapClient_passwd_VsVsVsNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 4, stringTypeInfo, NULL, "dn", stringTypeInfo, NULL, "oldpwd", stringTypeInfo, NULL, "newpwd", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // nothing LdapClient::rename(string dn, string newrdn, string newparent, softbool deleteoldrdn = True, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("rename", (q_method_t)LdapClient_rename_VsVsVsvbNt, false, QC_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 5, stringTypeInfo, NULL, "dn", stringTypeInfo, NULL, "newrdn", stringTypeInfo, NULL, "newparent", softBoolTypeInfo, &True, "deleteoldrdn", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // hash LdapClient::search(hash h, *timeout timeout_ms){}
   QC_LDAPCLIENT->addMethodExtended3("search", (q_method_t)LdapClient_search_VhNt, false, QC_NO_FLAGS, QDOM_DEFAULT, hashTypeInfo, 2, hashTypeInfo, NULL, "h", timeoutOrNothingTypeInfo, NULL, "timeout_ms");

   // static nothing LdapClient::getInfo(){}
   QC_LDAPCLIENT->addStaticMethodExtended3("getInfo", (q_func_t)static_LdapClient_getInfo, false, QC_CONSTANT, QDOM_DEFAULT, nothingTypeInfo);
# 71 "QC_LdapClient.qpp"
# 76 "QC_LdapClient.qpp"
# 79 "QC_LdapClient.qpp"
# 82 "QC_LdapClient.qpp"
   ns.addConstant("LDAP_SCOPE_BASE", new QoreBigIntNode(LDAP_SCOPE_BASE));
   ns.addConstant("LDAP_SCOPE_CHILDREN", new QoreBigIntNode(LDAP_SCOPE_CHILDREN));
   ns.addConstant("LDAP_SCOPE_ONELEVEL", new QoreBigIntNode(LDAP_SCOPE_ONELEVEL));
   ns.addConstant("LDAP_SCOPE_SUBTREE", new QoreBigIntNode(LDAP_SCOPE_SUBTREE));
# 91 "QC_LdapClient.qpp"
# 98 "QC_LdapClient.qpp"
   ns.addConstant("LDAP_MOD_ADD", new QoreStringNode("add"));
   ns.addConstant("LDAP_MOD_DELETE", new QoreStringNode("delete"));
   ns.addConstant("LDAP_MOD_REPLACE", new QoreStringNode("replace"));
# 105 "QC_LdapClient.qpp"
   ns.addConstant("DefaultTimeout", DateTimeNode::makeRelative(0, 0, 0, 0, 0, 60, 0));

   return QC_LDAPCLIENT;
}
