from distutils.core import setup, Extension
import sys, re, glob, os.path


#
# NOTE:  on Rbo's machine the path is /usr/local/nmr/pymol/modules
# so I call this as:
#  python setup.py install --prefix=$pynmrpath --install-purelib=$pynmrpath
#
# all of this is to determine where I'm going to install
# my image, test, and help files.
# python by default puts them in sys.prefix (default /usr)
# which is not where i want them to go.  
# They are to stay with pynmr.
# 

# see if I have passed this the directory path for pymol
import sys
#print "DEBUG:  argv = ", sys.argv

# look for --prefix
path = 0
for arg in  sys.argv:
    if arg.startswith("--prefix="): 
        pymol_path = arg[9:]
        path = 1
#        print "DEBUG: setting pymol path = ", pymol_path
            
# otherwise, figure it out
if path == 0:
	pymol_launch = 3
	import pymol
	pymol_path = sys.modules['pymol'].__file__
	(pymol_path, junk) = os.path.split(pymol_path)
	(pymol_path, junk) = os.path.split(pymol_path)


#print "DEBUG: pymol path = ", pymol_path

verbose = 1
# dry-run = 1


pynmr_path = pymol_path+"/pmg_tk/startup/pynmr"

#print "DEBUG: pynmr_path = " , pynmr_path

setup(name="pynmr",
            author="leigh willard",
            author_email="leigh@rsvs.ulaval.ca",
            version="0.37f",
            url="http://nmr.ulaval.ca/software/pynmr",
            py_modules=['pmg_tk.startup.plug_nmr'],
            packages=['pmg_tk/startup/pynmr'],
            data_files=[
                (pynmr_path, ['pmg_tk/startup/pynmr/Crmsd.so']), 
                (pynmr_path+"/help", glob.glob('pmg_tk/startup/pynmr/help/*')),
                (pynmr_path+"/images", glob.glob('pmg_tk/startup/pynmr/images/*')),
                (pynmr_path+"/test_data", glob.glob('pmg_tk/startup/pynmr/test_data/*')) ]
            )

