#
# verify_common.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., 
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
#
#
# --------------------------------------------------------------------
# author:  Leigh Willard
# lab:     Stephane Gagne, Laval Universite
# date:    jan 2004
# --------------------------------------------------------------------
#



from pymol import cmd
from Tkinter import *
from tkFileDialog import *
import string, sys, time, math, os
from verify import *
import common


#-----------------------------------------------------------------------------
class Verify:
    """ class to hold pointers to all objects needed by
        the verify function.  ie this is the top-level class for VERIFY """

    def __init__(self, parent, nmrframe):
        self.maingui = UserData(parent, nmrframe)
        self.violations = Violations()
#        self.pdb = PdbData()
        self.parent = parent
        self.nmrframe = nmrframe

        # constraints and distances variables set when use clicks
        # "calculate"


#-----------------------------------------------------------------------------
class Violations(Verify):
    """ Violation Object
        Used to store any violations from the data
    """


    #...........................................
    # add another violation
    def vappend(self, obj, lowlim, uplim, thisphipsi, \
        line, res, type, deviation,atom1, atom2):

        self.Lidx.append(self.numviol)
        self.columns['name'].append(self.numviol)
        self.columns['obj'].append(obj)
        self.columns['type'].append(type)
        self.columns['res'].append(res)
        self.columns['line'].append(line)
        self.columns['lowlim'].append(lowlim)
        self.columns['uplim'].append(uplim)
        self.columns['act'].append(thisphipsi)
        self.columns['viol'].append(deviation)
        self.columns['hidden1'].append(atom1)
        self.columns['hidden2'].append(atom2)

        # we store everything, even violations of size 0 (not really
        # a violation).  So we keep 2 counters to differentiate.
        self.numviol += 1
        if deviation > 0:
            self.numviol_actual += 1


    #...........................................
    #   cleanup any old violations objects 
    def cleanup_old(self):
        try: empty = self.numviol
        except: return
        for i in xrange(self.numviol):
            cmd.delete("viol_%d" % (self.columns['name'][i])) 

    #...........................................
    # print violations to the screen
    def printViolations(self):
#       self.idxL is a sorted array of indexes.  The user
#       can sort the output in a couple of different ways.
#       only the indexes get sorted, making this portion easy.
        for i in self.Lidx:
            if self.columns['viol'][i] == 0:
                continue
            self.col0.lb.insert("end","%4d\n" % self.columns['name'][i])
            self.col1.lb.insert("end",self.columns['obj'][i]+"\n")
            self.col2.lb.insert("end",self.columns['type'][i]+"\n")
            self.col8.lb.insert("end","%4s\n" % self.columns['res'][i])
            self.col3.lb.insert("end","%4s\n" % self.columns['line'][i])
            self.col4.lb.insert("end","%7.2f\n" % self.columns['lowlim'][i])
            self.col5.lb.insert("end","%7.2f\n" % self.columns['uplim'][i])
            self.col6.lb.insert("end","%7.2f\n" % self.columns['act'][i])
            self.col7.lb.insert("end","%7.3f\n" % self.columns['viol'][i])

    # one column in the violations output
    class ViolColumn:

        def __init__(self, parent, frame, title, dictidx, size, sortflag):
            self.obj = Frame(frame)
            self.obj.pack(side=LEFT)


#           some columns have buttons allowing one to sort on 
#           that column
            if sortflag:
                parent.Lsort.append(dictidx)
                myidx = parent.Lsort.index(dictidx)
                Radiobutton(self.obj, text=title, variable=parent.radio, \
                    value=myidx, command=parent.resort).pack()

            else:
                Label(self.obj, text=title).pack()
            self.lb = Text(self.obj, height=10,width=size)
            self.lb.pack(side=LEFT)
            self.lb.configure(yscrollcommand=parent.sb.set)

    #......................................... 
    # a routine to re-sort the index array 
    def resort(self):
        """ a routine to re-sort the index array """

#       make a copy of the list to be sorted.
#       append the index number onto each item - we will use this later

#       sortlist = name or obj or line ...
        sortlist = self.Lsort[self.radio.get()]
        tmplist = list()
        for i in xrange(self.numviol):
            idx = self.columns['name'][i]
            tmplist.append((self.columns[sortlist][i], idx))

#       tmplist looks like [(2.26, 0), (1.14, 1), (1.35, 2)... ]
        tmplist.sort()

#       if this is the "violation" column, you want it reverse sorted
        if sortlist == "viol":
            tmplist.reverse()
#       grab the sorted indexes
        self.Lidx[:] = [ t[1] for t in tmplist ]

        self.col0.lb.delete("1.0",END)
        self.col1.lb.delete("1.0",END)
        self.col2.lb.delete("1.0",END)
        self.col3.lb.delete("1.0",END)
        self.col4.lb.delete("1.0",END)
        self.col5.lb.delete("1.0",END)
        self.col6.lb.delete("1.0",END)
        self.col7.lb.delete("1.0",END)
        self.col8.lb.delete("1.0",END)

        self.printViolations()


    #.......................................................
    # scroll all violations output columns at the same time
    # arguments are either:
    #   "scroll X units" or
    #   "moveto 0.xxx"
    def violScrollAll(self, arg1, arg2, arg3=""):
        if (arg3 != ""):
            self.col0.lb.yview( arg1, arg2, arg3)
            self.col1.lb.yview( arg1, arg2, arg3)
            self.col2.lb.yview( arg1, arg2, arg3)
            self.col8.lb.yview( arg1, arg2, arg3)
            self.col3.lb.yview( arg1, arg2, arg3)
            self.col4.lb.yview( arg1, arg2, arg3)
            self.col5.lb.yview( arg1, arg2, arg3)
            self.col6.lb.yview( arg1, arg2, arg3)
            self.col7.lb.yview( arg1, arg2, arg3)
        else:
            self.col0.lb.yview( arg1, arg2)
            self.col1.lb.yview( arg1, arg2)
            self.col2.lb.yview( arg1, arg2)
            self.col8.lb.yview( arg1, arg2)
            self.col3.lb.yview( arg1, arg2)
            self.col4.lb.yview( arg1, arg2)
            self.col5.lb.yview( arg1, arg2)
            self.col6.lb.yview( arg1, arg2)
            self.col7.lb.yview( arg1, arg2)


    #........................................
    # draw the window (GUI)
    def draw(self, type):

#       if it already exists, delete the window.
        try: self.viol.destroy()
        except AttributeError: pass
        except TclError: pass

        self.viol = Tk()
        self.viol.title("Violations - Check Restraints ")
        self.viol.geometry("+800+25")

        self.radio = IntVar(self.viol);
        self.radio.set(0);

        fr1 = Frame(self.viol)
        fr2 = Frame(self.viol)
        fr3 = Frame(self.viol)
        fr1.pack()
        fr2.pack()
        fr3.pack()

        Label(fr1, text="VIOLATIONS OUTPUT", \
            fg="midnightblue").pack(padx=10,pady=10)

#       scrollbar
        self.sb = Scrollbar(fr2)
        self.sb.pack(side=RIGHT,fill=Y)
        self.sb.configure(command=self.violScrollAll)

#       create columns
        self.col0 = self.ViolColumn(self, fr2, "VIOL#", 'name', 8, 1)
        self.col1 = self.ViolColumn(self, fr2, "OBJECT", 'obj', 15, 1)
        self.col2 = self.ViolColumn(self, fr2, "TYPE", "", 6, 0)
        self.col3 = self.ViolColumn(self, fr2, "RST", 'line', 7, 1)
        if type == 0 :   #DIHEDRAL 
            self.col8 = self.ViolColumn(self, fr2, "RES", 'res', 7, 1)
            self.col4 = self.ViolColumn(self, fr2, "EXPECTED ", "", 9, 0)
            self.col5 = self.ViolColumn(self, fr2, "TOLERANCE", "", 9, 0)
        else:   #NOE
            self.col8 = self.ViolColumn(self, fr2, "ATOMS", 'res', 15, 1)
            self.col4 = self.ViolColumn(self, fr2, "LOWER LIM", "", 9, 0)
            self.col5 = self.ViolColumn(self, fr2, "UPPER LIM", "", 9, 0)
        self.col6 = self.ViolColumn(self, fr2, "ACTUAL", "", 9, 0)
        self.col7 = self.ViolColumn(self, fr2, "VIOLATION", 'viol', 12, 1)

        Button(fr3, text="Save", 
                command = lambda arg1=self.def_fname[type] : \
                saved_output(arg1)).pack(pady=10, side="left")
        Button(fr3, text="Close", command=self.viol.destroy).pack(pady=10, side="left")



    def __init__(self):
        self.linecnt = 0
        self.Lsort = list(); 
        myphipsi = dict(); myrsts = dict();
        self.numviol = 0
        self.numviol_actual = 0
        self.Lidx = []
        self.def_fname = ["dige.viol", "noe.viol"]
        self.columns = {'name': list(), 'obj': list(), 'type': list(),
            'line': list(), 'lowlim': list(), 'uplim': list(), 'res': list(),
            'act': list(), 'viol': list(), 
            'hidden1': list(), 'hidden2': list() }


#-----------------------------------------------------------------------------
class UserData(Verify):
    """ a class containing all of the data that the user selects
        in the main window.   """

    def __init__(self, prt, nmrframe):
        self.parent = prt
        self.nmrframe = nmrframe
        self.default_initc = "grey"
        self.ftype = StringVar(self.nmrframe)
        self.ftype.set("CNS")
#        self.file_types = ["CNS", "CYANA"]
        self.file_types = ["CNS"]
        self.nmr_colors = ["white", "yellow", "green", "pink", "orange", 
            "red", "blue", "purple", "brown", "grey", "black"]
        self.color_limits = [[2.0, 3.0, 4.0, 100.0], [.2, .5, 1.0, 2.0]]
        self.defaultcutoff = [1.0, 0.1]
        self.cutoff = DoubleVar(self.nmrframe)
        self.cutoff.set(self.defaultcutoff[0])
        self.colorcutoff = DoubleVar(self.nmrframe)
        self.colorcutoff.set(self.defaultcutoff[0])
        self.defaultcolors=["yellow", "red", "green", "blue"]
        self.limits = []
        self.colors = []
        self.objs = cmd.get_names('objects')
        self.type = IntVar(self.nmrframe)
        self.type.set(0)
        self.bbonly = IntVar(self.nmrframe)
        self.bbonly.set(0)
        self.dihF = Frame(self.nmrframe)
        self.noeF = Frame(self.nmrframe)



    def askOpen(self):
        """ wrapper to call askopenfilename """
        fname = askopenfilename(initialfile="filename.tbl")
        try: (base, file) = os.path.split(fname)
        except: return
        common.workingdir = base
        self.fname.set(file)



    def set_color_limits(self):
        """ write the violation limits in the GUI """
        global limits
        mytype = self.type.get()
        i = 0
        for val in self.color_limits[mytype]:
            self.limits[i].set(val)
            i += 1

    def set_def_cutoff(self):
        """ write the cutoff default in the GUI """
        mytype = self.type.get() #dihedral or noe
        self.cutoff.set(self.defaultcutoff[mytype])
        self.colorcutoff.set(self.defaultcutoff[mytype])

    def fr_destroy(self, myframe):
        """ destroy the given frame """
        try: myframe.destroy()
        except: pass

    def toggle_bb(self):
        """ toggle backbone only drawing """
        if self.bbonly.get() == 0:
            cmd.show("lines")
        if self.bbonly.get() == 1:
            cmd.hide("lines")
            cmd.show("lines", "n. n+c+ca+o")


    def draw_bbonly_button(self):
        """ pop up the bb only buttons """
#        self.fr_destroy(self.dihF)
#        self.fr_destroy(self.noeF)
        self.bbF = Frame(self.rstF)
        self.bbF.pack(fill=X)
        Checkbutton(self.bbF, text="Display backbone only", variable=self.bbonly, command=self.toggle_bb).pack(side=LEFT)


    def draw_noe_buttons(self):
        """ pop up the noe-averaging buttons """
        self.noeF = Frame(self.rstF)
        self.noeF.pack(fill=X)
        self.avgF = Frame(self.noeF, relief="raised", bd=1)
        self.avgF.pack(fill=X)
        self.avg = IntVar(self.nmrframe)
        self.avg.set(0)
        self.nmono = IntVar(self.nmrframe)
        self.nmono.set(1)
        self.proton = IntVar(self.nmrframe)
        self.proton.set(1)
        avgF_b = Frame(self.noeF, relief="raised", bd=1)
        avgF_b.pack()
        Checkbutton(avgF_b, text="read protons only", variable=self.proton).pack(side=LEFT)
        Label(self.avgF, text="Xplor/CNS Averaging: ").pack()
        Radiobutton(self.avgF, text="none", variable=self.avg, \
            value=4).pack(anchor="w")
        Radiobutton(self.avgF, text="closest", variable=self.avg, \
            value=5).pack(anchor="w")
        Radiobutton(self.avgF, text="r-6", variable=self.avg, \
            value=0).pack(anchor="w")
        Radiobutton(self.avgF, text="r-3", variable=self.avg, \
            value=1).pack(anchor="w")
        Radiobutton(self.avgF, text="centre", variable=self.avg, \
            value=2).pack(anchor="w")
        avgF_a = Frame(self.avgF)
        avgF_a.pack(side=LEFT)
        Radiobutton(avgF_a, text="sum", variable=self.avg, \
            value=3).pack(anchor="w", side=LEFT)
        Label(avgF_a, text="n_mono:").pack(anchor="w", side=LEFT)
        mychoice = Entry(avgF_a, width=1, textvariable=self.nmono)
        mychoice.pack(side=LEFT)



    def set_defaults(self):
        self.fr_destroy(self.noeF)
        self.set_color_limits()
        self.set_def_cutoff()
        if (self.type.get() == 1):
            self.draw_noe_buttons()

    def fileChoice(self, parent, myvar):
        """ draw a pull-down menu of input file types """

        def do_popup(event):
            mymenu.tk_popup(*parent.winfo_pointerxy())
            parent.focus_set()

        mychoice = Entry(parent, width=7, textvariable=myvar, 
            state=DISABLED)
        mychoice.pack()
        mymenu = Menu(tearoff=0)
        for i in self.file_types:
            mymenu.add_command(label=i, \
            command=lambda arg1=myvar, arg2=i: \
            arg1.set(arg2))
        mychoice.bind("<Button>", do_popup)

    def colorChoice(self, parent, myvar):
        """  draw a pull-down menu of colours """

        def showColor(myvar, mycolor, myentry): 
#            print "setting color", mycolor, "for variable", myvar, "entry ", myentry
            myvar.set(mycolor)
            myentry.config(bg=mycolor)

        def do_popup(event):
            mymenu.tk_popup(*parent.winfo_pointerxy())

        mychoice = Entry(parent, width=6,
            textvariable=myvar, bg=myvar.get())
#        mychoice = Entry(parent, width=6, state=DISABLED,
#            textvariable=myvar, bg=myvar.get())
        mychoice.pack()
        mymenu = Menu(tearoff=0)
        for i in self.nmr_colors:
            mymenu.add_command(label=i, background=i,\
            command=lambda arg1=myvar, arg2=i, arg3=mychoice:\
            showColor(arg1, arg2, arg3))
        mychoice.bind("<Button>", do_popup)


    def colorLine(self, idx):
        """  put up one line for the deviations/color GUI """
        Entry(self.colF_v, width=5, textvariable=self.limits[idx]).pack()
        self.colorChoice(self.colF_c, self.colors[idx])


    def draw(self):
        """ main routine to draw the main violations gui """
        for val in self.color_limits[0]:
            tkvar = DoubleVar(self.parent)
            tkvar.set(val)
            self.limits.append(tkvar)
        for val in self.defaultcolors:
            tkvar = StringVar(self.parent)
            tkvar.set(val)
            self.colors.append(tkvar)
#       title area
        titleF = Frame(self.nmrframe)
        titleF.pack(side=TOP, pady=10, padx=10)
        Label(titleF, text="RESTRAINTS CHECK", fg="midnightblue").pack()

#       restraint area
        rstF = Frame(self.nmrframe, bd=3, relief="sunken")
        rstF.pack(pady=10, padx=10)

#       type of check
        typeF = Frame(rstF)
        typeF.pack(pady=2, padx=10, side=TOP)
        self.rstF = rstF
        Radiobutton(typeF, text="Dihedral", variable=self.type, \
            command=self.set_defaults, 
            value=0).pack(side=LEFT)
        Radiobutton(typeF, text="NOE", variable=self.type, \
            command=self.set_defaults, 
            value=1).pack(side=LEFT)

#       cutoff
        frCutoff = Frame(rstF)
        frCutoff.pack()
        Label(frCutoff, text="Violations Cutoff (A or deg): ").pack(side=LEFT, anchor="w")
        Entry(frCutoff, width=4, textvariable=self.cutoff).pack(side=LEFT)

#       choice of file types
        ftypeF = Frame(rstF)
        ftypeF.pack(pady=2, padx=10)
        Label(ftypeF, text="file type:").pack(side=LEFT)
        self.fileChoice(ftypeF, self.ftype)

#       file name
        rstF_2 = Frame(rstF)
        rstF_2.pack(anchor="w")
        self.fname = StringVar(self.nmrframe)
        self.fname.set("filename.tbl")
        Label(rstF_2, text="Restraints file: ").pack(side=LEFT)
        self.nmr_entry = Entry(rstF_2, width=10, textvariable=self.fname)
        self.nmr_entry.pack(side=LEFT)
        self.browse =Button(rstF_2, text="browse", command=self.askOpen)
        self.browse.pack(side=LEFT)

        self.draw_bbonly_button()

#       colors/drawing info
        colF = Frame(self.nmrframe, relief="sunken", bd=3)
        colF.pack(pady=5, padx=5)

#       color cutoff
        colCutoff = Frame(colF)
        colCutoff.pack()
        Label(colCutoff, text="start coloring at: ").pack(side=LEFT, anchor="w")
        Entry(colCutoff, width=4, textvariable=self.colorcutoff).pack(side=LEFT)


        colF_B = Frame(colF)
        colF_B.pack(pady=7)
        self.colF_v = Frame(colF_B)
        self.colF_c = Frame(colF_B)
        Label(self.colF_v, text="If the violation is \n<= ").pack(anchor="w", padx=3)
        Label(self.colF_c, text="color the bond:\n ").pack(anchor="w", padx=3)
        line1 = self.colorLine(0)
        line2 = self.colorLine(1)
        line3 = self.colorLine(2)
        line4 = self.colorLine(3)
        self.colF_v.pack(side=LEFT)
        self.colF_c.pack(side=LEFT)

        colF_bg = Frame(colF)
        colF_bg.pack(anchor="w")
        self.initc = StringVar(self.nmrframe)
        self.initc.set(self.default_initc)
        Label(colF_bg, text="Initial Molecule Color: ").pack(side=LEFT)
        self.colorChoice(colF_bg, self.initc)
        colF_lt = Frame(colF)
        colF_lt.pack(anchor="w")
        Label(colF_lt, text="line thickness: ").pack(side=LEFT)
        self.lwidth = IntVar(self.nmrframe)
        self.lwidth.set(2)
        Entry(colF_lt, width=2, textvariable=self.lwidth).pack(side=LEFT)

#       buttons
        frButtons1 = Frame(colF)
	frButtons1.pack()
        self.drawB = Button(frButtons1, text="DRAW", command=colorObjects)
        self.drawB.pack(side=LEFT)
        self.drawB.config(state="disabled")
        self.clearB = Button(frButtons1, text="CLEAR",
            command=lambda arg="viol_*": cmd.delete(arg))
        self.clearB.pack(side=LEFT)
        self.clearB.config(state="disabled")

        frButtons2 = Frame(self.nmrframe)
        frButtons2.pack(pady=10)
        Button(frButtons2, text="CALCULATE\n", command=doVerify).pack(side=LEFT)
        Button(frButtons2, text="CALCULATE\n& DRAW", command=calcdraw).pack(side=LEFT)




    def XcolorObjects(self):     
        """ store the color value objects on the pymol screen """

        global myverify

        violations = myverify.violations
        maingui = myverify.maingui

        try: test = violations.Lidx
        except AttributeError: return
        cmd.color(maingui.initc.get())
        for i in violations.Lidx:

    #           devname, atom1, atom2, upperbound, mode, zoom, width, length,
    #           gap, label, quiet

    #           determine the atoms to color between

            at1 = violations.columns['obj'][i]+"///"
            at2 = violations.columns['obj'][i]+"///"
            if violations.columns['type'][i] == "phi":
                at1 = "%s%d/N" % (at1, violations.columns['res'][i]);
                at2 = "%s%d/CA" % (at2, violations.columns['res'][i]);
            elif violations.columns['type'][i] == "psi":
                at1 = "%s%d/CA" % (at1, violations.columns['res'][i]);
                at2 = "%s%d/C" % (at2, violations.columns['res'][i]);
            elif violations.columns['type'][i] == "NOE":
                objects = violations.columns['res'][i].split()
                fields0 = objects[0].split('.')
                fields1 = objects[1].split('.')
                at1 = "%s%s/%s" % (at1, fields0[0], fields0[1]);
                at2 = "%s%s/%s" % (at2, fields1[0], fields1[1]);
            else:
                at1 = "%s%d/C" % (at1, violations.columns['res'][i]);
                at2 = "%s%d/N" % (at2, violations.columns['res'][i+1]);
    # syntax: distance myobj, aria_10///28/c,aria_10///28/ca,-1,-1,0,5,1,0,0,0
            cmd.distance("viol_%d" % (violations.columns['name'][i]), at1, at2,
                -1, -1, 0, maingui.lwidth.get(), 1, 0, 0, 1)
            # debug
            # at1 or at2 can contain *
            print " command = ", violations.columns['name'][i], at1, at2, -1, -1, 0, maingui.lwidth.get(), 1, 0, 0, 1

    #           decide what color this will be drawn as
            lower = maingui.cutoff.get()
            deviation = violations.columns['viol'][i]
            idx = 0
            color = maingui.initc.get()
            for limit in maingui.limits:
                value = limit.get()
                if ((deviation >= lower) and (deviation < value)):
                    color = maingui.colors[idx].get()
                    break
                lower = value
                idx = idx + 1

            cmd.color(color, "viol_%d" % (violations.columns['name'][i]))



#..........................................................................
# an object representing constraints
class Constraints(Verify):

    pass

#..........................................................................
# an object representing constraints
class Distances(Verify):

    pass



