#
# pbar.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., 
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
#
from Tkinter import *

class ProgressBar:
    """  a simple progress bar """

    def __init__(self, bg = "blue", fg = "red",
        height=24, width=200, max=200, progress=0, geometry = "+200+500"):
        self.bg = bg
        self.fg = fg
        self.height = height
        self.max = max
        self.width = width
        self.progress = progress

        self.window = Tk()
        self.window.title("")
        self.window.geometry(geometry)
        self.frame = Frame(self.window)

        Label(self.frame, text="Progress...").pack()

#        self.cancel = Button(self.frame, text = "CANCEL", command=self.done)
#        self.cancel.pack()

        self.canvas = Canvas(self.frame, height=height+4, width=self.width+4)
        self.box = self.canvas.create_rectangle(0, 0, width+4, height+4,
            fill="white", outline="black", width=2)
        self.scale = self.canvas.create_rectangle(2, 2, 
            2, height, fill="blue", outline="")
        self.canvas.pack(side="top", fill="x", expand="no")
        self.frame.pack()
        self.update(progress)

    def update(self, progress):
        self.progress = progress
        if self.max == 0: return
        percent = float(self.progress)/self.max
        tix = int(self.width * percent)
#        print "progress = ", progress, " percent = ", percent, " tix = ", tix
        self.canvas.coords(self.scale, 2, 2, tix+2,
        self.height)
        self.canvas.update_idletasks() 

    def done(self):
        """ quit the progress button, and signal the program to stop """
        self.window.destroy()
        return -1

        


if __name__ == "__main__":
    import time
    root = Tk()
    root.update()
    p = ProgressBar(max=20)
    for i in xrange(20):
        time.sleep(1)
        p.update(i)
    root.mainloop()
