#
# loadnmr.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., # 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
#
#
# --------------------------------------------------------------------
# author:  Leigh Willard
# lab:     Stephane Gagne, Laval Universite
# date:    jan 2004
# --------------------------------------------------------------------
#
# PURPOSE:
# this module contains the routines for loading in (reading)
# PDB files.
#

from Tkinter import *
from tkFileDialog import *
from pymol import cmd
from glob import glob
from common import *
import os, re


def show_bbonly(flag=1):
    """ turn on or off backbone only viewing """
    if flag == 0:
        cmd.show("lines")
    if flag == 1:
        cmd.hide("lines")
        cmd.show("lines", "n. n+c+ca+o")



class LoadImage:
    
    def draw_gui(self):
        if self.type == 0:  self.gui_group()
        else:  self.gui_mult()

    def askOpen(self, variable):
        fname = askopenfilename(initialfile=self.defaultfname)
        try: (base, file) = os.path.split(fname)
        except: return
        variable.set(file)
        workingdir = base
        self.showworkingdir.set(base)


#        self.fname.set(fname)
#        try: basename = os.path.basename(fname)
#        except: return
#        self.fname.set(basename)

    def browse_rootname(self):

        fname = askopenfilename(initialfile=self.defaultfname)
        try: (base, file) = os.path.split(fname)
        except: return
        workingdir = base
        self.showworkingdir.set(base)
        self.rootname.set(file)
        # get the common part of the filename.
        # eg. with test_1.pdb, get test_
        pat = re.compile('^(\D+)(\d+)\.pdb')
        matches = pat.match(file)
        try: grouptuple = matches.groups()
        except AttributeError: return
        base = grouptuple[0]
        pattern = base + "*"
        rootnamelist = self.guess_rootname(pattern)
        self.rootname.set(rootnamelist[0])
        self.firstnum.set(rootnamelist[1])
        self.lastnum.set(rootnamelist[2])


#        try: basename = os.path.basename(fname)
#        except: return
#        self.rootname.set(basename)

    def guess_rootname(self, pattern):

#       look for pdb name of the form base_NUM.pdb 
#       store the base_ as the key in a dictionary,
#       with a list of NUMS as its data.
#       ie. pdbdict = {'base_': ['4', '8', '6']}
        pdbdict = dict()
        pat = re.compile('.*\/(\D+)(\d+)\.pdb')
        pattern = workingdir + "/" + pattern
        for pdb in glob(pattern):
            matches = pat.match(pdb)
            try: grouptuple = matches.groups()
            except AttributeError: continue

            try: pdbdict[grouptuple[0]].append(int(grouptuple[1]))
            except KeyError: pdbdict[grouptuple[0]] = [int(grouptuple[1])]
            
#       now get the basename, the first struct, and the last struct 
        if len(pdbdict) == 0:  return ["", "", ""]

        [key, itemlist] = pdbdict.popitem()
        itemlist.sort()
        first = itemlist[0]
        last = itemlist[-1]
        return [key, first, last]


    def superimpose(self):

        rms = cmd.intra_rms_cur("(name ca)",1)
        print "rms before superimpose = ", rms
#        rms = cmd.intra_fit(self.objname,1)
        rms = cmd.intra_fit("(name ca)",1)
        print "rms value of fit: ", rms

        
        
#   this routine is not currently used.
    def doLoad1(self):


        # set the name of the on-screen object
        if self.type == 0: self.objname = self.myobj.get()
        else: self.objname = ""   # created automatically from pdb name


        try: fp = open(self.fname.get(), 'r')
        except:
            print "file doesn't exist: ", self.fname.get()
            return

        if fp != None:
            for line in fp:
                fname = line[:-1]
                cmd.load(fname, self.objname)


    def doLoad2(self):

        root = self.rootname.get()
        if root == "": return
        try: first = self.firstnum.get()
        except:  return
        try: last = self.lastnum.get()
        except:  return

        load_root(root, first, last)


    def gui_pdbnames(self):

        framepdb = Frame(self.nmrframe)
        framepdb.pack(side=TOP, padx=10, pady=10)
        Label(framepdb, text=""" Choose your pdb files,
using one method below:
""").pack(side=TOP)

        framewd = Frame(self.nmrframe)
        framewd.pack(pady=5)
        Label(framewd, text="Working Directory: ", fg="midnightblue").pack(side=LEFT)
        workEntry = Entry(framewd, textvariable=self.showworkingdir, 
            width=45, state="disabled")
        workEntry.pack(side=LEFT)

        framepdb1 = Frame(framepdb)
        framepdb1.pack()

#       3) third choice

	frame3 = Frame(framepdb1,relief="sunken", bd=4, 
            height=20, width=30 )
	frame3.pack(fill=BOTH,pady=4,side=LEFT)

        Label(frame3, text="single PDB file:").pack(pady=10)
        frame3a = Frame(frame3)
        frame3a.pack()
        nmr_entry = Entry(frame3a, textvariable=self.pdbfname, width=15)
        nmr_entry.pack(side=LEFT)
        browse =Button(frame3a, text="browse", 
            command=lambda arg=self.pdbfname: self.askOpen(arg))
        browse.pack(side=LEFT)

        Button(frame3, text="Load", 
            command=lambda arg=self.pdbfname: load_models(arg),
            fg="white",
            bg="darkgreen",
            activebackground="green").pack(pady=10, side=BOTTOM)


#       1) first choice

	frame1 = Frame(framepdb1,relief="sunken", bd=4, 
            height=20, width=30 )
	frame1.pack(fill=BOTH,pady=4,side=LEFT)

        Label(frame1, text="File containing list of pdb files:").pack(
            pady=10)
        frame1a = Frame(frame1)
        frame1a.pack()
        nmr_entry = Entry(frame1a, textvariable=self.fname, width=15)
        nmr_entry.pack(side=LEFT)
        browse =Button(frame1a, text="browse",
            command=lambda arg=self.fname: self.askOpen(arg))
        browse.pack(side=LEFT)

        Button(frame1, text="Load", 
            command=lambda arg=self.fname: load_file(arg),
#                self.doLoad1, 
            fg="white",
            bg="darkgreen",
            activebackground="green").pack(
            pady=10, side=BOTTOM)


#	2) second choice
	frame2 = Frame(framepdb1, relief="sunken", bd=4,
            height=20, width=40 )
	frame2.pack(fill=BOTH,pady=4,side=RIGHT)

        frame2a = Frame(frame2)
        frame2a.pack()
        Label(frame2a, text="Rootname: ").pack(pady=10)
        Entry(frame2a, textvariable=self.rootname, width=15).pack(side=LEFT)
        Button(frame2a, text="browse", 
            command=self.browse_rootname).pack(side=LEFT)
        frame2b = Frame(frame2)
        frame2b.pack(anchor="w")
        Label(frame2b, text="First: ").pack(side=LEFT)
        Entry(frame2b, textvariable=self.firstnum, width=3).pack(side=LEFT)
        Label(frame2b, text="Last: ").pack(side=LEFT)
        Entry(frame2b, textvariable=self.lastnum, width=3).pack(side=LEFT)

        Button(frame2, text="Load", command=self.doLoad2, fg="white", bg="darkgreen",
            activebackground="green").pack(
            side=BOTTOM, pady=10)




    def gui_group(self):

        frame1 = Frame(self.nmrframe)
        frame1.pack(side=TOP)

        Label(frame1, text="LOAD GROUP", fg="midnightblue").pack()
        Label(frame1, text="Loads a group of pdb files into one object",\
            fg="midnightblue").pack()
        Label(frame1, \
            text="The resulting object is composed of frames, and can be used to play a movie ",\
            fg="midnightblue").pack()


        fmain = Frame(self.nmrframe)
        fmain.pack(side=TOP, pady=5)

        frame2 = Frame(fmain)
        frame2.pack(pady=5)
        Label(frame2, text="Select a name for the object:").pack(side=LEFT)
        self.nmr_entry = Entry(frame2, width=10, textvariable=self.myobj)
        self.nmr_entry.pack(side=LEFT)
        self.nmr_entry.insert(END, 'nmrobj')


        self.gui_pdbnames()

#        self.gui_superimpose()


    def gui_mult(self):

        topF = Frame(self.nmrframe)
        topF.pack(side=TOP)
        Label(topF, text="\nLoad PDB Files", fg="midnightblue").pack()
        Label(topF, \
            text="load multiple PDB files into seperate pymol objects",\
            fg="midnightblue").pack()

        self.gui_pdbnames()


    def __init__(self, nmrframe, type):

        self.type = type
        self.nmrframe = nmrframe
        self.defaultfname = "file.nam"
        self.fname = StringVar(self.nmrframe)
        self.fname.set(self.defaultfname)
        self.pdbfname = StringVar(self.nmrframe)
        self.showworkingdir = StringVar(self.nmrframe)
        self.showworkingdir.set(workingdir)
#        self.pdbfname.set(self.defaultfname)

        self.pdblist = list()
        self.metafile = ""
        self.defaultdir = "."
        self.objname = ""

        self.sourcedir = StringVar(self.nmrframe)
        self.rootname = StringVar(self.nmrframe)
        self.firstnum = IntVar(self.nmrframe)
        self.lastnum = IntVar(self.nmrframe)
        self.myobj = StringVar(self.nmrframe)
        self.simp = IntVar(self.nmrframe)
        self.simp.set(0)

        rootnamelist = self.guess_rootname("*.pdb")
        self.rootname.set(rootnamelist[0])
        self.firstnum.set(rootnamelist[1])
        self.lastnum.set(rootnamelist[2])


def loadPdb(nmrframe, type):

    myload = LoadImage(nmrframe, type)
    myload.draw_gui()



def load_file(basename):
    """ loads all pdb files listed in the given file """

    rootname = basename.get()
    fname = os.path.join(workingdir, rootname)
    try: fp = open(fname, 'r')
    except:
        print "file does not exist: ", fname
        return

    mylist = list()
    print "Loading..."
    if fp != None:
        for line in fp:
            fname = line[:-1]
            fullfname = os.path.join(workingdir, fname)
            if os.path.exists(fullfname):
                mylist.append((fname, fullfname))
                # display images on screen
                cmd.load(fullfname, "")

    # read in files
    for i,j in mylist:
        obj = i[:-4]
        pdb.myPDB[obj] = pdb.PdbFile()
        pdb.myPDB[obj].readLines(j)

    print "Done Loading"


def load_models(basename):
    """ loads a pdb file where all models are in the same file.
    ie. format that is in the PDB, with the MODEL/ENDMDL tags
    """
    fname = os.path.join(workingdir, basename.get())
    object = basename.get()
    object = object.replace(".pdb", "")

    cmd.load(fname, object)

    cmd.unset("all_states")
    cmd.split_states(object)
    cmd.delete(object)
    cnt = 0
    opened = 0

    # split the file up into individual files.
    # load each one separately
    try: pdbfile = open(fname, "r")
    except:
        print "**ERROR:  cannot read ", fname
        return
    lines = pdbfile.readlines()
    pdbfile.close()

    for line in lines:
        splt = string.split(string.strip(line))
        if splt[0] == "MODEL":
            cnt =+ 1
            opened = 1
            mnum = splt[1]
            pdblines = list()

        elif splt[0] == "ENDMDL":
            thisobj = "%s_%04d" % (object, int(mnum))

            pdb.myPDB[thisobj] = pdb.PdbFile()
            pdb.myPDB[thisobj].processLines(pdblines)
            opened = 0

        elif opened:
            pdblines.append(line)



def load_root(rootname, first, last):
    """ loads a bunch of pdb files with the same rootname,
    in the range first-last.
    for example, if you have the files:
    aria_1.pdb aria_2.pdb .... aria_11.pdb
    you would call load_root("aria_1", 1, 11)
    """

    print "Loading..."
    mylist = list()
    for num in xrange(first,last+1):
        fname = '%s%d.pdb' % (rootname, num)
        fullfname = os.path.join(workingdir, fname)
        mylist.append(('%s%d' % (rootname, num), fullfname))
        cmd.load(fullfname, "")

    # read in files
    for i,j in mylist:
        pdb.myPDB[i] = pdb.PdbFile()
        pdb.myPDB[i].readLines(j)

    print "Done Loading"


