# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.voice.v1.voice_permission.bulk_country_update import BulkCountryUpdateList
from twilio.rest.voice.v1.voice_permission.country import CountryList


class VoicePermissionList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the VoicePermissionList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.voice.v1.voice_permission.VoicePermissionList
        :rtype: twilio.rest.voice.v1.voice_permission.VoicePermissionList
        """
        super(VoicePermissionList, self).__init__(version)

        # Path Solution
        self._solution = {}

        # Components
        self._countries = None
        self._settings = None
        self._bulk_country_updates = None

    @property
    def countries(self):
        """
        Access the countries

        :returns: twilio.rest.voice.v1.voice_permission.country.CountryList
        :rtype: twilio.rest.voice.v1.voice_permission.country.CountryList
        """
        if self._countries is None:
            self._countries = CountryList(self._version, )
        return self._countries

    @property
    def bulk_country_updates(self):
        """
        Access the bulk_country_updates

        :returns: twilio.rest.voice.v1.voice_permission.bulk_country_update.BulkCountryUpdateList
        :rtype: twilio.rest.voice.v1.voice_permission.bulk_country_update.BulkCountryUpdateList
        """
        if self._bulk_country_updates is None:
            self._bulk_country_updates = BulkCountryUpdateList(self._version, )
        return self._bulk_country_updates

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.VoicePermissionList>'


class VoicePermissionPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the VoicePermissionPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.voice.v1.voice_permission.VoicePermissionPage
        :rtype: twilio.rest.voice.v1.voice_permission.VoicePermissionPage
        """
        super(VoicePermissionPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of VoicePermissionInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.voice.v1.voice_permission.VoicePermissionInstance
        :rtype: twilio.rest.voice.v1.voice_permission.VoicePermissionInstance
        """
        return VoicePermissionInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.VoicePermissionPage>'


class VoicePermissionInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the VoicePermissionInstance

        :returns: twilio.rest.voice.v1.voice_permission.VoicePermissionInstance
        :rtype: twilio.rest.voice.v1.voice_permission.VoicePermissionInstance
        """
        super(VoicePermissionInstance, self).__init__(version)

        # Context
        self._context = None
        self._solution = {}

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1.VoicePermissionInstance>'
