# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class WorkflowRealTimeStatisticsList(ListResource):
    """  """

    def __init__(self, version, workspace_sid, workflow_sid):
        """
        Initialize the WorkflowRealTimeStatisticsList

        :param Version version: Version that contains the resource
        :param workspace_sid: The workspace_sid
        :param workflow_sid: The workflow_sid

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsList
        """
        super(WorkflowRealTimeStatisticsList, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid, 'workflow_sid': workflow_sid, }

    def get(self):
        """
        Constructs a WorkflowRealTimeStatisticsContext

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        """
        return WorkflowRealTimeStatisticsContext(
            self._version,
            workspace_sid=self._solution['workspace_sid'],
            workflow_sid=self._solution['workflow_sid'],
        )

    def __call__(self):
        """
        Constructs a WorkflowRealTimeStatisticsContext

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        """
        return WorkflowRealTimeStatisticsContext(
            self._version,
            workspace_sid=self._solution['workspace_sid'],
            workflow_sid=self._solution['workflow_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.WorkflowRealTimeStatisticsList>'


class WorkflowRealTimeStatisticsPage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the WorkflowRealTimeStatisticsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param workspace_sid: The workspace_sid
        :param workflow_sid: The workflow_sid

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsPage
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsPage
        """
        super(WorkflowRealTimeStatisticsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of WorkflowRealTimeStatisticsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        """
        return WorkflowRealTimeStatisticsInstance(
            self._version,
            payload,
            workspace_sid=self._solution['workspace_sid'],
            workflow_sid=self._solution['workflow_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Taskrouter.V1.WorkflowRealTimeStatisticsPage>'


class WorkflowRealTimeStatisticsContext(InstanceContext):
    """  """

    def __init__(self, version, workspace_sid, workflow_sid):
        """
        Initialize the WorkflowRealTimeStatisticsContext

        :param Version version: Version that contains the resource
        :param workspace_sid: The workspace_sid
        :param workflow_sid: The workflow_sid

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        """
        super(WorkflowRealTimeStatisticsContext, self).__init__(version)

        # Path Solution
        self._solution = {'workspace_sid': workspace_sid, 'workflow_sid': workflow_sid, }
        self._uri = '/Workspaces/{workspace_sid}/Workflows/{workflow_sid}/RealTimeStatistics'.format(**self._solution)

    def fetch(self, task_channel=values.unset):
        """
        Fetch a WorkflowRealTimeStatisticsInstance

        :param unicode task_channel: Filter real-time and cumulative statistics by TaskChannel.

        :returns: Fetched WorkflowRealTimeStatisticsInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        """
        params = values.of({'TaskChannel': task_channel, })

        payload = self._version.fetch(
            'GET',
            self._uri,
            params=params,
        )

        return WorkflowRealTimeStatisticsInstance(
            self._version,
            payload,
            workspace_sid=self._solution['workspace_sid'],
            workflow_sid=self._solution['workflow_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.WorkflowRealTimeStatisticsContext {}>'.format(context)


class WorkflowRealTimeStatisticsInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, workspace_sid, workflow_sid):
        """
        Initialize the WorkflowRealTimeStatisticsInstance

        :returns: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        """
        super(WorkflowRealTimeStatisticsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload['account_sid'],
            'longest_task_waiting_age': deserialize.integer(payload['longest_task_waiting_age']),
            'tasks_by_priority': payload['tasks_by_priority'],
            'tasks_by_status': payload['tasks_by_status'],
            'total_tasks': deserialize.integer(payload['total_tasks']),
            'workflow_sid': payload['workflow_sid'],
            'workspace_sid': payload['workspace_sid'],
            'url': payload['url'],
        }

        # Context
        self._context = None
        self._solution = {'workspace_sid': workspace_sid, 'workflow_sid': workflow_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: WorkflowRealTimeStatisticsContext for this WorkflowRealTimeStatisticsInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsContext
        """
        if self._context is None:
            self._context = WorkflowRealTimeStatisticsContext(
                self._version,
                workspace_sid=self._solution['workspace_sid'],
                workflow_sid=self._solution['workflow_sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The account_sid
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def longest_task_waiting_age(self):
        """
        :returns: The age of the longest waiting Task
        :rtype: unicode
        """
        return self._properties['longest_task_waiting_age']

    @property
    def tasks_by_priority(self):
        """
        :returns: The tasks_by_priority
        :rtype: dict
        """
        return self._properties['tasks_by_priority']

    @property
    def tasks_by_status(self):
        """
        :returns: The Tasks broken down by status
        :rtype: dict
        """
        return self._properties['tasks_by_status']

    @property
    def total_tasks(self):
        """
        :returns: The total number of Tasks
        :rtype: unicode
        """
        return self._properties['total_tasks']

    @property
    def workflow_sid(self):
        """
        :returns: The workflow_sid
        :rtype: unicode
        """
        return self._properties['workflow_sid']

    @property
    def workspace_sid(self):
        """
        :returns: The workspace_sid
        :rtype: unicode
        """
        return self._properties['workspace_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self, task_channel=values.unset):
        """
        Fetch a WorkflowRealTimeStatisticsInstance

        :param unicode task_channel: Filter real-time and cumulative statistics by TaskChannel.

        :returns: Fetched WorkflowRealTimeStatisticsInstance
        :rtype: twilio.rest.taskrouter.v1.workspace.workflow.workflow_real_time_statistics.WorkflowRealTimeStatisticsInstance
        """
        return self._proxy.fetch(task_channel=task_channel, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Taskrouter.V1.WorkflowRealTimeStatisticsInstance {}>'.format(context)
