# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.api.v2010.account.usage.record import RecordList
from twilio.rest.api.v2010.account.usage.trigger import TriggerList


class UsageList(ListResource):
    """  """

    def __init__(self, version, account_sid):
        """
        Initialize the UsageList

        :param Version version: Version that contains the resource
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.usage.UsageList
        :rtype: twilio.rest.api.v2010.account.usage.UsageList
        """
        super(UsageList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, }

        # Components
        self._records = None
        self._triggers = None

    @property
    def records(self):
        """
        Access the records

        :returns: twilio.rest.api.v2010.account.usage.record.RecordList
        :rtype: twilio.rest.api.v2010.account.usage.record.RecordList
        """
        if self._records is None:
            self._records = RecordList(self._version, account_sid=self._solution['account_sid'], )
        return self._records

    @property
    def triggers(self):
        """
        Access the triggers

        :returns: twilio.rest.api.v2010.account.usage.trigger.TriggerList
        :rtype: twilio.rest.api.v2010.account.usage.trigger.TriggerList
        """
        if self._triggers is None:
            self._triggers = TriggerList(self._version, account_sid=self._solution['account_sid'], )
        return self._triggers

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UsageList>'


class UsagePage(Page):
    """  """

    def __init__(self, version, response, solution):
        """
        Initialize the UsagePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.api.v2010.account.usage.UsagePage
        :rtype: twilio.rest.api.v2010.account.usage.UsagePage
        """
        super(UsagePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UsageInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.usage.UsageInstance
        :rtype: twilio.rest.api.v2010.account.usage.UsageInstance
        """
        return UsageInstance(self._version, payload, account_sid=self._solution['account_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UsagePage>'


class UsageInstance(InstanceResource):
    """  """

    def __init__(self, version, payload, account_sid):
        """
        Initialize the UsageInstance

        :returns: twilio.rest.api.v2010.account.usage.UsageInstance
        :rtype: twilio.rest.api.v2010.account.usage.UsageInstance
        """
        super(UsageInstance, self).__init__(version)

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid, }

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UsageInstance>'
