# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class BulkCountryUpdateTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.voice_permissions \
                                .bulk_country_updates.create(update_request="update_request")

        values = {'UpdateRequest': "update_request", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/DialingPermissions/BulkCountryUpdates',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "update_count": 1,
                "update_request": "accepted"
            }
            '''
        ))

        actual = self.client.voice.v1.voice_permissions \
                                     .bulk_country_updates.create(update_request="update_request")

        self.assertIsNotNone(actual)
