# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class CompositionTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.compositions(sid="CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://video.twilio.com/v1/Compositions/CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "completed",
                "date_created": "2015-07-30T20:00:00Z",
                "date_completed": "2015-07-30T20:01:33Z",
                "date_deleted": null,
                "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "PAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "user*"
                ],
                "audio_sources_excluded": [
                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                ],
                "video_layout": {
                    "grid": {
                        "video_sources": [
                            "*"
                        ],
                        "video_sources_excluded": [
                            "MTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    },
                    "pip": {
                        "video_sources": [
                            "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                        ],
                        "video_sources_excluded": [],
                        "reuse": "none",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 0,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": []
                    }
                },
                "resolution": "1280x720",
                "format": "webm",
                "bitrate": 64,
                "size": 4,
                "duration": 6,
                "trim": true,
                "media_external_location": null,
                "encryption_key": null,
                "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                }
            }
            '''
        ))

        actual = self.client.video.v1.compositions(sid="CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.compositions.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://video.twilio.com/v1/Compositions',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "compositions": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/Compositions?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/Compositions?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "compositions"
                }
            }
            '''
        ))

        actual = self.client.video.v1.compositions.list()

        self.assertIsNotNone(actual)

    def test_read_results_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "compositions": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "status": "completed",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_completed": "2015-07-30T20:01:33Z",
                        "date_deleted": null,
                        "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "audio_sources": [
                            "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "user*"
                        ],
                        "audio_sources_excluded": [],
                        "video_layout": {
                            "grid": {
                                "video_sources": [
                                    "user*"
                                ],
                                "video_sources_excluded": [],
                                "reuse": "show_oldest",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            },
                            "pip": {
                                "video_sources": [
                                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"
                                ],
                                "video_sources_excluded": [],
                                "reuse": "none",
                                "x_pos": 100,
                                "y_pos": 600,
                                "z_pos": 10,
                                "width": 0,
                                "height": 0,
                                "max_columns": 0,
                                "max_rows": 0,
                                "cells_excluded": []
                            }
                        },
                        "resolution": "1280x720",
                        "format": "webm",
                        "bitrate": 64,
                        "size": 4,
                        "duration": 6,
                        "trim": true,
                        "media_external_location": null,
                        "encryption_key": null,
                        "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "links": {
                            "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://video.twilio.com/v1/Compositions?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://video.twilio.com/v1/Compositions?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "compositions"
                }
            }
            '''
        ))

        actual = self.client.video.v1.compositions.list()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.compositions(sid="CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://video.twilio.com/v1/Compositions/CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.video.v1.compositions(sid="CJXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.video.v1.compositions.create()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://video.twilio.com/v1/Compositions',
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "status": "processing",
                "date_created": "2015-07-30T20:00:00Z",
                "date_completed": null,
                "date_deleted": null,
                "sid": "CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "room_sid": "RMaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "audio_sources": [
                    "RTaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "user*"
                ],
                "audio_sources_excluded": [
                    "RTbaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                ],
                "video_layout": {
                    "custom": {
                        "video_sources": [
                            "user*"
                        ],
                        "video_sources_excluded": [
                            "RTcaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                        ],
                        "reuse": "show_oldest",
                        "x_pos": 100,
                        "y_pos": 600,
                        "z_pos": 10,
                        "width": 800,
                        "height": 0,
                        "max_columns": 0,
                        "max_rows": 0,
                        "cells_excluded": [
                            2,
                            3
                        ]
                    }
                },
                "trim": true,
                "format": "mp4",
                "resolution": "1920x1080",
                "bitrate": 0,
                "size": 0,
                "duration": 0,
                "media_external_location": null,
                "encryption_key": null,
                "url": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "media": "https://video.twilio.com/v1/Compositions/CJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Media"
                }
            }
            '''
        ))

        actual = self.client.video.v1.compositions.create()

        self.assertIsNotNone(actual)
