# Hello World Training

This example shows how to train a 2.5 kB model to generate a `sine` wave.

## Table of contents

-   [Overview](#overview)
-   [Training](#training)
-   [Trained Models](#trained-models)
-   [Model Architecture](#model-architecture)

## Overview

1. Dataset: Data is generated locally in the Jupyter Notebook.
2. Dataset Type: **Structured Data**
3. Deep Learning Framework: **TensorFlow 2**
4. Language: **Python 3.7**
5. Model Size: **2.5 kB**
6. Model Category: **Regression**

## Training

Train the model in the cloud using Google Colaboratory or locally using a
Jupyter Notebook.

<table class="tfo-notebook-buttons" align="left">
  <td>
    <a target="_blank" href="https://colab.research.google.com/github/tensorflow/tensorflow/blob/master/tensorflow/lite/micro/examples/hello_world/train/train_hello_world_model.ipynb"><img src="https://www.tensorflow.org/images/colab_logo_32px.png" />Google Colaboratory</a>
  </td>
  <td>
    <a target="_blank" href="https://github.com/tensorflow/tensorflow/blob/master/tensorflow/lite/micro/examples/hello_world/train/train_hello_world_model.ipynb"><img src="https://www.tensorflow.org/images/GitHub-Mark-32px.png" />Jupyter Notebook</a>
  </td>
</table>

*Estimated Training Time: 10 minutes.*


## Trained Models

Download Link | [hello_world.zip](https://storage.googleapis.com/download.tensorflow.org/models/tflite/micro/hello_world_2020_12_28.zip)
------------- | ------------------------------------------------------------------------------------------------------------------------

The `models` directory in the above zip file can be generated by following the
instructions in the [Training](#training) section above. It
includes the following 3 model files:

| Name | Format | Target Framework | Target Device |
| :------------- |:-------------|:-------------|-----|
| `model.pb` | Keras SavedModel | TensorFlow | Large-Scale/Cloud/Servers   |
| `model.tflite` *(2.5 kB)*  | Integer Only Quantized TFLite Model | TensorFlow Lite | Mobile Devices|
| `model.cc`  | C Source File | TensorFlow Lite for Microcontrollers | Microcontrollers |


## Model Architecture

The final model used to simulate a sine wave is displayed below. It is a
simple feed forward deep neural network with 2 fully connected layers with
ReLu activations and a final fully connected output layer with as shown below.

![model_architecture.png](../images/model_architecture.png)

*This image was derived from visualizing the 'model.tflite' file in [Netron](https://github.com/lutzroeder/netron)*

