/* Copyright 2020 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include "mlir-hlo/Dialect/mhlo/IR/hlo_ops.h"
#include "mlir-hlo/Dialect/mhlo/transforms/passes.h"
#include "mlir-hlo/Dialect/mhlo/transforms/rewriters.h"
#include "mlir/Dialect/StandardOps/IR/Ops.h"
#include "mlir/IR/MLIRContext.h"
#include "mlir/IR/Operation.h"
#include "mlir/Pass/Pass.h"
#include "mlir/Transforms/DialectConversion.h"
#include "mlir/Transforms/GreedyPatternRewriteDriver.h"

using mlir::FunctionPass;
using mlir::PassWrapper;

namespace {
class OptimizeMhloPass : public PassWrapper<OptimizeMhloPass, FunctionPass> {
 public:
  explicit OptimizeMhloPass() : PassWrapper<OptimizeMhloPass, FunctionPass>() {}

  /// Performs the lowering to MHLO dialect.
  void runOnFunction() override;
};
}  // end anonymous namespace

// Lowers the complex operations that can be represented using other operations.
void OptimizeMhloPass::runOnFunction() {
  // Add lowering patterns to the list.
  mlir::OwningRewritePatternList patterns(&getContext());
  mlir::mhlo::PopulateOptimizeMHLOPatterns(&getContext(), &patterns);

  (void)applyPatternsAndFoldGreedily(getFunction(), std::move(patterns));
}

std::unique_ptr<mlir::FunctionPass> mlir::mhlo::createOptimizeMhloPass() {
  return std::make_unique<OptimizeMhloPass>();
}
