# TensorFlow Lite Converter

The TensorFlow Lite Converter takes a TensorFlow graph file and creates a graph
file used by the TensorFlow Lite interpreter.

## From model training to device deployment

After a TensorFlow model is trained, the TensorFlow Lite converter uses that
model to generate a TensorFlow Lite
[FlatBuffer](https://google.github.io/flatbuffers/) file (`.tflite`). The
converter supports as input:
[SavedModels](https://www.tensorflow.org/guide/saved_model#using_savedmodel_with_estimators),
frozen graphs (models generated by
[freeze_graph.py](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/python/tools/freeze_graph.py)),
and `tf.keras` HDF5 models. The TensorFlow Lite `FlatBuffer` file is deployed to
a client device (generally a mobile or embedded device), and the TensorFlow Lite
interpreter uses the compressed model for on-device inference. This conversion
process is shown in the diagram below:

![TFLite converter workflow](../images/convert/workflow.svg)

The TensorFlow Lite Converter can be used either from [Python](python_api.md) or
from the [command line](cmdline_examples.md). This allows you to integrate the
conversion step into the model design workflow, ensuring the model is easy to
convert to a mobile inference graph.
