# -*- coding: utf-8 -*-
#
# rusty documentation build configuration file, created by
# sphinx-quickstart on Tue Nov 11 18:08:47 2008.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# The contents of this file are pickled, so don't put values in the namespace
# that aren't pickleable (module imports are okay, they're removed automatically).
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys, os

import sphinx

# If your extensions are in another directory, add it here. If the directory
# is relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#sys.path.append(os.path.abspath('.'))

# General configuration
# ---------------------

#sys.path = [os.path.dirname(__file__)] + sys.path
sys.path.append(os.path.abspath('..'))
from sphinxcontrib import exceltable

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
  'sphinx.ext.autodoc',
  'sphinx.ext.doctest',
  'sphinx.ext.todo',
  'sphinxcontrib.exceltable',
]

if sphinx.__version__.startswith('1.0'):
  extensions.append('sphinx.ext.extlinks')
  extlinks = {'issue': ('http://bitbucket.org/jmu/sphinxcontrib/issue/', 'issue ')}

# Add pdfbuilder if rst2pdf is available
try:
  from rst2pdf import pdfbuilder
  extensions.append('rst2pdf.pdfbuilder')

  pdf_documents = [
    ('index', 'sphinxcontrib.exceltable.alt', u'Sphinx-contrib Exceltable documentation',
     u'Juha Mustonen'),
  ]
  pdf_stylesheets = ['sphinx', 'kerning']
  pdf_break_level = 1
except ImportError:
  pass

# Add any paths that contain templates here, relative to this directory.
templates_path = ['static', '.templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Exceltable'
copyright = u'2008-2009, %s' % exceltable.__author__

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#


# The short X.Y version.
version = exceltable.__version__
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
#unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_trees = ['example']

# The reST default role (used for this markup: `text`) to use for all documents.
#default_role = None

highlight_language = 'bash'

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# Control whether todo lists are generated
todo_include_todos = True

rst_epilog = """
.. |sphinx| replace:: Sphinx documentation framework
.. include:: global.rst
"""


# Options for HTML output
# -----------------------

# The style sheet to use for HTML and HTML Help pages. A file of that name
# must exist either in Sphinx' static/ path, or in one of the custom paths
# given in html_static_path.
html_style = 'rusty.css'

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'static/exceltable.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
#html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = True

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, the reST sources are included in the HTML build as _sources/<name>.
html_copy_source = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'rusty'


# Options for LaTeX output
# ------------------------

# The paper size ('letter' or 'a4').
latex_paper_size = 'a4'

# The font size ('10pt', '11pt' or '12pt').
latex_font_size = '12pt'

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, document class [howto/manual]).
latex_documents = [
  ('index', 'rusty.tex', ur'Rusty documentation',
   ur'Juha Mustonen', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
latex_logo = 'static/rusty_big.png'

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
latex_use_parts = False

# Additional stuff for the LaTeX preamble.
latex_preamble = '''
'''

latex_elements = {
  'fncychap': '\\usepackage[Bjarne]{fncychap}',
  'fontpkg': '\\usepackage{palatino}'
}

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
latex_use_modindex = False


def setup(app):
  app.add_description_unit('confval', 'confval', 'pair: %s; configuration value')
  app.add_description_unit('bug', 'bug', 'pair: %s; bug')
  app.add_description_unit('task', 'task', 'pair: %s; task')
  app.add_description_unit('issue', 'issue', 'pair: %s; issue')
