# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005, updated 20180627
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

ADJECTIVES_WORDFORMS = {
'H-forma': ('H-forma',),
'H-formet': ('H-formet',),
'H-formete': ('H-formet',),
'H-formede': ('H-formet',),
'H-formete': ('H-formet',),
'H-formede': ('H-formet',),
'H-formet': ('H-formet',),
'PR-kåt': ('PR-kåt',),
'PR-kåte': ('PR-kåt',),
'PR-kåt': ('PR-kåt',),
'T-forma': ('T-forma',),
'T-formet': ('T-formet',),
'T-formete': ('T-formet',),
'T-formede': ('T-formet',),
'T-formete': ('T-formet',),
'T-formede': ('T-formet',),
'T-formet': ('T-formet',),
'U-forma': ('U-forma',),
'U-formet': ('U-formet',),
'U-formete': ('U-formet',),
'U-formede': ('U-formet',),
'U-formete': ('U-formet',),
'U-formede': ('U-formet',),
'U-formet': ('U-formet',),
'V-forma': ('V-forma',),
'V-formet': ('V-formet',),
'V-formete': ('V-formet',),
'V-formede': ('V-formet',),
'V-formete': ('V-formet',),
'V-formede': ('V-formet',),
'V-formet': ('V-formet',),
'abandonert': ('abandonere',),
'abandonerte': ('abandonere',),
'abandonerende': ('abandonere',),
'abbreviert': ('abbreviere',),
'abbrevierte': ('abbreviere',),
'abbrevierende': ('abbreviere',),
'abdisert': ('abdisere',),
'abdiserte': ('abdisere',),
'abdiserende': ('abdisere',),
'abdominal': ('abdominal',),
'abdominale': ('abdominal',),
'abdominalt': ('abdominal',),
'abessinsk': ('abessinsk',),
'abessinske': ('abessinsk',),
'abessinsk': ('abessinsk',),
'abkhasisk': ('abkhasisk',),
'abkhasiske': ('abkhasisk',),
'abkhasisk': ('abkhasisk',),
'ablativisk': ('ablativisk',),
'ablativiske': ('ablativisk',),
'ablativisk': ('ablativisk',),
'abnorm': ('abnorm',),
'abnorme': ('abnorm',),
'abnormt': ('abnorm',),
'abonnert': ('abonnere',),
'abonnerte': ('abonnere',),
'abonnerende': ('abonnere',),
'abortert': ('abortere',),
'aborterte': ('abortere',),
'aborterende': ('abortere',),
'abortiv': ('abortiv',),
'abortive': ('abortiv',),
'abortivt': ('abortiv',),
'abortsøkende': ('abortsøkende',),
'abrupt': ('abrupt',),
'abrupte': ('abrupt',),
'abrupt': ('abrupt',),
'absentert': ('absentere',),
'absenterte': ('absentere',),
'absenterende': ('absentere',),
'absolutistisk': ('absolutistisk',),
'absolutistiske': ('absolutistisk',),
'absolutistisk': ('absolutistisk',),
'absolutt': ('absolutt',),
'absolutte': ('absolutt',),
'absolutt': ('absolutt',),
'absolvert': ('absolvere',),
'absolverte': ('absolvere',),
'absolverende': ('absolvere',),
'absorbert': ('absorbere',),
'absorberte': ('absorbere',),
'absorberende': ('absorbere',),
'absorptiv': ('absorptiv',),
'absorptive': ('absorptiv',),
'absorptivt': ('absorptiv',),
'abstinent': ('abstinent',),
'abstinente': ('abstinent',),
'abstinent': ('abstinent',),
'abstrahert': ('abstrahere',),
'abstraherte': ('abstrahere',),
'abstraherende': ('abstrahere',),
'abstrakt': ('abstrakt',),
'abstrakte': ('abstrakt',),
'abstrakt': ('abstrakt',),
'absurd': ('absurd',),
'absurde': ('absurd',),
'absurd': ('absurd',),
'absurdistisk': ('absurdistisk',),
'absurdistiske': ('absurdistisk',),
'absurdistisk': ('absurdistisk',),
'adaptert': ('adaptere',),
'adapterte': ('adaptere',),
'adapterende': ('adaptere',),
'adaptiv': ('adaptiv',),
'adaptive': ('adaptiv',),
'adaptivt': ('adaptiv',),
'addert': ('addere',),
'adderte': ('addere',),
'adderende': ('addere',),
'additiv': ('additiv',),
'additive': ('additiv',),
'additivt': ('additiv',),
'adekvat': ('adekvat',),
'adekvate': ('adekvat',),
'adekvat': ('adekvat',),
'adelig': ('adelig',),
'adelige': ('adelig',),
'adelig': ('adelig',),
'adenoid': ('adenoid',),
'adenoide': ('adenoid',),
'adenoid': ('adenoid',),
'adgangsberettiga': ('adgangsberettiga',),
'adgangsberettiget': ('adgangsberettiget',),
'adgangsberettigete': ('adgangsberettiget',),
'adgangsberettigede': ('adgangsberettiget',),
'adgangsberettigete': ('adgangsberettiget',),
'adgangsberettigede': ('adgangsberettiget',),
'adgangsberettiget': ('adgangsberettiget',),
'adherert': ('adherere',),
'adhererte': ('adherere',),
'adhererende': ('adherere',),
'adjektivert': ('adjektivere',),
'adjektiverte': ('adjektivere',),
'adjektiverende': ('adjektivere',),
'adjektivisk': ('adjektivisk',),
'adjektiviske': ('adjektivisk',),
'adjektivisk': ('adjektivisk',),
'adla': ('adle',),
'adlet': ('adle',),
'adla': ('adle',),
'adlet': ('adle',),
'adla': ('adle',),
'adlete': ('adle',),
'adlede': ('adle',),
'adlete': ('adle',),
'adlede': ('adle',),
'adla': ('adle',),
'adlete': ('adle',),
'adlede': ('adle',),
'adlete': ('adle',),
'adlede': ('adle',),
'adlende': ('adle',),
'adlydt': ('adlyde',),
'adlydte': ('adlyde',),
'adlydende': ('adlyde',),
'administrativ': ('administrativ',),
'administrative': ('administrativ',),
'administrativt': ('administrativ',),
'administrert': ('administrere',),
'administrerte': ('administrere',),
'administrerende': ('administrere',),
'adonisk': ('adonisk',),
'adoniske': ('adonisk',),
'adonisk': ('adonisk',),
'adoptert': ('adoptere',),
'adopterte': ('adoptere',),
'adopterende': ('adoptere',),
'adresselaus': ('adresselaus',),
'adresselause': ('adresselaus',),
'adresselaust': ('adresselaus',),
'adresseløs': ('adresseløs',),
'adresseløse': ('adresseløs',),
'adresseløst': ('adresseløs',),
'adressert': ('adressere',),
'adresserte': ('adressere',),
'adresserende': ('adressere',),
'adsorbert': ('adsorbere',),
'adsorberte': ('adsorbere',),
'adsorberende': ('adsorbere',),
'adstadig': ('adstadig',),
'adstadige': ('adstadig',),
'adstadig': ('adstadig',),
'adstringert': ('adstringere',),
'adstringerte': ('adstringere',),
'adstringerende': ('adstringere',),
'advart': ('advare',),
'advarte': ('advare',),
'advarende': ('advare',),
'advarende': ('advarende',),
'adverbial': ('adverbial',),
'adverbiale': ('adverbial',),
'adverbialt': ('adverbial',),
'advisert': ('advisere',),
'adviserte': ('advisere',),
'adviserende': ('advisere',),
'advokatorisk': ('advokatorisk',),
'advokatoriske': ('advokatorisk',),
'advokatorisk': ('advokatorisk',),
'aerob': ('aerob',),
'aerobe': ('aerob',),
'aerobt': ('aerob',),
'aerodynamisk': ('aerodynamisk',),
'aerodynamiske': ('aerodynamisk',),
'aerodynamisk': ('aerodynamisk',),
'afatisk': ('afatisk',),
'afatiske': ('afatisk',),
'afatisk': ('afatisk',),
'affektert': ('affektere',),
'affekterte': ('affektere',),
'affekterende': ('affektere',),
'affektert': ('affektert',),
'affekterte': ('affektert',),
'affektert': ('affektert',),
'affektiv': ('affektiv',),
'affektive': ('affektiv',),
'affektivt': ('affektiv',),
'affektlada': ('affektlada',),
'affektladd': ('affektladd',),
'affektladde': ('affektladd',),
'affektladd': ('affektladd',),
'affektladet': ('affektladet',),
'affektladete': ('affektladet',),
'affektladede': ('affektladet',),
'affektladete': ('affektladet',),
'affektladede': ('affektladet',),
'affektladet': ('affektladet',),
'affisert': ('affisere',),
'affiserte': ('affisere',),
'affiserende': ('affisere',),
'afghansk': ('afghansk',),
'afghanske': ('afghansk',),
'afghansk': ('afghansk',),
'aforistisk': ('aforistisk',),
'aforistiske': ('aforistisk',),
'aforistisk': ('aforistisk',),
'afrikanisert': ('afrikanisere',),
'afrikaniserte': ('afrikanisere',),
'afrikaniserende': ('afrikanisere',),
'afrikansk': ('afrikansk',),
'afrikanske': ('afrikansk',),
'afrikansk': ('afrikansk',),
'afroamerikansk': ('afroamerikansk',),
'afroamerikanske': ('afroamerikansk',),
'afroamerikansk': ('afroamerikansk',),
'afroasiatisk': ('afroasiatisk',),
'afroasiatiske': ('afroasiatisk',),
'afroasiatisk': ('afroasiatisk',),
'aga': ('age',),
'aget': ('age',),
'aga': ('age',),
'aget': ('age',),
'aga': ('age',),
'agete': ('age',),
'agede': ('age',),
'aga': ('age',),
'agete': ('age',),
'agede': ('age',),
'agende': ('age',),
'agelaus': ('agelaus',),
'agelause': ('agelaus',),
'agelaust': ('agelaus',),
'ageløs': ('ageløs',),
'ageløse': ('ageløs',),
'ageløst': ('ageløs',),
'agert': ('agere',),
'agerte': ('agere',),
'agerende': ('agere',),
'agglutinert': ('agglutinere',),
'agglutinerte': ('agglutinere',),
'agglutinerende': ('agglutinere',),
'aggressiv': ('aggressiv',),
'aggressive': ('aggressiv',),
'aggressivt': ('aggressiv',),
'agitatorisk': ('agitatorisk',),
'agitatoriske': ('agitatorisk',),
'agitatorisk': ('agitatorisk',),
'agitert': ('agitere',),
'agiterte': ('agitere',),
'agiterende': ('agitere',),
'agnatisk': ('agnatisk',),
'agnatiske': ('agnatisk',),
'agnatisk': ('agnatisk',),
'agna': ('agne',),
'agnet': ('agne',),
'agna': ('agne',),
'agnet': ('agne',),
'agna': ('agne',),
'agnete': ('agne',),
'agnede': ('agne',),
'agna': ('agne',),
'agnete': ('agne',),
'agnede': ('agne',),
'agnende': ('agne',),
'agnostisk': ('agnostisk',),
'agnostiske': ('agnostisk',),
'agnostisk': ('agnostisk',),
'agrarisk': ('agrarisk',),
'agrariske': ('agrarisk',),
'agrarisk': ('agrarisk',),
'agronomisk': ('agronomisk',),
'agronomiske': ('agronomisk',),
'agronomisk': ('agronomisk',),
'ahistorisk': ('ahistorisk',),
'ahistoriske': ('ahistorisk',),
'ahistorisk': ('ahistorisk',),
'ajourført': ('ajourføre',),
'ajourførte': ('ajourføre',),
'ajourførende': ('ajourføre',),
'akademisk': ('akademisk',),
'akademiske': ('akademisk',),
'akademisk': ('akademisk',),
'akt': ('ake',),
'akte': ('ake',),
'akende': ('ake',),
'akka': ('akke',),
'akket': ('akke',),
'akka': ('akke',),
'akket': ('akke',),
'akka': ('akke',),
'akkete': ('akke',),
'akkede': ('akke',),
'akka': ('akke',),
'akkete': ('akke',),
'akkede': ('akke',),
'akkende': ('akke',),
'akkedert': ('akkedere',),
'akkederte': ('akkedere',),
'akkederende': ('akkedere',),
'akklimatisert': ('akklimatisere',),
'akklimatiserte': ('akklimatisere',),
'akklimatiserende': ('akklimatisere',),
'akkommodert': ('akkommodere',),
'akkommoderte': ('akkommodere',),
'akkommoderende': ('akkommodere',),
'akkompagnert': ('akkompagnere',),
'akkompagnerte': ('akkompagnere',),
'akkompagnerende': ('akkompagnere',),
'akkordert': ('akkordere',),
'akkorderte': ('akkordere',),
'akkorderende': ('akkordere',),
'akkreditert': ('akkreditere',),
'akkrediterte': ('akkreditere',),
'akkrediterende': ('akkreditere',),
'akkumulert': ('akkumulere',),
'akkumulerte': ('akkumulere',),
'akkumulerende': ('akkumulere',),
'akkusativisk': ('akkusativisk',),
'akkusativiske': ('akkusativisk',),
'akkusativisk': ('akkusativisk',),
'akkvirert': ('akkvirere',),
'akkvirerte': ('akkvirere',),
'akkvirerende': ('akkvirere',),
'akrobatisk': ('akrobatisk',),
'akrobatiske': ('akrobatisk',),
'akrobatisk': ('akrobatisk',),
'akromatisk': ('akromatisk',),
'akromatiske': ('akromatisk',),
'akromatisk': ('akromatisk',),
'akselbred': ('akselbred',),
'akselbrede': ('akselbred',),
'akselbredt': ('akselbred',),
'akselbrei': ('akselbrei',),
'akselbreie': ('akselbrei',),
'akselbreit': ('akselbrei',),
'akselerert': ('akselerere',),
'akselererte': ('akselerere',),
'akselererende': ('akselerere',),
'aksentuert': ('aksentuere',),
'aksentuerte': ('aksentuere',),
'aksentuerende': ('aksentuere',),
'akseptabel': ('akseptabel',),
'akseptable': ('akseptabel',),
'akseptabelt': ('akseptabel',),
'akseptert': ('akseptere',),
'aksepterte': ('akseptere',),
'aksepterende': ('akseptere',),
'aksessorisk': ('aksessorisk',),
'aksessoriske': ('aksessorisk',),
'aksessorisk': ('aksessorisk',),
'aksial': ('aksial',),
'aksiale': ('aksial',),
'aksialt': ('aksial',),
'aksiomatisk': ('aksiomatisk',),
'aksiomatiske': ('aksiomatisk',),
'aksiomatisk': ('aksiomatisk',),
'aksjonert': ('aksjonere',),
'aksjonerte': ('aksjonere',),
'aksjonerende': ('aksjonere',),
'aksla': ('aksle',),
'akslet': ('aksle',),
'aksla': ('aksle',),
'akslet': ('aksle',),
'aksla': ('aksle',),
'akslete': ('aksle',),
'akslede': ('aksle',),
'akslete': ('aksle',),
'akslede': ('aksle',),
'aksla': ('aksle',),
'akslete': ('aksle',),
'akslede': ('aksle',),
'akslete': ('aksle',),
'akslede': ('aksle',),
'akslende': ('aksle',),
'akslebred': ('akslebred',),
'akslebrede': ('akslebred',),
'akslebredt': ('akslebred',),
'akslebrei': ('akslebrei',),
'akslebreie': ('akslebrei',),
'akslebreit': ('akslebrei',),
'akta': ('akta',),
'akta': ('akte',),
'aktet': ('akte',),
'akta': ('akte',),
'aktet': ('akte',),
'akta': ('akte',),
'aktete': ('akte',),
'aktede': ('akte',),
'akta': ('akte',),
'aktete': ('akte',),
'aktede': ('akte',),
'aktende': ('akte',),
'akterlig': ('akterlig',),
'akterlige': ('akterlig',),
'akterlig': ('akterlig',),
'akterst': ('akterst',),
'akterste': ('akterst',),
'akterst': ('akterst',),
'akterutsegla': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutseglete': ('akterutsegle',),
'akterutseglede': ('akterutsegle',),
'akterutseglete': ('akterutsegle',),
'akterutseglede': ('akterutsegle',),
'akterutsegla': ('akterutsegle',),
'akterutseglete': ('akterutsegle',),
'akterutseglede': ('akterutsegle',),
'akterutseglete': ('akterutsegle',),
'akterutseglede': ('akterutsegle',),
'akterutseglende': ('akterutsegle',),
'akterutseilt': ('akterutseile',),
'akterutseilte': ('akterutseile',),
'akterutseilende': ('akterutseile',),
'aktet': ('aktet',),
'aktete': ('aktet',),
'aktede': ('aktet',),
'aktete': ('aktet',),
'aktede': ('aktet',),
'aktet': ('aktet',),
'aktiv': ('aktiv',),
'aktive': ('aktiv',),
'aktivt': ('aktiv',),
'aktivert': ('aktivere',),
'aktiverte': ('aktivere',),
'aktiverende': ('aktivere',),
'aktivisert': ('aktivisere',),
'aktiviserte': ('aktivisere',),
'aktiviserende': ('aktivisere',),
'aktivistisk': ('aktivistisk',),
'aktivistiske': ('aktivistisk',),
'aktivistisk': ('aktivistisk',),
'aktpågivende': ('aktpågivende',),
'aktre': ('aktre',),
'akterst': ('aktre',),
'akterste': ('aktre',),
'aktsom': ('aktsom',),
'aktsomme': ('aktsom',),
'aktsomt': ('aktsom',),
'aktualisert': ('aktualisere',),
'aktualiserte': ('aktualisere',),
'aktualiserende': ('aktualisere',),
'aktuell': ('aktuell',),
'aktuelle': ('aktuell',),
'aktuelt': ('aktuell',),
'aktverdig': ('aktverdig',),
'aktverdige': ('aktverdig',),
'aktverdig': ('aktverdig',),
'akustisk': ('akustisk',),
'akustiske': ('akustisk',),
'akustisk': ('akustisk',),
'akutt': ('akutt',),
'akutte': ('akutt',),
'akutt': ('akutt',),
'akvatisk': ('akvatisk',),
'akvatiske': ('akvatisk',),
'akvatisk': ('akvatisk',),
'alabasthvit': ('alabasthvit',),
'alabasthvite': ('alabasthvit',),
'alabasthvitt': ('alabasthvit',),
'alabastkvit': ('alabastkvit',),
'alabastkvite': ('alabastkvit',),
'alabastkvitt': ('alabastkvit',),
'alarmert': ('alarmere',),
'alarmerte': ('alarmere',),
'alarmerende': ('alarmere',),
'alarmerende': ('alarmerende',),
'alaskisk': ('alaskisk',),
'alaskiske': ('alaskisk',),
'alaskisk': ('alaskisk',),
'albansk': ('albansk',),
'albanske': ('albansk',),
'albansk': ('albansk',),
'albin': ('albin',),
'albine': ('albin',),
'albint': ('albin',),
'albua': ('albue',),
'albuet': ('albue',),
'albua': ('albue',),
'albuet': ('albue',),
'albua': ('albue',),
'albuete': ('albue',),
'albuede': ('albue',),
'albua': ('albue',),
'albuete': ('albue',),
'albuede': ('albue',),
'albuende': ('albue',),
'alderdommelig': ('alderdommelig',),
'alderdommelige': ('alderdommelig',),
'alderdommelig': ('alderdommelig',),
'alderdomssløv': ('alderdomssløv',),
'alderdomssløve': ('alderdomssløv',),
'alderdomssløvt': ('alderdomssløv',),
'aldersbestemt': ('aldersbestemme',),
'aldersbestemte': ('aldersbestemme',),
'aldersbestemmende': ('aldersbestemme',),
'alderstegen': ('alderstegen',),
'alderstegne': ('alderstegen',),
'alderstegent': ('alderstegen',),
'aldra': ('aldre',),
'aldret': ('aldre',),
'aldra': ('aldre',),
'aldret': ('aldre',),
'aldra': ('aldre',),
'aldrete': ('aldre',),
'aldrede': ('aldre',),
'aldrete': ('aldre',),
'aldrede': ('aldre',),
'aldra': ('aldre',),
'aldrete': ('aldre',),
'aldrede': ('aldre',),
'aldrete': ('aldre',),
'aldrede': ('aldre',),
'aldrende': ('aldre',),
'aldrende': ('aldrende',),
'aldringsbestandig': ('aldringsbestandig',),
'aldringsbestandige': ('aldringsbestandig',),
'aldringsbestandig': ('aldringsbestandig',),
'alet': ('ale',),
'alt': ('ale',),
'alet': ('ale',),
'alt': ('ale',),
'alete': ('ale',),
'alede': ('ale',),
'alte': ('ale',),
'alete': ('ale',),
'alede': ('ale',),
'alte': ('ale',),
'alende': ('ale',),
'aleksandrinsk': ('aleksandrinsk',),
'aleksandrinske': ('aleksandrinsk',),
'aleksandrinsk': ('aleksandrinsk',),
'alemannisk': ('alemannisk',),
'alemanniske': ('alemannisk',),
'alemannisk': ('alemannisk',),
'aleutisk': ('aleutisk',),
'aleutiske': ('aleutisk',),
'aleutisk': ('aleutisk',),
'alfabetisert': ('alfabetisere',),
'alfabetiserte': ('alfabetisere',),
'alfabetiserende': ('alfabetisere',),
'alfabetisk': ('alfabetisk',),
'alfabetiske': ('alfabetisk',),
'alfabetisk': ('alfabetisk',),
'alfanumerisk': ('alfanumerisk',),
'alfanumeriske': ('alfanumerisk',),
'alfanumerisk': ('alfanumerisk',),
'algebraisk': ('algebraisk',),
'algebraiske': ('algebraisk',),
'algebraisk': ('algebraisk',),
'algerisk': ('algerisk',),
'algeriske': ('algerisk',),
'algerisk': ('algerisk',),
'algonkinsk': ('algonkinsk',),
'algonkinske': ('algonkinsk',),
'algonkinsk': ('algonkinsk',),
'alienert': ('alienere',),
'alienerte': ('alienere',),
'alienerende': ('alienere',),
'alifatisk': ('alifatisk',),
'alifatiske': ('alifatisk',),
'alifatisk': ('alifatisk',),
'alkalisk': ('alkalisk',),
'alkaliske': ('alkalisk',),
'alkalisk': ('alkalisk',),
'alkoholholdig': ('alkoholholdig',),
'alkoholholdige': ('alkoholholdig',),
'alkoholholdig': ('alkoholholdig',),
'alkoholisert': ('alkoholisere',),
'alkoholiserte': ('alkoholisere',),
'alkoholiserende': ('alkoholisere',),
'alkoholisk': ('alkoholisk',),
'alkoholiske': ('alkoholisk',),
'alkoholisk': ('alkoholisk',),
'alkoholpåvirka': ('alkoholpåvirka',),
'alkoholpåvirket': ('alkoholpåvirket',),
'alkoholpåvirkete': ('alkoholpåvirket',),
'alkoholpåvirkede': ('alkoholpåvirket',),
'alkoholpåvirkete': ('alkoholpåvirket',),
'alkoholpåvirkede': ('alkoholpåvirket',),
'alkoholpåvirket': ('alkoholpåvirket',),
'alkoholskada': ('alkoholskada',),
'alkoholskadd': ('alkoholskadd',),
'alkoholskadde': ('alkoholskadd',),
'alkoholskadd': ('alkoholskadd',),
'alkoholskadet': ('alkoholskadet',),
'alkoholskadete': ('alkoholskadet',),
'alkoholskadede': ('alkoholskadet',),
'alkoholskadete': ('alkoholskadet',),
'alkoholskadede': ('alkoholskadet',),
'alkoholskadet': ('alkoholskadet',),
'alkoholsvak': ('alkoholsvak',),
'alkoholsvake': ('alkoholsvak',),
'alkoholsvakt': ('alkoholsvak',),
'all right': ('all right',),
'all righte': ('all right',),
'all right': ('all right',),
'all righte': ('all right',),
'all right': ('all right',),
'all slags': ('all slags',),
'allegorisk': ('allegorisk',),
'allegoriske': ('allegorisk',),
'allegorisk': ('allegorisk',),
'allehånde': ('allehånde',),
'allel': ('allel',),
'allele': ('allel',),
'allelt': ('allel',),
'allergisk': ('allergisk',),
'allergiske': ('allergisk',),
'allergisk': ('allergisk',),
'allestedsnærværende': ('allestedsnærværende',),
'alleuropeisk': ('alleuropeisk',),
'alleuropeiske': ('alleuropeisk',),
'alleuropeisk': ('alleuropeisk',),
'alliert': ('alliere',),
'allierte': ('alliere',),
'allierende': ('alliere',),
'alliert': ('alliert',),
'allierte': ('alliert',),
'alliert': ('alliert',),
'allitterert': ('allitterere',),
'allittererte': ('allitterere',),
'allittererende': ('allitterere',),
'allmektig': ('allmektig',),
'allmektige': ('allmektig',),
'allmektig': ('allmektig',),
'allmenn': ('allmenn',),
'allmenne': ('allmenn',),
'allment': ('allmenn',),
'allmenn-nyttig': ('allmenn-nyttig',),
'allmenn-nyttige': ('allmenn-nyttig',),
'allmenn-nyttig': ('allmenn-nyttig',),
'allmenndannende': ('allmenndannende',),
'allmenngyldig': ('allmenngyldig',),
'allmenngyldige': ('allmenngyldig',),
'allmenngyldig': ('allmenngyldig',),
'allmennmenneskelig': ('allmennmenneskelig',),
'allmennmenneskelige': ('allmennmenneskelig',),
'allmennmenneskelig': ('allmennmenneskelig',),
'allmennpraktiserende': ('allmennpraktiserende',),
'allmennpreventiv': ('allmennpreventiv',),
'allmennpreventive': ('allmennpreventiv',),
'allmennpreventivt': ('allmennpreventiv',),
'allmennyttig': ('allmennyttig',),
'allmennyttige': ('allmennyttig',),
'allmennyttig': ('allmennyttig',),
'allofonisk': ('allofonisk',),
'allofoniske': ('allofonisk',),
'allofonisk': ('allofonisk',),
'allokert': ('allokere',),
'allokerte': ('allokere',),
'allokerende': ('allokere',),
'allomorfisk': ('allomorfisk',),
'allomorfiske': ('allomorfisk',),
'allomorfisk': ('allomorfisk',),
'allsidig': ('allsidig',),
'allsidige': ('allsidig',),
'allsidig': ('allsidig',),
'allslags': ('allslags',),
'alltysk': ('alltysk',),
'alltyske': ('alltysk',),
'alltysk': ('alltysk',),
'alludert': ('alludere',),
'alluderte': ('alludere',),
'alluderende': ('alludere',),
'alluvial': ('alluvial',),
'alluviale': ('alluvial',),
'alluvialt': ('alluvial',),
'allvitende': ('allvitende',),
'alminnelig': ('alminnelig',),
'alminnelige': ('alminnelig',),
'alminnelig': ('alminnelig',),
'alminneligere': ('alminnelig',),
'alminneligst': ('alminnelig',),
'alminneligste': ('alminnelig',),
'alpin': ('alpin',),
'alpine': ('alpin',),
'alpint': ('alpin',),
'alpinsk': ('alpinsk',),
'alpinske': ('alpinsk',),
'alpinsk': ('alpinsk',),
'alsasisk': ('alsasisk',),
'alsasiske': ('alsasisk',),
'alsasisk': ('alsasisk',),
'alskens': ('alskens',),
'altaisk': ('altaisk',),
'altaiske': ('altaisk',),
'altaisk': ('altaisk',),
'alterert': ('alterere',),
'altererte': ('alterere',),
'altererende': ('alterere',),
'alternativ': ('alternativ',),
'alternative': ('alternativ',),
'alternativt': ('alternativ',),
'alternert': ('alternere',),
'alternerte': ('alternere',),
'alternerende': ('alternere',),
'altetende': ('altetende',),
'altgjennomtrengende': ('altgjennomtrengende',),
'altomfattende': ('altomfattende',),
'altomspennende': ('altomspennende',),
'altoppslukende': ('altoppslukende',),
'altruistisk': ('altruistisk',),
'altruistiske': ('altruistisk',),
'altruistisk': ('altruistisk',),
'aluminert': ('aluminere',),
'aluminerte': ('aluminere',),
'aluminerende': ('aluminere',),
'alveolar': ('alveolar',),
'alveolare': ('alveolar',),
'alveolart': ('alveolar',),
'alvorlig': ('alvorlig',),
'alvorlige': ('alvorlig',),
'alvorlig': ('alvorlig',),
'alvorligere': ('alvorlig',),
'alvorligst': ('alvorlig',),
'alvorligste': ('alvorlig',),
'alvorsfull': ('alvorsfull',),
'alvorsfulle': ('alvorsfull',),
'alvorsfullt': ('alvorsfull',),
'alvorstung': ('alvorstung',),
'alvorstunge': ('alvorstung',),
'alvorstungt': ('alvorstung',),
'amalgamert': ('amalgamere',),
'amalgamerte': ('amalgamere',),
'amalgamerende': ('amalgamere',),
'amatørmessig': ('amatørmessig',),
'amatørmessige': ('amatørmessig',),
'amatørmessig': ('amatørmessig',),
'ambiguøs': ('ambiguøs',),
'ambiguøse': ('ambiguøs',),
'ambiguøst': ('ambiguøs',),
'ambisiøs': ('ambisiøs',),
'ambisiøse': ('ambisiøs',),
'ambisiøst': ('ambisiøs',),
'ambivalent': ('ambivalent',),
'ambivalente': ('ambivalent',),
'ambivalent': ('ambivalent',),
'ambrosiansk': ('ambrosiansk',),
'ambrosianske': ('ambrosiansk',),
'ambrosiansk': ('ambrosiansk',),
'ambrosisk': ('ambrosisk',),
'ambrosiske': ('ambrosisk',),
'ambrosisk': ('ambrosisk',),
'ambulant': ('ambulant',),
'ambulante': ('ambulant',),
'ambulant': ('ambulant',),
'ambulatorisk': ('ambulatorisk',),
'ambulatoriske': ('ambulatorisk',),
'ambulatorisk': ('ambulatorisk',),
'ambulert': ('ambulere',),
'ambulerte': ('ambulere',),
'ambulerende': ('ambulere',),
'ambulerende': ('ambulerende',),
'amerikanisert': ('amerikanisere',),
'amerikaniserte': ('amerikanisere',),
'amerikaniserende': ('amerikanisere',),
'amerikansk': ('amerikansk',),
'amerikanske': ('amerikansk',),
'amerikansk': ('amerikansk',),
'amfibisk': ('amfibisk',),
'amfibiske': ('amfibisk',),
'amfibisk': ('amfibisk',),
'amma': ('amme',),
'ammet': ('amme',),
'amma': ('amme',),
'ammet': ('amme',),
'amma': ('amme',),
'ammete': ('amme',),
'ammede': ('amme',),
'amma': ('amme',),
'ammete': ('amme',),
'ammede': ('amme',),
'ammende': ('amme',),
'amoralsk': ('amoralsk',),
'amoralske': ('amoralsk',),
'amoralsk': ('amoralsk',),
'amorf': ('amorf',),
'amorfe': ('amorf',),
'amorft': ('amorf',),
'amortisabel': ('amortisabel',),
'amortisable': ('amortisabel',),
'amortisabelt': ('amortisabel',),
'amortisert': ('amortisere',),
'amortiserte': ('amortisere',),
'amortiserende': ('amortisere',),
'amorøs': ('amorøs',),
'amorøse': ('amorøs',),
'amorøst': ('amorøs',),
'amper': ('amper',),
'ampre': ('amper',),
'ampert': ('amper',),
'amputert': ('amputere',),
'amputerte': ('amputere',),
'amputerende': ('amputere',),
'amøbisk': ('amøbisk',),
'amøbiske': ('amøbisk',),
'amøbisk': ('amøbisk',),
'amøboid': ('amøboid',),
'amøboide': ('amøboid',),
'amøboid': ('amøboid',),
'anabol': ('anabol',),
'anabole': ('anabol',),
'anabolt': ('anabol',),
'anabolsk': ('anabolsk',),
'anabolske': ('anabolsk',),
'anabolsk': ('anabolsk',),
'anaerob': ('anaerob',),
'anaerobe': ('anaerob',),
'anaerobt': ('anaerob',),
'anaforisk': ('anaforisk',),
'anaforiske': ('anaforisk',),
'anaforisk': ('anaforisk',),
'anakolutisk': ('anakolutisk',),
'anakolutiske': ('anakolutisk',),
'anakolutisk': ('anakolutisk',),
'anakreontisk': ('anakreontisk',),
'anakreontiske': ('anakreontisk',),
'anakreontisk': ('anakreontisk',),
'anakronistisk': ('anakronistisk',),
'anakronistiske': ('anakronistisk',),
'anakronistisk': ('anakronistisk',),
'anal': ('anal',),
'anale': ('anal',),
'analt': ('anal',),
'analog': ('analog',),
'analoge': ('analog',),
'analogt': ('analog',),
'analogisk': ('analogisk',),
'analogiske': ('analogisk',),
'analogisk': ('analogisk',),
'analysert': ('analysere',),
'analyserte': ('analysere',),
'analyserende': ('analysere',),
'analytisk': ('analytisk',),
'analytiske': ('analytisk',),
'analytisk': ('analytisk',),
'anapestisk': ('anapestisk',),
'anapestiske': ('anapestisk',),
'anapestisk': ('anapestisk',),
'anarkisk': ('anarkisk',),
'anarkiske': ('anarkisk',),
'anarkisk': ('anarkisk',),
'anarkistisk': ('anarkistisk',),
'anarkistiske': ('anarkistisk',),
'anarkistisk': ('anarkistisk',),
'anatomisk': ('anatomisk',),
'anatomiske': ('anatomisk',),
'anatomisk': ('anatomisk',),
'anbefalt': ('anbefale',),
'anbefalte': ('anbefale',),
'anbefalende': ('anbefale',),
'anbefalelsesverdig': ('anbefalelsesverdig',),
'anbefalelsesverdige': ('anbefalelsesverdig',),
'anbefalelsesverdig': ('anbefalelsesverdig',),
'anbrakt': ('anbringe',),
'anbrakte': ('anbringe',),
'anbringende': ('anbringe',),
'andaktsfull': ('andaktsfull',),
'andaktsfulle': ('andaktsfull',),
'andaktsfullt': ('andaktsfull',),
'andalusisk': ('andalusisk',),
'andalusiske': ('andalusisk',),
'andalusisk': ('andalusisk',),
'anda': ('ande',),
'andet': ('ande',),
'anda': ('ande',),
'andet': ('ande',),
'anda': ('ande',),
'andete': ('ande',),
'andede': ('ande',),
'anda': ('ande',),
'andete': ('ande',),
'andede': ('ande',),
'andende': ('ande',),
'andektig': ('andektig',),
'andektige': ('andektig',),
'andektig': ('andektig',),
'andinsk': ('andinsk',),
'andinske': ('andinsk',),
'andinsk': ('andinsk',),
'andorransk': ('andorransk',),
'andorranske': ('andorransk',),
'andorransk': ('andorransk',),
'andpusten': ('andpusten',),
'andpustne': ('andpusten',),
'andpustent': ('andpusten',),
'andradd': ('andra',),
'andratt': ('andra',),
'andradd': ('andra',),
'andratt': ('andra',),
'andradd': ('andra',),
'andratt': ('andra',),
'andradd': ('andra',),
'andratt': ('andra',),
'andradde': ('andra',),
'andratte': ('andra',),
'andradde': ('andra',),
'andratte': ('andra',),
'andradde': ('andra',),
'andratte': ('andra',),
'andradde': ('andra',),
'andratte': ('andra',),
'andragende': ('andra',),
'andre': ('andre',),
'andrehands': ('andrehands',),
'andrehånds': ('andrehånds',),
'andreklasses': ('andreklasses',),
'andrerangs': ('andrerangs',),
'androgen': ('androgen',),
'androgene': ('androgen',),
'androgent': ('androgen',),
'androgyn': ('androgyn',),
'androgyne': ('androgyn',),
'androgynt': ('androgyn',),
'anduva': ('anduve',),
'anduvet': ('anduve',),
'anduva': ('anduve',),
'anduvet': ('anduve',),
'anduva': ('anduve',),
'anduvete': ('anduve',),
'anduvede': ('anduve',),
'anduva': ('anduve',),
'anduvete': ('anduve',),
'anduvede': ('anduve',),
'anduvende': ('anduve',),
'andøvet': ('andøve',),
'andøvd': ('andøve',),
'andøvet': ('andøve',),
'andøvd': ('andøve',),
'andøvete': ('andøve',),
'andøvede': ('andøve',),
'andøvde': ('andøve',),
'andøvete': ('andøve',),
'andøvede': ('andøve',),
'andøvde': ('andøve',),
'andøvende': ('andøve',),
'ant': ('ane',),
'ante': ('ane',),
'anende': ('ane',),
'anekdotisk': ('anekdotisk',),
'anekdotiske': ('anekdotisk',),
'anekdotisk': ('anekdotisk',),
'anemisk': ('anemisk',),
'anemiske': ('anemisk',),
'anemisk': ('anemisk',),
'anemofil': ('anemofil',),
'anemofile': ('anemofil',),
'anemofilt': ('anemofil',),
'anerkjent': ('anerkjenne',),
'anerkjente': ('anerkjenne',),
'anerkjennende': ('anerkjenne',),
'anerkjennelsesverdig': ('anerkjennelsesverdig',),
'anerkjennelsesverdige': ('anerkjennelsesverdig',),
'anerkjennelsesverdig': ('anerkjennelsesverdig',),
'anerkjennende': ('anerkjennende',),
'anerkjent': ('anerkjent',),
'anerkjente': ('anerkjent',),
'anerkjent': ('anerkjent',),
'anestesert': ('anestesere',),
'anesteserte': ('anestesere',),
'anesteserende': ('anestesere',),
'anestetisk': ('anestetisk',),
'anestetiske': ('anestetisk',),
'anestetisk': ('anestetisk',),
'anfalt': ('anfalle',),
'anfalte': ('anfalle',),
'anfallende': ('anfalle',),
'anfekta': ('anfekte',),
'anfektet': ('anfekte',),
'anfekta': ('anfekte',),
'anfektet': ('anfekte',),
'anfekta': ('anfekte',),
'anfektete': ('anfekte',),
'anfektede': ('anfekte',),
'anfekta': ('anfekte',),
'anfektete': ('anfekte',),
'anfektede': ('anfekte',),
'anfektende': ('anfekte',),
'anført': ('anføre',),
'anførte': ('anføre',),
'anførende': ('anføre',),
'anga': ('ange',),
'anget': ('ange',),
'anga': ('ange',),
'anget': ('ange',),
'anga': ('ange',),
'angete': ('ange',),
'angede': ('ange',),
'anga': ('ange',),
'angete': ('ange',),
'angede': ('ange',),
'angende': ('ange',),
'angelsaksisk': ('angelsaksisk',),
'angelsaksiske': ('angelsaksisk',),
'angelsaksisk': ('angelsaksisk',),
'angerfull': ('angerfull',),
'angerfulle': ('angerfull',),
'angerfullt': ('angerfull',),
'angitt': ('angi',),
'angitte': ('angi',),
'angiende': ('angi',),
'angivelig': ('angivelig',),
'angivelige': ('angivelig',),
'angivelig': ('angivelig',),
'angiversk': ('angiversk',),
'angiverske': ('angiversk',),
'angiversk': ('angiversk',),
'angjeldende': ('angjeldende',),
'angla': ('angle',),
'anglet': ('angle',),
'angla': ('angle',),
'anglet': ('angle',),
'angla': ('angle',),
'anglete': ('angle',),
'anglede': ('angle',),
'anglete': ('angle',),
'anglede': ('angle',),
'angla': ('angle',),
'anglete': ('angle',),
'anglede': ('angle',),
'anglete': ('angle',),
'anglede': ('angle',),
'anglende': ('angle',),
'anglifisert': ('anglifisere',),
'anglifiserte': ('anglifisere',),
'anglifiserende': ('anglifisere',),
'anglikansk': ('anglikansk',),
'anglikanske': ('anglikansk',),
'anglikansk': ('anglikansk',),
'anglisert': ('anglisere',),
'angliserte': ('anglisere',),
'angliserende': ('anglisere',),
'angloamerikansk': ('angloamerikansk',),
'angloamerikanske': ('angloamerikansk',),
'angloamerikansk': ('angloamerikansk',),
'anglofil': ('anglofil',),
'anglofile': ('anglofil',),
'anglofilt': ('anglofil',),
'angolansk': ('angolansk',),
'angolanske': ('angolansk',),
'angolansk': ('angolansk',),
'angra': ('angre',),
'angret': ('angre',),
'angra': ('angre',),
'angret': ('angre',),
'angra': ('angre',),
'angrete': ('angre',),
'angrede': ('angre',),
'angrete': ('angre',),
'angrede': ('angre',),
'angra': ('angre',),
'angrete': ('angre',),
'angrede': ('angre',),
'angrete': ('angre',),
'angrede': ('angre',),
'angrende': ('angre',),
'angrende': ('angrende',),
'angrepslysten': ('angrepslysten',),
'angrepslystne': ('angrepslysten',),
'angrepslystent': ('angrepslysten',),
'angrepet': ('angripe',),
'angrepen': ('angripe',),
'angrepne': ('angripe',),
'angripende': ('angripe',),
'angripelig': ('angripelig',),
'angripelige': ('angripelig',),
'angripelig': ('angripelig',),
'angstbitersk': ('angstbitersk',),
'angstbiterske': ('angstbitersk',),
'angstbitersk': ('angstbitersk',),
'angulær': ('angulær',),
'angulære': ('angulær',),
'angulært': ('angulær',),
'angått': ('angå',),
'angåtte': ('angå',),
'angående': ('angå',),
'anholdt': ('anholde',),
'anholdte': ('anholde',),
'anholdende': ('anholde',),
'animal': ('animal',),
'animale': ('animal',),
'animalt': ('animal',),
'animalisert': ('animalisere',),
'animaliserte': ('animalisere',),
'animaliserende': ('animalisere',),
'animalsk': ('animalsk',),
'animalske': ('animalsk',),
'animalsk': ('animalsk',),
'animert': ('animere',),
'animerte': ('animere',),
'animerende': ('animere',),
'animistisk': ('animistisk',),
'animistiske': ('animistisk',),
'animistisk': ('animistisk',),
'anka': ('anke',),
'anket': ('anke',),
'anka': ('anke',),
'anket': ('anke',),
'anka': ('anke',),
'ankete': ('anke',),
'ankede': ('anke',),
'anka': ('anke',),
'ankete': ('anke',),
'ankede': ('anke',),
'ankende': ('anke',),
'ankeldjup': ('ankeldjup',),
'ankeldjupe': ('ankeldjup',),
'ankeldjupt': ('ankeldjup',),
'ankeldyp': ('ankeldyp',),
'ankeldype': ('ankeldyp',),
'ankeldypt': ('ankeldyp',),
'ankelsid': ('ankelsid',),
'ankelside': ('ankelsid',),
'ankelsidt': ('ankelsid',),
'anklaga': ('anklage',),
'anklaget': ('anklage',),
'anklagd': ('anklage',),
'anklaga': ('anklage',),
'anklaget': ('anklage',),
'anklagd': ('anklage',),
'anklaga': ('anklage',),
'anklagete': ('anklage',),
'anklagede': ('anklage',),
'anklagde': ('anklage',),
'anklaga': ('anklage',),
'anklagete': ('anklage',),
'anklagede': ('anklage',),
'anklagde': ('anklage',),
'anklagende': ('anklage',),
'ankommet': ('ankomme',),
'ankommen': ('ankomme',),
'ankomne': ('ankomme',),
'ankommende': ('ankomme',),
'ankra': ('ankre',),
'ankret': ('ankre',),
'ankra': ('ankre',),
'ankret': ('ankre',),
'ankra': ('ankre',),
'ankrete': ('ankre',),
'ankrede': ('ankre',),
'ankrete': ('ankre',),
'ankrede': ('ankre',),
'ankra': ('ankre',),
'ankrete': ('ankre',),
'ankrede': ('ankre',),
'ankrete': ('ankre',),
'ankrede': ('ankre',),
'ankrende': ('ankre',),
'anlagt': ('anlagt',),
'anlagte': ('anlagt',),
'anlagt': ('anlagt',),
'anlagt': ('anlegge',),
'anlagte': ('anlegge',),
'anleggende': ('anlegge',),
'anløpt': ('anløpe',),
'anløpet': ('anløpe',),
'anløpt': ('anløpe',),
'anløpet': ('anløpe',),
'anløpte': ('anløpe',),
'anløpende': ('anløpe',),
'anløpen': ('anløpen',),
'anløpne': ('anløpen',),
'anløpent': ('anløpen',),
'anmassa': ('anmasse',),
'anmasset': ('anmasse',),
'anmassa': ('anmasse',),
'anmasset': ('anmasse',),
'anmassa': ('anmasse',),
'anmassete': ('anmasse',),
'anmassede': ('anmasse',),
'anmassa': ('anmasse',),
'anmassete': ('anmasse',),
'anmassede': ('anmasse',),
'anmassende': ('anmasse',),
'anmassende': ('anmassende',),
'anmeldt': ('anmelde',),
'anmeldte': ('anmelde',),
'anmeldende': ('anmelde',),
'anmerka': ('anmerke',),
'anmerket': ('anmerke',),
'anmerka': ('anmerke',),
'anmerket': ('anmerke',),
'anmerka': ('anmerke',),
'anmerkete': ('anmerke',),
'anmerkede': ('anmerke',),
'anmerka': ('anmerke',),
'anmerkete': ('anmerke',),
'anmerkede': ('anmerke',),
'anmerkende': ('anmerke',),
'anmoda': ('anmode',),
'anmodet': ('anmode',),
'anmoda': ('anmode',),
'anmodet': ('anmode',),
'anmoda': ('anmode',),
'anmodete': ('anmode',),
'anmodede': ('anmode',),
'anmoda': ('anmode',),
'anmodete': ('anmode',),
'anmodede': ('anmode',),
'anmodende': ('anmode',),
'annalistisk': ('annalistisk',),
'annalistiske': ('annalistisk',),
'annalistisk': ('annalistisk',),
'annamma': ('annamme',),
'annammet': ('annamme',),
'annamma': ('annamme',),
'annammet': ('annamme',),
'annamma': ('annamme',),
'annammete': ('annamme',),
'annammede': ('annamme',),
'annamma': ('annamme',),
'annammete': ('annamme',),
'annammede': ('annamme',),
'annammende': ('annamme',),
'annektert': ('annektere',),
'annekterte': ('annektere',),
'annekterende': ('annektere',),
'annenhånds': ('annenhånds',),
'annenklasses': ('annenklasses',),
'annenrangs': ('annenrangs',),
'annerledes': ('annerledes',),
'annerledestenkende': ('annerledestenkende',),
'annleis': ('annleis',),
'annleistenkende': ('annleistenkende',),
'annonsert': ('annonsere',),
'annonserte': ('annonsere',),
'annonserende': ('annonsere',),
'annuell': ('annuell',),
'annuelle': ('annuell',),
'annuelt': ('annuell',),
'annullert': ('annullere',),
'annullerte': ('annullere',),
'annullerende': ('annullere',),
'anodisert': ('anodisere',),
'anodiserte': ('anodisere',),
'anodiserende': ('anodisere',),
'anodisk': ('anodisk',),
'anodiske': ('anodisk',),
'anodisk': ('anodisk',),
'anomal': ('anomal',),
'anomale': ('anomal',),
'anomalt': ('anomal',),
'anonym': ('anonym',),
'anonyme': ('anonym',),
'anonymt': ('anonym',),
'anordna': ('anordne',),
'anordnet': ('anordne',),
'anordna': ('anordne',),
'anordnet': ('anordne',),
'anordna': ('anordne',),
'anordnete': ('anordne',),
'anordnede': ('anordne',),
'anordnete': ('anordne',),
'anordnede': ('anordne',),
'anordna': ('anordne',),
'anordnete': ('anordne',),
'anordnede': ('anordne',),
'anordnete': ('anordne',),
'anordnede': ('anordne',),
'anordnende': ('anordne',),
'anorganisk': ('anorganisk',),
'anorganiske': ('anorganisk',),
'anorganisk': ('anorganisk',),
'anormal': ('anormal',),
'anormale': ('anormal',),
'anormalt': ('anormal',),
'anretta': ('anrette',),
'anrettet': ('anrette',),
'anretta': ('anrette',),
'anrettet': ('anrette',),
'anretta': ('anrette',),
'anrettete': ('anrette',),
'anrettede': ('anrette',),
'anretta': ('anrette',),
'anrettete': ('anrette',),
'anrettede': ('anrette',),
'anrettende': ('anrette',),
'anrika': ('anrike',),
'anriket': ('anrike',),
'anrika': ('anrike',),
'anriket': ('anrike',),
'anrika': ('anrike',),
'anrikete': ('anrike',),
'anrikede': ('anrike',),
'anrika': ('anrike',),
'anrikete': ('anrike',),
'anrikede': ('anrike',),
'anrikende': ('anrike',),
'anropt': ('anrope',),
'anropte': ('anrope',),
'anropende': ('anrope',),
'ansatt': ('ansatt',),
'ansatte': ('ansatt',),
'ansatt': ('ansatt',),
'ansa': ('anse',),
'anset': ('anse',),
'anst': ('anse',),
'ansa': ('anse',),
'anset': ('anse',),
'anst': ('anse',),
'ansa': ('anse',),
'ansete': ('anse',),
'ansede': ('anse',),
'anste': ('anse',),
'ansa': ('anse',),
'ansete': ('anse',),
'ansede': ('anse',),
'anste': ('anse',),
'ansende': ('anse',),
'ansett': ('anse',),
'ansette': ('anse',),
'anseende': ('anse',),
'anselig': ('anselig',),
'anselige': ('anselig',),
'anselig': ('anselig',),
'ansett': ('ansett',),
'ansette': ('ansett',),
'ansett': ('ansett',),
'ansatt': ('ansette',),
'ansatte': ('ansette',),
'ansettende': ('ansette',),
'anskaffa': ('anskaffe',),
'anskaffet': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffet': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffete': ('anskaffe',),
'anskaffede': ('anskaffe',),
'anskaffa': ('anskaffe',),
'anskaffete': ('anskaffe',),
'anskaffede': ('anskaffe',),
'anskaffende': ('anskaffe',),
'anskreven': ('anskreven',),
'anskrevne': ('anskreven',),
'anskrevet': ('anskreven',),
'anskrevet': ('anskrevet',),
'anskrevne': ('anskrevet',),
'anskrevet': ('anskrevet',),
'anskua': ('anskue',),
'anskuet': ('anskue',),
'anskua': ('anskue',),
'anskuet': ('anskue',),
'anskua': ('anskue',),
'anskuete': ('anskue',),
'anskuede': ('anskue',),
'anskua': ('anskue',),
'anskuete': ('anskue',),
'anskuede': ('anskue',),
'anskuende': ('anskue',),
'anskuelig': ('anskuelig',),
'anskuelige': ('anskuelig',),
'anskuelig': ('anskuelig',),
'anskueliggjort': ('anskueliggjøre',),
'anskueliggjorte': ('anskueliggjøre',),
'anskueliggjørende': ('anskueliggjøre',),
'anslått': ('anslå',),
'anslåtte': ('anslå',),
'anslående': ('anslå',),
'anspent': ('anspenne',),
'anspente': ('anspenne',),
'anspennende': ('anspenne',),
'anspent': ('anspent',),
'anspente': ('anspent',),
'anspent': ('anspent',),
'anspora': ('anspore',),
'ansporet': ('anspore',),
'ansport': ('anspore',),
'anspora': ('anspore',),
'ansporet': ('anspore',),
'ansport': ('anspore',),
'anspora': ('anspore',),
'ansporete': ('anspore',),
'ansporede': ('anspore',),
'ansporte': ('anspore',),
'anspora': ('anspore',),
'ansporete': ('anspore',),
'ansporede': ('anspore',),
'ansporte': ('anspore',),
'ansporende': ('anspore',),
'ansporende': ('ansporende',),
'anstendig': ('anstendig',),
'anstendige': ('anstendig',),
'anstendig': ('anstendig',),
'anstifta': ('anstifte',),
'anstiftet': ('anstifte',),
'anstifta': ('anstifte',),
'anstiftet': ('anstifte',),
'anstifta': ('anstifte',),
'anstiftete': ('anstifte',),
'anstiftede': ('anstifte',),
'anstifta': ('anstifte',),
'anstiftete': ('anstifte',),
'anstiftede': ('anstifte',),
'anstiftende': ('anstifte',),
'anstilt': ('anstille',),
'anstilte': ('anstille',),
'anstillende': ('anstille',),
'anstrengt': ('anstrenge',),
'anstrengte': ('anstrenge',),
'anstrengende': ('anstrenge',),
'anstrengende': ('anstrengende',),
'anstrengt': ('anstrengt',),
'anstrengte': ('anstrengt',),
'anstrengt': ('anstrengt',),
'anstrøken': ('anstrøken',),
'anstrøkne': ('anstrøken',),
'anstrøket': ('anstrøken',),
'anstått': ('anstå',),
'anståtte': ('anstå',),
'anstående': ('anstå',),
'anstøtelig': ('anstøtelig',),
'anstøtelige': ('anstøtelig',),
'anstøtelig': ('anstøtelig',),
'anstøtende': ('anstøtende',),
'ansvarlig': ('ansvarlig',),
'ansvarlige': ('ansvarlig',),
'ansvarlig': ('ansvarlig',),
'ansvarsbevisst': ('ansvarsbevisst',),
'ansvarsbevisste': ('ansvarsbevisst',),
'ansvarsbevisst': ('ansvarsbevisst',),
'ansvarsfull': ('ansvarsfull',),
'ansvarsfulle': ('ansvarsfull',),
'ansvarsfullt': ('ansvarsfull',),
'ansvarshavende': ('ansvarshavende',),
'ansvarslaus': ('ansvarslaus',),
'ansvarslause': ('ansvarslaus',),
'ansvarslaust': ('ansvarslaus',),
'ansvarsløs': ('ansvarsløs',),
'ansvarsløse': ('ansvarsløs',),
'ansvarsløst': ('ansvarsløs',),
'ansvarstung': ('ansvarstung',),
'ansvarstunge': ('ansvarstung',),
'ansvarstungt': ('ansvarstung',),
'ansøkt': ('ansøke',),
'ansøkte': ('ansøke',),
'ansøkende': ('ansøke',),
'antatt': ('anta',),
'antatte': ('anta',),
'antakende': ('anta',),
'antagonistisk': ('antagonistisk',),
'antagonistiske': ('antagonistisk',),
'antagonistisk': ('antagonistisk',),
'antakelig': ('antakelig',),
'antakelige': ('antakelig',),
'antakelig': ('antakelig',),
'antarktisk': ('antarktisk',),
'antarktiske': ('antarktisk',),
'antarktisk': ('antarktisk',),
'antasta': ('antaste',),
'antastet': ('antaste',),
'antasta': ('antaste',),
'antastet': ('antaste',),
'antasta': ('antaste',),
'antastete': ('antaste',),
'antastede': ('antaste',),
'antasta': ('antaste',),
'antastete': ('antaste',),
'antastede': ('antaste',),
'antastende': ('antaste',),
'antedatert': ('antedatere',),
'antedaterte': ('antedatere',),
'antedaterende': ('antedatere',),
'antediluvial': ('antediluvial',),
'antediluviale': ('antediluvial',),
'antediluvialt': ('antediluvial',),
'antediluviansk': ('antediluviansk',),
'antediluvianske': ('antediluviansk',),
'antediluviansk': ('antediluviansk',),
'antegna': ('antegne',),
'antegnet': ('antegne',),
'antegna': ('antegne',),
'antegnet': ('antegne',),
'antegna': ('antegne',),
'antegnete': ('antegne',),
'antegnede': ('antegne',),
'antegna': ('antegne',),
'antegnete': ('antegne',),
'antegnede': ('antegne',),
'antegnende': ('antegne',),
'antent': ('antenne',),
'antente': ('antenne',),
'antennende': ('antenne',),
'antennelig': ('antennelig',),
'antennelige': ('antennelig',),
'antennelig': ('antennelig',),
'antesipert': ('antesipere',),
'antesiperte': ('antesipere',),
'antesiperende': ('antesipere',),
'antibiotisk': ('antibiotisk',),
'antibiotiske': ('antibiotisk',),
'antibiotisk': ('antibiotisk',),
'antidemokratisk': ('antidemokratisk',),
'antidemokratiske': ('antidemokratisk',),
'antidemokratisk': ('antidemokratisk',),
'antigen': ('antigen',),
'antigene': ('antigen',),
'antigent': ('antigen',),
'antiguansk': ('antiguansk',),
'antiguanske': ('antiguansk',),
'antiguansk': ('antiguansk',),
'antikisert': ('antikisere',),
'antikiserte': ('antikisere',),
'antikiserende': ('antikisere',),
'antikk': ('antikk',),
'antikke': ('antikk',),
'antikt': ('antikk',),
'antiklerikal': ('antiklerikal',),
'antiklerikale': ('antiklerikal',),
'antiklerikalt': ('antiklerikal',),
'antikommunistisk': ('antikommunistisk',),
'antikommunistiske': ('antikommunistisk',),
'antikommunistisk': ('antikommunistisk',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlete': ('antikrympbehandle',),
'antikrympbehandlede': ('antikrympbehandle',),
'antikrympbehandlete': ('antikrympbehandle',),
'antikrympbehandlede': ('antikrympbehandle',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlete': ('antikrympbehandle',),
'antikrympbehandlede': ('antikrympbehandle',),
'antikrympbehandlete': ('antikrympbehandle',),
'antikrympbehandlede': ('antikrympbehandle',),
'antikrympbehandlende': ('antikrympbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlete': ('antikrøllbehandle',),
'antikrøllbehandlede': ('antikrøllbehandle',),
'antikrøllbehandlete': ('antikrøllbehandle',),
'antikrøllbehandlede': ('antikrøllbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlete': ('antikrøllbehandle',),
'antikrøllbehandlede': ('antikrøllbehandle',),
'antikrøllbehandlete': ('antikrøllbehandle',),
'antikrøllbehandlede': ('antikrøllbehandle',),
'antikrøllbehandlende': ('antikrøllbehandle',),
'antikvarisk': ('antikvarisk',),
'antikvariske': ('antikvarisk',),
'antikvarisk': ('antikvarisk',),
'antikvert': ('antikvert',),
'antikverte': ('antikvert',),
'antikvert': ('antikvert',),
'antimilitaristisk': ('antimilitaristisk',),
'antimilitaristiske': ('antimilitaristisk',),
'antimilitaristisk': ('antimilitaristisk',),
'antipatisk': ('antipatisk',),
'antipatiske': ('antipatisk',),
'antipatisk': ('antipatisk',),
'antipodisk': ('antipodisk',),
'antipodiske': ('antipodisk',),
'antipodisk': ('antipodisk',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlete': ('antirefleksbehandle',),
'antirefleksbehandlede': ('antirefleksbehandle',),
'antirefleksbehandlete': ('antirefleksbehandle',),
'antirefleksbehandlede': ('antirefleksbehandle',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlete': ('antirefleksbehandle',),
'antirefleksbehandlede': ('antirefleksbehandle',),
'antirefleksbehandlete': ('antirefleksbehandle',),
'antirefleksbehandlede': ('antirefleksbehandle',),
'antirefleksbehandlende': ('antirefleksbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlete': ('antirustbehandle',),
'antirustbehandlede': ('antirustbehandle',),
'antirustbehandlete': ('antirustbehandle',),
'antirustbehandlede': ('antirustbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlete': ('antirustbehandle',),
'antirustbehandlede': ('antirustbehandle',),
'antirustbehandlete': ('antirustbehandle',),
'antirustbehandlede': ('antirustbehandle',),
'antirustbehandlende': ('antirustbehandle',),
'antisemittisk': ('antisemittisk',),
'antisemittiske': ('antisemittisk',),
'antisemittisk': ('antisemittisk',),
'antiseptisk': ('antiseptisk',),
'antiseptiske': ('antiseptisk',),
'antiseptisk': ('antiseptisk',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlete': ('antistatbehandle',),
'antistatbehandlede': ('antistatbehandle',),
'antistatbehandlete': ('antistatbehandle',),
'antistatbehandlede': ('antistatbehandle',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlete': ('antistatbehandle',),
'antistatbehandlede': ('antistatbehandle',),
'antistatbehandlete': ('antistatbehandle',),
'antistatbehandlede': ('antistatbehandle',),
'antistatbehandlende': ('antistatbehandle',),
'antistatisk': ('antistatisk',),
'antistatiske': ('antistatisk',),
'antistatisk': ('antistatisk',),
'antitetisk': ('antitetisk',),
'antitetiske': ('antitetisk',),
'antitetisk': ('antitetisk',),
'antitoksisk': ('antitoksisk',),
'antitoksiske': ('antitoksisk',),
'antitoksisk': ('antitoksisk',),
'antologisk': ('antologisk',),
'antologiske': ('antologisk',),
'antologisk': ('antologisk',),
'antonym': ('antonym',),
'antonyme': ('antonym',),
'antonymt': ('antonym',),
'antropofobisk': ('antropofobisk',),
'antropofobiske': ('antropofobisk',),
'antropofobisk': ('antropofobisk',),
'antropologisk': ('antropologisk',),
'antropologiske': ('antropologisk',),
'antropologisk': ('antropologisk',),
'antropomorf': ('antropomorf',),
'antropomorfe': ('antropomorf',),
'antropomorft': ('antropomorf',),
'antroposofisk': ('antroposofisk',),
'antroposofiske': ('antroposofisk',),
'antroposofisk': ('antroposofisk',),
'antrukket': ('antrukket',),
'antrukne': ('antrukket',),
'antrukket': ('antrukket',),
'antyda': ('antyde',),
'antydet': ('antyde',),
'antyda': ('antyde',),
'antydet': ('antyde',),
'antyda': ('antyde',),
'antydete': ('antyde',),
'antydede': ('antyde',),
'antyda': ('antyde',),
'antydete': ('antyde',),
'antydede': ('antyde',),
'antydende': ('antyde',),
'anvendt': ('anvende',),
'anvendte': ('anvende',),
'anvendende': ('anvende',),
'anvendelig': ('anvendelig',),
'anvendelige': ('anvendelig',),
'anvendelig': ('anvendelig',),
'anvendt': ('anvendt',),
'anvendte': ('anvendt',),
'anvendt': ('anvendt',),
'anvist': ('anvise',),
'anviste': ('anvise',),
'anvisende': ('anvise',),
'apalgrå': ('apalgrå',),
'apalgråe': ('apalgrå',),
'apalgrå': ('apalgrå',),
'apalgråe': ('apalgrå',),
'apalgrå': ('apalgrå',),
'apalgrått': ('apalgrå',),
'aparte': ('aparte',),
'apatisk': ('apatisk',),
'apatiske': ('apatisk',),
'apatisk': ('apatisk',),
'apa': ('ape',),
'apet': ('ape',),
'apt': ('ape',),
'apa': ('ape',),
'apet': ('ape',),
'apt': ('ape',),
'apa': ('ape',),
'apete': ('ape',),
'apede': ('ape',),
'apte': ('ape',),
'apa': ('ape',),
'apete': ('ape',),
'apede': ('ape',),
'apte': ('ape',),
'apende': ('ape',),
'apikal': ('apikal',),
'apikale': ('apikal',),
'apikalt': ('apikal',),
'apokalyptisk': ('apokalyptisk',),
'apokalyptiske': ('apokalyptisk',),
'apokalyptisk': ('apokalyptisk',),
'apokopert': ('apokopere',),
'apokoperte': ('apokopere',),
'apokoperende': ('apokopere',),
'apokryf': ('apokryf',),
'apokryfe': ('apokryf',),
'apokryft': ('apokryf',),
'apokryfisk': ('apokryfisk',),
'apokryfiske': ('apokryfisk',),
'apokryfisk': ('apokryfisk',),
'apolitisk': ('apolitisk',),
'apolitiske': ('apolitisk',),
'apolitisk': ('apolitisk',),
'apollinsk': ('apollinsk',),
'apollinske': ('apollinsk',),
'apollinsk': ('apollinsk',),
'apologetisk': ('apologetisk',),
'apologetiske': ('apologetisk',),
'apologetisk': ('apologetisk',),
'apoplektisk': ('apoplektisk',),
'apoplektiske': ('apoplektisk',),
'apoplektisk': ('apoplektisk',),
'aposteriorisk': ('aposteriorisk',),
'aposterioriske': ('aposteriorisk',),
'aposteriorisk': ('aposteriorisk',),
'apostolisk': ('apostolisk',),
'apostoliske': ('apostolisk',),
'apostolisk': ('apostolisk',),
'apostrofert': ('apostrofere',),
'apostroferte': ('apostrofere',),
'apostroferende': ('apostrofere',),
'appellabel': ('appellabel',),
'appellable': ('appellabel',),
'appellabelt': ('appellabel',),
'appellativisk': ('appellativisk',),
'appellativiske': ('appellativisk',),
'appellativisk': ('appellativisk',),
'appellert': ('appellere',),
'appellerte': ('appellere',),
'appellerende': ('appellere',),
'appetittlig': ('appetittlig',),
'appetittlige': ('appetittlig',),
'appetittlig': ('appetittlig',),
'appetittvekkende': ('appetittvekkende',),
'applaudert': ('applaudere',),
'applauderte': ('applaudere',),
'applauderende': ('applaudere',),
'applikert': ('applikere',),
'applikerte': ('applikere',),
'applikerende': ('applikere',),
'applisert': ('applisere',),
'appliserte': ('applisere',),
'appliserende': ('applisere',),
'apportert': ('apportere',),
'apporterte': ('apportere',),
'apporterende': ('apportere',),
'apposisjonell': ('apposisjonell',),
'apposisjonelle': ('apposisjonell',),
'apposisjonelt': ('apposisjonell',),
'appretert': ('appretere',),
'appreterte': ('appretere',),
'appreterende': ('appretere',),
'approbert': ('approbere',),
'approberte': ('approbere',),
'approberende': ('approbere',),
'approksimativ': ('approksimativ',),
'approksimative': ('approksimativ',),
'approksimativt': ('approksimativ',),
'appropriert': ('appropriere',),
'approprierte': ('appropriere',),
'approprierende': ('appropriere',),
'aprikosfarga': ('aprikosfarga',),
'aprikosfarget': ('aprikosfarget',),
'aprikosfargete': ('aprikosfarget',),
'aprikosfargede': ('aprikosfarget',),
'aprikosfargete': ('aprikosfarget',),
'aprikosfargede': ('aprikosfarget',),
'aprikosfarget': ('aprikosfarget',),
'apriorisk': ('apriorisk',),
'aprioriske': ('apriorisk',),
'apriorisk': ('apriorisk',),
'apsidal': ('apsidal',),
'apsidale': ('apsidal',),
'apsidalt': ('apsidal',),
'aptert': ('aptere',),
'apterte': ('aptere',),
'apterende': ('aptere',),
'arabisk': ('arabisk',),
'arabiske': ('arabisk',),
'arabisk': ('arabisk',),
'arameisk': ('arameisk',),
'arameiske': ('arameisk',),
'arameisk': ('arameisk',),
'arbeida': ('arbeide',),
'arbeidet': ('arbeide',),
'arbeidd': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidet': ('arbeide',),
'arbeidd': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidete': ('arbeide',),
'arbeidede': ('arbeide',),
'arbeidde': ('arbeide',),
'arbeida': ('arbeide',),
'arbeidete': ('arbeide',),
'arbeidede': ('arbeide',),
'arbeidde': ('arbeide',),
'arbeidende': ('arbeide',),
'arbeidsbesparende': ('arbeidsbesparende',),
'arbeidsdyktig': ('arbeidsdyktig',),
'arbeidsdyktige': ('arbeidsdyktig',),
'arbeidsdyktig': ('arbeidsdyktig',),
'arbeidsfør': ('arbeidsfør',),
'arbeidsføre': ('arbeidsfør',),
'arbeidsført': ('arbeidsfør',),
'arbeidsglad': ('arbeidsglad',),
'arbeidsglade': ('arbeidsglad',),
'arbeidsglad': ('arbeidsglad',),
'arbeidsintensiv': ('arbeidsintensiv',),
'arbeidsintensive': ('arbeidsintensiv',),
'arbeidsintensivt': ('arbeidsintensiv',),
'arbeidskrevende': ('arbeidskrevende',),
'arbeidslaus': ('arbeidslaus',),
'arbeidslause': ('arbeidslaus',),
'arbeidslaust': ('arbeidslaus',),
'arbeidsledig': ('arbeidsledig',),
'arbeidsledige': ('arbeidsledig',),
'arbeidsledig': ('arbeidsledig',),
'arbeidsløs': ('arbeidsløs',),
'arbeidsløse': ('arbeidsløs',),
'arbeidsløst': ('arbeidsløs',),
'arbeidsom': ('arbeidsom',),
'arbeidsomme': ('arbeidsom',),
'arbeidsomt': ('arbeidsom',),
'arbeidssparende': ('arbeidssparende',),
'arbeidsudyktig': ('arbeidsudyktig',),
'arbeidsudyktige': ('arbeidsudyktig',),
'arbeidsudyktig': ('arbeidsudyktig',),
'arbeidsufør': ('arbeidsufør',),
'arbeidsuføre': ('arbeidsufør',),
'arbeidsuført': ('arbeidsufør',),
'arbitrær': ('arbitrær',),
'arbitrære': ('arbitrær',),
'arbitrært': ('arbitrær',),
'arda': ('arde',),
'ardet': ('arde',),
'arda': ('arde',),
'ardet': ('arde',),
'arda': ('arde',),
'ardete': ('arde',),
'ardede': ('arde',),
'arda': ('arde',),
'ardete': ('arde',),
'ardede': ('arde',),
'ardende': ('arde',),
'arg': ('arg',),
'arge': ('arg',),
'argt': ('arg',),
'argere': ('arg',),
'argest': ('arg',),
'argeste': ('arg',),
'arga': ('arge',),
'arget': ('arge',),
'arga': ('arge',),
'arget': ('arge',),
'arga': ('arge',),
'argete': ('arge',),
'argede': ('arge',),
'arga': ('arge',),
'argete': ('arge',),
'argede': ('arge',),
'argende': ('arge',),
'argentinsk': ('argentinsk',),
'argentinske': ('argentinsk',),
'argentinsk': ('argentinsk',),
'argumentert': ('argumentere',),
'argumenterte': ('argumentere',),
'argumenterende': ('argumentere',),
'arid': ('arid',),
'aride': ('arid',),
'arid': ('arid',),
'arisk': ('arisk',),
'ariske': ('arisk',),
'arisk': ('arisk',),
'aristokratisk': ('aristokratisk',),
'aristokratiske': ('aristokratisk',),
'aristokratisk': ('aristokratisk',),
'aristotelisk': ('aristotelisk',),
'aristoteliske': ('aristotelisk',),
'aristotelisk': ('aristotelisk',),
'aritmetisk': ('aritmetisk',),
'aritmetiske': ('aritmetisk',),
'aritmetisk': ('aritmetisk',),
'arkaisert': ('arkaisere',),
'arkaiserte': ('arkaisere',),
'arkaiserende': ('arkaisere',),
'arkaisk': ('arkaisk',),
'arkaiske': ('arkaisk',),
'arkaisk': ('arkaisk',),
'arkaistisk': ('arkaistisk',),
'arkaistiske': ('arkaistisk',),
'arkaistisk': ('arkaistisk',),
'arkebusert': ('arkebusere',),
'arkebuserte': ('arkebusere',),
'arkebuserende': ('arkebusere',),
'arkeologisk': ('arkeologisk',),
'arkeologiske': ('arkeologisk',),
'arkeologisk': ('arkeologisk',),
'arketypisk': ('arketypisk',),
'arketypiske': ('arketypisk',),
'arketypisk': ('arketypisk',),
'arkitektonisk': ('arkitektonisk',),
'arkitektoniske': ('arkitektonisk',),
'arkitektonisk': ('arkitektonisk',),
'arkitekttegna': ('arkitekttegna',),
'arkitekttegnet': ('arkitekttegnet',),
'arkitekttegnete': ('arkitekttegnet',),
'arkitekttegnede': ('arkitekttegnet',),
'arkitekttegnete': ('arkitekttegnet',),
'arkitekttegnede': ('arkitekttegnet',),
'arkitekttegnet': ('arkitekttegnet',),
'arkivert': ('arkivere',),
'arkiverte': ('arkivere',),
'arkiverende': ('arkivere',),
'arktisk': ('arktisk',),
'arktiske': ('arktisk',),
'arktisk': ('arktisk',),
'arm': ('arm',),
'arme': ('arm',),
'armt': ('arm',),
'armere': ('arm',),
'armest': ('arm',),
'armeste': ('arm',),
'arma': ('arme',),
'armet': ('arme',),
'arma': ('arme',),
'armet': ('arme',),
'arma': ('arme',),
'armete': ('arme',),
'armede': ('arme',),
'arma': ('arme',),
'armete': ('arme',),
'armede': ('arme',),
'armende': ('arme',),
'armensk': ('armensk',),
'armenske': ('armensk',),
'armensk': ('armensk',),
'armert': ('armere',),
'armerte': ('armere',),
'armerende': ('armere',),
'armodslig': ('armodslig',),
'armodslige': ('armodslig',),
'armodslig': ('armodslig',),
'aromatisert': ('aromatisere',),
'aromatiserte': ('aromatisere',),
'aromatiserende': ('aromatisere',),
'aromatisk': ('aromatisk',),
'aromatiske': ('aromatisk',),
'aromatisk': ('aromatisk',),
'arrangert': ('arrangere',),
'arrangerte': ('arrangere',),
'arrangerende': ('arrangere',),
'arrestert': ('arrestere',),
'arresterte': ('arrestere',),
'arresterende': ('arrestere',),
'arret': ('arret',),
'arrete': ('arret',),
'arret': ('arret',),
'arrete': ('arrete',),
'arretert': ('arretere',),
'arreterte': ('arretere',),
'arreterende': ('arretere',),
'arrig': ('arrig',),
'arrige': ('arrig',),
'arrig': ('arrig',),
'arrivert': ('arrivere',),
'arriverte': ('arrivere',),
'arriverende': ('arrivere',),
'arrogant': ('arrogant',),
'arrogante': ('arrogant',),
'arrogant': ('arrogant',),
'arrondert': ('arrondere',),
'arronderte': ('arrondere',),
'arronderende': ('arrondere',),
'arsenikkholdig': ('arsenikkholdig',),
'arsenikkholdige': ('arsenikkholdig',),
'arsenikkholdig': ('arsenikkholdig',),
'arta': ('arte',),
'artet': ('arte',),
'arta': ('arte',),
'artet': ('arte',),
'arta': ('arte',),
'artete': ('arte',),
'artede': ('arte',),
'arta': ('arte',),
'artete': ('arte',),
'artede': ('arte',),
'artende': ('arte',),
'arteriell': ('arteriell',),
'arterielle': ('arteriell',),
'arterielt': ('arteriell',),
'artesisk': ('artesisk',),
'artesiske': ('artesisk',),
'artesisk': ('artesisk',),
'artifisiell': ('artifisiell',),
'artifisielle': ('artifisiell',),
'artifisielt': ('artifisiell',),
'artig': ('artig',),
'artige': ('artig',),
'artig': ('artig',),
'artigere': ('artig',),
'artigst': ('artig',),
'artigste': ('artig',),
'artikulatorisk': ('artikulatorisk',),
'artikulatoriske': ('artikulatorisk',),
'artikulatorisk': ('artikulatorisk',),
'artikulert': ('artikulere',),
'artikulerte': ('artikulere',),
'artikulerende': ('artikulere',),
'artistisk': ('artistisk',),
'artistiske': ('artistisk',),
'artistisk': ('artistisk',),
'artsbestemt': ('artsbestemme',),
'artsbestemte': ('artsbestemme',),
'artsbestemmende': ('artsbestemme',),
'artsfattig': ('artsfattig',),
'artsfattige': ('artsfattig',),
'artsfattig': ('artsfattig',),
'artsforskjellig': ('artsforskjellig',),
'artsforskjellige': ('artsforskjellig',),
'artsforskjellig': ('artsforskjellig',),
'artsrein': ('artsrein',),
'artsreine': ('artsrein',),
'artsreint': ('artsrein',),
'artsren': ('artsren',),
'artsrene': ('artsren',),
'artsrent': ('artsren',),
'artsrik': ('artsrik',),
'artsrike': ('artsrik',),
'artsrikt': ('artsrik',),
'artsrikere': ('artsrik',),
'artsrikest': ('artsrik',),
'artsrikeste': ('artsrik',),
'artstypisk': ('artstypisk',),
'artstypiske': ('artstypisk',),
'artstypisk': ('artstypisk',),
'arva': ('arve',),
'arvet': ('arve',),
'arva': ('arve',),
'arvet': ('arve',),
'arva': ('arve',),
'arvete': ('arve',),
'arvede': ('arve',),
'arva': ('arve',),
'arvete': ('arve',),
'arvede': ('arve',),
'arvende': ('arve',),
'arveberettiga': ('arveberettiga',),
'arveberettiget': ('arveberettiget',),
'arveberettigete': ('arveberettiget',),
'arveberettigede': ('arveberettiget',),
'arveberettigete': ('arveberettiget',),
'arveberettigede': ('arveberettiget',),
'arveberettiget': ('arveberettiget',),
'arvelaus': ('arvelaus',),
'arvelause': ('arvelaus',),
'arvelaust': ('arvelaus',),
'arvelig': ('arvelig',),
'arvelige': ('arvelig',),
'arvelig': ('arvelig',),
'arveløs': ('arveløs',),
'arveløse': ('arveløs',),
'arveløst': ('arveløs',),
'ast': ('ase',),
'aste': ('ase',),
'asende': ('ase',),
'aseksuell': ('aseksuell',),
'aseksuelle': ('aseksuell',),
'aseksuelt': ('aseksuell',),
'aseptisk': ('aseptisk',),
'aseptiske': ('aseptisk',),
'aseptisk': ('aseptisk',),
'aserbajdsjansk': ('aserbajdsjansk',),
'aserbajdsjanske': ('aserbajdsjansk',),
'aserbajdsjansk': ('aserbajdsjansk',),
'aset': ('aset',),
'asete': ('aset',),
'aset': ('aset',),
'asete': ('asete',),
'asfaltert': ('asfaltere',),
'asfalterte': ('asfaltere',),
'asfalterende': ('asfaltere',),
'asiatisk': ('asiatisk',),
'asiatiske': ('asiatisk',),
'asiatisk': ('asiatisk',),
'askeblond': ('askeblond',),
'askeblonde': ('askeblond',),
'askeblondt': ('askeblond',),
'askegrå': ('askegrå',),
'askegråe': ('askegrå',),
'askegrå': ('askegrå',),
'askegråe': ('askegrå',),
'askegrå': ('askegrå',),
'askegrått': ('askegrå',),
'askenasisk': ('askenasisk',),
'askenasiske': ('askenasisk',),
'askenasisk': ('askenasisk',),
'asketisk': ('asketisk',),
'asketiske': ('asketisk',),
'asketisk': ('asketisk',),
'asomatisk': ('asomatisk',),
'asomatiske': ('asomatisk',),
'asomatisk': ('asomatisk',),
'asosial': ('asosial',),
'asosiale': ('asosial',),
'asosialt': ('asosial',),
'aspiratorisk': ('aspiratorisk',),
'aspiratoriske': ('aspiratorisk',),
'aspiratorisk': ('aspiratorisk',),
'aspirert': ('aspirere',),
'aspirerte': ('aspirere',),
'aspirerende': ('aspirere',),
'assimilatorisk': ('assimilatorisk',),
'assimilatoriske': ('assimilatorisk',),
'assimilatorisk': ('assimilatorisk',),
'assimilert': ('assimilere',),
'assimilerte': ('assimilere',),
'assimilerende': ('assimilere',),
'assistert': ('assistere',),
'assisterte': ('assistere',),
'assisterende': ('assistere',),
'assortert': ('assortere',),
'assorterte': ('assortere',),
'assorterende': ('assortere',),
'assosiativ': ('assosiativ',),
'assosiative': ('assosiativ',),
'assosiativt': ('assosiativ',),
'assosiert': ('assosiere',),
'assosierte': ('assosiere',),
'assosierende': ('assosiere',),
'assurert': ('assurere',),
'assurerte': ('assurere',),
'assurerende': ('assurere',),
'assyrisk': ('assyrisk',),
'assyriske': ('assyrisk',),
'assyrisk': ('assyrisk',),
'astenisk': ('astenisk',),
'asteniske': ('astenisk',),
'astenisk': ('astenisk',),
'astigmatisk': ('astigmatisk',),
'astigmatiske': ('astigmatisk',),
'astigmatisk': ('astigmatisk',),
'astmasjuk': ('astmasjuk',),
'astmasjuke': ('astmasjuk',),
'astmasjukt': ('astmasjuk',),
'astmasyk': ('astmasyk',),
'astmasyke': ('astmasyk',),
'astmasykt': ('astmasyk',),
'astmatisk': ('astmatisk',),
'astmatiske': ('astmatisk',),
'astmatisk': ('astmatisk',),
'astral': ('astral',),
'astrale': ('astral',),
'astralt': ('astral',),
'astringert': ('astringere',),
'astringerte': ('astringere',),
'astringerende': ('astringere',),
'astrofysisk': ('astrofysisk',),
'astrofysiske': ('astrofysisk',),
'astrofysisk': ('astrofysisk',),
'astrologisk': ('astrologisk',),
'astrologiske': ('astrologisk',),
'astrologisk': ('astrologisk',),
'astronomisk': ('astronomisk',),
'astronomiske': ('astronomisk',),
'astronomisk': ('astronomisk',),
'asurblå': ('asurblå',),
'asurblåe': ('asurblå',),
'asurblå': ('asurblå',),
'asurblåe': ('asurblå',),
'asurblå': ('asurblå',),
'asurblått': ('asurblå',),
'asymmetrisk': ('asymmetrisk',),
'asymmetriske': ('asymmetrisk',),
'asymmetrisk': ('asymmetrisk',),
'asymptotisk': ('asymptotisk',),
'asymptotiske': ('asymptotisk',),
'asymptotisk': ('asymptotisk',),
'asyndetisk': ('asyndetisk',),
'asyndetiske': ('asyndetisk',),
'asyndetisk': ('asyndetisk',),
'asynkron': ('asynkron',),
'asynkrone': ('asynkron',),
'asynkront': ('asynkron',),
'atal': ('atal',),
'atale': ('atal',),
'atalt': ('atal',),
'atavistisk': ('atavistisk',),
'atavistiske': ('atavistisk',),
'atavistisk': ('atavistisk',),
'ateistisk': ('ateistisk',),
'ateistiske': ('ateistisk',),
'ateistisk': ('ateistisk',),
'atensk': ('atensk',),
'atenske': ('atensk',),
'atensk': ('atensk',),
'athensk': ('athensk',),
'athenske': ('athensk',),
'athensk': ('athensk',),
'atlantisk': ('atlantisk',),
'atlantiske': ('atlantisk',),
'atlantisk': ('atlantisk',),
'atlantocanadisk': ('atlantocanadisk',),
'atlantocanadiske': ('atlantocanadisk',),
'atlantocanadisk': ('atlantocanadisk',),
'atlantokanadisk': ('atlantokanadisk',),
'atlantokanadiske': ('atlantokanadisk',),
'atlantokanadisk': ('atlantokanadisk',),
'atlantoskandisk': ('atlantoskandisk',),
'atlantoskandiske': ('atlantoskandisk',),
'atlantoskandisk': ('atlantoskandisk',),
'atletisk': ('atletisk',),
'atletiske': ('atletisk',),
'atletisk': ('atletisk',),
'atmosfærisk': ('atmosfærisk',),
'atmosfæriske': ('atmosfærisk',),
'atmosfærisk': ('atmosfærisk',),
'atoksisk': ('atoksisk',),
'atoksiske': ('atoksisk',),
'atoksisk': ('atoksisk',),
'atomar': ('atomar',),
'atomare': ('atomar',),
'atomart': ('atomar',),
'atomdrevet': ('atomdrevet',),
'atomdrevne': ('atomdrevet',),
'atomdrevet': ('atomdrevet',),
'atomisert': ('atomisere',),
'atomiserte': ('atomisere',),
'atomiserende': ('atomisere',),
'atomistisk': ('atomistisk',),
'atomistiske': ('atomistisk',),
'atomistisk': ('atomistisk',),
'atomær': ('atomær',),
'atomære': ('atomær',),
'atomært': ('atomær',),
'atonal': ('atonal',),
'atonale': ('atonal',),
'atonalt': ('atonal',),
'atrofiert': ('atrofiere',),
'atrofierte': ('atrofiere',),
'atrofierende': ('atrofiere',),
'atrofisk': ('atrofisk',),
'atrofiske': ('atrofisk',),
'atrofisk': ('atrofisk',),
'atskilt': ('atskille',),
'atskilte': ('atskille',),
'atskillende': ('atskille',),
'atskillig': ('atskillig',),
'atskillige': ('atskillig',),
'atskillig': ('atskillig',),
'atskilt': ('atskilt',),
'atskilte': ('atskilt',),
'atskilt': ('atskilt',),
'atspredd': ('atspre',),
'atspredt': ('atspre',),
'atspredd': ('atspre',),
'atspredt': ('atspre',),
'atspredde': ('atspre',),
'atspredte': ('atspre',),
'atspredde': ('atspre',),
'atspredte': ('atspre',),
'atspreende': ('atspre',),
'atspredt': ('atsprede',),
'atspredd': ('atsprede',),
'atspredt': ('atsprede',),
'atspredd': ('atsprede',),
'atspredte': ('atsprede',),
'atspredde': ('atsprede',),
'atspredte': ('atsprede',),
'atspredde': ('atsprede',),
'atspredende': ('atsprede',),
'atspredt': ('atspredt',),
'atspredte': ('atspredt',),
'atspredt': ('atspredt',),
'attachert': ('attachere',),
'attacherte': ('attachere',),
'attacherende': ('attachere',),
'attakkert': ('attakkere',),
'attakkerte': ('attakkere',),
'attakkerende': ('attakkere',),
'attende': ('attende',),
'attenårig': ('attenårig',),
'attenårige': ('attenårig',),
'attenårig': ('attenårig',),
'attenårs': ('attenårs',),
'attestert': ('attestere',),
'attesterte': ('attestere',),
'attesterende': ('attestere',),
'attisk': ('attisk',),
'attiske': ('attisk',),
'attisk': ('attisk',),
'attrahert': ('attrahere',),
'attraherte': ('attrahere',),
'attraherende': ('attrahere',),
'attraktiv': ('attraktiv',),
'attraktive': ('attraktiv',),
'attraktivt': ('attraktiv',),
'attributiv': ('attributiv',),
'attributive': ('attributiv',),
'attributivt': ('attributiv',),
'attrådd': ('attrå',),
'attrådde': ('attrå',),
'attrående': ('attrå',),
'attråvekkende': ('attråvekkende',),
'attråverdig': ('attråverdig',),
'attråverdige': ('attråverdig',),
'attråverdig': ('attråverdig',),
'atypisk': ('atypisk',),
'atypiske': ('atypisk',),
'atypisk': ('atypisk',),
'audienssøkende': ('audienssøkende',),
'audiologisk': ('audiologisk',),
'audiologiske': ('audiologisk',),
'audiologisk': ('audiologisk',),
'audiovisuell': ('audiovisuell',),
'audiovisuelle': ('audiovisuell',),
'audiovisuelt': ('audiovisuell',),
'auditiv': ('auditiv',),
'auditive': ('auditiv',),
'auditivt': ('auditiv',),
'augsburgsk': ('augsburgsk',),
'augsburgske': ('augsburgsk',),
'augsburgsk': ('augsburgsk',),
'augustinsk': ('augustinsk',),
'augustinske': ('augustinsk',),
'augustinsk': ('augustinsk',),
'auka': ('auke',),
'auket': ('auke',),
'aukt': ('auke',),
'auka': ('auke',),
'auket': ('auke',),
'aukt': ('auke',),
'auka': ('auke',),
'aukete': ('auke',),
'aukede': ('auke',),
'aukte': ('auke',),
'auka': ('auke',),
'aukete': ('auke',),
'aukede': ('auke',),
'aukte': ('auke',),
'aukende': ('auke',),
'auksjonert': ('auksjonere',),
'auksjonerte': ('auksjonere',),
'auksjonerende': ('auksjonere',),
'aura': ('aure',),
'auret': ('aure',),
'aura': ('aure',),
'auret': ('aure',),
'aura': ('aure',),
'aurete': ('aure',),
'aurede': ('aure',),
'aura': ('aure',),
'aurete': ('aure',),
'aurede': ('aure',),
'aurende': ('aure',),
'auret': ('auret',),
'aurete': ('auret',),
'auret': ('auret',),
'aurete': ('aurete',),
'aust': ('ause',),
'auste': ('ause',),
'ausende': ('ause',),
'austafjelsk': ('austafjelsk',),
'austafjelske': ('austafjelsk',),
'austafjelsk': ('austafjelsk',),
'austasiatisk': ('austasiatisk',),
'austasiatiske': ('austasiatisk',),
'austasiatisk': ('austasiatisk',),
'austeuropeisk': ('austeuropeisk',),
'austeuropeiske': ('austeuropeisk',),
'austeuropeisk': ('austeuropeisk',),
'austgermansk': ('austgermansk',),
'austgermanske': ('austgermansk',),
'austgermansk': ('austgermansk',),
'austgotisk': ('austgotisk',),
'austgotiske': ('austgotisk',),
'austgotisk': ('austgotisk',),
'austlandsk': ('austlandsk',),
'austlandske': ('austlandsk',),
'austlandsk': ('austlandsk',),
'austlig': ('austlig',),
'austlige': ('austlig',),
'austlig': ('austlig',),
'austligere': ('austlig',),
'austligst': ('austlig',),
'austligste': ('austlig',),
'austnordisk': ('austnordisk',),
'austnordiske': ('austnordisk',),
'austnordisk': ('austnordisk',),
'austnorsk': ('austnorsk',),
'austnorske': ('austnorsk',),
'austnorsk': ('austnorsk',),
'australsk': ('australsk',),
'australske': ('australsk',),
'australsk': ('australsk',),
'austre': ('austre',),
'austromarxistisk': ('austromarxistisk',),
'austromarxistiske': ('austromarxistisk',),
'austromarxistisk': ('austromarxistisk',),
'austromersk': ('austromersk',),
'austromerske': ('austromersk',),
'austromersk': ('austromersk',),
'austtysk': ('austtysk',),
'austtyske': ('austtysk',),
'austtysk': ('austtysk',),
'austvendt': ('austvendt',),
'austvendte': ('austvendt',),
'austvendt': ('austvendt',),
'autentisk': ('autentisk',),
'autentiske': ('autentisk',),
'autentisk': ('autentisk',),
'autistisk': ('autistisk',),
'autistiske': ('autistisk',),
'autistisk': ('autistisk',),
'autobiografisk': ('autobiografisk',),
'autobiografiske': ('autobiografisk',),
'autobiografisk': ('autobiografisk',),
'autodidaktisk': ('autodidaktisk',),
'autodidaktiske': ('autodidaktisk',),
'autodidaktisk': ('autodidaktisk',),
'autogen': ('autogen',),
'autogene': ('autogen',),
'autogent': ('autogen',),
'autoklavert': ('autoklavere',),
'autoklaverte': ('autoklavere',),
'autoklaverende': ('autoklavere',),
'autokratisk': ('autokratisk',),
'autokratiske': ('autokratisk',),
'autokratisk': ('autokratisk',),
'automatisert': ('automatisere',),
'automatiserte': ('automatisere',),
'automatiserende': ('automatisere',),
'automatisk': ('automatisk',),
'automatiske': ('automatisk',),
'automatisk': ('automatisk',),
'autonom': ('autonom',),
'autonome': ('autonom',),
'autonomt': ('autonom',),
'autoral': ('autoral',),
'autorale': ('autoral',),
'autoralt': ('autoral',),
'autorisert': ('autorisere',),
'autoriserte': ('autorisere',),
'autoriserende': ('autorisere',),
'autoritativ': ('autoritativ',),
'autoritative': ('autoritativ',),
'autoritativt': ('autoritativ',),
'autoritær': ('autoritær',),
'autoritære': ('autoritær',),
'autoritært': ('autoritær',),
'avalert': ('avalere',),
'avalerte': ('avalere',),
'avalerende': ('avalere',),
'avansert': ('avansere',),
'avanserte': ('avansere',),
'avanserende': ('avansere',),
'avantgardistisk': ('avantgardistisk',),
'avantgardistiske': ('avantgardistisk',),
'avantgardistisk': ('avantgardistisk',),
'avbaklig': ('avbaklig',),
'avbaklige': ('avbaklig',),
'avbaklig': ('avbaklig',),
'avbalansert': ('avbalansere',),
'avbalanserte': ('avbalansere',),
'avbalanserende': ('avbalansere',),
'avbalansert': ('avbalansert',),
'avbalanserte': ('avbalansert',),
'avbalansert': ('avbalansert',),
'avbestilt': ('avbestille',),
'avbestilte': ('avbestille',),
'avbestillende': ('avbestille',),
'avbetalt': ('avbetale',),
'avbetalte': ('avbetale',),
'avbetalende': ('avbetale',),
'avbilda': ('avbilde',),
'avbildet': ('avbilde',),
'avbilda': ('avbilde',),
'avbildet': ('avbilde',),
'avbilda': ('avbilde',),
'avbildete': ('avbilde',),
'avbildede': ('avbilde',),
'avbilda': ('avbilde',),
'avbildete': ('avbilde',),
'avbildede': ('avbilde',),
'avbildende': ('avbilde',),
'avbundet': ('avbinde',),
'avbunden': ('avbinde',),
'avbundne': ('avbinde',),
'avbindende': ('avbinde',),
'avbleiket': ('avbleiket',),
'avbleikete': ('avbleiket',),
'avbleikede': ('avbleiket',),
'avbleikete': ('avbleiket',),
'avbleikede': ('avbleiket',),
'avbleiket': ('avbleiket',),
'avbleikt': ('avbleikt',),
'avbleikte': ('avbleikt',),
'avbleikt': ('avbleikt',),
'avbleket': ('avbleket',),
'avblekete': ('avbleket',),
'avblekede': ('avbleket',),
'avblekete': ('avbleket',),
'avblekede': ('avbleket',),
'avbleket': ('avbleket',),
'avblekt': ('avblekt',),
'avblekte': ('avblekt',),
'avblekt': ('avblekt',),
'avblomstra': ('avblomstra',),
'avblomstret': ('avblomstret',),
'avblomstrete': ('avblomstret',),
'avblomstrede': ('avblomstret',),
'avblomstrete': ('avblomstret',),
'avblomstrede': ('avblomstret',),
'avblomstret': ('avblomstret',),
'avblåst': ('avblåse',),
'avblåste': ('avblåse',),
'avblåsende': ('avblåse',),
'avbrutt': ('avbryte',),
'avbrutte': ('avbryte',),
'avbrytende': ('avbryte',),
'avbøtt': ('avbøte',),
'avbøtte': ('avbøte',),
'avbøtende': ('avbøte',),
'avbøyet': ('avbøye',),
'avbøyd': ('avbøye',),
'avbøyet': ('avbøye',),
'avbøyd': ('avbøye',),
'avbøyete': ('avbøye',),
'avbøyede': ('avbøye',),
'avbøyde': ('avbøye',),
'avbøyete': ('avbøye',),
'avbøyede': ('avbøye',),
'avbøyde': ('avbøye',),
'avbøyende': ('avbøye',),
'avdampa': ('avdampe',),
'avdampet': ('avdampe',),
'avdampa': ('avdampe',),
'avdampet': ('avdampe',),
'avdampa': ('avdampe',),
'avdampete': ('avdampe',),
'avdampede': ('avdampe',),
'avdampa': ('avdampe',),
'avdampete': ('avdampe',),
'avdampede': ('avdampe',),
'avdampende': ('avdampe',),
'avdanka': ('avdanka',),
'avdanket': ('avdanket',),
'avdankete': ('avdanket',),
'avdankede': ('avdanket',),
'avdankete': ('avdanket',),
'avdankede': ('avdanket',),
'avdanket': ('avdanket',),
'avdekka': ('avdekke',),
'avdekket': ('avdekke',),
'avdekt': ('avdekke',),
'avdekka': ('avdekke',),
'avdekket': ('avdekke',),
'avdekt': ('avdekke',),
'avdekka': ('avdekke',),
'avdekkete': ('avdekke',),
'avdekkede': ('avdekke',),
'avdekte': ('avdekke',),
'avdekka': ('avdekke',),
'avdekkete': ('avdekke',),
'avdekkede': ('avdekke',),
'avdekte': ('avdekke',),
'avdekkende': ('avdekke',),
'avdelt': ('avdele',),
'avdelte': ('avdele',),
'avdelende': ('avdele',),
'avdempa': ('avdempe',),
'avdempet': ('avdempe',),
'avdempa': ('avdempe',),
'avdempet': ('avdempe',),
'avdempa': ('avdempe',),
'avdempete': ('avdempe',),
'avdempede': ('avdempe',),
'avdempa': ('avdempe',),
'avdempete': ('avdempe',),
'avdempede': ('avdempe',),
'avdempende': ('avdempe',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdradd': ('avdra',),
'avdratt': ('avdra',),
'avdradde': ('avdra',),
'avdratte': ('avdra',),
'avdradde': ('avdra',),
'avdratte': ('avdra',),
'avdradde': ('avdra',),
'avdratte': ('avdra',),
'avdradde': ('avdra',),
'avdratte': ('avdra',),
'avdragende': ('avdra',),
'avdragsfri': ('avdragsfri',),
'avdragsfrie': ('avdragsfri',),
'avdragsfritt': ('avdragsfri',),
'avdramatisert': ('avdramatisere',),
'avdramatiserte': ('avdramatisere',),
'avdramatiserende': ('avdramatisere',),
'avduka': ('avduke',),
'avduket': ('avduke',),
'avduka': ('avduke',),
'avduket': ('avduke',),
'avduka': ('avduke',),
'avdukete': ('avduke',),
'avdukede': ('avduke',),
'avduka': ('avduke',),
'avdukete': ('avduke',),
'avdukede': ('avduke',),
'avdukende': ('avduke',),
'avdød': ('avdød',),
'avdøde': ('avdød',),
'avdødt': ('avdød',),
'avertert': ('avertere',),
'averterte': ('avertere',),
'averterende': ('avertere',),
'avfalma': ('avfalma',),
'avfalmet': ('avfalmet',),
'avfalmete': ('avfalmet',),
'avfalmede': ('avfalmet',),
'avfalmete': ('avfalmet',),
'avfalmede': ('avfalmet',),
'avfalmet': ('avfalmet',),
'avfasa': ('avfase',),
'avfaset': ('avfase',),
'avfasa': ('avfase',),
'avfaset': ('avfase',),
'avfasa': ('avfase',),
'avfasete': ('avfase',),
'avfasede': ('avfase',),
'avfasa': ('avfase',),
'avfasete': ('avfase',),
'avfasede': ('avfase',),
'avfasende': ('avfase',),
'avfatta': ('avfatte',),
'avfattet': ('avfatte',),
'avfatta': ('avfatte',),
'avfattet': ('avfatte',),
'avfatta': ('avfatte',),
'avfattete': ('avfatte',),
'avfattede': ('avfatte',),
'avfatta': ('avfatte',),
'avfattete': ('avfatte',),
'avfattede': ('avfatte',),
'avfattende': ('avfatte',),
'avfeiet': ('avfeie',),
'avfeid': ('avfeie',),
'avfeiet': ('avfeie',),
'avfeid': ('avfeie',),
'avfeiete': ('avfeie',),
'avfeiede': ('avfeie',),
'avfeide': ('avfeie',),
'avfeiete': ('avfeie',),
'avfeiede': ('avfeie',),
'avfeide': ('avfeie',),
'avfeiende': ('avfeie',),
'avfeldig': ('avfeldig',),
'avfeldige': ('avfeldig',),
'avfeldig': ('avfeldig',),
'avferdiga': ('avferdige',),
'avferdiget': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdiget': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdigete': ('avferdige',),
'avferdigede': ('avferdige',),
'avferdiga': ('avferdige',),
'avferdigete': ('avferdige',),
'avferdigede': ('avferdige',),
'avferdigende': ('avferdige',),
'avfetta': ('avfette',),
'avfettet': ('avfette',),
'avfetta': ('avfette',),
'avfettet': ('avfette',),
'avfetta': ('avfette',),
'avfettete': ('avfette',),
'avfettede': ('avfette',),
'avfetta': ('avfette',),
'avfettete': ('avfette',),
'avfettede': ('avfette',),
'avfettende': ('avfette',),
'avfunnet': ('avfinne',),
'avfunnen': ('avfinne',),
'avfunne': ('avfinne',),
'avfinnende': ('avfinne',),
'avfolka': ('avfolke',),
'avfolket': ('avfolke',),
'avfolka': ('avfolke',),
'avfolket': ('avfolke',),
'avfolka': ('avfolke',),
'avfolkete': ('avfolke',),
'avfolkede': ('avfolke',),
'avfolka': ('avfolke',),
'avfolkete': ('avfolke',),
'avfolkede': ('avfolke',),
'avfolkende': ('avfolke',),
'avfyrt': ('avfyre',),
'avfyrte': ('avfyre',),
'avfyrende': ('avfyre',),
'avfødt': ('avføde',),
'avfødte': ('avføde',),
'avfødende': ('avføde',),
'avført': ('avføre',),
'avførte': ('avføre',),
'avførende': ('avføre',),
'avførende': ('avførende',),
'avgitt': ('avgi',),
'avgitte': ('avgi',),
'avgiende': ('avgi',),
'avgiftsfri': ('avgiftsfri',),
'avgiftsfrie': ('avgiftsfri',),
'avgiftsfritt': ('avgiftsfri',),
'avgiftspliktig': ('avgiftspliktig',),
'avgiftspliktige': ('avgiftspliktig',),
'avgiftspliktig': ('avgiftspliktig',),
'avgjort': ('avgjort',),
'avgjorte': ('avgjort',),
'avgjort': ('avgjort',),
'avgjort': ('avgjøre',),
'avgjorte': ('avgjøre',),
'avgjørende': ('avgjøre',),
'avgjørende': ('avgjørende',),
'avglemt': ('avglemt',),
'avglemte': ('avglemt',),
'avglemt': ('avglemt',),
'avglømt': ('avglømt',),
'avglømte': ('avglømt',),
'avglømt': ('avglømt',),
'avgrensa': ('avgrense',),
'avgrenset': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrenset': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrensete': ('avgrense',),
'avgrensede': ('avgrense',),
'avgrensa': ('avgrense',),
'avgrensete': ('avgrense',),
'avgrensede': ('avgrense',),
'avgrensende': ('avgrense',),
'avgrunnsdjup': ('avgrunnsdjup',),
'avgrunnsdjupe': ('avgrunnsdjup',),
'avgrunnsdjupt': ('avgrunnsdjup',),
'avgrunnsdyp': ('avgrunnsdyp',),
'avgrunnsdype': ('avgrunnsdyp',),
'avgrunnsdypt': ('avgrunnsdyp',),
'avgrunnsmørk': ('avgrunnsmørk',),
'avgrunnsmørke': ('avgrunnsmørk',),
'avgrunnsmørkt': ('avgrunnsmørk',),
'avgått': ('avgå',),
'avgåtte': ('avgå',),
'avgående': ('avgå',),
'avgående': ('avgående',),
'avgått': ('avgått',),
'avgåtte': ('avgått',),
'avgått': ('avgått',),
'avheimla': ('avheimle',),
'avheimlet': ('avheimle',),
'avheimla': ('avheimle',),
'avheimlet': ('avheimle',),
'avheimla': ('avheimle',),
'avheimlete': ('avheimle',),
'avheimlede': ('avheimle',),
'avheimlete': ('avheimle',),
'avheimlede': ('avheimle',),
'avheimla': ('avheimle',),
'avheimlete': ('avheimle',),
'avheimlede': ('avheimle',),
'avheimlete': ('avheimle',),
'avheimlede': ('avheimle',),
'avheimlende': ('avheimle',),
'avhenda': ('avhende',),
'avhendet': ('avhende',),
'avhenda': ('avhende',),
'avhendet': ('avhende',),
'avhenda': ('avhende',),
'avhendete': ('avhende',),
'avhendede': ('avhende',),
'avhenda': ('avhende',),
'avhendete': ('avhende',),
'avhendede': ('avhende',),
'avhendende': ('avhende',),
'avhendelig': ('avhendelig',),
'avhendelige': ('avhendelig',),
'avhendelig': ('avhendelig',),
'avhengt': ('avhenge',),
'avhengte': ('avhenge',),
'avhengende': ('avhenge',),
'avhengig': ('avhengig',),
'avhengige': ('avhengig',),
'avhengig': ('avhengig',),
'avhenta': ('avhente',),
'avhentet': ('avhente',),
'avhenta': ('avhente',),
'avhentet': ('avhente',),
'avhenta': ('avhente',),
'avhentete': ('avhente',),
'avhentede': ('avhente',),
'avhenta': ('avhente',),
'avhentete': ('avhente',),
'avhentede': ('avhente',),
'avhentende': ('avhente',),
'avherda': ('avherde',),
'avherdet': ('avherde',),
'avherda': ('avherde',),
'avherdet': ('avherde',),
'avherda': ('avherde',),
'avherdete': ('avherde',),
'avherdede': ('avherde',),
'avherda': ('avherde',),
'avherdete': ('avherde',),
'avherdede': ('avherde',),
'avherdende': ('avherde',),
'avhjulpet': ('avhjelpe',),
'avhjulpen': ('avhjelpe',),
'avhjulpne': ('avhjelpe',),
'avhjelpende': ('avhjelpe',),
'avhjemla': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemlete': ('avhjemle',),
'avhjemlede': ('avhjemle',),
'avhjemlete': ('avhjemle',),
'avhjemlede': ('avhjemle',),
'avhjemla': ('avhjemle',),
'avhjemlete': ('avhjemle',),
'avhjemlede': ('avhjemle',),
'avhjemlete': ('avhjemle',),
'avhjemlede': ('avhjemle',),
'avhjemlende': ('avhjemle',),
'avholdt': ('avholde',),
'avholdte': ('avholde',),
'avholdende': ('avholde',),
'avholdende': ('avholdende',),
'avholdt': ('avholdt',),
'avholdte': ('avholdt',),
'avholdt': ('avholdt',),
'avhørt': ('avhøre',),
'avhørte': ('avhøre',),
'avhørende': ('avhøre',),
'aviatisk': ('aviatisk',),
'aviatiske': ('aviatisk',),
'aviatisk': ('aviatisk',),
'avindsjuk': ('avindsjuk',),
'avindsjuke': ('avindsjuk',),
'avindsjukt': ('avindsjuk',),
'avindsyk': ('avindsyk',),
'avindsyke': ('avindsyk',),
'avindsykt': ('avindsyk',),
'avist': ('avise',),
'aviste': ('avise',),
'avisende': ('avise',),
'avkanta': ('avkante',),
'avkantet': ('avkante',),
'avkanta': ('avkante',),
'avkantet': ('avkante',),
'avkanta': ('avkante',),
'avkantete': ('avkante',),
'avkantede': ('avkante',),
'avkanta': ('avkante',),
'avkantete': ('avkante',),
'avkantede': ('avkante',),
'avkantende': ('avkante',),
'avkjølt': ('avkjøle',),
'avkjølte': ('avkjøle',),
'avkjølende': ('avkjøle',),
'avkjønna': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønnete': ('avkjønne',),
'avkjønnede': ('avkjønne',),
'avkjønna': ('avkjønne',),
'avkjønnete': ('avkjønne',),
'avkjønnede': ('avkjønne',),
'avkjønnende': ('avkjønne',),
'avklart': ('avklare',),
'avklarte': ('avklare',),
'avklarende': ('avklare',),
'avkledd': ('avkle',),
'avkledde': ('avkle',),
'avkleende': ('avkle',),
'avkledende': ('avkle',),
'avkledd': ('avkledd',),
'avkledde': ('avkledd',),
'avkledd': ('avkledd',),
'avkoda': ('avkode',),
'avkodet': ('avkode',),
'avkoda': ('avkode',),
'avkodet': ('avkode',),
'avkoda': ('avkode',),
'avkodete': ('avkode',),
'avkodede': ('avkode',),
'avkoda': ('avkode',),
'avkodete': ('avkode',),
'avkodede': ('avkode',),
'avkodende': ('avkode',),
'avkokt': ('avkoke',),
'avkokte': ('avkoke',),
'avkokende': ('avkoke',),
'avkolonisert': ('avkolonisere',),
'avkoloniserte': ('avkolonisere',),
'avkoloniserende': ('avkolonisere',),
'avkorta': ('avkorte',),
'avkortet': ('avkorte',),
'avkorta': ('avkorte',),
'avkortet': ('avkorte',),
'avkorta': ('avkorte',),
'avkortete': ('avkorte',),
'avkortede': ('avkorte',),
'avkorta': ('avkorte',),
'avkortete': ('avkorte',),
'avkortede': ('avkorte',),
'avkortende': ('avkorte',),
'avkrefta': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkreftete': ('avkrefte',),
'avkreftede': ('avkrefte',),
'avkrefta': ('avkrefte',),
'avkreftete': ('avkrefte',),
'avkreftede': ('avkrefte',),
'avkreftende': ('avkrefte',),
'avkrevet': ('avkreve',),
'avkrevd': ('avkreve',),
'avkrevet': ('avkreve',),
'avkrevd': ('avkreve',),
'avkrevete': ('avkreve',),
'avkrevede': ('avkreve',),
'avkrevde': ('avkreve',),
'avkrevete': ('avkreve',),
'avkrevede': ('avkreve',),
'avkrevde': ('avkreve',),
'avkrevende': ('avkreve',),
'avkriminalisert': ('avkriminalisere',),
'avkriminaliserte': ('avkriminalisere',),
'avkriminaliserende': ('avkriminalisere',),
'avkristna': ('avkristne',),
'avkristnet': ('avkristne',),
'avkristna': ('avkristne',),
'avkristnet': ('avkristne',),
'avkristna': ('avkristne',),
'avkristnete': ('avkristne',),
'avkristnede': ('avkristne',),
'avkristnete': ('avkristne',),
'avkristnede': ('avkristne',),
'avkristna': ('avkristne',),
'avkristnete': ('avkristne',),
'avkristnede': ('avkristne',),
'avkristnete': ('avkristne',),
'avkristnede': ('avkristne',),
'avkristnende': ('avkristne',),
'avlagt': ('avlagt',),
'avlagte': ('avlagt',),
'avlagt': ('avlagt',),
'avlang': ('avlang',),
'avlange': ('avlang',),
'avlangt': ('avlang',),
'avlasta': ('avlaste',),
'avlastet': ('avlaste',),
'avlasta': ('avlaste',),
'avlastet': ('avlaste',),
'avlasta': ('avlaste',),
'avlastete': ('avlaste',),
'avlastede': ('avlaste',),
'avlasta': ('avlaste',),
'avlastete': ('avlaste',),
'avlastede': ('avlaste',),
'avlastende': ('avlaste',),
'avla': ('avle',),
'avlet': ('avle',),
'avla': ('avle',),
'avlet': ('avle',),
'avla': ('avle',),
'avlete': ('avle',),
'avlede': ('avle',),
'avlete': ('avle',),
'avlede': ('avle',),
'avla': ('avle',),
'avlete': ('avle',),
'avlede': ('avle',),
'avlete': ('avle',),
'avlede': ('avle',),
'avlende': ('avle',),
'avleda': ('avlede',),
'avledet': ('avlede',),
'avleda': ('avlede',),
'avledet': ('avlede',),
'avleda': ('avlede',),
'avledete': ('avlede',),
'avledede': ('avlede',),
'avleda': ('avlede',),
'avledete': ('avlede',),
'avledede': ('avlede',),
'avledende': ('avlede',),
'avledyktig': ('avledyktig',),
'avledyktige': ('avledyktig',),
'avledyktig': ('avledyktig',),
'avlagt': ('avlegge',),
'avlagte': ('avlegge',),
'avleggende': ('avlegge',),
'avleggs': ('avleggs',),
'avleggse': ('avleggs',),
'avleggs': ('avleggs',),
'avleid': ('avleie',),
'avleide': ('avleie',),
'avleiende': ('avleie',),
'avleira': ('avleire',),
'avleiret': ('avleire',),
'avleira': ('avleire',),
'avleiret': ('avleire',),
'avleira': ('avleire',),
'avleirete': ('avleire',),
'avleirede': ('avleire',),
'avleira': ('avleire',),
'avleirete': ('avleire',),
'avleirede': ('avleire',),
'avleirende': ('avleire',),
'avlesbar': ('avlesbar',),
'avlesbare': ('avlesbar',),
'avlesbart': ('avlesbar',),
'avlest': ('avlese',),
'avleste': ('avlese',),
'avlesende': ('avlese',),
'avlevert': ('avlevere',),
'avleverte': ('avlevere',),
'avleverende': ('avlevere',),
'avliva': ('avlive',),
'avlivet': ('avlive',),
'avliva': ('avlive',),
'avlivet': ('avlive',),
'avliva': ('avlive',),
'avlivete': ('avlive',),
'avlivede': ('avlive',),
'avliva': ('avlive',),
'avlivete': ('avlive',),
'avlivede': ('avlive',),
'avlivende': ('avlive',),
'avlokka': ('avlokke',),
'avlokket': ('avlokke',),
'avlokka': ('avlokke',),
'avlokket': ('avlokke',),
'avlokka': ('avlokke',),
'avlokkete': ('avlokke',),
'avlokkede': ('avlokke',),
'avlokka': ('avlokke',),
'avlokkete': ('avlokke',),
'avlokkede': ('avlokke',),
'avlokkende': ('avlokke',),
'avlsproduktiv': ('avlsproduktiv',),
'avlsproduktive': ('avlsproduktiv',),
'avlsproduktivt': ('avlsproduktiv',),
'avlurt': ('avlure',),
'avlurte': ('avlure',),
'avlurende': ('avlure',),
'avlusa': ('avluse',),
'avluset': ('avluse',),
'avlust': ('avluse',),
'avlusa': ('avluse',),
'avluset': ('avluse',),
'avlust': ('avluse',),
'avlusa': ('avluse',),
'avlusete': ('avluse',),
'avlusede': ('avluse',),
'avluste': ('avluse',),
'avlusa': ('avluse',),
'avlusete': ('avluse',),
'avlusede': ('avluse',),
'avluste': ('avluse',),
'avlusende': ('avluse',),
'avlyst': ('avlyse',),
'avlyste': ('avlyse',),
'avlysende': ('avlyse',),
'avlytta': ('avlytte',),
'avlyttet': ('avlytte',),
'avlytta': ('avlytte',),
'avlyttet': ('avlytte',),
'avlytta': ('avlytte',),
'avlyttete': ('avlytte',),
'avlyttede': ('avlytte',),
'avlytta': ('avlytte',),
'avlyttete': ('avlytte',),
'avlyttede': ('avlytte',),
'avlyttende': ('avlytte',),
'avlåst': ('avlåse',),
'avlåste': ('avlåse',),
'avlåsende': ('avlåse',),
'avlønna': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønt': ('avlønne',),
'avlønna': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønt': ('avlønne',),
'avlønna': ('avlønne',),
'avlønnete': ('avlønne',),
'avlønnede': ('avlønne',),
'avlønte': ('avlønne',),
'avlønna': ('avlønne',),
'avlønnete': ('avlønne',),
'avlønnede': ('avlønne',),
'avlønte': ('avlønne',),
'avlønnende': ('avlønne',),
'avløst': ('avløse',),
'avløste': ('avløse',),
'avløsende': ('avløse',),
'avløyst': ('avløyse',),
'avløyste': ('avløyse',),
'avløysende': ('avløyse',),
'avmagnetisert': ('avmagnetisere',),
'avmagnetiserte': ('avmagnetisere',),
'avmagnetiserende': ('avmagnetisere',),
'avmagra': ('avmagre',),
'avmagret': ('avmagre',),
'avmagra': ('avmagre',),
'avmagret': ('avmagre',),
'avmagra': ('avmagre',),
'avmagrete': ('avmagre',),
'avmagrede': ('avmagre',),
'avmagrete': ('avmagre',),
'avmagrede': ('avmagre',),
'avmagra': ('avmagre',),
'avmagrete': ('avmagre',),
'avmagrede': ('avmagre',),
'avmagrete': ('avmagre',),
'avmagrede': ('avmagre',),
'avmagrende': ('avmagre',),
'avmarsjert': ('avmarsjere',),
'avmarsjerte': ('avmarsjere',),
'avmarsjerende': ('avmarsjere',),
'avmektig': ('avmektig',),
'avmektige': ('avmektig',),
'avmektig': ('avmektig',),
'avmerka': ('avmerke',),
'avmerket': ('avmerke',),
'avmerka': ('avmerke',),
'avmerket': ('avmerke',),
'avmerka': ('avmerke',),
'avmerkete': ('avmerke',),
'avmerkede': ('avmerke',),
'avmerka': ('avmerke',),
'avmerkete': ('avmerke',),
'avmerkede': ('avmerke',),
'avmerkende': ('avmerke',),
'avmilitarisert': ('avmilitarisere',),
'avmilitariserte': ('avmilitarisere',),
'avmilitariserende': ('avmilitarisere',),
'avmytologisert': ('avmytologisere',),
'avmytologiserte': ('avmytologisere',),
'avmytologiserende': ('avmytologisere',),
'avmålt': ('avmåle',),
'avmålte': ('avmåle',),
'avmålende': ('avmåle',),
'avmålt': ('avmålt',),
'avmålte': ('avmålt',),
'avmålt': ('avmålt',),
'avmønstra': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstrete': ('avmønstre',),
'avmønstrede': ('avmønstre',),
'avmønstrete': ('avmønstre',),
'avmønstrede': ('avmønstre',),
'avmønstra': ('avmønstre',),
'avmønstrete': ('avmønstre',),
'avmønstrede': ('avmønstre',),
'avmønstrete': ('avmønstre',),
'avmønstrede': ('avmønstre',),
'avmønstrende': ('avmønstre',),
'avnasjonalisert': ('avnasjonalisere',),
'avnasjonaliserte': ('avnasjonalisere',),
'avnasjonaliserende': ('avnasjonalisere',),
'avnorska': ('avnorske',),
'avnorsket': ('avnorske',),
'avnorska': ('avnorske',),
'avnorsket': ('avnorske',),
'avnorska': ('avnorske',),
'avnorskete': ('avnorske',),
'avnorskede': ('avnorske',),
'avnorska': ('avnorske',),
'avnorskete': ('avnorske',),
'avnorskede': ('avnorske',),
'avnorskende': ('avnorske',),
'avokadogrønn': ('avokadogrønn',),
'avokadogrønne': ('avokadogrønn',),
'avokadogrønt': ('avokadogrønn',),
'avpassa': ('avpasse',),
'avpasset': ('avpasse',),
'avpassa': ('avpasse',),
'avpasset': ('avpasse',),
'avpassa': ('avpasse',),
'avpassete': ('avpasse',),
'avpassede': ('avpasse',),
'avpassa': ('avpasse',),
'avpassete': ('avpasse',),
'avpassede': ('avpasse',),
'avpassende': ('avpasse',),
'avpatruljert': ('avpatruljere',),
'avpatruljerte': ('avpatruljere',),
'avpatruljerende': ('avpatruljere',),
'avpolitisert': ('avpolitisere',),
'avpolitiserte': ('avpolitisere',),
'avpolitiserende': ('avpolitisere',),
'avreagert': ('avreagere',),
'avreagerte': ('avreagere',),
'avreagerende': ('avreagere',),
'avretta': ('avrette',),
'avrettet': ('avrette',),
'avretta': ('avrette',),
'avrettet': ('avrette',),
'avretta': ('avrette',),
'avrettete': ('avrette',),
'avrettede': ('avrette',),
'avretta': ('avrette',),
'avrettete': ('avrette',),
'avrettede': ('avrette',),
'avrettende': ('avrette',),
'avrima': ('avrime',),
'avrimet': ('avrime',),
'avrima': ('avrime',),
'avrimet': ('avrime',),
'avrima': ('avrime',),
'avrimete': ('avrime',),
'avrimede': ('avrime',),
'avrima': ('avrime',),
'avrimete': ('avrime',),
'avrimede': ('avrime',),
'avrimende': ('avrime',),
'avrunda': ('avrunde',),
'avrundet': ('avrunde',),
'avrunda': ('avrunde',),
'avrundet': ('avrunde',),
'avrunda': ('avrunde',),
'avrundete': ('avrunde',),
'avrundede': ('avrunde',),
'avrunda': ('avrunde',),
'avrundete': ('avrunde',),
'avrundede': ('avrunde',),
'avrundende': ('avrunde',),
'avrusa': ('avruse',),
'avruset': ('avruse',),
'avrusa': ('avruse',),
'avruset': ('avruse',),
'avrusa': ('avruse',),
'avrusete': ('avruse',),
'avrusede': ('avruse',),
'avrusa': ('avruse',),
'avrusete': ('avruse',),
'avrusede': ('avruse',),
'avrusende': ('avruse',),
'avrusta': ('avruste',),
'avrustet': ('avruste',),
'avrusta': ('avruste',),
'avrustet': ('avruste',),
'avrusta': ('avruste',),
'avrustete': ('avruste',),
'avrustede': ('avruste',),
'avrusta': ('avruste',),
'avrustete': ('avruste',),
'avrustede': ('avruste',),
'avrustende': ('avruste',),
'avsanna': ('avsanne',),
'avsannet': ('avsanne',),
'avsanna': ('avsanne',),
'avsannet': ('avsanne',),
'avsanna': ('avsanne',),
'avsannete': ('avsanne',),
'avsannede': ('avsanne',),
'avsanna': ('avsanne',),
'avsannete': ('avsanne',),
'avsannede': ('avsanne',),
'avsannende': ('avsanne',),
'avsett': ('avse',),
'avsette': ('avse',),
'avseende': ('avse',),
'avsendt': ('avsende',),
'avsendte': ('avsende',),
'avsendende': ('avsende',),
'avsatt': ('avsette',),
'avsatte': ('avsette',),
'avsettende': ('avsette',),
'avsagt': ('avsi',),
'avsagte': ('avsi',),
'avsiende': ('avsi',),
'avsides': ('avsides',),
'avsidesliggende': ('avsidesliggende',),
'avsilt': ('avsile',),
'avsilte': ('avsile',),
'avsilende': ('avsile',),
'avsindig': ('avsindig',),
'avsindige': ('avsindig',),
'avsindig': ('avsindig',),
'avsjela': ('avsjela',),
'avsjelet': ('avsjelet',),
'avsjelete': ('avsjelet',),
'avsjelede': ('avsjelet',),
'avsjelete': ('avsjelet',),
'avsjelede': ('avsjelet',),
'avsjelet': ('avsjelet',),
'avsjelt': ('avsjelt',),
'avsjelte': ('avsjelt',),
'avsjelt': ('avsjelt',),
'avskaffa': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffete': ('avskaffe',),
'avskaffede': ('avskaffe',),
'avskaffa': ('avskaffe',),
'avskaffete': ('avskaffe',),
'avskaffede': ('avskaffe',),
'avskaffende': ('avskaffe',),
'avskalla': ('avskalle',),
'avskallet': ('avskalle',),
'avskalla': ('avskalle',),
'avskallet': ('avskalle',),
'avskalla': ('avskalle',),
'avskallete': ('avskalle',),
'avskallede': ('avskalle',),
'avskalla': ('avskalle',),
'avskallete': ('avskalle',),
'avskallede': ('avskalle',),
'avskallende': ('avskalle',),
'avskilta': ('avskilte',),
'avskiltet': ('avskilte',),
'avskilta': ('avskilte',),
'avskiltet': ('avskilte',),
'avskilta': ('avskilte',),
'avskiltete': ('avskilte',),
'avskiltede': ('avskilte',),
'avskilta': ('avskilte',),
'avskiltete': ('avskilte',),
'avskiltede': ('avskilte',),
'avskiltende': ('avskilte',),
'avskipa': ('avskipe',),
'avskipet': ('avskipe',),
'avskipa': ('avskipe',),
'avskipet': ('avskipe',),
'avskipa': ('avskipe',),
'avskipete': ('avskipe',),
'avskipede': ('avskipe',),
'avskipa': ('avskipe',),
'avskipete': ('avskipe',),
'avskipede': ('avskipe',),
'avskipende': ('avskipe',),
'avskjediga': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjedigete': ('avskjedige',),
'avskjedigede': ('avskjedige',),
'avskjediga': ('avskjedige',),
'avskjedigete': ('avskjedige',),
'avskjedigede': ('avskjedige',),
'avskjedigende': ('avskjedige',),
'avskjerma': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjermete': ('avskjerme',),
'avskjermede': ('avskjerme',),
'avskjerma': ('avskjerme',),
'avskjermete': ('avskjerme',),
'avskjermede': ('avskjerme',),
'avskjermende': ('avskjerme',),
'avskåret': ('avskjære',),
'avskåren': ('avskjære',),
'avskårne': ('avskjære',),
'avskjærende': ('avskjære',),
'avskoga': ('avskoge',),
'avskoget': ('avskoge',),
'avskoga': ('avskoge',),
'avskoget': ('avskoge',),
'avskoga': ('avskoge',),
'avskogete': ('avskoge',),
'avskogede': ('avskoge',),
'avskoga': ('avskoge',),
'avskogete': ('avskoge',),
'avskogede': ('avskoge',),
'avskogende': ('avskoge',),
'avskrapa': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapt': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapt': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrapete': ('avskrape',),
'avskrapede': ('avskrape',),
'avskrapte': ('avskrape',),
'avskrapa': ('avskrape',),
'avskrapete': ('avskrape',),
'avskrapede': ('avskrape',),
'avskrapte': ('avskrape',),
'avskrapende': ('avskrape',),
'avskrekka': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekkete': ('avskrekke',),
'avskrekkede': ('avskrekke',),
'avskrekka': ('avskrekke',),
'avskrekkete': ('avskrekke',),
'avskrekkede': ('avskrekke',),
'avskrekkende': ('avskrekke',),
'avskrekkende': ('avskrekkende',),
'avskrevet': ('avskrive',),
'avskreven': ('avskrive',),
'avskrevne': ('avskrive',),
'avskrivende': ('avskrive',),
'avskydd': ('avsky',),
'avskydde': ('avsky',),
'avskyende': ('avsky',),
'avskyelig': ('avskyelig',),
'avskyelige': ('avskyelig',),
'avskyelig': ('avskyelig',),
'avskyvekkende': ('avskyvekkende',),
'avskåren': ('avskåren',),
'avskårne': ('avskåren',),
'avskåret': ('avskåren',),
'avskåret': ('avskåret',),
'avskårne': ('avskåret',),
'avskåret': ('avskåret',),
'avslappa': ('avslappa',),
'avslappet': ('avslappet',),
'avslappete': ('avslappet',),
'avslappede': ('avslappet',),
'avslappete': ('avslappet',),
'avslappede': ('avslappet',),
'avslappet': ('avslappet',),
'avslepen': ('avslepen',),
'avslepne': ('avslepen',),
'avslepent': ('avslepen',),
'avslutta': ('avslutte',),
'avsluttet': ('avslutte',),
'avslutta': ('avslutte',),
'avsluttet': ('avslutte',),
'avslutta': ('avslutte',),
'avsluttete': ('avslutte',),
'avsluttede': ('avslutte',),
'avslutta': ('avslutte',),
'avsluttete': ('avslutte',),
'avsluttede': ('avslutte',),
'avsluttende': ('avslutte',),
'avsluttende': ('avsluttende',),
'avslått': ('avslå',),
'avslåtte': ('avslå',),
'avslående': ('avslå',),
'avsløra': ('avsløre',),
'avsløret': ('avsløre',),
'avslørt': ('avsløre',),
'avsløra': ('avsløre',),
'avsløret': ('avsløre',),
'avslørt': ('avsløre',),
'avsløra': ('avsløre',),
'avslørete': ('avsløre',),
'avslørede': ('avsløre',),
'avslørte': ('avsløre',),
'avsløra': ('avsløre',),
'avslørete': ('avsløre',),
'avslørede': ('avsløre',),
'avslørte': ('avsløre',),
'avslørende': ('avsløre',),
'avslørende': ('avslørende',),
'avsondra': ('avsondre',),
'avsondret': ('avsondre',),
'avsondra': ('avsondre',),
'avsondret': ('avsondre',),
'avsondra': ('avsondre',),
'avsondrete': ('avsondre',),
'avsondrede': ('avsondre',),
'avsondrete': ('avsondre',),
'avsondrede': ('avsondre',),
'avsondra': ('avsondre',),
'avsondrete': ('avsondre',),
'avsondrede': ('avsondre',),
'avsondrete': ('avsondre',),
'avsondrede': ('avsondre',),
'avsondrende': ('avsondre',),
'avsona': ('avsone',),
'avsonet': ('avsone',),
'avsont': ('avsone',),
'avsona': ('avsone',),
'avsonet': ('avsone',),
'avsont': ('avsone',),
'avsona': ('avsone',),
'avsonete': ('avsone',),
'avsonede': ('avsone',),
'avsonte': ('avsone',),
'avsona': ('avsone',),
'avsonete': ('avsone',),
'avsonede': ('avsone',),
'avsonte': ('avsone',),
'avsonende': ('avsone',),
'avspalta': ('avspalte',),
'avspaltet': ('avspalte',),
'avspalta': ('avspalte',),
'avspaltet': ('avspalte',),
'avspalta': ('avspalte',),
'avspaltete': ('avspalte',),
'avspaltede': ('avspalte',),
'avspalta': ('avspalte',),
'avspaltete': ('avspalte',),
'avspaltede': ('avspalte',),
'avspaltende': ('avspalte',),
'avspasert': ('avspasere',),
'avspaserte': ('avspasere',),
'avspaserende': ('avspasere',),
'avspeila': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilt': ('avspeile',),
'avspeila': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilt': ('avspeile',),
'avspeila': ('avspeile',),
'avspeilete': ('avspeile',),
'avspeilede': ('avspeile',),
'avspeilte': ('avspeile',),
'avspeila': ('avspeile',),
'avspeilete': ('avspeile',),
'avspeilede': ('avspeile',),
'avspeilte': ('avspeile',),
'avspeilende': ('avspeile',),
'avspent': ('avspent',),
'avspente': ('avspent',),
'avspent': ('avspent',),
'avsperra': ('avsperre',),
'avsperret': ('avsperre',),
'avsperra': ('avsperre',),
'avsperret': ('avsperre',),
'avsperra': ('avsperre',),
'avsperrete': ('avsperre',),
'avsperrede': ('avsperre',),
'avsperra': ('avsperre',),
'avsperrete': ('avsperre',),
'avsperrede': ('avsperre',),
'avsperrende': ('avsperre',),
'avspist': ('avspise',),
'avspiste': ('avspise',),
'avspisende': ('avspise',),
'avspora': ('avspore',),
'avsporet': ('avspore',),
'avsport': ('avspore',),
'avspora': ('avspore',),
'avsporet': ('avspore',),
'avsport': ('avspore',),
'avspora': ('avspore',),
'avsporete': ('avspore',),
'avsporede': ('avspore',),
'avsporte': ('avspore',),
'avspora': ('avspore',),
'avsporete': ('avspore',),
'avsporede': ('avspore',),
'avsporte': ('avspore',),
'avsporende': ('avspore',),
'avstedkommet': ('avstedkomme',),
'avstedkommen': ('avstedkomme',),
'avstedkomne': ('avstedkomme',),
'avstedkommende': ('avstedkomme',),
'avstemt': ('avstemme',),
'avstemte': ('avstemme',),
'avstemmende': ('avstemme',),
'avstengt': ('avstengt',),
'avstengte': ('avstengt',),
'avstengt': ('avstengt',),
'avstikkende': ('avstikkende',),
'avstiva': ('avstive',),
'avstivet': ('avstive',),
'avstiva': ('avstive',),
'avstivet': ('avstive',),
'avstiva': ('avstive',),
'avstivete': ('avstive',),
'avstivede': ('avstive',),
'avstiva': ('avstive',),
'avstivete': ('avstive',),
'avstivede': ('avstive',),
'avstivende': ('avstive',),
'avstraffa': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffete': ('avstraffe',),
'avstraffede': ('avstraffe',),
'avstraffa': ('avstraffe',),
'avstraffete': ('avstraffe',),
'avstraffede': ('avstraffe',),
'avstraffende': ('avstraffe',),
'avstressa': ('avstresse',),
'avstresset': ('avstresse',),
'avstressa': ('avstresse',),
'avstresset': ('avstresse',),
'avstressa': ('avstresse',),
'avstressete': ('avstresse',),
'avstressede': ('avstresse',),
'avstressa': ('avstresse',),
'avstressete': ('avstresse',),
'avstressede': ('avstresse',),
'avstressende': ('avstresse',),
'avstumpa': ('avstumpa',),
'avstumpet': ('avstumpet',),
'avstumpete': ('avstumpet',),
'avstumpede': ('avstumpet',),
'avstumpete': ('avstumpet',),
'avstumpede': ('avstumpet',),
'avstumpet': ('avstumpet',),
'avstått': ('avstå',),
'avståtte': ('avstå',),
'avstående': ('avstå',),
'avstøpt': ('avstøpe',),
'avstøpte': ('avstøpe',),
'avstøpende': ('avstøpe',),
'avsvekka': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekt': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekt': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekkete': ('avsvekke',),
'avsvekkede': ('avsvekke',),
'avsvekte': ('avsvekke',),
'avsvekka': ('avsvekke',),
'avsvekkete': ('avsvekke',),
'avsvekkede': ('avsvekke',),
'avsvekte': ('avsvekke',),
'avsvekkende': ('avsvekke',),
'avsverga': ('avsverge',),
'avsverget': ('avsverge',),
'avsvoret': ('avsverge',),
'avsverga': ('avsverge',),
'avsverget': ('avsverge',),
'avsvoret': ('avsverge',),
'avsvoren': ('avsverge',),
'avsverga': ('avsverge',),
'avsvergete': ('avsverge',),
'avsvergede': ('avsverge',),
'avsvorne': ('avsverge',),
'avsverga': ('avsverge',),
'avsvergete': ('avsverge',),
'avsvergede': ('avsverge',),
'avsvorne': ('avsverge',),
'avsvergende': ('avsverge',),
'avsvidd': ('avsvi',),
'avsvidde': ('avsvi',),
'avsviende': ('avsvi',),
'avsunget': ('avsynge',),
'avsungen': ('avsynge',),
'avsungne': ('avsynge',),
'avsyngende': ('avsynge',),
'avtatt': ('avta',),
'avtatte': ('avta',),
'avtakende': ('avta',),
'avtagende': ('avtagende',),
'avtakbar': ('avtakbar',),
'avtakbare': ('avtakbar',),
'avtakbart': ('avtakbar',),
'avtakende': ('avtakende',),
'avtalt': ('avtale',),
'avtalte': ('avtale',),
'avtalende': ('avtale',),
'avtalefesta': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefestete': ('avtalefeste',),
'avtalefestede': ('avtalefeste',),
'avtalefesta': ('avtalefeste',),
'avtalefestete': ('avtalefeste',),
'avtalefestede': ('avtalefeste',),
'avtalefestende': ('avtalefeste',),
'avtegna': ('avtegne',),
'avtegnet': ('avtegne',),
'avtegna': ('avtegne',),
'avtegnet': ('avtegne',),
'avtegna': ('avtegne',),
'avtegnete': ('avtegne',),
'avtegnede': ('avtegne',),
'avtegna': ('avtegne',),
'avtegnete': ('avtegne',),
'avtegnede': ('avtegne',),
'avtegnende': ('avtegne',),
'avtjent': ('avtjene',),
'avtjente': ('avtjene',),
'avtjenende': ('avtjene',),
'avtrappa': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappete': ('avtrappe',),
'avtrappede': ('avtrappe',),
'avtrappa': ('avtrappe',),
'avtrappete': ('avtrappe',),
'avtrappede': ('avtrappe',),
'avtrappende': ('avtrappe',),
'avtroppende': ('avtroppende',),
'avtvunget': ('avtvinge',),
'avtvungen': ('avtvinge',),
'avtvungne': ('avtvinge',),
'avtvingende': ('avtvinge',),
'avundsjuk': ('avundsjuk',),
'avundsjuke': ('avundsjuk',),
'avundsjukt': ('avundsjuk',),
'avveid': ('avveie',),
'avveide': ('avveie',),
'avveiende': ('avveie',),
'avvekslende': ('avvekslende',),
'avvendt': ('avvende',),
'avvendte': ('avvende',),
'avvendende': ('avvende',),
'avvendelig': ('avvendelig',),
'avvendelige': ('avvendelig',),
'avvendelig': ('avvendelig',),
'avvennet': ('avvenne',),
'avvent': ('avvenne',),
'avvennet': ('avvenne',),
'avvent': ('avvenne',),
'avvennete': ('avvenne',),
'avvennede': ('avvenne',),
'avvente': ('avvenne',),
'avvennete': ('avvenne',),
'avvennede': ('avvenne',),
'avvente': ('avvenne',),
'avvennende': ('avvenne',),
'avventa': ('avvente',),
'avventet': ('avvente',),
'avventa': ('avvente',),
'avventet': ('avvente',),
'avventa': ('avvente',),
'avventete': ('avvente',),
'avventede': ('avvente',),
'avventa': ('avvente',),
'avventete': ('avvente',),
'avventede': ('avvente',),
'avventende': ('avvente',),
'avventende': ('avventende',),
'avverga': ('avverge',),
'avverget': ('avverge',),
'avverga': ('avverge',),
'avverget': ('avverge',),
'avverga': ('avverge',),
'avvergete': ('avverge',),
'avvergede': ('avverge',),
'avverga': ('avverge',),
'avvergete': ('avverge',),
'avvergede': ('avverge',),
'avvergende': ('avverge',),
'avvergende': ('avvergende',),
'avveket': ('avvike',),
'avveken': ('avvike',),
'avvekne': ('avvike',),
'avvikende': ('avvike',),
'avvikende': ('avvikende',),
'avvikla': ('avvikle',),
'avviklet': ('avvikle',),
'avvikla': ('avvikle',),
'avviklet': ('avvikle',),
'avvikla': ('avvikle',),
'avviklete': ('avvikle',),
'avviklede': ('avvikle',),
'avviklete': ('avvikle',),
'avviklede': ('avvikle',),
'avvikla': ('avvikle',),
'avviklete': ('avvikle',),
'avviklede': ('avvikle',),
'avviklete': ('avvikle',),
'avviklede': ('avvikle',),
'avviklende': ('avvikle',),
'avvirka': ('avvirke',),
'avvirket': ('avvirke',),
'avvirka': ('avvirke',),
'avvirket': ('avvirke',),
'avvirka': ('avvirke',),
'avvirkete': ('avvirke',),
'avvirkede': ('avvirke',),
'avvirka': ('avvirke',),
'avvirkete': ('avvirke',),
'avvirkede': ('avvirke',),
'avvirkende': ('avvirke',),
'avvist': ('avvise',),
'avviste': ('avvise',),
'avvisende': ('avvise',),
'avvisende': ('avvisende',),
'avvæpna': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpnete': ('avvæpne',),
'avvæpnede': ('avvæpne',),
'avvæpnete': ('avvæpne',),
'avvæpnede': ('avvæpne',),
'avvæpna': ('avvæpne',),
'avvæpnete': ('avvæpne',),
'avvæpnede': ('avvæpne',),
'avvæpnete': ('avvæpne',),
'avvæpnede': ('avvæpne',),
'avvæpnende': ('avvæpne',),
'aztekisk': ('aztekisk',),
'aztekiske': ('aztekisk',),
'aztekisk': ('aztekisk',),
'babelsk': ('babelsk',),
'babelske': ('babelsk',),
'babelsk': ('babelsk',),
'babla': ('bable',),
'bablet': ('bable',),
'babla': ('bable',),
'bablet': ('bable',),
'babla': ('bable',),
'bablete': ('bable',),
'bablede': ('bable',),
'bablete': ('bable',),
'bablede': ('bable',),
'babla': ('bable',),
'bablete': ('bable',),
'bablede': ('bable',),
'bablete': ('bable',),
'bablede': ('bable',),
'bablende': ('bable',),
'bablet': ('bablet',),
'bablete': ('bablet',),
'bablet': ('bablet',),
'bablete': ('bablete',),
'babylonisk': ('babylonisk',),
'babyloniske': ('babylonisk',),
'babylonisk': ('babylonisk',),
'babylonsk': ('babylonsk',),
'babylonske': ('babylonsk',),
'babylonsk': ('babylonsk',),
'bada': ('bade',),
'badet': ('bade',),
'bada': ('bade',),
'badet': ('bade',),
'bada': ('bade',),
'badete': ('bade',),
'badede': ('bade',),
'bada': ('bade',),
'badete': ('bade',),
'badede': ('bade',),
'badende': ('bade',),
'bagatellisert': ('bagatellisere',),
'bagatelliserte': ('bagatellisere',),
'bagatelliserende': ('bagatellisere',),
'bagatellmessig': ('bagatellmessig',),
'bagatellmessige': ('bagatellmessig',),
'bagatellmessig': ('bagatellmessig',),
'bahamansk': ('bahamansk',),
'bahamanske': ('bahamansk',),
'bahamansk': ('bahamansk',),
'bahrainsk': ('bahrainsk',),
'bahrainske': ('bahrainsk',),
'bahrainsk': ('bahrainsk',),
'baissa': ('baisse',),
'baisset': ('baisse',),
'baissa': ('baisse',),
'baisset': ('baisse',),
'baissa': ('baisse',),
'baissete': ('baisse',),
'baissede': ('baisse',),
'baissa': ('baisse',),
'baissete': ('baisse',),
'baissede': ('baisse',),
'baissende': ('baisse',),
'bakbundet': ('bakbinde',),
'bakbunden': ('bakbinde',),
'bakbundne': ('bakbinde',),
'bakbindende': ('bakbinde',),
'bakt': ('bake',),
'bakte': ('bake',),
'bakende': ('bake',),
'bakerst': ('bakerst',),
'bakerste': ('bakerst',),
'bakerst': ('bakerst',),
'bakglatt': ('bakglatt',),
'bakglatte': ('bakglatt',),
'bakglatt': ('bakglatt',),
'bakhjulsdrevet': ('bakhjulsdrevet',),
'bakhjulsdrevne': ('bakhjulsdrevet',),
'bakhjulsdrevet': ('bakhjulsdrevet',),
'bakkantisk': ('bakkantisk',),
'bakkantiske': ('bakkantisk',),
'bakkantisk': ('bakkantisk',),
'bakka': ('bakke',),
'bakket': ('bakke',),
'bakka': ('bakke',),
'bakket': ('bakke',),
'bakka': ('bakke',),
'bakkete': ('bakke',),
'bakkede': ('bakke',),
'bakka': ('bakke',),
'bakkete': ('bakke',),
'bakkede': ('bakke',),
'bakkende': ('bakke',),
'bakket': ('bakket',),
'bakkete': ('bakket',),
'bakket': ('bakket',),
'bakkete': ('bakkete',),
'bakknappa': ('bakknappa',),
'bakknappet': ('bakknappet',),
'bakknappete': ('bakknappet',),
'bakknappede': ('bakknappet',),
'bakknappete': ('bakknappet',),
'bakknappede': ('bakknappet',),
'bakknappet': ('bakknappet',),
'bakoverbøyd': ('bakoverbøyd',),
'bakoverbøyde': ('bakoverbøyd',),
'bakoverbøyd': ('bakoverbøyd',),
'bakre': ('bakre',),
'bakerst': ('bakre',),
'bakerste': ('bakre',),
'baksa': ('bakse',),
'bakset': ('bakse',),
'baksa': ('bakse',),
'bakset': ('bakse',),
'baksa': ('bakse',),
'baksete': ('bakse',),
'baksede': ('bakse',),
'baksa': ('bakse',),
'baksete': ('bakse',),
'baksede': ('bakse',),
'baksende': ('bakse',),
'baksnakka': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakkete': ('baksnakke',),
'baksnakkede': ('baksnakke',),
'baksnakka': ('baksnakke',),
'baksnakkete': ('baksnakke',),
'baksnakkede': ('baksnakke',),
'baksnakkende': ('baksnakke',),
'bakstreversk': ('bakstreversk',),
'bakstreverske': ('bakstreversk',),
'bakstreversk': ('bakstreversk',),
'baktalt': ('baktale',),
'baktalte': ('baktale',),
'baktalende': ('baktale',),
'baktericid': ('baktericid',),
'bakteriedrepende': ('bakteriedrepende',),
'bakteriell': ('bakteriell',),
'bakterielle': ('bakteriell',),
'bakterielt': ('bakteriell',),
'bakteriologisk': ('bakteriologisk',),
'bakteriologiske': ('bakteriologisk',),
'bakteriologisk': ('bakteriologisk',),
'baktung': ('baktung',),
'baktunge': ('baktung',),
'baktungt': ('baktung',),
'bakvaska': ('bakvaske',),
'bakvasket': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvasket': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvaskete': ('bakvaske',),
'bakvaskede': ('bakvaske',),
'bakvaska': ('bakvaske',),
'bakvaskete': ('bakvaske',),
'bakvaskede': ('bakvaske',),
'bakvaskende': ('bakvaske',),
'bakvendt': ('bakvendt',),
'bakvendte': ('bakvendt',),
'bakvendt': ('bakvendt',),
'balansert': ('balansere',),
'balanserte': ('balansere',),
'balanserende': ('balansere',),
'bala': ('bale',),
'balet': ('bale',),
'balt': ('bale',),
'bala': ('bale',),
'balet': ('bale',),
'balt': ('bale',),
'bala': ('bale',),
'balete': ('bale',),
'balede': ('bale',),
'balte': ('bale',),
'bala': ('bale',),
'balete': ('bale',),
'balede': ('bale',),
'balte': ('bale',),
'balende': ('bale',),
'balinesisk': ('balinesisk',),
'balinesiske': ('balinesisk',),
'balinesisk': ('balinesisk',),
'balkanisert': ('balkanisere',),
'balkaniserte': ('balkanisere',),
'balkaniserende': ('balkanisere',),
'balkansk': ('balkansk',),
'balkanske': ('balkansk',),
'balkansk': ('balkansk',),
'ballasta': ('ballaste',),
'ballastet': ('ballaste',),
'ballasta': ('ballaste',),
'ballastet': ('ballaste',),
'ballasta': ('ballaste',),
'ballastete': ('ballaste',),
'ballastede': ('ballaste',),
'ballasta': ('ballaste',),
'ballastete': ('ballaste',),
'ballastede': ('ballaste',),
'ballastende': ('ballaste',),
'balla': ('balle',),
'ballet': ('balle',),
'balla': ('balle',),
'ballet': ('balle',),
'balla': ('balle',),
'ballete': ('balle',),
'ballede': ('balle',),
'balla': ('balle',),
'ballete': ('balle',),
'ballede': ('balle',),
'ballende': ('balle',),
'ballistisk': ('ballistisk',),
'ballistiske': ('ballistisk',),
'ballistisk': ('ballistisk',),
'ballongforma': ('ballongforma',),
'ballongformet': ('ballongformet',),
'ballongformete': ('ballongformet',),
'ballongformede': ('ballongformet',),
'ballongformete': ('ballongformet',),
'ballongformede': ('ballongformet',),
'ballongformet': ('ballongformet',),
'ballottert': ('ballottere',),
'ballotterte': ('ballottere',),
'ballotterende': ('ballottere',),
'balsamert': ('balsamere',),
'balsamerte': ('balsamere',),
'balsamerende': ('balsamere',),
'balstyren': ('balstyren',),
'balstyrne': ('balstyren',),
'balstyrent': ('balstyren',),
'balstyrig': ('balstyrig',),
'balstyrige': ('balstyrig',),
'balstyrig': ('balstyrig',),
'baltisk': ('baltisk',),
'baltiske': ('baltisk',),
'baltisk': ('baltisk',),
'banal': ('banal',),
'banale': ('banal',),
'banalt': ('banal',),
'banalisert': ('banalisere',),
'banaliserte': ('banalisere',),
'banaliserende': ('banalisere',),
'bandasjert': ('bandasjere',),
'bandasjerte': ('bandasjere',),
'bandasjerende': ('bandasjere',),
'banda': ('bande',),
'bandet': ('bande',),
'banda': ('bande',),
'bandet': ('bande',),
'banda': ('bande',),
'bandete': ('bande',),
'bandede': ('bande',),
'banda': ('bande',),
'bandete': ('bande',),
'bandede': ('bande',),
'bandende': ('bande',),
'bandlagt': ('bandlegge',),
'bandlagte': ('bandlegge',),
'bandleggende': ('bandlegge',),
'bana': ('bane',),
'banet': ('bane',),
'bant': ('bane',),
'bana': ('bane',),
'banet': ('bane',),
'bant': ('bane',),
'bana': ('bane',),
'banete': ('bane',),
'banede': ('bane',),
'bante': ('bane',),
'bana': ('bane',),
'banete': ('bane',),
'banede': ('bane',),
'bante': ('bane',),
'banende': ('bane',),
'banebrytende': ('banebrytende',),
'banepålagt': ('banepålagt',),
'banepålagte': ('banepålagt',),
'banepålagt': ('banepålagt',),
'bange': ('bange',),
'bangladeshisk': ('bangladeshisk',),
'bangladeshiske': ('bangladeshisk',),
'bangladeshisk': ('bangladeshisk',),
'banka': ('banke',),
'banket': ('banke',),
'banka': ('banke',),
'banket': ('banke',),
'banka': ('banke',),
'bankete': ('banke',),
'bankede': ('banke',),
'banka': ('banke',),
'bankete': ('banke',),
'bankede': ('banke',),
'bankende': ('banke',),
'bankerott': ('bankerott',),
'bankerotte': ('bankerott',),
'bankerott': ('bankerott',),
'banna': ('banne',),
'bannet': ('banne',),
'bant': ('banne',),
'banna': ('banne',),
'bannet': ('banne',),
'bant': ('banne',),
'banna': ('banne',),
'bannete': ('banne',),
'bannede': ('banne',),
'bante': ('banne',),
'banna': ('banne',),
'bannete': ('banne',),
'bannede': ('banne',),
'bante': ('banne',),
'bannende': ('banne',),
'bannlyst': ('bannlyse',),
'bannlyste': ('bannlyse',),
'bannlysende': ('bannlyse',),
'bannsatt': ('bannsette',),
'bannsatte': ('bannsette',),
'bannsettende': ('bannsette',),
'baptistisk': ('baptistisk',),
'baptistiske': ('baptistisk',),
'baptistisk': ('baptistisk',),
'bar': ('bar',),
'bare': ('bar',),
'bart': ('bar',),
'barere': ('bar',),
'barest': ('bar',),
'bareste': ('bar',),
'bararma': ('bararma',),
'bararmet': ('bararmet',),
'bararmete': ('bararmet',),
'bararmede': ('bararmet',),
'bararmete': ('bararmet',),
'bararmede': ('bararmet',),
'bararmet': ('bararmet',),
'barbadisk': ('barbadisk',),
'barbadiske': ('barbadisk',),
'barbadisk': ('barbadisk',),
'barbarisk': ('barbarisk',),
'barbariske': ('barbarisk',),
'barbarisk': ('barbarisk',),
'barbeint': ('barbeint',),
'barbeinte': ('barbeint',),
'barbeint': ('barbeint',),
'barbent': ('barbent',),
'barbente': ('barbent',),
'barbent': ('barbent',),
'barbert': ('barbere',),
'barberte': ('barbere',),
'barberende': ('barbere',),
'bardunert': ('bardunere',),
'bardunerte': ('bardunere',),
'bardunerende': ('bardunere',),
'bardus': ('bardus',),
'barduse': ('bardus',),
'bardust': ('bardus',),
'bara': ('bare',),
'baret': ('bare',),
'bara': ('bare',),
'baret': ('bare',),
'bara': ('bare',),
'barete': ('bare',),
'barede': ('bare',),
'bara': ('bare',),
'barete': ('bare',),
'barede': ('bare',),
'barende': ('bare',),
'barfota': ('barfota',),
'barfotet': ('barfotet',),
'barfotete': ('barfotet',),
'barfotede': ('barfotet',),
'barfotete': ('barfotet',),
'barfotede': ('barfotet',),
'barfotet': ('barfotet',),
'barfrossen': ('barfrossen',),
'barfrosne': ('barfrossen',),
'barfrosset': ('barfrossen',),
'barfrosset': ('barfrosset',),
'barfrosne': ('barfrosset',),
'barfrosset': ('barfrosset',),
'barføtt': ('barføtt',),
'barføtte': ('barføtt',),
'barføtt': ('barføtt',),
'barhoda': ('barhoda',),
'barhodet': ('barhodet',),
'barhodete': ('barhodet',),
'barhodede': ('barhodet',),
'barhodete': ('barhodet',),
'barhodede': ('barhodet',),
'barhodet': ('barhodet',),
'barka': ('barka',),
'barka': ('barke',),
'barket': ('barke',),
'barka': ('barke',),
'barket': ('barke',),
'barka': ('barke',),
'barkete': ('barke',),
'barkede': ('barke',),
'barka': ('barke',),
'barkete': ('barke',),
'barkede': ('barke',),
'barkende': ('barke',),
'barket': ('barket',),
'barkete': ('barket',),
'barkede': ('barket',),
'barkete': ('barket',),
'barkede': ('barket',),
'barket': ('barket',),
'barmhjertig': ('barmhjertig',),
'barmhjertige': ('barmhjertig',),
'barmhjertig': ('barmhjertig',),
'barnaktig': ('barnaktig',),
'barnaktige': ('barnaktig',),
'barnaktig': ('barnaktig',),
'barnefødt': ('barnefødt',),
'barnefødte': ('barnefødt',),
'barnefødt': ('barnefødt',),
'barnerik': ('barnerik',),
'barnerike': ('barnerik',),
'barnerikt': ('barnerik',),
'barnerikere': ('barnerik',),
'barnerikest': ('barnerik',),
'barnerikeste': ('barnerik',),
'barnesikker': ('barnesikker',),
'barnesikre': ('barnesikker',),
'barnesikkert': ('barnesikker',),
'barnevennlig': ('barnevennlig',),
'barnevennlige': ('barnevennlig',),
'barnevennlig': ('barnevennlig',),
'barnlaus': ('barnlaus',),
'barnlause': ('barnlaus',),
'barnlaust': ('barnlaus',),
'barnlig': ('barnlig',),
'barnlige': ('barnlig',),
'barnlig': ('barnlig',),
'barnligere': ('barnlig',),
'barnligst': ('barnlig',),
'barnligste': ('barnlig',),
'barnløs': ('barnløs',),
'barnløse': ('barnløs',),
'barnløst': ('barnløs',),
'barnslig': ('barnslig',),
'barnslige': ('barnslig',),
'barnslig': ('barnslig',),
'barnsligere': ('barnslig',),
'barnsligst': ('barnslig',),
'barnsligste': ('barnslig',),
'barokk': ('barokk',),
'barokke': ('barokk',),
'barokt': ('barokk',),
'barometrisk': ('barometrisk',),
'barometriske': ('barometrisk',),
'barometrisk': ('barometrisk',),
'barrikadert': ('barrikadere',),
'barrikaderte': ('barrikadere',),
'barrikaderende': ('barrikadere',),
'barsk': ('barsk',),
'barske': ('barsk',),
'barskt': ('barsk',),
'barskere': ('barsk',),
'barskest': ('barsk',),
'barskeste': ('barsk',),
'barska': ('barske',),
'barsket': ('barske',),
'barska': ('barske',),
'barsket': ('barske',),
'barska': ('barske',),
'barskete': ('barske',),
'barskede': ('barske',),
'barska': ('barske',),
'barskete': ('barske',),
'barskede': ('barske',),
'barskende': ('barske',),
'basal': ('basal',),
'basale': ('basal',),
'basalt': ('basal',),
'basaltisk': ('basaltisk',),
'basaltiske': ('basaltisk',),
'basaltisk': ('basaltisk',),
'bast': ('base',),
'baste': ('base',),
'basende': ('base',),
'basert': ('basere',),
'baserte': ('basere',),
'baserende': ('basere',),
'basisk': ('basisk',),
'basiske': ('basisk',),
'basisk': ('basisk',),
'baska': ('baske',),
'basket': ('baske',),
'baska': ('baske',),
'basket': ('baske',),
'baska': ('baske',),
'baskete': ('baske',),
'baskede': ('baske',),
'baska': ('baske',),
'baskete': ('baske',),
'baskede': ('baske',),
'baskende': ('baske',),
'baskisk': ('baskisk',),
'baskiske': ('baskisk',),
'baskisk': ('baskisk',),
'bastant': ('bastant',),
'bastante': ('bastant',),
'bastant': ('bastant',),
'basta': ('baste',),
'bastet': ('baste',),
'basta': ('baste',),
'bastet': ('baste',),
'basta': ('baste',),
'bastete': ('baste',),
'bastede': ('baste',),
'basta': ('baste',),
'bastete': ('baste',),
'bastede': ('baste',),
'bastende': ('baste',),
'basunert': ('basunere',),
'basunerte': ('basunere',),
'basunerende': ('basunere',),
'batteridrevet': ('batteridrevet',),
'batteridrevne': ('batteridrevet',),
'batteridrevet': ('batteridrevet',),
'bauta': ('baute',),
'bautet': ('baute',),
'bauta': ('baute',),
'bautet': ('baute',),
'bauta': ('baute',),
'bautete': ('baute',),
'bautede': ('baute',),
'bauta': ('baute',),
'bautete': ('baute',),
'bautede': ('baute',),
'bautende': ('baute',),
'bayersk': ('bayersk',),
'bayerske': ('bayersk',),
'bayersk': ('bayersk',),
'bedt': ('be',),
'bedte': ('be',),
'beende': ('be',),
'bearbeida': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bearbeidd': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bearbeidd': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidete': ('bearbeide',),
'bearbeidede': ('bearbeide',),
'bearbeidde': ('bearbeide',),
'bearbeida': ('bearbeide',),
'bearbeidete': ('bearbeide',),
'bearbeidede': ('bearbeide',),
'bearbeidde': ('bearbeide',),
'bearbeidende': ('bearbeide',),
'bebodd': ('bebo',),
'bebodde': ('bebo',),
'beboende': ('bebo',),
'beboelig': ('beboelig',),
'beboelige': ('beboelig',),
'beboelig': ('beboelig',),
'bebreida': ('bebreide',),
'bebreidet': ('bebreide',),
'bebreida': ('bebreide',),
'bebreidet': ('bebreide',),
'bebreida': ('bebreide',),
'bebreidete': ('bebreide',),
'bebreidede': ('bebreide',),
'bebreida': ('bebreide',),
'bebreidete': ('bebreide',),
'bebreidede': ('bebreide',),
'bebreidende': ('bebreide',),
'bebreidende': ('bebreidende',),
'bebrilla': ('bebrilla',),
'bebrillet': ('bebrillet',),
'bebrillete': ('bebrillet',),
'bebrillede': ('bebrillet',),
'bebrillete': ('bebrillet',),
'bebrillede': ('bebrillet',),
'bebrillet': ('bebrillet',),
'bebuda': ('bebude',),
'bebudet': ('bebude',),
'bebuda': ('bebude',),
'bebudet': ('bebude',),
'bebuda': ('bebude',),
'bebudete': ('bebude',),
'bebudede': ('bebude',),
'bebuda': ('bebude',),
'bebudete': ('bebude',),
'bebudede': ('bebude',),
'bebudende': ('bebude',),
'bebygget': ('bebygge',),
'bebygd': ('bebygge',),
'bebygget': ('bebygge',),
'bebygd': ('bebygge',),
'bebyggete': ('bebygge',),
'bebyggede': ('bebygge',),
'bebygde': ('bebygge',),
'bebyggete': ('bebygge',),
'bebyggede': ('bebygge',),
'bebygde': ('bebygge',),
'bebyggende': ('bebygge',),
'bebyggelig': ('bebyggelig',),
'bebyggelige': ('bebyggelig',),
'bebyggelig': ('bebyggelig',),
'bebyrda': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrdete': ('bebyrde',),
'bebyrdede': ('bebyrde',),
'bebyrda': ('bebyrde',),
'bebyrdete': ('bebyrde',),
'bebyrdede': ('bebyrde',),
'bebyrdende': ('bebyrde',),
'bedaga': ('bedaga',),
'bedaga': ('bedage',),
'bedaget': ('bedage',),
'bedaga': ('bedage',),
'bedaget': ('bedage',),
'bedaga': ('bedage',),
'bedagete': ('bedage',),
'bedagede': ('bedage',),
'bedaga': ('bedage',),
'bedagete': ('bedage',),
'bedagede': ('bedage',),
'bedagende': ('bedage',),
'bedagelig': ('bedagelig',),
'bedagelige': ('bedagelig',),
'bedagelig': ('bedagelig',),
'bedaget': ('bedaget',),
'bedagete': ('bedaget',),
'bedagede': ('bedaget',),
'bedagete': ('bedaget',),
'bedagede': ('bedaget',),
'bedaget': ('bedaget',),
'bedt': ('bede',),
'bedte': ('bede',),
'bedende': ('bede',),
'bedekka': ('bedekke',),
'bedekket': ('bedekke',),
'bedekt': ('bedekke',),
'bedekka': ('bedekke',),
'bedekket': ('bedekke',),
'bedekt': ('bedekke',),
'bedekka': ('bedekke',),
'bedekkete': ('bedekke',),
'bedekkede': ('bedekke',),
'bedekte': ('bedekke',),
'bedekka': ('bedekke',),
'bedekkete': ('bedekke',),
'bedekkede': ('bedekke',),
'bedekte': ('bedekke',),
'bedekkende': ('bedekke',),
'bederva': ('bederva',),
'bedervelig': ('bedervelig',),
'bedervelige': ('bedervelig',),
'bedervelig': ('bedervelig',),
'bedervet': ('bedervet',),
'bedervete': ('bedervet',),
'bedervede': ('bedervet',),
'bedervete': ('bedervet',),
'bedervede': ('bedervet',),
'bedervet': ('bedervet',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedradd': ('bedra',),
'bedratt': ('bedra',),
'bedradde': ('bedra',),
'bedratte': ('bedra',),
'bedradde': ('bedra',),
'bedratte': ('bedra',),
'bedradde': ('bedra',),
'bedratte': ('bedra',),
'bedradde': ('bedra',),
'bedratte': ('bedra',),
'bedragende': ('bedra',),
'bedragersk': ('bedragersk',),
'bedragerske': ('bedragersk',),
'bedragersk': ('bedragersk',),
'bedra': ('bedre',),
'bedret': ('bedre',),
'bedra': ('bedre',),
'bedret': ('bedre',),
'bedra': ('bedre',),
'bedrete': ('bedre',),
'bedrede': ('bedre',),
'bedrete': ('bedre',),
'bedrede': ('bedre',),
'bedra': ('bedre',),
'bedrete': ('bedre',),
'bedrede': ('bedre',),
'bedrete': ('bedre',),
'bedrede': ('bedre',),
'bedrende': ('bedre',),
'bedre': ('bedre',),
'bedrestilt': ('bedrestilt',),
'bedrestilte': ('bedrestilt',),
'bedrestilt': ('bedrestilt',),
'bedrevitende': ('bedrevitende',),
'bedrevet': ('bedrive',),
'bedreven': ('bedrive',),
'bedrevne': ('bedrive',),
'bedrivende': ('bedrive',),
'bedrøva': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøvete': ('bedrøve',),
'bedrøvede': ('bedrøve',),
'bedrøva': ('bedrøve',),
'bedrøvete': ('bedrøve',),
'bedrøvede': ('bedrøve',),
'bedrøvende': ('bedrøve',),
'bedrøvelig': ('bedrøvelig',),
'bedrøvelige': ('bedrøvelig',),
'bedrøvelig': ('bedrøvelig',),
'bedugga': ('bedugga',),
'bedugget': ('bedugget',),
'beduggete': ('bedugget',),
'beduggede': ('bedugget',),
'beduggete': ('bedugget',),
'beduggede': ('bedugget',),
'bedugget': ('bedugget',),
'bedyra': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrt': ('bedyre',),
'bedyra': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrt': ('bedyre',),
'bedyra': ('bedyre',),
'bedyrete': ('bedyre',),
'bedyrede': ('bedyre',),
'bedyrte': ('bedyre',),
'bedyra': ('bedyre',),
'bedyrete': ('bedyre',),
'bedyrede': ('bedyre',),
'bedyrte': ('bedyre',),
'bedyrende': ('bedyre',),
'bedåra': ('bedåre',),
'bedåret': ('bedåre',),
'bedåra': ('bedåre',),
'bedåret': ('bedåre',),
'bedåra': ('bedåre',),
'bedårete': ('bedåre',),
'bedårede': ('bedåre',),
'bedåra': ('bedåre',),
'bedårete': ('bedåre',),
'bedårede': ('bedåre',),
'bedårende': ('bedåre',),
'bedårende': ('bedårende',),
'bedømt': ('bedømme',),
'bedømte': ('bedømme',),
'bedømmende': ('bedømme',),
'bedøva': ('bedøve',),
'bedøvet': ('bedøve',),
'bedøvd': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvet': ('bedøve',),
'bedøvd': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvete': ('bedøve',),
'bedøvede': ('bedøve',),
'bedøvde': ('bedøve',),
'bedøva': ('bedøve',),
'bedøvete': ('bedøve',),
'bedøvede': ('bedøve',),
'bedøvde': ('bedøve',),
'bedøvende': ('bedøve',),
'beediga': ('beedige',),
'beediget': ('beedige',),
'beediga': ('beedige',),
'beediget': ('beedige',),
'beediga': ('beedige',),
'beedigete': ('beedige',),
'beedigede': ('beedige',),
'beediga': ('beedige',),
'beedigete': ('beedige',),
'beedigede': ('beedige',),
'beedigende': ('beedige',),
'befalt': ('befale',),
'befalte': ('befale',),
'befalende': ('befale',),
'befart': ('befare',),
'befarte': ('befare',),
'befarende': ('befare',),
'befaren': ('befaren',),
'befarne': ('befaren',),
'befarent': ('befaren',),
'befatta': ('befatte',),
'befattet': ('befatte',),
'befatta': ('befatte',),
'befattet': ('befatte',),
'befatta': ('befatte',),
'befattete': ('befatte',),
'befattede': ('befatte',),
'befatta': ('befatte',),
'befattete': ('befatte',),
'befattede': ('befatte',),
'befattende': ('befatte',),
'befengt': ('befengt',),
'befengte': ('befengt',),
'befengt': ('befengt',),
'beferda': ('beferda',),
'beferdet': ('beferdet',),
'beferdete': ('beferdet',),
'beferdede': ('beferdet',),
'beferdete': ('beferdet',),
'beferdede': ('beferdet',),
'beferdet': ('beferdet',),
'befesta': ('befeste',),
'befestet': ('befeste',),
'befesta': ('befeste',),
'befestet': ('befeste',),
'befesta': ('befeste',),
'befestete': ('befeste',),
'befestede': ('befeste',),
'befesta': ('befeste',),
'befestete': ('befeste',),
'befestede': ('befeste',),
'befestende': ('befeste',),
'befunnet': ('befinne',),
'befunnen': ('befinne',),
'befunne': ('befinne',),
'befinnende': ('befinne',),
'befippa': ('befippa',),
'befippet': ('befippet',),
'befippete': ('befippet',),
'befippede': ('befippet',),
'befippete': ('befippet',),
'befippede': ('befippet',),
'befippet': ('befippet',),
'beflitta': ('beflitte',),
'beflittet': ('beflitte',),
'beflitta': ('beflitte',),
'beflittet': ('beflitte',),
'beflitta': ('beflitte',),
'beflittete': ('beflitte',),
'beflittede': ('beflitte',),
'beflitta': ('beflitte',),
'beflittete': ('beflitte',),
'beflittede': ('beflitte',),
'beflittende': ('beflitte',),
'befolka': ('befolke',),
'befolket': ('befolke',),
'befolka': ('befolke',),
'befolket': ('befolke',),
'befolka': ('befolke',),
'befolkete': ('befolke',),
'befolkede': ('befolke',),
'befolka': ('befolke',),
'befolkete': ('befolke',),
'befolkede': ('befolke',),
'befolkende': ('befolke',),
'befordra': ('befordre',),
'befordret': ('befordre',),
'befordra': ('befordre',),
'befordret': ('befordre',),
'befordra': ('befordre',),
'befordrete': ('befordre',),
'befordrede': ('befordre',),
'befordrete': ('befordre',),
'befordrede': ('befordre',),
'befordra': ('befordre',),
'befordrete': ('befordre',),
'befordrede': ('befordre',),
'befordrete': ('befordre',),
'befordrede': ('befordre',),
'befordrende': ('befordre',),
'befrakta': ('befrakte',),
'befraktet': ('befrakte',),
'befrakta': ('befrakte',),
'befraktet': ('befrakte',),
'befrakta': ('befrakte',),
'befraktete': ('befrakte',),
'befraktede': ('befrakte',),
'befrakta': ('befrakte',),
'befraktete': ('befrakte',),
'befraktede': ('befrakte',),
'befraktende': ('befrakte',),
'befridd': ('befri',),
'befridde': ('befri',),
'befriende': ('befri',),
'befriende': ('befriende',),
'befrukta': ('befrukte',),
'befruktet': ('befrukte',),
'befrukta': ('befrukte',),
'befruktet': ('befrukte',),
'befrukta': ('befrukte',),
'befruktete': ('befrukte',),
'befruktede': ('befrukte',),
'befrukta': ('befrukte',),
'befruktete': ('befrukte',),
'befruktede': ('befrukte',),
'befruktende': ('befrukte',),
'befruktningsdyktig': ('befruktningsdyktig',),
'befruktningsdyktige': ('befruktningsdyktig',),
'befruktningsdyktig': ('befruktningsdyktig',),
'befruktningshindrende': ('befruktningshindrende',),
'befølt': ('beføle',),
'befølte': ('beføle',),
'befølende': ('beføle',),
'beføya': ('beføya',),
'beføyet': ('beføyet',),
'beføyete': ('beføyet',),
'beføyede': ('beføyet',),
'beføyete': ('beføyet',),
'beføyede': ('beføyet',),
'beføyet': ('beføyet',),
'begava': ('begava',),
'begavet': ('begavet',),
'begavete': ('begavet',),
'begavede': ('begavet',),
'begavete': ('begavet',),
'begavede': ('begavet',),
'begavet': ('begavet',),
'begeistra': ('begeistre',),
'begeistret': ('begeistre',),
'begeistra': ('begeistre',),
'begeistret': ('begeistre',),
'begeistra': ('begeistre',),
'begeistrete': ('begeistre',),
'begeistrede': ('begeistre',),
'begeistrete': ('begeistre',),
'begeistrede': ('begeistre',),
'begeistra': ('begeistre',),
'begeistrete': ('begeistre',),
'begeistrede': ('begeistre',),
'begeistrete': ('begeistre',),
'begeistrede': ('begeistre',),
'begeistrende': ('begeistre',),
'begitt': ('begi',),
'begitte': ('begi',),
'begiende': ('begi',),
'begivenhetslaus': ('begivenhetslaus',),
'begivenhetslause': ('begivenhetslaus',),
'begivenhetslaust': ('begivenhetslaus',),
'begivenhetsløs': ('begivenhetsløs',),
'begivenhetsløse': ('begivenhetsløs',),
'begivenhetsløst': ('begivenhetsløs',),
'begivenhetsrik': ('begivenhetsrik',),
'begivenhetsrike': ('begivenhetsrik',),
'begivenhetsrikt': ('begivenhetsrik',),
'begjært': ('begjære',),
'begjærte': ('begjære',),
'begjærende': ('begjære',),
'begjærlig': ('begjærlig',),
'begjærlige': ('begjærlig',),
'begjærlig': ('begjærlig',),
'beglodd': ('beglo',),
'beglodde': ('beglo',),
'begloende': ('beglo',),
'begravet': ('begrave',),
'begravd': ('begrave',),
'begravet': ('begrave',),
'begravd': ('begrave',),
'begravete': ('begrave',),
'begravede': ('begrave',),
'begravde': ('begrave',),
'begravete': ('begrave',),
'begravede': ('begrave',),
'begravde': ('begrave',),
'begravende': ('begrave',),
'begredelig': ('begredelig',),
'begredelige': ('begredelig',),
'begredelig': ('begredelig',),
'begrensa': ('begrensa',),
'begrensa': ('begrense',),
'begrenset': ('begrense',),
'begrensa': ('begrense',),
'begrenset': ('begrense',),
'begrensa': ('begrense',),
'begrensete': ('begrense',),
'begrensede': ('begrense',),
'begrensa': ('begrense',),
'begrensete': ('begrense',),
'begrensede': ('begrense',),
'begrensende': ('begrense',),
'begrenset': ('begrenset',),
'begrensete': ('begrenset',),
'begrensede': ('begrenset',),
'begrensete': ('begrenset',),
'begrensede': ('begrenset',),
'begrenset': ('begrenset',),
'begrepsbestemt': ('begrepsbestemme',),
'begrepsbestemte': ('begrepsbestemme',),
'begrepsbestemmende': ('begrepsbestemme',),
'begrepsmessig': ('begrepsmessig',),
'begrepsmessige': ('begrepsmessig',),
'begrepsmessig': ('begrepsmessig',),
'begrepet': ('begripe',),
'begrepen': ('begripe',),
'begrepne': ('begripe',),
'begripende': ('begripe',),
'begripelig': ('begripelig',),
'begripelige': ('begripelig',),
'begripelig': ('begripelig',),
'begrodd': ('begrodd',),
'begrodde': ('begrodd',),
'begrodd': ('begrodd',),
'begrunna': ('begrunne',),
'begrunnet': ('begrunne',),
'begrunna': ('begrunne',),
'begrunnet': ('begrunne',),
'begrunna': ('begrunne',),
'begrunnete': ('begrunne',),
'begrunnede': ('begrunne',),
'begrunna': ('begrunne',),
'begrunnete': ('begrunne',),
'begrunnede': ('begrunne',),
'begrunnende': ('begrunne',),
'begunstiga': ('begunstige',),
'begunstiget': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstiget': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstigete': ('begunstige',),
'begunstigede': ('begunstige',),
'begunstiga': ('begunstige',),
'begunstigete': ('begunstige',),
'begunstigede': ('begunstige',),
'begunstigende': ('begunstige',),
'begynt': ('begynne',),
'begynte': ('begynne',),
'begynnende': ('begynne',),
'begått': ('begå',),
'begåtte': ('begå',),
'begående': ('begå',),
'behaga': ('behage',),
'behaget': ('behage',),
'behaga': ('behage',),
'behaget': ('behage',),
'behaga': ('behage',),
'behagete': ('behage',),
'behagede': ('behage',),
'behaga': ('behage',),
'behagete': ('behage',),
'behagede': ('behage',),
'behagende': ('behage',),
'behagelig': ('behagelig',),
'behagelige': ('behagelig',),
'behagelig': ('behagelig',),
'behageligere': ('behagelig',),
'behageligst': ('behagelig',),
'behageligste': ('behagelig',),
'behandla': ('behandle',),
'behandlet': ('behandle',),
'behandla': ('behandle',),
'behandlet': ('behandle',),
'behandla': ('behandle',),
'behandlete': ('behandle',),
'behandlede': ('behandle',),
'behandlete': ('behandle',),
'behandlede': ('behandle',),
'behandla': ('behandle',),
'behandlete': ('behandle',),
'behandlede': ('behandle',),
'behandlete': ('behandle',),
'behandlede': ('behandle',),
'behandlende': ('behandle',),
'behanska': ('behanska',),
'behansket': ('behansket',),
'behanskete': ('behansket',),
'behanskede': ('behansket',),
'behanskete': ('behansket',),
'behanskede': ('behansket',),
'behansket': ('behansket',),
'behefta': ('behefte',),
'beheftet': ('behefte',),
'behefta': ('behefte',),
'beheftet': ('behefte',),
'behefta': ('behefte',),
'beheftete': ('behefte',),
'beheftede': ('behefte',),
'behefta': ('behefte',),
'beheftete': ('behefte',),
'beheftede': ('behefte',),
'beheftende': ('behefte',),
'behendig': ('behendig',),
'behendige': ('behendig',),
'behendig': ('behendig',),
'behengt': ('behengt',),
'behengte': ('behengt',),
'behengt': ('behengt',),
'beherska': ('beherska',),
'beherska': ('beherske',),
'behersket': ('beherske',),
'beherska': ('beherske',),
'behersket': ('beherske',),
'beherska': ('beherske',),
'beherskete': ('beherske',),
'beherskede': ('beherske',),
'beherska': ('beherske',),
'beherskete': ('beherske',),
'beherskede': ('beherske',),
'beherskende': ('beherske',),
'behersket': ('behersket',),
'beherskete': ('behersket',),
'beherskede': ('behersket',),
'beherskete': ('behersket',),
'beherskede': ('behersket',),
'behersket': ('behersket',),
'behjelpelig': ('behjelpelig',),
'behjelpelige': ('behjelpelig',),
'behjelpelig': ('behjelpelig',),
'behjerta': ('behjerta',),
'behjertet': ('behjertet',),
'behjertete': ('behjertet',),
'behjertede': ('behjertet',),
'behjertete': ('behjertet',),
'behjertede': ('behjertet',),
'behjertet': ('behjertet',),
'beholdt': ('beholde',),
'beholdte': ('beholde',),
'beholdende': ('beholde',),
'behåra': ('behåra',),
'behåret': ('behåret',),
'behårete': ('behåret',),
'behårede': ('behåret',),
'behårete': ('behåret',),
'behårede': ('behåret',),
'behåret': ('behåret',),
'behørig': ('behørig',),
'behørige': ('behørig',),
'behørig': ('behørig',),
'behøvd': ('behøve',),
'behøvde': ('behøve',),
'behøvende': ('behøve',),
'beige': ('beige',),
'beila': ('beile',),
'beilet': ('beile',),
'beilt': ('beile',),
'beila': ('beile',),
'beilet': ('beile',),
'beilt': ('beile',),
'beila': ('beile',),
'beilete': ('beile',),
'beilede': ('beile',),
'beilte': ('beile',),
'beila': ('beile',),
'beilete': ('beile',),
'beilede': ('beile',),
'beilte': ('beile',),
'beilende': ('beile',),
'bein': ('bein',),
'beine': ('bein',),
'beint': ('bein',),
'beinere': ('bein',),
'beinest': ('bein',),
'beineste': ('bein',),
'beina': ('beine',),
'beinet': ('beine',),
'beina': ('beine',),
'beinet': ('beine',),
'beina': ('beine',),
'beinete': ('beine',),
'beinede': ('beine',),
'beina': ('beine',),
'beinete': ('beine',),
'beinede': ('beine',),
'beinende': ('beine',),
'beinet': ('beinet',),
'beinete': ('beinet',),
'beinet': ('beinet',),
'beinete': ('beinete',),
'beinfløyet': ('beinflyge',),
'beinfløyen': ('beinflyge',),
'beinfløyne': ('beinflyge',),
'beinflygende': ('beinflyge',),
'beinhard': ('beinhard',),
'beinharde': ('beinhard',),
'beinhardt': ('beinhard',),
'beinka': ('beinke',),
'beinket': ('beinke',),
'beinka': ('beinke',),
'beinket': ('beinke',),
'beinka': ('beinke',),
'beinkete': ('beinke',),
'beinkede': ('beinke',),
'beinka': ('beinke',),
'beinkete': ('beinke',),
'beinkede': ('beinke',),
'beinkende': ('beinke',),
'beinløs': ('beinløs',),
'beinløse': ('beinløs',),
'beinløst': ('beinløs',),
'beintfram': ('beintfram',),
'beintframme': ('beintfram',),
'beintframt': ('beintfram',),
'beintfram': ('beintfram',),
'beisa': ('beise',),
'beiset': ('beise',),
'beist': ('beise',),
'beisa': ('beise',),
'beiset': ('beise',),
'beist': ('beise',),
'beisa': ('beise',),
'beisete': ('beise',),
'beisede': ('beise',),
'beiste': ('beise',),
'beisa': ('beise',),
'beisete': ('beise',),
'beisede': ('beise',),
'beiste': ('beise',),
'beisende': ('beise',),
'beisk': ('beisk',),
'beiske': ('beisk',),
'beiskt': ('beisk',),
'beiskere': ('beisk',),
'beiskest': ('beisk',),
'beiskeste': ('beisk',),
'beiskna': ('beiskne',),
'beisknet': ('beiskne',),
'beiskna': ('beiskne',),
'beisknet': ('beiskne',),
'beiskna': ('beiskne',),
'beisknete': ('beiskne',),
'beisknede': ('beiskne',),
'beisknete': ('beiskne',),
'beisknede': ('beiskne',),
'beiskna': ('beiskne',),
'beisknete': ('beiskne',),
'beisknede': ('beiskne',),
'beisknete': ('beiskne',),
'beisknede': ('beiskne',),
'beisknende': ('beiskne',),
'beita': ('beite',),
'beitet': ('beite',),
'beita': ('beite',),
'beitet': ('beite',),
'beita': ('beite',),
'beitete': ('beite',),
'beitede': ('beite',),
'beita': ('beite',),
'beitete': ('beite',),
'beitede': ('beite',),
'beitende': ('beite',),
'bejaa': ('bejae',),
'bejaet': ('bejae',),
'bejaa': ('bejae',),
'bejaet': ('bejae',),
'bejaa': ('bejae',),
'bejaete': ('bejae',),
'bejaede': ('bejae',),
'bejaa': ('bejae',),
'bejaete': ('bejae',),
'bejaede': ('bejae',),
'bejaende': ('bejae',),
'beka': ('beke',),
'beket': ('beke',),
'bekt': ('beke',),
'beka': ('beke',),
'beket': ('beke',),
'bekt': ('beke',),
'beka': ('beke',),
'bekete': ('beke',),
'bekede': ('beke',),
'bekte': ('beke',),
'beka': ('beke',),
'bekete': ('beke',),
'bekede': ('beke',),
'bekte': ('beke',),
'bekende': ('beke',),
'bekjempa': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempete': ('bekjempe',),
'bekjempede': ('bekjempe',),
'bekjempa': ('bekjempe',),
'bekjempete': ('bekjempe',),
'bekjempede': ('bekjempe',),
'bekjempende': ('bekjempe',),
'bekjent': ('bekjenne',),
'bekjente': ('bekjenne',),
'bekjennende': ('bekjenne',),
'bekjennelseslaus': ('bekjennelseslaus',),
'bekjennelseslause': ('bekjennelseslaus',),
'bekjennelseslaust': ('bekjennelseslaus',),
'bekjennelsesløs': ('bekjennelsesløs',),
'bekjennelsesløse': ('bekjennelsesløs',),
'bekjennelsesløst': ('bekjennelsesløs',),
'bekjent': ('bekjent',),
'bekjente': ('bekjent',),
'bekjent': ('bekjent',),
'bekjentgjort': ('bekjentgjøre',),
'bekjentgjorte': ('bekjentgjøre',),
'bekjentgjørende': ('bekjentgjøre',),
'beklaga': ('beklage',),
'beklaget': ('beklage',),
'beklagd': ('beklage',),
'beklaga': ('beklage',),
'beklaget': ('beklage',),
'beklagd': ('beklage',),
'beklaga': ('beklage',),
'beklagete': ('beklage',),
'beklagede': ('beklage',),
'beklagde': ('beklage',),
'beklaga': ('beklage',),
'beklagete': ('beklage',),
'beklagede': ('beklage',),
'beklagde': ('beklage',),
'beklagende': ('beklage',),
'beklagelig': ('beklagelig',),
'beklagelige': ('beklagelig',),
'beklagelig': ('beklagelig',),
'bekledd': ('bekle',),
'bekledde': ('bekle',),
'bekleende': ('bekle',),
'beklemmende': ('beklemmende',),
'beklemt': ('beklemt',),
'beklemte': ('beklemt',),
'beklemt': ('beklemt',),
'beklippa': ('beklippe',),
'beklippet': ('beklippe',),
'beklipt': ('beklippe',),
'beklippa': ('beklippe',),
'beklippet': ('beklippe',),
'beklipt': ('beklippe',),
'beklippa': ('beklippe',),
'beklippete': ('beklippe',),
'beklippede': ('beklippe',),
'beklipte': ('beklippe',),
'beklippa': ('beklippe',),
'beklippete': ('beklippe',),
'beklippede': ('beklippe',),
'beklipte': ('beklippe',),
'beklippende': ('beklippe',),
'bekmørk': ('bekmørk',),
'bekmørke': ('bekmørk',),
'bekmørkt': ('bekmørk',),
'bekommet': ('bekomme',),
'bekommen': ('bekomme',),
'bekomne': ('bekomme',),
'bekommende': ('bekomme',),
'bekosta': ('bekoste',),
'bekostet': ('bekoste',),
'bekosta': ('bekoste',),
'bekostet': ('bekoste',),
'bekosta': ('bekoste',),
'bekostete': ('bekoste',),
'bekostede': ('bekoste',),
'bekosta': ('bekoste',),
'bekostete': ('bekoste',),
'bekostede': ('bekoste',),
'bekostende': ('bekoste',),
'bekransa': ('bekranse',),
'bekranset': ('bekranse',),
'bekransa': ('bekranse',),
'bekranset': ('bekranse',),
'bekransa': ('bekranse',),
'bekransete': ('bekranse',),
'bekransede': ('bekranse',),
'bekransa': ('bekranse',),
'bekransete': ('bekranse',),
'bekransede': ('bekranse',),
'bekransende': ('bekranse',),
'bekrefta': ('bekrefte',),
'bekreftet': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekreftet': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekreftete': ('bekrefte',),
'bekreftede': ('bekrefte',),
'bekrefta': ('bekrefte',),
'bekreftete': ('bekrefte',),
'bekreftede': ('bekrefte',),
'bekreftende': ('bekrefte',),
'bekreftende': ('bekreftende',),
'beksvart': ('beksvart',),
'beksvarte': ('beksvart',),
'beksvart': ('beksvart',),
'bekvem': ('bekvem',),
'bekvemme': ('bekvem',),
'bekvemt': ('bekvem',),
'bekvemmere': ('bekvem',),
'bekvemmest': ('bekvem',),
'bekvemmeste': ('bekvem',),
'bekvemma': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemmete': ('bekvemme',),
'bekvemmede': ('bekvemme',),
'bekvemma': ('bekvemme',),
'bekvemmete': ('bekvemme',),
'bekvemmede': ('bekvemme',),
'bekvemmende': ('bekvemme',),
'bekvemmelig': ('bekvemmelig',),
'bekvemmelige': ('bekvemmelig',),
'bekvemmelig': ('bekvemmelig',),
'bekymra': ('bekymre',),
'bekymret': ('bekymre',),
'bekymra': ('bekymre',),
'bekymret': ('bekymre',),
'bekymra': ('bekymre',),
'bekymrete': ('bekymre',),
'bekymrede': ('bekymre',),
'bekymrete': ('bekymre',),
'bekymrede': ('bekymre',),
'bekymra': ('bekymre',),
'bekymrete': ('bekymre',),
'bekymrede': ('bekymre',),
'bekymrete': ('bekymre',),
'bekymrede': ('bekymre',),
'bekymrende': ('bekymre',),
'bekymringsfull': ('bekymringsfull',),
'bekymringsfulle': ('bekymringsfull',),
'bekymringsfullt': ('bekymringsfull',),
'bekymringslaus': ('bekymringslaus',),
'bekymringslause': ('bekymringslaus',),
'bekymringslaust': ('bekymringslaus',),
'bekymringsløs': ('bekymringsløs',),
'bekymringsløse': ('bekymringsløs',),
'bekymringsløst': ('bekymringsløs',),
'belaga': ('belage',),
'belaget': ('belage',),
'belagd': ('belage',),
'belaga': ('belage',),
'belaget': ('belage',),
'belagd': ('belage',),
'belaga': ('belage',),
'belagete': ('belage',),
'belagede': ('belage',),
'belagde': ('belage',),
'belaga': ('belage',),
'belagete': ('belage',),
'belagede': ('belage',),
'belagde': ('belage',),
'belagende': ('belage',),
'belasta': ('belaste',),
'belastet': ('belaste',),
'belasta': ('belaste',),
'belastet': ('belaste',),
'belasta': ('belaste',),
'belastete': ('belaste',),
'belastede': ('belaste',),
'belasta': ('belaste',),
'belastete': ('belaste',),
'belastede': ('belaste',),
'belastende': ('belaste',),
'belagt': ('belegge',),
'belagte': ('belegge',),
'beleggende': ('belegge',),
'beleilig': ('beleilig',),
'beleilige': ('beleilig',),
'beleilig': ('beleilig',),
'beleira': ('beleire',),
'beleiret': ('beleire',),
'beleira': ('beleire',),
'beleiret': ('beleire',),
'beleira': ('beleire',),
'beleirete': ('beleire',),
'beleirede': ('beleire',),
'beleira': ('beleire',),
'beleirete': ('beleire',),
'beleirede': ('beleire',),
'beleirende': ('beleire',),
'belemra': ('belemre',),
'belemret': ('belemre',),
'belemra': ('belemre',),
'belemret': ('belemre',),
'belemra': ('belemre',),
'belemrete': ('belemre',),
'belemrede': ('belemre',),
'belemrete': ('belemre',),
'belemrede': ('belemre',),
'belemra': ('belemre',),
'belemrete': ('belemre',),
'belemrede': ('belemre',),
'belemrete': ('belemre',),
'belemrede': ('belemre',),
'belemrende': ('belemre',),
'belessa': ('belesse',),
'belesset': ('belesse',),
'belest': ('belesse',),
'belessa': ('belesse',),
'belesset': ('belesse',),
'belest': ('belesse',),
'belessa': ('belesse',),
'belessete': ('belesse',),
'belessede': ('belesse',),
'beleste': ('belesse',),
'belessa': ('belesse',),
'belessete': ('belesse',),
'belessede': ('belesse',),
'beleste': ('belesse',),
'belessende': ('belesse',),
'belest': ('belest',),
'beleste': ('belest',),
'belest': ('belest',),
'beleven': ('beleven',),
'belevne': ('beleven',),
'belevent': ('beleven',),
'belgisk': ('belgisk',),
'belgiske': ('belgisk',),
'belgisk': ('belgisk',),
'belgmørk': ('belgmørk',),
'belgmørke': ('belgmørk',),
'belgmørkt': ('belgmørk',),
'beliggende': ('beliggende',),
'beliva': ('beliva',),
'belivet': ('belivet',),
'belivete': ('belivet',),
'belivede': ('belivet',),
'belivete': ('belivet',),
'belivede': ('belivet',),
'belivet': ('belivet',),
'belizisk': ('belizisk',),
'beliziske': ('belizisk',),
'belizisk': ('belizisk',),
'belja': ('belje',),
'beljet': ('belje',),
'belja': ('belje',),
'beljet': ('belje',),
'belja': ('belje',),
'beljete': ('belje',),
'beljede': ('belje',),
'belja': ('belje',),
'beljete': ('belje',),
'beljede': ('belje',),
'beljende': ('belje',),
'belma': ('belme',),
'belmet': ('belme',),
'belma': ('belme',),
'belmet': ('belme',),
'belma': ('belme',),
'belmete': ('belme',),
'belmede': ('belme',),
'belma': ('belme',),
'belmete': ('belme',),
'belmede': ('belme',),
'belmende': ('belme',),
'beltegående': ('beltegående',),
'belyst': ('belyse',),
'belyste': ('belyse',),
'belysende': ('belyse',),
'belånt': ('belåne',),
'belånte': ('belåne',),
'belånende': ('belåne',),
'belært': ('belære',),
'belærte': ('belære',),
'belærende': ('belære',),
'belærende': ('belærende',),
'belønna': ('belønne',),
'belønnet': ('belønne',),
'belønt': ('belønne',),
'belønna': ('belønne',),
'belønnet': ('belønne',),
'belønt': ('belønne',),
'belønna': ('belønne',),
'belønnete': ('belønne',),
'belønnede': ('belønne',),
'belønte': ('belønne',),
'belønna': ('belønne',),
'belønnete': ('belønne',),
'belønnede': ('belønne',),
'belønte': ('belønne',),
'belønnende': ('belønne',),
'beløpt': ('beløpe',),
'beløpet': ('beløpe',),
'beløpt': ('beløpe',),
'beløpet': ('beløpe',),
'beløpte': ('beløpe',),
'beløpende': ('beløpe',),
'bemanna': ('bemanne',),
'bemannet': ('bemanne',),
'bemanna': ('bemanne',),
'bemannet': ('bemanne',),
'bemanna': ('bemanne',),
'bemannete': ('bemanne',),
'bemannede': ('bemanne',),
'bemanna': ('bemanne',),
'bemannete': ('bemanne',),
'bemannede': ('bemanne',),
'bemannende': ('bemanne',),
'bemektiga': ('bemektige',),
'bemektiget': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektiget': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektigete': ('bemektige',),
'bemektigede': ('bemektige',),
'bemektiga': ('bemektige',),
'bemektigete': ('bemektige',),
'bemektigede': ('bemektige',),
'bemektigende': ('bemektige',),
'bemerka': ('bemerke',),
'bemerket': ('bemerke',),
'bemerka': ('bemerke',),
'bemerket': ('bemerke',),
'bemerka': ('bemerke',),
'bemerkete': ('bemerke',),
'bemerkede': ('bemerke',),
'bemerka': ('bemerke',),
'bemerkete': ('bemerke',),
'bemerkede': ('bemerke',),
'bemerkende': ('bemerke',),
'bemerkelsesverdig': ('bemerkelsesverdig',),
'bemerkelsesverdige': ('bemerkelsesverdig',),
'bemerkelsesverdig': ('bemerkelsesverdig',),
'bemidla': ('bemidla',),
'bemidlet': ('bemidlet',),
'bemidlete': ('bemidlet',),
'bemidlede': ('bemidlet',),
'bemidlete': ('bemidlet',),
'bemidlede': ('bemidlet',),
'bemidlet': ('bemidlet',),
'bemyndiga': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndigete': ('bemyndige',),
'bemyndigede': ('bemyndige',),
'bemyndiga': ('bemyndige',),
'bemyndigete': ('bemyndige',),
'bemyndigede': ('bemyndige',),
'bemyndigende': ('bemyndige',),
'bemøya': ('bemøye',),
'bemøyet': ('bemøye',),
'bemøyd': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyet': ('bemøye',),
'bemøyd': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyete': ('bemøye',),
'bemøyede': ('bemøye',),
'bemøyde': ('bemøye',),
'bemøya': ('bemøye',),
'bemøyete': ('bemøye',),
'bemøyede': ('bemøye',),
'bemøyde': ('bemøye',),
'bemøyende': ('bemøye',),
'ben': ('ben',),
'bene': ('ben',),
'bent': ('ben',),
'benere': ('ben',),
'benest': ('ben',),
'beneste': ('ben',),
'bendt': ('bende',),
'bendte': ('bende',),
'bendende': ('bende',),
'bena': ('bene',),
'benet': ('bene',),
'bena': ('bene',),
'benet': ('bene',),
'bena': ('bene',),
'benete': ('bene',),
'benede': ('bene',),
'bena': ('bene',),
'benete': ('bene',),
'benede': ('bene',),
'benende': ('bene',),
'benefisert': ('benefisert',),
'benefiserte': ('benefisert',),
'benefisert': ('benefisert',),
'benekta': ('benekte',),
'benektet': ('benekte',),
'benekta': ('benekte',),
'benektet': ('benekte',),
'benekta': ('benekte',),
'benektete': ('benekte',),
'benektede': ('benekte',),
'benekta': ('benekte',),
'benektete': ('benekte',),
'benektede': ('benekte',),
'benektende': ('benekte',),
'benektende': ('benektende',),
'benet': ('benet',),
'benete': ('benet',),
'benet': ('benet',),
'benete': ('benete',),
'benevnt': ('benevne',),
'benevnte': ('benevne',),
'benevnende': ('benevne',),
'benevnt': ('benevnt',),
'benevnte': ('benevnt',),
'benevnt': ('benevnt',),
'bengalsk': ('bengalsk',),
'bengalske': ('bengalsk',),
'bengalsk': ('bengalsk',),
'beninsk': ('beninsk',),
'beninske': ('beninsk',),
'beninsk': ('beninsk',),
'benka': ('benke',),
'benket': ('benke',),
'benka': ('benke',),
'benket': ('benke',),
'benka': ('benke',),
'benkete': ('benke',),
'benkede': ('benke',),
'benka': ('benke',),
'benkete': ('benke',),
'benkede': ('benke',),
'benkende': ('benke',),
'benløs': ('benløs',),
'benløse': ('benløs',),
'benløst': ('benløs',),
'bensindrevet': ('bensindrevet',),
'bensindrevne': ('bensindrevet',),
'bensindrevet': ('bensindrevet',),
'bentfram': ('bentfram',),
'bentframme': ('bentfram',),
'bentframt': ('bentfram',),
'bentfram': ('bentfram',),
'bentfrem': ('bentfrem',),
'bentfremme': ('bentfrem',),
'bentfremt': ('bentfrem',),
'bentfrem': ('bentfrem',),
'benytta': ('benytte',),
'benyttet': ('benytte',),
'benytta': ('benytte',),
'benyttet': ('benytte',),
'benytta': ('benytte',),
'benyttete': ('benytte',),
'benyttede': ('benytte',),
'benytta': ('benytte',),
'benyttete': ('benytte',),
'benyttede': ('benytte',),
'benyttende': ('benytte',),
'benåda': ('benåde',),
'benådet': ('benåde',),
'benåda': ('benåde',),
'benådet': ('benåde',),
'benåda': ('benåde',),
'benådete': ('benåde',),
'benådede': ('benåde',),
'benåda': ('benåde',),
'benådete': ('benåde',),
'benådede': ('benåde',),
'benådende': ('benåde',),
'beordra': ('beordre',),
'beordret': ('beordre',),
'beordra': ('beordre',),
'beordret': ('beordre',),
'beordra': ('beordre',),
'beordrete': ('beordre',),
'beordrede': ('beordre',),
'beordrete': ('beordre',),
'beordrede': ('beordre',),
'beordra': ('beordre',),
'beordrete': ('beordre',),
'beordrede': ('beordre',),
'beordrete': ('beordre',),
'beordrede': ('beordre',),
'beordrende': ('beordre',),
'beplanta': ('beplante',),
'beplantet': ('beplante',),
'beplanta': ('beplante',),
'beplantet': ('beplante',),
'beplanta': ('beplante',),
'beplantete': ('beplante',),
'beplantede': ('beplante',),
'beplanta': ('beplante',),
'beplantete': ('beplante',),
'beplantede': ('beplante',),
'beplantende': ('beplante',),
'beramma': ('beramme',),
'berammet': ('beramme',),
'beramma': ('beramme',),
'berammet': ('beramme',),
'beramma': ('beramme',),
'berammete': ('beramme',),
'berammede': ('beramme',),
'beramma': ('beramme',),
'berammete': ('beramme',),
'berammede': ('beramme',),
'berammende': ('beramme',),
'berbisk': ('berbisk',),
'berbiske': ('berbisk',),
'berbisk': ('berbisk',),
'beredt': ('berede',),
'beredte': ('berede',),
'beredende': ('berede',),
'beredt': ('beredt',),
'beredte': ('beredt',),
'beredt': ('beredt',),
'beredvillig': ('beredvillig',),
'beredvillige': ('beredvillig',),
'beredvillig': ('beredvillig',),
'beregnbar': ('beregnbar',),
'beregnbare': ('beregnbar',),
'beregnbart': ('beregnbar',),
'beregna': ('beregne',),
'beregnet': ('beregne',),
'beregna': ('beregne',),
'beregnet': ('beregne',),
'beregna': ('beregne',),
'beregnete': ('beregne',),
'beregnede': ('beregne',),
'beregna': ('beregne',),
'beregnete': ('beregne',),
'beregnede': ('beregne',),
'beregnende': ('beregne',),
'beregnelig': ('beregnelig',),
'beregnelige': ('beregnelig',),
'beregnelig': ('beregnelig',),
'beregnende': ('beregnende',),
'bereist': ('bereist',),
'bereiste': ('bereist',),
'bereist': ('bereist',),
'beretta': ('berette',),
'berettet': ('berette',),
'beretta': ('berette',),
'berettet': ('berette',),
'beretta': ('berette',),
'berettete': ('berette',),
'berettede': ('berette',),
'beretta': ('berette',),
'berettete': ('berette',),
'berettede': ('berette',),
'berettende': ('berette',),
'berettiga': ('berettige',),
'berettiget': ('berettige',),
'berettiga': ('berettige',),
'berettiget': ('berettige',),
'berettiga': ('berettige',),
'berettigete': ('berettige',),
'berettigede': ('berettige',),
'berettiga': ('berettige',),
'berettigete': ('berettige',),
'berettigede': ('berettige',),
'berettigende': ('berettige',),
'berga': ('berge',),
'berget': ('berge',),
'berga': ('berge',),
'berget': ('berge',),
'berga': ('berge',),
'bergete': ('berge',),
'bergede': ('berge',),
'berga': ('berge',),
'bergete': ('berge',),
'bergede': ('berge',),
'bergende': ('berge',),
'bergensk': ('bergensk',),
'bergenske': ('bergensk',),
'bergensk': ('bergensk',),
'bergtatt': ('bergta',),
'bergtatte': ('bergta',),
'bergtakende': ('bergta',),
'berika': ('berike',),
'beriket': ('berike',),
'berika': ('berike',),
'beriket': ('berike',),
'berika': ('berike',),
'berikete': ('berike',),
'berikede': ('berike',),
'berika': ('berike',),
'berikete': ('berike',),
'berikede': ('berike',),
'berikende': ('berike',),
'beriktiga': ('beriktige',),
'beriktiget': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktiget': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktigete': ('beriktige',),
'beriktigede': ('beriktige',),
'beriktiga': ('beriktige',),
'beriktigete': ('beriktige',),
'beriktigede': ('beriktige',),
'beriktigende': ('beriktige',),
'berlinsk': ('berlinsk',),
'berlinske': ('berlinsk',),
'berlinsk': ('berlinsk',),
'berodd': ('bero',),
'berodde': ('bero',),
'beroende': ('bero',),
'beroliga': ('berolige',),
'beroliget': ('berolige',),
'beroliga': ('berolige',),
'beroliget': ('berolige',),
'beroliga': ('berolige',),
'beroligete': ('berolige',),
'beroligede': ('berolige',),
'beroliga': ('berolige',),
'beroligete': ('berolige',),
'beroligede': ('berolige',),
'beroligende': ('berolige',),
'beroligende': ('beroligende',),
'berrsynt': ('berrsynt',),
'berrsynte': ('berrsynt',),
'berrsynt': ('berrsynt',),
'berta': ('berte',),
'bertet': ('berte',),
'berta': ('berte',),
'bertet': ('berte',),
'berta': ('berte',),
'bertete': ('berte',),
'bertede': ('berte',),
'berta': ('berte',),
'bertete': ('berte',),
'bertede': ('berte',),
'bertende': ('berte',),
'berusa': ('berusa',),
'berusa': ('beruse',),
'beruset': ('beruse',),
'berust': ('beruse',),
'berusa': ('beruse',),
'beruset': ('beruse',),
'berust': ('beruse',),
'berusa': ('beruse',),
'berusete': ('beruse',),
'berusede': ('beruse',),
'beruste': ('beruse',),
'berusa': ('beruse',),
'berusete': ('beruse',),
'berusede': ('beruse',),
'beruste': ('beruse',),
'berusende': ('beruse',),
'beruset': ('beruset',),
'berusete': ('beruset',),
'berusede': ('beruset',),
'berusete': ('beruset',),
'berusede': ('beruset',),
'beruset': ('beruset',),
'berykta': ('berykta',),
'beryktet': ('beryktet',),
'beryktete': ('beryktet',),
'beryktede': ('beryktet',),
'beryktete': ('beryktet',),
'beryktede': ('beryktet',),
'beryktet': ('beryktet',),
'berømma': ('berømme',),
'berømmet': ('berømme',),
'berømt': ('berømme',),
'berømma': ('berømme',),
'berømmet': ('berømme',),
'berømt': ('berømme',),
'berømma': ('berømme',),
'berømmete': ('berømme',),
'berømmede': ('berømme',),
'berømte': ('berømme',),
'berømma': ('berømme',),
'berømmete': ('berømme',),
'berømmede': ('berømme',),
'berømte': ('berømme',),
'berømmende': ('berømme',),
'berømmelig': ('berømmelig',),
'berømmelige': ('berømmelig',),
'berømmelig': ('berømmelig',),
'berømt': ('berømt',),
'berømte': ('berømt',),
'berømt': ('berømt',),
'berørt': ('berøre',),
'berørte': ('berøre',),
'berørende': ('berøre',),
'berøva': ('berøve',),
'berøvet': ('berøve',),
'berøvd': ('berøve',),
'berøva': ('berøve',),
'berøvet': ('berøve',),
'berøvd': ('berøve',),
'berøva': ('berøve',),
'berøvete': ('berøve',),
'berøvede': ('berøve',),
'berøvde': ('berøve',),
'berøva': ('berøve',),
'berøvete': ('berøve',),
'berøvede': ('berøve',),
'berøvde': ('berøve',),
'berøvende': ('berøve',),
'besatt': ('besatt',),
'besatte': ('besatt',),
'besatt': ('besatt',),
'besett': ('bese',),
'besette': ('bese',),
'beseende': ('bese',),
'besegla': ('besegle',),
'beseglet': ('besegle',),
'besegla': ('besegle',),
'beseglet': ('besegle',),
'besegla': ('besegle',),
'beseglete': ('besegle',),
'beseglede': ('besegle',),
'beseglete': ('besegle',),
'beseglede': ('besegle',),
'besegla': ('besegle',),
'beseglete': ('besegle',),
'beseglede': ('besegle',),
'beseglete': ('besegle',),
'beseglede': ('besegle',),
'beseglende': ('besegle',),
'beseira': ('beseire',),
'beseiret': ('beseire',),
'beseira': ('beseire',),
'beseiret': ('beseire',),
'beseira': ('beseire',),
'beseirete': ('beseire',),
'beseirede': ('beseire',),
'beseira': ('beseire',),
'beseirete': ('beseire',),
'beseirede': ('beseire',),
'beseirende': ('beseire',),
'besatt': ('besette',),
'besatte': ('besette',),
'besettende': ('besette',),
'besifra': ('besifre',),
'besifret': ('besifre',),
'besifra': ('besifre',),
'besifret': ('besifre',),
'besifra': ('besifre',),
'besifrete': ('besifre',),
'besifrede': ('besifre',),
'besifrete': ('besifre',),
'besifrede': ('besifre',),
'besifra': ('besifre',),
'besifrete': ('besifre',),
'besifrede': ('besifre',),
'besifrete': ('besifre',),
'besifrede': ('besifre',),
'besifrende': ('besifre',),
'besikta': ('besikte',),
'besiktet': ('besikte',),
'besikta': ('besikte',),
'besiktet': ('besikte',),
'besikta': ('besikte',),
'besiktete': ('besikte',),
'besiktede': ('besikte',),
'besikta': ('besikte',),
'besiktete': ('besikte',),
'besiktede': ('besikte',),
'besiktende': ('besikte',),
'besiktiga': ('besiktige',),
'besiktiget': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktiget': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktigete': ('besiktige',),
'besiktigede': ('besiktige',),
'besiktiga': ('besiktige',),
'besiktigete': ('besiktige',),
'besiktigede': ('besiktige',),
'besiktigende': ('besiktige',),
'besindig': ('besindig',),
'besindige': ('besindig',),
'besindig': ('besindig',),
'besinna': ('besinne',),
'besinnet': ('besinne',),
'besinna': ('besinne',),
'besinnet': ('besinne',),
'besinna': ('besinne',),
'besinnete': ('besinne',),
'besinnede': ('besinne',),
'besinna': ('besinne',),
'besinnete': ('besinne',),
'besinnede': ('besinne',),
'besinnende': ('besinne',),
'besittet': ('besitte',),
'besitten': ('besitte',),
'besitne': ('besitte',),
'besittende': ('besitte',),
'besjelt': ('besjele',),
'besjelte': ('besjele',),
'besjelende': ('besjele',),
'besk': ('besk',),
'beske': ('besk',),
'beskt': ('besk',),
'beskere': ('besk',),
'beskest': ('besk',),
'beskeste': ('besk',),
'beskadiga': ('beskadige',),
'beskadiget': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadiget': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadigete': ('beskadige',),
'beskadigede': ('beskadige',),
'beskadiga': ('beskadige',),
'beskadigete': ('beskadige',),
'beskadigede': ('beskadige',),
'beskadigende': ('beskadige',),
'beskaffen': ('beskaffen',),
'beskafne': ('beskaffen',),
'beskaffent': ('beskaffen',),
'beskatta': ('beskatte',),
'beskattet': ('beskatte',),
'beskatta': ('beskatte',),
'beskattet': ('beskatte',),
'beskatta': ('beskatte',),
'beskattete': ('beskatte',),
'beskattede': ('beskatte',),
'beskatta': ('beskatte',),
'beskattete': ('beskatte',),
'beskattede': ('beskatte',),
'beskattende': ('beskatte',),
'beskikka': ('beskikke',),
'beskikket': ('beskikke',),
'beskikka': ('beskikke',),
'beskikket': ('beskikke',),
'beskikka': ('beskikke',),
'beskikkete': ('beskikke',),
'beskikkede': ('beskikke',),
'beskikka': ('beskikke',),
'beskikkete': ('beskikke',),
'beskikkede': ('beskikke',),
'beskikkende': ('beskikke',),
'beskjeden': ('beskjeden',),
'beskjedne': ('beskjeden',),
'beskjedent': ('beskjeden',),
'beskjeftiga': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftigete': ('beskjeftige',),
'beskjeftigede': ('beskjeftige',),
'beskjeftiga': ('beskjeftige',),
'beskjeftigete': ('beskjeftige',),
'beskjeftigede': ('beskjeftige',),
'beskjeftigende': ('beskjeftige',),
'beskjemma': ('beskjemma',),
'beskjemmet': ('beskjemmet',),
'beskjemmete': ('beskjemmet',),
'beskjemmede': ('beskjemmet',),
'beskjemmete': ('beskjemmet',),
'beskjemmede': ('beskjemmet',),
'beskjemmet': ('beskjemmet',),
'beskåret': ('beskjære',),
'beskåren': ('beskjære',),
'beskårne': ('beskjære',),
'beskjærende': ('beskjære',),
'beskna': ('beskne',),
'besknet': ('beskne',),
'beskna': ('beskne',),
'besknet': ('beskne',),
'beskna': ('beskne',),
'besknete': ('beskne',),
'besknede': ('beskne',),
'besknete': ('beskne',),
'besknede': ('beskne',),
'beskna': ('beskne',),
'besknete': ('beskne',),
'besknede': ('beskne',),
'besknete': ('beskne',),
'besknede': ('beskne',),
'besknende': ('beskne',),
'beskrevet': ('beskrive',),
'beskreven': ('beskrive',),
'beskrevne': ('beskrive',),
'beskrivende': ('beskrive',),
'beskua': ('beskue',),
'beskuet': ('beskue',),
'beskua': ('beskue',),
'beskuet': ('beskue',),
'beskua': ('beskue',),
'beskuete': ('beskue',),
'beskuede': ('beskue',),
'beskua': ('beskue',),
'beskuete': ('beskue',),
'beskuede': ('beskue',),
'beskuende': ('beskue',),
'beskyldt': ('beskylde',),
'beskyldte': ('beskylde',),
'beskyldende': ('beskylde',),
'beskutt': ('beskyte',),
'beskutte': ('beskyte',),
'beskytende': ('beskyte',),
'beskytta': ('beskytte',),
'beskyttet': ('beskytte',),
'beskytta': ('beskytte',),
'beskyttet': ('beskytte',),
'beskytta': ('beskytte',),
'beskyttete': ('beskytte',),
'beskyttede': ('beskytte',),
'beskytta': ('beskytte',),
'beskyttete': ('beskytte',),
'beskyttede': ('beskytte',),
'beskyttende': ('beskytte',),
'beskyttende': ('beskyttende',),
'beslaglagt': ('beslaglegge',),
'beslaglagte': ('beslaglegge',),
'beslagleggende': ('beslaglegge',),
'beslekta': ('beslekta',),
'beslektet': ('beslektet',),
'beslektete': ('beslektet',),
'beslektede': ('beslektet',),
'beslektete': ('beslektet',),
'beslektede': ('beslektet',),
'beslektet': ('beslektet',),
'beslutningsdyktig': ('beslutningsdyktig',),
'beslutningsdyktige': ('beslutningsdyktig',),
'beslutningsdyktig': ('beslutningsdyktig',),
'beslutta': ('beslutte',),
'besluttet': ('beslutte',),
'beslutta': ('beslutte',),
'besluttet': ('beslutte',),
'beslutta': ('beslutte',),
'besluttete': ('beslutte',),
'besluttede': ('beslutte',),
'beslutta': ('beslutte',),
'besluttete': ('beslutte',),
'besluttede': ('beslutte',),
'besluttende': ('beslutte',),
'besluttsom': ('besluttsom',),
'besluttsomme': ('besluttsom',),
'besluttsomt': ('besluttsom',),
'beslått': ('beslå',),
'beslåtte': ('beslå',),
'beslående': ('beslå',),
'besmitta': ('besmitte',),
'besmittet': ('besmitte',),
'besmitta': ('besmitte',),
'besmittet': ('besmitte',),
'besmitta': ('besmitte',),
'besmittete': ('besmitte',),
'besmittede': ('besmitte',),
'besmitta': ('besmitte',),
'besmittete': ('besmitte',),
'besmittede': ('besmitte',),
'besmittende': ('besmitte',),
'besnakka': ('besnakke',),
'besnakket': ('besnakke',),
'besnakka': ('besnakke',),
'besnakket': ('besnakke',),
'besnakka': ('besnakke',),
'besnakkete': ('besnakke',),
'besnakkede': ('besnakke',),
'besnakka': ('besnakke',),
'besnakkete': ('besnakke',),
'besnakkede': ('besnakke',),
'besnakkende': ('besnakke',),
'besnæra': ('besnære',),
'besnæret': ('besnære',),
'besnært': ('besnære',),
'besnæra': ('besnære',),
'besnæret': ('besnære',),
'besnært': ('besnære',),
'besnæra': ('besnære',),
'besnærete': ('besnære',),
'besnærede': ('besnære',),
'besnærte': ('besnære',),
'besnæra': ('besnære',),
'besnærete': ('besnære',),
'besnærede': ('besnære',),
'besnærte': ('besnære',),
'besnærende': ('besnære',),
'besnærende': ('besnærende',),
'bespist': ('bespise',),
'bespiste': ('bespise',),
'bespisende': ('bespise',),
'bespotta': ('bespotte',),
'bespottet': ('bespotte',),
'bespotta': ('bespotte',),
'bespottet': ('bespotte',),
'bespotta': ('bespotte',),
'bespottete': ('bespotte',),
'bespottede': ('bespotte',),
'bespotta': ('bespotte',),
'bespottete': ('bespotte',),
'bespottede': ('bespotte',),
'bespottende': ('bespotte',),
'bespottelig': ('bespottelig',),
'bespottelige': ('bespottelig',),
'bespottelig': ('bespottelig',),
'best': ('best',),
'beste': ('best',),
'best': ('best',),
'bestandig': ('bestandig',),
'bestandige': ('bestandig',),
'bestandig': ('bestandig',),
'besteborgerlig': ('besteborgerlig',),
'besteborgerlige': ('besteborgerlig',),
'besteborgerlig': ('besteborgerlig',),
'bestemt': ('bestemme',),
'bestemte': ('bestemme',),
'bestemmende': ('bestemme',),
'bestemt': ('bestemt',),
'bestemte': ('bestemt',),
'bestemt': ('bestemt',),
'bestialsk': ('bestialsk',),
'bestialske': ('bestialsk',),
'bestialsk': ('bestialsk',),
'besteget': ('bestige',),
'bestegen': ('bestige',),
'bestegne': ('bestige',),
'bestigende': ('bestige',),
'bestukket': ('bestikke',),
'bestukken': ('bestikke',),
'bestukne': ('bestikke',),
'bestikkende': ('bestikke',),
'bestikkelig': ('bestikkelig',),
'bestikkelige': ('bestikkelig',),
'bestikkelig': ('bestikkelig',),
'bestilt': ('bestille',),
'bestilte': ('bestille',),
'bestillende': ('bestille',),
'bestjålet': ('bestjele',),
'bestjålen': ('bestjele',),
'bestjålne': ('bestjele',),
'bestjelende': ('bestjele',),
'bestorma': ('bestorme',),
'bestormet': ('bestorme',),
'bestorma': ('bestorme',),
'bestormet': ('bestorme',),
'bestorma': ('bestorme',),
'bestormete': ('bestorme',),
'bestormede': ('bestorme',),
'bestorma': ('bestorme',),
'bestormete': ('bestorme',),
'bestormede': ('bestorme',),
'bestormende': ('bestorme',),
'bestreba': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebete': ('bestrebe',),
'bestrebede': ('bestrebe',),
'bestreba': ('bestrebe',),
'bestrebete': ('bestrebe',),
'bestrebede': ('bestrebe',),
'bestrebende': ('bestrebe',),
'bestridd': ('bestri',),
'bestridt': ('bestri',),
'bestridd': ('bestri',),
'bestridt': ('bestri',),
'bestridde': ('bestri',),
'bestridte': ('bestri',),
'bestridde': ('bestri',),
'bestridte': ('bestri',),
'bestriende': ('bestri',),
'bestridd': ('bestride',),
'bestridt': ('bestride',),
'bestridd': ('bestride',),
'bestridt': ('bestride',),
'bestridde': ('bestride',),
'bestridte': ('bestride',),
'bestridde': ('bestride',),
'bestridte': ('bestride',),
'bestridende': ('bestride',),
'bestrøket': ('bestryke',),
'bestrøken': ('bestryke',),
'bestrøket': ('bestryke',),
'bestrøken': ('bestryke',),
'bestrøkne': ('bestryke',),
'bestrykende': ('bestryke',),
'bestrålt': ('bestråle',),
'bestrålte': ('bestråle',),
'bestrålende': ('bestråle',),
'bestykka': ('bestykke',),
'bestykket': ('bestykke',),
'bestykka': ('bestykke',),
'bestykket': ('bestykke',),
'bestykka': ('bestykke',),
'bestykkete': ('bestykke',),
'bestykkede': ('bestykke',),
'bestykka': ('bestykke',),
'bestykkete': ('bestykke',),
'bestykkede': ('bestykke',),
'bestykkende': ('bestykke',),
'bestyrt': ('bestyre',),
'bestyrte': ('bestyre',),
'bestyrende': ('bestyre',),
'bestyrka': ('bestyrke',),
'bestyrket': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrket': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrkete': ('bestyrke',),
'bestyrkede': ('bestyrke',),
'bestyrka': ('bestyrke',),
'bestyrkete': ('bestyrke',),
'bestyrkede': ('bestyrke',),
'bestyrkende': ('bestyrke',),
'bestyrta': ('bestyrta',),
'bestyrtet': ('bestyrtet',),
'bestyrtete': ('bestyrtet',),
'bestyrtede': ('bestyrtet',),
'bestyrtete': ('bestyrtet',),
'bestyrtede': ('bestyrtet',),
'bestyrtet': ('bestyrtet',),
'bestått': ('bestå',),
'beståtte': ('bestå',),
'bestående': ('bestå',),
'bestøva': ('bestøve',),
'bestøvet': ('bestøve',),
'bestøva': ('bestøve',),
'bestøvet': ('bestøve',),
'bestøva': ('bestøve',),
'bestøvete': ('bestøve',),
'bestøvede': ('bestøve',),
'bestøva': ('bestøve',),
'bestøvete': ('bestøve',),
'bestøvede': ('bestøve',),
'bestøvende': ('bestøve',),
'besudla': ('besudle',),
'besudlet': ('besudle',),
'besudla': ('besudle',),
'besudlet': ('besudle',),
'besudla': ('besudle',),
'besudlete': ('besudle',),
'besudlede': ('besudle',),
'besudlete': ('besudle',),
'besudlede': ('besudle',),
'besudla': ('besudle',),
'besudlete': ('besudle',),
'besudlede': ('besudle',),
'besudlete': ('besudle',),
'besudlede': ('besudle',),
'besudlende': ('besudle',),
'besvangra': ('besvangre',),
'besvangret': ('besvangre',),
'besvangra': ('besvangre',),
'besvangret': ('besvangre',),
'besvangra': ('besvangre',),
'besvangrete': ('besvangre',),
'besvangrede': ('besvangre',),
'besvangrete': ('besvangre',),
'besvangrede': ('besvangre',),
'besvangra': ('besvangre',),
'besvangrete': ('besvangre',),
'besvangrede': ('besvangre',),
'besvangrete': ('besvangre',),
'besvangrede': ('besvangre',),
'besvangrende': ('besvangre',),
'besvart': ('besvare',),
'besvarte': ('besvare',),
'besvarende': ('besvare',),
'besverga': ('besverge',),
'besverget': ('besverge',),
'besvoret': ('besverge',),
'besverga': ('besverge',),
'besverget': ('besverge',),
'besvoret': ('besverge',),
'besvoren': ('besverge',),
'besverga': ('besverge',),
'besvergete': ('besverge',),
'besvergede': ('besverge',),
'besvorne': ('besverge',),
'besverga': ('besverge',),
'besvergete': ('besverge',),
'besvergede': ('besverge',),
'besvorne': ('besverge',),
'besvergende': ('besverge',),
'besvimt': ('besvime',),
'besvimte': ('besvime',),
'besvimende': ('besvime',),
'besvogra': ('besvogra',),
'besvogret': ('besvogret',),
'besvogrete': ('besvogret',),
'besvogrede': ('besvogret',),
'besvogrete': ('besvogret',),
'besvogrede': ('besvogret',),
'besvogret': ('besvogret',),
'besværa': ('besvære',),
'besværet': ('besvære',),
'besvært': ('besvære',),
'besværa': ('besvære',),
'besværet': ('besvære',),
'besvært': ('besvære',),
'besværa': ('besvære',),
'besværete': ('besvære',),
'besværede': ('besvære',),
'besværte': ('besvære',),
'besværa': ('besvære',),
'besværete': ('besvære',),
'besværede': ('besvære',),
'besværte': ('besvære',),
'besværende': ('besvære',),
'besværlig': ('besværlig',),
'besværlige': ('besværlig',),
'besværlig': ('besværlig',),
'besynderlig': ('besynderlig',),
'besynderlige': ('besynderlig',),
'besynderlig': ('besynderlig',),
'besunget': ('besynge',),
'besungen': ('besynge',),
'besungne': ('besynge',),
'besyngende': ('besynge',),
'besådd': ('besådd',),
'besådde': ('besådd',),
'besådd': ('besådd',),
'besøkt': ('besøke',),
'besøkte': ('besøke',),
'besøkende': ('besøke',),
'besørga': ('besørge',),
'besørget': ('besørge',),
'besørga': ('besørge',),
'besørget': ('besørge',),
'besørga': ('besørge',),
'besørgete': ('besørge',),
'besørgede': ('besørge',),
'besørga': ('besørge',),
'besørgete': ('besørge',),
'besørgede': ('besørge',),
'besørgende': ('besørge',),
'betatt': ('beta',),
'betatte': ('beta',),
'betakende': ('beta',),
'betagende': ('betagende',),
'betakende': ('betakende',),
'betakka': ('betakke',),
'betakket': ('betakke',),
'betakka': ('betakke',),
'betakket': ('betakke',),
'betakka': ('betakke',),
'betakkete': ('betakke',),
'betakkede': ('betakke',),
'betakka': ('betakke',),
'betakkete': ('betakke',),
'betakkede': ('betakke',),
'betakkende': ('betakke',),
'betalt': ('betale',),
'betalte': ('betale',),
'betalende': ('betale',),
'betalingsdyktig': ('betalingsdyktig',),
'betalingsdyktige': ('betalingsdyktig',),
'betalingsdyktig': ('betalingsdyktig',),
'betatt': ('betatt',),
'betatte': ('betatt',),
'betatt': ('betatt',),
'betedd': ('bete',),
'betedde': ('bete',),
'beteende': ('bete',),
'betegna': ('betegne',),
'betegnet': ('betegne',),
'betegna': ('betegne',),
'betegnet': ('betegne',),
'betegna': ('betegne',),
'betegnete': ('betegne',),
'betegnede': ('betegne',),
'betegna': ('betegne',),
'betegnete': ('betegne',),
'betegnede': ('betegne',),
'betegnende': ('betegne',),
'betegnende': ('betegnende',),
'betenkt': ('betenke',),
'betenkte': ('betenke',),
'betenkende': ('betenke',),
'betenkelig': ('betenkelig',),
'betenkelige': ('betenkelig',),
'betenkelig': ('betenkelig',),
'betenksom': ('betenksom',),
'betenksomme': ('betenksom',),
'betenksomt': ('betenksom',),
'betenkt': ('betenkt',),
'betenkte': ('betenkt',),
'betenkt': ('betenkt',),
'betent': ('betent',),
'betente': ('betent',),
'betent': ('betent',),
'betimelig': ('betimelig',),
'betimelige': ('betimelig',),
'betimelig': ('betimelig',),
'betinga': ('betinge',),
'betinget': ('betinge',),
'betinga': ('betinge',),
'betinget': ('betinge',),
'betinga': ('betinge',),
'betingete': ('betinge',),
'betingede': ('betinge',),
'betinga': ('betinge',),
'betingete': ('betinge',),
'betingede': ('betinge',),
'betingende': ('betinge',),
'betingelseslaus': ('betingelseslaus',),
'betingelseslause': ('betingelseslaus',),
'betingelseslaust': ('betingelseslaus',),
'betingelsesløs': ('betingelsesløs',),
'betingelsesløse': ('betingelsesløs',),
'betingelsesløst': ('betingelsesløs',),
'betjent': ('betjene',),
'betjente': ('betjene',),
'betjenende': ('betjene',),
'betla': ('betle',),
'betlet': ('betle',),
'betla': ('betle',),
'betlet': ('betle',),
'betla': ('betle',),
'betlete': ('betle',),
'betlede': ('betle',),
'betlete': ('betle',),
'betlede': ('betle',),
'betla': ('betle',),
'betlete': ('betle',),
'betlede': ('betle',),
'betlete': ('betle',),
'betlede': ('betle',),
'betlende': ('betle',),
'betona': ('betone',),
'betonet': ('betone',),
'betont': ('betone',),
'betona': ('betone',),
'betonet': ('betone',),
'betont': ('betone',),
'betona': ('betone',),
'betonete': ('betone',),
'betonede': ('betone',),
'betonte': ('betone',),
'betona': ('betone',),
'betonete': ('betone',),
'betonede': ('betone',),
'betonte': ('betone',),
'betonende': ('betone',),
'betrakta': ('betrakte',),
'betraktet': ('betrakte',),
'betrakta': ('betrakte',),
'betraktet': ('betrakte',),
'betrakta': ('betrakte',),
'betraktete': ('betrakte',),
'betraktede': ('betrakte',),
'betrakta': ('betrakte',),
'betraktete': ('betrakte',),
'betraktede': ('betrakte',),
'betraktende': ('betrakte',),
'betraktelig': ('betraktelig',),
'betraktelige': ('betraktelig',),
'betraktelig': ('betraktelig',),
'betrådt': ('betre',),
'betrådte': ('betre',),
'betredende': ('betre',),
'betrådt': ('betrede',),
'betrådte': ('betrede',),
'betredende': ('betrede',),
'betrengt': ('betrengt',),
'betrengte': ('betrengt',),
'betrengt': ('betrengt',),
'betrodd': ('betro',),
'betrodde': ('betro',),
'betroende': ('betro',),
'betrodd': ('betrodd',),
'betrodde': ('betrodd',),
'betrodd': ('betrodd',),
'betryggende': ('betryggende',),
'betutta': ('betutta',),
'betuttet': ('betuttet',),
'betuttete': ('betuttet',),
'betuttede': ('betuttet',),
'betuttete': ('betuttet',),
'betuttede': ('betuttet',),
'betuttet': ('betuttet',),
'betvilt': ('betvile',),
'betvilte': ('betvile',),
'betvilende': ('betvile',),
'betvunget': ('betvinge',),
'betvungen': ('betvinge',),
'betvungne': ('betvinge',),
'betvingende': ('betvinge',),
'betydd': ('bety',),
'betydde': ('bety',),
'betyende': ('bety',),
'betydelig': ('betydelig',),
'betydelige': ('betydelig',),
'betydelig': ('betydelig',),
'betydeligere': ('betydelig',),
'betydeligst': ('betydelig',),
'betydeligste': ('betydelig',),
'betydningsbærende': ('betydningsbærende',),
'betydningsfull': ('betydningsfull',),
'betydningsfulle': ('betydningsfull',),
'betydningsfullt': ('betydningsfull',),
'betydningslaus': ('betydningslaus',),
'betydningslause': ('betydningslaus',),
'betydningslaust': ('betydningslaus',),
'betydningsløs': ('betydningsløs',),
'betydningsløse': ('betydningsløs',),
'betydningsløst': ('betydningsløs',),
'betydningsrik': ('betydningsrik',),
'betydningsrike': ('betydningsrik',),
'betydningsrikt': ('betydningsrik',),
'beundra': ('beundre',),
'beundret': ('beundre',),
'beundra': ('beundre',),
'beundret': ('beundre',),
'beundra': ('beundre',),
'beundrete': ('beundre',),
'beundrede': ('beundre',),
'beundrete': ('beundre',),
'beundrede': ('beundre',),
'beundra': ('beundre',),
'beundrete': ('beundre',),
'beundrede': ('beundre',),
'beundrete': ('beundre',),
'beundrede': ('beundre',),
'beundrende': ('beundre',),
'beundringsverdig': ('beundringsverdig',),
'beundringsverdige': ('beundringsverdig',),
'beundringsverdig': ('beundringsverdig',),
'bevandra': ('bevandra',),
'bevandret': ('bevandret',),
'bevandrete': ('bevandret',),
'bevandrede': ('bevandret',),
'bevandrete': ('bevandret',),
'bevandrede': ('bevandret',),
'bevandret': ('bevandret',),
'bevart': ('bevare',),
'bevarte': ('bevare',),
'bevarende': ('bevare',),
'bevaringsverdig': ('bevaringsverdig',),
'bevaringsverdige': ('bevaringsverdig',),
'bevaringsverdig': ('bevaringsverdig',),
'bevart': ('bevart',),
'bevarte': ('bevart',),
'bevart': ('bevart',),
'beva': ('beve',),
'bevet': ('beve',),
'bevd': ('beve',),
'beva': ('beve',),
'bevet': ('beve',),
'bevd': ('beve',),
'beva': ('beve',),
'bevete': ('beve',),
'bevede': ('beve',),
'bevde': ('beve',),
'beva': ('beve',),
'bevete': ('beve',),
'bevede': ('beve',),
'bevde': ('beve',),
'bevende': ('beve',),
'bevega': ('bevege',),
'beveget': ('bevege',),
'bevegd': ('bevege',),
'bevega': ('bevege',),
'beveget': ('bevege',),
'bevegd': ('bevege',),
'bevega': ('bevege',),
'bevegete': ('bevege',),
'bevegede': ('bevege',),
'bevegde': ('bevege',),
'bevega': ('bevege',),
'bevegete': ('bevege',),
'bevegede': ('bevege',),
'bevegde': ('bevege',),
'bevegende': ('bevege',),
'bevegelig': ('bevegelig',),
'bevegelige': ('bevegelig',),
'bevegelig': ('bevegelig',),
'bevegelseshemma': ('bevegelseshemma',),
'bevegelseshemmet': ('bevegelseshemmet',),
'bevegelseshemmete': ('bevegelseshemmet',),
'bevegelseshemmede': ('bevegelseshemmet',),
'bevegelseshemmete': ('bevegelseshemmet',),
'bevegelseshemmede': ('bevegelseshemmet',),
'bevegelseshemmet': ('bevegelseshemmet',),
'beveget': ('beveget',),
'bevegete': ('beveget',),
'bevegede': ('beveget',),
'bevegete': ('beveget',),
'bevegede': ('beveget',),
'beveget': ('beveget',),
'bevendt': ('bevendt',),
'bevendte': ('bevendt',),
'bevendt': ('bevendt',),
'beverta': ('beverte',),
'bevertet': ('beverte',),
'beverta': ('beverte',),
'bevertet': ('beverte',),
'beverta': ('beverte',),
'bevertete': ('beverte',),
'bevertede': ('beverte',),
'beverta': ('beverte',),
'bevertete': ('beverte',),
'bevertede': ('beverte',),
'bevertende': ('beverte',),
'bevilga': ('bevilge',),
'bevilget': ('bevilge',),
'bevilga': ('bevilge',),
'bevilget': ('bevilge',),
'bevilga': ('bevilge',),
'bevilgete': ('bevilge',),
'bevilgede': ('bevilge',),
'bevilga': ('bevilge',),
'bevilgete': ('bevilge',),
'bevilgede': ('bevilge',),
'bevilgende': ('bevilge',),
'bevinga': ('bevinga',),
'bevinget': ('bevinget',),
'bevingete': ('bevinget',),
'bevingede': ('bevinget',),
'bevingete': ('bevinget',),
'bevingede': ('bevinget',),
'bevinget': ('bevinget',),
'bevirka': ('bevirke',),
'bevirket': ('bevirke',),
'bevirka': ('bevirke',),
'bevirket': ('bevirke',),
'bevirka': ('bevirke',),
'bevirkete': ('bevirke',),
'bevirkede': ('bevirke',),
'bevirka': ('bevirke',),
'bevirkete': ('bevirke',),
'bevirkede': ('bevirke',),
'bevirkende': ('bevirke',),
'bevist': ('bevise',),
'beviste': ('bevise',),
'bevisende': ('bevise',),
'beviselig': ('beviselig',),
'beviselige': ('beviselig',),
'beviselig': ('beviselig',),
'bevislig': ('bevislig',),
'bevislige': ('bevislig',),
'bevislig': ('bevislig',),
'bevisst': ('bevisst',),
'bevisste': ('bevisst',),
'bevisst': ('bevisst',),
'bevisstgjort': ('bevisstgjøre',),
'bevisstgjorte': ('bevisstgjøre',),
'bevisstgjørende': ('bevisstgjøre',),
'bevissthetsutvidende': ('bevissthetsutvidende',),
'bevisstlaus': ('bevisstlaus',),
'bevisstlause': ('bevisstlaus',),
'bevisstlaust': ('bevisstlaus',),
'bevisstløs': ('bevisstløs',),
'bevisstløse': ('bevisstløs',),
'bevisstløst': ('bevisstløs',),
'bevitna': ('bevitne',),
'bevitnet': ('bevitne',),
'bevitna': ('bevitne',),
'bevitnet': ('bevitne',),
'bevitna': ('bevitne',),
'bevitnete': ('bevitne',),
'bevitnede': ('bevitne',),
'bevitnete': ('bevitne',),
'bevitnede': ('bevitne',),
'bevitna': ('bevitne',),
'bevitnete': ('bevitne',),
'bevitnede': ('bevitne',),
'bevitnete': ('bevitne',),
'bevitnede': ('bevitne',),
'bevitnende': ('bevitne',),
'bevokst': ('bevokst',),
'bevokste': ('bevokst',),
'bevokst': ('bevokst',),
'bevokta': ('bevokte',),
'bevoktet': ('bevokte',),
'bevokta': ('bevokte',),
'bevoktet': ('bevokte',),
'bevokta': ('bevokte',),
'bevoktete': ('bevokte',),
'bevoktede': ('bevokte',),
'bevokta': ('bevokte',),
'bevoktete': ('bevokte',),
'bevoktede': ('bevokte',),
'bevoktende': ('bevokte',),
'bevra': ('bevre',),
'bevret': ('bevre',),
'bevra': ('bevre',),
'bevret': ('bevre',),
'bevra': ('bevre',),
'bevrete': ('bevre',),
'bevrede': ('bevre',),
'bevrete': ('bevre',),
'bevrede': ('bevre',),
'bevra': ('bevre',),
'bevrete': ('bevre',),
'bevrede': ('bevre',),
'bevrete': ('bevre',),
'bevrede': ('bevre',),
'bevrende': ('bevre',),
'bevæpna': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpnete': ('bevæpne',),
'bevæpnede': ('bevæpne',),
'bevæpnete': ('bevæpne',),
'bevæpnede': ('bevæpne',),
'bevæpna': ('bevæpne',),
'bevæpnete': ('bevæpne',),
'bevæpnede': ('bevæpne',),
'bevæpnete': ('bevæpne',),
'bevæpnede': ('bevæpne',),
'bevæpnende': ('bevæpne',),
'beånda': ('beånde',),
'beåndet': ('beånde',),
'beånda': ('beånde',),
'beåndet': ('beånde',),
'beånda': ('beånde',),
'beåndete': ('beånde',),
'beåndede': ('beånde',),
'beånda': ('beånde',),
'beåndete': ('beånde',),
'beåndede': ('beånde',),
'beåndende': ('beånde',),
'beæra': ('beære',),
'beæret': ('beære',),
'beæra': ('beære',),
'beæret': ('beære',),
'beæra': ('beære',),
'beærete': ('beære',),
'beærede': ('beære',),
'beæra': ('beære',),
'beærete': ('beære',),
'beærede': ('beære',),
'beærende': ('beære',),
'bhutansk': ('bhutansk',),
'bhutanske': ('bhutansk',),
'bhutansk': ('bhutansk',),
'biafransk': ('biafransk',),
'biafranske': ('biafransk',),
'biafransk': ('biafransk',),
'bibeholdt': ('bibeholde',),
'bibeholdte': ('bibeholde',),
'bibeholdende': ('bibeholde',),
'bibelsk': ('bibelsk',),
'bibelske': ('bibelsk',),
'bibelsk': ('bibelsk',),
'bibelsprengt': ('bibelsprengt',),
'bibelsprengte': ('bibelsprengt',),
'bibelsprengt': ('bibelsprengt',),
'bibliofil': ('bibliofil',),
'bibliofile': ('bibliofil',),
'bibliofilt': ('bibliofil',),
'bibliografisk': ('bibliografisk',),
'bibliografiske': ('bibliografisk',),
'bibliografisk': ('bibliografisk',),
'bibrakt': ('bibringe',),
'bibrakte': ('bibringe',),
'bibringende': ('bibringe',),
'bidig': ('bidig',),
'bidige': ('bidig',),
'bidig': ('bidig',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidradd': ('bidra',),
'bidratt': ('bidra',),
'bidradde': ('bidra',),
'bidratte': ('bidra',),
'bidradde': ('bidra',),
'bidratte': ('bidra',),
'bidradde': ('bidra',),
'bidratte': ('bidra',),
'bidradde': ('bidra',),
'bidratte': ('bidra',),
'bidragende': ('bidra',),
'bia': ('bie',),
'biet': ('bie',),
'bidd': ('bie',),
'bia': ('bie',),
'biet': ('bie',),
'bidd': ('bie',),
'bia': ('bie',),
'biete': ('bie',),
'biede': ('bie',),
'bidde': ('bie',),
'bia': ('bie',),
'biete': ('bie',),
'biede': ('bie',),
'bidde': ('bie',),
'biende': ('bie',),
'biennal': ('biennal',),
'biennale': ('biennal',),
'biennalt': ('biennal',),
'bifalt': ('bifalle',),
'bifalte': ('bifalle',),
'bifallende': ('bifalle',),
'biff': ('biff',),
'bifil': ('bifil',),
'bifile': ('bifil',),
'bifilt': ('bifil',),
'bifokal': ('bifokal',),
'bifokale': ('bifokal',),
'bifokalt': ('bifokal',),
'bigott': ('bigott',),
'bigotte': ('bigott',),
'bigott': ('bigott',),
'bikka': ('bikke',),
'bikket': ('bikke',),
'bikka': ('bikke',),
'bikket': ('bikke',),
'bikka': ('bikke',),
'bikkete': ('bikke',),
'bikkede': ('bikke',),
'bikka': ('bikke',),
'bikkete': ('bikke',),
'bikkede': ('bikke',),
'bikkende': ('bikke',),
'bikkjekald': ('bikkjekald',),
'bikkjekalde': ('bikkjekald',),
'bikkjekaldt': ('bikkjekald',),
'bikonkav': ('bikonkav',),
'bikonkave': ('bikonkav',),
'bikonkavt': ('bikonkav',),
'bikonveks': ('bikonveks',),
'bikonvekse': ('bikonveks',),
'bikonvekst': ('bikonveks',),
'bikta': ('bikte',),
'biktet': ('bikte',),
'bikta': ('bikte',),
'biktet': ('bikte',),
'bikta': ('bikte',),
'biktete': ('bikte',),
'biktede': ('bikte',),
'bikta': ('bikte',),
'biktete': ('bikte',),
'biktede': ('bikte',),
'biktende': ('bikte',),
'bilabial': ('bilabial',),
'bilabiale': ('bilabial',),
'bilabialt': ('bilabial',),
'bilateral': ('bilateral',),
'bilaterale': ('bilateral',),
'bilateralt': ('bilateral',),
'bildende': ('bildende',),
'bilderik': ('bilderik',),
'bilderike': ('bilderik',),
'bilderikt': ('bilderik',),
'bildeskjønn': ('bildeskjønn',),
'bildeskjønne': ('bildeskjønn',),
'bildeskjønt': ('bildeskjønn',),
'bilt': ('bile',),
'bilte': ('bile',),
'bilende': ('bile',),
'bilagt': ('bilegge',),
'bilagte': ('bilegge',),
'bileggende': ('bilegge',),
'bilingv': ('bilingv',),
'bilingve': ('bilingv',),
'bilingv': ('bilingv',),
'bilingval': ('bilingval',),
'bilingvale': ('bilingval',),
'bilingvalt': ('bilingval',),
'billedlig': ('billedlig',),
'billedlige': ('billedlig',),
'billedlig': ('billedlig',),
'billedrik': ('billedrik',),
'billedrike': ('billedrik',),
'billedrikt': ('billedrik',),
'billedskjønn': ('billedskjønn',),
'billedskjønne': ('billedskjønn',),
'billedskjønt': ('billedskjønn',),
'billettert': ('billettere',),
'billetterte': ('billettere',),
'billetterende': ('billettere',),
'billig': ('billig',),
'billige': ('billig',),
'billig': ('billig',),
'billigere': ('billig',),
'billigst': ('billig',),
'billigste': ('billig',),
'billiga': ('billige',),
'billiget': ('billige',),
'billiga': ('billige',),
'billiget': ('billige',),
'billiga': ('billige',),
'billigete': ('billige',),
'billigede': ('billige',),
'billiga': ('billige',),
'billigete': ('billige',),
'billigede': ('billige',),
'billigende': ('billige',),
'billiondels': ('billiondels',),
'billionte': ('billionte',),
'bilsakkyndig': ('bilsakkyndig',),
'bilsakkyndige': ('bilsakkyndig',),
'bilsakkyndig': ('bilsakkyndig',),
'bilsjuk': ('bilsjuk',),
'bilsjuke': ('bilsjuk',),
'bilsjukt': ('bilsjuk',),
'bilsyk': ('bilsyk',),
'bilsyke': ('bilsyk',),
'bilsykt': ('bilsyk',),
'bundet': ('binde',),
'bunden': ('binde',),
'bundne': ('binde',),
'bindende': ('binde',),
'bindegal': ('bindegal',),
'bindegale': ('bindegal',),
'bindegalt': ('bindegal',),
'bindegalen': ('bindegalen',),
'bindegalne': ('bindegalen',),
'bindegalent': ('bindegalen',),
'bindsterk': ('bindsterk',),
'bindsterke': ('bindsterk',),
'bindsterkt': ('bindsterk',),
'binokular': ('binokular',),
'binokulare': ('binokular',),
'binokulart': ('binokular',),
'binokulær': ('binokulær',),
'binokulære': ('binokulær',),
'binokulært': ('binokulær',),
'binomial': ('binomial',),
'binomiale': ('binomial',),
'binomialt': ('binomial',),
'binær': ('binær',),
'binære': ('binær',),
'binært': ('binær',),
'biodynamisk': ('biodynamisk',),
'biodynamiske': ('biodynamisk',),
'biodynamisk': ('biodynamisk',),
'biogeokjemisk': ('biogeokjemisk',),
'biogeokjemiske': ('biogeokjemisk',),
'biogeokjemisk': ('biogeokjemisk',),
'biografisk': ('biografisk',),
'biografiske': ('biografisk',),
'biografisk': ('biografisk',),
'biokjemisk': ('biokjemisk',),
'biokjemiske': ('biokjemisk',),
'biokjemisk': ('biokjemisk',),
'biologisk': ('biologisk',),
'biologiske': ('biologisk',),
'biologisk': ('biologisk',),
'biotisk': ('biotisk',),
'biotiske': ('biotisk',),
'biotisk': ('biotisk',),
'bisarr': ('bisarr',),
'bisarre': ('bisarr',),
'bisart': ('bisarr',),
'biseksuell': ('biseksuell',),
'biseksuelle': ('biseksuell',),
'biseksuelt': ('biseksuell',),
'bisatt': ('bisette',),
'bisatte': ('bisette',),
'bisettende': ('bisette',),
'bisk': ('bisk',),
'biske': ('bisk',),
'biskt': ('bisk',),
'biskere': ('bisk',),
'biskest': ('bisk',),
'biskeste': ('bisk',),
'biskoppelig': ('biskoppelig',),
'biskoppelige': ('biskoppelig',),
'biskoppelig': ('biskoppelig',),
'bister': ('bister',),
'bistre': ('bister',),
'bistert': ('bister',),
'bistått': ('bistå',),
'biståtte': ('bistå',),
'bistående': ('bistå',),
'bitt': ('bite',),
'bitte': ('bite',),
'bitende': ('bite',),
'bitende': ('bitende',),
'bitter': ('bitter',),
'bitre': ('bitter',),
'bittert': ('bitter',),
'bitrere': ('bitter',),
'bitrest': ('bitter',),
'bitreste': ('bitter',),
'bitterste': ('bitterste',),
'bittersøt': ('bittersøt',),
'bittersøte': ('bittersøt',),
'bittersøtt': ('bittersøt',),
'bitumiøs': ('bitumiøs',),
'bitumiøse': ('bitumiøs',),
'bitumiøst': ('bitumiøs',),
'bivalent': ('bivalent',),
'bivalente': ('bivalent',),
'bivalent': ('bivalent',),
'bivuakkert': ('bivuakkere',),
'bivuakkerte': ('bivuakkere',),
'bivuakkerende': ('bivuakkere',),
'bivåna': ('bivåne',),
'bivånet': ('bivåne',),
'bivånt': ('bivåne',),
'bivåna': ('bivåne',),
'bivånet': ('bivåne',),
'bivånt': ('bivåne',),
'bivåna': ('bivåne',),
'bivånete': ('bivåne',),
'bivånede': ('bivåne',),
'bivånte': ('bivåne',),
'bivåna': ('bivåne',),
'bivånete': ('bivåne',),
'bivånede': ('bivåne',),
'bivånte': ('bivåne',),
'bivånende': ('bivåne',),
'bjeffa': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffete': ('bjeffe',),
'bjeffede': ('bjeffe',),
'bjeffa': ('bjeffe',),
'bjeffete': ('bjeffe',),
'bjeffede': ('bjeffe',),
'bjeffende': ('bjeffe',),
'bladd': ('bla',),
'bladde': ('bla',),
'blaende': ('bla',),
'bladtynn': ('bladtynn',),
'bladtynne': ('bladtynn',),
'bladtynt': ('bladtynn',),
'blaffa': ('blaffe',),
'blaffet': ('blaffe',),
'blaffa': ('blaffe',),
'blaffet': ('blaffe',),
'blaffa': ('blaffe',),
'blaffete': ('blaffe',),
'blaffede': ('blaffe',),
'blaffa': ('blaffe',),
'blaffete': ('blaffe',),
'blaffede': ('blaffe',),
'blaffende': ('blaffe',),
'blafra': ('blafre',),
'blafret': ('blafre',),
'blafra': ('blafre',),
'blafret': ('blafre',),
'blafra': ('blafre',),
'blafrete': ('blafre',),
'blafrede': ('blafre',),
'blafrete': ('blafre',),
'blafrede': ('blafre',),
'blafra': ('blafre',),
'blafrete': ('blafre',),
'blafrede': ('blafre',),
'blafrete': ('blafre',),
'blafrede': ('blafre',),
'blafrende': ('blafre',),
'blakk': ('blakk',),
'blakke': ('blakk',),
'blakt': ('blakk',),
'blakkere': ('blakk',),
'blakkest': ('blakk',),
'blakkeste': ('blakk',),
'blakka': ('blakke',),
'blakket': ('blakke',),
'blakka': ('blakke',),
'blakket': ('blakke',),
'blakka': ('blakke',),
'blakkete': ('blakke',),
'blakkede': ('blakke',),
'blakka': ('blakke',),
'blakkete': ('blakke',),
'blakkede': ('blakke',),
'blakkende': ('blakke',),
'blakna': ('blakne',),
'blaknet': ('blakne',),
'blakna': ('blakne',),
'blaknet': ('blakne',),
'blakna': ('blakne',),
'blaknete': ('blakne',),
'blaknede': ('blakne',),
'blaknete': ('blakne',),
'blaknede': ('blakne',),
'blakna': ('blakne',),
'blaknete': ('blakne',),
'blaknede': ('blakne',),
'blaknete': ('blakne',),
'blaknede': ('blakne',),
'blaknende': ('blakne',),
'blakra': ('blakre',),
'blakret': ('blakre',),
'blakra': ('blakre',),
'blakret': ('blakre',),
'blakra': ('blakre',),
'blakrete': ('blakre',),
'blakrede': ('blakre',),
'blakrete': ('blakre',),
'blakrede': ('blakre',),
'blakra': ('blakre',),
'blakrete': ('blakre',),
'blakrede': ('blakre',),
'blakrete': ('blakre',),
'blakrede': ('blakre',),
'blakrende': ('blakre',),
'blamert': ('blamere',),
'blamerte': ('blamere',),
'blamerende': ('blamere',),
'blanda': ('blande',),
'blandet': ('blande',),
'blanda': ('blande',),
'blandet': ('blande',),
'blanda': ('blande',),
'blandete': ('blande',),
'blandede': ('blande',),
'blanda': ('blande',),
'blandete': ('blande',),
'blandede': ('blande',),
'blandende': ('blande',),
'blank': ('blank',),
'blanke': ('blank',),
'blankt': ('blank',),
'blankere': ('blank',),
'blankest': ('blank',),
'blankeste': ('blank',),
'blanka': ('blanke',),
'blanket': ('blanke',),
'blanka': ('blanke',),
'blanket': ('blanke',),
'blanka': ('blanke',),
'blankete': ('blanke',),
'blankede': ('blanke',),
'blanka': ('blanke',),
'blankete': ('blanke',),
'blankede': ('blanke',),
'blankende': ('blanke',),
'blankpussa': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpussete': ('blankpusse',),
'blankpussede': ('blankpusse',),
'blankpussa': ('blankpusse',),
'blankpussete': ('blankpusse',),
'blankpussede': ('blankpusse',),
'blankpussende': ('blankpusse',),
'blankslitt': ('blankslite',),
'blankslitte': ('blankslite',),
'blankslitende': ('blankslite',),
'blankøyd': ('blankøyd',),
'blankøyde': ('blankøyd',),
'blankøyd': ('blankøyd',),
'blasert': ('blasert',),
'blaserte': ('blasert',),
'blasert': ('blasert',),
'blasfemisk': ('blasfemisk',),
'blasfemiske': ('blasfemisk',),
'blasfemisk': ('blasfemisk',),
'blasonert': ('blasonere',),
'blasonerte': ('blasonere',),
'blasonerende': ('blasonere',),
'blass': ('blass',),
'blasse': ('blass',),
'blast': ('blass',),
'blassere': ('blass',),
'blassest': ('blass',),
'blasseste': ('blass',),
'blaut': ('blaut',),
'blaute': ('blaut',),
'blautt': ('blaut',),
'blautere': ('blaut',),
'blautest': ('blaut',),
'blauteste': ('blaut',),
'blautgjort': ('blautgjøre',),
'blautgjorte': ('blautgjøre',),
'blautgjørende': ('blautgjøre',),
'blauthjertet': ('blauthjertet',),
'blauthjertete': ('blauthjertet',),
'blauthjertede': ('blauthjertet',),
'blauthjertete': ('blauthjertet',),
'blauthjertede': ('blauthjertet',),
'blauthjertet': ('blauthjertet',),
'blautkokt': ('blautkoke',),
'blautkokte': ('blautkoke',),
'blautkokende': ('blautkoke',),
'blautlendt': ('blautlendt',),
'blautlendte': ('blautlendt',),
'blautlendt': ('blautlendt',),
'bleigd': ('bleige',),
'bleigde': ('bleige',),
'bleigende': ('bleige',),
'bleik': ('bleik',),
'bleike': ('bleik',),
'bleikt': ('bleik',),
'bleikere': ('bleik',),
'bleikest': ('bleik',),
'bleikeste': ('bleik',),
'bleikblå': ('bleikblå',),
'bleikblåe': ('bleikblå',),
'bleikblå': ('bleikblå',),
'bleikblåe': ('bleikblå',),
'bleikblå': ('bleikblå',),
'bleikblått': ('bleikblå',),
'bleikbrun': ('bleikbrun',),
'bleikbrune': ('bleikbrun',),
'bleikbrunt': ('bleikbrun',),
'bleika': ('bleike',),
'bleiket': ('bleike',),
'bleikt': ('bleike',),
'bleika': ('bleike',),
'bleiket': ('bleike',),
'bleikt': ('bleike',),
'bleika': ('bleike',),
'bleikete': ('bleike',),
'bleikede': ('bleike',),
'bleikte': ('bleike',),
'bleika': ('bleike',),
'bleikete': ('bleike',),
'bleikede': ('bleike',),
'bleikte': ('bleike',),
'bleikende': ('bleike',),
'bleikfeit': ('bleikfeit',),
'bleikfeite': ('bleikfeit',),
'bleikfeitt': ('bleikfeit',),
'bleikfett': ('bleikfeit',),
'bleikna': ('bleikne',),
'bleiknet': ('bleikne',),
'bleikna': ('bleikne',),
'bleiknet': ('bleikne',),
'bleikna': ('bleikne',),
'bleiknete': ('bleikne',),
'bleiknede': ('bleikne',),
'bleiknete': ('bleikne',),
'bleiknede': ('bleikne',),
'bleikna': ('bleikne',),
'bleiknete': ('bleikne',),
'bleiknede': ('bleikne',),
'bleiknete': ('bleikne',),
'bleiknede': ('bleikne',),
'bleiknende': ('bleikne',),
'bleiknebba': ('bleiknebba',),
'bleiknebbet': ('bleiknebbet',),
'bleiknebbete': ('bleiknebbet',),
'bleiknebbede': ('bleiknebbet',),
'bleiknebbete': ('bleiknebbet',),
'bleiknebbede': ('bleiknebbet',),
'bleiknebbet': ('bleiknebbet',),
'blek': ('blek',),
'bleke': ('blek',),
'blekt': ('blek',),
'blekere': ('blek',),
'blekest': ('blek',),
'blekeste': ('blek',),
'blekblå': ('blekblå',),
'blekblåe': ('blekblå',),
'blekblå': ('blekblå',),
'blekblåe': ('blekblå',),
'blekblå': ('blekblå',),
'blekblått': ('blekblå',),
'blekbrun': ('blekbrun',),
'blekbrune': ('blekbrun',),
'blekbrunt': ('blekbrun',),
'bleka': ('bleke',),
'bleket': ('bleke',),
'blekt': ('bleke',),
'bleka': ('bleke',),
'bleket': ('bleke',),
'blekt': ('bleke',),
'bleka': ('bleke',),
'blekete': ('bleke',),
'blekede': ('bleke',),
'blekte': ('bleke',),
'bleka': ('bleke',),
'blekete': ('bleke',),
'blekede': ('bleke',),
'blekte': ('bleke',),
'blekende': ('bleke',),
'blekfet': ('blekfet',),
'blekfete': ('blekfet',),
'blekfett': ('blekfet',),
'blekka': ('blekke',),
'blekket': ('blekke',),
'blekka': ('blekke',),
'blekket': ('blekke',),
'blekka': ('blekke',),
'blekkete': ('blekke',),
'blekkede': ('blekke',),
'blekka': ('blekke',),
'blekkete': ('blekke',),
'blekkede': ('blekke',),
'blekkende': ('blekke',),
'blekt': ('blekke',),
'blekte': ('blekke',),
'blekkende': ('blekke',),
'blekket': ('blekket',),
'blekkete': ('blekket',),
'blekket': ('blekket',),
'blekkete': ('blekkete',),
'blekna': ('blekne',),
'bleknet': ('blekne',),
'blekna': ('blekne',),
'bleknet': ('blekne',),
'blekna': ('blekne',),
'bleknete': ('blekne',),
'bleknede': ('blekne',),
'bleknete': ('blekne',),
'bleknede': ('blekne',),
'blekna': ('blekne',),
'bleknete': ('blekne',),
'bleknede': ('blekne',),
'bleknete': ('blekne',),
'bleknede': ('blekne',),
'bleknende': ('blekne',),
'blemmet': ('blemmet',),
'blemmete': ('blemmet',),
'blemmet': ('blemmet',),
'blemmete': ('blemmete',),
'blenda': ('blende',),
'blendet': ('blende',),
'blenda': ('blende',),
'blendet': ('blende',),
'blenda': ('blende',),
'blendete': ('blende',),
'blendede': ('blende',),
'blenda': ('blende',),
'blendete': ('blende',),
'blendede': ('blende',),
'blendende': ('blende',),
'blendende': ('blendende',),
'blivende': ('bli',),
'blitt': ('bli',),
'blitte': ('bli',),
'blivende': ('bli',),
'blid': ('blid',),
'blide': ('blid',),
'blidt': ('blid',),
'blidere': ('blid',),
'blidest': ('blid',),
'blideste': ('blid',),
'blidgjort': ('blidgjøre',),
'blidgjorte': ('blidgjøre',),
'blidgjørende': ('blidgjøre',),
'blidlåten': ('blidlåten',),
'blidlåtne': ('blidlåten',),
'blidlåtent': ('blidlåten',),
'blikkstille': ('blikkstille',),
'blind': ('blind',),
'blinde': ('blind',),
'blindt': ('blind',),
'blinda': ('blinde',),
'blindet': ('blinde',),
'blinda': ('blinde',),
'blindet': ('blinde',),
'blinda': ('blinde',),
'blindete': ('blinde',),
'blindede': ('blinde',),
'blinda': ('blinde',),
'blindete': ('blinde',),
'blindede': ('blinde',),
'blindende': ('blinde',),
'blingsa': ('blingse',),
'blingset': ('blingse',),
'blingsa': ('blingse',),
'blingset': ('blingse',),
'blingsa': ('blingse',),
'blingsete': ('blingse',),
'blingsede': ('blingse',),
'blingsa': ('blingse',),
'blingsete': ('blingse',),
'blingsede': ('blingse',),
'blingsende': ('blingse',),
'blingset': ('blingset',),
'blingsete': ('blingset',),
'blingset': ('blingset',),
'blingsete': ('blingsete',),
'blinka': ('blinke',),
'blinket': ('blinke',),
'blinka': ('blinke',),
'blinket': ('blinke',),
'blinka': ('blinke',),
'blinkete': ('blinke',),
'blinkede': ('blinke',),
'blinka': ('blinke',),
'blinkete': ('blinke',),
'blinkede': ('blinke',),
'blinkende': ('blinke',),
'blitsa': ('blitse',),
'blitset': ('blitse',),
'blitsa': ('blitse',),
'blitset': ('blitse',),
'blitsa': ('blitse',),
'blitsete': ('blitse',),
'blitsede': ('blitse',),
'blitsa': ('blitse',),
'blitsete': ('blitse',),
'blitsede': ('blitse',),
'blitsende': ('blitse',),
'blitt': ('blive',),
'blitte': ('blive',),
'blivende': ('blive',),
'blivende': ('blivende',),
'bloddryppende': ('bloddryppende',),
'blodet': ('blodet',),
'blodete': ('blodet',),
'blodet': ('blodet',),
'blodete': ('blodete',),
'blodfattig': ('blodfattig',),
'blodfattige': ('blodfattig',),
'blodfattig': ('blodfattig',),
'blodfersk': ('blodfersk',),
'blodferske': ('blodfersk',),
'blodferskt': ('blodfersk',),
'blodfull': ('blodfull',),
'blodfulle': ('blodfull',),
'blodfullt': ('blodfull',),
'blodig': ('blodig',),
'blodige': ('blodig',),
'blodig': ('blodig',),
'blodigere': ('blodig',),
'blodigst': ('blodig',),
'blodigste': ('blodig',),
'blodrød': ('blodrød',),
'blodrøde': ('blodrød',),
'blodrødt': ('blodrød',),
'blodrødere': ('blodrød',),
'blodrødest': ('blodrød',),
'blodrødeste': ('blodrød',),
'blodskutt': ('blodskutt',),
'blodskutte': ('blodskutt',),
'blodskutt': ('blodskutt',),
'blodsprengt': ('blodsprengt',),
'blodsprengte': ('blodsprengt',),
'blodsprengt': ('blodsprengt',),
'blodstillende': ('blodstillende',),
'blodtørstig': ('blodtørstig',),
'blodtørstige': ('blodtørstig',),
'blodtørstig': ('blodtørstig',),
'blodunderløpen': ('blodunderløpen',),
'blodunderløpne': ('blodunderløpen',),
'blodunderløpent': ('blodunderløpen',),
'blogga': ('blogge',),
'blogget': ('blogge',),
'blogga': ('blogge',),
'blogget': ('blogge',),
'blogga': ('blogge',),
'bloggete': ('blogge',),
'bloggede': ('blogge',),
'blogga': ('blogge',),
'bloggete': ('blogge',),
'bloggede': ('blogge',),
'bloggende': ('blogge',),
'blokka': ('blokke',),
'blokket': ('blokke',),
'blokka': ('blokke',),
'blokket': ('blokke',),
'blokka': ('blokke',),
'blokkete': ('blokke',),
'blokkede': ('blokke',),
'blokka': ('blokke',),
'blokkete': ('blokke',),
'blokkede': ('blokke',),
'blokkende': ('blokke',),
'blokkert': ('blokkere',),
'blokkerte': ('blokkere',),
'blokkerende': ('blokkere',),
'blomstra': ('blomstre',),
'blomstret': ('blomstre',),
'blomstra': ('blomstre',),
'blomstret': ('blomstre',),
'blomstra': ('blomstre',),
'blomstrete': ('blomstre',),
'blomstrede': ('blomstre',),
'blomstrete': ('blomstre',),
'blomstrede': ('blomstre',),
'blomstra': ('blomstre',),
'blomstrete': ('blomstre',),
'blomstrede': ('blomstre',),
'blomstrete': ('blomstre',),
'blomstrede': ('blomstre',),
'blomstrende': ('blomstre',),
'blomstrende': ('blomstrende',),
'blomstret': ('blomstret',),
'blomstrete': ('blomstret',),
'blomstret': ('blomstret',),
'blomstrete': ('blomstrete',),
'blond': ('blond',),
'blonde': ('blond',),
'blondt': ('blond',),
'blondere': ('blond',),
'blondest': ('blond',),
'blondeste': ('blond',),
'blota': ('blote',),
'blotet': ('blote',),
'blota': ('blote',),
'blotet': ('blote',),
'blota': ('blote',),
'blotete': ('blote',),
'blotede': ('blote',),
'blota': ('blote',),
'blotete': ('blote',),
'blotede': ('blote',),
'blotende': ('blote',),
'blott': ('blott',),
'blotte': ('blott',),
'blott': ('blott',),
'blotta': ('blotte',),
'blottet': ('blotte',),
'blotta': ('blotte',),
'blottet': ('blotte',),
'blotta': ('blotte',),
'blottete': ('blotte',),
'blottede': ('blotte',),
'blotta': ('blotte',),
'blottete': ('blotte',),
'blottede': ('blotte',),
'blottende': ('blotte',),
'blottlagt': ('blottlegge',),
'blottlagte': ('blottlegge',),
'blottleggende': ('blottlegge',),
'blottstilt': ('blottstille',),
'blottstilte': ('blottstille',),
'blottstillende': ('blottstille',),
'bluferdig': ('bluferdig',),
'bluferdige': ('bluferdig',),
'bluferdig': ('bluferdig',),
'blunda': ('blunde',),
'blundet': ('blunde',),
'blunda': ('blunde',),
'blundet': ('blunde',),
'blunda': ('blunde',),
'blundete': ('blunde',),
'blundede': ('blunde',),
'blunda': ('blunde',),
'blundete': ('blunde',),
'blundede': ('blunde',),
'blundende': ('blunde',),
'blunka': ('blunke',),
'blunket': ('blunke',),
'blunka': ('blunke',),
'blunket': ('blunke',),
'blunka': ('blunke',),
'blunkete': ('blunke',),
'blunkede': ('blunke',),
'blunka': ('blunke',),
'blunkete': ('blunke',),
'blunkede': ('blunke',),
'blunkende': ('blunke',),
'blussa': ('blusse',),
'blusset': ('blusse',),
'blussa': ('blusse',),
'blusset': ('blusse',),
'blussa': ('blusse',),
'blussete': ('blusse',),
'blussede': ('blusse',),
'blussa': ('blusse',),
'blussete': ('blusse',),
'blussede': ('blusse',),
'blussende': ('blusse',),
'blussende': ('blussende',),
'blyg': ('blyg',),
'blyge': ('blyg',),
'blygt': ('blyg',),
'blygere': ('blyg',),
'blygest': ('blyg',),
'blygeste': ('blyg',),
'blygrå': ('blygrå',),
'blygråe': ('blygrå',),
'blygrå': ('blygrå',),
'blygråe': ('blygrå',),
'blygrå': ('blygrå',),
'blygrått': ('blygrå',),
'blyholdig': ('blyholdig',),
'blyholdige': ('blyholdig',),
'blyholdig': ('blyholdig',),
'blytung': ('blytung',),
'blytunge': ('blytung',),
'blytungt': ('blytung',),
'blå': ('blå',),
'blåe': ('blå',),
'blå': ('blå',),
'blåe': ('blå',),
'blå': ('blå',),
'blått': ('blå',),
'blåere': ('blå',),
'blåest': ('blå',),
'blåeste': ('blå',),
'blåfiolett': ('blåfiolett',),
'blåfiolette': ('blåfiolett',),
'blåfiolett': ('blåfiolett',),
'blåfrossen': ('blåfrossen',),
'blåfrosne': ('blåfrossen',),
'blåfrosset': ('blåfrossen',),
'blåfrosset': ('blåfrosset',),
'blåfrosne': ('blåfrosset',),
'blåfrosset': ('blåfrosset',),
'blågul': ('blågul',),
'blågule': ('blågul',),
'blågult': ('blågul',),
'blåhard': ('blåhard',),
'blåharde': ('blåhard',),
'blåhardt': ('blåhard',),
'blåholdt': ('blåholde',),
'blåholdte': ('blåholde',),
'blåholdende': ('blåholde',),
'blålig': ('blålig',),
'blålige': ('blålig',),
'blålig': ('blålig',),
'blåna': ('blåne',),
'blånet': ('blåne',),
'blåna': ('blåne',),
'blånet': ('blåne',),
'blåna': ('blåne',),
'blånete': ('blåne',),
'blånede': ('blåne',),
'blåna': ('blåne',),
'blånete': ('blåne',),
'blånede': ('blåne',),
'blånende': ('blåne',),
'blånekta': ('blånekte',),
'blånektet': ('blånekte',),
'blånekta': ('blånekte',),
'blånektet': ('blånekte',),
'blånekta': ('blånekte',),
'blånektete': ('blånekte',),
'blånektede': ('blånekte',),
'blånekta': ('blånekte',),
'blånektete': ('blånekte',),
'blånektede': ('blånekte',),
'blånektende': ('blånekte',),
'blånøye': ('blånøye',),
'blåst': ('blåse',),
'blåste': ('blåse',),
'blåsende': ('blåse',),
'blåsur': ('blåsur',),
'blåsure': ('blåsur',),
'blåsurt': ('blåsur',),
'blåøyd': ('blåøyd',),
'blåøyde': ('blåøyd',),
'blåøyd': ('blåøyd',),
'blæra': ('blære',),
'blæret': ('blære',),
'blæra': ('blære',),
'blæret': ('blære',),
'blæra': ('blære',),
'blærete': ('blære',),
'blærede': ('blære',),
'blæra': ('blære',),
'blærete': ('blære',),
'blærede': ('blære',),
'blærende': ('blære',),
'blæret': ('blæret',),
'blærete': ('blæret',),
'blæret': ('blæret',),
'blærete': ('blærete',),
'blødd': ('blø',),
'blødde': ('blø',),
'bløende': ('blø',),
'bløffa': ('bløffe',),
'bløffet': ('bløffe',),
'bløffa': ('bløffe',),
'bløffet': ('bløffe',),
'bløffa': ('bløffe',),
'bløffete': ('bløffe',),
'bløffede': ('bløffe',),
'bløffa': ('bløffe',),
'bløffete': ('bløffe',),
'bløffede': ('bløffe',),
'bløffende': ('bløffe',),
'bløgga': ('bløgge',),
'bløgget': ('bløgge',),
'bløgga': ('bløgge',),
'bløgget': ('bløgge',),
'bløgga': ('bløgge',),
'bløggete': ('bløgge',),
'bløggede': ('bløgge',),
'bløgga': ('bløgge',),
'bløggete': ('bløgge',),
'bløggede': ('bløgge',),
'bløggende': ('bløgge',),
'bløt': ('bløt',),
'bløte': ('bløt',),
'bløtt': ('bløt',),
'bløtere': ('bløt',),
'bløtest': ('bløt',),
'bløteste': ('bløt',),
'bløtaktig': ('bløtaktig',),
'bløtaktige': ('bløtaktig',),
'bløtaktig': ('bløtaktig',),
'bløtt': ('bløte',),
'bløtte': ('bløte',),
'bløtende': ('bløte',),
'bløtgjort': ('bløtgjøre',),
'bløtgjorte': ('bløtgjøre',),
'bløtgjørende': ('bløtgjøre',),
'bløthjerta': ('bløthjerta',),
'bløthjertet': ('bløthjertet',),
'bløthjertete': ('bløthjertet',),
'bløthjertede': ('bløthjertet',),
'bløthjertete': ('bløthjertet',),
'bløthjertede': ('bløthjertet',),
'bløthjertet': ('bløthjertet',),
'bløtkokt': ('bløtkoke',),
'bløtkokte': ('bløtkoke',),
'bløtkokende': ('bløtkoke',),
'bløtlagt': ('bløtlegge',),
'bløtlagte': ('bløtlegge',),
'bløtleggende': ('bløtlegge',),
'bløytt': ('bløyte',),
'bløtt': ('bløyte',),
'bløytt': ('bløyte',),
'bløtt': ('bløyte',),
'bløytte': ('bløyte',),
'bløtte': ('bløyte',),
'bløytte': ('bløyte',),
'bløtte': ('bløyte',),
'bløytende': ('bløyte',),
'bløytlagt': ('bløytlegge',),
'bløytlagte': ('bløytlegge',),
'bløytleggende': ('bløytlegge',),
'bodd': ('bo',),
'bodde': ('bo',),
'boende': ('bo',),
'bobla': ('boble',),
'boblet': ('boble',),
'bobla': ('boble',),
'boblet': ('boble',),
'bobla': ('boble',),
'boblete': ('boble',),
'boblede': ('boble',),
'boblete': ('boble',),
'boblede': ('boble',),
'bobla': ('boble',),
'boblete': ('boble',),
'boblede': ('boble',),
'boblete': ('boble',),
'boblede': ('boble',),
'boblende': ('boble',),
'bofast': ('bofast',),
'bofaste': ('bofast',),
'bofast': ('bofast',),
'boga': ('boge',),
'boget': ('boge',),
'boga': ('boge',),
'boget': ('boge',),
'boga': ('boge',),
'bogete': ('boge',),
'bogede': ('boge',),
'boga': ('boge',),
'bogete': ('boge',),
'bogede': ('boge',),
'bogende': ('boge',),
'bogeforma': ('bogeforma',),
'bogeformet': ('bogeformet',),
'bogeformete': ('bogeformet',),
'bogeformede': ('bogeformet',),
'bogeformete': ('bogeformet',),
'bogeformede': ('bogeformet',),
'bogeformet': ('bogeformet',),
'bogna': ('bogne',),
'bognet': ('bogne',),
'bogna': ('bogne',),
'bognet': ('bogne',),
'bogna': ('bogne',),
'bognete': ('bogne',),
'bognede': ('bogne',),
'bogna': ('bogne',),
'bognete': ('bogne',),
'bognede': ('bogne',),
'bognende': ('bogne',),
'boikotta': ('boikotte',),
'boikottet': ('boikotte',),
'boikotta': ('boikotte',),
'boikottet': ('boikotte',),
'boikotta': ('boikotte',),
'boikottete': ('boikotte',),
'boikottede': ('boikotte',),
'boikotta': ('boikotte',),
'boikottete': ('boikotte',),
'boikottede': ('boikotte',),
'boikottende': ('boikotte',),
'bokført': ('bokføre',),
'bokførte': ('bokføre',),
'bokførende': ('bokføre',),
'boklig': ('boklig',),
'boklige': ('boklig',),
'boklig': ('boklig',),
'bokna': ('bokne',),
'boknet': ('bokne',),
'bokna': ('bokne',),
'boknet': ('bokne',),
'bokna': ('bokne',),
'boknete': ('bokne',),
'boknede': ('bokne',),
'boknete': ('bokne',),
'boknede': ('bokne',),
'bokna': ('bokne',),
'boknete': ('bokne',),
'boknede': ('bokne',),
'boknete': ('bokne',),
'boknede': ('bokne',),
'boknende': ('bokne',),
'boksa': ('bokse',),
'bokset': ('bokse',),
'boksa': ('bokse',),
'bokset': ('bokse',),
'boksa': ('bokse',),
'boksete': ('bokse',),
'boksede': ('bokse',),
'boksa': ('bokse',),
'boksete': ('bokse',),
'boksede': ('bokse',),
'boksende': ('bokse',),
'bokstavelig': ('bokstavelig',),
'bokstavelige': ('bokstavelig',),
'bokstavelig': ('bokstavelig',),
'bokstavert': ('bokstavere',),
'bokstaverte': ('bokstavere',),
'bokstaverende': ('bokstavere',),
'bokstavrett': ('bokstavrett',),
'bokstavrette': ('bokstavrett',),
'bokstavrett': ('bokstavrett',),
'bold': ('bold',),
'bolde': ('bold',),
'boldt': ('bold',),
'bola': ('bole',),
'bolet': ('bole',),
'bolt': ('bole',),
'bola': ('bole',),
'bolet': ('bole',),
'bolt': ('bole',),
'bola': ('bole',),
'bolete': ('bole',),
'bolede': ('bole',),
'bolte': ('bole',),
'bola': ('bole',),
'bolete': ('bole',),
'bolede': ('bole',),
'bolte': ('bole',),
'bolende': ('bole',),
'boligsøkende': ('boligsøkende',),
'boliviansk': ('boliviansk',),
'bolivianske': ('boliviansk',),
'boliviansk': ('boliviansk',),
'bolna': ('bolne',),
'bolnet': ('bolne',),
'bolna': ('bolne',),
'bolnet': ('bolne',),
'bolna': ('bolne',),
'bolnete': ('bolne',),
'bolnede': ('bolne',),
'bolnete': ('bolne',),
'bolnede': ('bolne',),
'bolna': ('bolne',),
'bolnete': ('bolne',),
'bolnede': ('bolne',),
'bolnete': ('bolne',),
'bolnede': ('bolne',),
'bolnende': ('bolne',),
'bolta': ('bolte',),
'boltet': ('bolte',),
'bolta': ('bolte',),
'boltet': ('bolte',),
'bolta': ('bolte',),
'boltete': ('bolte',),
'boltede': ('bolte',),
'bolta': ('bolte',),
'boltete': ('bolte',),
'boltede': ('bolte',),
'boltende': ('bolte',),
'boltra': ('boltre',),
'boltret': ('boltre',),
'boltra': ('boltre',),
'boltret': ('boltre',),
'boltra': ('boltre',),
'boltrete': ('boltre',),
'boltrede': ('boltre',),
'boltrete': ('boltre',),
'boltrede': ('boltre',),
'boltra': ('boltre',),
'boltrete': ('boltre',),
'boltrede': ('boltre',),
'boltrete': ('boltre',),
'boltrede': ('boltre',),
'boltrende': ('boltre',),
'bombardert': ('bombardere',),
'bombarderte': ('bombardere',),
'bombarderende': ('bombardere',),
'bombastisk': ('bombastisk',),
'bombastiske': ('bombastisk',),
'bombastisk': ('bombastisk',),
'bomba': ('bombe',),
'bombet': ('bombe',),
'bomba': ('bombe',),
'bombet': ('bombe',),
'bomba': ('bombe',),
'bombete': ('bombe',),
'bombede': ('bombe',),
'bomba': ('bombe',),
'bombete': ('bombe',),
'bombede': ('bombe',),
'bombende': ('bombe',),
'bombesikker': ('bombesikker',),
'bombesikre': ('bombesikker',),
'bombesikkert': ('bombesikker',),
'bomfast': ('bomfast',),
'bomfaste': ('bomfast',),
'bomfast': ('bomfast',),
'bomma': ('bomme',),
'bommet': ('bomme',),
'bomma': ('bomme',),
'bommet': ('bomme',),
'bomma': ('bomme',),
'bommete': ('bomme',),
'bommede': ('bomme',),
'bomma': ('bomme',),
'bommete': ('bomme',),
'bommede': ('bomme',),
'bommende': ('bomme',),
'bomsterk': ('bomsterk',),
'bomsterke': ('bomsterk',),
'bomsterkt': ('bomsterk',),
'bomstille': ('bomstille',),
'bondeblå': ('bondeblå',),
'bondeblåe': ('bondeblå',),
'bondeblå': ('bondeblå',),
'bondeblåe': ('bondeblå',),
'bondeblå': ('bondeblå',),
'bondeblått': ('bondeblå',),
'bondsk': ('bondsk',),
'bondske': ('bondsk',),
'bondsk': ('bondsk',),
'bona': ('bone',),
'bonet': ('bone',),
'bont': ('bone',),
'bona': ('bone',),
'bonet': ('bone',),
'bont': ('bone',),
'bona': ('bone',),
'bonete': ('bone',),
'bonede': ('bone',),
'bonte': ('bone',),
'bona': ('bone',),
'bonete': ('bone',),
'bonede': ('bone',),
'bonte': ('bone',),
'bonende': ('bone',),
'bonga': ('bonge',),
'bonget': ('bonge',),
'bonga': ('bonge',),
'bonget': ('bonge',),
'bonga': ('bonge',),
'bongete': ('bonge',),
'bongede': ('bonge',),
'bonga': ('bonge',),
'bongete': ('bonge',),
'bongede': ('bonge',),
'bongende': ('bonge',),
'bonitert': ('bonitere',),
'boniterte': ('bonitere',),
'boniterende': ('bonitere',),
'booka': ('booke',),
'booket': ('booke',),
'booka': ('booke',),
'booket': ('booke',),
'booka': ('booke',),
'bookete': ('booke',),
'bookede': ('booke',),
'booka': ('booke',),
'bookete': ('booke',),
'bookede': ('booke',),
'bookende': ('booke',),
'boolsk': ('boolsk',),
'boolske': ('boolsk',),
'boolsk': ('boolsk',),
'borda': ('borde',),
'bordet': ('borde',),
'borda': ('borde',),
'bordet': ('borde',),
'borda': ('borde',),
'bordete': ('borde',),
'bordede': ('borde',),
'borda': ('borde',),
'bordete': ('borde',),
'bordede': ('borde',),
'bordende': ('borde',),
'bordkledd': ('bordkle',),
'bordkledde': ('bordkle',),
'bordkleende': ('bordkle',),
'bora': ('bore',),
'boret': ('bore',),
'bora': ('bore',),
'boret': ('bore',),
'bora': ('bore',),
'borete': ('bore',),
'borede': ('bore',),
'bora': ('bore',),
'borete': ('bore',),
'borede': ('bore',),
'borende': ('bore',),
'boreal': ('boreal',),
'boreale': ('boreal',),
'borealt': ('boreal',),
'borga': ('borge',),
'borget': ('borge',),
'borga': ('borge',),
'borget': ('borge',),
'borga': ('borge',),
'borgete': ('borge',),
'borgede': ('borge',),
'borga': ('borge',),
'borgete': ('borge',),
'borgede': ('borge',),
'borgende': ('borge',),
'borgerlig': ('borgerlig',),
'borgerlige': ('borgerlig',),
'borgerlig': ('borgerlig',),
'borket': ('borket',),
'borkete': ('borket',),
'borket': ('borket',),
'borkete': ('borkete',),
'bornert': ('bornert',),
'bornerte': ('bornert',),
'bornert': ('bornert',),
'bortbestilt': ('bortbestilt',),
'bortbestilte': ('bortbestilt',),
'bortbestilt': ('bortbestilt',),
'bortbygsla': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygslete': ('bortbygsle',),
'bortbygslede': ('bortbygsle',),
'bortbygslete': ('bortbygsle',),
'bortbygslede': ('bortbygsle',),
'bortbygsla': ('bortbygsle',),
'bortbygslete': ('bortbygsle',),
'bortbygslede': ('bortbygsle',),
'bortbygslete': ('bortbygsle',),
'bortbygslede': ('bortbygsle',),
'bortbygslende': ('bortbygsle',),
'borterst': ('borterst',),
'borterste': ('borterst',),
'borterst': ('borterst',),
'bortest': ('bortest',),
'borteste': ('bortest',),
'bortest': ('bortest',),
'bortfesta': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfestete': ('bortfeste',),
'bortfestede': ('bortfeste',),
'bortfesta': ('bortfeste',),
'bortfestete': ('bortfeste',),
'bortfestede': ('bortfeste',),
'bortfestende': ('bortfeste',),
'bortforklart': ('bortforklare',),
'bortforklarte': ('bortforklare',),
'bortforklarende': ('bortforklare',),
'bortfrakta': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfraktete': ('bortfrakte',),
'bortfraktede': ('bortfrakte',),
'bortfrakta': ('bortfrakte',),
'bortfraktete': ('bortfrakte',),
'bortfraktede': ('bortfrakte',),
'bortfraktende': ('bortfrakte',),
'bortført': ('bortføre',),
'bortførte': ('bortføre',),
'bortførende': ('bortføre',),
'bortgangen': ('bortgangen',),
'bortgangne': ('bortgangen',),
'bortgangent': ('bortgangen',),
'bortgjemt': ('bortgjemt',),
'bortgjemte': ('bortgjemt',),
'bortgjemt': ('bortgjemt',),
'bortgjømt': ('bortgjømt',),
'bortgjømte': ('bortgjømt',),
'bortgjømt': ('bortgjømt',),
'bortglemt': ('bortglemt',),
'bortglemte': ('bortglemt',),
'bortglemt': ('bortglemt',),
'bortglømt': ('bortglømt',),
'bortglømte': ('bortglømt',),
'bortglømt': ('bortglømt',),
'bortkasta': ('bortkasta',),
'bortkastet': ('bortkastet',),
'bortkastete': ('bortkastet',),
'bortkastede': ('bortkastet',),
'bortkastete': ('bortkastet',),
'bortkastede': ('bortkastet',),
'bortkastet': ('bortkastet',),
'bortkommen': ('bortkommen',),
'bortkomne': ('bortkommen',),
'bortkomment': ('bortkommen',),
'bortkommen': ('bortkommen',),
'bortkomne': ('bortkommen',),
'bortkommet': ('bortkommen',),
'bortkommet': ('bortkommet',),
'bortkomne': ('bortkommet',),
'bortkommet': ('bortkommet',),
'bortleda': ('bortlede',),
'bortledet': ('bortlede',),
'bortleda': ('bortlede',),
'bortledet': ('bortlede',),
'bortleda': ('bortlede',),
'bortledete': ('bortlede',),
'bortledede': ('bortlede',),
'bortleda': ('bortlede',),
'bortledete': ('bortlede',),
'bortledede': ('bortlede',),
'bortledende': ('bortlede',),
'bortleid': ('bortleid',),
'bortleide': ('bortleid',),
'bortleid': ('bortleid',),
'bortløpen': ('bortløpen',),
'bortløpne': ('bortløpen',),
'bortløpent': ('bortløpen',),
'bortre': ('bortre',),
'borterst': ('bortre',),
'borterste': ('bortre',),
'bortreist': ('bortreist',),
'bortreiste': ('bortreist',),
'bortreist': ('bortreist',),
'bortsett': ('bortse',),
'bortsette': ('bortse',),
'bortseende': ('bortse',),
'bortsatt': ('bortsette',),
'bortsatte': ('bortsette',),
'bortsettende': ('bortsette',),
'bortskjemt': ('bortskjemt',),
'bortskjemte': ('bortskjemt',),
'bortskjemt': ('bortskjemt',),
'bortødsla': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødslete': ('bortødsle',),
'bortødslede': ('bortødsle',),
'bortødsla': ('bortødsle',),
'bortødslete': ('bortødsle',),
'bortødslede': ('bortødsle',),
'bortødslende': ('bortødsle',),
'bosatt': ('bosatt',),
'bosatte': ('bosatt',),
'bosatt': ('bosatt',),
'bosatt': ('bosette',),
'bosatte': ('bosette',),
'bosettende': ('bosette',),
'bosnisk': ('bosnisk',),
'bosniske': ('bosnisk',),
'bosnisk': ('bosnisk',),
'botanisert': ('botanisere',),
'botaniserte': ('botanisere',),
'botaniserende': ('botanisere',),
'botanisk': ('botanisk',),
'botaniske': ('botanisk',),
'botanisk': ('botanisk',),
'botferdig': ('botferdig',),
'botferdige': ('botferdig',),
'botferdig': ('botferdig',),
'botlagt': ('botlegge',),
'botlagte': ('botlegge',),
'botleggende': ('botlegge',),
'botna': ('botne',),
'botnet': ('botne',),
'botna': ('botne',),
'botnet': ('botne',),
'botna': ('botne',),
'botnete': ('botne',),
'botnede': ('botne',),
'botnete': ('botne',),
'botnede': ('botne',),
'botna': ('botne',),
'botnete': ('botne',),
'botnede': ('botne',),
'botnete': ('botne',),
'botnede': ('botne',),
'botnende': ('botne',),
'botnfelt': ('botnfelle',),
'botnfelte': ('botnfelle',),
'botnfellende': ('botnfelle',),
'botnlaus': ('botnlaus',),
'botnlause': ('botnlaus',),
'botnlaust': ('botnlaus',),
'botnløs': ('botnløs',),
'botnløse': ('botnløs',),
'botnløst': ('botnløs',),
'botnskrapa': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapt': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapt': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrapete': ('botnskrape',),
'botnskrapede': ('botnskrape',),
'botnskrapte': ('botnskrape',),
'botnskrapa': ('botnskrape',),
'botnskrapete': ('botnskrape',),
'botnskrapede': ('botnskrape',),
'botnskrapte': ('botnskrape',),
'botnskrapende': ('botnskrape',),
'botswansk': ('botswansk',),
'botswanske': ('botswansk',),
'botswansk': ('botswansk',),
'bowla': ('bowle',),
'bowlet': ('bowle',),
'bowla': ('bowle',),
'bowlet': ('bowle',),
'bowla': ('bowle',),
'bowlete': ('bowle',),
'bowlede': ('bowle',),
'bowla': ('bowle',),
'bowlete': ('bowle',),
'bowlede': ('bowle',),
'bowlende': ('bowle',),
'bra': ('bra',),
'braka': ('brake',),
'braket': ('brake',),
'brakt': ('brake',),
'braka': ('brake',),
'braket': ('brake',),
'brakt': ('brake',),
'braka': ('brake',),
'brakete': ('brake',),
'brakede': ('brake',),
'brakte': ('brake',),
'braka': ('brake',),
'brakete': ('brake',),
'brakede': ('brake',),
'brakte': ('brake',),
'brakende': ('brake',),
'brakk': ('brakk',),
'brakke': ('brakk',),
'brakt': ('brakk',),
'brakka': ('brakke',),
'brakket': ('brakke',),
'brakka': ('brakke',),
'brakket': ('brakke',),
'brakka': ('brakke',),
'brakkete': ('brakke',),
'brakkede': ('brakke',),
'brakka': ('brakke',),
'brakkete': ('brakke',),
'brakkede': ('brakke',),
'brakkende': ('brakke',),
'bramansk': ('bramansk',),
'bramanske': ('bramansk',),
'bramansk': ('bramansk',),
'bramfri': ('bramfri',),
'bramfrie': ('bramfri',),
'bramfritt': ('bramfri',),
'bramfull': ('bramfull',),
'bramfulle': ('bramfull',),
'bramfullt': ('bramfull',),
'bramma': ('bramme',),
'brammet': ('bramme',),
'bramma': ('bramme',),
'brammet': ('bramme',),
'bramma': ('bramme',),
'brammete': ('bramme',),
'brammede': ('bramme',),
'bramma': ('bramme',),
'brammete': ('bramme',),
'brammede': ('bramme',),
'brammende': ('bramme',),
'brannet': ('brannet',),
'brannete': ('brannet',),
'brannet': ('brannet',),
'brannete': ('brannete',),
'brannfarlig': ('brannfarlig',),
'brannfarlige': ('brannfarlig',),
'brannfarlig': ('brannfarlig',),
'branngul': ('branngul',),
'branngule': ('branngul',),
'branngult': ('branngul',),
'brannrød': ('brannrød',),
'brannrøde': ('brannrød',),
'brannrødt': ('brannrød',),
'brannrødere': ('brannrød',),
'brannrødest': ('brannrød',),
'brannrødeste': ('brannrød',),
'brannsikker': ('brannsikker',),
'brannsikre': ('brannsikker',),
'brannsikkert': ('brannsikker',),
'brasiliansk': ('brasiliansk',),
'brasilianske': ('brasiliansk',),
'brasiliansk': ('brasiliansk',),
'braska': ('braske',),
'brasket': ('braske',),
'braska': ('braske',),
'brasket': ('braske',),
'braska': ('braske',),
'braskete': ('braske',),
'braskede': ('braske',),
'braska': ('braske',),
'braskete': ('braske',),
'braskede': ('braske',),
'braskende': ('braske',),
'bratna': ('bratne',),
'bratnet': ('bratne',),
'bratna': ('bratne',),
'bratnet': ('bratne',),
'bratna': ('bratne',),
'bratnete': ('bratne',),
'bratnede': ('bratne',),
'bratnete': ('bratne',),
'bratnede': ('bratne',),
'bratna': ('bratne',),
'bratnete': ('bratne',),
'bratnede': ('bratne',),
'bratnete': ('bratne',),
'bratnede': ('bratne',),
'bratnende': ('bratne',),
'bratt': ('bratt',),
'bratte': ('bratt',),
'bratt': ('bratt',),
'brattere': ('bratt',),
'brattest': ('bratt',),
'bratteste': ('bratt',),
'brattlendt': ('brattlendt',),
'brattlendte': ('brattlendt',),
'brattlendt': ('brattlendt',),
'brauta': ('braute',),
'brautet': ('braute',),
'brauta': ('braute',),
'brautet': ('braute',),
'brauta': ('braute',),
'brautete': ('braute',),
'brautede': ('braute',),
'brauta': ('braute',),
'brautete': ('braute',),
'brautede': ('braute',),
'brautende': ('braute',),
'brav': ('brav',),
'brave': ('brav',),
'bravt': ('brav',),
'bravere': ('brav',),
'bravest': ('brav',),
'braveste': ('brav',),
'bravert': ('bravere',),
'braverte': ('bravere',),
'braverende': ('bravere',),
'bred': ('bred',),
'brede': ('bred',),
'bredt': ('bred',),
'bredere': ('bred',),
'bredest': ('bred',),
'bredeste': ('bred',),
'bredakslet': ('bredakslet',),
'bredakslete': ('bredakslet',),
'bredakslede': ('bredakslet',),
'bredakslete': ('bredakslet',),
'bredakslede': ('bredakslet',),
'bredakslet': ('bredakslet',),
'breddfull': ('breddfull',),
'breddfulle': ('breddfull',),
'breddfullt': ('breddfull',),
'bredkinna': ('bredkinna',),
'bredkinnet': ('bredkinnet',),
'bredkinnete': ('bredkinnet',),
'bredkinnede': ('bredkinnet',),
'bredkinnete': ('bredkinnet',),
'bredkinnede': ('bredkinnet',),
'bredkinnet': ('bredkinnet',),
'bredkjefta': ('bredkjefta',),
'bredkjeftet': ('bredkjeftet',),
'bredkjeftete': ('bredkjeftet',),
'bredkjeftede': ('bredkjeftet',),
'bredkjeftete': ('bredkjeftet',),
'bredkjeftede': ('bredkjeftet',),
'bredkjeftet': ('bredkjeftet',),
'bredpanna': ('bredpanna',),
'bredpannet': ('bredpannet',),
'bredpannete': ('bredpannet',),
'bredpannede': ('bredpannet',),
'bredpannete': ('bredpannet',),
'bredpannede': ('bredpannet',),
'bredpannet': ('bredpannet',),
'bredskuldra': ('bredskuldra',),
'bredskuldret': ('bredskuldret',),
'bredskuldrete': ('bredskuldret',),
'bredskuldrede': ('bredskuldret',),
'bredskuldrete': ('bredskuldret',),
'bredskuldrede': ('bredskuldret',),
'bredskuldret': ('bredskuldret',),
'bredskåren': ('bredskåren',),
'bredskårne': ('bredskåren',),
'bredskårent': ('bredskåren',),
'bredspora': ('bredspora',),
'bredsporet': ('bredsporet',),
'bredsporete': ('bredsporet',),
'bredsporede': ('bredsporet',),
'bredsporete': ('bredsporet',),
'bredsporede': ('bredsporet',),
'bredsporet': ('bredsporet',),
'bredvokst': ('bredvokst',),
'bredvokste': ('bredvokst',),
'bredvokst': ('bredvokst',),
'bregrønn': ('bregrønn',),
'bregrønne': ('bregrønn',),
'bregrønt': ('bregrønn',),
'brei': ('brei',),
'breie': ('brei',),
'breit': ('brei',),
'breiere': ('brei',),
'breiest': ('brei',),
'breieste': ('brei',),
'breiakslet': ('breiakslet',),
'breiakslete': ('breiakslet',),
'breiakslede': ('breiakslet',),
'breiakslete': ('breiakslet',),
'breiakslede': ('breiakslet',),
'breiakslet': ('breiakslet',),
'breia': ('breie',),
'breiet': ('breie',),
'breid': ('breie',),
'breia': ('breie',),
'breiet': ('breie',),
'breid': ('breie',),
'breia': ('breie',),
'breiete': ('breie',),
'breiede': ('breie',),
'breide': ('breie',),
'breia': ('breie',),
'breiete': ('breie',),
'breiede': ('breie',),
'breide': ('breie',),
'breiende': ('breie',),
'breikinna': ('breikinna',),
'breikinnet': ('breikinnet',),
'breikinnete': ('breikinnet',),
'breikinnede': ('breikinnet',),
'breikinnete': ('breikinnet',),
'breikinnede': ('breikinnet',),
'breikinnet': ('breikinnet',),
'breikjefta': ('breikjefta',),
'breikjeftet': ('breikjeftet',),
'breikjeftete': ('breikjeftet',),
'breikjeftede': ('breikjeftet',),
'breikjeftete': ('breikjeftet',),
'breikjeftede': ('breikjeftet',),
'breikjeftet': ('breikjeftet',),
'breipanna': ('breipanna',),
'breipannet': ('breipannet',),
'breipannete': ('breipannet',),
'breipannede': ('breipannet',),
'breipannete': ('breipannet',),
'breipannede': ('breipannet',),
'breipannet': ('breipannet',),
'breiskuldra': ('breiskuldra',),
'breiskuldret': ('breiskuldret',),
'breiskuldrete': ('breiskuldret',),
'breiskuldrede': ('breiskuldret',),
'breiskuldrete': ('breiskuldret',),
'breiskuldrede': ('breiskuldret',),
'breiskuldret': ('breiskuldret',),
'breiskåren': ('breiskåren',),
'breiskårne': ('breiskåren',),
'breiskårent': ('breiskåren',),
'breispora': ('breispora',),
'breisporet': ('breisporet',),
'breisporete': ('breisporet',),
'breisporede': ('breisporet',),
'breisporete': ('breisporet',),
'breisporede': ('breisporet',),
'breisporet': ('breisporet',),
'breivokst': ('breivokst',),
'breivokste': ('breivokst',),
'breivokst': ('breivokst',),
'breka': ('breke',),
'breket': ('breke',),
'brekt': ('breke',),
'breka': ('breke',),
'breket': ('breke',),
'brekt': ('breke',),
'breka': ('breke',),
'brekete': ('breke',),
'brekede': ('breke',),
'brekte': ('breke',),
'breka': ('breke',),
'brekete': ('breke',),
'brekede': ('breke',),
'brekte': ('breke',),
'brekende': ('breke',),
'brekka': ('brekke',),
'brekket': ('brekke',),
'brekt': ('brekke',),
'brekka': ('brekke',),
'brekket': ('brekke',),
'brekt': ('brekke',),
'brekka': ('brekke',),
'brekkete': ('brekke',),
'brekkede': ('brekke',),
'brekte': ('brekke',),
'brekka': ('brekke',),
'brekkete': ('brekke',),
'brekkede': ('brekke',),
'brekte': ('brekke',),
'brekkende': ('brekke',),
'brukket': ('brekke',),
'brukken': ('brekke',),
'brukne': ('brekke',),
'brekkende': ('brekke',),
'bremma': ('bremme',),
'bremmet': ('bremme',),
'bremma': ('bremme',),
'bremmet': ('bremme',),
'bremma': ('bremme',),
'bremmete': ('bremme',),
'bremmede': ('bremme',),
'bremma': ('bremme',),
'bremmete': ('bremme',),
'bremmede': ('bremme',),
'bremmende': ('bremme',),
'bremsa': ('bremse',),
'bremset': ('bremse',),
'bremsa': ('bremse',),
'bremset': ('bremse',),
'bremsa': ('bremse',),
'bremsete': ('bremse',),
'bremsede': ('bremse',),
'bremsa': ('bremse',),
'bremsete': ('bremse',),
'bremsede': ('bremse',),
'bremsende': ('bremse',),
'brennaktuell': ('brennaktuell',),
'brennaktuelle': ('brennaktuell',),
'brennaktuelt': ('brennaktuell',),
'brennbar': ('brennbar',),
'brennbare': ('brennbar',),
'brennbart': ('brennbar',),
'brennemerka': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerkete': ('brennemerke',),
'brennemerkede': ('brennemerke',),
'brennemerka': ('brennemerke',),
'brennemerkete': ('brennemerke',),
'brennemerkede': ('brennemerke',),
'brennemerkende': ('brennemerke',),
'brennhet': ('brennhet',),
'brennhete': ('brennhet',),
'brennhett': ('brennhet',),
'brennrød': ('brennrød',),
'brennrøde': ('brennrød',),
'brennrødt': ('brennrød',),
'brennsikker': ('brennsikker',),
'brennsikre': ('brennsikker',),
'brennsikkert': ('brennsikker',),
'brennsnar': ('brennsnar',),
'brennsnare': ('brennsnar',),
'brennsnart': ('brennsnar',),
'bresert': ('bresere',),
'breserte': ('bresere',),
'breserende': ('bresere',),
'bresta': ('breste',),
'brestet': ('breste',),
'bresta': ('breste',),
'brestet': ('breste',),
'bresta': ('breste',),
'brestete': ('breste',),
'brestede': ('breste',),
'bresta': ('breste',),
'brestete': ('breste',),
'brestede': ('breste',),
'brestende': ('breste',),
'bretagnsk': ('bretagnsk',),
'bretagnske': ('bretagnsk',),
'bretagnsk': ('bretagnsk',),
'bretonsk': ('bretonsk',),
'bretonske': ('bretonsk',),
'bretonsk': ('bretonsk',),
'bretta': ('brette',),
'brettet': ('brette',),
'bretta': ('brette',),
'brettet': ('brette',),
'bretta': ('brette',),
'brettete': ('brette',),
'brettede': ('brette',),
'bretta': ('brette',),
'brettete': ('brette',),
'brettede': ('brette',),
'brettende': ('brette',),
'brettsegla': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettseglete': ('brettsegle',),
'brettseglede': ('brettsegle',),
'brettseglete': ('brettsegle',),
'brettseglede': ('brettsegle',),
'brettsegla': ('brettsegle',),
'brettseglete': ('brettsegle',),
'brettseglede': ('brettsegle',),
'brettseglete': ('brettsegle',),
'brettseglede': ('brettsegle',),
'brettseglende': ('brettsegle',),
'brettseilt': ('brettseile',),
'brettseilte': ('brettseile',),
'brettseilende': ('brettseile',),
'brevveksla': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevvekslete': ('brevveksle',),
'brevvekslede': ('brevveksle',),
'brevvekslete': ('brevveksle',),
'brevvekslede': ('brevveksle',),
'brevveksla': ('brevveksle',),
'brevvekslete': ('brevveksle',),
'brevvekslede': ('brevveksle',),
'brevvekslete': ('brevveksle',),
'brevvekslede': ('brevveksle',),
'brevvekslende': ('brevveksle',),
'brifa': ('brife',),
'brifet': ('brife',),
'brifa': ('brife',),
'brifet': ('brife',),
'brifa': ('brife',),
'brifete': ('brife',),
'brifede': ('brife',),
'brifa': ('brife',),
'brifete': ('brife',),
'brifede': ('brife',),
'brifende': ('brife',),
'brikettert': ('brikettere',),
'briketterte': ('brikettere',),
'briketterende': ('brikettere',),
'briljant': ('briljant',),
'briljante': ('briljant',),
'briljant': ('briljant',),
'briljert': ('briljere',),
'briljerte': ('briljere',),
'briljerende': ('briljere',),
'brillefin': ('brillefin',),
'brillefine': ('brillefin',),
'brillefint': ('brillefin',),
'brakt': ('bringe',),
'brakte': ('bringe',),
'bringende': ('bringe',),
'bringebred': ('bringebred',),
'bringebrede': ('bringebred',),
'bringebredt': ('bringebred',),
'bringebrei': ('bringebrei',),
'bringebreie': ('bringebrei',),
'bringebreit': ('bringebrei',),
'brisant': ('brisant',),
'brisante': ('brisant',),
'brisant': ('brisant',),
'brist': ('brise',),
'briste': ('brise',),
'brisende': ('brise',),
'brisen': ('brisen',),
'brisne': ('brisen',),
'brisent': ('brisen',),
'briska': ('briske',),
'brisket': ('briske',),
'briska': ('briske',),
'brisket': ('briske',),
'briska': ('briske',),
'briskete': ('briske',),
'briskede': ('briske',),
'briska': ('briske',),
'briskete': ('briske',),
'briskede': ('briske',),
'briskende': ('briske',),
'bristet': ('briste',),
'bristen': ('briste',),
'bristne': ('briste',),
'bristende': ('briste',),
'bristeferdig': ('bristeferdig',),
'bristeferdige': ('bristeferdig',),
'bristeferdig': ('bristeferdig',),
'bristfeldig': ('bristfeldig',),
'bristfeldige': ('bristfeldig',),
'bristfeldig': ('bristfeldig',),
'britannisk': ('britannisk',),
'britanniske': ('britannisk',),
'britannisk': ('britannisk',),
'britisk': ('britisk',),
'britiske': ('britisk',),
'britisk': ('britisk',),
'brittonsk': ('brittonsk',),
'brittonske': ('brittonsk',),
'brittonsk': ('brittonsk',),
'brodda': ('brodde',),
'broddet': ('brodde',),
'brodda': ('brodde',),
'broddet': ('brodde',),
'brodda': ('brodde',),
'broddete': ('brodde',),
'broddede': ('brodde',),
'brodda': ('brodde',),
'broddete': ('brodde',),
'broddede': ('brodde',),
'broddende': ('brodde',),
'brodden': ('brodden',),
'brodne': ('brodden',),
'broddent': ('brodden',),
'brodert': ('brodere',),
'broderte': ('brodere',),
'broderende': ('brodere',),
'broderlig': ('broderlig',),
'broderlige': ('broderlig',),
'broderlig': ('broderlig',),
'broket': ('broket',),
'brokete': ('broket',),
'broket': ('broket',),
'brokete': ('brokete',),
'brokksjuk': ('brokksjuk',),
'brokksjuke': ('brokksjuk',),
'brokksjukt': ('brokksjuk',),
'brokksyk': ('brokksyk',),
'brokksyke': ('brokksyk',),
'brokksykt': ('brokksyk',),
'brolagt': ('brolegge',),
'brolagte': ('brolegge',),
'broleggende': ('brolegge',),
'bronkial': ('bronkial',),
'bronkiale': ('bronkial',),
'bronkialt': ('bronkial',),
'bronkittisk': ('bronkittisk',),
'bronkittiske': ('bronkittisk',),
'bronkittisk': ('bronkittisk',),
'bronsa': ('bronse',),
'bronset': ('bronse',),
'bronsa': ('bronse',),
'bronset': ('bronse',),
'bronsa': ('bronse',),
'bronsete': ('bronse',),
'bronsede': ('bronse',),
'bronsa': ('bronse',),
'bronsete': ('bronse',),
'bronsede': ('bronse',),
'bronsende': ('bronse',),
'bronsebrun': ('bronsebrun',),
'bronsebrune': ('bronsebrun',),
'bronsebrunt': ('bronsebrun',),
'bronsert': ('bronsere',),
'bronserte': ('bronsere',),
'bronserende': ('bronsere',),
'brosjert': ('brosjere',),
'brosjerte': ('brosjere',),
'brosjerende': ('brosjere',),
'brotna': ('brotne',),
'brotnet': ('brotne',),
'brotna': ('brotne',),
'brotnet': ('brotne',),
'brotna': ('brotne',),
'brotnete': ('brotne',),
'brotnede': ('brotne',),
'brotnete': ('brotne',),
'brotnede': ('brotne',),
'brotna': ('brotne',),
'brotnete': ('brotne',),
'brotnede': ('brotne',),
'brotnete': ('brotne',),
'brotnede': ('brotne',),
'brotnende': ('brotne',),
'brotsja': ('brotsje',),
'brotsjet': ('brotsje',),
'brotsja': ('brotsje',),
'brotsjet': ('brotsje',),
'brotsja': ('brotsje',),
'brotsjete': ('brotsje',),
'brotsjede': ('brotsje',),
'brotsja': ('brotsje',),
'brotsjete': ('brotsje',),
'brotsjede': ('brotsje',),
'brotsjende': ('brotsje',),
'brottfast': ('brottfast',),
'brottfaste': ('brottfast',),
'brottfast': ('brottfast',),
'brudden': ('brudden',),
'brudne': ('brudden',),
'bruddent': ('brudden',),
'bruddfast': ('bruddfast',),
'bruddfaste': ('bruddfast',),
'bruddfast': ('bruddfast',),
'brukbar': ('brukbar',),
'brukbare': ('brukbar',),
'brukbart': ('brukbar',),
'brukt': ('bruke',),
'brukte': ('bruke',),
'brukende': ('bruke',),
'brukelig': ('brukelig',),
'brukelige': ('brukelig',),
'brukelig': ('brukelig',),
'brukervennlig': ('brukervennlig',),
'brukervennlige': ('brukervennlig',),
'brukervennlig': ('brukervennlig',),
'brukken': ('brukken',),
'brukne': ('brukken',),
'brukket': ('brukken',),
'brukket': ('brukket',),
'brukne': ('brukket',),
'brukket': ('brukket',),
'brukt': ('brukt',),
'brukte': ('brukt',),
'brukt': ('brukt',),
'brulagt': ('brulegge',),
'brulagte': ('brulegge',),
'bruleggende': ('brulegge',),
'brumla': ('brumle',),
'brumlet': ('brumle',),
'brumla': ('brumle',),
'brumlet': ('brumle',),
'brumla': ('brumle',),
'brumlete': ('brumle',),
'brumlede': ('brumle',),
'brumlete': ('brumle',),
'brumlede': ('brumle',),
'brumla': ('brumle',),
'brumlete': ('brumle',),
'brumlede': ('brumle',),
'brumlete': ('brumle',),
'brumlede': ('brumle',),
'brumlende': ('brumle',),
'brumma': ('brumme',),
'brummet': ('brumme',),
'brumma': ('brumme',),
'brummet': ('brumme',),
'brumma': ('brumme',),
'brummete': ('brumme',),
'brummede': ('brumme',),
'brumma': ('brumme',),
'brummete': ('brumme',),
'brummede': ('brumme',),
'brummende': ('brumme',),
'brun': ('brun',),
'brune': ('brun',),
'brunt': ('brun',),
'brunere': ('brun',),
'brunest': ('brun',),
'bruneste': ('brun',),
'brunbarka': ('brunbarka',),
'brunbarket': ('brunbarket',),
'brunbarkete': ('brunbarket',),
'brunbarkede': ('brunbarket',),
'brunbarkete': ('brunbarket',),
'brunbarkede': ('brunbarket',),
'brunbarket': ('brunbarket',),
'bruna': ('brune',),
'brunet': ('brune',),
'bruna': ('brune',),
'brunet': ('brune',),
'bruna': ('brune',),
'brunete': ('brune',),
'brunede': ('brune',),
'bruna': ('brune',),
'brunete': ('brune',),
'brunede': ('brune',),
'brunende': ('brune',),
'bruneisk': ('bruneisk',),
'bruneiske': ('bruneisk',),
'bruneisk': ('bruneisk',),
'brunlig': ('brunlig',),
'brunlige': ('brunlig',),
'brunlig': ('brunlig',),
'brunsteikt': ('brunsteike',),
'brunsteikte': ('brunsteike',),
'brunsteikende': ('brunsteike',),
'brunstekt': ('brunsteke',),
'brunstekte': ('brunsteke',),
'brunstekende': ('brunsteke',),
'brunstig': ('brunstig',),
'brunstige': ('brunstig',),
'brunstig': ('brunstig',),
'brunøyd': ('brunøyd',),
'brunøyde': ('brunøyd',),
'brunøyd': ('brunøyd',),
'brust': ('bruse',),
'bruste': ('bruse',),
'brusende': ('bruse',),
'brusten': ('brusten',),
'brustne': ('brusten',),
'brustent': ('brusten',),
'brutal': ('brutal',),
'brutale': ('brutal',),
'brutalt': ('brutal',),
'brutalisert': ('brutalisere',),
'brutaliserte': ('brutalisere',),
'brutaliserende': ('brutalisere',),
'brutto': ('brutto',),
'brydd': ('bry',),
'brydde': ('bry',),
'bryende': ('bry',),
'brydd': ('brydd',),
'brydde': ('brydd',),
'brydd': ('brydd',),
'brydda': ('brydde',),
'bryddet': ('brydde',),
'brydda': ('brydde',),
'bryddet': ('brydde',),
'brydda': ('brydde',),
'bryddete': ('brydde',),
'bryddede': ('brydde',),
'brydda': ('brydde',),
'bryddete': ('brydde',),
'bryddede': ('brydde',),
'bryddende': ('brydde',),
'brygga': ('brygge',),
'brygget': ('brygge',),
'brygga': ('brygge',),
'brygget': ('brygge',),
'brygga': ('brygge',),
'bryggete': ('brygge',),
'bryggede': ('brygge',),
'brygga': ('brygge',),
'bryggete': ('brygge',),
'bryggede': ('brygge',),
'bryggende': ('brygge',),
'brynt': ('bryne',),
'brynte': ('bryne',),
'brynende': ('bryne',),
'bryologisk': ('bryologisk',),
'bryologiske': ('bryologisk',),
'bryologisk': ('bryologisk',),
'brysk': ('brysk',),
'bryske': ('brysk',),
'bryskt': ('brysk',),
'bryskere': ('brysk',),
'bryskest': ('brysk',),
'bryskeste': ('brysk',),
'bryska': ('bryske',),
'brysket': ('bryske',),
'bryska': ('bryske',),
'brysket': ('bryske',),
'bryska': ('bryske',),
'bryskete': ('bryske',),
'bryskede': ('bryske',),
'bryska': ('bryske',),
'bryskete': ('bryske',),
'bryskede': ('bryske',),
'bryskende': ('bryske',),
'brysom': ('brysom',),
'brysomme': ('brysom',),
'brysomt': ('brysom',),
'brysommere': ('brysom',),
'brysomst': ('brysom',),
'brysomste': ('brysom',),
'brysta': ('bryste',),
'brystet': ('bryste',),
'brysta': ('bryste',),
'brystet': ('bryste',),
'brysta': ('bryste',),
'brystete': ('bryste',),
'brystede': ('bryste',),
'brysta': ('bryste',),
'brystete': ('bryste',),
'brystede': ('bryste',),
'brystende': ('bryste',),
'brytbar': ('brytbar',),
'brytbare': ('brytbar',),
'brytbart': ('brytbar',),
'brutt': ('bryte',),
'brutte': ('bryte',),
'brytende': ('bryte',),
'brå': ('brå',),
'bråe': ('brå',),
'brå': ('brå',),
'bråe': ('brå',),
'brå': ('brå',),
'brått': ('brå',),
'bråere': ('brå',),
'bråest': ('brå',),
'bråeste': ('brå',),
'bråbremsa': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremsete': ('bråbremse',),
'bråbremsede': ('bråbremse',),
'bråbremsa': ('bråbremse',),
'bråbremsete': ('bråbremse',),
'bråbremsede': ('bråbremse',),
'bråbremsende': ('bråbremse',),
'brådjup': ('brådjup',),
'brådjupe': ('brådjup',),
'brådjupt': ('brådjup',),
'brådyp': ('brådyp',),
'brådype': ('brådyp',),
'brådypt': ('brådyp',),
'bråka': ('bråke',),
'bråket': ('bråke',),
'bråkt': ('bråke',),
'bråka': ('bråke',),
'bråket': ('bråke',),
'bråkt': ('bråke',),
'bråka': ('bråke',),
'bråkete': ('bråke',),
'bråkede': ('bråke',),
'bråkte': ('bråke',),
'bråka': ('bråke',),
'bråkete': ('bråke',),
'bråkede': ('bråke',),
'bråkte': ('bråke',),
'bråkende': ('bråke',),
'bråket': ('bråket',),
'bråkete': ('bråket',),
'bråket': ('bråket',),
'bråkete': ('bråkete',),
'bråkjekk': ('bråkjekk',),
'bråkjekke': ('bråkjekk',),
'bråkjekt': ('bråkjekk',),
'bråmoden': ('bråmoden',),
'bråmodne': ('bråmoden',),
'bråmodent': ('bråmoden',),
'bråna': ('bråne',),
'brånet': ('bråne',),
'brånt': ('bråne',),
'bråna': ('bråne',),
'brånet': ('bråne',),
'brånt': ('bråne',),
'bråna': ('bråne',),
'brånete': ('bråne',),
'brånede': ('bråne',),
'brånte': ('bråne',),
'bråna': ('bråne',),
'brånete': ('bråne',),
'brånede': ('bråne',),
'brånte': ('bråne',),
'brånende': ('bråne',),
'bråsinna': ('bråsinna',),
'bråsint': ('bråsint',),
'bråsinte': ('bråsint',),
'bråsint': ('bråsint',),
'bråvakker': ('bråvakker',),
'bråvakre': ('bråvakker',),
'bråvakkert': ('bråvakker',),
'brødefull': ('brødefull',),
'brødefulle': ('brødefull',),
'brødefullt': ('brødefull',),
'brødfødd': ('brødfø',),
'brødfødde': ('brødfø',),
'brødføende': ('brødfø',),
'brødlaus': ('brødlaus',),
'brødlause': ('brødlaus',),
'brødlaust': ('brødlaus',),
'brødløs': ('brødløs',),
'brødløse': ('brødløs',),
'brødløst': ('brødløs',),
'brølt': ('brøle',),
'brølte': ('brøle',),
'brølende': ('brøle',),
'brøstfeldig': ('brøstfeldig',),
'brøstfeldige': ('brøstfeldig',),
'brøstfeldig': ('brøstfeldig',),
'brøstholden': ('brøstholden',),
'brøstholdne': ('brøstholden',),
'brøstholdent': ('brøstholden',),
'brøyta': ('brøyte',),
'brøytet': ('brøyte',),
'brøyta': ('brøyte',),
'brøytet': ('brøyte',),
'brøyta': ('brøyte',),
'brøytete': ('brøyte',),
'brøytede': ('brøyte',),
'brøyta': ('brøyte',),
'brøytete': ('brøyte',),
'brøytede': ('brøyte',),
'brøytende': ('brøyte',),
'budd': ('bu',),
'budde': ('bu',),
'buende': ('bu',),
'bua': ('bua',),
'buddhistisk': ('buddhistisk',),
'buddhistiske': ('buddhistisk',),
'buddhistisk': ('buddhistisk',),
'buden': ('buden',),
'budne': ('buden',),
'budent': ('buden',),
'budsendt': ('budsende',),
'budsendte': ('budsende',),
'budsendende': ('budsende',),
'budsjettert': ('budsjettere',),
'budsjetterte': ('budsjettere',),
'budsjetterende': ('budsjettere',),
'bua': ('bue',),
'buet': ('bue',),
'bua': ('bue',),
'buet': ('bue',),
'bua': ('bue',),
'buete': ('bue',),
'buede': ('bue',),
'bua': ('bue',),
'buete': ('bue',),
'buede': ('bue',),
'buende': ('bue',),
'bueforma': ('bueforma',),
'bueformet': ('bueformet',),
'bueformete': ('bueformet',),
'bueformede': ('bueformet',),
'bueformete': ('bueformet',),
'bueformede': ('bueformet',),
'bueformet': ('bueformet',),
'buet': ('buet',),
'buete': ('buet',),
'buede': ('buet',),
'buete': ('buet',),
'buede': ('buet',),
'buet': ('buet',),
'bufast': ('bufast',),
'bufaste': ('bufast',),
'bufast': ('bufast',),
'bugna': ('bugne',),
'bugnet': ('bugne',),
'bugna': ('bugne',),
'bugnet': ('bugne',),
'bugna': ('bugne',),
'bugnete': ('bugne',),
'bugnede': ('bugne',),
'bugna': ('bugne',),
'bugnete': ('bugne',),
'bugnede': ('bugne',),
'bugnende': ('bugne',),
'bukka': ('bukke',),
'bukket': ('bukke',),
'bukka': ('bukke',),
'bukket': ('bukke',),
'bukka': ('bukke',),
'bukkete': ('bukke',),
'bukkede': ('bukke',),
'bukka': ('bukke',),
'bukkete': ('bukke',),
'bukkede': ('bukke',),
'bukkende': ('bukke',),
'buklanda': ('buklande',),
'buklandet': ('buklande',),
'buklanda': ('buklande',),
'buklandet': ('buklande',),
'buklanda': ('buklande',),
'buklandete': ('buklande',),
'buklandede': ('buklande',),
'buklanda': ('buklande',),
'buklandete': ('buklande',),
'buklandede': ('buklande',),
'buklandende': ('buklande',),
'buklet': ('buklet',),
'buklete': ('buklet',),
'buklet': ('buklet',),
'buklete': ('buklete',),
'bukolisk': ('bukolisk',),
'bukoliske': ('bukolisk',),
'bukolisk': ('bukolisk',),
'buksert': ('buksere',),
'bukserte': ('buksere',),
'bukserende': ('buksere',),
'bukta': ('bukte',),
'buktet': ('bukte',),
'bukta': ('bukte',),
'buktet': ('bukte',),
'bukta': ('bukte',),
'buktete': ('bukte',),
'buktede': ('bukte',),
'bukta': ('bukte',),
'buktete': ('bukte',),
'buktede': ('bukte',),
'buktende': ('bukte',),
'buktet': ('buktet',),
'buktete': ('buktet',),
'buktet': ('buktet',),
'buktete': ('buktete',),
'buldra': ('buldre',),
'buldret': ('buldre',),
'buldra': ('buldre',),
'buldret': ('buldre',),
'buldra': ('buldre',),
'buldrete': ('buldre',),
'buldrede': ('buldre',),
'buldrete': ('buldre',),
'buldrede': ('buldre',),
'buldra': ('buldre',),
'buldrete': ('buldre',),
'buldrede': ('buldre',),
'buldrete': ('buldre',),
'buldrede': ('buldre',),
'buldrende': ('buldre',),
'bula': ('bule',),
'bulet': ('bule',),
'bult': ('bule',),
'bula': ('bule',),
'bulet': ('bule',),
'bult': ('bule',),
'bula': ('bule',),
'bulete': ('bule',),
'bulede': ('bule',),
'bulte': ('bule',),
'bula': ('bule',),
'bulete': ('bule',),
'bulede': ('bule',),
'bulte': ('bule',),
'bulende': ('bule',),
'bulet': ('bulet',),
'bulete': ('bulet',),
'bulet': ('bulet',),
'bulete': ('bulete',),
'bulgarsk': ('bulgarsk',),
'bulgarske': ('bulgarsk',),
'bulgarsk': ('bulgarsk',),
'bulka': ('bulke',),
'bulket': ('bulke',),
'bulka': ('bulke',),
'bulket': ('bulke',),
'bulka': ('bulke',),
'bulkete': ('bulke',),
'bulkede': ('bulke',),
'bulka': ('bulke',),
'bulkete': ('bulke',),
'bulkede': ('bulke',),
'bulkende': ('bulke',),
'bulket': ('bulket',),
'bulkete': ('bulket',),
'bulket': ('bulket',),
'bulkete': ('bulkete',),
'bulna': ('bulne',),
'bulnet': ('bulne',),
'bulna': ('bulne',),
'bulnet': ('bulne',),
'bulna': ('bulne',),
'bulnete': ('bulne',),
'bulnede': ('bulne',),
'bulnete': ('bulne',),
'bulnede': ('bulne',),
'bulna': ('bulne',),
'bulnete': ('bulne',),
'bulnede': ('bulne',),
'bulnete': ('bulne',),
'bulnede': ('bulne',),
'bulnende': ('bulne',),
'bumsa': ('bumse',),
'bumset': ('bumse',),
'bumsa': ('bumse',),
'bumset': ('bumse',),
'bumsa': ('bumse',),
'bumsete': ('bumse',),
'bumsede': ('bumse',),
'bumsa': ('bumse',),
'bumsete': ('bumse',),
'bumsede': ('bumse',),
'bumsende': ('bumse',),
'bumset': ('bumset',),
'bumsete': ('bumset',),
'bumset': ('bumset',),
'bumsete': ('bumsete',),
'bunadkledd': ('bunadkledd',),
'bunadkledde': ('bunadkledd',),
'bunadkledd': ('bunadkledd',),
'bunadskledd': ('bunadskledd',),
'bunadskledde': ('bunadskledd',),
'bunadskledd': ('bunadskledd',),
'bunden': ('bunden',),
'bundne': ('bunden',),
'bundet': ('bunden',),
'bundet': ('bundet',),
'bundne': ('bundet',),
'bundet': ('bundet',),
'bundsforvandt': ('bundsforvandt',),
'bundsforvandte': ('bundsforvandt',),
'bundsforvandt': ('bundsforvandt',),
'bunka': ('bunke',),
'bunket': ('bunke',),
'bunka': ('bunke',),
'bunket': ('bunke',),
'bunka': ('bunke',),
'bunkete': ('bunke',),
'bunkede': ('bunke',),
'bunka': ('bunke',),
'bunkete': ('bunke',),
'bunkede': ('bunke',),
'bunkende': ('bunke',),
'bunkra': ('bunkre',),
'bunkret': ('bunkre',),
'bunkra': ('bunkre',),
'bunkret': ('bunkre',),
'bunkra': ('bunkre',),
'bunkrete': ('bunkre',),
'bunkrede': ('bunkre',),
'bunkrete': ('bunkre',),
'bunkrede': ('bunkre',),
'bunkra': ('bunkre',),
'bunkrete': ('bunkre',),
'bunkrede': ('bunkre',),
'bunkrete': ('bunkre',),
'bunkrede': ('bunkre',),
'bunkrende': ('bunkre',),
'bunnfalsk': ('bunnfalsk',),
'bunnfalske': ('bunnfalsk',),
'bunnfalskt': ('bunnfalsk',),
'bunnfelt': ('bunnfelle',),
'bunnfelte': ('bunnfelle',),
'bunnfellende': ('bunnfelle',),
'bunnhederlig': ('bunnhederlig',),
'bunnhederlige': ('bunnhederlig',),
'bunnhederlig': ('bunnhederlig',),
'bunnlaus': ('bunnlaus',),
'bunnlause': ('bunnlaus',),
'bunnlaust': ('bunnlaus',),
'bunnløs': ('bunnløs',),
'bunnløse': ('bunnløs',),
'bunnløst': ('bunnløs',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapt': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapt': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapete': ('bunnskrape',),
'bunnskrapede': ('bunnskrape',),
'bunnskrapte': ('bunnskrape',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapete': ('bunnskrape',),
'bunnskrapede': ('bunnskrape',),
'bunnskrapte': ('bunnskrape',),
'bunnskrapende': ('bunnskrape',),
'bunnsolid': ('bunnsolid',),
'bunnsolide': ('bunnsolid',),
'bunnsolid': ('bunnsolid',),
'bunta': ('bunte',),
'buntet': ('bunte',),
'bunta': ('bunte',),
'buntet': ('bunte',),
'bunta': ('bunte',),
'buntete': ('bunte',),
'buntede': ('bunte',),
'bunta': ('bunte',),
'buntete': ('bunte',),
'buntede': ('bunte',),
'buntende': ('bunte',),
'bura': ('bure',),
'buret': ('bure',),
'burt': ('bure',),
'bura': ('bure',),
'buret': ('bure',),
'burt': ('bure',),
'bura': ('bure',),
'burete': ('bure',),
'burede': ('bure',),
'burte': ('bure',),
'bura': ('bure',),
'burete': ('bure',),
'burede': ('bure',),
'burte': ('bure',),
'burende': ('bure',),
'burgunderrød': ('burgunderrød',),
'burgunderrøde': ('burgunderrød',),
'burgunderrødt': ('burgunderrød',),
'burgundisk': ('burgundisk',),
'burgundiske': ('burgundisk',),
'burgundisk': ('burgundisk',),
'burjatisk': ('burjatisk',),
'burjatiske': ('burjatisk',),
'burjatisk': ('burjatisk',),
'burkinsk': ('burkinsk',),
'burkinske': ('burkinsk',),
'burkinsk': ('burkinsk',),
'burlesk': ('burlesk',),
'burleske': ('burlesk',),
'burlesk': ('burlesk',),
'bursjikos': ('bursjikos',),
'bursjikose': ('bursjikos',),
'bursjikos': ('bursjikos',),
'burundisk': ('burundisk',),
'burundiske': ('burundisk',),
'burundisk': ('burundisk',),
'busatt': ('busatt',),
'busatte': ('busatt',),
'busatt': ('busatt',),
'busa': ('buse',),
'buset': ('buse',),
'bust': ('buse',),
'busa': ('buse',),
'buset': ('buse',),
'bust': ('buse',),
'busa': ('buse',),
'busete': ('buse',),
'busede': ('buse',),
'buste': ('buse',),
'busa': ('buse',),
'busete': ('buse',),
'busede': ('buse',),
'buste': ('buse',),
'busende': ('buse',),
'busatt': ('busette',),
'busatte': ('busette',),
'busettende': ('busette',),
'buska': ('buske',),
'busket': ('buske',),
'buska': ('buske',),
'busket': ('buske',),
'buska': ('buske',),
'buskete': ('buske',),
'buskede': ('buske',),
'buska': ('buske',),
'buskete': ('buske',),
'buskede': ('buske',),
'buskende': ('buske',),
'busket': ('busket',),
'buskete': ('busket',),
'busket': ('busket',),
'buskete': ('buskete',),
'bussa': ('busse',),
'busset': ('busse',),
'bussa': ('busse',),
'busset': ('busse',),
'bussa': ('busse',),
'bussete': ('busse',),
'bussede': ('busse',),
'bussa': ('busse',),
'bussete': ('busse',),
'bussede': ('busse',),
'bussende': ('busse',),
'busta': ('buste',),
'bustet': ('buste',),
'busta': ('buste',),
'bustet': ('buste',),
'busta': ('buste',),
'bustete': ('buste',),
'bustede': ('buste',),
'busta': ('buste',),
'bustete': ('buste',),
'bustede': ('buste',),
'bustende': ('buste',),
'bustet': ('bustet',),
'bustete': ('bustet',),
'bustet': ('bustet',),
'bustete': ('bustete',),
'butt': ('butt',),
'butte': ('butt',),
'butt': ('butt',),
'buttere': ('butt',),
'buttest': ('butt',),
'butteste': ('butt',),
'butta': ('butte',),
'buttet': ('butte',),
'butta': ('butte',),
'buttet': ('butte',),
'butta': ('butte',),
'buttete': ('butte',),
'buttede': ('butte',),
'butta': ('butte',),
'buttete': ('butte',),
'buttede': ('butte',),
'buttende': ('butte',),
'buttet': ('buttet',),
'buttete': ('buttet',),
'buttet': ('buttet',),
'buttete': ('buttete',),
'bydd': ('by',),
'budt': ('by',),
'bydd': ('by',),
'budt': ('by',),
'bydd': ('by',),
'bydde': ('by',),
'budte': ('by',),
'bydde': ('by',),
'budte': ('by',),
'bydde': ('by',),
'byende': ('by',),
'bydd': ('byde',),
'budt': ('byde',),
'bydd': ('byde',),
'budt': ('byde',),
'bydd': ('byde',),
'bydde': ('byde',),
'budte': ('byde',),
'bydde': ('byde',),
'budte': ('byde',),
'bydde': ('byde',),
'bydende': ('byde',),
'bydende': ('bydende',),
'byget': ('byget',),
'bygete': ('byget',),
'byget': ('byget',),
'bygete': ('bygete',),
'bygget': ('bygge',),
'bygd': ('bygge',),
'bygget': ('bygge',),
'bygd': ('bygge',),
'byggete': ('bygge',),
'byggede': ('bygge',),
'bygde': ('bygge',),
'byggete': ('bygge',),
'byggede': ('bygge',),
'bygde': ('bygge',),
'byggende': ('bygge',),
'byggeklar': ('byggeklar',),
'byggeklare': ('byggeklar',),
'byggeklart': ('byggeklar',),
'bygsla': ('bygsle',),
'bygslet': ('bygsle',),
'bygsla': ('bygsle',),
'bygslet': ('bygsle',),
'bygsla': ('bygsle',),
'bygslete': ('bygsle',),
'bygslede': ('bygsle',),
'bygslete': ('bygsle',),
'bygslede': ('bygsle',),
'bygsla': ('bygsle',),
'bygslete': ('bygsle',),
'bygslede': ('bygsle',),
'bygslete': ('bygsle',),
'bygslede': ('bygsle',),
'bygslende': ('bygsle',),
'bykst': ('bykse',),
'bykste': ('bykse',),
'byksende': ('bykse',),
'bylta': ('bylte',),
'byltet': ('bylte',),
'bylta': ('bylte',),
'byltet': ('bylte',),
'bylta': ('bylte',),
'byltete': ('bylte',),
'byltede': ('bylte',),
'bylta': ('bylte',),
'byltete': ('bylte',),
'byltede': ('bylte',),
'byltende': ('bylte',),
'bymessig': ('bymessig',),
'bymessige': ('bymessig',),
'bymessig': ('bymessig',),
'byrdefull': ('byrdefull',),
'byrdefulle': ('byrdefull',),
'byrdefullt': ('byrdefull',),
'byrg': ('byrg',),
'byrge': ('byrg',),
'byrgt': ('byrg',),
'byråkratisert': ('byråkratisere',),
'byråkratiserte': ('byråkratisere',),
'byråkratiserende': ('byråkratisere',),
'byråkratisk': ('byråkratisk',),
'byråkratiske': ('byråkratisk',),
'byråkratisk': ('byråkratisk',),
'bysantinsk': ('bysantinsk',),
'bysantinske': ('bysantinsk',),
'bysantinsk': ('bysantinsk',),
'byssa': ('bysse',),
'bysset': ('bysse',),
'byssa': ('bysse',),
'bysset': ('bysse',),
'byssa': ('bysse',),
'byssete': ('bysse',),
'byssede': ('bysse',),
'byssa': ('bysse',),
'byssete': ('bysse',),
'byssede': ('bysse',),
'byssende': ('bysse',),
'bytta': ('bytte',),
'byttet': ('bytte',),
'bytta': ('bytte',),
'byttet': ('bytte',),
'bytta': ('bytte',),
'byttete': ('bytte',),
'byttede': ('bytte',),
'bytta': ('bytte',),
'byttete': ('bytte',),
'byttede': ('bytte',),
'byttende': ('bytte',),
'byttelånt': ('byttelåne',),
'byttelånte': ('byttelåne',),
'byttelånende': ('byttelåne',),
'båndlagt': ('båndlegge',),
'båndlagte': ('båndlegge',),
'båndleggende': ('båndlegge',),
'båra': ('båre',),
'båret': ('båre',),
'båra': ('båre',),
'båret': ('båre',),
'båra': ('båre',),
'bårete': ('båre',),
'bårede': ('båre',),
'båra': ('båre',),
'bårete': ('båre',),
'bårede': ('båre',),
'bårende': ('båre',),
'båtvant': ('båtvant',),
'båtvante': ('båtvant',),
'båtvant': ('båtvant',),
'bærbar': ('bærbar',),
'bærbare': ('bærbar',),
'bærbart': ('bærbar',),
'bærekraftig': ('bærekraftig',),
'bærekraftige': ('bærekraftig',),
'bærekraftig': ('bærekraftig',),
'bæsja': ('bæsje',),
'bæsjet': ('bæsje',),
'bæsja': ('bæsje',),
'bæsjet': ('bæsje',),
'bæsja': ('bæsje',),
'bæsjete': ('bæsje',),
'bæsjede': ('bæsje',),
'bæsja': ('bæsje',),
'bæsjete': ('bæsje',),
'bæsjede': ('bæsje',),
'bæsjende': ('bæsje',),
'bøhmisk': ('bøhmisk',),
'bøhmiske': ('bøhmisk',),
'bøhmisk': ('bøhmisk',),
'bølga': ('bølge',),
'bølget': ('bølge',),
'bølga': ('bølge',),
'bølget': ('bølge',),
'bølga': ('bølge',),
'bølgete': ('bølge',),
'bølgede': ('bølge',),
'bølga': ('bølge',),
'bølgete': ('bølge',),
'bølgede': ('bølge',),
'bølgende': ('bølge',),
'bøllet': ('bøllet',),
'bøllete': ('bøllet',),
'bøllet': ('bøllet',),
'bøllete': ('bøllete',),
'bønnfalt': ('bønnfalle',),
'bønnfalte': ('bønnfalle',),
'bønnfallende': ('bønnfalle',),
'bønnhørt': ('bønnhøre',),
'bønnhørte': ('bønnhøre',),
'bønnhørende': ('bønnhøre',),
'bønnlig': ('bønnlig',),
'bønnlige': ('bønnlig',),
'bønnlig': ('bønnlig',),
'børsa': ('børse',),
'børset': ('børse',),
'børsa': ('børse',),
'børset': ('børse',),
'børsa': ('børse',),
'børsete': ('børse',),
'børsede': ('børse',),
'børsa': ('børse',),
'børsete': ('børse',),
'børsede': ('børse',),
'børsende': ('børse',),
'børsnotert': ('børsnotere',),
'børsnoterte': ('børsnotere',),
'børsnoterende': ('børsnotere',),
'børsta': ('børste',),
'børstet': ('børste',),
'børsta': ('børste',),
'børstet': ('børste',),
'børsta': ('børste',),
'børstete': ('børste',),
'børstede': ('børste',),
'børsta': ('børste',),
'børstete': ('børste',),
'børstede': ('børste',),
'børstende': ('børste',),
'børsten': ('børsten',),
'børstne': ('børsten',),
'børstent': ('børsten',),
'bøs': ('bøs',),
'bøse': ('bøs',),
'bøst': ('bøs',),
'bøsere': ('bøs',),
'bøsest': ('bøs',),
'bøseste': ('bøs',),
'bøtt': ('bøte',),
'bøtte': ('bøte',),
'bøtende': ('bøte',),
'bøtelagt': ('bøtelegge',),
'bøtelagte': ('bøtelegge',),
'bøteleggende': ('bøtelegge',),
'bøyet': ('bøye',),
'bøyd': ('bøye',),
'bøyet': ('bøye',),
'bøyd': ('bøye',),
'bøyete': ('bøye',),
'bøyede': ('bøye',),
'bøyde': ('bøye',),
'bøyete': ('bøye',),
'bøyede': ('bøye',),
'bøyde': ('bøye',),
'bøyende': ('bøye',),
'bøyefast': ('bøyefast',),
'bøyefaste': ('bøyefast',),
'bøyefast': ('bøyefast',),
'bøyelig': ('bøyelig',),
'bøyelige': ('bøyelig',),
'bøyelig': ('bøyelig',),
'bøyet': ('bøyet',),
'bøyete': ('bøyet',),
'bøyet': ('bøyet',),
'bøyete': ('bøyete',),
'californisk': ('californisk',),
'californiske': ('californisk',),
'californisk': ('californisk',),
'campa': ('campe',),
'campet': ('campe',),
'campa': ('campe',),
'campet': ('campe',),
'campa': ('campe',),
'campete': ('campe',),
'campede': ('campe',),
'campa': ('campe',),
'campete': ('campe',),
'campede': ('campe',),
'campende': ('campe',),
'canadisk': ('canadisk',),
'canadiske': ('canadisk',),
'canadisk': ('canadisk',),
'cash': ('cash',),
'casha': ('cashe',),
'cashet': ('cashe',),
'casha': ('cashe',),
'cashet': ('cashe',),
'casha': ('cashe',),
'cashete': ('cashe',),
'cashede': ('cashe',),
'casha': ('cashe',),
'cashete': ('cashe',),
'cashede': ('cashe',),
'cashende': ('cashe',),
'celeber': ('celeber',),
'celebre': ('celeber',),
'celebert': ('celeber',),
'celebrert': ('celebrere',),
'celebrerte': ('celebrere',),
'celebrerende': ('celebrere',),
'celest': ('celest',),
'celeste': ('celest',),
'celest': ('celest',),
'cellular': ('cellular',),
'cellulare': ('cellular',),
'cellulart': ('cellular',),
'cellulær': ('cellulær',),
'cellulære': ('cellulær',),
'cellulært': ('cellulær',),
'cendre': ('cendre',),
'cerebral': ('cerebral',),
'cerebrale': ('cerebral',),
'cerebralt': ('cerebral',),
'cerebral parese-ramma': ('cerebral parese-ramma',),
'cerebral parese-rammet': ('cerebral parese-rammet',),
'cerebral parese-rammete': ('cerebral parese-rammet',),
'cerebral parese-rammede': ('cerebral parese-rammet',),
'cerebral parese-rammete': ('cerebral parese-rammet',),
'cerebral parese-rammede': ('cerebral parese-rammet',),
'cerebral parese-rammet': ('cerebral parese-rammet',),
'ceylonsk': ('ceylonsk',),
'ceylonske': ('ceylonsk',),
'ceylonsk': ('ceylonsk',),
'changeant': ('changeant',),
'changert': ('changere',),
'changerte': ('changere',),
'changerende': ('changere',),
'chartra': ('chartre',),
'chartret': ('chartre',),
'chartra': ('chartre',),
'chartret': ('chartre',),
'chartra': ('chartre',),
'chartrete': ('chartre',),
'chartrede': ('chartre',),
'chartrete': ('chartre',),
'chartrede': ('chartre',),
'chartra': ('chartre',),
'chartrete': ('chartre',),
'chartrede': ('chartre',),
'chartrete': ('chartre',),
'chartrede': ('chartre',),
'chartrende': ('chartre',),
'chevaleresk': ('chevaleresk',),
'chevalereske': ('chevaleresk',),
'chevaleresk': ('chevaleresk',),
'chevrotert': ('chevrotere',),
'chevroterte': ('chevrotere',),
'chevroterende': ('chevrotere',),
'chic': ('chic',),
'chice': ('chic',),
'chict': ('chic',),
'chiffrert': ('chiffrere',),
'chiffrerte': ('chiffrere',),
'chiffrerende': ('chiffrere',),
'chilensk': ('chilensk',),
'chilenske': ('chilensk',),
'chilensk': ('chilensk',),
'choka': ('choke',),
'choket': ('choke',),
'choka': ('choke',),
'choket': ('choke',),
'choka': ('choke',),
'chokete': ('choke',),
'chokede': ('choke',),
'choka': ('choke',),
'chokete': ('choke',),
'chokede': ('choke',),
'chokende': ('choke',),
'cirkumpolar': ('cirkumpolar',),
'cirkumpolare': ('cirkumpolar',),
'cirkumpolart': ('cirkumpolar',),
'cirkumpolær': ('cirkumpolær',),
'cirkumpolære': ('cirkumpolær',),
'cirkumpolært': ('cirkumpolær',),
'cisalpinsk': ('cisalpinsk',),
'cisalpinske': ('cisalpinsk',),
'cisalpinsk': ('cisalpinsk',),
'clairvoyant': ('clairvoyant',),
'clairvoyante': ('clairvoyant',),
'clairvoyant': ('clairvoyant',),
'clincha': ('clinche',),
'clinchet': ('clinche',),
'clincha': ('clinche',),
'clinchet': ('clinche',),
'clincha': ('clinche',),
'clinchete': ('clinche',),
'clinchede': ('clinche',),
'clincha': ('clinche',),
'clinchete': ('clinche',),
'clinchede': ('clinche',),
'clinchende': ('clinche',),
'clutcha': ('clutche',),
'clutchet': ('clutche',),
'clutcha': ('clutche',),
'clutchet': ('clutche',),
'clutcha': ('clutche',),
'clutchete': ('clutche',),
'clutchede': ('clutche',),
'clutcha': ('clutche',),
'clutchete': ('clutche',),
'clutchede': ('clutche',),
'clutchende': ('clutche',),
'colombiansk': ('colombiansk',),
'colombianske': ('colombiansk',),
'colombiansk': ('colombiansk',),
'comme il faut': ('comme il faut',),
'corny': ('corny',),
'costaricansk': ('costaricansk',),
'costaricanske': ('costaricansk',),
'costaricansk': ('costaricansk',),
'crazy': ('crazy',),
'cruisa': ('cruise',),
'cruiset': ('cruise',),
'cruisa': ('cruise',),
'cruiset': ('cruise',),
'cruisa': ('cruise',),
'cruisete': ('cruise',),
'cruisede': ('cruise',),
'cruisa': ('cruise',),
'cruisete': ('cruise',),
'cruisede': ('cruise',),
'cruisende': ('cruise',),
'cubansk': ('cubansk',),
'cubanske': ('cubansk',),
'cubansk': ('cubansk',),
'cyanidisert': ('cyanidisere',),
'cyanidiserte': ('cyanidisere',),
'cyanidiserende': ('cyanidisere',),
'cyklamen': ('cyklamen',),
'cystisk': ('cystisk',),
'cystiske': ('cystisk',),
'cystisk': ('cystisk',),
'cytologisk': ('cytologisk',),
'cytologiske': ('cytologisk',),
'cytologisk': ('cytologisk',),
'cæsarisk': ('cæsarisk',),
'cæsariske': ('cæsarisk',),
'cæsarisk': ('cæsarisk',),
'cøliakisk': ('cøliakisk',),
'cøliakiske': ('cøliakisk',),
'cøliakisk': ('cøliakisk',),
'dabba': ('dabbe',),
'dabbet': ('dabbe',),
'dabba': ('dabbe',),
'dabbet': ('dabbe',),
'dabba': ('dabbe',),
'dabbete': ('dabbe',),
'dabbede': ('dabbe',),
'dabba': ('dabbe',),
'dabbete': ('dabbe',),
'dabbede': ('dabbe',),
'dabbende': ('dabbe',),
'dadaistisk': ('dadaistisk',),
'dadaistiske': ('dadaistisk',),
'dadaistisk': ('dadaistisk',),
'daddellaus': ('daddellaus',),
'daddellause': ('daddellaus',),
'daddellaust': ('daddellaus',),
'daddelløs': ('daddelløs',),
'daddelløse': ('daddelløs',),
'daddelløst': ('daddelløs',),
'daddelverdig': ('daddelverdig',),
'daddelverdige': ('daddelverdig',),
'daddelverdig': ('daddelverdig',),
'dadla': ('dadle',),
'dadlet': ('dadle',),
'dadla': ('dadle',),
'dadlet': ('dadle',),
'dadla': ('dadle',),
'dadlete': ('dadle',),
'dadlede': ('dadle',),
'dadlete': ('dadle',),
'dadlede': ('dadle',),
'dadla': ('dadle',),
'dadlete': ('dadle',),
'dadlede': ('dadle',),
'dadlete': ('dadle',),
'dadlede': ('dadle',),
'dadlende': ('dadle',),
'daff': ('daff',),
'daffe': ('daff',),
'daft': ('daff',),
'daffere': ('daff',),
'daffest': ('daff',),
'daffeste': ('daff',),
'daffa': ('daffe',),
'daffet': ('daffe',),
'daffa': ('daffe',),
'daffet': ('daffe',),
'daffa': ('daffe',),
'daffete': ('daffe',),
'daffede': ('daffe',),
'daffa': ('daffe',),
'daffete': ('daffe',),
'daffede': ('daffe',),
'daffende': ('daffe',),
'dagdrømt': ('dagdrømme',),
'dagdrømte': ('dagdrømme',),
'dagdrømmende': ('dagdrømme',),
'daga': ('dage',),
'daget': ('dage',),
'daga': ('dage',),
'daget': ('dage',),
'daga': ('dage',),
'dagete': ('dage',),
'dagede': ('dage',),
'daga': ('dage',),
'dagete': ('dage',),
'dagede': ('dage',),
'dagende': ('dage',),
'daghavende': ('daghavende',),
'dagjeldende': ('dagjeldende',),
'daglig': ('daglig',),
'daglige': ('daglig',),
'daglig': ('daglig',),
'dagligdags': ('dagligdags',),
'dagligdagse': ('dagligdags',),
'dagligdags': ('dagligdags',),
'dagsaktuell': ('dagsaktuell',),
'dagsaktuelle': ('dagsaktuell',),
'dagsaktuelt': ('dagsaktuell',),
'dagsens': ('dagsens',),
'dagvill': ('dagvill',),
'dagville': ('dagvill',),
'dagvilt': ('dagvill',),
'dagviss': ('dagviss',),
'dagvisse': ('dagviss',),
'dagvisst': ('dagviss',),
'daktylisk': ('daktylisk',),
'daktyliske': ('daktylisk',),
'daktylisk': ('daktylisk',),
'dalt': ('dale',),
'dalte': ('dale',),
'dalende': ('dale',),
'dalet': ('dalet',),
'dalete': ('dalet',),
'dalet': ('dalet',),
'dalete': ('dalete',),
'dalevende': ('dalevende',),
'dalka': ('dalke',),
'dalket': ('dalke',),
'dalka': ('dalke',),
'dalket': ('dalke',),
'dalka': ('dalke',),
'dalkete': ('dalke',),
'dalkede': ('dalke',),
'dalka': ('dalke',),
'dalkete': ('dalke',),
'dalkede': ('dalke',),
'dalkende': ('dalke',),
'dalmatisk': ('dalmatisk',),
'dalmatiske': ('dalmatisk',),
'dalmatisk': ('dalmatisk',),
'dalta': ('dalte',),
'daltet': ('dalte',),
'dalta': ('dalte',),
'daltet': ('dalte',),
'dalta': ('dalte',),
'daltete': ('dalte',),
'daltede': ('dalte',),
'dalta': ('dalte',),
'daltete': ('dalte',),
'daltede': ('dalte',),
'daltende': ('dalte',),
'damascert': ('damascere',),
'damascerte': ('damascere',),
'damascerende': ('damascere',),
'dampdrevet': ('dampdrevet',),
'dampdrevne': ('dampdrevet',),
'dampdrevet': ('dampdrevet',),
'dampa': ('dampe',),
'dampet': ('dampe',),
'dampa': ('dampe',),
'dampet': ('dampe',),
'dampa': ('dampe',),
'dampete': ('dampe',),
'dampede': ('dampe',),
'dampa': ('dampe',),
'dampete': ('dampe',),
'dampede': ('dampe',),
'dampende': ('dampe',),
'dampkokt': ('dampkoke',),
'dampkokte': ('dampkoke',),
'dampkokende': ('dampkoke',),
'dandert': ('dandere',),
'danderte': ('dandere',),
'danderende': ('dandere',),
'dangla': ('dangle',),
'danglet': ('dangle',),
'dangla': ('dangle',),
'danglet': ('dangle',),
'dangla': ('dangle',),
'danglete': ('dangle',),
'danglede': ('dangle',),
'danglete': ('dangle',),
'danglede': ('dangle',),
'dangla': ('dangle',),
'danglete': ('dangle',),
'danglede': ('dangle',),
'danglete': ('dangle',),
'danglede': ('dangle',),
'danglende': ('dangle',),
'danka': ('danke',),
'danket': ('danke',),
'danka': ('danke',),
'danket': ('danke',),
'danka': ('danke',),
'dankete': ('danke',),
'dankede': ('danke',),
'danka': ('danke',),
'dankete': ('danke',),
'dankede': ('danke',),
'dankende': ('danke',),
'danna': ('danna',),
'danna': ('danne',),
'dannet': ('danne',),
'danna': ('danne',),
'dannet': ('danne',),
'danna': ('danne',),
'dannete': ('danne',),
'dannede': ('danne',),
'danna': ('danne',),
'dannete': ('danne',),
'dannede': ('danne',),
'dannende': ('danne',),
'dannet': ('dannet',),
'dannete': ('dannet',),
'dannede': ('dannet',),
'dannete': ('dannet',),
'dannede': ('dannet',),
'dannet': ('dannet',),
'dansa': ('danse',),
'danset': ('danse',),
'dansa': ('danse',),
'danset': ('danse',),
'dansa': ('danse',),
'dansete': ('danse',),
'dansede': ('danse',),
'dansa': ('danse',),
'dansete': ('danse',),
'dansede': ('danse',),
'dansende': ('danse',),
'dansegal': ('dansegal',),
'dansegale': ('dansegal',),
'dansegalt': ('dansegal',),
'dansk': ('dansk',),
'danske': ('dansk',),
'dansk': ('dansk',),
'dansk-norsk': ('dansk-norsk',),
'dansk-norske': ('dansk-norsk',),
'dansk-norsk': ('dansk-norsk',),
'danska': ('danske',),
'dansket': ('danske',),
'danska': ('danske',),
'dansket': ('danske',),
'danska': ('danske',),
'danskete': ('danske',),
'danskede': ('danske',),
'danska': ('danske',),
'danskete': ('danske',),
'danskede': ('danske',),
'danskende': ('danske',),
'darra': ('darre',),
'darret': ('darre',),
'darra': ('darre',),
'darret': ('darre',),
'darra': ('darre',),
'darrete': ('darre',),
'darrede': ('darre',),
'darra': ('darre',),
'darrete': ('darre',),
'darrede': ('darre',),
'darrende': ('darre',),
'daska': ('daske',),
'dasket': ('daske',),
'daska': ('daske',),
'dasket': ('daske',),
'daska': ('daske',),
'daskete': ('daske',),
'daskede': ('daske',),
'daska': ('daske',),
'daskete': ('daske',),
'daskede': ('daske',),
'daskende': ('daske',),
'databehandla': ('databehandle',),
'databehandlet': ('databehandle',),
'databehandla': ('databehandle',),
'databehandlet': ('databehandle',),
'databehandla': ('databehandle',),
'databehandlete': ('databehandle',),
'databehandlede': ('databehandle',),
'databehandlete': ('databehandle',),
'databehandlede': ('databehandle',),
'databehandla': ('databehandle',),
'databehandlete': ('databehandle',),
'databehandlede': ('databehandle',),
'databehandlete': ('databehandle',),
'databehandlede': ('databehandle',),
'databehandlende': ('databehandle',),
'dataført': ('dataføre',),
'dataførte': ('dataføre',),
'dataførende': ('dataføre',),
'datagrafisk': ('datagrafisk',),
'datagrafiske': ('datagrafisk',),
'datagrafisk': ('datagrafisk',),
'datamaskinassistert': ('datamaskinassistert',),
'datamaskinassisterte': ('datamaskinassistert',),
'datamaskinassistert': ('datamaskinassistert',),
'datamaskinell': ('datamaskinell',),
'datamaskinelle': ('datamaskinell',),
'datamaskinelt': ('datamaskinell',),
'datastyrt': ('datastyre',),
'datastyrte': ('datastyre',),
'datastyrende': ('datastyre',),
'datert': ('datere',),
'daterte': ('datere',),
'daterende': ('datere',),
'datidig': ('datidig',),
'datidige': ('datidig',),
'datidig': ('datidig',),
'datostempla': ('datostemple',),
'datostemplet': ('datostemple',),
'datostempla': ('datostemple',),
'datostemplet': ('datostemple',),
'datostempla': ('datostemple',),
'datostemplete': ('datostemple',),
'datostemplede': ('datostemple',),
'datostemplete': ('datostemple',),
'datostemplede': ('datostemple',),
'datostempla': ('datostemple',),
'datostemplete': ('datostemple',),
'datostemplede': ('datostemple',),
'datostemplete': ('datostemple',),
'datostemplede': ('datostemple',),
'datostemplende': ('datostemple',),
'dau': ('dau',),
'daue': ('dau',),
'daut': ('dau',),
'dauere': ('dau',),
'dauest': ('dau',),
'daueste': ('dau',),
'daubakt': ('daubakt',),
'daubakte': ('daubakt',),
'daubakt': ('daubakt',),
'daud': ('daud',),
'daude': ('daud',),
'daudt': ('daud',),
'daudere': ('daud',),
'daudest': ('daud',),
'daudeste': ('daud',),
'daudbleik': ('daudbleik',),
'daudbleike': ('daudbleik',),
'daudbleikt': ('daudbleik',),
'daudblek': ('daudblek',),
'daudbleke': ('daudblek',),
'daudblekt': ('daudblek',),
'daudbrent': ('daudbrent',),
'daudbrente': ('daudbrent',),
'daudbrent': ('daudbrent',),
'dauddrukken': ('dauddrukken',),
'dauddrukne': ('dauddrukken',),
'dauddrukkent': ('dauddrukken',),
'daudfødt': ('daudfødt',),
'daudfødte': ('daudfødt',),
'daudfødt': ('daudfødt',),
'daugjødsla': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødslete': ('daugjødsle',),
'daugjødslede': ('daugjødsle',),
'daugjødslete': ('daugjødsle',),
'daugjødslede': ('daugjødsle',),
'daugjødsla': ('daugjødsle',),
'daugjødslete': ('daugjødsle',),
'daugjødslede': ('daugjødsle',),
'daugjødslete': ('daugjødsle',),
'daugjødslede': ('daugjødsle',),
'daugjødslende': ('daugjødsle',),
'dauhogd': ('dauhogge',),
'dauhogde': ('dauhogge',),
'dauhoggende': ('dauhogge',),
'dauhugget': ('dauhugge',),
'dauhugd': ('dauhugge',),
'dauhugget': ('dauhugge',),
'dauhugd': ('dauhugge',),
'dauhuggete': ('dauhugge',),
'dauhuggede': ('dauhugge',),
'dauhugde': ('dauhugge',),
'dauhuggete': ('dauhugge',),
'dauhuggede': ('dauhugge',),
'dauhugde': ('dauhugge',),
'dauhuggende': ('dauhugge',),
'daukjørt': ('daukjøre',),
'daukjørte': ('daukjøre',),
'daukjørende': ('daukjøre',),
'dausteikt': ('dausteikt',),
'dausteikte': ('dausteikt',),
'dausteikt': ('dausteikt',),
'daustekt': ('daustekt',),
'daustekte': ('daustekt',),
'daustekt': ('daustekt',),
'daværende': ('daværende',),
'debattert': ('debattere',),
'debatterte': ('debattere',),
'debatterende': ('debattere',),
'debil': ('debil',),
'debile': ('debil',),
'debilt': ('debil',),
'debitert': ('debitere',),
'debiterte': ('debitere',),
'debiterende': ('debitere',),
'debutert': ('debutere',),
'debuterte': ('debutere',),
'debuterende': ('debutere',),
'dechiffrert': ('dechiffrere',),
'dechiffrerte': ('dechiffrere',),
'dechiffrerende': ('dechiffrere',),
'dedisert': ('dedisere',),
'dediserte': ('dedisere',),
'dediserende': ('dedisere',),
'deduktiv': ('deduktiv',),
'deduktive': ('deduktiv',),
'deduktivt': ('deduktiv',),
'dedusert': ('dedusere',),
'deduserte': ('dedusere',),
'deduserende': ('dedusere',),
'defaitistisk': ('defaitistisk',),
'defaitistiske': ('defaitistisk',),
'defaitistisk': ('defaitistisk',),
'defekt': ('defekt',),
'defekte': ('defekt',),
'defekt': ('defekt',),
'defensiv': ('defensiv',),
'defensive': ('defensiv',),
'defensivt': ('defensiv',),
'defilert': ('defilere',),
'defilerte': ('defilere',),
'defilerende': ('defilere',),
'definerbar': ('definerbar',),
'definerbare': ('definerbar',),
'definerbart': ('definerbar',),
'definert': ('definere',),
'definerte': ('definere',),
'definerende': ('definere',),
'definisjonsmessig': ('definisjonsmessig',),
'definisjonsmessige': ('definisjonsmessig',),
'definisjonsmessig': ('definisjonsmessig',),
'definitiv': ('definitiv',),
'definitive': ('definitiv',),
'definitivt': ('definitiv',),
'definitorisk': ('definitorisk',),
'definitoriske': ('definitorisk',),
'definitorisk': ('definitorisk',),
'deflatert': ('deflatere',),
'deflaterte': ('deflatere',),
'deflaterende': ('deflatere',),
'deflatorisk': ('deflatorisk',),
'deflatoriske': ('deflatorisk',),
'deflatorisk': ('deflatorisk',),
'deflorert': ('deflorere',),
'deflorerte': ('deflorere',),
'deflorerende': ('deflorere',),
'deform': ('deform',),
'deforme': ('deform',),
'deformt': ('deform',),
'deformert': ('deformere',),
'deformerte': ('deformere',),
'deformerende': ('deformere',),
'degenerert': ('degenerere',),
'degenererte': ('degenerere',),
'degenererende': ('degenerere',),
'degenerert': ('degenerert',),
'degenererte': ('degenerert',),
'degenerert': ('degenerert',),
'degga': ('degge',),
'degget': ('degge',),
'degga': ('degge',),
'degget': ('degge',),
'degga': ('degge',),
'deggete': ('degge',),
'deggede': ('degge',),
'degga': ('degge',),
'deggete': ('degge',),
'deggede': ('degge',),
'deggende': ('degge',),
'degradert': ('degradere',),
'degraderte': ('degradere',),
'degraderende': ('degradere',),
'degressiv': ('degressiv',),
'degressive': ('degressiv',),
'degressivt': ('degressiv',),
'dehydrert': ('dehydrere',),
'dehydrerte': ('dehydrere',),
'dehydrerende': ('dehydrere',),
'deiget': ('deiget',),
'deigete': ('deiget',),
'deiget': ('deiget',),
'deigete': ('deigete',),
'deiktisk': ('deiktisk',),
'deiktiske': ('deiktisk',),
'deiktisk': ('deiktisk',),
'deilig': ('deilig',),
'deilige': ('deilig',),
'deilig': ('deilig',),
'deiligere': ('deilig',),
'deiligst': ('deilig',),
'deiligste': ('deilig',),
'deisa': ('deise',),
'deiset': ('deise',),
'deist': ('deise',),
'deisa': ('deise',),
'deiset': ('deise',),
'deist': ('deise',),
'deisa': ('deise',),
'deisete': ('deise',),
'deisede': ('deise',),
'deiste': ('deise',),
'deisa': ('deise',),
'deisete': ('deise',),
'deisede': ('deise',),
'deiste': ('deise',),
'deisende': ('deise',),
'deistisk': ('deistisk',),
'deistiske': ('deistisk',),
'deistisk': ('deistisk',),
'dekadent': ('dekadent',),
'dekadente': ('dekadent',),
'dekadent': ('dekadent',),
'dekadisk': ('dekadisk',),
'dekadiske': ('dekadisk',),
'dekadisk': ('dekadisk',),
'dekantert': ('dekantere',),
'dekanterte': ('dekantere',),
'dekanterende': ('dekantere',),
'dekatert': ('dekatere',),
'dekaterte': ('dekatere',),
'dekaterende': ('dekatere',),
'dekka': ('dekke',),
'dekket': ('dekke',),
'dekt': ('dekke',),
'dekka': ('dekke',),
'dekket': ('dekke',),
'dekt': ('dekke',),
'dekka': ('dekke',),
'dekkete': ('dekke',),
'dekkede': ('dekke',),
'dekte': ('dekke',),
'dekka': ('dekke',),
'dekkete': ('dekke',),
'dekkede': ('dekke',),
'dekte': ('dekke',),
'dekkende': ('dekke',),
'dekkende': ('dekkende',),
'dekkfrøa': ('dekkfrøa',),
'dekkfrøet': ('dekkfrøet',),
'dekkfrøete': ('dekkfrøet',),
'dekkfrøede': ('dekkfrøet',),
'dekkfrøete': ('dekkfrøet',),
'dekkfrøede': ('dekkfrøet',),
'dekkfrøet': ('dekkfrøet',),
'deklamert': ('deklamere',),
'deklamerte': ('deklamere',),
'deklamerende': ('deklamere',),
'deklaratorisk': ('deklaratorisk',),
'deklaratoriske': ('deklaratorisk',),
'deklaratorisk': ('deklaratorisk',),
'deklarert': ('deklarere',),
'deklarerte': ('deklarere',),
'deklarerende': ('deklarere',),
'deklassert': ('deklassere',),
'deklasserte': ('deklassere',),
'deklasserende': ('deklassere',),
'deklinabel': ('deklinabel',),
'deklinable': ('deklinabel',),
'deklinabelt': ('deklinabel',),
'deklinert': ('deklinere',),
'deklinerte': ('deklinere',),
'deklinerende': ('deklinere',),
'dekningslaus': ('dekningslaus',),
'dekningslause': ('dekningslaus',),
'dekningslaust': ('dekningslaus',),
'dekningsløs': ('dekningsløs',),
'dekningsløse': ('dekningsløs',),
'dekningsløst': ('dekningsløs',),
'dekoda': ('dekode',),
'dekodet': ('dekode',),
'dekoda': ('dekode',),
'dekodet': ('dekode',),
'dekoda': ('dekode',),
'dekodete': ('dekode',),
'dekodede': ('dekode',),
'dekoda': ('dekode',),
'dekodete': ('dekode',),
'dekodede': ('dekode',),
'dekodende': ('dekode',),
'dekolletert': ('dekolletert',),
'dekolleterte': ('dekolletert',),
'dekolletert': ('dekolletert',),
'dekomponert': ('dekomponere',),
'dekomponerte': ('dekomponere',),
'dekomponerende': ('dekomponere',),
'dekorativ': ('dekorativ',),
'dekorative': ('dekorativ',),
'dekorativt': ('dekorativ',),
'dekorert': ('dekorere',),
'dekorerte': ('dekorere',),
'dekorerende': ('dekorere',),
'dekortert': ('dekortere',),
'dekorterte': ('dekortere',),
'dekorterende': ('dekortere',),
'dekretert': ('dekretere',),
'dekreterte': ('dekretere',),
'dekreterende': ('dekretere',),
'dekupert': ('dekupere',),
'dekuperte': ('dekupere',),
'dekuperende': ('dekupere',),
'delabialisert': ('delabialisere',),
'delabialiserte': ('delabialisere',),
'delabialiserende': ('delabialisere',),
'delaktig': ('delaktig',),
'delaktige': ('delaktig',),
'delaktig': ('delaktig',),
'delt': ('dele',),
'delte': ('dele',),
'delende': ('dele',),
'delegert': ('delegere',),
'delegerte': ('delegere',),
'delegerende': ('delegere',),
'delegert': ('delegert',),
'delegerte': ('delegert',),
'delegert': ('delegert',),
'delelig': ('delelig',),
'delelige': ('delelig',),
'delelig': ('delelig',),
'delert': ('delere',),
'delerte': ('delere',),
'delerende': ('delere',),
'delikat': ('delikat',),
'delikate': ('delikat',),
'delikat': ('delikat',),
'delikatert': ('delikatere',),
'delikaterte': ('delikatere',),
'delikaterende': ('delikatere',),
'delirant': ('delirant',),
'delirante': ('delirant',),
'delirant': ('delirant',),
'delirert': ('delirere',),
'delirerte': ('delirere',),
'delirerende': ('delirere',),
'delja': ('delje',),
'deljet': ('delje',),
'delja': ('delje',),
'deljet': ('delje',),
'delja': ('delje',),
'deljete': ('delje',),
'deljede': ('delje',),
'delja': ('delje',),
'deljete': ('delje',),
'deljede': ('delje',),
'deljende': ('delje',),
'deltatt': ('delta',),
'deltatte': ('delta',),
'deltakende': ('delta',),
'deltaforma': ('deltaforma',),
'deltaformet': ('deltaformet',),
'deltaformete': ('deltaformet',),
'deltaformede': ('deltaformet',),
'deltaformete': ('deltaformet',),
'deltaformede': ('deltaformet',),
'deltaformet': ('deltaformet',),
'deltagende': ('deltagende',),
'deltakende': ('deltakende',),
'deltidsansatt': ('deltidsansatt',),
'deltidsansatte': ('deltidsansatt',),
'deltidsansatt': ('deltidsansatt',),
'demagogisk': ('demagogisk',),
'demagogiske': ('demagogisk',),
'demagogisk': ('demagogisk',),
'demaskert': ('demaskere',),
'demaskerte': ('demaskere',),
'demaskerende': ('demaskere',),
'dementert': ('dementere',),
'dementerte': ('dementere',),
'dementerende': ('dementere',),
'demi-sec': ('demi-sec',),
'demilitarisert': ('demilitarisere',),
'demilitariserte': ('demilitarisere',),
'demilitariserende': ('demilitarisere',),
'demisjonert': ('demisjonere',),
'demisjonerte': ('demisjonere',),
'demisjonerende': ('demisjonere',),
'demmet': ('demme',),
'demt': ('demme',),
'demmet': ('demme',),
'demt': ('demme',),
'demmete': ('demme',),
'demmede': ('demme',),
'demte': ('demme',),
'demmete': ('demme',),
'demmede': ('demme',),
'demte': ('demme',),
'demmende': ('demme',),
'demobilisert': ('demobilisere',),
'demobiliserte': ('demobilisere',),
'demobiliserende': ('demobilisere',),
'demografisk': ('demografisk',),
'demografiske': ('demografisk',),
'demografisk': ('demografisk',),
'demokratisert': ('demokratisere',),
'demokratiserte': ('demokratisere',),
'demokratiserende': ('demokratisere',),
'demokratisk': ('demokratisk',),
'demokratiske': ('demokratisk',),
'demokratisk': ('demokratisk',),
'demolert': ('demolere',),
'demolerte': ('demolere',),
'demolerende': ('demolere',),
'demonisk': ('demonisk',),
'demoniske': ('demonisk',),
'demonisk': ('demonisk',),
'demonstrativ': ('demonstrativ',),
'demonstrative': ('demonstrativ',),
'demonstrativt': ('demonstrativ',),
'demonstrert': ('demonstrere',),
'demonstrerte': ('demonstrere',),
'demonstrerende': ('demonstrere',),
'demontert': ('demontere',),
'demonterte': ('demontere',),
'demonterende': ('demontere',),
'demoralisert': ('demoralisere',),
'demoraliserte': ('demoralisere',),
'demoraliserende': ('demoralisere',),
'dempa': ('dempe',),
'dempet': ('dempe',),
'dempa': ('dempe',),
'dempet': ('dempe',),
'dempa': ('dempe',),
'dempete': ('dempe',),
'dempede': ('dempe',),
'dempa': ('dempe',),
'dempete': ('dempe',),
'dempede': ('dempe',),
'dempende': ('dempe',),
'demra': ('demre',),
'demret': ('demre',),
'demra': ('demre',),
'demret': ('demre',),
'demra': ('demre',),
'demrete': ('demre',),
'demrede': ('demre',),
'demrete': ('demre',),
'demrede': ('demre',),
'demra': ('demre',),
'demrete': ('demre',),
'demrede': ('demre',),
'demrete': ('demre',),
'demrede': ('demre',),
'demrende': ('demre',),
'den slags': ('den slags',),
'denasjonalisert': ('denasjonalisere',),
'denasjonaliserte': ('denasjonalisere',),
'denasjonaliserende': ('denasjonalisere',),
'denaturalisert': ('denaturalisere',),
'denaturaliserte': ('denaturalisere',),
'denaturaliserende': ('denaturalisere',),
'denaturert': ('denaturere',),
'denaturerte': ('denaturere',),
'denaturerende': ('denaturere',),
'dengt': ('denge',),
'dengte': ('denge',),
'dengende': ('denge',),
'dennesidig': ('dennesidig',),
'dennesidige': ('dennesidig',),
'dennesidig': ('dennesidig',),
'denominativ': ('denominativ',),
'denominative': ('denominativ',),
'denominativt': ('denominativ',),
'denotativ': ('denotativ',),
'denotative': ('denotativ',),
'denotativt': ('denotativ',),
'denotert': ('denotere',),
'denoterte': ('denotere',),
'denoterende': ('denotere',),
'dental': ('dental',),
'dentale': ('dental',),
'dentalt': ('dental',),
'denudert': ('denudere',),
'denuderte': ('denudere',),
'denuderende': ('denudere',),
'deoksidert': ('deoksidere',),
'deoksiderte': ('deoksidere',),
'deoksiderende': ('deoksidere',),
'departemental': ('departemental',),
'departementale': ('departemental',),
'departementalt': ('departemental',),
'deponent': ('deponent',),
'deponente': ('deponent',),
'deponent': ('deponent',),
'deponert': ('deponere',),
'deponerte': ('deponere',),
'deponerende': ('deponere',),
'deportert': ('deportere',),
'deporterte': ('deportere',),
'deporterende': ('deportere',),
'deppa': ('deppa',),
'deppa': ('deppe',),
'deppet': ('deppe',),
'deppa': ('deppe',),
'deppet': ('deppe',),
'deppa': ('deppe',),
'deppete': ('deppe',),
'deppede': ('deppe',),
'deppa': ('deppe',),
'deppete': ('deppe',),
'deppede': ('deppe',),
'deppende': ('deppe',),
'depravert': ('depravere',),
'depraverte': ('depravere',),
'depraverende': ('depravere',),
'depressiv': ('depressiv',),
'depressive': ('depressiv',),
'depressivt': ('depressiv',),
'deprimert': ('deprimere',),
'deprimerte': ('deprimere',),
'deprimerende': ('deprimere',),
'deprimert': ('deprimert',),
'deprimerte': ('deprimert',),
'deprimert': ('deprimert',),
'deprivatisert': ('deprivatisere',),
'deprivatiserte': ('deprivatisere',),
'deprivatiserende': ('deprivatisere',),
'deputert': ('deputert',),
'deputerte': ('deputert',),
'deputert': ('deputert',),
'derangert': ('derangere',),
'derangerte': ('derangere',),
'derangerende': ('derangere',),
'derangert': ('derangert',),
'derangerte': ('derangert',),
'derangert': ('derangert',),
'derelinkvert': ('derelinkvere',),
'derelinkverte': ('derelinkvere',),
'derelinkverende': ('derelinkvere',),
'deriverbar': ('deriverbar',),
'deriverbare': ('deriverbar',),
'deriverbart': ('deriverbar',),
'derivert': ('derivere',),
'deriverte': ('derivere',),
'deriverende': ('derivere',),
'derværende': ('derværende',),
'desarmert': ('desarmere',),
'desarmerte': ('desarmere',),
'desarmerende': ('desarmere',),
'desavuert': ('desavuere',),
'desavuerte': ('desavuere',),
'desavuerende': ('desavuere',),
'desentralisert': ('desentralisere',),
'desentraliserte': ('desentralisere',),
'desentraliserende': ('desentralisere',),
'desertert': ('desertere',),
'deserterte': ('desertere',),
'deserterende': ('desertere',),
'desidert': ('desidere',),
'desiderte': ('desidere',),
'desiderende': ('desidere',),
'desidert': ('desidert',),
'desiderte': ('desidert',),
'desidert': ('desidert',),
'designa': ('designe',),
'designet': ('designe',),
'designa': ('designe',),
'designet': ('designe',),
'designa': ('designe',),
'designete': ('designe',),
'designede': ('designe',),
'designa': ('designe',),
'designete': ('designe',),
'designede': ('designe',),
'designende': ('designe',),
'desillusjonert': ('desillusjonere',),
'desillusjonerte': ('desillusjonere',),
'desillusjonerende': ('desillusjonere',),
'desillusjonert': ('desillusjonert',),
'desillusjonerte': ('desillusjonert',),
'desillusjonert': ('desillusjonert',),
'desimert': ('desimere',),
'desimerte': ('desimere',),
'desimerende': ('desimere',),
'desinfisert': ('desinfisere',),
'desinfiserte': ('desinfisere',),
'desinfiserende': ('desinfisere',),
'desinformert': ('desinformere',),
'desinformerte': ('desinformere',),
'desinformerende': ('desinformere',),
'desintegrert': ('desintegrere',),
'desintegrerte': ('desintegrere',),
'desintegrerende': ('desintegrere',),
'deskriptiv': ('deskriptiv',),
'deskriptive': ('deskriptiv',),
'deskriptivt': ('deskriptiv',),
'desoksidert': ('desoksidere',),
'desoksiderte': ('desoksidere',),
'desoksiderende': ('desoksidere',),
'desorganisert': ('desorganisere',),
'desorganiserte': ('desorganisere',),
'desorganiserende': ('desorganisere',),
'desorientert': ('desorientere',),
'desorienterte': ('desorientere',),
'desorienterende': ('desorientere',),
'desorientert': ('desorientert',),
'desorienterte': ('desorientert',),
'desorientert': ('desorientert',),
'desperat': ('desperat',),
'desperate': ('desperat',),
'desperat': ('desperat',),
'despotisk': ('despotisk',),
'despotiske': ('despotisk',),
'despotisk': ('despotisk',),
'desslike': ('desslike',),
'destillert': ('destillere',),
'destillerte': ('destillere',),
'destillerende': ('destillere',),
'destruert': ('destruere',),
'destruerte': ('destruere',),
'destruerende': ('destruere',),
'destruktiv': ('destruktiv',),
'destruktive': ('destruktiv',),
'destruktivt': ('destruktiv',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlete': ('detaljbehandle',),
'detaljbehandlede': ('detaljbehandle',),
'detaljbehandlete': ('detaljbehandle',),
'detaljbehandlede': ('detaljbehandle',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlete': ('detaljbehandle',),
'detaljbehandlede': ('detaljbehandle',),
'detaljbehandlete': ('detaljbehandle',),
'detaljbehandlede': ('detaljbehandle',),
'detaljbehandlende': ('detaljbehandle',),
'detaljert': ('detaljere',),
'detaljerte': ('detaljere',),
'detaljerende': ('detaljere',),
'detaljert': ('detaljert',),
'detaljerte': ('detaljert',),
'detaljert': ('detaljert',),
'detaljrik': ('detaljrik',),
'detaljrike': ('detaljrik',),
'detaljrikt': ('detaljrik',),
'detasjert': ('detasjere',),
'detasjerte': ('detasjere',),
'detasjerende': ('detasjere',),
'determinativ': ('determinativ',),
'determinative': ('determinativ',),
'determinativt': ('determinativ',),
'determinert': ('determinere',),
'determinerte': ('determinere',),
'determinerende': ('determinere',),
'deterministisk': ('deterministisk',),
'deterministiske': ('deterministisk',),
'deterministisk': ('deterministisk',),
'detonert': ('detonere',),
'detonerte': ('detonere',),
'detonerende': ('detonere',),
'detronisert': ('detronisere',),
'detroniserte': ('detronisere',),
'detroniserende': ('detronisere',),
'dettet': ('dette',),
'dettete': ('dette',),
'dettede': ('dette',),
'dettete': ('dette',),
'dettede': ('dette',),
'dettende': ('dette',),
'devaluert': ('devaluere',),
'devaluerte': ('devaluere',),
'devaluerende': ('devaluere',),
'deviert': ('deviere',),
'devierte': ('deviere',),
'devierende': ('deviere',),
'devot': ('devot',),
'diabetisk': ('diabetisk',),
'diabetiske': ('diabetisk',),
'diabetisk': ('diabetisk',),
'diabolsk': ('diabolsk',),
'diabolske': ('diabolsk',),
'diabolsk': ('diabolsk',),
'diagnostisert': ('diagnostisere',),
'diagnostiserte': ('diagnostisere',),
'diagnostiserende': ('diagnostisere',),
'diagnostisk': ('diagnostisk',),
'diagnostiske': ('diagnostisk',),
'diagnostisk': ('diagnostisk',),
'diagonal': ('diagonal',),
'diagonale': ('diagonal',),
'diagonalt': ('diagonal',),
'diagonalvevd': ('diagonalvevd',),
'diagonalvevde': ('diagonalvevd',),
'diagonalvevd': ('diagonalvevd',),
'diakonal': ('diakonal',),
'diakonale': ('diakonal',),
'diakonalt': ('diakonal',),
'diakritisk': ('diakritisk',),
'diakritiske': ('diakritisk',),
'diakritisk': ('diakritisk',),
'diakron': ('diakron',),
'diakrone': ('diakron',),
'diakront': ('diakron',),
'diakronisk': ('diakronisk',),
'diakroniske': ('diakronisk',),
'diakronisk': ('diakronisk',),
'dialektal': ('dialektal',),
'dialektale': ('dialektal',),
'dialektalt': ('dialektal',),
'dialektfarga': ('dialektfarga',),
'dialektfarget': ('dialektfarget',),
'dialektfargete': ('dialektfarget',),
'dialektfargede': ('dialektfarget',),
'dialektfargete': ('dialektfarget',),
'dialektfargede': ('dialektfarget',),
'dialektfarget': ('dialektfarget',),
'dialektisk': ('dialektisk',),
'dialektiske': ('dialektisk',),
'dialektisk': ('dialektisk',),
'dialysert': ('dialysere',),
'dialyserte': ('dialysere',),
'dialyserende': ('dialysere',),
'diametral': ('diametral',),
'diametrale': ('diametral',),
'diametralt': ('diametral',),
'diatonisk': ('diatonisk',),
'diatoniske': ('diatonisk',),
'diatonisk': ('diatonisk',),
'didaktisk': ('didaktisk',),
'didaktiske': ('didaktisk',),
'didaktisk': ('didaktisk',),
'dia': ('die',),
'diet': ('die',),
'dia': ('die',),
'diet': ('die',),
'dia': ('die',),
'diete': ('die',),
'diede': ('die',),
'dia': ('die',),
'diete': ('die',),
'diede': ('die',),
'diende': ('die',),
'dieseldrevet': ('dieseldrevet',),
'dieseldrevne': ('dieseldrevet',),
'dieseldrevet': ('dieseldrevet',),
'differensiert': ('differensiere',),
'differensierte': ('differensiere',),
'differensierende': ('differensiere',),
'differert': ('differere',),
'differerte': ('differere',),
'differerende': ('differere',),
'diffundert': ('diffundere',),
'diffunderte': ('diffundere',),
'diffunderende': ('diffundere',),
'diffus': ('diffus',),
'diffuse': ('diffus',),
'diffust': ('diffus',),
'difterisk': ('difterisk',),
'difteriske': ('difterisk',),
'difterisk': ('difterisk',),
'diftongert': ('diftongere',),
'diftongerte': ('diftongere',),
'diftongerende': ('diftongere',),
'diger': ('diger',),
'digre': ('diger',),
'digert': ('diger',),
'digrere': ('diger',),
'digrest': ('diger',),
'digreste': ('diger',),
'digga': ('digge',),
'digget': ('digge',),
'digga': ('digge',),
'digget': ('digge',),
'digga': ('digge',),
'diggete': ('digge',),
'diggede': ('digge',),
'digga': ('digge',),
'diggete': ('digge',),
'diggede': ('digge',),
'diggende': ('digge',),
'digital': ('digital',),
'digitale': ('digital',),
'digitalt': ('digital',),
'digitalisert': ('digitalisere',),
'digitaliserte': ('digitalisere',),
'digitaliserende': ('digitalisere',),
'dikka': ('dikke',),
'dikket': ('dikke',),
'dikka': ('dikke',),
'dikket': ('dikke',),
'dikka': ('dikke',),
'dikkete': ('dikke',),
'dikkede': ('dikke',),
'dikka': ('dikke',),
'dikkete': ('dikke',),
'dikkede': ('dikke',),
'dikkende': ('dikke',),
'diktatorisk': ('diktatorisk',),
'diktatoriske': ('diktatorisk',),
'diktatorisk': ('diktatorisk',),
'dikta': ('dikte',),
'diktet': ('dikte',),
'dikta': ('dikte',),
'diktet': ('dikte',),
'dikta': ('dikte',),
'diktete': ('dikte',),
'diktede': ('dikte',),
'dikta': ('dikte',),
'diktete': ('dikte',),
'diktede': ('dikte',),
'diktende': ('dikte',),
'diktert': ('diktere',),
'dikterte': ('diktere',),
'dikterende': ('diktere',),
'dikterisk': ('dikterisk',),
'dikteriske': ('dikterisk',),
'dikterisk': ('dikterisk',),
'dilettantisk': ('dilettantisk',),
'dilettantiske': ('dilettantisk',),
'dilettantisk': ('dilettantisk',),
'dilettantmessig': ('dilettantmessig',),
'dilettantmessige': ('dilettantmessig',),
'dilettantmessig': ('dilettantmessig',),
'dilla': ('dille',),
'dillet': ('dille',),
'dilla': ('dille',),
'dillet': ('dille',),
'dilla': ('dille',),
'dillete': ('dille',),
'dillede': ('dille',),
'dilla': ('dille',),
'dillete': ('dille',),
'dillede': ('dille',),
'dillende': ('dille',),
'dillet': ('dillet',),
'dillete': ('dillet',),
'dillet': ('dillet',),
'dillete': ('dillete',),
'dilta': ('dilte',),
'diltet': ('dilte',),
'dilta': ('dilte',),
'diltet': ('dilte',),
'dilta': ('dilte',),
'diltete': ('dilte',),
'diltede': ('dilte',),
'dilta': ('dilte',),
'diltete': ('dilte',),
'diltede': ('dilte',),
'diltende': ('dilte',),
'diluvial': ('diluvial',),
'diluviale': ('diluvial',),
'diluvialt': ('diluvial',),
'diluviansk': ('diluviansk',),
'diluvianske': ('diluviansk',),
'diluviansk': ('diluviansk',),
'dim': ('dim',),
'dimme': ('dim',),
'dimt': ('dim',),
'dimmere': ('dim',),
'dimmest': ('dim',),
'dimmeste': ('dim',),
'dimensjonal': ('dimensjonal',),
'dimensjonale': ('dimensjonal',),
'dimensjonalt': ('dimensjonal',),
'dimensjonert': ('dimensjonere',),
'dimensjonerte': ('dimensjonere',),
'dimensjonerende': ('dimensjonere',),
'diminutiv': ('diminutiv',),
'diminutive': ('diminutiv',),
'diminutivt': ('diminutiv',),
'dimittert': ('dimittere',),
'dimitterte': ('dimittere',),
'dimitterende': ('dimittere',),
'dimma': ('dimme',),
'dimmet': ('dimme',),
'dimma': ('dimme',),
'dimmet': ('dimme',),
'dimma': ('dimme',),
'dimmete': ('dimme',),
'dimmede': ('dimme',),
'dimma': ('dimme',),
'dimmete': ('dimme',),
'dimmede': ('dimme',),
'dimmende': ('dimme',),
'dimt': ('dimme',),
'dimte': ('dimme',),
'dimmende': ('dimme',),
'dimorf': ('dimorf',),
'dimorfe': ('dimorf',),
'dimorft': ('dimorf',),
'dinert': ('dinere',),
'dinerte': ('dinere',),
'dinerende': ('dinere',),
'dingla': ('dingle',),
'dinglet': ('dingle',),
'dingla': ('dingle',),
'dinglet': ('dingle',),
'dingla': ('dingle',),
'dinglete': ('dingle',),
'dinglede': ('dingle',),
'dinglete': ('dingle',),
'dinglede': ('dingle',),
'dingla': ('dingle',),
'dinglete': ('dingle',),
'dinglede': ('dingle',),
'dinglete': ('dingle',),
'dinglede': ('dingle',),
'dinglende': ('dingle',),
'dionysisk': ('dionysisk',),
'dionysiske': ('dionysisk',),
'dionysisk': ('dionysisk',),
'diploid': ('diploid',),
'diploide': ('diploid',),
'diploid': ('diploid',),
'diplomatarisk': ('diplomatarisk',),
'diplomatariske': ('diplomatarisk',),
'diplomatarisk': ('diplomatarisk',),
'diplomatisk': ('diplomatisk',),
'diplomatiske': ('diplomatisk',),
'diplomatisk': ('diplomatisk',),
'direkte': ('direkte',),
'direktekobla': ('direktekobla',),
'direktekoblet': ('direktekoblet',),
'direktekoblete': ('direktekoblet',),
'direktekoblede': ('direktekoblet',),
'direktekoblete': ('direktekoblet',),
'direktekoblede': ('direktekoblet',),
'direktekoblet': ('direktekoblet',),
'direktekopla': ('direktekopla',),
'direktekoplet': ('direktekoplet',),
'direktekoplete': ('direktekoplet',),
'direktekoplede': ('direktekoplet',),
'direktekoplete': ('direktekoplet',),
'direktekoplede': ('direktekoplet',),
'direktekoplet': ('direktekoplet',),
'direktiv': ('direktiv',),
'direktive': ('direktiv',),
'direktivt': ('direktiv',),
'dirigert': ('dirigere',),
'dirigerte': ('dirigere',),
'dirigerende': ('dirigere',),
'dirka': ('dirke',),
'dirket': ('dirke',),
'dirka': ('dirke',),
'dirket': ('dirke',),
'dirka': ('dirke',),
'dirkete': ('dirke',),
'dirkede': ('dirke',),
'dirka': ('dirke',),
'dirkete': ('dirke',),
'dirkede': ('dirke',),
'dirkende': ('dirke',),
'dirkefri': ('dirkefri',),
'dirkefrie': ('dirkefri',),
'dirkefritt': ('dirkefri',),
'dirra': ('dirre',),
'dirret': ('dirre',),
'dirra': ('dirre',),
'dirret': ('dirre',),
'dirra': ('dirre',),
'dirrete': ('dirre',),
'dirrede': ('dirre',),
'dirra': ('dirre',),
'dirrete': ('dirre',),
'dirrede': ('dirre',),
'dirrende': ('dirre',),
'diset': ('diset',),
'disete': ('diset',),
'diset': ('diset',),
'disete': ('disete',),
'disharmonisk': ('disharmonisk',),
'disharmoniske': ('disharmonisk',),
'disharmonisk': ('disharmonisk',),
'disig': ('disig',),
'disige': ('disig',),
'disig': ('disig',),
'disiplinert': ('disiplinere',),
'disiplinerte': ('disiplinere',),
'disiplinerende': ('disiplinere',),
'disiplinær': ('disiplinær',),
'disiplinære': ('disiplinær',),
'disiplinært': ('disiplinær',),
'disjunktiv': ('disjunktiv',),
'disjunktive': ('disjunktiv',),
'disjunktivt': ('disjunktiv',),
'diska': ('diske',),
'disket': ('diske',),
'diska': ('diske',),
'disket': ('diske',),
'diska': ('diske',),
'diskete': ('diske',),
'diskede': ('diske',),
'diska': ('diske',),
'diskete': ('diske',),
'diskede': ('diske',),
'diskende': ('diske',),
'diskontert': ('diskontere',),
'diskonterte': ('diskontere',),
'diskonterende': ('diskontere',),
'diskontinuerlig': ('diskontinuerlig',),
'diskontinuerlige': ('diskontinuerlig',),
'diskontinuerlig': ('diskontinuerlig',),
'diskré': ('diskré',),
'diskree': ('diskré',),
'diskré': ('diskré',),
'diskrée': ('diskré',),
'diskree': ('diskré',),
'diskré': ('diskré',),
'diskrée': ('diskré',),
'diskré': ('diskré',),
'diskreditert': ('diskreditere',),
'diskrediterte': ('diskreditere',),
'diskrediterende': ('diskreditere',),
'diskret': ('diskret',),
'diskrete': ('diskret',),
'diskret': ('diskret',),
'diskriminert': ('diskriminere',),
'diskriminerte': ('diskriminere',),
'diskriminerende': ('diskriminere',),
'diskursiv': ('diskursiv',),
'diskursive': ('diskursiv',),
'diskursivt': ('diskursiv',),
'diskutabel': ('diskutabel',),
'diskutable': ('diskutabel',),
'diskutabelt': ('diskutabel',),
'diskutert': ('diskutere',),
'diskuterte': ('diskutere',),
'diskuterende': ('diskutere',),
'diskvalifisert': ('diskvalifisere',),
'diskvalifiserte': ('diskvalifisere',),
'diskvalifiserende': ('diskvalifisere',),
'dispasjert': ('dispasjere',),
'dispasjerte': ('dispasjere',),
'dispasjerende': ('dispasjere',),
'dispensert': ('dispensere',),
'dispenserte': ('dispensere',),
'dispenserende': ('dispensere',),
'disponert': ('disponere',),
'disponerte': ('disponere',),
'disponerende': ('disponere',),
'disponibel': ('disponibel',),
'disponible': ('disponibel',),
'disponibelt': ('disponibel',),
'disputert': ('disputere',),
'disputerte': ('disputere',),
'disputerende': ('disputere',),
'dissa': ('disse',),
'disset': ('disse',),
'dissa': ('disse',),
'disset': ('disse',),
'dissa': ('disse',),
'dissete': ('disse',),
'dissede': ('disse',),
'dissa': ('disse',),
'dissete': ('disse',),
'dissede': ('disse',),
'dissende': ('disse',),
'dissekert': ('dissekere',),
'dissekerte': ('dissekere',),
'dissekerende': ('dissekere',),
'dissentert': ('dissentere',),
'dissenterte': ('dissentere',),
'dissenterende': ('dissentere',),
'dissimilert': ('dissimilere',),
'dissimilerte': ('dissimilere',),
'dissimilerende': ('dissimilere',),
'dissonert': ('dissonere',),
'dissonerte': ('dissonere',),
'dissonerende': ('dissonere',),
'dissosiert': ('dissosiere',),
'dissosierte': ('dissosiere',),
'dissosierende': ('dissosiere',),
'distansert': ('distansere',),
'distanserte': ('distansere',),
'distanserende': ('distansere',),
'distingvert': ('distingvere',),
'distingverte': ('distingvere',),
'distingverende': ('distingvere',),
'distingvert': ('distingvert',),
'distingverte': ('distingvert',),
'distingvert': ('distingvert',),
'distinkt': ('distinkt',),
'distinkte': ('distinkt',),
'distinkt': ('distinkt',),
'distinktiv': ('distinktiv',),
'distinktive': ('distinktiv',),
'distinktivt': ('distinktiv',),
'distré': ('distré',),
'distree': ('distré',),
'distré': ('distré',),
'distrée': ('distré',),
'distree': ('distré',),
'distré': ('distré',),
'distrée': ('distré',),
'distré': ('distré',),
'distrahert': ('distrahere',),
'distraherte': ('distrahere',),
'distraherende': ('distrahere',),
'distribuert': ('distribuere',),
'distribuerte': ('distribuere',),
'distribuerende': ('distribuere',),
'distributiv': ('distributiv',),
'distributive': ('distributiv',),
'distributivt': ('distributiv',),
'divergent': ('divergent',),
'divergente': ('divergent',),
'divergent': ('divergent',),
'divergert': ('divergere',),
'divergerte': ('divergere',),
'divergerende': ('divergere',),
'diverse': ('diverse',),
'divertert': ('divertere',),
'diverterte': ('divertere',),
'diverterende': ('divertere',),
'dividert': ('dividere',),
'dividerte': ('dividere',),
'dividerende': ('dividere',),
'diøcisk': ('diøcisk',),
'diøciske': ('diøcisk',),
'diøcisk': ('diøcisk',),
'djerv': ('djerv',),
'djerve': ('djerv',),
'djervt': ('djerv',),
'djervere': ('djerv',),
'djervest': ('djerv',),
'djerveste': ('djerv',),
'djevelsk': ('djevelsk',),
'djevelske': ('djevelsk',),
'djevelsk': ('djevelsk',),
'djevla': ('djevla',),
'djevlebesatt': ('djevlebesatt',),
'djevlebesatte': ('djevlebesatt',),
'djevlebesatt': ('djevlebesatt',),
'djevlig': ('djevlig',),
'djevlige': ('djevlig',),
'djevlig': ('djevlig',),
'djevligere': ('djevlig',),
'djevligst': ('djevlig',),
'djevligste': ('djevlig',),
'djiboutisk': ('djiboutisk',),
'djiboutiske': ('djiboutisk',),
'djiboutisk': ('djiboutisk',),
'djup': ('djup',),
'djupe': ('djup',),
'djupt': ('djup',),
'djupere': ('djup',),
'djupest': ('djup',),
'djupeste': ('djup',),
'djupblå': ('djupblå',),
'djupblåe': ('djupblå',),
'djupblå': ('djupblå',),
'djupblåe': ('djupblå',),
'djupblå': ('djupblå',),
'djupblått': ('djupblå',),
'djuperegående': ('djuperegående',),
'djupereliggende': ('djupereliggende',),
'djupetsa': ('djupetse',),
'djupetset': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetset': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetsete': ('djupetse',),
'djupetsede': ('djupetse',),
'djupetsa': ('djupetse',),
'djupetsete': ('djupetse',),
'djupetsede': ('djupetse',),
'djupetsende': ('djupetse',),
'djupfryst': ('djupfryse',),
'djupfryste': ('djupfryse',),
'djupfrysende': ('djupfryse',),
'djupfølt': ('djupfølt',),
'djupfølte': ('djupfølt',),
'djupfølt': ('djupfølt',),
'djuplendt': ('djuplendt',),
'djuplendte': ('djuplendt',),
'djuplendt': ('djuplendt',),
'djupna': ('djupne',),
'djupnet': ('djupne',),
'djupna': ('djupne',),
'djupnet': ('djupne',),
'djupna': ('djupne',),
'djupnete': ('djupne',),
'djupnede': ('djupne',),
'djupnete': ('djupne',),
'djupnede': ('djupne',),
'djupna': ('djupne',),
'djupnete': ('djupne',),
'djupnede': ('djupne',),
'djupnete': ('djupne',),
'djupnede': ('djupne',),
'djupnende': ('djupne',),
'djuprød': ('djuprød',),
'djuprøde': ('djuprød',),
'djuprødt': ('djuprød',),
'djupsindig': ('djupsindig',),
'djupsindige': ('djupsindig',),
'djupsindig': ('djupsindig',),
'djuptfølt': ('djuptfølt',),
'djuptfølte': ('djuptfølt',),
'djuptfølt': ('djuptfølt',),
'djuptgripende': ('djuptgripende',),
'djuptgående': ('djuptgående',),
'djuptloddende': ('djuptloddende',),
'djupttenkende': ('djupttenkende',),
'dobbel': ('dobbel',),
'doble': ('dobbel',),
'dobbelt': ('dobbel',),
'dobbelt': ('dobbelt',),
'dobbelte': ('dobbelt',),
'dobbelt': ('dobbelt',),
'dobbeltarbeidende': ('dobbeltarbeidende',),
'dobbeltbotna': ('dobbeltbotna',),
'dobbeltbotnet': ('dobbeltbotnet',),
'dobbeltbotnete': ('dobbeltbotnet',),
'dobbeltbotnede': ('dobbeltbotnet',),
'dobbeltbotnete': ('dobbeltbotnet',),
'dobbeltbotnede': ('dobbeltbotnet',),
'dobbeltbotnet': ('dobbeltbotnet',),
'dobbeltbunna': ('dobbeltbunna',),
'dobbeltbunnet': ('dobbeltbunnet',),
'dobbeltbunnete': ('dobbeltbunnet',),
'dobbeltbunnede': ('dobbeltbunnet',),
'dobbeltbunnete': ('dobbeltbunnet',),
'dobbeltbunnede': ('dobbeltbunnet',),
'dobbeltbunnet': ('dobbeltbunnet',),
'dobbeltknappa': ('dobbeltknappa',),
'dobbeltknappet': ('dobbeltknappet',),
'dobbeltknappete': ('dobbeltknappet',),
'dobbeltknappede': ('dobbeltknappet',),
'dobbeltknappete': ('dobbeltknappet',),
'dobbeltknappede': ('dobbeltknappet',),
'dobbeltknappet': ('dobbeltknappet',),
'dobbeltrensa': ('dobbeltrensa',),
'dobbeltrenset': ('dobbeltrenset',),
'dobbeltrensete': ('dobbeltrenset',),
'dobbeltrensede': ('dobbeltrenset',),
'dobbeltrensete': ('dobbeltrenset',),
'dobbeltrensede': ('dobbeltrenset',),
'dobbeltrenset': ('dobbeltrenset',),
'dobbeltsidig': ('dobbeltsidig',),
'dobbeltsidige': ('dobbeltsidig',),
'dobbeltsidig': ('dobbeltsidig',),
'dobbeltspora': ('dobbeltspora',),
'dobbeltsporet': ('dobbeltsporet',),
'dobbeltsporete': ('dobbeltsporet',),
'dobbeltsporede': ('dobbeltsporet',),
'dobbeltsporete': ('dobbeltsporet',),
'dobbeltsporede': ('dobbeltsporet',),
'dobbeltsporet': ('dobbeltsporet',),
'dobla': ('doble',),
'doblet': ('doble',),
'dobla': ('doble',),
'doblet': ('doble',),
'dobla': ('doble',),
'doblete': ('doble',),
'doblede': ('doble',),
'doblete': ('doble',),
'doblede': ('doble',),
'dobla': ('doble',),
'doblete': ('doble',),
'doblede': ('doble',),
'doblete': ('doble',),
'doblede': ('doble',),
'doblende': ('doble',),
'dogga': ('dogge',),
'dogget': ('dogge',),
'dogga': ('dogge',),
'dogget': ('dogge',),
'dogga': ('dogge',),
'doggete': ('dogge',),
'doggede': ('dogge',),
'dogga': ('dogge',),
'doggete': ('dogge',),
'doggede': ('dogge',),
'doggende': ('dogge',),
'dogget': ('dogget',),
'doggete': ('dogget',),
'dogget': ('dogget',),
'doggete': ('doggete',),
'doggfri': ('doggfri',),
'doggfrie': ('doggfri',),
'doggfritt': ('doggfri',),
'doggfrisk': ('doggfrisk',),
'doggfriske': ('doggfrisk',),
'doggfriskt': ('doggfrisk',),
'doggvåt': ('doggvåt',),
'doggvåte': ('doggvåt',),
'doggvått': ('doggvåt',),
'dogmatisk': ('dogmatisk',),
'dogmatiske': ('dogmatisk',),
'dogmatisk': ('dogmatisk',),
'dokka': ('dokke',),
'dokket': ('dokke',),
'dokka': ('dokke',),
'dokket': ('dokke',),
'dokka': ('dokke',),
'dokkete': ('dokke',),
'dokkede': ('dokke',),
'dokka': ('dokke',),
'dokkete': ('dokke',),
'dokkede': ('dokke',),
'dokkende': ('dokke',),
'dokkeaktig': ('dokkeaktig',),
'dokkeaktige': ('dokkeaktig',),
'dokkeaktig': ('dokkeaktig',),
'dokksatt': ('dokksette',),
'dokksatte': ('dokksette',),
'dokksettende': ('dokksette',),
'doktorert': ('doktorere',),
'doktorerte': ('doktorere',),
'doktorerende': ('doktorere',),
'doktrinær': ('doktrinær',),
'doktrinære': ('doktrinær',),
'doktrinært': ('doktrinær',),
'dokumentarisk': ('dokumentarisk',),
'dokumentariske': ('dokumentarisk',),
'dokumentarisk': ('dokumentarisk',),
'dokumentert': ('dokumentere',),
'dokumenterte': ('dokumentere',),
'dokumenterende': ('dokumentere',),
'dolka': ('dolke',),
'dolket': ('dolke',),
'dolka': ('dolke',),
'dolket': ('dolke',),
'dolka': ('dolke',),
'dolkete': ('dolke',),
'dolkede': ('dolke',),
'dolka': ('dolke',),
'dolkete': ('dolke',),
'dolkede': ('dolke',),
'dolkende': ('dolke',),
'domfelt': ('domfelle',),
'domfelte': ('domfelle',),
'domfellende': ('domfelle',),
'dominant': ('dominant',),
'dominante': ('dominant',),
'dominant': ('dominant',),
'dominert': ('dominere',),
'dominerte': ('dominere',),
'dominerende': ('dominere',),
'dominerende': ('dominerende',),
'dominikansk': ('dominikansk',),
'dominikanske': ('dominikansk',),
'dominikansk': ('dominikansk',),
'dominikisk': ('dominikisk',),
'dominikiske': ('dominikisk',),
'dominikisk': ('dominikisk',),
'domisiliert': ('domisiliere',),
'domisilierte': ('domisiliere',),
'domisilierende': ('domisiliere',),
'donert': ('donere',),
'donerte': ('donere',),
'donerende': ('donere',),
'dopa': ('dope',),
'dopet': ('dope',),
'dopa': ('dope',),
'dopet': ('dope',),
'dopa': ('dope',),
'dopete': ('dope',),
'dopede': ('dope',),
'dopa': ('dope',),
'dopete': ('dope',),
'dopede': ('dope',),
'dopende': ('dope',),
'dora': ('dore',),
'doret': ('dore',),
'dort': ('dore',),
'dora': ('dore',),
'doret': ('dore',),
'dort': ('dore',),
'dora': ('dore',),
'dorete': ('dore',),
'dorede': ('dore',),
'dorte': ('dore',),
'dora': ('dore',),
'dorete': ('dore',),
'dorede': ('dore',),
'dorte': ('dore',),
'dorende': ('dore',),
'dorga': ('dorge',),
'dorget': ('dorge',),
'dorga': ('dorge',),
'dorget': ('dorge',),
'dorga': ('dorge',),
'dorgete': ('dorge',),
'dorgede': ('dorge',),
'dorga': ('dorge',),
'dorgete': ('dorge',),
'dorgede': ('dorge',),
'dorgende': ('dorge',),
'dorisk': ('dorisk',),
'doriske': ('dorisk',),
'dorisk': ('dorisk',),
'dorma': ('dorme',),
'dormet': ('dorme',),
'dorma': ('dorme',),
'dormet': ('dorme',),
'dorma': ('dorme',),
'dormete': ('dorme',),
'dormede': ('dorme',),
'dorma': ('dorme',),
'dormete': ('dorme',),
'dormede': ('dorme',),
'dormende': ('dorme',),
'dorsal': ('dorsal',),
'dorsale': ('dorsal',),
'dorsalt': ('dorsal',),
'dorsk': ('dorsk',),
'dorske': ('dorsk',),
'dorskt': ('dorsk',),
'dorskere': ('dorsk',),
'dorskest': ('dorsk',),
'dorskeste': ('dorsk',),
'dosert': ('dosere',),
'doserte': ('dosere',),
'doserende': ('dosere',),
'dossert': ('dossere',),
'dosserte': ('dossere',),
'dosserende': ('dossere',),
'dotert': ('dotere',),
'doterte': ('dotere',),
'doterende': ('dotere',),
'dottet': ('dottet',),
'dottete': ('dottet',),
'dottet': ('dottet',),
'dottete': ('dottete',),
'dov': ('dov',),
'dove': ('dov',),
'dovt': ('dov',),
'doven': ('doven',),
'dovne': ('doven',),
'dovent': ('doven',),
'dovnere': ('doven',),
'dovnest': ('doven',),
'dovneste': ('doven',),
'dovna': ('dovne',),
'dovnet': ('dovne',),
'dovna': ('dovne',),
'dovnet': ('dovne',),
'dovna': ('dovne',),
'dovnete': ('dovne',),
'dovnede': ('dovne',),
'dovnete': ('dovne',),
'dovnede': ('dovne',),
'dovna': ('dovne',),
'dovnete': ('dovne',),
'dovnede': ('dovne',),
'dovnete': ('dovne',),
'dovnede': ('dovne',),
'dovnende': ('dovne',),
'drabelig': ('drabelig',),
'drabelige': ('drabelig',),
'drabelig': ('drabelig',),
'dragen': ('dragen',),
'dragne': ('dragen',),
'draget': ('dragen',),
'dragende': ('dragende',),
'dragsa': ('dragse',),
'dragset': ('dragse',),
'dragsa': ('dragse',),
'dragset': ('dragse',),
'dragsa': ('dragse',),
'dragsete': ('dragse',),
'dragsede': ('dragse',),
'dragsa': ('dragse',),
'dragsete': ('dragse',),
'dragsede': ('dragse',),
'dragsende': ('dragse',),
'drakonisk': ('drakonisk',),
'drakoniske': ('drakonisk',),
'drakonisk': ('drakonisk',),
'dramatisert': ('dramatisere',),
'dramatiserte': ('dramatisere',),
'dramatiserende': ('dramatisere',),
'dramatisk': ('dramatisk',),
'dramatiske': ('dramatisk',),
'dramatisk': ('dramatisk',),
'dramaturgisk': ('dramaturgisk',),
'dramaturgiske': ('dramaturgisk',),
'dramaturgisk': ('dramaturgisk',),
'drapert': ('drapere',),
'draperte': ('drapere',),
'draperende': ('drapere',),
'drapsmistenkt': ('drapsmistenkt',),
'drapsmistenkte': ('drapsmistenkt',),
'drapsmistenkt': ('drapsmistenkt',),
'drasjert': ('drasjere',),
'drasjerte': ('drasjere',),
'drasjerende': ('drasjere',),
'drassa': ('drasse',),
'drasset': ('drasse',),
'drassa': ('drasse',),
'drasset': ('drasse',),
'drassa': ('drasse',),
'drassete': ('drasse',),
'drassede': ('drasse',),
'drassa': ('drasse',),
'drassete': ('drasse',),
'drassede': ('drasse',),
'drassende': ('drasse',),
'drastisk': ('drastisk',),
'drastiske': ('drastisk',),
'drastisk': ('drastisk',),
'dratta': ('dratte',),
'drattet': ('dratte',),
'dratta': ('dratte',),
'drattet': ('dratte',),
'dratta': ('dratte',),
'drattete': ('dratte',),
'drattede': ('dratte',),
'dratta': ('dratte',),
'drattete': ('dratte',),
'drattede': ('dratte',),
'drattende': ('dratte',),
'draugbleik': ('draugbleik',),
'draugbleike': ('draugbleik',),
'draugbleikt': ('draugbleik',),
'draugblek': ('draugblek',),
'draugbleke': ('draugblek',),
'draugblekt': ('draugblek',),
'dravidisk': ('dravidisk',),
'dravidiske': ('dravidisk',),
'dravidisk': ('dravidisk',),
'dregga': ('dregge',),
'dregget': ('dregge',),
'dregga': ('dregge',),
'dregget': ('dregge',),
'dregga': ('dregge',),
'dreggete': ('dregge',),
'dreggede': ('dregge',),
'dregga': ('dregge',),
'dreggete': ('dregge',),
'dreggede': ('dregge',),
'dreggende': ('dregge',),
'dreibar': ('dreibar',),
'dreibare': ('dreibar',),
'dreibart': ('dreibar',),
'dreia': ('dreie',),
'dreiet': ('dreie',),
'dreid': ('dreie',),
'dreia': ('dreie',),
'dreiet': ('dreie',),
'dreid': ('dreie',),
'dreia': ('dreie',),
'dreiete': ('dreie',),
'dreiede': ('dreie',),
'dreide': ('dreie',),
'dreia': ('dreie',),
'dreiete': ('dreie',),
'dreiede': ('dreie',),
'dreide': ('dreie',),
'dreiende': ('dreie',),
'dreielig': ('dreielig',),
'dreielige': ('dreielig',),
'dreielig': ('dreielig',),
'dreist': ('dreise',),
'dreiste': ('dreise',),
'dreisende': ('dreise',),
'drektig': ('drektig',),
'drektige': ('drektig',),
'drektig': ('drektig',),
'drent': ('drene',),
'drente': ('drene',),
'drenende': ('drene',),
'drenert': ('drenere',),
'drenerte': ('drenere',),
'drenerende': ('drenere',),
'drept': ('drepe',),
'drepte': ('drepe',),
'drepende': ('drepe',),
'drepende': ('drepende',),
'dressa': ('dresse',),
'dresset': ('dresse',),
'dressa': ('dresse',),
'dresset': ('dresse',),
'dressa': ('dresse',),
'dressete': ('dresse',),
'dressede': ('dresse',),
'dressa': ('dresse',),
'dressete': ('dresse',),
'dressede': ('dresse',),
'dressende': ('dresse',),
'dressert': ('dressere',),
'dresserte': ('dressere',),
'dresserende': ('dressere',),
'dretta': ('drette',),
'drettet': ('drette',),
'dretta': ('drette',),
'drettet': ('drette',),
'dretta': ('drette',),
'drettete': ('drette',),
'drettede': ('drette',),
'dretta': ('drette',),
'drettete': ('drette',),
'drettede': ('drette',),
'drettende': ('drette',),
'dreven': ('dreven',),
'drevne': ('dreven',),
'drevent': ('dreven',),
'dribla': ('drible',),
'driblet': ('drible',),
'dribla': ('drible',),
'driblet': ('drible',),
'dribla': ('drible',),
'driblete': ('drible',),
'driblede': ('drible',),
'driblete': ('drible',),
'driblede': ('drible',),
'dribla': ('drible',),
'driblete': ('drible',),
'driblede': ('drible',),
'driblete': ('drible',),
'driblede': ('drible',),
'driblende': ('drible',),
'drifta': ('drifte',),
'driftet': ('drifte',),
'drifta': ('drifte',),
'driftet': ('drifte',),
'drifta': ('drifte',),
'driftete': ('drifte',),
'driftede': ('drifte',),
'drifta': ('drifte',),
'driftete': ('drifte',),
'driftede': ('drifte',),
'driftende': ('drifte',),
'driftig': ('driftig',),
'driftige': ('driftig',),
'driftig': ('driftig',),
'driftigere': ('driftig',),
'driftigst': ('driftig',),
'driftigste': ('driftig',),
'driftsmessig': ('driftsmessig',),
'driftsmessige': ('driftsmessig',),
'driftsmessig': ('driftsmessig',),
'driftssikker': ('driftssikker',),
'driftssikre': ('driftssikker',),
'driftssikkert': ('driftssikker',),
'drukket': ('drikke',),
'drukken': ('drikke',),
'drukne': ('drikke',),
'drikkende': ('drikke',),
'drikkelig': ('drikkelig',),
'drikkelige': ('drikkelig',),
'drikkelig': ('drikkelig',),
'drikkfeldig': ('drikkfeldig',),
'drikkfeldige': ('drikkfeldig',),
'drikkfeldig': ('drikkfeldig',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilla': ('drille',),
'drillete': ('drille',),
'drillede': ('drille',),
'drilla': ('drille',),
'drillete': ('drille',),
'drillede': ('drille',),
'drillende': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drilla': ('drille',),
'drillet': ('drille',),
'drilt': ('drille',),
'drilla': ('drille',),
'drillete': ('drille',),
'drillede': ('drille',),
'drilte': ('drille',),
'drilla': ('drille',),
'drillete': ('drille',),
'drillede': ('drille',),
'drilte': ('drille',),
'drillende': ('drille',),
'drista': ('driste',),
'dristet': ('driste',),
'drista': ('driste',),
'dristet': ('driste',),
'drista': ('driste',),
'dristete': ('driste',),
'dristede': ('driste',),
'drista': ('driste',),
'dristete': ('driste',),
'dristede': ('driste',),
'dristende': ('driste',),
'dristig': ('dristig',),
'dristige': ('dristig',),
'dristig': ('dristig',),
'dristigere': ('dristig',),
'dristigst': ('dristig',),
'dristigste': ('dristig',),
'dritt': ('drite',),
'dritet': ('drite',),
'dritt': ('drite',),
'dritet': ('drite',),
'driten': ('drite',),
'dritte': ('drite',),
'dritne': ('drite',),
'dritte': ('drite',),
'dritne': ('drite',),
'dritende': ('drite',),
'drittlei': ('drittlei',),
'drittleie': ('drittlei',),
'drittleit': ('drittlei',),
'drevet': ('drive',),
'dreven': ('drive',),
'drevne': ('drive',),
'drivende': ('drive',),
'drivende': ('drivende',),
'drivendes': ('drivendes',),
'drivhvit': ('drivhvit',),
'drivhvite': ('drivhvit',),
'drivhvitt': ('drivhvit',),
'drivkvit': ('drivkvit',),
'drivkvite': ('drivkvit',),
'drivkvitt': ('drivkvit',),
'drivverdig': ('drivverdig',),
'drivverdige': ('drivverdig',),
'drivverdig': ('drivverdig',),
'drivvåt': ('drivvåt',),
'drivvåte': ('drivvåt',),
'drivvått': ('drivvåt',),
'drodla': ('drodle',),
'drodlet': ('drodle',),
'drodla': ('drodle',),
'drodlet': ('drodle',),
'drodla': ('drodle',),
'drodlete': ('drodle',),
'drodlede': ('drodle',),
'drodlete': ('drodle',),
'drodlede': ('drodle',),
'drodla': ('drodle',),
'drodlete': ('drodle',),
'drodlede': ('drodle',),
'drodlete': ('drodle',),
'drodlede': ('drodle',),
'drodlende': ('drodle',),
'droplet': ('droplet',),
'droplete': ('droplet',),
'droplet': ('droplet',),
'droplete': ('droplete',),
'droppa': ('droppe',),
'droppet': ('droppe',),
'droppa': ('droppe',),
'droppet': ('droppe',),
'droppa': ('droppe',),
'droppete': ('droppe',),
'droppede': ('droppe',),
'droppa': ('droppe',),
'droppete': ('droppe',),
'droppede': ('droppe',),
'droppende': ('droppe',),
'drukken': ('drukken',),
'drukne': ('drukken',),
'drukkent': ('drukken',),
'drukna': ('drukne',),
'druknet': ('drukne',),
'drukna': ('drukne',),
'druknet': ('drukne',),
'drukna': ('drukne',),
'druknete': ('drukne',),
'druknede': ('drukne',),
'druknete': ('drukne',),
'druknede': ('drukne',),
'drukna': ('drukne',),
'druknete': ('drukne',),
'druknede': ('drukne',),
'druknete': ('drukne',),
'druknede': ('drukne',),
'druknende': ('drukne',),
'drusisk': ('drusisk',),
'drusiske': ('drusisk',),
'drusisk': ('drusisk',),
'dry': ('dry',),
'dryg': ('dryg',),
'dryge': ('dryg',),
'drygt': ('dryg',),
'drygere': ('dryg',),
'drygest': ('dryg',),
'drygeste': ('dryg',),
'drygd': ('dryge',),
'drygde': ('dryge',),
'drygende': ('dryge',),
'dryppa': ('dryppe',),
'dryppet': ('dryppe',),
'drypt': ('dryppe',),
'dryppa': ('dryppe',),
'dryppet': ('dryppe',),
'drypt': ('dryppe',),
'dryppa': ('dryppe',),
'dryppete': ('dryppe',),
'dryppede': ('dryppe',),
'drypte': ('dryppe',),
'dryppa': ('dryppe',),
'dryppete': ('dryppe',),
'dryppede': ('dryppe',),
'drypte': ('dryppe',),
'dryppende': ('dryppe',),
'dryppefri': ('dryppefri',),
'dryppefrie': ('dryppefri',),
'dryppefritt': ('dryppefri',),
'dryppfri': ('dryppfri',),
'dryppfrie': ('dryppfri',),
'dryppfritt': ('dryppfri',),
'drypptørka': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørkete': ('drypptørke',),
'drypptørkede': ('drypptørke',),
'drypptørka': ('drypptørke',),
'drypptørkete': ('drypptørke',),
'drypptørkede': ('drypptørke',),
'drypptørkende': ('drypptørke',),
'drypptørra': ('drypptørre',),
'drypptørret': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørret': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørrete': ('drypptørre',),
'drypptørrede': ('drypptørre',),
'drypptørra': ('drypptørre',),
'drypptørrete': ('drypptørre',),
'drypptørrede': ('drypptørre',),
'drypptørrende': ('drypptørre',),
'dryppvåt': ('dryppvåt',),
'dryppvåte': ('dryppvåt',),
'dryppvått': ('dryppvåt',),
'dryssa': ('drysse',),
'drysset': ('drysse',),
'dryst': ('drysse',),
'dryssa': ('drysse',),
'drysset': ('drysse',),
'dryst': ('drysse',),
'dryssa': ('drysse',),
'dryssete': ('drysse',),
'dryssede': ('drysse',),
'dryste': ('drysse',),
'dryssa': ('drysse',),
'dryssete': ('drysse',),
'dryssede': ('drysse',),
'dryste': ('drysse',),
'dryssende': ('drysse',),
'dråpeforma': ('dråpeforma',),
'dråpeformet': ('dråpeformet',),
'dråpeformete': ('dråpeformet',),
'dråpeformede': ('dråpeformet',),
'dråpeformete': ('dråpeformet',),
'dråpeformede': ('dråpeformet',),
'dråpeformet': ('dråpeformet',),
'drøfta': ('drøfte',),
'drøftet': ('drøfte',),
'drøfta': ('drøfte',),
'drøftet': ('drøfte',),
'drøfta': ('drøfte',),
'drøftete': ('drøfte',),
'drøftede': ('drøfte',),
'drøfta': ('drøfte',),
'drøftete': ('drøfte',),
'drøftede': ('drøfte',),
'drøftende': ('drøfte',),
'drømt': ('drømme',),
'drømte': ('drømme',),
'drømmende': ('drømme',),
'drømmende': ('drømmende',),
'drønna': ('drønne',),
'drønnet': ('drønne',),
'drønt': ('drønne',),
'drønna': ('drønne',),
'drønnet': ('drønne',),
'drønt': ('drønne',),
'drønna': ('drønne',),
'drønnete': ('drønne',),
'drønnede': ('drønne',),
'drønte': ('drønne',),
'drønna': ('drønne',),
'drønnete': ('drønne',),
'drønnede': ('drønne',),
'drønte': ('drønne',),
'drønnende': ('drønne',),
'drøst': ('drøse',),
'drøste': ('drøse',),
'drøsende': ('drøse',),
'drøvtygget': ('drøvtygge',),
'drøvtygd': ('drøvtygge',),
'drøvtygget': ('drøvtygge',),
'drøvtygd': ('drøvtygge',),
'drøvtyggete': ('drøvtygge',),
'drøvtyggede': ('drøvtygge',),
'drøvtygde': ('drøvtygge',),
'drøvtyggete': ('drøvtygge',),
'drøvtyggede': ('drøvtygge',),
'drøvtygde': ('drøvtygge',),
'drøvtyggende': ('drøvtygge',),
'drøy': ('drøy',),
'drøye': ('drøy',),
'drøyt': ('drøy',),
'drøyere': ('drøy',),
'drøyest': ('drøy',),
'drøyeste': ('drøy',),
'drøyd': ('drøye',),
'drøyde': ('drøye',),
'drøyende': ('drøye',),
'dualistisk': ('dualistisk',),
'dualistiske': ('dualistisk',),
'dualistisk': ('dualistisk',),
'dubba': ('dubbe',),
'dubbet': ('dubbe',),
'dubba': ('dubbe',),
'dubbet': ('dubbe',),
'dubba': ('dubbe',),
'dubbete': ('dubbe',),
'dubbede': ('dubbe',),
'dubba': ('dubbe',),
'dubbete': ('dubbe',),
'dubbede': ('dubbe',),
'dubbende': ('dubbe',),
'dubiøs': ('dubiøs',),
'dubiøse': ('dubiøs',),
'dubiøst': ('dubiøs',),
'dublert': ('dublere',),
'dublerte': ('dublere',),
'dublerende': ('dublere',),
'dueblå': ('dueblå',),
'dueblåe': ('dueblå',),
'dueblå': ('dueblå',),
'dueblåe': ('dueblå',),
'dueblå': ('dueblå',),
'dueblått': ('dueblå',),
'duellert': ('duellere',),
'duellerte': ('duellere',),
'duellerende': ('duellere',),
'dufta': ('dufte',),
'duftet': ('dufte',),
'dufta': ('dufte',),
'duftet': ('dufte',),
'dufta': ('dufte',),
'duftete': ('dufte',),
'duftede': ('dufte',),
'dufta': ('dufte',),
'duftete': ('dufte',),
'duftede': ('dufte',),
'duftende': ('dufte',),
'dugd': ('duge',),
'dugde': ('duge',),
'dugende': ('duge',),
'dugelig': ('dugelig',),
'dugelige': ('dugelig',),
'dugelig': ('dugelig',),
'dugga': ('dugge',),
'dugget': ('dugge',),
'dugga': ('dugge',),
'dugget': ('dugge',),
'dugga': ('dugge',),
'duggete': ('dugge',),
'duggede': ('dugge',),
'dugga': ('dugge',),
'duggete': ('dugge',),
'duggede': ('dugge',),
'duggende': ('dugge',),
'dugget': ('dugget',),
'duggete': ('dugget',),
'dugget': ('dugget',),
'duggete': ('duggete',),
'duggfri': ('duggfri',),
'duggfrie': ('duggfri',),
'duggfritt': ('duggfri',),
'duggfrisk': ('duggfrisk',),
'duggfriske': ('duggfrisk',),
'duggfriskt': ('duggfrisk',),
'duggvåt': ('duggvåt',),
'duggvåte': ('duggvåt',),
'duggvått': ('duggvåt',),
'duka': ('duke',),
'duket': ('duke',),
'duka': ('duke',),
'duket': ('duke',),
'duka': ('duke',),
'dukete': ('duke',),
'dukede': ('duke',),
'duka': ('duke',),
'dukete': ('duke',),
'dukede': ('duke',),
'dukende': ('duke',),
'dukka': ('dukke',),
'dukket': ('dukke',),
'dukka': ('dukke',),
'dukket': ('dukke',),
'dukka': ('dukke',),
'dukkete': ('dukke',),
'dukkede': ('dukke',),
'dukka': ('dukke',),
'dukkete': ('dukke',),
'dukkede': ('dukke',),
'dukkende': ('dukke',),
'dukkeaktig': ('dukkeaktig',),
'dukkeaktige': ('dukkeaktig',),
'dukkeaktig': ('dukkeaktig',),
'dukknakka': ('dukknakka',),
'dukknakket': ('dukknakket',),
'dukknakkete': ('dukknakket',),
'dukknakkede': ('dukknakket',),
'dukknakkete': ('dukknakket',),
'dukknakkede': ('dukknakket',),
'dukknakket': ('dukknakket',),
'dulgt': ('dulgt',),
'dulgte': ('dulgt',),
'dulgt': ('dulgt',),
'dulla': ('dulle',),
'dullet': ('dulle',),
'dulla': ('dulle',),
'dullet': ('dulle',),
'dulla': ('dulle',),
'dullete': ('dulle',),
'dullede': ('dulle',),
'dulla': ('dulle',),
'dullete': ('dulle',),
'dullede': ('dulle',),
'dullende': ('dulle',),
'dulma': ('dulme',),
'dulmet': ('dulme',),
'dulma': ('dulme',),
'dulmet': ('dulme',),
'dulma': ('dulme',),
'dulmete': ('dulme',),
'dulmede': ('dulme',),
'dulma': ('dulme',),
'dulmete': ('dulme',),
'dulmede': ('dulme',),
'dulmende': ('dulme',),
'dulta': ('dulte',),
'dultet': ('dulte',),
'dulta': ('dulte',),
'dultet': ('dulte',),
'dulta': ('dulte',),
'dultete': ('dulte',),
'dultede': ('dulte',),
'dulta': ('dulte',),
'dultete': ('dulte',),
'dultede': ('dulte',),
'dultende': ('dulte',),
'dum': ('dum',),
'dumme': ('dum',),
'dumt': ('dum',),
'dummere': ('dum',),
'dummest': ('dum',),
'dummeste': ('dum',),
'dumdristig': ('dumdristig',),
'dumdristige': ('dumdristig',),
'dumdristig': ('dumdristig',),
'dumma': ('dumme',),
'dummet': ('dumme',),
'dumma': ('dumme',),
'dummet': ('dumme',),
'dumma': ('dumme',),
'dummete': ('dumme',),
'dummede': ('dumme',),
'dumma': ('dumme',),
'dummete': ('dumme',),
'dummede': ('dumme',),
'dummende': ('dumme',),
'dump': ('dump',),
'dumpe': ('dump',),
'dumpt': ('dump',),
'dumpa': ('dumpe',),
'dumpet': ('dumpe',),
'dumpa': ('dumpe',),
'dumpet': ('dumpe',),
'dumpa': ('dumpe',),
'dumpete': ('dumpe',),
'dumpede': ('dumpe',),
'dumpa': ('dumpe',),
'dumpete': ('dumpe',),
'dumpede': ('dumpe',),
'dumpende': ('dumpe',),
'dumpet': ('dumpet',),
'dumpete': ('dumpet',),
'dumpet': ('dumpet',),
'dumpete': ('dumpete',),
'dumsnill': ('dumsnill',),
'dumsnille': ('dumsnill',),
'dumsnilt': ('dumsnill',),
'dumstolt': ('dumstolt',),
'dumstolte': ('dumstolt',),
'dumstolt': ('dumstolt',),
'dunbløt': ('dunbløt',),
'dunbløte': ('dunbløt',),
'dunbløtt': ('dunbløt',),
'dundra': ('dundre',),
'dundret': ('dundre',),
'dundra': ('dundre',),
'dundret': ('dundre',),
'dundra': ('dundre',),
'dundrete': ('dundre',),
'dundrede': ('dundre',),
'dundrete': ('dundre',),
'dundrede': ('dundre',),
'dundra': ('dundre',),
'dundrete': ('dundre',),
'dundrede': ('dundre',),
'dundrete': ('dundre',),
'dundrede': ('dundre',),
'dundrende': ('dundre',),
'dundrende': ('dundrende',),
'dunet': ('dunet',),
'dunete': ('dunet',),
'dunet': ('dunet',),
'dunete': ('dunete',),
'dunga': ('dunge',),
'dunget': ('dunge',),
'dunga': ('dunge',),
'dunget': ('dunge',),
'dunga': ('dunge',),
'dungete': ('dunge',),
'dungede': ('dunge',),
'dunga': ('dunge',),
'dungete': ('dunge',),
'dungede': ('dunge',),
'dungende': ('dunge',),
'dunhåra': ('dunhåra',),
'dunhåret': ('dunhåret',),
'dunhårete': ('dunhåret',),
'dunhårede': ('dunhåret',),
'dunhårete': ('dunhåret',),
'dunhårede': ('dunhåret',),
'dunhåret': ('dunhåret',),
'dunka': ('dunke',),
'dunket': ('dunke',),
'dunka': ('dunke',),
'dunket': ('dunke',),
'dunka': ('dunke',),
'dunkete': ('dunke',),
'dunkede': ('dunke',),
'dunka': ('dunke',),
'dunkete': ('dunke',),
'dunkede': ('dunke',),
'dunkende': ('dunke',),
'dunkel': ('dunkel',),
'dunkle': ('dunkel',),
'dunkelt': ('dunkel',),
'dunklere': ('dunkel',),
'dunklest': ('dunkel',),
'dunkleste': ('dunkel',),
'dunkledd': ('dunkledd',),
'dunkledde': ('dunkledd',),
'dunkledd': ('dunkledd',),
'dunlett': ('dunlett',),
'dunlette': ('dunlett',),
'dunlett': ('dunlett',),
'dunsta': ('dunste',),
'dunstet': ('dunste',),
'dunsta': ('dunste',),
'dunstet': ('dunste',),
'dunsta': ('dunste',),
'dunstete': ('dunste',),
'dunstede': ('dunste',),
'dunsta': ('dunste',),
'dunstete': ('dunste',),
'dunstede': ('dunste',),
'dunstende': ('dunste',),
'dupert': ('dupere',),
'duperte': ('dupere',),
'duperende': ('dupere',),
'duplisert': ('duplisere',),
'dupliserte': ('duplisere',),
'dupliserende': ('duplisere',),
'duppa': ('duppe',),
'duppet': ('duppe',),
'duppa': ('duppe',),
'duppet': ('duppe',),
'duppa': ('duppe',),
'duppete': ('duppe',),
'duppede': ('duppe',),
'duppa': ('duppe',),
'duppete': ('duppe',),
'duppede': ('duppe',),
'duppende': ('duppe',),
'durabel': ('durabel',),
'durable': ('durabel',),
'durabelt': ('durabel',),
'durabelig': ('durabelig',),
'durabelige': ('durabelig',),
'durabelig': ('durabelig',),
'durativ': ('durativ',),
'durative': ('durativ',),
'durativt': ('durativ',),
'dura': ('dure',),
'duret': ('dure',),
'durt': ('dure',),
'dura': ('dure',),
'duret': ('dure',),
'durt': ('dure',),
'dura': ('dure',),
'durete': ('dure',),
'durede': ('dure',),
'durte': ('dure',),
'dura': ('dure',),
'durete': ('dure',),
'durede': ('dure',),
'durte': ('dure',),
'durende': ('dure',),
'durkdreven': ('durkdreven',),
'durkdrevne': ('durkdreven',),
'durkdrevent': ('durkdreven',),
'durksydd': ('durksy',),
'durksydde': ('durksy',),
'durksyende': ('durksy',),
'dus': ('dus',),
'duse': ('dus',),
'dust': ('dus',),
'dusere': ('dus',),
'dusest': ('dus',),
'duseste': ('dus',),
'dust': ('duse',),
'duste': ('duse',),
'dusende': ('duse',),
'dusement': ('dusement',),
'dusemente': ('dusement',),
'dusement': ('dusement',),
'dusja': ('dusje',),
'dusjet': ('dusje',),
'dusja': ('dusje',),
'dusjet': ('dusje',),
'dusja': ('dusje',),
'dusjete': ('dusje',),
'dusjede': ('dusje',),
'dusja': ('dusje',),
'dusjete': ('dusje',),
'dusjede': ('dusje',),
'dusjende': ('dusje',),
'duskregna': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnt': ('duskregne',),
'duskregna': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnt': ('duskregne',),
'duskregna': ('duskregne',),
'duskregnete': ('duskregne',),
'duskregnede': ('duskregne',),
'duskregnte': ('duskregne',),
'duskregna': ('duskregne',),
'duskregnete': ('duskregne',),
'duskregnede': ('duskregne',),
'duskregnte': ('duskregne',),
'duskregnende': ('duskregne',),
'dustet': ('dustet',),
'dustete': ('dustet',),
'dustet': ('dustet',),
'dustete': ('dustete',),
'dutta': ('dutte',),
'duttet': ('dutte',),
'dutta': ('dutte',),
'duttet': ('dutte',),
'dutta': ('dutte',),
'duttete': ('dutte',),
'duttede': ('dutte',),
'dutta': ('dutte',),
'duttete': ('dutte',),
'duttede': ('dutte',),
'duttende': ('dutte',),
'duva': ('duve',),
'duvet': ('duve',),
'duvd': ('duve',),
'duva': ('duve',),
'duvet': ('duve',),
'duvd': ('duve',),
'duva': ('duve',),
'duvete': ('duve',),
'duvede': ('duve',),
'duvde': ('duve',),
'duva': ('duve',),
'duvete': ('duve',),
'duvede': ('duve',),
'duvde': ('duve',),
'duvende': ('duve',),
'dvask': ('dvask',),
'dvaske': ('dvask',),
'dvaskt': ('dvask',),
'dvaskere': ('dvask',),
'dvaskest': ('dvask',),
'dvaskeste': ('dvask',),
'dvelt': ('dvele',),
'dvelte': ('dvele',),
'dvelende': ('dvele',),
'dydd': ('dy',),
'dydde': ('dy',),
'dyende': ('dy',),
'dyadisk': ('dyadisk',),
'dyadiske': ('dyadisk',),
'dyadisk': ('dyadisk',),
'dydig': ('dydig',),
'dydige': ('dydig',),
'dydig': ('dydig',),
'dydsiret': ('dydsiret',),
'dydsirete': ('dydsiret',),
'dydsirede': ('dydsiret',),
'dydsirete': ('dydsiret',),
'dydsirede': ('dydsiret',),
'dydsiret': ('dydsiret',),
'dykka': ('dykke',),
'dykket': ('dykke',),
'dykka': ('dykke',),
'dykket': ('dykke',),
'dykka': ('dykke',),
'dykkete': ('dykke',),
'dykkede': ('dykke',),
'dykka': ('dykke',),
'dykkete': ('dykke',),
'dykkede': ('dykke',),
'dykkende': ('dykke',),
'dyktig': ('dyktig',),
'dyktige': ('dyktig',),
'dyktig': ('dyktig',),
'dyktigere': ('dyktig',),
'dyktigst': ('dyktig',),
'dyktigste': ('dyktig',),
'dyktiggjort': ('dyktiggjøre',),
'dyktiggjorte': ('dyktiggjøre',),
'dyktiggjørende': ('dyktiggjøre',),
'dynamisk': ('dynamisk',),
'dynamiske': ('dynamisk',),
'dynamisk': ('dynamisk',),
'dynastisk': ('dynastisk',),
'dynastiske': ('dynastisk',),
'dynastisk': ('dynastisk',),
'dynga': ('dynge',),
'dynget': ('dynge',),
'dynga': ('dynge',),
'dynget': ('dynge',),
'dynga': ('dynge',),
'dyngete': ('dynge',),
'dyngede': ('dynge',),
'dynga': ('dynge',),
'dyngete': ('dynge',),
'dyngede': ('dynge',),
'dyngende': ('dynge',),
'dynka': ('dynke',),
'dynket': ('dynke',),
'dynka': ('dynke',),
'dynket': ('dynke',),
'dynka': ('dynke',),
'dynkete': ('dynke',),
'dynkede': ('dynke',),
'dynka': ('dynke',),
'dynkete': ('dynke',),
'dynkede': ('dynke',),
'dynkende': ('dynke',),
'dyp': ('dyp',),
'dype': ('dyp',),
'dypt': ('dyp',),
'dypere': ('dyp',),
'dypest': ('dyp',),
'dypeste': ('dyp',),
'dypblå': ('dypblå',),
'dypblåe': ('dypblå',),
'dypblå': ('dypblå',),
'dypblåe': ('dypblå',),
'dypblå': ('dypblå',),
'dypblått': ('dypblå',),
'dyperegående': ('dyperegående',),
'dypereliggende': ('dypereliggende',),
'dypetsa': ('dypetse',),
'dypetset': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetset': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetsete': ('dypetse',),
'dypetsede': ('dypetse',),
'dypetsa': ('dypetse',),
'dypetsete': ('dypetse',),
'dypetsede': ('dypetse',),
'dypetsende': ('dypetse',),
'dypfryst': ('dypfryse',),
'dypfryste': ('dypfryse',),
'dypfrysende': ('dypfryse',),
'dyppa': ('dyppe',),
'dyppet': ('dyppe',),
'dyppa': ('dyppe',),
'dyppet': ('dyppe',),
'dyppa': ('dyppe',),
'dyppete': ('dyppe',),
'dyppede': ('dyppe',),
'dyppa': ('dyppe',),
'dyppete': ('dyppe',),
'dyppede': ('dyppe',),
'dyppende': ('dyppe',),
'dyprød': ('dyprød',),
'dyprøde': ('dyprød',),
'dyprødt': ('dyprød',),
'dypsindig': ('dypsindig',),
'dypsindige': ('dypsindig',),
'dypsindig': ('dypsindig',),
'dyptfølt': ('dyptfølt',),
'dyptfølte': ('dyptfølt',),
'dyptfølt': ('dyptfølt',),
'dyptgripende': ('dyptgripende',),
'dyptgående': ('dyptgående',),
'dyptloddende': ('dyptloddende',),
'dypttenkende': ('dypttenkende',),
'dyr': ('dyr',),
'dyre': ('dyr',),
'dyrt': ('dyr',),
'dyrere': ('dyr',),
'dyrest': ('dyr',),
'dyreste': ('dyr',),
'dyrebar': ('dyrebar',),
'dyrebare': ('dyrebar',),
'dyrebart': ('dyrebar',),
'dyregod': ('dyregod',),
'dyregode': ('dyregod',),
'dyregodt': ('dyregod',),
'dyrekjøpt': ('dyrekjøpt',),
'dyrekjøpte': ('dyrekjøpt',),
'dyrekjøpt': ('dyrekjøpt',),
'dyrisk': ('dyrisk',),
'dyriske': ('dyrisk',),
'dyrisk': ('dyrisk',),
'dyrkbar': ('dyrkbar',),
'dyrkbare': ('dyrkbar',),
'dyrkbart': ('dyrkbar',),
'dyrka': ('dyrke',),
'dyrket': ('dyrke',),
'dyrka': ('dyrke',),
'dyrket': ('dyrke',),
'dyrka': ('dyrke',),
'dyrkete': ('dyrke',),
'dyrkede': ('dyrke',),
'dyrka': ('dyrke',),
'dyrkete': ('dyrke',),
'dyrkede': ('dyrke',),
'dyrkende': ('dyrke',),
'dysfunksjonell': ('dysfunksjonell',),
'dysfunksjonelle': ('dysfunksjonell',),
'dysfunksjonelt': ('dysfunksjonell',),
'dyssa': ('dysse',),
'dysset': ('dysse',),
'dyssa': ('dysse',),
'dysset': ('dysse',),
'dyssa': ('dysse',),
'dyssete': ('dysse',),
'dyssede': ('dysse',),
'dyssa': ('dysse',),
'dyssete': ('dysse',),
'dyssede': ('dysse',),
'dyssende': ('dysse',),
'dyster': ('dyster',),
'dystre': ('dyster',),
'dystert': ('dyster',),
'dystrere': ('dyster',),
'dystrest': ('dyster',),
'dystreste': ('dyster',),
'dytta': ('dytte',),
'dyttet': ('dytte',),
'dytta': ('dytte',),
'dyttet': ('dytte',),
'dytta': ('dytte',),
'dyttete': ('dytte',),
'dyttede': ('dytte',),
'dytta': ('dytte',),
'dyttete': ('dytte',),
'dyttede': ('dytte',),
'dyttende': ('dytte',),
'dyvåt': ('dyvåt',),
'dyvåte': ('dyvåt',),
'dyvått': ('dyvåt',),
'dådlaus': ('dådlaus',),
'dådlause': ('dådlaus',),
'dådlaust': ('dådlaus',),
'dådløs': ('dådløs',),
'dådløse': ('dådløs',),
'dådløst': ('dådløs',),
'dådrik': ('dådrik',),
'dådrike': ('dådrik',),
'dådrikt': ('dådrik',),
'dåna': ('dåne',),
'dånet': ('dåne',),
'dånt': ('dåne',),
'dåna': ('dåne',),
'dånet': ('dåne',),
'dånt': ('dåne',),
'dåna': ('dåne',),
'dånete': ('dåne',),
'dånede': ('dåne',),
'dånte': ('dåne',),
'dåna': ('dåne',),
'dånete': ('dåne',),
'dånede': ('dåne',),
'dånte': ('dåne',),
'dånende': ('dåne',),
'dåneferdig': ('dåneferdig',),
'dåneferdige': ('dåneferdig',),
'dåneferdig': ('dåneferdig',),
'dåraktig': ('dåraktig',),
'dåraktige': ('dåraktig',),
'dåraktig': ('dåraktig',),
'dåra': ('dåre',),
'dåret': ('dåre',),
'dåra': ('dåre',),
'dåret': ('dåre',),
'dåra': ('dåre',),
'dårete': ('dåre',),
'dårede': ('dåre',),
'dåra': ('dåre',),
'dårete': ('dåre',),
'dårede': ('dåre',),
'dårende': ('dåre',),
'dårlig': ('dårlig',),
'dårlige': ('dårlig',),
'dårlig': ('dårlig',),
'dårligere': ('dårlig',),
'dårligst': ('dårlig',),
'dårligste': ('dårlig',),
'dåset': ('dåset',),
'dåsete': ('dåset',),
'dåset': ('dåset',),
'dåsete': ('dåsete',),
'dødd': ('dø',),
'dødde': ('dø',),
'døende': ('dø',),
'død': ('død',),
'døde': ('død',),
'dødt': ('død',),
'dødere': ('død',),
'dødest': ('død',),
'dødeste': ('død',),
'dødbleik': ('dødbleik',),
'dødbleike': ('dødbleik',),
'dødbleikt': ('dødbleik',),
'dødblek': ('dødblek',),
'dødbleke': ('dødblek',),
'dødblekt': ('dødblek',),
'dødbrent': ('dødbrent',),
'dødbrente': ('dødbrent',),
'dødbrent': ('dødbrent',),
'dødbringende': ('dødbringende',),
'døddrukken': ('døddrukken',),
'døddrukne': ('døddrukken',),
'døddrukkent': ('døddrukken',),
'døda': ('døde',),
'dødet': ('døde',),
'døda': ('døde',),
'dødet': ('døde',),
'døda': ('døde',),
'dødete': ('døde',),
'dødede': ('døde',),
'døda': ('døde',),
'dødete': ('døde',),
'dødede': ('døde',),
'dødende': ('døde',),
'dødelig': ('dødelig',),
'dødelige': ('dødelig',),
'dødelig': ('dødelig',),
'dødeligere': ('dødelig',),
'dødeligst': ('dødelig',),
'dødeligste': ('dødelig',),
'dødfødt': ('dødfødt',),
'dødfødte': ('dødfødt',),
'dødfødt': ('dødfødt',),
'dødsdømt': ('dødsdømt',),
'dødsdømte': ('dødsdømt',),
'dødsdømt': ('dødsdømt',),
'dødsens': ('dødsens',),
'dødslei': ('dødslei',),
'dødsleie': ('dødslei',),
'dødsleit': ('dødslei',),
'dødsleiere': ('dødslei',),
'dødsleiest': ('dødslei',),
'dødsleieste': ('dødslei',),
'dødsmerka': ('dødsmerka',),
'dødsmerket': ('dødsmerket',),
'dødsmerkete': ('dødsmerket',),
'dødsmerkede': ('dødsmerket',),
'dødsmerkete': ('dødsmerket',),
'dødsmerkede': ('dødsmerket',),
'dødsmerket': ('dødsmerket',),
'dødssjuk': ('dødssjuk',),
'dødssjuke': ('dødssjuk',),
'dødssjukt': ('dødssjuk',),
'dødssyk': ('dødssyk',),
'dødssyke': ('dødssyk',),
'dødssykt': ('dødssyk',),
'dødstrett': ('dødstrett',),
'dødstrette': ('dødstrett',),
'dødstrett': ('dødstrett',),
'dødstrøtt': ('dødstrøtt',),
'dødstrøtte': ('dødstrøtt',),
'dødstrøtt': ('dødstrøtt',),
'døgngammel': ('døgngammel',),
'døgngamle': ('døgngammel',),
'døgngammelt': ('døgngammel',),
'døgnkontinuerlig': ('døgnkontinuerlig',),
'døgnkontinuerlige': ('døgnkontinuerlig',),
'døgnkontinuerlig': ('døgnkontinuerlig',),
'døgnvill': ('døgnvill',),
'døgnville': ('døgnvill',),
'døgnvilt': ('døgnvill',),
'døgnåpen': ('døgnåpen',),
'døgnåpne': ('døgnåpen',),
'døgnåpent': ('døgnåpen',),
'dulgt': ('dølge',),
'dulgte': ('dølge',),
'dølgende': ('dølge',),
'dølsk': ('dølsk',),
'dølske': ('dølsk',),
'dølsk': ('dølsk',),
'dømt': ('dømme',),
'dømte': ('dømme',),
'dømmende': ('dømme',),
'dømmesjuk': ('dømmesjuk',),
'dømmesjuke': ('dømmesjuk',),
'dømmesjukt': ('dømmesjuk',),
'dømmesyk': ('dømmesyk',),
'dømmesyke': ('dømmesyk',),
'dømmesykt': ('dømmesyk',),
'dønna': ('dønne',),
'dønnet': ('dønne',),
'dønt': ('dønne',),
'dønna': ('dønne',),
'dønnet': ('dønne',),
'dønt': ('dønne',),
'dønna': ('dønne',),
'dønnete': ('dønne',),
'dønnede': ('dønne',),
'dønte': ('dønne',),
'dønna': ('dønne',),
'dønnete': ('dønne',),
'dønnede': ('dønne',),
'dønte': ('dønne',),
'dønnende': ('dønne',),
'døpt': ('døpe',),
'døpte': ('døpe',),
'døpende': ('døpe',),
'døsa': ('døse',),
'døset': ('døse',),
'døst': ('døse',),
'døsa': ('døse',),
'døset': ('døse',),
'døst': ('døse',),
'døsa': ('døse',),
'døsete': ('døse',),
'døsede': ('døse',),
'døste': ('døse',),
'døsa': ('døse',),
'døsete': ('døse',),
'døsede': ('døse',),
'døste': ('døse',),
'døsende': ('døse',),
'døsen': ('døsen',),
'døsne': ('døsen',),
'døsent': ('døsen',),
'døsig': ('døsig',),
'døsige': ('døsig',),
'døsig': ('døsig',),
'døsigere': ('døsig',),
'døsigst': ('døsig',),
'døsigste': ('døsig',),
'døv': ('døv',),
'døve': ('døv',),
'døvt': ('døv',),
'døvere': ('døv',),
'døvest': ('døv',),
'døveste': ('døv',),
'døvblind': ('døvblind',),
'døvblinde': ('døvblind',),
'døvblindt': ('døvblind',),
'døvfødt': ('døvfødt',),
'døvfødte': ('døvfødt',),
'døvfødt': ('døvfødt',),
'døvhørt': ('døvhørt',),
'døvhørte': ('døvhørt',),
'døvhørt': ('døvhørt',),
'døvstum': ('døvstum',),
'døvstumme': ('døvstum',),
'døvstumt': ('døvstum',),
'døya': ('døye',),
'døyet': ('døye',),
'døyd': ('døye',),
'døya': ('døye',),
'døyet': ('døye',),
'døyd': ('døye',),
'døya': ('døye',),
'døyete': ('døye',),
'døyede': ('døye',),
'døyde': ('døye',),
'døya': ('døye',),
'døyete': ('døye',),
'døyede': ('døye',),
'døyde': ('døye',),
'døyende': ('døye',),
'døyva': ('døyve',),
'døyvet': ('døyve',),
'døyvd': ('døyve',),
'døyva': ('døyve',),
'døyvet': ('døyve',),
'døyvd': ('døyve',),
'døyva': ('døyve',),
'døyvete': ('døyve',),
'døyvede': ('døyve',),
'døyvde': ('døyve',),
'døyva': ('døyve',),
'døyvete': ('døyve',),
'døyvede': ('døyve',),
'døyvde': ('døyve',),
'døyvende': ('døyve',),
'ebba': ('ebbe',),
'ebbet': ('ebbe',),
'ebba': ('ebbe',),
'ebbet': ('ebbe',),
'ebba': ('ebbe',),
'ebbete': ('ebbe',),
'ebbede': ('ebbe',),
'ebba': ('ebbe',),
'ebbete': ('ebbe',),
'ebbede': ('ebbe',),
'ebbende': ('ebbe',),
'ecru': ('ecru',),
'ecuadoriansk': ('ecuadoriansk',),
'ecuadorianske': ('ecuadoriansk',),
'ecuadoriansk': ('ecuadoriansk',),
'edafisk': ('edafisk',),
'edafiske': ('edafisk',),
'edafisk': ('edafisk',),
'eddiksur': ('eddiksur',),
'eddiksure': ('eddiksur',),
'eddiksurt': ('eddiksur',),
'edel': ('edel',),
'edle': ('edel',),
'edelt': ('edel',),
'edlere': ('edel',),
'edlest': ('edel',),
'edleste': ('edel',),
'edelig': ('edelig',),
'edelige': ('edelig',),
'edelig': ('edelig',),
'edelmodig': ('edelmodig',),
'edelmodige': ('edelmodig',),
'edelmodig': ('edelmodig',),
'edfesta': ('edfeste',),
'edfestet': ('edfeste',),
'edfesta': ('edfeste',),
'edfestet': ('edfeste',),
'edfesta': ('edfeste',),
'edfestete': ('edfeste',),
'edfestede': ('edfeste',),
'edfesta': ('edfeste',),
'edfestete': ('edfeste',),
'edfestede': ('edfeste',),
'edfestende': ('edfeste',),
'edru': ('edru',),
'edrue': ('edru',),
'edru': ('edru',),
'edrue': ('edru',),
'edru': ('edru',),
'edruelig': ('edruelig',),
'edruelige': ('edruelig',),
'edruelig': ('edruelig',),
'edsvoren': ('edsvoren',),
'edsvorne': ('edsvoren',),
'edsvorent': ('edsvoren',),
'efemer': ('efemer',),
'efemere': ('efemer',),
'efemert': ('efemer',),
'effektfull': ('effektfull',),
'effektfulle': ('effektfull',),
'effektfullt': ('effektfull',),
'effektiv': ('effektiv',),
'effektive': ('effektiv',),
'effektivt': ('effektiv',),
'effektivisert': ('effektivisere',),
'effektiviserte': ('effektivisere',),
'effektiviserende': ('effektivisere',),
'effektuert': ('effektuere',),
'effektuerte': ('effektuere',),
'effektuerende': ('effektuere',),
'egal': ('egal',),
'egale': ('egal',),
'egalt': ('egal',),
'egalisert': ('egalisere',),
'egaliserte': ('egalisere',),
'egaliserende': ('egalisere',),
'egalitær': ('egalitær',),
'egalitære': ('egalitær',),
'egalitært': ('egalitær',),
'egdsk': ('egdsk',),
'egdske': ('egdsk',),
'egdsk': ('egdsk',),
'egeisk': ('egeisk',),
'egeiske': ('egeisk',),
'egeisk': ('egeisk',),
'egen': ('egen',),
'egne': ('egen',),
'egent': ('egen',),
'egenarta': ('egenarta',),
'egenartet': ('egenartet',),
'egenartete': ('egenartet',),
'egenartede': ('egenartet',),
'egenartete': ('egenartet',),
'egenartede': ('egenartet',),
'egenartet': ('egenartet',),
'egenhendig': ('egenhendig',),
'egenhendige': ('egenhendig',),
'egenhendig': ('egenhendig',),
'egenkjærlig': ('egenkjærlig',),
'egenkjærlige': ('egenkjærlig',),
'egenkjærlig': ('egenkjærlig',),
'egenmektig': ('egenmektig',),
'egenmektige': ('egenmektig',),
'egenmektig': ('egenmektig',),
'egenprodusert': ('egenprodusert',),
'egenproduserte': ('egenprodusert',),
'egenprodusert': ('egenprodusert',),
'egenrettferdig': ('egenrettferdig',),
'egenrettferdige': ('egenrettferdig',),
'egenrettferdig': ('egenrettferdig',),
'egenrådig': ('egenrådig',),
'egenrådige': ('egenrådig',),
'egenrådig': ('egenrådig',),
'egensikker': ('egensikker',),
'egensikre': ('egensikker',),
'egensikkert': ('egensikker',),
'egensindig': ('egensindig',),
'egensindige': ('egensindig',),
'egensindig': ('egensindig',),
'egentlig': ('egentlig',),
'egentlige': ('egentlig',),
'egentlig': ('egentlig',),
'egga': ('egge',),
'egget': ('egge',),
'egga': ('egge',),
'egget': ('egge',),
'egga': ('egge',),
'eggete': ('egge',),
'eggede': ('egge',),
'egga': ('egge',),
'eggete': ('egge',),
'eggede': ('egge',),
'eggende': ('egge',),
'eggeforma': ('eggeforma',),
'eggeformet': ('eggeformet',),
'eggeformete': ('eggeformet',),
'eggeformede': ('eggeformet',),
'eggeformete': ('eggeformet',),
'eggeformede': ('eggeformet',),
'eggeformet': ('eggeformet',),
'eggeskallfarga': ('eggeskallfarga',),
'eggeskallfarget': ('eggeskallfarget',),
'eggeskallfargete': ('eggeskallfarget',),
'eggeskallfargede': ('eggeskallfarget',),
'eggeskallfargete': ('eggeskallfarget',),
'eggeskallfargede': ('eggeskallfarget',),
'eggeskallfarget': ('eggeskallfarget',),
'eggforma': ('eggforma',),
'eggformet': ('eggformet',),
'eggformete': ('eggformet',),
'eggformede': ('eggformet',),
'eggformete': ('eggformet',),
'eggformede': ('eggformet',),
'eggformet': ('eggformet',),
'egla': ('egle',),
'eglet': ('egle',),
'egla': ('egle',),
'eglet': ('egle',),
'egla': ('egle',),
'eglete': ('egle',),
'eglede': ('egle',),
'eglete': ('egle',),
'eglede': ('egle',),
'egla': ('egle',),
'eglete': ('egle',),
'eglede': ('egle',),
'eglete': ('egle',),
'eglede': ('egle',),
'eglende': ('egle',),
'eglet': ('eglet',),
'eglete': ('eglet',),
'eglet': ('eglet',),
'eglete': ('eglete',),
'egna': ('egna',),
'egna': ('egne',),
'egnet': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egna': ('egne',),
'egnete': ('egne',),
'egnede': ('egne',),
'egna': ('egne',),
'egnete': ('egne',),
'egnede': ('egne',),
'egnende': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egnt': ('egne',),
'egna': ('egne',),
'egnet': ('egne',),
'egnt': ('egne',),
'egna': ('egne',),
'egnete': ('egne',),
'egnede': ('egne',),
'egnte': ('egne',),
'egna': ('egne',),
'egnete': ('egne',),
'egnede': ('egne',),
'egnte': ('egne',),
'egnende': ('egne',),
'egnet': ('egnet',),
'egnete': ('egnet',),
'egnede': ('egnet',),
'egnete': ('egnet',),
'egnede': ('egnet',),
'egnet': ('egnet',),
'egoistisk': ('egoistisk',),
'egoistiske': ('egoistisk',),
'egoistisk': ('egoistisk',),
'egosentrisk': ('egosentrisk',),
'egosentriske': ('egosentrisk',),
'egosentrisk': ('egosentrisk',),
'egyptisk': ('egyptisk',),
'egyptiske': ('egyptisk',),
'egyptisk': ('egyptisk',),
'eiet': ('eie',),
'eid': ('eie',),
'ått': ('eie',),
'eiet': ('eie',),
'eid': ('eie',),
'ått': ('eie',),
'eiete': ('eie',),
'eiede': ('eie',),
'eide': ('eie',),
'åtte': ('eie',),
'eiete': ('eie',),
'eiede': ('eie',),
'eide': ('eie',),
'åtte': ('eie',),
'eiende': ('eie',),
'eiegod': ('eiegod',),
'eiegode': ('eiegod',),
'eiegodt': ('eiegod',),
'eiendommelig': ('eiendommelig',),
'eiendommelige': ('eiendommelig',),
'eiendommelig': ('eiendommelig',),
'eiendomslaus': ('eiendomslaus',),
'eiendomslause': ('eiendomslaus',),
'eiendomslaust': ('eiendomslaus',),
'eiendomsløs': ('eiendomsløs',),
'eiendomsløse': ('eiendomsløs',),
'eiendomsløst': ('eiendomsløs',),
'eiesnill': ('eiesnill',),
'eiesnille': ('eiesnill',),
'eiesnilt': ('eiesnill',),
'eigenarta': ('eigenarta',),
'eigenartet': ('eigenartet',),
'eigenartete': ('eigenartet',),
'eigenartede': ('eigenartet',),
'eigenartete': ('eigenartet',),
'eigenartede': ('eigenartet',),
'eigenartet': ('eigenartet',),
'eigenhendig': ('eigenhendig',),
'eigenhendige': ('eigenhendig',),
'eigenhendig': ('eigenhendig',),
'eigenkjærlig': ('eigenkjærlig',),
'eigenkjærlige': ('eigenkjærlig',),
'eigenkjærlig': ('eigenkjærlig',),
'eigenmektig': ('eigenmektig',),
'eigenmektige': ('eigenmektig',),
'eigenmektig': ('eigenmektig',),
'eigenprodusert': ('eigenprodusert',),
'eigenproduserte': ('eigenprodusert',),
'eigenprodusert': ('eigenprodusert',),
'eigenrettferdig': ('eigenrettferdig',),
'eigenrettferdige': ('eigenrettferdig',),
'eigenrettferdig': ('eigenrettferdig',),
'eigenrådig': ('eigenrådig',),
'eigenrådige': ('eigenrådig',),
'eigenrådig': ('eigenrådig',),
'eigensikker': ('eigensikker',),
'eigensikre': ('eigensikker',),
'eigensikkert': ('eigensikker',),
'eigensindig': ('eigensindig',),
'eigensindige': ('eigensindig',),
'eigensindig': ('eigensindig',),
'eima': ('eime',),
'eimet': ('eime',),
'eima': ('eime',),
'eimet': ('eime',),
'eima': ('eime',),
'eimete': ('eime',),
'eimede': ('eime',),
'eima': ('eime',),
'eimete': ('eime',),
'eimede': ('eime',),
'eimende': ('eime',),
'einslig': ('einslig',),
'einslige': ('einslig',),
'einslig': ('einslig',),
'einsligstilt': ('einsligstilt',),
'einsligstilte': ('einsligstilt',),
'einsligstilt': ('einsligstilt',),
'eira': ('eire',),
'eiret': ('eire',),
'eira': ('eire',),
'eiret': ('eire',),
'eira': ('eire',),
'eirete': ('eire',),
'eirede': ('eire',),
'eira': ('eire',),
'eirete': ('eire',),
'eirede': ('eire',),
'eirende': ('eire',),
'eiret': ('eiret',),
'eirete': ('eiret',),
'eiret': ('eiret',),
'eirete': ('eirete',),
'eirgrønn': ('eirgrønn',),
'eirgrønne': ('eirgrønn',),
'eirgrønt': ('eirgrønn',),
'ejakulert': ('ejakulere',),
'ejakulerte': ('ejakulere',),
'ejakulerende': ('ejakulere',),
'ekkel': ('ekkel',),
'ekle': ('ekkel',),
'ekkelt': ('ekkel',),
'eklere': ('ekkel',),
'eklest': ('ekkel',),
'ekleste': ('ekkel',),
'eklatant': ('eklatant',),
'eklatante': ('eklatant',),
'eklatant': ('eklatant',),
'eklektisk': ('eklektisk',),
'eklektiske': ('eklektisk',),
'eklektisk': ('eklektisk',),
'eksakt': ('eksakt',),
'eksakte': ('eksakt',),
'eksakt': ('eksakt',),
'eksaltert': ('eksaltert',),
'eksalterte': ('eksaltert',),
'eksaltert': ('eksaltert',),
'eksamensberettiga': ('eksamensberettiga',),
'eksamensberettiget': ('eksamensberettiget',),
'eksamensberettigete': ('eksamensberettiget',),
'eksamensberettigede': ('eksamensberettiget',),
'eksamensberettigete': ('eksamensberettiget',),
'eksamensberettigede': ('eksamensberettiget',),
'eksamensberettiget': ('eksamensberettiget',),
'eksamensfri': ('eksamensfri',),
'eksamensfrie': ('eksamensfri',),
'eksamensfritt': ('eksamensfri',),
'eksamensretta': ('eksamensretta',),
'eksamensrettet': ('eksamensrettet',),
'eksamensrettete': ('eksamensrettet',),
'eksamensrettede': ('eksamensrettet',),
'eksamensrettete': ('eksamensrettet',),
'eksamensrettede': ('eksamensrettet',),
'eksamensrettet': ('eksamensrettet',),
'eksaminatorisk': ('eksaminatorisk',),
'eksaminatoriske': ('eksaminatorisk',),
'eksaminatorisk': ('eksaminatorisk',),
'eksaminert': ('eksaminere',),
'eksaminerte': ('eksaminere',),
'eksaminerende': ('eksaminere',),
'eksegert': ('eksegere',),
'eksegerte': ('eksegere',),
'eksegerende': ('eksegere',),
'eksegetisk': ('eksegetisk',),
'eksegetiske': ('eksegetisk',),
'eksegetisk': ('eksegetisk',),
'eksekutiv': ('eksekutiv',),
'eksekutive': ('eksekutiv',),
'eksekutivt': ('eksekutiv',),
'eksekvert': ('eksekvere',),
'eksekverte': ('eksekvere',),
'eksekverende': ('eksekvere',),
'eksellent': ('eksellent',),
'eksellente': ('eksellent',),
'eksellent': ('eksellent',),
'eksellert': ('eksellere',),
'eksellerte': ('eksellere',),
'eksellerende': ('eksellere',),
'eksemplarisk': ('eksemplarisk',),
'eksemplariske': ('eksemplarisk',),
'eksemplarisk': ('eksemplarisk',),
'eksemplifisert': ('eksemplifisere',),
'eksemplifiserte': ('eksemplifisere',),
'eksemplifiserende': ('eksemplifisere',),
'eksentrisk': ('eksentrisk',),
'eksentriske': ('eksentrisk',),
'eksentrisk': ('eksentrisk',),
'eksepsjonell': ('eksepsjonell',),
'eksepsjonelle': ('eksepsjonell',),
'eksepsjonelt': ('eksepsjonell',),
'ekserpert': ('ekserpere',),
'ekserperte': ('ekserpere',),
'ekserperende': ('ekserpere',),
'eksersert': ('eksersere',),
'ekserserte': ('eksersere',),
'ekserserende': ('eksersere',),
'ekshalert': ('ekshalere',),
'ekshalerte': ('ekshalere',),
'ekshalerende': ('ekshalere',),
'ekshibisjonistisk': ('ekshibisjonistisk',),
'ekshibisjonistiske': ('ekshibisjonistisk',),
'ekshibisjonistisk': ('ekshibisjonistisk',),
'eksistensialistisk': ('eksistensialistisk',),
'eksistensialistiske': ('eksistensialistisk',),
'eksistensialistisk': ('eksistensialistisk',),
'eksistensiell': ('eksistensiell',),
'eksistensielle': ('eksistensiell',),
'eksistensielt': ('eksistensiell',),
'eksistert': ('eksistere',),
'eksisterte': ('eksistere',),
'eksisterende': ('eksistere',),
'eksklamert': ('eksklamere',),
'eksklamerte': ('eksklamere',),
'eksklamerende': ('eksklamere',),
'ekskludert': ('ekskludere',),
'ekskluderte': ('ekskludere',),
'ekskluderende': ('ekskludere',),
'eksklusiv': ('eksklusiv',),
'eksklusive': ('eksklusiv',),
'eksklusivt': ('eksklusiv',),
'ekskommunisert': ('ekskommunisere',),
'ekskommuniserte': ('ekskommunisere',),
'ekskommuniserende': ('ekskommunisere',),
'eksogen': ('eksogen',),
'eksogene': ('eksogen',),
'eksogent': ('eksogen',),
'eksokrin': ('eksokrin',),
'eksokrine': ('eksokrin',),
'eksokrint': ('eksokrin',),
'eksosforgifta': ('eksosforgifta',),
'eksosforgiftet': ('eksosforgiftet',),
'eksosforgiftete': ('eksosforgiftet',),
'eksosforgiftede': ('eksosforgiftet',),
'eksosforgiftete': ('eksosforgiftet',),
'eksosforgiftede': ('eksosforgiftet',),
'eksosforgiftet': ('eksosforgiftet',),
'eksoterisk': ('eksoterisk',),
'eksoteriske': ('eksoterisk',),
'eksoterisk': ('eksoterisk',),
'eksoterm': ('eksoterm',),
'eksoterme': ('eksoterm',),
'eksotermt': ('eksoterm',),
'eksotisk': ('eksotisk',),
'eksotiske': ('eksotisk',),
'eksotisk': ('eksotisk',),
'ekspandert': ('ekspandere',),
'ekspanderte': ('ekspandere',),
'ekspanderende': ('ekspandere',),
'ekspansiv': ('ekspansiv',),
'ekspansive': ('ekspansiv',),
'ekspansivt': ('ekspansiv',),
'ekspatriert': ('ekspatriere',),
'ekspatrierte': ('ekspatriere',),
'ekspatrierende': ('ekspatriere',),
'ekspedert': ('ekspedere',),
'ekspederte': ('ekspedere',),
'ekspederende': ('ekspedere',),
'ekspeditt': ('ekspeditt',),
'ekspeditte': ('ekspeditt',),
'ekspeditt': ('ekspeditt',),
'eksperimentell': ('eksperimentell',),
'eksperimentelle': ('eksperimentell',),
'eksperimentelt': ('eksperimentell',),
'eksperimentert': ('eksperimentere',),
'eksperimenterte': ('eksperimentere',),
'eksperimenterende': ('eksperimentere',),
'ekspiratorisk': ('ekspiratorisk',),
'ekspiratoriske': ('ekspiratorisk',),
'ekspiratorisk': ('ekspiratorisk',),
'ekspirert': ('ekspirere',),
'ekspirerte': ('ekspirere',),
'ekspirerende': ('ekspirere',),
'eksplisitt': ('eksplisitt',),
'eksplisitte': ('eksplisitt',),
'eksplisitt': ('eksplisitt',),
'eksplisittert': ('eksplisittere',),
'eksplisitterte': ('eksplisittere',),
'eksplisitterende': ('eksplisittere',),
'eksploatert': ('eksploatere',),
'eksploaterte': ('eksploatere',),
'eksploaterende': ('eksploatere',),
'eksplodert': ('eksplodere',),
'eksploderte': ('eksplodere',),
'eksploderende': ('eksplodere',),
'eksplosiv': ('eksplosiv',),
'eksplosive': ('eksplosiv',),
'eksplosivt': ('eksplosiv',),
'eksplosjonsarta': ('eksplosjonsarta',),
'eksplosjonsartet': ('eksplosjonsartet',),
'eksplosjonsartete': ('eksplosjonsartet',),
'eksplosjonsartede': ('eksplosjonsartet',),
'eksplosjonsartete': ('eksplosjonsartet',),
'eksplosjonsartede': ('eksplosjonsartet',),
'eksplosjonsartet': ('eksplosjonsartet',),
'eksplosjonsfarlig': ('eksplosjonsfarlig',),
'eksplosjonsfarlige': ('eksplosjonsfarlig',),
'eksplosjonsfarlig': ('eksplosjonsfarlig',),
'eksplosjonssikker': ('eksplosjonssikker',),
'eksplosjonssikre': ('eksplosjonssikker',),
'eksplosjonssikkert': ('eksplosjonssikker',),
'eksplosjonstett': ('eksplosjonstett',),
'eksplosjonstette': ('eksplosjonstett',),
'eksplosjonstett': ('eksplosjonstett',),
'eksponert': ('eksponere',),
'eksponerte': ('eksponere',),
'eksponerende': ('eksponere',),
'eksportert': ('eksportere',),
'eksporterte': ('eksportere',),
'eksporterende': ('eksportere',),
'eksportfremmende': ('eksportfremmende',),
'eksportregulerende': ('eksportregulerende',),
'ekspresjonistisk': ('ekspresjonistisk',),
'ekspresjonistiske': ('ekspresjonistisk',),
'ekspresjonistisk': ('ekspresjonistisk',),
'ekspressiv': ('ekspressiv',),
'ekspressive': ('ekspressiv',),
'ekspressivt': ('ekspressiv',),
'ekspropriert': ('ekspropriere',),
'eksproprierte': ('ekspropriere',),
'eksproprierende': ('ekspropriere',),
'ekstatisk': ('ekstatisk',),
'ekstatiske': ('ekstatisk',),
'ekstatisk': ('ekstatisk',),
'ekstemporal': ('ekstemporal',),
'ekstemporale': ('ekstemporal',),
'ekstemporalt': ('ekstemporal',),
'ekstemporert': ('ekstemporere',),
'ekstemporerte': ('ekstemporere',),
'ekstemporerende': ('ekstemporere',),
'ekstensiv': ('ekstensiv',),
'ekstensive': ('ekstensiv',),
'ekstensivt': ('ekstensiv',),
'ekstensivert': ('ekstensivere',),
'ekstensiverte': ('ekstensivere',),
'ekstensiverende': ('ekstensivere',),
'ekstern': ('ekstern',),
'eksterne': ('ekstern',),
'eksternt': ('ekstern',),
'eksterritorial': ('eksterritorial',),
'eksterritoriale': ('eksterritorial',),
'eksterritorialt': ('eksterritorial',),
'ekstra': ('ekstra',),
'ekstrahert': ('ekstrahere',),
'ekstraherte': ('ekstrahere',),
'ekstraherende': ('ekstrahere',),
'ekstraordinær': ('ekstraordinær',),
'ekstraordinære': ('ekstraordinær',),
'ekstraordinært': ('ekstraordinær',),
'ekstrapolert': ('ekstrapolere',),
'ekstrapolerte': ('ekstrapolere',),
'ekstrapolerende': ('ekstrapolere',),
'ekstrauterin': ('ekstrauterin',),
'ekstrauterine': ('ekstrauterin',),
'ekstrauterint': ('ekstrauterin',),
'ekstravagant': ('ekstravagant',),
'ekstravagante': ('ekstravagant',),
'ekstravagant': ('ekstravagant',),
'ekstrem': ('ekstrem',),
'ekstreme': ('ekstrem',),
'ekstremt': ('ekstrem',),
'ekstremistisk': ('ekstremistisk',),
'ekstremistiske': ('ekstremistisk',),
'ekstremistisk': ('ekstremistisk',),
'ekstrovert': ('ekstrovert',),
'ekstroverte': ('ekstrovert',),
'ekstrovert': ('ekstrovert',),
'ekta': ('ekte',),
'ektet': ('ekte',),
'ekta': ('ekte',),
'ektet': ('ekte',),
'ekta': ('ekte',),
'ektete': ('ekte',),
'ektede': ('ekte',),
'ekta': ('ekte',),
'ektete': ('ekte',),
'ektede': ('ekte',),
'ektende': ('ekte',),
'ekte': ('ekte',),
'ekteskapelig': ('ekteskapelig',),
'ekteskapelige': ('ekteskapelig',),
'ekteskapelig': ('ekteskapelig',),
'ektevia': ('ektevie',),
'ekteviet': ('ektevie',),
'ektevidd': ('ektevie',),
'ektevigd': ('ektevie',),
'ektevia': ('ektevie',),
'ekteviet': ('ektevie',),
'ektevidd': ('ektevie',),
'ektevigd': ('ektevie',),
'ektevia': ('ektevie',),
'ekteviete': ('ektevie',),
'ekteviede': ('ektevie',),
'ektevidde': ('ektevie',),
'ektevigde': ('ektevie',),
'ektevia': ('ektevie',),
'ekteviete': ('ektevie',),
'ekteviede': ('ektevie',),
'ektevidde': ('ektevie',),
'ektevigde': ('ektevie',),
'ekteviende': ('ektevie',),
'ekvatorial': ('ekvatorial',),
'ekvatoriale': ('ekvatorial',),
'ekvatorialt': ('ekvatorial',),
'ekvatorialguineansk': ('ekvatorialguineansk',),
'ekvatorialguineanske': ('ekvatorialguineansk',),
'ekvatorialguineansk': ('ekvatorialguineansk',),
'ekvilibristisk': ('ekvilibristisk',),
'ekvilibristiske': ('ekvilibristisk',),
'ekvilibristisk': ('ekvilibristisk',),
'ekvipert': ('ekvipere',),
'ekviperte': ('ekvipere',),
'ekviperende': ('ekvipere',),
'ekvivalent': ('ekvivalent',),
'ekvivalente': ('ekvivalent',),
'ekvivalent': ('ekvivalent',),
'ekvivalert': ('ekvivalere',),
'ekvivalerte': ('ekvivalere',),
'ekvivalerende': ('ekvivalere',),
'elastisk': ('elastisk',),
'elastiske': ('elastisk',),
'elastisk': ('elastisk',),
'elda': ('elde',),
'eldet': ('elde',),
'elda': ('elde',),
'eldet': ('elde',),
'elda': ('elde',),
'eldete': ('elde',),
'eldede': ('elde',),
'elda': ('elde',),
'eldete': ('elde',),
'eldede': ('elde',),
'eldende': ('elde',),
'eldgammel': ('eldgammel',),
'eldgamle': ('eldgammel',),
'eldgammelt': ('eldgammel',),
'eldhuga': ('eldhuga',),
'eldre': ('eldre',),
'eldst': ('eldst',),
'eldste': ('eldst',),
'eldst': ('eldst',),
'elegant': ('elegant',),
'elegante': ('elegant',),
'elegant': ('elegant',),
'elegisk': ('elegisk',),
'elegiske': ('elegisk',),
'elegisk': ('elegisk',),
'elektiv': ('elektiv',),
'elektive': ('elektiv',),
'elektivt': ('elektiv',),
'elektoral': ('elektoral',),
'elektorale': ('elektoral',),
'elektoralt': ('elektoral',),
'elektrifisert': ('elektrifisere',),
'elektrifiserte': ('elektrifisere',),
'elektrifiserende': ('elektrifisere',),
'elektrisert': ('elektrisere',),
'elektriserte': ('elektrisere',),
'elektriserende': ('elektrisere',),
'elektrisk': ('elektrisk',),
'elektriske': ('elektrisk',),
'elektrisk': ('elektrisk',),
'elektrokjemisk': ('elektrokjemisk',),
'elektrokjemiske': ('elektrokjemisk',),
'elektrokjemisk': ('elektrokjemisk',),
'elektrolytisk': ('elektrolytisk',),
'elektrolytiske': ('elektrolytisk',),
'elektrolytisk': ('elektrolytisk',),
'elektromagnetisk': ('elektromagnetisk',),
'elektromagnetiske': ('elektromagnetisk',),
'elektromagnetisk': ('elektromagnetisk',),
'elektrometallurgisk': ('elektrometallurgisk',),
'elektrometallurgiske': ('elektrometallurgisk',),
'elektrometallurgisk': ('elektrometallurgisk',),
'elektronisk': ('elektronisk',),
'elektroniske': ('elektronisk',),
'elektronisk': ('elektronisk',),
'elementær': ('elementær',),
'elementære': ('elementær',),
'elementært': ('elementær',),
'elendig': ('elendig',),
'elendige': ('elendig',),
'elendig': ('elendig',),
'elendigere': ('elendig',),
'elendigst': ('elendig',),
'elendigste': ('elendig',),
'elevert': ('elevere',),
'eleverte': ('elevere',),
'eleverende': ('elevere',),
'elevert': ('elevert',),
'eleverte': ('elevert',),
'elevert': ('elevert',),
'elgsblakk': ('elgsblakk',),
'elgsblakke': ('elgsblakk',),
'elgsblakt': ('elgsblakk',),
'elgsgrå': ('elgsgrå',),
'elgsgråe': ('elgsgrå',),
'elgsgrå': ('elgsgrå',),
'elgsgråe': ('elgsgrå',),
'elgsgrå': ('elgsgrå',),
'elgsgrått': ('elgsgrå',),
'eligert': ('eligere',),
'eligerte': ('eligere',),
'eligerende': ('eligere',),
'eliminert': ('eliminere',),
'eliminerte': ('eliminere',),
'eliminerende': ('eliminere',),
'ella': ('elle',),
'ellet': ('elle',),
'ella': ('elle',),
'ellet': ('elle',),
'ella': ('elle',),
'ellete': ('elle',),
'ellede': ('elle',),
'ella': ('elle',),
'ellete': ('elle',),
'ellede': ('elle',),
'ellende': ('elle',),
'elleveårig': ('elleveårig',),
'elleveårige': ('elleveårig',),
'elleveårig': ('elleveårig',),
'elleveårs': ('elleveårs',),
'ellevill': ('ellevill',),
'elleville': ('ellevill',),
'ellevilt': ('ellevill',),
'ellevte': ('ellevte',),
'ellipseforma': ('ellipseforma',),
'ellipseformet': ('ellipseformet',),
'ellipseformete': ('ellipseformet',),
'ellipseformede': ('ellipseformet',),
'ellipseformete': ('ellipseformet',),
'ellipseformede': ('ellipseformet',),
'ellipseformet': ('ellipseformet',),
'elliptisk': ('elliptisk',),
'elliptiske': ('elliptisk',),
'elliptisk': ('elliptisk',),
'eloksert': ('eloksere',),
'elokserte': ('eloksere',),
'elokserende': ('eloksere',),
'elska': ('elske',),
'elsket': ('elske',),
'elska': ('elske',),
'elsket': ('elske',),
'elska': ('elske',),
'elskete': ('elske',),
'elskede': ('elske',),
'elska': ('elske',),
'elskete': ('elske',),
'elskede': ('elske',),
'elskende': ('elske',),
'elskelig': ('elskelig',),
'elskelige': ('elskelig',),
'elskelig': ('elskelig',),
'elskovsfull': ('elskovsfull',),
'elskovsfulle': ('elskovsfull',),
'elskovsfullt': ('elskovsfull',),
'elskverdig': ('elskverdig',),
'elskverdige': ('elskverdig',),
'elskverdig': ('elskverdig',),
'elta': ('elte',),
'eltet': ('elte',),
'elta': ('elte',),
'eltet': ('elte',),
'elta': ('elte',),
'eltete': ('elte',),
'eltede': ('elte',),
'elta': ('elte',),
'eltete': ('elte',),
'eltede': ('elte',),
'eltende': ('elte',),
'eludert': ('eludere',),
'eluderte': ('eludere',),
'eluderende': ('eludere',),
'elyseisk': ('elyseisk',),
'elyseiske': ('elyseisk',),
'elyseisk': ('elyseisk',),
'elzevirsk': ('elzevirsk',),
'elzevirske': ('elzevirsk',),
'elzevirsk': ('elzevirsk',),
'emaljert': ('emaljere',),
'emaljerte': ('emaljere',),
'emaljerende': ('emaljere',),
'emansipert': ('emansipere',),
'emansiperte': ('emansipere',),
'emansiperende': ('emansipere',),
'emansipert': ('emansipert',),
'emansiperte': ('emansipert',),
'emansipert': ('emansipert',),
'emballert': ('emballere',),
'emballerte': ('emballere',),
'emballerende': ('emballere',),
'embarkert': ('embarkere',),
'embarkerte': ('embarkere',),
'embarkerende': ('embarkere',),
'emfatisk': ('emfatisk',),
'emfatiske': ('emfatisk',),
'emfatisk': ('emfatisk',),
'emigrert': ('emigrere',),
'emigrerte': ('emigrere',),
'emigrerende': ('emigrere',),
'eminent': ('eminent',),
'eminente': ('eminent',),
'eminent': ('eminent',),
'emittert': ('emittere',),
'emitterte': ('emittere',),
'emitterende': ('emittere',),
'emmen': ('emmen',),
'emne': ('emmen',),
'emment': ('emmen',),
'emna': ('emne',),
'emnet': ('emne',),
'emna': ('emne',),
'emnet': ('emne',),
'emna': ('emne',),
'emnete': ('emne',),
'emnede': ('emne',),
'emna': ('emne',),
'emnete': ('emne',),
'emnede': ('emne',),
'emnende': ('emne',),
'emnelig': ('emnelig',),
'emnelige': ('emnelig',),
'emnelig': ('emnelig',),
'emosjonell': ('emosjonell',),
'emosjonelle': ('emosjonell',),
'emosjonelt': ('emosjonell',),
'emotiv': ('emotiv',),
'emotive': ('emotiv',),
'emotivt': ('emotiv',),
'empirisk': ('empirisk',),
'empiriske': ('empirisk',),
'empirisk': ('empirisk',),
'employert': ('employere',),
'employerte': ('employere',),
'employerende': ('employere',),
'emulgert': ('emulgere',),
'emulgerte': ('emulgere',),
'emulgerende': ('emulgere',),
'en vogue': ('en vogue',),
'enarma': ('enarma',),
'enarmet': ('enarmet',),
'enarmete': ('enarmet',),
'enarmede': ('enarmet',),
'enarmete': ('enarmet',),
'enarmede': ('enarmet',),
'enarmet': ('enarmet',),
'enatomig': ('enatomig',),
'enatomige': ('enatomig',),
'enatomig': ('enatomig',),
'enbo': ('enbo',),
'enbu': ('enbu',),
'enbåren': ('enbåren',),
'enbårne': ('enbåren',),
'enbårent': ('enbåren',),
'encella': ('encella',),
'encellet': ('encellet',),
'encellete': ('encellet',),
'encellede': ('encellet',),
'encellete': ('encellet',),
'encellede': ('encellet',),
'encellet': ('encellet',),
'encyklisk': ('encyklisk',),
'encykliske': ('encyklisk',),
'encyklisk': ('encyklisk',),
'encyklopedisk': ('encyklopedisk',),
'encyklopediske': ('encyklopedisk',),
'encyklopedisk': ('encyklopedisk',),
'endt': ('ende',),
'endte': ('ende',),
'endende': ('ende',),
'endefram': ('endefram',),
'endeframme': ('endefram',),
'endeframt': ('endefram',),
'endefrem': ('endefrem',),
'endefremme': ('endefrem',),
'endefremt': ('endefrem',),
'endefrem': ('endefrem',),
'endegyldig': ('endegyldig',),
'endegyldige': ('endegyldig',),
'endegyldig': ('endegyldig',),
'endelaus': ('endelaus',),
'endelause': ('endelaus',),
'endelaust': ('endelaus',),
'endelig': ('endelig',),
'endelige': ('endelig',),
'endelig': ('endelig',),
'endeløs': ('endeløs',),
'endeløse': ('endeløs',),
'endeløst': ('endeløs',),
'endemisk': ('endemisk',),
'endemiske': ('endemisk',),
'endemisk': ('endemisk',),
'endetil': ('endetil',),
'endevendt': ('endevende',),
'endevendte': ('endevende',),
'endevendende': ('endevende',),
'endimensjonal': ('endimensjonal',),
'endimensjonale': ('endimensjonal',),
'endimensjonalt': ('endimensjonal',),
'endogen': ('endogen',),
'endogene': ('endogen',),
'endogent': ('endogen',),
'endokrin': ('endokrin',),
'endokrine': ('endokrin',),
'endokrint': ('endokrin',),
'endossert': ('endossere',),
'endosserte': ('endossere',),
'endosserende': ('endossere',),
'endoterm': ('endoterm',),
'endoterme': ('endoterm',),
'endotermt': ('endoterm',),
'endra': ('endre',),
'endret': ('endre',),
'endra': ('endre',),
'endret': ('endre',),
'endra': ('endre',),
'endrete': ('endre',),
'endrede': ('endre',),
'endrete': ('endre',),
'endrede': ('endre',),
'endra': ('endre',),
'endrete': ('endre',),
'endrede': ('endre',),
'endrete': ('endre',),
'endrede': ('endre',),
'endrende': ('endre',),
'ent': ('ene',),
'ente': ('ene',),
'enende': ('ene',),
'eneberettiga': ('eneberettiga',),
'eneberettiget': ('eneberettiget',),
'eneberettigete': ('eneberettiget',),
'eneberettigede': ('eneberettiget',),
'eneberettigete': ('eneberettiget',),
'eneberettigede': ('eneberettiget',),
'eneberettiget': ('eneberettiget',),
'eneherskende': ('eneherskende',),
'energetisk': ('energetisk',),
'energetiske': ('energetisk',),
'energetisk': ('energetisk',),
'energisk': ('energisk',),
'energiske': ('energisk',),
'energisk': ('energisk',),
'enervert': ('enervere',),
'enerverte': ('enervere',),
'enerverende': ('enervere',),
'enerverende': ('enerverende',),
'enerådende': ('enerådende',),
'enerådig': ('enerådig',),
'enerådige': ('enerådig',),
'enerådig': ('enerådig',),
'enestående': ('enestående',),
'enetasjes': ('enetasjes',),
'eneveldig': ('eneveldig',),
'eneveldige': ('eneveldig',),
'eneveldig': ('eneveldig',),
'enfasa': ('enfasa',),
'enfaset': ('enfaset',),
'enfasete': ('enfaset',),
'enfasede': ('enfaset',),
'enfasete': ('enfaset',),
'enfasede': ('enfaset',),
'enfaset': ('enfaset',),
'enfoldig': ('enfoldig',),
'enfoldige': ('enfoldig',),
'enfoldig': ('enfoldig',),
'enfrøblada': ('enfrøblada',),
'enfrøbladet': ('enfrøbladet',),
'enfrøbladete': ('enfrøbladet',),
'enfrøbladede': ('enfrøbladet',),
'enfrøbladete': ('enfrøbladet',),
'enfrøbladede': ('enfrøbladet',),
'enfrøbladet': ('enfrøbladet',),
'eng': ('eng',),
'enge': ('eng',),
'engt': ('eng',),
'engere': ('eng',),
'engest': ('eng',),
'engeste': ('eng',),
'engangs': ('engangs',),
'engasjert': ('engasjere',),
'engasjerte': ('engasjere',),
'engasjerende': ('engasjere',),
'engelsk': ('engelsk',),
'engelske': ('engelsk',),
'engelsk': ('engelsk',),
'engelsk-norsk': ('engelsk-norsk',),
'engelsk-norske': ('engelsk-norsk',),
'engelsk-norsk': ('engelsk-norsk',),
'engelskspråklig': ('engelskspråklig',),
'engelskspråklige': ('engelskspråklig',),
'engelskspråklig': ('engelskspråklig',),
'engelsktalende': ('engelsktalende',),
'engleaktig': ('engleaktig',),
'engleaktige': ('engleaktig',),
'engleaktig': ('engleaktig',),
'engsta': ('engste',),
'engstet': ('engste',),
'engsta': ('engste',),
'engstet': ('engste',),
'engsta': ('engste',),
'engstete': ('engste',),
'engstede': ('engste',),
'engsta': ('engste',),
'engstete': ('engste',),
'engstede': ('engste',),
'engstende': ('engste',),
'engstelig': ('engstelig',),
'engstelige': ('engstelig',),
'engstelig': ('engstelig',),
'engsteligere': ('engstelig',),
'engsteligst': ('engstelig',),
'engsteligste': ('engstelig',),
'enhetlig': ('enhetlig',),
'enhetlige': ('enhetlig',),
'enhetlig': ('enhetlig',),
'enhånds': ('enhånds',),
'enig': ('enig',),
'enige': ('enig',),
'enig': ('enig',),
'enigmatisk': ('enigmatisk',),
'enigmatiske': ('enigmatisk',),
'enigmatisk': ('enigmatisk',),
'enkel': ('enkel',),
'enkle': ('enkel',),
'enkelt': ('enkel',),
'enklere': ('enkel',),
'enklest': ('enkel',),
'enkleste': ('enkel',),
'enkelt': ('enkelt',),
'enkelte': ('enkelt',),
'enkelt': ('enkelt',),
'enkeltknappa': ('enkeltknappa',),
'enkeltknappet': ('enkeltknappet',),
'enkeltknappete': ('enkeltknappet',),
'enkeltknappede': ('enkeltknappet',),
'enkeltknappete': ('enkeltknappet',),
'enkeltknappede': ('enkeltknappet',),
'enkeltknappet': ('enkeltknappet',),
'enkeltløpa': ('enkeltløpa',),
'enkeltløpet': ('enkeltløpet',),
'enkeltløpete': ('enkeltløpet',),
'enkeltløpede': ('enkeltløpet',),
'enkeltløpete': ('enkeltløpet',),
'enkeltløpede': ('enkeltløpet',),
'enkeltløpet': ('enkeltløpet',),
'enkeltspent': ('enkeltspent',),
'enkeltspente': ('enkeltspent',),
'enkeltspent': ('enkeltspent',),
'enkeltspora': ('enkeltspora',),
'enkeltsporet': ('enkeltsporet',),
'enkeltsporete': ('enkeltsporet',),
'enkeltsporede': ('enkeltsporet',),
'enkeltsporete': ('enkeltsporet',),
'enkeltsporede': ('enkeltsporet',),
'enkeltsporet': ('enkeltsporet',),
'enkeltstående': ('enkeltstående',),
'enkjønna': ('enkjønna',),
'enkjønnet': ('enkjønnet',),
'enkjønnete': ('enkjønnet',),
'enkjønnede': ('enkjønnet',),
'enkjønnete': ('enkjønnet',),
'enkjønnede': ('enkjønnet',),
'enkjønnet': ('enkjønnet',),
'enklitisk': ('enklitisk',),
'enklitiske': ('enklitisk',),
'enklitisk': ('enklitisk',),
'enmanns': ('enmanns',),
'enmannsbetjent': ('enmannsbetjent',),
'enmannsbetjente': ('enmannsbetjent',),
'enmannsbetjent': ('enmannsbetjent',),
'enmotors': ('enmotors',),
'enorm': ('enorm',),
'enorme': ('enorm',),
'enormt': ('enorm',),
'enpukla': ('enpukla',),
'enpuklet': ('enpuklet',),
'enpuklete': ('enpuklet',),
'enpuklede': ('enpuklet',),
'enpuklete': ('enpuklet',),
'enpuklede': ('enpuklet',),
'enpuklet': ('enpuklet',),
'ens': ('ens',),
'ensarta': ('ensarta',),
'ensartet': ('ensartet',),
'ensartete': ('ensartet',),
'ensartede': ('ensartet',),
'ensartete': ('ensartet',),
'ensartede': ('ensartet',),
'ensartet': ('ensartet',),
'ensbetydende': ('ensbetydende',),
'ensa': ('ense',),
'enset': ('ense',),
'enst': ('ense',),
'ensa': ('ense',),
'enset': ('ense',),
'enst': ('ense',),
'ensa': ('ense',),
'ensete': ('ense',),
'ensede': ('ense',),
'enste': ('ense',),
'ensa': ('ense',),
'ensete': ('ense',),
'ensede': ('ense',),
'enste': ('ense',),
'ensende': ('ense',),
'ensfarga': ('ensfarga',),
'ensfarget': ('ensfarget',),
'ensfargete': ('ensfarget',),
'ensfargede': ('ensfarget',),
'ensfargete': ('ensfarget',),
'ensfargede': ('ensfarget',),
'ensfarget': ('ensfarget',),
'ensforma': ('ensforma',),
'ensformet': ('ensformet',),
'ensformete': ('ensformet',),
'ensformede': ('ensformet',),
'ensformete': ('ensformet',),
'ensformede': ('ensformet',),
'ensformet': ('ensformet',),
'ensformig': ('ensformig',),
'ensformige': ('ensformig',),
'ensformig': ('ensformig',),
'ensidig': ('ensidig',),
'ensidige': ('ensidig',),
'ensidig': ('ensidig',),
'ensifra': ('ensifra',),
'ensifret': ('ensifret',),
'ensifrete': ('ensifret',),
'ensifrede': ('ensifret',),
'ensifrete': ('ensifret',),
'ensifrede': ('ensifret',),
'ensifret': ('ensifret',),
'ensilert': ('ensilere',),
'ensilerte': ('ensilere',),
'ensilerende': ('ensilere',),
'enskafta': ('enskafta',),
'enskaftet': ('enskaftet',),
'enskaftete': ('enskaftet',),
'enskaftede': ('enskaftet',),
'enskaftete': ('enskaftet',),
'enskaftede': ('enskaftet',),
'enskaftet': ('enskaftet',),
'enskjærs': ('enskjærs',),
'enslig': ('enslig',),
'enslige': ('enslig',),
'enslig': ('enslig',),
'ensligstilt': ('ensligstilt',),
'ensligstilte': ('ensligstilt',),
'ensligstilt': ('ensligstilt',),
'enslydende': ('enslydende',),
'ensom': ('ensom',),
'ensomme': ('ensom',),
'ensomt': ('ensom',),
'ensommere': ('ensom',),
'ensomst': ('ensom',),
'ensomste': ('ensom',),
'enspora': ('enspora',),
'ensporet': ('ensporet',),
'ensporete': ('ensporet',),
'ensporede': ('ensporet',),
'ensporete': ('ensporet',),
'ensporede': ('ensporet',),
'ensporet': ('ensporet',),
'enspråklig': ('enspråklig',),
'enspråklige': ('enspråklig',),
'enspråklig': ('enspråklig',),
'ensretta': ('ensrette',),
'ensrettet': ('ensrette',),
'ensretta': ('ensrette',),
'ensrettet': ('ensrette',),
'ensretta': ('ensrette',),
'ensrettete': ('ensrette',),
'ensrettede': ('ensrette',),
'ensretta': ('ensrette',),
'ensrettete': ('ensrette',),
'ensrettede': ('ensrette',),
'ensrettende': ('ensrette',),
'enstava': ('enstava',),
'enstavet': ('enstavet',),
'enstavete': ('enstavet',),
'enstavede': ('enstavet',),
'enstavete': ('enstavet',),
'enstavede': ('enstavet',),
'enstavet': ('enstavet',),
'enstemmig': ('enstemmig',),
'enstemmige': ('enstemmig',),
'enstemmig': ('enstemmig',),
'enstonig': ('enstonig',),
'enstonige': ('enstonig',),
'enstonig': ('enstonig',),
'enstrøken': ('enstrøken',),
'enstrøkne': ('enstrøken',),
'enstrøket': ('enstrøken',),
'enstrøket': ('enstrøket',),
'enstrøkne': ('enstrøket',),
'enstrøket': ('enstrøket',),
'enstydig': ('enstydig',),
'enstydige': ('enstydig',),
'enstydig': ('enstydig',),
'ente': ('ente',),
'entoms': ('entoms',),
'entra': ('entre',),
'entret': ('entre',),
'entra': ('entre',),
'entret': ('entre',),
'entra': ('entre',),
'entrete': ('entre',),
'entrede': ('entre',),
'entrete': ('entre',),
'entrede': ('entre',),
'entra': ('entre',),
'entrete': ('entre',),
'entrede': ('entre',),
'entrete': ('entre',),
'entrede': ('entre',),
'entrende': ('entre',),
'entreprenant': ('entreprenant',),
'entreprenante': ('entreprenant',),
'entreprenant': ('entreprenant',),
'entusiastisk': ('entusiastisk',),
'entusiastiske': ('entusiastisk',),
'entusiastisk': ('entusiastisk',),
'entydig': ('entydig',),
'entydige': ('entydig',),
'entydig': ('entydig',),
'envegsregulert': ('envegsregulere',),
'envegsregulerte': ('envegsregulere',),
'envegsregulerende': ('envegsregulere',),
'enveisregulert': ('enveisregulere',),
'enveisregulerte': ('enveisregulere',),
'enveisregulerende': ('enveisregulere',),
'enverdig': ('enverdig',),
'enverdige': ('enverdig',),
'enverdig': ('enverdig',),
'envis': ('envis',),
'envise': ('envis',),
'envist': ('envis',),
'enzymatisk': ('enzymatisk',),
'enzymatiske': ('enzymatisk',),
'enzymatisk': ('enzymatisk',),
'enøres': ('enøres',),
'enøyd': ('enøyd',),
'enøyde': ('enøyd',),
'enøyd': ('enøyd',),
'epidemisk': ('epidemisk',),
'epidemiske': ('epidemisk',),
'epidemisk': ('epidemisk',),
'epidural': ('epidural',),
'epidurale': ('epidural',),
'epiduralt': ('epidural',),
'epikureisk': ('epikureisk',),
'epikureiske': ('epikureisk',),
'epikureisk': ('epikureisk',),
'epileptisk': ('epileptisk',),
'epileptiske': ('epileptisk',),
'epileptisk': ('epileptisk',),
'episk': ('episk',),
'episke': ('episk',),
'episk': ('episk',),
'episkopal': ('episkopal',),
'episkopale': ('episkopal',),
'episkopalt': ('episkopal',),
'episodisk': ('episodisk',),
'episodiske': ('episodisk',),
'episodisk': ('episodisk',),
'epistemisk': ('epistemisk',),
'epistemiske': ('epistemisk',),
'epistemisk': ('epistemisk',),
'epistemologisk': ('epistemologisk',),
'epistemologiske': ('epistemologisk',),
'epistemologisk': ('epistemologisk',),
'epokegjørende': ('epokegjørende',),
'erfart': ('erfare',),
'erfarte': ('erfare',),
'erfarende': ('erfare',),
'erfaren': ('erfaren',),
'erfarne': ('erfaren',),
'erfarent': ('erfaren',),
'erfaringsmessig': ('erfaringsmessig',),
'erfaringsmessige': ('erfaringsmessig',),
'erfaringsmessig': ('erfaringsmessig',),
'ergerlig': ('ergerlig',),
'ergerlige': ('ergerlig',),
'ergerlig': ('ergerlig',),
'ergra': ('ergre',),
'ergret': ('ergre',),
'ergra': ('ergre',),
'ergret': ('ergre',),
'ergra': ('ergre',),
'ergrete': ('ergre',),
'ergrede': ('ergre',),
'ergrete': ('ergre',),
'ergrede': ('ergre',),
'ergra': ('ergre',),
'ergrete': ('ergre',),
'ergrede': ('ergre',),
'ergrete': ('ergre',),
'ergrede': ('ergre',),
'ergrende': ('ergre',),
'erholdt': ('erholde',),
'erholdte': ('erholde',),
'erholdende': ('erholde',),
'erigert': ('erigere',),
'erigerte': ('erigere',),
'erigerende': ('erigere',),
'erindra': ('erindre',),
'erindret': ('erindre',),
'erindra': ('erindre',),
'erindret': ('erindre',),
'erindra': ('erindre',),
'erindrete': ('erindre',),
'erindrede': ('erindre',),
'erindrete': ('erindre',),
'erindrede': ('erindre',),
'erindra': ('erindre',),
'erindrete': ('erindre',),
'erindrede': ('erindre',),
'erindrete': ('erindre',),
'erindrede': ('erindre',),
'erindrende': ('erindre',),
'eritreisk': ('eritreisk',),
'eritreiske': ('eritreisk',),
'eritreisk': ('eritreisk',),
'erkekonservativ': ('erkekonservativ',),
'erkekonservative': ('erkekonservativ',),
'erkekonservativt': ('erkekonservativ',),
'erkjent': ('erkjenne',),
'erkjente': ('erkjenne',),
'erkjennende': ('erkjenne',),
'erklært': ('erklære',),
'erklærte': ('erklære',),
'erklærende': ('erklære',),
'erklært': ('erklært',),
'erklærte': ('erklært',),
'erklært': ('erklært',),
'erlagt': ('erlegge',),
'erlagte': ('erlegge',),
'erleggende': ('erlegge',),
'ernært': ('ernære',),
'ernærte': ('ernære',),
'ernærende': ('ernære',),
'erobra': ('erobre',),
'erobret': ('erobre',),
'erobra': ('erobre',),
'erobret': ('erobre',),
'erobra': ('erobre',),
'erobrete': ('erobre',),
'erobrede': ('erobre',),
'erobrete': ('erobre',),
'erobrede': ('erobre',),
'erobra': ('erobre',),
'erobrete': ('erobre',),
'erobrede': ('erobre',),
'erobrete': ('erobre',),
'erobrede': ('erobre',),
'erobrende': ('erobre',),
'erodert': ('erodere',),
'eroderte': ('erodere',),
'eroderende': ('erodere',),
'erogen': ('erogen',),
'erogene': ('erogen',),
'erogent': ('erogen',),
'erotisert': ('erotisere',),
'erotiserte': ('erotisere',),
'erotiserende': ('erotisere',),
'erotisk': ('erotisk',),
'erotiske': ('erotisk',),
'erotisk': ('erotisk',),
'erotoman': ('erotoman',),
'erotomane': ('erotoman',),
'erotomant': ('erotoman',),
'erstatta': ('erstatte',),
'erstattet': ('erstatte',),
'erstatta': ('erstatte',),
'erstattet': ('erstatte',),
'erstatta': ('erstatte',),
'erstattete': ('erstatte',),
'erstattede': ('erstatte',),
'erstatta': ('erstatte',),
'erstattete': ('erstatte',),
'erstattede': ('erstatte',),
'erstattende': ('erstatte',),
'erstattelig': ('erstattelig',),
'erstattelige': ('erstattelig',),
'erstattelig': ('erstattelig',),
'erta': ('erte',),
'ertet': ('erte',),
'erta': ('erte',),
'ertet': ('erte',),
'erta': ('erte',),
'ertete': ('erte',),
'ertede': ('erte',),
'erta': ('erte',),
'ertete': ('erte',),
'ertede': ('erte',),
'ertende': ('erte',),
'erteblomstra': ('erteblomstra',),
'erteblomstret': ('erteblomstret',),
'erteblomstrete': ('erteblomstret',),
'erteblomstrede': ('erteblomstret',),
'erteblomstrete': ('erteblomstret',),
'erteblomstrede': ('erteblomstret',),
'erteblomstret': ('erteblomstret',),
'erten': ('erten',),
'ertne': ('erten',),
'ertent': ('erten',),
'ertet': ('ertet',),
'ertete': ('ertet',),
'ertet': ('ertet',),
'ertete': ('ertete',),
'eruptiv': ('eruptiv',),
'eruptive': ('eruptiv',),
'eruptivt': ('eruptiv',),
'erverva': ('erverve',),
'ervervet': ('erverve',),
'erverva': ('erverve',),
'ervervet': ('erverve',),
'erverva': ('erverve',),
'ervervete': ('erverve',),
'ervervede': ('erverve',),
'erverva': ('erverve',),
'ervervete': ('erverve',),
'ervervede': ('erverve',),
'ervervende': ('erverve',),
'ervervsdyktig': ('ervervsdyktig',),
'ervervsdyktige': ('ervervsdyktig',),
'ervervsdyktig': ('ervervsdyktig',),
'ervervslaus': ('ervervslaus',),
'ervervslause': ('ervervslaus',),
'ervervslaust': ('ervervslaus',),
'ervervsløs': ('ervervsløs',),
'ervervsløse': ('ervervsløs',),
'ervervsløst': ('ervervsløs',),
'ervervsmessig': ('ervervsmessig',),
'ervervsmessige': ('ervervsmessig',),
'ervervsmessig': ('ervervsmessig',),
'est': ('ese',),
'este': ('ese',),
'esende': ('ese',),
'eskalert': ('eskalere',),
'eskalerte': ('eskalere',),
'eskalerende': ('eskalere',),
'eskamotert': ('eskamotere',),
'eskamoterte': ('eskamotere',),
'eskamoterende': ('eskamotere',),
'eskapert': ('eskapere',),
'eskaperte': ('eskapere',),
'eskaperende': ('eskapere',),
'eskapistisk': ('eskapistisk',),
'eskapistiske': ('eskapistisk',),
'eskapistisk': ('eskapistisk',),
'eskatologisk': ('eskatologisk',),
'eskatologiske': ('eskatologisk',),
'eskatologisk': ('eskatologisk',),
'eska': ('eske',),
'esket': ('eske',),
'eska': ('eske',),
'esket': ('eske',),
'eska': ('eske',),
'eskete': ('eske',),
'eskede': ('eske',),
'eska': ('eske',),
'eskete': ('eske',),
'eskede': ('eske',),
'eskende': ('eske',),
'eskimoisk': ('eskimoisk',),
'eskimoiske': ('eskimoisk',),
'eskimoisk': ('eskimoisk',),
'eskimoisk-aleutisk': ('eskimoisk-aleutisk',),
'eskimoisk-aleutiske': ('eskimoisk-aleutisk',),
'eskimoisk-aleutisk': ('eskimoisk-aleutisk',),
'eskortert': ('eskortere',),
'eskorterte': ('eskortere',),
'eskorterende': ('eskortere',),
'esla': ('esle',),
'eslet': ('esle',),
'esla': ('esle',),
'eslet': ('esle',),
'esla': ('esle',),
'eslete': ('esle',),
'eslede': ('esle',),
'esla': ('esle',),
'eslete': ('esle',),
'eslede': ('esle',),
'eslende': ('esle',),
'esoterisk': ('esoterisk',),
'esoteriske': ('esoterisk',),
'esoterisk': ('esoterisk',),
'essensiell': ('essensiell',),
'essensielle': ('essensiell',),
'essensielt': ('essensiell',),
'estetisert': ('estetisere',),
'estetiserte': ('estetisere',),
'estetiserende': ('estetisere',),
'estetisk': ('estetisk',),
'estetiske': ('estetisk',),
'estetisk': ('estetisk',),
'estimert': ('estimere',),
'estimerte': ('estimere',),
'estimerende': ('estimere',),
'estisk': ('estisk',),
'estiske': ('estisk',),
'estisk': ('estisk',),
'estlandsk': ('estlandsk',),
'estlandske': ('estlandsk',),
'estlandsk': ('estlandsk',),
'etablert': ('etablere',),
'etablerte': ('etablere',),
'etablerende': ('etablere',),
'etablert': ('etablert',),
'etablerte': ('etablert',),
'etablert': ('etablert',),
'ett': ('ete',),
'ette': ('ete',),
'etende': ('ete',),
'eterisk': ('eterisk',),
'eteriske': ('eterisk',),
'eterisk': ('eterisk',),
'etikettert': ('etikettere',),
'etiketterte': ('etikettere',),
'etiketterende': ('etikettere',),
'etiopisk': ('etiopisk',),
'etiopiske': ('etiopisk',),
'etiopisk': ('etiopisk',),
'etisk': ('etisk',),
'etiske': ('etisk',),
'etisk': ('etisk',),
'etla': ('etle',),
'etlet': ('etle',),
'etla': ('etle',),
'etlet': ('etle',),
'etla': ('etle',),
'etlete': ('etle',),
'etlede': ('etle',),
'etlete': ('etle',),
'etlede': ('etle',),
'etla': ('etle',),
'etlete': ('etle',),
'etlede': ('etle',),
'etlete': ('etle',),
'etlede': ('etle',),
'etlende': ('etle',),
'etnisk': ('etnisk',),
'etniske': ('etnisk',),
'etnisk': ('etnisk',),
'etnografisk': ('etnografisk',),
'etnografiske': ('etnografisk',),
'etnografisk': ('etnografisk',),
'etnologisk': ('etnologisk',),
'etnologiske': ('etnologisk',),
'etnologisk': ('etnologisk',),
'etnosentrisk': ('etnosentrisk',),
'etnosentriske': ('etnosentrisk',),
'etnosentrisk': ('etnosentrisk',),
'etologisk': ('etologisk',),
'etologiske': ('etologisk',),
'etologisk': ('etologisk',),
'etrurisk': ('etrurisk',),
'etruriske': ('etrurisk',),
'etrurisk': ('etrurisk',),
'etruskisk': ('etruskisk',),
'etruskiske': ('etruskisk',),
'etruskisk': ('etruskisk',),
'etsa': ('etse',),
'etset': ('etse',),
'etsa': ('etse',),
'etset': ('etse',),
'etsa': ('etse',),
'etsete': ('etse',),
'etsede': ('etse',),
'etsa': ('etse',),
'etsete': ('etse',),
'etsede': ('etse',),
'etsende': ('etse',),
'etteranmeldt': ('etteranmelde',),
'etteranmeldte': ('etteranmelde',),
'etteranmeldende': ('etteranmelde',),
'etterapa': ('etterape',),
'etterapet': ('etterape',),
'etterapt': ('etterape',),
'etterapa': ('etterape',),
'etterapet': ('etterape',),
'etterapt': ('etterape',),
'etterapa': ('etterape',),
'etterapete': ('etterape',),
'etterapede': ('etterape',),
'etterapte': ('etterape',),
'etterapa': ('etterape',),
'etterapete': ('etterape',),
'etterapede': ('etterape',),
'etterapte': ('etterape',),
'etterapende': ('etterape',),
'etterbehandla': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandlete': ('etterbehandle',),
'etterbehandlede': ('etterbehandle',),
'etterbehandlete': ('etterbehandle',),
'etterbehandlede': ('etterbehandle',),
'etterbehandla': ('etterbehandle',),
'etterbehandlete': ('etterbehandle',),
'etterbehandlede': ('etterbehandle',),
'etterbehandlete': ('etterbehandle',),
'etterbehandlede': ('etterbehandle',),
'etterbehandlende': ('etterbehandle',),
'etterbetalt': ('etterbetale',),
'etterbetalte': ('etterbetale',),
'etterbetalende': ('etterbetale',),
'etterforska': ('etterforske',),
'etterforsket': ('etterforske',),
'etterforska': ('etterforske',),
'etterforsket': ('etterforske',),
'etterforska': ('etterforske',),
'etterforskete': ('etterforske',),
'etterforskede': ('etterforske',),
'etterforska': ('etterforske',),
'etterforskete': ('etterforske',),
'etterforskede': ('etterforske',),
'etterforskende': ('etterforske',),
'etterfylt': ('etterfylle',),
'etterfylte': ('etterfylle',),
'etterfyllende': ('etterfylle',),
'ettergitt': ('ettergi',),
'ettergitte': ('ettergi',),
'ettergiende': ('ettergi',),
'ettergiven': ('ettergiven',),
'ettergivne': ('ettergiven',),
'ettergivent': ('ettergiven',),
'ettergivende': ('ettergivende',),
'ettergjort': ('ettergjøre',),
'ettergjorte': ('ettergjøre',),
'ettergjørende': ('ettergjøre',),
'ettergymnasial': ('ettergymnasial',),
'ettergymnasiale': ('ettergymnasial',),
'ettergymnasialt': ('ettergymnasial',),
'etterhengt': ('etterhengt',),
'etterhengte': ('etterhengt',),
'etterhengt': ('etterhengt',),
'etterisolert': ('etterisolere',),
'etterisolerte': ('etterisolere',),
'etterisolerende': ('etterisolere',),
'etterklok': ('etterklok',),
'etterkloke': ('etterklok',),
'etterklokt': ('etterklok',),
'etterlatt': ('etterlate',),
'etterlatte': ('etterlate',),
'etterlatende': ('etterlate',),
'etterlengta': ('etterlengta',),
'etterlengtet': ('etterlengtet',),
'etterlengtete': ('etterlengtet',),
'etterlengtede': ('etterlengtet',),
'etterlengtete': ('etterlengtet',),
'etterlengtede': ('etterlengtet',),
'etterlengtet': ('etterlengtet',),
'etterlevd': ('etterleve',),
'etterlevde': ('etterleve',),
'etterlevende': ('etterleve',),
'etterlevende': ('etterlevende',),
'etterligna': ('etterligne',),
'etterlignet': ('etterligne',),
'etterligna': ('etterligne',),
'etterlignet': ('etterligne',),
'etterligna': ('etterligne',),
'etterlignete': ('etterligne',),
'etterlignede': ('etterligne',),
'etterligna': ('etterligne',),
'etterlignete': ('etterligne',),
'etterlignede': ('etterligne',),
'etterlignende': ('etterligne',),
'etterlikna': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterliknete': ('etterlikne',),
'etterliknede': ('etterlikne',),
'etterliknete': ('etterlikne',),
'etterliknede': ('etterlikne',),
'etterlikna': ('etterlikne',),
'etterliknete': ('etterlikne',),
'etterliknede': ('etterlikne',),
'etterliknete': ('etterlikne',),
'etterliknede': ('etterlikne',),
'etterliknende': ('etterlikne',),
'etterlyst': ('etterlyse',),
'etterlyste': ('etterlyse',),
'etterlysende': ('etterlyse',),
'etterplapra': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplaprete': ('etterplapre',),
'etterplaprede': ('etterplapre',),
'etterplaprete': ('etterplapre',),
'etterplaprede': ('etterplapre',),
'etterplapra': ('etterplapre',),
'etterplaprete': ('etterplapre',),
'etterplaprede': ('etterplapre',),
'etterplaprete': ('etterplapre',),
'etterplaprede': ('etterplapre',),
'etterplaprende': ('etterplapre',),
'etterprøvd': ('etterprøve',),
'etterprøvde': ('etterprøve',),
'etterprøvende': ('etterprøve',),
'etterpåklok': ('etterpåklok',),
'etterpåkloke': ('etterpåklok',),
'etterpåklokt': ('etterpåklok',),
'etterrettelig': ('etterrettelig',),
'etterrettelige': ('etterrettelig',),
'etterrettelig': ('etterrettelig',),
'ettersett': ('etterse',),
'ettersette': ('etterse',),
'etterseende': ('etterse',),
'ettersendt': ('ettersende',),
'ettersendte': ('ettersende',),
'ettersendende': ('ettersende',),
'ettersittende': ('ettersittende',),
'etterslokka': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokt': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokt': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokkete': ('etterslokke',),
'etterslokkede': ('etterslokke',),
'etterslokte': ('etterslokke',),
'etterslokka': ('etterslokke',),
'etterslokkete': ('etterslokke',),
'etterslokkede': ('etterslokke',),
'etterslokte': ('etterslokke',),
'etterslokkende': ('etterslokke',),
'etterslukka': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukt': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukt': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukkete': ('etterslukke',),
'etterslukkede': ('etterslukke',),
'etterslukte': ('etterslukke',),
'etterslukka': ('etterslukke',),
'etterslukkete': ('etterslukke',),
'etterslukkede': ('etterslukke',),
'etterslukte': ('etterslukke',),
'etterslukkende': ('etterslukke',),
'etterspora': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersport': ('etterspore',),
'etterspora': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersport': ('etterspore',),
'etterspora': ('etterspore',),
'ettersporete': ('etterspore',),
'ettersporede': ('etterspore',),
'ettersporte': ('etterspore',),
'etterspora': ('etterspore',),
'ettersporete': ('etterspore',),
'ettersporede': ('etterspore',),
'ettersporte': ('etterspore',),
'ettersporende': ('etterspore',),
'etterspurt': ('etterspurt',),
'etterspurte': ('etterspurt',),
'etterspurt': ('etterspurt',),
'etterstreba': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebete': ('etterstrebe',),
'etterstrebede': ('etterstrebe',),
'etterstreba': ('etterstrebe',),
'etterstrebete': ('etterstrebe',),
'etterstrebede': ('etterstrebe',),
'etterstrebende': ('etterstrebe',),
'ettersynkronisert': ('ettersynkronisere',),
'ettersynkroniserte': ('ettersynkronisere',),
'ettersynkroniserende': ('ettersynkronisere',),
'ettersøkt': ('ettersøke',),
'ettersøkte': ('ettersøke',),
'ettersøkende': ('ettersøke',),
'ettertenksom': ('ettertenksom',),
'ettertenksomme': ('ettertenksom',),
'ettertenksomt': ('ettertenksom',),
'ettertrakta': ('ettertrakta',),
'ettertrakta': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertraktete': ('ettertrakte',),
'ettertraktede': ('ettertrakte',),
'ettertrakta': ('ettertrakte',),
'ettertraktete': ('ettertrakte',),
'ettertraktede': ('ettertrakte',),
'ettertraktende': ('ettertrakte',),
'ettertraktelsesverdig': ('ettertraktelsesverdig',),
'ettertraktelsesverdige': ('ettertraktelsesverdig',),
'ettertraktelsesverdig': ('ettertraktelsesverdig',),
'ettertraktet': ('ettertraktet',),
'ettertraktete': ('ettertraktet',),
'ettertraktede': ('ettertraktet',),
'ettertraktete': ('ettertraktet',),
'ettertraktede': ('ettertraktet',),
'ettertraktet': ('ettertraktet',),
'ettertrykkelig': ('ettertrykkelig',),
'ettertrykkelige': ('ettertrykkelig',),
'ettertrykkelig': ('ettertrykkelig',),
'ettfags': ('ettfags',),
'ettroms': ('ettroms',),
'ettårig': ('ettårig',),
'ettårige': ('ettårig',),
'ettårig': ('ettårig',),
'ettårs': ('ettårs',),
'ettøres': ('ettøres',),
'etymologisk': ('etymologisk',),
'etymologiske': ('etymologisk',),
'etymologisk': ('etymologisk',),
'eufemistisk': ('eufemistisk',),
'eufemistiske': ('eufemistisk',),
'eufemistisk': ('eufemistisk',),
'eufonisk': ('eufonisk',),
'eufoniske': ('eufonisk',),
'eufonisk': ('eufonisk',),
'euforiserende': ('euforiserende',),
'eugenisk': ('eugenisk',),
'eugeniske': ('eugenisk',),
'eugenisk': ('eugenisk',),
'eukaryot': ('eukaryot',),
'eukaryote': ('eukaryot',),
'eukaryot': ('eukaryot',),
'euklidsk': ('euklidsk',),
'euklidske': ('euklidsk',),
'euklidsk': ('euklidsk',),
'eurasisk': ('eurasisk',),
'eurasiske': ('eurasisk',),
'eurasisk': ('eurasisk',),
'europeisert': ('europeisere',),
'europeiserte': ('europeisere',),
'europeiserende': ('europeisere',),
'europeisk': ('europeisk',),
'europeiske': ('europeisk',),
'europeisk': ('europeisk',),
'eutrof': ('eutrof',),
'eutrofe': ('eutrof',),
'eutroft': ('eutrof',),
'evakuert': ('evakuere',),
'evakuerte': ('evakuere',),
'evakuerende': ('evakuere',),
'evaluert': ('evaluere',),
'evaluerte': ('evaluere',),
'evaluerende': ('evaluere',),
'evangelisert': ('evangelisere',),
'evangeliserte': ('evangelisere',),
'evangeliserende': ('evangelisere',),
'evangelisk': ('evangelisk',),
'evangeliske': ('evangelisk',),
'evangelisk': ('evangelisk',),
'evangelisk-luthersk': ('evangelisk-luthersk',),
'evangelisk-lutherske': ('evangelisk-luthersk',),
'evangelisk-luthersk': ('evangelisk-luthersk',),
'evaporert': ('evaporere',),
'evaporerte': ('evaporere',),
'evaporerende': ('evaporere',),
'evasiv': ('evasiv',),
'evasive': ('evasiv',),
'evasivt': ('evasiv',),
'eva': ('eve',),
'evet': ('eve',),
'eva': ('eve',),
'evet': ('eve',),
'eva': ('eve',),
'evete': ('eve',),
'evede': ('eve',),
'eva': ('eve',),
'evete': ('eve',),
'evede': ('eve',),
'evende': ('eve',),
'eventuell': ('eventuell',),
'eventuelle': ('eventuell',),
'eventuelt': ('eventuell',),
'eventyraktig': ('eventyraktig',),
'eventyraktige': ('eventyraktig',),
'eventyraktig': ('eventyraktig',),
'eventyrlig': ('eventyrlig',),
'eventyrlige': ('eventyrlig',),
'eventyrlig': ('eventyrlig',),
'eventyrlysten': ('eventyrlysten',),
'eventyrlystne': ('eventyrlysten',),
'eventyrlystent': ('eventyrlysten',),
'evfemistisk': ('evfemistisk',),
'evfemistiske': ('evfemistisk',),
'evfemistisk': ('evfemistisk',),
'evident': ('evident',),
'evidente': ('evident',),
'evident': ('evident',),
'evig': ('evig',),
'evige': ('evig',),
'evig': ('evig',),
'eviggrønn': ('eviggrønn',),
'eviggrønne': ('eviggrønn',),
'eviggrønt': ('eviggrønn',),
'evigung': ('evigung',),
'evigunge': ('evigung',),
'evigungt': ('evigung',),
'evigvarende': ('evigvarende',),
'evinnelig': ('evinnelig',),
'evinnelige': ('evinnelig',),
'evinnelig': ('evinnelig',),
'evna': ('evne',),
'evnet': ('evne',),
'evna': ('evne',),
'evnet': ('evne',),
'evna': ('evne',),
'evnete': ('evne',),
'evnede': ('evne',),
'evna': ('evne',),
'evnete': ('evne',),
'evnede': ('evne',),
'evnende': ('evne',),
'evnelaus': ('evnelaus',),
'evnelause': ('evnelaus',),
'evnelaust': ('evnelaus',),
'evneløs': ('evneløs',),
'evneløse': ('evneløs',),
'evneløst': ('evneløs',),
'evnerik': ('evnerik',),
'evnerike': ('evnerik',),
'evnerikt': ('evnerik',),
'evneveik': ('evneveik',),
'evneveike': ('evneveik',),
'evneveikt': ('evneveik',),
'evnevek': ('evnevek',),
'evneveke': ('evnevek',),
'evnevekt': ('evnevek',),
'evolusjonistisk': ('evolusjonistisk',),
'evolusjonistiske': ('evolusjonistisk',),
'evolusjonistisk': ('evolusjonistisk',),
'exa': ('exe',),
'exet': ('exe',),
'exa': ('exe',),
'exet': ('exe',),
'exa': ('exe',),
'exete': ('exe',),
'exede': ('exe',),
'exa': ('exe',),
'exete': ('exe',),
'exede': ('exe',),
'exende': ('exe',),
'fôra': ('fôre',),
'fôret': ('fôre',),
'fôrt': ('fôre',),
'fôra': ('fôre',),
'fôret': ('fôre',),
'fôrt': ('fôre',),
'fôra': ('fôre',),
'fôrete': ('fôre',),
'fôrede': ('fôre',),
'fôrte': ('fôre',),
'fôra': ('fôre',),
'fôrete': ('fôre',),
'fôrede': ('fôre',),
'fôrte': ('fôre',),
'fôrende': ('fôre',),
'fabelaktig': ('fabelaktig',),
'fabelaktige': ('fabelaktig',),
'fabelaktig': ('fabelaktig',),
'fabla': ('fable',),
'fablet': ('fable',),
'fabla': ('fable',),
'fablet': ('fable',),
'fabla': ('fable',),
'fablete': ('fable',),
'fablede': ('fable',),
'fablete': ('fable',),
'fablede': ('fable',),
'fabla': ('fable',),
'fablete': ('fable',),
'fablede': ('fable',),
'fablete': ('fable',),
'fablede': ('fable',),
'fablende': ('fable',),
'fabrikkert': ('fabrikkere',),
'fabrikkerte': ('fabrikkere',),
'fabrikkerende': ('fabrikkere',),
'fabrikkmessig': ('fabrikkmessig',),
'fabrikkmessige': ('fabrikkmessig',),
'fabrikkmessig': ('fabrikkmessig',),
'fabrikkny': ('fabrikkny',),
'fabrikknye': ('fabrikkny',),
'fabrikknytt': ('fabrikkny',),
'fabulert': ('fabulere',),
'fabulerte': ('fabulere',),
'fabulerende': ('fabulere',),
'fada': ('fade',),
'fadet': ('fade',),
'fada': ('fade',),
'fadet': ('fade',),
'fada': ('fade',),
'fadete': ('fade',),
'fadede': ('fade',),
'fada': ('fade',),
'fadete': ('fade',),
'fadede': ('fade',),
'fadende': ('fade',),
'faderlig': ('faderlig',),
'faderlige': ('faderlig',),
'faderlig': ('faderlig',),
'faderløs': ('faderløs',),
'faderløse': ('faderløs',),
'faderløst': ('faderløs',),
'faens': ('faens',),
'fager': ('fager',),
'fagre': ('fager',),
'fagert': ('fager',),
'fagrere': ('fager',),
'fagrest': ('fager',),
'fagreste': ('fager',),
'faglig': ('faglig',),
'faglige': ('faglig',),
'faglig': ('faglig',),
'faglært': ('faglært',),
'faglærte': ('faglært',),
'faglært': ('faglært',),
'fagmessig': ('fagmessig',),
'fagmessige': ('fagmessig',),
'fagmessig': ('fagmessig',),
'fagna': ('fagne',),
'fagnet': ('fagne',),
'fagna': ('fagne',),
'fagnet': ('fagne',),
'fagna': ('fagne',),
'fagnete': ('fagne',),
'fagnede': ('fagne',),
'fagna': ('fagne',),
'fagnete': ('fagne',),
'fagnede': ('fagne',),
'fagnende': ('fagne',),
'fagorganisert': ('fagorganisert',),
'fagorganiserte': ('fagorganisert',),
'fagorganisert': ('fagorganisert',),
'fair': ('fair',),
'fakka': ('fakke',),
'fakket': ('fakke',),
'fakka': ('fakke',),
'fakket': ('fakke',),
'fakka': ('fakke',),
'fakkete': ('fakke',),
'fakkede': ('fakke',),
'fakka': ('fakke',),
'fakkete': ('fakke',),
'fakkede': ('fakke',),
'fakkende': ('fakke',),
'faksa': ('fakse',),
'fakset': ('fakse',),
'faksa': ('fakse',),
'fakset': ('fakse',),
'faksa': ('fakse',),
'faksete': ('fakse',),
'faksede': ('fakse',),
'faksa': ('fakse',),
'faksete': ('fakse',),
'faksede': ('fakse',),
'faksende': ('fakse',),
'fakset': ('fakset',),
'faksete': ('fakset',),
'fakset': ('fakset',),
'faksete': ('faksete',),
'faksimilert': ('faksimilere',),
'faksimilerte': ('faksimilere',),
'faksimilerende': ('faksimilere',),
'faktisk': ('faktisk',),
'faktiske': ('faktisk',),
'faktisk': ('faktisk',),
'faktorisert': ('faktorisere',),
'faktoriserte': ('faktorisere',),
'faktoriserende': ('faktorisere',),
'faktuell': ('faktuell',),
'faktuelle': ('faktuell',),
'faktuelt': ('faktuell',),
'fakturert': ('fakturere',),
'fakturerte': ('fakturere',),
'fakturerende': ('fakturere',),
'fakultativ': ('fakultativ',),
'fakultative': ('fakultativ',),
'fakultativt': ('fakultativ',),
'fal': ('fal',),
'falbydd': ('falby',),
'falbudt': ('falby',),
'falbydd': ('falby',),
'falbudt': ('falby',),
'falbydd': ('falby',),
'falbydde': ('falby',),
'falbudte': ('falby',),
'falbydde': ('falby',),
'falbudte': ('falby',),
'falbydde': ('falby',),
'falbyende': ('falby',),
'falda': ('falde',),
'faldet': ('falde',),
'falda': ('falde',),
'faldet': ('falde',),
'falda': ('falde',),
'faldete': ('falde',),
'faldede': ('falde',),
'falda': ('falde',),
'faldete': ('falde',),
'faldede': ('falde',),
'faldende': ('falde',),
'falklandsk': ('falklandsk',),
'falklandske': ('falklandsk',),
'falklandsk': ('falklandsk',),
'falt': ('falle',),
'falte': ('falle',),
'fallende': ('falle',),
'falleferdig': ('falleferdig',),
'falleferdige': ('falleferdig',),
'falleferdig': ('falleferdig',),
'fallen': ('fallen',),
'falne': ('fallen',),
'fallent': ('fallen',),
'fallert': ('fallere',),
'fallerte': ('fallere',),
'fallerende': ('fallere',),
'fallesjuk': ('fallesjuk',),
'fallesjuke': ('fallesjuk',),
'fallesjukt': ('fallesjuk',),
'fallesyk': ('fallesyk',),
'fallesyke': ('fallesyk',),
'fallesykt': ('fallesyk',),
'fallisk': ('fallisk',),
'falliske': ('fallisk',),
'fallisk': ('fallisk',),
'fallitt': ('fallitt',),
'fallitte': ('fallitt',),
'fallitt': ('fallitt',),
'falma': ('falme',),
'falmet': ('falme',),
'falma': ('falme',),
'falmet': ('falme',),
'falma': ('falme',),
'falmete': ('falme',),
'falmede': ('falme',),
'falma': ('falme',),
'falmete': ('falme',),
'falmede': ('falme',),
'falmende': ('falme',),
'falsa': ('false',),
'falset': ('false',),
'falsa': ('false',),
'falset': ('false',),
'falsa': ('false',),
'falsete': ('false',),
'falsede': ('false',),
'falsa': ('false',),
'falsete': ('false',),
'falsede': ('false',),
'falsende': ('false',),
'falsifiserbar': ('falsifiserbar',),
'falsifiserbare': ('falsifiserbar',),
'falsifiserbart': ('falsifiserbar',),
'falsifisert': ('falsifisere',),
'falsifiserte': ('falsifisere',),
'falsifiserende': ('falsifisere',),
'falsk': ('falsk',),
'falske': ('falsk',),
'falskt': ('falsk',),
'falskere': ('falsk',),
'falskest': ('falsk',),
'falskeste': ('falsk',),
'familievennlig': ('familievennlig',),
'familievennlige': ('familievennlig',),
'familievennlig': ('familievennlig',),
'familiær': ('familiær',),
'familiære': ('familiær',),
'familiært': ('familiær',),
'famla': ('famle',),
'famlet': ('famle',),
'famla': ('famle',),
'famlet': ('famle',),
'famla': ('famle',),
'famlete': ('famle',),
'famlede': ('famle',),
'famlete': ('famle',),
'famlede': ('famle',),
'famla': ('famle',),
'famlete': ('famle',),
'famlede': ('famle',),
'famlete': ('famle',),
'famlede': ('famle',),
'famlende': ('famle',),
'famlende': ('famlende',),
'famøs': ('famøs',),
'famøse': ('famøs',),
'famøst': ('famøs',),
'fanatisk': ('fanatisk',),
'fanatiske': ('fanatisk',),
'fanatisk': ('fanatisk',),
'fancy': ('fancy',),
'fandenivoldsk': ('fandenivoldsk',),
'fandenivoldske': ('fandenivoldsk',),
'fandenivoldsk': ('fandenivoldsk',),
'fandens': ('fandens',),
'fanga': ('fange',),
'fanget': ('fange',),
'fanga': ('fange',),
'fanget': ('fange',),
'fanga': ('fange',),
'fangete': ('fange',),
'fangede': ('fange',),
'fanga': ('fange',),
'fangete': ('fange',),
'fangede': ('fange',),
'fangende': ('fange',),
'fangen': ('fangen',),
'fangne': ('fangen',),
'fangent': ('fangen',),
'fangsta': ('fangste',),
'fangstet': ('fangste',),
'fangsta': ('fangste',),
'fangstet': ('fangste',),
'fangsta': ('fangste',),
'fangstete': ('fangste',),
'fangstede': ('fangste',),
'fangsta': ('fangste',),
'fangstete': ('fangste',),
'fangstede': ('fangste',),
'fangstende': ('fangste',),
'fans': ('fans',),
'fantasert': ('fantasere',),
'fantaserte': ('fantasere',),
'fantaserende': ('fantasere',),
'fantasifull': ('fantasifull',),
'fantasifulle': ('fantasifull',),
'fantasifullt': ('fantasifull',),
'fantasilaus': ('fantasilaus',),
'fantasilause': ('fantasilaus',),
'fantasilaust': ('fantasilaus',),
'fantasiløs': ('fantasiløs',),
'fantasiløse': ('fantasiløs',),
'fantasiløst': ('fantasiløs',),
'fantasirik': ('fantasirik',),
'fantasirike': ('fantasirik',),
'fantasirikt': ('fantasirik',),
'fantastisk': ('fantastisk',),
'fantastiske': ('fantastisk',),
'fantastisk': ('fantastisk',),
'fantegått': ('fantegå',),
'fantegåtte': ('fantegå',),
'fantegående': ('fantegå',),
'faraoisk': ('faraoisk',),
'faraoiske': ('faraoisk',),
'faraoisk': ('faraoisk',),
'farbar': ('farbar',),
'farbare': ('farbar',),
'farbart': ('farbar',),
'fart': ('fare',),
'farte': ('fare',),
'farende': ('fare',),
'farefri': ('farefri',),
'farefrie': ('farefri',),
'farefritt': ('farefri',),
'farefull': ('farefull',),
'farefulle': ('farefull',),
'farefullt': ('farefull',),
'faren': ('faren',),
'farne': ('faren',),
'farent': ('faren',),
'faretruende': ('faretruende',),
'farga': ('farga',),
'farga': ('farge',),
'farget': ('farge',),
'farga': ('farge',),
'farget': ('farge',),
'farga': ('farge',),
'fargete': ('farge',),
'fargede': ('farge',),
'farga': ('farge',),
'fargete': ('farge',),
'fargede': ('farge',),
'fargende': ('farge',),
'fargeblind': ('fargeblind',),
'fargeblinde': ('fargeblind',),
'fargeblindt': ('fargeblind',),
'fargeekte': ('fargeekte',),
'fargelaus': ('fargelaus',),
'fargelause': ('fargelaus',),
'fargelaust': ('fargelaus',),
'fargeløs': ('fargeløs',),
'fargeløse': ('fargeløs',),
'fargeløst': ('fargeløs',),
'fargerik': ('fargerik',),
'fargerike': ('fargerik',),
'fargerikt': ('fargerik',),
'fargerikere': ('fargerik',),
'fargerikest': ('fargerik',),
'fargerikeste': ('fargerik',),
'farget': ('farget',),
'fargete': ('farget',),
'fargede': ('farget',),
'fargete': ('farget',),
'fargede': ('farget',),
'farget': ('farget',),
'fariseisk': ('fariseisk',),
'fariseiske': ('fariseisk',),
'fariseisk': ('fariseisk',),
'farlaus': ('farlaus',),
'farlause': ('farlaus',),
'farlaust': ('farlaus',),
'farlig': ('farlig',),
'farlige': ('farlig',),
'farlig': ('farlig',),
'farligere': ('farlig',),
'farligst': ('farlig',),
'farligste': ('farlig',),
'farløs': ('farløs',),
'farløse': ('farløs',),
'farløst': ('farløs',),
'farmakologisk': ('farmakologisk',),
'farmakologiske': ('farmakologisk',),
'farmakologisk': ('farmakologisk',),
'farmasøytisk': ('farmasøytisk',),
'farmasøytiske': ('farmasøytisk',),
'farmasøytisk': ('farmasøytisk',),
'farsert': ('farsere',),
'farserte': ('farsere',),
'farserende': ('farsere',),
'farta': ('farte',),
'fartet': ('farte',),
'farta': ('farte',),
'fartet': ('farte',),
'farta': ('farte',),
'fartete': ('farte',),
'fartede': ('farte',),
'farta': ('farte',),
'fartete': ('farte',),
'fartede': ('farte',),
'fartende': ('farte',),
'fartsgal': ('fartsgal',),
'fartsgale': ('fartsgal',),
'fartsgalt': ('fartsgal',),
'fasadefri': ('fasadefri',),
'fasadefrie': ('fasadefri',),
'fasadefritt': ('fasadefri',),
'fascinert': ('fascinere',),
'fascinerte': ('fascinere',),
'fascinerende': ('fascinere',),
'fascistisk': ('fascistisk',),
'fascistiske': ('fascistisk',),
'fascistisk': ('fascistisk',),
'fasa': ('fase',),
'faset': ('fase',),
'fasa': ('fase',),
'faset': ('fase',),
'fasa': ('fase',),
'fasete': ('fase',),
'fasede': ('fase',),
'fasa': ('fase',),
'fasete': ('fase',),
'fasede': ('fase',),
'fasende': ('fase',),
'fasettert': ('fasettere',),
'fasetterte': ('fasettere',),
'fasetterende': ('fasettere',),
'fasjonabel': ('fasjonabel',),
'fasjonable': ('fasjonabel',),
'fasjonabelt': ('fasjonabel',),
'fasla': ('fasle',),
'faslet': ('fasle',),
'fasla': ('fasle',),
'faslet': ('fasle',),
'fasla': ('fasle',),
'faslete': ('fasle',),
'faslede': ('fasle',),
'faslete': ('fasle',),
'faslede': ('fasle',),
'fasla': ('fasle',),
'faslete': ('fasle',),
'faslede': ('fasle',),
'faslete': ('fasle',),
'faslede': ('fasle',),
'faslende': ('fasle',),
'fasongert': ('fasongere',),
'fasongerte': ('fasongere',),
'fasongerende': ('fasongere',),
'fasongsydd': ('fasongsydd',),
'fasongsydde': ('fasongsydd',),
'fasongsydd': ('fasongsydd',),
'fast': ('fast',),
'faste': ('fast',),
'fast': ('fast',),
'fastere': ('fast',),
'fastest': ('fast',),
'fasteste': ('fast',),
'fastboende': ('fastboende',),
'fastbuende': ('fastbuende',),
'fasta': ('faste',),
'fastet': ('faste',),
'fasta': ('faste',),
'fastet': ('faste',),
'fasta': ('faste',),
'fastete': ('faste',),
'fastede': ('faste',),
'fasta': ('faste',),
'fastete': ('faste',),
'fastede': ('faste',),
'fastende': ('faste',),
'fastfrossen': ('fastfrossen',),
'fastfrosne': ('fastfrossen',),
'fastfrosset': ('fastfrossen',),
'fastfrosset': ('fastfrosset',),
'fastfrosne': ('fastfrosset',),
'fastfrosset': ('fastfrosset',),
'fastgrodd': ('fastgrodd',),
'fastgrodde': ('fastgrodd',),
'fastgrodd': ('fastgrodd',),
'fastholdt': ('fastholde',),
'fastholdte': ('fastholde',),
'fastholdende': ('fastholde',),
'fastklemt': ('fastklemt',),
'fastklemte': ('fastklemt',),
'fastklemt': ('fastklemt',),
'fastlagt': ('fastlegge',),
'fastlagte': ('fastlegge',),
'fastleggende': ('fastlegge',),
'fastlåst': ('fastlåse',),
'fastlåste': ('fastlåse',),
'fastlåsende': ('fastlåse',),
'fastlønna': ('fastlønna',),
'fastlønnet': ('fastlønnet',),
'fastlønnete': ('fastlønnet',),
'fastlønnede': ('fastlønnet',),
'fastlønnete': ('fastlønnet',),
'fastlønnede': ('fastlønnet',),
'fastlønnet': ('fastlønnet',),
'fastlønt': ('fastlønt',),
'fastlønte': ('fastlønt',),
'fastlønt': ('fastlønt',),
'fastnagla': ('fastnagla',),
'fastnaglet': ('fastnaglet',),
'fastnaglete': ('fastnaglet',),
'fastnaglede': ('fastnaglet',),
'fastnaglete': ('fastnaglet',),
'fastnaglede': ('fastnaglet',),
'fastnaglet': ('fastnaglet',),
'fastna': ('fastne',),
'fastnet': ('fastne',),
'fastna': ('fastne',),
'fastnet': ('fastne',),
'fastna': ('fastne',),
'fastnete': ('fastne',),
'fastnede': ('fastne',),
'fastnete': ('fastne',),
'fastnede': ('fastne',),
'fastna': ('fastne',),
'fastnete': ('fastne',),
'fastnede': ('fastne',),
'fastnete': ('fastne',),
'fastnede': ('fastne',),
'fastnende': ('fastne',),
'fastrusta': ('fastrusta',),
'fastrustet': ('fastrustet',),
'fastrustete': ('fastrustet',),
'fastrustede': ('fastrustet',),
'fastrustete': ('fastrustet',),
'fastrustede': ('fastrustet',),
'fastrustet': ('fastrustet',),
'fastsatt': ('fastsette',),
'fastsatte': ('fastsette',),
'fastsettende': ('fastsette',),
'fasttømra': ('fasttømra',),
'fasttømret': ('fasttømret',),
'fasttømrete': ('fasttømret',),
'fasttømrede': ('fasttømret',),
'fasttømrete': ('fasttømret',),
'fasttømrede': ('fasttømret',),
'fasttømret': ('fasttømret',),
'fatal': ('fatal',),
'fatale': ('fatal',),
'fatalt': ('fatal',),
'fatalistisk': ('fatalistisk',),
'fatalistiske': ('fatalistisk',),
'fatalistisk': ('fatalistisk',),
'fata': ('fate',),
'fatet': ('fate',),
'fata': ('fate',),
'fatet': ('fate',),
'fata': ('fate',),
'fatete': ('fate',),
'fatede': ('fate',),
'fata': ('fate',),
'fatete': ('fate',),
'fatede': ('fate',),
'fatende': ('fate',),
'fatla': ('fatle',),
'fatlet': ('fatle',),
'fatla': ('fatle',),
'fatlet': ('fatle',),
'fatla': ('fatle',),
'fatlete': ('fatle',),
'fatlede': ('fatle',),
'fatlete': ('fatle',),
'fatlede': ('fatle',),
'fatla': ('fatle',),
'fatlete': ('fatle',),
'fatlede': ('fatle',),
'fatlete': ('fatle',),
'fatlede': ('fatle',),
'fatlende': ('fatle',),
'fatta': ('fatta',),
'fattbar': ('fattbar',),
'fattbare': ('fattbar',),
'fattbart': ('fattbar',),
'fatta': ('fatte',),
'fattet': ('fatte',),
'fatta': ('fatte',),
'fattet': ('fatte',),
'fatta': ('fatte',),
'fattete': ('fatte',),
'fattede': ('fatte',),
'fatta': ('fatte',),
'fattete': ('fatte',),
'fattede': ('fatte',),
'fattende': ('fatte',),
'fattelig': ('fattelig',),
'fattelige': ('fattelig',),
'fattelig': ('fattelig',),
'fattet': ('fattet',),
'fattete': ('fattet',),
'fattede': ('fattet',),
'fattete': ('fattet',),
'fattede': ('fattet',),
'fattet': ('fattet',),
'fattig': ('fattig',),
'fattige': ('fattig',),
'fattig': ('fattig',),
'fattigere': ('fattig',),
'fattigst': ('fattig',),
'fattigste': ('fattig',),
'fattigfornem': ('fattigfornem',),
'fattigfornemme': ('fattigfornem',),
'fattigfornemt': ('fattigfornem',),
'fattigslig': ('fattigslig',),
'fattigslige': ('fattigslig',),
'fattigslig': ('fattigslig',),
'favna': ('favne',),
'favnet': ('favne',),
'favna': ('favne',),
'favnet': ('favne',),
'favna': ('favne',),
'favnete': ('favne',),
'favnede': ('favne',),
'favna': ('favne',),
'favnete': ('favne',),
'favnede': ('favne',),
'favnende': ('favne',),
'favorisert': ('favorisere',),
'favoriserte': ('favorisere',),
'favoriserende': ('favorisere',),
'feberdrivende': ('feberdrivende',),
'feberhet': ('feberhet',),
'feberhete': ('feberhet',),
'feberhett': ('feberhet',),
'feberstillende': ('feberstillende',),
'febril': ('febril',),
'febrile': ('febril',),
'febrilt': ('febril',),
'febrilsk': ('febrilsk',),
'febrilske': ('febrilsk',),
'febrilsk': ('febrilsk',),
'fedrene': ('fedrene',),
'feida': ('feide',),
'feidet': ('feide',),
'feida': ('feide',),
'feidet': ('feide',),
'feida': ('feide',),
'feidete': ('feide',),
'feidede': ('feide',),
'feida': ('feide',),
'feidete': ('feide',),
'feidede': ('feide',),
'feidende': ('feide',),
'feia': ('feie',),
'feiet': ('feie',),
'feid': ('feie',),
'feia': ('feie',),
'feiet': ('feie',),
'feid': ('feie',),
'feia': ('feie',),
'feiete': ('feie',),
'feiede': ('feie',),
'feide': ('feie',),
'feia': ('feie',),
'feiete': ('feie',),
'feiede': ('feie',),
'feide': ('feie',),
'feiende': ('feie',),
'feiende': ('feiende',),
'feig': ('feig',),
'feige': ('feig',),
'feigt': ('feig',),
'feigere': ('feig',),
'feigest': ('feig',),
'feigeste': ('feig',),
'feilaktig': ('feilaktig',),
'feilaktige': ('feilaktig',),
'feilaktig': ('feilaktig',),
'feilbedømt': ('feilbedømme',),
'feilbedømte': ('feilbedømme',),
'feilbedømmende': ('feilbedømme',),
'feila': ('feile',),
'feilet': ('feile',),
'feilt': ('feile',),
'feila': ('feile',),
'feilet': ('feile',),
'feilt': ('feile',),
'feila': ('feile',),
'feilete': ('feile',),
'feilede': ('feile',),
'feilte': ('feile',),
'feila': ('feile',),
'feilete': ('feile',),
'feilede': ('feile',),
'feilte': ('feile',),
'feilende': ('feile',),
'feilslått': ('feilslått',),
'feilslåtte': ('feilslått',),
'feilslått': ('feilslått',),
'feilvurdert': ('feilvurdere',),
'feilvurderte': ('feilvurdere',),
'feilvurderende': ('feilvurdere',),
'feira': ('feire',),
'feiret': ('feire',),
'feira': ('feire',),
'feiret': ('feire',),
'feira': ('feire',),
'feirete': ('feire',),
'feirede': ('feire',),
'feira': ('feire',),
'feirete': ('feire',),
'feirede': ('feire',),
'feirende': ('feire',),
'feit': ('feit',),
'feite': ('feit',),
'feitt': ('feit',),
'fett': ('feit',),
'feitere': ('feit',),
'feitest': ('feit',),
'feiteste': ('feit',),
'feita': ('feite',),
'feitet': ('feite',),
'feita': ('feite',),
'feitet': ('feite',),
'feita': ('feite',),
'feitete': ('feite',),
'feitede': ('feite',),
'feita': ('feite',),
'feitete': ('feite',),
'feitede': ('feite',),
'feitende': ('feite',),
'feitladen': ('feitladen',),
'feitladne': ('feitladen',),
'feitladent': ('feitladen',),
'feitlaten': ('feitlaten',),
'feitlatne': ('feitlaten',),
'feitlatent': ('feitlaten',),
'feitna': ('feitne',),
'feitnet': ('feitne',),
'feitna': ('feitne',),
'feitnet': ('feitne',),
'feitna': ('feitne',),
'feitnete': ('feitne',),
'feitnede': ('feitne',),
'feitnete': ('feitne',),
'feitnede': ('feitne',),
'feitna': ('feitne',),
'feitnete': ('feitne',),
'feitnede': ('feitne',),
'feitnete': ('feitne',),
'feitnede': ('feitne',),
'feitnende': ('feitne',),
'fekta': ('fekte',),
'fektet': ('fekte',),
'fekta': ('fekte',),
'fektet': ('fekte',),
'fekta': ('fekte',),
'fektete': ('fekte',),
'fektede': ('fekte',),
'fekta': ('fekte',),
'fektete': ('fekte',),
'fektede': ('fekte',),
'fektende': ('fekte',),
'felt': ('felle',),
'felte': ('felle',),
'fellende': ('felle',),
'fellende': ('fellende',),
'felles': ('felles',),
'felleskirkelig': ('felleskirkelig',),
'felleskirkelige': ('felleskirkelig',),
'felleskirkelig': ('felleskirkelig',),
'femblada': ('femblada',),
'fembladet': ('fembladet',),
'fembladete': ('fembladet',),
'fembladede': ('fembladet',),
'fembladete': ('fembladet',),
'fembladede': ('fembladet',),
'fembladet': ('fembladet',),
'femdobbel': ('femdobbel',),
'femdoble': ('femdobbel',),
'femdobbelt': ('femdobbel',),
'femdobbelt': ('femdobbelt',),
'femdobbelte': ('femdobbelt',),
'femdobbelt': ('femdobbelt',),
'femdobla': ('femdoble',),
'femdoblet': ('femdoble',),
'femdobla': ('femdoble',),
'femdoblet': ('femdoble',),
'femdobla': ('femdoble',),
'femdoblete': ('femdoble',),
'femdoblede': ('femdoble',),
'femdoblete': ('femdoble',),
'femdoblede': ('femdoble',),
'femdobla': ('femdoble',),
'femdoblete': ('femdoble',),
'femdoblede': ('femdoble',),
'femdoblete': ('femdoble',),
'femdoblede': ('femdoble',),
'femdoblende': ('femdoble',),
'femetasjes': ('femetasjes',),
'femfota': ('femfota',),
'femfotet': ('femfotet',),
'femfotete': ('femfotet',),
'femfotede': ('femfotet',),
'femfotete': ('femfotet',),
'femfotede': ('femfotet',),
'femfotet': ('femfotet',),
'femføtt': ('femføtt',),
'femføtte': ('femføtt',),
'femføtt': ('femføtt',),
'feminin': ('feminin',),
'feminine': ('feminin',),
'feminint': ('feminin',),
'feminisert': ('feminisere',),
'feminiserte': ('feminisere',),
'feminiserende': ('feminisere',),
'femkanta': ('femkanta',),
'femkantet': ('femkantet',),
'femkantete': ('femkantet',),
'femkantede': ('femkantet',),
'femkantete': ('femkantet',),
'femkantede': ('femkantet',),
'femkantet': ('femkantet',),
'femmasta': ('femmasta',),
'femmastet': ('femmastet',),
'femmastete': ('femmastet',),
'femmastede': ('femmastet',),
'femmastete': ('femmastet',),
'femmastede': ('femmastet',),
'femmastet': ('femmastet',),
'femroms': ('femroms',),
'femsida': ('femsida',),
'femsidet': ('femsidet',),
'femsidete': ('femsidet',),
'femsidede': ('femsidet',),
'femsidete': ('femsidet',),
'femsidede': ('femsidet',),
'femsidet': ('femsidet',),
'femte': ('femte',),
'femtende': ('femtende',),
'femtenårig': ('femtenårig',),
'femtenårige': ('femtenårig',),
'femtenårig': ('femtenårig',),
'femtenårs': ('femtenårs',),
'femtiende': ('femtiende',),
'femtiårig': ('femtiårig',),
'femtiårige': ('femtiårig',),
'femtiårig': ('femtiårig',),
'femtiøres': ('femtiøres',),
'femtoms': ('femtoms',),
'femårig': ('femårig',),
'femårige': ('femårig',),
'femårig': ('femårig',),
'femårs': ('femårs',),
'femøres': ('femøres',),
'fenga': ('fenge',),
'fenget': ('fenge',),
'fengt': ('fenge',),
'fenga': ('fenge',),
'fenget': ('fenge',),
'fengt': ('fenge',),
'fenga': ('fenge',),
'fengete': ('fenge',),
'fengede': ('fenge',),
'fengte': ('fenge',),
'fenga': ('fenge',),
'fengete': ('fenge',),
'fengede': ('fenge',),
'fengte': ('fenge',),
'fengende': ('fenge',),
'fengende': ('fengende',),
'fengsla': ('fengsle',),
'fengslet': ('fengsle',),
'fengsla': ('fengsle',),
'fengslet': ('fengsle',),
'fengsla': ('fengsle',),
'fengslete': ('fengsle',),
'fengslede': ('fengsle',),
'fengslete': ('fengsle',),
'fengslede': ('fengsle',),
'fengsla': ('fengsle',),
'fengslete': ('fengsle',),
'fengslede': ('fengsle',),
'fengslete': ('fengsle',),
'fengslede': ('fengsle',),
'fengslende': ('fengsle',),
'fengslig': ('fengslig',),
'fengslige': ('fengslig',),
'fengslig': ('fengslig',),
'fennoskandisk': ('fennoskandisk',),
'fennoskandiske': ('fennoskandisk',),
'fennoskandisk': ('fennoskandisk',),
'fenologisk': ('fenologisk',),
'fenologiske': ('fenologisk',),
'fenologisk': ('fenologisk',),
'fenomenal': ('fenomenal',),
'fenomenale': ('fenomenal',),
'fenomenalt': ('fenomenal',),
'fenomenologisk': ('fenomenologisk',),
'fenomenologiske': ('fenomenologisk',),
'fenomenologisk': ('fenomenologisk',),
'ferda': ('ferde',),
'ferdet': ('ferde',),
'ferda': ('ferde',),
'ferdet': ('ferde',),
'ferda': ('ferde',),
'ferdete': ('ferde',),
'ferdede': ('ferde',),
'ferda': ('ferde',),
'ferdete': ('ferde',),
'ferdede': ('ferde',),
'ferdende': ('ferde',),
'ferdig': ('ferdig',),
'ferdige': ('ferdig',),
'ferdig': ('ferdig',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlete': ('ferdigbehandle',),
'ferdigbehandlede': ('ferdigbehandle',),
'ferdigbehandlete': ('ferdigbehandle',),
'ferdigbehandlede': ('ferdigbehandle',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlete': ('ferdigbehandle',),
'ferdigbehandlede': ('ferdigbehandle',),
'ferdigbehandlete': ('ferdigbehandle',),
'ferdigbehandlede': ('ferdigbehandle',),
'ferdigbehandlende': ('ferdigbehandle',),
'ferdiglaga': ('ferdiglaga',),
'ferdiglagd': ('ferdiglagd',),
'ferdiglagde': ('ferdiglagd',),
'ferdiglagd': ('ferdiglagd',),
'ferdiglaget': ('ferdiglaget',),
'ferdiglagete': ('ferdiglaget',),
'ferdiglagede': ('ferdiglaget',),
'ferdiglagete': ('ferdiglaget',),
'ferdiglagede': ('ferdiglaget',),
'ferdiglaget': ('ferdiglaget',),
'ferdigpakka': ('ferdigpakka',),
'ferdigpakket': ('ferdigpakket',),
'ferdigpakkete': ('ferdigpakket',),
'ferdigpakkede': ('ferdigpakket',),
'ferdigpakkete': ('ferdigpakket',),
'ferdigpakkede': ('ferdigpakket',),
'ferdigpakket': ('ferdigpakket',),
'ferga': ('ferge',),
'ferget': ('ferge',),
'ferga': ('ferge',),
'ferget': ('ferge',),
'ferga': ('ferge',),
'fergete': ('ferge',),
'fergede': ('ferge',),
'ferga': ('ferge',),
'fergete': ('ferge',),
'fergede': ('ferge',),
'fergende': ('ferge',),
'feriert': ('feriere',),
'ferierte': ('feriere',),
'ferierende': ('feriere',),
'ferja': ('ferje',),
'ferjet': ('ferje',),
'ferja': ('ferje',),
'ferjet': ('ferje',),
'ferja': ('ferje',),
'ferjete': ('ferje',),
'ferjede': ('ferje',),
'ferja': ('ferje',),
'ferjete': ('ferje',),
'ferjede': ('ferje',),
'ferjende': ('ferje',),
'ferm': ('ferm',),
'ferme': ('ferm',),
'fermt': ('ferm',),
'fermere': ('ferm',),
'fermest': ('ferm',),
'fermeste': ('ferm',),
'ferma': ('ferme',),
'fermet': ('ferme',),
'ferma': ('ferme',),
'fermet': ('ferme',),
'ferma': ('ferme',),
'fermete': ('ferme',),
'fermede': ('ferme',),
'ferma': ('ferme',),
'fermete': ('ferme',),
'fermede': ('ferme',),
'fermende': ('ferme',),
'fermentert': ('fermentere',),
'fermenterte': ('fermentere',),
'fermenterende': ('fermentere',),
'fernissert': ('fernissere',),
'fernisserte': ('fernissere',),
'fernisserende': ('fernissere',),
'fersk': ('fersk',),
'ferske': ('fersk',),
'ferskt': ('fersk',),
'ferskere': ('fersk',),
'ferskest': ('fersk',),
'ferskeste': ('fersk',),
'ferska': ('ferske',),
'fersket': ('ferske',),
'ferska': ('ferske',),
'fersket': ('ferske',),
'ferska': ('ferske',),
'ferskete': ('ferske',),
'ferskede': ('ferske',),
'ferska': ('ferske',),
'ferskete': ('ferske',),
'ferskede': ('ferske',),
'ferskende': ('ferske',),
'ferskenfarget': ('ferskenfarget',),
'ferskenfargete': ('ferskenfarget',),
'ferskenfargede': ('ferskenfarget',),
'ferskenfargete': ('ferskenfarget',),
'ferskenfargede': ('ferskenfarget',),
'ferskenfarget': ('ferskenfarget',),
'fertil': ('fertil',),
'fertile': ('fertil',),
'fertilt': ('fertil',),
'festa': ('feste',),
'festet': ('feste',),
'festa': ('feste',),
'festet': ('feste',),
'festa': ('feste',),
'festete': ('feste',),
'festede': ('feste',),
'festa': ('feste',),
'festete': ('feste',),
'festede': ('feste',),
'festende': ('feste',),
'festlig': ('festlig',),
'festlige': ('festlig',),
'festlig': ('festlig',),
'festligere': ('festlig',),
'festligst': ('festlig',),
'festligste': ('festlig',),
'festna': ('festne',),
'festnet': ('festne',),
'festna': ('festne',),
'festnet': ('festne',),
'festna': ('festne',),
'festnete': ('festne',),
'festnede': ('festne',),
'festnete': ('festne',),
'festnede': ('festne',),
'festna': ('festne',),
'festnete': ('festne',),
'festnede': ('festne',),
'festnete': ('festne',),
'festnede': ('festne',),
'festnende': ('festne',),
'feststemt': ('feststemt',),
'feststemte': ('feststemt',),
'feststemt': ('feststemt',),
'fet': ('fet',),
'fete': ('fet',),
'fett': ('fet',),
'fetere': ('fet',),
'fetest': ('fet',),
'feteste': ('fet',),
'feta': ('fete',),
'fetet': ('fete',),
'feta': ('fete',),
'fetet': ('fete',),
'feta': ('fete',),
'fetete': ('fete',),
'fetede': ('fete',),
'feta': ('fete',),
'fetete': ('fete',),
'fetede': ('fete',),
'fetende': ('fete',),
'fetert': ('fetere',),
'feterte': ('fetere',),
'feterende': ('fetere',),
'fetlaten': ('fetlaten',),
'fetlatne': ('fetlaten',),
'fetlatent': ('fetlaten',),
'fetna': ('fetne',),
'fetnet': ('fetne',),
'fetna': ('fetne',),
'fetnet': ('fetne',),
'fetna': ('fetne',),
'fetnete': ('fetne',),
'fetnede': ('fetne',),
'fetnete': ('fetne',),
'fetnede': ('fetne',),
'fetna': ('fetne',),
'fetnete': ('fetne',),
'fetnede': ('fetne',),
'fetnete': ('fetne',),
'fetnede': ('fetne',),
'fetnende': ('fetne',),
'fettet': ('fettet',),
'fettete': ('fettet',),
'fettet': ('fettet',),
'fettete': ('fettete',),
'fettglinsende': ('fettglinsende',),
'fiberrik': ('fiberrik',),
'fiberrike': ('fiberrik',),
'fiberrikt': ('fiberrik',),
'fibrøs': ('fibrøs',),
'fibrøse': ('fibrøs',),
'fibrøst': ('fibrøs',),
'fiendsk': ('fiendsk',),
'fiendske': ('fiendsk',),
'fiendsk': ('fiendsk',),
'fiendtlig': ('fiendtlig',),
'fiendtlige': ('fiendtlig',),
'fiendtlig': ('fiendtlig',),
'fiendtligere': ('fiendtlig',),
'fiendtligst': ('fiendtlig',),
'fiendtligste': ('fiendtlig',),
'fiendtligsinna': ('fiendtligsinna',),
'fiendtligsinnet': ('fiendtligsinnet',),
'fiendtligsinnete': ('fiendtligsinnet',),
'fiendtligsinnede': ('fiendtligsinnet',),
'fiendtligsinnete': ('fiendtligsinnet',),
'fiendtligsinnede': ('fiendtligsinnet',),
'fiendtligsinnet': ('fiendtligsinnet',),
'fiffa': ('fiffe',),
'fiffet': ('fiffe',),
'fiffa': ('fiffe',),
'fiffet': ('fiffe',),
'fiffa': ('fiffe',),
'fiffete': ('fiffe',),
'fiffede': ('fiffe',),
'fiffa': ('fiffe',),
'fiffete': ('fiffe',),
'fiffede': ('fiffe',),
'fiffende': ('fiffe',),
'fiffig': ('fiffig',),
'fiffige': ('fiffig',),
'fiffig': ('fiffig',),
'fighta': ('fighte',),
'fightet': ('fighte',),
'fighta': ('fighte',),
'fightet': ('fighte',),
'fighta': ('fighte',),
'fightete': ('fighte',),
'fightede': ('fighte',),
'fighta': ('fighte',),
'fightete': ('fighte',),
'fightede': ('fighte',),
'fightende': ('fighte',),
'figurativ': ('figurativ',),
'figurative': ('figurativ',),
'figurativt': ('figurativ',),
'figurert': ('figurere',),
'figurerte': ('figurere',),
'figurerende': ('figurere',),
'figurlig': ('figurlig',),
'figurlige': ('figurlig',),
'figurlig': ('figurlig',),
'fijiansk': ('fijiansk',),
'fijianske': ('fijiansk',),
'fijiansk': ('fijiansk',),
'fika': ('fike',),
'fiket': ('fike',),
'fikt': ('fike',),
'fika': ('fike',),
'fiket': ('fike',),
'fikt': ('fike',),
'fika': ('fike',),
'fikete': ('fike',),
'fikede': ('fike',),
'fikte': ('fike',),
'fika': ('fike',),
'fikete': ('fike',),
'fikede': ('fike',),
'fikte': ('fike',),
'fikende': ('fike',),
'fiken': ('fiken',),
'fikne': ('fiken',),
'fikent': ('fiken',),
'fikla': ('fikle',),
'fiklet': ('fikle',),
'fikla': ('fikle',),
'fiklet': ('fikle',),
'fikla': ('fikle',),
'fiklete': ('fikle',),
'fiklede': ('fikle',),
'fiklete': ('fikle',),
'fiklede': ('fikle',),
'fikla': ('fikle',),
'fiklete': ('fikle',),
'fiklede': ('fikle',),
'fiklete': ('fikle',),
'fiklede': ('fikle',),
'fiklende': ('fikle',),
'fiks': ('fiks',),
'fikse': ('fiks',),
'fikst': ('fiks',),
'fiksa': ('fikse',),
'fikset': ('fikse',),
'fiksa': ('fikse',),
'fikset': ('fikse',),
'fiksa': ('fikse',),
'fiksete': ('fikse',),
'fiksede': ('fikse',),
'fiksa': ('fikse',),
'fiksete': ('fikse',),
'fiksede': ('fikse',),
'fiksende': ('fikse',),
'fiksert': ('fiksere',),
'fikserte': ('fiksere',),
'fikserende': ('fiksere',),
'fiktiv': ('fiktiv',),
'fiktive': ('fiktiv',),
'fiktivt': ('fiktiv',),
'filantropisk': ('filantropisk',),
'filantropiske': ('filantropisk',),
'filantropisk': ('filantropisk',),
'filatelistisk': ('filatelistisk',),
'filatelistiske': ('filatelistisk',),
'filatelistisk': ('filatelistisk',),
'fila': ('file',),
'filet': ('file',),
'filt': ('file',),
'fila': ('file',),
'filet': ('file',),
'filt': ('file',),
'fila': ('file',),
'filete': ('file',),
'filede': ('file',),
'filte': ('file',),
'fila': ('file',),
'filete': ('file',),
'filede': ('file',),
'filte': ('file',),
'filende': ('file',),
'filert': ('filere',),
'filerte': ('filere',),
'filerende': ('filere',),
'filetert': ('filetere',),
'fileterte': ('filetere',),
'fileterende': ('filetere',),
'filharmonisk': ('filharmonisk',),
'filharmoniske': ('filharmonisk',),
'filharmonisk': ('filharmonisk',),
'filippinsk': ('filippinsk',),
'filippinske': ('filippinsk',),
'filippinsk': ('filippinsk',),
'filistrøs': ('filistrøs',),
'filistrøse': ('filistrøs',),
'filistrøst': ('filistrøs',),
'fille': ('fille',),
'fillet': ('fillet',),
'fillete': ('fillet',),
'fillet': ('fillet',),
'fillete': ('fillete',),
'filmatisert': ('filmatisere',),
'filmatiserte': ('filmatisere',),
'filmatiserende': ('filmatisere',),
'filmatisk': ('filmatisk',),
'filmatiske': ('filmatisk',),
'filmatisk': ('filmatisk',),
'filma': ('filme',),
'filmet': ('filme',),
'filma': ('filme',),
'filmet': ('filme',),
'filma': ('filme',),
'filmete': ('filme',),
'filmede': ('filme',),
'filma': ('filme',),
'filmete': ('filme',),
'filmede': ('filme',),
'filmende': ('filme',),
'filologisk': ('filologisk',),
'filologiske': ('filologisk',),
'filologisk': ('filologisk',),
'filosofert': ('filosofere',),
'filosoferte': ('filosofere',),
'filosoferende': ('filosofere',),
'filosofisk': ('filosofisk',),
'filosofiske': ('filosofisk',),
'filosofisk': ('filosofisk',),
'filthåra': ('filthåra',),
'filthåret': ('filthåret',),
'filthårete': ('filthåret',),
'filthårede': ('filthåret',),
'filthårete': ('filthåret',),
'filthårede': ('filthåret',),
'filthåret': ('filthåret',),
'filtra': ('filtre',),
'filtret': ('filtre',),
'filtra': ('filtre',),
'filtret': ('filtre',),
'filtra': ('filtre',),
'filtrete': ('filtre',),
'filtrede': ('filtre',),
'filtrete': ('filtre',),
'filtrede': ('filtre',),
'filtra': ('filtre',),
'filtrete': ('filtre',),
'filtrede': ('filtre',),
'filtrete': ('filtre',),
'filtrede': ('filtre',),
'filtrende': ('filtre',),
'filtrert': ('filtrere',),
'filtrerte': ('filtrere',),
'filtrerende': ('filtrere',),
'fin': ('fin',),
'fine': ('fin',),
'fint': ('fin',),
'finere': ('fin',),
'finest': ('fin',),
'fineste': ('fin',),
'final': ('final',),
'finale': ('final',),
'finalt': ('final',),
'finansiell': ('finansiell',),
'finansielle': ('finansiell',),
'finansielt': ('finansiell',),
'finansiert': ('finansiere',),
'finansierte': ('finansiere',),
'finansierende': ('finansiere',),
'finert': ('finere',),
'finerte': ('finere',),
'finerende': ('finere',),
'finfin': ('finfin',),
'finfine': ('finfin',),
'finfint': ('finfin',),
'finfordelt': ('finfordele',),
'finfordelte': ('finfordele',),
'finfordelende': ('finfordele',),
'finfølende': ('finfølende',),
'fingert': ('fingere',),
'fingerte': ('fingere',),
'fingerende': ('fingere',),
'fingerferdig': ('fingerferdig',),
'fingerferdige': ('fingerferdig',),
'fingerferdig': ('fingerferdig',),
'fingernem': ('fingernem',),
'fingernemme': ('fingernem',),
'fingernemt': ('fingernem',),
'fingert': ('fingert',),
'fingerte': ('fingert',),
'fingert': ('fingert',),
'fingra': ('fingra',),
'fingra': ('fingre',),
'fingret': ('fingre',),
'fingra': ('fingre',),
'fingret': ('fingre',),
'fingra': ('fingre',),
'fingrete': ('fingre',),
'fingrede': ('fingre',),
'fingrete': ('fingre',),
'fingrede': ('fingre',),
'fingra': ('fingre',),
'fingrete': ('fingre',),
'fingrede': ('fingre',),
'fingrete': ('fingre',),
'fingrede': ('fingre',),
'fingrende': ('fingre',),
'fingret': ('fingret',),
'fingrete': ('fingret',),
'fingrede': ('fingret',),
'fingrete': ('fingret',),
'fingrede': ('fingret',),
'fingret': ('fingret',),
'finhakka': ('finhakke',),
'finhakket': ('finhakke',),
'finhakka': ('finhakke',),
'finhakket': ('finhakke',),
'finhakka': ('finhakke',),
'finhakkete': ('finhakke',),
'finhakkede': ('finhakke',),
'finhakka': ('finhakke',),
'finhakkete': ('finhakke',),
'finhakkede': ('finhakke',),
'finhakkende': ('finhakke',),
'finhøvla': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvlete': ('finhøvle',),
'finhøvlede': ('finhøvle',),
'finhøvlete': ('finhøvle',),
'finhøvlede': ('finhøvle',),
'finhøvla': ('finhøvle',),
'finhøvlete': ('finhøvle',),
'finhøvlede': ('finhøvle',),
'finhøvlete': ('finhøvle',),
'finhøvlede': ('finhøvle',),
'finhøvlende': ('finhøvle',),
'fininnstilt': ('fininnstille',),
'fininnstilte': ('fininnstille',),
'fininnstillende': ('fininnstille',),
'finitt': ('finitt',),
'finitte': ('finitt',),
'finitt': ('finitt',),
'finkjemma': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemt': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemt': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemmete': ('finkjemme',),
'finkjemmede': ('finkjemme',),
'finkjemte': ('finkjemme',),
'finkjemma': ('finkjemme',),
'finkjemmete': ('finkjemme',),
'finkjemmede': ('finkjemme',),
'finkjemte': ('finkjemme',),
'finkjemmende': ('finkjemme',),
'finkorna': ('finkorna',),
'finkornet': ('finkornet',),
'finkornete': ('finkornet',),
'finkornede': ('finkornet',),
'finkornete': ('finkornet',),
'finkornede': ('finkornet',),
'finkornet': ('finkornet',),
'finlandsk': ('finlandsk',),
'finlandske': ('finlandsk',),
'finlandsk': ('finlandsk',),
'finmalt': ('finmale',),
'finmalte': ('finmale',),
'finmalende': ('finmale',),
'finmaska': ('finmaska',),
'finmasket': ('finmasket',),
'finmaskete': ('finmasket',),
'finmaskede': ('finmasket',),
'finmaskete': ('finmasket',),
'finmaskede': ('finmasket',),
'finmasket': ('finmasket',),
'funnet': ('finne',),
'funnen': ('finne',),
'funne': ('finne',),
'finnende': ('finne',),
'finnet': ('finnet',),
'finnete': ('finnet',),
'finnet': ('finnet',),
'finnete': ('finnete',),
'finpussa': ('finpusse',),
'finpusset': ('finpusse',),
'finpussa': ('finpusse',),
'finpusset': ('finpusse',),
'finpussa': ('finpusse',),
'finpussete': ('finpusse',),
'finpussede': ('finpusse',),
'finpussa': ('finpusse',),
'finpussete': ('finpusse',),
'finpussede': ('finpusse',),
'finpussende': ('finpusse',),
'finsikta': ('finsikte',),
'finsiktet': ('finsikte',),
'finsikta': ('finsikte',),
'finsiktet': ('finsikte',),
'finsikta': ('finsikte',),
'finsiktete': ('finsikte',),
'finsiktede': ('finsikte',),
'finsikta': ('finsikte',),
'finsiktete': ('finsikte',),
'finsiktede': ('finsikte',),
'finsiktende': ('finsikte',),
'finsk': ('finsk',),
'finske': ('finsk',),
'finsk': ('finsk',),
'finsk-ugrisk': ('finsk-ugrisk',),
'finsk-ugriske': ('finsk-ugrisk',),
'finsk-ugrisk': ('finsk-ugrisk',),
'finskåren': ('finskåren',),
'finskårne': ('finskåren',),
'finskåret': ('finskåren',),
'finskåret': ('finskåret',),
'finskårne': ('finskåret',),
'finskåret': ('finskåret',),
'finstilt': ('finstilt',),
'finstilte': ('finstilt',),
'finstilt': ('finstilt',),
'finta': ('finte',),
'fintet': ('finte',),
'finta': ('finte',),
'fintet': ('finte',),
'finta': ('finte',),
'fintete': ('finte',),
'fintede': ('finte',),
'finta': ('finte',),
'fintete': ('finte',),
'fintede': ('finte',),
'fintende': ('finte',),
'fintellet': ('fintelle',),
'fintelt': ('fintelle',),
'fintalt': ('fintelle',),
'fintellet': ('fintelle',),
'fintelt': ('fintelle',),
'fintalt': ('fintelle',),
'fintellete': ('fintelle',),
'fintellede': ('fintelle',),
'fintelte': ('fintelle',),
'fintalte': ('fintelle',),
'fintellete': ('fintelle',),
'fintellede': ('fintelle',),
'fintelte': ('fintelle',),
'fintalte': ('fintelle',),
'fintellende': ('fintelle',),
'fintfølende': ('fintfølende',),
'finurlig': ('finurlig',),
'finurlige': ('finurlig',),
'finurlig': ('finurlig',),
'fiolblå': ('fiolblå',),
'fiolblåe': ('fiolblå',),
'fiolblå': ('fiolblå',),
'fiolblåe': ('fiolblå',),
'fiolblå': ('fiolblå',),
'fiolblått': ('fiolblå',),
'fiolett': ('fiolett',),
'fiolette': ('fiolett',),
'fiolett': ('fiolett',),
'firbeint': ('firbeint',),
'firbeinte': ('firbeint',),
'firbeint': ('firbeint',),
'firbent': ('firbent',),
'firbente': ('firbent',),
'firbent': ('firbent',),
'firblada': ('firblada',),
'firbladet': ('firbladet',),
'firbladete': ('firbladet',),
'firbladede': ('firbladet',),
'firbladete': ('firbladet',),
'firbladede': ('firbladet',),
'firbladet': ('firbladet',),
'firdelt': ('firdelt',),
'firdelte': ('firdelt',),
'firdelt': ('firdelt',),
'firdobbel': ('firdobbel',),
'firdoble': ('firdobbel',),
'firdobbelt': ('firdobbel',),
'firdobbelt': ('firdobbelt',),
'firdobbelte': ('firdobbelt',),
'firdobbelt': ('firdobbelt',),
'firdobla': ('firdoble',),
'firdoblet': ('firdoble',),
'firdobla': ('firdoble',),
'firdoblet': ('firdoble',),
'firdobla': ('firdoble',),
'firdoblete': ('firdoble',),
'firdoblede': ('firdoble',),
'firdoblete': ('firdoble',),
'firdoblede': ('firdoble',),
'firdobla': ('firdoble',),
'firdoblete': ('firdoble',),
'firdoblede': ('firdoble',),
'firdoblete': ('firdoble',),
'firdoblede': ('firdoble',),
'firdoblende': ('firdoble',),
'fira': ('fire',),
'firet': ('fire',),
'firt': ('fire',),
'fira': ('fire',),
'firet': ('fire',),
'firt': ('fire',),
'fira': ('fire',),
'firete': ('fire',),
'firede': ('fire',),
'firte': ('fire',),
'fira': ('fire',),
'firete': ('fire',),
'firede': ('fire',),
'firte': ('fire',),
'firende': ('fire',),
'firebeint': ('firebeint',),
'firebeinte': ('firebeint',),
'firebeint': ('firebeint',),
'firebent': ('firebent',),
'firebente': ('firebent',),
'firebent': ('firebent',),
'fireblada': ('fireblada',),
'firebladet': ('firebladet',),
'firebladete': ('firebladet',),
'firebladede': ('firebladet',),
'firebladete': ('firebladet',),
'firebladede': ('firebladet',),
'firebladet': ('firebladet',),
'firedelt': ('firedelt',),
'firedelte': ('firedelt',),
'firedelt': ('firedelt',),
'firedimensjonal': ('firedimensjonal',),
'firedimensjonale': ('firedimensjonal',),
'firedimensjonalt': ('firedimensjonal',),
'firedobbel': ('firedobbel',),
'firedoble': ('firedobbel',),
'firedobbelt': ('firedobbel',),
'firedobbelt': ('firedobbelt',),
'firedobbelte': ('firedobbelt',),
'firedobbelt': ('firedobbelt',),
'firedobla': ('firedoble',),
'firedoblet': ('firedoble',),
'firedobla': ('firedoble',),
'firedoblet': ('firedoble',),
'firedobla': ('firedoble',),
'firedoblete': ('firedoble',),
'firedoblede': ('firedoble',),
'firedoblete': ('firedoble',),
'firedoblede': ('firedoble',),
'firedobla': ('firedoble',),
'firedoblete': ('firedoble',),
'firedoblede': ('firedoble',),
'firedoblete': ('firedoble',),
'firedoblede': ('firedoble',),
'firedoblende': ('firedoble',),
'fireetasjes': ('fireetasjes',),
'firefelta': ('firefelta',),
'firefeltet': ('firefeltet',),
'firefeltete': ('firefeltet',),
'firefeltede': ('firefeltet',),
'firefeltete': ('firefeltet',),
'firefeltede': ('firefeltet',),
'firefeltet': ('firefeltet',),
'firefelts': ('firefelts',),
'firefota': ('firefota',),
'firefotet': ('firefotet',),
'firefotete': ('firefotet',),
'firefotede': ('firefotet',),
'firefotete': ('firefotet',),
'firefotede': ('firefotet',),
'firefotet': ('firefotet',),
'fireføtt': ('fireføtt',),
'fireføtte': ('fireføtt',),
'fireføtt': ('fireføtt',),
'firehendig': ('firehendig',),
'firehendige': ('firehendig',),
'firehendig': ('firehendig',),
'firehjuls': ('firehjuls',),
'fireliters': ('fireliters',),
'firemasta': ('firemasta',),
'firemastet': ('firemastet',),
'firemastete': ('firemastet',),
'firemastede': ('firemastet',),
'firemastete': ('firemastet',),
'firemastede': ('firemastet',),
'firemastet': ('firemastet',),
'fireroms': ('fireroms',),
'firesifra': ('firesifra',),
'firesifret': ('firesifret',),
'firesifrete': ('firesifret',),
'firesifrede': ('firesifret',),
'firesifrete': ('firesifret',),
'firesifrede': ('firesifret',),
'firesifret': ('firesifret',),
'firesylindra': ('firesylindra',),
'firesylindret': ('firesylindret',),
'firesylindrete': ('firesylindret',),
'firesylindrede': ('firesylindret',),
'firesylindrete': ('firesylindret',),
'firesylindrede': ('firesylindret',),
'firesylindret': ('firesylindret',),
'firetoms': ('firetoms',),
'fireårig': ('fireårig',),
'fireårige': ('fireårig',),
'fireårig': ('fireårig',),
'fireårs': ('fireårs',),
'firfota': ('firfota',),
'firfotet': ('firfotet',),
'firfotete': ('firfotet',),
'firfotede': ('firfotet',),
'firfotete': ('firfotet',),
'firfotede': ('firfotet',),
'firfotet': ('firfotet',),
'firføtt': ('firføtt',),
'firføtte': ('firføtt',),
'firføtt': ('firføtt',),
'firhendig': ('firhendig',),
'firhendige': ('firhendig',),
'firhendig': ('firhendig',),
'firhjuls': ('firhjuls',),
'firkanta': ('firkanta',),
'firkantet': ('firkantet',),
'firkantete': ('firkantet',),
'firkantede': ('firkantet',),
'firkantete': ('firkantet',),
'firkantede': ('firkantet',),
'firkantet': ('firkantet',),
'firmasta': ('firmasta',),
'firmastet': ('firmastet',),
'firmastete': ('firmastet',),
'firmastede': ('firmastet',),
'firmastete': ('firmastet',),
'firmastede': ('firmastet',),
'firmastet': ('firmastet',),
'firsifra': ('firsifra',),
'firsifret': ('firsifret',),
'firsifrete': ('firsifret',),
'firsifrede': ('firsifret',),
'firsifrete': ('firsifret',),
'firsifrede': ('firsifret',),
'firsifret': ('firsifret',),
'firskåren': ('firskåren',),
'firskårne': ('firskåren',),
'firskåret': ('firskåren',),
'firskåren': ('firskåren',),
'firskårne': ('firskåren',),
'firskårent': ('firskåren',),
'firskåret': ('firskåret',),
'firskårne': ('firskåret',),
'firskåret': ('firskåret',),
'firstrøken': ('firstrøken',),
'firstrøkne': ('firstrøken',),
'firstrøket': ('firstrøken',),
'firstrøket': ('firstrøket',),
'firstrøkne': ('firstrøket',),
'firstrøket': ('firstrøket',),
'firtoms': ('firtoms',),
'fisblid': ('fisblid',),
'fisblide': ('fisblid',),
'fisblidt': ('fisblid',),
'fist': ('fise',),
'feset': ('fise',),
'fist': ('fise',),
'feset': ('fise',),
'fesen': ('fise',),
'fiste': ('fise',),
'fesne': ('fise',),
'fiste': ('fise',),
'fesne': ('fise',),
'fisende': ('fise',),
'fiseblid': ('fiseblid',),
'fiseblide': ('fiseblid',),
'fiseblidt': ('fiseblid',),
'fisefin': ('fisefin',),
'fisefine': ('fisefin',),
'fisefint': ('fisefin',),
'fisefornem': ('fisefornem',),
'fisefornemme': ('fisefornem',),
'fisefornemt': ('fisefornem',),
'fisfin': ('fisfin',),
'fisfine': ('fisfin',),
'fisfint': ('fisfin',),
'fisfornem': ('fisfornem',),
'fisfornemme': ('fisfornem',),
'fisfornemt': ('fisfornem',),
'fisjonert': ('fisjonere',),
'fisjonerte': ('fisjonere',),
'fisjonerende': ('fisjonere',),
'fiskal': ('fiskal',),
'fiskale': ('fiskal',),
'fiskalt': ('fiskal',),
'fiska': ('fiske',),
'fisket': ('fiske',),
'fiska': ('fiske',),
'fisket': ('fiske',),
'fiska': ('fiske',),
'fiskete': ('fiske',),
'fiskede': ('fiske',),
'fiska': ('fiske',),
'fiskete': ('fiske',),
'fiskede': ('fiske',),
'fiskende': ('fiske',),
'fisla': ('fisle',),
'fislet': ('fisle',),
'fisla': ('fisle',),
'fislet': ('fisle',),
'fisla': ('fisle',),
'fislete': ('fisle',),
'fislede': ('fisle',),
'fislete': ('fisle',),
'fislede': ('fisle',),
'fisla': ('fisle',),
'fislete': ('fisle',),
'fislede': ('fisle',),
'fislete': ('fisle',),
'fislede': ('fisle',),
'fislende': ('fisle',),
'fissil': ('fissil',),
'fissile': ('fissil',),
'fissilt': ('fissil',),
'fjamsa': ('fjamse',),
'fjamset': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamset': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamsete': ('fjamse',),
'fjamsede': ('fjamse',),
'fjamsa': ('fjamse',),
'fjamsete': ('fjamse',),
'fjamsede': ('fjamse',),
'fjamsende': ('fjamse',),
'fjasa': ('fjase',),
'fjaset': ('fjase',),
'fjast': ('fjase',),
'fjasa': ('fjase',),
'fjaset': ('fjase',),
'fjast': ('fjase',),
'fjasa': ('fjase',),
'fjasete': ('fjase',),
'fjasede': ('fjase',),
'fjaste': ('fjase',),
'fjasa': ('fjase',),
'fjasete': ('fjase',),
'fjasede': ('fjase',),
'fjaste': ('fjase',),
'fjasende': ('fjase',),
'fjaset': ('fjaset',),
'fjasete': ('fjaset',),
'fjaset': ('fjaset',),
'fjasete': ('fjasete',),
'fjelg': ('fjelg',),
'fjelge': ('fjelg',),
'fjelgt': ('fjelg',),
'fjelga': ('fjelge',),
'fjelget': ('fjelge',),
'fjelga': ('fjelge',),
'fjelget': ('fjelge',),
'fjelga': ('fjelge',),
'fjelgete': ('fjelge',),
'fjelgede': ('fjelge',),
'fjelga': ('fjelge',),
'fjelgete': ('fjelge',),
'fjelgede': ('fjelge',),
'fjelgende': ('fjelge',),
'fjerde': ('fjerde',),
'fjern': ('fjern',),
'fjerne': ('fjern',),
'fjernt': ('fjern',),
'fjernere': ('fjern',),
'fjernest': ('fjern',),
'fjerneste': ('fjern',),
'fjerna': ('fjerne',),
'fjernet': ('fjerne',),
'fjerna': ('fjerne',),
'fjernet': ('fjerne',),
'fjerna': ('fjerne',),
'fjernete': ('fjerne',),
'fjernede': ('fjerne',),
'fjerna': ('fjerne',),
'fjernete': ('fjerne',),
'fjernede': ('fjerne',),
'fjernende': ('fjerne',),
'fjernstyrt': ('fjernstyre',),
'fjernstyrte': ('fjernstyre',),
'fjernstyrende': ('fjernstyre',),
'fjernstyrt': ('fjernstyrt',),
'fjernstyrte': ('fjernstyrt',),
'fjernstyrt': ('fjernstyrt',),
'fjerta': ('fjerte',),
'fjertet': ('fjerte',),
'fjerta': ('fjerte',),
'fjertet': ('fjerte',),
'fjerta': ('fjerte',),
'fjertete': ('fjerte',),
'fjertede': ('fjerte',),
'fjerta': ('fjerte',),
'fjertete': ('fjerte',),
'fjertede': ('fjerte',),
'fjertende': ('fjerte',),
'fjeska': ('fjeske',),
'fjesket': ('fjeske',),
'fjeska': ('fjeske',),
'fjesket': ('fjeske',),
'fjeska': ('fjeske',),
'fjeskete': ('fjeske',),
'fjeskede': ('fjeske',),
'fjeska': ('fjeske',),
'fjeskete': ('fjeske',),
'fjeskede': ('fjeske',),
'fjeskende': ('fjeske',),
'fjetra': ('fjetre',),
'fjetret': ('fjetre',),
'fjetra': ('fjetre',),
'fjetret': ('fjetre',),
'fjetra': ('fjetre',),
'fjetrete': ('fjetre',),
'fjetrede': ('fjetre',),
'fjetrete': ('fjetre',),
'fjetrede': ('fjetre',),
'fjetra': ('fjetre',),
'fjetrete': ('fjetre',),
'fjetrede': ('fjetre',),
'fjetrete': ('fjetre',),
'fjetrede': ('fjetre',),
'fjetrende': ('fjetre',),
'fjolla': ('fjolle',),
'fjollet': ('fjolle',),
'fjolla': ('fjolle',),
'fjollet': ('fjolle',),
'fjolla': ('fjolle',),
'fjollete': ('fjolle',),
'fjollede': ('fjolle',),
'fjolla': ('fjolle',),
'fjollete': ('fjolle',),
'fjollede': ('fjolle',),
'fjollende': ('fjolle',),
'fjollet': ('fjollet',),
'fjollete': ('fjollet',),
'fjollet': ('fjollet',),
'fjollete': ('fjollete',),
'fjong': ('fjong',),
'fjonge': ('fjong',),
'fjongt': ('fjong',),
'fjongere': ('fjong',),
'fjongest': ('fjong',),
'fjongeste': ('fjong',),
'fjorgammal': ('fjorgammal',),
'fjorgamle': ('fjorgammal',),
'fjorgammalt': ('fjorgammal',),
'fjorgammel': ('fjorgammel',),
'fjorgamle': ('fjorgammel',),
'fjorgammelt': ('fjorgammel',),
'fjortende': ('fjortende',),
'fjortenårig': ('fjortenårig',),
'fjortenårige': ('fjortenårig',),
'fjortenårig': ('fjortenårig',),
'fjortenårs': ('fjortenårs',),
'fjottet': ('fjottet',),
'fjottete': ('fjottet',),
'fjottet': ('fjottet',),
'fjottete': ('fjottete',),
'fjuska': ('fjuske',),
'fjusket': ('fjuske',),
'fjuska': ('fjuske',),
'fjusket': ('fjuske',),
'fjuska': ('fjuske',),
'fjuskete': ('fjuske',),
'fjuskede': ('fjuske',),
'fjuska': ('fjuske',),
'fjuskete': ('fjuske',),
'fjuskede': ('fjuske',),
'fjuskende': ('fjuske',),
'fjæra': ('fjære',),
'fjæret': ('fjære',),
'fjæra': ('fjære',),
'fjæret': ('fjære',),
'fjæra': ('fjære',),
'fjærete': ('fjære',),
'fjærede': ('fjære',),
'fjæra': ('fjære',),
'fjærete': ('fjære',),
'fjærede': ('fjære',),
'fjærende': ('fjære',),
'fjæret': ('fjæret',),
'fjærete': ('fjæret',),
'fjæret': ('fjæret',),
'fjærete': ('fjærete',),
'fjærlett': ('fjærlett',),
'fjærlette': ('fjærlett',),
'fjærlett': ('fjærlett',),
'fjøra': ('fjøre',),
'fjøret': ('fjøre',),
'fjøra': ('fjøre',),
'fjøret': ('fjøre',),
'fjøra': ('fjøre',),
'fjørete': ('fjøre',),
'fjørede': ('fjøre',),
'fjøra': ('fjøre',),
'fjørete': ('fjøre',),
'fjørede': ('fjøre',),
'fjørende': ('fjøre',),
'fjøret': ('fjøret',),
'fjørete': ('fjøret',),
'fjøret': ('fjøret',),
'fjørete': ('fjørete',),
'fjørlett': ('fjørlett',),
'fjørlette': ('fjørlett',),
'fjørlett': ('fjørlett',),
'flagga': ('flagge',),
'flagget': ('flagge',),
'flagga': ('flagge',),
'flagget': ('flagge',),
'flagga': ('flagge',),
'flaggete': ('flagge',),
'flaggede': ('flagge',),
'flagga': ('flagge',),
'flaggete': ('flagge',),
'flaggede': ('flagge',),
'flaggende': ('flagge',),
'flagrant': ('flagrant',),
'flagrante': ('flagrant',),
'flagrant': ('flagrant',),
'flagra': ('flagre',),
'flagret': ('flagre',),
'flagra': ('flagre',),
'flagret': ('flagre',),
'flagra': ('flagre',),
'flagrete': ('flagre',),
'flagrede': ('flagre',),
'flagrete': ('flagre',),
'flagrede': ('flagre',),
'flagra': ('flagre',),
'flagrete': ('flagre',),
'flagrede': ('flagre',),
'flagrete': ('flagre',),
'flagrede': ('flagre',),
'flagrende': ('flagre',),
'flaka': ('flake',),
'flaket': ('flake',),
'flakt': ('flake',),
'flaka': ('flake',),
'flaket': ('flake',),
'flakt': ('flake',),
'flaka': ('flake',),
'flakete': ('flake',),
'flakede': ('flake',),
'flakte': ('flake',),
'flaka': ('flake',),
'flakete': ('flake',),
'flakede': ('flake',),
'flakte': ('flake',),
'flakende': ('flake',),
'flakk': ('flakk',),
'flakke': ('flakk',),
'flakt': ('flakk',),
'flakka': ('flakke',),
'flakket': ('flakke',),
'flakka': ('flakke',),
'flakket': ('flakke',),
'flakka': ('flakke',),
'flakkete': ('flakke',),
'flakkede': ('flakke',),
'flakka': ('flakke',),
'flakkete': ('flakke',),
'flakkede': ('flakke',),
'flakkende': ('flakke',),
'flakna': ('flakne',),
'flaknet': ('flakne',),
'flakna': ('flakne',),
'flaknet': ('flakne',),
'flakna': ('flakne',),
'flaknete': ('flakne',),
'flaknede': ('flakne',),
'flaknete': ('flakne',),
'flaknede': ('flakne',),
'flakna': ('flakne',),
'flaknete': ('flakne',),
'flaknede': ('flakne',),
'flaknete': ('flakne',),
'flaknede': ('flakne',),
'flaknende': ('flakne',),
'flaksa': ('flakse',),
'flakset': ('flakse',),
'flaksa': ('flakse',),
'flakset': ('flakse',),
'flaksa': ('flakse',),
'flaksete': ('flakse',),
'flaksede': ('flakse',),
'flaksa': ('flakse',),
'flaksete': ('flakse',),
'flaksede': ('flakse',),
'flaksende': ('flakse',),
'flambert': ('flambere',),
'flamberte': ('flambere',),
'flamberende': ('flambere',),
'flamma': ('flamme',),
'flammet': ('flamme',),
'flamma': ('flamme',),
'flammet': ('flamme',),
'flamma': ('flamme',),
'flammete': ('flamme',),
'flammede': ('flamme',),
'flamma': ('flamme',),
'flammete': ('flamme',),
'flammede': ('flamme',),
'flammende': ('flamme',),
'flammende': ('flammende',),
'flammesikker': ('flammesikker',),
'flammesikre': ('flammesikker',),
'flammesikkert': ('flammesikker',),
'flammet': ('flammet',),
'flammete': ('flammet',),
'flammet': ('flammet',),
'flammete': ('flammete',),
'flamsk': ('flamsk',),
'flamske': ('flamsk',),
'flamsk': ('flamsk',),
'flamsktalende': ('flamsktalende',),
'flana': ('flane',),
'flanet': ('flane',),
'flant': ('flane',),
'flana': ('flane',),
'flanet': ('flane',),
'flant': ('flane',),
'flana': ('flane',),
'flanete': ('flane',),
'flanede': ('flane',),
'flante': ('flane',),
'flana': ('flane',),
'flanete': ('flane',),
'flanede': ('flane',),
'flante': ('flane',),
'flanende': ('flane',),
'flanert': ('flanere',),
'flanerte': ('flanere',),
'flanerende': ('flanere',),
'flankert': ('flankere',),
'flankerte': ('flankere',),
'flankerende': ('flankere',),
'flara': ('flare',),
'flaret': ('flare',),
'flart': ('flare',),
'flara': ('flare',),
'flaret': ('flare',),
'flart': ('flare',),
'flara': ('flare',),
'flarete': ('flare',),
'flarede': ('flare',),
'flarte': ('flare',),
'flara': ('flare',),
'flarete': ('flare',),
'flarede': ('flare',),
'flarte': ('flare',),
'flarende': ('flare',),
'flaska': ('flaske',),
'flasket': ('flaske',),
'flaska': ('flaske',),
'flasket': ('flaske',),
'flaska': ('flaske',),
'flaskete': ('flaske',),
'flaskede': ('flaske',),
'flaska': ('flaske',),
'flaskete': ('flaske',),
'flaskede': ('flaske',),
'flaskende': ('flaske',),
'flaskegrønn': ('flaskegrønn',),
'flaskegrønne': ('flaskegrønn',),
'flaskegrønt': ('flaskegrønn',),
'flassa': ('flasse',),
'flasset': ('flasse',),
'flassa': ('flasse',),
'flasset': ('flasse',),
'flassa': ('flasse',),
'flassete': ('flasse',),
'flassede': ('flasse',),
'flassa': ('flasse',),
'flassete': ('flasse',),
'flassede': ('flasse',),
'flassende': ('flasse',),
'flasset': ('flasset',),
'flassete': ('flasset',),
'flasset': ('flasset',),
'flassete': ('flassete',),
'flat': ('flat',),
'flate': ('flat',),
'flatt': ('flat',),
'flatere': ('flat',),
'flatest': ('flat',),
'flateste': ('flat',),
'flatbotna': ('flatbotna',),
'flatbotnet': ('flatbotnet',),
'flatbotnete': ('flatbotnet',),
'flatbotnede': ('flatbotnet',),
'flatbotnete': ('flatbotnet',),
'flatbotnede': ('flatbotnet',),
'flatbotnet': ('flatbotnet',),
'flatbrysta': ('flatbrysta',),
'flatbrystet': ('flatbrystet',),
'flatbrystete': ('flatbrystet',),
'flatbrystede': ('flatbrystet',),
'flatbrystete': ('flatbrystet',),
'flatbrystede': ('flatbrystet',),
'flatbrystet': ('flatbrystet',),
'flatbunna': ('flatbunna',),
'flatbunnet': ('flatbunnet',),
'flatbunnete': ('flatbunnet',),
'flatbunnede': ('flatbunnet',),
'flatbunnete': ('flatbunnet',),
'flatbunnede': ('flatbunnet',),
'flatbunnet': ('flatbunnet',),
'flata': ('flate',),
'flatet': ('flate',),
'flata': ('flate',),
'flatet': ('flate',),
'flata': ('flate',),
'flatete': ('flate',),
'flatede': ('flate',),
'flata': ('flate',),
'flatete': ('flate',),
'flatede': ('flate',),
'flatende': ('flate',),
'flatklemt': ('flatklemt',),
'flatklemte': ('flatklemt',),
'flatklemt': ('flatklemt',),
'flatlendt': ('flatlendt',),
'flatlendte': ('flatlendt',),
'flatlendt': ('flatlendt',),
'flatna': ('flatne',),
'flatnet': ('flatne',),
'flatna': ('flatne',),
'flatnet': ('flatne',),
'flatna': ('flatne',),
'flatnete': ('flatne',),
'flatnede': ('flatne',),
'flatnete': ('flatne',),
'flatnede': ('flatne',),
'flatna': ('flatne',),
'flatnete': ('flatne',),
'flatnede': ('flatne',),
'flatnete': ('flatne',),
'flatnede': ('flatne',),
'flatnende': ('flatne',),
'flattert': ('flattere',),
'flatterte': ('flattere',),
'flatterende': ('flattere',),
'flatterende': ('flatterende',),
'flattrykt': ('flattrykt',),
'flattrykte': ('flattrykt',),
'flattrykt': ('flattrykt',),
'flau': ('flau',),
'flaue': ('flau',),
'flaut': ('flau',),
'flauere': ('flau',),
'flauest': ('flau',),
'flaueste': ('flau',),
'flaua': ('flaue',),
'flauet': ('flaue',),
'flaua': ('flaue',),
'flauet': ('flaue',),
'flaua': ('flaue',),
'flauete': ('flaue',),
'flauede': ('flaue',),
'flaua': ('flaue',),
'flauete': ('flaue',),
'flauede': ('flaue',),
'flauende': ('flaue',),
'flegmatisk': ('flegmatisk',),
'flegmatiske': ('flegmatisk',),
'flegmatisk': ('flegmatisk',),
'fleinskalla': ('fleinskalla',),
'fleinskallet': ('fleinskallet',),
'fleinskallete': ('fleinskallet',),
'fleinskallede': ('fleinskallet',),
'fleinskallete': ('fleinskallet',),
'fleinskallede': ('fleinskallet',),
'fleinskallet': ('fleinskallet',),
'fleipa': ('fleipe',),
'fleipet': ('fleipe',),
'fleipt': ('fleipe',),
'fleipa': ('fleipe',),
'fleipet': ('fleipe',),
'fleipt': ('fleipe',),
'fleipa': ('fleipe',),
'fleipete': ('fleipe',),
'fleipede': ('fleipe',),
'fleipte': ('fleipe',),
'fleipa': ('fleipe',),
'fleipete': ('fleipe',),
'fleipede': ('fleipe',),
'fleipte': ('fleipe',),
'fleipende': ('fleipe',),
'fleipet': ('fleipet',),
'fleipete': ('fleipet',),
'fleipet': ('fleipet',),
'fleipete': ('fleipete',),
'flekka': ('flekke',),
'flekket': ('flekke',),
'flekka': ('flekke',),
'flekket': ('flekke',),
'flekka': ('flekke',),
'flekkete': ('flekke',),
'flekkede': ('flekke',),
'flekka': ('flekke',),
'flekkete': ('flekke',),
'flekkede': ('flekke',),
'flekkende': ('flekke',),
'flekket': ('flekke',),
'flekt': ('flekke',),
'flekket': ('flekke',),
'flekt': ('flekke',),
'flekkete': ('flekke',),
'flekkede': ('flekke',),
'flekte': ('flekke',),
'flekkete': ('flekke',),
'flekkede': ('flekke',),
'flekte': ('flekke',),
'flekkende': ('flekke',),
'flekket': ('flekket',),
'flekkete': ('flekket',),
'flekket': ('flekket',),
'flekkete': ('flekkete',),
'fleksa': ('flekse',),
'flekset': ('flekse',),
'fleksa': ('flekse',),
'flekset': ('flekse',),
'fleksa': ('flekse',),
'fleksete': ('flekse',),
'fleksede': ('flekse',),
'fleksa': ('flekse',),
'fleksete': ('flekse',),
'fleksede': ('flekse',),
'fleksende': ('flekse',),
'fleksibel': ('fleksibel',),
'fleksible': ('fleksibel',),
'fleksibelt': ('fleksibel',),
'flektert': ('flektere',),
'flekterte': ('flektere',),
'flekterende': ('flektere',),
'flenga': ('flenge',),
'flenget': ('flenge',),
'flengt': ('flenge',),
'flenga': ('flenge',),
'flenget': ('flenge',),
'flengt': ('flenge',),
'flenga': ('flenge',),
'flengete': ('flenge',),
'flengede': ('flenge',),
'flengte': ('flenge',),
'flenga': ('flenge',),
'flengete': ('flenge',),
'flengede': ('flenge',),
'flengte': ('flenge',),
'flengende': ('flenge',),
'flengende': ('flengende',),
'flensa': ('flense',),
'flenset': ('flense',),
'flensa': ('flense',),
'flenset': ('flense',),
'flensa': ('flense',),
'flensete': ('flense',),
'flensede': ('flense',),
'flensa': ('flense',),
'flensete': ('flense',),
'flensede': ('flense',),
'flensende': ('flense',),
'flerbo': ('flerbo',),
'flerbu': ('flerbu',),
'flercella': ('flercella',),
'flercellet': ('flercellet',),
'flercellete': ('flercellet',),
'flercellede': ('flercellet',),
'flercellete': ('flercellet',),
'flercellede': ('flercellet',),
'flercellet': ('flercellet',),
'flerdobbel': ('flerdobbel',),
'flerdoble': ('flerdobbel',),
'flerdobbelt': ('flerdobbel',),
'flerdobbelt': ('flerdobbelt',),
'flerdobbelte': ('flerdobbelt',),
'flerdobbelt': ('flerdobbelt',),
'flerdobla': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoblete': ('flerdoble',),
'flerdoblede': ('flerdoble',),
'flerdoblete': ('flerdoble',),
'flerdoblede': ('flerdoble',),
'flerdobla': ('flerdoble',),
'flerdoblete': ('flerdoble',),
'flerdoblede': ('flerdoble',),
'flerdoblete': ('flerdoble',),
'flerdoblede': ('flerdoble',),
'flerdoblende': ('flerdoble',),
'flere': ('flere',),
'flest': ('flere',),
'fleste': ('flere',),
'flerfarget': ('flerfarget',),
'flerfargete': ('flerfarget',),
'flerfargede': ('flerfarget',),
'flerfargete': ('flerfarget',),
'flerfargede': ('flerfarget',),
'flerfarget': ('flerfarget',),
'flerfasa': ('flerfasa',),
'flerfaset': ('flerfaset',),
'flerfasete': ('flerfaset',),
'flerfasede': ('flerfaset',),
'flerfasete': ('flerfaset',),
'flerfasede': ('flerfaset',),
'flerfaset': ('flerfaset',),
'flerfoldig': ('flerfoldig',),
'flerfoldige': ('flerfoldig',),
'flerfoldig': ('flerfoldig',),
'flernasjonal': ('flernasjonal',),
'flernasjonale': ('flernasjonal',),
'flernasjonalt': ('flernasjonal',),
'flersida': ('flersida',),
'flersidet': ('flersidet',),
'flersidete': ('flersidet',),
'flersidede': ('flersidet',),
'flersidete': ('flersidet',),
'flersidede': ('flersidet',),
'flersidet': ('flersidet',),
'flersidig': ('flersidig',),
'flersidige': ('flersidig',),
'flersidig': ('flersidig',),
'flersifra': ('flersifra',),
'flersifret': ('flersifret',),
'flersifrete': ('flersifret',),
'flersifrede': ('flersifret',),
'flersifrete': ('flersifret',),
'flersifrede': ('flersifret',),
'flersifret': ('flersifret',),
'flerspråklig': ('flerspråklig',),
'flerspråklige': ('flerspråklig',),
'flerspråklig': ('flerspråklig',),
'flerstemmig': ('flerstemmig',),
'flerstemmige': ('flerstemmig',),
'flerstemmig': ('flerstemmig',),
'flerstemt': ('flerstemt',),
'flerstemte': ('flerstemt',),
'flerstemt': ('flerstemt',),
'flertydig': ('flertydig',),
'flertydige': ('flertydig',),
'flertydig': ('flertydig',),
'flerverdig': ('flerverdig',),
'flerverdige': ('flerverdig',),
'flerverdig': ('flerverdig',),
'flerårig': ('flerårig',),
'flerårige': ('flerårig',),
'flerårig': ('flerårig',),
'flesket': ('flesket',),
'fleskete': ('flesket',),
'flesket': ('flesket',),
'fleskete': ('fleskete',),
'flest': ('flest',),
'fleste': ('flest',),
'flest': ('flest',),
'fletta': ('flette',),
'flettet': ('flette',),
'fletta': ('flette',),
'flettet': ('flette',),
'fletta': ('flette',),
'flettete': ('flette',),
'flettede': ('flette',),
'fletta': ('flette',),
'flettete': ('flette',),
'flettede': ('flette',),
'flettende': ('flette',),
'flidd': ('fli',),
'flidde': ('fli',),
'fliende': ('fli',),
'flidd': ('flidd',),
'flidde': ('flidd',),
'flidd': ('flidd',),
'fliket': ('fliket',),
'flikete': ('fliket',),
'fliket': ('fliket',),
'flikete': ('flikete',),
'flikka': ('flikke',),
'flikket': ('flikke',),
'flikka': ('flikke',),
'flikket': ('flikke',),
'flikka': ('flikke',),
'flikkete': ('flikke',),
'flikkede': ('flikke',),
'flikka': ('flikke',),
'flikkete': ('flikke',),
'flikkede': ('flikke',),
'flikkende': ('flikke',),
'flimra': ('flimre',),
'flimret': ('flimre',),
'flimra': ('flimre',),
'flimret': ('flimre',),
'flimra': ('flimre',),
'flimrete': ('flimre',),
'flimrede': ('flimre',),
'flimrete': ('flimre',),
'flimrede': ('flimre',),
'flimra': ('flimre',),
'flimrete': ('flimre',),
'flimrede': ('flimre',),
'flimrete': ('flimre',),
'flimrede': ('flimre',),
'flimrende': ('flimre',),
'flink': ('flink',),
'flinke': ('flink',),
'flinkt': ('flink',),
'flinkere': ('flink',),
'flinkest': ('flink',),
'flinkeste': ('flink',),
'flinthard': ('flinthard',),
'flintharde': ('flinthard',),
'flinthardt': ('flinthard',),
'flintskalla': ('flintskalla',),
'flintskallet': ('flintskallet',),
'flintskallete': ('flintskallet',),
'flintskallede': ('flintskallet',),
'flintskallete': ('flintskallet',),
'flintskallede': ('flintskallet',),
'flintskallet': ('flintskallet',),
'flippa': ('flippe',),
'flippet': ('flippe',),
'flippa': ('flippe',),
'flippet': ('flippe',),
'flippa': ('flippe',),
'flippete': ('flippe',),
'flippede': ('flippe',),
'flippa': ('flippe',),
'flippete': ('flippe',),
'flippede': ('flippe',),
'flippende': ('flippe',),
'flirt': ('flire',),
'flirte': ('flire',),
'flirende': ('flire',),
'flisbelagt': ('flisbelagt',),
'flisbelagte': ('flisbelagt',),
'flisbelagt': ('flisbelagt',),
'flisa': ('flise',),
'fliset': ('flise',),
'flist': ('flise',),
'flisa': ('flise',),
'fliset': ('flise',),
'flist': ('flise',),
'flisa': ('flise',),
'flisete': ('flise',),
'flisede': ('flise',),
'fliste': ('flise',),
'flisa': ('flise',),
'flisete': ('flise',),
'flisede': ('flise',),
'fliste': ('flise',),
'flisende': ('flise',),
'flisebelagt': ('flisebelagt',),
'flisebelagte': ('flisebelagt',),
'flisebelagt': ('flisebelagt',),
'fliselagt': ('fliselagt',),
'fliselagte': ('fliselagt',),
'fliselagt': ('fliselagt',),
'fliselagt': ('fliselegge',),
'fliselagte': ('fliselegge',),
'fliseleggende': ('fliselegge',),
'fliset': ('fliset',),
'flisete': ('fliset',),
'fliset': ('fliset',),
'flisete': ('flisete',),
'flislagt': ('flislagt',),
'flislagte': ('flislagt',),
'flislagt': ('flislagt',),
'flislagt': ('flislegge',),
'flislagte': ('flislegge',),
'flisleggende': ('flislegge',),
'flittig': ('flittig',),
'flittige': ('flittig',),
'flittig': ('flittig',),
'flittigere': ('flittig',),
'flittigst': ('flittig',),
'flittigste': ('flittig',),
'floka': ('floke',),
'floket': ('floke',),
'floka': ('floke',),
'floket': ('floke',),
'floka': ('floke',),
'flokete': ('floke',),
'flokede': ('floke',),
'floka': ('floke',),
'flokete': ('floke',),
'flokede': ('floke',),
'flokende': ('floke',),
'floket': ('floket',),
'flokete': ('floket',),
'floket': ('floket',),
'flokete': ('flokete',),
'flokka': ('flokke',),
'flokket': ('flokke',),
'flokka': ('flokke',),
'flokket': ('flokke',),
'flokka': ('flokke',),
'flokkete': ('flokke',),
'flokkede': ('flokke',),
'flokka': ('flokke',),
'flokkete': ('flokke',),
'flokkede': ('flokke',),
'flokkende': ('flokke',),
'floksa': ('flokse',),
'flokset': ('flokse',),
'floksa': ('flokse',),
'flokset': ('flokse',),
'floksa': ('flokse',),
'floksete': ('flokse',),
'floksede': ('flokse',),
'floksa': ('flokse',),
'floksete': ('flokse',),
'floksede': ('flokse',),
'floksende': ('flokse',),
'flomherja': ('flomherja',),
'flomherjet': ('flomherjet',),
'flomherjete': ('flomherjet',),
'flomherjede': ('flomherjet',),
'flomherjete': ('flomherjet',),
'flomherjede': ('flomherjet',),
'flomherjet': ('flomherjet',),
'flomma': ('flomme',),
'flommet': ('flomme',),
'flomma': ('flomme',),
'flommet': ('flomme',),
'flomma': ('flomme',),
'flommete': ('flomme',),
'flommede': ('flomme',),
'flomma': ('flomme',),
'flommete': ('flomme',),
'flommede': ('flomme',),
'flommende': ('flomme',),
'floppa': ('floppe',),
'floppet': ('floppe',),
'floppa': ('floppe',),
'floppet': ('floppe',),
'floppa': ('floppe',),
'floppete': ('floppe',),
'floppede': ('floppe',),
'floppa': ('floppe',),
'floppete': ('floppe',),
'floppede': ('floppe',),
'floppende': ('floppe',),
'floragrafert': ('floragrafere',),
'floragraferte': ('floragrafere',),
'floragraferende': ('floragrafere',),
'florentinsk': ('florentinsk',),
'florentinske': ('florentinsk',),
'florentinsk': ('florentinsk',),
'florert': ('florere',),
'florerte': ('florere',),
'florerende': ('florere',),
'florisant': ('florisant',),
'florisante': ('florisant',),
'florisant': ('florisant',),
'florlett': ('florlett',),
'florlette': ('florlett',),
'florlett': ('florlett',),
'floromvundet': ('floromvundet',),
'floromvundne': ('floromvundet',),
'floromvundet': ('floromvundet',),
'flotta': ('flotte',),
'flottet': ('flotte',),
'flotta': ('flotte',),
'flottet': ('flotte',),
'flotta': ('flotte',),
'flottete': ('flotte',),
'flottede': ('flotte',),
'flotta': ('flotte',),
'flottete': ('flotte',),
'flottede': ('flotte',),
'flottende': ('flotte',),
'fluid': ('fluid',),
'fluide': ('fluid',),
'fluid': ('fluid',),
'flukta': ('flukte',),
'fluktet': ('flukte',),
'flukta': ('flukte',),
'fluktet': ('flukte',),
'flukta': ('flukte',),
'fluktete': ('flukte',),
'fluktede': ('flukte',),
'flukta': ('flukte',),
'fluktete': ('flukte',),
'fluktede': ('flukte',),
'fluktende': ('flukte',),
'fluktsikker': ('fluktsikker',),
'fluktsikre': ('fluktsikker',),
'fluktsikkert': ('fluktsikker',),
'fluktuert': ('fluktuere',),
'fluktuerte': ('fluktuere',),
'fluktuerende': ('fluktuere',),
'fluorescert': ('fluorescere',),
'fluorescerte': ('fluorescere',),
'fluorescerende': ('fluorescere',),
'fluoridert': ('fluoridere',),
'fluoriderte': ('fluoridere',),
'fluoriderende': ('fluoridere',),
'fluorisert': ('fluorisere',),
'fluoriserte': ('fluorisere',),
'fluoriserende': ('fluorisere',),
'flydd': ('fly',),
'fløyet': ('fly',),
'flydd': ('fly',),
'fløyet': ('fly',),
'fløyen': ('fly',),
'flydde': ('fly',),
'fløyne': ('fly',),
'flydde': ('fly',),
'fløyne': ('fly',),
'flyende': ('fly',),
'flybåren': ('flybåren',),
'flybårne': ('flybåren',),
'flybåret': ('flybåren',),
'flybåret': ('flybåret',),
'flybårne': ('flybåret',),
'flybåret': ('flybåret',),
'flydyktig': ('flydyktig',),
'flydyktige': ('flydyktig',),
'flydyktig': ('flydyktig',),
'flyende': ('flyende',),
'flyferdig': ('flyferdig',),
'flyferdige': ('flyferdig',),
'flyferdig': ('flyferdig',),
'fløyet': ('flyge',),
'fløyen': ('flyge',),
'fløyne': ('flyge',),
'flygende': ('flyge',),
'flygedyktig': ('flygedyktig',),
'flygedyktige': ('flygedyktig',),
'flygedyktig': ('flygedyktig',),
'flygeferdig': ('flygeferdig',),
'flygeferdige': ('flygeferdig',),
'flygeferdig': ('flygeferdig',),
'flygende': ('flygende',),
'flykta': ('flykte',),
'flyktet': ('flykte',),
'flykta': ('flykte',),
'flyktet': ('flykte',),
'flykta': ('flykte',),
'flyktete': ('flykte',),
'flyktede': ('flykte',),
'flykta': ('flykte',),
'flyktete': ('flykte',),
'flyktede': ('flykte',),
'flyktende': ('flykte',),
'flyktig': ('flyktig',),
'flyktige': ('flyktig',),
'flyktig': ('flyktig',),
'flyktigere': ('flyktig',),
'flyktigst': ('flyktig',),
'flyktigste': ('flyktig',),
'flytt': ('flyte',),
'flytte': ('flyte',),
'flytende': ('flyte',),
'flytende': ('flytende',),
'flyttbar': ('flyttbar',),
'flyttbare': ('flyttbar',),
'flyttbart': ('flyttbar',),
'flytta': ('flytte',),
'flyttet': ('flytte',),
'flytta': ('flytte',),
'flyttet': ('flytte',),
'flytta': ('flytte',),
'flyttete': ('flytte',),
'flyttede': ('flytte',),
'flytta': ('flytte',),
'flyttete': ('flytte',),
'flyttede': ('flytte',),
'flyttende': ('flytte',),
'flådd': ('flå',),
'flådde': ('flå',),
'flående': ('flå',),
'flå': ('flå',),
'flåe': ('flå',),
'flå': ('flå',),
'flåe': ('flå',),
'flå': ('flå',),
'flått': ('flå',),
'flåkjefta': ('flåkjefta',),
'flåkjeftet': ('flåkjeftet',),
'flåkjeftete': ('flåkjeftet',),
'flåkjeftede': ('flåkjeftet',),
'flåkjeftete': ('flåkjeftet',),
'flåkjeftede': ('flåkjeftet',),
'flåkjeftet': ('flåkjeftet',),
'flåst': ('flåse',),
'flåste': ('flåse',),
'flåsende': ('flåse',),
'flåset': ('flåset',),
'flåsete': ('flåset',),
'flåset': ('flåset',),
'flåsete': ('flåsete',),
'flædd': ('flæ',),
'flædde': ('flæ',),
'flæende': ('flæ',),
'flæra': ('flære',),
'flæret': ('flære',),
'flæra': ('flære',),
'flæret': ('flære',),
'flæra': ('flære',),
'flærete': ('flære',),
'flærede': ('flære',),
'flæra': ('flære',),
'flærete': ('flære',),
'flærede': ('flære',),
'flærende': ('flære',),
'flødd': ('flø',),
'flødde': ('flø',),
'fløende': ('flø',),
'fløkt': ('fløke',),
'fløkte': ('fløke',),
'fløkende': ('fløke',),
'flømmet': ('flømme',),
'flømt': ('flømme',),
'flømmet': ('flømme',),
'flømt': ('flømme',),
'flømmete': ('flømme',),
'flømmede': ('flømme',),
'flømte': ('flømme',),
'flømmete': ('flømme',),
'flømmede': ('flømme',),
'flømte': ('flømme',),
'flømmende': ('flømme',),
'flørta': ('flørte',),
'flørtet': ('flørte',),
'flørta': ('flørte',),
'flørtet': ('flørte',),
'flørta': ('flørte',),
'flørtete': ('flørte',),
'flørtede': ('flørte',),
'flørta': ('flørte',),
'flørtete': ('flørte',),
'flørtede': ('flørte',),
'flørtende': ('flørte',),
'fløta': ('fløte',),
'fløtet': ('fløte',),
'fløtt': ('fløte',),
'fløta': ('fløte',),
'fløtet': ('fløte',),
'fløtt': ('fløte',),
'fløta': ('fløte',),
'fløtete': ('fløte',),
'fløtede': ('fløte',),
'fløtte': ('fløte',),
'fløta': ('fløte',),
'fløtete': ('fløte',),
'fløtede': ('fløte',),
'fløtte': ('fløte',),
'fløtende': ('fløte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytete': ('fløyte',),
'fløytede': ('fløyte',),
'fløyta': ('fløyte',),
'fløytete': ('fløyte',),
'fløytede': ('fløyte',),
'fløytende': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytet': ('fløyte',),
'fløyta': ('fløyte',),
'fløytete': ('fløyte',),
'fløytede': ('fløyte',),
'fløyta': ('fløyte',),
'fløytete': ('fløyte',),
'fløytede': ('fløyte',),
'fløytende': ('fløyte',),
'fnist': ('fnise',),
'fniste': ('fnise',),
'fnisende': ('fnise',),
'fniset': ('fniset',),
'fnisete': ('fniset',),
'fniset': ('fniset',),
'fnisete': ('fnisete',),
'fnugglett': ('fnugglett',),
'fnugglette': ('fnugglett',),
'fnugglett': ('fnugglett',),
'fnyst': ('fnyse',),
'fnyste': ('fnyse',),
'fnysende': ('fnyse',),
'fnysende': ('fnysende',),
'fokal': ('fokal',),
'fokale': ('fokal',),
'fokalt': ('fokal',),
'fokusert': ('fokusere',),
'fokuserte': ('fokusere',),
'fokuserende': ('fokusere',),
'folda': ('folde',),
'foldet': ('folde',),
'folda': ('folde',),
'foldet': ('folde',),
'folda': ('folde',),
'foldete': ('folde',),
'foldede': ('folde',),
'folda': ('folde',),
'foldete': ('folde',),
'foldede': ('folde',),
'foldende': ('folde',),
'fola': ('fole',),
'folet': ('fole',),
'fola': ('fole',),
'folet': ('fole',),
'fola': ('fole',),
'folete': ('fole',),
'folede': ('fole',),
'fola': ('fole',),
'folete': ('fole',),
'folede': ('fole',),
'folende': ('fole',),
'foliert': ('foliere',),
'folierte': ('foliere',),
'folierende': ('foliere',),
'folka': ('folke',),
'folket': ('folke',),
'folka': ('folke',),
'folket': ('folke',),
'folka': ('folke',),
'folkete': ('folke',),
'folkede': ('folke',),
'folka': ('folke',),
'folkete': ('folke',),
'folkede': ('folke',),
'folkende': ('folke',),
'folkelig': ('folkelig',),
'folkelige': ('folkelig',),
'folkelig': ('folkelig',),
'folkevalgt': ('folkevalgt',),
'folkevalgte': ('folkevalgt',),
'folkevalgt': ('folkevalgt',),
'folkevond': ('folkevond',),
'folkevonde': ('folkevond',),
'folkevondt': ('folkevond',),
'folkloristisk': ('folkloristisk',),
'folkloristiske': ('folkloristisk',),
'folkloristisk': ('folkloristisk',),
'folksom': ('folksom',),
'folksomme': ('folksom',),
'folksomt': ('folksom',),
'folksommere': ('folksom',),
'folksomst': ('folksom',),
'folksomste': ('folksom',),
'folla': ('folle',),
'follet': ('folle',),
'folla': ('folle',),
'follet': ('folle',),
'folla': ('folle',),
'follete': ('folle',),
'follede': ('folle',),
'folla': ('folle',),
'follete': ('folle',),
'follede': ('folle',),
'follende': ('folle',),
'follrik': ('follrik',),
'follrike': ('follrik',),
'follrikt': ('follrik',),
'folna': ('folne',),
'folnet': ('folne',),
'folna': ('folne',),
'folnet': ('folne',),
'folna': ('folne',),
'folnete': ('folne',),
'folnede': ('folne',),
'folnete': ('folne',),
'folnede': ('folne',),
'folna': ('folne',),
'folnete': ('folne',),
'folnede': ('folne',),
'folnete': ('folne',),
'folnede': ('folne',),
'folnende': ('folne',),
'fomla': ('fomle',),
'fomlet': ('fomle',),
'fomla': ('fomle',),
'fomlet': ('fomle',),
'fomla': ('fomle',),
'fomlete': ('fomle',),
'fomlede': ('fomle',),
'fomlete': ('fomle',),
'fomlede': ('fomle',),
'fomla': ('fomle',),
'fomlete': ('fomle',),
'fomlede': ('fomle',),
'fomlete': ('fomle',),
'fomlede': ('fomle',),
'fomlende': ('fomle',),
'fonetisk': ('fonetisk',),
'fonetiske': ('fonetisk',),
'fonetisk': ('fonetisk',),
'fonna': ('fonne',),
'fonnet': ('fonne',),
'fonna': ('fonne',),
'fonnet': ('fonne',),
'fonna': ('fonne',),
'fonnete': ('fonne',),
'fonnede': ('fonne',),
'fonna': ('fonne',),
'fonnete': ('fonne',),
'fonnede': ('fonne',),
'fonnende': ('fonne',),
'fonnet': ('fonnet',),
'fonnete': ('fonnet',),
'fonnet': ('fonnet',),
'fonnete': ('fonnete',),
'fonologisk': ('fonologisk',),
'fonologiske': ('fonologisk',),
'fonologisk': ('fonologisk',),
'forakta': ('forakte',),
'foraktet': ('forakte',),
'forakta': ('forakte',),
'foraktet': ('forakte',),
'forakta': ('forakte',),
'foraktete': ('forakte',),
'foraktede': ('forakte',),
'forakta': ('forakte',),
'foraktete': ('forakte',),
'foraktede': ('forakte',),
'foraktende': ('forakte',),
'foraktelig': ('foraktelig',),
'foraktelige': ('foraktelig',),
'foraktelig': ('foraktelig',),
'foranderlig': ('foranderlig',),
'foranderlige': ('foranderlig',),
'foranderlig': ('foranderlig',),
'forandra': ('forandre',),
'forandret': ('forandre',),
'forandra': ('forandre',),
'forandret': ('forandre',),
'forandra': ('forandre',),
'forandrete': ('forandre',),
'forandrede': ('forandre',),
'forandrete': ('forandre',),
'forandrede': ('forandre',),
'forandra': ('forandre',),
'forandrete': ('forandre',),
'forandrede': ('forandre',),
'forandrete': ('forandre',),
'forandrede': ('forandre',),
'forandrende': ('forandre',),
'forankra': ('forankre',),
'forankret': ('forankre',),
'forankra': ('forankre',),
'forankret': ('forankre',),
'forankra': ('forankre',),
'forankrete': ('forankre',),
'forankrede': ('forankre',),
'forankrete': ('forankre',),
'forankrede': ('forankre',),
'forankra': ('forankre',),
'forankrete': ('forankre',),
'forankrede': ('forankre',),
'forankrete': ('forankre',),
'forankrede': ('forankre',),
'forankrende': ('forankre',),
'foranlediga': ('foranledige',),
'foranlediget': ('foranledige',),
'foranlediga': ('foranledige',),
'foranlediget': ('foranledige',),
'foranlediga': ('foranledige',),
'foranledigete': ('foranledige',),
'foranledigede': ('foranledige',),
'foranlediga': ('foranledige',),
'foranledigete': ('foranledige',),
'foranledigede': ('foranledige',),
'foranledigende': ('foranledige',),
'forannevnt': ('forannevnt',),
'forannevnte': ('forannevnt',),
'forannevnt': ('forannevnt',),
'foranstalta': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstaltete': ('foranstalte',),
'foranstaltede': ('foranstalte',),
'foranstalta': ('foranstalte',),
'foranstaltete': ('foranstalte',),
'foranstaltede': ('foranstalte',),
'foranstaltende': ('foranstalte',),
'foranstilt': ('foranstilt',),
'foranstilte': ('foranstilt',),
'foranstilt': ('foranstilt',),
'forarbeida': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarbeidd': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarbeidd': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidete': ('forarbeide',),
'forarbeidede': ('forarbeide',),
'forarbeidde': ('forarbeide',),
'forarbeida': ('forarbeide',),
'forarbeidete': ('forarbeide',),
'forarbeidede': ('forarbeide',),
'forarbeidde': ('forarbeide',),
'forarbeidende': ('forarbeide',),
'forarga': ('forarge',),
'forarget': ('forarge',),
'forarga': ('forarge',),
'forarget': ('forarge',),
'forarga': ('forarge',),
'forargete': ('forarge',),
'forargede': ('forarge',),
'forarga': ('forarge',),
'forargete': ('forarge',),
'forargede': ('forarge',),
'forargende': ('forarge',),
'forargelig': ('forargelig',),
'forargelige': ('forargelig',),
'forargelig': ('forargelig',),
'forarma': ('forarme',),
'forarmet': ('forarme',),
'forarma': ('forarme',),
'forarmet': ('forarme',),
'forarma': ('forarme',),
'forarmete': ('forarme',),
'forarmede': ('forarme',),
'forarma': ('forarme',),
'forarmete': ('forarme',),
'forarmede': ('forarme',),
'forarmende': ('forarme',),
'forbanna': ('forbanna',),
'forbanna': ('forbanne',),
'forbannet': ('forbanne',),
'forbant': ('forbanne',),
'forbanna': ('forbanne',),
'forbannet': ('forbanne',),
'forbant': ('forbanne',),
'forbanna': ('forbanne',),
'forbannete': ('forbanne',),
'forbannede': ('forbanne',),
'forbante': ('forbanne',),
'forbanna': ('forbanne',),
'forbannete': ('forbanne',),
'forbannede': ('forbanne',),
'forbante': ('forbanne',),
'forbannende': ('forbanne',),
'forbannet': ('forbannet',),
'forbannete': ('forbannet',),
'forbannede': ('forbannet',),
'forbannete': ('forbannet',),
'forbannede': ('forbannet',),
'forbannet': ('forbannet',),
'forbarma': ('forbarme',),
'forbarmet': ('forbarme',),
'forbarma': ('forbarme',),
'forbarmet': ('forbarme',),
'forbarma': ('forbarme',),
'forbarmete': ('forbarme',),
'forbarmede': ('forbarme',),
'forbarma': ('forbarme',),
'forbarmete': ('forbarme',),
'forbarmede': ('forbarme',),
'forbarmende': ('forbarme',),
'forbaska': ('forbaska',),
'forbasket': ('forbasket',),
'forbaskete': ('forbasket',),
'forbaskede': ('forbasket',),
'forbaskete': ('forbasket',),
'forbaskede': ('forbasket',),
'forbasket': ('forbasket',),
'forbausa': ('forbause',),
'forbauset': ('forbause',),
'forbausa': ('forbause',),
'forbauset': ('forbause',),
'forbausa': ('forbause',),
'forbausete': ('forbause',),
'forbausede': ('forbause',),
'forbausa': ('forbause',),
'forbausete': ('forbause',),
'forbausede': ('forbause',),
'forbausende': ('forbause',),
'forbedra': ('forbedre',),
'forbedret': ('forbedre',),
'forbedra': ('forbedre',),
'forbedret': ('forbedre',),
'forbedra': ('forbedre',),
'forbedrete': ('forbedre',),
'forbedrede': ('forbedre',),
'forbedrete': ('forbedre',),
'forbedrede': ('forbedre',),
'forbedra': ('forbedre',),
'forbedrete': ('forbedre',),
'forbedrede': ('forbedre',),
'forbedrete': ('forbedre',),
'forbedrede': ('forbedre',),
'forbedrende': ('forbedre',),
'forbeholdt': ('forbeholde',),
'forbeholdte': ('forbeholde',),
'forbeholdende': ('forbeholde',),
'forbeholden': ('forbeholden',),
'forbeholdne': ('forbeholden',),
'forbeholdent': ('forbeholden',),
'forbeina': ('forbeine',),
'forbeinet': ('forbeine',),
'forbeina': ('forbeine',),
'forbeinet': ('forbeine',),
'forbeina': ('forbeine',),
'forbeinete': ('forbeine',),
'forbeinede': ('forbeine',),
'forbeina': ('forbeine',),
'forbeinete': ('forbeine',),
'forbeinede': ('forbeine',),
'forbeinende': ('forbeine',),
'forbena': ('forbene',),
'forbenet': ('forbene',),
'forbena': ('forbene',),
'forbenet': ('forbene',),
'forbena': ('forbene',),
'forbenete': ('forbene',),
'forbenede': ('forbene',),
'forbena': ('forbene',),
'forbenete': ('forbene',),
'forbenede': ('forbene',),
'forbenende': ('forbene',),
'forberedt': ('forberede',),
'forberedte': ('forberede',),
'forberedende': ('forberede',),
'forberedende': ('forberedende',),
'forberedt': ('forberedt',),
'forberedte': ('forberedt',),
'forberedt': ('forberedt',),
'forbigått': ('forbigå',),
'forbigåtte': ('forbigå',),
'forbigående': ('forbigå',),
'forbigående': ('forbigående',),
'forbilledlig': ('forbilledlig',),
'forbilledlige': ('forbilledlig',),
'forbilledlig': ('forbilledlig',),
'forbundet': ('forbinde',),
'forbunden': ('forbinde',),
'forbundne': ('forbinde',),
'forbindende': ('forbinde',),
'forbindtlig': ('forbindtlig',),
'forbindtlige': ('forbindtlig',),
'forbindtlig': ('forbindtlig',),
'forbipasserende': ('forbipasserende',),
'forbistra': ('forbistra',),
'forbistret': ('forbistret',),
'forbistrete': ('forbistret',),
'forbistrede': ('forbistret',),
'forbistrete': ('forbistret',),
'forbistrede': ('forbistret',),
'forbistret': ('forbistret',),
'forbitra': ('forbitra',),
'forbitra': ('forbitre',),
'forbitret': ('forbitre',),
'forbitra': ('forbitre',),
'forbitret': ('forbitre',),
'forbitra': ('forbitre',),
'forbitrete': ('forbitre',),
'forbitrede': ('forbitre',),
'forbitrete': ('forbitre',),
'forbitrede': ('forbitre',),
'forbitra': ('forbitre',),
'forbitrete': ('forbitre',),
'forbitrede': ('forbitre',),
'forbitrete': ('forbitre',),
'forbitrede': ('forbitre',),
'forbitrende': ('forbitre',),
'forbitret': ('forbitret',),
'forbitrete': ('forbitret',),
'forbitrede': ('forbitret',),
'forbitrete': ('forbitret',),
'forbitrede': ('forbitret',),
'forbitret': ('forbitret',),
'forblenda': ('forblende',),
'forblendet': ('forblende',),
'forblenda': ('forblende',),
'forblendet': ('forblende',),
'forblenda': ('forblende',),
'forblendete': ('forblende',),
'forblendede': ('forblende',),
'forblenda': ('forblende',),
'forblendete': ('forblende',),
'forblendede': ('forblende',),
'forblendende': ('forblende',),
'forblitt': ('forbli',),
'forblitte': ('forbli',),
'forblivende': ('forbli',),
'forblinda': ('forblinde',),
'forblindet': ('forblinde',),
'forblinda': ('forblinde',),
'forblindet': ('forblinde',),
'forblinda': ('forblinde',),
'forblindete': ('forblinde',),
'forblindede': ('forblinde',),
'forblinda': ('forblinde',),
'forblindete': ('forblinde',),
'forblindede': ('forblinde',),
'forblindende': ('forblinde',),
'forblomma': ('forblomma',),
'forblommet': ('forblommet',),
'forblommete': ('forblommet',),
'forblommede': ('forblommet',),
'forblommete': ('forblommet',),
'forblommede': ('forblommet',),
'forblommet': ('forblommet',),
'forblåst': ('forblåst',),
'forblåste': ('forblåst',),
'forblåst': ('forblåst',),
'forblødd': ('forblø',),
'forblødde': ('forblø',),
'forbløende': ('forblø',),
'forbløffa': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffete': ('forbløffe',),
'forbløffede': ('forbløffe',),
'forbløffa': ('forbløffe',),
'forbløffete': ('forbløffe',),
'forbløffede': ('forbløffe',),
'forbløffende': ('forbløffe',),
'forbløffende': ('forbløffende',),
'forborgen': ('forborgen',),
'forborgne': ('forborgen',),
'forborgent': ('forborgen',),
'forbrukt': ('forbruke',),
'forbrukte': ('forbruke',),
'forbrukende': ('forbruke',),
'forbrukervennlig': ('forbrukervennlig',),
'forbrukervennlige': ('forbrukervennlig',),
'forbrukervennlig': ('forbrukervennlig',),
'forbrutt': ('forbryte',),
'forbrutte': ('forbryte',),
'forbrytende': ('forbryte',),
'forbrytersk': ('forbrytersk',),
'forbryterske': ('forbrytersk',),
'forbrytersk': ('forbrytersk',),
'forbuden': ('forbuden',),
'forbudne': ('forbuden',),
'forbudent': ('forbuden',),
'forbudt': ('forbudt',),
'forbudte': ('forbudt',),
'forbudt': ('forbudt',),
'forbundsvis': ('forbundsvis',),
'forbundsvise': ('forbundsvis',),
'forbundsvist': ('forbundsvis',),
'forbundsvis': ('forbundsvis',),
'forbydd': ('forby',),
'forbudt': ('forby',),
'forbydd': ('forby',),
'forbudt': ('forby',),
'forbydd': ('forby',),
'forbydde': ('forby',),
'forbudte': ('forby',),
'forbydde': ('forby',),
'forbudte': ('forby',),
'forbydde': ('forby',),
'forbyende': ('forby',),
'forbytta': ('forbytte',),
'forbyttet': ('forbytte',),
'forbytta': ('forbytte',),
'forbyttet': ('forbytte',),
'forbytta': ('forbytte',),
'forbyttete': ('forbytte',),
'forbyttede': ('forbytte',),
'forbytta': ('forbytte',),
'forbyttete': ('forbytte',),
'forbyttede': ('forbytte',),
'forbyttende': ('forbytte',),
'fordampa': ('fordampe',),
'fordampet': ('fordampe',),
'fordampa': ('fordampe',),
'fordampet': ('fordampe',),
'fordampa': ('fordampe',),
'fordampete': ('fordampe',),
'fordampede': ('fordampe',),
'fordampa': ('fordampe',),
'fordampete': ('fordampe',),
'fordampede': ('fordampe',),
'fordampende': ('fordampe',),
'fordanska': ('fordanske',),
'fordansket': ('fordanske',),
'fordanska': ('fordanske',),
'fordansket': ('fordanske',),
'fordanska': ('fordanske',),
'fordanskete': ('fordanske',),
'fordanskede': ('fordanske',),
'fordanska': ('fordanske',),
'fordanskete': ('fordanske',),
'fordanskede': ('fordanske',),
'fordanskende': ('fordanske',),
'fordekt': ('fordekt',),
'fordekte': ('fordekt',),
'fordekt': ('fordekt',),
'fordektig': ('fordektig',),
'fordektige': ('fordektig',),
'fordektig': ('fordektig',),
'fordelaktig': ('fordelaktig',),
'fordelaktige': ('fordelaktig',),
'fordelaktig': ('fordelaktig',),
'fordelt': ('fordele',),
'fordelte': ('fordele',),
'fordelende': ('fordele',),
'forderva': ('forderve',),
'fordervet': ('forderve',),
'forderva': ('forderve',),
'fordervet': ('forderve',),
'forderva': ('forderve',),
'fordervete': ('forderve',),
'fordervede': ('forderve',),
'forderva': ('forderve',),
'fordervete': ('forderve',),
'fordervede': ('forderve',),
'fordervende': ('forderve',),
'fordervelig': ('fordervelig',),
'fordervelige': ('fordervelig',),
'fordervelig': ('fordervelig',),
'fordjupa': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupete': ('fordjupe',),
'fordjupede': ('fordjupe',),
'fordjupa': ('fordjupe',),
'fordjupete': ('fordjupe',),
'fordjupede': ('fordjupe',),
'fordjupende': ('fordjupe',),
'fordobla': ('fordoble',),
'fordoblet': ('fordoble',),
'fordobla': ('fordoble',),
'fordoblet': ('fordoble',),
'fordobla': ('fordoble',),
'fordoblete': ('fordoble',),
'fordoblede': ('fordoble',),
'fordoblete': ('fordoble',),
'fordoblede': ('fordoble',),
'fordobla': ('fordoble',),
'fordoblete': ('fordoble',),
'fordoblede': ('fordoble',),
'fordoblete': ('fordoble',),
'fordoblede': ('fordoble',),
'fordoblende': ('fordoble',),
'fordomsfull': ('fordomsfull',),
'fordomsfulle': ('fordomsfull',),
'fordomsfullt': ('fordomsfull',),
'fordomslaus': ('fordomslaus',),
'fordomslause': ('fordomslaus',),
'fordomslaust': ('fordomslaus',),
'fordomsløs': ('fordomsløs',),
'fordomsløse': ('fordomsløs',),
'fordomsløst': ('fordomsløs',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordradd': ('fordra',),
'fordratt': ('fordra',),
'fordradde': ('fordra',),
'fordratte': ('fordra',),
'fordradde': ('fordra',),
'fordratte': ('fordra',),
'fordradde': ('fordra',),
'fordratte': ('fordra',),
'fordradde': ('fordra',),
'fordratte': ('fordra',),
'fordragende': ('fordra',),
'fordragelig': ('fordragelig',),
'fordragelige': ('fordragelig',),
'fordragelig': ('fordragelig',),
'fordra': ('fordre',),
'fordret': ('fordre',),
'fordra': ('fordre',),
'fordret': ('fordre',),
'fordra': ('fordre',),
'fordrete': ('fordre',),
'fordrede': ('fordre',),
'fordrete': ('fordre',),
'fordrede': ('fordre',),
'fordra': ('fordre',),
'fordrete': ('fordre',),
'fordrede': ('fordre',),
'fordrete': ('fordre',),
'fordrede': ('fordre',),
'fordrende': ('fordre',),
'fordreia': ('fordreie',),
'fordreiet': ('fordreie',),
'fordreid': ('fordreie',),
'fordreia': ('fordreie',),
'fordreiet': ('fordreie',),
'fordreid': ('fordreie',),
'fordreia': ('fordreie',),
'fordreiete': ('fordreie',),
'fordreiede': ('fordreie',),
'fordreide': ('fordreie',),
'fordreia': ('fordreie',),
'fordreiete': ('fordreie',),
'fordreiede': ('fordreie',),
'fordreide': ('fordreie',),
'fordreiende': ('fordreie',),
'fordringsfull': ('fordringsfull',),
'fordringsfulle': ('fordringsfull',),
'fordringsfullt': ('fordringsfull',),
'fordringslaus': ('fordringslaus',),
'fordringslause': ('fordringslaus',),
'fordringslaust': ('fordringslaus',),
'fordringsløs': ('fordringsløs',),
'fordringsløse': ('fordringsløs',),
'fordringsløst': ('fordringsløs',),
'fordrista': ('fordriste',),
'fordristet': ('fordriste',),
'fordrista': ('fordriste',),
'fordristet': ('fordriste',),
'fordrista': ('fordriste',),
'fordristete': ('fordriste',),
'fordristede': ('fordriste',),
'fordrista': ('fordriste',),
'fordristete': ('fordriste',),
'fordristede': ('fordriste',),
'fordristende': ('fordriste',),
'fordrevet': ('fordrive',),
'fordreven': ('fordrive',),
'fordrevne': ('fordrive',),
'fordrivende': ('fordrive',),
'fordrukken': ('fordrukken',),
'fordrukne': ('fordrukken',),
'fordrukkent': ('fordrukken',),
'fordufta': ('fordufte',),
'forduftet': ('fordufte',),
'fordufta': ('fordufte',),
'forduftet': ('fordufte',),
'fordufta': ('fordufte',),
'forduftete': ('fordufte',),
'forduftede': ('fordufte',),
'fordufta': ('fordufte',),
'forduftete': ('fordufte',),
'forduftede': ('fordufte',),
'forduftende': ('fordufte',),
'fordulgt': ('fordulgt',),
'fordulgte': ('fordulgt',),
'fordulgt': ('fordulgt',),
'fordumma': ('fordumme',),
'fordummet': ('fordumme',),
'fordumma': ('fordumme',),
'fordummet': ('fordumme',),
'fordumma': ('fordumme',),
'fordummete': ('fordumme',),
'fordummede': ('fordumme',),
'fordumma': ('fordumme',),
'fordummete': ('fordumme',),
'fordummede': ('fordumme',),
'fordummende': ('fordumme',),
'fordums': ('fordums',),
'fordunkla': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunklete': ('fordunkle',),
'fordunklede': ('fordunkle',),
'fordunklete': ('fordunkle',),
'fordunklede': ('fordunkle',),
'fordunkla': ('fordunkle',),
'fordunklete': ('fordunkle',),
'fordunklede': ('fordunkle',),
'fordunklete': ('fordunkle',),
'fordunklede': ('fordunkle',),
'fordunklende': ('fordunkle',),
'fordunsta': ('fordunste',),
'fordunstet': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunstet': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunstete': ('fordunste',),
'fordunstede': ('fordunste',),
'fordunsta': ('fordunste',),
'fordunstete': ('fordunste',),
'fordunstede': ('fordunste',),
'fordunstende': ('fordunste',),
'fordypa': ('fordype',),
'fordypet': ('fordype',),
'fordypa': ('fordype',),
'fordypet': ('fordype',),
'fordypa': ('fordype',),
'fordypete': ('fordype',),
'fordypede': ('fordype',),
'fordypa': ('fordype',),
'fordypete': ('fordype',),
'fordypede': ('fordype',),
'fordypende': ('fordype',),
'fordyra': ('fordyre',),
'fordyret': ('fordyre',),
'fordyra': ('fordyre',),
'fordyret': ('fordyre',),
'fordyra': ('fordyre',),
'fordyrete': ('fordyre',),
'fordyrede': ('fordyre',),
'fordyra': ('fordyre',),
'fordyrete': ('fordyre',),
'fordyrede': ('fordyre',),
'fordyrende': ('fordyre',),
'fordømt': ('fordømme',),
'fordømte': ('fordømme',),
'fordømmende': ('fordømme',),
'fordømt': ('fordømt',),
'fordømte': ('fordømt',),
'fordømt': ('fordømt',),
'fordøya': ('fordøye',),
'fordøyet': ('fordøye',),
'fordøyd': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyet': ('fordøye',),
'fordøyd': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyete': ('fordøye',),
'fordøyede': ('fordøye',),
'fordøyde': ('fordøye',),
'fordøya': ('fordøye',),
'fordøyete': ('fordøye',),
'fordøyede': ('fordøye',),
'fordøyde': ('fordøye',),
'fordøyende': ('fordøye',),
'fordøyelig': ('fordøyelig',),
'fordøyelige': ('fordøyelig',),
'fordøyelig': ('fordøyelig',),
'forebrakt': ('forebringe',),
'forebrakte': ('forebringe',),
'forebringende': ('forebringe',),
'forebygget': ('forebygge',),
'forebygd': ('forebygge',),
'forebygget': ('forebygge',),
'forebygd': ('forebygge',),
'forebyggete': ('forebygge',),
'forebyggede': ('forebygge',),
'forebygde': ('forebygge',),
'forebyggete': ('forebygge',),
'forebyggede': ('forebygge',),
'forebygde': ('forebygge',),
'forebyggende': ('forebygge',),
'foredla': ('foredle',),
'foredlet': ('foredle',),
'foredla': ('foredle',),
'foredlet': ('foredle',),
'foredla': ('foredle',),
'foredlete': ('foredle',),
'foredlede': ('foredle',),
'foredlete': ('foredle',),
'foredlede': ('foredle',),
'foredla': ('foredle',),
'foredlete': ('foredle',),
'foredlede': ('foredle',),
'foredlete': ('foredle',),
'foredlede': ('foredle',),
'foredlende': ('foredle',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredradd': ('foredra',),
'foredratt': ('foredra',),
'foredradde': ('foredra',),
'foredratte': ('foredra',),
'foredradde': ('foredra',),
'foredratte': ('foredra',),
'foredradde': ('foredra',),
'foredratte': ('foredra',),
'foredradde': ('foredra',),
'foredratte': ('foredra',),
'foredragende': ('foredra',),
'forefalt': ('forefalle',),
'forefalte': ('forefalle',),
'forefallende': ('forefalle',),
'forefallende': ('forefallende',),
'foregitt': ('foregi',),
'foregitte': ('foregi',),
'foregiende': ('foregi',),
'foregrepet': ('foregripe',),
'foregrepen': ('foregripe',),
'foregrepne': ('foregripe',),
'foregripende': ('foregripe',),
'foregått': ('foregå',),
'foregåtte': ('foregå',),
'foregående': ('foregå',),
'foregående': ('foregående',),
'foreholdt': ('foreholde',),
'foreholdte': ('foreholde',),
'foreholdende': ('foreholde',),
'forekommet': ('forekomme',),
'forekommen': ('forekomme',),
'forekomne': ('forekomme',),
'forekommende': ('forekomme',),
'forekommende': ('forekommende',),
'forelda': ('forelda',),
'foreldet': ('foreldet',),
'foreldete': ('foreldet',),
'foreldede': ('foreldet',),
'foreldete': ('foreldet',),
'foreldede': ('foreldet',),
'foreldet': ('foreldet',),
'foreldrelaus': ('foreldrelaus',),
'foreldrelause': ('foreldrelaus',),
'foreldrelaust': ('foreldrelaus',),
'foreldreløs': ('foreldreløs',),
'foreldreløse': ('foreldreløs',),
'foreldreløst': ('foreldreløs',),
'forelagt': ('forelegge',),
'forelagte': ('forelegge',),
'foreleggende': ('forelegge',),
'forelest': ('forelese',),
'foreleste': ('forelese',),
'forelesende': ('forelese',),
'foreligget': ('foreligge',),
'foreliggen': ('foreligge',),
'foreligne': ('foreligge',),
'foreliggende': ('foreligge',),
'forelska': ('forelska',),
'forelska': ('forelske',),
'forelsket': ('forelske',),
'forelska': ('forelske',),
'forelsket': ('forelske',),
'forelska': ('forelske',),
'forelskete': ('forelske',),
'forelskede': ('forelske',),
'forelska': ('forelske',),
'forelskete': ('forelske',),
'forelskede': ('forelske',),
'forelskende': ('forelske',),
'forelsket': ('forelsket',),
'forelskete': ('forelsket',),
'forelskede': ('forelsket',),
'forelskete': ('forelsket',),
'forelskede': ('forelsket',),
'forelsket': ('forelsket',),
'foreløpig': ('foreløpig',),
'foreløpige': ('foreløpig',),
'foreløpig': ('foreløpig',),
'forenet': ('forene',),
'forent': ('forene',),
'forenet': ('forene',),
'forent': ('forene',),
'forenete': ('forene',),
'forenede': ('forene',),
'forente': ('forene',),
'forenete': ('forene',),
'forenede': ('forene',),
'forente': ('forene',),
'forenende': ('forene',),
'forenelig': ('forenelig',),
'forenelige': ('forenelig',),
'forenelig': ('forenelig',),
'forenkla': ('forenkle',),
'forenklet': ('forenkle',),
'forenkla': ('forenkle',),
'forenklet': ('forenkle',),
'forenkla': ('forenkle',),
'forenklete': ('forenkle',),
'forenklede': ('forenkle',),
'forenklete': ('forenkle',),
'forenklede': ('forenkle',),
'forenkla': ('forenkle',),
'forenklete': ('forenkle',),
'forenklede': ('forenkle',),
'forenklete': ('forenkle',),
'forenklede': ('forenkle',),
'forenklende': ('forenkle',),
'forenlig': ('forenlig',),
'forenlige': ('forenlig',),
'forenlig': ('forenlig',),
'foresatt': ('foresatt',),
'foresatte': ('foresatt',),
'foresatt': ('foresatt',),
'foresatt': ('foresette',),
'foresatte': ('foresette',),
'foresettende': ('foresette',),
'foresagt': ('foresi',),
'foresagte': ('foresi',),
'foresiende': ('foresi',),
'foreskrevet': ('foreskrive',),
'foreskreven': ('foreskrive',),
'foreskrevne': ('foreskrive',),
'foreskrivende': ('foreskrive',),
'foreslått': ('foreslå',),
'foreslåtte': ('foreslå',),
'foreslående': ('foreslå',),
'forespeila': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilt': ('forespeile',),
'forespeila': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilt': ('forespeile',),
'forespeila': ('forespeile',),
'forespeilete': ('forespeile',),
'forespeilede': ('forespeile',),
'forespeilte': ('forespeile',),
'forespeila': ('forespeile',),
'forespeilete': ('forespeile',),
'forespeilede': ('forespeile',),
'forespeilte': ('forespeile',),
'forespeilende': ('forespeile',),
'forespurt': ('forespørre',),
'forespurte': ('forespørre',),
'forespørrende': ('forespørre',),
'forestilt': ('forestille',),
'forestilte': ('forestille',),
'forestillende': ('forestille',),
'forestått': ('forestå',),
'foreståtte': ('forestå',),
'forestående': ('forestå',),
'forestående': ('forestående',),
'foresveva': ('foresveve',),
'foresvevet': ('foresveve',),
'foresvevd': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevet': ('foresveve',),
'foresvevd': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevete': ('foresveve',),
'foresvevede': ('foresveve',),
'foresvevde': ('foresveve',),
'foresveva': ('foresveve',),
'foresvevete': ('foresveve',),
'foresvevede': ('foresveve',),
'foresvevde': ('foresveve',),
'foresvevende': ('foresveve',),
'foretatt': ('foreta',),
'foretatte': ('foreta',),
'foretakende': ('foreta',),
'foretaksom': ('foretaksom',),
'foretaksomme': ('foretaksom',),
'foretaksomt': ('foretaksom',),
'foretaksommere': ('foretaksom',),
'foretaksommest': ('foretaksom',),
'foretaksommeste': ('foretaksom',),
'foretrukket': ('foretrekke',),
'foretrukken': ('foretrekke',),
'foretrukne': ('foretrekke',),
'foretrekkende': ('foretrekke',),
'foreviga': ('forevige',),
'foreviget': ('forevige',),
'foreviga': ('forevige',),
'foreviget': ('forevige',),
'foreviga': ('forevige',),
'forevigete': ('forevige',),
'forevigede': ('forevige',),
'foreviga': ('forevige',),
'forevigete': ('forevige',),
'forevigede': ('forevige',),
'forevigende': ('forevige',),
'forevist': ('forevise',),
'foreviste': ('forevise',),
'forevisende': ('forevise',),
'forfalt': ('forfalle',),
'forfalte': ('forfalle',),
'forfallende': ('forfalle',),
'forfallen': ('forfallen',),
'forfalne': ('forfallen',),
'forfallent': ('forfallen',),
'forfalska': ('forfalske',),
'forfalsket': ('forfalske',),
'forfalska': ('forfalske',),
'forfalsket': ('forfalske',),
'forfalska': ('forfalske',),
'forfalskete': ('forfalske',),
'forfalskede': ('forfalske',),
'forfalska': ('forfalske',),
'forfalskete': ('forfalske',),
'forfalskede': ('forfalske',),
'forfalskende': ('forfalske',),
'forfatningsstridig': ('forfatningsstridig',),
'forfatningsstridige': ('forfatningsstridig',),
'forfatningsstridig': ('forfatningsstridig',),
'forfatningstro': ('forfatningstro',),
'forfatningstru': ('forfatningstru',),
'forfatningstrue': ('forfatningstru',),
'forfatningstru': ('forfatningstru',),
'forfatningstrue': ('forfatningstru',),
'forfatningstru': ('forfatningstru',),
'forfatta': ('forfatte',),
'forfattet': ('forfatte',),
'forfatta': ('forfatte',),
'forfattet': ('forfatte',),
'forfatta': ('forfatte',),
'forfattete': ('forfatte',),
'forfattede': ('forfatte',),
'forfatta': ('forfatte',),
'forfattete': ('forfatte',),
'forfattede': ('forfatte',),
'forfattende': ('forfatte',),
'forfeila': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilt': ('forfeile',),
'forfeila': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilt': ('forfeile',),
'forfeila': ('forfeile',),
'forfeilete': ('forfeile',),
'forfeilede': ('forfeile',),
'forfeilte': ('forfeile',),
'forfeila': ('forfeile',),
'forfeilete': ('forfeile',),
'forfeilede': ('forfeile',),
'forfeilte': ('forfeile',),
'forfeilende': ('forfeile',),
'forfekta': ('forfekte',),
'forfektet': ('forfekte',),
'forfekta': ('forfekte',),
'forfektet': ('forfekte',),
'forfekta': ('forfekte',),
'forfektete': ('forfekte',),
'forfektede': ('forfekte',),
'forfekta': ('forfekte',),
'forfektete': ('forfekte',),
'forfektede': ('forfekte',),
'forfektende': ('forfekte',),
'forfengelig': ('forfengelig',),
'forfengelige': ('forfengelig',),
'forfengelig': ('forfengelig',),
'forferda': ('forferde',),
'forferdet': ('forferde',),
'forferda': ('forferde',),
'forferdet': ('forferde',),
'forferda': ('forferde',),
'forferdete': ('forferde',),
'forferdede': ('forferde',),
'forferda': ('forferde',),
'forferdete': ('forferde',),
'forferdede': ('forferde',),
'forferdende': ('forferde',),
'forferdelig': ('forferdelig',),
'forferdelige': ('forferdelig',),
'forferdelig': ('forferdelig',),
'forferdiga': ('forferdige',),
'forferdiget': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdiget': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdigete': ('forferdige',),
'forferdigede': ('forferdige',),
'forferdiga': ('forferdige',),
'forferdigete': ('forferdige',),
'forferdigede': ('forferdige',),
'forferdigende': ('forferdige',),
'forfina': ('forfina',),
'forfina': ('forfine',),
'forfinet': ('forfine',),
'forfina': ('forfine',),
'forfinet': ('forfine',),
'forfina': ('forfine',),
'forfinete': ('forfine',),
'forfinede': ('forfine',),
'forfina': ('forfine',),
'forfinete': ('forfine',),
'forfinede': ('forfine',),
'forfinende': ('forfine',),
'forfinet': ('forfinet',),
'forfinete': ('forfinet',),
'forfinede': ('forfinet',),
'forfinete': ('forfinet',),
'forfinede': ('forfinet',),
'forfinet': ('forfinet',),
'forfjamsa': ('forfjamsa',),
'forfjamsa': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamsete': ('forfjamse',),
'forfjamsede': ('forfjamse',),
'forfjamsa': ('forfjamse',),
'forfjamsete': ('forfjamse',),
'forfjamsede': ('forfjamse',),
'forfjamsende': ('forfjamse',),
'forfjamset': ('forfjamset',),
'forfjamsete': ('forfjamset',),
'forfjamsede': ('forfjamset',),
'forfjamsete': ('forfjamset',),
'forfjamsede': ('forfjamset',),
'forfjamset': ('forfjamset',),
'forfjetra': ('forfjetra',),
'forfjetret': ('forfjetret',),
'forfjetrete': ('forfjetret',),
'forfjetrede': ('forfjetret',),
'forfjetrete': ('forfjetret',),
'forfjetrede': ('forfjetret',),
'forfjetret': ('forfjetret',),
'forflata': ('forflate',),
'forflatet': ('forflate',),
'forflata': ('forflate',),
'forflatet': ('forflate',),
'forflata': ('forflate',),
'forflatete': ('forflate',),
'forflatede': ('forflate',),
'forflata': ('forflate',),
'forflatete': ('forflate',),
'forflatede': ('forflate',),
'forflatende': ('forflate',),
'forflera': ('forflere',),
'forfleret': ('forflere',),
'forflert': ('forflere',),
'forflera': ('forflere',),
'forfleret': ('forflere',),
'forflert': ('forflere',),
'forflera': ('forflere',),
'forflerete': ('forflere',),
'forflerede': ('forflere',),
'forflerte': ('forflere',),
'forflera': ('forflere',),
'forflerete': ('forflere',),
'forflerede': ('forflere',),
'forflerte': ('forflere',),
'forflerende': ('forflere',),
'forflytta': ('forflytte',),
'forflyttet': ('forflytte',),
'forflytta': ('forflytte',),
'forflyttet': ('forflytte',),
'forflytta': ('forflytte',),
'forflyttete': ('forflytte',),
'forflyttede': ('forflytte',),
'forflytta': ('forflytte',),
'forflyttete': ('forflytte',),
'forflyttede': ('forflytte',),
'forflyttende': ('forflytte',),
'forfløyen': ('forfløyen',),
'forfløyne': ('forfløyen',),
'forfløyent': ('forfløyen',),
'forfordelt': ('forfordele',),
'forfordelte': ('forfordele',),
'forfordelende': ('forfordele',),
'forfremma': ('forfremme',),
'forfremmet': ('forfremme',),
'forfremma': ('forfremme',),
'forfremmet': ('forfremme',),
'forfremma': ('forfremme',),
'forfremmete': ('forfremme',),
'forfremmede': ('forfremme',),
'forfremma': ('forfremme',),
'forfremmete': ('forfremme',),
'forfremmede': ('forfremme',),
'forfremmende': ('forfremme',),
'forfriska': ('forfriske',),
'forfrisket': ('forfriske',),
'forfriska': ('forfriske',),
'forfrisket': ('forfriske',),
'forfriska': ('forfriske',),
'forfriskete': ('forfriske',),
'forfriskede': ('forfriske',),
'forfriska': ('forfriske',),
'forfriskete': ('forfriske',),
'forfriskede': ('forfriske',),
'forfriskende': ('forfriske',),
'forfrosset': ('forfryse',),
'forfrossen': ('forfryse',),
'forfrosset': ('forfryse',),
'forfrossen': ('forfryse',),
'forfrosne': ('forfryse',),
'forfrysende': ('forfryse',),
'forfylla': ('forfylla',),
'forfyllet': ('forfyllet',),
'forfyllete': ('forfyllet',),
'forfyllede': ('forfyllet',),
'forfyllete': ('forfyllet',),
'forfyllede': ('forfyllet',),
'forfyllet': ('forfyllet',),
'forfulgt': ('forfølge',),
'forfulgte': ('forfølge',),
'forfølgende': ('forfølge',),
'forført': ('forføre',),
'forførte': ('forføre',),
'forførende': ('forføre',),
'forførerisk': ('forførerisk',),
'forføreriske': ('forførerisk',),
'forførerisk': ('forførerisk',),
'forføya': ('forføye',),
'forføyet': ('forføye',),
'forføyd': ('forføye',),
'forføya': ('forføye',),
'forføyet': ('forføye',),
'forføyd': ('forføye',),
'forføya': ('forføye',),
'forføyete': ('forføye',),
'forføyede': ('forføye',),
'forføyde': ('forføye',),
'forføya': ('forføye',),
'forføyete': ('forføye',),
'forføyede': ('forføye',),
'forføyde': ('forføye',),
'forføyende': ('forføye',),
'forgangen': ('forgangen',),
'forgangne': ('forgangen',),
'forgangent': ('forgangen',),
'forgapa': ('forgape',),
'forgapt': ('forgape',),
'forgapa': ('forgape',),
'forgapt': ('forgape',),
'forgapa': ('forgape',),
'forgapte': ('forgape',),
'forgapa': ('forgape',),
'forgapte': ('forgape',),
'forgapende': ('forgape',),
'forgassa': ('forgasse',),
'forgasset': ('forgasse',),
'forgassa': ('forgasse',),
'forgasset': ('forgasse',),
'forgassa': ('forgasse',),
'forgassete': ('forgasse',),
'forgassede': ('forgasse',),
'forgassa': ('forgasse',),
'forgassete': ('forgasse',),
'forgassede': ('forgasse',),
'forgassende': ('forgasse',),
'forgitt': ('forgi',),
'forgitte': ('forgi',),
'forgiende': ('forgi',),
'forgifta': ('forgifte',),
'forgiftet': ('forgifte',),
'forgifta': ('forgifte',),
'forgiftet': ('forgifte',),
'forgifta': ('forgifte',),
'forgiftete': ('forgifte',),
'forgiftede': ('forgifte',),
'forgifta': ('forgifte',),
'forgiftete': ('forgifte',),
'forgiftede': ('forgifte',),
'forgiftende': ('forgifte',),
'forgjelda': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjeldete': ('forgjelde',),
'forgjeldede': ('forgjelde',),
'forgjelda': ('forgjelde',),
'forgjeldete': ('forgjelde',),
'forgjeldede': ('forgjelde',),
'forgjeldende': ('forgjelde',),
'forgjengelig': ('forgjengelig',),
'forgjengelige': ('forgjengelig',),
'forgjengelig': ('forgjengelig',),
'forgjeves': ('forgjeves',),
'forgjort': ('forgjøre',),
'forgjorte': ('forgjøre',),
'forgjørende': ('forgjøre',),
'forglemt': ('forglemme',),
'forglemte': ('forglemme',),
'forglemmende': ('forglemme',),
'forglømt': ('forglømme',),
'forglømte': ('forglømme',),
'forglømmende': ('forglømme',),
'forgreina': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreint': ('forgreine',),
'forgreina': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreint': ('forgreine',),
'forgreina': ('forgreine',),
'forgreinete': ('forgreine',),
'forgreinede': ('forgreine',),
'forgreinte': ('forgreine',),
'forgreina': ('forgreine',),
'forgreinete': ('forgreine',),
'forgreinede': ('forgreine',),
'forgreinte': ('forgreine',),
'forgreinende': ('forgreine',),
'forgremma': ('forgremma',),
'forgremmet': ('forgremmet',),
'forgremmete': ('forgremmet',),
'forgremmede': ('forgremmet',),
'forgremmete': ('forgremmet',),
'forgremmede': ('forgremmet',),
'forgremmet': ('forgremmet',),
'forgremt': ('forgremt',),
'forgremte': ('forgremt',),
'forgremt': ('forgremt',),
'forgrena': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrent': ('forgrene',),
'forgrena': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrent': ('forgrene',),
'forgrena': ('forgrene',),
'forgrenete': ('forgrene',),
'forgrenede': ('forgrene',),
'forgrente': ('forgrene',),
'forgrena': ('forgrene',),
'forgrenete': ('forgrene',),
'forgrenede': ('forgrene',),
'forgrente': ('forgrene',),
'forgrenende': ('forgrene',),
'forgrepet': ('forgripe',),
'forgrepen': ('forgripe',),
'forgrepne': ('forgripe',),
'forgripende': ('forgripe',),
'forgrova': ('forgrove',),
'forgrovet': ('forgrove',),
'forgrova': ('forgrove',),
'forgrovet': ('forgrove',),
'forgrova': ('forgrove',),
'forgrovete': ('forgrove',),
'forgrovede': ('forgrove',),
'forgrova': ('forgrove',),
'forgrovete': ('forgrove',),
'forgrovede': ('forgrove',),
'forgrovende': ('forgrove',),
'forgrått': ('forgrått',),
'forgråtte': ('forgrått',),
'forgrått': ('forgrått',),
'forgubba': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbete': ('forgubbe',),
'forgubbede': ('forgubbe',),
'forgubba': ('forgubbe',),
'forgubbete': ('forgubbe',),
'forgubbede': ('forgubbe',),
'forgubbende': ('forgubbe',),
'forguda': ('forgude',),
'forgudet': ('forgude',),
'forguda': ('forgude',),
'forgudet': ('forgude',),
'forguda': ('forgude',),
'forgudete': ('forgude',),
'forgudede': ('forgude',),
'forguda': ('forgude',),
'forgudete': ('forgude',),
'forgudede': ('forgude',),
'forgudende': ('forgude',),
'forgyllet': ('forgylle',),
'forgylt': ('forgylle',),
'forgyllet': ('forgylle',),
'forgylt': ('forgylle',),
'forgyllete': ('forgylle',),
'forgyllede': ('forgylle',),
'forgylte': ('forgylle',),
'forgyllete': ('forgylle',),
'forgyllede': ('forgylle',),
'forgylte': ('forgylle',),
'forgyllende': ('forgylle',),
'forgått': ('forgå',),
'forgåtte': ('forgå',),
'forgående': ('forgå',),
'forhala': ('forhale',),
'forhalet': ('forhale',),
'forhalt': ('forhale',),
'forhala': ('forhale',),
'forhalet': ('forhale',),
'forhalt': ('forhale',),
'forhala': ('forhale',),
'forhalete': ('forhale',),
'forhalede': ('forhale',),
'forhalte': ('forhale',),
'forhala': ('forhale',),
'forhalete': ('forhale',),
'forhalede': ('forhale',),
'forhalte': ('forhale',),
'forhalende': ('forhale',),
'forhandla': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandla': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandla': ('forhandle',),
'forhandlete': ('forhandle',),
'forhandlede': ('forhandle',),
'forhandlete': ('forhandle',),
'forhandlede': ('forhandle',),
'forhandla': ('forhandle',),
'forhandlete': ('forhandle',),
'forhandlede': ('forhandle',),
'forhandlete': ('forhandle',),
'forhandlede': ('forhandle',),
'forhandlende': ('forhandle',),
'forhandsbestilt': ('forhandsbestille',),
'forhandsbestilte': ('forhandsbestille',),
'forhandsbestillende': ('forhandsbestille',),
'forhandsomtalt': ('forhandsomtale',),
'forhandsomtalte': ('forhandsomtale',),
'forhandsomtalende': ('forhandsomtale',),
'forhandsstemt': ('forhandsstemme',),
'forhandsstemte': ('forhandsstemme',),
'forhandsstemmende': ('forhandsstemme',),
'forhasta': ('forhaste',),
'forhastet': ('forhaste',),
'forhasta': ('forhaste',),
'forhastet': ('forhaste',),
'forhasta': ('forhaste',),
'forhastete': ('forhaste',),
'forhastede': ('forhaste',),
'forhasta': ('forhaste',),
'forhastete': ('forhaste',),
'forhastede': ('forhaste',),
'forhastende': ('forhaste',),
'forhatt': ('forhatt',),
'forhatte': ('forhatt',),
'forhatt': ('forhatt',),
'forheksa': ('forhekse',),
'forhekset': ('forhekse',),
'forheksa': ('forhekse',),
'forhekset': ('forhekse',),
'forheksa': ('forhekse',),
'forheksete': ('forhekse',),
'forheksede': ('forhekse',),
'forheksa': ('forhekse',),
'forheksete': ('forhekse',),
'forheksede': ('forhekse',),
'forheksende': ('forhekse',),
'forhenværende': ('forhenværende',),
'forherda': ('forherde',),
'forherdet': ('forherde',),
'forherda': ('forherde',),
'forherdet': ('forherde',),
'forherda': ('forherde',),
'forherdete': ('forherde',),
'forherdede': ('forherde',),
'forherda': ('forherde',),
'forherdete': ('forherde',),
'forherdede': ('forherde',),
'forherdende': ('forherde',),
'forherliga': ('forherlige',),
'forherliget': ('forherlige',),
'forherliga': ('forherlige',),
'forherliget': ('forherlige',),
'forherliga': ('forherlige',),
'forherligete': ('forherlige',),
'forherligede': ('forherlige',),
'forherliga': ('forherlige',),
'forherligete': ('forherlige',),
'forherligede': ('forherlige',),
'forherligende': ('forherlige',),
'forhindra': ('forhindre',),
'forhindret': ('forhindre',),
'forhindra': ('forhindre',),
'forhindret': ('forhindre',),
'forhindra': ('forhindre',),
'forhindrete': ('forhindre',),
'forhindrede': ('forhindre',),
'forhindrete': ('forhindre',),
'forhindrede': ('forhindre',),
'forhindra': ('forhindre',),
'forhindrete': ('forhindre',),
'forhindrede': ('forhindre',),
'forhindrete': ('forhindre',),
'forhindrede': ('forhindre',),
'forhindrende': ('forhindre',),
'forhippen': ('forhippen',),
'forhipne': ('forhippen',),
'forhippent': ('forhippen',),
'forhistorisk': ('forhistorisk',),
'forhistoriske': ('forhistorisk',),
'forhistorisk': ('forhistorisk',),
'forhjulsdrevet': ('forhjulsdrevet',),
'forhjulsdrevne': ('forhjulsdrevet',),
'forhjulsdrevet': ('forhjulsdrevet',),
'forholdt': ('forholde',),
'forholdte': ('forholde',),
'forholdende': ('forholde',),
'forholdsmessig': ('forholdsmessig',),
'forholdsmessige': ('forholdsmessig',),
'forholdsmessig': ('forholdsmessig',),
'forhutla': ('forhutla',),
'forhutlet': ('forhutlet',),
'forhutlete': ('forhutlet',),
'forhutlede': ('forhutlet',),
'forhutlete': ('forhutlet',),
'forhutlede': ('forhutlet',),
'forhutlet': ('forhutlet',),
'forhyra': ('forhyre',),
'forhyret': ('forhyre',),
'forhyrt': ('forhyre',),
'forhyra': ('forhyre',),
'forhyret': ('forhyre',),
'forhyrt': ('forhyre',),
'forhyra': ('forhyre',),
'forhyrete': ('forhyre',),
'forhyrede': ('forhyre',),
'forhyrte': ('forhyre',),
'forhyra': ('forhyre',),
'forhyrete': ('forhyre',),
'forhyrede': ('forhyre',),
'forhyrte': ('forhyre',),
'forhyrende': ('forhyre',),
'forhåndsbestilt': ('forhåndsbestille',),
'forhåndsbestilte': ('forhåndsbestille',),
'forhåndsbestillende': ('forhåndsbestille',),
'forhåndsomtalt': ('forhåndsomtale',),
'forhåndsomtalte': ('forhåndsomtale',),
'forhåndsomtalende': ('forhåndsomtale',),
'forhåndsstemt': ('forhåndsstemme',),
'forhåndsstemte': ('forhåndsstemme',),
'forhåndsstemmende': ('forhåndsstemme',),
'forhåna': ('forhåne',),
'forhånet': ('forhåne',),
'forhånt': ('forhåne',),
'forhåna': ('forhåne',),
'forhånet': ('forhåne',),
'forhånt': ('forhåne',),
'forhåna': ('forhåne',),
'forhånete': ('forhåne',),
'forhånede': ('forhåne',),
'forhånte': ('forhåne',),
'forhåna': ('forhåne',),
'forhånete': ('forhåne',),
'forhånede': ('forhåne',),
'forhånte': ('forhåne',),
'forhånende': ('forhåne',),
'forhåpningsfull': ('forhåpningsfull',),
'forhåpningsfulle': ('forhåpningsfull',),
'forhåpningsfullt': ('forhåpningsfull',),
'forhørt': ('forhøre',),
'forhørte': ('forhøre',),
'forhørende': ('forhøre',),
'forhøya': ('forhøye',),
'forhøyet': ('forhøye',),
'forhøyd': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyet': ('forhøye',),
'forhøyd': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyete': ('forhøye',),
'forhøyede': ('forhøye',),
'forhøyde': ('forhøye',),
'forhøya': ('forhøye',),
'forhøyete': ('forhøye',),
'forhøyede': ('forhøye',),
'forhøyde': ('forhøye',),
'forhøyende': ('forhøye',),
'forivra': ('forivre',),
'forivret': ('forivre',),
'forivra': ('forivre',),
'forivret': ('forivre',),
'forivra': ('forivre',),
'forivrete': ('forivre',),
'forivrede': ('forivre',),
'forivrete': ('forivre',),
'forivrede': ('forivre',),
'forivra': ('forivre',),
'forivrete': ('forivre',),
'forivrede': ('forivre',),
'forivrete': ('forivre',),
'forivrede': ('forivre',),
'forivrende': ('forivre',),
'forjaga': ('forjaga',),
'forjagd': ('forjagd',),
'forjagde': ('forjagd',),
'forjagd': ('forjagd',),
'forjaget': ('forjaget',),
'forjagete': ('forjaget',),
'forjagede': ('forjaget',),
'forjagete': ('forjaget',),
'forjagede': ('forjaget',),
'forjaget': ('forjaget',),
'forjetta': ('forjette',),
'forjettet': ('forjette',),
'forjetta': ('forjette',),
'forjettet': ('forjette',),
'forjetta': ('forjette',),
'forjettete': ('forjette',),
'forjettede': ('forjette',),
'forjetta': ('forjette',),
'forjettete': ('forjette',),
'forjettede': ('forjette',),
'forjettende': ('forjette',),
'forkalka': ('forkalke',),
'forkalket': ('forkalke',),
'forkalka': ('forkalke',),
'forkalket': ('forkalke',),
'forkalka': ('forkalke',),
'forkalkete': ('forkalke',),
'forkalkede': ('forkalke',),
'forkalka': ('forkalke',),
'forkalkete': ('forkalke',),
'forkalkede': ('forkalke',),
'forkalkende': ('forkalke',),
'forkasta': ('forkaste',),
'forkastet': ('forkaste',),
'forkasta': ('forkaste',),
'forkastet': ('forkaste',),
'forkasta': ('forkaste',),
'forkastete': ('forkaste',),
'forkastede': ('forkaste',),
'forkasta': ('forkaste',),
'forkastete': ('forkaste',),
'forkastede': ('forkaste',),
'forkastende': ('forkaste',),
'forkastelig': ('forkastelig',),
'forkastelige': ('forkastelig',),
'forkastelig': ('forkastelig',),
'forkava': ('forkava',),
'forkavd': ('forkavd',),
'forkavde': ('forkavd',),
'forkavd': ('forkavd',),
'forkavet': ('forkavet',),
'forkavete': ('forkavet',),
'forkavede': ('forkavet',),
'forkavete': ('forkavet',),
'forkavede': ('forkavet',),
'forkavet': ('forkavet',),
'forkjetra': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetrete': ('forkjetre',),
'forkjetrede': ('forkjetre',),
'forkjetrete': ('forkjetre',),
'forkjetrede': ('forkjetre',),
'forkjetra': ('forkjetre',),
'forkjetrete': ('forkjetre',),
'forkjetrede': ('forkjetre',),
'forkjetrete': ('forkjetre',),
'forkjetrede': ('forkjetre',),
'forkjetrende': ('forkjetre',),
'forkjælt': ('forkjæle',),
'forkjælte': ('forkjæle',),
'forkjælende': ('forkjæle',),
'forkjært': ('forkjært',),
'forkjærte': ('forkjært',),
'forkjært': ('forkjært',),
'forkjøla': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølt': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølt': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjølete': ('forkjøle',),
'forkjølede': ('forkjøle',),
'forkjølte': ('forkjøle',),
'forkjøla': ('forkjøle',),
'forkjølete': ('forkjøle',),
'forkjølede': ('forkjøle',),
'forkjølte': ('forkjøle',),
'forkjølende': ('forkjøle',),
'forkjøpt': ('forkjøpe',),
'forkjøpte': ('forkjøpe',),
'forkjøpende': ('forkjøpe',),
'forklart': ('forklare',),
'forklarte': ('forklare',),
'forklarende': ('forklare',),
'forklaret': ('forklaret',),
'forklarete': ('forklaret',),
'forklarede': ('forklaret',),
'forklarete': ('forklaret',),
'forklarede': ('forklaret',),
'forklaret': ('forklaret',),
'forklarlig': ('forklarlig',),
'forklarlige': ('forklarlig',),
'forklarlig': ('forklarlig',),
'forkledd': ('forkle',),
'forkledde': ('forkle',),
'forkleende': ('forkle',),
'forkleina': ('forkleine',),
'forkleinet': ('forkleine',),
'forkleina': ('forkleine',),
'forkleinet': ('forkleine',),
'forkleina': ('forkleine',),
'forkleinete': ('forkleine',),
'forkleinede': ('forkleine',),
'forkleina': ('forkleine',),
'forkleinete': ('forkleine',),
'forkleinede': ('forkleine',),
'forkleinende': ('forkleine',),
'forkludra': ('forkludre',),
'forkludret': ('forkludre',),
'forkludra': ('forkludre',),
'forkludret': ('forkludre',),
'forkludra': ('forkludre',),
'forkludrete': ('forkludre',),
'forkludrede': ('forkludre',),
'forkludrete': ('forkludre',),
'forkludrede': ('forkludre',),
'forkludra': ('forkludre',),
'forkludrete': ('forkludre',),
'forkludrede': ('forkludre',),
'forkludrete': ('forkludre',),
'forkludrede': ('forkludre',),
'forkludrende': ('forkludre',),
'forknytt': ('forknytt',),
'forknytte': ('forknytt',),
'forknytt': ('forknytt',),
'forkobra': ('forkobre',),
'forkobret': ('forkobre',),
'forkobra': ('forkobre',),
'forkobret': ('forkobre',),
'forkobra': ('forkobre',),
'forkobrete': ('forkobre',),
'forkobrede': ('forkobre',),
'forkobrete': ('forkobre',),
'forkobrede': ('forkobre',),
'forkobra': ('forkobre',),
'forkobrete': ('forkobre',),
'forkobrede': ('forkobre',),
'forkobrete': ('forkobre',),
'forkobrede': ('forkobre',),
'forkobrende': ('forkobre',),
'forkommet': ('forkomme',),
'forkommen': ('forkomme',),
'forkomne': ('forkomme',),
'forkommende': ('forkomme',),
'forkommen': ('forkommen',),
'forkomne': ('forkommen',),
'forkomment': ('forkommen',),
'forkopra': ('forkopre',),
'forkopret': ('forkopre',),
'forkopra': ('forkopre',),
'forkopret': ('forkopre',),
'forkopra': ('forkopre',),
'forkoprete': ('forkopre',),
'forkoprede': ('forkopre',),
'forkoprete': ('forkopre',),
'forkoprede': ('forkopre',),
'forkopra': ('forkopre',),
'forkoprete': ('forkopre',),
'forkoprede': ('forkopre',),
'forkoprete': ('forkopre',),
'forkoprede': ('forkopre',),
'forkoprende': ('forkopre',),
'forkorta': ('forkorte',),
'forkortet': ('forkorte',),
'forkorta': ('forkorte',),
'forkortet': ('forkorte',),
'forkorta': ('forkorte',),
'forkortete': ('forkorte',),
'forkortede': ('forkorte',),
'forkorta': ('forkorte',),
'forkortete': ('forkorte',),
'forkortede': ('forkorte',),
'forkortende': ('forkorte',),
'forkromma': ('forkromme',),
'forkrommet': ('forkromme',),
'forkromma': ('forkromme',),
'forkrommet': ('forkromme',),
'forkromma': ('forkromme',),
'forkrommete': ('forkromme',),
'forkrommede': ('forkromme',),
'forkromma': ('forkromme',),
'forkrommete': ('forkromme',),
'forkrommede': ('forkromme',),
'forkrommende': ('forkromme',),
'forkrøpla': ('forkrøpla',),
'forkrøplet': ('forkrøplet',),
'forkrøplete': ('forkrøplet',),
'forkrøplede': ('forkrøplet',),
'forkrøplete': ('forkrøplet',),
'forkrøplede': ('forkrøplet',),
'forkrøplet': ('forkrøplet',),
'forkua': ('forkue',),
'forkuet': ('forkue',),
'forkua': ('forkue',),
'forkuet': ('forkue',),
'forkua': ('forkue',),
'forkuete': ('forkue',),
'forkuede': ('forkue',),
'forkua': ('forkue',),
'forkuete': ('forkue',),
'forkuede': ('forkue',),
'forkuende': ('forkue',),
'forkulla': ('forkulle',),
'forkullet': ('forkulle',),
'forkulla': ('forkulle',),
'forkullet': ('forkulle',),
'forkulla': ('forkulle',),
'forkullete': ('forkulle',),
'forkullede': ('forkulle',),
'forkulla': ('forkulle',),
'forkullete': ('forkulle',),
'forkullede': ('forkulle',),
'forkullende': ('forkulle',),
'forkvakla': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvaklete': ('forkvakle',),
'forkvaklede': ('forkvakle',),
'forkvaklete': ('forkvakle',),
'forkvaklede': ('forkvakle',),
'forkvakla': ('forkvakle',),
'forkvaklete': ('forkvakle',),
'forkvaklede': ('forkvakle',),
'forkvaklete': ('forkvakle',),
'forkvaklede': ('forkvakle',),
'forkvaklende': ('forkvakle',),
'forkynt': ('forkynne',),
'forkynte': ('forkynne',),
'forkynnende': ('forkynne',),
'forlangt': ('forlange',),
'forlangte': ('forlange',),
'forlangende': ('forlange',),
'forlatt': ('forlate',),
'forlatte': ('forlate',),
'forlatende': ('forlate',),
'forlatt': ('forlatt',),
'forlatte': ('forlatt',),
'forlatt': ('forlatt',),
'forleda': ('forlede',),
'forledet': ('forlede',),
'forleda': ('forlede',),
'forledet': ('forlede',),
'forleda': ('forlede',),
'forledete': ('forlede',),
'forledede': ('forlede',),
'forleda': ('forlede',),
'forledete': ('forlede',),
'forledede': ('forlede',),
'forledende': ('forlede',),
'forleden': ('forleden',),
'forlegen': ('forlegen',),
'forlegne': ('forlegen',),
'forlegent': ('forlegen',),
'forlagt': ('forlegge',),
'forlagte': ('forlegge',),
'forleggende': ('forlegge',),
'forlenga': ('forlenge',),
'forlenget': ('forlenge',),
'forlenga': ('forlenge',),
'forlenget': ('forlenge',),
'forlenga': ('forlenge',),
'forlengete': ('forlenge',),
'forlengede': ('forlenge',),
'forlenga': ('forlenge',),
'forlengete': ('forlenge',),
'forlengede': ('forlenge',),
'forlengende': ('forlenge',),
'forlest': ('forlese',),
'forleste': ('forlese',),
'forlesende': ('forlese',),
'forlibt': ('forlibe',),
'forlibte': ('forlibe',),
'forlibende': ('forlibe',),
'forlikt': ('forlike',),
'forlikte': ('forlike',),
'forlikende': ('forlike',),
'forlikelig': ('forlikelig',),
'forlikelige': ('forlikelig',),
'forlikelig': ('forlikelig',),
'forlist': ('forlise',),
'forliste': ('forlise',),
'forlisende': ('forlise',),
'forlodds': ('forlodds',),
'forlokka': ('forlokke',),
'forlokket': ('forlokke',),
'forlokka': ('forlokke',),
'forlokket': ('forlokke',),
'forlokka': ('forlokke',),
'forlokkete': ('forlokke',),
'forlokkede': ('forlokke',),
'forlokka': ('forlokke',),
'forlokkete': ('forlokke',),
'forlokkede': ('forlokke',),
'forlokkende': ('forlokke',),
'forlokkende': ('forlokkende',),
'forloren': ('forloren',),
'forlorne': ('forloren',),
'forlorent': ('forloren',),
'forlova': ('forlove',),
'forlovet': ('forlove',),
'forlova': ('forlove',),
'forlovet': ('forlove',),
'forlova': ('forlove',),
'forlovete': ('forlove',),
'forlovede': ('forlove',),
'forlova': ('forlove',),
'forlovete': ('forlove',),
'forlovede': ('forlove',),
'forlovende': ('forlove',),
'forlydt': ('forlyde',),
'forlydte': ('forlyde',),
'forlydende': ('forlyde',),
'forlysta': ('forlyste',),
'forlystet': ('forlyste',),
'forlysta': ('forlyste',),
'forlystet': ('forlyste',),
'forlysta': ('forlyste',),
'forlystete': ('forlyste',),
'forlystede': ('forlyste',),
'forlysta': ('forlyste',),
'forlystete': ('forlyste',),
'forlystede': ('forlyste',),
'forlystende': ('forlyste',),
'forløfta': ('forløfte',),
'forløftet': ('forløfte',),
'forløfta': ('forløfte',),
'forløftet': ('forløfte',),
'forløfta': ('forløfte',),
'forløftete': ('forløfte',),
'forløftede': ('forløfte',),
'forløfta': ('forløfte',),
'forløftete': ('forløfte',),
'forløftede': ('forløfte',),
'forløftende': ('forløfte',),
'forløpt': ('forløpe',),
'forløpet': ('forløpe',),
'forløpt': ('forløpe',),
'forløpet': ('forløpe',),
'forløpte': ('forløpe',),
'forløpende': ('forløpe',),
'forløpen': ('forløpen',),
'forløpne': ('forløpen',),
'forløpent': ('forløpen',),
'forløst': ('forløse',),
'forløste': ('forløse',),
'forløsende': ('forløse',),
'forløyet': ('forløyet',),
'forløyne': ('forløyet',),
'forløyet': ('forløyet',),
'forløyst': ('forløyse',),
'forløyste': ('forløyse',),
'forløysende': ('forløyse',),
'formal': ('formal',),
'formale': ('formal',),
'formalt': ('formal',),
'formaldannende': ('formaldannende',),
'formalt': ('formale',),
'formalte': ('formale',),
'formalende': ('formale',),
'formalisert': ('formalisere',),
'formaliserte': ('formalisere',),
'formaliserende': ('formalisere',),
'formalistisk': ('formalistisk',),
'formalistiske': ('formalistisk',),
'formalistisk': ('formalistisk',),
'formana': ('formane',),
'formanet': ('formane',),
'formant': ('formane',),
'formana': ('formane',),
'formanet': ('formane',),
'formant': ('formane',),
'formana': ('formane',),
'formanete': ('formane',),
'formanede': ('formane',),
'formante': ('formane',),
'formana': ('formane',),
'formanete': ('formane',),
'formanede': ('formane',),
'formante': ('formane',),
'formanende': ('formane',),
'formasta': ('formaste',),
'formastet': ('formaste',),
'formasta': ('formaste',),
'formastet': ('formaste',),
'formasta': ('formaste',),
'formastete': ('formaste',),
'formastede': ('formaste',),
'formasta': ('formaste',),
'formastete': ('formaste',),
'formastede': ('formaste',),
'formastende': ('formaste',),
'formastelig': ('formastelig',),
'formastelige': ('formastelig',),
'formastelig': ('formastelig',),
'formatert': ('formatere',),
'formaterte': ('formatere',),
'formaterende': ('formatere',),
'formativ': ('formativ',),
'formative': ('formativ',),
'formativt': ('formativ',),
'forma': ('forme',),
'formet': ('forme',),
'forma': ('forme',),
'formet': ('forme',),
'forma': ('forme',),
'formete': ('forme',),
'formede': ('forme',),
'forma': ('forme',),
'formete': ('forme',),
'formede': ('forme',),
'formende': ('forme',),
'formell': ('formell',),
'formelle': ('formell',),
'formelt': ('formell',),
'forment': ('formene',),
'formente': ('formene',),
'formenende': ('formene',),
'formentlig': ('formentlig',),
'formentlige': ('formentlig',),
'formentlig': ('formentlig',),
'formert': ('formere',),
'formerte': ('formere',),
'formerende': ('formere',),
'formfullendt': ('formfullendt',),
'formfullendte': ('formfullendt',),
'formfullendt': ('formfullendt',),
'formgitt': ('formgi',),
'formgitte': ('formgi',),
'formgiende': ('formgi',),
'formidabel': ('formidabel',),
'formidable': ('formidabel',),
'formidabelt': ('formidabel',),
'formidla': ('formidle',),
'formidlet': ('formidle',),
'formidla': ('formidle',),
'formidlet': ('formidle',),
'formidla': ('formidle',),
'formidlete': ('formidle',),
'formidlede': ('formidle',),
'formidlete': ('formidle',),
'formidlede': ('formidle',),
'formidla': ('formidle',),
'formidlete': ('formidle',),
'formidlede': ('formidle',),
'formidlete': ('formidle',),
'formidlede': ('formidle',),
'formidlende': ('formidle',),
'formilda': ('formilde',),
'formildet': ('formilde',),
'formilda': ('formilde',),
'formildet': ('formilde',),
'formilda': ('formilde',),
'formildete': ('formilde',),
'formildede': ('formilde',),
'formilda': ('formilde',),
'formildete': ('formilde',),
'formildede': ('formilde',),
'formildende': ('formilde',),
'forminska': ('forminske',),
'forminsket': ('forminske',),
'forminska': ('forminske',),
'forminsket': ('forminske',),
'forminska': ('forminske',),
'forminskete': ('forminske',),
'forminskede': ('forminske',),
'forminska': ('forminske',),
'forminskete': ('forminske',),
'forminskede': ('forminske',),
'forminskende': ('forminske',),
'formlaus': ('formlaus',),
'formlause': ('formlaus',),
'formlaust': ('formlaus',),
'formløs': ('formløs',),
'formløse': ('formløs',),
'formløst': ('formløs',),
'formoda': ('formode',),
'formodet': ('formode',),
'formoda': ('formode',),
'formodet': ('formode',),
'formoda': ('formode',),
'formodete': ('formode',),
'formodede': ('formode',),
'formoda': ('formode',),
'formodete': ('formode',),
'formodede': ('formode',),
'formodende': ('formode',),
'formodentlig': ('formodentlig',),
'formodentlige': ('formodentlig',),
'formodentlig': ('formodentlig',),
'formolda': ('formolde',),
'formoldet': ('formolde',),
'formolda': ('formolde',),
'formoldet': ('formolde',),
'formolda': ('formolde',),
'formoldete': ('formolde',),
'formoldede': ('formolde',),
'formolda': ('formolde',),
'formoldete': ('formolde',),
'formoldede': ('formolde',),
'formoldende': ('formolde',),
'formosansk': ('formosansk',),
'formosanske': ('formosansk',),
'formosansk': ('formosansk',),
'formuende': ('formuende',),
'formulda': ('formulde',),
'formuldet': ('formulde',),
'formulda': ('formulde',),
'formuldet': ('formulde',),
'formulda': ('formulde',),
'formuldete': ('formulde',),
'formuldede': ('formulde',),
'formulda': ('formulde',),
'formuldete': ('formulde',),
'formuldede': ('formulde',),
'formuldende': ('formulde',),
'formulert': ('formulere',),
'formulerte': ('formulere',),
'formulerende': ('formulere',),
'formumma': ('formumme',),
'formummet': ('formumme',),
'formumma': ('formumme',),
'formummet': ('formumme',),
'formumma': ('formumme',),
'formummete': ('formumme',),
'formummede': ('formumme',),
'formumma': ('formumme',),
'formummete': ('formumme',),
'formummede': ('formumme',),
'formummende': ('formumme',),
'formådd': ('formå',),
'formådde': ('formå',),
'formående': ('formå',),
'formålslaus': ('formålslaus',),
'formålslause': ('formålslaus',),
'formålslaust': ('formålslaus',),
'formålsløs': ('formålsløs',),
'formålsløse': ('formålsløs',),
'formålsløst': ('formålsløs',),
'formålstjenlig': ('formålstjenlig',),
'formålstjenlige': ('formålstjenlig',),
'formålstjenlig': ('formålstjenlig',),
'formælt': ('formæle',),
'formælte': ('formæle',),
'formælende': ('formæle',),
'formørka': ('formørke',),
'formørket': ('formørke',),
'formørka': ('formørke',),
'formørket': ('formørke',),
'formørka': ('formørke',),
'formørkete': ('formørke',),
'formørkede': ('formørke',),
'formørka': ('formørke',),
'formørkete': ('formørke',),
'formørkede': ('formørke',),
'formørkende': ('formørke',),
'forn': ('forn',),
'forne': ('forn',),
'fornt': ('forn',),
'fornedra': ('fornedre',),
'fornedret': ('fornedre',),
'fornedra': ('fornedre',),
'fornedret': ('fornedre',),
'fornedra': ('fornedre',),
'fornedrete': ('fornedre',),
'fornedrede': ('fornedre',),
'fornedrete': ('fornedre',),
'fornedrede': ('fornedre',),
'fornedra': ('fornedre',),
'fornedrete': ('fornedre',),
'fornedrede': ('fornedre',),
'fornedrete': ('fornedre',),
'fornedrede': ('fornedre',),
'fornedrende': ('fornedre',),
'fornekta': ('fornekte',),
'fornektet': ('fornekte',),
'fornekta': ('fornekte',),
'fornektet': ('fornekte',),
'fornekta': ('fornekte',),
'fornektete': ('fornekte',),
'fornektede': ('fornekte',),
'fornekta': ('fornekte',),
'fornektete': ('fornekte',),
'fornektede': ('fornekte',),
'fornektende': ('fornekte',),
'fornem': ('fornem',),
'fornemme': ('fornem',),
'fornemt': ('fornem',),
'fornemmere': ('fornem',),
'fornemmest': ('fornem',),
'fornemmeste': ('fornem',),
'fornemma': ('fornemme',),
'fornemmet': ('fornemme',),
'fornemma': ('fornemme',),
'fornemmet': ('fornemme',),
'fornemma': ('fornemme',),
'fornemmete': ('fornemme',),
'fornemmede': ('fornemme',),
'fornemne': ('fornemme',),
'fornemma': ('fornemme',),
'fornemmete': ('fornemme',),
'fornemmede': ('fornemme',),
'fornemne': ('fornemme',),
'fornemmende': ('fornemme',),
'fornikla': ('fornikle',),
'forniklet': ('fornikle',),
'fornikla': ('fornikle',),
'forniklet': ('fornikle',),
'fornikla': ('fornikle',),
'forniklete': ('fornikle',),
'forniklede': ('fornikle',),
'forniklete': ('fornikle',),
'forniklede': ('fornikle',),
'fornikla': ('fornikle',),
'forniklete': ('fornikle',),
'forniklede': ('fornikle',),
'forniklete': ('fornikle',),
'forniklede': ('fornikle',),
'forniklende': ('fornikle',),
'fornorska': ('fornorske',),
'fornorsket': ('fornorske',),
'fornorska': ('fornorske',),
'fornorsket': ('fornorske',),
'fornorska': ('fornorske',),
'fornorskete': ('fornorske',),
'fornorskede': ('fornorske',),
'fornorska': ('fornorske',),
'fornorskete': ('fornorske',),
'fornorskede': ('fornorske',),
'fornorskende': ('fornorske',),
'fornuftig': ('fornuftig',),
'fornuftige': ('fornuftig',),
'fornuftig': ('fornuftig',),
'fornuftigere': ('fornuftig',),
'fornuftigst': ('fornuftig',),
'fornuftigste': ('fornuftig',),
'fornuftsstridig': ('fornuftsstridig',),
'fornuftsstridige': ('fornuftsstridig',),
'fornuftsstridig': ('fornuftsstridig',),
'fornuftstridig': ('fornuftstridig',),
'fornuftstridige': ('fornuftstridig',),
'fornuftstridig': ('fornuftstridig',),
'fornybar': ('fornybar',),
'fornybare': ('fornybar',),
'fornybart': ('fornybar',),
'fornya': ('fornye',),
'fornyet': ('fornye',),
'fornya': ('fornye',),
'fornyet': ('fornye',),
'fornya': ('fornye',),
'fornyete': ('fornye',),
'fornyede': ('fornye',),
'fornya': ('fornye',),
'fornyete': ('fornye',),
'fornyede': ('fornye',),
'fornyende': ('fornye',),
'fornærma': ('fornærma',),
'fornærma': ('fornærme',),
'fornærmet': ('fornærme',),
'fornærma': ('fornærme',),
'fornærmet': ('fornærme',),
'fornærma': ('fornærme',),
'fornærmete': ('fornærme',),
'fornærmede': ('fornærme',),
'fornærma': ('fornærme',),
'fornærmete': ('fornærme',),
'fornærmede': ('fornærme',),
'fornærmende': ('fornærme',),
'fornærmelig': ('fornærmelig',),
'fornærmelige': ('fornærmelig',),
'fornærmelig': ('fornærmelig',),
'fornærmet': ('fornærmet',),
'fornærmete': ('fornærmet',),
'fornærmede': ('fornærmet',),
'fornærmete': ('fornærmet',),
'fornærmede': ('fornærmet',),
'fornærmet': ('fornærmet',),
'fornøden': ('fornøden',),
'fornødne': ('fornøden',),
'fornødent': ('fornøden',),
'fornøgd': ('fornøgd',),
'fornøgde': ('fornøgd',),
'fornøgd': ('fornøgd',),
'fornøyd': ('fornøyd',),
'fornøyde': ('fornøyd',),
'fornøyd': ('fornøyd',),
'fornøyet': ('fornøye',),
'fornøyd': ('fornøye',),
'fornøyet': ('fornøye',),
'fornøyd': ('fornøye',),
'fornøyete': ('fornøye',),
'fornøyede': ('fornøye',),
'fornøyde': ('fornøye',),
'fornøyete': ('fornøye',),
'fornøyede': ('fornøye',),
'fornøyde': ('fornøye',),
'fornøyende': ('fornøye',),
'fornøyelig': ('fornøyelig',),
'fornøyelige': ('fornøyelig',),
'fornøyelig': ('fornøyelig',),
'fornøyelsessjuk': ('fornøyelsessjuk',),
'fornøyelsessjuke': ('fornøyelsessjuk',),
'fornøyelsessjukt': ('fornøyelsessjuk',),
'fornøyelsessyk': ('fornøyelsessyk',),
'fornøyelsessyke': ('fornøyelsessyk',),
'fornøyelsessykt': ('fornøyelsessyk',),
'forordna': ('forordne',),
'forordnet': ('forordne',),
'forordna': ('forordne',),
'forordnet': ('forordne',),
'forordna': ('forordne',),
'forordnete': ('forordne',),
'forordnede': ('forordne',),
'forordnete': ('forordne',),
'forordnede': ('forordne',),
'forordna': ('forordne',),
'forordnete': ('forordne',),
'forordnede': ('forordne',),
'forordnete': ('forordne',),
'forordnede': ('forordne',),
'forordnende': ('forordne',),
'foroverbøyd': ('foroverbøyd',),
'foroverbøyde': ('foroverbøyd',),
'foroverbøyd': ('foroverbøyd',),
'forpakta': ('forpakte',),
'forpaktet': ('forpakte',),
'forpakta': ('forpakte',),
'forpaktet': ('forpakte',),
'forpakta': ('forpakte',),
'forpaktete': ('forpakte',),
'forpaktede': ('forpakte',),
'forpakta': ('forpakte',),
'forpaktete': ('forpakte',),
'forpaktede': ('forpakte',),
'forpaktende': ('forpakte',),
'forpesta': ('forpeste',),
'forpestet': ('forpeste',),
'forpesta': ('forpeste',),
'forpestet': ('forpeste',),
'forpesta': ('forpeste',),
'forpestete': ('forpeste',),
'forpestede': ('forpeste',),
'forpesta': ('forpeste',),
'forpestete': ('forpeste',),
'forpestede': ('forpeste',),
'forpestende': ('forpeste',),
'forpint': ('forpint',),
'forpinte': ('forpint',),
'forpint': ('forpint',),
'forpjuska': ('forpjuska',),
'forpjusket': ('forpjusket',),
'forpjuskete': ('forpjusket',),
'forpjuskede': ('forpjusket',),
'forpjuskete': ('forpjusket',),
'forpjuskede': ('forpjusket',),
'forpjusket': ('forpjusket',),
'forplanta': ('forplante',),
'forplantet': ('forplante',),
'forplanta': ('forplante',),
'forplantet': ('forplante',),
'forplanta': ('forplante',),
'forplantete': ('forplante',),
'forplantede': ('forplante',),
'forplanta': ('forplante',),
'forplantete': ('forplante',),
'forplantede': ('forplante',),
'forplantende': ('forplante',),
'forplantingsdyktig': ('forplantingsdyktig',),
'forplantingsdyktige': ('forplantingsdyktig',),
'forplantingsdyktig': ('forplantingsdyktig',),
'forplantningsdyktig': ('forplantningsdyktig',),
'forplantningsdyktige': ('forplantningsdyktig',),
'forplantningsdyktig': ('forplantningsdyktig',),
'forpleia': ('forpleie',),
'forpleiet': ('forpleie',),
'forpleid': ('forpleie',),
'forpleia': ('forpleie',),
'forpleiet': ('forpleie',),
'forpleid': ('forpleie',),
'forpleia': ('forpleie',),
'forpleiete': ('forpleie',),
'forpleiede': ('forpleie',),
'forpleide': ('forpleie',),
'forpleia': ('forpleie',),
'forpleiete': ('forpleie',),
'forpleiede': ('forpleie',),
'forpleide': ('forpleie',),
'forpleiende': ('forpleie',),
'forplikta': ('forplikte',),
'forpliktet': ('forplikte',),
'forplikta': ('forplikte',),
'forpliktet': ('forplikte',),
'forplikta': ('forplikte',),
'forpliktete': ('forplikte',),
'forpliktede': ('forplikte',),
'forplikta': ('forplikte',),
'forpliktete': ('forplikte',),
'forpliktede': ('forplikte',),
'forpliktende': ('forplikte',),
'forpliktende': ('forpliktende',),
'forprosjektert': ('forprosjektere',),
'forprosjekterte': ('forprosjektere',),
'forprosjekterende': ('forprosjektere',),
'forpuppa': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppete': ('forpuppe',),
'forpuppede': ('forpuppe',),
'forpuppa': ('forpuppe',),
'forpuppete': ('forpuppe',),
'forpuppede': ('forpuppe',),
'forpuppende': ('forpuppe',),
'forpurra': ('forpurre',),
'forpurret': ('forpurre',),
'forpurra': ('forpurre',),
'forpurret': ('forpurre',),
'forpurra': ('forpurre',),
'forpurrete': ('forpurre',),
'forpurrede': ('forpurre',),
'forpurra': ('forpurre',),
'forpurrete': ('forpurre',),
'forpurrede': ('forpurre',),
'forpurrende': ('forpurre',),
'forrangla': ('forrangla',),
'forranglet': ('forranglet',),
'forranglete': ('forranglet',),
'forranglede': ('forranglet',),
'forranglete': ('forranglet',),
'forranglede': ('forranglet',),
'forranglet': ('forranglet',),
'forre': ('forre',),
'forregna': ('forregne',),
'forregnet': ('forregne',),
'forregna': ('forregne',),
'forregnet': ('forregne',),
'forregna': ('forregne',),
'forregnete': ('forregne',),
'forregnede': ('forregne',),
'forregna': ('forregne',),
'forregnete': ('forregne',),
'forregnede': ('forregne',),
'forregnende': ('forregne',),
'forrenta': ('forrente',),
'forrentet': ('forrente',),
'forrenta': ('forrente',),
'forrentet': ('forrente',),
'forrenta': ('forrente',),
'forrentete': ('forrente',),
'forrentede': ('forrente',),
'forrenta': ('forrente',),
'forrentete': ('forrente',),
'forrentede': ('forrente',),
'forrentende': ('forrente',),
'forrest': ('forrest',),
'forreste': ('forrest',),
'forrest': ('forrest',),
'forretningsdrivende': ('forretningsdrivende',),
'forretningsmessig': ('forretningsmessig',),
'forretningsmessige': ('forretningsmessig',),
'forretningsmessig': ('forretningsmessig',),
'forretta': ('forrette',),
'forrettet': ('forrette',),
'forretta': ('forrette',),
'forrettet': ('forrette',),
'forretta': ('forrette',),
'forrettete': ('forrette',),
'forrettede': ('forrette',),
'forretta': ('forrette',),
'forrettete': ('forrette',),
'forrettede': ('forrette',),
'forrettende': ('forrette',),
'forreven': ('forreven',),
'forrevne': ('forreven',),
'forrevet': ('forreven',),
'forrevet': ('forrevet',),
'forrevne': ('forrevet',),
'forrevet': ('forrevet',),
'forringa': ('forringe',),
'forringet': ('forringe',),
'forringa': ('forringe',),
'forringet': ('forringe',),
'forringa': ('forringe',),
'forringete': ('forringe',),
'forringede': ('forringe',),
'forringa': ('forringe',),
'forringete': ('forringe',),
'forringede': ('forringe',),
'forringende': ('forringe',),
'forrykende': ('forrykende',),
'forrykka': ('forrykke',),
'forrykket': ('forrykke',),
'forrykt': ('forrykke',),
'forrykka': ('forrykke',),
'forrykket': ('forrykke',),
'forrykt': ('forrykke',),
'forrykka': ('forrykke',),
'forrykkete': ('forrykke',),
'forrykkede': ('forrykke',),
'forrykte': ('forrykke',),
'forrykka': ('forrykke',),
'forrykkete': ('forrykke',),
'forrykkede': ('forrykke',),
'forrykte': ('forrykke',),
'forrykkende': ('forrykke',),
'forrykt': ('forrykt',),
'forrykte': ('forrykt',),
'forrykt': ('forrykt',),
'forrådt': ('forråde',),
'forrådte': ('forråde',),
'forrådende': ('forråde',),
'forråa': ('forråe',),
'forrået': ('forråe',),
'forråa': ('forråe',),
'forrået': ('forråe',),
'forråa': ('forråe',),
'forråete': ('forråe',),
'forråede': ('forråe',),
'forråa': ('forråe',),
'forråete': ('forråe',),
'forråede': ('forråe',),
'forrående': ('forråe',),
'forrædersk': ('forrædersk',),
'forræderske': ('forrædersk',),
'forrædersk': ('forrædersk',),
'forsaga': ('forsage',),
'forsaget': ('forsage',),
'forsaga': ('forsage',),
'forsaget': ('forsage',),
'forsaga': ('forsage',),
'forsagete': ('forsage',),
'forsagede': ('forsage',),
'forsaga': ('forsage',),
'forsagete': ('forsage',),
'forsagede': ('forsage',),
'forsagende': ('forsage',),
'forsagt': ('forsagt',),
'forsagte': ('forsagt',),
'forsagt': ('forsagt',),
'forsaka': ('forsake',),
'forsaket': ('forsake',),
'forsaka': ('forsake',),
'forsaket': ('forsake',),
'forsaka': ('forsake',),
'forsakete': ('forsake',),
'forsakede': ('forsake',),
'forsaka': ('forsake',),
'forsakete': ('forsake',),
'forsakede': ('forsake',),
'forsakende': ('forsake',),
'forsett': ('forse',),
'forsette': ('forse',),
'forseende': ('forse',),
'forseggjort': ('forseggjort',),
'forseggjorte': ('forseggjort',),
'forseggjort': ('forseggjort',),
'forsegla': ('forsegle',),
'forseglet': ('forsegle',),
'forsegla': ('forsegle',),
'forseglet': ('forsegle',),
'forsegla': ('forsegle',),
'forseglete': ('forsegle',),
'forseglede': ('forsegle',),
'forseglete': ('forsegle',),
'forseglede': ('forsegle',),
'forsegla': ('forsegle',),
'forseglete': ('forsegle',),
'forseglede': ('forsegle',),
'forseglete': ('forsegle',),
'forseglede': ('forsegle',),
'forseglende': ('forsegle',),
'forsenka': ('forsenke',),
'forsenket': ('forsenke',),
'forsenka': ('forsenke',),
'forsenket': ('forsenke',),
'forsenka': ('forsenke',),
'forsenkete': ('forsenke',),
'forsenkede': ('forsenke',),
'forsenka': ('forsenke',),
'forsenkete': ('forsenke',),
'forsenkede': ('forsenke',),
'forsenkende': ('forsenke',),
'forsert': ('forsere',),
'forserte': ('forsere',),
'forserende': ('forsere',),
'forsert': ('forsert',),
'forserte': ('forsert',),
'forsert': ('forsert',),
'forsettlig': ('forsettlig',),
'forsettlige': ('forsettlig',),
'forsettlig': ('forsettlig',),
'forsikra': ('forsikre',),
'forsikret': ('forsikre',),
'forsikra': ('forsikre',),
'forsikret': ('forsikre',),
'forsikra': ('forsikre',),
'forsikrete': ('forsikre',),
'forsikrede': ('forsikre',),
'forsikrete': ('forsikre',),
'forsikrede': ('forsikre',),
'forsikra': ('forsikre',),
'forsikrete': ('forsikre',),
'forsikrede': ('forsikre',),
'forsikrete': ('forsikre',),
'forsikrede': ('forsikre',),
'forsikrende': ('forsikre',),
'forsiktig': ('forsiktig',),
'forsiktige': ('forsiktig',),
'forsiktig': ('forsiktig',),
'forsiktigere': ('forsiktig',),
'forsiktigst': ('forsiktig',),
'forsiktigste': ('forsiktig',),
'forsimpla': ('forsimple',),
'forsimplet': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimplet': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimplete': ('forsimple',),
'forsimplede': ('forsimple',),
'forsimplete': ('forsimple',),
'forsimplede': ('forsimple',),
'forsimpla': ('forsimple',),
'forsimplete': ('forsimple',),
'forsimplede': ('forsimple',),
'forsimplete': ('forsimple',),
'forsimplede': ('forsimple',),
'forsimplende': ('forsimple',),
'forsinka': ('forsinke',),
'forsinket': ('forsinke',),
'forsinka': ('forsinke',),
'forsinket': ('forsinke',),
'forsinka': ('forsinke',),
'forsinkete': ('forsinke',),
'forsinkede': ('forsinke',),
'forsinka': ('forsinke',),
'forsinkete': ('forsinke',),
'forsinkede': ('forsinke',),
'forsinkende': ('forsinke',),
'forsirt': ('forsire',),
'forsirte': ('forsire',),
'forsirende': ('forsire',),
'forsjofla': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjoflete': ('forsjofle',),
'forsjoflede': ('forsjofle',),
'forsjoflete': ('forsjofle',),
'forsjoflede': ('forsjofle',),
'forsjofla': ('forsjofle',),
'forsjoflete': ('forsjofle',),
'forsjoflede': ('forsjofle',),
'forsjoflete': ('forsjofle',),
'forsjoflede': ('forsjofle',),
'forsjoflende': ('forsjofle',),
'forskala': ('forskale',),
'forskalet': ('forskale',),
'forskalt': ('forskale',),
'forskala': ('forskale',),
'forskalet': ('forskale',),
'forskalt': ('forskale',),
'forskala': ('forskale',),
'forskalete': ('forskale',),
'forskalede': ('forskale',),
'forskalte': ('forskale',),
'forskala': ('forskale',),
'forskalete': ('forskale',),
'forskalede': ('forskale',),
'forskalte': ('forskale',),
'forskalende': ('forskale',),
'forskansa': ('forskanse',),
'forskanset': ('forskanse',),
'forskansa': ('forskanse',),
'forskanset': ('forskanse',),
'forskansa': ('forskanse',),
'forskansete': ('forskanse',),
'forskansede': ('forskanse',),
'forskansa': ('forskanse',),
'forskansete': ('forskanse',),
'forskansede': ('forskanse',),
'forskansende': ('forskanse',),
'forska': ('forske',),
'forsket': ('forske',),
'forska': ('forske',),
'forsket': ('forske',),
'forska': ('forske',),
'forskete': ('forske',),
'forskede': ('forske',),
'forska': ('forske',),
'forskete': ('forske',),
'forskede': ('forske',),
'forskende': ('forske',),
'forskende': ('forskende',),
'forskjellig': ('forskjellig',),
'forskjellige': ('forskjellig',),
'forskjellig': ('forskjellig',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlete': ('forskjellsbehandle',),
'forskjellsbehandlede': ('forskjellsbehandle',),
'forskjellsbehandlete': ('forskjellsbehandle',),
'forskjellsbehandlede': ('forskjellsbehandle',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlete': ('forskjellsbehandle',),
'forskjellsbehandlede': ('forskjellsbehandle',),
'forskjellsbehandlete': ('forskjellsbehandle',),
'forskjellsbehandlede': ('forskjellsbehandle',),
'forskjellsbehandlende': ('forskjellsbehandle',),
'forskjønna': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønnete': ('forskjønne',),
'forskjønnede': ('forskjønne',),
'forskjønna': ('forskjønne',),
'forskjønnete': ('forskjønne',),
'forskjønnede': ('forskjønne',),
'forskjønnende': ('forskjønne',),
'forskottert': ('forskottere',),
'forskotterte': ('forskottere',),
'forskotterende': ('forskottere',),
'forskrekka': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekkete': ('forskrekke',),
'forskrekkede': ('forskrekke',),
'forskrekka': ('forskrekke',),
'forskrekkete': ('forskrekke',),
'forskrekkede': ('forskrekke',),
'forskrekkende': ('forskrekke',),
'forskrekkelig': ('forskrekkelig',),
'forskrekkelige': ('forskrekkelig',),
'forskrekkelig': ('forskrekkelig',),
'forskremt': ('forskremt',),
'forskremte': ('forskremt',),
'forskremt': ('forskremt',),
'forskreva': ('forskreve',),
'forskrevet': ('forskreve',),
'forskrevd': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevet': ('forskreve',),
'forskrevd': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevete': ('forskreve',),
'forskrevede': ('forskreve',),
'forskrevde': ('forskreve',),
'forskreva': ('forskreve',),
'forskrevete': ('forskreve',),
'forskrevede': ('forskreve',),
'forskrevde': ('forskreve',),
'forskrevende': ('forskreve',),
'forskriftmessig': ('forskriftmessig',),
'forskriftmessige': ('forskriftmessig',),
'forskriftmessig': ('forskriftmessig',),
'forskriftsmessig': ('forskriftsmessig',),
'forskriftsmessige': ('forskriftsmessig',),
'forskriftsmessig': ('forskriftsmessig',),
'forskrevet': ('forskrive',),
'forskreven': ('forskrive',),
'forskrevne': ('forskrive',),
'forskrivende': ('forskrive',),
'forskrudd': ('forskrudd',),
'forskrudde': ('forskrudd',),
'forskrudd': ('forskrudd',),
'forskusla': ('forskusle',),
'forskuslet': ('forskusle',),
'forskusla': ('forskusle',),
'forskuslet': ('forskusle',),
'forskusla': ('forskusle',),
'forskuslete': ('forskusle',),
'forskuslede': ('forskusle',),
'forskusla': ('forskusle',),
'forskuslete': ('forskusle',),
'forskuslede': ('forskusle',),
'forskuslende': ('forskusle',),
'forskuttert': ('forskuttere',),
'forskutterte': ('forskuttere',),
'forskutterende': ('forskuttere',),
'forskyldt': ('forskylde',),
'forskyldte': ('forskylde',),
'forskyldende': ('forskylde',),
'forskjøvet': ('forskyve',),
'forskjøven': ('forskyve',),
'forskjøvet': ('forskyve',),
'forskjøven': ('forskyve',),
'forskjøvne': ('forskyve',),
'forskyvende': ('forskyve',),
'forskåna': ('forskåne',),
'forskånet': ('forskåne',),
'forskånt': ('forskåne',),
'forskåna': ('forskåne',),
'forskånet': ('forskåne',),
'forskånt': ('forskåne',),
'forskåna': ('forskåne',),
'forskånete': ('forskåne',),
'forskånede': ('forskåne',),
'forskånte': ('forskåne',),
'forskåna': ('forskåne',),
'forskånete': ('forskåne',),
'forskånede': ('forskåne',),
'forskånte': ('forskåne',),
'forskånende': ('forskåne',),
'forslagen': ('forslagen',),
'forslagne': ('forslagen',),
'forslagent': ('forslagen',),
'forslitt': ('forslitt',),
'forslitte': ('forslitt',),
'forslitt': ('forslitt',),
'forslukt': ('forsluke',),
'forslukte': ('forsluke',),
'forslukende': ('forsluke',),
'forsluken': ('forsluken',),
'forslukne': ('forsluken',),
'forslukent': ('forsluken',),
'forslumma': ('forslumme',),
'forslummet': ('forslumme',),
'forslumma': ('forslumme',),
'forslummet': ('forslumme',),
'forslumma': ('forslumme',),
'forslummete': ('forslumme',),
'forslummede': ('forslumme',),
'forslumma': ('forslumme',),
'forslummete': ('forslumme',),
'forslummede': ('forslumme',),
'forslummende': ('forslumme',),
'forslått': ('forslå',),
'forslåtte': ('forslå',),
'forslående': ('forslå',),
'forslått': ('forslått',),
'forslåtte': ('forslått',),
'forslått': ('forslått',),
'forsmedelig': ('forsmedelig',),
'forsmedelige': ('forsmedelig',),
'forsmedelig': ('forsmedelig',),
'forsmådd': ('forsmå',),
'forsmådde': ('forsmå',),
'forsmående': ('forsmå',),
'forsnakka': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakkete': ('forsnakke',),
'forsnakkede': ('forsnakke',),
'forsnakka': ('forsnakke',),
'forsnakkete': ('forsnakke',),
'forsnakkede': ('forsnakke',),
'forsnakkende': ('forsnakke',),
'forsnevra': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevrete': ('forsnevre',),
'forsnevrede': ('forsnevre',),
'forsnevrete': ('forsnevre',),
'forsnevrede': ('forsnevre',),
'forsnevra': ('forsnevre',),
'forsnevrete': ('forsnevre',),
'forsnevrede': ('forsnevre',),
'forsnevrete': ('forsnevre',),
'forsnevrede': ('forsnevre',),
'forsnevrende': ('forsnevre',),
'forsoffen': ('forsoffen',),
'forsofne': ('forsoffen',),
'forsoffent': ('forsoffen',),
'forsona': ('forsone',),
'forsonet': ('forsone',),
'forsont': ('forsone',),
'forsona': ('forsone',),
'forsonet': ('forsone',),
'forsont': ('forsone',),
'forsona': ('forsone',),
'forsonete': ('forsone',),
'forsonede': ('forsone',),
'forsonte': ('forsone',),
'forsona': ('forsone',),
'forsonete': ('forsone',),
'forsonede': ('forsone',),
'forsonte': ('forsone',),
'forsonende': ('forsone',),
'forsonlig': ('forsonlig',),
'forsonlige': ('forsonlig',),
'forsonlig': ('forsonlig',),
'forsoren': ('forsoren',),
'forsorne': ('forsoren',),
'forsorent': ('forsoren',),
'forsovet': ('forsove',),
'forsoven': ('forsove',),
'forsovne': ('forsove',),
'forsovende': ('forsove',),
'forspent': ('forspenne',),
'forspente': ('forspenne',),
'forspennende': ('forspenne',),
'forspilt': ('forspille',),
'forspilte': ('forspille',),
'forspillende': ('forspille',),
'forspist': ('forspise',),
'forspiste': ('forspise',),
'forspisende': ('forspise',),
'forsprengt': ('forsprengt',),
'forsprengte': ('forsprengt',),
'forsprengt': ('forsprengt',),
'forspurt': ('forspørre',),
'forspurte': ('forspørre',),
'forspørrende': ('forspørre',),
'forstandig': ('forstandig',),
'forstandige': ('forstandig',),
'forstandig': ('forstandig',),
'forstandsmessig': ('forstandsmessig',),
'forstandsmessige': ('forstandsmessig',),
'forstandsmessig': ('forstandsmessig',),
'forsteina': ('forsteina',),
'forsteinet': ('forsteinet',),
'forsteinete': ('forsteinet',),
'forsteinede': ('forsteinet',),
'forsteinete': ('forsteinet',),
'forsteinede': ('forsteinet',),
'forsteinet': ('forsteinet',),
'forstemmende': ('forstemmende',),
'forstemt': ('forstemt',),
'forstemte': ('forstemt',),
'forstemt': ('forstemt',),
'forstenet': ('forstenet',),
'forstenete': ('forstenet',),
'forstenede': ('forstenet',),
'forstenete': ('forstenet',),
'forstenede': ('forstenet',),
'forstenet': ('forstenet',),
'forsterka': ('forsterke',),
'forsterket': ('forsterke',),
'forsterka': ('forsterke',),
'forsterket': ('forsterke',),
'forsterka': ('forsterke',),
'forsterkete': ('forsterke',),
'forsterkede': ('forsterke',),
'forsterka': ('forsterke',),
'forsterkete': ('forsterke',),
'forsterkede': ('forsterke',),
'forsterkende': ('forsterke',),
'forstukket': ('forstikke',),
'forstukken': ('forstikke',),
'forstukne': ('forstikke',),
'forstikkende': ('forstikke',),
'forstilt': ('forstille',),
'forstilte': ('forstille',),
'forstillende': ('forstille',),
'forstokka': ('forstokka',),
'forstokket': ('forstokket',),
'forstokkete': ('forstokket',),
'forstokkede': ('forstokket',),
'forstokkete': ('forstokket',),
'forstokkede': ('forstokket',),
'forstokket': ('forstokket',),
'forstua': ('forstue',),
'forstuet': ('forstue',),
'forstua': ('forstue',),
'forstuet': ('forstue',),
'forstua': ('forstue',),
'forstuete': ('forstue',),
'forstuede': ('forstue',),
'forstua': ('forstue',),
'forstuete': ('forstue',),
'forstuede': ('forstue',),
'forstuende': ('forstue',),
'forstumma': ('forstumme',),
'forstummet': ('forstumme',),
'forstumma': ('forstumme',),
'forstummet': ('forstumme',),
'forstumma': ('forstumme',),
'forstummete': ('forstumme',),
'forstummede': ('forstumme',),
'forstumma': ('forstumme',),
'forstummete': ('forstumme',),
'forstummede': ('forstumme',),
'forstummende': ('forstumme',),
'forstyrra': ('forstyrra',),
'forstyrra': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrrete': ('forstyrre',),
'forstyrrede': ('forstyrre',),
'forstyrra': ('forstyrre',),
'forstyrrete': ('forstyrre',),
'forstyrrede': ('forstyrre',),
'forstyrrende': ('forstyrre',),
'forstyrret': ('forstyrret',),
'forstyrrete': ('forstyrret',),
'forstyrrede': ('forstyrret',),
'forstyrrete': ('forstyrret',),
'forstyrrede': ('forstyrret',),
'forstyrret': ('forstyrret',),
'forstått': ('forstå',),
'forståtte': ('forstå',),
'forstående': ('forstå',),
'forståelig': ('forståelig',),
'forståelige': ('forståelig',),
'forståelig': ('forståelig',),
'forståelsesfull': ('forståelsesfull',),
'forståelsesfulle': ('forståelsesfull',),
'forståelsesfullt': ('forståelsesfull',),
'forstøkt': ('forstøkt',),
'forstøkte': ('forstøkt',),
'forstøkt': ('forstøkt',),
'forstørra': ('forstørre',),
'forstørret': ('forstørre',),
'forstørra': ('forstørre',),
'forstørret': ('forstørre',),
'forstørra': ('forstørre',),
'forstørrete': ('forstørre',),
'forstørrede': ('forstørre',),
'forstørra': ('forstørre',),
'forstørrete': ('forstørre',),
'forstørrede': ('forstørre',),
'forstørrende': ('forstørre',),
'forstøtt': ('forstøte',),
'forstøtte': ('forstøte',),
'forstøtende': ('forstøte',),
'forstøtta': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøttete': ('forstøtte',),
'forstøttede': ('forstøtte',),
'forstøtta': ('forstøtte',),
'forstøttete': ('forstøtte',),
'forstøttede': ('forstøtte',),
'forstøttende': ('forstøtte',),
'forstøva': ('forstøve',),
'forstøvet': ('forstøve',),
'forstøva': ('forstøve',),
'forstøvet': ('forstøve',),
'forstøva': ('forstøve',),
'forstøvete': ('forstøve',),
'forstøvede': ('forstøve',),
'forstøva': ('forstøve',),
'forstøvete': ('forstøve',),
'forstøvede': ('forstøve',),
'forstøvende': ('forstøve',),
'forsumpa': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpete': ('forsumpe',),
'forsumpede': ('forsumpe',),
'forsumpa': ('forsumpe',),
'forsumpete': ('forsumpe',),
'forsumpede': ('forsumpe',),
'forsumpende': ('forsumpe',),
'forsura': ('forsure',),
'forsuret': ('forsure',),
'forsura': ('forsure',),
'forsuret': ('forsure',),
'forsura': ('forsure',),
'forsurete': ('forsure',),
'forsurede': ('forsure',),
'forsura': ('forsure',),
'forsurete': ('forsure',),
'forsurede': ('forsure',),
'forsurende': ('forsure',),
'forsvart': ('forsvare',),
'forsvarte': ('forsvare',),
'forsvarende': ('forsvare',),
'forsvarlig': ('forsvarlig',),
'forsvarlige': ('forsvarlig',),
'forsvarlig': ('forsvarlig',),
'forsvarslaus': ('forsvarslaus',),
'forsvarslause': ('forsvarslaus',),
'forsvarslaust': ('forsvarslaus',),
'forsvarsløs': ('forsvarsløs',),
'forsvarsløse': ('forsvarsløs',),
'forsvarsløst': ('forsvarsløs',),
'forsvenska': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvenskete': ('forsvenske',),
'forsvenskede': ('forsvenske',),
'forsvenska': ('forsvenske',),
'forsvenskete': ('forsvenske',),
'forsvenskede': ('forsvenske',),
'forsvenskende': ('forsvenske',),
'forsverga': ('forsverge',),
'forsverget': ('forsverge',),
'forsvoret': ('forsverge',),
'forsverga': ('forsverge',),
'forsverget': ('forsverge',),
'forsvoret': ('forsverge',),
'forsvoren': ('forsverge',),
'forsverga': ('forsverge',),
'forsvergete': ('forsverge',),
'forsvergede': ('forsverge',),
'forsvorne': ('forsverge',),
'forsverga': ('forsverge',),
'forsvergete': ('forsverge',),
'forsvergede': ('forsverge',),
'forsvorne': ('forsverge',),
'forsvergende': ('forsverge',),
'forsvunnet': ('forsvinne',),
'forsvunnen': ('forsvinne',),
'forsvunne': ('forsvinne',),
'forsvinnende': ('forsvinne',),
'forsvinnende': ('forsvinnende',),
'forsynda': ('forsynde',),
'forsyndet': ('forsynde',),
'forsynda': ('forsynde',),
'forsyndet': ('forsynde',),
'forsynda': ('forsynde',),
'forsyndete': ('forsynde',),
'forsyndede': ('forsynde',),
'forsynda': ('forsynde',),
'forsyndete': ('forsynde',),
'forsyndede': ('forsynde',),
'forsyndende': ('forsynde',),
'forsynt': ('forsyne',),
'forsynte': ('forsyne',),
'forsynende': ('forsyne',),
'forsynlig': ('forsynlig',),
'forsynlige': ('forsynlig',),
'forsynlig': ('forsynlig',),
'forsøkt': ('forsøke',),
'forsøkte': ('forsøke',),
'forsøkende': ('forsøke',),
'forsølva': ('forsølve',),
'forsølvet': ('forsølve',),
'forsølva': ('forsølve',),
'forsølvet': ('forsølve',),
'forsølva': ('forsølve',),
'forsølvete': ('forsølve',),
'forsølvede': ('forsølve',),
'forsølva': ('forsølve',),
'forsølvete': ('forsølve',),
'forsølvede': ('forsølve',),
'forsølvende': ('forsølve',),
'forsømt': ('forsømme',),
'forsømte': ('forsømme',),
'forsømmende': ('forsømme',),
'forsømmelig': ('forsømmelig',),
'forsømmelige': ('forsømmelig',),
'forsømmelig': ('forsømmelig',),
'forsømt': ('forsømt',),
'forsømte': ('forsømt',),
'forsømt': ('forsømt',),
'forsøpla': ('forsøple',),
'forsøplet': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøplet': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøplete': ('forsøple',),
'forsøplede': ('forsøple',),
'forsøplete': ('forsøple',),
'forsøplede': ('forsøple',),
'forsøpla': ('forsøple',),
'forsøplete': ('forsøple',),
'forsøplede': ('forsøple',),
'forsøplete': ('forsøple',),
'forsøplede': ('forsøple',),
'forsøplende': ('forsøple',),
'forsørga': ('forsørge',),
'forsørget': ('forsørge',),
'forsørgd': ('forsørge',),
'forsørga': ('forsørge',),
'forsørget': ('forsørge',),
'forsørgd': ('forsørge',),
'forsørga': ('forsørge',),
'forsørgete': ('forsørge',),
'forsørgede': ('forsørge',),
'forsørgde': ('forsørge',),
'forsørga': ('forsørge',),
'forsørgete': ('forsørge',),
'forsørgede': ('forsørge',),
'forsørgde': ('forsørge',),
'forsørgende': ('forsørge',),
'forsøta': ('forsøte',),
'forsøtet': ('forsøte',),
'forsøta': ('forsøte',),
'forsøtet': ('forsøte',),
'forsøta': ('forsøte',),
'forsøtete': ('forsøte',),
'forsøtede': ('forsøte',),
'forsøta': ('forsøte',),
'forsøtete': ('forsøte',),
'forsøtede': ('forsøte',),
'forsøtende': ('forsøte',),
'fortatt': ('forta',),
'fortatte': ('forta',),
'fortakende': ('forta',),
'fortapt': ('fortape',),
'fortapte': ('fortape',),
'fortapende': ('fortape',),
'fortapt': ('fortapt',),
'fortapte': ('fortapt',),
'fortapt': ('fortapt',),
'forta': ('forte',),
'fortet': ('forte',),
'forta': ('forte',),
'fortet': ('forte',),
'forta': ('forte',),
'fortete': ('forte',),
'fortede': ('forte',),
'forta': ('forte',),
'fortete': ('forte',),
'fortede': ('forte',),
'fortende': ('forte',),
'fortegna': ('fortegne',),
'fortegnet': ('fortegne',),
'fortegna': ('fortegne',),
'fortegnet': ('fortegne',),
'fortegna': ('fortegne',),
'fortegnete': ('fortegne',),
'fortegnede': ('fortegne',),
'fortegna': ('fortegne',),
'fortegnete': ('fortegne',),
'fortegnede': ('fortegne',),
'fortegnende': ('fortegne',),
'fortalt': ('fortelle',),
'fortalte': ('fortelle',),
'fortellende': ('fortelle',),
'fortellende': ('fortellende',),
'fortenkt': ('fortenke',),
'fortenkte': ('fortenke',),
'fortenkende': ('fortenke',),
'fortenkt': ('fortenkt',),
'fortenkte': ('fortenkt',),
'fortenkt': ('fortenkt',),
'forterpa': ('forterpa',),
'forterpet': ('forterpet',),
'forterpete': ('forterpet',),
'forterpede': ('forterpet',),
'forterpete': ('forterpet',),
'forterpede': ('forterpet',),
'forterpet': ('forterpet',),
'forterska': ('forterska',),
'fortersket': ('fortersket',),
'forterskete': ('fortersket',),
'forterskede': ('fortersket',),
'forterskete': ('fortersket',),
'forterskede': ('fortersket',),
'fortersket': ('fortersket',),
'fortetta': ('fortette',),
'fortettet': ('fortette',),
'fortetta': ('fortette',),
'fortettet': ('fortette',),
'fortetta': ('fortette',),
'fortettete': ('fortette',),
'fortettede': ('fortette',),
'fortetta': ('fortette',),
'fortettete': ('fortette',),
'fortettede': ('fortette',),
'fortettende': ('fortette',),
'fortidig': ('fortidig',),
'fortidige': ('fortidig',),
'fortidig': ('fortidig',),
'fortia': ('fortie',),
'fortiet': ('fortie',),
'fortidd': ('fortie',),
'fortia': ('fortie',),
'fortiet': ('fortie',),
'fortidd': ('fortie',),
'fortia': ('fortie',),
'fortiete': ('fortie',),
'fortiede': ('fortie',),
'fortidde': ('fortie',),
'fortia': ('fortie',),
'fortiete': ('fortie',),
'fortiede': ('fortie',),
'fortidde': ('fortie',),
'fortiende': ('fortie',),
'fortinna': ('fortinne',),
'fortinnet': ('fortinne',),
'fortinna': ('fortinne',),
'fortinnet': ('fortinne',),
'fortinna': ('fortinne',),
'fortinnete': ('fortinne',),
'fortinnede': ('fortinne',),
'fortinna': ('fortinne',),
'fortinnete': ('fortinne',),
'fortinnede': ('fortinne',),
'fortinnende': ('fortinne',),
'fortjent': ('fortjene',),
'fortjente': ('fortjene',),
'fortjenende': ('fortjene',),
'fortjenestefull': ('fortjenestefull',),
'fortjenestefulle': ('fortjenestefull',),
'fortjenestefullt': ('fortjenestefull',),
'fortjenstfull': ('fortjenstfull',),
'fortjenstfulle': ('fortjenstfull',),
'fortjenstfullt': ('fortjenstfull',),
'fortløpende': ('fortløpende',),
'fortna': ('fortne',),
'fortnet': ('fortne',),
'fortna': ('fortne',),
'fortnet': ('fortne',),
'fortna': ('fortne',),
'fortnete': ('fortne',),
'fortnede': ('fortne',),
'fortnete': ('fortne',),
'fortnede': ('fortne',),
'fortna': ('fortne',),
'fortnete': ('fortne',),
'fortnede': ('fortne',),
'fortnete': ('fortne',),
'fortnede': ('fortne',),
'fortnende': ('fortne',),
'fortolka': ('fortolke',),
'fortolket': ('fortolke',),
'fortolka': ('fortolke',),
'fortolket': ('fortolke',),
'fortolka': ('fortolke',),
'fortolkete': ('fortolke',),
'fortolkede': ('fortolke',),
'fortolka': ('fortolke',),
'fortolkete': ('fortolke',),
'fortolkede': ('fortolke',),
'fortolkende': ('fortolke',),
'fortolla': ('fortolle',),
'fortollet': ('fortolle',),
'fortolla': ('fortolle',),
'fortollet': ('fortolle',),
'fortolla': ('fortolle',),
'fortollete': ('fortolle',),
'fortollede': ('fortolle',),
'fortolla': ('fortolle',),
'fortollete': ('fortolle',),
'fortollede': ('fortolle',),
'fortollende': ('fortolle',),
'fortona': ('fortone',),
'fortonet': ('fortone',),
'fortont': ('fortone',),
'fortona': ('fortone',),
'fortonet': ('fortone',),
'fortont': ('fortone',),
'fortona': ('fortone',),
'fortonete': ('fortone',),
'fortonede': ('fortone',),
'fortonte': ('fortone',),
'fortona': ('fortone',),
'fortonete': ('fortone',),
'fortonede': ('fortone',),
'fortonte': ('fortone',),
'fortonende': ('fortone',),
'fortorva': ('fortorve',),
'fortorvet': ('fortorve',),
'fortorva': ('fortorve',),
'fortorvet': ('fortorve',),
'fortorva': ('fortorve',),
'fortorvete': ('fortorve',),
'fortorvede': ('fortorve',),
'fortorva': ('fortorve',),
'fortorvete': ('fortorve',),
'fortorvede': ('fortorve',),
'fortorvende': ('fortorve',),
'fortredelig': ('fortredelig',),
'fortredelige': ('fortredelig',),
'fortredelig': ('fortredelig',),
'fortreffelig': ('fortreffelig',),
'fortreffelige': ('fortreffelig',),
'fortreffelig': ('fortreffelig',),
'fortrukket': ('fortrekke',),
'fortrukken': ('fortrekke',),
'fortrukne': ('fortrekke',),
'fortrekkende': ('fortrekke',),
'fortrengt': ('fortrenge',),
'fortrengte': ('fortrenge',),
'fortrengende': ('fortrenge',),
'fortrinnlig': ('fortrinnlig',),
'fortrinnlige': ('fortrinnlig',),
'fortrinnlig': ('fortrinnlig',),
'fortrinnsberettiga': ('fortrinnsberettiga',),
'fortrinnsberettiget': ('fortrinnsberettiget',),
'fortrinnsberettigete': ('fortrinnsberettiget',),
'fortrinnsberettigede': ('fortrinnsberettiget',),
'fortrinnsberettigete': ('fortrinnsberettiget',),
'fortrinnsberettigede': ('fortrinnsberettiget',),
'fortrinnsberettiget': ('fortrinnsberettiget',),
'fortrolig': ('fortrolig',),
'fortrolige': ('fortrolig',),
'fortrolig': ('fortrolig',),
'fortroligere': ('fortrolig',),
'fortroligst': ('fortrolig',),
'fortroligste': ('fortrolig',),
'fortrolla': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrollete': ('fortrolle',),
'fortrollede': ('fortrolle',),
'fortrolla': ('fortrolle',),
'fortrollete': ('fortrolle',),
'fortrollede': ('fortrolle',),
'fortrollende': ('fortrolle',),
'fortrykt': ('fortrykt',),
'fortrykte': ('fortrykt',),
'fortrykt': ('fortrykt',),
'fortrylla': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortryllete': ('fortrylle',),
'fortryllede': ('fortrylle',),
'fortrylla': ('fortrylle',),
'fortryllete': ('fortrylle',),
'fortryllede': ('fortrylle',),
'fortryllende': ('fortrylle',),
'fortrøsta': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøstete': ('fortrøste',),
'fortrøstede': ('fortrøste',),
'fortrøsta': ('fortrøste',),
'fortrøstete': ('fortrøste',),
'fortrøstede': ('fortrøste',),
'fortrøstende': ('fortrøste',),
'fortrøstningsfull': ('fortrøstningsfull',),
'fortrøstningsfulle': ('fortrøstningsfull',),
'fortrøstningsfullt': ('fortrøstningsfull',),
'fortsatt': ('fortsette',),
'fortsatte': ('fortsette',),
'fortsettende': ('fortsette',),
'fortulla': ('fortulla',),
'fortullet': ('fortullet',),
'fortullete': ('fortullet',),
'fortullede': ('fortullet',),
'fortullete': ('fortullet',),
'fortullede': ('fortullet',),
'fortullet': ('fortullet',),
'fortumla': ('fortumla',),
'fortumlet': ('fortumlet',),
'fortumlete': ('fortumlet',),
'fortumlede': ('fortumlet',),
'fortumlete': ('fortumlet',),
'fortumlede': ('fortumlet',),
'fortumlet': ('fortumlet',),
'fortvila': ('fortvila',),
'fortvilt': ('fortvile',),
'fortvilte': ('fortvile',),
'fortvilende': ('fortvile',),
'fortvilet': ('fortvilet',),
'fortvilete': ('fortvilet',),
'fortvilede': ('fortvilet',),
'fortvilete': ('fortvilet',),
'fortvilede': ('fortvilet',),
'fortvilet': ('fortvilet',),
'fortvilt': ('fortvilt',),
'fortvilte': ('fortvilt',),
'fortvilt': ('fortvilt',),
'fortykka': ('fortykke',),
'fortykket': ('fortykke',),
'fortykka': ('fortykke',),
'fortykket': ('fortykke',),
'fortykka': ('fortykke',),
'fortykkete': ('fortykke',),
'fortykkede': ('fortykke',),
'fortykka': ('fortykke',),
'fortykkete': ('fortykke',),
'fortykkede': ('fortykke',),
'fortykkende': ('fortykke',),
'fortynna': ('fortynne',),
'fortynnet': ('fortynne',),
'fortynna': ('fortynne',),
'fortynnet': ('fortynne',),
'fortynna': ('fortynne',),
'fortynnete': ('fortynne',),
'fortynnede': ('fortynne',),
'fortynna': ('fortynne',),
'fortynnete': ('fortynne',),
'fortynnede': ('fortynne',),
'fortynnende': ('fortynne',),
'fortært': ('fortære',),
'fortærte': ('fortære',),
'fortærende': ('fortære',),
'fortærende': ('fortærende',),
'fortørna': ('fortørne',),
'fortørnet': ('fortørne',),
'fortørna': ('fortørne',),
'fortørnet': ('fortørne',),
'fortørna': ('fortørne',),
'fortørnete': ('fortørne',),
'fortørnede': ('fortørne',),
'fortørna': ('fortørne',),
'fortørnete': ('fortørne',),
'fortørnede': ('fortørne',),
'fortørnende': ('fortørne',),
'fortøyd': ('fortøye',),
'fortøyde': ('fortøye',),
'fortøyende': ('fortøye',),
'foruleiliga': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleiligete': ('foruleilige',),
'foruleiligede': ('foruleilige',),
'foruleiliga': ('foruleilige',),
'foruleiligete': ('foruleilige',),
'foruleiligede': ('foruleilige',),
'foruleiligende': ('foruleilige',),
'forulempa': ('forulempe',),
'forulempet': ('forulempe',),
'forulempa': ('forulempe',),
'forulempet': ('forulempe',),
'forulempa': ('forulempe',),
'forulempete': ('forulempe',),
'forulempede': ('forulempe',),
'forulempa': ('forulempe',),
'forulempete': ('forulempe',),
'forulempede': ('forulempe',),
'forulempende': ('forulempe',),
'forulykka': ('forulykke',),
'forulykket': ('forulykke',),
'forulykka': ('forulykke',),
'forulykket': ('forulykke',),
'forulykka': ('forulykke',),
'forulykkete': ('forulykke',),
'forulykkede': ('forulykke',),
'forulykka': ('forulykke',),
'forulykkete': ('forulykke',),
'forulykkede': ('forulykke',),
'forulykkende': ('forulykke',),
'forunderlig': ('forunderlig',),
'forunderlige': ('forunderlig',),
'forunderlig': ('forunderlig',),
'forundra': ('forundre',),
'forundret': ('forundre',),
'forundra': ('forundre',),
'forundret': ('forundre',),
'forundra': ('forundre',),
'forundrete': ('forundre',),
'forundrede': ('forundre',),
'forundrete': ('forundre',),
'forundrede': ('forundre',),
'forundra': ('forundre',),
'forundrete': ('forundre',),
'forundrede': ('forundre',),
'forundrete': ('forundre',),
'forundrede': ('forundre',),
'forundrende': ('forundre',),
'forunt': ('forunne',),
'forunte': ('forunne',),
'forunnende': ('forunne',),
'forurensa': ('forurense',),
'forurenset': ('forurense',),
'forurensa': ('forurense',),
'forurenset': ('forurense',),
'forurensa': ('forurense',),
'forurensete': ('forurense',),
'forurensede': ('forurense',),
'forurensa': ('forurense',),
'forurensete': ('forurense',),
'forurensede': ('forurense',),
'forurensende': ('forurense',),
'foruretta': ('forurette',),
'forurettet': ('forurette',),
'foruretta': ('forurette',),
'forurettet': ('forurette',),
'foruretta': ('forurette',),
'forurettete': ('forurette',),
'forurettede': ('forurette',),
'foruretta': ('forurette',),
'forurettete': ('forurette',),
'forurettede': ('forurette',),
'forurettende': ('forurette',),
'foruroliga': ('forurolige',),
'foruroliget': ('forurolige',),
'foruroliga': ('forurolige',),
'foruroliget': ('forurolige',),
'foruroliga': ('forurolige',),
'foruroligete': ('forurolige',),
'foruroligede': ('forurolige',),
'foruroliga': ('forurolige',),
'foruroligete': ('forurolige',),
'foruroligede': ('forurolige',),
'foruroligende': ('forurolige',),
'foruroligende': ('foruroligende',),
'forutberegna': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegnete': ('forutberegne',),
'forutberegnede': ('forutberegne',),
'forutberegna': ('forutberegne',),
'forutberegnete': ('forutberegne',),
'forutberegnede': ('forutberegne',),
'forutberegnende': ('forutberegne',),
'forutbestemt': ('forutbestemme',),
'forutbestemte': ('forutbestemme',),
'forutbestemmende': ('forutbestemme',),
'forutfatta': ('forutfatta',),
'forutfattet': ('forutfattet',),
'forutfattete': ('forutfattet',),
'forutfattede': ('forutfattet',),
'forutfattete': ('forutfattet',),
'forutfattede': ('forutfattet',),
'forutfattet': ('forutfattet',),
'forutgående': ('forutgående',),
'forutinntatt': ('forutinntatt',),
'forutinntatte': ('forutinntatt',),
'forutinntatt': ('forutinntatt',),
'forutsett': ('forutse',),
'forutsette': ('forutse',),
'forutseende': ('forutse',),
'forutseende': ('forutseende',),
'forutsetningslaus': ('forutsetningslaus',),
'forutsetningslause': ('forutsetningslaus',),
'forutsetningslaust': ('forutsetningslaus',),
'forutsetningsløs': ('forutsetningsløs',),
'forutsetningsløse': ('forutsetningsløs',),
'forutsetningsløst': ('forutsetningsløs',),
'forutsatt': ('forutsette',),
'forutsatte': ('forutsette',),
'forutsettende': ('forutsette',),
'forutsigelig': ('forutsigelig',),
'forutsigelige': ('forutsigelig',),
'forutsigelig': ('forutsigelig',),
'forutskikka': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikkete': ('forutskikke',),
'forutskikkede': ('forutskikke',),
'forutskikka': ('forutskikke',),
'forutskikkete': ('forutskikke',),
'forutskikkede': ('forutskikke',),
'forutskikkende': ('forutskikke',),
'forvalta': ('forvalte',),
'forvaltet': ('forvalte',),
'forvalta': ('forvalte',),
'forvaltet': ('forvalte',),
'forvalta': ('forvalte',),
'forvaltete': ('forvalte',),
'forvaltede': ('forvalte',),
'forvalta': ('forvalte',),
'forvaltete': ('forvalte',),
'forvaltede': ('forvalte',),
'forvaltende': ('forvalte',),
'forvandla': ('forvandle',),
'forvandlet': ('forvandle',),
'forvandla': ('forvandle',),
'forvandlet': ('forvandle',),
'forvandla': ('forvandle',),
'forvandlete': ('forvandle',),
'forvandlede': ('forvandle',),
'forvandlete': ('forvandle',),
'forvandlede': ('forvandle',),
'forvandla': ('forvandle',),
'forvandlete': ('forvandle',),
'forvandlede': ('forvandle',),
'forvandlete': ('forvandle',),
'forvandlede': ('forvandle',),
'forvandlende': ('forvandle',),
'forvanska': ('forvanske',),
'forvansket': ('forvanske',),
'forvanska': ('forvanske',),
'forvansket': ('forvanske',),
'forvanska': ('forvanske',),
'forvanskete': ('forvanske',),
'forvanskede': ('forvanske',),
'forvanska': ('forvanske',),
'forvanskete': ('forvanske',),
'forvanskede': ('forvanske',),
'forvanskende': ('forvanske',),
'forvart': ('forvare',),
'forvarte': ('forvare',),
'forvarende': ('forvare',),
'forveda': ('forvede',),
'forvedet': ('forvede',),
'forveda': ('forvede',),
'forvedet': ('forvede',),
'forveda': ('forvede',),
'forvedete': ('forvede',),
'forvedede': ('forvede',),
'forveda': ('forvede',),
'forvedete': ('forvede',),
'forvedede': ('forvede',),
'forvedende': ('forvede',),
'forveksla': ('forveksle',),
'forvekslet': ('forveksle',),
'forveksla': ('forveksle',),
'forvekslet': ('forveksle',),
'forveksla': ('forveksle',),
'forvekslete': ('forveksle',),
'forvekslede': ('forveksle',),
'forvekslete': ('forveksle',),
'forvekslede': ('forveksle',),
'forveksla': ('forveksle',),
'forvekslete': ('forveksle',),
'forvekslede': ('forveksle',),
'forvekslete': ('forveksle',),
'forvekslede': ('forveksle',),
'forvekslende': ('forveksle',),
'forvella': ('forvelle',),
'forvellet': ('forvelle',),
'forvelt': ('forvelle',),
'forvella': ('forvelle',),
'forvellet': ('forvelle',),
'forvelt': ('forvelle',),
'forvella': ('forvelle',),
'forvellete': ('forvelle',),
'forvellede': ('forvelle',),
'forvelte': ('forvelle',),
'forvella': ('forvelle',),
'forvellete': ('forvelle',),
'forvellede': ('forvelle',),
'forvelte': ('forvelle',),
'forvellende': ('forvelle',),
'forvent': ('forvenne',),
'forvente': ('forvenne',),
'forvennende': ('forvenne',),
'forvent': ('forvent',),
'forvente': ('forvent',),
'forvent': ('forvent',),
'forventa': ('forvente',),
'forventet': ('forvente',),
'forventa': ('forvente',),
'forventet': ('forvente',),
'forventa': ('forvente',),
'forventete': ('forvente',),
'forventede': ('forvente',),
'forventa': ('forvente',),
'forventete': ('forvente',),
'forventede': ('forvente',),
'forventende': ('forvente',),
'forventningsfull': ('forventningsfull',),
'forventningsfulle': ('forventningsfull',),
'forventningsfullt': ('forventningsfull',),
'forverra': ('forverre',),
'forverret': ('forverre',),
'forverra': ('forverre',),
'forverret': ('forverre',),
'forverra': ('forverre',),
'forverrete': ('forverre',),
'forverrede': ('forverre',),
'forverra': ('forverre',),
'forverrete': ('forverre',),
'forverrede': ('forverre',),
'forverrende': ('forverre',),
'forvilla': ('forville',),
'forvillet': ('forville',),
'forvilla': ('forville',),
'forvillet': ('forville',),
'forvilla': ('forville',),
'forvillete': ('forville',),
'forvillede': ('forville',),
'forvilla': ('forville',),
'forvillete': ('forville',),
'forvillede': ('forville',),
'forvillende': ('forville',),
'forvirra': ('forvirra',),
'forvirra': ('forvirre',),
'forvirret': ('forvirre',),
'forvirra': ('forvirre',),
'forvirret': ('forvirre',),
'forvirra': ('forvirre',),
'forvirrete': ('forvirre',),
'forvirrede': ('forvirre',),
'forvirra': ('forvirre',),
'forvirrete': ('forvirre',),
'forvirrede': ('forvirre',),
'forvirrende': ('forvirre',),
'forvirret': ('forvirret',),
'forvirrete': ('forvirret',),
'forvirrede': ('forvirret',),
'forvirrete': ('forvirret',),
'forvirrede': ('forvirret',),
'forvirret': ('forvirret',),
'forvist': ('forvise',),
'forviste': ('forvise',),
'forvisende': ('forvise',),
'forvissa': ('forvisse',),
'forvisset': ('forvisse',),
'forvissa': ('forvisse',),
'forvisset': ('forvisse',),
'forvissa': ('forvisse',),
'forvissete': ('forvisse',),
'forvissede': ('forvisse',),
'forvissa': ('forvisse',),
'forvissete': ('forvisse',),
'forvissede': ('forvisse',),
'forvissende': ('forvisse',),
'forviten': ('forviten',),
'forvitne': ('forviten',),
'forvitent': ('forviten',),
'forvitra': ('forvitre',),
'forvitret': ('forvitre',),
'forvitra': ('forvitre',),
'forvitret': ('forvitre',),
'forvitra': ('forvitre',),
'forvitrete': ('forvitre',),
'forvitrede': ('forvitre',),
'forvitrete': ('forvitre',),
'forvitrede': ('forvitre',),
'forvitra': ('forvitre',),
'forvitrete': ('forvitre',),
'forvitrede': ('forvitre',),
'forvitrete': ('forvitre',),
'forvitrede': ('forvitre',),
'forvitrende': ('forvitre',),
'forvokst': ('forvokst',),
'forvokste': ('forvokst',),
'forvokst': ('forvokst',),
'forvoldt': ('forvolde',),
'forvoldte': ('forvolde',),
'forvoldende': ('forvolde',),
'forvorpen': ('forvorpen',),
'forvorpne': ('forvorpen',),
'forvorpent': ('forvorpen',),
'forvrengt': ('forvrenge',),
'forvrengte': ('forvrenge',),
'forvrengende': ('forvrenge',),
'forvridd': ('forvri',),
'forvridde': ('forvri',),
'forvriende': ('forvri',),
'forvrøvla': ('forvrøvla',),
'forvrøvlet': ('forvrøvlet',),
'forvrøvlete': ('forvrøvlet',),
'forvrøvlede': ('forvrøvlet',),
'forvrøvlete': ('forvrøvlet',),
'forvrøvlede': ('forvrøvlet',),
'forvrøvlet': ('forvrøvlet',),
'forvåka': ('forvåka',),
'forvåket': ('forvåket',),
'forvåkete': ('forvåket',),
'forvåkede': ('forvåket',),
'forvåkete': ('forvåket',),
'forvåkede': ('forvåket',),
'forvåket': ('forvåket',),
'forvåkt': ('forvåkt',),
'forvåkte': ('forvåkt',),
'forvåkt': ('forvåkt',),
'forynga': ('forynge',),
'forynget': ('forynge',),
'forynga': ('forynge',),
'forynget': ('forynge',),
'forynga': ('forynge',),
'foryngete': ('forynge',),
'foryngede': ('forynge',),
'forynga': ('forynge',),
'foryngete': ('forynge',),
'foryngede': ('forynge',),
'foryngende': ('forynge',),
'forårsaka': ('forårsake',),
'forårsaket': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsaket': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsakete': ('forårsake',),
'forårsakede': ('forårsake',),
'forårsaka': ('forårsake',),
'forårsakete': ('forårsake',),
'forårsakede': ('forårsake',),
'forårsakende': ('forårsake',),
'forært': ('forære',),
'forærte': ('forære',),
'forærende': ('forære',),
'forøda': ('forøde',),
'forødet': ('forøde',),
'forødt': ('forøde',),
'forøda': ('forøde',),
'forødet': ('forøde',),
'forødt': ('forøde',),
'forøda': ('forøde',),
'forødete': ('forøde',),
'forødede': ('forøde',),
'forødte': ('forøde',),
'forøda': ('forøde',),
'forødete': ('forøde',),
'forødede': ('forøde',),
'forødte': ('forøde',),
'forødende': ('forøde',),
'forøka': ('forøke',),
'forøket': ('forøke',),
'forøkt': ('forøke',),
'forøka': ('forøke',),
'forøket': ('forøke',),
'forøkt': ('forøke',),
'forøka': ('forøke',),
'forøkete': ('forøke',),
'forøkede': ('forøke',),
'forøkte': ('forøke',),
'forøka': ('forøke',),
'forøkete': ('forøke',),
'forøkede': ('forøke',),
'forøkte': ('forøke',),
'forøkende': ('forøke',),
'forønska': ('forønska',),
'forønsket': ('forønsket',),
'forønskete': ('forønsket',),
'forønskede': ('forønsket',),
'forønskete': ('forønsket',),
'forønskede': ('forønsket',),
'forønsket': ('forønsket',),
'forøva': ('forøve',),
'forøvet': ('forøve',),
'forøvd': ('forøve',),
'forøva': ('forøve',),
'forøvet': ('forøve',),
'forøvd': ('forøve',),
'forøva': ('forøve',),
'forøvete': ('forøve',),
'forøvede': ('forøve',),
'forøvde': ('forøve',),
'forøva': ('forøve',),
'forøvete': ('forøve',),
'forøvede': ('forøve',),
'forøvde': ('forøve',),
'forøvende': ('forøve',),
'fosforescert': ('fosforescere',),
'fosforescerte': ('fosforescere',),
'fosforescerende': ('fosforescere',),
'fosforsur': ('fosforsur',),
'fosforsure': ('fosforsur',),
'fosforsurt': ('fosforsur',),
'fossa': ('fosse',),
'fosset': ('fosse',),
'fossa': ('fosse',),
'fosset': ('fosse',),
'fossa': ('fosse',),
'fossete': ('fosse',),
'fossede': ('fosse',),
'fossa': ('fosse',),
'fossete': ('fosse',),
'fossede': ('fosse',),
'fossende': ('fosse',),
'fossil': ('fossil',),
'fossile': ('fossil',),
'fossilt': ('fossil',),
'fosskokt': ('fosskoke',),
'fosskokte': ('fosskoke',),
'fosskokende': ('fosskoke',),
'fossregna': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnt': ('fossregne',),
'fossregna': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnt': ('fossregne',),
'fossregna': ('fossregne',),
'fossregnete': ('fossregne',),
'fossregnede': ('fossregne',),
'fossregnte': ('fossregne',),
'fossregna': ('fossregne',),
'fossregnete': ('fossregne',),
'fossregnede': ('fossregne',),
'fossregnte': ('fossregne',),
'fossregnende': ('fossregne',),
'fossrodd': ('fossro',),
'fossrodde': ('fossro',),
'fossroende': ('fossro',),
'fostra': ('fostre',),
'fostret': ('fostre',),
'fostra': ('fostre',),
'fostret': ('fostre',),
'fostra': ('fostre',),
'fostrete': ('fostre',),
'fostrede': ('fostre',),
'fostrete': ('fostre',),
'fostrede': ('fostre',),
'fostra': ('fostre',),
'fostrete': ('fostre',),
'fostrede': ('fostre',),
'fostrete': ('fostre',),
'fostrede': ('fostre',),
'fostrende': ('fostre',),
'fota': ('fote',),
'fotet': ('fote',),
'fota': ('fote',),
'fotet': ('fote',),
'fota': ('fote',),
'fotete': ('fote',),
'fotede': ('fote',),
'fota': ('fote',),
'fotete': ('fote',),
'fotede': ('fote',),
'fotende': ('fote',),
'fotogen': ('fotogen',),
'fotogene': ('fotogen',),
'fotogent': ('fotogen',),
'fotografert': ('fotografere',),
'fotograferte': ('fotografere',),
'fotograferende': ('fotografere',),
'fotografisk': ('fotografisk',),
'fotografiske': ('fotografisk',),
'fotografisk': ('fotografisk',),
'fotokopiert': ('fotokopiere',),
'fotokopierte': ('fotokopiere',),
'fotokopierende': ('fotokopiere',),
'fotostatisk': ('fotostatisk',),
'fotostatiske': ('fotostatisk',),
'fotostatisk': ('fotostatisk',),
'fotosyntetisk': ('fotosyntetisk',),
'fotosyntetiske': ('fotosyntetisk',),
'fotosyntetisk': ('fotosyntetisk',),
'fototaktisk': ('fototaktisk',),
'fototaktiske': ('fototaktisk',),
'fototaktisk': ('fototaktisk',),
'fotsid': ('fotsid',),
'fotside': ('fotsid',),
'fotsidt': ('fotsid',),
'frabedt': ('frabe',),
'frabedte': ('frabe',),
'frabeende': ('frabe',),
'frabeordra': ('frabeordre',),
'frabeordret': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordret': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordrete': ('frabeordre',),
'frabeordrede': ('frabeordre',),
'frabeordrete': ('frabeordre',),
'frabeordrede': ('frabeordre',),
'frabeordra': ('frabeordre',),
'frabeordrete': ('frabeordre',),
'frabeordrede': ('frabeordre',),
'frabeordrete': ('frabeordre',),
'frabeordrede': ('frabeordre',),
'frabeordrende': ('frabeordre',),
'fradragsberettiga': ('fradragsberettiga',),
'fradragsberettiget': ('fradragsberettiget',),
'fradragsberettigete': ('fradragsberettiget',),
'fradragsberettigede': ('fradragsberettiget',),
'fradragsberettigete': ('fradragsberettiget',),
'fradragsberettigede': ('fradragsberettiget',),
'fradragsberettiget': ('fradragsberettiget',),
'fradømt': ('fradømme',),
'fradømte': ('fradømme',),
'fradømmende': ('fradømme',),
'frafallen': ('frafallen',),
'frafalne': ('frafallen',),
'frafallent': ('frafallen',),
'fraflytta': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflyttete': ('fraflytte',),
'fraflyttede': ('fraflytte',),
'fraflytta': ('fraflytte',),
'fraflyttete': ('fraflytte',),
'fraflyttede': ('fraflytte',),
'fraflyttende': ('fraflytte',),
'fragil': ('fragil',),
'fragile': ('fragil',),
'fragilt': ('fragil',),
'fragmentarisk': ('fragmentarisk',),
'fragmentariske': ('fragmentarisk',),
'fragmentarisk': ('fragmentarisk',),
'fragmentert': ('fragmentere',),
'fragmenterte': ('fragmentere',),
'fragmenterende': ('fragmentere',),
'fragått': ('fragå',),
'fragåtte': ('fragå',),
'fragående': ('fragå',),
'fraise': ('fraise',),
'frakjent': ('frakjenne',),
'frakjente': ('frakjenne',),
'frakjennende': ('frakjenne',),
'frakobla': ('frakobla',),
'frakobla': ('frakoble',),
'frakoblet': ('frakoble',),
'frakobla': ('frakoble',),
'frakoblet': ('frakoble',),
'frakobla': ('frakoble',),
'frakoblete': ('frakoble',),
'frakoblede': ('frakoble',),
'frakoblete': ('frakoble',),
'frakoblede': ('frakoble',),
'frakobla': ('frakoble',),
'frakoblete': ('frakoble',),
'frakoblede': ('frakoble',),
'frakoblete': ('frakoble',),
'frakoblede': ('frakoble',),
'frakoblende': ('frakoble',),
'frakoblet': ('frakoblet',),
'frakoblete': ('frakoblet',),
'frakoblede': ('frakoblet',),
'frakoblete': ('frakoblet',),
'frakoblede': ('frakoblet',),
'frakoblet': ('frakoblet',),
'frakopla': ('frakopla',),
'frakopla': ('frakople',),
'frakoplet': ('frakople',),
'frakopla': ('frakople',),
'frakoplet': ('frakople',),
'frakopla': ('frakople',),
'frakoplete': ('frakople',),
'frakoplede': ('frakople',),
'frakoplete': ('frakople',),
'frakoplede': ('frakople',),
'frakopla': ('frakople',),
'frakoplete': ('frakople',),
'frakoplede': ('frakople',),
'frakoplete': ('frakople',),
'frakoplede': ('frakople',),
'frakoplende': ('frakople',),
'frakoplet': ('frakoplet',),
'frakoplete': ('frakoplet',),
'frakoplede': ('frakoplet',),
'frakoplete': ('frakoplet',),
'frakoplede': ('frakoplet',),
'frakoplet': ('frakoplet',),
'fraksjonert': ('fraksjonere',),
'fraksjonerte': ('fraksjonere',),
'fraksjonerende': ('fraksjonere',),
'fraktal': ('fraktal',),
'fraktale': ('fraktal',),
'fraktalt': ('fraktal',),
'frakta': ('frakte',),
'fraktet': ('frakte',),
'frakta': ('frakte',),
'fraktet': ('frakte',),
'frakta': ('frakte',),
'fraktete': ('frakte',),
'fraktede': ('frakte',),
'frakta': ('frakte',),
'fraktete': ('frakte',),
'fraktede': ('frakte',),
'fraktende': ('frakte',),
'fralands': ('fralands',),
'fralagt': ('fralegge',),
'fralagte': ('fralegge',),
'fraleggende': ('fralegge',),
'fralokka': ('fralokke',),
'fralokket': ('fralokke',),
'fralokka': ('fralokke',),
'fralokket': ('fralokke',),
'fralokka': ('fralokke',),
'fralokkete': ('fralokke',),
'fralokkede': ('fralokke',),
'fralokka': ('fralokke',),
'fralokkete': ('fralokke',),
'fralokkede': ('fralokke',),
'fralokkende': ('fralokke',),
'framdatert': ('framdatere',),
'framdaterte': ('framdatere',),
'framdaterende': ('framdatere',),
'framelska': ('framelske',),
'framelsket': ('framelske',),
'framelska': ('framelske',),
'framelsket': ('framelske',),
'framelska': ('framelske',),
'framelskete': ('framelske',),
'framelskede': ('framelske',),
'framelska': ('framelske',),
'framelskete': ('framelske',),
'framelskede': ('framelske',),
'framelskende': ('framelske',),
'framfaren': ('framfaren',),
'framfarne': ('framfaren',),
'framfarent': ('framfaren',),
'framfus': ('framfus',),
'framfuse': ('framfus',),
'framfust': ('framfus',),
'framfusende': ('framfusende',),
'framført': ('framføre',),
'framførte': ('framføre',),
'framførende': ('framføre',),
'framgangsrik': ('framgangsrik',),
'framgangsrike': ('framgangsrik',),
'framgangsrikt': ('framgangsrik',),
'framgått': ('framgå',),
'framgåtte': ('framgå',),
'framgående': ('framgå',),
'framherskende': ('framherskende',),
'framheva': ('framheve',),
'framhevet': ('framheve',),
'framhevd': ('framheve',),
'framheva': ('framheve',),
'framhevet': ('framheve',),
'framhevd': ('framheve',),
'framheva': ('framheve',),
'framhevete': ('framheve',),
'framhevede': ('framheve',),
'framhevde': ('framheve',),
'framheva': ('framheve',),
'framhevete': ('framheve',),
'framhevede': ('framheve',),
'framhevde': ('framheve',),
'framhevende': ('framheve',),
'framholdt': ('framholde',),
'framholdte': ('framholde',),
'framholdende': ('framholde',),
'framifrå': ('framifrå',),
'framkalt': ('framkalle',),
'framkalte': ('framkalle',),
'framkallende': ('framkalle',),
'framkasta': ('framkaste',),
'framkastet': ('framkaste',),
'framkasta': ('framkaste',),
'framkastet': ('framkaste',),
'framkasta': ('framkaste',),
'framkastete': ('framkaste',),
'framkastede': ('framkaste',),
'framkasta': ('framkaste',),
'framkastete': ('framkaste',),
'framkastede': ('framkaste',),
'framkastende': ('framkaste',),
'framkommelig': ('framkommelig',),
'framkommelige': ('framkommelig',),
'framkommelig': ('framkommelig',),
'framlagt': ('framlegge',),
'framlagte': ('framlegge',),
'framleggende': ('framlegge',),
'framleid': ('framleie',),
'framleide': ('framleie',),
'framleiende': ('framleie',),
'framlut': ('framlut',),
'framlute': ('framlut',),
'framlutt': ('framlut',),
'frammøtt': ('frammøtt',),
'frammøtte': ('frammøtt',),
'frammøtt': ('frammøtt',),
'framoverbøyd': ('framoverbøyd',),
'framoverbøyde': ('framoverbøyd',),
'framoverbøyd': ('framoverbøyd',),
'framoverlut': ('framoverlut',),
'framoverlute': ('framoverlut',),
'framoverlutt': ('framoverlut',),
'framsatt': ('framsette',),
'framsatte': ('framsette',),
'framsettende': ('framsette',),
'framsagt': ('framsi',),
'framsagte': ('framsi',),
'framsiende': ('framsi',),
'framskaffa': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffete': ('framskaffe',),
'framskaffede': ('framskaffe',),
'framskaffa': ('framskaffe',),
'framskaffete': ('framskaffe',),
'framskaffede': ('framskaffe',),
'framskaffende': ('framskaffe',),
'framskreden': ('framskreden',),
'framskredne': ('framskreden',),
'framskredent': ('framskreden',),
'framskrittsfiendtlig': ('framskrittsfiendtlig',),
'framskrittsfiendtlige': ('framskrittsfiendtlig',),
'framskrittsfiendtlig': ('framskrittsfiendtlig',),
'framskrittsvennlig': ('framskrittsvennlig',),
'framskrittsvennlige': ('framskrittsvennlig',),
'framskrittsvennlig': ('framskrittsvennlig',),
'framskrevet': ('framskrive',),
'framskreven': ('framskrive',),
'framskrevne': ('framskrive',),
'framskrivende': ('framskrive',),
'framskutt': ('framskutt',),
'framskutte': ('framskutt',),
'framskutt': ('framskutt',),
'framskynda': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndt': ('framskynde',),
'framskynda': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndt': ('framskynde',),
'framskynda': ('framskynde',),
'framskyndete': ('framskynde',),
'framskyndede': ('framskynde',),
'framskyndte': ('framskynde',),
'framskynda': ('framskynde',),
'framskyndete': ('framskynde',),
'framskyndede': ('framskynde',),
'framskyndte': ('framskynde',),
'framskyndende': ('framskynde',),
'framskutt': ('framskyte',),
'framskutte': ('framskyte',),
'framskytende': ('framskyte',),
'framspringende': ('framspringende',),
'framstilt': ('framstille',),
'framstilte': ('framstille',),
'framstillende': ('framstille',),
'framstått': ('framstå',),
'framståtte': ('framstå',),
'framstående': ('framstå',),
'framstående': ('framstående',),
'framsynt': ('framsynt',),
'framsynte': ('framsynt',),
'framsynt': ('framsynt',),
'framtidig': ('framtidig',),
'framtidige': ('framtidig',),
'framtidig': ('framtidig',),
'framtidsretta': ('framtidsretta',),
'framtidsrettet': ('framtidsrettet',),
'framtidsrettete': ('framtidsrettet',),
'framtidsrettede': ('framtidsrettet',),
'framtidsrettete': ('framtidsrettet',),
'framtidsrettede': ('framtidsrettet',),
'framtidsrettet': ('framtidsrettet',),
'framtredende': ('framtredende',),
'framvist': ('framvise',),
'framviste': ('framvise',),
'framvisende': ('framvise',),
'franarra': ('franarre',),
'franarret': ('franarre',),
'franarra': ('franarre',),
'franarret': ('franarre',),
'franarra': ('franarre',),
'franarrete': ('franarre',),
'franarrede': ('franarre',),
'franarra': ('franarre',),
'franarrete': ('franarre',),
'franarrede': ('franarre',),
'franarrende': ('franarre',),
'frank': ('frank',),
'franke': ('frank',),
'frankt': ('frank',),
'frankert': ('frankere',),
'frankerte': ('frankere',),
'frankerende': ('frankere',),
'frankofil': ('frankofil',),
'frankofile': ('frankofil',),
'frankofilt': ('frankofil',),
'frankoman': ('frankoman',),
'frankomane': ('frankoman',),
'frankomant': ('frankoman',),
'fransk': ('fransk',),
'franske': ('fransk',),
'fransk': ('fransk',),
'frappant': ('frappant',),
'frappante': ('frappant',),
'frappantt': ('frappant',),
'frappert': ('frappere',),
'frapperte': ('frappere',),
'frapperende': ('frappere',),
'frapperende': ('frapperende',),
'frarana': ('frarane',),
'fraranet': ('frarane',),
'frarant': ('frarane',),
'frarana': ('frarane',),
'fraranet': ('frarane',),
'frarant': ('frarane',),
'frarana': ('frarane',),
'fraranete': ('frarane',),
'fraranede': ('frarane',),
'frarante': ('frarane',),
'frarana': ('frarane',),
'fraranete': ('frarane',),
'fraranede': ('frarane',),
'frarante': ('frarane',),
'fraranende': ('frarane',),
'fraregna': ('fraregna',),
'fraregnet': ('fraregnet',),
'fraregnete': ('fraregnet',),
'fraregnede': ('fraregnet',),
'fraregnete': ('fraregnet',),
'fraregnede': ('fraregnet',),
'fraregnet': ('fraregnet',),
'frarådd': ('frarå',),
'frarådde': ('frarå',),
'frarående': ('frarå',),
'frarådet': ('fraråde',),
'frarådd': ('fraråde',),
'frarådet': ('fraråde',),
'frarådd': ('fraråde',),
'frarådete': ('fraråde',),
'frarådede': ('fraråde',),
'frarådde': ('fraråde',),
'frarådete': ('fraråde',),
'frarådede': ('fraråde',),
'frarådde': ('fraråde',),
'frarådende': ('fraråde',),
'frasefylt': ('frasefylt',),
'frasefylte': ('frasefylt',),
'frasefylt': ('frasefylt',),
'frasolgt': ('fraselge',),
'frasolgte': ('fraselge',),
'fraselgende': ('fraselge',),
'fraseologisk': ('fraseologisk',),
'fraseologiske': ('fraseologisk',),
'fraseologisk': ('fraseologisk',),
'fraseparert': ('fraseparert',),
'fraseparerte': ('fraseparert',),
'fraseparert': ('fraseparert',),
'frasert': ('frasere',),
'fraserte': ('frasere',),
'fraserende': ('frasere',),
'frasagt': ('frasi',),
'frasagte': ('frasi',),
'frasiende': ('frasi',),
'fraskilt': ('fraskille',),
'fraskilte': ('fraskille',),
'fraskillende': ('fraskille',),
'fraskjøta': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtt': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtt': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøtete': ('fraskjøte',),
'fraskjøtede': ('fraskjøte',),
'fraskjøtte': ('fraskjøte',),
'fraskjøta': ('fraskjøte',),
'fraskjøtete': ('fraskjøte',),
'fraskjøtede': ('fraskjøte',),
'fraskjøtte': ('fraskjøte',),
'fraskjøtende': ('fraskjøte',),
'fraskrevet': ('fraskrive',),
'fraskreven': ('fraskrive',),
'fraskrevne': ('fraskrive',),
'fraskrivende': ('fraskrive',),
'frastjålet': ('frastjele',),
'frastjålen': ('frastjele',),
'frastjålne': ('frastjele',),
'frastjelende': ('frastjele',),
'frastøtt': ('frastøte',),
'frastøtte': ('frastøte',),
'frastøtende': ('frastøte',),
'frastøtende': ('frastøtende',),
'fratatt': ('frata',),
'fratatte': ('frata',),
'fratakende': ('frata',),
'fraternisert': ('fraternisere',),
'fraterniserte': ('fraternisere',),
'fraterniserende': ('fraternisere',),
'fratrådt': ('fratre',),
'fratrådte': ('fratre',),
'fratredende': ('fratre',),
'fraveket': ('fravike',),
'fraveken': ('fravike',),
'fravekne': ('fravike',),
'fravikende': ('fravike',),
'fravikelig': ('fravikelig',),
'fravikelige': ('fravikelig',),
'fravikelig': ('fravikelig',),
'fravrista': ('fravriste',),
'fravristet': ('fravriste',),
'fravrista': ('fravriste',),
'fravristet': ('fravriste',),
'fravrista': ('fravriste',),
'fravristete': ('fravriste',),
'fravristede': ('fravriste',),
'fravrista': ('fravriste',),
'fravristete': ('fravriste',),
'fravristede': ('fravriste',),
'fravristende': ('fravriste',),
'fraværende': ('fraværende',),
'freda': ('frede',),
'fredet': ('frede',),
'freda': ('frede',),
'fredet': ('frede',),
'freda': ('frede',),
'fredete': ('frede',),
'fredede': ('frede',),
'freda': ('frede',),
'fredete': ('frede',),
'fredede': ('frede',),
'fredende': ('frede',),
'fredelig': ('fredelig',),
'fredelige': ('fredelig',),
'fredelig': ('fredelig',),
'fredeligere': ('fredelig',),
'fredeligst': ('fredelig',),
'fredeligste': ('fredelig',),
'fredeligsinna': ('fredeligsinna',),
'fredeligsinnet': ('fredeligsinnet',),
'fredeligsinnete': ('fredeligsinnet',),
'fredeligsinnede': ('fredeligsinnet',),
'fredeligsinnete': ('fredeligsinnet',),
'fredeligsinnede': ('fredeligsinnet',),
'fredeligsinnet': ('fredeligsinnet',),
'fredfull': ('fredfull',),
'fredfulle': ('fredfull',),
'fredfullt': ('fredfull',),
'fredhellig': ('fredhellig',),
'fredhellige': ('fredhellig',),
'fredhellig': ('fredhellig',),
'fredlaus': ('fredlaus',),
'fredlause': ('fredlaus',),
'fredlaust': ('fredlaus',),
'fredløs': ('fredløs',),
'fredløse': ('fredløs',),
'fredløst': ('fredløs',),
'fredsbevarende': ('fredsbevarende',),
'fredselskende': ('fredselskende',),
'fredsommelig': ('fredsommelig',),
'fredsommelige': ('fredsommelig',),
'fredsommelig': ('fredsommelig',),
'fredsæl': ('fredsæl',),
'fredsæle': ('fredsæl',),
'fredsælt': ('fredsæl',),
'frega': ('frege',),
'freget': ('frege',),
'frega': ('frege',),
'freget': ('frege',),
'frega': ('frege',),
'fregete': ('frege',),
'fregede': ('frege',),
'frega': ('frege',),
'fregete': ('frege',),
'fregede': ('frege',),
'fregende': ('frege',),
'fregnet': ('fregnet',),
'fregnete': ('fregnet',),
'fregnet': ('fregnet',),
'fregnete': ('fregnete',),
'freidig': ('freidig',),
'freidige': ('freidig',),
'freidig': ('freidig',),
'freidigere': ('freidig',),
'freidigst': ('freidig',),
'freidigste': ('freidig',),
'frekk': ('frekk',),
'frekke': ('frekk',),
'frekt': ('frekk',),
'frekkere': ('frekk',),
'frekkest': ('frekk',),
'frekkeste': ('frekk',),
'frekvent': ('frekvent',),
'frekvente': ('frekvent',),
'frekvent': ('frekvent',),
'frekventert': ('frekventere',),
'frekventerte': ('frekventere',),
'frekventerende': ('frekventere',),
'frelst': ('frelse',),
'frelste': ('frelse',),
'frelsende': ('frelse',),
'frelst': ('frelst',),
'frelste': ('frelst',),
'frelst': ('frelst',),
'fremadretta': ('fremadretta',),
'fremadrettet': ('fremadrettet',),
'fremadrettete': ('fremadrettet',),
'fremadrettede': ('fremadrettet',),
'fremadrettete': ('fremadrettet',),
'fremadrettede': ('fremadrettet',),
'fremadrettet': ('fremadrettet',),
'fremadstormende': ('fremadstormende',),
'fremadstrebende': ('fremadstrebende',),
'fremdatert': ('fremdatere',),
'fremdaterte': ('fremdatere',),
'fremdaterende': ('fremdatere',),
'fremelska': ('fremelske',),
'fremelsket': ('fremelske',),
'fremelska': ('fremelske',),
'fremelsket': ('fremelske',),
'fremelska': ('fremelske',),
'fremelskete': ('fremelske',),
'fremelskede': ('fremelske',),
'fremelska': ('fremelske',),
'fremelskete': ('fremelske',),
'fremelskede': ('fremelske',),
'fremelskende': ('fremelske',),
'fremfaren': ('fremfaren',),
'fremfarne': ('fremfaren',),
'fremfarent': ('fremfaren',),
'fremfus': ('fremfus',),
'fremfuse': ('fremfus',),
'fremfust': ('fremfus',),
'fremfusende': ('fremfusende',),
'fremført': ('fremføre',),
'fremførte': ('fremføre',),
'fremførende': ('fremføre',),
'fremgangsrik': ('fremgangsrik',),
'fremgangsrike': ('fremgangsrik',),
'fremgangsrikt': ('fremgangsrik',),
'fremgått': ('fremgå',),
'fremgåtte': ('fremgå',),
'fremgående': ('fremgå',),
'fremherskende': ('fremherskende',),
'fremheva': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhevd': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhevd': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevete': ('fremheve',),
'fremhevede': ('fremheve',),
'fremhevde': ('fremheve',),
'fremheva': ('fremheve',),
'fremhevete': ('fremheve',),
'fremhevede': ('fremheve',),
'fremhevde': ('fremheve',),
'fremhevende': ('fremheve',),
'fremholdt': ('fremholde',),
'fremholdte': ('fremholde',),
'fremholdende': ('fremholde',),
'fremkalt': ('fremkalle',),
'fremkalte': ('fremkalle',),
'fremkallende': ('fremkalle',),
'fremkasta': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkastete': ('fremkaste',),
'fremkastede': ('fremkaste',),
'fremkasta': ('fremkaste',),
'fremkastete': ('fremkaste',),
'fremkastede': ('fremkaste',),
'fremkastende': ('fremkaste',),
'fremkommelig': ('fremkommelig',),
'fremkommelige': ('fremkommelig',),
'fremkommelig': ('fremkommelig',),
'fremlagt': ('fremlegge',),
'fremlagte': ('fremlegge',),
'fremleggende': ('fremlegge',),
'fremleid': ('fremleie',),
'fremleide': ('fremleie',),
'fremleiende': ('fremleie',),
'fremlut': ('fremlut',),
'fremlute': ('fremlut',),
'fremlutt': ('fremlut',),
'fremma': ('fremme',),
'fremmet': ('fremme',),
'fremma': ('fremme',),
'fremmet': ('fremme',),
'fremma': ('fremme',),
'fremmete': ('fremme',),
'fremmede': ('fremme',),
'fremma': ('fremme',),
'fremmete': ('fremme',),
'fremmede': ('fremme',),
'fremmende': ('fremme',),
'fremmed': ('fremmed',),
'fremmede': ('fremmed',),
'fremmed': ('fremmed',),
'fremmedarta': ('fremmedarta',),
'fremmedartet': ('fremmedartet',),
'fremmedartete': ('fremmedartet',),
'fremmedartede': ('fremmedartet',),
'fremmedartete': ('fremmedartet',),
'fremmedartede': ('fremmedartet',),
'fremmedartet': ('fremmedartet',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjorte': ('fremmedgjøre',),
'fremmedgjørende': ('fremmedgjøre',),
'fremmedspråklig': ('fremmedspråklig',),
'fremmedspråklige': ('fremmedspråklig',),
'fremmedspråklig': ('fremmedspråklig',),
'fremmelig': ('fremmelig',),
'fremmelige': ('fremmelig',),
'fremmelig': ('fremmelig',),
'fremmøtt': ('fremmøtt',),
'fremmøtte': ('fremmøtt',),
'fremmøtt': ('fremmøtt',),
'fremoverbøyd': ('fremoverbøyd',),
'fremoverbøyde': ('fremoverbøyd',),
'fremoverbøyd': ('fremoverbøyd',),
'fremoverlut': ('fremoverlut',),
'fremoverlute': ('fremoverlut',),
'fremoverlutt': ('fremoverlut',),
'fremragende': ('fremragende',),
'fremre': ('fremre',),
'fremst': ('fremre',),
'fremste': ('fremre',),
'fremsatt': ('fremsette',),
'fremsatte': ('fremsette',),
'fremsettende': ('fremsette',),
'fremsagt': ('fremsi',),
'fremsagte': ('fremsi',),
'fremsiende': ('fremsi',),
'fremskaffa': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffete': ('fremskaffe',),
'fremskaffede': ('fremskaffe',),
'fremskaffa': ('fremskaffe',),
'fremskaffete': ('fremskaffe',),
'fremskaffede': ('fremskaffe',),
'fremskaffende': ('fremskaffe',),
'fremskreden': ('fremskreden',),
'fremskredne': ('fremskreden',),
'fremskredent': ('fremskreden',),
'fremskrittsfiendtlig': ('fremskrittsfiendtlig',),
'fremskrittsfiendtlige': ('fremskrittsfiendtlig',),
'fremskrittsfiendtlig': ('fremskrittsfiendtlig',),
'fremskrittsvennlig': ('fremskrittsvennlig',),
'fremskrittsvennlige': ('fremskrittsvennlig',),
'fremskrittsvennlig': ('fremskrittsvennlig',),
'fremskrevet': ('fremskrive',),
'fremskreven': ('fremskrive',),
'fremskrevne': ('fremskrive',),
'fremskrivende': ('fremskrive',),
'fremskutt': ('fremskutt',),
'fremskutte': ('fremskutt',),
'fremskutt': ('fremskutt',),
'fremskynda': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndt': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndt': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskyndete': ('fremskynde',),
'fremskyndede': ('fremskynde',),
'fremskyndte': ('fremskynde',),
'fremskynda': ('fremskynde',),
'fremskyndete': ('fremskynde',),
'fremskyndede': ('fremskynde',),
'fremskyndte': ('fremskynde',),
'fremskyndende': ('fremskynde',),
'fremskutt': ('fremskyte',),
'fremskutte': ('fremskyte',),
'fremskytende': ('fremskyte',),
'fremspringende': ('fremspringende',),
'fremst': ('fremst',),
'fremste': ('fremst',),
'fremst': ('fremst',),
'fremstilt': ('fremstille',),
'fremstilte': ('fremstille',),
'fremstillende': ('fremstille',),
'fremstått': ('fremstå',),
'fremståtte': ('fremstå',),
'fremstående': ('fremstå',),
'fremstående': ('fremstående',),
'fremsynt': ('fremsynt',),
'fremsynte': ('fremsynt',),
'fremsynt': ('fremsynt',),
'fremtidig': ('fremtidig',),
'fremtidige': ('fremtidig',),
'fremtidig': ('fremtidig',),
'fremtidsretta': ('fremtidsretta',),
'fremtidsrettet': ('fremtidsrettet',),
'fremtidsrettete': ('fremtidsrettet',),
'fremtidsrettede': ('fremtidsrettet',),
'fremtidsrettete': ('fremtidsrettet',),
'fremtidsrettede': ('fremtidsrettet',),
'fremtidsrettet': ('fremtidsrettet',),
'fremtredende': ('fremtredende',),
'fremvist': ('fremvise',),
'fremviste': ('fremvise',),
'fremvisende': ('fremvise',),
'frenetisk': ('frenetisk',),
'frenetiske': ('frenetisk',),
'frenetisk': ('frenetisk',),
'frest': ('frese',),
'freste': ('frese',),
'fresende': ('frese',),
'fresta': ('freste',),
'frestet': ('freste',),
'fresta': ('freste',),
'frestet': ('freste',),
'fresta': ('freste',),
'frestete': ('freste',),
'frestede': ('freste',),
'fresta': ('freste',),
'frestete': ('freste',),
'frestede': ('freste',),
'frestende': ('freste',),
'fretta': ('frette',),
'frettet': ('frette',),
'fretta': ('frette',),
'frettet': ('frette',),
'fretta': ('frette',),
'frettete': ('frette',),
'frettede': ('frette',),
'fretta': ('frette',),
'frettete': ('frette',),
'frettede': ('frette',),
'frettende': ('frette',),
'freudiansk': ('freudiansk',),
'freudianske': ('freudiansk',),
'freudiansk': ('freudiansk',),
'freudsk': ('freudsk',),
'freudske': ('freudsk',),
'freudsk': ('freudsk',),
'fridd': ('fri',),
'fridde': ('fri',),
'friende': ('fri',),
'fri': ('fri',),
'frie': ('fri',),
'fritt': ('fri',),
'friere': ('fri',),
'friest': ('fri',),
'frieste': ('fri',),
'fribåren': ('fribåren',),
'fribårne': ('fribåren',),
'fribårent': ('fribåren',),
'frigitt': ('frigi',),
'frigitte': ('frigi',),
'frigiende': ('frigi',),
'frigid': ('frigid',),
'frigide': ('frigid',),
'frigid': ('frigid',),
'frigjort': ('frigjort',),
'frigjorte': ('frigjort',),
'frigjort': ('frigjort',),
'frigjort': ('frigjøre',),
'frigjorte': ('frigjøre',),
'frigjørende': ('frigjøre',),
'frigjørende': ('frigjørende',),
'frikativ': ('frikativ',),
'frikative': ('frikativ',),
'frikativt': ('frikativ',),
'friket': ('friket',),
'frikete': ('friket',),
'friket': ('friket',),
'frikete': ('frikete',),
'frikjent': ('frikjenne',),
'frikjente': ('frikjenne',),
'frikjennende': ('frikjenne',),
'frikostig': ('frikostig',),
'frikostige': ('frikostig',),
'frikostig': ('frikostig',),
'friksjonsfri': ('friksjonsfri',),
'friksjonsfrie': ('friksjonsfri',),
'friksjonsfritt': ('friksjonsfri',),
'frilans': ('frilans',),
'frilansa': ('frilanse',),
'frilanset': ('frilanse',),
'frilansa': ('frilanse',),
'frilanset': ('frilanse',),
'frilansa': ('frilanse',),
'frilansete': ('frilanse',),
'frilansede': ('frilanse',),
'frilansa': ('frilanse',),
'frilansete': ('frilanse',),
'frilansede': ('frilanse',),
'frilansende': ('frilanse',),
'frilista': ('friliste',),
'frilistet': ('friliste',),
'frilista': ('friliste',),
'frilistet': ('friliste',),
'frilista': ('friliste',),
'frilistete': ('friliste',),
'frilistede': ('friliste',),
'frilista': ('friliste',),
'frilistete': ('friliste',),
'frilistede': ('friliste',),
'frilistende': ('friliste',),
'frilynt': ('frilynt',),
'frilynte': ('frilynt',),
'frilynt': ('frilynt',),
'frimodig': ('frimodig',),
'frimodige': ('frimodig',),
'frimodig': ('frimodig',),
'fripostig': ('fripostig',),
'fripostige': ('fripostig',),
'fripostig': ('fripostig',),
'frirådig': ('frirådig',),
'frirådige': ('frirådig',),
'frirådig': ('frirådig',),
'frisert': ('frisere',),
'friserte': ('frisere',),
'friserende': ('frisere',),
'frisinna': ('frisinna',),
'frisinnet': ('frisinnet',),
'frisinnete': ('frisinnet',),
'frisinnede': ('frisinnet',),
'frisinnete': ('frisinnet',),
'frisinnede': ('frisinnet',),
'frisinnet': ('frisinnet',),
'frisisk': ('frisisk',),
'frisiske': ('frisisk',),
'frisisk': ('frisisk',),
'frisk': ('frisk',),
'friske': ('frisk',),
'friskt': ('frisk',),
'friskere': ('frisk',),
'friskest': ('frisk',),
'friskeste': ('frisk',),
'friska': ('friske',),
'frisket': ('friske',),
'friska': ('friske',),
'frisket': ('friske',),
'friska': ('friske',),
'friskete': ('friske',),
'friskede': ('friske',),
'friska': ('friske',),
'friskete': ('friske',),
'friskede': ('friske',),
'friskende': ('friske',),
'friskfyraktig': ('friskfyraktig',),
'friskfyraktige': ('friskfyraktig',),
'friskfyraktig': ('friskfyraktig',),
'friskmeldt': ('friskmelde',),
'friskmeldte': ('friskmelde',),
'friskmeldende': ('friskmelde',),
'friskna': ('friskne',),
'frisknet': ('friskne',),
'friskna': ('friskne',),
'frisknet': ('friskne',),
'friskna': ('friskne',),
'frisknete': ('friskne',),
'frisknede': ('friskne',),
'frisknete': ('friskne',),
'frisknede': ('friskne',),
'friskna': ('friskne',),
'frisknete': ('friskne',),
'frisknede': ('friskne',),
'frisknete': ('friskne',),
'frisknede': ('friskne',),
'frisknende': ('friskne',),
'frista': ('friste',),
'fristet': ('friste',),
'frista': ('friste',),
'fristet': ('friste',),
'frista': ('friste',),
'fristete': ('friste',),
'fristede': ('friste',),
'frista': ('friste',),
'fristete': ('friste',),
'fristede': ('friste',),
'fristende': ('friste',),
'fristende': ('fristende',),
'fritatt': ('frita',),
'fritatte': ('frita',),
'fritakende': ('frita',),
'fritalende': ('fritalende',),
'fritenkersk': ('fritenkersk',),
'fritenkerske': ('fritenkersk',),
'fritenkersk': ('fritenkersk',),
'fritert': ('fritere',),
'friterte': ('fritere',),
'friterende': ('fritere',),
'fritt-talende': ('fritt-talende',),
'frittalende': ('frittalende',),
'fritta': ('fritte',),
'frittet': ('fritte',),
'fritta': ('fritte',),
'frittet': ('fritte',),
'fritta': ('fritte',),
'frittete': ('fritte',),
'frittede': ('fritte',),
'fritta': ('fritte',),
'frittete': ('fritte',),
'frittede': ('fritte',),
'frittende': ('fritte',),
'frittliggende': ('frittliggende',),
'frittstående': ('frittstående',),
'frityrkokt': ('frityrkokt',),
'frityrkokte': ('frityrkokt',),
'frityrkokt': ('frityrkokt',),
'frityrsteikt': ('frityrsteikt',),
'frityrsteikte': ('frityrsteikt',),
'frityrsteikt': ('frityrsteikt',),
'frityrstekt': ('frityrstekt',),
'frityrstekte': ('frityrstekt',),
'frityrstekt': ('frityrstekt',),
'frivillig': ('frivillig',),
'frivillige': ('frivillig',),
'frivillig': ('frivillig',),
'frivol': ('frivol',),
'frivole': ('frivol',),
'frivolt': ('frivol',),
'frodig': ('frodig',),
'frodige': ('frodig',),
'frodig': ('frodig',),
'frodigere': ('frodig',),
'frodigst': ('frodig',),
'frodigste': ('frodig',),
'from': ('from',),
'fromme': ('from',),
'fromt': ('from',),
'frommere': ('from',),
'frommest': ('from',),
'frommeste': ('from',),
'frondert': ('frondere',),
'fronderte': ('frondere',),
'fronderende': ('frondere',),
'frontal': ('frontal',),
'frontale': ('frontal',),
'frontalt': ('frontal',),
'frossen': ('frossen',),
'frosne': ('frossen',),
'frossent': ('frossen',),
'frostlendt': ('frostlendt',),
'frostlendte': ('frostlendt',),
'frostlendt': ('frostlendt',),
'frostskada': ('frostskada',),
'frostskadd': ('frostskadd',),
'frostskadde': ('frostskadd',),
'frostskadd': ('frostskadd',),
'frostskadet': ('frostskadet',),
'frostskadete': ('frostskadet',),
'frostskadede': ('frostskadet',),
'frostskadete': ('frostskadet',),
'frostskadede': ('frostskadet',),
'frostskadet': ('frostskadet',),
'frottert': ('frottere',),
'frotterte': ('frottere',),
'frotterende': ('frottere',),
'frugal': ('frugal',),
'frugale': ('frugal',),
'frugalt': ('frugal',),
'fruktbar': ('fruktbar',),
'fruktbare': ('fruktbar',),
'fruktbart': ('fruktbar',),
'fruktbringende': ('fruktbringende',),
'frukta': ('frukte',),
'fruktet': ('frukte',),
'frukta': ('frukte',),
'fruktet': ('frukte',),
'frukta': ('frukte',),
'fruktete': ('frukte',),
'fruktede': ('frukte',),
'frukta': ('frukte',),
'fruktete': ('frukte',),
'fruktede': ('frukte',),
'fruktende': ('frukte',),
'fruktesløs': ('fruktesløs',),
'fruktesløse': ('fruktesløs',),
'fruktesløst': ('fruktesløs',),
'fruktsommelig': ('fruktsommelig',),
'fruktsommelige': ('fruktsommelig',),
'fruktsommelig': ('fruktsommelig',),
'frustrert': ('frustrere',),
'frustrerte': ('frustrere',),
'frustrerende': ('frustrere',),
'fryda': ('fryde',),
'frydet': ('fryde',),
'fryda': ('fryde',),
'frydet': ('fryde',),
'fryda': ('fryde',),
'frydete': ('fryde',),
'frydede': ('fryde',),
'fryda': ('fryde',),
'frydete': ('fryde',),
'frydede': ('fryde',),
'frydende': ('fryde',),
'frydefull': ('frydefull',),
'frydefulle': ('frydefull',),
'frydefullt': ('frydefull',),
'frygisk': ('frygisk',),
'frygiske': ('frygisk',),
'frygisk': ('frygisk',),
'fryktblanda': ('fryktblanda',),
'fryktblandet': ('fryktblandet',),
'fryktblandete': ('fryktblandet',),
'fryktblandede': ('fryktblandet',),
'fryktblandete': ('fryktblandet',),
'fryktblandede': ('fryktblandet',),
'fryktblandet': ('fryktblandet',),
'frykta': ('frykte',),
'fryktet': ('frykte',),
'frykta': ('frykte',),
'fryktet': ('frykte',),
'frykta': ('frykte',),
'fryktete': ('frykte',),
'fryktede': ('frykte',),
'frykta': ('frykte',),
'fryktete': ('frykte',),
'fryktede': ('frykte',),
'fryktende': ('frykte',),
'fryktelig': ('fryktelig',),
'fryktelige': ('fryktelig',),
'fryktelig': ('fryktelig',),
'frykteligere': ('fryktelig',),
'frykteligst': ('fryktelig',),
'frykteligste': ('fryktelig',),
'fryktinngytende': ('fryktinngytende',),
'fryktlaus': ('fryktlaus',),
'fryktlause': ('fryktlaus',),
'fryktlaust': ('fryktlaus',),
'fryktløs': ('fryktløs',),
'fryktløse': ('fryktløs',),
'fryktløst': ('fryktløs',),
'fryktsom': ('fryktsom',),
'fryktsomme': ('fryktsom',),
'fryktsomt': ('fryktsom',),
'frynsa': ('frynse',),
'frynset': ('frynse',),
'frynsa': ('frynse',),
'frynset': ('frynse',),
'frynsa': ('frynse',),
'frynsete': ('frynse',),
'frynsede': ('frynse',),
'frynsa': ('frynse',),
'frynsete': ('frynse',),
'frynsede': ('frynse',),
'frynsende': ('frynse',),
'frynset': ('frynset',),
'frynsete': ('frynset',),
'frynset': ('frynset',),
'frynsete': ('frynsete',),
'fråda': ('fråde',),
'frådet': ('fråde',),
'fråda': ('fråde',),
'frådet': ('fråde',),
'fråda': ('fråde',),
'frådete': ('fråde',),
'frådede': ('fråde',),
'fråda': ('fråde',),
'frådete': ('fråde',),
'frådede': ('fråde',),
'frådende': ('fråde',),
'fråssa': ('fråsse',),
'fråsset': ('fråsse',),
'fråssa': ('fråsse',),
'fråsset': ('fråsse',),
'fråssa': ('fråsse',),
'fråssete': ('fråsse',),
'fråssede': ('fråsse',),
'fråssa': ('fråsse',),
'fråssete': ('fråsse',),
'fråssede': ('fråsse',),
'fråssende': ('fråsse',),
'fråtsa': ('fråtse',),
'fråtset': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtset': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtsete': ('fråtse',),
'fråtsede': ('fråtse',),
'fråtsa': ('fråtse',),
'fråtsete': ('fråtse',),
'fråtsede': ('fråtse',),
'fråtsende': ('fråtse',),
'frødd': ('frø',),
'frødde': ('frø',),
'frøende': ('frø',),
'frøkenaktig': ('frøkenaktig',),
'frøkenaktige': ('frøkenaktig',),
'frøkenaktig': ('frøkenaktig',),
'frøst': ('frøse',),
'frøste': ('frøse',),
'frøsende': ('frøse',),
'frøsen': ('frøsen',),
'frøsne': ('frøsen',),
'frøsent': ('frøsen',),
'fuga': ('fuge',),
'fuget': ('fuge',),
'fuga': ('fuge',),
'fuget': ('fuge',),
'fuga': ('fuge',),
'fugete': ('fuge',),
'fugede': ('fuge',),
'fuga': ('fuge',),
'fugete': ('fuge',),
'fugede': ('fuge',),
'fugende': ('fuge',),
'fuktbestandig': ('fuktbestandig',),
'fuktbestandige': ('fuktbestandig',),
'fuktbestandig': ('fuktbestandig',),
'fukta': ('fukte',),
'fuktet': ('fukte',),
'fukta': ('fukte',),
'fuktet': ('fukte',),
'fukta': ('fukte',),
'fuktete': ('fukte',),
'fuktede': ('fukte',),
'fukta': ('fukte',),
'fuktete': ('fukte',),
'fuktede': ('fukte',),
'fuktende': ('fukte',),
'fuktig': ('fuktig',),
'fuktige': ('fuktig',),
'fuktig': ('fuktig',),
'fuktigere': ('fuktig',),
'fuktigst': ('fuktig',),
'fuktigste': ('fuktig',),
'ful': ('ful',),
'fule': ('ful',),
'fult': ('ful',),
'fulere': ('ful',),
'fulest': ('ful',),
'fuleste': ('ful',),
'full': ('full',),
'fulle': ('full',),
'fullt': ('full',),
'fullere': ('full',),
'fullest': ('full',),
'fulleste': ('full',),
'full-lasta': ('full-lasta',),
'full-lastet': ('full-lastet',),
'full-lastete': ('full-lastet',),
'full-lastede': ('full-lastet',),
'full-lastete': ('full-lastet',),
'full-lastede': ('full-lastet',),
'full-lastet': ('full-lastet',),
'fullasta': ('fullasta',),
'fullastet': ('fullastet',),
'fullastete': ('fullastet',),
'fullastede': ('fullastet',),
'fullastete': ('fullastet',),
'fullastede': ('fullastet',),
'fullastet': ('fullastet',),
'fullbefaren': ('fullbefaren',),
'fullbefarne': ('fullbefaren',),
'fullbefarent': ('fullbefaren',),
'fullblods': ('fullblods',),
'fullbrakt': ('fullbringe',),
'fullbrakte': ('fullbringe',),
'fullbringende': ('fullbringe',),
'fullbyrda': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrdete': ('fullbyrde',),
'fullbyrdede': ('fullbyrde',),
'fullbyrda': ('fullbyrde',),
'fullbyrdete': ('fullbyrde',),
'fullbyrdede': ('fullbyrde',),
'fullbyrdende': ('fullbyrde',),
'fullbåren': ('fullbåren',),
'fullbårne': ('fullbåren',),
'fullbårent': ('fullbåren',),
'fullendt': ('fullende',),
'fullendte': ('fullende',),
'fullendende': ('fullende',),
'fullendt': ('fullendt',),
'fullendte': ('fullendt',),
'fullendt': ('fullendt',),
'fullført': ('fullføre',),
'fullførte': ('fullføre',),
'fullførende': ('fullføre',),
'fullgod': ('fullgod',),
'fullgode': ('fullgod',),
'fullgodt': ('fullgod',),
'fullkommen': ('fullkommen',),
'fullkomne': ('fullkommen',),
'fullkomment': ('fullkommen',),
'fullmoden': ('fullmoden',),
'fullmodne': ('fullmoden',),
'fullmodent': ('fullmoden',),
'fullpakka': ('fullpakka',),
'fullpakket': ('fullpakket',),
'fullpakkete': ('fullpakket',),
'fullpakkede': ('fullpakket',),
'fullpakkete': ('fullpakket',),
'fullpakkede': ('fullpakket',),
'fullpakket': ('fullpakket',),
'fullrigga': ('fullrigga',),
'fullrigget': ('fullrigget',),
'fullriggete': ('fullrigget',),
'fullriggede': ('fullrigget',),
'fullriggete': ('fullrigget',),
'fullriggede': ('fullrigget',),
'fullrigget': ('fullrigget',),
'fullrost': ('fullrose',),
'fullroste': ('fullrose',),
'fullrosende': ('fullrose',),
'fullsatt': ('fullsatt',),
'fullsatte': ('fullsatt',),
'fullsatt': ('fullsatt',),
'fullstappa': ('fullstappa',),
'fullstappet': ('fullstappet',),
'fullstappete': ('fullstappet',),
'fullstappede': ('fullstappet',),
'fullstappete': ('fullstappet',),
'fullstappede': ('fullstappet',),
'fullstappet': ('fullstappet',),
'fullstendig': ('fullstendig',),
'fullstendige': ('fullstendig',),
'fullstendig': ('fullstendig',),
'fulltakka': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakkete': ('fulltakke',),
'fulltakkede': ('fulltakke',),
'fulltakka': ('fulltakke',),
'fulltakkete': ('fulltakke',),
'fulltakkede': ('fulltakke',),
'fulltakkende': ('fulltakke',),
'fulltallig': ('fulltallig',),
'fulltallige': ('fulltallig',),
'fulltallig': ('fulltallig',),
'fulltegna': ('fulltegna',),
'fulltegnet': ('fulltegnet',),
'fulltegnete': ('fulltegnet',),
'fulltegnede': ('fulltegnet',),
'fulltegnete': ('fulltegnet',),
'fulltegnede': ('fulltegnet',),
'fulltegnet': ('fulltegnet',),
'fulltonende': ('fulltonende',),
'fullverdig': ('fullverdig',),
'fullverdige': ('fullverdig',),
'fullverdig': ('fullverdig',),
'fullvoksen': ('fullvoksen',),
'fullvoksne': ('fullvoksen',),
'fullvoksent': ('fullvoksen',),
'fundamental': ('fundamental',),
'fundamentale': ('fundamental',),
'fundamentalt': ('fundamental',),
'fundamentalistisk': ('fundamentalistisk',),
'fundamentalistiske': ('fundamentalistisk',),
'fundamentalistisk': ('fundamentalistisk',),
'fundamentert': ('fundamentere',),
'fundamenterte': ('fundamentere',),
'fundamenterende': ('fundamentere',),
'fundert': ('fundere',),
'funderte': ('fundere',),
'funderende': ('fundere',),
'fungert': ('fungere',),
'fungerte': ('fungere',),
'fungerende': ('fungere',),
'funkla': ('funkle',),
'funklet': ('funkle',),
'funkla': ('funkle',),
'funklet': ('funkle',),
'funkla': ('funkle',),
'funklete': ('funkle',),
'funklede': ('funkle',),
'funklete': ('funkle',),
'funklede': ('funkle',),
'funkla': ('funkle',),
'funklete': ('funkle',),
'funklede': ('funkle',),
'funklete': ('funkle',),
'funklede': ('funkle',),
'funklende': ('funkle',),
'funksjonalistisk': ('funksjonalistisk',),
'funksjonalistiske': ('funksjonalistisk',),
'funksjonalistisk': ('funksjonalistisk',),
'funksjonell': ('funksjonell',),
'funksjonelle': ('funksjonell',),
'funksjonelt': ('funksjonell',),
'funksjonert': ('funksjonere',),
'funksjonerte': ('funksjonere',),
'funksjonerende': ('funksjonere',),
'funksjonsdyktig': ('funksjonsdyktig',),
'funksjonsdyktige': ('funksjonsdyktig',),
'funksjonsdyktig': ('funksjonsdyktig',),
'funksjonshemma': ('funksjonshemma',),
'funksjonshemmet': ('funksjonshemmet',),
'funksjonshemmete': ('funksjonshemmet',),
'funksjonshemmede': ('funksjonshemmet',),
'funksjonshemmete': ('funksjonshemmet',),
'funksjonshemmede': ('funksjonshemmet',),
'funksjonshemmet': ('funksjonshemmet',),
'funksjonsriktig': ('funksjonsriktig',),
'funksjonsriktige': ('funksjonsriktig',),
'funksjonsriktig': ('funksjonsriktig',),
'furasjert': ('furasjere',),
'furasjerte': ('furasjere',),
'furasjerende': ('furasjere',),
'fura': ('fure',),
'furet': ('fure',),
'furt': ('fure',),
'fura': ('fure',),
'furet': ('fure',),
'furt': ('fure',),
'fura': ('fure',),
'furete': ('fure',),
'furede': ('fure',),
'furte': ('fure',),
'fura': ('fure',),
'furete': ('fure',),
'furede': ('fure',),
'furte': ('fure',),
'furende': ('fure',),
'furet': ('furet',),
'furete': ('furet',),
'furet': ('furet',),
'furete': ('furete',),
'furnert': ('furnere',),
'furnerte': ('furnere',),
'furnerende': ('furnere',),
'furta': ('furte',),
'furtet': ('furte',),
'furta': ('furte',),
'furtet': ('furte',),
'furta': ('furte',),
'furtete': ('furte',),
'furtede': ('furte',),
'furta': ('furte',),
'furtete': ('furte',),
'furtede': ('furte',),
'furtende': ('furte',),
'furten': ('furten',),
'furtne': ('furten',),
'furtent': ('furten',),
'fus': ('fus',),
'fuse': ('fus',),
'fust': ('fus',),
'fust': ('fuse',),
'fuste': ('fuse',),
'fusende': ('fuse',),
'fusjonert': ('fusjonere',),
'fusjonerte': ('fusjonere',),
'fusjonerende': ('fusjonere',),
'fuska': ('fuske',),
'fusket': ('fuske',),
'fuska': ('fuske',),
'fusket': ('fuske',),
'fuska': ('fuske',),
'fuskete': ('fuske',),
'fuskede': ('fuske',),
'fuska': ('fuske',),
'fuskete': ('fuske',),
'fuskede': ('fuske',),
'fuskende': ('fuske',),
'futil': ('futil',),
'futile': ('futil',),
'futilt': ('futil',),
'futta': ('futte',),
'futtet': ('futte',),
'futta': ('futte',),
'futtet': ('futte',),
'futta': ('futte',),
'futtete': ('futte',),
'futtede': ('futte',),
'futta': ('futte',),
'futtete': ('futte',),
'futtede': ('futte',),
'futtende': ('futte',),
'futurisk': ('futurisk',),
'futuriske': ('futurisk',),
'futurisk': ('futurisk',),
'futuristisk': ('futuristisk',),
'futuristiske': ('futuristisk',),
'futuristisk': ('futuristisk',),
'føket': ('fyke',),
'føken': ('fyke',),
'føket': ('fyke',),
'føken': ('fyke',),
'føkne': ('fyke',),
'fykende': ('fyke',),
'fykende': ('fykende',),
'fyldig': ('fyldig',),
'fyldige': ('fyldig',),
'fyldig': ('fyldig',),
'fyldigere': ('fyldig',),
'fyldigst': ('fyldig',),
'fyldigste': ('fyldig',),
'fylka': ('fylke',),
'fylket': ('fylke',),
'fylkt': ('fylke',),
'fylka': ('fylke',),
'fylket': ('fylke',),
'fylkt': ('fylke',),
'fylka': ('fylke',),
'fylkete': ('fylke',),
'fylkede': ('fylke',),
'fylkte': ('fylke',),
'fylka': ('fylke',),
'fylkete': ('fylke',),
'fylkede': ('fylke',),
'fylkte': ('fylke',),
'fylkende': ('fylke',),
'fylkeskommunal': ('fylkeskommunal',),
'fylkeskommunale': ('fylkeskommunal',),
'fylkeskommunalt': ('fylkeskommunal',),
'fylla': ('fylle',),
'fyllet': ('fylle',),
'fylla': ('fylle',),
'fyllet': ('fylle',),
'fylla': ('fylle',),
'fyllete': ('fylle',),
'fyllede': ('fylle',),
'fylla': ('fylle',),
'fyllete': ('fylle',),
'fyllede': ('fylle',),
'fyllende': ('fylle',),
'fylt': ('fylle',),
'fylte': ('fylle',),
'fyllende': ('fylle',),
'fyllekjørt': ('fyllekjøre',),
'fyllekjørte': ('fyllekjøre',),
'fyllekjørende': ('fyllekjøre',),
'fyllesjuk': ('fyllesjuk',),
'fyllesjuke': ('fyllesjuk',),
'fyllesjukt': ('fyllesjuk',),
'fyllestgjørende': ('fyllestgjørende',),
'fyllesyk': ('fyllesyk',),
'fyllesyke': ('fyllesyk',),
'fyllesykt': ('fyllesyk',),
'fyndig': ('fyndig',),
'fyndige': ('fyndig',),
'fyndig': ('fyndig',),
'fyrt': ('fyre',),
'fyrte': ('fyre',),
'fyrende': ('fyre',),
'fyrig': ('fyrig',),
'fyrige': ('fyrig',),
'fyrig': ('fyrig',),
'fyrstelig': ('fyrstelig',),
'fyrstelige': ('fyrstelig',),
'fyrstelig': ('fyrstelig',),
'fyst': ('fyse',),
'fyste': ('fyse',),
'fysende': ('fyse',),
'fysen': ('fysen',),
'fysne': ('fysen',),
'fysent': ('fysen',),
'fysikalsk': ('fysikalsk',),
'fysikalske': ('fysikalsk',),
'fysikalsk': ('fysikalsk',),
'fysiologisk': ('fysiologisk',),
'fysiologiske': ('fysiologisk',),
'fysiologisk': ('fysiologisk',),
'fysisk': ('fysisk',),
'fysiske': ('fysisk',),
'fysisk': ('fysisk',),
'fått': ('få',),
'fåtte': ('få',),
'fående': ('få',),
'få': ('få',),
'færre': ('få',),
'færrest': ('få',),
'færreste': ('få',),
'fåfengt': ('fåfengt',),
'fåfengte': ('fåfengt',),
'fåfengt': ('fåfengt',),
'fåkunnig': ('fåkunnig',),
'fåkunnige': ('fåkunnig',),
'fåkunnig': ('fåkunnig',),
'fåment': ('fåment',),
'fåmente': ('fåment',),
'fåment': ('fåment',),
'fåmælt': ('fåmælt',),
'fåmælte': ('fåmælt',),
'fåmælt': ('fåmælt',),
'fånyttes': ('fånyttes',),
'fåret': ('fåret',),
'fårete': ('fåret',),
'fåret': ('fåret',),
'fårete': ('fårete',),
'fåtallig': ('fåtallig',),
'fåtallige': ('fåtallig',),
'fåtallig': ('fåtallig',),
'fåtenkt': ('fåtenkt',),
'fåtenkte': ('fåtenkt',),
'fåtenkt': ('fåtenkt',),
'fæl': ('fæl',),
'fæle': ('fæl',),
'fælt': ('fæl',),
'fælere': ('fæl',),
'fælest': ('fæl',),
'fæleste': ('fæl',),
'fælt': ('fæle',),
'fælte': ('fæle',),
'fælende': ('fæle',),
'fælen': ('fælen',),
'fælne': ('fælen',),
'fælent': ('fælen',),
'færre': ('færre',),
'færrest': ('færrest',),
'færreste': ('færrest',),
'færrest': ('færrest',),
'færøysk': ('færøysk',),
'færøyske': ('færøysk',),
'færøysk': ('færøysk',),
'fødd': ('fø',),
'fødde': ('fø',),
'føende': ('fø',),
'født': ('føde',),
'fødte': ('føde',),
'fødende': ('føde',),
'føderal': ('føderal',),
'føderale': ('føderal',),
'føderalt': ('føderal',),
'føderativ': ('føderativ',),
'føderative': ('føderativ',),
'føderativt': ('føderativ',),
'følbar': ('følbar',),
'følbare': ('følbar',),
'følbart': ('følbar',),
'følt': ('føle',),
'følte': ('føle',),
'følende': ('føle',),
'følelig': ('følelig',),
'følelige': ('følelig',),
'følelig': ('følelig',),
'følelsesbetona': ('følelsesbetona',),
'følelsesbetonet': ('følelsesbetonet',),
'følelsesbetonete': ('følelsesbetonet',),
'følelsesbetonede': ('følelsesbetonet',),
'følelsesbetonete': ('følelsesbetonet',),
'følelsesbetonede': ('følelsesbetonet',),
'følelsesbetonet': ('følelsesbetonet',),
'følelsesbetont': ('følelsesbetont',),
'følelsesbetonte': ('følelsesbetont',),
'følelsesbetont': ('følelsesbetont',),
'følelsesfull': ('følelsesfull',),
'følelsesfulle': ('følelsesfull',),
'følelsesfullt': ('følelsesfull',),
'følelseskald': ('følelseskald',),
'følelseskalde': ('følelseskald',),
'følelseskaldt': ('følelseskald',),
'følelseslada': ('følelseslada',),
'følelsesladd': ('følelsesladd',),
'følelsesladde': ('følelsesladd',),
'følelsesladd': ('følelsesladd',),
'følelsesladet': ('følelsesladet',),
'følelsesladete': ('følelsesladet',),
'følelsesladede': ('følelsesladet',),
'følelsesladete': ('følelsesladet',),
'følelsesladede': ('følelsesladet',),
'følelsesladet': ('følelsesladet',),
'følelseslaus': ('følelseslaus',),
'følelseslause': ('følelseslaus',),
'følelseslaust': ('følelseslaus',),
'følelsesløs': ('følelsesløs',),
'følelsesløse': ('følelsesløs',),
'følelsesløst': ('følelsesløs',),
'følelsesmessig': ('følelsesmessig',),
'følelsesmessige': ('følelsesmessig',),
'følelsesmessig': ('følelsesmessig',),
'følgende': ('følgende',),
'følgeriktig': ('følgeriktig',),
'følgeriktige': ('følgeriktig',),
'følgeriktig': ('følgeriktig',),
'følgestreng': ('følgestreng',),
'følgestrenge': ('følgestreng',),
'følgestrengt': ('følgestreng',),
'følgestrengere': ('følgestreng',),
'følgestrengest': ('følgestreng',),
'følgestrengeste': ('følgestreng',),
'følla': ('følle',),
'føllet': ('følle',),
'følla': ('følle',),
'føllet': ('følle',),
'følla': ('følle',),
'føllete': ('følle',),
'føllede': ('følle',),
'følla': ('følle',),
'føllete': ('følle',),
'føllede': ('følle',),
'føllende': ('følle',),
'følsom': ('følsom',),
'følsomme': ('følsom',),
'følsomt': ('følsom',),
'følsommere': ('følsom',),
'følsomst': ('følsom',),
'følsomste': ('følsom',),
'føna': ('føne',),
'fønet': ('føne',),
'fønt': ('føne',),
'føna': ('føne',),
'fønet': ('føne',),
'fønt': ('føne',),
'føna': ('føne',),
'fønete': ('føne',),
'fønede': ('føne',),
'fønte': ('føne',),
'føna': ('føne',),
'fønete': ('føne',),
'fønede': ('føne',),
'fønte': ('føne',),
'fønende': ('føne',),
'før': ('før',),
'føre': ('før',),
'ført': ('før',),
'ført': ('føre',),
'førte': ('føre',),
'førende': ('føre',),
'førebels': ('førebels',),
'førebudd': ('førebu',),
'førebudde': ('førebu',),
'førebuende': ('førebu',),
'førekteskapelig': ('førekteskapelig',),
'førekteskapelige': ('førekteskapelig',),
'førekteskapelig': ('førekteskapelig',),
'førhistorisk': ('førhistorisk',),
'førhistoriske': ('førhistorisk',),
'førhistorisk': ('førhistorisk',),
'førkolumbisk': ('førkolumbisk',),
'førkolumbiske': ('førkolumbisk',),
'førkolumbisk': ('førkolumbisk',),
'førkrigs': ('førkrigs',),
'førlig': ('førlig',),
'førlige': ('førlig',),
'førlig': ('førlig',),
'førnevnt': ('førnevnt',),
'førnevnte': ('førnevnt',),
'førnevnt': ('førnevnt',),
'første': ('første',),
'førstefødt': ('førstefødt',),
'førstefødte': ('førstefødt',),
'førstefødt': ('førstefødt',),
'førstegangsfødende': ('førstegangsfødende',),
'førstehands': ('førstehands',),
'førstehånds': ('førstehånds',),
'førsteklasses': ('førsteklasses',),
'førsterangs': ('førsterangs',),
'førstkommende': ('førstkommende',),
'førstnevnt': ('førstnevnt',),
'førstnevnte': ('førstnevnt',),
'førstnevnt': ('førstnevnt',),
'førtidspensjonert': ('førtidspensjonere',),
'førtidspensjonerte': ('førtidspensjonere',),
'førtidspensjonerende': ('førtidspensjonere',),
'førtiende': ('førtiende',),
'føydal': ('føydal',),
'føydale': ('føydal',),
'føydalt': ('føydal',),
'føyet': ('føye',),
'føyd': ('føye',),
'føyet': ('føye',),
'føyd': ('føye',),
'føyete': ('føye',),
'føyede': ('føye',),
'føyde': ('føye',),
'føyete': ('føye',),
'føyede': ('føye',),
'føyde': ('føye',),
'føyende': ('føye',),
'føyelig': ('føyelig',),
'føyelige': ('føyelig',),
'føyelig': ('føyelig',),
'føyka': ('føyke',),
'føyket': ('føyke',),
'føykt': ('føyke',),
'føyka': ('føyke',),
'føyket': ('føyke',),
'føykt': ('føyke',),
'føyka': ('føyke',),
'føykete': ('føyke',),
'føykede': ('føyke',),
'føykte': ('føyke',),
'føyka': ('føyke',),
'føykete': ('føyke',),
'føykede': ('føyke',),
'føykte': ('føyke',),
'føykende': ('føyke',),
'føyst': ('føyse',),
'føyste': ('føyse',),
'føysende': ('føyse',),
'gabonsk': ('gabonsk',),
'gabonske': ('gabonsk',),
'gabonsk': ('gabonsk',),
'gaffelforma': ('gaffelforma',),
'gaffelformet': ('gaffelformet',),
'gaffelformete': ('gaffelformet',),
'gaffelformede': ('gaffelformet',),
'gaffelformete': ('gaffelformet',),
'gaffelformede': ('gaffelformet',),
'gaffelformet': ('gaffelformet',),
'gafla': ('gafle',),
'gaflet': ('gafle',),
'gafla': ('gafle',),
'gaflet': ('gafle',),
'gafla': ('gafle',),
'gaflete': ('gafle',),
'gaflede': ('gafle',),
'gaflete': ('gafle',),
'gaflede': ('gafle',),
'gafla': ('gafle',),
'gaflete': ('gafle',),
'gaflede': ('gafle',),
'gaflete': ('gafle',),
'gaflede': ('gafle',),
'gaflende': ('gafle',),
'gagna': ('gagne',),
'gagnet': ('gagne',),
'gagna': ('gagne',),
'gagnet': ('gagne',),
'gagna': ('gagne',),
'gagnete': ('gagne',),
'gagnede': ('gagne',),
'gagna': ('gagne',),
'gagnete': ('gagne',),
'gagnede': ('gagne',),
'gagnende': ('gagne',),
'gagnlaus': ('gagnlaus',),
'gagnlause': ('gagnlaus',),
'gagnlaust': ('gagnlaus',),
'gagnlig': ('gagnlig',),
'gagnlige': ('gagnlig',),
'gagnlig': ('gagnlig',),
'gagnløs': ('gagnløs',),
'gagnløse': ('gagnløs',),
'gagnløst': ('gagnløs',),
'gagns': ('gagns',),
'gakka': ('gakke',),
'gakket': ('gakke',),
'gakka': ('gakke',),
'gakket': ('gakke',),
'gakka': ('gakke',),
'gakkete': ('gakke',),
'gakkede': ('gakke',),
'gakka': ('gakke',),
'gakkete': ('gakke',),
'gakkede': ('gakke',),
'gakkende': ('gakke',),
'gal': ('gal',),
'gale': ('gal',),
'galt': ('gal',),
'galere': ('gal',),
'galest': ('gal',),
'galeste': ('gal',),
'galaktisk': ('galaktisk',),
'galaktiske': ('galaktisk',),
'galaktisk': ('galaktisk',),
'galant': ('galant',),
'galante': ('galant',),
'galant': ('galant',),
'galdra': ('galdre',),
'galdret': ('galdre',),
'galdra': ('galdre',),
'galdret': ('galdre',),
'galdra': ('galdre',),
'galdrete': ('galdre',),
'galdrede': ('galdre',),
'galdrete': ('galdre',),
'galdrede': ('galdre',),
'galdra': ('galdre',),
'galdrete': ('galdre',),
'galdrede': ('galdre',),
'galdrete': ('galdre',),
'galdrede': ('galdre',),
'galdrende': ('galdre',),
'galt': ('gale',),
'galte': ('gale',),
'galende': ('gale',),
'galen': ('galen',),
'galne': ('galen',),
'galent': ('galen',),
'galgenhumoristisk': ('galgenhumoristisk',),
'galgenhumoristiske': ('galgenhumoristisk',),
'galgenhumoristisk': ('galgenhumoristisk',),
'galileisk': ('galileisk',),
'galileiske': ('galileisk',),
'galileisk': ('galileisk',),
'gallegrønn': ('gallegrønn',),
'gallegrønne': ('gallegrønn',),
'gallegrønt': ('gallegrønn',),
'gallisk': ('gallisk',),
'galliske': ('gallisk',),
'gallisk': ('gallisk',),
'galoppert': ('galoppere',),
'galopperte': ('galoppere',),
'galopperende': ('galoppere',),
'galvanisert': ('galvanisere',),
'galvaniserte': ('galvanisere',),
'galvaniserende': ('galvanisere',),
'galvanisk': ('galvanisk',),
'galvaniske': ('galvanisk',),
'galvanisk': ('galvanisk',),
'gambisk': ('gambisk',),
'gambiske': ('gambisk',),
'gambisk': ('gambisk',),
'gambla': ('gamble',),
'gamblet': ('gamble',),
'gambla': ('gamble',),
'gamblet': ('gamble',),
'gambla': ('gamble',),
'gamblete': ('gamble',),
'gamblede': ('gamble',),
'gamblete': ('gamble',),
'gamblede': ('gamble',),
'gambla': ('gamble',),
'gamblete': ('gamble',),
'gamblede': ('gamble',),
'gamblete': ('gamble',),
'gamblede': ('gamble',),
'gamblende': ('gamble',),
'game': ('game',),
'gammal': ('gammal',),
'gamle': ('gammal',),
'gammalt': ('gammal',),
'eldre': ('gammal',),
'eldst': ('gammal',),
'eldste': ('gammal',),
'gammaldansk': ('gammaldansk',),
'gammaldanske': ('gammaldansk',),
'gammaldansk': ('gammaldansk',),
'gammalkjent': ('gammalkjent',),
'gammalkjente': ('gammalkjent',),
'gammalkjent': ('gammalkjent',),
'gammalmannsaktig': ('gammalmannsaktig',),
'gammalmannsaktige': ('gammalmannsaktig',),
'gammalmannsaktig': ('gammalmannsaktig',),
'gammalmodig': ('gammalmodig',),
'gammalmodige': ('gammalmodig',),
'gammalmodig': ('gammalmodig',),
'gammalnorsk': ('gammalnorsk',),
'gammalnorske': ('gammalnorsk',),
'gammalnorsk': ('gammalnorsk',),
'gammalrosa': ('gammalrosa',),
'gammaltestamentlig': ('gammaltestamentlig',),
'gammaltestamentlige': ('gammaltestamentlig',),
'gammaltestamentlig': ('gammaltestamentlig',),
'gammalvoren': ('gammalvoren',),
'gammalvorne': ('gammalvoren',),
'gammalvorent': ('gammalvoren',),
'gammel': ('gammel',),
'gamle': ('gammel',),
'gammelt': ('gammel',),
'eldre': ('gammel',),
'eldst': ('gammel',),
'eldste': ('gammel',),
'gammeldansk': ('gammeldansk',),
'gammeldanske': ('gammeldansk',),
'gammeldansk': ('gammeldansk',),
'gammelkjent': ('gammelkjent',),
'gammelkjente': ('gammelkjent',),
'gammelkjent': ('gammelkjent',),
'gammelmannsaktig': ('gammelmannsaktig',),
'gammelmannsaktige': ('gammelmannsaktig',),
'gammelmannsaktig': ('gammelmannsaktig',),
'gammelmodig': ('gammelmodig',),
'gammelmodige': ('gammelmodig',),
'gammelmodig': ('gammelmodig',),
'gammelnorsk': ('gammelnorsk',),
'gammelnorske': ('gammelnorsk',),
'gammelnorsk': ('gammelnorsk',),
'gammelrosa': ('gammelrosa',),
'gammeltestamentlig': ('gammeltestamentlig',),
'gammeltestamentlige': ('gammeltestamentlig',),
'gammeltestamentlig': ('gammeltestamentlig',),
'gammelvoren': ('gammelvoren',),
'gammelvorne': ('gammelvoren',),
'gammelvorent': ('gammelvoren',),
'ganda': ('gande',),
'gandet': ('gande',),
'ganda': ('gande',),
'gandet': ('gande',),
'ganda': ('gande',),
'gandete': ('gande',),
'gandede': ('gande',),
'ganda': ('gande',),
'gandete': ('gande',),
'gandede': ('gande',),
'gandende': ('gande',),
'gana': ('gane',),
'ganet': ('gane',),
'gant': ('gane',),
'gana': ('gane',),
'ganet': ('gane',),
'gant': ('gane',),
'gana': ('gane',),
'ganete': ('gane',),
'ganede': ('gane',),
'gante': ('gane',),
'gana': ('gane',),
'ganete': ('gane',),
'ganede': ('gane',),
'gante': ('gane',),
'ganende': ('gane',),
'gangbar': ('gangbar',),
'gangbare': ('gangbar',),
'gangbart': ('gangbar',),
'ganga': ('gange',),
'ganget': ('gange',),
'ganga': ('gange',),
'ganget': ('gange',),
'ganga': ('gange',),
'gangete': ('gange',),
'gangede': ('gange',),
'ganga': ('gange',),
'gangete': ('gange',),
'gangede': ('gange',),
'gangende': ('gange',),
'gangfør': ('gangfør',),
'gangføre': ('gangfør',),
'gangført': ('gangfør',),
'gangrenøs': ('gangrenøs',),
'gangrenøse': ('gangrenøs',),
'gangrenøst': ('gangrenøs',),
'gangsynt': ('gangsynt',),
'gangsynte': ('gangsynt',),
'gangsynt': ('gangsynt',),
'ganta': ('gante',),
'gantet': ('gante',),
'ganta': ('gante',),
'gantet': ('gante',),
'ganta': ('gante',),
'gantete': ('gante',),
'gantede': ('gante',),
'ganta': ('gante',),
'gantete': ('gante',),
'gantede': ('gante',),
'gantende': ('gante',),
'gapa': ('gape',),
'gapt': ('gape',),
'gapa': ('gape',),
'gapt': ('gape',),
'gapa': ('gape',),
'gapte': ('gape',),
'gapa': ('gape',),
'gapte': ('gape',),
'gapende': ('gape',),
'gapen': ('gapen',),
'gapne': ('gapen',),
'gapent': ('gapen',),
'gapet': ('gapet',),
'gapete': ('gapet',),
'gapet': ('gapet',),
'gapete': ('gapete',),
'gapskratta': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskrattete': ('gapskratte',),
'gapskrattede': ('gapskratte',),
'gapskratta': ('gapskratte',),
'gapskrattete': ('gapskratte',),
'gapskrattede': ('gapskratte',),
'gapskrattende': ('gapskratte',),
'garantert': ('garantere',),
'garanterte': ('garantere',),
'garanterende': ('garantere',),
'gardert': ('gardere',),
'garderte': ('gardere',),
'garderende': ('gardere',),
'garna': ('garne',),
'garnet': ('garne',),
'garna': ('garne',),
'garnet': ('garne',),
'garna': ('garne',),
'garnete': ('garne',),
'garnede': ('garne',),
'garna': ('garne',),
'garnete': ('garne',),
'garnede': ('garne',),
'garnende': ('garne',),
'garnert': ('garnere',),
'garnerte': ('garnere',),
'garnerende': ('garnere',),
'garnisonert': ('garnisonere',),
'garnisonerte': ('garnisonere',),
'garnisonerende': ('garnisonere',),
'garpa': ('garpe',),
'garpet': ('garpe',),
'garpa': ('garpe',),
'garpet': ('garpe',),
'garpa': ('garpe',),
'garpete': ('garpe',),
'garpede': ('garpe',),
'garpa': ('garpe',),
'garpete': ('garpe',),
'garpede': ('garpe',),
'garpende': ('garpe',),
'garva': ('garva',),
'garva': ('garve',),
'garvet': ('garve',),
'garva': ('garve',),
'garvet': ('garve',),
'garva': ('garve',),
'garvete': ('garve',),
'garvede': ('garve',),
'garva': ('garve',),
'garvete': ('garve',),
'garvede': ('garve',),
'garvende': ('garve',),
'garvet': ('garvet',),
'garvete': ('garvet',),
'garvede': ('garvet',),
'garvete': ('garvet',),
'garvede': ('garvet',),
'garvet': ('garvet',),
'gasjert': ('gasjere',),
'gasjerte': ('gasjere',),
'gasjerende': ('gasjere',),
'gassa': ('gasse',),
'gasset': ('gasse',),
'gassa': ('gasse',),
'gasset': ('gasse',),
'gassa': ('gasse',),
'gassete': ('gasse',),
'gassede': ('gasse',),
'gassa': ('gasse',),
'gassete': ('gasse',),
'gassede': ('gasse',),
'gassende': ('gasse',),
'gassformig': ('gassformig',),
'gassformige': ('gassformig',),
'gassformig': ('gassformig',),
'gassisk': ('gassisk',),
'gassiske': ('gassisk',),
'gassisk': ('gassisk',),
'gasta': ('gasta',),
'gastrisk': ('gastrisk',),
'gastriske': ('gastrisk',),
'gastrisk': ('gastrisk',),
'gastronomisk': ('gastronomisk',),
'gastronomiske': ('gastronomisk',),
'gastronomisk': ('gastronomisk',),
'gauka': ('gauke',),
'gauket': ('gauke',),
'gauka': ('gauke',),
'gauket': ('gauke',),
'gauka': ('gauke',),
'gaukete': ('gauke',),
'gaukede': ('gauke',),
'gauka': ('gauke',),
'gaukete': ('gauke',),
'gaukede': ('gauke',),
'gaukende': ('gauke',),
'gaula': ('gaule',),
'gaulet': ('gaule',),
'gault': ('gaule',),
'gaula': ('gaule',),
'gaulet': ('gaule',),
'gault': ('gaule',),
'gaula': ('gaule',),
'gaulete': ('gaule',),
'gaulede': ('gaule',),
'gaulte': ('gaule',),
'gaula': ('gaule',),
'gaulete': ('gaule',),
'gaulede': ('gaule',),
'gaulte': ('gaule',),
'gaulende': ('gaule',),
'gauma': ('gaume',),
'gaumet': ('gaume',),
'gauma': ('gaume',),
'gaumet': ('gaume',),
'gauma': ('gaume',),
'gaumete': ('gaume',),
'gaumede': ('gaume',),
'gauma': ('gaume',),
'gaumete': ('gaume',),
'gaumede': ('gaume',),
'gaumende': ('gaume',),
'gaussisk': ('gaussisk',),
'gaussiske': ('gaussisk',),
'gaussisk': ('gaussisk',),
'gavmild': ('gavmild',),
'gavmilde': ('gavmild',),
'gavmildt': ('gavmild',),
'geberda': ('geberde',),
'geberdet': ('geberde',),
'geberda': ('geberde',),
'geberdet': ('geberde',),
'geberda': ('geberde',),
'geberdete': ('geberde',),
'geberdede': ('geberde',),
'geberda': ('geberde',),
'geberdete': ('geberde',),
'geberdede': ('geberde',),
'geberdende': ('geberde',),
'gebrekkelig': ('gebrekkelig',),
'gebrekkelige': ('gebrekkelig',),
'gebrekkelig': ('gebrekkelig',),
'gebrokken': ('gebrokken',),
'gebrokne': ('gebrokken',),
'gebrokkent': ('gebrokken',),
'gedigen': ('gedigen',),
'gedigne': ('gedigen',),
'gedigent': ('gedigen',),
'geil': ('geil',),
'geile': ('geil',),
'geilt': ('geil',),
'geipa': ('geipe',),
'geipet': ('geipe',),
'geipt': ('geipe',),
'geipa': ('geipe',),
'geipet': ('geipe',),
'geipt': ('geipe',),
'geipa': ('geipe',),
'geipete': ('geipe',),
'geipede': ('geipe',),
'geipte': ('geipe',),
'geipa': ('geipe',),
'geipete': ('geipe',),
'geipede': ('geipe',),
'geipte': ('geipe',),
'geipende': ('geipe',),
'geipet': ('geipet',),
'geipete': ('geipet',),
'geipet': ('geipet',),
'geipete': ('geipete',),
'geistlig': ('geistlig',),
'geistlige': ('geistlig',),
'geistlig': ('geistlig',),
'geitet': ('geitet',),
'geitete': ('geitet',),
'geitet': ('geitet',),
'geitete': ('geitete',),
'geléaktig': ('geléaktig',),
'geléaktige': ('geléaktig',),
'geléaktig': ('geléaktig',),
'geleida': ('geleide',),
'geleidet': ('geleide',),
'geleida': ('geleide',),
'geleidet': ('geleide',),
'geleida': ('geleide',),
'geleidete': ('geleide',),
'geleidede': ('geleide',),
'geleida': ('geleide',),
'geleidete': ('geleide',),
'geleidede': ('geleide',),
'geleidende': ('geleide',),
'gemeinslig': ('gemeinslig',),
'gemeinslige': ('gemeinslig',),
'gemeinslig': ('gemeinslig',),
'gemen': ('gemen',),
'gemene': ('gemen',),
'gement': ('gemen',),
'gemenslig': ('gemenslig',),
'gemenslige': ('gemenslig',),
'gemenslig': ('gemenslig',),
'geminert': ('geminere',),
'geminerte': ('geminere',),
'geminerende': ('geminere',),
'gemyttlig': ('gemyttlig',),
'gemyttlige': ('gemyttlig',),
'gemyttlig': ('gemyttlig',),
'genealogisk': ('genealogisk',),
'genealogiske': ('genealogisk',),
'genealogisk': ('genealogisk',),
'generalisert': ('generalisere',),
'generaliserte': ('generalisere',),
'generaliserende': ('generalisere',),
'generalpreventiv': ('generalpreventiv',),
'generalpreventive': ('generalpreventiv',),
'generalpreventivt': ('generalpreventiv',),
'generativ': ('generativ',),
'generative': ('generativ',),
'generativt': ('generativ',),
'generell': ('generell',),
'generelle': ('generell',),
'generelt': ('generell',),
'generert': ('generere',),
'genererte': ('generere',),
'genererende': ('generere',),
'generisk': ('generisk',),
'generiske': ('generisk',),
'generisk': ('generisk',),
'genetisk': ('genetisk',),
'genetiske': ('genetisk',),
'genetisk': ('genetisk',),
'genial': ('genial',),
'geniale': ('genial',),
'genialt': ('genial',),
'genierklært': ('genierklære',),
'genierklærte': ('genierklære',),
'genierklærende': ('genierklære',),
'genital': ('genital',),
'genitale': ('genital',),
'genitalt': ('genital',),
'genovesisk': ('genovesisk',),
'genovesiske': ('genovesisk',),
'genovesisk': ('genovesisk',),
'gentil': ('gentil',),
'gentile': ('gentil',),
'gentilt': ('gentil',),
'genuesisk': ('genuesisk',),
'genuesiske': ('genuesisk',),
'genuesisk': ('genuesisk',),
'genuin': ('genuin',),
'genuine': ('genuin',),
'genuint': ('genuin',),
'geodetisk': ('geodetisk',),
'geodetiske': ('geodetisk',),
'geodetisk': ('geodetisk',),
'geofysisk': ('geofysisk',),
'geofysiske': ('geofysisk',),
'geofysisk': ('geofysisk',),
'geografisk': ('geografisk',),
'geografiske': ('geografisk',),
'geografisk': ('geografisk',),
'geologisk': ('geologisk',),
'geologiske': ('geologisk',),
'geologisk': ('geologisk',),
'geometrisk': ('geometrisk',),
'geometriske': ('geometrisk',),
'geometrisk': ('geometrisk',),
'georgisk': ('georgisk',),
'georgiske': ('georgisk',),
'georgisk': ('georgisk',),
'georgistisk': ('georgistisk',),
'georgistiske': ('georgistisk',),
'georgistisk': ('georgistisk',),
'geosentrisk': ('geosentrisk',),
'geosentriske': ('geosentrisk',),
'geosentrisk': ('geosentrisk',),
'gerert': ('gerere',),
'gererte': ('gerere',),
'gererende': ('gerere',),
'geriatrisk': ('geriatrisk',),
'geriatriske': ('geriatrisk',),
'geriatrisk': ('geriatrisk',),
'germanisert': ('germanisere',),
'germaniserte': ('germanisere',),
'germaniserende': ('germanisere',),
'germansk': ('germansk',),
'germanske': ('germansk',),
'germansk': ('germansk',),
'geråda': ('geråde',),
'gerådet': ('geråde',),
'geråda': ('geråde',),
'gerådet': ('geråde',),
'geråda': ('geråde',),
'gerådete': ('geråde',),
'gerådede': ('geråde',),
'geråda': ('geråde',),
'gerådete': ('geråde',),
'gerådede': ('geråde',),
'gerådende': ('geråde',),
'geskjeftig': ('geskjeftig',),
'geskjeftige': ('geskjeftig',),
'geskjeftig': ('geskjeftig',),
'gestalta': ('gestalte',),
'gestaltet': ('gestalte',),
'gestalta': ('gestalte',),
'gestaltet': ('gestalte',),
'gestalta': ('gestalte',),
'gestaltete': ('gestalte',),
'gestaltede': ('gestalte',),
'gestalta': ('gestalte',),
'gestaltete': ('gestalte',),
'gestaltede': ('gestalte',),
'gestaltende': ('gestalte',),
'gestikulert': ('gestikulere',),
'gestikulerte': ('gestikulere',),
'gestikulerende': ('gestikulere',),
'gesvint': ('gesvint',),
'gesvinte': ('gesvint',),
'gesvint': ('gesvint',),
'ghanesisk': ('ghanesisk',),
'ghanesiske': ('ghanesisk',),
'ghanesisk': ('ghanesisk',),
'gitt': ('gi',),
'gitte': ('gi',),
'giende': ('gi',),
'giddet': ('gidde',),
'gidden': ('gidde',),
'gidne': ('gidde',),
'giddende': ('gidde',),
'giddelaus': ('giddelaus',),
'giddelause': ('giddelaus',),
'giddelaust': ('giddelaus',),
'giddeløs': ('giddeløs',),
'giddeløse': ('giddeløs',),
'giddeløst': ('giddeløs',),
'gift': ('gift',),
'gifte': ('gift',),
'gift': ('gift',),
'gifta': ('gifte',),
'giftet': ('gifte',),
'gifta': ('gifte',),
'giftet': ('gifte',),
'gifta': ('gifte',),
'giftete': ('gifte',),
'giftede': ('gifte',),
'gifta': ('gifte',),
'giftete': ('gifte',),
'giftede': ('gifte',),
'giftende': ('gifte',),
'giftegal': ('giftegal',),
'giftegale': ('giftegal',),
'giftegalt': ('giftegal',),
'giftgrønn': ('giftgrønn',),
'giftgrønne': ('giftgrønn',),
'giftgrønt': ('giftgrønn',),
'giftig': ('giftig',),
'giftige': ('giftig',),
'giftig': ('giftig',),
'giftigere': ('giftig',),
'giftigst': ('giftig',),
'giftigste': ('giftig',),
'giftiggrønn': ('giftiggrønn',),
'giftiggrønne': ('giftiggrønn',),
'giftiggrønt': ('giftiggrønn',),
'gigantisk': ('gigantisk',),
'gigantiske': ('gigantisk',),
'gigantisk': ('gigantisk',),
'gigga': ('gigge',),
'gigget': ('gigge',),
'gigga': ('gigge',),
'gigget': ('gigge',),
'gigga': ('gigge',),
'giggete': ('gigge',),
'giggede': ('gigge',),
'gigga': ('gigge',),
'giggete': ('gigge',),
'giggede': ('gigge',),
'giggende': ('gigge',),
'giktisk': ('giktisk',),
'giktiske': ('giktisk',),
'giktisk': ('giktisk',),
'giktsjuk': ('giktsjuk',),
'giktsjuke': ('giktsjuk',),
'giktsjukt': ('giktsjuk',),
'giktsyk': ('giktsyk',),
'giktsyke': ('giktsyk',),
'giktsykt': ('giktsyk',),
'gild': ('gild',),
'gilde': ('gild',),
'gildt': ('gild',),
'gildere': ('gild',),
'gildest': ('gild',),
'gildeste': ('gild',),
'gildra': ('gildre',),
'gildret': ('gildre',),
'gildra': ('gildre',),
'gildret': ('gildre',),
'gildra': ('gildre',),
'gildrete': ('gildre',),
'gildrede': ('gildre',),
'gildrete': ('gildre',),
'gildrede': ('gildre',),
'gildra': ('gildre',),
'gildrete': ('gildre',),
'gildrede': ('gildre',),
'gildrete': ('gildre',),
'gildrede': ('gildre',),
'gildrende': ('gildre',),
'giljotinert': ('giljotinere',),
'giljotinerte': ('giljotinere',),
'giljotinerende': ('giljotinere',),
'gimpa': ('gimpe',),
'gimpet': ('gimpe',),
'gimpa': ('gimpe',),
'gimpet': ('gimpe',),
'gimpa': ('gimpe',),
'gimpete': ('gimpe',),
'gimpede': ('gimpe',),
'gimpa': ('gimpe',),
'gimpete': ('gimpe',),
'gimpede': ('gimpe',),
'gimpende': ('gimpe',),
'gingival': ('gingival',),
'gingivale': ('gingival',),
'gingivalt': ('gingival',),
'gipsa': ('gipse',),
'gipset': ('gipse',),
'gipst': ('gipse',),
'gipsa': ('gipse',),
'gipset': ('gipse',),
'gipst': ('gipse',),
'gipsa': ('gipse',),
'gipsete': ('gipse',),
'gipsede': ('gipse',),
'gipste': ('gipse',),
'gipsa': ('gipse',),
'gipsete': ('gipse',),
'gipsede': ('gipse',),
'gipste': ('gipse',),
'gipsende': ('gipse',),
'girert': ('girere',),
'girerte': ('girere',),
'girerende': ('girere',),
'gisna': ('gisne',),
'gisnet': ('gisne',),
'gisna': ('gisne',),
'gisnet': ('gisne',),
'gisna': ('gisne',),
'gisnete': ('gisne',),
'gisnede': ('gisne',),
'gisna': ('gisne',),
'gisnete': ('gisne',),
'gisnede': ('gisne',),
'gisnende': ('gisne',),
'gispa': ('gispe',),
'gispet': ('gispe',),
'gispa': ('gispe',),
'gispet': ('gispe',),
'gispa': ('gispe',),
'gispete': ('gispe',),
'gispede': ('gispe',),
'gispa': ('gispe',),
'gispete': ('gispe',),
'gispede': ('gispe',),
'gispende': ('gispe',),
'gissa': ('gisse',),
'gisset': ('gisse',),
'gissa': ('gisse',),
'gisset': ('gisse',),
'gissa': ('gisse',),
'gissete': ('gisse',),
'gissede': ('gisse',),
'gissa': ('gisse',),
'gissete': ('gisse',),
'gissede': ('gisse',),
'gissende': ('gisse',),
'gissen': ('gissen',),
'gisne': ('gissen',),
'gissent': ('gissen',),
'gitra': ('gitre',),
'gitret': ('gitre',),
'gitra': ('gitre',),
'gitret': ('gitre',),
'gitra': ('gitre',),
'gitrete': ('gitre',),
'gitrede': ('gitre',),
'gitrete': ('gitre',),
'gitrede': ('gitre',),
'gitra': ('gitre',),
'gitrete': ('gitre',),
'gitrede': ('gitre',),
'gitrete': ('gitre',),
'gitrede': ('gitre',),
'gitrende': ('gitre',),
'givende': ('givende',),
'gjalla': ('gjalle',),
'gjallet': ('gjalle',),
'gjalla': ('gjalle',),
'gjallet': ('gjalle',),
'gjalla': ('gjalle',),
'gjallete': ('gjalle',),
'gjallede': ('gjalle',),
'gjalla': ('gjalle',),
'gjallete': ('gjalle',),
'gjallede': ('gjalle',),
'gjallende': ('gjalle',),
'gjekka': ('gjekke',),
'gjekket': ('gjekke',),
'gjekka': ('gjekke',),
'gjekket': ('gjekke',),
'gjekka': ('gjekke',),
'gjekkete': ('gjekke',),
'gjekkede': ('gjekke',),
'gjekka': ('gjekke',),
'gjekkete': ('gjekke',),
'gjekkede': ('gjekke',),
'gjekkende': ('gjekke',),
'gjeld': ('gjeld',),
'gjelde': ('gjeld',),
'gjeldt': ('gjeld',),
'gjeld': ('gjeld',),
'gjeldbunden': ('gjeldbunden',),
'gjeldbundne': ('gjeldbunden',),
'gjeldbundet': ('gjeldbunden',),
'gjeldbundet': ('gjeldbundet',),
'gjeldbundne': ('gjeldbundet',),
'gjeldbundet': ('gjeldbundet',),
'gjelda': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldt': ('gjelde',),
'gjelda': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldt': ('gjelde',),
'gjelda': ('gjelde',),
'gjeldete': ('gjelde',),
'gjeldede': ('gjelde',),
'gjeldte': ('gjelde',),
'gjelda': ('gjelde',),
'gjeldete': ('gjelde',),
'gjeldede': ('gjelde',),
'gjeldte': ('gjelde',),
'gjeldende': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeldte': ('gjelde',),
'gjeldende': ('gjelde',),
'gjeldende': ('gjeldende',),
'gjeldfri': ('gjeldfri',),
'gjeldfrie': ('gjeldfri',),
'gjeldfritt': ('gjeldfri',),
'gjelt': ('gjelle',),
'gjelte': ('gjelle',),
'gjellende': ('gjelle',),
'gjemt': ('gjemme',),
'gjemte': ('gjemme',),
'gjemmende': ('gjemme',),
'gjenbrukbar': ('gjenbrukbar',),
'gjenbrukbare': ('gjenbrukbar',),
'gjenbrukbart': ('gjenbrukbar',),
'gjenbrukt': ('gjenbruke',),
'gjenbrukte': ('gjenbruke',),
'gjenbrukende': ('gjenbruke',),
'gjendrivelig': ('gjendrivelig',),
'gjendrivelige': ('gjendrivelig',),
'gjendrivelig': ('gjendrivelig',),
'gjenerobra': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobrete': ('gjenerobre',),
'gjenerobrede': ('gjenerobre',),
'gjenerobrete': ('gjenerobre',),
'gjenerobrede': ('gjenerobre',),
'gjenerobra': ('gjenerobre',),
'gjenerobrete': ('gjenerobre',),
'gjenerobrede': ('gjenerobre',),
'gjenerobrete': ('gjenerobre',),
'gjenerobrede': ('gjenerobre',),
'gjenerobrende': ('gjenerobre',),
'gjenforenet': ('gjenforene',),
'gjenforent': ('gjenforene',),
'gjenforenet': ('gjenforene',),
'gjenforent': ('gjenforene',),
'gjenforenete': ('gjenforene',),
'gjenforenede': ('gjenforene',),
'gjenforente': ('gjenforene',),
'gjenforenete': ('gjenforene',),
'gjenforenede': ('gjenforene',),
'gjenforente': ('gjenforene',),
'gjenforenende': ('gjenforene',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikrete': ('gjenforsikre',),
'gjenforsikrede': ('gjenforsikre',),
'gjenforsikrete': ('gjenforsikre',),
'gjenforsikrede': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikrete': ('gjenforsikre',),
'gjenforsikrede': ('gjenforsikre',),
'gjenforsikrete': ('gjenforsikre',),
'gjenforsikrede': ('gjenforsikre',),
'gjenforsikrende': ('gjenforsikre',),
'gjenga': ('gjenge',),
'gjenget': ('gjenge',),
'gjenga': ('gjenge',),
'gjenget': ('gjenge',),
'gjenga': ('gjenge',),
'gjengete': ('gjenge',),
'gjengede': ('gjenge',),
'gjenga': ('gjenge',),
'gjengete': ('gjenge',),
'gjengede': ('gjenge',),
'gjengende': ('gjenge',),
'gjenget': ('gjenget',),
'gjengete': ('gjenget',),
'gjenget': ('gjenget',),
'gjengete': ('gjengete',),
'gjengitt': ('gjengi',),
'gjengitte': ('gjengi',),
'gjengiende': ('gjengi',),
'gjengifta': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengiftete': ('gjengifte',),
'gjengiftede': ('gjengifte',),
'gjengifta': ('gjengifte',),
'gjengiftete': ('gjengifte',),
'gjengiftede': ('gjengifte',),
'gjengiftende': ('gjengifte',),
'gjengjeldt': ('gjengjelde',),
'gjengjeldte': ('gjengjelde',),
'gjengjeldende': ('gjengjelde',),
'gjenglemt': ('gjenglemt',),
'gjenglemte': ('gjenglemt',),
'gjenglemt': ('gjenglemt',),
'gjenglømt': ('gjenglømt',),
'gjenglømte': ('gjenglømt',),
'gjenglømt': ('gjenglømt',),
'gjengrodd': ('gjengrodd',),
'gjengrodde': ('gjengrodd',),
'gjengrodd': ('gjengrodd',),
'gjengs': ('gjengs',),
'gjengse': ('gjengs',),
'gjengs': ('gjengs',),
'gjeninnført': ('gjeninnføre',),
'gjeninnførte': ('gjeninnføre',),
'gjeninnførende': ('gjeninnføre',),
'gjeninnsatt': ('gjeninnsette',),
'gjeninnsatte': ('gjeninnsette',),
'gjeninnsettende': ('gjeninnsette',),
'gjeninntatt': ('gjeninnta',),
'gjeninntatte': ('gjeninnta',),
'gjeninntakende': ('gjeninnta',),
'gjenkalt': ('gjenkalle',),
'gjenkalte': ('gjenkalle',),
'gjenkallende': ('gjenkalle',),
'gjenkjent': ('gjenkjenne',),
'gjenkjente': ('gjenkjenne',),
'gjenkjennende': ('gjenkjenne',),
'gjenkjennelig': ('gjenkjennelig',),
'gjenkjennelige': ('gjenkjennelig',),
'gjenkjennelig': ('gjenkjennelig',),
'gjenlagt': ('gjenlegge',),
'gjenlagte': ('gjenlegge',),
'gjenleggende': ('gjenlegge',),
'gjenlevende': ('gjenlevende',),
'gjenløst': ('gjenløse',),
'gjenløste': ('gjenløse',),
'gjenløsende': ('gjenløse',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennomarbeidd': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennomarbeidd': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidete': ('gjennomarbeide',),
'gjennomarbeidede': ('gjennomarbeide',),
'gjennomarbeidde': ('gjennomarbeide',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidete': ('gjennomarbeide',),
'gjennomarbeidede': ('gjennomarbeide',),
'gjennomarbeidde': ('gjennomarbeide',),
'gjennomarbeidende': ('gjennomarbeide',),
'gjennombarka': ('gjennombarka',),
'gjennombarket': ('gjennombarket',),
'gjennombarkete': ('gjennombarket',),
'gjennombarkede': ('gjennombarket',),
'gjennombarkete': ('gjennombarket',),
'gjennombarkede': ('gjennombarket',),
'gjennombarket': ('gjennombarket',),
'gjennomblaut': ('gjennomblaut',),
'gjennomblaute': ('gjennomblaut',),
'gjennomblautt': ('gjennomblaut',),
'gjennombløt': ('gjennombløt',),
'gjennombløte': ('gjennombløt',),
'gjennombløtt': ('gjennombløt',),
'gjennombora': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennomborete': ('gjennombore',),
'gjennomborede': ('gjennombore',),
'gjennombora': ('gjennombore',),
'gjennomborete': ('gjennombore',),
'gjennomborede': ('gjennombore',),
'gjennomborende': ('gjennombore',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftete': ('gjennomdrøfte',),
'gjennomdrøftede': ('gjennomdrøfte',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftete': ('gjennomdrøfte',),
'gjennomdrøftede': ('gjennomdrøfte',),
'gjennomdrøftende': ('gjennomdrøfte',),
'gjennomfrossen': ('gjennomfrossen',),
'gjennomfrosne': ('gjennomfrossen',),
'gjennomfrosset': ('gjennomfrossen',),
'gjennomfrosset': ('gjennomfrosset',),
'gjennomfrosne': ('gjennomfrosset',),
'gjennomfrosset': ('gjennomfrosset',),
'gjennomført': ('gjennomføre',),
'gjennomførte': ('gjennomføre',),
'gjennomførende': ('gjennomføre',),
'gjennomførlig': ('gjennomførlig',),
'gjennomførlige': ('gjennomførlig',),
'gjennomførlig': ('gjennomførlig',),
'gjennomført': ('gjennomført',),
'gjennomførte': ('gjennomført',),
'gjennomført': ('gjennomført',),
'gjennomgripende': ('gjennomgripende',),
'gjennomgått': ('gjennomgå',),
'gjennomgåtte': ('gjennomgå',),
'gjennomgående': ('gjennomgå',),
'gjennomgående': ('gjennomgående',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullete': ('gjennomhulle',),
'gjennomhullede': ('gjennomhulle',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullete': ('gjennomhulle',),
'gjennomhullede': ('gjennomhulle',),
'gjennomhullende': ('gjennomhulle',),
'gjennomillustrert': ('gjennomillustrere',),
'gjennomillustrerte': ('gjennomillustrere',),
'gjennomillustrerende': ('gjennomillustrere',),
'gjennomlest': ('gjennomlese',),
'gjennomleste': ('gjennomlese',),
'gjennomlesende': ('gjennomlese',),
'gjennomlevd': ('gjennomleve',),
'gjennomlevde': ('gjennomleve',),
'gjennomlevende': ('gjennomleve',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftete': ('gjennomlufte',),
'gjennomluftede': ('gjennomlufte',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftete': ('gjennomlufte',),
'gjennomluftede': ('gjennomlufte',),
'gjennomluftende': ('gjennomlufte',),
'gjennomlyst': ('gjennomlyse',),
'gjennomlyste': ('gjennomlyse',),
'gjennomlysende': ('gjennomlyse',),
'gjennomprøvd': ('gjennomprøve',),
'gjennomprøvde': ('gjennomprøve',),
'gjennomprøvende': ('gjennomprøve',),
'gjennomsett': ('gjennomse',),
'gjennomsette': ('gjennomse',),
'gjennomseende': ('gjennomse',),
'gjennomsiktig': ('gjennomsiktig',),
'gjennomsiktige': ('gjennomsiktig',),
'gjennomsiktig': ('gjennomsiktig',),
'gjennomskinnelig': ('gjennomskinnelig',),
'gjennomskinnelige': ('gjennomskinnelig',),
'gjennomskinnelig': ('gjennomskinnelig',),
'gjennomskua': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskuete': ('gjennomskue',),
'gjennomskuede': ('gjennomskue',),
'gjennomskua': ('gjennomskue',),
'gjennomskuete': ('gjennomskue',),
'gjennomskuede': ('gjennomskue',),
'gjennomskuende': ('gjennomskue',),
'gjennomsnittlig': ('gjennomsnittlig',),
'gjennomsnittlige': ('gjennomsnittlig',),
'gjennomsnittlig': ('gjennomsnittlig',),
'gjennomsteikt': ('gjennomsteike',),
'gjennomsteikte': ('gjennomsteike',),
'gjennomsteikende': ('gjennomsteike',),
'gjennomstekt': ('gjennomsteke',),
'gjennomstekte': ('gjennomsteke',),
'gjennomstekende': ('gjennomsteke',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømt': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømt': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmete': ('gjennomstrømme',),
'gjennomstrømmede': ('gjennomstrømme',),
'gjennomstrømte': ('gjennomstrømme',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmete': ('gjennomstrømme',),
'gjennomstrømmede': ('gjennomstrømme',),
'gjennomstrømte': ('gjennomstrømme',),
'gjennomstrømmende': ('gjennomstrømme',),
'gjennomsvett': ('gjennomsvett',),
'gjennomsvette': ('gjennomsvett',),
'gjennomsvett': ('gjennomsvett',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrt': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrt': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyrete': ('gjennomsyre',),
'gjennomsyrede': ('gjennomsyre',),
'gjennomsyrte': ('gjennomsyre',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyrete': ('gjennomsyre',),
'gjennomsyrede': ('gjennomsyre',),
'gjennomsyrte': ('gjennomsyre',),
'gjennomsyrende': ('gjennomsyre',),
'gjennomtenkt': ('gjennomtenke',),
'gjennomtenkte': ('gjennomtenke',),
'gjennomtenkende': ('gjennomtenke',),
'gjennomtrengt': ('gjennomtrenge',),
'gjennomtrengte': ('gjennomtrenge',),
'gjennomtrengende': ('gjennomtrenge',),
'gjennomtrengelig': ('gjennomtrengelig',),
'gjennomtrengelige': ('gjennomtrengelig',),
'gjennomtrengelig': ('gjennomtrengelig',),
'gjennomtrengende': ('gjennomtrengende',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålt': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålt': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålete': ('gjennomtråle',),
'gjennomtrålede': ('gjennomtråle',),
'gjennomtrålte': ('gjennomtråle',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålete': ('gjennomtråle',),
'gjennomtrålede': ('gjennomtråle',),
'gjennomtrålte': ('gjennomtråle',),
'gjennomtrålende': ('gjennomtråle',),
'gjennomtørr': ('gjennomtørr',),
'gjennomtørre': ('gjennomtørr',),
'gjennomtørt': ('gjennomtørr',),
'gjennomvarm': ('gjennomvarm',),
'gjennomvarme': ('gjennomvarm',),
'gjennomvarmt': ('gjennomvarm',),
'gjennomvåt': ('gjennomvåt',),
'gjennomvåte': ('gjennomvåt',),
'gjennomvått': ('gjennomvåt',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblussete': ('gjenoppblusse',),
'gjenoppblussede': ('gjenoppblusse',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblussete': ('gjenoppblusse',),
'gjenoppblussede': ('gjenoppblusse',),
'gjenoppblussende': ('gjenoppblusse',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppbygd': ('gjenoppbygge',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppbygd': ('gjenoppbygge',),
'gjenoppbyggete': ('gjenoppbygge',),
'gjenoppbyggede': ('gjenoppbygge',),
'gjenoppbygde': ('gjenoppbygge',),
'gjenoppbyggete': ('gjenoppbygge',),
'gjenoppbyggede': ('gjenoppbygge',),
'gjenoppbygde': ('gjenoppbygge',),
'gjenoppbyggende': ('gjenoppbygge',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdagete': ('gjenoppdage',),
'gjenoppdagede': ('gjenoppdage',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdagete': ('gjenoppdage',),
'gjenoppdagede': ('gjenoppdage',),
'gjenoppdagende': ('gjenoppdage',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfriskete': ('gjenoppfriske',),
'gjenoppfriskede': ('gjenoppfriske',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfriskete': ('gjenoppfriske',),
'gjenoppfriskede': ('gjenoppfriske',),
'gjenoppfriskende': ('gjenoppfriske',),
'gjenopplevd': ('gjenoppleve',),
'gjenopplevde': ('gjenoppleve',),
'gjenopplevende': ('gjenoppleve',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivete': ('gjenopplive',),
'gjenopplivede': ('gjenopplive',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivete': ('gjenopplive',),
'gjenopplivede': ('gjenopplive',),
'gjenopplivende': ('gjenopplive',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettete': ('gjenopprette',),
'gjenopprettede': ('gjenopprette',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettete': ('gjenopprette',),
'gjenopprettede': ('gjenopprette',),
'gjenopprettende': ('gjenopprette',),
'gjenopptatt': ('gjenoppta',),
'gjenopptatte': ('gjenoppta',),
'gjenopptakende': ('gjenoppta',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykt': ('gjenopptrykke',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykt': ('gjenopptrykke',),
'gjenopptrykkete': ('gjenopptrykke',),
'gjenopptrykkede': ('gjenopptrykke',),
'gjenopptrykte': ('gjenopptrykke',),
'gjenopptrykkete': ('gjenopptrykke',),
'gjenopptrykkede': ('gjenopptrykke',),
'gjenopptrykte': ('gjenopptrykke',),
'gjenopptrykkende': ('gjenopptrykke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekt': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekt': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekkete': ('gjenoppvekke',),
'gjenoppvekkede': ('gjenoppvekke',),
'gjenoppvekte': ('gjenoppvekke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekkete': ('gjenoppvekke',),
'gjenoppvekkede': ('gjenoppvekke',),
'gjenoppvekte': ('gjenoppvekke',),
'gjenoppvekkende': ('gjenoppvekke',),
'gjenreist': ('gjenreise',),
'gjenreiste': ('gjenreise',),
'gjenreisende': ('gjenreise',),
'gjensidig': ('gjensidig',),
'gjensidige': ('gjensidig',),
'gjensidig': ('gjensidig',),
'gjenskapt': ('gjenskape',),
'gjenskapte': ('gjenskape',),
'gjenskapende': ('gjenskape',),
'gjensnødd': ('gjensnødd',),
'gjensnødde': ('gjensnødd',),
'gjensnødd': ('gjensnødd',),
'gjenspeila': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilt': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilt': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeilete': ('gjenspeile',),
'gjenspeilede': ('gjenspeile',),
'gjenspeilte': ('gjenspeile',),
'gjenspeila': ('gjenspeile',),
'gjenspeilete': ('gjenspeile',),
'gjenspeilede': ('gjenspeile',),
'gjenspeilte': ('gjenspeile',),
'gjenspeilende': ('gjenspeile',),
'gjenstridig': ('gjenstridig',),
'gjenstridige': ('gjenstridig',),
'gjenstridig': ('gjenstridig',),
'gjentatt': ('gjenta',),
'gjentatte': ('gjenta',),
'gjentakende': ('gjenta',),
'gjenvalgt': ('gjenvelge',),
'gjenvalgte': ('gjenvelge',),
'gjenvelgende': ('gjenvelge',),
'gjenvinnbar': ('gjenvinnbar',),
'gjenvinnbare': ('gjenvinnbar',),
'gjenvinnbart': ('gjenvinnbar',),
'gjenværende': ('gjenværende',),
'gjenåpna': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpnete': ('gjenåpne',),
'gjenåpnede': ('gjenåpne',),
'gjenåpnete': ('gjenåpne',),
'gjenåpnede': ('gjenåpne',),
'gjenåpna': ('gjenåpne',),
'gjenåpnete': ('gjenåpne',),
'gjenåpnede': ('gjenåpne',),
'gjenåpnete': ('gjenåpne',),
'gjenåpnede': ('gjenåpne',),
'gjenåpnende': ('gjenåpne',),
'gjerda': ('gjerde',),
'gjerdet': ('gjerde',),
'gjerda': ('gjerde',),
'gjerdet': ('gjerde',),
'gjerda': ('gjerde',),
'gjerdete': ('gjerde',),
'gjerdede': ('gjerde',),
'gjerda': ('gjerde',),
'gjerdete': ('gjerde',),
'gjerdede': ('gjerde',),
'gjerdende': ('gjerde',),
'gjerdelaus': ('gjerdelaus',),
'gjerdelause': ('gjerdelaus',),
'gjerdelaust': ('gjerdelaus',),
'gjerdeløs': ('gjerdeløs',),
'gjerdeløse': ('gjerdeløs',),
'gjerdeløst': ('gjerdeløs',),
'gjerrig': ('gjerrig',),
'gjerrige': ('gjerrig',),
'gjerrig': ('gjerrig',),
'gjerrigere': ('gjerrig',),
'gjerrigst': ('gjerrig',),
'gjerrigste': ('gjerrig',),
'gjespa': ('gjespe',),
'gjespet': ('gjespe',),
'gjespa': ('gjespe',),
'gjespet': ('gjespe',),
'gjespa': ('gjespe',),
'gjespete': ('gjespe',),
'gjespede': ('gjespe',),
'gjespa': ('gjespe',),
'gjespete': ('gjespe',),
'gjespede': ('gjespe',),
'gjespende': ('gjespe',),
'gjesta': ('gjeste',),
'gjestet': ('gjeste',),
'gjesta': ('gjeste',),
'gjestet': ('gjeste',),
'gjesta': ('gjeste',),
'gjestete': ('gjeste',),
'gjestede': ('gjeste',),
'gjesta': ('gjeste',),
'gjestete': ('gjeste',),
'gjestede': ('gjeste',),
'gjestende': ('gjeste',),
'gjestfri': ('gjestfri',),
'gjestfrie': ('gjestfri',),
'gjestfritt': ('gjestfri',),
'gjestmild': ('gjestmild',),
'gjestmilde': ('gjestmild',),
'gjestmildt': ('gjestmild',),
'gjett': ('gjete',),
'gjette': ('gjete',),
'gjetende': ('gjete',),
'gjetta': ('gjette',),
'gjettet': ('gjette',),
'gjetta': ('gjette',),
'gjettet': ('gjette',),
'gjetta': ('gjette',),
'gjettete': ('gjette',),
'gjettede': ('gjette',),
'gjetta': ('gjette',),
'gjettete': ('gjette',),
'gjettede': ('gjette',),
'gjettende': ('gjette',),
'gjev': ('gjev',),
'gjeve': ('gjev',),
'gjevt': ('gjev',),
'gjevere': ('gjev',),
'gjevest': ('gjev',),
'gjeveste': ('gjev',),
'gjorda': ('gjorde',),
'gjordet': ('gjorde',),
'gjorda': ('gjorde',),
'gjordet': ('gjorde',),
'gjorda': ('gjorde',),
'gjordete': ('gjorde',),
'gjordede': ('gjorde',),
'gjorda': ('gjorde',),
'gjordete': ('gjorde',),
'gjordede': ('gjorde',),
'gjordende': ('gjorde',),
'gjura': ('gjure',),
'gjuret': ('gjure',),
'gjurt': ('gjure',),
'gjura': ('gjure',),
'gjuret': ('gjure',),
'gjurt': ('gjure',),
'gjura': ('gjure',),
'gjurete': ('gjure',),
'gjurede': ('gjure',),
'gjurte': ('gjure',),
'gjura': ('gjure',),
'gjurete': ('gjure',),
'gjurede': ('gjure',),
'gjurte': ('gjure',),
'gjurende': ('gjure',),
'gjæra': ('gjære',),
'gjæret': ('gjære',),
'gjært': ('gjære',),
'gjæra': ('gjære',),
'gjæret': ('gjære',),
'gjært': ('gjære',),
'gjæra': ('gjære',),
'gjærete': ('gjære',),
'gjærede': ('gjære',),
'gjærte': ('gjære',),
'gjæra': ('gjære',),
'gjærete': ('gjære',),
'gjærede': ('gjære',),
'gjærte': ('gjære',),
'gjærende': ('gjære',),
'gjødd': ('gjø',),
'gjødde': ('gjø',),
'gjøende': ('gjø',),
'gjødd': ('gjøde',),
'gjødde': ('gjøde',),
'gjødende': ('gjøde',),
'gjødsla': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødslete': ('gjødsle',),
'gjødslede': ('gjødsle',),
'gjødslete': ('gjødsle',),
'gjødslede': ('gjødsle',),
'gjødsla': ('gjødsle',),
'gjødslete': ('gjødsle',),
'gjødslede': ('gjødsle',),
'gjødslete': ('gjødsle',),
'gjødslede': ('gjødsle',),
'gjødslende': ('gjødsle',),
'gjøgla': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøglete': ('gjøgle',),
'gjøglede': ('gjøgle',),
'gjøglete': ('gjøgle',),
'gjøglede': ('gjøgle',),
'gjøgla': ('gjøgle',),
'gjøglete': ('gjøgle',),
'gjøglede': ('gjøgle',),
'gjøglete': ('gjøgle',),
'gjøglede': ('gjøgle',),
'gjøglende': ('gjøgle',),
'gjølt': ('gjøle',),
'gjølte': ('gjøle',),
'gjølende': ('gjøle',),
'gjølet': ('gjølet',),
'gjølete': ('gjølet',),
'gjølet': ('gjølet',),
'gjølete': ('gjølete',),
'gjømt': ('gjømme',),
'gjømte': ('gjømme',),
'gjømmende': ('gjømme',),
'gjønt': ('gjøne',),
'gjønte': ('gjøne',),
'gjønende': ('gjøne',),
'gjort': ('gjøre',),
'gjorte': ('gjøre',),
'gjørende': ('gjøre',),
'gjørlig': ('gjørlig',),
'gjørlige': ('gjørlig',),
'gjørlig': ('gjørlig',),
'gjørma': ('gjørme',),
'gjørmet': ('gjørme',),
'gjørma': ('gjørme',),
'gjørmet': ('gjørme',),
'gjørma': ('gjørme',),
'gjørmete': ('gjørme',),
'gjørmede': ('gjørme',),
'gjørma': ('gjørme',),
'gjørmete': ('gjørme',),
'gjørmede': ('gjørme',),
'gjørmende': ('gjørme',),
'gjørmet': ('gjørmet',),
'gjørmete': ('gjørmet',),
'gjørmet': ('gjørmet',),
'gjørmete': ('gjørmete',),
'gladd': ('gla',),
'gladde': ('gla',),
'glaende': ('gla',),
'glad': ('glad',),
'glade': ('glad',),
'glad': ('glad',),
'gladere': ('glad',),
'gladest': ('glad',),
'gladeste': ('glad',),
'gladlynt': ('gladlynt',),
'gladlynte': ('gladlynt',),
'gladlynt': ('gladlynt',),
'glafsa': ('glafse',),
'glafset': ('glafse',),
'glafsa': ('glafse',),
'glafset': ('glafse',),
'glafsa': ('glafse',),
'glafsete': ('glafse',),
'glafsede': ('glafse',),
'glafsa': ('glafse',),
'glafsete': ('glafse',),
'glafsede': ('glafse',),
'glafsende': ('glafse',),
'glamma': ('glamme',),
'glammet': ('glamme',),
'glamma': ('glamme',),
'glammet': ('glamme',),
'glamma': ('glamme',),
'glammete': ('glamme',),
'glammede': ('glamme',),
'glamma': ('glamme',),
'glammete': ('glamme',),
'glammede': ('glamme',),
'glammende': ('glamme',),
'glamorisert': ('glamorisere',),
'glamoriserte': ('glamorisere',),
'glamoriserende': ('glamorisere',),
'glamorøs': ('glamorøs',),
'glamorøse': ('glamorøs',),
'glamorøst': ('glamorøs',),
'glant': ('glane',),
'glante': ('glane',),
'glanende': ('glane',),
'glansa': ('glanse',),
'glanset': ('glanse',),
'glansa': ('glanse',),
'glanset': ('glanse',),
'glansa': ('glanse',),
'glansete': ('glanse',),
'glansede': ('glanse',),
'glansa': ('glanse',),
'glansete': ('glanse',),
'glansede': ('glanse',),
'glansende': ('glanse',),
'glasert': ('glasere',),
'glaserte': ('glasere',),
'glaserende': ('glasere',),
'glasial': ('glasial',),
'glasiale': ('glasial',),
'glasialt': ('glasial',),
'glasiologisk': ('glasiologisk',),
'glasiologiske': ('glasiologisk',),
'glasiologisk': ('glasiologisk',),
'glassaktig': ('glassaktig',),
'glassaktige': ('glassaktig',),
'glassaktig': ('glassaktig',),
'glassblank': ('glassblank',),
'glassblanke': ('glassblank',),
'glassblankt': ('glassblank',),
'glasshard': ('glasshard',),
'glassharde': ('glasshard',),
'glasshardt': ('glasshard',),
'glassklar': ('glassklar',),
'glassklare': ('glassklar',),
'glassklart': ('glassklar',),
'glatt': ('glatt',),
'glatte': ('glatt',),
'glatt': ('glatt',),
'glattere': ('glatt',),
'glattest': ('glatt',),
'glatteste': ('glatt',),
'glattbarbert': ('glattbarbere',),
'glattbarberte': ('glattbarbere',),
'glattbarberende': ('glattbarbere',),
'glatta': ('glatte',),
'glattet': ('glatte',),
'glatta': ('glatte',),
'glattet': ('glatte',),
'glatta': ('glatte',),
'glattete': ('glatte',),
'glattede': ('glatte',),
'glatta': ('glatte',),
'glattete': ('glatte',),
'glattede': ('glatte',),
'glattende': ('glatte',),
'glatthåra': ('glatthåra',),
'glatthåret': ('glatthåret',),
'glatthårete': ('glatthåret',),
'glatthårede': ('glatthåret',),
'glatthårete': ('glatthåret',),
'glatthårede': ('glatthåret',),
'glatthåret': ('glatthåret',),
'glattkjemma': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemt': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemt': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemmete': ('glattkjemme',),
'glattkjemmede': ('glattkjemme',),
'glattkjemte': ('glattkjemme',),
'glattkjemma': ('glattkjemme',),
'glattkjemmete': ('glattkjemme',),
'glattkjemmede': ('glattkjemme',),
'glattkjemte': ('glattkjemme',),
'glattkjemmende': ('glattkjemme',),
'glattløpa': ('glattløpa',),
'glattløpet': ('glattløpet',),
'glattløpete': ('glattløpet',),
'glattløpede': ('glattløpet',),
'glattløpete': ('glattløpet',),
'glattløpede': ('glattløpet',),
'glattløpet': ('glattløpet',),
'glattstrøket': ('glattstryke',),
'glattstrøken': ('glattstryke',),
'glattstrøket': ('glattstryke',),
'glattstrøken': ('glattstryke',),
'glattstrøkne': ('glattstryke',),
'glattstrykende': ('glattstryke',),
'gleda': ('glede',),
'gledet': ('glede',),
'gledd': ('glede',),
'gleda': ('glede',),
'gledet': ('glede',),
'gledd': ('glede',),
'gleda': ('glede',),
'gledete': ('glede',),
'gledede': ('glede',),
'gledde': ('glede',),
'gleda': ('glede',),
'gledete': ('glede',),
'gledede': ('glede',),
'gledde': ('glede',),
'gledende': ('glede',),
'gledefylt': ('gledefylt',),
'gledefylte': ('gledefylt',),
'gledefylt': ('gledefylt',),
'gledelaus': ('gledelaus',),
'gledelause': ('gledelaus',),
'gledelaust': ('gledelaus',),
'gledelig': ('gledelig',),
'gledelige': ('gledelig',),
'gledelig': ('gledelig',),
'gledeligere': ('gledelig',),
'gledeligst': ('gledelig',),
'gledeligste': ('gledelig',),
'gledeløs': ('gledeløs',),
'gledeløse': ('gledeløs',),
'gledeløst': ('gledeløs',),
'glederik': ('glederik',),
'glederike': ('glederik',),
'glederikt': ('glederik',),
'gledestrålende': ('gledestrålende',),
'glefsa': ('glefse',),
'glefset': ('glefse',),
'glefst': ('glefse',),
'glefsa': ('glefse',),
'glefset': ('glefse',),
'glefst': ('glefse',),
'glefsa': ('glefse',),
'glefsete': ('glefse',),
'glefsede': ('glefse',),
'glefste': ('glefse',),
'glefsa': ('glefse',),
'glefsete': ('glefse',),
'glefsede': ('glefse',),
'glefste': ('glefse',),
'glefsende': ('glefse',),
'glemt': ('glemme',),
'glemte': ('glemme',),
'glemmende': ('glemme',),
'glemsk': ('glemsk',),
'glemske': ('glemsk',),
'glemsk': ('glemsk',),
'glemsom': ('glemsom',),
'glemsomme': ('glemsom',),
'glemsomt': ('glemsom',),
'glemsommere': ('glemsom',),
'glemsomst': ('glemsom',),
'glemsomste': ('glemsom',),
'gleppet': ('gleppe',),
'gleppete': ('gleppe',),
'gleppede': ('gleppe',),
'gleppete': ('gleppe',),
'gleppede': ('gleppe',),
'gleppende': ('gleppe',),
'glidd': ('gli',),
'glidde': ('gli',),
'gliende': ('gli',),
'glideflydd': ('glidefly',),
'glidefløyet': ('glidefly',),
'glideflydd': ('glidefly',),
'glidefløyet': ('glidefly',),
'glidefløyen': ('glidefly',),
'glideflydde': ('glidefly',),
'glidefløyne': ('glidefly',),
'glideflydde': ('glidefly',),
'glidefløyne': ('glidefly',),
'glideflyende': ('glidefly',),
'glidefløyet': ('glideflyge',),
'glidefløyen': ('glideflyge',),
'glidefløyne': ('glideflyge',),
'glideflygende': ('glideflyge',),
'glidende': ('glidende',),
'glimt': ('glime',),
'glimte': ('glime',),
'glimende': ('glime',),
'glimra': ('glimre',),
'glimret': ('glimre',),
'glimra': ('glimre',),
'glimret': ('glimre',),
'glimra': ('glimre',),
'glimrete': ('glimre',),
'glimrede': ('glimre',),
'glimrete': ('glimre',),
'glimrede': ('glimre',),
'glimra': ('glimre',),
'glimrete': ('glimre',),
'glimrede': ('glimre',),
'glimrete': ('glimre',),
'glimrede': ('glimre',),
'glimrende': ('glimre',),
'glimrende': ('glimrende',),
'glimta': ('glimte',),
'glimtet': ('glimte',),
'glimta': ('glimte',),
'glimtet': ('glimte',),
'glimta': ('glimte',),
'glimtete': ('glimte',),
'glimtede': ('glimte',),
'glimta': ('glimte',),
'glimtete': ('glimte',),
'glimtede': ('glimte',),
'glimtende': ('glimte',),
'glinsa': ('glinse',),
'glinset': ('glinse',),
'glinsa': ('glinse',),
'glinset': ('glinse',),
'glinsa': ('glinse',),
'glinsete': ('glinse',),
'glinsede': ('glinse',),
'glinsa': ('glinse',),
'glinsete': ('glinse',),
'glinsede': ('glinse',),
'glinsende': ('glinse',),
'glipt': ('glipe',),
'glipte': ('glipe',),
'glipende': ('glipe',),
'glirt': ('glire',),
'glirte': ('glire',),
'glirende': ('glire',),
'glist': ('glise',),
'gliste': ('glise',),
'glisende': ('glise',),
'glissen': ('glissen',),
'glisne': ('glissen',),
'glissent': ('glissen',),
'glitra': ('glitre',),
'glitret': ('glitre',),
'glitra': ('glitre',),
'glitret': ('glitre',),
'glitra': ('glitre',),
'glitrete': ('glitre',),
'glitrede': ('glitre',),
'glitrete': ('glitre',),
'glitrede': ('glitre',),
'glitra': ('glitre',),
'glitrete': ('glitre',),
'glitrede': ('glitre',),
'glitrete': ('glitre',),
'glitrede': ('glitre',),
'glitrende': ('glitre',),
'glitrende': ('glitrende',),
'glitta': ('glitte',),
'glittet': ('glitte',),
'glitta': ('glitte',),
'glittet': ('glitte',),
'glitta': ('glitte',),
'glittete': ('glitte',),
'glittede': ('glitte',),
'glitta': ('glitte',),
'glittete': ('glitte',),
'glittede': ('glitte',),
'glittende': ('glitte',),
'glodd': ('glo',),
'glodde': ('glo',),
'gloende': ('glo',),
'global': ('global',),
'globale': ('global',),
'globalt': ('global',),
'gloende': ('gloende',),
'glohet': ('glohet',),
'glohete': ('glohet',),
'glohett': ('glohet',),
'glora': ('glore',),
'gloret': ('glore',),
'glort': ('glore',),
'glora': ('glore',),
'gloret': ('glore',),
'glort': ('glore',),
'glora': ('glore',),
'glorete': ('glore',),
'glorede': ('glore',),
'glorte': ('glore',),
'glora': ('glore',),
'glorete': ('glore',),
'glorede': ('glore',),
'glorte': ('glore',),
'glorende': ('glore',),
'gloret': ('gloret',),
'glorete': ('gloret',),
'gloret': ('gloret',),
'glorete': ('glorete',),
'glorifisert': ('glorifisere',),
'glorifiserte': ('glorifisere',),
'glorifiserende': ('glorifisere',),
'gloriøs': ('gloriøs',),
'gloriøse': ('gloriøs',),
'gloriøst': ('gloriøs',),
'glorverdig': ('glorverdig',),
'glorverdige': ('glorverdig',),
'glorverdig': ('glorverdig',),
'glorød': ('glorød',),
'glorøde': ('glorød',),
'glorødt': ('glorød',),
'glottal': ('glottal',),
'glottale': ('glottal',),
'glottalt': ('glottal',),
'glovarm': ('glovarm',),
'glovarme': ('glovarm',),
'glovarmt': ('glovarm',),
'glup': ('glup',),
'glupe': ('glup',),
'glupt': ('glup',),
'glupere': ('glup',),
'glupest': ('glup',),
'glupeste': ('glup',),
'glupende': ('glupende',),
'glupsk': ('glupsk',),
'glupske': ('glupsk',),
'glupsk': ('glupsk',),
'glutenholdig': ('glutenholdig',),
'glutenholdige': ('glutenholdig',),
'glutenholdig': ('glutenholdig',),
'gløda': ('gløde',),
'glødet': ('gløde',),
'glødd': ('gløde',),
'gløda': ('gløde',),
'glødet': ('gløde',),
'glødd': ('gløde',),
'gløda': ('gløde',),
'glødete': ('gløde',),
'glødede': ('gløde',),
'glødde': ('gløde',),
'gløda': ('gløde',),
'glødete': ('gløde',),
'glødede': ('gløde',),
'glødde': ('gløde',),
'glødende': ('gløde',),
'glødende': ('glødende',),
'gløgg': ('gløgg',),
'gløgge': ('gløgg',),
'gløgt': ('gløgg',),
'gløggere': ('gløgg',),
'gløggest': ('gløgg',),
'gløggeste': ('gløgg',),
'gløggtenkt': ('gløggtenkt',),
'gløggtenkte': ('gløggtenkt',),
'gløggtenkt': ('gløggtenkt',),
'glømt': ('glømme',),
'glømte': ('glømme',),
'glømmende': ('glømme',),
'glømsk': ('glømsk',),
'glømske': ('glømsk',),
'glømsk': ('glømsk',),
'glømsom': ('glømsom',),
'glømsomme': ('glømsom',),
'glømsomt': ('glømsom',),
'glømsommere': ('glømsom',),
'glømsomst': ('glømsom',),
'glømsomste': ('glømsom',),
'gløtta': ('gløtte',),
'gløttet': ('gløtte',),
'gløtta': ('gløtte',),
'gløttet': ('gløtte',),
'gløtta': ('gløtte',),
'gløttete': ('gløtte',),
'gløttede': ('gløtte',),
'gløtta': ('gløtte',),
'gløttete': ('gløtte',),
'gløttede': ('gløtte',),
'gløttende': ('gløtte',),
'gnafsa': ('gnafse',),
'gnafset': ('gnafse',),
'gnafst': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafset': ('gnafse',),
'gnafst': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafsete': ('gnafse',),
'gnafsede': ('gnafse',),
'gnafste': ('gnafse',),
'gnafsa': ('gnafse',),
'gnafsete': ('gnafse',),
'gnafsede': ('gnafse',),
'gnafste': ('gnafse',),
'gnafsende': ('gnafse',),
'gnaget': ('gnage',),
'gnagd': ('gnage',),
'gnaget': ('gnage',),
'gnagd': ('gnage',),
'gnagete': ('gnage',),
'gnagede': ('gnage',),
'gnagde': ('gnage',),
'gnagete': ('gnage',),
'gnagede': ('gnage',),
'gnagde': ('gnage',),
'gnagende': ('gnage',),
'gnaldra': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldrete': ('gnaldre',),
'gnaldrede': ('gnaldre',),
'gnaldrete': ('gnaldre',),
'gnaldrede': ('gnaldre',),
'gnaldra': ('gnaldre',),
'gnaldrete': ('gnaldre',),
'gnaldrede': ('gnaldre',),
'gnaldrete': ('gnaldre',),
'gnaldrede': ('gnaldre',),
'gnaldrende': ('gnaldre',),
'gneldra': ('gneldre',),
'gneldret': ('gneldre',),
'gneldra': ('gneldre',),
'gneldret': ('gneldre',),
'gneldra': ('gneldre',),
'gneldrete': ('gneldre',),
'gneldrede': ('gneldre',),
'gneldrete': ('gneldre',),
'gneldrede': ('gneldre',),
'gneldra': ('gneldre',),
'gneldrete': ('gneldre',),
'gneldrede': ('gneldre',),
'gneldrete': ('gneldre',),
'gneldrede': ('gneldre',),
'gneldrende': ('gneldre',),
'gnell': ('gnell',),
'gnelle': ('gnell',),
'gnelt': ('gnell',),
'gnellere': ('gnell',),
'gnellest': ('gnell',),
'gnelleste': ('gnell',),
'gnelt': ('gnelle',),
'gnelte': ('gnelle',),
'gnellende': ('gnelle',),
'gnidd': ('gni',),
'gnidde': ('gni',),
'gniende': ('gni',),
'gnidra': ('gnidre',),
'gnidret': ('gnidre',),
'gnidra': ('gnidre',),
'gnidret': ('gnidre',),
'gnidra': ('gnidre',),
'gnidrete': ('gnidre',),
'gnidrede': ('gnidre',),
'gnidrete': ('gnidre',),
'gnidrede': ('gnidre',),
'gnidra': ('gnidre',),
'gnidrete': ('gnidre',),
'gnidrede': ('gnidre',),
'gnidrete': ('gnidre',),
'gnidrede': ('gnidre',),
'gnidrende': ('gnidre',),
'gnidret': ('gnidret',),
'gnidrete': ('gnidret',),
'gnidret': ('gnidret',),
'gnidrete': ('gnidrete',),
'gnieraktig': ('gnieraktig',),
'gnieraktige': ('gnieraktig',),
'gnieraktig': ('gnieraktig',),
'gniken': ('gniken',),
'gnikne': ('gniken',),
'gnikent': ('gniken',),
'gnikka': ('gnikke',),
'gnikket': ('gnikke',),
'gnikka': ('gnikke',),
'gnikket': ('gnikke',),
'gnikka': ('gnikke',),
'gnikkete': ('gnikke',),
'gnikkede': ('gnikke',),
'gnikka': ('gnikke',),
'gnikkete': ('gnikke',),
'gnikkede': ('gnikke',),
'gnikkende': ('gnikke',),
'gniksa': ('gnikse',),
'gnikset': ('gnikse',),
'gniksa': ('gnikse',),
'gnikset': ('gnikse',),
'gniksa': ('gnikse',),
'gniksete': ('gnikse',),
'gniksede': ('gnikse',),
'gniksa': ('gnikse',),
'gniksete': ('gnikse',),
'gniksede': ('gnikse',),
'gniksende': ('gnikse',),
'gnirka': ('gnirke',),
'gnirket': ('gnirke',),
'gnirka': ('gnirke',),
'gnirket': ('gnirke',),
'gnirka': ('gnirke',),
'gnirkete': ('gnirke',),
'gnirkede': ('gnirke',),
'gnirka': ('gnirke',),
'gnirkete': ('gnirke',),
'gnirkede': ('gnirke',),
'gnirkende': ('gnirke',),
'gnisla': ('gnisle',),
'gnislet': ('gnisle',),
'gnisla': ('gnisle',),
'gnislet': ('gnisle',),
'gnisla': ('gnisle',),
'gnislete': ('gnisle',),
'gnislede': ('gnisle',),
'gnisla': ('gnisle',),
'gnislete': ('gnisle',),
'gnislede': ('gnisle',),
'gnislende': ('gnisle',),
'gnissa': ('gnisse',),
'gnisset': ('gnisse',),
'gnissa': ('gnisse',),
'gnisset': ('gnisse',),
'gnissa': ('gnisse',),
'gnissete': ('gnisse',),
'gnissede': ('gnisse',),
'gnissa': ('gnisse',),
'gnissete': ('gnisse',),
'gnissede': ('gnisse',),
'gnissende': ('gnisse',),
'gnista': ('gniste',),
'gnistet': ('gniste',),
'gnista': ('gniste',),
'gnistet': ('gniste',),
'gnista': ('gniste',),
'gnistete': ('gniste',),
'gnistede': ('gniste',),
'gnista': ('gniste',),
'gnistete': ('gniste',),
'gnistede': ('gniste',),
'gnistende': ('gniste',),
'gnistra': ('gnistre',),
'gnistret': ('gnistre',),
'gnistra': ('gnistre',),
'gnistret': ('gnistre',),
'gnistra': ('gnistre',),
'gnistrete': ('gnistre',),
'gnistrede': ('gnistre',),
'gnistrete': ('gnistre',),
'gnistrede': ('gnistre',),
'gnistra': ('gnistre',),
'gnistrete': ('gnistre',),
'gnistrede': ('gnistre',),
'gnistrete': ('gnistre',),
'gnistrede': ('gnistre',),
'gnistrende': ('gnistre',),
'gnistrende': ('gnistrende',),
'gnomisk': ('gnomisk',),
'gnomiske': ('gnomisk',),
'gnomisk': ('gnomisk',),
'gnostisk': ('gnostisk',),
'gnostiske': ('gnostisk',),
'gnostisk': ('gnostisk',),
'gnudd': ('gnu',),
'gnudde': ('gnu',),
'gnuende': ('gnu',),
'gnubba': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbete': ('gnubbe',),
'gnubbede': ('gnubbe',),
'gnubba': ('gnubbe',),
'gnubbete': ('gnubbe',),
'gnubbede': ('gnubbe',),
'gnubbende': ('gnubbe',),
'gnugga': ('gnugge',),
'gnugget': ('gnugge',),
'gnugga': ('gnugge',),
'gnugget': ('gnugge',),
'gnugga': ('gnugge',),
'gnuggete': ('gnugge',),
'gnuggede': ('gnugge',),
'gnugga': ('gnugge',),
'gnuggete': ('gnugge',),
'gnuggede': ('gnugge',),
'gnuggende': ('gnugge',),
'gnukka': ('gnukke',),
'gnukket': ('gnukke',),
'gnukka': ('gnukke',),
'gnukket': ('gnukke',),
'gnukka': ('gnukke',),
'gnukkete': ('gnukke',),
'gnukkede': ('gnukke',),
'gnukka': ('gnukke',),
'gnukkete': ('gnukke',),
'gnukkede': ('gnukke',),
'gnukkende': ('gnukke',),
'gnura': ('gnure',),
'gnuret': ('gnure',),
'gnurt': ('gnure',),
'gnura': ('gnure',),
'gnuret': ('gnure',),
'gnurt': ('gnure',),
'gnura': ('gnure',),
'gnurete': ('gnure',),
'gnurede': ('gnure',),
'gnurte': ('gnure',),
'gnura': ('gnure',),
'gnurete': ('gnure',),
'gnurede': ('gnure',),
'gnurte': ('gnure',),
'gnurende': ('gnure',),
'gnusla': ('gnusle',),
'gnuslet': ('gnusle',),
'gnusla': ('gnusle',),
'gnuslet': ('gnusle',),
'gnusla': ('gnusle',),
'gnuslete': ('gnusle',),
'gnuslede': ('gnusle',),
'gnusla': ('gnusle',),
'gnuslete': ('gnusle',),
'gnuslede': ('gnusle',),
'gnuslende': ('gnusle',),
'gnussa': ('gnusse',),
'gnusset': ('gnusse',),
'gnussa': ('gnusse',),
'gnusset': ('gnusse',),
'gnussa': ('gnusse',),
'gnussete': ('gnusse',),
'gnussede': ('gnusse',),
'gnussa': ('gnusse',),
'gnussete': ('gnusse',),
'gnussede': ('gnusse',),
'gnussende': ('gnusse',),
'gnydd': ('gny',),
'gnydde': ('gny',),
'gnyende': ('gny',),
'gnålt': ('gnåle',),
'gnålte': ('gnåle',),
'gnålende': ('gnåle',),
'goanesisk': ('goanesisk',),
'goanesiske': ('goanesisk',),
'goanesisk': ('goanesisk',),
'god': ('god',),
'gode': ('god',),
'godt': ('god',),
'bedre': ('god',),
'best': ('god',),
'beste': ('god',),
'godarta': ('godarta',),
'godartet': ('godartet',),
'godartete': ('godartet',),
'godartede': ('godartet',),
'godartete': ('godartet',),
'godartede': ('godartet',),
'godartet': ('godartet',),
'godfjottet': ('godfjottet',),
'godfjottete': ('godfjottet',),
'godfjottet': ('godfjottet',),
'godfjottete': ('godfjottete',),
'godgjort': ('godgjøre',),
'godgjorte': ('godgjøre',),
'godgjørende': ('godgjøre',),
'godgjørende': ('godgjørende',),
'godhjerta': ('godhjerta',),
'godhjertet': ('godhjertet',),
'godhjertete': ('godhjertet',),
'godhjertede': ('godhjertet',),
'godhjertete': ('godhjertet',),
'godhjertede': ('godhjertet',),
'godhjertet': ('godhjertet',),
'godkjent': ('godkjenne',),
'godkjente': ('godkjenne',),
'godkjennende': ('godkjenne',),
'godkjent': ('godkjent',),
'godkjente': ('godkjent',),
'godkjent': ('godkjent',),
'godlynt': ('godlynt',),
'godlynte': ('godlynt',),
'godlynt': ('godlynt',),
'godmodig': ('godmodig',),
'godmodige': ('godmodig',),
'godmodig': ('godmodig',),
'godskrevet': ('godskrive',),
'godskreven': ('godskrive',),
'godskrevne': ('godskrive',),
'godskrivende': ('godskrive',),
'godslig': ('godslig',),
'godslige': ('godslig',),
'godslig': ('godslig',),
'godsnakka': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakkete': ('godsnakke',),
'godsnakkede': ('godsnakke',),
'godsnakka': ('godsnakke',),
'godsnakkete': ('godsnakke',),
'godsnakkede': ('godsnakke',),
'godsnakkende': ('godsnakke',),
'godtatt': ('godta',),
'godtatte': ('godta',),
'godtakende': ('godta',),
'godta': ('godte',),
'godtet': ('godte',),
'godta': ('godte',),
'godtet': ('godte',),
'godta': ('godte',),
'godtete': ('godte',),
'godtede': ('godte',),
'godta': ('godte',),
'godtete': ('godte',),
'godtede': ('godte',),
'godtende': ('godte',),
'godtekkelig': ('godtekkelig',),
'godtekkelige': ('godtekkelig',),
'godtekkelig': ('godtekkelig',),
'godtgjort': ('godtgjøre',),
'godtgjorte': ('godtgjøre',),
'godtgjørende': ('godtgjøre',),
'godtkjøps': ('godtkjøps',),
'godtroende': ('godtroende',),
'godtruen': ('godtruen',),
'godtruene': ('godtruen',),
'godtruent': ('godtruen',),
'godtruende': ('godtruende',),
'godvillig': ('godvillig',),
'godvillige': ('godvillig',),
'godvillig': ('godvillig',),
'gold': ('gold',),
'golde': ('gold',),
'goldt': ('gold',),
'goldere': ('gold',),
'goldest': ('gold',),
'goldeste': ('gold',),
'gomla': ('gomle',),
'gomlet': ('gomle',),
'gomla': ('gomle',),
'gomlet': ('gomle',),
'gomla': ('gomle',),
'gomlete': ('gomle',),
'gomlede': ('gomle',),
'gomlete': ('gomle',),
'gomlede': ('gomle',),
'gomla': ('gomle',),
'gomlete': ('gomle',),
'gomlede': ('gomle',),
'gomlete': ('gomle',),
'gomlede': ('gomle',),
'gomlende': ('gomle',),
'gordisk': ('gordisk',),
'gordiske': ('gordisk',),
'gordisk': ('gordisk',),
'gotisk': ('gotisk',),
'gotiske': ('gotisk',),
'gotisk': ('gotisk',),
'gotlandsk': ('gotlandsk',),
'gotlandske': ('gotlandsk',),
'gotlandsk': ('gotlandsk',),
'gova': ('gove',),
'govet': ('gove',),
'gova': ('gove',),
'govet': ('gove',),
'gova': ('gove',),
'govete': ('gove',),
'govede': ('gove',),
'gova': ('gove',),
'govete': ('gove',),
'govede': ('gove',),
'govende': ('gove',),
'gra': ('gra',),
'grae': ('gra',),
'gra': ('gra',),
'grae': ('gra',),
'gra': ('gra',),
'grabba': ('grabbe',),
'grabbet': ('grabbe',),
'grabba': ('grabbe',),
'grabbet': ('grabbe',),
'grabba': ('grabbe',),
'grabbete': ('grabbe',),
'grabbede': ('grabbe',),
'grabba': ('grabbe',),
'grabbete': ('grabbe',),
'grabbede': ('grabbe',),
'grabbende': ('grabbe',),
'gradbøyet': ('gradbøye',),
'gradbøyd': ('gradbøye',),
'gradbøyet': ('gradbøye',),
'gradbøyd': ('gradbøye',),
'gradbøyete': ('gradbøye',),
'gradbøyede': ('gradbøye',),
'gradbøyde': ('gradbøye',),
'gradbøyete': ('gradbøye',),
'gradbøyede': ('gradbøye',),
'gradbøyde': ('gradbøye',),
'gradbøyende': ('gradbøye',),
'grada': ('grade',),
'gradet': ('grade',),
'grada': ('grade',),
'gradet': ('grade',),
'grada': ('grade',),
'gradete': ('grade',),
'gradede': ('grade',),
'grada': ('grade',),
'gradete': ('grade',),
'gradede': ('grade',),
'gradende': ('grade',),
'gradert': ('gradere',),
'graderte': ('gradere',),
'graderende': ('gradere',),
'gradual': ('gradual',),
'graduale': ('gradual',),
'gradualt': ('gradual',),
'graduell': ('graduell',),
'graduelle': ('graduell',),
'graduelt': ('graduell',),
'graduert': ('graduere',),
'graduerte': ('graduere',),
'graduerende': ('graduere',),
'grafisk': ('grafisk',),
'grafiske': ('grafisk',),
'grafisk': ('grafisk',),
'grafologisk': ('grafologisk',),
'grafologiske': ('grafologisk',),
'grafologisk': ('grafologisk',),
'grafsa': ('grafse',),
'grafset': ('grafse',),
'grafsa': ('grafse',),
'grafset': ('grafse',),
'grafsa': ('grafse',),
'grafsete': ('grafse',),
'grafsede': ('grafse',),
'grafsa': ('grafse',),
'grafsete': ('grafse',),
'grafsede': ('grafse',),
'grafsende': ('grafse',),
'grafsen': ('grafsen',),
'grafsne': ('grafsen',),
'grafsent': ('grafsen',),
'gram': ('gram',),
'gramme': ('gram',),
'gramt': ('gram',),
'grammere': ('gram',),
'grammest': ('gram',),
'grammeste': ('gram',),
'grammatikalsk': ('grammatikalsk',),
'grammatikalske': ('grammatikalsk',),
'grammatikalsk': ('grammatikalsk',),
'grammatisk': ('grammatisk',),
'grammatiske': ('grammatisk',),
'grammatisk': ('grammatisk',),
'gramnegativ': ('gramnegativ',),
'gramnegative': ('gramnegativ',),
'gramnegativt': ('gramnegativ',),
'grampositiv': ('grampositiv',),
'grampositive': ('grampositiv',),
'grampositivt': ('grampositiv',),
'gramsa': ('gramse',),
'gramset': ('gramse',),
'gramsa': ('gramse',),
'gramset': ('gramse',),
'gramsa': ('gramse',),
'gramsete': ('gramse',),
'gramsede': ('gramse',),
'gramsa': ('gramse',),
'gramsete': ('gramse',),
'gramsede': ('gramse',),
'gramsende': ('gramse',),
'grand': ('grand',),
'grandios': ('grandios',),
'grandiose': ('grandios',),
'grandiost': ('grandios',),
'granittisk': ('granittisk',),
'granittiske': ('granittisk',),
'granittisk': ('granittisk',),
'grann': ('grann',),
'granne': ('grann',),
'grant': ('grann',),
'grannere': ('grann',),
'grannest': ('grann',),
'granneste': ('grann',),
'grannmælt': ('grannmælt',),
'grannmælte': ('grannmælt',),
'grannmælt': ('grannmælt',),
'grannvokst': ('grannvokst',),
'grannvokste': ('grannvokst',),
'grannvokst': ('grannvokst',),
'granska': ('granske',),
'gransket': ('granske',),
'granska': ('granske',),
'gransket': ('granske',),
'granska': ('granske',),
'granskete': ('granske',),
'granskede': ('granske',),
'granska': ('granske',),
'granskete': ('granske',),
'granskede': ('granske',),
'granskende': ('granske',),
'granulert': ('granulere',),
'granulerte': ('granulere',),
'granulerende': ('granulere',),
'grasa': ('grase',),
'graset': ('grase',),
'grasa': ('grase',),
'graset': ('grase',),
'grasa': ('grase',),
'grasete': ('grase',),
'grasede': ('grase',),
'grasa': ('grase',),
'grasete': ('grase',),
'grasede': ('grase',),
'grasende': ('grase',),
'grasgrodd': ('grasgrodd',),
'grasgrodde': ('grasgrodd',),
'grasgrodd': ('grasgrodd',),
'grasil': ('grasil',),
'grasile': ('grasil',),
'grasilt': ('grasil',),
'grasiøs': ('grasiøs',),
'grasiøse': ('grasiøs',),
'grasiøst': ('grasiøs',),
'graskledd': ('graskledd',),
'graskledde': ('graskledd',),
'graskledd': ('graskledd',),
'grassert': ('grassere',),
'grasserte': ('grassere',),
'grasserende': ('grassere',),
'gratinert': ('gratinere',),
'gratinerte': ('gratinere',),
'gratinerende': ('gratinere',),
'gratis': ('gratis',),
'gratulert': ('gratulere',),
'gratulerte': ('gratulere',),
'gratulerende': ('gratulere',),
'grautaktig': ('grautaktig',),
'grautaktige': ('grautaktig',),
'grautaktig': ('grautaktig',),
'grauten': ('grauten',),
'grautne': ('grauten',),
'grautent': ('grauten',),
'grautet': ('grautet',),
'grautete': ('grautet',),
'grautet': ('grautet',),
'grautete': ('grautete',),
'gravalvorlig': ('gravalvorlig',),
'gravalvorlige': ('gravalvorlig',),
'gravalvorlig': ('gravalvorlig',),
'grava': ('grave',),
'gravet': ('grave',),
'gravd': ('grave',),
'grava': ('grave',),
'gravet': ('grave',),
'gravd': ('grave',),
'grava': ('grave',),
'gravete': ('grave',),
'gravede': ('grave',),
'gravde': ('grave',),
'grava': ('grave',),
'gravete': ('grave',),
'gravede': ('grave',),
'gravde': ('grave',),
'gravende': ('grave',),
'gravd': ('grave',),
'gravde': ('grave',),
'gravende': ('grave',),
'gravert': ('gravere',),
'graverte': ('gravere',),
'graverende': ('gravere',),
'graverende': ('graverende',),
'gravid': ('gravid',),
'gravide': ('gravid',),
'gravid': ('gravid',),
'gravitert': ('gravitere',),
'graviterte': ('gravitere',),
'graviterende': ('gravitere',),
'gravitetisk': ('gravitetisk',),
'gravitetiske': ('gravitetisk',),
'gravitetisk': ('gravitetisk',),
'gravlagt': ('gravlegge',),
'gravlagte': ('gravlegge',),
'gravleggende': ('gravlegge',),
'gredd': ('gre',),
'gredde': ('gre',),
'greende': ('gre',),
'gregoriansk': ('gregoriansk',),
'gregorianske': ('gregoriansk',),
'gregoriansk': ('gregoriansk',),
'grei': ('grei',),
'greie': ('grei',),
'greit': ('grei',),
'greiere': ('grei',),
'greiest': ('grei',),
'greieste': ('grei',),
'greid': ('greie',),
'greide': ('greie',),
'greiende': ('greie',),
'greina': ('greine',),
'greinet': ('greine',),
'greint': ('greine',),
'greina': ('greine',),
'greinet': ('greine',),
'greint': ('greine',),
'greina': ('greine',),
'greinete': ('greine',),
'greinede': ('greine',),
'greinte': ('greine',),
'greina': ('greine',),
'greinete': ('greine',),
'greinede': ('greine',),
'greinte': ('greine',),
'greinende': ('greine',),
'greinet': ('greinet',),
'greinete': ('greinet',),
'greinet': ('greinet',),
'greinete': ('greinete',),
'grell': ('grell',),
'grelle': ('grell',),
'grelt': ('grell',),
'grellere': ('grell',),
'grellest': ('grell',),
'grelleste': ('grell',),
'gremma': ('gremme',),
'gremmet': ('gremme',),
'gremt': ('gremme',),
'gremma': ('gremme',),
'gremmet': ('gremme',),
'gremt': ('gremme',),
'gremma': ('gremme',),
'gremmete': ('gremme',),
'gremmede': ('gremme',),
'gremte': ('gremme',),
'gremma': ('gremme',),
'gremmete': ('gremme',),
'gremmede': ('gremme',),
'gremte': ('gremme',),
'gremmende': ('gremme',),
'grenadisk': ('grenadisk',),
'grenadiske': ('grenadisk',),
'grenadisk': ('grenadisk',),
'grena': ('grene',),
'grenet': ('grene',),
'grent': ('grene',),
'grena': ('grene',),
'grenet': ('grene',),
'grent': ('grene',),
'grena': ('grene',),
'grenete': ('grene',),
'grenede': ('grene',),
'grente': ('grene',),
'grena': ('grene',),
'grenete': ('grene',),
'grenede': ('grene',),
'grente': ('grene',),
'grenende': ('grene',),
'grenet': ('grenet',),
'grenete': ('grenet',),
'grenet': ('grenet',),
'grenete': ('grenete',),
'grensa': ('grense',),
'grenset': ('grense',),
'grensa': ('grense',),
'grenset': ('grense',),
'grensa': ('grense',),
'grensete': ('grense',),
'grensede': ('grense',),
'grensa': ('grense',),
'grensete': ('grense',),
'grensede': ('grense',),
'grensende': ('grense',),
'grenselaus': ('grenselaus',),
'grenselause': ('grenselaus',),
'grenselaust': ('grenselaus',),
'grenseløs': ('grenseløs',),
'grenseløse': ('grenseløs',),
'grenseløst': ('grenseløs',),
'grepa': ('grepa',),
'grepen': ('grepen',),
'grepne': ('grepen',),
'grepet': ('grepen',),
'grepet': ('grepet',),
'grepne': ('grepet',),
'grepet': ('grepet',),
'gresk': ('gresk',),
'greske': ('gresk',),
'gresk': ('gresk',),
'gresk-katolsk': ('gresk-katolsk',),
'gresk-katolske': ('gresk-katolsk',),
'gresk-katolsk': ('gresk-katolsk',),
'gresk-ortodoks': ('gresk-ortodoks',),
'gresk-ortodokse': ('gresk-ortodoks',),
'gresk-ortodokst': ('gresk-ortodoks',),
'gresk-romersk': ('gresk-romersk',),
'gresk-romerske': ('gresk-romersk',),
'gresk-romersk': ('gresk-romersk',),
'gressa': ('gresse',),
'gresset': ('gresse',),
'gressa': ('gresse',),
'gresset': ('gresse',),
'gressa': ('gresse',),
'gressete': ('gresse',),
'gressede': ('gresse',),
'gressa': ('gresse',),
'gressete': ('gresse',),
'gressede': ('gresse',),
'gressende': ('gresse',),
'gresselig': ('gresselig',),
'gresselige': ('gresselig',),
'gresselig': ('gresselig',),
'gressgrodd': ('gressgrodd',),
'gressgrodde': ('gressgrodd',),
'gressgrodd': ('gressgrodd',),
'gresskledd': ('gresskledd',),
'gresskledde': ('gresskledd',),
'gresskledd': ('gresskledd',),
'gretten': ('gretten',),
'gretne': ('gretten',),
'grettent': ('gretten',),
'grevelig': ('grevelig',),
'grevelige': ('grevelig',),
'grevelig': ('grevelig',),
'griljert': ('griljere',),
'griljerte': ('griljere',),
'griljerende': ('griljere',),
'grilla': ('grille',),
'grillet': ('grille',),
'grilla': ('grille',),
'grillet': ('grille',),
'grilla': ('grille',),
'grillete': ('grille',),
'grillede': ('grille',),
'grilla': ('grille',),
'grillete': ('grille',),
'grillede': ('grille',),
'grillende': ('grille',),
'grillsteikt': ('grillsteikt',),
'grillsteikte': ('grillsteikt',),
'grillsteikt': ('grillsteikt',),
'grillstekt': ('grillstekt',),
'grillstekte': ('grillstekt',),
'grillstekt': ('grillstekt',),
'grim': ('grim',),
'grimme': ('grim',),
'grimt': ('grim',),
'grimmere': ('grim',),
'grimmest': ('grim',),
'grimmeste': ('grim',),
'grima': ('grime',),
'grimet': ('grime',),
'grima': ('grime',),
'grimet': ('grime',),
'grima': ('grime',),
'grimete': ('grime',),
'grimede': ('grime',),
'grima': ('grime',),
'grimete': ('grime',),
'grimede': ('grime',),
'grimende': ('grime',),
'grimet': ('grimet',),
'grimete': ('grimet',),
'grimet': ('grimet',),
'grimete': ('grimete',),
'grinaktig': ('grinaktig',),
'grinaktige': ('grinaktig',),
'grinaktig': ('grinaktig',),
'grint': ('grine',),
'grinte': ('grine',),
'grinende': ('grine',),
'grinet': ('grinet',),
'grinete': ('grinet',),
'grinet': ('grinet',),
'grinete': ('grinete',),
'grepet': ('gripe',),
'grepen': ('gripe',),
'grepne': ('gripe',),
'gripende': ('gripe',),
'gripende': ('gripende',),
'grisa': ('grise',),
'griset': ('grise',),
'grist': ('grise',),
'grisa': ('grise',),
'griset': ('grise',),
'grist': ('grise',),
'grisa': ('grise',),
'grisete': ('grise',),
'grisede': ('grise',),
'griste': ('grise',),
'grisa': ('grise',),
'grisete': ('grise',),
'grisede': ('grise',),
'griste': ('grise',),
'grisende': ('grise',),
'griset': ('griset',),
'grisete': ('griset',),
'griset': ('griset',),
'grisete': ('grisete',),
'grisgrendt': ('grisgrendt',),
'grisgrendte': ('grisgrendt',),
'grisgrendt': ('grisgrendt',),
'grisk': ('grisk',),
'griske': ('grisk',),
'griskt': ('grisk',),
'griskere': ('grisk',),
'griskest': ('grisk',),
'griskeste': ('grisk',),
'grisla': ('grisle',),
'grislet': ('grisle',),
'grisla': ('grisle',),
'grislet': ('grisle',),
'grisla': ('grisle',),
'grislete': ('grisle',),
'grislede': ('grisle',),
'grislete': ('grisle',),
'grislede': ('grisle',),
'grisla': ('grisle',),
'grislete': ('grisle',),
'grislede': ('grisle',),
'grislete': ('grisle',),
'grislede': ('grisle',),
'grislende': ('grisle',),
'grisna': ('grisne',),
'grisnet': ('grisne',),
'grisna': ('grisne',),
'grisnet': ('grisne',),
'grisna': ('grisne',),
'grisnete': ('grisne',),
'grisnede': ('grisne',),
'grisna': ('grisne',),
'grisnete': ('grisne',),
'grisnede': ('grisne',),
'grisnende': ('grisne',),
'grissen': ('grissen',),
'grisne': ('grissen',),
'grissent': ('grissen',),
'grissgrendt': ('grissgrendt',),
'grissgrendte': ('grissgrendt',),
'grissgrendt': ('grissgrendt',),
'grisøyd': ('grisøyd',),
'grisøyde': ('grisøyd',),
'grisøyd': ('grisøyd',),
'grodd': ('gro',),
'grodde': ('gro',),
'groende': ('gro',),
'groggy': ('groggy',),
'grom': ('grom',),
'gromme': ('grom',),
'gromt': ('grom',),
'grommere': ('grom',),
'grommest': ('grom',),
'grommeste': ('grom',),
'gropa': ('grope',),
'gropet': ('grope',),
'gropa': ('grope',),
'gropet': ('grope',),
'gropa': ('grope',),
'gropete': ('grope',),
'gropede': ('grope',),
'gropa': ('grope',),
'gropete': ('grope',),
'gropede': ('grope',),
'gropende': ('grope',),
'grotesk': ('grotesk',),
'groteske': ('grotesk',),
'grotesk': ('grotesk',),
'grov': ('grov',),
'grove': ('grov',),
'grovt': ('grov',),
'grovere': ('grov',),
'grovest': ('grov',),
'grøvst': ('grov',),
'groveste': ('grov',),
'grøvste': ('grov',),
'grovbarka': ('grovbarka',),
'grovbarket': ('grovbarket',),
'grovbarkete': ('grovbarket',),
'grovbarkede': ('grovbarket',),
'grovbarkete': ('grovbarket',),
'grovbarkede': ('grovbarket',),
'grovbarket': ('grovbarket',),
'grovbygd': ('grovbygd',),
'grovbygde': ('grovbygd',),
'grovbygd': ('grovbygd',),
'grovdimensjonert': ('grovdimensjonert',),
'grovdimensjonerte': ('grovdimensjonert',),
'grovdimensjonert': ('grovdimensjonert',),
'grovhakka': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakkete': ('grovhakke',),
'grovhakkede': ('grovhakke',),
'grovhakka': ('grovhakke',),
'grovhakkete': ('grovhakke',),
'grovhakkede': ('grovhakke',),
'grovhakkende': ('grovhakke',),
'grovkorna': ('grovkorna',),
'grovkornet': ('grovkornet',),
'grovkornete': ('grovkornet',),
'grovkornede': ('grovkornet',),
'grovkornete': ('grovkornet',),
'grovkornede': ('grovkornet',),
'grovkornet': ('grovkornet',),
'grovmalt': ('grovmale',),
'grovmalte': ('grovmale',),
'grovmalende': ('grovmale',),
'grovmælt': ('grovmælt',),
'grovmælte': ('grovmælt',),
'grovmælt': ('grovmælt',),
'grovsikta': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsiktete': ('grovsikte',),
'grovsiktede': ('grovsikte',),
'grovsikta': ('grovsikte',),
'grovsiktete': ('grovsikte',),
'grovsiktede': ('grovsikte',),
'grovsiktende': ('grovsikte',),
'grovskåret': ('grovskåret',),
'grovskårne': ('grovskåret',),
'grovskåret': ('grovskåret',),
'grovsortert': ('grovsortere',),
'grovsorterte': ('grovsortere',),
'grovsorterende': ('grovsortere',),
'grovtellet': ('grovtelle',),
'grovtelt': ('grovtelle',),
'grovtalt': ('grovtelle',),
'grovtellet': ('grovtelle',),
'grovtelt': ('grovtelle',),
'grovtalt': ('grovtelle',),
'grovtellete': ('grovtelle',),
'grovtellede': ('grovtelle',),
'grovtelte': ('grovtelle',),
'grovtalte': ('grovtelle',),
'grovtellete': ('grovtelle',),
'grovtellede': ('grovtelle',),
'grovtelte': ('grovtelle',),
'grovtalte': ('grovtelle',),
'grovtellende': ('grovtelle',),
'grubla': ('gruble',),
'grublet': ('gruble',),
'grubla': ('gruble',),
'grublet': ('gruble',),
'grubla': ('gruble',),
'grublete': ('gruble',),
'grublede': ('gruble',),
'grublete': ('gruble',),
'grublede': ('gruble',),
'grubla': ('gruble',),
'grublete': ('gruble',),
'grublede': ('gruble',),
'grublete': ('gruble',),
'grublede': ('gruble',),
'grublende': ('gruble',),
'grua': ('grue',),
'gruet': ('grue',),
'grudd': ('grue',),
'grua': ('grue',),
'gruet': ('grue',),
'grudd': ('grue',),
'grua': ('grue',),
'gruete': ('grue',),
'gruede': ('grue',),
'grudde': ('grue',),
'grua': ('grue',),
'gruete': ('grue',),
'gruede': ('grue',),
'grudde': ('grue',),
'gruende': ('grue',),
'gruelig': ('gruelig',),
'gruelige': ('gruelig',),
'gruelig': ('gruelig',),
'grufull': ('grufull',),
'grufulle': ('grufull',),
'grufullt': ('grufull',),
'gruggen': ('gruggen',),
'grugne': ('gruggen',),
'gruggent': ('gruggen',),
'grugget': ('grugget',),
'gruggete': ('grugget',),
'grugget': ('grugget',),
'gruggete': ('gruggete',),
'grum': ('grum',),
'grumme': ('grum',),
'grumt': ('grum',),
'grummere': ('grum',),
'grummest': ('grum',),
'grummeste': ('grum',),
'grumsa': ('grumse',),
'grumset': ('grumse',),
'grumsa': ('grumse',),
'grumset': ('grumse',),
'grumsa': ('grumse',),
'grumsete': ('grumse',),
'grumsede': ('grumse',),
'grumsa': ('grumse',),
'grumsete': ('grumse',),
'grumsede': ('grumse',),
'grumsende': ('grumse',),
'grumset': ('grumset',),
'grumsete': ('grumset',),
'grumset': ('grumset',),
'grumsete': ('grumsete',),
'grundert': ('grundere',),
'grunderte': ('grundere',),
'grunderende': ('grundere',),
'grundig': ('grundig',),
'grundige': ('grundig',),
'grundig': ('grundig',),
'grundigere': ('grundig',),
'grundigst': ('grundig',),
'grundigste': ('grundig',),
'grundtvigiansk': ('grundtvigiansk',),
'grundtvigianske': ('grundtvigiansk',),
'grundtvigiansk': ('grundtvigiansk',),
'grunn': ('grunn',),
'grunne': ('grunn',),
'grunt': ('grunn',),
'grunnere': ('grunn',),
'grunnest': ('grunn',),
'grunneste': ('grunn',),
'grunna': ('grunne',),
'grunnet': ('grunne',),
'grunna': ('grunne',),
'grunnet': ('grunne',),
'grunna': ('grunne',),
'grunnete': ('grunne',),
'grunnede': ('grunne',),
'grunna': ('grunne',),
'grunnete': ('grunne',),
'grunnede': ('grunne',),
'grunnende': ('grunne',),
'grunnfalsk': ('grunnfalsk',),
'grunnfalske': ('grunnfalsk',),
'grunnfalskt': ('grunnfalsk',),
'grunnfast': ('grunnfast',),
'grunnfaste': ('grunnfast',),
'grunnfast': ('grunnfast',),
'grunnfesta': ('grunnfesta',),
'grunnfesta': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfestete': ('grunnfeste',),
'grunnfestede': ('grunnfeste',),
'grunnfesta': ('grunnfeste',),
'grunnfestete': ('grunnfeste',),
'grunnfestede': ('grunnfeste',),
'grunnfestende': ('grunnfeste',),
'grunnfestet': ('grunnfestet',),
'grunnfestete': ('grunnfestet',),
'grunnfestede': ('grunnfestet',),
'grunnfestete': ('grunnfestet',),
'grunnfestede': ('grunnfestet',),
'grunnfestet': ('grunnfestet',),
'grunngitt': ('grunngi',),
'grunngitte': ('grunngi',),
'grunngiende': ('grunngi',),
'grunnlaus': ('grunnlaus',),
'grunnlause': ('grunnlaus',),
'grunnlaust': ('grunnlaus',),
'grunnlagt': ('grunnlegge',),
'grunnlagte': ('grunnlegge',),
'grunnleggende': ('grunnlegge',),
'grunnleggende': ('grunnleggende',),
'grunnlovfesta': ('grunnlovfesta',),
'grunnlovfestet': ('grunnlovfestet',),
'grunnlovfestete': ('grunnlovfestet',),
'grunnlovfestede': ('grunnlovfestet',),
'grunnlovfestete': ('grunnlovfestet',),
'grunnlovfestede': ('grunnlovfestet',),
'grunnlovfestet': ('grunnlovfestet',),
'grunnlovgivende': ('grunnlovgivende',),
'grunnlovlig': ('grunnlovlig',),
'grunnlovlige': ('grunnlovlig',),
'grunnlovlig': ('grunnlovlig',),
'grunnlovsstridig': ('grunnlovsstridig',),
'grunnlovsstridige': ('grunnlovsstridig',),
'grunnlovsstridig': ('grunnlovsstridig',),
'grunnløs': ('grunnløs',),
'grunnløse': ('grunnløs',),
'grunnløst': ('grunnløs',),
'grunnrik': ('grunnrik',),
'grunnrike': ('grunnrik',),
'grunnrikt': ('grunnrik',),
'grunnsatt': ('grunnsette',),
'grunnsatte': ('grunnsette',),
'grunnsettende': ('grunnsette',),
'grunnsolid': ('grunnsolid',),
'grunnsolide': ('grunnsolid',),
'grunnsolid': ('grunnsolid',),
'grunnstøtt': ('grunnstøte',),
'grunnstøtte': ('grunnstøte',),
'grunnstøtende': ('grunnstøte',),
'gruntgående': ('gruntgående',),
'gruppert': ('gruppere',),
'grupperte': ('gruppere',),
'grupperende': ('gruppere',),
'grusa': ('gruse',),
'gruset': ('gruse',),
'grusa': ('gruse',),
'gruset': ('gruse',),
'grusa': ('gruse',),
'grusete': ('gruse',),
'grusede': ('gruse',),
'grusa': ('gruse',),
'grusete': ('gruse',),
'grusede': ('gruse',),
'grusende': ('gruse',),
'gruselig': ('gruselig',),
'gruselige': ('gruselig',),
'gruselig': ('gruselig',),
'gruset': ('gruset',),
'grusete': ('gruset',),
'gruset': ('gruset',),
'grusete': ('grusete',),
'grusisk': ('grusisk',),
'grusiske': ('grusisk',),
'grusisk': ('grusisk',),
'gruslagt': ('gruslegge',),
'gruslagte': ('gruslegge',),
'grusleggende': ('gruslegge',),
'grusom': ('grusom',),
'grusomme': ('grusom',),
'grusomt': ('grusom',),
'grusommere': ('grusom',),
'grusomst': ('grusom',),
'grusomste': ('grusom',),
'grydd': ('gry',),
'grydde': ('gry',),
'gryende': ('gry',),
'grynt': ('gryne',),
'grynte': ('gryne',),
'grynende': ('gryne',),
'grynet': ('grynet',),
'grynete': ('grynet',),
'grynet': ('grynet',),
'grynete': ('grynete',),
'grynta': ('grynte',),
'gryntet': ('grynte',),
'grynta': ('grynte',),
'gryntet': ('grynte',),
'grynta': ('grynte',),
'gryntete': ('grynte',),
'gryntede': ('grynte',),
'grynta': ('grynte',),
'gryntete': ('grynte',),
'gryntede': ('grynte',),
'gryntende': ('grynte',),
'gryteferdig': ('gryteferdig',),
'gryteferdige': ('gryteferdig',),
'gryteferdig': ('gryteferdig',),
'grytidlig': ('grytidlig',),
'grytidlige': ('grytidlig',),
'grytidlig': ('grytidlig',),
'grå': ('grå',),
'gråe': ('grå',),
'grå': ('grå',),
'gråe': ('grå',),
'grå': ('grå',),
'grått': ('grå',),
'gråere': ('grå',),
'gråest': ('grå',),
'gråeste': ('grå',),
'gråaktig': ('gråaktig',),
'gråaktige': ('gråaktig',),
'gråaktig': ('gråaktig',),
'grådig': ('grådig',),
'grådige': ('grådig',),
'grådig': ('grådig',),
'gråhåra': ('gråhåra',),
'gråhåret': ('gråhåret',),
'gråhårete': ('gråhåret',),
'gråhårede': ('gråhåret',),
'gråhårete': ('gråhåret',),
'gråhårede': ('gråhåret',),
'gråhåret': ('gråhåret',),
'gråkald': ('gråkald',),
'gråkalde': ('gråkald',),
'gråkaldt': ('gråkald',),
'grålt': ('gråle',),
'grålte': ('gråle',),
'grålende': ('gråle',),
'grålig': ('grålig',),
'grålige': ('grålig',),
'grålig': ('grålig',),
'gråna': ('gråne',),
'grånet': ('gråne',),
'gråna': ('gråne',),
'grånet': ('gråne',),
'gråna': ('gråne',),
'grånete': ('gråne',),
'grånede': ('gråne',),
'gråna': ('gråne',),
'grånete': ('gråne',),
'grånede': ('gråne',),
'grånende': ('gråne',),
'gråskitten': ('gråskitten',),
'gråskitne': ('gråskitten',),
'gråskittent': ('gråskitten',),
'gråtblanda': ('gråtblanda',),
'gråtblandet': ('gråtblandet',),
'gråtblandete': ('gråtblandet',),
'gråtblandede': ('gråtblandet',),
'gråtblandete': ('gråtblandet',),
'gråtblandede': ('gråtblandet',),
'gråtblandet': ('gråtblandet',),
'grått': ('gråte',),
'gråtte': ('gråte',),
'gråtende': ('gråte',),
'gråteferdig': ('gråteferdig',),
'gråteferdige': ('gråteferdig',),
'gråteferdig': ('gråteferdig',),
'gråtkvalt': ('gråtkvalt',),
'gråtkvalte': ('gråtkvalt',),
'gråtkvalt': ('gråtkvalt',),
'gråøyd': ('gråøyd',),
'gråøyde': ('gråøyd',),
'gråøyd': ('gråøyd',),
'grødd': ('grø',),
'grødde': ('grø',),
'grøende': ('grø',),
'grødefull': ('grødefull',),
'grødefulle': ('grødefull',),
'grødefullt': ('grødefull',),
'grøderik': ('grøderik',),
'grøderike': ('grøderik',),
'grøderikt': ('grøderik',),
'grøfta': ('grøfte',),
'grøftet': ('grøfte',),
'grøfta': ('grøfte',),
'grøftet': ('grøfte',),
'grøfta': ('grøfte',),
'grøftete': ('grøfte',),
'grøftede': ('grøfte',),
'grøfta': ('grøfte',),
'grøftete': ('grøfte',),
'grøftede': ('grøfte',),
'grøftende': ('grøfte',),
'grønka': ('grønke',),
'grønket': ('grønke',),
'grønka': ('grønke',),
'grønket': ('grønke',),
'grønka': ('grønke',),
'grønkete': ('grønke',),
'grønkede': ('grønke',),
'grønka': ('grønke',),
'grønkete': ('grønke',),
'grønkede': ('grønke',),
'grønkende': ('grønke',),
'grønlandsk': ('grønlandsk',),
'grønlandske': ('grønlandsk',),
'grønlandsk': ('grønlandsk',),
'grønn': ('grønn',),
'grønne': ('grønn',),
'grønt': ('grønn',),
'grønnere': ('grønn',),
'grønnest': ('grønn',),
'grønneste': ('grønn',),
'grønnaktig': ('grønnaktig',),
'grønnaktige': ('grønnaktig',),
'grønnaktig': ('grønnaktig',),
'grønnlig': ('grønnlig',),
'grønnlige': ('grønnlig',),
'grønnlig': ('grønnlig',),
'grønska': ('grønske',),
'grønsket': ('grønske',),
'grønska': ('grønske',),
'grønsket': ('grønske',),
'grønska': ('grønske',),
'grønskete': ('grønske',),
'grønskede': ('grønske',),
'grønskete': ('grønske',),
'grønskede': ('grønske',),
'grønska': ('grønske',),
'grønskete': ('grønske',),
'grønskede': ('grønske',),
'grønskete': ('grønske',),
'grønskede': ('grønske',),
'grønskende': ('grønske',),
'grønsket': ('grønsket',),
'grønskete': ('grønsket',),
'grønsket': ('grønsket',),
'grønskete': ('grønskete',),
'grøppet': ('grøppe',),
'grøpt': ('grøppe',),
'grøppet': ('grøppe',),
'grøpt': ('grøppe',),
'grøppete': ('grøppe',),
'grøppede': ('grøppe',),
'grøpte': ('grøppe',),
'grøppete': ('grøppe',),
'grøppede': ('grøppe',),
'grøpte': ('grøppe',),
'grøppende': ('grøppe',),
'grøssa': ('grøsse',),
'grøsset': ('grøsse',),
'grøst': ('grøsse',),
'grøssa': ('grøsse',),
'grøsset': ('grøsse',),
'grøst': ('grøsse',),
'grøssa': ('grøsse',),
'grøssete': ('grøsse',),
'grøssede': ('grøsse',),
'grøste': ('grøsse',),
'grøssa': ('grøsse',),
'grøssete': ('grøsse',),
'grøssede': ('grøsse',),
'grøste': ('grøsse',),
'grøssende': ('grøsse',),
'grøtaktig': ('grøtaktig',),
'grøtaktige': ('grøtaktig',),
'grøtaktig': ('grøtaktig',),
'grøtet': ('grøtet',),
'grøtete': ('grøtet',),
'grøtet': ('grøtet',),
'grøtete': ('grøtete',),
'grøvst': ('grøvst',),
'grøvste': ('grøvst',),
'grøvst': ('grøvst',),
'guatemalansk': ('guatemalansk',),
'guatemalanske': ('guatemalansk',),
'guatemalansk': ('guatemalansk',),
'gudbenåda': ('gudbenåda',),
'gudbenådet': ('gudbenådet',),
'gudbenådete': ('gudbenådet',),
'gudbenådede': ('gudbenådet',),
'gudbenådete': ('gudbenådet',),
'gudbenådede': ('gudbenådet',),
'gudbenådet': ('gudbenådet',),
'gudbrandsdalsk': ('gudbrandsdalsk',),
'gudbrandsdalske': ('gudbrandsdalsk',),
'gudbrandsdalsk': ('gudbrandsdalsk',),
'guddommelig': ('guddommelig',),
'guddommelige': ('guddommelig',),
'guddommelig': ('guddommelig',),
'gudelig': ('gudelig',),
'gudelige': ('gudelig',),
'gudelig': ('gudelig',),
'gudfryktig': ('gudfryktig',),
'gudfryktige': ('gudfryktig',),
'gudfryktig': ('gudfryktig',),
'gudgitt': ('gudgitt',),
'gudgitte': ('gudgitt',),
'gudgitt': ('gudgitt',),
'gudhengiven': ('gudhengiven',),
'gudhengivne': ('gudhengiven',),
'gudhengivent': ('gudhengiven',),
'gudlaus': ('gudlaus',),
'gudlause': ('gudlaus',),
'gudlaust': ('gudlaus',),
'gudløs': ('gudløs',),
'gudløse': ('gudløs',),
'gudløst': ('gudløs',),
'gudnådslig': ('gudnådslig',),
'gudnådslige': ('gudnådslig',),
'gudnådslig': ('gudnådslig',),
'gudsbespottelig': ('gudsbespottelig',),
'gudsbespottelige': ('gudsbespottelig',),
'gudsbespottelig': ('gudsbespottelig',),
'gudsendt': ('gudsendt',),
'gudsendte': ('gudsendt',),
'gudsendt': ('gudsendt',),
'gudsens': ('gudsens',),
'gudsforlatt': ('gudsforlatt',),
'gudsforlatte': ('gudsforlatt',),
'gudsforlatt': ('gudsforlatt',),
'gudsjammerlig': ('gudsjammerlig',),
'gudsjammerlige': ('gudsjammerlig',),
'gudsjammerlig': ('gudsjammerlig',),
'gudskapt': ('gudskapt',),
'gudskapte': ('gudskapt',),
'gudskapt': ('gudskapt',),
'gudstjenstlig': ('gudstjenstlig',),
'gudstjenstlige': ('gudstjenstlig',),
'gudstjenstlig': ('gudstjenstlig',),
'guffen': ('guffen',),
'gufne': ('guffen',),
'guffent': ('guffen',),
'gufsa': ('gufse',),
'gufset': ('gufse',),
'gufsa': ('gufse',),
'gufset': ('gufse',),
'gufsa': ('gufse',),
'gufsete': ('gufse',),
'gufsede': ('gufse',),
'gufsa': ('gufse',),
'gufsete': ('gufse',),
'gufsede': ('gufse',),
'gufsende': ('gufse',),
'guida': ('guide',),
'guidet': ('guide',),
'guida': ('guide',),
'guidet': ('guide',),
'guida': ('guide',),
'guidete': ('guide',),
'guidede': ('guide',),
'guida': ('guide',),
'guidete': ('guide',),
'guidede': ('guide',),
'guidende': ('guide',),
'guineansk': ('guineansk',),
'guineanske': ('guineansk',),
'guineansk': ('guineansk',),
'gul': ('gul',),
'gule': ('gul',),
'gult': ('gul',),
'gulere': ('gul',),
'gulest': ('gul',),
'guleste': ('gul',),
'gulblakk': ('gulblakk',),
'gulblakke': ('gulblakk',),
'gulblakt': ('gulblakk',),
'gula': ('gule',),
'gulet': ('gule',),
'gula': ('gule',),
'gulet': ('gule',),
'gula': ('gule',),
'gulete': ('gule',),
'gulede': ('gule',),
'gula': ('gule',),
'gulete': ('gule',),
'gulede': ('gule',),
'gulende': ('gule',),
'gulka': ('gulke',),
'gulket': ('gulke',),
'gulka': ('gulke',),
'gulket': ('gulke',),
'gulka': ('gulke',),
'gulkete': ('gulke',),
'gulkede': ('gulke',),
'gulka': ('gulke',),
'gulkete': ('gulke',),
'gulkede': ('gulke',),
'gulkende': ('gulke',),
'gullblank': ('gullblank',),
'gullblanke': ('gullblank',),
'gullblankt': ('gullblank',),
'gullkanta': ('gullkanta',),
'gullkantet': ('gullkantet',),
'gullkantete': ('gullkantet',),
'gullkantede': ('gullkantet',),
'gullkantete': ('gullkantet',),
'gullkantede': ('gullkantet',),
'gullkantet': ('gullkantet',),
'gullslått': ('gullslått',),
'gullslåtte': ('gullslått',),
'gullslått': ('gullslått',),
'gulmoden': ('gulmoden',),
'gulmodne': ('gulmoden',),
'gulmodent': ('gulmoden',),
'gulna': ('gulne',),
'gulnet': ('gulne',),
'gulna': ('gulne',),
'gulnet': ('gulne',),
'gulna': ('gulne',),
'gulnete': ('gulne',),
'gulnede': ('gulne',),
'gulnete': ('gulne',),
'gulnede': ('gulne',),
'gulna': ('gulne',),
'gulnete': ('gulne',),
'gulnede': ('gulne',),
'gulnete': ('gulne',),
'gulnede': ('gulne',),
'gulnende': ('gulne',),
'gulpa': ('gulpe',),
'gulpet': ('gulpe',),
'gulpa': ('gulpe',),
'gulpet': ('gulpe',),
'gulpa': ('gulpe',),
'gulpete': ('gulpe',),
'gulpede': ('gulpe',),
'gulpa': ('gulpe',),
'gulpete': ('gulpe',),
'gulpede': ('gulpe',),
'gulpende': ('gulpe',),
'gulrotfarga': ('gulrotfarga',),
'gulrotfarget': ('gulrotfarget',),
'gulrotfargete': ('gulrotfarget',),
'gulrotfargede': ('gulrotfarget',),
'gulrotfargete': ('gulrotfarget',),
'gulrotfargede': ('gulrotfarget',),
'gulrotfarget': ('gulrotfarget',),
'gummiert': ('gummiere',),
'gummierte': ('gummiere',),
'gummierende': ('gummiere',),
'gunstig': ('gunstig',),
'gunstige': ('gunstig',),
'gunstig': ('gunstig',),
'gunstigere': ('gunstig',),
'gunstigst': ('gunstig',),
'gunstigste': ('gunstig',),
'gurgla': ('gurgle',),
'gurglet': ('gurgle',),
'gurgla': ('gurgle',),
'gurglet': ('gurgle',),
'gurgla': ('gurgle',),
'gurglete': ('gurgle',),
'gurglede': ('gurgle',),
'gurglete': ('gurgle',),
'gurglede': ('gurgle',),
'gurgla': ('gurgle',),
'gurglete': ('gurgle',),
'gurglede': ('gurgle',),
'gurglete': ('gurgle',),
'gurglede': ('gurgle',),
'gurglende': ('gurgle',),
'gurpa': ('gurpe',),
'gurpet': ('gurpe',),
'gurpa': ('gurpe',),
'gurpet': ('gurpe',),
'gurpa': ('gurpe',),
'gurpete': ('gurpe',),
'gurpede': ('gurpe',),
'gurpa': ('gurpe',),
'gurpete': ('gurpe',),
'gurpede': ('gurpe',),
'gurpende': ('gurpe',),
'gusta': ('guste',),
'gustet': ('guste',),
'gusta': ('guste',),
'gustet': ('guste',),
'gusta': ('guste',),
'gustete': ('guste',),
'gustede': ('guste',),
'gusta': ('guste',),
'gustete': ('guste',),
'gustede': ('guste',),
'gustende': ('guste',),
'gusten': ('gusten',),
'gustne': ('gusten',),
'gustent': ('gusten',),
'gutert': ('gutere',),
'guterte': ('gutere',),
'guterende': ('gutere',),
'guttaktig': ('guttaktig',),
'guttaktige': ('guttaktig',),
'guttaktig': ('guttaktig',),
'gutteaktig': ('gutteaktig',),
'gutteaktige': ('gutteaktig',),
'gutteaktig': ('gutteaktig',),
'guttegal': ('guttegal',),
'guttegale': ('guttegal',),
'guttegalt': ('guttegal',),
'guttural': ('guttural',),
'gutturale': ('guttural',),
'gutturalt': ('guttural',),
'guyansk': ('guyansk',),
'guyanske': ('guyansk',),
'guyansk': ('guyansk',),
'gyldig': ('gyldig',),
'gyldige': ('gyldig',),
'gyldig': ('gyldig',),
'gyllet': ('gylle',),
'gylt': ('gylle',),
'gyllet': ('gylle',),
'gylt': ('gylle',),
'gyllete': ('gylle',),
'gyllede': ('gylle',),
'gylte': ('gylle',),
'gyllete': ('gylle',),
'gyllede': ('gylle',),
'gylte': ('gylle',),
'gyllende': ('gylle',),
'gyllen': ('gyllen',),
'gylne': ('gyllen',),
'gyllent': ('gyllen',),
'gylnere': ('gyllen',),
'gylnest': ('gyllen',),
'gylneste': ('gyllen',),
'gyllenblank': ('gyllenblank',),
'gyllenblanke': ('gyllenblank',),
'gyllenblankt': ('gyllenblank',),
'gyllenbrun': ('gyllenbrun',),
'gyllenbrune': ('gyllenbrun',),
'gyllenbrunt': ('gyllenbrun',),
'gymnasial': ('gymnasial',),
'gymnasiale': ('gymnasial',),
'gymnasialt': ('gymnasial',),
'gymnastisert': ('gymnastisere',),
'gymnastiserte': ('gymnastisere',),
'gymnastiserende': ('gymnastisere',),
'gymnastisk': ('gymnastisk',),
'gymnastiske': ('gymnastisk',),
'gymnastisk': ('gymnastisk',),
'gynekologisk': ('gynekologisk',),
'gynekologiske': ('gynekologisk',),
'gynekologisk': ('gynekologisk',),
'gynga': ('gynge',),
'gynget': ('gynge',),
'gynga': ('gynge',),
'gynget': ('gynge',),
'gynga': ('gynge',),
'gyngete': ('gynge',),
'gyngede': ('gynge',),
'gynga': ('gynge',),
'gyngete': ('gynge',),
'gyngede': ('gynge',),
'gyngende': ('gynge',),
'gyst': ('gyse',),
'gyste': ('gyse',),
'gyst': ('gyse',),
'gyste': ('gyse',),
'gyst': ('gyse',),
'gysende': ('gyse',),
'gyselig': ('gyselig',),
'gyselige': ('gyselig',),
'gyselig': ('gyselig',),
'gyseligere': ('gyselig',),
'gyseligst': ('gyselig',),
'gyseligste': ('gyselig',),
'gytt': ('gyte',),
'gytte': ('gyte',),
'gytende': ('gyte',),
'gyteferdig': ('gyteferdig',),
'gyteferdige': ('gyteferdig',),
'gyteferdig': ('gyteferdig',),
'gjøvet': ('gyve',),
'gyvd': ('gyve',),
'gjøvet': ('gyve',),
'gyvd': ('gyve',),
'gjøvet': ('gyve',),
'gyvd': ('gyve',),
'gjøven': ('gyve',),
'gjøvet': ('gyve',),
'gjøven': ('gyve',),
'gyvd': ('gyve',),
'gjøvne': ('gyve',),
'gyvde': ('gyve',),
'gjøvne': ('gyve',),
'gyvd': ('gyve',),
'gjøvne': ('gyve',),
'gyvde': ('gyve',),
'gjøvne': ('gyve',),
'gyvd': ('gyve',),
'gyvende': ('gyve',),
'gått': ('gå',),
'gåtte': ('gå',),
'gående': ('gå',),
'gåen': ('gåen',),
'gåene': ('gåen',),
'gåent': ('gåen',),
'gående': ('gående',),
'gåra': ('gåre',),
'gåret': ('gåre',),
'gåra': ('gåre',),
'gåret': ('gåre',),
'gåra': ('gåre',),
'gårete': ('gåre',),
'gårede': ('gåre',),
'gåra': ('gåre',),
'gårete': ('gåre',),
'gårede': ('gåre',),
'gårende': ('gåre',),
'gåtefull': ('gåtefull',),
'gåtefulle': ('gåtefull',),
'gåtefullt': ('gåtefull',),
'gælisk': ('gælisk',),
'gæliske': ('gælisk',),
'gælisk': ('gælisk',),
'gørr': ('gørr',),
'gørre': ('gørr',),
'gørr': ('gørr',),
'gørrkjedelig': ('gørrkjedelig',),
'gørrkjedelige': ('gørrkjedelig',),
'gørrkjedelig': ('gørrkjedelig',),
'gørrlei': ('gørrlei',),
'gørrleie': ('gørrlei',),
'gørrleit': ('gørrlei',),
'gøy': ('gøy',),
'gøye': ('gøy',),
'gøy': ('gøy',),
'gøyere': ('gøy',),
'gøyest': ('gøy',),
'gøyeste': ('gøy',),
'gøyal': ('gøyal',),
'gøyale': ('gøyal',),
'gøyalt': ('gøyal',),
'gøyst': ('gøyse',),
'gøyste': ('gøyse',),
'gøysende': ('gøyse',),
'haende': ('ha',),
'ha-stemt': ('ha-stemt',),
'ha-stemte': ('ha-stemt',),
'ha-stemt': ('ha-stemt',),
'habil': ('habil',),
'habile': ('habil',),
'habilt': ('habil',),
'habilitert': ('habilitere',),
'habiliterte': ('habilitere',),
'habiliterende': ('habilitere',),
'habituell': ('habituell',),
'habituelle': ('habituell',),
'habituelt': ('habituell',),
'habsburgisk': ('habsburgisk',),
'habsburgiske': ('habsburgisk',),
'habsburgisk': ('habsburgisk',),
'habsburgsk': ('habsburgsk',),
'habsburgske': ('habsburgsk',),
'habsburgsk': ('habsburgsk',),
'hag': ('hag',),
'hage': ('hag',),
'hagt': ('hag',),
'haglblanda': ('haglblanda',),
'haglblandet': ('haglblandet',),
'haglblandete': ('haglblandet',),
'haglblandede': ('haglblandet',),
'haglblandete': ('haglblandet',),
'haglblandede': ('haglblandet',),
'haglblandet': ('haglblandet',),
'hagla': ('hagle',),
'haglet': ('hagle',),
'hagla': ('hagle',),
'haglet': ('hagle',),
'hagla': ('hagle',),
'haglete': ('hagle',),
'haglede': ('hagle',),
'haglete': ('hagle',),
'haglede': ('hagle',),
'hagla': ('hagle',),
'haglete': ('hagle',),
'haglede': ('hagle',),
'haglete': ('hagle',),
'haglede': ('hagle',),
'haglende': ('hagle',),
'haika': ('haike',),
'haiket': ('haike',),
'haika': ('haike',),
'haiket': ('haike',),
'haika': ('haike',),
'haikete': ('haike',),
'haikede': ('haike',),
'haika': ('haike',),
'haikete': ('haike',),
'haikede': ('haike',),
'haikende': ('haike',),
'haitiansk': ('haitiansk',),
'haitianske': ('haitiansk',),
'haitiansk': ('haitiansk',),
'haitisk': ('haitisk',),
'haitiske': ('haitisk',),
'haitisk': ('haitisk',),
'haka': ('hake',),
'haket': ('hake',),
'hakt': ('hake',),
'haka': ('hake',),
'haket': ('hake',),
'hakt': ('hake',),
'haka': ('hake',),
'hakete': ('hake',),
'hakede': ('hake',),
'hakte': ('hake',),
'haka': ('hake',),
'hakete': ('hake',),
'hakede': ('hake',),
'hakte': ('hake',),
'hakende': ('hake',),
'hakka': ('hakke',),
'hakket': ('hakke',),
'hakka': ('hakke',),
'hakket': ('hakke',),
'hakka': ('hakke',),
'hakkete': ('hakke',),
'hakkede': ('hakke',),
'hakka': ('hakke',),
'hakkete': ('hakke',),
'hakkede': ('hakke',),
'hakkende': ('hakke',),
'hakket': ('hakket',),
'hakkete': ('hakket',),
'hakket': ('hakket',),
'hakkete': ('hakkete',),
'hala': ('hale',),
'halet': ('hale',),
'halt': ('hale',),
'hala': ('hale',),
'halet': ('hale',),
'halt': ('hale',),
'hala': ('hale',),
'halete': ('hale',),
'halede': ('hale',),
'halte': ('hale',),
'hala': ('hale',),
'halete': ('hale',),
'halede': ('hale',),
'halte': ('hale',),
'halende': ('hale',),
'halelaus': ('halelaus',),
'halelause': ('halelaus',),
'halelaust': ('halelaus',),
'haleløs': ('haleløs',),
'haleløse': ('haleløs',),
'haleløst': ('haleløs',),
'hall': ('hall',),
'halle': ('hall',),
'halt': ('hall',),
'halla': ('halle',),
'hallet': ('halle',),
'halla': ('halle',),
'hallet': ('halle',),
'halla': ('halle',),
'hallete': ('halle',),
'hallede': ('halle',),
'halla': ('halle',),
'hallete': ('halle',),
'hallede': ('halle',),
'hallende': ('halle',),
'hallusinatorisk': ('hallusinatorisk',),
'hallusinatoriske': ('hallusinatorisk',),
'hallusinatorisk': ('hallusinatorisk',),
'hallusinert': ('hallusinere',),
'hallusinerte': ('hallusinere',),
'hallusinerende': ('hallusinere',),
'hallusinogen': ('hallusinogen',),
'hallusinogene': ('hallusinogen',),
'hallusinogent': ('hallusinogen',),
'halofil': ('halofil',),
'halofile': ('halofil',),
'halofilt': ('halofil',),
'halsbrekkende': ('halsbrekkende',),
'halsa': ('halse',),
'halset': ('halse',),
'halsa': ('halse',),
'halset': ('halse',),
'halsa': ('halse',),
'halsete': ('halse',),
'halsede': ('halse',),
'halsa': ('halse',),
'halsete': ('halse',),
'halsede': ('halse',),
'halsende': ('halse',),
'halslaus': ('halslaus',),
'halslause': ('halslaus',),
'halslaust': ('halslaus',),
'halsløs': ('halsløs',),
'halsløse': ('halsløs',),
'halsløst': ('halsløs',),
'halsstarrig': ('halsstarrig',),
'halsstarrige': ('halsstarrig',),
'halsstarrig': ('halsstarrig',),
'halt': ('halt',),
'halte': ('halt',),
'halt': ('halt',),
'halta': ('halte',),
'haltet': ('halte',),
'halta': ('halte',),
'haltet': ('halte',),
'halta': ('halte',),
'haltete': ('halte',),
'haltede': ('halte',),
'halta': ('halte',),
'haltete': ('halte',),
'haltede': ('halte',),
'haltende': ('halte',),
'halv': ('halv',),
'halve': ('halv',),
'halvt': ('halv',),
'halvautomatisk': ('halvautomatisk',),
'halvautomatiske': ('halvautomatisk',),
'halvautomatisk': ('halvautomatisk',),
'halvblind': ('halvblind',),
'halvblinde': ('halvblind',),
'halvblindt': ('halvblind',),
'halvblods': ('halvblods',),
'halvdaud': ('halvdaud',),
'halvdaude': ('halvdaud',),
'halvdaudt': ('halvdaud',),
'halvdokumentarisk': ('halvdokumentarisk',),
'halvdokumentariske': ('halvdokumentarisk',),
'halvdokumentarisk': ('halvdokumentarisk',),
'halvdød': ('halvdød',),
'halvdøde': ('halvdød',),
'halvdødt': ('halvdød',),
'halva': ('halve',),
'halvet': ('halve',),
'halva': ('halve',),
'halvet': ('halve',),
'halva': ('halve',),
'halvete': ('halve',),
'halvede': ('halve',),
'halva': ('halve',),
'halvete': ('halve',),
'halvede': ('halve',),
'halvende': ('halve',),
'halvert': ('halvere',),
'halverte': ('halvere',),
'halverende': ('halvere',),
'halvferdig': ('halvferdig',),
'halvferdige': ('halvferdig',),
'halvferdig': ('halvferdig',),
'halvfet': ('halvfet',),
'halvfete': ('halvfet',),
'halvfett': ('halvfet',),
'halvfordøya': ('halvfordøya',),
'halvfordøyd': ('halvfordøyd',),
'halvfordøyde': ('halvfordøyd',),
'halvfordøyd': ('halvfordøyd',),
'halvfordøyet': ('halvfordøyet',),
'halvfordøyete': ('halvfordøyet',),
'halvfordøyede': ('halvfordøyet',),
'halvfordøyete': ('halvfordøyet',),
'halvfordøyede': ('halvfordøyet',),
'halvfordøyet': ('halvfordøyet',),
'halvfull': ('halvfull',),
'halvfulle': ('halvfull',),
'halvfullt': ('halvfull',),
'halvgal': ('halvgal',),
'halvgale': ('halvgal',),
'halvgalt': ('halvgal',),
'halvgammel': ('halvgammel',),
'halvgamle': ('halvgammel',),
'halvgammelt': ('halvgammel',),
'halvgardert': ('halvgardere',),
'halvgarderte': ('halvgardere',),
'halvgarderende': ('halvgardere',),
'halvgjort': ('halvgjort',),
'halvgjorte': ('halvgjort',),
'halvgjort': ('halvgjort',),
'halvgod': ('halvgod',),
'halvgode': ('halvgod',),
'halvgodt': ('halvgod',),
'halvgått': ('halvgått',),
'halvgåtte': ('halvgått',),
'halvgått': ('halvgått',),
'halvhjerta': ('halvhjerta',),
'halvhjertet': ('halvhjertet',),
'halvhjertete': ('halvhjertet',),
'halvhjertede': ('halvhjertet',),
'halvhjertete': ('halvhjertet',),
'halvhjertede': ('halvhjertet',),
'halvhjertet': ('halvhjertet',),
'halvhøg': ('halvhøg',),
'halvhøge': ('halvhøg',),
'halvhøgt': ('halvhøg',),
'halvhøy': ('halvhøy',),
'halvhøye': ('halvhøy',),
'halvhøyt': ('halvhøy',),
'halvklart': ('halvklare',),
'halvklarte': ('halvklare',),
'halvklarende': ('halvklare',),
'halvkvedet': ('halvkvedet',),
'halvkvedete': ('halvkvedet',),
'halvkvedede': ('halvkvedet',),
'halvkvedete': ('halvkvedet',),
'halvkvedede': ('halvkvedet',),
'halvkvedet': ('halvkvedet',),
'halvmett': ('halvmett',),
'halvmette': ('halvmett',),
'halvmett': ('halvmett',),
'halvmoden': ('halvmoden',),
'halvmodne': ('halvmoden',),
'halvmodent': ('halvmoden',),
'halvnaken': ('halvnaken',),
'halvnakne': ('halvnaken',),
'halvnakent': ('halvnaken',),
'halvsovet': ('halvsove',),
'halvsoven': ('halvsove',),
'halvsovne': ('halvsove',),
'halvsovende': ('halvsove',),
'halvstudert': ('halvstudert',),
'halvstuderte': ('halvstudert',),
'halvstudert': ('halvstudert',),
'halvsåla': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålt': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålt': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsålete': ('halvsåle',),
'halvsålede': ('halvsåle',),
'halvsålte': ('halvsåle',),
'halvsåla': ('halvsåle',),
'halvsålete': ('halvsåle',),
'halvsålede': ('halvsåle',),
'halvsålte': ('halvsåle',),
'halvsålende': ('halvsåle',),
'halvtoms': ('halvtoms',),
'halvtredje': ('halvtredje',),
'halvtullet': ('halvtullet',),
'halvtullete': ('halvtullet',),
'halvtullet': ('halvtullet',),
'halvtullete': ('halvtullete',),
'halvtårs': ('halvtårs',),
'halvtørr': ('halvtørr',),
'halvtørre': ('halvtørr',),
'halvtørt': ('halvtørr',),
'halvvoksen': ('halvvoksen',),
'halvvoksne': ('halvvoksen',),
'halvvoksent': ('halvvoksen',),
'halvårig': ('halvårig',),
'halvårige': ('halvårig',),
'halvårig': ('halvårig',),
'halvårlig': ('halvårlig',),
'halvårlige': ('halvårlig',),
'halvårlig': ('halvårlig',),
'hamburgsk': ('hamburgsk',),
'hamburgske': ('hamburgsk',),
'hamburgsk': ('hamburgsk',),
'hamittisk': ('hamittisk',),
'hamittiske': ('hamittisk',),
'hamittisk': ('hamittisk',),
'hamla': ('hamle',),
'hamlet': ('hamle',),
'hamla': ('hamle',),
'hamlet': ('hamle',),
'hamla': ('hamle',),
'hamlete': ('hamle',),
'hamlede': ('hamle',),
'hamlete': ('hamle',),
'hamlede': ('hamle',),
'hamla': ('hamle',),
'hamlete': ('hamle',),
'hamlede': ('hamle',),
'hamlete': ('hamle',),
'hamlede': ('hamle',),
'hamlende': ('hamle',),
'hamna': ('hamne',),
'hamnet': ('hamne',),
'hamna': ('hamne',),
'hamnet': ('hamne',),
'hamna': ('hamne',),
'hamnete': ('hamne',),
'hamnede': ('hamne',),
'hamnete': ('hamne',),
'hamnede': ('hamne',),
'hamna': ('hamne',),
'hamnete': ('hamne',),
'hamnede': ('hamne',),
'hamnete': ('hamne',),
'hamnede': ('hamne',),
'hamnende': ('hamne',),
'hamra': ('hamre',),
'hamret': ('hamre',),
'hamra': ('hamre',),
'hamret': ('hamre',),
'hamra': ('hamre',),
'hamrete': ('hamre',),
'hamrede': ('hamre',),
'hamrete': ('hamre',),
'hamrede': ('hamre',),
'hamra': ('hamre',),
'hamrete': ('hamre',),
'hamrede': ('hamre',),
'hamrete': ('hamre',),
'hamrede': ('hamre',),
'hamrende': ('hamre',),
'hamsa': ('hamse',),
'hamset': ('hamse',),
'hamsa': ('hamse',),
'hamset': ('hamse',),
'hamsa': ('hamse',),
'hamsete': ('hamse',),
'hamsede': ('hamse',),
'hamsa': ('hamse',),
'hamsete': ('hamse',),
'hamsede': ('hamse',),
'hamsende': ('hamse',),
'hamstra': ('hamstre',),
'hamstret': ('hamstre',),
'hamstra': ('hamstre',),
'hamstret': ('hamstre',),
'hamstra': ('hamstre',),
'hamstrete': ('hamstre',),
'hamstrede': ('hamstre',),
'hamstrete': ('hamstre',),
'hamstrede': ('hamstre',),
'hamstra': ('hamstre',),
'hamstrete': ('hamstre',),
'hamstrede': ('hamstre',),
'hamstrete': ('hamstre',),
'hamstrede': ('hamstre',),
'hamstrende': ('hamstre',),
'handdrevet': ('handdrevet',),
'handdrevne': ('handdrevet',),
'handdrevet': ('handdrevet',),
'handelspolitisk': ('handelspolitisk',),
'handelspolitiske': ('handelspolitisk',),
'handelspolitisk': ('handelspolitisk',),
'handfallen': ('handfallen',),
'handfalne': ('handfallen',),
'handfallent': ('handfallen',),
'handfart': ('handfare',),
'handfarte': ('handfare',),
'handfarende': ('handfare',),
'handfast': ('handfast',),
'handfaste': ('handfast',),
'handfast': ('handfast',),
'handgangen': ('handgangen',),
'handgangne': ('handgangen',),
'handgangent': ('handgangen',),
'handgitt': ('handgi',),
'handgitte': ('handgi',),
'handgiende': ('handgi',),
'handgripelig': ('handgripelig',),
'handgripelige': ('handgripelig',),
'handgripelig': ('handgripelig',),
'handheva': ('handheve',),
'handhevet': ('handheve',),
'handhevd': ('handheve',),
'handheva': ('handheve',),
'handhevet': ('handheve',),
'handhevd': ('handheve',),
'handheva': ('handheve',),
'handhevete': ('handheve',),
'handhevede': ('handheve',),
'handhevde': ('handheve',),
'handheva': ('handheve',),
'handhevete': ('handheve',),
'handhevede': ('handheve',),
'handhevde': ('handheve',),
'handhevende': ('handheve',),
'handhilst': ('handhilse',),
'handhilste': ('handhilse',),
'handhilsende': ('handhilse',),
'handikappa': ('handikappe',),
'handikappet': ('handikappe',),
'handikappa': ('handikappe',),
'handikappet': ('handikappe',),
'handikappa': ('handikappe',),
'handikappete': ('handikappe',),
'handikappede': ('handikappe',),
'handikappa': ('handikappe',),
'handikappete': ('handikappe',),
'handikappede': ('handikappe',),
'handikappende': ('handikappe',),
'handlaga': ('handlaga',),
'handlagd': ('handlagd',),
'handlagde': ('handlagd',),
'handlagd': ('handlagd',),
'handlaget': ('handlaget',),
'handlagete': ('handlaget',),
'handlagede': ('handlaget',),
'handlagete': ('handlaget',),
'handlagede': ('handlaget',),
'handlaget': ('handlaget',),
'handla': ('handle',),
'handlet': ('handle',),
'handla': ('handle',),
'handlet': ('handle',),
'handla': ('handle',),
'handlete': ('handle',),
'handlede': ('handle',),
'handlete': ('handle',),
'handlede': ('handle',),
'handla': ('handle',),
'handlete': ('handle',),
'handlede': ('handle',),
'handlete': ('handle',),
'handlede': ('handle',),
'handlende': ('handle',),
'handledyktig': ('handledyktig',),
'handledyktige': ('handledyktig',),
'handledyktig': ('handledyktig',),
'handlekraftig': ('handlekraftig',),
'handlekraftige': ('handlekraftig',),
'handlekraftig': ('handlekraftig',),
'handlingslamma': ('handlingslamma',),
'handlingslammet': ('handlingslammet',),
'handlingslammete': ('handlingslammet',),
'handlingslammede': ('handlingslammet',),
'handlingslammete': ('handlingslammet',),
'handlingslammede': ('handlingslammet',),
'handlingslammet': ('handlingslammet',),
'handlingsmetta': ('handlingsmetta',),
'handlingsmettet': ('handlingsmettet',),
'handlingsmettete': ('handlingsmettet',),
'handlingsmettede': ('handlingsmettet',),
'handlingsmettete': ('handlingsmettet',),
'handlingsmettede': ('handlingsmettet',),
'handlingsmettet': ('handlingsmettet',),
'handnerva': ('handnerva',),
'handnervet': ('handnervet',),
'handnervete': ('handnervet',),
'handnervede': ('handnervet',),
'handnervete': ('handnervet',),
'handnervede': ('handnervet',),
'handnervet': ('handnervet',),
'handplukka': ('handplukke',),
'handplukket': ('handplukke',),
'handplukka': ('handplukke',),
'handplukket': ('handplukke',),
'handplukka': ('handplukke',),
'handplukkete': ('handplukke',),
'handplukkede': ('handplukke',),
'handplukka': ('handplukke',),
'handplukkete': ('handplukke',),
'handplukkede': ('handplukke',),
'handplukkende': ('handplukke',),
'handsama': ('handsame',),
'handsamet': ('handsame',),
'handsama': ('handsame',),
'handsamet': ('handsame',),
'handsama': ('handsame',),
'handsamete': ('handsame',),
'handsamede': ('handsame',),
'handsama': ('handsame',),
'handsamete': ('handsame',),
'handsamede': ('handsame',),
'handsamende': ('handsame',),
'handsa': ('handse',),
'handset': ('handse',),
'handsa': ('handse',),
'handset': ('handse',),
'handsa': ('handse',),
'handsete': ('handse',),
'handsede': ('handse',),
'handsete': ('handse',),
'handsede': ('handse',),
'handsa': ('handse',),
'handsete': ('handse',),
'handsede': ('handse',),
'handsete': ('handse',),
'handsede': ('handse',),
'handsende': ('handse',),
'handskreven': ('handskreven',),
'handskrevne': ('handskreven',),
'handskrevet': ('handskreven',),
'handskrevet': ('handskrevet',),
'handskrevne': ('handskrevet',),
'handskrevet': ('handskrevet',),
'handskåren': ('handskåren',),
'handskårne': ('handskåren',),
'handskåret': ('handskåren',),
'handskåret': ('handskåret',),
'handskårne': ('handskåret',),
'handskåret': ('handskåret',),
'handstående': ('handstående',),
'handtert': ('handtere',),
'handterte': ('handtere',),
'handterende': ('handtere',),
'handterlig': ('handterlig',),
'handterlige': ('handterlig',),
'handterlig': ('handterlig',),
'handvarm': ('handvarm',),
'handvarme': ('handvarm',),
'handvarmt': ('handvarm',),
'handverksmessig': ('handverksmessig',),
'handverksmessige': ('handverksmessig',),
'handverksmessig': ('handverksmessig',),
'hangla': ('hangle',),
'hanglet': ('hangle',),
'hangla': ('hangle',),
'hanglet': ('hangle',),
'hangla': ('hangle',),
'hanglete': ('hangle',),
'hanglede': ('hangle',),
'hanglete': ('hangle',),
'hanglede': ('hangle',),
'hangla': ('hangle',),
'hanglete': ('hangle',),
'hanglede': ('hangle',),
'hanglete': ('hangle',),
'hanglede': ('hangle',),
'hanglende': ('hangle',),
'hanglet': ('hanglet',),
'hanglete': ('hanglet',),
'hanglet': ('hanglet',),
'hanglete': ('hanglete',),
'hankelaus': ('hankelaus',),
'hankelause': ('hankelaus',),
'hankelaust': ('hankelaus',),
'hankeløs': ('hankeløs',),
'hankeløse': ('hankeløs',),
'hankeløst': ('hankeløs',),
'hanlig': ('hanlig',),
'hanlige': ('hanlig',),
'hanlig': ('hanlig',),
'hannlig': ('hannlig',),
'hannlige': ('hannlig',),
'hannlig': ('hannlig',),
'hanseatisk': ('hanseatisk',),
'hanseatiske': ('hanseatisk',),
'hanseatisk': ('hanseatisk',),
'haploid': ('haploid',),
'haploide': ('haploid',),
'haploid': ('haploid',),
'hard': ('hard',),
'harde': ('hard',),
'hardt': ('hard',),
'hardere': ('hard',),
'hardest': ('hard',),
'hardeste': ('hard',),
'hardbalen': ('hardbalen',),
'hardbalne': ('hardbalen',),
'hardbalent': ('hardbalen',),
'hardbarket': ('hardbarket',),
'hardbarkete': ('hardbarket',),
'hardbarkede': ('hardbarket',),
'hardbarkete': ('hardbarket',),
'hardbarkede': ('hardbarket',),
'hardbarket': ('hardbarket',),
'hardfrossen': ('hardfrossen',),
'hardfrosne': ('hardfrossen',),
'hardfrosset': ('hardfrossen',),
'hardfrosset': ('hardfrosset',),
'hardfrosne': ('hardfrosset',),
'hardfrosset': ('hardfrosset',),
'hardfør': ('hardfør',),
'hardføre': ('hardfør',),
'hardført': ('hardfør',),
'hardhendt': ('hardhendt',),
'hardhendte': ('hardhendt',),
'hardhendt': ('hardhendt',),
'hardhjerta': ('hardhjerta',),
'hardhjertet': ('hardhjertet',),
'hardhjertete': ('hardhjertet',),
'hardhjertede': ('hardhjertet',),
'hardhjertete': ('hardhjertet',),
'hardhjertede': ('hardhjertet',),
'hardhjertet': ('hardhjertet',),
'hardhuda': ('hardhuda',),
'hardhudet': ('hardhudet',),
'hardhudete': ('hardhudet',),
'hardhudede': ('hardhudet',),
'hardhudete': ('hardhudet',),
'hardhudede': ('hardhudet',),
'hardhudet': ('hardhudet',),
'hardkokt': ('hardkoke',),
'hardkokte': ('hardkoke',),
'hardkokende': ('hardkoke',),
'hardlynt': ('hardlynt',),
'hardlynte': ('hardlynt',),
'hardlynt': ('hardlynt',),
'hardnakka': ('hardnakka',),
'hardnakket': ('hardnakket',),
'hardnakkete': ('hardnakket',),
'hardnakkede': ('hardnakket',),
'hardnakkete': ('hardnakket',),
'hardnakkede': ('hardnakket',),
'hardnakket': ('hardnakket',),
'hardna': ('hardne',),
'hardnet': ('hardne',),
'hardna': ('hardne',),
'hardnet': ('hardne',),
'hardna': ('hardne',),
'hardnete': ('hardne',),
'hardnede': ('hardne',),
'hardnete': ('hardne',),
'hardnede': ('hardne',),
'hardna': ('hardne',),
'hardnete': ('hardne',),
'hardnede': ('hardne',),
'hardnete': ('hardne',),
'hardnede': ('hardne',),
'hardnende': ('hardne',),
'hardstappa': ('hardstappa',),
'hardstappet': ('hardstappet',),
'hardstappete': ('hardstappet',),
'hardstappede': ('hardstappet',),
'hardstappete': ('hardstappet',),
'hardstappede': ('hardstappet',),
'hardstappet': ('hardstappet',),
'hardtrampa': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampete': ('hardtrampe',),
'hardtrampede': ('hardtrampe',),
'hardtrampa': ('hardtrampe',),
'hardtrampete': ('hardtrampe',),
'hardtrampede': ('hardtrampe',),
'hardtrampende': ('hardtrampe',),
'hardtrena': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrent': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrent': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrenete': ('hardtrene',),
'hardtrenede': ('hardtrene',),
'hardtrente': ('hardtrene',),
'hardtrena': ('hardtrene',),
'hardtrenete': ('hardtrene',),
'hardtrenede': ('hardtrene',),
'hardtrente': ('hardtrene',),
'hardtrenende': ('hardtrene',),
'haremynt': ('haremynt',),
'haremynte': ('haremynt',),
'haremynt': ('haremynt',),
'harka': ('harke',),
'harket': ('harke',),
'harka': ('harke',),
'harket': ('harke',),
'harka': ('harke',),
'harkete': ('harke',),
'harkede': ('harke',),
'harka': ('harke',),
'harkete': ('harke',),
'harkede': ('harke',),
'harkende': ('harke',),
'harm': ('harm',),
'harme': ('harm',),
'harmt': ('harm',),
'harmdirrende': ('harmdirrende',),
'harma': ('harme',),
'harmet': ('harme',),
'harma': ('harme',),
'harmet': ('harme',),
'harma': ('harme',),
'harmete': ('harme',),
'harmede': ('harme',),
'harma': ('harme',),
'harmete': ('harme',),
'harmede': ('harme',),
'harmende': ('harme',),
'harmelig': ('harmelig',),
'harmelige': ('harmelig',),
'harmelig': ('harmelig',),
'harmfull': ('harmfull',),
'harmfulle': ('harmfull',),
'harmfullt': ('harmfull',),
'harmlaus': ('harmlaus',),
'harmlause': ('harmlaus',),
'harmlaust': ('harmlaus',),
'harmløs': ('harmløs',),
'harmløse': ('harmløs',),
'harmløst': ('harmløs',),
'harmonert': ('harmonere',),
'harmonerte': ('harmonere',),
'harmonerende': ('harmonere',),
'harmonisert': ('harmonisere',),
'harmoniserte': ('harmonisere',),
'harmoniserende': ('harmonisere',),
'harmonisk': ('harmonisk',),
'harmoniske': ('harmonisk',),
'harmonisk': ('harmonisk',),
'harpa': ('harpe',),
'harpet': ('harpe',),
'harpa': ('harpe',),
'harpet': ('harpe',),
'harpa': ('harpe',),
'harpete': ('harpe',),
'harpede': ('harpe',),
'harpa': ('harpe',),
'harpete': ('harpe',),
'harpede': ('harpe',),
'harpende': ('harpe',),
'harpunert': ('harpunere',),
'harpunerte': ('harpunere',),
'harpunerende': ('harpunere',),
'harselert': ('harselere',),
'harselerte': ('harselere',),
'harselerende': ('harselere',),
'harsk': ('harsk',),
'harske': ('harsk',),
'harskt': ('harsk',),
'harskere': ('harsk',),
'harskest': ('harsk',),
'harskeste': ('harsk',),
'harska': ('harske',),
'harsket': ('harske',),
'harska': ('harske',),
'harsket': ('harske',),
'harska': ('harske',),
'harskete': ('harske',),
'harskede': ('harske',),
'harska': ('harske',),
'harskete': ('harske',),
'harskede': ('harske',),
'harskende': ('harske',),
'harskna': ('harskne',),
'harsknet': ('harskne',),
'harskna': ('harskne',),
'harsknet': ('harskne',),
'harskna': ('harskne',),
'harsknete': ('harskne',),
'harsknede': ('harskne',),
'harsknete': ('harskne',),
'harsknede': ('harskne',),
'harskna': ('harskne',),
'harsknete': ('harskne',),
'harsknede': ('harskne',),
'harsknete': ('harskne',),
'harsknede': ('harskne',),
'harsknende': ('harskne',),
'harva': ('harve',),
'harvet': ('harve',),
'harva': ('harve',),
'harvet': ('harve',),
'harva': ('harve',),
'harvete': ('harve',),
'harvede': ('harve',),
'harva': ('harve',),
'harvete': ('harve',),
'harvede': ('harve',),
'harvende': ('harve',),
'hasardiøs': ('hasardiøs',),
'hasardiøse': ('hasardiøs',),
'hasardiøst': ('hasardiøs',),
'haspa': ('haspe',),
'haspet': ('haspe',),
'haspa': ('haspe',),
'haspet': ('haspe',),
'haspa': ('haspe',),
'haspete': ('haspe',),
'haspede': ('haspe',),
'haspa': ('haspe',),
'haspete': ('haspe',),
'haspede': ('haspe',),
'haspende': ('haspe',),
'haspla': ('hasple',),
'hasplet': ('hasple',),
'haspla': ('hasple',),
'hasplet': ('hasple',),
'haspla': ('hasple',),
'hasplete': ('hasple',),
'hasplede': ('hasple',),
'hasplete': ('hasple',),
'hasplede': ('hasple',),
'haspla': ('hasple',),
'hasplete': ('hasple',),
'hasplede': ('hasple',),
'hasplete': ('hasple',),
'hasplede': ('hasple',),
'hasplende': ('hasple',),
'hasta': ('haste',),
'hastet': ('haste',),
'hasta': ('haste',),
'hastet': ('haste',),
'hasta': ('haste',),
'hastete': ('haste',),
'hastede': ('haste',),
'hasta': ('haste',),
'hastete': ('haste',),
'hastede': ('haste',),
'hastende': ('haste',),
'hastig': ('hastig',),
'hastige': ('hastig',),
'hastig': ('hastig',),
'hata': ('hate',),
'hatet': ('hate',),
'hata': ('hate',),
'hatet': ('hate',),
'hata': ('hate',),
'hatete': ('hate',),
'hatede': ('hate',),
'hata': ('hate',),
'hatete': ('hate',),
'hatede': ('hate',),
'hatende': ('hate',),
'hatefull': ('hatefull',),
'hatefulle': ('hatefull',),
'hatefullt': ('hatefull',),
'hatig': ('hatig',),
'hatige': ('hatig',),
'hatig': ('hatig',),
'hatsk': ('hatsk',),
'hatske': ('hatsk',),
'hatsk': ('hatsk',),
'hatskere': ('hatsk',),
'hatskest': ('hatsk',),
'hatskeste': ('hatsk',),
'hauga': ('hauge',),
'hauget': ('hauge',),
'hauga': ('hauge',),
'hauget': ('hauge',),
'hauga': ('hauge',),
'haugete': ('hauge',),
'haugede': ('hauge',),
'hauga': ('hauge',),
'haugete': ('hauge',),
'haugede': ('hauge',),
'haugende': ('hauge',),
'hauget': ('hauget',),
'haugete': ('hauget',),
'hauget': ('hauget',),
'haugete': ('haugete',),
'haugiansk': ('haugiansk',),
'haugianske': ('haugiansk',),
'haugiansk': ('haugiansk',),
'hauglagt': ('hauglegge',),
'hauglagte': ('hauglegge',),
'haugleggende': ('hauglegge',),
'haugtatt': ('haugta',),
'haugtatte': ('haugta',),
'haugtakende': ('haugta',),
'hauka': ('hauke',),
'hauket': ('hauke',),
'hauka': ('hauke',),
'hauket': ('hauke',),
'hauka': ('hauke',),
'haukete': ('hauke',),
'haukede': ('hauke',),
'hauka': ('hauke',),
'haukete': ('hauke',),
'haukede': ('hauke',),
'haukende': ('hauke',),
'haussa': ('hausse',),
'hausset': ('hausse',),
'haussa': ('hausse',),
'hausset': ('hausse',),
'haussa': ('hausse',),
'haussete': ('hausse',),
'haussede': ('hausse',),
'haussa': ('hausse',),
'haussete': ('hausse',),
'haussede': ('hausse',),
'haussende': ('hausse',),
'havannesisk': ('havannesisk',),
'havannesiske': ('havannesisk',),
'havannesisk': ('havannesisk',),
'havarert': ('havarere',),
'havarerte': ('havarere',),
'havarerende': ('havarere',),
'havesjuk': ('havesjuk',),
'havesjuke': ('havesjuk',),
'havesjukt': ('havesjuk',),
'havesyk': ('havesyk',),
'havesyke': ('havesyk',),
'havesykt': ('havesyk',),
'havgående': ('havgående',),
'havna': ('havne',),
'havnet': ('havne',),
'havna': ('havne',),
'havnet': ('havne',),
'havna': ('havne',),
'havnete': ('havne',),
'havnede': ('havne',),
'havna': ('havne',),
'havnete': ('havne',),
'havnede': ('havne',),
'havnende': ('havne',),
'havsalt': ('havsalt',),
'havsalte': ('havsalt',),
'havsalt': ('havsalt',),
'hawaiisk': ('hawaiisk',),
'hawaiiske': ('hawaiisk',),
'hawaiisk': ('hawaiisk',),
'hawaisk': ('hawaisk',),
'hawaiske': ('hawaisk',),
'hawaisk': ('hawaisk',),
'heada': ('heade',),
'headet': ('heade',),
'heada': ('heade',),
'headet': ('heade',),
'heada': ('heade',),
'headete': ('heade',),
'headede': ('heade',),
'heada': ('heade',),
'headete': ('heade',),
'headede': ('heade',),
'headende': ('heade',),
'hebraisk': ('hebraisk',),
'hebraiske': ('hebraisk',),
'hebraisk': ('hebraisk',),
'hebridisk': ('hebridisk',),
'hebridiske': ('hebridisk',),
'hebridisk': ('hebridisk',),
'hedensk': ('hedensk',),
'hedenske': ('hedensk',),
'hedensk': ('hedensk',),
'hederlig': ('hederlig',),
'hederlige': ('hederlig',),
'hederlig': ('hederlig',),
'hederskrona': ('hederskrona',),
'hederskronet': ('hederskronet',),
'hederskronete': ('hederskronet',),
'hederskronede': ('hederskronet',),
'hederskronete': ('hederskronet',),
'hederskronede': ('hederskronet',),
'hederskronet': ('hederskronet',),
'hederskront': ('hederskront',),
'hederskronte': ('hederskront',),
'hederskront': ('hederskront',),
'hedonistisk': ('hedonistisk',),
'hedonistiske': ('hedonistisk',),
'hedonistisk': ('hedonistisk',),
'hedra': ('hedre',),
'hedret': ('hedre',),
'hedra': ('hedre',),
'hedret': ('hedre',),
'hedra': ('hedre',),
'hedrete': ('hedre',),
'hedrede': ('hedre',),
'hedrete': ('hedre',),
'hedrede': ('hedre',),
'hedra': ('hedre',),
'hedrete': ('hedre',),
'hedrede': ('hedre',),
'hedrete': ('hedre',),
'hedrede': ('hedre',),
'hedrende': ('hedre',),
'hefta': ('hefte',),
'heftet': ('hefte',),
'hefta': ('hefte',),
'heftet': ('hefte',),
'hefta': ('hefte',),
'heftete': ('hefte',),
'heftede': ('hefte',),
'hefta': ('hefte',),
'heftete': ('hefte',),
'heftede': ('hefte',),
'heftende': ('hefte',),
'heftig': ('heftig',),
'heftige': ('heftig',),
'heftig': ('heftig',),
'heftigere': ('heftig',),
'heftigst': ('heftig',),
'heftigste': ('heftig',),
'hegda': ('hegde',),
'hegdet': ('hegde',),
'hegda': ('hegde',),
'hegdet': ('hegde',),
'hegda': ('hegde',),
'hegdete': ('hegde',),
'hegdede': ('hegde',),
'hegda': ('hegde',),
'hegdete': ('hegde',),
'hegdede': ('hegde',),
'hegdende': ('hegde',),
'hegeliansk': ('hegeliansk',),
'hegelianske': ('hegeliansk',),
'hegeliansk': ('hegeliansk',),
'hegelsk': ('hegelsk',),
'hegelske': ('hegelsk',),
'hegelsk': ('hegelsk',),
'hegna': ('hegne',),
'hegnet': ('hegne',),
'hegna': ('hegne',),
'hegnet': ('hegne',),
'hegna': ('hegne',),
'hegnete': ('hegne',),
'hegnede': ('hegne',),
'hegna': ('hegne',),
'hegnete': ('hegne',),
'hegnede': ('hegne',),
'hegnende': ('hegne',),
'heidundrende': ('heidundrende',),
'heia': ('heie',),
'heiet': ('heie',),
'heia': ('heie',),
'heiet': ('heie',),
'heia': ('heie',),
'heiete': ('heie',),
'heiede': ('heie',),
'heia': ('heie',),
'heiete': ('heie',),
'heiede': ('heie',),
'heiende': ('heie',),
'heil': ('heil',),
'heile': ('heil',),
'heilt': ('heil',),
'heilaftens': ('heilaftens',),
'heilautomatisk': ('heilautomatisk',),
'heilautomatiske': ('heilautomatisk',),
'heilautomatisk': ('heilautomatisk',),
'heildekkende': ('heildekkende',),
'heilfet': ('heilfet',),
'heilfete': ('heilfet',),
'heilfett': ('heilfet',),
'heilfrelst': ('heilfrelst',),
'heilfrelste': ('heilfrelst',),
'heilfrelst': ('heilfrelst',),
'heilgardert': ('heilgardere',),
'heilgarderte': ('heilgardere',),
'heilgarderende': ('heilgardere',),
'heilhetlig': ('heilhetlig',),
'heilhetlige': ('heilhetlig',),
'heilhetlig': ('heilhetlig',),
'heilhjerta': ('heilhjerta',),
'heilhjertet': ('heilhjertet',),
'heilhjertete': ('heilhjertet',),
'heilhjertede': ('heilhjertet',),
'heilhjertete': ('heilhjertet',),
'heilhjertede': ('heilhjertet',),
'heilhjertet': ('heilhjertet',),
'heilhuga': ('heilhuga',),
'heilkontinuerlig': ('heilkontinuerlig',),
'heilkontinuerlige': ('heilkontinuerlig',),
'heilkontinuerlig': ('heilkontinuerlig',),
'heilnorsk': ('heilnorsk',),
'heilnorske': ('heilnorsk',),
'heilnorsk': ('heilnorsk',),
'heilskinna': ('heilskinna',),
'heilskinnet': ('heilskinnet',),
'heilskinnete': ('heilskinnet',),
'heilskinnede': ('heilskinnet',),
'heilskinnete': ('heilskinnet',),
'heilskinnede': ('heilskinnet',),
'heilskinnet': ('heilskinnet',),
'heilskåren': ('heilskåren',),
'heilskårne': ('heilskåren',),
'heilskåret': ('heilskåren',),
'heilskåret': ('heilskåret',),
'heilskårne': ('heilskåret',),
'heilskåret': ('heilskåret',),
'heilstaut': ('heilstaut',),
'heilstaute': ('heilstaut',),
'heilstaut': ('heilstaut',),
'heilsteikt': ('heilsteike',),
'heilsteikte': ('heilsteike',),
'heilsteikende': ('heilsteike',),
'heilstekt': ('heilsteke',),
'heilstekte': ('heilsteke',),
'heilstekende': ('heilsteke',),
'heilstøpt': ('heilstøpe',),
'heilstøpte': ('heilstøpe',),
'heilstøpende': ('heilstøpe',),
'heilstøypt': ('heilstøype',),
'heilstøypte': ('heilstøype',),
'heilstøypende': ('heilstøype',),
'heilsvart': ('heilsvart',),
'heilsvarte': ('heilsvart',),
'heilsvart': ('heilsvart',),
'heilsynkronisert': ('heilsynkronisere',),
'heilsynkroniserte': ('heilsynkronisere',),
'heilsynkroniserende': ('heilsynkronisere',),
'heiltallig': ('heiltallig',),
'heiltallige': ('heiltallig',),
'heiltallig': ('heiltallig',),
'heiltidsansatt': ('heiltidsansatt',),
'heiltidsansatte': ('heiltidsansatt',),
'heiltidsansatt': ('heiltidsansatt',),
'heiltres': ('heiltres',),
'heiltrukket': ('heiltrukket',),
'heiltrukne': ('heiltrukket',),
'heiltrukket': ('heiltrukket',),
'heilårig': ('heilårig',),
'heilårige': ('heilårig',),
'heilårig': ('heilårig',),
'heilårs': ('heilårs',),
'heimattkommen': ('heimattkommen',),
'heimattkomne': ('heimattkommen',),
'heimattkommet': ('heimattkommen',),
'heimattkommet': ('heimattkommet',),
'heimattkomne': ('heimattkommet',),
'heimattkommet': ('heimattkommet',),
'heima': ('heime',),
'heimet': ('heime',),
'heima': ('heime',),
'heimet': ('heime',),
'heima': ('heime',),
'heimete': ('heime',),
'heimede': ('heime',),
'heima': ('heime',),
'heimete': ('heime',),
'heimede': ('heime',),
'heimende': ('heime',),
'heimearbeidende': ('heimearbeidende',),
'heimeavla': ('heimeavla',),
'heimeavlet': ('heimeavlet',),
'heimeavlete': ('heimeavlet',),
'heimeavlede': ('heimeavlet',),
'heimeavlete': ('heimeavlet',),
'heimeavlede': ('heimeavlet',),
'heimeavlet': ('heimeavlet',),
'heimebakt': ('heimebakt',),
'heimebakte': ('heimebakt',),
'heimebakt': ('heimebakt',),
'heimegjort': ('heimegjort',),
'heimegjorte': ('heimegjort',),
'heimegjort': ('heimegjort',),
'heimehørende': ('heimehørende',),
'heimekjent': ('heimekjent',),
'heimekjente': ('heimekjent',),
'heimekjent': ('heimekjent',),
'heimekjær': ('heimekjær',),
'heimekjære': ('heimekjær',),
'heimekjært': ('heimekjær',),
'heimekoselig': ('heimekoselig',),
'heimekoselige': ('heimekoselig',),
'heimekoselig': ('heimekoselig',),
'heimelaga': ('heimelaga',),
'heimelagd': ('heimelagd',),
'heimelagde': ('heimelagd',),
'heimelagd': ('heimelagd',),
'heimelaget': ('heimelaget',),
'heimelagete': ('heimelaget',),
'heimelagede': ('heimelaget',),
'heimelagete': ('heimelaget',),
'heimelagede': ('heimelaget',),
'heimelaget': ('heimelaget',),
'heimestrikka': ('heimestrikka',),
'heimestrikket': ('heimestrikket',),
'heimestrikkete': ('heimestrikket',),
'heimestrikkede': ('heimestrikket',),
'heimestrikkete': ('heimestrikket',),
'heimestrikkede': ('heimestrikket',),
'heimestrikket': ('heimestrikket',),
'heimevant': ('heimevant',),
'heimevante': ('heimevant',),
'heimevant': ('heimevant',),
'heimeværende': ('heimeværende',),
'heimfalt': ('heimfalle',),
'heimfalte': ('heimfalle',),
'heimfallende': ('heimfalle',),
'heimfallen': ('heimfallen',),
'heimfalne': ('heimfallen',),
'heimfallent': ('heimfallen',),
'heimfesta': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfestete': ('heimfeste',),
'heimfestede': ('heimfeste',),
'heimfesta': ('heimfeste',),
'heimfestete': ('heimfeste',),
'heimfestede': ('heimfeste',),
'heimfestende': ('heimfeste',),
'heimfus': ('heimfus',),
'heimfuse': ('heimfus',),
'heimfust': ('heimfus',),
'heimført': ('heimføre',),
'heimførte': ('heimføre',),
'heimførende': ('heimføre',),
'heimhuga': ('heimhuga',),
'heimkalt': ('heimkalle',),
'heimkalte': ('heimkalle',),
'heimkallende': ('heimkalle',),
'heimkommet': ('heimkommet',),
'heimkomne': ('heimkommet',),
'heimkommet': ('heimkommet',),
'heimlaus': ('heimlaus',),
'heimlause': ('heimlaus',),
'heimlaust': ('heimlaus',),
'heimla': ('heimle',),
'heimlet': ('heimle',),
'heimla': ('heimle',),
'heimlet': ('heimle',),
'heimla': ('heimle',),
'heimlete': ('heimle',),
'heimlede': ('heimle',),
'heimlete': ('heimle',),
'heimlede': ('heimle',),
'heimla': ('heimle',),
'heimlete': ('heimle',),
'heimlede': ('heimle',),
'heimlete': ('heimle',),
'heimlede': ('heimle',),
'heimlende': ('heimle',),
'heimlig': ('heimlig',),
'heimlige': ('heimlig',),
'heimlig': ('heimlig',),
'heimløs': ('heimløs',),
'heimløse': ('heimløs',),
'heimløst': ('heimløs',),
'heimsendt': ('heimsende',),
'heimsendte': ('heimsende',),
'heimsendende': ('heimsende',),
'heimsøkt': ('heimsøke',),
'heimsøkte': ('heimsøke',),
'heimsøkende': ('heimsøke',),
'heimvendt': ('heimvendt',),
'heimvendte': ('heimvendt',),
'heimvendt': ('heimvendt',),
'heint': ('heine',),
'heinte': ('heine',),
'heinende': ('heine',),
'heist': ('heise',),
'heiste': ('heise',),
'heisende': ('heise',),
'heit': ('heit',),
'heite': ('heit',),
'heitt': ('heit',),
'hett': ('heit',),
'heitere': ('heit',),
'heitest': ('heit',),
'heiteste': ('heit',),
'heitna': ('heitne',),
'heitnet': ('heitne',),
'heitna': ('heitne',),
'heitnet': ('heitne',),
'heitna': ('heitne',),
'heitnete': ('heitne',),
'heitnede': ('heitne',),
'heitnete': ('heitne',),
'heitnede': ('heitne',),
'heitna': ('heitne',),
'heitnete': ('heitne',),
'heitnede': ('heitne',),
'heitnete': ('heitne',),
'heitnede': ('heitne',),
'heitnende': ('heitne',),
'hekka': ('hekke',),
'hekket': ('hekke',),
'hekka': ('hekke',),
'hekket': ('hekke',),
'hekka': ('hekke',),
'hekkete': ('hekke',),
'hekkede': ('hekke',),
'hekka': ('hekke',),
'hekkete': ('hekke',),
'hekkede': ('hekke',),
'hekkende': ('hekke',),
'hekla': ('hekle',),
'heklet': ('hekle',),
'hekla': ('hekle',),
'heklet': ('hekle',),
'hekla': ('hekle',),
'heklete': ('hekle',),
'heklede': ('hekle',),
'heklete': ('hekle',),
'heklede': ('hekle',),
'hekla': ('hekle',),
'heklete': ('hekle',),
'heklede': ('hekle',),
'heklete': ('hekle',),
'heklede': ('hekle',),
'heklende': ('hekle',),
'heksa': ('hekse',),
'hekset': ('hekse',),
'heksa': ('hekse',),
'hekset': ('hekse',),
'heksa': ('hekse',),
'heksete': ('hekse',),
'heksede': ('hekse',),
'heksa': ('hekse',),
'heksete': ('hekse',),
'heksede': ('hekse',),
'heksende': ('hekse',),
'hekta': ('hekte',),
'hektet': ('hekte',),
'hekta': ('hekte',),
'hektet': ('hekte',),
'hekta': ('hekte',),
'hektete': ('hekte',),
'hektede': ('hekte',),
'hekta': ('hekte',),
'hektete': ('hekte',),
'hektede': ('hekte',),
'hektende': ('hekte',),
'hektisk': ('hektisk',),
'hektiske': ('hektisk',),
'hektisk': ('hektisk',),
'hektografert': ('hektografere',),
'hektograferte': ('hektografere',),
'hektograferende': ('hektografere',),
'hel': ('hel',),
'hele': ('hel',),
'helt': ('hel',),
'helaftens': ('helaftens',),
'helautomatisk': ('helautomatisk',),
'helautomatiske': ('helautomatisk',),
'helautomatisk': ('helautomatisk',),
'helbreda': ('helbrede',),
'helbredet': ('helbrede',),
'helbreda': ('helbrede',),
'helbredet': ('helbrede',),
'helbreda': ('helbrede',),
'helbredete': ('helbrede',),
'helbredede': ('helbrede',),
'helbreda': ('helbrede',),
'helbredete': ('helbrede',),
'helbredede': ('helbrede',),
'helbredende': ('helbrede',),
'helbredelig': ('helbredelig',),
'helbredelige': ('helbredelig',),
'helbredelig': ('helbredelig',),
'helda': ('helde',),
'heldet': ('helde',),
'helda': ('helde',),
'heldet': ('helde',),
'helda': ('helde',),
'heldete': ('helde',),
'heldede': ('helde',),
'helda': ('helde',),
'heldete': ('helde',),
'heldede': ('helde',),
'heldende': ('helde',),
'heldekkende': ('heldekkende',),
'heldig': ('heldig',),
'heldige': ('heldig',),
'heldig': ('heldig',),
'heldigere': ('heldig',),
'heldigst': ('heldig',),
'heldigste': ('heldig',),
'helfet': ('helfet',),
'helfete': ('helfet',),
'helfett': ('helfet',),
'helfrelst': ('helfrelst',),
'helfrelste': ('helfrelst',),
'helfrelst': ('helfrelst',),
'helgardert': ('helgardere',),
'helgarderte': ('helgardere',),
'helgarderende': ('helgardere',),
'helhetlig': ('helhetlig',),
'helhetlige': ('helhetlig',),
'helhetlig': ('helhetlig',),
'helhjerta': ('helhjerta',),
'helhjertet': ('helhjertet',),
'helhjertete': ('helhjertet',),
'helhjertede': ('helhjertet',),
'helhjertete': ('helhjertet',),
'helhjertede': ('helhjertet',),
'helhjertet': ('helhjertet',),
'heliosentrisk': ('heliosentrisk',),
'heliosentriske': ('heliosentrisk',),
'heliosentrisk': ('heliosentrisk',),
'helkontinuerlig': ('helkontinuerlig',),
'helkontinuerlige': ('helkontinuerlig',),
'helkontinuerlig': ('helkontinuerlig',),
'hellet': ('helle',),
'helt': ('helle',),
'hellet': ('helle',),
'helt': ('helle',),
'hellete': ('helle',),
'hellede': ('helle',),
'helte': ('helle',),
'hellete': ('helle',),
'hellede': ('helle',),
'helte': ('helle',),
'hellende': ('helle',),
'hellelagt': ('hellelegge',),
'hellelagte': ('hellelegge',),
'helleleggende': ('hellelegge',),
'hellenistisk': ('hellenistisk',),
'hellenistiske': ('hellenistisk',),
'hellenistisk': ('hellenistisk',),
'hellensk': ('hellensk',),
'hellenske': ('hellensk',),
'hellensk': ('hellensk',),
'hellig': ('hellig',),
'hellige': ('hellig',),
'hellig': ('hellig',),
'helligere': ('hellig',),
'helligst': ('hellig',),
'helligste': ('hellig',),
'helliga': ('hellige',),
'helliget': ('hellige',),
'helliga': ('hellige',),
'helliget': ('hellige',),
'helliga': ('hellige',),
'helligete': ('hellige',),
'helligede': ('hellige',),
'helliga': ('hellige',),
'helligete': ('hellige',),
'helligede': ('hellige',),
'helligende': ('hellige',),
'helligholdt': ('helligholde',),
'helligholdte': ('helligholde',),
'helligholdende': ('helligholde',),
'helnorsk': ('helnorsk',),
'helnorske': ('helnorsk',),
'helnorsk': ('helnorsk',),
'helsebringende': ('helsebringende',),
'helsebrutt': ('helsebrutt',),
'helsebrutte': ('helsebrutt',),
'helsebrutt': ('helsebrutt',),
'helsefarlig': ('helsefarlig',),
'helsefarlige': ('helsefarlig',),
'helsefarlig': ('helsefarlig',),
'helselaus': ('helselaus',),
'helselause': ('helselaus',),
'helselaust': ('helselaus',),
'helseløs': ('helseløs',),
'helseløse': ('helseløs',),
'helseløst': ('helseløs',),
'helseslått': ('helseslå',),
'helseslåtte': ('helseslå',),
'helseslående': ('helseslå',),
'helsikes': ('helsikes',),
'helskinna': ('helskinna',),
'helskinnet': ('helskinnet',),
'helskinnete': ('helskinnet',),
'helskinnede': ('helskinnet',),
'helskinnete': ('helskinnet',),
'helskinnede': ('helskinnet',),
'helskinnet': ('helskinnet',),
'helskåren': ('helskåren',),
'helskårne': ('helskåren',),
'helskåret': ('helskåren',),
'helskåret': ('helskåret',),
'helskårne': ('helskåret',),
'helskåret': ('helskåret',),
'helstaut': ('helstaut',),
'helstaute': ('helstaut',),
'helstaut': ('helstaut',),
'helsteikt': ('helsteike',),
'helsteikte': ('helsteike',),
'helsteikende': ('helsteike',),
'helstekt': ('helsteke',),
'helstekte': ('helsteke',),
'helstekende': ('helsteke',),
'helstøpt': ('helstøpe',),
'helstøpte': ('helstøpe',),
'helstøpende': ('helstøpe',),
'helstøypt': ('helstøype',),
'helstøypte': ('helstøype',),
'helstøypende': ('helstøype',),
'helsvart': ('helsvart',),
'helsvarte': ('helsvart',),
'helsvart': ('helsvart',),
'helsynkronisert': ('helsynkronisere',),
'helsynkroniserte': ('helsynkronisere',),
'helsynkroniserende': ('helsynkronisere',),
'heltallig': ('heltallig',),
'heltallige': ('heltallig',),
'heltallig': ('heltallig',),
'heltemodig': ('heltemodig',),
'heltemodige': ('heltemodig',),
'heltemodig': ('heltemodig',),
'heltidsansatt': ('heltidsansatt',),
'heltidsansatte': ('heltidsansatt',),
'heltidsansatt': ('heltidsansatt',),
'heltres': ('heltres',),
'heltrukket': ('heltrukket',),
'heltrukne': ('heltrukket',),
'heltrukket': ('heltrukket',),
'helvetes': ('helvetes',),
'helårig': ('helårig',),
'helårige': ('helårig',),
'helårig': ('helårig',),
'helårs': ('helårs',),
'hematologisk': ('hematologisk',),
'hematologiske': ('hematologisk',),
'hematologisk': ('hematologisk',),
'hemisfærisk': ('hemisfærisk',),
'hemisfæriske': ('hemisfærisk',),
'hemisfærisk': ('hemisfærisk',),
'hemma': ('hemme',),
'hemmet': ('hemme',),
'hemma': ('hemme',),
'hemmet': ('hemme',),
'hemma': ('hemme',),
'hemmete': ('hemme',),
'hemmede': ('hemme',),
'hemma': ('hemme',),
'hemmete': ('hemme',),
'hemmede': ('hemme',),
'hemmende': ('hemme',),
'hemmelig': ('hemmelig',),
'hemmelige': ('hemmelig',),
'hemmelig': ('hemmelig',),
'hemmeligere': ('hemmelig',),
'hemmeligst': ('hemmelig',),
'hemmeligste': ('hemmelig',),
'hemmelighetsfull': ('hemmelighetsfull',),
'hemmelighetsfulle': ('hemmelighetsfull',),
'hemmelighetsfullt': ('hemmelighetsfull',),
'hemmeligholdt': ('hemmeligholde',),
'hemmeligholdte': ('hemmeligholde',),
'hemmeligholdende': ('hemmeligholde',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplete': ('hemmeligstemple',),
'hemmeligstemplede': ('hemmeligstemple',),
'hemmeligstemplete': ('hemmeligstemple',),
'hemmeligstemplede': ('hemmeligstemple',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplete': ('hemmeligstemple',),
'hemmeligstemplede': ('hemmeligstemple',),
'hemmeligstemplete': ('hemmeligstemple',),
'hemmeligstemplede': ('hemmeligstemple',),
'hemmeligstemplende': ('hemmeligstemple',),
'hemningslaus': ('hemningslaus',),
'hemningslause': ('hemningslaus',),
'hemningslaust': ('hemningslaus',),
'hemningsløs': ('hemningsløs',),
'hemningsløse': ('hemningsløs',),
'hemningsløst': ('hemningsløs',),
'hendt': ('hende',),
'hendte': ('hende',),
'hendende': ('hende',),
'hende': ('hende',),
'hendelig': ('hendelig',),
'hendelige': ('hendelig',),
'hendelig': ('hendelig',),
'hendig': ('hendig',),
'hendige': ('hendig',),
'hendig': ('hendig',),
'hendt': ('hendt',),
'hendte': ('hendt',),
'hendt': ('hendt',),
'hendøende': ('hendøende',),
'henfallen': ('henfallen',),
'henfalne': ('henfallen',),
'henfallent': ('henfallen',),
'henfaren': ('henfaren',),
'henfarne': ('henfaren',),
'henfarent': ('henfaren',),
'henført': ('henføre',),
'henførte': ('henføre',),
'henførende': ('henføre',),
'hengebratt': ('hengebratt',),
'hengebratte': ('hengebratt',),
'hengebratt': ('hengebratt',),
'hengeskuldra': ('hengeskuldra',),
'hengeskuldret': ('hengeskuldret',),
'hengeskuldrete': ('hengeskuldret',),
'hengeskuldrede': ('hengeskuldret',),
'hengeskuldrete': ('hengeskuldret',),
'hengeskuldrede': ('hengeskuldret',),
'hengeskuldret': ('hengeskuldret',),
'hengitt': ('hengi',),
'hengitte': ('hengi',),
'hengiende': ('hengi',),
'hengiven': ('hengiven',),
'hengivne': ('hengiven',),
'hengivent': ('hengiven',),
'hengsla': ('hengsle',),
'hengslet': ('hengsle',),
'hengsla': ('hengsle',),
'hengslet': ('hengsle',),
'hengsla': ('hengsle',),
'hengslete': ('hengsle',),
'hengslede': ('hengsle',),
'hengslete': ('hengsle',),
'hengslede': ('hengsle',),
'hengsla': ('hengsle',),
'hengslete': ('hengsle',),
'hengslede': ('hengsle',),
'hengslete': ('hengsle',),
'hengslede': ('hengsle',),
'hengslende': ('hengsle',),
'hengslet': ('hengslet',),
'hengslete': ('hengslet',),
'hengslet': ('hengslet',),
'hengslete': ('hengslete',),
'henholdt': ('henholde',),
'henholdte': ('henholde',),
'henholdende': ('henholde',),
'henhørt': ('henhøre',),
'henhørte': ('henhøre',),
'henhørende': ('henhøre',),
'henkasta': ('henkaste',),
'henkastet': ('henkaste',),
'henkasta': ('henkaste',),
'henkastet': ('henkaste',),
'henkasta': ('henkaste',),
'henkastete': ('henkaste',),
'henkastede': ('henkaste',),
'henkasta': ('henkaste',),
'henkastete': ('henkaste',),
'henkastede': ('henkaste',),
'henkastende': ('henkaste',),
'henleda': ('henlede',),
'henledet': ('henlede',),
'henleda': ('henlede',),
'henledet': ('henlede',),
'henleda': ('henlede',),
'henledete': ('henlede',),
'henledede': ('henlede',),
'henleda': ('henlede',),
'henledete': ('henlede',),
'henledede': ('henlede',),
'henledende': ('henlede',),
'henlagt': ('henlegge',),
'henlagte': ('henlegge',),
'henleggende': ('henlegge',),
'hennafarga': ('hennafarga',),
'hennafarget': ('hennafarget',),
'hennafargete': ('hennafarget',),
'hennafargede': ('hennafarget',),
'hennafargete': ('hennafarget',),
'hennafargede': ('hennafarget',),
'hennafarget': ('hennafarget',),
'henretta': ('henrette',),
'henrettet': ('henrette',),
'henretta': ('henrette',),
'henrettet': ('henrette',),
'henretta': ('henrette',),
'henrettete': ('henrette',),
'henrettede': ('henrette',),
'henretta': ('henrette',),
'henrettete': ('henrette',),
'henrettede': ('henrette',),
'henrettende': ('henrette',),
'henrivende': ('henrivende',),
'henrykka': ('henrykke',),
'henrykket': ('henrykke',),
'henrykt': ('henrykke',),
'henrykka': ('henrykke',),
'henrykket': ('henrykke',),
'henrykt': ('henrykke',),
'henrykka': ('henrykke',),
'henrykkete': ('henrykke',),
'henrykkede': ('henrykke',),
'henrykte': ('henrykke',),
'henrykka': ('henrykke',),
'henrykkete': ('henrykke',),
'henrykkede': ('henrykke',),
'henrykte': ('henrykke',),
'henrykkende': ('henrykke',),
'henrykt': ('henrykt',),
'henrykte': ('henrykt',),
'henrykt': ('henrykt',),
'hensatt': ('hensette',),
'hensatte': ('hensette',),
'hensettende': ('hensette',),
'hensiktsmessig': ('hensiktsmessig',),
'hensiktsmessige': ('hensiktsmessig',),
'hensiktsmessig': ('hensiktsmessig',),
'hensiktssvarende': ('hensiktssvarende',),
'henskutt': ('henskyte',),
'henskutte': ('henskyte',),
'henskytende': ('henskyte',),
'henslengt': ('henslengt',),
'henslengte': ('henslengt',),
'henslengt': ('henslengt',),
'henslept': ('henslepe',),
'henslepte': ('henslepe',),
'henslepende': ('henslepe',),
'henspilt': ('henspille',),
'henspilte': ('henspille',),
'henspillende': ('henspille',),
'henstilt': ('henstille',),
'henstilte': ('henstille',),
'henstillende': ('henstille',),
'henstrakt': ('henstrakt',),
'henstrakte': ('henstrakt',),
'henstrakt': ('henstrakt',),
'hensynsfull': ('hensynsfull',),
'hensynsfulle': ('hensynsfull',),
'hensynsfullt': ('hensynsfull',),
'hensynslaus': ('hensynslaus',),
'hensynslause': ('hensynslaus',),
'hensynslaust': ('hensynslaus',),
'hensynsløs': ('hensynsløs',),
'hensynsløse': ('hensynsløs',),
'hensynsløst': ('hensynsløs',),
'henta': ('hente',),
'hentet': ('hente',),
'henta': ('hente',),
'hentet': ('hente',),
'henta': ('hente',),
'hentete': ('hente',),
'hentede': ('hente',),
'henta': ('hente',),
'hentete': ('hente',),
'hentede': ('hente',),
'hentende': ('hente',),
'hentyda': ('hentyde',),
'hentydet': ('hentyde',),
'hentyda': ('hentyde',),
'hentydet': ('hentyde',),
'hentyda': ('hentyde',),
'hentydete': ('hentyde',),
'hentydede': ('hentyde',),
'hentyda': ('hentyde',),
'hentydete': ('hentyde',),
'hentydede': ('hentyde',),
'hentydende': ('hentyde',),
'henvendt': ('henvende',),
'henvendte': ('henvende',),
'henvendende': ('henvende',),
'henvist': ('henvise',),
'henviste': ('henvise',),
'henvisende': ('henvise',),
'heppa': ('heppe',),
'heppet': ('heppe',),
'heppa': ('heppe',),
'heppet': ('heppe',),
'heppa': ('heppe',),
'heppete': ('heppe',),
'heppede': ('heppe',),
'heppa': ('heppe',),
'heppete': ('heppe',),
'heppede': ('heppe',),
'heppende': ('heppe',),
'heppen': ('heppen',),
'hepne': ('heppen',),
'heppent': ('heppen',),
'heraldisk': ('heraldisk',),
'heraldiske': ('heraldisk',),
'heraldisk': ('heraldisk',),
'herda': ('herde',),
'herdet': ('herde',),
'herda': ('herde',),
'herdet': ('herde',),
'herda': ('herde',),
'herdete': ('herde',),
'herdede': ('herde',),
'herda': ('herde',),
'herdete': ('herde',),
'herdede': ('herde',),
'herdende': ('herde',),
'herdebrei': ('herdebrei',),
'herdebreie': ('herdebrei',),
'herdebreit': ('herdebrei',),
'herdig': ('herdig',),
'herdige': ('herdig',),
'herdig': ('herdig',),
'herdna': ('herdne',),
'herdnet': ('herdne',),
'herdna': ('herdne',),
'herdnet': ('herdne',),
'herdna': ('herdne',),
'herdnete': ('herdne',),
'herdnede': ('herdne',),
'herdnete': ('herdne',),
'herdnede': ('herdne',),
'herdna': ('herdne',),
'herdnete': ('herdne',),
'herdnede': ('herdne',),
'herdnete': ('herdne',),
'herdnede': ('herdne',),
'herdnende': ('herdne',),
'hereditær': ('hereditær',),
'hereditære': ('hereditær',),
'hereditært': ('hereditær',),
'heretisk': ('heretisk',),
'heretiske': ('heretisk',),
'heretisk': ('heretisk',),
'herja': ('herje',),
'herjet': ('herje',),
'herja': ('herje',),
'herjet': ('herje',),
'herja': ('herje',),
'herjete': ('herje',),
'herjede': ('herje',),
'herja': ('herje',),
'herjete': ('herje',),
'herjede': ('herje',),
'herjende': ('herje',),
'herkulisk': ('herkulisk',),
'herkuliske': ('herkulisk',),
'herkulisk': ('herkulisk',),
'herlig': ('herlig',),
'herlige': ('herlig',),
'herlig': ('herlig',),
'herligere': ('herlig',),
'herligst': ('herlig',),
'herligste': ('herlig',),
'herliggjort': ('herliggjøre',),
'herliggjorte': ('herliggjøre',),
'herliggjørende': ('herliggjøre',),
'hermafrodittisk': ('hermafrodittisk',),
'hermafrodittiske': ('hermafrodittisk',),
'hermafrodittisk': ('hermafrodittisk',),
'herma': ('herme',),
'hermet': ('herme',),
'hermt': ('herme',),
'herma': ('herme',),
'hermet': ('herme',),
'hermt': ('herme',),
'herma': ('herme',),
'hermete': ('herme',),
'hermede': ('herme',),
'hermte': ('herme',),
'herma': ('herme',),
'hermete': ('herme',),
'hermede': ('herme',),
'hermte': ('herme',),
'hermende': ('herme',),
'hermeneutisk': ('hermeneutisk',),
'hermeneutiske': ('hermeneutisk',),
'hermeneutisk': ('hermeneutisk',),
'hermetisert': ('hermetisere',),
'hermetiserte': ('hermetisere',),
'hermetiserende': ('hermetisere',),
'hermetisk': ('hermetisk',),
'hermetiske': ('hermetisk',),
'hermetisk': ('hermetisk',),
'heroisert': ('heroisere',),
'heroiserte': ('heroisere',),
'heroiserende': ('heroisere',),
'heroisk': ('heroisk',),
'heroiske': ('heroisk',),
'heroisk': ('heroisk',),
'herostratisk': ('herostratisk',),
'herostratiske': ('herostratisk',),
'herostratisk': ('herostratisk',),
'herrelaus': ('herrelaus',),
'herrelause': ('herrelaus',),
'herrelaust': ('herrelaus',),
'herreløs': ('herreløs',),
'herreløse': ('herreløs',),
'herreløst': ('herreløs',),
'herrnhutisk': ('herrnhutisk',),
'herrnhutiske': ('herrnhutisk',),
'herrnhutisk': ('herrnhutisk',),
'hersa': ('herse',),
'herset': ('herse',),
'hersa': ('herse',),
'herset': ('herse',),
'hersa': ('herse',),
'hersete': ('herse',),
'hersede': ('herse',),
'hersa': ('herse',),
'hersete': ('herse',),
'hersede': ('herse',),
'hersende': ('herse',),
'herskapelig': ('herskapelig',),
'herskapelige': ('herskapelig',),
'herskapelig': ('herskapelig',),
'herska': ('herske',),
'hersket': ('herske',),
'herska': ('herske',),
'hersket': ('herske',),
'herska': ('herske',),
'herskete': ('herske',),
'herskede': ('herske',),
'herska': ('herske',),
'herskete': ('herske',),
'herskede': ('herske',),
'herskende': ('herske',),
'herskesjuk': ('herskesjuk',),
'herskesjuke': ('herskesjuk',),
'herskesjukt': ('herskesjuk',),
'herskesyk': ('herskesyk',),
'herskesyke': ('herskesyk',),
'herskesykt': ('herskesyk',),
'herværende': ('herværende',),
'hes': ('hes',),
'hese': ('hes',),
'hest': ('hes',),
'hesere': ('hes',),
'hesest': ('hes',),
'heseste': ('hes',),
'heseblesende': ('heseblesende',),
'hesja': ('hesje',),
'hesjet': ('hesje',),
'hesja': ('hesje',),
'hesjet': ('hesje',),
'hesja': ('hesje',),
'hesjete': ('hesje',),
'hesjede': ('hesje',),
'hesja': ('hesje',),
'hesjete': ('hesje',),
'hesjede': ('hesje',),
'hesjende': ('hesje',),
'heslig': ('heslig',),
'heslige': ('heslig',),
'heslig': ('heslig',),
'hesligere': ('heslig',),
'hesligst': ('heslig',),
'hesligste': ('heslig',),
'hespa': ('hespe',),
'hespet': ('hespe',),
'hespa': ('hespe',),
'hespet': ('hespe',),
'hespa': ('hespe',),
'hespete': ('hespe',),
'hespede': ('hespe',),
'hespa': ('hespe',),
'hespete': ('hespe',),
'hespede': ('hespe',),
'hespende': ('hespe',),
'hespla': ('hesple',),
'hesplet': ('hesple',),
'hespla': ('hesple',),
'hesplet': ('hesple',),
'hespla': ('hesple',),
'hesplete': ('hesple',),
'hesplede': ('hesple',),
'hesplete': ('hesple',),
'hesplede': ('hesple',),
'hespla': ('hesple',),
'hesplete': ('hesple',),
'hesplede': ('hesple',),
'hesplete': ('hesple',),
'hesplede': ('hesple',),
'hesplende': ('hesple',),
'hestedum': ('hestedum',),
'hestedumme': ('hestedum',),
'hestedumt': ('hestedum',),
'hestegal': ('hestegal',),
'hestegale': ('hestegal',),
'hestegalt': ('hestegal',),
'hestehandla': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandlete': ('hestehandle',),
'hestehandlede': ('hestehandle',),
'hestehandlete': ('hestehandle',),
'hestehandlede': ('hestehandle',),
'hestehandla': ('hestehandle',),
'hestehandlete': ('hestehandle',),
'hestehandlede': ('hestehandle',),
'hestehandlete': ('hestehandle',),
'hestehandlede': ('hestehandle',),
'hestehandlende': ('hestehandle',),
'hestgal': ('hestgal',),
'hestgale': ('hestgal',),
'hestgalt': ('hestgal',),
'het': ('het',),
'hete': ('het',),
'hett': ('het',),
'hetere': ('het',),
'hetest': ('het',),
'heteste': ('het',),
'heta': ('hete',),
'hetet': ('hete',),
'heta': ('hete',),
'hetet': ('hete',),
'heta': ('hete',),
'hetete': ('hete',),
'hetede': ('hete',),
'heta': ('hete',),
'hetete': ('hete',),
'hetede': ('hete',),
'hetende': ('hete',),
'hett': ('hete',),
'hette': ('hete',),
'hetende': ('hete',),
'heterodoks': ('heterodoks',),
'heterodokse': ('heterodoks',),
'heterodokst': ('heterodoks',),
'heterofil': ('heterofil',),
'heterofile': ('heterofil',),
'heterofilt': ('heterofil',),
'heterogen': ('heterogen',),
'heterogene': ('heterogen',),
'heterogent': ('heterogen',),
'heteromorf': ('heteromorf',),
'heteromorfe': ('heteromorf',),
'heteromorft': ('heteromorf',),
'heteroseksuell': ('heteroseksuell',),
'heteroseksuelle': ('heteroseksuell',),
'heteroseksuelt': ('heteroseksuell',),
'hetna': ('hetne',),
'hetnet': ('hetne',),
'hetna': ('hetne',),
'hetnet': ('hetne',),
'hetna': ('hetne',),
'hetnete': ('hetne',),
'hetnede': ('hetne',),
'hetnete': ('hetne',),
'hetnede': ('hetne',),
'hetna': ('hetne',),
'hetnete': ('hetne',),
'hetnede': ('hetne',),
'hetnete': ('hetne',),
'hetnede': ('hetne',),
'hetnende': ('hetne',),
'hetsa': ('hetse',),
'hetset': ('hetse',),
'hetsa': ('hetse',),
'hetset': ('hetse',),
'hetsa': ('hetse',),
'hetsete': ('hetse',),
'hetsede': ('hetse',),
'hetsa': ('hetse',),
'hetsete': ('hetse',),
'hetsede': ('hetse',),
'hetsende': ('hetse',),
'hettittisk': ('hettittisk',),
'hettittiske': ('hettittisk',),
'hettittisk': ('hettittisk',),
'heuristisk': ('heuristisk',),
'heuristiske': ('heuristisk',),
'heuristisk': ('heuristisk',),
'hevbar': ('hevbar',),
'hevbare': ('hevbar',),
'hevbart': ('hevbar',),
'hevda': ('hevde',),
'hevdet': ('hevde',),
'hevda': ('hevde',),
'hevdet': ('hevde',),
'hevda': ('hevde',),
'hevdete': ('hevde',),
'hevdede': ('hevde',),
'hevda': ('hevde',),
'hevdete': ('hevde',),
'hevdede': ('hevde',),
'hevdende': ('hevde',),
'hevdvunnen': ('hevdvunnen',),
'hevdvunne': ('hevdvunnen',),
'hevdvunnet': ('hevdvunnen',),
'hevdvunnet': ('hevdvunnet',),
'hevdvunne': ('hevdvunnet',),
'hevdvunnet': ('hevdvunnet',),
'heva': ('heve',),
'hevet': ('heve',),
'hevd': ('heve',),
'heva': ('heve',),
'hevet': ('heve',),
'hevd': ('heve',),
'heva': ('heve',),
'hevete': ('heve',),
'hevede': ('heve',),
'hevde': ('heve',),
'heva': ('heve',),
'hevete': ('heve',),
'hevede': ('heve',),
'hevde': ('heve',),
'hevende': ('heve',),
'hevla': ('hevle',),
'hevlet': ('hevle',),
'hevla': ('hevle',),
'hevlet': ('hevle',),
'hevla': ('hevle',),
'hevlete': ('hevle',),
'hevlede': ('hevle',),
'hevlete': ('hevle',),
'hevlede': ('hevle',),
'hevla': ('hevle',),
'hevlete': ('hevle',),
'hevlede': ('hevle',),
'hevlete': ('hevle',),
'hevlede': ('hevle',),
'hevlende': ('hevle',),
'hevna': ('hevne',),
'hevnet': ('hevne',),
'hevna': ('hevne',),
'hevnet': ('hevne',),
'hevna': ('hevne',),
'hevnete': ('hevne',),
'hevnede': ('hevne',),
'hevna': ('hevne',),
'hevnete': ('hevne',),
'hevnede': ('hevne',),
'hevnende': ('hevne',),
'hevngjerrig': ('hevngjerrig',),
'hevngjerrige': ('hevngjerrig',),
'hevngjerrig': ('hevngjerrig',),
'hia': ('hie',),
'hiet': ('hie',),
'hia': ('hie',),
'hiet': ('hie',),
'hia': ('hie',),
'hiete': ('hie',),
'hiede': ('hie',),
'hia': ('hie',),
'hiete': ('hie',),
'hiede': ('hie',),
'hiende': ('hie',),
'hierarkisk': ('hierarkisk',),
'hierarkiske': ('hierarkisk',),
'hierarkisk': ('hierarkisk',),
'hieratisk': ('hieratisk',),
'hieratiske': ('hieratisk',),
'hieratisk': ('hieratisk',),
'hieroglyfisk': ('hieroglyfisk',),
'hieroglyfiske': ('hieroglyfisk',),
'hieroglyfisk': ('hieroglyfisk',),
'higa': ('hige',),
'higet': ('hige',),
'higa': ('hige',),
'higet': ('hige',),
'higa': ('hige',),
'higete': ('hige',),
'higede': ('hige',),
'higa': ('hige',),
'higete': ('hige',),
'higede': ('hige',),
'higende': ('hige',),
'hikka': ('hikke',),
'hikket': ('hikke',),
'hikka': ('hikke',),
'hikket': ('hikke',),
'hikka': ('hikke',),
'hikkete': ('hikke',),
'hikkede': ('hikke',),
'hikka': ('hikke',),
'hikkete': ('hikke',),
'hikkede': ('hikke',),
'hikkende': ('hikke',),
'hiksta': ('hikste',),
'hikstet': ('hikste',),
'hiksta': ('hikste',),
'hikstet': ('hikste',),
'hiksta': ('hikste',),
'hikstete': ('hikste',),
'hikstede': ('hikste',),
'hiksta': ('hikste',),
'hikstete': ('hikste',),
'hikstede': ('hikste',),
'hikstende': ('hikste',),
'hikstegrått': ('hikstegråte',),
'hikstegråtte': ('hikstegråte',),
'hikstegråtende': ('hikstegråte',),
'hilda': ('hilde',),
'hildet': ('hilde',),
'hilda': ('hilde',),
'hildet': ('hilde',),
'hilda': ('hilde',),
'hildete': ('hilde',),
'hildede': ('hilde',),
'hilda': ('hilde',),
'hildete': ('hilde',),
'hildede': ('hilde',),
'hildende': ('hilde',),
'hildra': ('hildre',),
'hildret': ('hildre',),
'hildra': ('hildre',),
'hildret': ('hildre',),
'hildra': ('hildre',),
'hildrete': ('hildre',),
'hildrede': ('hildre',),
'hildrete': ('hildre',),
'hildrede': ('hildre',),
'hildra': ('hildre',),
'hildrete': ('hildre',),
'hildrede': ('hildre',),
'hildrete': ('hildre',),
'hildrede': ('hildre',),
'hildrende': ('hildre',),
'hilst': ('hilse',),
'hilste': ('hilse',),
'hilsende': ('hilse',),
'himla': ('himle',),
'himlet': ('himle',),
'himla': ('himle',),
'himlet': ('himle',),
'himla': ('himle',),
'himlete': ('himle',),
'himlede': ('himle',),
'himlete': ('himle',),
'himlede': ('himle',),
'himla': ('himle',),
'himlete': ('himle',),
'himlede': ('himle',),
'himlete': ('himle',),
'himlede': ('himle',),
'himlende': ('himle',),
'himmelblå': ('himmelblå',),
'himmelblåe': ('himmelblå',),
'himmelblå': ('himmelblå',),
'himmelblåe': ('himmelblå',),
'himmelblå': ('himmelblå',),
'himmelblått': ('himmelblå',),
'himmelfallen': ('himmelfallen',),
'himmelfalne': ('himmelfallen',),
'himmelfallent': ('himmelfallen',),
'himmelhenrykt': ('himmelhenrykt',),
'himmelhenrykte': ('himmelhenrykt',),
'himmelhenrykt': ('himmelhenrykt',),
'himmelhøg': ('himmelhøg',),
'himmelhøge': ('himmelhøg',),
'himmelhøgt': ('himmelhøg',),
'himmelhøy': ('himmelhøy',),
'himmelhøye': ('himmelhøy',),
'himmelhøyt': ('himmelhøy',),
'himmelropende': ('himmelropende',),
'himmelsk': ('himmelsk',),
'himmelske': ('himmelsk',),
'himmelsk': ('himmelsk',),
'himmelstormende': ('himmelstormende',),
'himmelvid': ('himmelvid',),
'himmelvide': ('himmelvid',),
'himmelvidt': ('himmelvid',),
'hindra': ('hindre',),
'hindret': ('hindre',),
'hindra': ('hindre',),
'hindret': ('hindre',),
'hindra': ('hindre',),
'hindrete': ('hindre',),
'hindrede': ('hindre',),
'hindrete': ('hindre',),
'hindrede': ('hindre',),
'hindra': ('hindre',),
'hindrete': ('hindre',),
'hindrede': ('hindre',),
'hindrete': ('hindre',),
'hindrede': ('hindre',),
'hindrende': ('hindre',),
'hinduisk': ('hinduisk',),
'hinduiske': ('hinduisk',),
'hinduisk': ('hinduisk',),
'hinduistisk': ('hinduistisk',),
'hinduistiske': ('hinduistisk',),
'hinduistisk': ('hinduistisk',),
'hindustansk': ('hindustansk',),
'hindustanske': ('hindustansk',),
'hindustansk': ('hindustansk',),
'hingstegal': ('hingstegal',),
'hingstegale': ('hingstegal',),
'hingstegalt': ('hingstegal',),
'hingstgal': ('hingstgal',),
'hingstgale': ('hingstgal',),
'hingstgalt': ('hingstgal',),
'hinka': ('hinke',),
'hinket': ('hinke',),
'hinka': ('hinke',),
'hinket': ('hinke',),
'hinka': ('hinke',),
'hinkete': ('hinke',),
'hinkede': ('hinke',),
'hinka': ('hinke',),
'hinkete': ('hinke',),
'hinkede': ('hinke',),
'hinkende': ('hinke',),
'hinnet': ('hinnet',),
'hinnete': ('hinnet',),
'hinnet': ('hinnet',),
'hinnete': ('hinnete',),
'hinsidig': ('hinsidig',),
'hinsidige': ('hinsidig',),
'hinsidig': ('hinsidig',),
'hipa': ('hipe',),
'hipet': ('hipe',),
'hipt': ('hipe',),
'hipa': ('hipe',),
'hipet': ('hipe',),
'hipt': ('hipe',),
'hipa': ('hipe',),
'hipete': ('hipe',),
'hipede': ('hipe',),
'hipte': ('hipe',),
'hipa': ('hipe',),
'hipete': ('hipe',),
'hipede': ('hipe',),
'hipte': ('hipe',),
'hipende': ('hipe',),
'hipp': ('hipp',),
'hippe': ('hipp',),
'hipt': ('hipp',),
'hippere': ('hipp',),
'hippest': ('hipp',),
'hippeste': ('hipp',),
'hippen': ('hippen',),
'hipne': ('hippen',),
'hippent': ('hippen',),
'hirt': ('hire',),
'hirte': ('hire',),
'hirende': ('hire',),
'hiren': ('hiren',),
'hirne': ('hiren',),
'hirent': ('hiren',),
'hissa': ('hisse',),
'hisset': ('hisse',),
'hissa': ('hisse',),
'hisset': ('hisse',),
'hissa': ('hisse',),
'hissete': ('hisse',),
'hissede': ('hisse',),
'hissa': ('hisse',),
'hissete': ('hisse',),
'hissede': ('hisse',),
'hissende': ('hisse',),
'hissig': ('hissig',),
'hissige': ('hissig',),
'hissig': ('hissig',),
'hissigere': ('hissig',),
'hissigst': ('hissig',),
'hissigste': ('hissig',),
'historiografisk': ('historiografisk',),
'historiografiske': ('historiografisk',),
'historiografisk': ('historiografisk',),
'historisk': ('historisk',),
'historiske': ('historisk',),
'historisk': ('historisk',),
'hithørende': ('hithørende',),
'hitre': ('hitre',),
'hitterst': ('hitre',),
'hitterste': ('hitre',),
'hitsatt': ('hitsette',),
'hitsatte': ('hitsette',),
'hitsettende': ('hitsette',),
'hitta': ('hitte',),
'hittet': ('hitte',),
'hitta': ('hitte',),
'hittet': ('hitte',),
'hitta': ('hitte',),
'hittete': ('hitte',),
'hittede': ('hitte',),
'hitta': ('hitte',),
'hittete': ('hitte',),
'hittede': ('hitte',),
'hittende': ('hitte',),
'hitterst': ('hitterst',),
'hitterste': ('hitterst',),
'hitterst': ('hitterst',),
'hivd': ('hive',),
'hivde': ('hive',),
'hivende': ('hive',),
'hjulpet': ('hjelpe',),
'hjulpen': ('hjelpe',),
'hjulpne': ('hjelpe',),
'hjelpende': ('hjelpe',),
'hjelpelaus': ('hjelpelaus',),
'hjelpelause': ('hjelpelaus',),
'hjelpelaust': ('hjelpelaus',),
'hjelpeløs': ('hjelpeløs',),
'hjelpeløse': ('hjelpeløs',),
'hjelpeløst': ('hjelpeløs',),
'hjelpetrengende': ('hjelpetrengende',),
'hjelpsom': ('hjelpsom',),
'hjelpsomme': ('hjelpsom',),
'hjelpsomt': ('hjelpsom',),
'hjelpsommere': ('hjelpsom',),
'hjelpsomst': ('hjelpsom',),
'hjelpsomste': ('hjelpsom',),
'hjemfalt': ('hjemfalle',),
'hjemfalte': ('hjemfalle',),
'hjemfallende': ('hjemfalle',),
'hjemfallen': ('hjemfallen',),
'hjemfalne': ('hjemfallen',),
'hjemfallent': ('hjemfallen',),
'hjemfesta': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfestete': ('hjemfeste',),
'hjemfestede': ('hjemfeste',),
'hjemfesta': ('hjemfeste',),
'hjemfestete': ('hjemfeste',),
'hjemfestede': ('hjemfeste',),
'hjemfestende': ('hjemfeste',),
'hjemført': ('hjemføre',),
'hjemførte': ('hjemføre',),
'hjemførende': ('hjemføre',),
'hjemkalt': ('hjemkalle',),
'hjemkalte': ('hjemkalle',),
'hjemkallende': ('hjemkalle',),
'hjemkommet': ('hjemkommet',),
'hjemkomne': ('hjemkommet',),
'hjemkommet': ('hjemkommet',),
'hjemlaus': ('hjemlaus',),
'hjemlause': ('hjemlaus',),
'hjemlaust': ('hjemlaus',),
'hjemla': ('hjemle',),
'hjemlet': ('hjemle',),
'hjemla': ('hjemle',),
'hjemlet': ('hjemle',),
'hjemla': ('hjemle',),
'hjemlete': ('hjemle',),
'hjemlede': ('hjemle',),
'hjemlete': ('hjemle',),
'hjemlede': ('hjemle',),
'hjemla': ('hjemle',),
'hjemlete': ('hjemle',),
'hjemlede': ('hjemle',),
'hjemlete': ('hjemle',),
'hjemlede': ('hjemle',),
'hjemlende': ('hjemle',),
'hjemlig': ('hjemlig',),
'hjemlige': ('hjemlig',),
'hjemlig': ('hjemlig',),
'hjemløs': ('hjemløs',),
'hjemløse': ('hjemløs',),
'hjemløst': ('hjemløs',),
'hjemmearbeidende': ('hjemmearbeidende',),
'hjemmeavla': ('hjemmeavla',),
'hjemmeavlet': ('hjemmeavlet',),
'hjemmeavlete': ('hjemmeavlet',),
'hjemmeavlede': ('hjemmeavlet',),
'hjemmeavlete': ('hjemmeavlet',),
'hjemmeavlede': ('hjemmeavlet',),
'hjemmeavlet': ('hjemmeavlet',),
'hjemmegjort': ('hjemmegjort',),
'hjemmegjorte': ('hjemmegjort',),
'hjemmegjort': ('hjemmegjort',),
'hjemmehørende': ('hjemmehørende',),
'hjemmekjent': ('hjemmekjent',),
'hjemmekjente': ('hjemmekjent',),
'hjemmekjent': ('hjemmekjent',),
'hjemmekjær': ('hjemmekjær',),
'hjemmekjære': ('hjemmekjær',),
'hjemmekjært': ('hjemmekjær',),
'hjemmekoselig': ('hjemmekoselig',),
'hjemmekoselige': ('hjemmekoselig',),
'hjemmekoselig': ('hjemmekoselig',),
'hjemmelaga': ('hjemmelaga',),
'hjemmelagd': ('hjemmelagd',),
'hjemmelagde': ('hjemmelagd',),
'hjemmelagd': ('hjemmelagd',),
'hjemmelaget': ('hjemmelaget',),
'hjemmelagete': ('hjemmelaget',),
'hjemmelagede': ('hjemmelaget',),
'hjemmelagete': ('hjemmelaget',),
'hjemmelagede': ('hjemmelaget',),
'hjemmelaget': ('hjemmelaget',),
'hjemmestrikka': ('hjemmestrikka',),
'hjemmestrikket': ('hjemmestrikket',),
'hjemmestrikkete': ('hjemmestrikket',),
'hjemmestrikkede': ('hjemmestrikket',),
'hjemmestrikkete': ('hjemmestrikket',),
'hjemmestrikkede': ('hjemmestrikket',),
'hjemmestrikket': ('hjemmestrikket',),
'hjemmevant': ('hjemmevant',),
'hjemmevante': ('hjemmevant',),
'hjemmevant': ('hjemmevant',),
'hjemmeværende': ('hjemmeværende',),
'hjemsendt': ('hjemsende',),
'hjemsendte': ('hjemsende',),
'hjemsendende': ('hjemsende',),
'hjemstavnsberettiga': ('hjemstavnsberettiga',),
'hjemstavnsberettiget': ('hjemstavnsberettiget',),
'hjemstavnsberettigete': ('hjemstavnsberettiget',),
'hjemstavnsberettigede': ('hjemstavnsberettiget',),
'hjemstavnsberettigete': ('hjemstavnsberettiget',),
'hjemstavnsberettigede': ('hjemstavnsberettiget',),
'hjemstavnsberettiget': ('hjemstavnsberettiget',),
'hjemsøkt': ('hjemsøke',),
'hjemsøkte': ('hjemsøke',),
'hjemsøkende': ('hjemsøke',),
'hjemvendt': ('hjemvendt',),
'hjemvendte': ('hjemvendt',),
'hjemvendt': ('hjemvendt',),
'hjernedød': ('hjernedød',),
'hjernedøde': ('hjernedød',),
'hjernedødt': ('hjernedød',),
'hjernevaska': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevaskete': ('hjernevaske',),
'hjernevaskede': ('hjernevaske',),
'hjernevaska': ('hjernevaske',),
'hjernevaskete': ('hjernevaske',),
'hjernevaskede': ('hjernevaske',),
'hjernevaskende': ('hjernevaske',),
'hjerta': ('hjerta',),
'hjerteforma': ('hjerteforma',),
'hjerteformet': ('hjerteformet',),
'hjerteformete': ('hjerteformet',),
'hjerteformede': ('hjerteformet',),
'hjerteformete': ('hjerteformet',),
'hjerteformede': ('hjerteformet',),
'hjerteformet': ('hjerteformet',),
'hjertegod': ('hjertegod',),
'hjertegode': ('hjertegod',),
'hjertegodt': ('hjertegod',),
'hjertelaus': ('hjertelaus',),
'hjertelause': ('hjertelaus',),
'hjertelaust': ('hjertelaus',),
'hjertelig': ('hjertelig',),
'hjertelige': ('hjertelig',),
'hjertelig': ('hjertelig',),
'hjerteligere': ('hjertelig',),
'hjerteligst': ('hjertelig',),
'hjerteligste': ('hjertelig',),
'hjerteløs': ('hjerteløs',),
'hjerteløse': ('hjerteløs',),
'hjerteløst': ('hjerteløs',),
'hjertens': ('hjertens',),
'hjerterå': ('hjerterå',),
'hjerteråe': ('hjerterå',),
'hjerterå': ('hjerterå',),
'hjerteråe': ('hjerterå',),
'hjerterå': ('hjerterå',),
'hjerterått': ('hjerterå',),
'hjerteskjærende': ('hjerteskjærende',),
'hjertevarm': ('hjertevarm',),
'hjertevarme': ('hjertevarm',),
'hjertevarmt': ('hjertevarm',),
'hjonslig': ('hjonslig',),
'hjonslige': ('hjonslig',),
'hjonslig': ('hjonslig',),
'hjulbeint': ('hjulbeint',),
'hjulbeinte': ('hjulbeint',),
'hjulbeint': ('hjulbeint',),
'hjulbent': ('hjulbent',),
'hjulbente': ('hjulbent',),
'hjulbent': ('hjulbent',),
'hjulpen': ('hjulpen',),
'hjulpne': ('hjulpen',),
'hjulpent': ('hjulpen',),
'hodegal': ('hodegal',),
'hodegale': ('hodegal',),
'hodegalt': ('hodegal',),
'hodegalen': ('hodegalen',),
'hodegalne': ('hodegalen',),
'hodegalent': ('hodegalen',),
'hoderystende': ('hoderystende',),
'hofferda': ('hofferde',),
'hofferdet': ('hofferde',),
'hofferda': ('hofferde',),
'hofferdet': ('hofferde',),
'hofferda': ('hofferde',),
'hofferdete': ('hofferde',),
'hofferdede': ('hofferde',),
'hofferda': ('hofferde',),
'hofferdete': ('hofferde',),
'hofferdede': ('hofferde',),
'hofferdende': ('hofferde',),
'hofferdig': ('hofferdig',),
'hofferdige': ('hofferdig',),
'hofferdig': ('hofferdig',),
'hoggbratt': ('hoggbratt',),
'hoggbratte': ('hoggbratt',),
'hoggbratt': ('hoggbratt',),
'hogstmoden': ('hogstmoden',),
'hogstmodne': ('hogstmoden',),
'hogstmodent': ('hogstmoden',),
'hoia': ('hoie',),
'hoiet': ('hoie',),
'hoia': ('hoie',),
'hoiet': ('hoie',),
'hoia': ('hoie',),
'hoiete': ('hoie',),
'hoiede': ('hoie',),
'hoia': ('hoie',),
'hoiete': ('hoie',),
'hoiede': ('hoie',),
'hoiende': ('hoie',),
'hol': ('hol',),
'hole': ('hol',),
'holt': ('hol',),
'holere': ('hol',),
'holest': ('hol',),
'holeste': ('hol',),
'holdbar': ('holdbar',),
'holdbare': ('holdbar',),
'holdbart': ('holdbar',),
'holdt': ('holde',),
'holdte': ('holde',),
'holdende': ('holde',),
'holden': ('holden',),
'holdne': ('holden',),
'holdent': ('holden',),
'holdningslaus': ('holdningslaus',),
'holdningslause': ('holdningslaus',),
'holdningslaust': ('holdningslaus',),
'holdningsløs': ('holdningsløs',),
'holdningsløse': ('holdningsløs',),
'holdningsløst': ('holdningsløs',),
'holdningsskapende': ('holdningsskapende',),
'holt': ('hole',),
'holte': ('hole',),
'holende': ('hole',),
'holet': ('holet',),
'holete': ('holet',),
'holet': ('holet',),
'holete': ('holete',),
'holka': ('holke',),
'holket': ('holke',),
'holka': ('holke',),
'holket': ('holke',),
'holka': ('holke',),
'holkete': ('holke',),
'holkede': ('holke',),
'holka': ('holke',),
'holkete': ('holke',),
'holkede': ('holke',),
'holkende': ('holke',),
'holkinna': ('holkinna',),
'holkinnet': ('holkinnet',),
'holkinnete': ('holkinnet',),
'holkinnede': ('holkinnet',),
'holkinnete': ('holkinnet',),
'holkinnede': ('holkinnet',),
'holkinnet': ('holkinnet',),
'hollandsk': ('hollandsk',),
'hollandske': ('hollandsk',),
'hollandsk': ('hollandsk',),
'holna': ('holne',),
'holnet': ('holne',),
'holna': ('holne',),
'holnet': ('holne',),
'holna': ('holne',),
'holnete': ('holne',),
'holnede': ('holne',),
'holnete': ('holne',),
'holnede': ('holne',),
'holna': ('holne',),
'holnete': ('holne',),
'holnede': ('holne',),
'holnete': ('holne',),
'holnede': ('holne',),
'holnende': ('holne',),
'holograf': ('holograf',),
'holografe': ('holograf',),
'holograft': ('holograf',),
'holografisk': ('holografisk',),
'holografiske': ('holografisk',),
'holografisk': ('holografisk',),
'holsteinsk': ('holsteinsk',),
'holsteinske': ('holsteinsk',),
'holsteinsk': ('holsteinsk',),
'holøyd': ('holøyd',),
'holøyde': ('holøyd',),
'holøyd': ('holøyd',),
'homerisk': ('homerisk',),
'homeriske': ('homerisk',),
'homerisk': ('homerisk',),
'homiletisk': ('homiletisk',),
'homiletiske': ('homiletisk',),
'homiletisk': ('homiletisk',),
'homma': ('homme',),
'hommet': ('homme',),
'homma': ('homme',),
'hommet': ('homme',),
'homma': ('homme',),
'hommete': ('homme',),
'hommede': ('homme',),
'homma': ('homme',),
'hommete': ('homme',),
'hommede': ('homme',),
'hommende': ('homme',),
'homo': ('homo',),
'homofil': ('homofil',),
'homofile': ('homofil',),
'homofilt': ('homofil',),
'homofon': ('homofon',),
'homofone': ('homofon',),
'homofont': ('homofon',),
'homogen': ('homogen',),
'homogene': ('homogen',),
'homogent': ('homogen',),
'homogenisert': ('homogenisere',),
'homogeniserte': ('homogenisere',),
'homogeniserende': ('homogenisere',),
'homonym': ('homonym',),
'homonyme': ('homonym',),
'homonymt': ('homonym',),
'homoseksuell': ('homoseksuell',),
'homoseksuelle': ('homoseksuell',),
'homoseksuelt': ('homoseksuell',),
'homøopatisk': ('homøopatisk',),
'homøopatiske': ('homøopatisk',),
'homøopatisk': ('homøopatisk',),
'honduransk': ('honduransk',),
'honduranske': ('honduransk',),
'honduransk': ('honduransk',),
'honnett': ('honnett',),
'honnette': ('honnett',),
'honnett': ('honnett',),
'honningsøt': ('honningsøt',),
'honningsøte': ('honningsøt',),
'honningsøtt': ('honningsøt',),
'honorabel': ('honorabel',),
'honorable': ('honorabel',),
'honorabelt': ('honorabel',),
'honorert': ('honorere',),
'honorerte': ('honorere',),
'honorerende': ('honorere',),
'honorær': ('honorær',),
'honorære': ('honorær',),
'honorært': ('honorær',),
'hopa': ('hope',),
'hopet': ('hope',),
'hopa': ('hope',),
'hopet': ('hope',),
'hopa': ('hope',),
'hopete': ('hope',),
'hopede': ('hope',),
'hopa': ('hope',),
'hopete': ('hope',),
'hopede': ('hope',),
'hopende': ('hope',),
'hoppa': ('hoppe',),
'hoppet': ('hoppe',),
'hoppa': ('hoppe',),
'hoppet': ('hoppe',),
'hoppa': ('hoppe',),
'hoppete': ('hoppe',),
'hoppede': ('hoppe',),
'hoppa': ('hoppe',),
'hoppete': ('hoppe',),
'hoppede': ('hoppe',),
'hoppende': ('hoppe',),
'hora': ('hore',),
'horet': ('hore',),
'hort': ('hore',),
'hora': ('hore',),
'horet': ('hore',),
'hort': ('hore',),
'hora': ('hore',),
'horete': ('hore',),
'horede': ('hore',),
'horte': ('hore',),
'hora': ('hore',),
'horete': ('hore',),
'horede': ('hore',),
'horte': ('hore',),
'horende': ('hore',),
'horisontal': ('horisontal',),
'horisontale': ('horisontal',),
'horisontalt': ('horisontal',),
'horisontaldelt': ('horisontaldelt',),
'horisontaldelte': ('horisontaldelt',),
'horisontaldelt': ('horisontaldelt',),
'hormonal': ('hormonal',),
'hormonale': ('hormonal',),
'hormonalt': ('hormonal',),
'hormonell': ('hormonell',),
'hormonelle': ('hormonell',),
'hormonelt': ('hormonell',),
'hornet': ('hornet',),
'hornete': ('hornet',),
'hornet': ('hornet',),
'hornete': ('hornete',),
'horribel': ('horribel',),
'horrible': ('horribel',),
'horribelt': ('horribel',),
'horsa': ('horse',),
'horset': ('horse',),
'horsa': ('horse',),
'horset': ('horse',),
'horsa': ('horse',),
'horsete': ('horse',),
'horsede': ('horse',),
'horsa': ('horse',),
'horsete': ('horse',),
'horsede': ('horse',),
'horsende': ('horse',),
'hosliggende': ('hosliggende',),
'hospitalisert': ('hospitalisere',),
'hospitaliserte': ('hospitalisere',),
'hospitaliserende': ('hospitalisere',),
'hospitert': ('hospitere',),
'hospiterte': ('hospitere',),
'hospiterende': ('hospitere',),
'hosstående': ('hosstående',),
'hosta': ('hoste',),
'hostet': ('hoste',),
'hosta': ('hoste',),
'hostet': ('hoste',),
'hosta': ('hoste',),
'hostete': ('hoste',),
'hostede': ('hoste',),
'hosta': ('hoste',),
'hostete': ('hoste',),
'hostede': ('hoste',),
'hostende': ('hoste',),
'hota': ('hote',),
'hotet': ('hote',),
'hota': ('hote',),
'hotet': ('hote',),
'hota': ('hote',),
'hotete': ('hote',),
'hotede': ('hote',),
'hota': ('hote',),
'hotete': ('hote',),
'hotede': ('hote',),
'hotende': ('hote',),
'hottentottisk': ('hottentottisk',),
'hottentottiske': ('hottentottisk',),
'hottentottisk': ('hottentottisk',),
'hovedsakelig': ('hovedsakelig',),
'hovedsakelige': ('hovedsakelig',),
'hovedsakelig': ('hovedsakelig',),
'hoven': ('hoven',),
'hovne': ('hoven',),
'hovent': ('hoven',),
'hovert': ('hovere',),
'hoverte': ('hovere',),
'hoverende': ('hovere',),
'hovmesterert': ('hovmesterere',),
'hovmestererte': ('hovmesterere',),
'hovmestererende': ('hovmesterere',),
'hovmoda': ('hovmode',),
'hovmodet': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmodet': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmodete': ('hovmode',),
'hovmodede': ('hovmode',),
'hovmoda': ('hovmode',),
'hovmodete': ('hovmode',),
'hovmodede': ('hovmode',),
'hovmodende': ('hovmode',),
'hovmodig': ('hovmodig',),
'hovmodige': ('hovmodig',),
'hovmodig': ('hovmodig',),
'hovna': ('hovne',),
'hovnet': ('hovne',),
'hovna': ('hovne',),
'hovnet': ('hovne',),
'hovna': ('hovne',),
'hovnete': ('hovne',),
'hovnede': ('hovne',),
'hovnete': ('hovne',),
'hovnede': ('hovne',),
'hovna': ('hovne',),
'hovnete': ('hovne',),
'hovnede': ('hovne',),
'hovnete': ('hovne',),
'hovnede': ('hovne',),
'hovnende': ('hovne',),
'hudfletta': ('hudflette',),
'hudflettet': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflettet': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflettete': ('hudflette',),
'hudflettede': ('hudflette',),
'hudfletta': ('hudflette',),
'hudflettete': ('hudflette',),
'hudflettede': ('hudflette',),
'hudflettende': ('hudflette',),
'hudlaus': ('hudlaus',),
'hudlause': ('hudlaus',),
'hudlaust': ('hudlaus',),
'hudløs': ('hudløs',),
'hudløse': ('hudløs',),
'hudløst': ('hudløs',),
'hudstrøket': ('hudstryke',),
'hudstrøken': ('hudstryke',),
'hudstrøket': ('hudstryke',),
'hudstrøken': ('hudstryke',),
'hudstrøkne': ('hudstryke',),
'hudstrykende': ('hudstryke',),
'huegæren': ('huegæren',),
'huegærne': ('huegæren',),
'huegærent': ('huegæren',),
'hufsa': ('hufse',),
'hufset': ('hufse',),
'hufsa': ('hufse',),
'hufset': ('hufse',),
'hufsa': ('hufse',),
'hufsete': ('hufse',),
'hufsede': ('hufse',),
'hufsa': ('hufse',),
'hufsete': ('hufse',),
'hufsede': ('hufse',),
'hufsende': ('hufse',),
'huga': ('huga',),
'hugal': ('hugal',),
'hugale': ('hugal',),
'hugalt': ('hugal',),
'huga': ('huge',),
'huget': ('huge',),
'huga': ('huge',),
'huget': ('huge',),
'huga': ('huge',),
'hugete': ('huge',),
'hugede': ('huge',),
'huga': ('huge',),
'hugete': ('huge',),
'hugede': ('huge',),
'hugende': ('huge',),
'hugheil': ('hugheil',),
'hugheile': ('hugheil',),
'hugheilt': ('hugheil',),
'hugnadsam': ('hugnadsam',),
'hugnadsame': ('hugnadsam',),
'hugnadsamt': ('hugnadsam',),
'hugstmoden': ('hugstmoden',),
'hugstmodne': ('hugstmoden',),
'hugstmodent': ('hugstmoden',),
'hugsvala': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalt': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalt': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvalete': ('hugsvale',),
'hugsvalede': ('hugsvale',),
'hugsvalte': ('hugsvale',),
'hugsvala': ('hugsvale',),
'hugsvalete': ('hugsvale',),
'hugsvalede': ('hugsvale',),
'hugsvalte': ('hugsvale',),
'hugsvalende': ('hugsvale',),
'hugtatt': ('hugta',),
'hugtatte': ('hugta',),
'hugtakende': ('hugta',),
'hugæren': ('hugæren',),
'hugærne': ('hugæren',),
'hugærent': ('hugæren',),
'huia': ('huie',),
'huiet': ('huie',),
'huia': ('huie',),
'huiet': ('huie',),
'huia': ('huie',),
'huiete': ('huie',),
'huiede': ('huie',),
'huia': ('huie',),
'huiete': ('huie',),
'huiede': ('huie',),
'huiende': ('huie',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huka': ('huke',),
'hukete': ('huke',),
'hukede': ('huke',),
'hukte': ('huke',),
'huka': ('huke',),
'hukete': ('huke',),
'hukede': ('huke',),
'hukte': ('huke',),
'hukende': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huka': ('huke',),
'huket': ('huke',),
'hukt': ('huke',),
'huka': ('huke',),
'hukete': ('huke',),
'hukede': ('huke',),
'hukte': ('huke',),
'huka': ('huke',),
'hukete': ('huke',),
'hukede': ('huke',),
'hukte': ('huke',),
'hukende': ('huke',),
'hukra': ('hukre',),
'hukret': ('hukre',),
'hukra': ('hukre',),
'hukret': ('hukre',),
'hukra': ('hukre',),
'hukrete': ('hukre',),
'hukrede': ('hukre',),
'hukrete': ('hukre',),
'hukrede': ('hukre',),
'hukra': ('hukre',),
'hukrete': ('hukre',),
'hukrede': ('hukre',),
'hukrete': ('hukre',),
'hukrede': ('hukre',),
'hukrende': ('hukre',),
'huksittende': ('huksittende',),
'hul': ('hul',),
'hule': ('hul',),
'hult': ('hul',),
'hulere': ('hul',),
'hulest': ('hul',),
'huleste': ('hul',),
'hulbrysta': ('hulbrysta',),
'hulbrystet': ('hulbrystet',),
'hulbrystete': ('hulbrystet',),
'hulbrystede': ('hulbrystet',),
'hulbrystete': ('hulbrystet',),
'hulbrystede': ('hulbrystet',),
'hulbrystet': ('hulbrystet',),
'huldren': ('huldren',),
'huldrene': ('huldren',),
'huldrne': ('huldren',),
'huldrene': ('huldren',),
'huldrne': ('huldren',),
'huldrent': ('huldren',),
'hulet': ('hule',),
'hult': ('hule',),
'hulet': ('hule',),
'hult': ('hule',),
'hulete': ('hule',),
'hulede': ('hule',),
'hulte': ('hule',),
'hulete': ('hule',),
'hulede': ('hule',),
'hulte': ('hule',),
'hulende': ('hule',),
'hulka': ('hulke',),
'hulket': ('hulke',),
'hulka': ('hulke',),
'hulket': ('hulke',),
'hulka': ('hulke',),
'hulkete': ('hulke',),
'hulkede': ('hulke',),
'hulka': ('hulke',),
'hulkete': ('hulke',),
'hulkede': ('hulke',),
'hulkende': ('hulke',),
'hulkinna': ('hulkinna',),
'hulkinnet': ('hulkinnet',),
'hulkinnete': ('hulkinnet',),
'hulkinnede': ('hulkinnet',),
'hulkinnete': ('hulkinnet',),
'hulkinnede': ('hulkinnet',),
'hulkinnet': ('hulkinnet',),
'hull': ('hull',),
'hulle': ('hull',),
'hult': ('hull',),
'hulla': ('hulle',),
'hullet': ('hulle',),
'hulla': ('hulle',),
'hullet': ('hulle',),
'hulla': ('hulle',),
'hullete': ('hulle',),
'hullede': ('hulle',),
'hulla': ('hulle',),
'hullete': ('hulle',),
'hullede': ('hulle',),
'hullende': ('hulle',),
'hullet': ('hullet',),
'hullete': ('hullet',),
'hullet': ('hullet',),
'hullete': ('hullete',),
'huløyd': ('huløyd',),
'huløyde': ('huløyd',),
'huløyd': ('huløyd',),
'human': ('human',),
'humane': ('human',),
'humant': ('human',),
'humanetisk': ('humanetisk',),
'humanetiske': ('humanetisk',),
'humanetisk': ('humanetisk',),
'humanisert': ('humanisere',),
'humaniserte': ('humanisere',),
'humaniserende': ('humanisere',),
'humanistisk': ('humanistisk',),
'humanistiske': ('humanistisk',),
'humanistisk': ('humanistisk',),
'humanitær': ('humanitær',),
'humanitære': ('humanitær',),
'humanitært': ('humanitær',),
'humid': ('humid',),
'humide': ('humid',),
'humid': ('humid',),
'humoral': ('humoral',),
'humorale': ('humoral',),
'humoralt': ('humoral',),
'humoristisk': ('humoristisk',),
'humoristiske': ('humoristisk',),
'humoristisk': ('humoristisk',),
'humpa': ('humpe',),
'humpet': ('humpe',),
'humpa': ('humpe',),
'humpet': ('humpe',),
'humpa': ('humpe',),
'humpete': ('humpe',),
'humpede': ('humpe',),
'humpa': ('humpe',),
'humpete': ('humpe',),
'humpede': ('humpe',),
'humpende': ('humpe',),
'humpet': ('humpet',),
'humpete': ('humpet',),
'humpet': ('humpet',),
'humpete': ('humpete',),
'humra': ('humre',),
'humret': ('humre',),
'humra': ('humre',),
'humret': ('humre',),
'humra': ('humre',),
'humrete': ('humre',),
'humrede': ('humre',),
'humrete': ('humre',),
'humrede': ('humre',),
'humra': ('humre',),
'humrete': ('humre',),
'humrede': ('humre',),
'humrete': ('humre',),
'humrede': ('humre',),
'humrende': ('humre',),
'humørfylt': ('humørfylt',),
'humørfylte': ('humørfylt',),
'humørfylt': ('humørfylt',),
'humørsjuk': ('humørsjuk',),
'humørsjuke': ('humørsjuk',),
'humørsjukt': ('humørsjuk',),
'humørsyk': ('humørsyk',),
'humørsyke': ('humørsyk',),
'humørsykt': ('humørsyk',),
'hundekald': ('hundekald',),
'hundekalde': ('hundekald',),
'hundekaldt': ('hundekald',),
'hundgammal': ('hundgammal',),
'hundgamle': ('hundgammal',),
'hundgammalt': ('hundgammal',),
'hundgammel': ('hundgammel',),
'hundgamle': ('hundgammel',),
'hundgammelt': ('hundgammel',),
'hundjaga': ('hundjage',),
'hundjaget': ('hundjage',),
'hundjagd': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjaget': ('hundjage',),
'hundjagd': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjagete': ('hundjage',),
'hundjagede': ('hundjage',),
'hundjagde': ('hundjage',),
'hundjaga': ('hundjage',),
'hundjagete': ('hundjage',),
'hundjagede': ('hundjage',),
'hundjagde': ('hundjage',),
'hundjagende': ('hundjage',),
'hundrede': ('hundrede',),
'hundretalls': ('hundretalls',),
'hundreårig': ('hundreårig',),
'hundreårige': ('hundreårig',),
'hundreårig': ('hundreårig',),
'hundreårs': ('hundreårs',),
'hundsa': ('hundse',),
'hundset': ('hundse',),
'hundsa': ('hundse',),
'hundset': ('hundse',),
'hundsa': ('hundse',),
'hundsete': ('hundse',),
'hundsede': ('hundse',),
'hundsete': ('hundse',),
'hundsede': ('hundse',),
'hundsa': ('hundse',),
'hundsete': ('hundse',),
'hundsede': ('hundse',),
'hundsete': ('hundse',),
'hundsede': ('hundse',),
'hundsende': ('hundse',),
'hundsk': ('hundsk',),
'hundske': ('hundsk',),
'hundsk': ('hundsk',),
'hungerramma': ('hungerramma',),
'hungerrammet': ('hungerrammet',),
'hungerrammete': ('hungerrammet',),
'hungerrammede': ('hungerrammet',),
'hungerrammete': ('hungerrammet',),
'hungerrammede': ('hungerrammet',),
'hungerrammet': ('hungerrammet',),
'hungra': ('hungre',),
'hungret': ('hungre',),
'hungra': ('hungre',),
'hungret': ('hungre',),
'hungra': ('hungre',),
'hungrete': ('hungre',),
'hungrede': ('hungre',),
'hungrete': ('hungre',),
'hungrede': ('hungre',),
'hungra': ('hungre',),
'hungrete': ('hungre',),
'hungrede': ('hungre',),
'hungrete': ('hungre',),
'hungrede': ('hungre',),
'hungrende': ('hungre',),
'hungrig': ('hungrig',),
'hungrige': ('hungrig',),
'hungrig': ('hungrig',),
'hunisk': ('hunisk',),
'huniske': ('hunisk',),
'hunisk': ('hunisk',),
'hunlig': ('hunlig',),
'hunlige': ('hunlig',),
'hunlig': ('hunlig',),
'hunnlig': ('hunnlig',),
'hunnlige': ('hunnlig',),
'hunnlig': ('hunnlig',),
'hurpa': ('hurpe',),
'hurpet': ('hurpe',),
'hurpa': ('hurpe',),
'hurpet': ('hurpe',),
'hurpa': ('hurpe',),
'hurpete': ('hurpe',),
'hurpede': ('hurpe',),
'hurpa': ('hurpe',),
'hurpete': ('hurpe',),
'hurpede': ('hurpe',),
'hurpende': ('hurpe',),
'hurpet': ('hurpet',),
'hurpete': ('hurpet',),
'hurpet': ('hurpet',),
'hurpete': ('hurpete',),
'hurra': ('hurre',),
'hurret': ('hurre',),
'hurra': ('hurre',),
'hurret': ('hurre',),
'hurra': ('hurre',),
'hurrete': ('hurre',),
'hurrede': ('hurre',),
'hurra': ('hurre',),
'hurrete': ('hurre',),
'hurrede': ('hurre',),
'hurrende': ('hurre',),
'hurtig': ('hurtig',),
'hurtige': ('hurtig',),
'hurtig': ('hurtig',),
'hurtigere': ('hurtig',),
'hurtigst': ('hurtig',),
'hurtigste': ('hurtig',),
'hurtigarbeidende': ('hurtigarbeidende',),
'hurtiggående': ('hurtiggående',),
'husbankfinansiert': ('husbankfinansiere',),
'husbankfinansierte': ('husbankfinansiere',),
'husbankfinansierende': ('husbankfinansiere',),
'husa': ('huse',),
'huset': ('huse',),
'hust': ('huse',),
'husa': ('huse',),
'huset': ('huse',),
'hust': ('huse',),
'husa': ('huse',),
'husete': ('huse',),
'husede': ('huse',),
'huste': ('huse',),
'husa': ('huse',),
'husete': ('huse',),
'husede': ('huse',),
'huste': ('huse',),
'husende': ('huse',),
'husert': ('husere',),
'huserte': ('husere',),
'huserende': ('husere',),
'husholdt': ('husholde',),
'husholdte': ('husholde',),
'husholdende': ('husholde',),
'husholdert': ('husholdere',),
'husholderte': ('husholdere',),
'husholderende': ('husholdere',),
'husholderert': ('husholderere',),
'husholdererte': ('husholderere',),
'husholdererende': ('husholderere',),
'husittisk': ('husittisk',),
'husittiske': ('husittisk',),
'husittisk': ('husittisk',),
'huskald': ('huskald',),
'huskalde': ('huskald',),
'huskaldt': ('huskald',),
'huska': ('huske',),
'husket': ('huske',),
'huska': ('huske',),
'husket': ('huske',),
'huska': ('huske',),
'huskete': ('huske',),
'huskede': ('huske',),
'huska': ('huske',),
'huskete': ('huske',),
'huskede': ('huske',),
'huskende': ('huske',),
'huslaus': ('huslaus',),
'huslause': ('huslaus',),
'huslaust': ('huslaus',),
'huslig': ('huslig',),
'huslige': ('huslig',),
'huslig': ('huslig',),
'husløs': ('husløs',),
'husløse': ('husløs',),
'husløst': ('husløs',),
'hussøkende': ('hussøkende',),
'hustra': ('hustre',),
'hustret': ('hustre',),
'hustra': ('hustre',),
'hustret': ('hustre',),
'hustra': ('hustre',),
'hustrete': ('hustre',),
'hustrede': ('hustre',),
'hustrete': ('hustre',),
'hustrede': ('hustre',),
'hustra': ('hustre',),
'hustrete': ('hustre',),
'hustrede': ('hustre',),
'hustrete': ('hustre',),
'hustrede': ('hustre',),
'hustrende': ('hustre',),
'hustren': ('hustren',),
'hustrene': ('hustren',),
'hustrne': ('hustren',),
'hustrene': ('hustren',),
'hustrne': ('hustren',),
'hustrent': ('hustren',),
'hustrig': ('hustrig',),
'hustrige': ('hustrig',),
'hustrig': ('hustrig',),
'husvalt': ('husvale',),
'husvalte': ('husvale',),
'husvalende': ('husvale',),
'husvarm': ('husvarm',),
'husvarme': ('husvarm',),
'husvarmt': ('husvarm',),
'husvill': ('husvill',),
'husville': ('husvill',),
'husvilt': ('husvill',),
'huta': ('hute',),
'hutet': ('hute',),
'huta': ('hute',),
'hutet': ('hute',),
'huta': ('hute',),
'hutete': ('hute',),
'hutede': ('hute',),
'huta': ('hute',),
'hutete': ('hute',),
'hutede': ('hute',),
'hutende': ('hute',),
'hutra': ('hutre',),
'hutret': ('hutre',),
'hutra': ('hutre',),
'hutret': ('hutre',),
'hutra': ('hutre',),
'hutrete': ('hutre',),
'hutrede': ('hutre',),
'hutrete': ('hutre',),
'hutrede': ('hutre',),
'hutra': ('hutre',),
'hutrete': ('hutre',),
'hutrede': ('hutre',),
'hutrete': ('hutre',),
'hutrede': ('hutre',),
'hutrende': ('hutre',),
'hvass': ('hvass',),
'hvasse': ('hvass',),
'hvast': ('hvass',),
'hvassere': ('hvass',),
'hvassest': ('hvass',),
'hvasseste': ('hvass',),
'hvassøyd': ('hvassøyd',),
'hvassøyde': ('hvassøyd',),
'hvassøyd': ('hvassøyd',),
'hvelva': ('hvelve',),
'hvelvet': ('hvelve',),
'hvelva': ('hvelve',),
'hvelvet': ('hvelve',),
'hvelva': ('hvelve',),
'hvelvete': ('hvelve',),
'hvelvede': ('hvelve',),
'hvelva': ('hvelve',),
'hvelvete': ('hvelve',),
'hvelvede': ('hvelve',),
'hvelvende': ('hvelve',),
'hverdagslig': ('hverdagslig',),
'hverdagslige': ('hverdagslig',),
'hverdagslig': ('hverdagslig',),
'hvest': ('hvese',),
'hveste': ('hvese',),
'hvesende': ('hvese',),
'hvesset': ('hvesse',),
'hvesst': ('hvesse',),
'hvesset': ('hvesse',),
'hvesst': ('hvesse',),
'hvessete': ('hvesse',),
'hvessede': ('hvesse',),
'hvesste': ('hvesse',),
'hvessete': ('hvesse',),
'hvessede': ('hvesse',),
'hvesste': ('hvesse',),
'hvessende': ('hvesse',),
'hvilt': ('hvile',),
'hvilte': ('hvile',),
'hvilende': ('hvile',),
'hvilelaus': ('hvilelaus',),
'hvilelause': ('hvilelaus',),
'hvilelaust': ('hvilelaus',),
'hvileløs': ('hvileløs',),
'hvileløse': ('hvileløs',),
'hvileløst': ('hvileløs',),
'hvint': ('hvine',),
'hvinte': ('hvine',),
'hvinende': ('hvine',),
'hviska': ('hviske',),
'hvisket': ('hviske',),
'hviska': ('hviske',),
'hvisket': ('hviske',),
'hviska': ('hviske',),
'hviskete': ('hviske',),
'hviskede': ('hviske',),
'hviska': ('hviske',),
'hviskete': ('hviske',),
'hviskede': ('hviske',),
'hviskende': ('hviske',),
'hvit': ('hvit',),
'hvite': ('hvit',),
'hvitt': ('hvit',),
'hvitere': ('hvit',),
'hvitest': ('hvit',),
'hviteste': ('hvit',),
'hvitbleik': ('hvitbleik',),
'hvitbleike': ('hvitbleik',),
'hvitbleikt': ('hvitbleik',),
'hvitblek': ('hvitblek',),
'hvitbleke': ('hvitblek',),
'hvitblekt': ('hvitblek',),
'hviterussisk': ('hviterussisk',),
'hviterussiske': ('hviterussisk',),
'hviterussisk': ('hviterussisk',),
'hvitglødende': ('hvitglødende',),
'hvithåra': ('hvithåra',),
'hvithåret': ('hvithåret',),
'hvithårete': ('hvithåret',),
'hvithårede': ('hvithåret',),
'hvithårete': ('hvithåret',),
'hvithårede': ('hvithåret',),
'hvithåret': ('hvithåret',),
'hvitkalka': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalkete': ('hvitkalke',),
'hvitkalkede': ('hvitkalke',),
'hvitkalka': ('hvitkalke',),
'hvitkalkete': ('hvitkalke',),
'hvitkalkede': ('hvitkalke',),
'hvitkalkende': ('hvitkalke',),
'hvitkledd': ('hvitkledd',),
'hvitkledde': ('hvitkledd',),
'hvitkledd': ('hvitkledd',),
'hvitlett': ('hvitlett',),
'hvitlette': ('hvitlett',),
'hvitlett': ('hvitlett',),
'hvitna': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitna': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitna': ('hvitne',),
'hvitnete': ('hvitne',),
'hvitnede': ('hvitne',),
'hvitnete': ('hvitne',),
'hvitnede': ('hvitne',),
'hvitna': ('hvitne',),
'hvitnete': ('hvitne',),
'hvitnede': ('hvitne',),
'hvitnete': ('hvitne',),
'hvitnede': ('hvitne',),
'hvitnende': ('hvitne',),
'hvitta': ('hvitte',),
'hvittet': ('hvitte',),
'hvitta': ('hvitte',),
'hvittet': ('hvitte',),
'hvitta': ('hvitte',),
'hvittete': ('hvitte',),
'hvittede': ('hvitte',),
'hvitta': ('hvitte',),
'hvittete': ('hvitte',),
'hvittede': ('hvitte',),
'hvittende': ('hvitte',),
'hvitvaska': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvaskete': ('hvitvaske',),
'hvitvaskede': ('hvitvaske',),
'hvitvaska': ('hvitvaske',),
'hvitvaskete': ('hvitvaske',),
'hvitvaskede': ('hvitvaske',),
'hvitvaskende': ('hvitvaske',),
'hybrid': ('hybrid',),
'hybride': ('hybrid',),
'hybrid': ('hybrid',),
'hydraulisk': ('hydraulisk',),
'hydrauliske': ('hydraulisk',),
'hydraulisk': ('hydraulisk',),
'hydroelektrisk': ('hydroelektrisk',),
'hydroelektriske': ('hydroelektrisk',),
'hydroelektrisk': ('hydroelektrisk',),
'hydrofil': ('hydrofil',),
'hydrofile': ('hydrofil',),
'hydrofilt': ('hydrofil',),
'hydrofob': ('hydrofob',),
'hydrofobe': ('hydrofob',),
'hydrofobt': ('hydrofob',),
'hydroteknisk': ('hydroteknisk',),
'hydrotekniske': ('hydroteknisk',),
'hydroteknisk': ('hydroteknisk',),
'hyet': ('hyet',),
'hyete': ('hyet',),
'hyet': ('hyet',),
'hyete': ('hyete',),
'hygga': ('hygge',),
'hygget': ('hygge',),
'hygd': ('hygge',),
'hygga': ('hygge',),
'hygget': ('hygge',),
'hygd': ('hygge',),
'hygga': ('hygge',),
'hyggete': ('hygge',),
'hyggede': ('hygge',),
'hygde': ('hygge',),
'hygga': ('hygge',),
'hyggete': ('hygge',),
'hyggede': ('hygge',),
'hygde': ('hygge',),
'hyggende': ('hygge',),
'hyggelig': ('hyggelig',),
'hyggelige': ('hyggelig',),
'hyggelig': ('hyggelig',),
'hyggeligere': ('hyggelig',),
'hyggeligst': ('hyggelig',),
'hyggeligste': ('hyggelig',),
'hygienisk': ('hygienisk',),
'hygieniske': ('hygienisk',),
'hygienisk': ('hygienisk',),
'hygroskopisk': ('hygroskopisk',),
'hygroskopiske': ('hygroskopisk',),
'hygroskopisk': ('hygroskopisk',),
'hykkelsk': ('hykkelsk',),
'hykkelske': ('hykkelsk',),
'hykkelsk': ('hykkelsk',),
'hykla': ('hykle',),
'hyklet': ('hykle',),
'hykla': ('hykle',),
'hyklet': ('hykle',),
'hykla': ('hykle',),
'hyklete': ('hykle',),
'hyklede': ('hykle',),
'hyklete': ('hykle',),
'hyklede': ('hykle',),
'hykla': ('hykle',),
'hyklete': ('hykle',),
'hyklede': ('hykle',),
'hyklete': ('hykle',),
'hyklede': ('hykle',),
'hyklende': ('hykle',),
'hyklersk': ('hyklersk',),
'hyklerske': ('hyklersk',),
'hyklersk': ('hyklersk',),
'hylt': ('hyle',),
'hylte': ('hyle',),
'hylende': ('hyle',),
'hylla': ('hylle',),
'hyllet': ('hylle',),
'hylla': ('hylle',),
'hyllet': ('hylle',),
'hylla': ('hylle',),
'hyllete': ('hylle',),
'hyllede': ('hylle',),
'hylla': ('hylle',),
'hyllete': ('hylle',),
'hyllede': ('hylle',),
'hyllende': ('hylle',),
'hyperaktiv': ('hyperaktiv',),
'hyperaktive': ('hyperaktiv',),
'hyperaktivt': ('hyperaktiv',),
'hyperaktuell': ('hyperaktuell',),
'hyperaktuelle': ('hyperaktuell',),
'hyperaktuelt': ('hyperaktuell',),
'hyperbolsk': ('hyperbolsk',),
'hyperbolske': ('hyperbolsk',),
'hyperbolsk': ('hyperbolsk',),
'hyperelegant': ('hyperelegant',),
'hyperelegante': ('hyperelegant',),
'hyperelegant': ('hyperelegant',),
'hyperkorrekt': ('hyperkorrekt',),
'hyperkorrekte': ('hyperkorrekt',),
'hyperkorrekt': ('hyperkorrekt',),
'hypermoderne': ('hypermoderne',),
'hypersonisk': ('hypersonisk',),
'hypersoniske': ('hypersonisk',),
'hypersonisk': ('hypersonisk',),
'hypnotisert': ('hypnotisere',),
'hypnotiserte': ('hypnotisere',),
'hypnotiserende': ('hypnotisere',),
'hypnotisk': ('hypnotisk',),
'hypnotiske': ('hypnotisk',),
'hypnotisk': ('hypnotisk',),
'hypokonder': ('hypokonder',),
'hypokondre': ('hypokonder',),
'hypokondert': ('hypokonder',),
'hypokondrisk': ('hypokondrisk',),
'hypokondriske': ('hypokondrisk',),
'hypokondrisk': ('hypokondrisk',),
'hypotaktisk': ('hypotaktisk',),
'hypotaktiske': ('hypotaktisk',),
'hypotaktisk': ('hypotaktisk',),
'hypotetisk': ('hypotetisk',),
'hypotetiske': ('hypotetisk',),
'hypotetisk': ('hypotetisk',),
'hypp': ('hypp',),
'hyppe': ('hypp',),
'hypt': ('hypp',),
'hyppa': ('hyppe',),
'hyppet': ('hyppe',),
'hyppa': ('hyppe',),
'hyppet': ('hyppe',),
'hyppa': ('hyppe',),
'hyppete': ('hyppe',),
'hyppede': ('hyppe',),
'hyppa': ('hyppe',),
'hyppete': ('hyppe',),
'hyppede': ('hyppe',),
'hyppende': ('hyppe',),
'hyppig': ('hyppig',),
'hyppige': ('hyppig',),
'hyppig': ('hyppig',),
'hyppigere': ('hyppig',),
'hyppigst': ('hyppig',),
'hyppigste': ('hyppig',),
'hyra': ('hyre',),
'hyret': ('hyre',),
'hyrt': ('hyre',),
'hyra': ('hyre',),
'hyret': ('hyre',),
'hyrt': ('hyre',),
'hyra': ('hyre',),
'hyrete': ('hyre',),
'hyrede': ('hyre',),
'hyrte': ('hyre',),
'hyra': ('hyre',),
'hyrete': ('hyre',),
'hyrede': ('hyre',),
'hyrte': ('hyre',),
'hyrende': ('hyre',),
'hysja': ('hysje',),
'hysjet': ('hysje',),
'hysja': ('hysje',),
'hysjet': ('hysje',),
'hysja': ('hysje',),
'hysjete': ('hysje',),
'hysjede': ('hysje',),
'hysja': ('hysje',),
'hysjete': ('hysje',),
'hysjede': ('hysje',),
'hysjende': ('hysje',),
'hyssa': ('hysse',),
'hysset': ('hysse',),
'hyssa': ('hysse',),
'hysset': ('hysse',),
'hyssa': ('hysse',),
'hyssete': ('hysse',),
'hyssede': ('hysse',),
'hyssa': ('hysse',),
'hyssete': ('hysse',),
'hyssede': ('hysse',),
'hyssende': ('hysse',),
'hysterisk': ('hysterisk',),
'hysteriske': ('hysterisk',),
'hysterisk': ('hysterisk',),
'hytta': ('hytte',),
'hyttet': ('hytte',),
'hytta': ('hytte',),
'hyttet': ('hytte',),
'hytta': ('hytte',),
'hyttete': ('hytte',),
'hyttede': ('hytte',),
'hytta': ('hytte',),
'hyttete': ('hytte',),
'hyttede': ('hytte',),
'hyttende': ('hytte',),
'hål': ('hål',),
'håle': ('hål',),
'hålt': ('hål',),
'hålket': ('hålket',),
'hålkete': ('hålket',),
'hålket': ('hålket',),
'hålkete': ('hålkete',),
'hånddrevet': ('hånddrevet',),
'hånddrevne': ('hånddrevet',),
'hånddrevet': ('hånddrevet',),
'håndfallen': ('håndfallen',),
'håndfalne': ('håndfallen',),
'håndfallent': ('håndfallen',),
'håndfast': ('håndfast',),
'håndfaste': ('håndfast',),
'håndfast': ('håndfast',),
'håndgangen': ('håndgangen',),
'håndgangne': ('håndgangen',),
'håndgangent': ('håndgangen',),
'håndgitt': ('håndgi',),
'håndgitte': ('håndgi',),
'håndgiende': ('håndgi',),
'håndgripelig': ('håndgripelig',),
'håndgripelige': ('håndgripelig',),
'håndgripelig': ('håndgripelig',),
'håndheva': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhevd': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhevd': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevete': ('håndheve',),
'håndhevede': ('håndheve',),
'håndhevde': ('håndheve',),
'håndheva': ('håndheve',),
'håndhevete': ('håndheve',),
'håndhevede': ('håndheve',),
'håndhevde': ('håndheve',),
'håndhevende': ('håndheve',),
'håndhilst': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndhilsende': ('håndhilse',),
'håndlaga': ('håndlaga',),
'håndlagd': ('håndlagd',),
'håndlagde': ('håndlagd',),
'håndlagd': ('håndlagd',),
'håndlaget': ('håndlaget',),
'håndlagete': ('håndlaget',),
'håndlagede': ('håndlaget',),
'håndlagete': ('håndlaget',),
'håndlagede': ('håndlaget',),
'håndlaget': ('håndlaget',),
'håndnerva': ('håndnerva',),
'håndnervet': ('håndnervet',),
'håndnervete': ('håndnervet',),
'håndnervede': ('håndnervet',),
'håndnervete': ('håndnervet',),
'håndnervede': ('håndnervet',),
'håndnervet': ('håndnervet',),
'håndplukka': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukkete': ('håndplukke',),
'håndplukkede': ('håndplukke',),
'håndplukka': ('håndplukke',),
'håndplukkete': ('håndplukke',),
'håndplukkede': ('håndplukke',),
'håndplukkende': ('håndplukke',),
'håndskreven': ('håndskreven',),
'håndskrevne': ('håndskreven',),
'håndskrevet': ('håndskreven',),
'håndskrevet': ('håndskrevet',),
'håndskrevne': ('håndskrevet',),
'håndskrevet': ('håndskrevet',),
'håndskåren': ('håndskåren',),
'håndskårne': ('håndskåren',),
'håndskåret': ('håndskåren',),
'håndskåret': ('håndskåret',),
'håndskårne': ('håndskåret',),
'håndskåret': ('håndskåret',),
'håndstående': ('håndstående',),
'håndtert': ('håndtere',),
'håndterte': ('håndtere',),
'håndterende': ('håndtere',),
'håndterlig': ('håndterlig',),
'håndterlige': ('håndterlig',),
'håndterlig': ('håndterlig',),
'håndvarm': ('håndvarm',),
'håndvarme': ('håndvarm',),
'håndvarmt': ('håndvarm',),
'håndverksmessig': ('håndverksmessig',),
'håndverksmessige': ('håndverksmessig',),
'håndverksmessig': ('håndverksmessig',),
'håna': ('håne',),
'hånet': ('håne',),
'hånt': ('håne',),
'håna': ('håne',),
'hånet': ('håne',),
'hånt': ('håne',),
'håna': ('håne',),
'hånete': ('håne',),
'hånede': ('håne',),
'hånte': ('håne',),
'håna': ('håne',),
'hånete': ('håne',),
'hånede': ('håne',),
'hånte': ('håne',),
'hånende': ('håne',),
'hånflirt': ('hånflire',),
'hånflirte': ('hånflire',),
'hånflirende': ('hånflire',),
'hånledd': ('hånle',),
'hånledde': ('hånle',),
'hånleende': ('hånle',),
'hånlig': ('hånlig',),
'hånlige': ('hånlig',),
'hånlig': ('hånlig',),
'hånsk': ('hånsk',),
'hånske': ('hånsk',),
'hånsk': ('hånsk',),
'håpa': ('håpe',),
'håpet': ('håpe',),
'håpt': ('håpe',),
'håpa': ('håpe',),
'håpet': ('håpe',),
'håpt': ('håpe',),
'håpa': ('håpe',),
'håpete': ('håpe',),
'håpede': ('håpe',),
'håpte': ('håpe',),
'håpa': ('håpe',),
'håpete': ('håpe',),
'håpede': ('håpe',),
'håpte': ('håpe',),
'håpende': ('håpe',),
'håpefull': ('håpefull',),
'håpefulle': ('håpefull',),
'håpefullt': ('håpefull',),
'håplaus': ('håplaus',),
'håplause': ('håplaus',),
'håplaust': ('håplaus',),
'håpløs': ('håpløs',),
'håpløse': ('håpløs',),
'håpløst': ('håpløs',),
'håret': ('håret',),
'hårete': ('håret',),
'håret': ('håret',),
'hårete': ('hårete',),
'hårfager': ('hårfager',),
'hårfagre': ('hårfager',),
'hårfagert': ('hårfager',),
'hårfin': ('hårfin',),
'hårfine': ('hårfin',),
'hårfint': ('hårfin',),
'hårreisende': ('hårreisende',),
'hårsår': ('hårsår',),
'hårsåre': ('hårsår',),
'hårsårt': ('hårsår',),
'hås': ('hås',),
'håse': ('hås',),
'håst': ('hås',),
'håsere': ('hås',),
'håsest': ('hås',),
'håseste': ('hås',),
'håva': ('håve',),
'håvet': ('håve',),
'håva': ('håve',),
'håvet': ('håve',),
'håva': ('håve',),
'håvete': ('håve',),
'håvede': ('håve',),
'håva': ('håve',),
'håvete': ('håve',),
'håvede': ('håve',),
'håvende': ('håve',),
'hæla': ('hæle',),
'hælet': ('hæle',),
'hælt': ('hæle',),
'hæla': ('hæle',),
'hælet': ('hæle',),
'hælt': ('hæle',),
'hæla': ('hæle',),
'hælete': ('hæle',),
'hælede': ('hæle',),
'hælte': ('hæle',),
'hæla': ('hæle',),
'hælete': ('hæle',),
'hælede': ('hæle',),
'hælte': ('hæle',),
'hælende': ('hæle',),
'hælsparka': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparkete': ('hælsparke',),
'hælsparkede': ('hælsparke',),
'hælsparka': ('hælsparke',),
'hælsparkete': ('hælsparke',),
'hælsparkede': ('hælsparke',),
'hælsparkende': ('hælsparke',),
'hærkledd': ('hærkledd',),
'hærkledde': ('hærkledd',),
'hærkledd': ('hærkledd',),
'hærtatt': ('hærta',),
'hærtatte': ('hærta',),
'hærtakende': ('hærta',),
'høflig': ('høflig',),
'høflige': ('høflig',),
'høflig': ('høflig',),
'høfligere': ('høflig',),
'høfligst': ('høflig',),
'høfligste': ('høflig',),
'høg': ('høg',),
'høge': ('høg',),
'høgt': ('høg',),
'høgere': ('høg',),
'høgest': ('høg',),
'høgeste': ('høg',),
'høgborgerlig': ('høgborgerlig',),
'høgborgerlige': ('høgborgerlig',),
'høgborgerlig': ('høgborgerlig',),
'høgereliggende': ('høgereliggende',),
'høgerestående': ('høgerestående',),
'høgfrekvent': ('høgfrekvent',),
'høgfrekvente': ('høgfrekvent',),
'høgfrekvent': ('høgfrekvent',),
'høggravid': ('høggravid',),
'høggravide': ('høggravid',),
'høggravid': ('høggravid',),
'høghalset': ('høghalset',),
'høghalsete': ('høghalset',),
'høghalsede': ('høghalset',),
'høghalsete': ('høghalset',),
'høghalsede': ('høghalset',),
'høghalset': ('høghalset',),
'høghælt': ('høghælt',),
'høghælte': ('høghælt',),
'høghælt': ('høghælt',),
'høgkirkelig': ('høgkirkelig',),
'høgkirkelige': ('høgkirkelig',),
'høgkirkelig': ('høgkirkelig',),
'høglofta': ('høglofta',),
'høgloftet': ('høgloftet',),
'høgloftete': ('høgloftet',),
'høgloftede': ('høgloftet',),
'høgloftete': ('høgloftet',),
'høgloftede': ('høgloftet',),
'høgloftet': ('høgloftet',),
'høglys': ('høglys',),
'høglyse': ('høglys',),
'høglyst': ('høglys',),
'høglytt': ('høglytt',),
'høglytte': ('høglytt',),
'høglytt': ('høglytt',),
'høgmælt': ('høgmælt',),
'høgmælte': ('høgmælt',),
'høgmælt': ('høgmælt',),
'høgre': ('høgre',),
'høgrehendt': ('høgrehendt',),
'høgrehendte': ('høgrehendt',),
'høgrehendt': ('høgrehendt',),
'høgrehengsla': ('høgrehengsla',),
'høgrehengslet': ('høgrehengslet',),
'høgrehengslete': ('høgrehengslet',),
'høgrehengslede': ('høgrehengslet',),
'høgrehengslete': ('høgrehengslet',),
'høgrehengslede': ('høgrehengslet',),
'høgrehengslet': ('høgrehengslet',),
'høgreorientert': ('høgreorientert',),
'høgreorienterte': ('høgreorientert',),
'høgreorientert': ('høgreorientert',),
'høgrevridd': ('høgrevridd',),
'høgrevridde': ('høgrevridd',),
'høgrevridd': ('høgrevridd',),
'høgrygga': ('høgrygga',),
'høgrygget': ('høgrygget',),
'høgryggete': ('høgrygget',),
'høgryggede': ('høgrygget',),
'høgryggete': ('høgrygget',),
'høgryggede': ('høgrygget',),
'høgrygget': ('høgrygget',),
'høgrøsta': ('høgrøsta',),
'høgrøstet': ('høgrøstet',),
'høgrøstete': ('høgrøstet',),
'høgrøstede': ('høgrøstet',),
'høgrøstete': ('høgrøstet',),
'høgrøstede': ('høgrøstet',),
'høgrøstet': ('høgrøstet',),
'høgspent': ('høgspent',),
'høgspente': ('høgspent',),
'høgspent': ('høgspent',),
'høgstemt': ('høgstemt',),
'høgstemte': ('høgstemt',),
'høgstemt': ('høgstemt',),
'høgtflygende': ('høgtflygende',),
'høgtidelig': ('høgtidelig',),
'høgtidelige': ('høgtidelig',),
'høgtidelig': ('høgtidelig',),
'høgtidsfull': ('høgtidsfull',),
'høgtidsfulle': ('høgtidsfull',),
'høgtidsfullt': ('høgtidsfull',),
'høgtliggende': ('høgtliggende',),
'høgtlønna': ('høgtlønna',),
'høgtlønnet': ('høgtlønnet',),
'høgtlønnete': ('høgtlønnet',),
'høgtlønnede': ('høgtlønnet',),
'høgtlønnete': ('høgtlønnet',),
'høgtlønnede': ('høgtlønnet',),
'høgtlønnet': ('høgtlønnet',),
'høgtlønt': ('høgtlønt',),
'høgtlønte': ('høgtlønt',),
'høgtlønt': ('høgtlønt',),
'høgtstående': ('høgtstående',),
'høgtsvevende': ('høgtsvevende',),
'høgtysk': ('høgtysk',),
'høgtyske': ('høgtysk',),
'høgtysk': ('høgtysk',),
'høgvelbåren': ('høgvelbåren',),
'høgvelbårne': ('høgvelbåren',),
'høgvelbårent': ('høgvelbåren',),
'høgverdig': ('høgverdig',),
'høgverdige': ('høgverdig',),
'høgverdig': ('høgverdig',),
'høgvokst': ('høgvokst',),
'høgvokste': ('høgvokst',),
'høgvokst': ('høgvokst',),
'høgætta': ('høgætta',),
'høgættet': ('høgættet',),
'høgættete': ('høgættet',),
'høgættede': ('høgættet',),
'høgættete': ('høgættet',),
'høgættede': ('høgættet',),
'høgættet': ('høgættet',),
'høkeraktig': ('høkeraktig',),
'høkeraktige': ('høkeraktig',),
'høkeraktig': ('høkeraktig',),
'høkra': ('høkre',),
'høkret': ('høkre',),
'høkra': ('høkre',),
'høkret': ('høkre',),
'høkra': ('høkre',),
'høkrete': ('høkre',),
'høkrede': ('høkre',),
'høkrete': ('høkre',),
'høkrede': ('høkre',),
'høkra': ('høkre',),
'høkrete': ('høkre',),
'høkrede': ('høkre',),
'høkrete': ('høkre',),
'høkrede': ('høkre',),
'høkrende': ('høkre',),
'hølja': ('hølje',),
'høljet': ('hølje',),
'hølja': ('hølje',),
'høljet': ('hølje',),
'hølja': ('hølje',),
'høljete': ('hølje',),
'høljede': ('hølje',),
'hølja': ('hølje',),
'høljete': ('hølje',),
'høljede': ('hølje',),
'høljende': ('hølje',),
'høljeregna': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnt': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnt': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregnete': ('høljeregne',),
'høljeregnede': ('høljeregne',),
'høljeregnte': ('høljeregne',),
'høljeregna': ('høljeregne',),
'høljeregnete': ('høljeregne',),
'høljeregnede': ('høljeregne',),
'høljeregnte': ('høljeregne',),
'høljeregnende': ('høljeregne',),
'høljregna': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnt': ('høljregne',),
'høljregna': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnt': ('høljregne',),
'høljregna': ('høljregne',),
'høljregnete': ('høljregne',),
'høljregnede': ('høljregne',),
'høljregnte': ('høljregne',),
'høljregna': ('høljregne',),
'høljregnete': ('høljregne',),
'høljregnede': ('høljregne',),
'høljregnte': ('høljregne',),
'høljregnende': ('høljregne',),
'hørbar': ('hørbar',),
'hørbare': ('hørbar',),
'hørbart': ('hørbar',),
'hørt': ('høre',),
'hørte': ('høre',),
'hørende': ('høre',),
'hørlig': ('hørlig',),
'hørlige': ('hørlig',),
'hørlig': ('hørlig',),
'hørselshemma': ('hørselshemma',),
'hørselshemmet': ('hørselshemmet',),
'hørselshemmete': ('hørselshemmet',),
'hørselshemmede': ('hørselshemmet',),
'hørselshemmete': ('hørselshemmet',),
'hørselshemmede': ('hørselshemmet',),
'hørselshemmet': ('hørselshemmet',),
'hørselssvekka': ('hørselssvekka',),
'hørselssvekket': ('hørselssvekket',),
'hørselssvekkete': ('hørselssvekket',),
'hørselssvekkede': ('hørselssvekket',),
'hørselssvekkete': ('hørselssvekket',),
'hørselssvekkede': ('hørselssvekket',),
'hørselssvekket': ('hørselssvekket',),
'høstbær': ('høstbær',),
'høstbære': ('høstbær',),
'høstbært': ('høstbær',),
'høsta': ('høste',),
'høstet': ('høste',),
'høsta': ('høste',),
'høstet': ('høste',),
'høsta': ('høste',),
'høstete': ('høste',),
'høstede': ('høste',),
'høsta': ('høste',),
'høstete': ('høste',),
'høstede': ('høste',),
'høstende': ('høste',),
'høstlig': ('høstlig',),
'høstlige': ('høstlig',),
'høstlig': ('høstlig',),
'høvd': ('høve',),
'høvde': ('høve',),
'høvende': ('høve',),
'høvelig': ('høvelig',),
'høvelige': ('høvelig',),
'høvelig': ('høvelig',),
'høveligere': ('høvelig',),
'høveligst': ('høvelig',),
'høveligste': ('høvelig',),
'høvisk': ('høvisk',),
'høviske': ('høvisk',),
'høvisk': ('høvisk',),
'høvla': ('høvle',),
'høvlet': ('høvle',),
'høvla': ('høvle',),
'høvlet': ('høvle',),
'høvla': ('høvle',),
'høvlete': ('høvle',),
'høvlede': ('høvle',),
'høvlete': ('høvle',),
'høvlede': ('høvle',),
'høvla': ('høvle',),
'høvlete': ('høvle',),
'høvlede': ('høvle',),
'høvlete': ('høvle',),
'høvlede': ('høvle',),
'høvlende': ('høvle',),
'høy': ('høy',),
'høye': ('høy',),
'høyt': ('høy',),
'høyere': ('høy',),
'høyest': ('høy',),
'høyeste': ('høy',),
'høyborgerlig': ('høyborgerlig',),
'høyborgerlige': ('høyborgerlig',),
'høyborgerlig': ('høyborgerlig',),
'høya': ('høye',),
'høyet': ('høye',),
'høya': ('høye',),
'høyet': ('høye',),
'høya': ('høye',),
'høyete': ('høye',),
'høyede': ('høye',),
'høya': ('høye',),
'høyete': ('høye',),
'høyede': ('høye',),
'høyende': ('høye',),
'høyereliggende': ('høyereliggende',),
'høyerestående': ('høyerestående',),
'høyfrekvent': ('høyfrekvent',),
'høyfrekvente': ('høyfrekvent',),
'høyfrekvent': ('høyfrekvent',),
'høygravid': ('høygravid',),
'høygravide': ('høygravid',),
'høygravid': ('høygravid',),
'høyhalset': ('høyhalset',),
'høyhalsete': ('høyhalset',),
'høyhalsede': ('høyhalset',),
'høyhalsete': ('høyhalset',),
'høyhalsede': ('høyhalset',),
'høyhalset': ('høyhalset',),
'høyhælt': ('høyhælt',),
'høyhælte': ('høyhælt',),
'høyhælt': ('høyhælt',),
'høykirkelig': ('høykirkelig',),
'høykirkelige': ('høykirkelig',),
'høykirkelig': ('høykirkelig',),
'høylofta': ('høylofta',),
'høyloftet': ('høyloftet',),
'høyloftete': ('høyloftet',),
'høyloftede': ('høyloftet',),
'høyloftete': ('høyloftet',),
'høyloftede': ('høyloftet',),
'høyloftet': ('høyloftet',),
'høylys': ('høylys',),
'høylyse': ('høylys',),
'høylyst': ('høylys',),
'høylytt': ('høylytt',),
'høylytte': ('høylytt',),
'høylytt': ('høylytt',),
'høymælt': ('høymælt',),
'høymælte': ('høymælt',),
'høymælt': ('høymælt',),
'høyna': ('høyne',),
'høynet': ('høyne',),
'høyna': ('høyne',),
'høynet': ('høyne',),
'høyna': ('høyne',),
'høynete': ('høyne',),
'høynede': ('høyne',),
'høyna': ('høyne',),
'høynete': ('høyne',),
'høynede': ('høyne',),
'høynende': ('høyne',),
'høyre': ('høyre',),
'høyrehendt': ('høyrehendt',),
'høyrehendte': ('høyrehendt',),
'høyrehendt': ('høyrehendt',),
'høyrehengsla': ('høyrehengsla',),
'høyrehengslet': ('høyrehengslet',),
'høyrehengslete': ('høyrehengslet',),
'høyrehengslede': ('høyrehengslet',),
'høyrehengslete': ('høyrehengslet',),
'høyrehengslede': ('høyrehengslet',),
'høyrehengslet': ('høyrehengslet',),
'høyreorientert': ('høyreorientert',),
'høyreorienterte': ('høyreorientert',),
'høyreorientert': ('høyreorientert',),
'høyrevridd': ('høyrevridd',),
'høyrevridde': ('høyrevridd',),
'høyrevridd': ('høyrevridd',),
'høyrygga': ('høyrygga',),
'høyrygget': ('høyrygget',),
'høyryggete': ('høyrygget',),
'høyryggede': ('høyrygget',),
'høyryggete': ('høyrygget',),
'høyryggede': ('høyrygget',),
'høyrygget': ('høyrygget',),
'høyrøsta': ('høyrøsta',),
'høyrøstet': ('høyrøstet',),
'høyrøstete': ('høyrøstet',),
'høyrøstede': ('høyrøstet',),
'høyrøstete': ('høyrøstet',),
'høyrøstede': ('høyrøstet',),
'høyrøstet': ('høyrøstet',),
'høyspent': ('høyspent',),
'høyspente': ('høyspent',),
'høyspent': ('høyspent',),
'høystbydende': ('høystbydende',),
'høystemt': ('høystemt',),
'høystemte': ('høystemt',),
'høystemt': ('høystemt',),
'høystæret': ('høystæret',),
'høystærete': ('høystæret',),
'høystærede': ('høystæret',),
'høystærete': ('høystæret',),
'høystærede': ('høystæret',),
'høystæret': ('høystæret',),
'høytflygende': ('høytflygende',),
'høytidelig': ('høytidelig',),
'høytidelige': ('høytidelig',),
'høytidelig': ('høytidelig',),
'høytidsfull': ('høytidsfull',),
'høytidsfulle': ('høytidsfull',),
'høytidsfullt': ('høytidsfull',),
'høytliggende': ('høytliggende',),
'høytlønt': ('høytlønt',),
'høytlønte': ('høytlønt',),
'høytlønt': ('høytlønt',),
'høytstående': ('høytstående',),
'høytsvevende': ('høytsvevende',),
'høyttravende': ('høyttravende',),
'høytysk': ('høytysk',),
'høytyske': ('høytysk',),
'høytysk': ('høytysk',),
'høyvelbåren': ('høyvelbåren',),
'høyvelbårne': ('høyvelbåren',),
'høyvelbårent': ('høyvelbåren',),
'høyverdig': ('høyverdig',),
'høyverdige': ('høyverdig',),
'høyverdig': ('høyverdig',),
'høyvokst': ('høyvokst',),
'høyvokste': ('høyvokst',),
'høyvokst': ('høyvokst',),
'høyætta': ('høyætta',),
'høyættet': ('høyættet',),
'høyættete': ('høyættet',),
'høyættede': ('høyættet',),
'høyættete': ('høyættet',),
'høyættede': ('høyættet',),
'høyættet': ('høyættet',),
'iakttatt': ('iaktta',),
'iakttatte': ('iaktta',),
'iakttakende': ('iaktta',),
'iatrogen': ('iatrogen',),
'iatrogene': ('iatrogen',),
'iatrogent': ('iatrogen',),
'iberegna': ('iberegne',),
'iberegnet': ('iberegne',),
'iberegna': ('iberegne',),
'iberegnet': ('iberegne',),
'iberegna': ('iberegne',),
'iberegnete': ('iberegne',),
'iberegnede': ('iberegne',),
'iberegna': ('iberegne',),
'iberegnete': ('iberegne',),
'iberegnede': ('iberegne',),
'iberegnende': ('iberegne',),
'iberisk': ('iberisk',),
'iberiske': ('iberisk',),
'iberisk': ('iberisk',),
'iblanda': ('iblande',),
'iblandet': ('iblande',),
'iblanda': ('iblande',),
'iblandet': ('iblande',),
'iblanda': ('iblande',),
'iblandete': ('iblande',),
'iblandede': ('iblande',),
'iblanda': ('iblande',),
'iblandete': ('iblande',),
'iblandede': ('iblande',),
'iblandende': ('iblande',),
'iboende': ('iboende',),
'ibsensk': ('ibsensk',),
'ibsenske': ('ibsensk',),
'ibsensk': ('ibsensk',),
'ibuende': ('ibuende',),
'idéhistorisk': ('idéhistorisk',),
'idéhistoriske': ('idéhistorisk',),
'idéhistorisk': ('idéhistorisk',),
'idélaus': ('idélaus',),
'idélause': ('idélaus',),
'idélaust': ('idélaus',),
'idéløs': ('idéløs',),
'idéløse': ('idéløs',),
'idéløst': ('idéløs',),
'idérik': ('idérik',),
'idérike': ('idérik',),
'idérikt': ('idérik',),
'idérikere': ('idérik',),
'idérikest': ('idérik',),
'idérikeste': ('idérik',),
'ideal': ('ideal',),
'ideale': ('ideal',),
'idealt': ('ideal',),
'idealisert': ('idealisere',),
'idealiserte': ('idealisere',),
'idealiserende': ('idealisere',),
'idealistisk': ('idealistisk',),
'idealistiske': ('idealistisk',),
'idealistisk': ('idealistisk',),
'ideell': ('ideell',),
'ideelle': ('ideell',),
'ideelt': ('ideell',),
'idel': ('idel',),
'idelig': ('idelig',),
'idelige': ('idelig',),
'idelig': ('idelig',),
'identifisert': ('identifisere',),
'identifiserte': ('identifisere',),
'identifiserende': ('identifisere',),
'identisk': ('identisk',),
'identiske': ('identisk',),
'identisk': ('identisk',),
'ideografisk': ('ideografisk',),
'ideografiske': ('ideografisk',),
'ideografisk': ('ideografisk',),
'ideologisert': ('ideologisere',),
'ideologiserte': ('ideologisere',),
'ideologiserende': ('ideologisere',),
'ideologisk': ('ideologisk',),
'ideologiske': ('ideologisk',),
'ideologisk': ('ideologisk',),
'idig': ('idig',),
'idige': ('idig',),
'idig': ('idig',),
'idiomatisk': ('idiomatisk',),
'idiomatiske': ('idiomatisk',),
'idiomatisk': ('idiomatisk',),
'idiosynkratisk': ('idiosynkratisk',),
'idiosynkratiske': ('idiosynkratisk',),
'idiosynkratisk': ('idiosynkratisk',),
'idiotisk': ('idiotisk',),
'idiotiske': ('idiotisk',),
'idiotisk': ('idiotisk',),
'idiotsikker': ('idiotsikker',),
'idiotsikre': ('idiotsikker',),
'idiotsikkert': ('idiotsikker',),
'idka': ('idke',),
'idket': ('idke',),
'idka': ('idke',),
'idket': ('idke',),
'idka': ('idke',),
'idkete': ('idke',),
'idkede': ('idke',),
'idkete': ('idke',),
'idkede': ('idke',),
'idka': ('idke',),
'idkete': ('idke',),
'idkede': ('idke',),
'idkete': ('idke',),
'idkede': ('idke',),
'idkende': ('idke',),
'idrettslig': ('idrettslig',),
'idrettslige': ('idrettslig',),
'idrettslig': ('idrettslig',),
'idyllisert': ('idyllisere',),
'idylliserte': ('idyllisere',),
'idylliserende': ('idyllisere',),
'idyllisk': ('idyllisk',),
'idylliske': ('idyllisk',),
'idyllisk': ('idyllisk',),
'idømt': ('idømme',),
'idømte': ('idømme',),
'idømmende': ('idømme',),
'iført': ('iføre',),
'iførte': ('iføre',),
'iførende': ('iføre',),
'igangsatt': ('igangsette',),
'igangsatte': ('igangsette',),
'igangsettende': ('igangsette',),
'igangværende': ('igangværende',),
'ignorert': ('ignorere',),
'ignorerte': ('ignorere',),
'ignorerende': ('ignorere',),
'iherdig': ('iherdig',),
'iherdige': ('iherdig',),
'iherdig': ('iherdig',),
'ihjelfrosset': ('ihjelfrosset',),
'ihjelfrosne': ('ihjelfrosset',),
'ihjelfrosset': ('ihjelfrosset',),
'ihjelkjørt': ('ihjelkjørt',),
'ihjelkjørte': ('ihjelkjørt',),
'ihjelkjørt': ('ihjelkjørt',),
'ihopfletta': ('ihopfletta',),
'ihopflettet': ('ihopflettet',),
'ihopflettete': ('ihopflettet',),
'ihopflettede': ('ihopflettet',),
'ihopflettete': ('ihopflettet',),
'ihopflettede': ('ihopflettet',),
'ihopflettet': ('ihopflettet',),
'ihopklemt': ('ihopklemt',),
'ihopklemte': ('ihopklemt',),
'ihopklemt': ('ihopklemt',),
'ihopkrøkt': ('ihopkrøkt',),
'ihopkrøkte': ('ihopkrøkt',),
'ihopkrøkt': ('ihopkrøkt',),
'ihuga': ('ihuga',),
'ihukommet': ('ihukomme',),
'ihukommen': ('ihukomme',),
'ihukomne': ('ihukomme',),
'ihukommende': ('ihukomme',),
'ikke-ledende': ('ikke-ledende',),
'ikke-stridende': ('ikke-stridende',),
'ikledd': ('ikle',),
'ikledde': ('ikle',),
'ikleende': ('ikle',),
'ikonisk': ('ikonisk',),
'ikoniske': ('ikonisk',),
'ikonisk': ('ikonisk',),
'ilanddrevet': ('ilanddrevet',),
'ilanddrevne': ('ilanddrevet',),
'ilanddrevet': ('ilanddrevet',),
'ilandført': ('ilandføre',),
'ilandførte': ('ilandføre',),
'ilandførende': ('ilandføre',),
'ilda': ('ilde',),
'ildet': ('ilde',),
'ilda': ('ilde',),
'ildet': ('ilde',),
'ilda': ('ilde',),
'ildete': ('ilde',),
'ildede': ('ilde',),
'ilda': ('ilde',),
'ildete': ('ilde',),
'ildede': ('ilde',),
'ildende': ('ilde',),
'ildfast': ('ildfast',),
'ildfaste': ('ildfast',),
'ildfast': ('ildfast',),
'ildfull': ('ildfull',),
'ildfulle': ('ildfull',),
'ildfullt': ('ildfull',),
'ildna': ('ildne',),
'ildnet': ('ildne',),
'ildna': ('ildne',),
'ildnet': ('ildne',),
'ildna': ('ildne',),
'ildnete': ('ildne',),
'ildnede': ('ildne',),
'ildnete': ('ildne',),
'ildnede': ('ildne',),
'ildna': ('ildne',),
'ildnete': ('ildne',),
'ildnede': ('ildne',),
'ildnete': ('ildne',),
'ildnede': ('ildne',),
'ildnende': ('ildne',),
'ildnende': ('ildnende',),
'ildrød': ('ildrød',),
'ildrøde': ('ildrød',),
'ildrødt': ('ildrød',),
'ildrødere': ('ildrød',),
'ildrødest': ('ildrød',),
'ildrødeste': ('ildrød',),
'ildsfarlig': ('ildsfarlig',),
'ildsfarlige': ('ildsfarlig',),
'ildsfarlig': ('ildsfarlig',),
'ildsikker': ('ildsikker',),
'ildsikre': ('ildsikker',),
'ildsikkert': ('ildsikker',),
'ildsprutende': ('ildsprutende',),
'ilt': ('ile',),
'ilte': ('ile',),
'ilende': ('ile',),
'ilagt': ('ilegge',),
'ilagte': ('ilegge',),
'ileggende': ('ilegge',),
'iligna': ('iligne',),
'ilignet': ('iligne',),
'iligna': ('iligne',),
'ilignet': ('iligne',),
'iligna': ('iligne',),
'ilignete': ('iligne',),
'ilignede': ('iligne',),
'iligna': ('iligne',),
'ilignete': ('iligne',),
'ilignede': ('iligne',),
'ilignende': ('iligne',),
'ilikna': ('ilikne',),
'iliknet': ('ilikne',),
'ilikna': ('ilikne',),
'iliknet': ('ilikne',),
'ilikna': ('ilikne',),
'iliknete': ('ilikne',),
'iliknede': ('ilikne',),
'iliknete': ('ilikne',),
'iliknede': ('ilikne',),
'ilikna': ('ilikne',),
'iliknete': ('ilikne',),
'iliknede': ('ilikne',),
'iliknete': ('ilikne',),
'iliknede': ('ilikne',),
'iliknende': ('ilikne',),
'ill': ('ill',),
'ille': ('ill',),
'ilt': ('ill',),
'illere': ('ill',),
'illest': ('ill',),
'illeste': ('ill',),
'illegal': ('illegal',),
'illegale': ('illegal',),
'illegalt': ('illegal',),
'illegitim': ('illegitim',),
'illegitime': ('illegitim',),
'illegitimt': ('illegitim',),
'illeluktende': ('illeluktende',),
'illevarslende': ('illevarslende',),
'illgjeten': ('illgjeten',),
'illgjetne': ('illgjeten',),
'illgjetent': ('illgjeten',),
'illgjødd': ('illgjø',),
'illgjødde': ('illgjø',),
'illgjøende': ('illgjø',),
'illhervelig': ('illhervelig',),
'illhervelige': ('illhervelig',),
'illhervelig': ('illhervelig',),
'illhuia': ('illhuie',),
'illhuiet': ('illhuie',),
'illhuia': ('illhuie',),
'illhuiet': ('illhuie',),
'illhuia': ('illhuie',),
'illhuiete': ('illhuie',),
'illhuiede': ('illhuie',),
'illhuia': ('illhuie',),
'illhuiete': ('illhuie',),
'illhuiede': ('illhuie',),
'illhuiende': ('illhuie',),
'illiberal': ('illiberal',),
'illiberale': ('illiberal',),
'illiberalt': ('illiberal',),
'illojal': ('illojal',),
'illojale': ('illojal',),
'illojalt': ('illojal',),
'illrød': ('illrød',),
'illrøde': ('illrød',),
'illrødt': ('illrød',),
'illrødere': ('illrød',),
'illrødest': ('illrød',),
'illrødeste': ('illrød',),
'illsinna': ('illsinna',),
'illsint': ('illsint',),
'illsinte': ('illsint',),
'illsint': ('illsint',),
'illskreket': ('illskrike',),
'illskreken': ('illskrike',),
'illskrekne': ('illskrike',),
'illskrikende': ('illskrike',),
'illsvien': ('illsvien',),
'illsviene': ('illsvien',),
'illsvient': ('illsvien',),
'illudert': ('illudere',),
'illuderte': ('illudere',),
'illuderende': ('illudere',),
'illuminert': ('illuminere',),
'illuminerte': ('illuminere',),
'illuminerende': ('illuminere',),
'illusjonær': ('illusjonær',),
'illusjonære': ('illusjonær',),
'illusjonært': ('illusjonær',),
'illusorisk': ('illusorisk',),
'illusoriske': ('illusorisk',),
'illusorisk': ('illusorisk',),
'illustrativ': ('illustrativ',),
'illustrative': ('illustrativ',),
'illustrativt': ('illustrativ',),
'illustre': ('illustre',),
'illustrert': ('illustrere',),
'illustrerte': ('illustrere',),
'illustrerende': ('illustrere',),
'ilsk': ('ilsk',),
'ilske': ('ilsk',),
'ilsk': ('ilsk',),
'ilskere': ('ilsk',),
'ilskest': ('ilsk',),
'ilskeste': ('ilsk',),
'ilska': ('ilske',),
'ilsket': ('ilske',),
'ilska': ('ilske',),
'ilsket': ('ilske',),
'ilska': ('ilske',),
'ilskete': ('ilske',),
'ilskede': ('ilske',),
'ilska': ('ilske',),
'ilskete': ('ilske',),
'ilskede': ('ilske',),
'ilskende': ('ilske',),
'ilsken': ('ilsken',),
'ilskne': ('ilsken',),
'ilskent': ('ilsken',),
'ilskna': ('ilskne',),
'ilsknet': ('ilskne',),
'ilskna': ('ilskne',),
'ilsknet': ('ilskne',),
'ilskna': ('ilskne',),
'ilsknete': ('ilskne',),
'ilsknede': ('ilskne',),
'ilskna': ('ilskne',),
'ilsknete': ('ilskne',),
'ilsknede': ('ilskne',),
'ilsknende': ('ilskne',),
'ilsom': ('ilsom',),
'ilsomme': ('ilsom',),
'ilsomt': ('ilsom',),
'ilsommere': ('ilsom',),
'ilsomst': ('ilsom',),
'ilsomste': ('ilsom',),
'ilter': ('ilter',),
'iltre': ('ilter',),
'iltert': ('ilter',),
'iltrere': ('ilter',),
'iltrest': ('ilter',),
'iltreste': ('ilter',),
'imaginal': ('imaginal',),
'imaginale': ('imaginal',),
'imaginalt': ('imaginal',),
'imaginert': ('imaginere',),
'imaginerte': ('imaginere',),
'imaginerende': ('imaginere',),
'imaginær': ('imaginær',),
'imaginære': ('imaginær',),
'imaginært': ('imaginær',),
'imitert': ('imitere',),
'imiterte': ('imitere',),
'imiterende': ('imitere',),
'immanent': ('immanent',),
'immanente': ('immanent',),
'immanent': ('immanent',),
'immateriell': ('immateriell',),
'immaterielle': ('immateriell',),
'immaterielt': ('immateriell',),
'immatrikulert': ('immatrikulere',),
'immatrikulerte': ('immatrikulere',),
'immatrikulerende': ('immatrikulere',),
'immigrert': ('immigrere',),
'immigrerte': ('immigrere',),
'immigrerende': ('immigrere',),
'immobil': ('immobil',),
'immobile': ('immobil',),
'immobilt': ('immobil',),
'immortalisert': ('immortalisere',),
'immortaliserte': ('immortalisere',),
'immortaliserende': ('immortalisere',),
'immortell': ('immortell',),
'immortelle': ('immortell',),
'immortelt': ('immortell',),
'immun': ('immun',),
'immune': ('immun',),
'immunt': ('immun',),
'immunisert': ('immunisere',),
'immuniserte': ('immunisere',),
'immuniserende': ('immunisere',),
'immunologisk': ('immunologisk',),
'immunologiske': ('immunologisk',),
'immunologisk': ('immunologisk',),
'impenetrabel': ('impenetrabel',),
'impenetrable': ('impenetrabel',),
'impenetrabelt': ('impenetrabel',),
'imperativ': ('imperativ',),
'imperative': ('imperativ',),
'imperativt': ('imperativ',),
'imperativisk': ('imperativisk',),
'imperativiske': ('imperativisk',),
'imperativisk': ('imperativisk',),
'imperfektiv': ('imperfektiv',),
'imperfektive': ('imperfektiv',),
'imperfektivt': ('imperfektiv',),
'imperial': ('imperial',),
'imperiale': ('imperial',),
'imperialt': ('imperial',),
'imperialistisk': ('imperialistisk',),
'imperialistiske': ('imperialistisk',),
'imperialistisk': ('imperialistisk',),
'impermeabel': ('impermeabel',),
'impermeable': ('impermeabel',),
'impermeabelt': ('impermeabel',),
'impertinent': ('impertinent',),
'impertinente': ('impertinent',),
'impertinent': ('impertinent',),
'implantert': ('implantere',),
'implanterte': ('implantere',),
'implanterende': ('implantere',),
'implementert': ('implementere',),
'implementerte': ('implementere',),
'implementerende': ('implementere',),
'implisert': ('implisere',),
'impliserte': ('implisere',),
'impliserende': ('implisere',),
'implisitt': ('implisitt',),
'implisitte': ('implisitt',),
'implisitt': ('implisitt',),
'implodert': ('implodere',),
'imploderte': ('implodere',),
'imploderende': ('implodere',),
'implosjonssikker': ('implosjonssikker',),
'implosjonssikre': ('implosjonssikker',),
'implosjonssikkert': ('implosjonssikker',),
'imponert': ('imponere',),
'imponerte': ('imponere',),
'imponerende': ('imponere',),
'importert': ('importere',),
'importerte': ('importere',),
'importerende': ('importere',),
'imposant': ('imposant',),
'imposante': ('imposant',),
'imposant': ('imposant',),
'impotent': ('impotent',),
'impotente': ('impotent',),
'impotent': ('impotent',),
'impregnert': ('impregnere',),
'impregnerte': ('impregnere',),
'impregnerende': ('impregnere',),
'impresjonistisk': ('impresjonistisk',),
'impresjonistiske': ('impresjonistisk',),
'impresjonistisk': ('impresjonistisk',),
'improvisert': ('improvisere',),
'improviserte': ('improvisere',),
'improviserende': ('improvisere',),
'impulsiv': ('impulsiv',),
'impulsive': ('impulsiv',),
'impulsivt': ('impulsiv',),
'imøtegått': ('imøtegå',),
'imøtegåtte': ('imøtegå',),
'imøtegående': ('imøtegå',),
'imøtesett': ('imøtese',),
'imøtesette': ('imøtese',),
'imøteseende': ('imøtese',),
'in': ('in',),
'inadekvat': ('inadekvat',),
'inadekvate': ('inadekvat',),
'inadekvat': ('inadekvat',),
'inaktiv': ('inaktiv',),
'inaktive': ('inaktiv',),
'inaktivt': ('inaktiv',),
'inaktivert': ('inaktivere',),
'inaktiverte': ('inaktivere',),
'inaktiverende': ('inaktivere',),
'inappellabel': ('inappellabel',),
'inappellable': ('inappellabel',),
'inappellabelt': ('inappellabel',),
'inaugurert': ('inaugurere',),
'inaugurerte': ('inaugurere',),
'inaugurerende': ('inaugurere',),
'incestuøs': ('incestuøs',),
'incestuøse': ('incestuøs',),
'incestuøst': ('incestuøs',),
'incitert': ('incitere',),
'inciterte': ('incitere',),
'inciterende': ('incitere',),
'inderlig': ('inderlig',),
'inderlige': ('inderlig',),
'inderlig': ('inderlig',),
'inderligere': ('inderlig',),
'inderligst': ('inderlig',),
'inderligste': ('inderlig',),
'indiansk': ('indiansk',),
'indianske': ('indiansk',),
'indiansk': ('indiansk',),
'indifferent': ('indifferent',),
'indifferente': ('indifferent',),
'indifferent': ('indifferent',),
'indignert': ('indignert',),
'indignerte': ('indignert',),
'indignert': ('indignert',),
'indigoblå': ('indigoblå',),
'indigoblåe': ('indigoblå',),
'indigoblå': ('indigoblå',),
'indigoblåe': ('indigoblå',),
'indigoblå': ('indigoblå',),
'indigoblått': ('indigoblå',),
'indikativisk': ('indikativisk',),
'indikativiske': ('indikativisk',),
'indikativisk': ('indikativisk',),
'indikert': ('indikere',),
'indikerte': ('indikere',),
'indikerende': ('indikere',),
'indirekte': ('indirekte',),
'indisk': ('indisk',),
'indiske': ('indisk',),
'indisk': ('indisk',),
'indiskre': ('indiskre',),
'indiskree': ('indiskre',),
'indiskre': ('indiskre',),
'indiskree': ('indiskre',),
'indiskre': ('indiskre',),
'indiskutabel': ('indiskutabel',),
'indiskutable': ('indiskutabel',),
'indiskutabelt': ('indiskutabel',),
'indisponert': ('indisponert',),
'indisponerte': ('indisponert',),
'indisponert': ('indisponert',),
'indisponibel': ('indisponibel',),
'indisponible': ('indisponibel',),
'indisponibelt': ('indisponibel',),
'individualisert': ('individualisere',),
'individualiserte': ('individualisere',),
'individualiserende': ('individualisere',),
'individualistisk': ('individualistisk',),
'individualistiske': ('individualistisk',),
'individualistisk': ('individualistisk',),
'individualpreventiv': ('individualpreventiv',),
'individualpreventive': ('individualpreventiv',),
'individualpreventivt': ('individualpreventiv',),
'individuell': ('individuell',),
'individuelle': ('individuell',),
'individuelt': ('individuell',),
'indoarisk': ('indoarisk',),
'indoariske': ('indoarisk',),
'indoarisk': ('indoarisk',),
'indoeuropeisk': ('indoeuropeisk',),
'indoeuropeiske': ('indoeuropeisk',),
'indoeuropeisk': ('indoeuropeisk',),
'indoiransk': ('indoiransk',),
'indoiranske': ('indoiransk',),
'indoiransk': ('indoiransk',),
'indokinesisk': ('indokinesisk',),
'indokinesiske': ('indokinesisk',),
'indokinesisk': ('indokinesisk',),
'indoktrinert': ('indoktrinere',),
'indoktrinerte': ('indoktrinere',),
'indoktrinerende': ('indoktrinere',),
'indolent': ('indolent',),
'indolente': ('indolent',),
'indolent': ('indolent',),
'indonesisk': ('indonesisk',),
'indonesiske': ('indonesisk',),
'indonesisk': ('indonesisk',),
'indre': ('indre',),
'innerst': ('indre',),
'innerste': ('indre',),
'indremedisinsk': ('indremedisinsk',),
'indremedisinske': ('indremedisinsk',),
'indremedisinsk': ('indremedisinsk',),
'indrepolitisk': ('indrepolitisk',),
'indrepolitiske': ('indrepolitisk',),
'indrepolitisk': ('indrepolitisk',),
'indresekretorisk': ('indresekretorisk',),
'indresekretoriske': ('indresekretorisk',),
'indresekretorisk': ('indresekretorisk',),
'induktiv': ('induktiv',),
'induktive': ('induktiv',),
'induktivt': ('induktiv',),
'indusert': ('indusere',),
'induserte': ('indusere',),
'induserende': ('indusere',),
'industrialisert': ('industrialisere',),
'industrialiserte': ('industrialisere',),
'industrialiserende': ('industrialisere',),
'industriell': ('industriell',),
'industrielle': ('industriell',),
'industrielt': ('industriell',),
'ineffektiv': ('ineffektiv',),
'ineffektive': ('ineffektiv',),
'ineffektivt': ('ineffektiv',),
'inert': ('inert',),
'inerte': ('inert',),
'inert': ('inert',),
'infam': ('infam',),
'infame': ('infam',),
'infamt': ('infam',),
'infamert': ('infamere',),
'infamerte': ('infamere',),
'infamerende': ('infamere',),
'infantil': ('infantil',),
'infantile': ('infantil',),
'infantilt': ('infantil',),
'infantilisert': ('infantilisere',),
'infantiliserte': ('infantilisere',),
'infantiliserende': ('infantilisere',),
'infeksiøs': ('infeksiøs',),
'infeksiøse': ('infeksiøs',),
'infeksiøst': ('infeksiøs',),
'inferiør': ('inferiør',),
'inferiøre': ('inferiør',),
'inferiørt': ('inferiør',),
'infernalsk': ('infernalsk',),
'infernalske': ('infernalsk',),
'infernalsk': ('infernalsk',),
'infiltrert': ('infiltrere',),
'infiltrerte': ('infiltrere',),
'infiltrerende': ('infiltrere',),
'infinitt': ('infinitt',),
'infinitte': ('infinitt',),
'infinitt': ('infinitt',),
'infisert': ('infisere',),
'infiserte': ('infisere',),
'infiserende': ('infisere',),
'inflammatorisk': ('inflammatorisk',),
'inflammatoriske': ('inflammatorisk',),
'inflammatorisk': ('inflammatorisk',),
'inflammert': ('inflammere',),
'inflammerte': ('inflammere',),
'inflammerende': ('inflammere',),
'inflasjonistisk': ('inflasjonistisk',),
'inflasjonistiske': ('inflasjonistisk',),
'inflasjonistisk': ('inflasjonistisk',),
'inflasjonsdrivende': ('inflasjonsdrivende',),
'inflatert': ('inflatere',),
'inflaterte': ('inflatere',),
'inflaterende': ('inflatere',),
'inflatorisk': ('inflatorisk',),
'inflatoriske': ('inflatorisk',),
'inflatorisk': ('inflatorisk',),
'influert': ('influere',),
'influerte': ('influere',),
'influerende': ('influere',),
'informativ': ('informativ',),
'informative': ('informativ',),
'informativt': ('informativ',),
'informert': ('informere',),
'informerte': ('informere',),
'informerende': ('informere',),
'infrarød': ('infrarød',),
'infrarøde': ('infrarød',),
'infrarødt': ('infrarød',),
'inhabil': ('inhabil',),
'inhabile': ('inhabil',),
'inhabilt': ('inhabil',),
'inhalert': ('inhalere',),
'inhalerte': ('inhalere',),
'inhalerende': ('inhalere',),
'inherent': ('inherent',),
'inherente': ('inherent',),
'inherent': ('inherent',),
'inherert': ('inherere',),
'inhererte': ('inherere',),
'inhererende': ('inherere',),
'inhibert': ('inhibere',),
'inhiberte': ('inhibere',),
'inhiberende': ('inhibere',),
'inhibitorisk': ('inhibitorisk',),
'inhibitoriske': ('inhibitorisk',),
'inhibitorisk': ('inhibitorisk',),
'inhuman': ('inhuman',),
'inhumane': ('inhuman',),
'inhumant': ('inhuman',),
'initial': ('initial',),
'initiale': ('initial',),
'initialt': ('initial',),
'initiativlaus': ('initiativlaus',),
'initiativlause': ('initiativlaus',),
'initiativlaust': ('initiativlaus',),
'initiativløs': ('initiativløs',),
'initiativløse': ('initiativløs',),
'initiativløst': ('initiativløs',),
'initiativrik': ('initiativrik',),
'initiativrike': ('initiativrik',),
'initiativrikt': ('initiativrik',),
'initiert': ('initiere',),
'initierte': ('initiere',),
'initierende': ('initiere',),
'injisert': ('injisere',),
'injiserte': ('injisere',),
'injiserende': ('injisere',),
'injuriert': ('injuriere',),
'injurierte': ('injuriere',),
'injurierende': ('injuriere',),
'inkapabel': ('inkapabel',),
'inkapable': ('inkapabel',),
'inkapabelt': ('inkapabel',),
'inkarnert': ('inkarnere',),
'inkarnerte': ('inkarnere',),
'inkarnerende': ('inkarnere',),
'inklinert': ('inklinere',),
'inklinerte': ('inklinere',),
'inklinerende': ('inklinere',),
'inkludert': ('inkludere',),
'inkluderte': ('inkludere',),
'inkluderende': ('inkludere',),
'inklusiv': ('inklusiv',),
'inklusive': ('inklusiv',),
'inklusivt': ('inklusiv',),
'inkoativ': ('inkoativ',),
'inkoative': ('inkoativ',),
'inkoativt': ('inkoativ',),
'inkommensurabel': ('inkommensurabel',),
'inkommensurable': ('inkommensurabel',),
'inkommensurabelt': ('inkommensurabel',),
'inkontinent': ('inkontinent',),
'inkontinente': ('inkontinent',),
'inkontinent': ('inkontinent',),
'inkorporert': ('inkorporere',),
'inkorporerte': ('inkorporere',),
'inkorporerende': ('inkorporere',),
'inkvisitorisk': ('inkvisitorisk',),
'inkvisitoriske': ('inkvisitorisk',),
'inkvisitorisk': ('inkvisitorisk',),
'innabords': ('innabords',),
'innabygds': ('innabygds',),
'innabygdsboende': ('innabygdsboende',),
'innabys': ('innabys',),
'innadvendt': ('innadvendt',),
'innadvendte': ('innadvendt',),
'innadvendt': ('innadvendt',),
'innadørs': ('innadørs',),
'innalandsk': ('innalandsk',),
'innalandske': ('innalandsk',),
'innalandsk': ('innalandsk',),
'innanka': ('innanke',),
'innanket': ('innanke',),
'innanka': ('innanke',),
'innanket': ('innanke',),
'innanka': ('innanke',),
'innankete': ('innanke',),
'innankede': ('innanke',),
'innanka': ('innanke',),
'innankete': ('innanke',),
'innankede': ('innanke',),
'innankende': ('innanke',),
'innarbeida': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innarbeidd': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innarbeidd': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidete': ('innarbeide',),
'innarbeidede': ('innarbeide',),
'innarbeidde': ('innarbeide',),
'innarbeida': ('innarbeide',),
'innarbeidete': ('innarbeide',),
'innarbeidede': ('innarbeide',),
'innarbeidde': ('innarbeide',),
'innarbeidende': ('innarbeide',),
'innariks': ('innariks',),
'innariksk': ('innariksk',),
'innarikske': ('innariksk',),
'innariksk': ('innariksk',),
'innbakt': ('innbakt',),
'innbakte': ('innbakt',),
'innbakt': ('innbakt',),
'innballa': ('innballa',),
'innballet': ('innballet',),
'innballete': ('innballet',),
'innballede': ('innballet',),
'innballete': ('innballet',),
'innballede': ('innballet',),
'innballet': ('innballet',),
'innbarka': ('innbarka',),
'innbarket': ('innbarket',),
'innbarkete': ('innbarket',),
'innbarkede': ('innbarket',),
'innbarkete': ('innbarket',),
'innbarkede': ('innbarket',),
'innbarket': ('innbarket',),
'innbefatta': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefattete': ('innbefatte',),
'innbefattede': ('innbefatte',),
'innbefatta': ('innbefatte',),
'innbefattete': ('innbefatte',),
'innbefattede': ('innbefatte',),
'innbefattende': ('innbefatte',),
'innberetta': ('innberette',),
'innberettet': ('innberette',),
'innberetta': ('innberette',),
'innberettet': ('innberette',),
'innberetta': ('innberette',),
'innberettete': ('innberette',),
'innberettede': ('innberette',),
'innberetta': ('innberette',),
'innberettete': ('innberette',),
'innberettede': ('innberette',),
'innberettende': ('innberette',),
'innbetalt': ('innbetale',),
'innbetalte': ('innbetale',),
'innbetalende': ('innbetale',),
'innbilt': ('innbille',),
'innbilte': ('innbille',),
'innbillende': ('innbille',),
'innbilsk': ('innbilsk',),
'innbilske': ('innbilsk',),
'innbilsk': ('innbilsk',),
'innbundet': ('innbinde',),
'innbunden': ('innbinde',),
'innbundne': ('innbinde',),
'innbindende': ('innbinde',),
'innbitt': ('innbitt',),
'innbitte': ('innbitt',),
'innbitt': ('innbitt',),
'innblanda': ('innblande',),
'innblandet': ('innblande',),
'innblanda': ('innblande',),
'innblandet': ('innblande',),
'innblanda': ('innblande',),
'innblandete': ('innblande',),
'innblandede': ('innblande',),
'innblanda': ('innblande',),
'innblandete': ('innblande',),
'innblandede': ('innblande',),
'innblandende': ('innblande',),
'innbrakt': ('innbringe',),
'innbrakte': ('innbringe',),
'innbringende': ('innbringe',),
'innbringende': ('innbringende',),
'innbydd': ('innby',),
'innbudt': ('innby',),
'innbydd': ('innby',),
'innbudt': ('innby',),
'innbydd': ('innby',),
'innbydde': ('innby',),
'innbudte': ('innby',),
'innbydde': ('innby',),
'innbudte': ('innby',),
'innbydde': ('innby',),
'innbyende': ('innby',),
'innbydende': ('innbydende',),
'innbygd': ('innbygd',),
'innbygde': ('innbygd',),
'innbygd': ('innbygd',),
'innbyrdes': ('innbyrdes',),
'inndampa': ('inndampe',),
'inndampet': ('inndampe',),
'inndampa': ('inndampe',),
'inndampet': ('inndampe',),
'inndampa': ('inndampe',),
'inndampete': ('inndampe',),
'inndampede': ('inndampe',),
'inndampa': ('inndampe',),
'inndampete': ('inndampe',),
'inndampede': ('inndampe',),
'inndampende': ('inndampe',),
'inndelt': ('inndele',),
'inndelte': ('inndele',),
'inndelende': ('inndele',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndradd': ('inndra',),
'inndratt': ('inndra',),
'inndradde': ('inndra',),
'inndratte': ('inndra',),
'inndradde': ('inndra',),
'inndratte': ('inndra',),
'inndradde': ('inndra',),
'inndratte': ('inndra',),
'inndradde': ('inndra',),
'inndratte': ('inndra',),
'inndragende': ('inndra',),
'inndrevet': ('inndrive',),
'inndreven': ('inndrive',),
'inndrevne': ('inndrive',),
'inndrivende': ('inndrive',),
'innebygd': ('innebygd',),
'innebygde': ('innebygd',),
'innebygd': ('innebygd',),
'innebåret': ('innebære',),
'innebåren': ('innebære',),
'innebårne': ('innebære',),
'innebærende': ('innebære',),
'innefrosset': ('innefrosset',),
'innefrosne': ('innefrosset',),
'innefrosset': ('innefrosset',),
'innehatt': ('inneha',),
'innehatte': ('inneha',),
'innehaende': ('inneha',),
'inneholdt': ('inneholde',),
'inneholdte': ('inneholde',),
'inneholdende': ('inneholde',),
'inneklemt': ('inneklemt',),
'inneklemte': ('inneklemt',),
'inneklemt': ('inneklemt',),
'inneksersert': ('inneksersere',),
'innekserserte': ('inneksersere',),
'innekserserende': ('inneksersere',),
'innelukka': ('innelukka',),
'innelukket': ('innelukket',),
'innelukkete': ('innelukket',),
'innelukkede': ('innelukket',),
'innelukkete': ('innelukket',),
'innelukkede': ('innelukket',),
'innelukket': ('innelukket',),
'innemurt': ('innemurt',),
'innemurte': ('innemurt',),
'innemurt': ('innemurt',),
'innenbords': ('innenbords',),
'innenbygds': ('innenbygds',),
'innenbygdsboende': ('innenbygdsboende',),
'innenbys': ('innenbys',),
'innendørs': ('innendørs',),
'innenlandsk': ('innenlandsk',),
'innenlandske': ('innenlandsk',),
'innenlandsk': ('innenlandsk',),
'innenriks': ('innenriks',),
'innenriksk': ('innenriksk',),
'innenrikske': ('innenriksk',),
'innenriksk': ('innenriksk',),
'innerst': ('innerst',),
'innerste': ('innerst',),
'innerst': ('innerst',),
'inneslutta': ('inneslutta',),
'innesluttet': ('innesluttet',),
'innesluttete': ('innesluttet',),
'innesluttede': ('innesluttet',),
'innesluttete': ('innesluttet',),
'innesluttede': ('innesluttet',),
'innesluttet': ('innesluttet',),
'innesnødd': ('innesnødd',),
'innesnødde': ('innesnødd',),
'innesnødd': ('innesnødd',),
'innesperra': ('innesperra',),
'innesperret': ('innesperret',),
'innesperrete': ('innesperret',),
'innesperrede': ('innesperret',),
'innesperrete': ('innesperret',),
'innesperrede': ('innesperret',),
'innesperret': ('innesperret',),
'innestengt': ('innestengt',),
'innestengte': ('innestengt',),
'innestengt': ('innestengt',),
'innett': ('innett',),
'innette': ('innett',),
'innett': ('innett',),
'inneværende': ('inneværende',),
'innfallen': ('innfallen',),
'innfalne': ('innfallen',),
'innfallent': ('innfallen',),
'innfallsrik': ('innfallsrik',),
'innfallsrike': ('innfallsrik',),
'innfallsrikt': ('innfallsrik',),
'innfatta': ('innfatte',),
'innfattet': ('innfatte',),
'innfatta': ('innfatte',),
'innfattet': ('innfatte',),
'innfatta': ('innfatte',),
'innfattete': ('innfatte',),
'innfattede': ('innfatte',),
'innfatta': ('innfatte',),
'innfattete': ('innfatte',),
'innfattede': ('innfatte',),
'innfattende': ('innfatte',),
'innfelt': ('innfelle',),
'innfelte': ('innfelle',),
'innfellende': ('innfelle',),
'innfiltra': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltrete': ('innfiltre',),
'innfiltrede': ('innfiltre',),
'innfiltrete': ('innfiltre',),
'innfiltrede': ('innfiltre',),
'innfiltra': ('innfiltre',),
'innfiltrete': ('innfiltre',),
'innfiltrede': ('innfiltre',),
'innfiltrete': ('innfiltre',),
'innfiltrede': ('innfiltre',),
'innfiltrende': ('innfiltre',),
'innfunnet': ('innfinne',),
'innfunnen': ('innfinne',),
'innfunne': ('innfinne',),
'innfinnende': ('innfinne',),
'innfletta': ('innfletta',),
'innflettet': ('innflettet',),
'innflettete': ('innflettet',),
'innflettede': ('innflettet',),
'innflettete': ('innflettet',),
'innflettede': ('innflettet',),
'innflettet': ('innflettet',),
'innflytelsesrik': ('innflytelsesrik',),
'innflytelsesrike': ('innflytelsesrik',),
'innflytelsesrikt': ('innflytelsesrik',),
'innflytningsklar': ('innflytningsklar',),
'innflytningsklare': ('innflytningsklar',),
'innflytningsklart': ('innflytningsklar',),
'innflyttingsklar': ('innflyttingsklar',),
'innflyttingsklare': ('innflyttingsklar',),
'innflyttingsklart': ('innflyttingsklar',),
'innfløkt': ('innfløkt',),
'innfløkte': ('innfløkt',),
'innfløkt': ('innfløkt',),
'innforliva': ('innforlive',),
'innforlivet': ('innforlive',),
'innforliva': ('innforlive',),
'innforlivet': ('innforlive',),
'innforliva': ('innforlive',),
'innforlivete': ('innforlive',),
'innforlivede': ('innforlive',),
'innforliva': ('innforlive',),
'innforlivete': ('innforlive',),
'innforlivede': ('innforlive',),
'innforlivende': ('innforlive',),
'innforstått': ('innforstått',),
'innforståtte': ('innforstått',),
'innforstått': ('innforstått',),
'innfridd': ('innfri',),
'innfridde': ('innfri',),
'innfriende': ('innfri',),
'innful': ('innful',),
'innfule': ('innful',),
'innfult': ('innful',),
'innfødt': ('innfødt',),
'innfødte': ('innfødt',),
'innfødt': ('innfødt',),
'innført': ('innføre',),
'innførte': ('innføre',),
'innførende': ('innføre',),
'innføyet': ('innføye',),
'innføyd': ('innføye',),
'innføyet': ('innføye',),
'innføyd': ('innføye',),
'innføyete': ('innføye',),
'innføyede': ('innføye',),
'innføyde': ('innføye',),
'innføyete': ('innføye',),
'innføyede': ('innføye',),
'innføyde': ('innføye',),
'innføyende': ('innføye',),
'inngitt': ('inngi',),
'inngitte': ('inngi',),
'inngiende': ('inngi',),
'inngifta': ('inngifta',),
'inngifta': ('inngifte',),
'inngiftet': ('inngifte',),
'inngifta': ('inngifte',),
'inngiftet': ('inngifte',),
'inngifta': ('inngifte',),
'inngiftete': ('inngifte',),
'inngiftede': ('inngifte',),
'inngifta': ('inngifte',),
'inngiftete': ('inngifte',),
'inngiftede': ('inngifte',),
'inngiftende': ('inngifte',),
'inngiftet': ('inngiftet',),
'inngiftete': ('inngiftet',),
'inngiftede': ('inngiftet',),
'inngiftete': ('inngiftet',),
'inngiftede': ('inngiftet',),
'inngiftet': ('inngiftet',),
'inngjerda': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerdete': ('inngjerde',),
'inngjerdede': ('inngjerde',),
'inngjerda': ('inngjerde',),
'inngjerdete': ('inngjerde',),
'inngjerdede': ('inngjerde',),
'inngjerdende': ('inngjerde',),
'inngnidd': ('inngnidd',),
'inngnidde': ('inngnidd',),
'inngnidd': ('inngnidd',),
'inngravert': ('inngravere',),
'inngraverte': ('inngravere',),
'inngraverende': ('inngravere',),
'inngripende': ('inngripende',),
'inngrodd': ('inngrodd',),
'inngrodde': ('inngrodd',),
'inngrodd': ('inngrodd',),
'inngytt': ('inngyte',),
'inngytte': ('inngyte',),
'inngytende': ('inngyte',),
'inngått': ('inngå',),
'inngåtte': ('inngå',),
'inngående': ('inngå',),
'inngående': ('inngående',),
'innhegna': ('innhegne',),
'innhegnet': ('innhegne',),
'innhegna': ('innhegne',),
'innhegnet': ('innhegne',),
'innhegna': ('innhegne',),
'innhegnete': ('innhegne',),
'innhegnede': ('innhegne',),
'innhegna': ('innhegne',),
'innhegnete': ('innhegne',),
'innhegnede': ('innhegne',),
'innhegnende': ('innhegne',),
'innhenta': ('innhente',),
'innhentet': ('innhente',),
'innhenta': ('innhente',),
'innhentet': ('innhente',),
'innhenta': ('innhente',),
'innhentete': ('innhente',),
'innhentede': ('innhente',),
'innhenta': ('innhente',),
'innhentete': ('innhente',),
'innhentede': ('innhente',),
'innhentende': ('innhente',),
'innhogd': ('innhogd',),
'innhogde': ('innhogd',),
'innhogd': ('innhogd',),
'innhol': ('innhol',),
'innhole': ('innhol',),
'innholt': ('innhol',),
'innholdslaus': ('innholdslaus',),
'innholdslause': ('innholdslaus',),
'innholdslaust': ('innholdslaus',),
'innholdsløs': ('innholdsløs',),
'innholdsløse': ('innholdsløs',),
'innholdsløst': ('innholdsløs',),
'innholdsrik': ('innholdsrik',),
'innholdsrike': ('innholdsrik',),
'innholdsrikt': ('innholdsrik',),
'innhul': ('innhul',),
'innhule': ('innhul',),
'innhult': ('innhul',),
'innhylla': ('innhylle',),
'innhyllet': ('innhylle',),
'innhylla': ('innhylle',),
'innhyllet': ('innhylle',),
'innhylla': ('innhylle',),
'innhyllete': ('innhylle',),
'innhyllede': ('innhylle',),
'innhylla': ('innhylle',),
'innhyllete': ('innhylle',),
'innhyllede': ('innhylle',),
'innhyllende': ('innhylle',),
'innhøsta': ('innhøste',),
'innhøstet': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøstet': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøstete': ('innhøste',),
'innhøstede': ('innhøste',),
'innhøsta': ('innhøste',),
'innhøstete': ('innhøste',),
'innhøstede': ('innhøste',),
'innhøstende': ('innhøste',),
'innkalkulert': ('innkalkulere',),
'innkalkulerte': ('innkalkulere',),
'innkalkulerende': ('innkalkulere',),
'innkalt': ('innkalle',),
'innkalte': ('innkalle',),
'innkallende': ('innkalle',),
'innkapsla': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapslete': ('innkapsle',),
'innkapslede': ('innkapsle',),
'innkapslete': ('innkapsle',),
'innkapslede': ('innkapsle',),
'innkapsla': ('innkapsle',),
'innkapslete': ('innkapsle',),
'innkapslede': ('innkapsle',),
'innkapslete': ('innkapsle',),
'innkapslede': ('innkapsle',),
'innkapslende': ('innkapsle',),
'innkassert': ('innkassere',),
'innkasserte': ('innkassere',),
'innkasserende': ('innkassere',),
'innkasta': ('innkaste',),
'innkastet': ('innkaste',),
'innkasta': ('innkaste',),
'innkastet': ('innkaste',),
'innkasta': ('innkaste',),
'innkastete': ('innkaste',),
'innkastede': ('innkaste',),
'innkasta': ('innkaste',),
'innkastete': ('innkaste',),
'innkastede': ('innkaste',),
'innkastende': ('innkaste',),
'innkilt': ('innkilt',),
'innkilte': ('innkilt',),
'innkilt': ('innkilt',),
'innkjøpt': ('innkjøpt',),
'innkjøpte': ('innkjøpt',),
'innkjøpt': ('innkjøpt',),
'innkjørt': ('innkjøre',),
'innkjørte': ('innkjøre',),
'innkjørende': ('innkjøre',),
'innklaga': ('innklage',),
'innklaget': ('innklage',),
'innklagd': ('innklage',),
'innklaga': ('innklage',),
'innklaget': ('innklage',),
'innklagd': ('innklage',),
'innklaga': ('innklage',),
'innklagete': ('innklage',),
'innklagede': ('innklage',),
'innklagde': ('innklage',),
'innklaga': ('innklage',),
'innklagete': ('innklage',),
'innklagede': ('innklage',),
'innklagde': ('innklage',),
'innklagende': ('innklage',),
'innklarert': ('innklarere',),
'innklarerte': ('innklarere',),
'innklarerende': ('innklarere',),
'innklemt': ('innklemt',),
'innklemte': ('innklemt',),
'innklemt': ('innklemt',),
'innklint': ('innklint',),
'innklinte': ('innklint',),
'innklint': ('innklint',),
'innkobla': ('innkoble',),
'innkoblet': ('innkoble',),
'innkobla': ('innkoble',),
'innkoblet': ('innkoble',),
'innkobla': ('innkoble',),
'innkoblete': ('innkoble',),
'innkoblede': ('innkoble',),
'innkoblete': ('innkoble',),
'innkoblede': ('innkoble',),
'innkobla': ('innkoble',),
'innkoblete': ('innkoble',),
'innkoblede': ('innkoble',),
'innkoblete': ('innkoble',),
'innkoblede': ('innkoble',),
'innkoblende': ('innkoble',),
'innkokt': ('innkokt',),
'innkokte': ('innkokt',),
'innkokt': ('innkokt',),
'innkommandert': ('innkommandere',),
'innkommanderte': ('innkommandere',),
'innkommanderende': ('innkommandere',),
'innkommet': ('innkomme',),
'innkommen': ('innkomme',),
'innkomne': ('innkomme',),
'innkommende': ('innkomme',),
'innkopla': ('innkople',),
'innkoplet': ('innkople',),
'innkopla': ('innkople',),
'innkoplet': ('innkople',),
'innkopla': ('innkople',),
'innkoplete': ('innkople',),
'innkoplede': ('innkople',),
'innkoplete': ('innkople',),
'innkoplede': ('innkople',),
'innkopla': ('innkople',),
'innkoplete': ('innkople',),
'innkoplede': ('innkople',),
'innkoplete': ('innkople',),
'innkoplede': ('innkople',),
'innkoplende': ('innkople',),
'innkorta': ('innkorte',),
'innkortet': ('innkorte',),
'innkorta': ('innkorte',),
'innkortet': ('innkorte',),
'innkorta': ('innkorte',),
'innkortete': ('innkorte',),
'innkortede': ('innkorte',),
'innkorta': ('innkorte',),
'innkortete': ('innkorte',),
'innkortede': ('innkorte',),
'innkortende': ('innkorte',),
'innkrevet': ('innkreve',),
'innkrevd': ('innkreve',),
'innkrevet': ('innkreve',),
'innkrevd': ('innkreve',),
'innkrevete': ('innkreve',),
'innkrevede': ('innkreve',),
'innkrevde': ('innkreve',),
'innkrevete': ('innkreve',),
'innkrevede': ('innkreve',),
'innkrevde': ('innkreve',),
'innkrevende': ('innkreve',),
'innkvartert': ('innkvartere',),
'innkvarterte': ('innkvartere',),
'innkvarterende': ('innkvartere',),
'innlagt': ('innlagt',),
'innlagte': ('innlagt',),
'innlagt': ('innlagt',),
'innlasta': ('innlasta',),
'innlastet': ('innlastet',),
'innlastete': ('innlastet',),
'innlastede': ('innlastet',),
'innlastete': ('innlastet',),
'innlastede': ('innlastet',),
'innlastet': ('innlastet',),
'innlatt': ('innlate',),
'innlatte': ('innlate',),
'innlatende': ('innlate',),
'innleda': ('innlede',),
'innledet': ('innlede',),
'innleda': ('innlede',),
'innledet': ('innlede',),
'innleda': ('innlede',),
'innledete': ('innlede',),
'innledede': ('innlede',),
'innleda': ('innlede',),
'innledete': ('innlede',),
'innledede': ('innlede',),
'innledende': ('innlede',),
'innlagt': ('innlegge',),
'innlagte': ('innlegge',),
'innleggende': ('innlegge',),
'innleid': ('innleie',),
'innleide': ('innleie',),
'innleiende': ('innleie',),
'innlemma': ('innlemme',),
'innlemmet': ('innlemme',),
'innlemma': ('innlemme',),
'innlemmet': ('innlemme',),
'innlemma': ('innlemme',),
'innlemmete': ('innlemme',),
'innlemmede': ('innlemme',),
'innlemma': ('innlemme',),
'innlemmete': ('innlemme',),
'innlemmede': ('innlemme',),
'innlemmende': ('innlemme',),
'innlest': ('innlese',),
'innleste': ('innlese',),
'innlesende': ('innlese',),
'innlevert': ('innlevere',),
'innleverte': ('innlevere',),
'innleverende': ('innlevere',),
'innlosjert': ('innlosjere',),
'innlosjerte': ('innlosjere',),
'innlosjerende': ('innlosjere',),
'innlysende': ('innlysende',),
'innlånt': ('innlåne',),
'innlånte': ('innlåne',),
'innlånende': ('innlåne',),
'innlåst': ('innlåst',),
'innlåste': ('innlåst',),
'innlåst': ('innlåst',),
'innlært': ('innlært',),
'innlærte': ('innlært',),
'innlært': ('innlært',),
'innløpt': ('innløpe',),
'innløpet': ('innløpe',),
'innløpt': ('innløpe',),
'innløpet': ('innløpe',),
'innløpte': ('innløpe',),
'innløpende': ('innløpe',),
'innløst': ('innløse',),
'innløste': ('innløse',),
'innløsende': ('innløse',),
'innløselig': ('innløselig',),
'innløselige': ('innløselig',),
'innløselig': ('innløselig',),
'innløyst': ('innløyse',),
'innløyste': ('innløyse',),
'innløysende': ('innløyse',),
'innløyselig': ('innløyselig',),
'innløyselige': ('innløyselig',),
'innløyselig': ('innløyselig',),
'innmari': ('innmari',),
'innmarisk': ('innmarisk',),
'innmariske': ('innmarisk',),
'innmarisk': ('innmarisk',),
'innmeldt': ('innmeldt',),
'innmeldte': ('innmeldt',),
'innmeldt': ('innmeldt',),
'innmura': ('innmure',),
'innmuret': ('innmure',),
'innmurt': ('innmure',),
'innmura': ('innmure',),
'innmuret': ('innmure',),
'innmurt': ('innmure',),
'innmura': ('innmure',),
'innmurete': ('innmure',),
'innmurede': ('innmure',),
'innmurte': ('innmure',),
'innmura': ('innmure',),
'innmurete': ('innmure',),
'innmurede': ('innmure',),
'innmurte': ('innmure',),
'innmurende': ('innmure',),
'innordna': ('innordne',),
'innordnet': ('innordne',),
'innordna': ('innordne',),
'innordnet': ('innordne',),
'innordna': ('innordne',),
'innordnete': ('innordne',),
'innordnede': ('innordne',),
'innordnete': ('innordne',),
'innordnede': ('innordne',),
'innordna': ('innordne',),
'innordnete': ('innordne',),
'innordnede': ('innordne',),
'innordnete': ('innordne',),
'innordnede': ('innordne',),
'innordnende': ('innordne',),
'innovativ': ('innovativ',),
'innovative': ('innovativ',),
'innovativt': ('innovativ',),
'innovert': ('innovere',),
'innoverte': ('innovere',),
'innoverende': ('innovere',),
'innpakka': ('innpakke',),
'innpakket': ('innpakke',),
'innpakka': ('innpakke',),
'innpakket': ('innpakke',),
'innpakka': ('innpakke',),
'innpakkete': ('innpakke',),
'innpakkede': ('innpakke',),
'innpakka': ('innpakke',),
'innpakkete': ('innpakke',),
'innpakkede': ('innpakke',),
'innpakkende': ('innpakke',),
'innpassa': ('innpasse',),
'innpasset': ('innpasse',),
'innpassa': ('innpasse',),
'innpasset': ('innpasse',),
'innpassa': ('innpasse',),
'innpassete': ('innpasse',),
'innpassede': ('innpasse',),
'innpassa': ('innpasse',),
'innpassete': ('innpasse',),
'innpassede': ('innpasse',),
'innpassende': ('innpasse',),
'innpassert': ('innpassere',),
'innpasserte': ('innpassere',),
'innpasserende': ('innpassere',),
'innpiska': ('innpiske',),
'innpisket': ('innpiske',),
'innpiska': ('innpiske',),
'innpisket': ('innpiske',),
'innpiska': ('innpiske',),
'innpiskete': ('innpiske',),
'innpiskede': ('innpiske',),
'innpiska': ('innpiske',),
'innpiskete': ('innpiske',),
'innpiskede': ('innpiske',),
'innpiskende': ('innpiske',),
'innplanta': ('innplante',),
'innplantet': ('innplante',),
'innplanta': ('innplante',),
'innplantet': ('innplante',),
'innplanta': ('innplante',),
'innplantete': ('innplante',),
'innplantede': ('innplante',),
'innplanta': ('innplante',),
'innplantete': ('innplante',),
'innplantede': ('innplante',),
'innplantende': ('innplante',),
'innpoda': ('innpode',),
'innpodet': ('innpode',),
'innpoda': ('innpode',),
'innpodet': ('innpode',),
'innpoda': ('innpode',),
'innpodete': ('innpode',),
'innpodede': ('innpode',),
'innpoda': ('innpode',),
'innpodete': ('innpode',),
'innpodede': ('innpode',),
'innpodende': ('innpode',),
'innprenta': ('innprente',),
'innprentet': ('innprente',),
'innprenta': ('innprente',),
'innprentet': ('innprente',),
'innprenta': ('innprente',),
'innprentete': ('innprente',),
'innprentede': ('innprente',),
'innprenta': ('innprente',),
'innprentete': ('innprente',),
'innprentede': ('innprente',),
'innprentende': ('innprente',),
'innpåsliten': ('innpåsliten',),
'innpåslitne': ('innpåsliten',),
'innpåslitent': ('innpåsliten',),
'innramma': ('innramme',),
'innrammet': ('innramme',),
'innramma': ('innramme',),
'innrammet': ('innramme',),
'innramma': ('innramme',),
'innrammete': ('innramme',),
'innrammede': ('innramme',),
'innramma': ('innramme',),
'innrammete': ('innramme',),
'innrammede': ('innramme',),
'innrammende': ('innramme',),
'innrapportert': ('innrapportere',),
'innrapporterte': ('innrapportere',),
'innrapporterende': ('innrapportere',),
'innreda': ('innrede',),
'innredet': ('innrede',),
'innreda': ('innrede',),
'innredet': ('innrede',),
'innreda': ('innrede',),
'innredete': ('innrede',),
'innredede': ('innrede',),
'innreda': ('innrede',),
'innredete': ('innrede',),
'innredede': ('innrede',),
'innredende': ('innrede',),
'innreid': ('innreie',),
'innreide': ('innreie',),
'innreiende': ('innreie',),
'innretta': ('innrette',),
'innrettet': ('innrette',),
'innretta': ('innrette',),
'innrettet': ('innrette',),
'innretta': ('innrette',),
'innrettete': ('innrette',),
'innrettede': ('innrette',),
'innretta': ('innrette',),
'innrettete': ('innrette',),
'innrettede': ('innrette',),
'innrettende': ('innrette',),
'innrigga': ('innrigga',),
'innrigget': ('innrigget',),
'innriggete': ('innrigget',),
'innriggede': ('innrigget',),
'innriggete': ('innrigget',),
'innriggede': ('innrigget',),
'innrigget': ('innrigget',),
'innringa': ('innringe',),
'innringet': ('innringe',),
'innringa': ('innringe',),
'innringet': ('innringe',),
'innringa': ('innringe',),
'innringete': ('innringe',),
'innringede': ('innringe',),
'innringa': ('innringe',),
'innringete': ('innringe',),
'innringede': ('innringe',),
'innringende': ('innringe',),
'innrissa': ('innrissa',),
'innrisset': ('innrisset',),
'innrissete': ('innrisset',),
'innrissede': ('innrisset',),
'innrissete': ('innrisset',),
'innrissede': ('innrisset',),
'innrisset': ('innrisset',),
'innrullert': ('innrullere',),
'innrullerte': ('innrullere',),
'innrullerende': ('innrullere',),
'innrykka': ('innrykke',),
'innrykket': ('innrykke',),
'innrykt': ('innrykke',),
'innrykka': ('innrykke',),
'innrykket': ('innrykke',),
'innrykt': ('innrykke',),
'innrykka': ('innrykke',),
'innrykkete': ('innrykke',),
'innrykkede': ('innrykke',),
'innrykte': ('innrykke',),
'innrykka': ('innrykke',),
'innrykkete': ('innrykke',),
'innrykkede': ('innrykke',),
'innrykte': ('innrykke',),
'innrykkende': ('innrykke',),
'innrømma': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømt': ('innrømme',),
'innrømma': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømt': ('innrømme',),
'innrømma': ('innrømme',),
'innrømmete': ('innrømme',),
'innrømmede': ('innrømme',),
'innrømte': ('innrømme',),
'innrømma': ('innrømme',),
'innrømmete': ('innrømme',),
'innrømmede': ('innrømme',),
'innrømte': ('innrømme',),
'innrømmende': ('innrømme',),
'innrøykt': ('innrøykt',),
'innrøykte': ('innrøykt',),
'innrøykt': ('innrøykt',),
'innsamla': ('innsamle',),
'innsamlet': ('innsamle',),
'innsamla': ('innsamle',),
'innsamlet': ('innsamle',),
'innsamla': ('innsamle',),
'innsamlete': ('innsamle',),
'innsamlede': ('innsamle',),
'innsamlete': ('innsamle',),
'innsamlede': ('innsamle',),
'innsamla': ('innsamle',),
'innsamlete': ('innsamle',),
'innsamlede': ('innsamle',),
'innsamlete': ('innsamle',),
'innsamlede': ('innsamle',),
'innsamlende': ('innsamle',),
'innsatt': ('innsatt',),
'innsatte': ('innsatt',),
'innsatt': ('innsatt',),
'innsausa': ('innsausa',),
'innsauset': ('innsauset',),
'innsausete': ('innsauset',),
'innsausede': ('innsauset',),
'innsausete': ('innsauset',),
'innsausede': ('innsauset',),
'innsauset': ('innsauset',),
'innsett': ('innse',),
'innsette': ('innse',),
'innseende': ('innse',),
'innsegla': ('innsegle',),
'innseglet': ('innsegle',),
'innsegla': ('innsegle',),
'innseglet': ('innsegle',),
'innsegla': ('innsegle',),
'innseglete': ('innsegle',),
'innseglede': ('innsegle',),
'innseglete': ('innsegle',),
'innseglede': ('innsegle',),
'innsegla': ('innsegle',),
'innseglete': ('innsegle',),
'innseglede': ('innsegle',),
'innseglete': ('innsegle',),
'innseglede': ('innsegle',),
'innseglende': ('innsegle',),
'innseilt': ('innseile',),
'innseilte': ('innseile',),
'innseilende': ('innseile',),
'innsendt': ('innsende',),
'innsendte': ('innsende',),
'innsendende': ('innsende',),
'innsatt': ('innsette',),
'innsatte': ('innsette',),
'innsettende': ('innsette',),
'innsikta': ('innsikte',),
'innsiktet': ('innsikte',),
'innsikta': ('innsikte',),
'innsiktet': ('innsikte',),
'innsikta': ('innsikte',),
'innsiktete': ('innsikte',),
'innsiktede': ('innsikte',),
'innsikta': ('innsikte',),
'innsiktete': ('innsikte',),
'innsiktede': ('innsikte',),
'innsiktende': ('innsikte',),
'innsiktsfull': ('innsiktsfull',),
'innsiktsfulle': ('innsiktsfull',),
'innsiktsfullt': ('innsiktsfull',),
'innsirkla': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirklete': ('innsirkle',),
'innsirklede': ('innsirkle',),
'innsirklete': ('innsirkle',),
'innsirklede': ('innsirkle',),
'innsirkla': ('innsirkle',),
'innsirklete': ('innsirkle',),
'innsirklede': ('innsirkle',),
'innsirklete': ('innsirkle',),
'innsirklede': ('innsirkle',),
'innsirklende': ('innsirkle',),
'innskipa': ('innskipe',),
'innskipet': ('innskipe',),
'innskipa': ('innskipe',),
'innskipet': ('innskipe',),
'innskipa': ('innskipe',),
'innskipete': ('innskipe',),
'innskipede': ('innskipe',),
'innskipa': ('innskipe',),
'innskipete': ('innskipe',),
'innskipede': ('innskipe',),
'innskipende': ('innskipe',),
'innskjerpa': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpete': ('innskjerpe',),
'innskjerpede': ('innskjerpe',),
'innskjerpa': ('innskjerpe',),
'innskjerpete': ('innskjerpe',),
'innskjerpede': ('innskjerpe',),
'innskjerpende': ('innskjerpe',),
'innskåret': ('innskjære',),
'innskåren': ('innskjære',),
'innskårne': ('innskjære',),
'innskjærende': ('innskjære',),
'innskrenka': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenkete': ('innskrenke',),
'innskrenkede': ('innskrenke',),
'innskrenka': ('innskrenke',),
'innskrenkete': ('innskrenke',),
'innskrenkede': ('innskrenke',),
'innskrenkende': ('innskrenke',),
'innskrevet': ('innskrive',),
'innskreven': ('innskrive',),
'innskrevne': ('innskrive',),
'innskrivende': ('innskrive',),
'innskrumpa': ('innskrumpa',),
'innskrumpet': ('innskrumpet',),
'innskrumpete': ('innskrumpet',),
'innskrumpede': ('innskrumpet',),
'innskrumpete': ('innskrumpet',),
'innskrumpede': ('innskrumpet',),
'innskrumpet': ('innskrumpet',),
'innskutt': ('innskyte',),
'innskutte': ('innskyte',),
'innskytende': ('innskyte',),
'innslått': ('innslått',),
'innslåtte': ('innslått',),
'innslått': ('innslått',),
'innsmigra': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigrete': ('innsmigre',),
'innsmigrede': ('innsmigre',),
'innsmigrete': ('innsmigre',),
'innsmigrede': ('innsmigre',),
'innsmigra': ('innsmigre',),
'innsmigrete': ('innsmigre',),
'innsmigrede': ('innsmigre',),
'innsmigrete': ('innsmigre',),
'innsmigrede': ('innsmigre',),
'innsmigrende': ('innsmigre',),
'innsmugla': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmuglete': ('innsmugle',),
'innsmuglede': ('innsmugle',),
'innsmuglete': ('innsmugle',),
'innsmuglede': ('innsmugle',),
'innsmugla': ('innsmugle',),
'innsmuglete': ('innsmugle',),
'innsmuglede': ('innsmugle',),
'innsmuglete': ('innsmugle',),
'innsmuglede': ('innsmugle',),
'innsmuglende': ('innsmugle',),
'innsmurt': ('innsmøre',),
'innsmurte': ('innsmøre',),
'innsmørende': ('innsmøre',),
'innsnevra': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevrete': ('innsnevre',),
'innsnevrede': ('innsnevre',),
'innsnevra': ('innsnevre',),
'innsnevrete': ('innsnevre',),
'innsnevrede': ('innsnevre',),
'innsnevrende': ('innsnevre',),
'innsnørt': ('innsnørt',),
'innsnørte': ('innsnørt',),
'innsnørt': ('innsnørt',),
'innspart': ('innspart',),
'innsparte': ('innspart',),
'innspart': ('innspart',),
'innspilt': ('innspilt',),
'innspilte': ('innspilt',),
'innspilt': ('innspilt',),
'innsprengt': ('innsprengt',),
'innsprengte': ('innsprengt',),
'innsprengt': ('innsprengt',),
'innsprøyta': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøytete': ('innsprøyte',),
'innsprøytede': ('innsprøyte',),
'innsprøyta': ('innsprøyte',),
'innsprøytete': ('innsprøyte',),
'innsprøytede': ('innsprøyte',),
'innsprøytende': ('innsprøyte',),
'innspunnet': ('innspunnet',),
'innspunne': ('innspunnet',),
'innspunnet': ('innspunnet',),
'innstendig': ('innstendig',),
'innstendige': ('innstendig',),
'innstendig': ('innstendig',),
'innstevna': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnete': ('innstevne',),
'innstevnede': ('innstevne',),
'innstevnte': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnete': ('innstevne',),
'innstevnede': ('innstevne',),
'innstevnte': ('innstevne',),
'innstevnende': ('innstevne',),
'innstifta': ('innstifte',),
'innstiftet': ('innstifte',),
'innstifta': ('innstifte',),
'innstiftet': ('innstifte',),
'innstifta': ('innstifte',),
'innstiftete': ('innstifte',),
'innstiftede': ('innstifte',),
'innstifta': ('innstifte',),
'innstiftete': ('innstifte',),
'innstiftede': ('innstifte',),
'innstiftende': ('innstifte',),
'innstilt': ('innstille',),
'innstilte': ('innstille',),
'innstillende': ('innstille',),
'innstramma': ('innstramme',),
'innstrammet': ('innstramme',),
'innstramma': ('innstramme',),
'innstrammet': ('innstramme',),
'innstramma': ('innstramme',),
'innstrammete': ('innstramme',),
'innstrammede': ('innstramme',),
'innstramma': ('innstramme',),
'innstrammete': ('innstramme',),
'innstrammede': ('innstramme',),
'innstrammende': ('innstramme',),
'innstudert': ('innstudere',),
'innstuderte': ('innstudere',),
'innstuderende': ('innstudere',),
'innstukket': ('innstukket',),
'innstukne': ('innstukket',),
'innstukket': ('innstukket',),
'innstøpt': ('innstøpe',),
'innstøpte': ('innstøpe',),
'innstøpende': ('innstøpe',),
'innstøypt': ('innstøype',),
'innstøypte': ('innstøype',),
'innstøypende': ('innstøype',),
'innsuga': ('innsuge',),
'innsuget': ('innsuge',),
'innsugd': ('innsuge',),
'innsuga': ('innsuge',),
'innsuget': ('innsuge',),
'innsugd': ('innsuge',),
'innsuga': ('innsuge',),
'innsugete': ('innsuge',),
'innsugede': ('innsuge',),
'innsugde': ('innsuge',),
'innsuga': ('innsuge',),
'innsugete': ('innsuge',),
'innsugede': ('innsuge',),
'innsugde': ('innsuge',),
'innsugende': ('innsuge',),
'innsunket': ('innsunket',),
'innsunkne': ('innsunket',),
'innsunket': ('innsunket',),
'innsvinga': ('innsvinga',),
'innsvinget': ('innsvinget',),
'innsvingete': ('innsvinget',),
'innsvingede': ('innsvinget',),
'innsvingete': ('innsvinget',),
'innsvingede': ('innsvinget',),
'innsvinget': ('innsvinget',),
'innsvingt': ('innsvingt',),
'innsvingte': ('innsvingt',),
'innsvingt': ('innsvingt',),
'innsvøpt': ('innsvøpt',),
'innsvøpte': ('innsvøpt',),
'innsvøpt': ('innsvøpt',),
'innsydd': ('innsydd',),
'innsydde': ('innsydd',),
'innsydd': ('innsydd',),
'innsunget': ('innsynge',),
'innsungen': ('innsynge',),
'innsungne': ('innsynge',),
'innsyngende': ('innsynge',),
'innsåpa': ('innsåpa',),
'innsåpet': ('innsåpet',),
'innsåpete': ('innsåpet',),
'innsåpede': ('innsåpet',),
'innsåpete': ('innsåpet',),
'innsåpede': ('innsåpet',),
'innsåpet': ('innsåpet',),
'innsåpt': ('innsåpt',),
'innsåpte': ('innsåpt',),
'innsåpt': ('innsåpt',),
'inntatt': ('innta',),
'inntatte': ('innta',),
'inntakende': ('innta',),
'inntagende': ('inntagende',),
'inntakende': ('inntakende',),
'inntasta': ('inntaste',),
'inntastet': ('inntaste',),
'inntasta': ('inntaste',),
'inntastet': ('inntaste',),
'inntasta': ('inntaste',),
'inntastete': ('inntaste',),
'inntastede': ('inntaste',),
'inntasta': ('inntaste',),
'inntastete': ('inntaste',),
'inntastede': ('inntaste',),
'inntastende': ('inntaste',),
'inntatt': ('inntatt',),
'inntatte': ('inntatt',),
'inntatt': ('inntatt',),
'inntegna': ('inntegne',),
'inntegnet': ('inntegne',),
'inntegna': ('inntegne',),
'inntegnet': ('inntegne',),
'inntegna': ('inntegne',),
'inntegnete': ('inntegne',),
'inntegnede': ('inntegne',),
'inntegna': ('inntegne',),
'inntegnete': ('inntegne',),
'inntegnede': ('inntegne',),
'inntegnende': ('inntegne',),
'inntektsgivende': ('inntektsgivende',),
'inntilbeins': ('inntilbeins',),
'inntilbens': ('inntilbens',),
'inntjent': ('inntjent',),
'inntjente': ('inntjent',),
'inntjent': ('inntjent',),
'inntrådt': ('inntre',),
'inntrådte': ('inntre',),
'inntredende': ('inntre',),
'inntruffet': ('inntreffe',),
'inntruffen': ('inntreffe',),
'inntrufne': ('inntreffe',),
'inntreffende': ('inntreffe',),
'inntrengende': ('inntrengende',),
'inntrykksøm': ('inntrykksøm',),
'inntrykksømme': ('inntrykksøm',),
'inntrykksømt': ('inntrykksøm',),
'inntrykt': ('inntrykt',),
'inntrykte': ('inntrykt',),
'inntrykt': ('inntrykt',),
'inntulla': ('inntulla',),
'inntullet': ('inntullet',),
'inntullete': ('inntullet',),
'inntullede': ('inntullet',),
'inntullete': ('inntullet',),
'inntullede': ('inntullet',),
'inntullet': ('inntullet',),
'inntørka': ('inntørka',),
'inntørket': ('inntørket',),
'inntørkete': ('inntørket',),
'inntørkede': ('inntørket',),
'inntørkete': ('inntørket',),
'inntørkede': ('inntørket',),
'inntørket': ('inntørket',),
'innvandra': ('innvandre',),
'innvandret': ('innvandre',),
'innvandra': ('innvandre',),
'innvandret': ('innvandre',),
'innvandra': ('innvandre',),
'innvandrete': ('innvandre',),
'innvandrede': ('innvandre',),
'innvandrete': ('innvandre',),
'innvandrede': ('innvandre',),
'innvandra': ('innvandre',),
'innvandrete': ('innvandre',),
'innvandrede': ('innvandre',),
'innvandrete': ('innvandre',),
'innvandrede': ('innvandre',),
'innvandrende': ('innvandre',),
'innvarsla': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarslete': ('innvarsle',),
'innvarslede': ('innvarsle',),
'innvarslete': ('innvarsle',),
'innvarslede': ('innvarsle',),
'innvarsla': ('innvarsle',),
'innvarslete': ('innvarsle',),
'innvarslede': ('innvarsle',),
'innvarslete': ('innvarsle',),
'innvarslede': ('innvarsle',),
'innvarslende': ('innvarsle',),
'innveid': ('innveie',),
'innveide': ('innveie',),
'innveiende': ('innveie',),
'innvalgt': ('innvelge',),
'innvalgte': ('innvelge',),
'innvelgende': ('innvelge',),
'innvendt': ('innvende',),
'innvendte': ('innvende',),
'innvendende': ('innvende',),
'innvendig': ('innvendig',),
'innvendige': ('innvendig',),
'innvendig': ('innvendig',),
'innvevd': ('innvevd',),
'innvevde': ('innvevd',),
'innvevd': ('innvevd',),
'innvia': ('innvie',),
'innviet': ('innvie',),
'innvidd': ('innvie',),
'innvigd': ('innvie',),
'innvia': ('innvie',),
'innviet': ('innvie',),
'innvidd': ('innvie',),
'innvigd': ('innvie',),
'innvia': ('innvie',),
'innviete': ('innvie',),
'innviede': ('innvie',),
'innvidde': ('innvie',),
'innvigde': ('innvie',),
'innvia': ('innvie',),
'innviete': ('innvie',),
'innviede': ('innvie',),
'innvidde': ('innvie',),
'innvigde': ('innvie',),
'innviende': ('innvie',),
'innvikla': ('innvikla',),
'innvikla': ('innvikle',),
'innviklet': ('innvikle',),
'innvikla': ('innvikle',),
'innviklet': ('innvikle',),
'innvikla': ('innvikle',),
'innviklete': ('innvikle',),
'innviklede': ('innvikle',),
'innviklete': ('innvikle',),
'innviklede': ('innvikle',),
'innvikla': ('innvikle',),
'innviklete': ('innvikle',),
'innviklede': ('innvikle',),
'innviklete': ('innvikle',),
'innviklede': ('innvikle',),
'innviklende': ('innvikle',),
'innviklet': ('innviklet',),
'innviklete': ('innviklet',),
'innviklede': ('innviklet',),
'innviklete': ('innviklet',),
'innviklede': ('innviklet',),
'innviklet': ('innviklet',),
'innvilga': ('innvilge',),
'innvilget': ('innvilge',),
'innvilga': ('innvilge',),
'innvilget': ('innvilge',),
'innvilga': ('innvilge',),
'innvilgete': ('innvilge',),
'innvilgede': ('innvilge',),
'innvilga': ('innvilge',),
'innvilgete': ('innvilge',),
'innvilgede': ('innvilge',),
'innvilgende': ('innvilge',),
'innvunnet': ('innvinne',),
'innvunnen': ('innvinne',),
'innvunne': ('innvinne',),
'innvinnende': ('innvinne',),
'innvirka': ('innvirke',),
'innvirket': ('innvirke',),
'innvirka': ('innvirke',),
'innvirket': ('innvirke',),
'innvirka': ('innvirke',),
'innvirkete': ('innvirke',),
'innvirkede': ('innvirke',),
'innvirka': ('innvirke',),
'innvirkete': ('innvirke',),
'innvirkede': ('innvirke',),
'innvirkende': ('innvirke',),
'innvortes': ('innvortes',),
'innvotert': ('innvotere',),
'innvoterte': ('innvotere',),
'innvoterende': ('innvotere',),
'innynda': ('innynde',),
'innyndet': ('innynde',),
'innynda': ('innynde',),
'innyndet': ('innynde',),
'innynda': ('innynde',),
'innyndete': ('innynde',),
'innyndede': ('innynde',),
'innynda': ('innynde',),
'innyndete': ('innynde',),
'innyndede': ('innynde',),
'innyndende': ('innynde',),
'innånda': ('innånde',),
'innåndet': ('innånde',),
'innånda': ('innånde',),
'innåndet': ('innånde',),
'innånda': ('innånde',),
'innåndete': ('innånde',),
'innåndede': ('innånde',),
'innånda': ('innånde',),
'innåndete': ('innånde',),
'innåndede': ('innånde',),
'innåndende': ('innånde',),
'innøva': ('innøve',),
'innøvet': ('innøve',),
'innøvd': ('innøve',),
'innøva': ('innøve',),
'innøvet': ('innøve',),
'innøvd': ('innøve',),
'innøva': ('innøve',),
'innøvete': ('innøve',),
'innøvede': ('innøve',),
'innøvde': ('innøve',),
'innøva': ('innøve',),
'innøvete': ('innøve',),
'innøvede': ('innøve',),
'innøvde': ('innøve',),
'innøvende': ('innøve',),
'inokulert': ('inokulere',),
'inokulerte': ('inokulere',),
'inokulerende': ('inokulere',),
'inopportun': ('inopportun',),
'inopportune': ('inopportun',),
'inopportunt': ('inopportun',),
'insektdrepende': ('insektdrepende',),
'insektetende': ('insektetende',),
'inseminert': ('inseminere',),
'inseminerte': ('inseminere',),
'inseminerende': ('inseminere',),
'insinuant': ('insinuant',),
'insinuante': ('insinuant',),
'insinuant': ('insinuant',),
'insinuert': ('insinuere',),
'insinuerte': ('insinuere',),
'insinuerende': ('insinuere',),
'insistert': ('insistere',),
'insisterte': ('insistere',),
'insisterende': ('insistere',),
'inspirert': ('inspirere',),
'inspirerte': ('inspirere',),
'inspirerende': ('inspirere',),
'inspisert': ('inspisere',),
'inspiserte': ('inspisere',),
'inspiserende': ('inspisere',),
'instabil': ('instabil',),
'instabile': ('instabil',),
'instabilt': ('instabil',),
'installert': ('installere',),
'installerte': ('installere',),
'installerende': ('installere',),
'instinktiv': ('instinktiv',),
'instinktive': ('instinktiv',),
'instinktivt': ('instinktiv',),
'instituert': ('instituere',),
'instituerte': ('instituere',),
'instituerende': ('instituere',),
'institusjonalisert': ('institusjonalisere',),
'institusjonaliserte': ('institusjonalisere',),
'institusjonaliserende': ('institusjonalisere',),
'institusjonell': ('institusjonell',),
'institusjonelle': ('institusjonell',),
'institusjonelt': ('institusjonell',),
'instruert': ('instruere',),
'instruerte': ('instruere',),
'instruerende': ('instruere',),
'instruktiv': ('instruktiv',),
'instruktive': ('instruktiv',),
'instruktivt': ('instruktiv',),
'instrumental': ('instrumental',),
'instrumentale': ('instrumental',),
'instrumentalt': ('instrumental',),
'instrumentell': ('instrumentell',),
'instrumentelle': ('instrumentell',),
'instrumentelt': ('instrumentell',),
'instrumentert': ('instrumentere',),
'instrumenterte': ('instrumentere',),
'instrumenterende': ('instrumentere',),
'insuffisient': ('insuffisient',),
'insulær': ('insulær',),
'insulære': ('insulær',),
'insulært': ('insulær',),
'intakt': ('intakt',),
'intakte': ('intakt',),
'intakt': ('intakt',),
'integrert': ('integrere',),
'integrerte': ('integrere',),
'integrerende': ('integrere',),
'intellektualisert': ('intellektualisere',),
'intellektualiserte': ('intellektualisere',),
'intellektualiserende': ('intellektualisere',),
'intellektualistisk': ('intellektualistisk',),
'intellektualistiske': ('intellektualistisk',),
'intellektualistisk': ('intellektualistisk',),
'intellektuell': ('intellektuell',),
'intellektuelle': ('intellektuell',),
'intellektuelt': ('intellektuell',),
'intelligent': ('intelligent',),
'intelligente': ('intelligent',),
'intelligent': ('intelligent',),
'intelligibel': ('intelligibel',),
'intelligible': ('intelligibel',),
'intelligibelt': ('intelligibel',),
'intendert': ('intendere',),
'intenderte': ('intendere',),
'intenderende': ('intendere',),
'intens': ('intens',),
'intense': ('intens',),
'intenst': ('intens',),
'intensiv': ('intensiv',),
'intensive': ('intensiv',),
'intensivt': ('intensiv',),
'intensivert': ('intensivere',),
'intensiverte': ('intensivere',),
'intensiverende': ('intensivere',),
'intensjonal': ('intensjonal',),
'intensjonale': ('intensjonal',),
'intensjonalt': ('intensjonal',),
'intensjonell': ('intensjonell',),
'intensjonelle': ('intensjonell',),
'intensjonelt': ('intensjonell',),
'interdental': ('interdental',),
'interdentale': ('interdental',),
'interdentalt': ('interdental',),
'interdepartemental': ('interdepartemental',),
'interdepartementale': ('interdepartemental',),
'interdepartementalt': ('interdepartemental',),
'interdisiplinær': ('interdisiplinær',),
'interdisiplinære': ('interdisiplinær',),
'interdisiplinært': ('interdisiplinær',),
'interessant': ('interessant',),
'interessante': ('interessant',),
'interessant': ('interessant',),
'interesselaus': ('interesselaus',),
'interesselause': ('interesselaus',),
'interesselaust': ('interesselaus',),
'interesseløs': ('interesseløs',),
'interesseløse': ('interesseløs',),
'interesseløst': ('interesseløs',),
'interessert': ('interessere',),
'interesserte': ('interessere',),
'interesserende': ('interessere',),
'interessevekkende': ('interessevekkende',),
'intereuropeisk': ('intereuropeisk',),
'intereuropeiske': ('intereuropeisk',),
'intereuropeisk': ('intereuropeisk',),
'interferert': ('interferere',),
'interfererte': ('interferere',),
'interfererende': ('interferere',),
'interfoliert': ('interfoliere',),
'interfolierte': ('interfoliere',),
'interfolierende': ('interfoliere',),
'interglasial': ('interglasial',),
'interglasiale': ('interglasial',),
'interglasialt': ('interglasial',),
'interimistisk': ('interimistisk',),
'interimistiske': ('interimistisk',),
'interimistisk': ('interimistisk',),
'interkommunal': ('interkommunal',),
'interkommunale': ('interkommunal',),
'interkommunalt': ('interkommunal',),
'interkonfesjonell': ('interkonfesjonell',),
'interkonfesjonelle': ('interkonfesjonell',),
'interkonfesjonelt': ('interkonfesjonell',),
'interkontinental': ('interkontinental',),
'interkontinentale': ('interkontinental',),
'interkontinentalt': ('interkontinental',),
'intern': ('intern',),
'interne': ('intern',),
'internt': ('intern',),
'internasjonal': ('internasjonal',),
'internasjonale': ('internasjonal',),
'internasjonalt': ('internasjonal',),
'internasjonalisert': ('internasjonalisere',),
'internasjonaliserte': ('internasjonalisere',),
'internasjonaliserende': ('internasjonalisere',),
'internasjonalistisk': ('internasjonalistisk',),
'internasjonalistiske': ('internasjonalistisk',),
'internasjonalistisk': ('internasjonalistisk',),
'internert': ('internere',),
'internerte': ('internere',),
'internerende': ('internere',),
'internordisk': ('internordisk',),
'internordiske': ('internordisk',),
'internordisk': ('internordisk',),
'interparlamentarisk': ('interparlamentarisk',),
'interparlamentariske': ('interparlamentarisk',),
'interparlamentarisk': ('interparlamentarisk',),
'interpellert': ('interpellere',),
'interpellerte': ('interpellere',),
'interpellerende': ('interpellere',),
'interplanetarisk': ('interplanetarisk',),
'interplanetariske': ('interplanetarisk',),
'interplanetarisk': ('interplanetarisk',),
'interpolert': ('interpolere',),
'interpolerte': ('interpolere',),
'interpolerende': ('interpolere',),
'interpretert': ('interpretere',),
'interpreterte': ('interpretere',),
'interpreterende': ('interpretere',),
'interrogativ': ('interrogativ',),
'interrogative': ('interrogativ',),
'interrogativt': ('interrogativ',),
'interseksuell': ('interseksuell',),
'interseksuelle': ('interseksuell',),
'interseksuelt': ('interseksuell',),
'interskandinavisk': ('interskandinavisk',),
'interskandinaviske': ('interskandinavisk',),
'interskandinavisk': ('interskandinavisk',),
'interstellar': ('interstellar',),
'interstellare': ('interstellar',),
'interstellart': ('interstellar',),
'intersubjektiv': ('intersubjektiv',),
'intersubjektive': ('intersubjektiv',),
'intersubjektivt': ('intersubjektiv',),
'intervenert': ('intervenere',),
'intervenerte': ('intervenere',),
'intervenerende': ('intervenere',),
'intervjua': ('intervjue',),
'intervjuet': ('intervjue',),
'intervjua': ('intervjue',),
'intervjuet': ('intervjue',),
'intervjua': ('intervjue',),
'intervjuete': ('intervjue',),
'intervjuede': ('intervjue',),
'intervjua': ('intervjue',),
'intervjuete': ('intervjue',),
'intervjuede': ('intervjue',),
'intervjuende': ('intervjue',),
'intervokalisk': ('intervokalisk',),
'intervokaliske': ('intervokalisk',),
'intervokalisk': ('intervokalisk',),
'intetanende': ('intetanende',),
'intetsigende': ('intetsigende',),
'intim': ('intim',),
'intime': ('intim',),
'intimt': ('intim',),
'intimidert': ('intimidere',),
'intimiderte': ('intimidere',),
'intimiderende': ('intimidere',),
'intonert': ('intonere',),
'intonerte': ('intonere',),
'intonerende': ('intonere',),
'intracellulær': ('intracellulær',),
'intracellulære': ('intracellulær',),
'intracellulært': ('intracellulær',),
'intramolekylær': ('intramolekylær',),
'intramolekylære': ('intramolekylær',),
'intramolekylært': ('intramolekylær',),
'intransitiv': ('intransitiv',),
'intransitive': ('intransitiv',),
'intransitivt': ('intransitiv',),
'intravenøs': ('intravenøs',),
'intravenøse': ('intravenøs',),
'intravenøst': ('intravenøs',),
'intrigant': ('intrigant',),
'intrigante': ('intrigant',),
'intrigant': ('intrigant',),
'intrigert': ('intrigere',),
'intrigerte': ('intrigere',),
'intrigerende': ('intrigere',),
'intrikat': ('intrikat',),
'intrikate': ('intrikat',),
'intrikat': ('intrikat',),
'introdusert': ('introdusere',),
'introduserte': ('introdusere',),
'introduserende': ('introdusere',),
'introspektiv': ('introspektiv',),
'introspektive': ('introspektiv',),
'introspektivt': ('introspektiv',),
'introvert': ('introvert',),
'introverte': ('introvert',),
'introvert': ('introvert',),
'intuitiv': ('intuitiv',),
'intuitive': ('intuitiv',),
'intuitivt': ('intuitiv',),
'invadert': ('invadere',),
'invaderte': ('invadere',),
'invaderende': ('invadere',),
'invalid': ('invalid',),
'invalide': ('invalid',),
'invalid': ('invalid',),
'invalidisert': ('invalidisere',),
'invalidiserte': ('invalidisere',),
'invalidiserende': ('invalidisere',),
'invariabel': ('invariabel',),
'invariable': ('invariabel',),
'invariabelt': ('invariabel',),
'inventert': ('inventere',),
'inventerte': ('inventere',),
'inventerende': ('inventere',),
'invers': ('invers',),
'inverse': ('invers',),
'inverst': ('invers',),
'invertert': ('invertere',),
'inverterte': ('invertere',),
'inverterende': ('invertere',),
'investert': ('investere',),
'investerte': ('investere',),
'investerende': ('investere',),
'invitert': ('invitere',),
'inviterte': ('invitere',),
'inviterende': ('invitere',),
'involvert': ('involvere',),
'involverte': ('involvere',),
'involverende': ('involvere',),
'ionisert': ('ionisere',),
'ioniserte': ('ionisere',),
'ioniserende': ('ionisere',),
'ionogen': ('ionogen',),
'ionogene': ('ionogen',),
'ionogent': ('ionogen',),
'ionosfærisk': ('ionosfærisk',),
'ionosfæriske': ('ionosfærisk',),
'ionosfærisk': ('ionosfærisk',),
'irakisk': ('irakisk',),
'irakiske': ('irakisk',),
'irakisk': ('irakisk',),
'iraksk': ('iraksk',),
'irakske': ('iraksk',),
'iraksk': ('iraksk',),
'iransk': ('iransk',),
'iranske': ('iransk',),
'iransk': ('iransk',),
'irettesatt': ('irettesette',),
'irettesatte': ('irettesette',),
'irettesettende': ('irettesette',),
'irisert': ('irisere',),
'iriserte': ('irisere',),
'iriserende': ('irisere',),
'irokesisk': ('irokesisk',),
'irokesiske': ('irokesisk',),
'irokesisk': ('irokesisk',),
'ironisert': ('ironisere',),
'ironiserte': ('ironisere',),
'ironiserende': ('ironisere',),
'ironisk': ('ironisk',),
'ironiske': ('ironisk',),
'ironisk': ('ironisk',),
'irrasjonal': ('irrasjonal',),
'irrasjonale': ('irrasjonal',),
'irrasjonalt': ('irrasjonal',),
'irrasjonell': ('irrasjonell',),
'irrasjonelle': ('irrasjonell',),
'irrasjonelt': ('irrasjonell',),
'irra': ('irre',),
'irret': ('irre',),
'irra': ('irre',),
'irret': ('irre',),
'irra': ('irre',),
'irrete': ('irre',),
'irrede': ('irre',),
'irra': ('irre',),
'irrete': ('irre',),
'irrede': ('irre',),
'irrende': ('irre',),
'irreal': ('irreal',),
'irreale': ('irreal',),
'irrealt': ('irreal',),
'irreell': ('irreell',),
'irreelle': ('irreell',),
'irreelt': ('irreell',),
'irreligiøs': ('irreligiøs',),
'irreligiøse': ('irreligiøs',),
'irreligiøst': ('irreligiøs',),
'irreparabel': ('irreparabel',),
'irreparable': ('irreparabel',),
'irreparabelt': ('irreparabel',),
'irret': ('irret',),
'irrete': ('irret',),
'irret': ('irret',),
'irrete': ('irrete',),
'irreversibel': ('irreversibel',),
'irreversible': ('irreversibel',),
'irreversibelt': ('irreversibel',),
'irrgrønn': ('irrgrønn',),
'irrgrønne': ('irrgrønn',),
'irrgrønt': ('irrgrønn',),
'irrigert': ('irrigere',),
'irrigerte': ('irrigere',),
'irrigerende': ('irrigere',),
'irritabel': ('irritabel',),
'irritable': ('irritabel',),
'irritabelt': ('irritabel',),
'irritert': ('irritere',),
'irriterte': ('irritere',),
'irriterende': ('irritere',),
'irsk': ('irsk',),
'irske': ('irsk',),
'irsk': ('irsk',),
'isblå': ('isblå',),
'isblåe': ('isblå',),
'isblå': ('isblå',),
'isblåe': ('isblå',),
'isblå': ('isblå',),
'isblått': ('isblå',),
'iscenesatt': ('iscenesette',),
'iscenesatte': ('iscenesette',),
'iscenesettende': ('iscenesette',),
'isa': ('ise',),
'iset': ('ise',),
'ist': ('ise',),
'isa': ('ise',),
'iset': ('ise',),
'ist': ('ise',),
'isa': ('ise',),
'isete': ('ise',),
'isede': ('ise',),
'iste': ('ise',),
'isa': ('ise',),
'isete': ('ise',),
'isede': ('ise',),
'iste': ('ise',),
'isende': ('ise',),
'isende': ('isende',),
'iset': ('iset',),
'isete': ('iset',),
'iset': ('iset',),
'isete': ('isete',),
'isgrønn': ('isgrønn',),
'isgrønne': ('isgrønn',),
'isgrønt': ('isgrønn',),
'isgående': ('isgående',),
'iskald': ('iskald',),
'iskalde': ('iskald',),
'iskaldt': ('iskald',),
'islagt': ('islagt',),
'islagte': ('islagt',),
'islagt': ('islagt',),
'islamisert': ('islamisere',),
'islamiserte': ('islamisere',),
'islamiserende': ('islamisere',),
'islamsk': ('islamsk',),
'islamske': ('islamsk',),
'islamsk': ('islamsk',),
'islandsk': ('islandsk',),
'islandske': ('islandsk',),
'islandsk': ('islandsk',),
'isna': ('isne',),
'isnet': ('isne',),
'isna': ('isne',),
'isnet': ('isne',),
'isna': ('isne',),
'isnete': ('isne',),
'isnede': ('isne',),
'isnete': ('isne',),
'isnede': ('isne',),
'isna': ('isne',),
'isnete': ('isne',),
'isnede': ('isne',),
'isnete': ('isne',),
'isnede': ('isne',),
'isnende': ('isne',),
'isokron': ('isokron',),
'isokrone': ('isokron',),
'isokront': ('isokron',),
'isolasjonistisk': ('isolasjonistisk',),
'isolasjonistiske': ('isolasjonistisk',),
'isolasjonistisk': ('isolasjonistisk',),
'isolert': ('isolere',),
'isolerte': ('isolere',),
'isolerende': ('isolere',),
'isometrisk': ('isometrisk',),
'isometriske': ('isometrisk',),
'isometrisk': ('isometrisk',),
'isomorf': ('isomorf',),
'isomorfe': ('isomorf',),
'isomorft': ('isomorf',),
'isoterm': ('isoterm',),
'isoterme': ('isoterm',),
'isotermt': ('isoterm',),
'isotermisk': ('isotermisk',),
'isotermiske': ('isotermisk',),
'isotermisk': ('isotermisk',),
'isotonisk': ('isotonisk',),
'isotoniske': ('isotonisk',),
'isotonisk': ('isotonisk',),
'isotop': ('isotop',),
'isotope': ('isotop',),
'isotopt': ('isotop',),
'isotopisk': ('isotopisk',),
'isotopiske': ('isotopisk',),
'isotopisk': ('isotopisk',),
'isotrop': ('isotrop',),
'isotrope': ('isotrop',),
'isotropt': ('isotrop',),
'ispedd': ('ispe',),
'ispedde': ('ispe',),
'ispeende': ('ispe',),
'isprengt': ('isprengt',),
'isprengte': ('isprengt',),
'isprengt': ('isprengt',),
'israelittisk': ('israelittisk',),
'israelittiske': ('israelittisk',),
'israelittisk': ('israelittisk',),
'israelsk': ('israelsk',),
'israelske': ('israelsk',),
'israelsk': ('israelsk',),
'istandsatt': ('istandsatt',),
'istandsatte': ('istandsatt',),
'istandsatt': ('istandsatt',),
'istemt': ('istemme',),
'istemte': ('istemme',),
'istemmende': ('istemme',),
'istykkerslått': ('istykkerslått',),
'istykkerslåtte': ('istykkerslått',),
'istykkerslått': ('istykkerslått',),
'italiensk': ('italiensk',),
'italienske': ('italiensk',),
'italiensk': ('italiensk',),
'italisk': ('italisk',),
'italiske': ('italisk',),
'italisk': ('italisk',),
'iterativ': ('iterativ',),
'iterative': ('iterativ',),
'iterativt': ('iterativ',),
'iterert': ('iterere',),
'itererte': ('iterere',),
'itererende': ('iterere',),
'ivaretatt': ('ivareta',),
'ivaretatte': ('ivareta',),
'ivaretakende': ('ivareta',),
'iverksatt': ('iverksette',),
'iverksatte': ('iverksette',),
'iverksettende': ('iverksette',),
'ivoriansk': ('ivoriansk',),
'ivorianske': ('ivoriansk',),
'ivoriansk': ('ivoriansk',),
'ivra': ('ivre',),
'ivret': ('ivre',),
'ivra': ('ivre',),
'ivret': ('ivre',),
'ivra': ('ivre',),
'ivrete': ('ivre',),
'ivrede': ('ivre',),
'ivrete': ('ivre',),
'ivrede': ('ivre',),
'ivra': ('ivre',),
'ivrete': ('ivre',),
'ivrede': ('ivre',),
'ivrete': ('ivre',),
'ivrede': ('ivre',),
'ivrende': ('ivre',),
'ivrig': ('ivrig',),
'ivrige': ('ivrig',),
'ivrig': ('ivrig',),
'ivrigere': ('ivrig',),
'ivrigst': ('ivrig',),
'ivrigste': ('ivrig',),
'iørefallende': ('iørefallende',),
'iøynefallende': ('iøynefallende',),
'jabba': ('jabbe',),
'jabbet': ('jabbe',),
'jabba': ('jabbe',),
'jabbet': ('jabbe',),
'jabba': ('jabbe',),
'jabbete': ('jabbe',),
'jabbede': ('jabbe',),
'jabba': ('jabbe',),
'jabbete': ('jabbe',),
'jabbede': ('jabbe',),
'jabbende': ('jabbe',),
'jafsa': ('jafse',),
'jafset': ('jafse',),
'jafsa': ('jafse',),
'jafset': ('jafse',),
'jafsa': ('jafse',),
'jafsete': ('jafse',),
'jafsede': ('jafse',),
'jafsa': ('jafse',),
'jafsete': ('jafse',),
'jafsede': ('jafse',),
'jafsende': ('jafse',),
'jaga': ('jage',),
'jaget': ('jage',),
'jagd': ('jage',),
'jaga': ('jage',),
'jaget': ('jage',),
'jagd': ('jage',),
'jaga': ('jage',),
'jagete': ('jage',),
'jagede': ('jage',),
'jagde': ('jage',),
'jaga': ('jage',),
'jagete': ('jage',),
'jagede': ('jage',),
'jagde': ('jage',),
'jagende': ('jage',),
'jaktbar': ('jaktbar',),
'jaktbare': ('jaktbar',),
'jaktbart': ('jaktbar',),
'jakta': ('jakte',),
'jaktet': ('jakte',),
'jakta': ('jakte',),
'jaktet': ('jakte',),
'jakta': ('jakte',),
'jaktete': ('jakte',),
'jaktede': ('jakte',),
'jakta': ('jakte',),
'jaktete': ('jakte',),
'jaktede': ('jakte',),
'jaktende': ('jakte',),
'jakutisk': ('jakutisk',),
'jakutiske': ('jakutisk',),
'jakutisk': ('jakutisk',),
'jalma': ('jalme',),
'jalmet': ('jalme',),
'jalma': ('jalme',),
'jalmet': ('jalme',),
'jalma': ('jalme',),
'jalmete': ('jalme',),
'jalmede': ('jalme',),
'jalma': ('jalme',),
'jalmete': ('jalme',),
'jalmede': ('jalme',),
'jalmende': ('jalme',),
'jamaicansk': ('jamaicansk',),
'jamaicanske': ('jamaicansk',),
'jamaicansk': ('jamaicansk',),
'jamaikansk': ('jamaikansk',),
'jamaikanske': ('jamaikansk',),
'jamaikansk': ('jamaikansk',),
'jamaldra': ('jamaldra',),
'jamaldret': ('jamaldret',),
'jamaldrete': ('jamaldret',),
'jamaldrede': ('jamaldret',),
'jamaldrete': ('jamaldret',),
'jamaldrede': ('jamaldret',),
'jamaldret': ('jamaldret',),
'jambisk': ('jambisk',),
'jambiske': ('jambisk',),
'jambisk': ('jambisk',),
'jambyrdig': ('jambyrdig',),
'jambyrdige': ('jambyrdig',),
'jambyrdig': ('jambyrdig',),
'jamført': ('jamføre',),
'jamførte': ('jamføre',),
'jamførende': ('jamføre',),
'jamgammel': ('jamgammel',),
'jamgamle': ('jamgammel',),
'jamgammelt': ('jamgammel',),
'jamgod': ('jamgod',),
'jamgode': ('jamgod',),
'jamgodt': ('jamgod',),
'jamlang': ('jamlang',),
'jamlange': ('jamlang',),
'jamlangt': ('jamlang',),
'jamlik': ('jamlik',),
'jamlike': ('jamlik',),
'jamlikt': ('jamlik',),
'jamma': ('jamme',),
'jammet': ('jamme',),
'jamma': ('jamme',),
'jammet': ('jamme',),
'jamma': ('jamme',),
'jammete': ('jamme',),
'jammede': ('jamme',),
'jamma': ('jamme',),
'jammete': ('jamme',),
'jammede': ('jamme',),
'jammende': ('jamme',),
'jammerlig': ('jammerlig',),
'jammerlige': ('jammerlig',),
'jammerlig': ('jammerlig',),
'jamn': ('jamn',),
'jamne': ('jamn',),
'jamt': ('jamn',),
'jamnere': ('jamn',),
'jamnest': ('jamn',),
'jamneste': ('jamn',),
'jamna': ('jamne',),
'jamnet': ('jamne',),
'jamna': ('jamne',),
'jamnet': ('jamne',),
'jamna': ('jamne',),
'jamnete': ('jamne',),
'jamnede': ('jamne',),
'jamna': ('jamne',),
'jamnete': ('jamne',),
'jamnede': ('jamne',),
'jamnende': ('jamne',),
'jamra': ('jamre',),
'jamret': ('jamre',),
'jamra': ('jamre',),
'jamret': ('jamre',),
'jamra': ('jamre',),
'jamrete': ('jamre',),
'jamrede': ('jamre',),
'jamrete': ('jamre',),
'jamrede': ('jamre',),
'jamra': ('jamre',),
'jamrete': ('jamre',),
'jamrede': ('jamre',),
'jamrete': ('jamre',),
'jamrede': ('jamre',),
'jamrende': ('jamre',),
'jamspelt': ('jamspelt',),
'jamspelte': ('jamspelt',),
'jamspelt': ('jamspelt',),
'jamspilt': ('jamspilt',),
'jamspilte': ('jamspilt',),
'jamspilt': ('jamspilt',),
'jamsterk': ('jamsterk',),
'jamsterke': ('jamsterk',),
'jamsterkt': ('jamsterk',),
'jamstilt': ('jamstille',),
'jamstilte': ('jamstille',),
'jamstillende': ('jamstille',),
'jamstor': ('jamstor',),
'jamstore': ('jamstor',),
'jamstort': ('jamstor',),
'jamstørre': ('jamstor',),
'jamstørst': ('jamstor',),
'jamstørste': ('jamstor',),
'jamtjukk': ('jamtjukk',),
'jamtjukke': ('jamtjukk',),
'jamtjukt': ('jamtjukk',),
'jamtykk': ('jamtykk',),
'jamtykke': ('jamtykk',),
'jamtykt': ('jamtykk',),
'japansk': ('japansk',),
'japanske': ('japansk',),
'japansk': ('japansk',),
'jara': ('jare',),
'jaret': ('jare',),
'jara': ('jare',),
'jaret': ('jare',),
'jara': ('jare',),
'jarete': ('jare',),
'jarede': ('jare',),
'jara': ('jare',),
'jarete': ('jare',),
'jarede': ('jare',),
'jarende': ('jare',),
'jaska': ('jaske',),
'jasket': ('jaske',),
'jaska': ('jaske',),
'jasket': ('jaske',),
'jaska': ('jaske',),
'jaskete': ('jaske',),
'jaskede': ('jaske',),
'jaska': ('jaske',),
'jaskete': ('jaske',),
'jaskede': ('jaske',),
'jaskende': ('jaske',),
'jasket': ('jasket',),
'jaskete': ('jasket',),
'jasket': ('jasket',),
'jaskete': ('jaskete',),
'jassa': ('jasse',),
'jasset': ('jasse',),
'jassa': ('jasse',),
'jasset': ('jasse',),
'jassa': ('jasse',),
'jassete': ('jasse',),
'jassede': ('jasse',),
'jassa': ('jasse',),
'jassete': ('jasse',),
'jassede': ('jasse',),
'jassende': ('jasse',),
'jassifisert': ('jassifisere',),
'jassifiserte': ('jassifisere',),
'jassifiserende': ('jassifisere',),
'jatta': ('jatte',),
'jattet': ('jatte',),
'jatta': ('jatte',),
'jattet': ('jatte',),
'jatta': ('jatte',),
'jattete': ('jatte',),
'jattede': ('jatte',),
'jatta': ('jatte',),
'jattete': ('jatte',),
'jattede': ('jatte',),
'jattende': ('jatte',),
'jattet': ('jattet',),
'jattete': ('jattet',),
'jattet': ('jattet',),
'jattete': ('jattete',),
'javanesisk': ('javanesisk',),
'javanesiske': ('javanesisk',),
'javanesisk': ('javanesisk',),
'jazza': ('jazze',),
'jazzet': ('jazze',),
'jazza': ('jazze',),
'jazzet': ('jazze',),
'jazza': ('jazze',),
'jazzete': ('jazze',),
'jazzede': ('jazze',),
'jazza': ('jazze',),
'jazzete': ('jazze',),
'jazzede': ('jazze',),
'jazzende': ('jazze',),
'jazzifisert': ('jazzifisere',),
'jazzifiserte': ('jazzifisere',),
'jazzifiserende': ('jazzifisere',),
'jekka': ('jekke',),
'jekket': ('jekke',),
'jekka': ('jekke',),
'jekket': ('jekke',),
'jekka': ('jekke',),
'jekkete': ('jekke',),
'jekkede': ('jekke',),
'jekka': ('jekke',),
'jekkete': ('jekke',),
'jekkede': ('jekke',),
'jekkende': ('jekke',),
'jelka': ('jelke',),
'jelket': ('jelke',),
'jelka': ('jelke',),
'jelket': ('jelke',),
'jelka': ('jelke',),
'jelkete': ('jelke',),
'jelkede': ('jelke',),
'jelka': ('jelke',),
'jelkete': ('jelke',),
'jelkede': ('jelke',),
'jelkende': ('jelke',),
'jemenittisk': ('jemenittisk',),
'jemenittiske': ('jemenittisk',),
'jemenittisk': ('jemenittisk',),
'jenka': ('jenke',),
'jenket': ('jenke',),
'jenka': ('jenke',),
'jenket': ('jenke',),
'jenka': ('jenke',),
'jenkete': ('jenke',),
'jenkede': ('jenke',),
'jenka': ('jenke',),
'jenkete': ('jenke',),
'jenkede': ('jenke',),
'jenkende': ('jenke',),
'jentegalen': ('jentegalen',),
'jentegalne': ('jentegalen',),
'jentegalent': ('jentegalen',),
'jentegalnere': ('jentegalen',),
'jentegalnest': ('jentegalen',),
'jentegalneste': ('jentegalen',),
'jernfattig': ('jernfattig',),
'jernfattige': ('jernfattig',),
'jernfattig': ('jernfattig',),
'jernførende': ('jernførende',),
'jernhard': ('jernhard',),
'jernharde': ('jernhard',),
'jernhardt': ('jernhard',),
'jernholdig': ('jernholdig',),
'jernholdige': ('jernholdig',),
'jernholdig': ('jernholdig',),
'jesuittisk': ('jesuittisk',),
'jesuittiske': ('jesuittisk',),
'jesuittisk': ('jesuittisk',),
'jetdrevet': ('jetdrevet',),
'jetdrevne': ('jetdrevet',),
'jetdrevet': ('jetdrevet',),
'jettesterk': ('jettesterk',),
'jettesterke': ('jettesterk',),
'jettesterkt': ('jettesterk',),
'jettestor': ('jettestor',),
'jettestore': ('jettestor',),
'jettestort': ('jettestor',),
'jevn': ('jevn',),
'jevne': ('jevn',),
'jevnt': ('jevn',),
'jevnere': ('jevn',),
'jevnest': ('jevn',),
'jevneste': ('jevn',),
'jevnaldrende': ('jevnaldrende',),
'jevnbyrdig': ('jevnbyrdig',),
'jevnbyrdige': ('jevnbyrdig',),
'jevnbyrdig': ('jevnbyrdig',),
'jevna': ('jevne',),
'jevnet': ('jevne',),
'jevna': ('jevne',),
'jevnet': ('jevne',),
'jevna': ('jevne',),
'jevnete': ('jevne',),
'jevnede': ('jevne',),
'jevna': ('jevne',),
'jevnete': ('jevne',),
'jevnede': ('jevne',),
'jevnende': ('jevne',),
'jevnført': ('jevnføre',),
'jevnførte': ('jevnføre',),
'jevnførende': ('jevnføre',),
'jevngammel': ('jevngammel',),
'jevngamle': ('jevngammel',),
'jevngammelt': ('jevngammel',),
'jevngod': ('jevngod',),
'jevngode': ('jevngod',),
'jevngodt': ('jevngod',),
'jevnlang': ('jevnlang',),
'jevnlange': ('jevnlang',),
'jevnlangt': ('jevnlang',),
'jevnlik': ('jevnlik',),
'jevnlike': ('jevnlik',),
'jevnlikt': ('jevnlik',),
'jevnspelt': ('jevnspelt',),
'jevnspelte': ('jevnspelt',),
'jevnspelt': ('jevnspelt',),
'jevnspilt': ('jevnspilt',),
'jevnspilte': ('jevnspilt',),
'jevnspilt': ('jevnspilt',),
'jevnsterk': ('jevnsterk',),
'jevnsterke': ('jevnsterk',),
'jevnsterkt': ('jevnsterk',),
'jevnstor': ('jevnstor',),
'jevnstore': ('jevnstor',),
'jevnstort': ('jevnstor',),
'jevntjukk': ('jevntjukk',),
'jevntjukke': ('jevntjukk',),
'jevntjukt': ('jevntjukk',),
'jevntykk': ('jevntykk',),
'jevntykke': ('jevntykk',),
'jevntykt': ('jevntykk',),
'jibba': ('jibbe',),
'jibbet': ('jibbe',),
'jibba': ('jibbe',),
'jibbet': ('jibbe',),
'jibba': ('jibbe',),
'jibbete': ('jibbe',),
'jibbede': ('jibbe',),
'jibba': ('jibbe',),
'jibbete': ('jibbe',),
'jibbede': ('jibbe',),
'jibbende': ('jibbe',),
'jiddisch': ('jiddisch',),
'jiddische': ('jiddisch',),
'jiddisch': ('jiddisch',),
'jiddisk': ('jiddisk',),
'jiddiske': ('jiddisk',),
'jiddisk': ('jiddisk',),
'jobba': ('jobbe',),
'jobbet': ('jobbe',),
'jobba': ('jobbe',),
'jobbet': ('jobbe',),
'jobba': ('jobbe',),
'jobbete': ('jobbe',),
'jobbede': ('jobbe',),
'jobba': ('jobbe',),
'jobbete': ('jobbe',),
'jobbede': ('jobbe',),
'jobbende': ('jobbe',),
'jodert': ('jodere',),
'joderte': ('jodere',),
'joderende': ('jodere',),
'jodisert': ('jodisere',),
'jodiserte': ('jodisere',),
'jodiserende': ('jodisere',),
'jodla': ('jodle',),
'jodlet': ('jodle',),
'jodla': ('jodle',),
'jodlet': ('jodle',),
'jodla': ('jodle',),
'jodlete': ('jodle',),
'jodlede': ('jodle',),
'jodlete': ('jodle',),
'jodlede': ('jodle',),
'jodla': ('jodle',),
'jodlete': ('jodle',),
'jodlede': ('jodle',),
'jodlete': ('jodle',),
'jodlede': ('jodle',),
'jodlende': ('jodle',),
'jogga': ('jogge',),
'jogget': ('jogge',),
'jogga': ('jogge',),
'jogget': ('jogge',),
'jogga': ('jogge',),
'joggete': ('jogge',),
'joggede': ('jogge',),
'jogga': ('jogge',),
'joggete': ('jogge',),
'joggede': ('jogge',),
'joggende': ('jogge',),
'joika': ('joike',),
'joiket': ('joike',),
'joika': ('joike',),
'joiket': ('joike',),
'joika': ('joike',),
'joikete': ('joike',),
'joikede': ('joike',),
'joika': ('joike',),
'joikete': ('joike',),
'joikede': ('joike',),
'joikende': ('joike',),
'jomfruelig': ('jomfruelig',),
'jomfruelige': ('jomfruelig',),
'jomfruelig': ('jomfruelig',),
'jomfrunalsk': ('jomfrunalsk',),
'jomfrunalske': ('jomfrunalsk',),
'jomfrunalsk': ('jomfrunalsk',),
'jonisk': ('jonisk',),
'joniske': ('jonisk',),
'jonisk': ('jonisk',),
'jordansk': ('jordansk',),
'jordanske': ('jordansk',),
'jordansk': ('jordansk',),
'jordbunden': ('jordbunden',),
'jordbundne': ('jordbunden',),
'jordbundet': ('jordbunden',),
'jordbundet': ('jordbundet',),
'jordbundne': ('jordbundet',),
'jordbundet': ('jordbundet',),
'jorda': ('jorde',),
'jordet': ('jorde',),
'jorda': ('jorde',),
'jordet': ('jorde',),
'jorda': ('jorde',),
'jordete': ('jorde',),
'jordede': ('jorde',),
'jorda': ('jorde',),
'jordete': ('jorde',),
'jordede': ('jorde',),
'jordende': ('jorde',),
'jordet': ('jordet',),
'jordete': ('jordet',),
'jordet': ('jordet',),
'jordete': ('jordete',),
'jordfast': ('jordfast',),
'jordfaste': ('jordfast',),
'jordfast': ('jordfast',),
'jordfesta': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfestete': ('jordfeste',),
'jordfestede': ('jordfeste',),
'jordfesta': ('jordfeste',),
'jordfestete': ('jordfeste',),
'jordfestede': ('jordfeste',),
'jordfestende': ('jordfeste',),
'jordisk': ('jordisk',),
'jordiske': ('jordisk',),
'jordisk': ('jordisk',),
'jordnær': ('jordnær',),
'jordnære': ('jordnær',),
'jordnært': ('jordnær',),
'jordskjelvsikker': ('jordskjelvsikker',),
'jordskjelvsikre': ('jordskjelvsikker',),
'jordskjelvsikkert': ('jordskjelvsikker',),
'jordslått': ('jordslå',),
'jordslåtte': ('jordslå',),
'jordslående': ('jordslå',),
'jordslått': ('jordslått',),
'jordslåtte': ('jordslått',),
'jordslått': ('jordslått',),
'jorta': ('jorte',),
'jortet': ('jorte',),
'jorta': ('jorte',),
'jortet': ('jorte',),
'jorta': ('jorte',),
'jortete': ('jorte',),
'jortede': ('jorte',),
'jorta': ('jorte',),
'jortete': ('jorte',),
'jortede': ('jorte',),
'jortende': ('jorte',),
'jourhavende': ('jourhavende',),
'journalført': ('journalføre',),
'journalførte': ('journalføre',),
'journalførende': ('journalføre',),
'journalisert': ('journalisere',),
'journaliserte': ('journalisere',),
'journaliserende': ('journalisere',),
'journalistisk': ('journalistisk',),
'journalistiske': ('journalistisk',),
'journalistisk': ('journalistisk',),
'jovial': ('jovial',),
'joviale': ('jovial',),
'jovialt': ('jovial',),
'jubilert': ('jubilere',),
'jubilerte': ('jubilere',),
'jubilerende': ('jubilere',),
'jubla': ('juble',),
'jublet': ('juble',),
'jubla': ('juble',),
'jublet': ('juble',),
'jubla': ('juble',),
'jublete': ('juble',),
'jublede': ('juble',),
'jublete': ('juble',),
'jublede': ('juble',),
'jubla': ('juble',),
'jublete': ('juble',),
'jublede': ('juble',),
'jublete': ('juble',),
'jublede': ('juble',),
'jublende': ('juble',),
'judeisk': ('judeisk',),
'judeiske': ('judeisk',),
'judeisk': ('judeisk',),
'judisiell': ('judisiell',),
'judisielle': ('judisiell',),
'judisielt': ('judisiell',),
'jugla': ('jugle',),
'juglet': ('jugle',),
'jugla': ('jugle',),
'juglet': ('jugle',),
'jugla': ('jugle',),
'juglete': ('jugle',),
'juglede': ('jugle',),
'juglete': ('jugle',),
'juglede': ('jugle',),
'jugla': ('jugle',),
'juglete': ('jugle',),
'juglede': ('jugle',),
'juglete': ('jugle',),
'juglede': ('jugle',),
'juglende': ('jugle',),
'juglet': ('juglet',),
'juglete': ('juglet',),
'juglet': ('juglet',),
'juglete': ('juglete',),
'jugoslavisk': ('jugoslavisk',),
'jugoslaviske': ('jugoslavisk',),
'jugoslavisk': ('jugoslavisk',),
'juksa': ('jukse',),
'jukset': ('jukse',),
'juksa': ('jukse',),
'jukset': ('jukse',),
'juksa': ('jukse',),
'juksete': ('jukse',),
'juksede': ('jukse',),
'juksa': ('jukse',),
'juksete': ('jukse',),
'juksede': ('jukse',),
'juksende': ('jukse',),
'jult': ('jule',),
'julte': ('jule',),
'julende': ('jule',),
'juliansk': ('juliansk',),
'julianske': ('juliansk',),
'juliansk': ('juliansk',),
'jumpa': ('jumpe',),
'jumpet': ('jumpe',),
'jumpa': ('jumpe',),
'jumpet': ('jumpe',),
'jumpa': ('jumpe',),
'jumpete': ('jumpe',),
'jumpede': ('jumpe',),
'jumpa': ('jumpe',),
'jumpete': ('jumpe',),
'jumpede': ('jumpe',),
'jumpende': ('jumpe',),
'junior': ('junior',),
'junka': ('junke',),
'junket': ('junke',),
'junka': ('junke',),
'junket': ('junke',),
'junka': ('junke',),
'junkete': ('junke',),
'junkede': ('junke',),
'junka': ('junke',),
'junkete': ('junke',),
'junkede': ('junke',),
'junkende': ('junke',),
'junonisk': ('junonisk',),
'junoniske': ('junonisk',),
'junonisk': ('junonisk',),
'juraisk': ('juraisk',),
'juraiske': ('juraisk',),
'juraisk': ('juraisk',),
'juridisk': ('juridisk',),
'juridiske': ('juridisk',),
'juridisk': ('juridisk',),
'juryert': ('juryere',),
'juryerte': ('juryere',),
'juryerende': ('juryere',),
'justerbar': ('justerbar',),
'justerbare': ('justerbar',),
'justerbart': ('justerbar',),
'justert': ('justere',),
'justerte': ('justere',),
'justerende': ('justere',),
'justitiell': ('justitiell',),
'justitielle': ('justitiell',),
'justitielt': ('justitiell',),
'jyllandsk': ('jyllandsk',),
'jyllandske': ('jyllandsk',),
'jyllandsk': ('jyllandsk',),
'jysk': ('jysk',),
'jyske': ('jysk',),
'jysk': ('jysk',),
'jåla': ('jåle',),
'jålet': ('jåle',),
'jålt': ('jåle',),
'jåla': ('jåle',),
'jålet': ('jåle',),
'jålt': ('jåle',),
'jåla': ('jåle',),
'jålete': ('jåle',),
'jålede': ('jåle',),
'jålte': ('jåle',),
'jåla': ('jåle',),
'jålete': ('jåle',),
'jålede': ('jåle',),
'jålte': ('jåle',),
'jålende': ('jåle',),
'jålet': ('jålet',),
'jålete': ('jålet',),
'jålet': ('jålet',),
'jålete': ('jålete',),
'jækla': ('jækla',),
'jæklig': ('jæklig',),
'jæklige': ('jæklig',),
'jæklig': ('jæklig',),
'jækligere': ('jæklig',),
'jækligst': ('jæklig',),
'jækligste': ('jæklig',),
'jærsk': ('jærsk',),
'jærske': ('jærsk',),
'jærsk': ('jærsk',),
'jævla': ('jævla',),
'jævlig': ('jævlig',),
'jævlige': ('jævlig',),
'jævlig': ('jævlig',),
'jævligere': ('jævlig',),
'jævligst': ('jævlig',),
'jævligste': ('jævlig',),
'jødisk': ('jødisk',),
'jødiske': ('jødisk',),
'jødisk': ('jødisk',),
'jøya': ('jøye',),
'jøyet': ('jøye',),
'jøya': ('jøye',),
'jøyet': ('jøye',),
'jøya': ('jøye',),
'jøyete': ('jøye',),
'jøyede': ('jøye',),
'jøya': ('jøye',),
'jøyete': ('jøye',),
'jøyede': ('jøye',),
'jøyende': ('jøye',),
'kabbalistisk': ('kabbalistisk',),
'kabbalistiske': ('kabbalistisk',),
'kabbalistisk': ('kabbalistisk',),
'kabba': ('kabbe',),
'kabbet': ('kabbe',),
'kabba': ('kabbe',),
'kabbet': ('kabbe',),
'kabba': ('kabbe',),
'kabbete': ('kabbe',),
'kabbede': ('kabbe',),
'kabba': ('kabbe',),
'kabbete': ('kabbe',),
'kabbede': ('kabbe',),
'kabbende': ('kabbe',),
'kabylsk': ('kabylsk',),
'kabylske': ('kabylsk',),
'kabylsk': ('kabylsk',),
'kadmiert': ('kadmiere',),
'kadmierte': ('kadmiere',),
'kadmierende': ('kadmiere',),
'kadreia': ('kadreie',),
'kadreiet': ('kadreie',),
'kadreid': ('kadreie',),
'kadreia': ('kadreie',),
'kadreiet': ('kadreie',),
'kadreid': ('kadreie',),
'kadreia': ('kadreie',),
'kadreiete': ('kadreie',),
'kadreiede': ('kadreie',),
'kadreide': ('kadreie',),
'kadreia': ('kadreie',),
'kadreiete': ('kadreie',),
'kadreiede': ('kadreie',),
'kadreide': ('kadreie',),
'kadreiende': ('kadreie',),
'kaka': ('kake',),
'kaket': ('kake',),
'kaka': ('kake',),
'kaket': ('kake',),
'kaka': ('kake',),
'kakete': ('kake',),
'kakede': ('kake',),
'kaka': ('kake',),
'kakete': ('kake',),
'kakede': ('kake',),
'kakende': ('kake',),
'kakka': ('kakke',),
'kakket': ('kakke',),
'kakka': ('kakke',),
'kakket': ('kakke',),
'kakka': ('kakke',),
'kakkete': ('kakke',),
'kakkede': ('kakke',),
'kakka': ('kakke',),
'kakkete': ('kakke',),
'kakkede': ('kakke',),
'kakkende': ('kakke',),
'kakla': ('kakle',),
'kaklet': ('kakle',),
'kakla': ('kakle',),
'kaklet': ('kakle',),
'kakla': ('kakle',),
'kaklete': ('kakle',),
'kaklede': ('kakle',),
'kaklete': ('kakle',),
'kaklede': ('kakle',),
'kakla': ('kakle',),
'kaklete': ('kakle',),
'kaklede': ('kakle',),
'kaklete': ('kakle',),
'kaklede': ('kakle',),
'kaklende': ('kakle',),
'kakofon': ('kakofon',),
'kakofone': ('kakofon',),
'kakofont': ('kakofon',),
'kakofonisk': ('kakofonisk',),
'kakofoniske': ('kakofonisk',),
'kakofonisk': ('kakofonisk',),
'kakstrøket': ('kakstryke',),
'kakstrøken': ('kakstryke',),
'kakstrøket': ('kakstryke',),
'kakstrøken': ('kakstryke',),
'kakstrøkne': ('kakstryke',),
'kakstrykende': ('kakstryke',),
'kakuminal': ('kakuminal',),
'kakuminale': ('kakuminal',),
'kakuminalt': ('kakuminal',),
'kakuminalisert': ('kakuminalisere',),
'kakuminaliserte': ('kakuminalisere',),
'kakuminaliserende': ('kakuminalisere',),
'kalandrert': ('kalandrere',),
'kalandrerte': ('kalandrere',),
'kalandrerende': ('kalandrere',),
'kald': ('kald',),
'kalde': ('kald',),
'kaldt': ('kald',),
'kaldere': ('kald',),
'kaldest': ('kald',),
'kaldeste': ('kald',),
'kaldblodig': ('kaldblodig',),
'kaldblodige': ('kaldblodig',),
'kaldblodig': ('kaldblodig',),
'kaldeisk': ('kaldeisk',),
'kaldeiske': ('kaldeisk',),
'kaldeisk': ('kaldeisk',),
'kaldflirt': ('kaldflire',),
'kaldflirte': ('kaldflire',),
'kaldflirende': ('kaldflire',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykt': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykt': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykte': ('kaldrøyke',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykte': ('kaldrøyke',),
'kaldrøykende': ('kaldrøyke',),
'kaldskjør': ('kaldskjør',),
'kaldskjøre': ('kaldskjør',),
'kaldskjørt': ('kaldskjør',),
'kaldskratta': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskrattete': ('kaldskratte',),
'kaldskrattede': ('kaldskratte',),
'kaldskratta': ('kaldskratte',),
'kaldskrattete': ('kaldskratte',),
'kaldskrattede': ('kaldskratte',),
'kaldskrattende': ('kaldskratte',),
'kaldslig': ('kaldslig',),
'kaldslige': ('kaldslig',),
'kaldslig': ('kaldslig',),
'kaldsmidd': ('kaldsmi',),
'kaldsmidde': ('kaldsmi',),
'kaldsmiende': ('kaldsmi',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettete': ('kaldsvette',),
'kaldsvettede': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettete': ('kaldsvette',),
'kaldsvettede': ('kaldsvette',),
'kaldsvettende': ('kaldsvette',),
'kaledonsk': ('kaledonsk',),
'kaledonske': ('kaledonsk',),
'kaledonsk': ('kaledonsk',),
'kaleidoskopisk': ('kaleidoskopisk',),
'kaleidoskopiske': ('kaleidoskopisk',),
'kaleidoskopisk': ('kaleidoskopisk',),
'kalfatra': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatrete': ('kalfatre',),
'kalfatrede': ('kalfatre',),
'kalfatrete': ('kalfatre',),
'kalfatrede': ('kalfatre',),
'kalfatra': ('kalfatre',),
'kalfatrete': ('kalfatre',),
'kalfatrede': ('kalfatre',),
'kalfatrete': ('kalfatre',),
'kalfatrede': ('kalfatre',),
'kalfatrende': ('kalfatre',),
'kalibrert': ('kalibrere',),
'kalibrerte': ('kalibrere',),
'kalibrerende': ('kalibrere',),
'kalifornisk': ('kalifornisk',),
'kaliforniske': ('kalifornisk',),
'kalifornisk': ('kalifornisk',),
'kalka': ('kalke',),
'kalket': ('kalke',),
'kalka': ('kalke',),
'kalket': ('kalke',),
'kalka': ('kalke',),
'kalkete': ('kalke',),
'kalkede': ('kalke',),
'kalka': ('kalke',),
'kalkete': ('kalke',),
'kalkede': ('kalke',),
'kalkende': ('kalke',),
'kalkert': ('kalkere',),
'kalkerte': ('kalkere',),
'kalkerende': ('kalkere',),
'kalkholdig': ('kalkholdig',),
'kalkholdige': ('kalkholdig',),
'kalkholdig': ('kalkholdig',),
'kalkulatorisk': ('kalkulatorisk',),
'kalkulatoriske': ('kalkulatorisk',),
'kalkulatorisk': ('kalkulatorisk',),
'kalkulert': ('kalkulere',),
'kalkulerte': ('kalkulere',),
'kalkulerende': ('kalkulere',),
'kalkunsk': ('kalkunsk',),
'kalkunske': ('kalkunsk',),
'kalkunsk': ('kalkunsk',),
'kalt': ('kalle',),
'kalte': ('kalle',),
'kallende': ('kalle',),
'kalligrafert': ('kalligrafere',),
'kalligraferte': ('kalligrafere',),
'kalligraferende': ('kalligrafere',),
'kalligrafisk': ('kalligrafisk',),
'kalligrafiske': ('kalligrafisk',),
'kalligrafisk': ('kalligrafisk',),
'kalmukkisk': ('kalmukkisk',),
'kalmukkiske': ('kalmukkisk',),
'kalmukkisk': ('kalmukkisk',),
'kalorifattig': ('kalorifattig',),
'kalorifattige': ('kalorifattig',),
'kalorifattig': ('kalorifattig',),
'kalsinert': ('kalsinere',),
'kalsinerte': ('kalsinere',),
'kalsinerende': ('kalsinere',),
'kalvbeint': ('kalvbeint',),
'kalvbeinte': ('kalvbeint',),
'kalvbeint': ('kalvbeint',),
'kalvbent': ('kalvbent',),
'kalvbente': ('kalvbent',),
'kalvbent': ('kalvbent',),
'kalvdiger': ('kalvdiger',),
'kalvdigre': ('kalvdiger',),
'kalvdigert': ('kalvdiger',),
'kalva': ('kalve',),
'kalvet': ('kalve',),
'kalva': ('kalve',),
'kalvet': ('kalve',),
'kalva': ('kalve',),
'kalvete': ('kalve',),
'kalvede': ('kalve',),
'kalva': ('kalve',),
'kalvete': ('kalve',),
'kalvede': ('kalve',),
'kalvende': ('kalve',),
'kalvet': ('kalvet',),
'kalvete': ('kalvet',),
'kalvet': ('kalvet',),
'kalvete': ('kalvete',),
'kalvinistisk': ('kalvinistisk',),
'kalvinistiske': ('kalvinistisk',),
'kalvinistisk': ('kalvinistisk',),
'kalvinsk': ('kalvinsk',),
'kalvinske': ('kalvinsk',),
'kalvinsk': ('kalvinsk',),
'kambial': ('kambial',),
'kambiale': ('kambial',),
'kambialt': ('kambial',),
'kambodsjansk': ('kambodsjansk',),
'kambodsjanske': ('kambodsjansk',),
'kambodsjansk': ('kambodsjansk',),
'kambrisk': ('kambrisk',),
'kambriske': ('kambrisk',),
'kambrisk': ('kambrisk',),
'kameleonaktig': ('kameleonaktig',),
'kameleonaktige': ('kameleonaktig',),
'kameleonaktig': ('kameleonaktig',),
'kameratslig': ('kameratslig',),
'kameratslige': ('kameratslig',),
'kameratslig': ('kameratslig',),
'kamerunsk': ('kamerunsk',),
'kamerunske': ('kamerunsk',),
'kamerunsk': ('kamerunsk',),
'kamma': ('kamme',),
'kammet': ('kamme',),
'kamma': ('kamme',),
'kammet': ('kamme',),
'kamma': ('kamme',),
'kammete': ('kamme',),
'kammede': ('kamme',),
'kamma': ('kamme',),
'kammete': ('kamme',),
'kammede': ('kamme',),
'kammende': ('kamme',),
'kampdyktig': ('kampdyktig',),
'kampdyktige': ('kampdyktig',),
'kampdyktig': ('kampdyktig',),
'kampert': ('kampere',),
'kamperte': ('kampere',),
'kamperende': ('kampere',),
'kamplysten': ('kamplysten',),
'kamplystne': ('kamplysten',),
'kamplystent': ('kamplysten',),
'kampudyktig': ('kampudyktig',),
'kampudyktige': ('kampudyktig',),
'kampudyktig': ('kampudyktig',),
'kamsa': ('kamse',),
'kamset': ('kamse',),
'kamsa': ('kamse',),
'kamset': ('kamse',),
'kamsa': ('kamse',),
'kamsete': ('kamse',),
'kamsede': ('kamse',),
'kamsa': ('kamse',),
'kamsete': ('kamse',),
'kamsede': ('kamse',),
'kamsende': ('kamse',),
'kamuflert': ('kamuflere',),
'kamuflerte': ('kamuflere',),
'kamuflerende': ('kamuflere',),
'kanaaneisk': ('kanaaneisk',),
'kanaaneiske': ('kanaaneisk',),
'kanaaneisk': ('kanaaneisk',),
'kanaanittisk': ('kanaanittisk',),
'kanaanittiske': ('kanaanittisk',),
'kanaanittisk': ('kanaanittisk',),
'kanadisk': ('kanadisk',),
'kanadiske': ('kanadisk',),
'kanadisk': ('kanadisk',),
'kanalisert': ('kanalisere',),
'kanaliserte': ('kanalisere',),
'kanaliserende': ('kanalisere',),
'kanarisk': ('kanarisk',),
'kanariske': ('kanarisk',),
'kanarisk': ('kanarisk',),
'kandidert': ('kandidere',),
'kandiderte': ('kandidere',),
'kandiderende': ('kandidere',),
'kandisert': ('kandisere',),
'kandiserte': ('kandisere',),
'kandiserende': ('kandisere',),
'kannelert': ('kannelere',),
'kannelerte': ('kannelere',),
'kannelerende': ('kannelere',),
'kannibalsk': ('kannibalsk',),
'kannibalske': ('kannibalsk',),
'kannibalsk': ('kannibalsk',),
'kanonisert': ('kanonisere',),
'kanoniserte': ('kanonisere',),
'kanoniserende': ('kanonisere',),
'kanonisk': ('kanonisk',),
'kanoniske': ('kanonisk',),
'kanonisk': ('kanonisk',),
'kansellert': ('kansellere',),
'kansellerte': ('kansellere',),
'kansellerende': ('kansellere',),
'kanta': ('kante',),
'kantet': ('kante',),
'kanta': ('kante',),
'kantet': ('kante',),
'kanta': ('kante',),
'kantete': ('kante',),
'kantede': ('kante',),
'kanta': ('kante',),
'kantete': ('kante',),
'kantede': ('kante',),
'kantende': ('kante',),
'kantet': ('kantet',),
'kantete': ('kantet',),
'kantet': ('kantet',),
'kantete': ('kantete',),
'kantra': ('kantre',),
'kantret': ('kantre',),
'kantra': ('kantre',),
'kantret': ('kantre',),
'kantra': ('kantre',),
'kantrete': ('kantre',),
'kantrede': ('kantre',),
'kantrete': ('kantre',),
'kantrede': ('kantre',),
'kantra': ('kantre',),
'kantrete': ('kantre',),
'kantrede': ('kantre',),
'kantrete': ('kantre',),
'kantrede': ('kantre',),
'kantrende': ('kantre',),
'kaotisk': ('kaotisk',),
'kaotiske': ('kaotisk',),
'kaotisk': ('kaotisk',),
'kapabel': ('kapabel',),
'kapable': ('kapabel',),
'kapabelt': ('kapabel',),
'kapillær': ('kapillær',),
'kapillære': ('kapillær',),
'kapillært': ('kapillær',),
'kapital': ('kapital',),
'kapitale': ('kapital',),
'kapitalt': ('kapital',),
'kapitalintensiv': ('kapitalintensiv',),
'kapitalintensive': ('kapitalintensiv',),
'kapitalintensivt': ('kapitalintensiv',),
'kapitalisert': ('kapitalisere',),
'kapitaliserte': ('kapitalisere',),
'kapitaliserende': ('kapitalisere',),
'kapitalistisk': ('kapitalistisk',),
'kapitalistiske': ('kapitalistisk',),
'kapitalistisk': ('kapitalistisk',),
'kapitalkrevende': ('kapitalkrevende',),
'kapitulert': ('kapitulere',),
'kapitulerte': ('kapitulere',),
'kapitulerende': ('kapitulere',),
'kappdrukket': ('kappdrikke',),
'kappdrukken': ('kappdrikke',),
'kappdrukne': ('kappdrikke',),
'kappdrikkende': ('kappdrikke',),
'kappa': ('kappe',),
'kappet': ('kappe',),
'kappa': ('kappe',),
'kappet': ('kappe',),
'kappa': ('kappe',),
'kappete': ('kappe',),
'kappede': ('kappe',),
'kappa': ('kappe',),
'kappete': ('kappe',),
'kappede': ('kappe',),
'kappende': ('kappe',),
'kappekledd': ('kappekledd',),
'kappekledde': ('kappekledd',),
'kappekledd': ('kappekledd',),
'kappkjørt': ('kappkjøre',),
'kappkjørte': ('kappkjøre',),
'kappkjørende': ('kappkjøre',),
'kappverdisk': ('kappverdisk',),
'kappverdiske': ('kappverdisk',),
'kappverdisk': ('kappverdisk',),
'kapra': ('kapre',),
'kapret': ('kapre',),
'kapra': ('kapre',),
'kapret': ('kapre',),
'kapra': ('kapre',),
'kaprete': ('kapre',),
'kaprede': ('kapre',),
'kaprete': ('kapre',),
'kaprede': ('kapre',),
'kapra': ('kapre',),
'kaprete': ('kapre',),
'kaprede': ('kapre',),
'kaprete': ('kapre',),
'kaprede': ('kapre',),
'kaprende': ('kapre',),
'kaprisiøs': ('kaprisiøs',),
'kaprisiøse': ('kaprisiøs',),
'kaprisiøst': ('kaprisiøs',),
'kapseist': ('kapseise',),
'kapseiste': ('kapseise',),
'kapseisende': ('kapseise',),
'kapsla': ('kapsle',),
'kapslet': ('kapsle',),
'kapsla': ('kapsle',),
'kapslet': ('kapsle',),
'kapsla': ('kapsle',),
'kapslete': ('kapsle',),
'kapslede': ('kapsle',),
'kapslete': ('kapsle',),
'kapslede': ('kapsle',),
'kapsla': ('kapsle',),
'kapslete': ('kapsle',),
'kapslede': ('kapsle',),
'kapslete': ('kapsle',),
'kapslede': ('kapsle',),
'kapslende': ('kapsle',),
'kapunert': ('kapunere',),
'kapunerte': ('kapunere',),
'kapunerende': ('kapunere',),
'kaputt': ('kaputt',),
'karakterdannende': ('karakterdannende',),
'karakterfast': ('karakterfast',),
'karakterfaste': ('karakterfast',),
'karakterfast': ('karakterfast',),
'karakterisert': ('karakterisere',),
'karakteriserte': ('karakterisere',),
'karakteriserende': ('karakterisere',),
'karakteristisk': ('karakteristisk',),
'karakteristiske': ('karakteristisk',),
'karakteristisk': ('karakteristisk',),
'karakterlaus': ('karakterlaus',),
'karakterlause': ('karakterlaus',),
'karakterlaust': ('karakterlaus',),
'karakterløs': ('karakterløs',),
'karakterløse': ('karakterløs',),
'karakterløst': ('karakterløs',),
'kardansk': ('kardansk',),
'kardanske': ('kardansk',),
'kardansk': ('kardansk',),
'karda': ('karde',),
'kardet': ('karde',),
'karda': ('karde',),
'kardet': ('karde',),
'karda': ('karde',),
'kardete': ('karde',),
'kardede': ('karde',),
'karda': ('karde',),
'kardete': ('karde',),
'kardede': ('karde',),
'kardende': ('karde',),
'kara': ('kare',),
'karet': ('kare',),
'kara': ('kare',),
'karet': ('kare',),
'kara': ('kare',),
'karete': ('kare',),
'karede': ('kare',),
'kara': ('kare',),
'karete': ('kare',),
'karede': ('kare',),
'karende': ('kare',),
'karelsk': ('karelsk',),
'karelske': ('karelsk',),
'karelsk': ('karelsk',),
'karibisk': ('karibisk',),
'karibiske': ('karibisk',),
'karibisk': ('karibisk',),
'karikert': ('karikere',),
'karikerte': ('karikere',),
'karikerende': ('karikere',),
'karismatisk': ('karismatisk',),
'karismatiske': ('karismatisk',),
'karismatisk': ('karismatisk',),
'kariøs': ('kariøs',),
'kariøse': ('kariøs',),
'kariøst': ('kariøs',),
'karminrød': ('karminrød',),
'karminrøde': ('karminrød',),
'karminrødt': ('karminrød',),
'karnøfla': ('karnøfle',),
'karnøflet': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøflet': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøflete': ('karnøfle',),
'karnøflede': ('karnøfle',),
'karnøflete': ('karnøfle',),
'karnøflede': ('karnøfle',),
'karnøfla': ('karnøfle',),
'karnøflete': ('karnøfle',),
'karnøflede': ('karnøfle',),
'karnøflete': ('karnøfle',),
'karnøflede': ('karnøfle',),
'karnøflende': ('karnøfle',),
'karolingisk': ('karolingisk',),
'karolingiske': ('karolingisk',),
'karolingisk': ('karolingisk',),
'karolinsk': ('karolinsk',),
'karolinske': ('karolinsk',),
'karolinsk': ('karolinsk',),
'karrig': ('karrig',),
'karrige': ('karrig',),
'karrig': ('karrig',),
'karrigere': ('karrig',),
'karrigst': ('karrig',),
'karrigste': ('karrig',),
'karsk': ('karsk',),
'karske': ('karsk',),
'karskt': ('karsk',),
'karskere': ('karsk',),
'karskest': ('karsk',),
'karskeste': ('karsk',),
'karslig': ('karslig',),
'karslige': ('karslig',),
'karslig': ('karslig',),
'karta': ('karte',),
'kartet': ('karte',),
'karta': ('karte',),
'kartet': ('karte',),
'karta': ('karte',),
'kartete': ('karte',),
'kartede': ('karte',),
'karta': ('karte',),
'kartete': ('karte',),
'kartede': ('karte',),
'kartende': ('karte',),
'kartert': ('kartere',),
'karterte': ('kartere',),
'karterende': ('kartere',),
'kartesiansk': ('kartesiansk',),
'kartesianske': ('kartesiansk',),
'kartesiansk': ('kartesiansk',),
'kartesisk': ('kartesisk',),
'kartesiske': ('kartesisk',),
'kartesisk': ('kartesisk',),
'kartlagt': ('kartlegge',),
'kartlagte': ('kartlegge',),
'kartleggende': ('kartlegge',),
'kartonert': ('kartonere',),
'kartonerte': ('kartonere',),
'kartonerende': ('kartonere',),
'karva': ('karve',),
'karvet': ('karve',),
'karva': ('karve',),
'karvet': ('karve',),
'karva': ('karve',),
'karvete': ('karve',),
'karvede': ('karve',),
'karva': ('karve',),
'karvete': ('karve',),
'karvede': ('karve',),
'karvende': ('karve',),
'kasakhisk': ('kasakhisk',),
'kasakhiske': ('kasakhisk',),
'kasakhisk': ('kasakhisk',),
'kasa': ('kase',),
'kaset': ('kase',),
'kasa': ('kase',),
'kaset': ('kase',),
'kasa': ('kase',),
'kasete': ('kase',),
'kasede': ('kase',),
'kasa': ('kase',),
'kasete': ('kase',),
'kasede': ('kase',),
'kasende': ('kase',),
'kasjmirsk': ('kasjmirsk',),
'kasjmirske': ('kasjmirsk',),
'kasjmirsk': ('kasjmirsk',),
'kassabel': ('kassabel',),
'kassable': ('kassabel',),
'kassabelt': ('kassabel',),
'kassert': ('kassere',),
'kasserte': ('kassere',),
'kasserende': ('kassere',),
'kastanjebrun': ('kastanjebrun',),
'kastanjebrune': ('kastanjebrun',),
'kastanjebrunt': ('kastanjebrun',),
'kasta': ('kaste',),
'kastet': ('kaste',),
'kasta': ('kaste',),
'kastet': ('kaste',),
'kasta': ('kaste',),
'kastete': ('kaste',),
'kastede': ('kaste',),
'kasta': ('kaste',),
'kastete': ('kaste',),
'kastede': ('kaste',),
'kastende': ('kaste',),
'kastebytta': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebyttete': ('kastebytte',),
'kastebyttede': ('kastebytte',),
'kastebytta': ('kastebytte',),
'kastebyttete': ('kastebytte',),
'kastebyttede': ('kastebytte',),
'kastebyttende': ('kastebytte',),
'kastelaus': ('kastelaus',),
'kastelause': ('kastelaus',),
'kastelaust': ('kastelaus',),
'kasteløs': ('kasteløs',),
'kasteløse': ('kasteløs',),
'kasteløst': ('kasteløs',),
'kastiljansk': ('kastiljansk',),
'kastiljanske': ('kastiljansk',),
'kastiljansk': ('kastiljansk',),
'kastrert': ('kastrere',),
'kastrerte': ('kastrere',),
'kastrerende': ('kastrere',),
'kasuistisk': ('kasuistisk',),
'kasuistiske': ('kasuistisk',),
'kasuistisk': ('kasuistisk',),
'katalansk': ('katalansk',),
'katalanske': ('katalansk',),
'katalansk': ('katalansk',),
'katalogisert': ('katalogisere',),
'katalogiserte': ('katalogisere',),
'katalogiserende': ('katalogisere',),
'katalysert': ('katalysere',),
'katalyserte': ('katalysere',),
'katalyserende': ('katalysere',),
'katalytisk': ('katalytisk',),
'katalytiske': ('katalytisk',),
'katalytisk': ('katalytisk',),
'katarralsk': ('katarralsk',),
'katarralske': ('katarralsk',),
'katarralsk': ('katarralsk',),
'katastrofal': ('katastrofal',),
'katastrofale': ('katastrofal',),
'katastrofalt': ('katastrofal',),
'katataktisk': ('katataktisk',),
'katataktiske': ('katataktisk',),
'katataktisk': ('katataktisk',),
'kategorisert': ('kategorisere',),
'kategoriserte': ('kategorisere',),
'kategoriserende': ('kategorisere',),
'kategorisk': ('kategorisk',),
'kategoriske': ('kategorisk',),
'kategorisk': ('kategorisk',),
'kateketisk': ('kateketisk',),
'kateketiske': ('kateketisk',),
'kateketisk': ('kateketisk',),
'katekisert': ('katekisere',),
'katekiserte': ('katekisere',),
'katekiserende': ('katekisere',),
'katolisert': ('katolisere',),
'katoliserte': ('katolisere',),
'katoliserende': ('katolisere',),
'katolsk': ('katolsk',),
'katolske': ('katolsk',),
'katolsk': ('katolsk',),
'kattaktig': ('kattaktig',),
'kattaktige': ('kattaktig',),
'kattaktig': ('kattaktig',),
'katta': ('katte',),
'kattet': ('katte',),
'katta': ('katte',),
'kattet': ('katte',),
'katta': ('katte',),
'kattete': ('katte',),
'kattede': ('katte',),
'katta': ('katte',),
'kattete': ('katte',),
'kattede': ('katte',),
'kattende': ('katte',),
'katteaktig': ('katteaktig',),
'katteaktige': ('katteaktig',),
'katteaktig': ('katteaktig',),
'kattemjuk': ('kattemjuk',),
'kattemjuke': ('kattemjuk',),
'kattemjukt': ('kattemjuk',),
'kattemyk': ('kattemyk',),
'kattemyke': ('kattemyk',),
'kattemykt': ('kattemyk',),
'kaua': ('kaue',),
'kauet': ('kaue',),
'kaua': ('kaue',),
'kauet': ('kaue',),
'kaua': ('kaue',),
'kauete': ('kaue',),
'kauede': ('kaue',),
'kaua': ('kaue',),
'kauete': ('kaue',),
'kauede': ('kaue',),
'kauende': ('kaue',),
'kaukasisk': ('kaukasisk',),
'kaukasiske': ('kaukasisk',),
'kaukasisk': ('kaukasisk',),
'kaukasoid': ('kaukasoid',),
'kaukasoide': ('kaukasoid',),
'kaukasoid': ('kaukasoid',),
'kauka': ('kauke',),
'kauket': ('kauke',),
'kauka': ('kauke',),
'kauket': ('kauke',),
'kauka': ('kauke',),
'kaukete': ('kauke',),
'kaukede': ('kauke',),
'kauka': ('kauke',),
'kaukete': ('kauke',),
'kaukede': ('kauke',),
'kaukende': ('kauke',),
'kausal': ('kausal',),
'kausale': ('kausal',),
'kausalt': ('kausal',),
'kausativ': ('kausativ',),
'kausative': ('kausativ',),
'kausativt': ('kausativ',),
'kausjonert': ('kausjonere',),
'kausjonerte': ('kausjonere',),
'kausjonerende': ('kausjonere',),
'kaustisk': ('kaustisk',),
'kaustiske': ('kaustisk',),
'kaustisk': ('kaustisk',),
'kaut': ('kaut',),
'kaute': ('kaut',),
'kaut': ('kaut',),
'kautere': ('kaut',),
'kautest': ('kaut',),
'kauteste': ('kaut',),
'kava': ('kave',),
'kavet': ('kave',),
'kavd': ('kave',),
'kava': ('kave',),
'kavet': ('kave',),
'kavd': ('kave',),
'kava': ('kave',),
'kavete': ('kave',),
'kavede': ('kave',),
'kavde': ('kave',),
'kava': ('kave',),
'kavete': ('kave',),
'kavede': ('kave',),
'kavde': ('kave',),
'kavende': ('kave',),
'kavert': ('kavere',),
'kaverte': ('kavere',),
'kaverende': ('kavere',),
'kavernøs': ('kavernøs',),
'kavernøse': ('kavernøs',),
'kavernøst': ('kavernøs',),
'kavla': ('kavle',),
'kavlet': ('kavle',),
'kavla': ('kavle',),
'kavlet': ('kavle',),
'kavla': ('kavle',),
'kavlete': ('kavle',),
'kavlede': ('kavle',),
'kavlete': ('kavle',),
'kavlede': ('kavle',),
'kavla': ('kavle',),
'kavlete': ('kavle',),
'kavlede': ('kavle',),
'kavlete': ('kavle',),
'kavlede': ('kavle',),
'kavlende': ('kavle',),
'kavlet': ('kavlet',),
'kavlete': ('kavlet',),
'kavlet': ('kavlet',),
'kavlete': ('kavlete',),
'keia': ('keie',),
'keiet': ('keie',),
'keia': ('keie',),
'keiet': ('keie',),
'keia': ('keie',),
'keiete': ('keie',),
'keiede': ('keie',),
'keia': ('keie',),
'keiete': ('keie',),
'keiede': ('keie',),
'keiende': ('keie',),
'keik': ('keik',),
'keike': ('keik',),
'keikt': ('keik',),
'keika': ('keike',),
'keiket': ('keike',),
'keikt': ('keike',),
'keika': ('keike',),
'keiket': ('keike',),
'keikt': ('keike',),
'keika': ('keike',),
'keikete': ('keike',),
'keikede': ('keike',),
'keikte': ('keike',),
'keika': ('keike',),
'keikete': ('keike',),
'keikede': ('keike',),
'keikte': ('keike',),
'keikende': ('keike',),
'keiket': ('keiket',),
'keikete': ('keiket',),
'keiket': ('keiket',),
'keikete': ('keikete',),
'keisam': ('keisam',),
'keisamme': ('keisam',),
'keisamt': ('keisam',),
'keisammere': ('keisam',),
'keisamst': ('keisam',),
'keisamste': ('keisam',),
'keiserlig': ('keiserlig',),
'keiserlige': ('keiserlig',),
'keiserlig': ('keiserlig',),
'keitet': ('keitet',),
'keitete': ('keitet',),
'keitet': ('keitet',),
'keitete': ('keitete',),
'keiv': ('keiv',),
'keive': ('keiv',),
'keivt': ('keiv',),
'keivelig': ('keivelig',),
'keivelige': ('keivelig',),
'keivelig': ('keivelig',),
'keiven': ('keiven',),
'keivne': ('keiven',),
'keivent': ('keiven',),
'keivet': ('keivet',),
'keivete': ('keivet',),
'keivet': ('keivet',),
'keivete': ('keivete',),
'keivhendt': ('keivhendt',),
'keivhendte': ('keivhendt',),
'keivhendt': ('keivhendt',),
'keivla': ('keivle',),
'keivlet': ('keivle',),
'keivla': ('keivle',),
'keivlet': ('keivle',),
'keivla': ('keivle',),
'keivlete': ('keivle',),
'keivlede': ('keivle',),
'keivlete': ('keivle',),
'keivlede': ('keivle',),
'keivla': ('keivle',),
'keivlete': ('keivle',),
'keivlede': ('keivle',),
'keivlete': ('keivle',),
'keivlede': ('keivle',),
'keivlende': ('keivle',),
'keltisk': ('keltisk',),
'keltiske': ('keltisk',),
'keltisk': ('keltisk',),
'kenyansk': ('kenyansk',),
'kenyanske': ('kenyansk',),
'kenyansk': ('kenyansk',),
'keramisk': ('keramisk',),
'keramiske': ('keramisk',),
'keramisk': ('keramisk',),
'kibba': ('kibbe',),
'kibbet': ('kibbe',),
'kibba': ('kibbe',),
'kibbet': ('kibbe',),
'kibba': ('kibbe',),
'kibbete': ('kibbe',),
'kibbede': ('kibbe',),
'kibba': ('kibbe',),
'kibbete': ('kibbe',),
'kibbede': ('kibbe',),
'kibbende': ('kibbe',),
'kidnappa': ('kidnappe',),
'kidnappet': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappet': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappete': ('kidnappe',),
'kidnappede': ('kidnappe',),
'kidnappa': ('kidnappe',),
'kidnappete': ('kidnappe',),
'kidnappede': ('kidnappe',),
'kidnappende': ('kidnappe',),
'kika': ('kike',),
'kiket': ('kike',),
'kika': ('kike',),
'kiket': ('kike',),
'kika': ('kike',),
'kikete': ('kike',),
'kikede': ('kike',),
'kika': ('kike',),
'kikete': ('kike',),
'kikede': ('kike',),
'kikende': ('kike',),
'kikt': ('kike',),
'kikte': ('kike',),
'kikende': ('kike',),
'kikka': ('kikke',),
'kikket': ('kikke',),
'kikka': ('kikke',),
'kikket': ('kikke',),
'kikka': ('kikke',),
'kikkete': ('kikke',),
'kikkede': ('kikke',),
'kikka': ('kikke',),
'kikkete': ('kikke',),
'kikkede': ('kikke',),
'kikkende': ('kikke',),
'kikna': ('kikne',),
'kiknet': ('kikne',),
'kikna': ('kikne',),
'kiknet': ('kikne',),
'kikna': ('kikne',),
'kiknete': ('kikne',),
'kiknede': ('kikne',),
'kiknete': ('kikne',),
'kiknede': ('kikne',),
'kikna': ('kikne',),
'kiknete': ('kikne',),
'kiknede': ('kikne',),
'kiknete': ('kikne',),
'kiknede': ('kikne',),
'kiknende': ('kikne',),
'kikra': ('kikre',),
'kikret': ('kikre',),
'kikra': ('kikre',),
'kikret': ('kikre',),
'kikra': ('kikre',),
'kikrete': ('kikre',),
'kikrede': ('kikre',),
'kikrete': ('kikre',),
'kikrede': ('kikre',),
'kikra': ('kikre',),
'kikrete': ('kikre',),
'kikrede': ('kikre',),
'kikrete': ('kikre',),
'kikrede': ('kikre',),
'kikrende': ('kikre',),
'kiksa': ('kikse',),
'kikset': ('kikse',),
'kiksa': ('kikse',),
'kikset': ('kikse',),
'kiksa': ('kikse',),
'kiksete': ('kikse',),
'kiksede': ('kikse',),
'kiksa': ('kikse',),
'kiksete': ('kikse',),
'kiksede': ('kikse',),
'kiksende': ('kikse',),
'kilden': ('kilden',),
'kildne': ('kilden',),
'kildent': ('kilden',),
'kildra': ('kildre',),
'kildret': ('kildre',),
'kildra': ('kildre',),
'kildret': ('kildre',),
'kildra': ('kildre',),
'kildrete': ('kildre',),
'kildrede': ('kildre',),
'kildrete': ('kildre',),
'kildrede': ('kildre',),
'kildra': ('kildre',),
'kildrete': ('kildre',),
'kildrede': ('kildre',),
'kildrete': ('kildre',),
'kildrede': ('kildre',),
'kildrende': ('kildre',),
'kilt': ('kile',),
'kilte': ('kile',),
'kilende': ('kile',),
'kilen': ('kilen',),
'kilne': ('kilen',),
'kilent': ('kilen',),
'kimbrisk': ('kimbrisk',),
'kimbriske': ('kimbrisk',),
'kimbrisk': ('kimbrisk',),
'kima': ('kime',),
'kimet': ('kime',),
'kimt': ('kime',),
'kima': ('kime',),
'kimet': ('kime',),
'kimt': ('kime',),
'kima': ('kime',),
'kimete': ('kime',),
'kimede': ('kime',),
'kimte': ('kime',),
'kima': ('kime',),
'kimete': ('kime',),
'kimede': ('kime',),
'kimte': ('kime',),
'kimende': ('kime',),
'kimsa': ('kimse',),
'kimset': ('kimse',),
'kimsa': ('kimse',),
'kimset': ('kimse',),
'kimsa': ('kimse',),
'kimsete': ('kimse',),
'kimsede': ('kimse',),
'kimsa': ('kimse',),
'kimsete': ('kimse',),
'kimsede': ('kimse',),
'kimsende': ('kimse',),
'kinesisk': ('kinesisk',),
'kinesiske': ('kinesisk',),
'kinesisk': ('kinesisk',),
'kinestetisk': ('kinestetisk',),
'kinestetiske': ('kinestetisk',),
'kinestetisk': ('kinestetisk',),
'kinetisk': ('kinetisk',),
'kinetiske': ('kinetisk',),
'kinetisk': ('kinetisk',),
'kingsa': ('kingse',),
'kingset': ('kingse',),
'kingsa': ('kingse',),
'kingset': ('kingse',),
'kingsa': ('kingse',),
'kingsete': ('kingse',),
'kingsede': ('kingse',),
'kingsa': ('kingse',),
'kingsete': ('kingse',),
'kingsede': ('kingse',),
'kingsende': ('kingse',),
'kinka': ('kinke',),
'kinket': ('kinke',),
'kinka': ('kinke',),
'kinket': ('kinke',),
'kinka': ('kinke',),
'kinkete': ('kinke',),
'kinkede': ('kinke',),
'kinka': ('kinke',),
'kinkete': ('kinke',),
'kinkede': ('kinke',),
'kinkende': ('kinke',),
'kinkig': ('kinkig',),
'kinkige': ('kinkig',),
'kinkig': ('kinkig',),
'kinksa': ('kinkse',),
'kinkset': ('kinkse',),
'kinksa': ('kinkse',),
'kinkset': ('kinkse',),
'kinksa': ('kinkse',),
'kinksete': ('kinkse',),
'kinksede': ('kinkse',),
'kinksa': ('kinkse',),
'kinksete': ('kinkse',),
'kinksede': ('kinkse',),
'kinksende': ('kinkse',),
'kinna': ('kinne',),
'kinnet': ('kinne',),
'kinna': ('kinne',),
'kinnet': ('kinne',),
'kinna': ('kinne',),
'kinnete': ('kinne',),
'kinnede': ('kinne',),
'kinna': ('kinne',),
'kinnete': ('kinne',),
'kinnede': ('kinne',),
'kinnende': ('kinne',),
'kipen': ('kipen',),
'kipne': ('kipen',),
'kipent': ('kipen',),
'kippa': ('kippe',),
'kippet': ('kippe',),
'kipt': ('kippe',),
'kippa': ('kippe',),
'kippet': ('kippe',),
'kipt': ('kippe',),
'kippa': ('kippe',),
'kippete': ('kippe',),
'kippede': ('kippe',),
'kipte': ('kippe',),
'kippa': ('kippe',),
'kippete': ('kippe',),
'kippede': ('kippe',),
'kipte': ('kippe',),
'kippende': ('kippe',),
'kippskodd': ('kippskodd',),
'kippskodde': ('kippskodd',),
'kippskodd': ('kippskodd',),
'kirgisisk': ('kirgisisk',),
'kirgisiske': ('kirgisisk',),
'kirgisisk': ('kirgisisk',),
'kiribatisk': ('kiribatisk',),
'kiribatiske': ('kiribatisk',),
'kiribatisk': ('kiribatisk',),
'kirkefremmed': ('kirkefremmed',),
'kirkefremmede': ('kirkefremmed',),
'kirkefremmed': ('kirkefremmed',),
'kirkelig': ('kirkelig',),
'kirkelige': ('kirkelig',),
'kirkelig': ('kirkelig',),
'kiropraktisk': ('kiropraktisk',),
'kiropraktiske': ('kiropraktisk',),
'kiropraktisk': ('kiropraktisk',),
'kirurgisk': ('kirurgisk',),
'kirurgiske': ('kirurgisk',),
'kirurgisk': ('kirurgisk',),
'kisla': ('kisle',),
'kislet': ('kisle',),
'kisla': ('kisle',),
'kislet': ('kisle',),
'kisla': ('kisle',),
'kislete': ('kisle',),
'kislede': ('kisle',),
'kisla': ('kisle',),
'kislete': ('kisle',),
'kislede': ('kisle',),
'kislende': ('kisle',),
'kislen': ('kislen',),
'kislne': ('kislen',),
'kislent': ('kislen',),
'kisteglad': ('kisteglad',),
'kisteglade': ('kisteglad',),
'kisteglad': ('kisteglad',),
'kitla': ('kitle',),
'kitlet': ('kitle',),
'kitla': ('kitle',),
'kitlet': ('kitle',),
'kitla': ('kitle',),
'kitlete': ('kitle',),
'kitlede': ('kitle',),
'kitlete': ('kitle',),
'kitlede': ('kitle',),
'kitla': ('kitle',),
'kitlete': ('kitle',),
'kitlede': ('kitle',),
'kitlete': ('kitle',),
'kitlede': ('kitle',),
'kitlende': ('kitle',),
'kitlen': ('kitlen',),
'kitlne': ('kitlen',),
'kitlent': ('kitlen',),
'kitta': ('kitte',),
'kittet': ('kitte',),
'kitta': ('kitte',),
'kittet': ('kitte',),
'kitta': ('kitte',),
'kittete': ('kitte',),
'kittede': ('kitte',),
'kitta': ('kitte',),
'kittete': ('kitte',),
'kittede': ('kitte',),
'kittende': ('kitte',),
'kivaktig': ('kivaktig',),
'kivaktige': ('kivaktig',),
'kivaktig': ('kivaktig',),
'kiva': ('kive',),
'kivet': ('kive',),
'kivd': ('kive',),
'kiva': ('kive',),
'kivet': ('kive',),
'kivd': ('kive',),
'kiva': ('kive',),
'kivete': ('kive',),
'kivede': ('kive',),
'kivde': ('kive',),
'kiva': ('kive',),
'kivete': ('kive',),
'kivede': ('kive',),
'kivde': ('kive',),
'kivende': ('kive',),
'kjaksa': ('kjakse',),
'kjakset': ('kjakse',),
'kjaksa': ('kjakse',),
'kjakset': ('kjakse',),
'kjaksa': ('kjakse',),
'kjaksete': ('kjakse',),
'kjaksede': ('kjakse',),
'kjaksa': ('kjakse',),
'kjaksete': ('kjakse',),
'kjaksede': ('kjakse',),
'kjaksende': ('kjakse',),
'kjangsa': ('kjangse',),
'kjangset': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangset': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangsete': ('kjangse',),
'kjangsede': ('kjangse',),
'kjangsa': ('kjangse',),
'kjangsete': ('kjangse',),
'kjangsede': ('kjangse',),
'kjangsende': ('kjangse',),
'kjapp': ('kjapp',),
'kjappe': ('kjapp',),
'kjapt': ('kjapp',),
'kjappere': ('kjapp',),
'kjappest': ('kjapp',),
'kjappeste': ('kjapp',),
'kjappa': ('kjappe',),
'kjappet': ('kjappe',),
'kjappa': ('kjappe',),
'kjappet': ('kjappe',),
'kjappa': ('kjappe',),
'kjappete': ('kjappe',),
'kjappede': ('kjappe',),
'kjappa': ('kjappe',),
'kjappete': ('kjappe',),
'kjappede': ('kjappe',),
'kjappende': ('kjappe',),
'kjast': ('kjase',),
'kjaste': ('kjase',),
'kjasende': ('kjase',),
'kjava': ('kjave',),
'kjavet': ('kjave',),
'kjavd': ('kjave',),
'kjava': ('kjave',),
'kjavet': ('kjave',),
'kjavd': ('kjave',),
'kjava': ('kjave',),
'kjavete': ('kjave',),
'kjavede': ('kjave',),
'kjavde': ('kjave',),
'kjava': ('kjave',),
'kjavete': ('kjave',),
'kjavede': ('kjave',),
'kjavde': ('kjave',),
'kjavende': ('kjave',),
'kjed': ('kjed',),
'kjede': ('kjed',),
'kjedt': ('kjed',),
'kjeda': ('kjede',),
'kjedet': ('kjede',),
'kjeda': ('kjede',),
'kjedet': ('kjede',),
'kjeda': ('kjede',),
'kjedete': ('kjede',),
'kjedede': ('kjede',),
'kjeda': ('kjede',),
'kjedete': ('kjede',),
'kjedede': ('kjede',),
'kjedende': ('kjede',),
'kjedelig': ('kjedelig',),
'kjedelige': ('kjedelig',),
'kjedelig': ('kjedelig',),
'kjedeligere': ('kjedelig',),
'kjedeligst': ('kjedelig',),
'kjedeligste': ('kjedelig',),
'kjederøyka': ('kjederøyke',),
'kjederøykt': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøykt': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøykte': ('kjederøyke',),
'kjederøyka': ('kjederøyke',),
'kjederøykte': ('kjederøyke',),
'kjederøykende': ('kjederøyke',),
'kjedsom': ('kjedsom',),
'kjedsomme': ('kjedsom',),
'kjedsomt': ('kjedsom',),
'kjedsommere': ('kjedsom',),
'kjedsomst': ('kjedsom',),
'kjedsomste': ('kjedsom',),
'kjedsommelig': ('kjedsommelig',),
'kjedsommelige': ('kjedsommelig',),
'kjedsommelig': ('kjedsommelig',),
'kjea': ('kjee',),
'kjeet': ('kjee',),
'kjea': ('kjee',),
'kjeet': ('kjee',),
'kjea': ('kjee',),
'kjeete': ('kjee',),
'kjeede': ('kjee',),
'kjea': ('kjee',),
'kjeete': ('kjee',),
'kjeede': ('kjee',),
'kjeende': ('kjee',),
'kjefta': ('kjefte',),
'kjeftet': ('kjefte',),
'kjefta': ('kjefte',),
'kjeftet': ('kjefte',),
'kjefta': ('kjefte',),
'kjeftete': ('kjefte',),
'kjeftede': ('kjefte',),
'kjefta': ('kjefte',),
'kjeftete': ('kjefte',),
'kjeftede': ('kjefte',),
'kjeftende': ('kjefte',),
'kjekk': ('kjekk',),
'kjekke': ('kjekk',),
'kjekt': ('kjekk',),
'kjekkere': ('kjekk',),
'kjekkest': ('kjekk',),
'kjekkeste': ('kjekk',),
'kjekka': ('kjekke',),
'kjekket': ('kjekke',),
'kjekka': ('kjekke',),
'kjekket': ('kjekke',),
'kjekka': ('kjekke',),
'kjekkete': ('kjekke',),
'kjekkede': ('kjekke',),
'kjekka': ('kjekke',),
'kjekkete': ('kjekke',),
'kjekkede': ('kjekke',),
'kjekkende': ('kjekke',),
'kjekkesen': ('kjekkesen',),
'kjekla': ('kjekle',),
'kjeklet': ('kjekle',),
'kjekla': ('kjekle',),
'kjeklet': ('kjekle',),
'kjekla': ('kjekle',),
'kjeklete': ('kjekle',),
'kjeklede': ('kjekle',),
'kjeklete': ('kjekle',),
'kjeklede': ('kjekle',),
'kjekla': ('kjekle',),
'kjeklete': ('kjekle',),
'kjeklede': ('kjekle',),
'kjeklete': ('kjekle',),
'kjeklede': ('kjekle',),
'kjeklende': ('kjekle',),
'kjeksa': ('kjekse',),
'kjekset': ('kjekse',),
'kjeksa': ('kjekse',),
'kjekset': ('kjekse',),
'kjeksa': ('kjekse',),
'kjeksete': ('kjekse',),
'kjeksede': ('kjekse',),
'kjeksa': ('kjekse',),
'kjeksete': ('kjekse',),
'kjeksede': ('kjekse',),
'kjeksende': ('kjekse',),
'kjelket': ('kjelket',),
'kjelkete': ('kjelket',),
'kjelket': ('kjelket',),
'kjelkete': ('kjelkete',),
'kjellerkald': ('kjellerkald',),
'kjellerkalde': ('kjellerkald',),
'kjellerkaldt': ('kjellerkald',),
'kjemigrafisk': ('kjemigrafisk',),
'kjemigrafiske': ('kjemigrafisk',),
'kjemigrafisk': ('kjemigrafisk',),
'kjemisk': ('kjemisk',),
'kjemiske': ('kjemisk',),
'kjemisk': ('kjemisk',),
'kjemma': ('kjemme',),
'kjemmet': ('kjemme',),
'kjemt': ('kjemme',),
'kjemma': ('kjemme',),
'kjemmet': ('kjemme',),
'kjemt': ('kjemme',),
'kjemma': ('kjemme',),
'kjemmete': ('kjemme',),
'kjemmede': ('kjemme',),
'kjemte': ('kjemme',),
'kjemma': ('kjemme',),
'kjemmete': ('kjemme',),
'kjemmede': ('kjemme',),
'kjemte': ('kjemme',),
'kjemmende': ('kjemme',),
'kjempa': ('kjempe',),
'kjempet': ('kjempe',),
'kjempa': ('kjempe',),
'kjempet': ('kjempe',),
'kjempa': ('kjempe',),
'kjempete': ('kjempe',),
'kjempede': ('kjempe',),
'kjempa': ('kjempe',),
'kjempete': ('kjempe',),
'kjempede': ('kjempe',),
'kjempende': ('kjempe',),
'kjempemessig': ('kjempemessig',),
'kjempemessige': ('kjempemessig',),
'kjempemessig': ('kjempemessig',),
'kjent': ('kjenne',),
'kjente': ('kjenne',),
'kjennende': ('kjenne',),
'kjennelig': ('kjennelig',),
'kjennelige': ('kjennelig',),
'kjennelig': ('kjennelig',),
'kjennetegna': ('kjennetegne',),
'kjennetegnet': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegnet': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegnete': ('kjennetegne',),
'kjennetegnede': ('kjennetegne',),
'kjennetegna': ('kjennetegne',),
'kjennetegnete': ('kjennetegne',),
'kjennetegnede': ('kjennetegne',),
'kjennetegnende': ('kjennetegne',),
'kjenslelaus': ('kjenslelaus',),
'kjenslelause': ('kjenslelaus',),
'kjenslelaust': ('kjenslelaus',),
'kjensleløs': ('kjensleløs',),
'kjensleløse': ('kjensleløs',),
'kjensleløst': ('kjensleløs',),
'kjenslevar': ('kjenslevar',),
'kjenslevare': ('kjenslevar',),
'kjenslevart': ('kjenslevar',),
'kjent': ('kjent',),
'kjente': ('kjent',),
'kjent': ('kjent',),
'kjepphøg': ('kjepphøg',),
'kjepphøge': ('kjepphøg',),
'kjepphøgt': ('kjepphøg',),
'kjepphøy': ('kjepphøy',),
'kjepphøye': ('kjepphøy',),
'kjepphøyt': ('kjepphøy',),
'kjeppjaga': ('kjeppjage',),
'kjeppjaget': ('kjeppjage',),
'kjeppjagd': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjaget': ('kjeppjage',),
'kjeppjagd': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjagete': ('kjeppjage',),
'kjeppjagede': ('kjeppjage',),
'kjeppjagde': ('kjeppjage',),
'kjeppjaga': ('kjeppjage',),
'kjeppjagete': ('kjeppjage',),
'kjeppjagede': ('kjeppjage',),
'kjeppjagde': ('kjeppjage',),
'kjeppjagende': ('kjeppjage',),
'kjerna': ('kjerne',),
'kjernet': ('kjerne',),
'kjerna': ('kjerne',),
'kjernet': ('kjerne',),
'kjerna': ('kjerne',),
'kjernete': ('kjerne',),
'kjernede': ('kjerne',),
'kjerna': ('kjerne',),
'kjernete': ('kjerne',),
'kjernede': ('kjerne',),
'kjernende': ('kjerne',),
'kjernefysisk': ('kjernefysisk',),
'kjernefysiske': ('kjernefysisk',),
'kjernefysisk': ('kjernefysisk',),
'kjernesunn': ('kjernesunn',),
'kjernesunne': ('kjernesunn',),
'kjernesunt': ('kjernesunn',),
'kjerva': ('kjerve',),
'kjervet': ('kjerve',),
'kjerva': ('kjerve',),
'kjervet': ('kjerve',),
'kjerva': ('kjerve',),
'kjervete': ('kjerve',),
'kjervede': ('kjerve',),
'kjerva': ('kjerve',),
'kjervete': ('kjerve',),
'kjervede': ('kjerve',),
'kjervende': ('kjerve',),
'kjest': ('kjese',),
'kjeste': ('kjese',),
'kjesende': ('kjese',),
'kjeska': ('kjeske',),
'kjesket': ('kjeske',),
'kjeska': ('kjeske',),
'kjesket': ('kjeske',),
'kjeska': ('kjeske',),
'kjeskete': ('kjeske',),
'kjeskede': ('kjeske',),
'kjeska': ('kjeske',),
'kjeskete': ('kjeske',),
'kjeskede': ('kjeske',),
'kjeskende': ('kjeske',),
'kjesken': ('kjesken',),
'kjeskne': ('kjesken',),
'kjeskent': ('kjesken',),
'kjettersk': ('kjettersk',),
'kjetterske': ('kjettersk',),
'kjettersk': ('kjettersk',),
'kjevla': ('kjevle',),
'kjevlet': ('kjevle',),
'kjevla': ('kjevle',),
'kjevlet': ('kjevle',),
'kjevla': ('kjevle',),
'kjevlete': ('kjevle',),
'kjevlede': ('kjevle',),
'kjevlete': ('kjevle',),
'kjevlede': ('kjevle',),
'kjevla': ('kjevle',),
'kjevlete': ('kjevle',),
'kjevlede': ('kjevle',),
'kjevlete': ('kjevle',),
'kjevlede': ('kjevle',),
'kjevlende': ('kjevle',),
'kjælt': ('kjæle',),
'kjælte': ('kjæle',),
'kjælende': ('kjæle',),
'kjælen': ('kjælen',),
'kjælne': ('kjælen',),
'kjælent': ('kjælen',),
'kjær': ('kjær',),
'kjære': ('kjær',),
'kjært': ('kjær',),
'kjærere': ('kjær',),
'kjærest': ('kjær',),
'kjæreste': ('kjær',),
'kjært': ('kjære',),
'kjærte': ('kjære',),
'kjærende': ('kjære',),
'kjærkommen': ('kjærkommen',),
'kjærkomne': ('kjærkommen',),
'kjærkomment': ('kjærkommen',),
'kjærlig': ('kjærlig',),
'kjærlige': ('kjærlig',),
'kjærlig': ('kjærlig',),
'kjærligere': ('kjærlig',),
'kjærligst': ('kjærlig',),
'kjærligste': ('kjærlig',),
'kjærtegna': ('kjærtegne',),
'kjærtegnet': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegnet': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegnete': ('kjærtegne',),
'kjærtegnede': ('kjærtegne',),
'kjærtegna': ('kjærtegne',),
'kjærtegnete': ('kjærtegne',),
'kjærtegnede': ('kjærtegne',),
'kjærtegnende': ('kjærtegne',),
'kjætt': ('kjæte',),
'kjætte': ('kjæte',),
'kjætende': ('kjæte',),
'kjødelig': ('kjødelig',),
'kjødelige': ('kjødelig',),
'kjødelig': ('kjødelig',),
'kjølt': ('kjøle',),
'kjølte': ('kjøle',),
'kjølende': ('kjøle',),
'kjølhala': ('kjølhale',),
'kjølhalet': ('kjølhale',),
'kjølhalt': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhalet': ('kjølhale',),
'kjølhalt': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhalete': ('kjølhale',),
'kjølhalede': ('kjølhale',),
'kjølhalte': ('kjølhale',),
'kjølhala': ('kjølhale',),
'kjølhalete': ('kjølhale',),
'kjølhalede': ('kjølhale',),
'kjølhalte': ('kjølhale',),
'kjølhalende': ('kjølhale',),
'kjølig': ('kjølig',),
'kjølige': ('kjølig',),
'kjølig': ('kjølig',),
'kjøligere': ('kjølig',),
'kjøligst': ('kjølig',),
'kjøligste': ('kjølig',),
'kjølna': ('kjølne',),
'kjølnet': ('kjølne',),
'kjølna': ('kjølne',),
'kjølnet': ('kjølne',),
'kjølna': ('kjølne',),
'kjølnete': ('kjølne',),
'kjølnede': ('kjølne',),
'kjølnete': ('kjølne',),
'kjølnede': ('kjølne',),
'kjølna': ('kjølne',),
'kjølnete': ('kjølne',),
'kjølnede': ('kjølne',),
'kjølnete': ('kjølne',),
'kjølnede': ('kjølne',),
'kjølnende': ('kjølne',),
'kjøn': ('kjøn',),
'kjøne': ('kjøn',),
'kjønt': ('kjøn',),
'kjønna': ('kjønna',),
'kjønnet': ('kjønnet',),
'kjønnete': ('kjønnet',),
'kjønnede': ('kjønnet',),
'kjønnete': ('kjønnet',),
'kjønnede': ('kjønnet',),
'kjønnet': ('kjønnet',),
'kjønnsbestemt': ('kjønnsbestemt',),
'kjønnsbestemte': ('kjønnsbestemt',),
'kjønnsbestemt': ('kjønnsbestemt',),
'kjønnsbundet': ('kjønnsbundet',),
'kjønnsbundne': ('kjønnsbundet',),
'kjønnsbundet': ('kjønnsbundet',),
'kjønnslaus': ('kjønnslaus',),
'kjønnslause': ('kjønnslaus',),
'kjønnslaust': ('kjønnslaus',),
'kjønnslig': ('kjønnslig',),
'kjønnslige': ('kjønnslig',),
'kjønnslig': ('kjønnslig',),
'kjønnsløs': ('kjønnsløs',),
'kjønnsløse': ('kjønnsløs',),
'kjønnsløst': ('kjønnsløs',),
'kjønnsmoden': ('kjønnsmoden',),
'kjønnsmodne': ('kjønnsmoden',),
'kjønnsmodent': ('kjønnsmoden',),
'kjønnsnøytral': ('kjønnsnøytral',),
'kjønnsnøytrale': ('kjønnsnøytral',),
'kjønnsnøytralt': ('kjønnsnøytral',),
'kjøpt': ('kjøpe',),
'kjøpte': ('kjøpe',),
'kjøpende': ('kjøpe',),
'kjøpekraftig': ('kjøpekraftig',),
'kjøpekraftige': ('kjøpekraftig',),
'kjøpekraftig': ('kjøpekraftig',),
'kjørbar': ('kjørbar',),
'kjørbare': ('kjørbar',),
'kjørbart': ('kjørbar',),
'kjørt': ('kjøre',),
'kjørte': ('kjøre',),
'kjørende': ('kjøre',),
'kjørna': ('kjørne',),
'kjørnet': ('kjørne',),
'kjørna': ('kjørne',),
'kjørnet': ('kjørne',),
'kjørna': ('kjørne',),
'kjørnete': ('kjørne',),
'kjørnede': ('kjørne',),
'kjørna': ('kjørne',),
'kjørnete': ('kjørne',),
'kjørnede': ('kjørne',),
'kjørnende': ('kjørne',),
'kjørt': ('kjørt',),
'kjørte': ('kjørt',),
'kjørt': ('kjørt',),
'kjøttetende': ('kjøttetende',),
'kjøttfull': ('kjøttfull',),
'kjøttfulle': ('kjøttfull',),
'kjøttfullt': ('kjøttfull',),
'kjøvd': ('kjøve',),
'kjøvde': ('kjøve',),
'kjøvende': ('kjøve',),
'klabba': ('klabbe',),
'klabbet': ('klabbe',),
'klabba': ('klabbe',),
'klabbet': ('klabbe',),
'klabba': ('klabbe',),
'klabbete': ('klabbe',),
'klabbede': ('klabbe',),
'klabba': ('klabbe',),
'klabbete': ('klabbe',),
'klabbede': ('klabbe',),
'klabbende': ('klabbe',),
'klabbet': ('klabbet',),
'klabbete': ('klabbet',),
'klabbet': ('klabbet',),
'klabbete': ('klabbete',),
'kladda': ('kladde',),
'kladdet': ('kladde',),
'kladda': ('kladde',),
'kladdet': ('kladde',),
'kladda': ('kladde',),
'kladdete': ('kladde',),
'kladdede': ('kladde',),
'kladda': ('kladde',),
'kladdete': ('kladde',),
'kladdede': ('kladde',),
'kladdende': ('kladde',),
'klaffa': ('klaffe',),
'klaffet': ('klaffe',),
'klaffa': ('klaffe',),
'klaffet': ('klaffe',),
'klaffa': ('klaffe',),
'klaffete': ('klaffe',),
'klaffede': ('klaffe',),
'klaffa': ('klaffe',),
'klaffete': ('klaffe',),
'klaffede': ('klaffe',),
'klaffende': ('klaffe',),
'klaga': ('klage',),
'klaget': ('klage',),
'klagd': ('klage',),
'klaga': ('klage',),
'klaget': ('klage',),
'klagd': ('klage',),
'klaga': ('klage',),
'klagete': ('klage',),
'klagede': ('klage',),
'klagde': ('klage',),
'klaga': ('klage',),
'klagete': ('klage',),
'klagede': ('klage',),
'klagde': ('klage',),
'klagende': ('klage',),
'klaka': ('klake',),
'klaket': ('klake',),
'klaka': ('klake',),
'klaket': ('klake',),
'klaka': ('klake',),
'klakete': ('klake',),
'klakede': ('klake',),
'klaka': ('klake',),
'klakete': ('klake',),
'klakede': ('klake',),
'klakende': ('klake',),
'klaket': ('klaket',),
'klakete': ('klaket',),
'klaket': ('klaket',),
'klakete': ('klakete',),
'klakka': ('klakke',),
'klakket': ('klakke',),
'klakka': ('klakke',),
'klakket': ('klakke',),
'klakka': ('klakke',),
'klakkete': ('klakke',),
'klakkede': ('klakke',),
'klakka': ('klakke',),
'klakkete': ('klakke',),
'klakkede': ('klakke',),
'klakkende': ('klakke',),
'klam': ('klam',),
'klamme': ('klam',),
'klamt': ('klam',),
'klammere': ('klam',),
'klammest': ('klam',),
'klammeste': ('klam',),
'klampa': ('klampe',),
'klampet': ('klampe',),
'klampa': ('klampe',),
'klampet': ('klampe',),
'klampa': ('klampe',),
'klampete': ('klampe',),
'klampede': ('klampe',),
'klampa': ('klampe',),
'klampete': ('klampe',),
'klampede': ('klampe',),
'klampende': ('klampe',),
'klamra': ('klamre',),
'klamret': ('klamre',),
'klamra': ('klamre',),
'klamret': ('klamre',),
'klamra': ('klamre',),
'klamrete': ('klamre',),
'klamrede': ('klamre',),
'klamrete': ('klamre',),
'klamrede': ('klamre',),
'klamra': ('klamre',),
'klamrete': ('klamre',),
'klamrede': ('klamre',),
'klamrete': ('klamre',),
'klamrede': ('klamre',),
'klamrende': ('klamre',),
'klanderverdig': ('klanderverdig',),
'klanderverdige': ('klanderverdig',),
'klanderverdig': ('klanderverdig',),
'klandra': ('klandre',),
'klandret': ('klandre',),
'klandra': ('klandre',),
'klandret': ('klandre',),
'klandra': ('klandre',),
'klandrete': ('klandre',),
'klandrede': ('klandre',),
'klandrete': ('klandre',),
'klandrede': ('klandre',),
'klandra': ('klandre',),
'klandrete': ('klandre',),
'klandrede': ('klandre',),
'klandrete': ('klandre',),
'klandrede': ('klandre',),
'klandrende': ('klandre',),
'klangfull': ('klangfull',),
'klangfulle': ('klangfull',),
'klangfullt': ('klangfull',),
'klanglig': ('klanglig',),
'klanglige': ('klanglig',),
'klanglig': ('klanglig',),
'klappa': ('klappe',),
'klappet': ('klappe',),
'klappa': ('klappe',),
'klappet': ('klappe',),
'klappa': ('klappe',),
'klappete': ('klappe',),
'klappede': ('klappe',),
'klappa': ('klappe',),
'klappete': ('klappe',),
'klappede': ('klappe',),
'klappende': ('klappe',),
'klapra': ('klapre',),
'klapret': ('klapre',),
'klapra': ('klapre',),
'klapret': ('klapre',),
'klapra': ('klapre',),
'klaprete': ('klapre',),
'klaprede': ('klapre',),
'klaprete': ('klapre',),
'klaprede': ('klapre',),
'klapra': ('klapre',),
'klaprete': ('klapre',),
'klaprede': ('klapre',),
'klaprete': ('klapre',),
'klaprede': ('klapre',),
'klaprende': ('klapre',),
'klapsa': ('klapse',),
'klapset': ('klapse',),
'klapsa': ('klapse',),
'klapset': ('klapse',),
'klapsa': ('klapse',),
'klapsete': ('klapse',),
'klapsede': ('klapse',),
'klapsa': ('klapse',),
'klapsete': ('klapse',),
'klapsede': ('klapse',),
'klapsende': ('klapse',),
'klar': ('klar',),
'klare': ('klar',),
'klart': ('klar',),
'klarere': ('klar',),
'klarest': ('klar',),
'klareste': ('klar',),
'klara': ('klare',),
'klaret': ('klare',),
'klart': ('klare',),
'klara': ('klare',),
'klaret': ('klare',),
'klart': ('klare',),
'klara': ('klare',),
'klarete': ('klare',),
'klarede': ('klare',),
'klarte': ('klare',),
'klara': ('klare',),
'klarete': ('klare',),
'klarede': ('klare',),
'klarte': ('klare',),
'klarende': ('klare',),
'klart': ('klare',),
'klarte': ('klare',),
'klarende': ('klare',),
'klarert': ('klarere',),
'klarerte': ('klarere',),
'klarerende': ('klarere',),
'klargjort': ('klargjøre',),
'klargjorte': ('klargjøre',),
'klargjørende': ('klargjøre',),
'klarlagt': ('klarlegge',),
'klarlagte': ('klarlegge',),
'klarleggende': ('klarlegge',),
'klarna': ('klarne',),
'klarnet': ('klarne',),
'klarna': ('klarne',),
'klarnet': ('klarne',),
'klarna': ('klarne',),
'klarnete': ('klarne',),
'klarnede': ('klarne',),
'klarnete': ('klarne',),
'klarnede': ('klarne',),
'klarna': ('klarne',),
'klarnete': ('klarne',),
'klarnede': ('klarne',),
'klarnete': ('klarne',),
'klarnede': ('klarne',),
'klarnende': ('klarne',),
'klarsynt': ('klarsynt',),
'klarsynte': ('klarsynt',),
'klarsynt': ('klarsynt',),
'klartseende': ('klartseende',),
'klarøyd': ('klarøyd',),
'klarøyde': ('klarøyd',),
'klarøyd': ('klarøyd',),
'klasa': ('klase',),
'klaset': ('klase',),
'klast': ('klase',),
'klasa': ('klase',),
'klaset': ('klase',),
'klast': ('klase',),
'klasa': ('klase',),
'klasete': ('klase',),
'klasede': ('klase',),
'klaste': ('klase',),
'klasa': ('klase',),
'klasete': ('klase',),
'klasede': ('klase',),
'klaste': ('klase',),
'klasende': ('klase',),
'klaska': ('klaske',),
'klasket': ('klaske',),
'klaska': ('klaske',),
'klasket': ('klaske',),
'klaska': ('klaske',),
'klaskete': ('klaske',),
'klaskede': ('klaske',),
'klaska': ('klaske',),
'klaskete': ('klaske',),
'klaskede': ('klaske',),
'klaskende': ('klaske',),
'klassa': ('klasse',),
'klasset': ('klasse',),
'klassa': ('klasse',),
'klasset': ('klasse',),
'klassa': ('klasse',),
'klassete': ('klasse',),
'klassede': ('klasse',),
'klassa': ('klasse',),
'klassete': ('klasse',),
'klassede': ('klasse',),
'klassende': ('klasse',),
'klassebevisst': ('klassebevisst',),
'klassebevisste': ('klassebevisst',),
'klassebevisst': ('klassebevisst',),
'klasselaus': ('klasselaus',),
'klasselause': ('klasselaus',),
'klasselaust': ('klasselaus',),
'klasseløs': ('klasseløs',),
'klasseløse': ('klasseløs',),
'klasseløst': ('klasseløs',),
'klassifisert': ('klassifisere',),
'klassifiserte': ('klassifisere',),
'klassifiserende': ('klassifisere',),
'klassisistisk': ('klassisistisk',),
'klassisistiske': ('klassisistisk',),
'klassisistisk': ('klassisistisk',),
'klassisk': ('klassisk',),
'klassiske': ('klassisk',),
'klassisk': ('klassisk',),
'klatra': ('klatre',),
'klatret': ('klatre',),
'klatra': ('klatre',),
'klatret': ('klatre',),
'klatra': ('klatre',),
'klatrete': ('klatre',),
'klatrede': ('klatre',),
'klatrete': ('klatre',),
'klatrede': ('klatre',),
'klatra': ('klatre',),
'klatrete': ('klatre',),
'klatrede': ('klatre',),
'klatrete': ('klatre',),
'klatrede': ('klatre',),
'klatrende': ('klatre',),
'klatta': ('klatte',),
'klattet': ('klatte',),
'klatta': ('klatte',),
'klattet': ('klatte',),
'klatta': ('klatte',),
'klattete': ('klatte',),
'klattede': ('klatte',),
'klatta': ('klatte',),
'klattete': ('klatte',),
'klattede': ('klatte',),
'klattende': ('klatte',),
'klattemalt': ('klattemale',),
'klattemalte': ('klattemale',),
'klattemalende': ('klattemale',),
'klattmalt': ('klattmale',),
'klattmalte': ('klattmale',),
'klattmalende': ('klattmale',),
'klaustrofobisk': ('klaustrofobisk',),
'klaustrofobiske': ('klaustrofobisk',),
'klaustrofobisk': ('klaustrofobisk',),
'klausulert': ('klausulere',),
'klausulerte': ('klausulere',),
'klausulerende': ('klausulere',),
'klava': ('klave',),
'klavet': ('klave',),
'klavd': ('klave',),
'klava': ('klave',),
'klavet': ('klave',),
'klavd': ('klave',),
'klava': ('klave',),
'klavete': ('klave',),
'klavede': ('klave',),
'klavde': ('klave',),
'klava': ('klave',),
'klavete': ('klave',),
'klavede': ('klave',),
'klavde': ('klave',),
'klavende': ('klave',),
'klavebundet': ('klavebinde',),
'klavebunden': ('klavebinde',),
'klavebundne': ('klavebinde',),
'klavebindende': ('klavebinde',),
'kledd': ('kle',),
'kledde': ('kle',),
'kleende': ('kle',),
'kleba': ('klebe',),
'klebet': ('klebe',),
'klebt': ('klebe',),
'kleba': ('klebe',),
'klebet': ('klebe',),
'klebt': ('klebe',),
'kleba': ('klebe',),
'klebete': ('klebe',),
'klebede': ('klebe',),
'klebte': ('klebe',),
'kleba': ('klebe',),
'klebete': ('klebe',),
'klebede': ('klebe',),
'klebte': ('klebe',),
'klebende': ('klebe',),
'klebrig': ('klebrig',),
'klebrige': ('klebrig',),
'klebrig': ('klebrig',),
'kledd': ('klede',),
'kledde': ('klede',),
'kledende': ('klede',),
'kledelig': ('kledelig',),
'kledelige': ('kledelig',),
'kledelig': ('kledelig',),
'kleia': ('kleie',),
'kleiet': ('kleie',),
'kleid': ('kleie',),
'kleia': ('kleie',),
'kleiet': ('kleie',),
'kleid': ('kleie',),
'kleia': ('kleie',),
'kleiete': ('kleie',),
'kleiede': ('kleie',),
'kleide': ('kleie',),
'kleia': ('kleie',),
'kleiete': ('kleie',),
'kleiede': ('kleie',),
'kleide': ('kleie',),
'kleiende': ('kleie',),
'kleimt': ('kleime',),
'kleimte': ('kleime',),
'kleimende': ('kleime',),
'kleimen': ('kleimen',),
'kleimne': ('kleimen',),
'kleiment': ('kleimen',),
'klein': ('klein',),
'kleine': ('klein',),
'kleint': ('klein',),
'kleinere': ('klein',),
'kleinest': ('klein',),
'kleineste': ('klein',),
'kleis': ('kleis',),
'kleise': ('kleis',),
'kleist': ('kleis',),
'kleisa': ('kleise',),
'kleiset': ('kleise',),
'kleist': ('kleise',),
'kleisa': ('kleise',),
'kleiset': ('kleise',),
'kleist': ('kleise',),
'kleisa': ('kleise',),
'kleisete': ('kleise',),
'kleisede': ('kleise',),
'kleiste': ('kleise',),
'kleisa': ('kleise',),
'kleisete': ('kleise',),
'kleisede': ('kleise',),
'kleiste': ('kleise',),
'kleisende': ('kleise',),
'klekka': ('klekke',),
'klekket': ('klekke',),
'klekt': ('klekke',),
'klekka': ('klekke',),
'klekket': ('klekke',),
'klekt': ('klekke',),
'klekka': ('klekke',),
'klekkete': ('klekke',),
'klekkede': ('klekke',),
'klekte': ('klekke',),
'klekka': ('klekke',),
'klekkete': ('klekke',),
'klekkede': ('klekke',),
'klekte': ('klekke',),
'klekkende': ('klekke',),
'klekkelig': ('klekkelig',),
'klekkelige': ('klekkelig',),
'klekkelig': ('klekkelig',),
'klemt': ('klemme',),
'klemte': ('klemme',),
'klemmende': ('klemme',),
'klemta': ('klemte',),
'klemtet': ('klemte',),
'klemta': ('klemte',),
'klemtet': ('klemte',),
'klemta': ('klemte',),
'klemtete': ('klemte',),
'klemtede': ('klemte',),
'klemta': ('klemte',),
'klemtete': ('klemte',),
'klemtede': ('klemte',),
'klemtende': ('klemte',),
'klen': ('klen',),
'klene': ('klen',),
'klent': ('klen',),
'klenere': ('klen',),
'klenest': ('klen',),
'kleneste': ('klen',),
'klengt': ('klenge',),
'klengte': ('klenge',),
'klengende': ('klenge',),
'klenget': ('klenge',),
'klengt': ('klenge',),
'klenget': ('klenge',),
'klengt': ('klenge',),
'klengete': ('klenge',),
'klengede': ('klenge',),
'klengte': ('klenge',),
'klengete': ('klenge',),
'klengede': ('klenge',),
'klengte': ('klenge',),
'klengende': ('klenge',),
'klengen': ('klengen',),
'klengne': ('klengen',),
'klengent': ('klengen',),
'klenget': ('klenget',),
'klengete': ('klenget',),
'klenget': ('klenget',),
'klengete': ('klengete',),
'kleppa': ('kleppe',),
'kleppet': ('kleppe',),
'kleppa': ('kleppe',),
'kleppet': ('kleppe',),
'kleppa': ('kleppe',),
'kleppete': ('kleppe',),
'kleppede': ('kleppe',),
'kleppa': ('kleppe',),
'kleppete': ('kleppe',),
'kleppede': ('kleppe',),
'kleppende': ('kleppe',),
'kleptoman': ('kleptoman',),
'kleptomane': ('kleptoman',),
'kleptomant': ('kleptoman',),
'klerikal': ('klerikal',),
'klerikale': ('klerikal',),
'klerikalt': ('klerikal',),
'klesset': ('klesset',),
'klessete': ('klesset',),
'klesset': ('klesset',),
'klessete': ('klessete',),
'klikka': ('klikke',),
'klikket': ('klikke',),
'klikka': ('klikke',),
'klikket': ('klikke',),
'klikka': ('klikke',),
'klikkete': ('klikke',),
'klikkede': ('klikke',),
'klikka': (