# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005, updated 20180627
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en  
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

LOOKUP = {
'à': 'à',
'à la': 'à la',
'A-': 'A-',
'A/L': 'A/L',
'AD': 'AD',
'a.D.': 'AD',
'AD': 'AD',
'ADB': 'ADB',
'adb': 'ADB',
'ADB': 'ADB',
'AL': 'AL',
'AM': 'AM',
'AS': 'AS',
'AV': 'AV',
'av': 'AV',
'AV': 'AV',
'Ac': 'Ac',
'Ag': 'Ag',
'Al': 'Al',
'Am': 'Am',
'Ar': 'Ar',
'As': 'As',
'At': 'At',
'Au': 'Au',
'Ba': 'Ba',
'Be': 'Be',
'Bi': 'Bi',
'Bk': 'Bk',
'Bq': 'Bq',
'Br': 'Br',
'C.': 'C.',
'CP': 'CP',
'cp': 'CP',
'CP': 'CP',
'Ca': 'Ca',
'Cd': 'Cd',
'Ce': 'Ce',
'Cf': 'Cf',
'Ci': 'Ci',
'Cl': 'Cl',
'Cm': 'Cm',
'Co': 'Co',
'Co.': 'Co.',
'co.': 'Co.',
'Co.': 'Co.',
'Cr': 'Cr',
'Cs': 'Cs',
'Cu': 'Cu',
'D/S': 'D/S',
'DK': 'DK',
'DS': 'DS',
'Dy': 'Dy',
'EDB': 'EDB',
'edb': 'EDB',
'EDB': 'EDB',
'EF': 'EF',
'EKG': 'EKG',
'ekg': 'EKG',
'EKG': 'EKG',
'ES': 'ES',
'Es': 'Es',
'Eu': 'Eu',
'EØS': 'EØS',
'FM': 'FM',
'FN': 'FN',
'Fe': 'Fe',
'Fm': 'Fm',
'Fr': 'Fr',
'GB': 'GB',
'GHz': 'GHz',
'GMT': 'GMT',
'GT': 'GT',
'GW': 'GW',
'Ga': 'Ga',
'Gb': 'Gd',
'Gd': 'Gd',
'Gy': 'Gy',
'H.K.H.': 'H.K.H.',
'H.M.': 'H.M.',
'HB': 'HB',
'HF': 'HF',
'HV': 'HV',
'He': 'He',
'Hf': 'Hf',
'Hg': 'Hg',
'Ho': 'Ho',
'Hz': 'Hz',
'I': 'I',
'eder': 'I',
'Eder': 'I',
'I': 'I',
'I.N.D.': 'I.N.D.',
'IQ': 'IQ',
'In': 'In',
'Ir': 'Ir',
'K/S': 'K/S',
'KS': 'KS',
'Kr': 'Kr',
'L': 'L',
'L': 'L',
'LK': 'LK',
'La': 'La',
'Lg': 'Lg',
'Li': 'Li',
'Lr': 'Lr',
'Lt.': 'Lt.',
'Lu': 'Lu',
'M': 'M',
'M/S': 'M/S',
'M/T': 'M/T',
'MB': 'MB',
'MHz': 'MHz',
'MP': 'MP',
'MS': 'MS',
'MS': 'MS',
'ms': 'MS',
'MS': 'MS',
'MT': 'MT',
'MV': 'MV',
'MW': 'MW',
'Mg': 'Mg',
'Mlle': 'Mlle',
'Mme': 'Mme',
'Mn': 'Mn',
'Mo': 'Mo',
'Mr.': 'Mr.',
'Mt': 'Mt',
'NATO': 'NATO',
'Nato': 'NATO',
'NATO': 'NATO',
'NB': 'NB',
'NN': 'NN',
'NRF': 'NRF',
'NS': 'NS',
'Na': 'Na',
'Nato': 'Nato',
'Nb': 'Nb',
'Ne': 'Ne',
'Ng': 'Ng',
'ng': 'Ng',
'Ng': 'Ng',
'Ni': 'Ni',
'No': 'No',
'Np': 'Np',
'Oe': 'Oe',
'Os': 'Os',
'Ot.': 'Ot.',
'PVC': 'PVC',
'PVRK': 'PVRK',
'pvrk': 'PVRK',
'PVRK': 'PVRK',
'Pa': 'Pa',
'Pb': 'Pb',
'Pd': 'Pd',
'Pf': 'Pf',
'Pf': 'Pf',
'Pfg': 'Pfg',
'Pfg': 'Pfg',
'Pm': 'Pm',
'Po': 'Po',
'Pr': 'Pr',
'Pt': 'Pt',
'Pu': 'Pu',
'Ra': 'Ra',
'Rb': 'Rb',
'Re': 'Re',
'Rh': 'Rh',
'Rn': 'Rn',
'Ru': 'Ru',
'S/S': 'S/S',
'SI': 'SI',
'SS': 'SS',
'Sa': 'Sa',
'Sb': 'Sb',
'Sc': 'Sc',
'Se': 'Se',
'Sg': 'Sg',
'Si': 'Si',
'Sn': 'Sn',
'Sr': 'Sr',
'St.': 'St.',
'Sv': 'Sv',
'T/S': 'T/S',
'TCDD': 'TCDD',
'TNT': 'TNT',
'TS': 'TS',
'TW': 'TW',
'Ta': 'Ta',
'Tb': 'Tb',
'Tc': 'Tc',
'Te': 'Te',
'Th': 'Th',
'Tl': 'Tl',
'Tm': 'Tm',
'U-': 'U-',
'V5': 'V5',
'V6': 'V6',
'VA': 'VA',
'VCM': 'VCM',
'VVS': 'VVS',
'Wb': 'Wb',
'Wh': 'Wh',
'Xe': 'Xe',
'Yb': 'Yb',
'Zn': 'Zn',
'Zr': 'Zr',
'a': 'a',
'a': 'a',
'a': 'a',
'a': 'a',
'a-': 'a-',
'a-': 'a-',
'a-': 'a-',
'a.D.': 'a.D.',
'ab': 'ab',
'ad': 'ad',
'adb': 'adb',
'adjø': 'adjø',
'aero-': 'aero-',
'afro-': 'afro-',
'agri-': 'agri-',
'agric.': 'agric.',
'agro-': 'agro-',
'ah': 'ah',
'aha': 'aha',
'ai': 'ai',
'akk': 'akk',
'akro-': 'akro-',
'aktenom': 'aktenom',
'al-': 'al-',
'alko-': 'alko-',
'all': 'all',
'alt': 'all',
'alle': 'all',
'all verden': 'all verden',
'alle vegne': 'alle vegne',
'allo-': 'allo-',
'allting': 'allting',
'alm.': 'alm.',
'alpe-': 'alpe-',
'amatør-': 'amatør-',
'ambi-': 'ambi-',
'amen': 'amen',
'amerika-': 'amerika-',
'amfi-': 'amfi-',
'amfibie-': 'amfibie-',
'amino-': 'amino-',
'an-': 'an-',
'ana-': 'ana-',
'and-': 'and-',
'andels-': 'andels-',
'andro-': 'andro-',
'anemo-': 'anemo-',
'anglo-': 'anglo-',
'angående': 'angående',
'annen': 'annen',
'anna': 'annen',
'annen': 'annen',
'anna': 'annen',
'annet': 'annen',
'anna': 'annen',
'andre': 'annen',
'annenhver': 'annenhver',
'annethvert': 'annenhver',
'ant-': 'ant-',
'ante-': 'ante-',
'anti-': 'anti-',
'antropo-': 'antropo-',
'apo-': 'apo-',
'arktik-': 'arktik-',
'art.': 'art.',
'astro-': 'astro-',
'at': 'at',
'att-': 'att-',
'atten': 'atten',
'attpå': 'attpå',
'au': 'au',
'au revoir': 'au revoir',
'austafor': 'austafor',
'austafra': 'austafra',
'austetter': 'austetter',
'austfra': 'austfra',
'austover': 'austover',
'austpå': 'austpå',
'auto-': 'auto-',
'av': 'av',
'av dage': 'av dage',
'av garde': 'av garde',
'av gårde': 'av gårde',
'av lage': 'av lage',
'av sted': 'av sted',
'av syne': 'av syne',
'b-': 'b-',
'bak': 'bak',
'bakafor': 'bakafor',
'bakenfor': 'bakenfor',
'bakenifra': 'bakenifra',
'baketter': 'baketter',
'bakom': 'bakom',
'bakpå': 'bakpå',
'bang': 'bang',
'basta': 'basta',
'be-': 'be-',
'begge': 'begge',
'best som': 'best som',
'best.': 'best.',
'bevares': 'bevares',
'bi-': 'bi-',
'bio-': 'bio-',
'bl.a.': 'bl.a.',
'blant': 'blant',
'blå-': 'blå-',
'bnr.': 'bnr.',
'bom': 'bom',
'bort imot': 'bort imot',
'bort mot': 'bort mot',
'bortafor': 'bortafor',
'bortefra': 'bortefra',
'bortenfor': 'bortenfor',
'borti': 'borti',
'bortigjennom': 'bortigjennom',
'bortom': 'bortom',
'bortover': 'bortover',
'bortpå': 'bortpå',
'borttil': 'borttil',
'bortunder': 'bortunder',
'bortved': 'bortved',
'boven-': 'boven-',
'brakar': 'brakar',
'bram-': 'bram-',
'bravissimo': 'bravissimo',
'bravo': 'bravo',
'brenn-': 'brenn-',
'brå-': 'brå-',
'bums': 'bums',
'bunn-': 'bunn-',
'byss': 'byss',
'både': 'både',
'bæ': 'bæ',
'bø': 'bø',
'ca.': 'ca.',
'cal': 'cal',
'cand.': 'cand.',
'cand.act.': 'cand.act.',
'cand.agric.': 'cand.agric.',
'cand.jur.': 'cand.jur.',
'cand.mag.': 'cand.mag.',
'cand.med.': 'cand.med.',
'cand.med.vet.': 'cand.med.vet.',
'cand.min.': 'cand.min.',
'cand.odont.': 'cand.odont.',
'cand.oecon.': 'cand.oecon.',
'cand.paed.': 'cand.paed.',
'cand.pharm.': 'cand.pharm.',
'cand.philol.': 'cand.philol.',
'cand.polit.': 'cand.polit.',
'cand.psychol.': 'cand.psychol.',
'cand.real.': 'cand.real.',
'cand.scient.': 'cand.scient.',
'cand.sociol.': 'cand.sociol.',
'cand.theol.': 'cand.theol.',
'cd': 'cd',
'centi-': 'centi-',
'cg': 'cg',
'cis-': 'cis-',
'cl': 'cl',
'cm': 'cm',
'co.': 'co.',
'contra': 'contra',
'cos': 'cos',
'cot': 'cot',
'cp': 'cp',
'cyto-': 'cyto-',
'd.c.': 'd.c.',
'd.d.': 'd.d.',
'd.e.': 'd.e.',
'd.y.': 'd.y.',
'd.å.': 'd.å.',
'dB': 'dB',
'daa': 'daa',
'dat.': 'dat.',
'datt': 'datt',
'datten': 'datten',
'datter-': 'datter-',
'db': 'db',
'de': 'de',
'dem': 'de',
'de': 'de',
'de': 'de',
'de': 'de',
'de-': 'de-',
'degeren': 'degeren',
'degern': 'degern',
'deka-': 'deka-',
'demi-': 'demi-',
'den': 'den',
'den': 'den',
'den gang': 'den gang',
'denne': 'denne',
'dept.': 'dept.',
'dere': 'dere',
'deres': 'deres',
'dersom': 'dersom',
'des-': 'des-',
'desi-': 'desi-',
'det': 'det',
'det': 'det',
'dette': 'dette',
'dg': 'dg',
'di-': 'di-',
'dia-': 'dia-',
'dikkedikk': 'dikkedikk',
'dim.': 'dim.',
'din': 'din',
'di': 'din',
'ditt': 'din',
'dine': 'din',
'ding-dang': 'ding-dang',
'ding-ding': 'ding-ding',
'dis-': 'dis-',
'disse': 'disse',
'ditt': 'ditt',
'ditt': 'ditt',
'ditten': 'ditten',
'ditten': 'ditten',
'ditto': 'ditto',
'div.': 'div.',
'dl': 'dl',
'dm': 'dm',
'do.': 'do.',
'dr.': 'dr.',
'dr.agric.': 'dr.agric.',
'dr.art.': 'dr.art.',
'dr.ing.': 'dr.ing.',
'dr.jur.': 'dr.jur.',
'dr.med.': 'dr.med.',
'dr.med.vet.': 'dr.med.vet.',
'dr.odont.': 'dr.odont.',
'dr.oecon.': 'dr.oecon.',
'dr.philos.': 'dr.philos.',
'dr.techn.': 'dr.techn.',
'dr.theol.': 'dr.theol.',
'dritt-': 'dritt-',
'drømme-': 'drømme-',
'ds.': 'ds.',
'dss.': 'dss.',
'du': 'du',
'deg': 'du',
'dunk': 'dunk',
'dupleks-': 'dupleks-',
'duplo': 'duplo',
'dv.': 'dv.',
'dvs.': 'dvs.',
'dys-': 'dys-',
'dægeren': 'dægeren',
'dægern': 'dægern',
'dæven': 'dæven',
'e': 'e',
'e.Kr.': 'e.Kr.',
'e.f.': 'e.f.',
'e.l.': 'e.l.',
'eV': 'eV',
'edb': 'edb',
'eflg.': 'eflg.',
'eg.': 'eg.',
'ei': 'ei',
'eia': 'eia',
'eigen': 'eigen',
'eiga': 'eigen',
'eige': 'eigen',
'eigne': 'eigen',
'ekg': 'ekg',
'eks-': 'eks-',
'eksenter-': 'eksenter-',
'ekso-': 'ekso-',
'eksperimental-': 'eksperimental-',
'ekto-': 'ekto-',
'ekvi-': 'ekvi-',
'el.': 'el.',
'eldre-': 'eldre-',
'eleison': 'eleison',
'elektro-': 'elektro-',
'eller': 'eller',
'elleve': 'elleve',
'en': 'en',
'ei': 'en',
'ett': 'en',
'et': 'en',
'en': 'en',
'endelangs': 'endelangs',
'endo-': 'endo-',
'eneste': 'eneste',
'engere': 'engere',
'engest': 'engere',
'engeste': 'engere',
'enhver': 'enhver',
'ethvert': 'enhver',
'enn': 'enn',
'enn': 'enn',
'enn si': 'enn si',
'enn videre': 'enn videre',
'enn ytterligere': 'enn ytterligere',
'enskjønt': 'enskjønt',
'enten': 'enten',
'entré-': 'entré-',
'epi-': 'epi-',
'er-': 'er-',
'ergo-': 'ergo-',
'erke-': 'erke-',
'et.': 'et.',
'etc.': 'etc.',
'etno-': 'etno-',
'etter': 'etter',
'etter at': 'etter at',
'etter som': 'etter som',
'etterkrigs-': 'etterkrigs-',
'ettersom': 'ettersom',
'eu-': 'eu-',
'ev-': 'ev-',
'ev.': 'ev.',
'ex': 'ex',
'f.': 'f.',
'f.Kr.': 'f.Kr.',
'f.eks.': 'f.eks.',
'f.o.r.': 'f.o.r.',
'face': 'face',
'fallera': 'fallera',
'falleri': 'falleri',
'fantom-': 'fantom-',
'far vel': 'far vel',
'farken': 'farken',
'farmako-': 'farmako-',
'fec.': 'fec.',
'fedrene-': 'fedrene-',
'felles-': 'felles-',
'fem': 'fem',
'femten': 'femten',
'femti': 'femti',
'ferro-': 'ferro-',
'ff': 'ff',
'fff': 'fff',
'fhv.': 'fhv.',
'fil-': 'fil-',
'filiokus': 'filiokus',
'filiokus': 'filiokus',
'fille-': 'fille-',
'filleren': 'filleren',
'filo-': 'filo-',
'fin-': 'fin-',
'fire': 'fire',
'fjartan': 'fjartan',
'fjern-': 'fjern-',
'fjorten': 'fjorten',
'fl': 'fl',
'fl.': 'fl.',
'fl.': 'fl.',
'flt.': 'fl.',
'fl.': 'fl.',
'fler-': 'fler-',
'flg.': 'flg.',
'flt.': 'flt.',
'fol.': 'fol.',
'fola': 'fola',
'fono-': 'fono-',
'for': 'for',
'for': 'for',
'for': 'for',
'for at': 'for at',
'for di': 'for di',
'for hånden': 'for hånden',
'for tida': 'for tida',
'for tiden': 'for tiden',
'for-': 'for-',
'for-': 'for-',
'foran': 'foran',
'forbi': 'forbi',
'fordi': 'fordi',
'fore-': 'fore-',
'foregangs-': 'foregangs-',
'fork.': 'fork.',
'formedelst': 'formedelst',
'forrige': 'forrige',
'forst-': 'forst-',
'foruten': 'foruten',
'foto-': 'foto-',
'fr': 'fr',
'fr.': 'fr.',
'fra': 'fra',
'fra borde': 'fra borde',
'frametter': 'frametter',
'framfor': 'framfor',
'frammafor': 'frammafor',
'frammenfor': 'frammenfor',
'framom': 'framom',
'framover': 'framover',
'frampå': 'frampå',
'franko-': 'franko-',
'fremetter': 'fremetter',
'fremfor': 'fremfor',
'fremmenfor': 'fremmenfor',
'fremom': 'fremom',
'fremover': 'fremover',
'frempå': 'frempå',
'frk.': 'frk.',
'fro-': 'fro-',
'fut.': 'fut.',
'fy': 'fy',
'fysio-': 'fysio-',
'fysj': 'fysj',
'før': 'før',
'før enn': 'før enn',
'førti': 'førti',
'g': 'g.',
'g.': 'g.',
'g.': 'g.',
'gakk': 'gakk',
'gakk-gakk': 'gakk-gakk',
'gal': 'gal',
'gamle-': 'gamle-',
'gastro-': 'gastro-',
'ge-': 'ge-',
'geheime-': 'geheime-',
'gen.': 'gen.',
'general-': 'general-',
'geo-': 'geo-',
'gett': 'gett',
'gg': 'gg',
'gid': 'gid',
'giga-': 'giga-',
'giss': 'giss',
'gitt': 'gitt',
'gjen-': 'gjen-',
'gjennom': 'gjennom',
'gjøren': 'gjøren',
'gl.': 'gl.',
'gnr.': 'gnr.',
'god dag': 'god dag',
'god kveld': 'god kveld',
'god morgen': 'god morgen',
'god natt': 'god natt',
'grise-': 'grise-',
'gros': 'gros',
'gud skje lov': 'gud skje lov',
'gymno-': 'gymno-',
'gyn-': 'gyn-',
'går kveld': 'går kveld',
'går morges': 'går morges',
'går natt': 'går natt',
'ha': 'ha',
'ha': 'ha',
'ha-ha': 'ha-ha',
'haha': 'haha',
'halleluja': 'halleluja',
'hallo': 'hallo',
'halloi': 'halloi',
'halo-': 'halo-',
'halvannen': 'halvannen',
'halvanna': 'halvannen',
'halvannen': 'halvannen',
'halvannet': 'halvannen',
'halvhundre': 'halvhundre',
'han': 'han',
'ham': 'han',
'han': 'han',
'hand-': 'hand-',
'hands up': 'hands up',
'hans': 'hans',
'hau': 'hau',
'he': 'he',
'hei': 'hei',
'hei sann': 'hei sann',
'heia': 'heia',
'heil': 'heil',
'heim att': 'heim att',
'heimanfra': 'heimanfra',
'heksa-': 'heksa-',
'hekto-': 'hekto-',
'helio-': 'helio-',
'helledussen': 'helledussen',
'hema-': 'hema-',
'hemi-': 'hemi-',
'henad': 'henad',
'henimot': 'henimot',
'hennes': 'hennes',
'henover': 'henover',
'henved': 'henved',
'hepp': 'hepp',
'hepta-': 'hepta-',
'herregud': 'herregud',
'hetero-': 'hetero-',
'heureka': 'heureka',
'hg': 'hg',
'hhv.': 'hhv.',
'hill': 'hill',
'hin': 'hin',
'hi': 'hin',
'hint': 'hin',
'hine': 'hin',
'hinannen': 'hinannen',
'hinsides': 'hinsides',
'hipp': 'hipp',
'hitafor': 'hitafor',
'hitenfor': 'hitenfor',
'hk': 'hk',
'hl': 'hl',
'hm': 'hm',
'ho': 'ho',
'hoho': 'hoho',
'hoi': 'hoi',
'holdt': 'holdt',
'homo-': 'homo-',
'hopp': 'hopp',
'hopp sann': 'hopp sann',
'hoppla': 'hoppla',
'hoppsa': 'hoppsa',
'hoppsasa': 'hoppsasa',
'hos': 'hos',
'hosianna': 'hosianna',
'hoved-': 'hoved-',
'hu': 'hu',
'huff': 'huff',
'hui': 'hui',
'hun': 'hun',
'henne': 'hun',
'hundre': 'hundre',
'hundreogén': 'hundreogén',
'hundreogéi': 'hundreogén',
'hundreogett': 'hundreogén',
'hurra': 'hurra',
'hurten': 'hurten',
'husj': 'husj',
'hut': 'hut',
'huttemegtu': 'huttemegtu',
'huttetu': 'huttetu',
'hva': 'hva',
'hvem': 'hvem',
'hver': 'hver',
'hvert': 'hver',
'hverandre': 'hverandre',
'hvilken': 'hvilken',
'hvilket': 'hvilken',
'hvilke': 'hvilken',
'hvo': 'hvo',
'hvorvidt': 'hvorvidt',
'hyper-': 'hyper-',
'hypo-': 'hypo-',
'hypp': 'hypp',
'hysj': 'hysj',
'hyss': 'hyss',
'hå': 'hå',
'hånd-': 'hånd-',
'hæ': 'hæ',
'hø': 'hø',
'høg-': 'høg-',
'hør': 'hør',
'høy-': 'høy-',
'i': 'i',
'i aften': 'i aften',
'i aftes': 'i aftes',
'i dag': 'i dag',
'i fall': 'i fall',
'i fjor': 'i fjor',
'i fleng': 'i fleng',
'i forfjor': 'i forfjor',
'i forgårs': 'i forgårs',
'i gjerde': 'i gjerde',
'i gjære': 'i gjære',
'i grunnen': 'i grunnen',
'i går': 'i går',
'i går kveld': 'i går kveld',
'i hel': 'i hel',
'i hende': 'i hende',
'i hjel': 'i hjel',
'i hop': 'i hop',
'i hug': 'i hug',
'i huleste': 'i huleste',
'i hvert fall': 'i hvert fall',
'i koll': 'i koll',
'i kraft': 'i kraft',
'i kveld': 'i kveld',
'i lag': 'i lag',
'i land': 'i land',
'i like måte': 'i like måte',
'i live': 'i live',
'i mak': 'i mak',
'i mente': 'i mente',
'i miss': 'i miss',
'i mist': 'i mist',
'i morgen': 'i morgen',
'i morges': 'i morges',
'i møte': 'i møte',
'i natt': 'i natt',
'i overmorgen': 'i overmorgen',
'i rette': 'i rette',
'i sammen': 'i sammen',
'i senn': 'i senn',
'i sinne': 'i sinne',
'i stand': 'i stand',
'i sted': 'i sted',
'i stedet for': 'i stedet for',
'i stedet for': 'i stedet for',
'i stykker': 'i stykker',
'i stå': 'i stå',
'i sund': 'i sund',
'i svime': 'i svime',
'i så fall': 'i så fall',
'i så måte': 'i så måte',
'i søvne': 'i søvne',
'i tide': 'i tide',
'i tilfelle': 'i tilfelle',
'i tu': 'i tu',
'i utide': 'i utide',
'i vare': 'i vare',
'i veg': 'i veg',
'i vei': 'i vei',
'i vente': 'i vente',
'i verk': 'i verk',
'i år': 'i år',
'i.e.': 'i.e.',
'iatro-': 'iatro-',
'ib.': 'ib.',
'ib.': 'ibid.',
'ibid.': 'ibid.',
'iblant': 'iblant',
'idet': 'idet',
'idio-': 'idio-',
'ifra': 'ifra',
'ifølge': 'ifølge',
'igjennom': 'igjennom',
'ihjel-': 'ihjel-',
'ihop-': 'ihop-',
'ikring': 'ikring',
'il-': 'il-',
'im-': 'im-',
'imellom': 'imellom',
'imot': 'imot',
'in-': 'in-',
'individual-': 'individual-',
'indo-': 'indo-',
'infra-': 'infra-',
'ingen': 'ingen',
'inga': 'ingen',
'ingen': 'ingen',
'intet': 'ingen',
'ingen': 'ingen',
'ingenting': 'ingenting',
'inkl.': 'inkl.',
'inn i': 'inn i',
'inn til': 'inn til',
'innafor': 'innafor',
'innefra': 'innefra',
'innen': 'innen',
'innenfor': 'innenfor',
'innenifra': 'innenifra',
'inner-': 'inner-',
'innetter': 'innetter',
'innfor': 'innfor',
'inni': 'inni',
'inniblant': 'inniblant',
'innimellom': 'innimellom',
'innmed': 'innmed',
'innom': 'innom',
'innover': 'innover',
'innpå': 'innpå',
'inntil': 'inntil',
'innunder': 'innunder',
'innved': 'innved',
'innåt': 'innåt',
'insular-': 'insular-',
'inter-': 'inter-',
'interims-': 'interims-',
'intet': 'intet',
'intet': 'intet',
'intra-': 'intra-',
'ir-': 'ir-',
'isj': 'isj',
'iso-': 'iso-',
'ist': 'ist',
'istedenfor': 'istedenfor',
'istf.': 'istf.',
'ja': 'ja',
'ja vel': 'ja vel',
'ja visst': 'ja visst',
'jadden': 'jadden',
'jaggu': 'jaggu',
'jaha': 'jaha',
'jam-': 'jam-',
'jeg': 'jeg',
'meg': 'jeg',
'jemini': 'jemini',
'jf.': 'jf.',
'jo': 'jo',
'jo visst': 'jo visst',
'joggu': 'joggu',
'joho': 'joho',
'jr.': 'jr.',
'jun.': 'jr.',
'jr.': 'jr.',
'jun.': 'jun.',
'jur.': 'jur.',
'juris': 'juris',
'jøss': 'jøss',
'jøsses': 'jøsses',
'jøye': 'jøye',
'kB': 'kB',
'kHz': 'kHz',
'kJ': 'kJ',
'kV': 'kV',
'kW': 'kW',
'kWh': 'kWh',
'kanari-': 'kanari-',
'kand.': 'kand.',
'kanon-': 'kanon-',
'kardinal-': 'kardinal-',
'kcal': 'kcal',
'kg': 'kg',
'kgl.': 'kgl.',
'kgl.res.': 'kgl.res.',
'kilo-': 'kilo-',
'kiss': 'kiss',
'kjempe-': 'kjempe-',
'kl.': 'kl.',
'klask': 'klask',
'klikk-klakk': 'klikk-klakk',
'kling': 'kling',
'klingeling': 'klingeling',
'kliss-klass': 'kliss-klass',
'klukk': 'klukk',
'km': 'km',
'knall-': 'knall-',
'ko-': 'ko-',
'ko-ko': 'ko-ko',
'kol-': 'kol-',
'kom-': 'kom-',
'kombi-': 'kombi-',
'kon-': 'kon-',
'konst.': 'konst.',
'kontra': 'kontra',
'kontra-': 'kontra-',
'kor-': 'kor-',
'kosmo-': 'kosmo-',
'kp': 'kp',
'kpm': 'kpm',
'kr': 'kr',
'kra': 'kra',
'kring': 'kring',
'kringom': 'kringom',
'kromo-': 'kromo-',
'kst.': 'kst.',
'kt': 'kt',
'kurr': 'kurr',
'kvadrupel-': 'kvadrupel-',
'kvakk': 'kvakk',
'kvasi-': 'kvasi-',
'kvekk': 'kvekk',
'kvirrevitt': 'kvirrevitt',
'kykeliky': 'kykeliky',
'kyrie eleison': 'kyrie eleison',
'l': 'l',
'l\'art pour l\'art': 'l\'art pour l\'art',
'lab.': 'lab.',
'lag-': 'lag-',
'lakto-': 'lakto-',
'langs': 'langs',
'langsetter': 'langsetter',
'langsmed': 'langsmed',
'langt fra': 'langt fra',
'langt ifra': 'langt ifra',
'lat.': 'lat.',
'laten': 'laten',
'lev vel': 'lev vel',
'lg': 'lg',
'lg': 'lg',
'lic.': 'lic.',
'lic.philos.': 'lic.philos.',
'lign.': 'lign.',
'like ens': 'like ens',
'like til': 'like til',
'like-': 'like-',
'likesom': 'likesom',
'lign.': 'likn.',
'likn.': 'likn.',
'liksom': 'liksom',
'lim.': 'lim.',
'lite grann': 'lite grann',
'lm': 'lm',
'ln': 'ln',
'log': 'log',
'lim.': 'ltd.',
'ltd.': 'ltd.',
'lx': 'lx',
'm': 'm',
'moh.': 'moh.',
'muh.': 'muh.',
'm-l': 'm-l',
'm.a.o.': 'm.a.o.',
'm.m.': 'm.m.',
'm.o.t.': 'm.o.t.',
'm.p.p.': 'm.p.p.',
'mV': 'mV',
'mW': 'mW',
'mag.': 'mag.',
'mag.art.': 'mag.art.',
'mag.scient.': 'mag.scient.',
'makro-': 'makro-',
'man': 'man',
'mang en': 'mang en',
'mang ei': 'mang en',
'mangt et': 'mang en',
'mange': 'mang en',
'mange slags': 'mange slags',
'mang en': 'mangt et',
'manne-': 'manne-',
'manns-': 'manns-',
'maraton-': 'maraton-',
'mari-': 'mari-',
'marsj': 'marsj',
'mask.': 'mask.',
'mb': 'mb',
'med': 'med',
'med mindre': 'med mindre',
'med.': 'med.',
'mega-': 'mega-',
'mek.': 'mek.',
'mellom': 'mellom',
'men': 'men',
'mens': 'mens',
'meso-': 'meso-',
'meta-': 'meta-',
'mezzo-': 'mezzo-',
'mfl.': 'mfl.',
'mg': 'mg',
'mht.': 'mht.',
'mid-': 'mid-',
'middel-': 'middel-',
'midt-': 'midt-',
'mikro-': 'mikro-',
'mill.': 'mill.',
'milli-': 'milli-',
'min': 'min',
'mi': 'min',
'mitt': 'min',
'mine': 'min',
'miniatyr-': 'miniatyr-',
'mis-': 'mis-',
'mjau': 'mjau',
'ml': 'ml',
'mm': 'mm',
'moder-': 'moder-',
'molekylar-': 'molekylar-',
'mon': 'mon',
'mon tro': 'mon tro',
'mon tru': 'mon tru',
'mon-': 'mon-',
'mono-': 'mono-',
'moratorie-': 'moratorie-',
'morn': 'morn',
'mot': 'mot',
'mots.': 'mots.',
'mrd.': 'mrd.',
'ms': 'ms',
'multi-': 'multi-',
'mva.': 'mva.',
'må hende': 'må hende',
'må vite': 'må vite',
'mø': 'mø',
'nabo-': 'nabo-',
'nam': 'nam',
'nano-': 'nano-',
'narko-': 'narko-',
'natura': 'natura',
'natural-': 'natural-',
'nau-': 'nau-',
'ned i': 'ned i',
'ned på': 'ned på',
'nedafor': 'nedafor',
'nedafra': 'nedafra',
'nedefra': 'nedefra',
'nedenfor': 'nedenfor',
'nedenfra': 'nedenfra',
'nedenifra': 'nedenifra',
'nedenom': 'nedenom',
'nedetter': 'nedetter',
'nedi': 'nedi',
'nedigjennom': 'nedigjennom',
'nedimot': 'nedimot',
'nedmed': 'nedmed',
'nedom': 'nedom',
'nedover': 'nedover',
'nedpå': 'nedpå',
'nedved': 'nedved',
'nei': 'nei',
'nekro-': 'nekro-',
'neo-': 'neo-',
'neste': 'neste',
'neur-': 'neur-',
'neuro-': 'neuro-',
'nevr-': 'nevr-',
'nevro-': 'nevro-',
'ng': 'ng',
'ni': 'ni',
'ni-': 'ni-',
'nitr-': 'nitr-',
'nitro-': 'nitro-',
'nitten': 'nitten',
'nitti': 'nitti',
'nja': 'nja',
'NOK': 'nkr',
'nkr': 'nkr',
'nobel-': 'nobel-',
'noen': 'noen',
'noe': 'noen',
'noen': 'noen',
'non-': 'non-',
'nord om': 'nord om',
'nordafor': 'nordafor',
'nordafra': 'nordafra',
'nordenfor': 'nordenfor',
'nordenfra': 'nordenfra',
'nordenom': 'nordenom',
'nordetter': 'nordetter',
'nordfra': 'nordfra',
'nordi': 'nordi',
'nordigjennom': 'nordigjennom',
'nordmed': 'nordmed',
'nordom': 'nordom',
'nordover': 'nordover',
'nordpå': 'nordpå',
'nr.': 'nr.',
'null': 'null',
'nåda': 'nåda',
'nøff': 'nøff',
'nøff-nøff': 'nøff-nøff',
'nøkkel-': 'nøkkel-',
'o-': 'o-',
'o.a.': 'o.a.',
'o.h.': 'o.h.',
'o.l.': 'o.l.',
'o.m.': 'o.m.',
'o.m.a.': 'o.m.a.',
'ob-': 'ob-',
'obs.': 'obs.',
'obs.': 'obs.',
'odont.': 'odont.',
'oecon.': 'oecon.',
'off': 'off.',
'off.': 'off.',
'ofl.': 'ofl.',
'og': 'og',
'oho': 'oho',
'ohoi': 'ohoi',
'oi': 'oi',
'okk': 'okk',
'okt-': 'okt-',
'okta-': 'okta-',
'okto-': 'okto-',
'old-': 'old-',
'om': 'om',
'om': 'om',
'om bord': 'om bord',
'om enn': 'om enn',
'om gangen': 'om gangen',
'om kapp': 'om kapp',
'om kull': 'om kull',
'om lag': 'om lag',
'om senn': 'om senn',
'om-': 'om-',
'omennskjønt': 'omennskjønt',
'omfram': 'omfram',
'omframt': 'omframt',
'omkr.': 'omkr.',
'omkring': 'omkring',
'omnibus-': 'omnibus-',
'op-': 'op-',
'op.': 'op.',
'op.cit.': 'op.cit.',
'opp i': 'opp i',
'opp imot': 'opp imot',
'opp mot': 'opp mot',
'opp på': 'opp på',
'opp til': 'opp til',
'oppetter': 'oppetter',
'oppfor': 'oppfor',
'oppi': 'oppi',
'oppigjennom': 'oppigjennom',
'oppimot': 'oppimot',
'oppmed': 'oppmed',
'oppom': 'oppom',
'oppover': 'oppover',
'opptil': 'opptil',
'oppunder': 'oppunder',
'oppved': 'oppved',
'oppå': 'oppå',
'orto-': 'orto-',
'osfr.': 'osfr.',
'osv.': 'osv.',
'ot-': 'ot-',
'ot.prp.': 'ot.prp.',
'oto-': 'oto-',
'ov-': 'ov-',
'ova-': 'ova-',
'ovafor': 'ovafor',
'ovafra': 'ovafra',
'ovapå': 'ovapå',
'oven-': 'oven-',
'ovenfor': 'ovenfor',
'ovenfra': 'ovenfra',
'ovenom': 'ovenom',
'ovenpå': 'ovenpå',
'over': 'over',
'over bord': 'over bord',
'over ende': 'over ende',
'over kors': 'over kors',
'over lang': 'over lang',
'over skrevs': 'over skrevs',
'over styr': 'over styr',
'over tvert': 'over tvert',
'over-': 'over-',
'overfor': 'overfor',
'ovf.': 'ovf.',
'p': 'p',
'p.': 'p.',
'p.a.': 'p.a.',
'p.m.': 'p.m.',
'p.p.': 'p.p.',
'p.p.m.': 'p.p.m.',
'p.r.': 'p.r.',
'p.t.': 'p.t.',
'pa.': 'pa.',
'paed.': 'paed.',
'paff': 'paff',
'paleo-': 'paleo-',
'pan-': 'pan-',
'pang-': 'pang-',
'para-': 'para-',
'partial-': 'partial-',
'passant': 'passant',
'penta-': 'penta-',
'per': 'per',
'per-': 'per-',
'pereat': 'pereat',
'peri-': 'peri-',
'pers': 'pers',
'pf.': 'pf.',
'pga.': 'pga.',
'pharm.': 'pharm.',
'philol.': 'philol.',
'philos.': 'philos.',
'piff': 'piff',
'pinadø': 'pinadø',
'pinede': 'pinede',
'pinedød': 'pinedød',
'pip': 'pip',
'piskadausen': 'piskadausen',
'piskadød': 'piskadød',
'pist': 'pist',
'pl.': 'pl.',
'plaff': 'plaff',
'plask': 'plask',
'plenar-': 'plenar-',
'pling': 'pling',
'plopp': 'plopp',
'plump': 'plump',
'polit.': 'polit.',
'poly-': 'poly-',
'post': 'post',
'post-': 'post-',
'poste restante': 'poste restante',
'pr.': 'pr.',
'pre-': 'pre-',
'prep.': 'prep.',
'pret.': 'pret.',
'pro': 'pro',
'pro-': 'pro-',
'pron.': 'pron.',
'prosit': 'prosit',
'prositt': 'prositt',
'prot-': 'prot-',
'proto-': 'proto-',
'prp.': 'prp.',
'pseudo-': 'pseudo-',
'psevdo-': 'psevdo-',
'pst': 'pst',
'pst.': 'pst.',
'psychol.': 'psychol.',
'psyko-': 'psyko-',
'ptro': 'ptro',
'puff': 'puff',
'puh': 'puh',
'puss': 'puss',
'pvrk': 'pvrk',
'pyro-': 'pyro-',
'pytt': 'pytt',
'på': 'på',
'pø': 'pø',
'pøh': 'pøh',
'q.e.d.': 'q.e.d.',
'q.s.': 'q.s.',
'qua': 'qua',
'quo vadis': 'quo vadis',
'quod erat demonstrandum': 'quod erat demonstrandum',
'radio-': 'radio-',
'rapp': 'rapp',
'ratsj': 'ratsj',
're-': 're-',
'real.': 'real.',
'redoks-': 'redoks-',
'rek.': 'rek.',
'rekord-': 'rekord-',
'renminbi': 'renminbi',
'res.kap.': 'res.kap.',
'resp.': 'resp.',
'retro-': 'retro-',
'riks-': 'riks-',
'ritsj': 'ritsj',
'rundt': 'rundt',
'rømmen': 'rømmen',
's.a.': 's.a.',
's.u.': 's.u.',
's.å.': 's.å.',
'salvo': 'salvo',
'sam-': 'sam-',
'samme': 'samme',
'samt': 'samt',
'samtlige': 'samtlige',
'sc.': 'sc.',
'scient.': 'scient.',
'scient.': 'scient.',
'seg': 'seg',
'sek': 'sek',
'seks': 'seks',
'seksten': 'seksten',
'seksti': 'seksti',
'seksual-': 'seksual-',
'sekular-': 'sekular-',
'selv': 'selv',
'selv om': 'selv om',
'selveste': 'selveste',
'semi-': 'semi-',
'sen.': 'sen.',
'sr.': 'sen.',
'sen.': 'sen.',
'senior-': 'senior-',
'servo-': 'servo-',
'sesam': 'sesam',
'sg.': 'sg.',
'sing.': 'sg.',
'sg.': 'sg.',
'si-': 'si-',
'sign.': 'sign.',
'simili-': 'simili-',
'simpleks-': 'simpleks-',
'simsalabim': 'simsalabim',
'sin': 'sin',
'si': 'sin',
'sitt': 'sin',
'sine': 'sin',
'sing.': 'sing.',
'singott': 'singott',
'sitter-': 'sitter-',
'sju': 'sju',
'sjøl': 'sjøl',
'sjølveste': 'sjølveste',
'skarve-': 'skarve-',
'skinn-': 'skinn-',
'skjønt': 'skjønt',
'skyts-': 'skyts-',
'skål': 'skål',
'slik': 'slik',
'slikt': 'slik',
'slike': 'slik',
'smell-': 'smell-',
'snapp': 'snapp',
'snart': 'snart',
'snik-': 'snik-',
'snipp': 'snipp',
'som': 'som',
'somme': 'somme',
'somt': 'somt',
'somme': 'somt',
'sosio-': 'sosio-',
'sr.': 'sr.',
'st.': 'st.',
'st.prp.': 'st.prp.',
'stam-': 'stam-',
'ste-': 'ste-',
'stk.': 'stk.',
'strato-': 'strato-',
'stud.': 'stud.',
'sturten': 'sturten',
'sub-': 'sub-',
'sulf-': 'sulf-',
'sulfo-': 'sulfo-',
'super-': 'super-',
'supra-': 'supra-',
'sviger-': 'sviger-',
'svine-': 'svine-',
'svupp': 'svupp',
'sydetter': 'sydetter',
'sydfra': 'sydfra',
'sydover': 'sydover',
'sydpå': 'sydpå',
'syl-': 'syl-',
'sym-': 'sym-',
'syn-': 'syn-',
'sytten': 'sytten',
'sytti': 'sytti',
'så framt': 'så framt',
'så fremt': 'så fremt',
'så menn': 'så menn',
'så nær som': 'så nær som',
'så sant': 'så sant',
'så som': 'så som',
'så vel som': 'så vel som',
'så vidt': 'så vidt',
'sådan': 'sådan',
'sådant': 'sådan',
'sådanne': 'sådan',
'såframt': 'såframt',
'såfremt': 'såfremt',
'sånn': 'sånn',
'sånt': 'sånn',
'sånne': 'sånn',
'sønnafor': 'sønnafor',
'sønnafra': 'sønnafra',
'sønnenfor': 'sønnenfor',
'sønnenfra': 'sønnenfra',
'sønnenom': 'sønnenom',
'søren': 'søren',
'søretter': 'søretter',
'sørfra': 'sørfra',
'sørover': 'sørover',
'sørpå': 'sørpå',
'søtten': 'søtten',
't.d.': 't.d.',
't.o.m.': 't.o.m.',
'taky-': 'taky-',
'tbc': 'tbc',
'tekno-': 'tekno-',
'tele-': 'tele-',
'teo-': 'teo-',
'tera-': 'tera-',
'termo-': 'termo-',
'tetra-': 'tetra-',
'thai-': 'thai-',
'ti': 'ti',
'tikk': 'tikk',
'tikk-takk': 'tikk-takk',
'til': 'til',
'til dels': 'til dels',
'til dømes': 'til dømes',
'til fals': 'til fals',
'til like': 'til like',
'til live': 'til live',
'til livs': 'til livs',
'til orde': 'til orde',
'til overs': 'til overs',
'til stede': 'til stede',
'tilleggs-': 'tilleggs-',
'tillikemed': 'tillikemed',
'tio-': 'tio-',
'tja': 'tja',
'tjo': 'tjo',
'tjue': 'tjue',
'to': 'to',
'toksi-': 'toksi-',
'tolv': 'tolv',
'tralala': 'tralala',
'trans-': 'trans-',
'trass': 'trass',
'tre': 'tre',
'tretten': 'tretten',
'tretti': 'tretti',
'tri-': 'tri-',
'triplo': 'triplo',
'tripp': 'tripp',
'trommelom': 'trommelom',
'tross': 'tross',
'tupp': 'tupp',
'turbo-': 'turbo-',
'turko-': 'turko-',
'tusen': 'tusen',
'tve-': 'tve-',
'tverr-': 'tverr-',
'tvi': 'tvi',
'tvi-': 'tvi-',
'tyss': 'tyss',
'tøff': 'tøff',
'u-': 'u-',
'uaktet': 'uaktet',
'uansett': 'uansett',
'uff': 'uff',
'ult.': 'ult.',
'ultra-': 'ultra-',
'undas': 'undas',
'under': 'under',
'under vær': 'under vær',
'under-': 'under-',
'underhands-': 'underhands-',
'underhånds-': 'underhånds-',
'uni-': 'uni-',
'unn-': 'unn-',
'unna': 'unna',
'unntagen': 'unntagen',
'unntatt': 'unntatt',
'ur-': 'ur-',
'ut av': 'ut av',
'ut i': 'ut i',
'ut over': 'ut over',
'ut på': 'ut på',
'ut-': 'ut-',
'uta-': 'uta-',
'utafor': 'utafor',
'utafra': 'utafra',
'utapå': 'utapå',
'utav': 'utav',
'utefra': 'utefra',
'uten': 'uten',
'uten-': 'uten-',
'utenfor': 'utenfor',
'utenfra': 'utenfra',
'utenom': 'utenom',
'utenpå': 'utenpå',
'utetter': 'utetter',
'utfor': 'utfor',
'uti': 'uti',
'utmed': 'utmed',
'utom': 'utom',
'utover': 'utover',
'utpå': 'utpå',
'utved': 'utved',
'v.': 'v.',
'van': 'van',
'van-': 'van-',
'vara-': 'vara-',
'varsku': 'varsku',
'vaso-': 'vaso-',
'vass-': 'vass-',
've': 've',
'ved': 'ved',
'ved like': 'ved like',
'veder-': 'veder-',
'verken': 'verken',
'versus': 'versus',
'vestafor': 'vestafor',
'vestafra': 'vestafra',
'vestenfor': 'vestenfor',
'vestenfra': 'vestenfra',
'vestenom': 'vestenom',
'vestfra': 'vestfra',
'vestover': 'vestover',
'vestpå': 'vestpå',
'vet.': 'vet.',
'vet.': 'vet.',
'vi': 'vi',
'oss': 'vi',
'via': 'via',
'video-': 'video-',
'vips': 'vips',
'vis-à-vis': 'vis-à-vis',
'vise-': 'vise-',
'vit.ass.': 'vit.ass.',
'vivat': 'vivat',
'voff': 'voff',
'voff-voff': 'voff-voff',
'von': 'von',
'votiv-': 'votiv-',
'vov': 'vov',
'vov-vov': 'vov-vov',
'vsa.': 'vsa.',
'vår': 'vår',
'vårt': 'vår',
'våre': 'vår',
'vær-': 'vær-',
'xanto-': 'xanto-',
'xeno-': 'xeno-',
'xero-': 'xero-',
'xylo-': 'xylo-',
'yd': 'yd',
'ytter-': 'ytter-',
'zero': 'zero',
'zoo-': 'zoo-',
'å': 'å',
'å': 'å',
'åhå': 'åhå',
'åt': 'åt',
'åtte': 'åtte',
'åtti': 'åtti',
'æ': 'æ',
'æsj': 'æsj',
'øko-': 'øko-',
'ør-': 'ør-',
'ørten': 'ørten',
'østafor': 'østafor',
'østafra': 'østafra',
'østenfor': 'østenfor',
'østenfra': 'østenfra',
'østenom': 'østenom',
'østetter': 'østetter',
'østfra': 'østfra',
'østover': 'østover',
'østpå': 'østpå',
'egen': 'egen',
'eget': 'egen',
'egne': 'egen',
'fersken': 'fersken',
'hvis': 'hvis',
'hvis': 'hvis',
'den': 'den',
'eder': 'eder',
'enøk': 'enøk',
'hundre og én': 'hundre og én',
'hundre og éi': 'hundre og én',
'hundre og ett': 'hundre og én',
'hverken': 'hverken',
'i mellomtida': 'i mellomtida',
'i mellomtiden': 'i mellomtiden',
'kille': 'kille',
'min': 'min',
'pang': 'pang',
'pardong': 'pardong',
'pro': 'pro',
'restante': 'restante',
'sin': 'sin',
'sjøl om': 'sjøl om',
'svibrent': 'svibrent',
'tan': 'tan',
'tjueen': 'tjueen',
'tjueei': 'tjueen',
'tjueett': 'tjueen',
'trapp': 'trapp',
'trom': 'trom',
'tvibrent': 'tvibrent',
'UHF': 'UHF',
'vilden': 'vilden',
'villen': 'villen',
'by': 'by',
'de': 'de',
'et': 'et',
'fyterakkern': 'fyterakkern',
'hi': 'hi',
'viss': 'viss',
'kynnerer': 'kynnerer',
'nå': 'nå',
'syv': 'syv',
'frå borde': 'frå borde',
'til og med': 'til og med',
'til og med': 'til og med',
'A': 'A',
'av': 'av',
'c': 'c',
'CD': 'CD',
'D': 'D',
'E': 'E',
'el': 'el',
'f': 'f',
'g': 'g',
'g.': 'g',
'g': 'g',
'Mrs.': 'Mrs.',
'R': 'R',
'r': 'r',
't': 't',
'U': 'U',
'u': 'U',
'U': 'U',
'u': 'u',
'v': 'v',
'X': 'X',
'YAP': 'YAP',
'B-': 'B-',
'ideal-': 'ideal-',
'laboratorie-': 'laboratorie-',
'mini-': 'mini-',
'olig-': 'olig-',
'piko-': 'piko-',
'røk-': 'røk-',
'røke-': 'røke-',
'stereo-': 'stereo-',
'still-': 'still-',
'A': 'A',
'Å': 'Å',
'B': 'B',
'b': 'b',
'C': 'C',
'd': 'd',
'da': 'da',
'F': 'F',
'G': 'G',
'g': 'g',
'H': 'H',
'h': 'h',
'J': 'J',
'K': 'K',
'k': 'k',
'N': 'N',
'n': 'n',
'O': 'O',
'P': 'P',
'S': 'S',
's': 's',
'T': 'T',
'U': 'U',
'u': 'u',
'V': 'V',
'W': 'W',
'Y': 'Y',
'i hu': 'i hu',
'fanker\'n': 'fanker\'n',
'goddag': 'goddag',
'godnatt': 'godnatt',
'jamen': 'jamen',
'javel': 'javel',
'joda': 'joda',
'langtfra': 'langtfra',
'neivel': 'neivel',
'da': 'da',
'De': 'De',
'Dem': 'De',
'eders': 'eders',
'eders': 'eders',
'selve': 'selve',
'som': 'som',
'adj.': 'adj.',
'adr.': 'adr.',
'adv.': 'adv.',
'akk.': 'akk.',
'a.m.': 'a.m.',
'Ap': 'Ap.',
'Ap.': 'Ap.',
'apr.': 'apr.',
'att.': 'att.',
'aug.': 'aug.',
'aut.': 'aut.',
'avs.': 'avs.',
'bet.': 'bet.',
'bto.': 'bto.',
'cif': 'cif.',
'd.s.': 'd.s.',
'd.m.': 'd.m.',
'da': 'da',
'daa': 'da',
'da': 'da',
'dB': 'dB',
'dB': 'dB',
'des.': 'des.',
'e.': 'e.',
'EEC': 'EEC',
'eks.': 'eks.',
'ekskl.': 'ekskl.',
'EU': 'EU',
'f.m.': 'f.m.',
'f.t.': 'f.t.',
'f.å.': 'f.å.',
'feb.': 'feb.',
'fig.': 'fig.',
'fob': 'fob',
'GATT': 'GATT',
'IT': 'IT',
'jnr.': 'jnr.',
'lnr.': 'lnr.',
'mv.': 'mv.',
'maks.': 'maks.',
'md.': 'md.',
'min': 'min',
'MV': 'MV',
'n.': 'n.',
'no.': 'no.',
'nom.': 'nom.',
'nov.': 'nov.',
'NT': 'NT',
'obs.': 'obs.',
'OECD': 'OECD',
'okt.': 'okt.',
'pkt.': 'pkt.',
'pr.pr.': 'pr.pr.',
's.d.': 's.d.',
's.': 's.',
'sep.': 'sep.',
'sj.': 'sj.',
'sst.': 'sst.',
'ss.': 'ss.',
'st.meld.': 'st.meld.',
't.forskj.fra': 't.forskj.fra',
'tlf.': 'tlf.',
'ts': 'ts',
'UK': 'UK',
'UNESCO': 'UNESCO',
'USA': 'USA',
'utg.': 'utg.',
'utt.': 'utt.',
'v.h.a.': 'v.h.a.',
'vedk.': 'vedk.',
'årg.': 'årg.',
'årh.': 'årh.',
'bet.': 'bet.',
'bot.': 'bot.',
'hå.': 'hå.',
'jan.': 'jan.',
'red.': 'red.',
'red.': 'red.',
'dr.philos.': 'dr.philos.',
'dr.polit.': 'dr.polit.',
'dr.psychol.': 'dr.psychol.',
'dr.scient.': 'dr.scient.',
'dr.pharm.': 'dr.pharm.',
'stud.mag.art.': 'stud.mag.art.',
'stud.odont.': 'stud.odont.',
'stud.oecon.': 'stud.oecon.',
'stud.pharm.': 'stud.pharm.',
'stud.philol.': 'stud.philol.',
'stud.polit.': 'stud.polit.',
'stud.psychol.': 'stud.psychol.',
'stud.real.': 'stud.real.',
'stud.scient.': 'stud.scient.',
'blant anna': 'blant anna',
'blant annet': 'blant annet',
'enkelt sagt': 'enkelt sagt',
'for eksempel': 'for eksempel',
'fra barnsbein av': 'fra barnsbein av',
'fra barnsben av': 'fra barnsben av',
'fra oven': 'fra oven',
'gjøren og laden': 'gjøren og laden',
'gjøren og laten': 'gjøren og laten',
'glipp av': 'glipp av',
'has på': 'has på',
'hipp som happ	 subst+prep+subst adv @S-PRED normert': 'hipp som happ',
'hulter til bulter	 subst+prep+subst adv @ADV normert': 'hulter til bulter',
'hummer og kanari': 'hummer og kanari',
'hurten og sturten': 'hurten og sturten',
'hva i huleste': 'hva i huleste',
'i beknip': 'i beknip',
'i bero': 'i bero',
'i beste velgående': 'i beste velgående',
'i bløt': 'i bløt',
'i bløyt': 'i bløyt',
'i embeds medfør': 'i embeds medfør',
'i embets medfør': 'i embets medfør',
'i en fyk og en fei': 'i en fyk og en fei',
'i en ruff': 'i en ruff',
'i forvaring': 'i forvaring',
'i fyk og fei': 'i fyk og fei',
'i glemme': 'i glemme',
'i glømme': 'i glømme',
'i halve dag': 'i halve dag',
'i halve fjor	 prep+adj+subst adv @ADV normert': 'i halve fjor',
'i halve forfjor': 'i halve forfjor',
'i halve forgårs': 'i halve forgårs',
'i halve går': 'i halve går',
'i halve morgen': 'i halve morgen',
'i hartkorn': 'i hartkorn',
'i hele dag': 'i hele dag',
'i hele fjor	 prep+adj+subst adv @ADV normert': 'i hele fjor',
'i hele forfjor': 'i hele forfjor',
'i hele forgårs': 'i hele forgårs',
'i hele går': 'i hele går',
'i hele morgen': 'i hele morgen',
'i hui og hast': 'i hui og hast',
'i hutaheiti': 'i hutaheiti',
'i hytt og pine': 'i hytt og pine',
'i hytt og vær': 'i hytt og vær',
'i kraft av': 'i kraft av',
'i påvente av': 'i påvente av',
'i ro og mak': 'i ro og mak',
'i senk': 'i senk',
'i smug': 'i smug',
'i stampe': 'i stampe',
'i sus og dus': 'i sus og dus',
'i ulage': 'i ulage',
'i urede': 'i urede',
'i ustand': 'i ustand',
'i villrede': 'i villrede',
'jo da': 'jo da',
'klabb og babb': 'klabb og babb',
'kort fortalt': 'kort fortalt',
'kort sagt': 'kort sagt',
'kost og mask': 'kost og mask',
'kreti og pleti': 'kreti og pleti',
'langveges fra': 'langveges fra',
'langvegs fra': 'langvegs fra',
'langveis fra': 'langveis fra',
'last og brast': 'last og brast',
'med bibehold av': 'med bibehold av',
'med brask og bram': 'med brask og bram',
'med føye': 'med føye',
'med henblikk på': 'med henblikk på',
'ned fra': 'ned fra',
'ned over': 'ned over',
'nei vel': 'nei vel',
'nei visst': 'nei visst',
'pomp og prakt': 'pomp og prakt',
'pr def': 'pr. def.',
'pr. def.': 'pr. def.',
'pr definisjon': 'pr. definisjon',
'pr. definisjon': 'pr. definisjon',
'på forhand': 'på forhand',
'på forhånd': 'på forhånd',
'på førehand': 'på førehand',
'på gjørs': 'på gjørs',
'på hils': 'på hils',
'på huk': 'på huk',
'på leit': 'på leit',
'på måfå': 'på måfå',
'på ny frisk': 'på ny frisk',
'på rams': 'på rams',
'på røde rappen': 'på røde rappen',
'på si': 'på si',
'på skakke': 'på skakke',
'på svøm': 'på svøm',
'på tverke': 'på tverke',
'på vidvank': 'på vidvank',
'på vidvanke': 'på vidvanke',
'ride ranke': 'ride ranke',
'rist eller ro': 'rist eller ro',
'rubb og rake': 'rubb og rake',
'rubb og stubb': 'rubb og stubb',
'rubbel og bit': 'rubbel og bit',
'sjakk matt': 'sjakk matt',
'smitt og smule': 'smitt og smule',
'stopp en hal': 'stopp en hal',
'stopp en halv': 'stopp en halv',
'stort sett': 'stort sett',
'så pass': 'så pass',
'takk i like måte': 'takk i like måte',
'takk, i like måte': 'takk i like måte',
'til pers': 'til pers',
'til punkt og prikke': 'til punkt og prikke',
'til spille': 'til spille',
'til spott og spe': 'til spott og spe',
'tort og svie': 'tort og svie',
'under fund': 'under fund',
'under vær med': 'under vær med',
'varg i veum': 'varg i veum',
'i ferd med': 'i ferd med',
'først og fremst': 'først og fremst',
'ved hjelp av': 'ved hjelp av',
'blott til lyst': 'blott til lyst',
'saga blott': 'saga blott',
'AV-': 'AV-',
'billed-': 'billed-',
'blomster-': 'blomster-',
'kles-': 'kles-',
'maksi-': 'maksi-',
'midi-': 'midi-',
'oligo-': 'oligo-',
'små-': 'små-',
'studenter-': 'studenter-',
'øyen-': 'øyen-',
'atsjo': 'atsjo',
'attmed': 'attmed',
'attom': 'attom',
'austenom': 'austenom',
'bakenfra': 'bakenfra',
'bakenom': 'bakenom',
'baki': 'baki',
'bl': 'bl',
'bortenom': 'bortenom',
'bortetter': 'bortetter',
'bortmed': 'bortmed',
'Deres': 'Deres',
'førtien': 'førtien',
'førtifem': 'førtifem',
'førtifire': 'førtifire',
'førtiåtte': 'førtiåtte',
'førtini': 'førtini',
'førtiseks': 'førtiseks',
'førtisju': 'førtisju',
'førtito': 'førtito',
'førtitre': 'førtitre',
'føy': 'føy',
'femtien': 'femtien',
'femtifem': 'femtifem',
'femtifire': 'femtifire',
'femtiåtte': 'femtiåtte',
'femtini': 'femtini',
'femtiseks': 'femtiseks',
'femtisju': 'femtisju',
'femtito': 'femtito',
'femtitre': 'femtitre',
'fillern': 'fillern',
'på folkemunne': 'på folkemunne',
'fyss': 'fyss',
'gudbevares': 'gudbevares',
'gudbevars': 'gudbevars',
'hjå': 'hjå',
'huhei': 'huhei',
'huhu': 'huhu',
'innigjennom': 'innigjennom',
'klingeliklang': 'klingeliklang',
'morna': 'morna',
'nittien': 'nittien',
'nittifem': 'nittifem',
'nittifire': 'nittifire',
'nittiåtte': 'nittiåtte',
'nittini': 'nittini',
'nittiseks': 'nittiseks',
'nittisju': 'nittisju',
'nittito': 'nittito',
'nittitre': 'nittitre',
'nordøstover': 'nordøstover',
'NRK': 'NRK',
'olé': 'olé',
'oppgjennom': 'oppgjennom',
'sekstien': 'sekstien',
'sekstifem': 'sekstifem',
'sekstifire': 'sekstifire',
'sekstiåtte': 'sekstiåtte',
'sekstini': 'sekstini',
'sekstiseks': 'sekstiseks',
'sekstisju': 'sekstisju',
'sekstito': 'sekstito',
'sekstitre': 'sekstitre',
'syttien': 'syttien',
'syttifem': 'syttifem',
'syttifire': 'syttifire',
'syttiåtte': 'syttiåtte',
'syttini': 'syttini',
'syttiseks': 'syttiseks',
'syttisju': 'syttisju',
'syttito': 'syttito',
'syttitre': 'syttitre',
'tjuefem': 'tjuefem',
'tjuefire': 'tjuefire',
'tjueåtte': 'tjueåtte',
'tjueni': 'tjueni',
'tjueseks': 'tjueseks',
'tjuesju': 'tjuesju',
'tjueto': 'tjueto',
'tjuetre': 'tjuetre',
'trettien': 'trettien',
'trettifem': 'trettifem',
'trettifire': 'trettifire',
'trettiåtte': 'trettiåtte',
'trettini': 'trettini',
'trettiseks': 'trettiseks',
'trettisju': 'trettisju',
'trettito': 'trettito',
'trettitre': 'trettitre',
'vis-a-vis': 'vis-a-vis',
'åh': 'åh',
'åttien': 'åttien',
'åttifem': 'åttifem',
'åttifire': 'åttifire',
'åttiåtte': 'åttiåtte',
'åttini': 'åttini',
'åttiseks': 'åttiseks',
'åttisju': 'åttisju',
'åttito': 'åttito',
'åttitre': 'åttitre',
'når': 'når',
'noe sterkt': 'noe sterkt',
'en sterk en': 'en sterk en',
'før': 'før',
'denne': 'denne',
'den': 'den',
'gud': 'gud',
'Gud': 'Gud',
'ill.': 'ill.',
'ass.gen.sekr.': 'ass.gen.sekr.',
'Pb.': 'Pb.',
'mann av huse': 'mann av huse',
'bingo': 'bingo',
'dump': 'dump',
'hokuspokus': 'hokuspokus',
'kliss': 'kliss',
'knekk': 'knekk',
'knips': 'knips',
'kvitt': 'kvitt',
'niks': 'niks',
'sorry': 'sorry',
'i ny og ne': 'i ny og ne',
'takket være': 'takket være',
'etter hvert som': 'etter hvert som',
'til tross for at': 'til tross for at',
'i de dage': 'i de dage',
'innendørs': 'innendørs',
'utendørs': 'utendørs',
'én': 'én',
'éi': 'én',
'ett': 'én',
'siden': 'siden',
'inntil': 'inntil',
'så': 'så',
'ombord': 'ombord',
'overbord': 'overbord',
'i drømme': 'i drømme',
'ene': 'ene',
'for moro skyld': 'for moro skyld',
'helledudenda': 'helledudenda',
'gudhjelpe': 'gudhjelpe',
'gud hjelpe': 'gud hjelpe',
'fy faen': 'fy faen',
'neida': 'neida',
'jada': 'jada',
'sjæl': 'sjæl',
'ha\'kke': 'ha\'kke',
'bortsett fra': 'bortsett fra',
'bill mrk': 'bill. mrk.',
'bill. mrk': 'bill. mrk.',
'bill. mrk.': 'bill. mrk.',
'efterpå': 'efterpå',
'ohoy': 'ohoy',
'mm': 'mm',
'mhm': 'mhm',
'høh': 'høh',
'denne': 'denne',
'dette': 'dette',
'disse': 'disse',
'adm.dir.': 'adm.dir.',
'm/s': 'm/s',
'km/t': 'km/t',
'eks.': 'eks.',
'i det fri': 'i det fri',
'TWh': 'TWh',
'TWh': 'TWh',
'M 87': 'M 87',
'no\'': 'no\'',
'den dag i dag': 'den dag i dag',
'A.': 'A.',
'B.': 'B.',
'C.': 'C.',
'D.': 'D.',
'E.': 'E.',
'F.': 'F.',
'G.': 'G.',
'H.': 'H.',
'I.': 'I.',
'J.': 'J.',
'K.': 'K.',
'L.': 'L.',
'M.': 'M.',
'N.': 'N.',
'O.': 'O.',
'P.': 'P.',
'Q.': 'Q.',
'R.': 'R.',
'S.': 'S.',
'T.': 'T.',
'U.': 'U.',
'V.': 'V.',
'W.': 'W.',
'X.': 'X.',
'Y.': 'Y.',
'Z.': 'Z.',
'Æ.': 'Æ.',
'Ø.': 'Ø.',
'Å.': 'Å.',
'år 2000': 'år 2000',
'noen': 'noen',
'noen': 'noen',
'noe': 'noe',
'noe': 'noe',
'åja': 'åja',
'he he': 'he he',
'hehe': 'hehe',
'cand.sosiol.': 'cand.sosiol.',
'stud.jur.': 'stud.jur.',
'stud.med.': 'stud.med.',
'stud.techn.': 'stud.techn.',
'stud.theol.': 'stud.theol.',
'på tvers': 'på tvers',
'liv laga': 'liv laga',
'm2': 'm2',
'm3': 'm3',
'km2': 'km2',
'på tide': 'på tide',
'til': 'til',
'grunnet': 'grunnet',
'utifra': 'utifra',
'okay': 'okay',
'godkveld': 'godkveld',
'værsågod': 'værsågod',
'n.br.': 'n.br.',
'IL': 'IL',
'HMS': 'HMS',
'Edv.': 'Edv.',
'eftf.': 'eftf.',
'kvm': 'kvm',
'Joh.': 'Joh.',
'Johs.': 'Johs.',
'på vegne av': 'på vegne av',
'til fjells': 'til fjells',
'på glid': 'på glid',
'på gli': 'på gli',
'til beins': 'til beins',
'til verks': 'til verks',
'til sengs': 'til sengs',
'hakk i hæl': 'hakk i hæl',
'til sjøs': 'til sjøs',
'til seters': 'til seters',
'til himmels': 'til himmels',
'til værs': 'til værs',
'til fots': 'til fots',
'til lands': 'til lands',
'til vanns': 'til vanns',
'til minnes': 'til minnes',
'til alters': 'til alters',
'til gards': 'til gards',
'til gårds': 'til gårds',
'innatt': 'innatt',
'I': 'I',
'I': 'I',
'V': 'V',
'V': 'V',
'X': 'X',
'C': 'C',
'C': 'C',
'O': 'O',
'M': 'M',
'hverandres': 'hverandres',
'avd.': 'avd.',
'red. anm.': 'red. anm.',
'viseadm.dir.': 'viseadm.dir.',
'KrF': 'KrF',
'Sp': 'Sp',
'sp.': 'Sp',
'Sp': 'Sp',
'FrP': 'FrP',
'SV': 'SV',
'RV': 'RV',
'rv.': 'RV',
'RV': 'RV',
'hokus pokus': 'hokus pokus',
'bare': 'bare',
'enda': 'enda',
'så': 'så',
'fly forbanna': 'fly forbanna',
'fly forbannet': 'fly forbannet',
'på avveier': 'på avveier',
'på avveger': 'på avveger',
'på avveie': 'på avveie',
'alle': 'alle',
'begge': 'begge',
'enhver': 'enhver',
'ingen': 'ingen',
'ingen': 'ingen',
'inga': 'inga',
'intet': 'intet',
'alt': 'alt',
'hvilken': 'hvilken',
'hvilke': 'hvilke',
'hvilket': 'hvilket',
'samtlige': 'samtlige',
'slikt': 'slikt',
'sånt': 'sånt',
'somt': 'somt',
'somme': 'somme',
'mand.': 'mand.',
'v.g.s.': 'v.g.s.',
'fung.': 'fung.',
'ccm': 'ccm',
'siv.ing.': 'siv.ing.',
'ex. phil.': 'ex. phil.',
'v.': 'v/',
'v/': 'v/',
'straks': 'straks',
'ditt og datt': 'ditt og datt',
'ditten og datten': 'ditten og datten',
'u-': 'u-',
'u-': 'u-',
'hokuspokus filiokus': 'hokuspokus filiokus',
'til gagns': 'til gagns',
'cand.juris': 'cand.juris',
'dr.juris': 'dr.juris',
'stud.juris': 'stud.juris',
'uff a meg': 'uff a meg',
'huff a meg': 'huff a meg',
'ASA': 'ASA',
'Dep': 'Dep',
'forts.': 'forts.',
'hoh.': 'hoh.',
'kb': 'kb',
'km/h': 'km/h',
'kto.': 'kto.',
'm.a.': 'm.a.',
'moh.': 'moh.',
'osb.': 'osb.',
'ref.': 'ref.',
'i vilden': 'i vilden',
'i vilden sky': 'i vilden sky',
'i villen': 'i villen',
'i villen sky': 'i villen sky',
'på fersken': 'på fersken',
'på rømmen': 'på rømmen',
'laden': 'laden',
'i ulag': 'i ulag',
'de skrå bredder': 'de skrå bredder',
'trøste og bære': 'trøste og bære',
'pro et contra': 'pro et contra',
'på direkten': 'på direkten',
'sus og dus': 'sus og dus',
'i eininga': 'i eininga',
'i einingen': 'i einingen',
'i eninga': 'i eninga',
'i eningen': 'i eningen',
'til felles': 'til felles',
'fengslig forvaring': 'fengslig forvaring',
'i forbifarten': 'i forbifarten',
'i forvegen': 'i forvegen',
'i forveien': 'i forveien',
'på frifot': 'på frifot',
'på lykke og fromme': 'på lykke og fromme',
'i glemmeboka': 'i glemmeboka',
'i glømmeboka': 'i glømmeboka',
'på hekta': 'på hekta',
'på latsiden': 'på latsiden',
'på latsida': 'på latsida',
'på likstrå': 'på likstrå',
'med velberådd hu': 'med velberådd hu',
'edder og galle': 'edder og galle',
'til rette': 'til rette',
'akk og ve': 'akk og ve',
'på nippet': 'på nippet',
'på nippen': 'på nippen',
'på nære nippet': 'på nære nippet',
'på nære nippen': 'på nære nippen',
'skitt au': 'skitt au',
'fra arilds tid': 'fra arilds tid',
'på borg': 'på borg',
'på ert': 'på ert',
'på ferde': 'på ferde',
'til føye': 'til føye',
'i hør og heim': 'i hør og heim',
'på tro og love': 'på tro og love',
'på lur': 'på lur',
'til skamme': 'til skamme',
'til syne': 'til syne',
'til pass': 'til pass',
'etter sigende': 'etter sigende',
'per stykk': 'per stykk',
'pr stykk': 'pr stykk',
'pr. stykk': 'pr. stykk',
'ansikts sved': 'ansikts sved',
'opp ad dage': 'opp ad dage',
'innadørs': 'innadørs',
'i tide og utide': 'i tide og utide',
'på kryss og tvers': 'på kryss og tvers',
'for fote': 'for fote',
'varsko': 'varsko',
'til veie': 'til veie',
'i våres': 'i våres',
'tilslørte bondepiker': 'tilslørte bondepiker',
'ennskjønt': 'ennskjønt',
'omennskjønt': 'omennskjønt',
'sia': 'sia',
'akva-': 'akva-',
'audio-': 'audio-',
'cyber-': 'cyber-',
'døds-': 'døds-',
'ento-': 'ento-',
'euro-': 'euro-',
'ikt': 'ikt',
'jepp': 'jepp',
'Ms.': 'Ms.',
'nebular-': 'nebular-',
'parade-': 'parade-',
'sær-': 'sær-',
'UV': 'UV',
'ANS': 'ANS',
'iht.': 'iht.',
'Sm': 'Sm',
'skau-': 'skau-',
'skog-': 'skog-',
'skogs-': 'skogs-',
'tjuesyv': 'tjuesyv',
'trettisyv': 'trettisyv',
'førtisyv': 'førtisyv',
'femtisyv': 'femtisyv',
'sekstisyv': 'sekstisyv',
'syttisyv': 'syttisyv',
'åttisyv': 'åttisyv',
'nittisyv': 'nittisyv',
'Mlle.': 'Mlle.',
'Mme.': 'Mme.',
'IKT': 'IKT',
'NOK': 'NOK',
'takk': 'takk',
'bu': 'bu',
'Gb': 'Gb',
'entre-': 'entre-',
'hundre og en': 'hundre og en',
'hundre og ei': 'hundre og en',
'hundre og ett': 'hundre og en',
'hundreogen': 'hundreogen',
'hundreogei': 'hundreogen',
'hundreogett': 'hundreogen',
'ole': 'ole',
'adoptiv-': 'adoptiv-',
'bonus-': 'bonus-',
'draps-': 'draps-',
'faen': 'faen'
}