# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005,  updated 20180627
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

ADVERBS_WORDFORMS = {
'à jour': ('à jour',),
'à la carte': ('à la carte',),
'à la grecque': ('à la grecque',),
'à la mode': ('à la mode',),
'òg': ('òg',),
'a cappella': ('a cappella',),
'a konto': ('a konto',),
'a posteriori': ('a posteriori',),
'a prima vista': ('a prima vista',),
'a priori': ('a priori',),
'a tempo': ('a tempo',),
'a verbo': ('a verbo',),
'a viso': ('a viso',),
'a vista': ('a vista',),
'ad absurdum': ('ad absurdum',),
'ad acta': ('ad acta',),
'ad hoc': ('ad hoc',),
'ad infinitum': ('ad infinitum',),
'ad notam': ('ad notam',),
'ad undas': ('ad undas',),
'adagio': ('adagio',),
'akkurat': ('akkurat',),
'aktenfor': ('aktenfor',),
'aktenfra': ('aktenfra',),
'akter': ('akter',),
'akterinn': ('akterinn',),
'akterover': ('akterover',),
'akterut': ('akterut',),
'al fresco': ('al fresco',),
'al secco': ('al secco',),
'aldeles': ('aldeles',),
'alders tid': ('alders tid',),
'aldri': ('aldri',),
'aleine': ('aleine',),
'alene': ('alene',),
'alias': ('alias',),
'allegretto': ('allegretto',),
'allegro': ('allegro',),
'aller': ('aller',),
'allerede': ('allerede',),
'allesteds': ('allesteds',),
'allestedsfra': ('allestedsfra',),
'allestedshen': ('allestedshen',),
'allikevel': ('allikevel',),
'alltid': ('alltid',),
'alltids': ('alltids',),
'alt': ('alt',),
'altfor': ('altfor',),
'altså': ('altså',),
'amok': ('amok',),
'an': ('an',),
'ana': ('ana',),
'andante': ('andante',),
'andantino': ('andantino',),
'andelsvis': ('andelsvis',),
'andfares': ('andfares',),
'andføttes': ('andføttes',),
'annensteds': ('annensteds',),
'annenstedsfra': ('annenstedsfra',),
'annenstedshen': ('annenstedshen',),
'annetsteds': ('annetsteds',),
'annetstedsfra': ('annetstedsfra',),
'annetstedsfra': ('annetstedsfra',),
'annetstedshen': ('annetstedshen',),
'anno': ('anno',),
'anslagsvis': ('anslagsvis',),
'anstendigvis': ('anstendigvis',),
'anstigende': ('anstigende',),
'antakeligvis': ('antakeligvis',),
'antydningsvis': ('antydningsvis',),
'apropos': ('apropos',),
'argende': ('argende',),
'at': ('at',),
'att': ('att',),
'attende': ('attende',),
'atter': ('atter',),
'attpåtil': ('attpåtil',),
'attåt': ('attåt',),
'au': ('au',),
'aust': ('aust',),
'austa': ('austa',),
'austafjells': ('austafjells',),
'av gårde': ('av gårde',),
'av sted': ('av sted',),
'avdelingsvis': ('avdelingsvis',),
'avdragsvis': ('avdragsvis',),
'avhendes': ('avhendes',),
'avhends': ('avhends',),
'avsatsvis': ('avsatsvis',),
'babord': ('babord',),
'bakfra': ('bakfra',),
'bakk': ('bakk',),
'baklengs': ('baklengs',),
'bakover': ('bakover',),
'bakut': ('bakut',),
'bare': ('bare',),
'bataljonsvis': ('bataljonsvis',),
'beint fram': ('beint fram',),
'bekende': ('bekende',),
'belgende': ('belgende',),
'bent fram': ('bent fram',),
'bent frem': ('bent frem',),
'betids': ('betids',),
'bi': ('bi',),
'bidevind': ('bidevind',),
'bis': ('bis',),
'bitevis': ('bitevis',),
'bitte': ('bitte',),
'bitterlig': ('bitterlig',),
'blanko': ('blanko',),
'blidelig': ('blidelig',),
'blikk': ('blikk',),
'blikkende': ('blikkende',),
'blottende': ('blottende',),
'bom': ('bom',),
'bommende': ('bommende',),
'bona fide': ('bona fide',),
'bort': ('bort',),
'borte': ('borte',),
'bortimot': ('bortimot',),
'brennfort': ('brennfort',),
'bråtevis': ('bråtevis',),
'bums': ('bums',),
'buntevis': ('buntevis',),
'buntvis': ('buntvis',),
'bus': ('bus',),
'bygdimellom': ('bygdimellom',),
'cantabile': ('cantabile',),
'cf': ('cf',),
'cif': ('cif',),
'cirka': ('cirka',),
'comme il faut': ('comme il faut',),
'crescendo': ('crescendo',),
'da': ('da',),
'dagevis': ('dagevis',),
'dagstøtt': ('dagstøtt',),
'dakapo': ('dakapo',),
'dam': ('dam',),
'dammende': ('dammende',),
'dann': ('dann',),
'de facto': ('de facto',),
'de jure': ('de jure',),
'decrescendo': ('decrescendo',),
'delkredere': ('delkredere',),
'dels': ('dels',),
'delvis': ('delvis',),
'den gang': ('den gang',),
'der': ('der',),
'der borte': ('der borte',),
'der hen': ('der hen',),
'der inne': ('der inne',),
'der nede': ('der nede',),
'der oppe': ('der oppe',),
'der ute': ('der ute',),
'derav': ('derav',),
'deretter': ('deretter',),
'derfor': ('derfor',),
'derfra': ('derfra',),
'deri': ('deri',),
'deriblant': ('deriblant',),
'derifra': ('derifra',),
'derimot': ('derimot',),
'dermed': ('dermed',),
'dernest': ('dernest',),
'derom': ('derom',),
'derpå': ('derpå',),
'dertil': ('dertil',),
'derved': ('derved',),
'dess': ('dess',),
'dessuten': ('dessuten',),
'dessverre': ('dessverre',),
'desto': ('desto',),
'diminuendo': ('diminuendo',),
'dis': ('dis',),
'dit': ('dit',),
'dit hen': ('dit hen',),
'ditover': ('ditover',),
'ditto': ('ditto',),
'dog': ('dog',),
'dolce': ('dolce',),
'dorgende': ('dorgende',),
'dryppende': ('dryppende',),
'drøssevis': ('drøssevis',),
'dus': ('dus',),
'dusinvis': ('dusinvis',),
'dyende': ('dyende',),
'døgnvis': ('døgnvis',),
'dønn': ('dønn',),
'dørg': ('dørg',),
'dørgende': ('dørgende',),
'dørimellom': ('dørimellom',),
'ei': ('ei',),
'eiende': ('eiende',),
'einkom': ('einkom',),
'eitrende': ('eitrende',),
'eks': ('eks',),
'eksempelvis': ('eksempelvis',),
'eksklusiv': ('eksklusiv',),
'eksklusive': ('eksklusive',),
'ekspress': ('ekspress',),
'ekstempore': ('ekstempore',),
'ellers': ('ellers',),
'en': ('en',),
'en bloc': ('en bloc',),
'en detail': ('en detail',),
'en face': ('en face',),
'en gros': ('en gros',),
'en masse': ('en masse',),
'en passant': ('en passant',),
'en profil': ('en profil',),
'en suite': ('en suite',),
'enda': ('enda',),
'endatil': ('endatil',),
'ende': ('ende',),
'ende fram': ('ende fram',),
'ende frem': ('ende frem',),
'ender': ('ender',),
'endog': ('endog',),
'ene': ('ene',),
'engang': ('engang',),
'enkeltvis': ('enkeltvis',),
'enkom': ('enkom',),
'enn': ('enn',),
'ennå': ('ennå',),
'ensteds': ('ensteds',),
'eo ipso': ('eo ipso',),
'ergo': ('ergo',),
'et cetera': ('et cetera',),
'etappevis': ('etappevis',),
'etsteds': ('etsteds',),
'etterhånden': ('etterhånden',),
'etterpå': ('etterpå',),
'etterskottsvis': ('etterskottsvis',),
'etterskuddsvis': ('etterskuddsvis',),
'ex animo': ('ex animo',),
'ex auditorio': ('ex auditorio',),
'ex cathedra': ('ex cathedra',),
'ex officio': ('ex officio',),
'exit': ('exit',),
'f.o.r.': ('f.o.r.',),
'fas': ('fas',),
'fatt': ('fatt',),
'feil': ('feil',),
'femti-femti': ('femti-femti',),
'fifty-fifty': ('fifty-fifty',),
'flekkevis': ('flekkevis',),
'flokkevis': ('flokkevis',),
'fluks': ('fluks',),
'fluksens': ('fluksens',),
'flunkende': ('flunkende',),
'flust': ('flust',),
'fly': ('fly',),
'fløyten': ('fløyten',),
'fob': ('fob',),
'for': ('for',),
'for hånden': ('for hånden',),
'for lengst': ('for lengst',),
'for resten': ('for resten',),
'for så vidt': ('for så vidt',),
'for tida': ('for tida',),
'for tiden': ('for tiden',),
'for visst': ('for visst',),
'for øvrig': ('for øvrig',),
'fordevind': ('fordevind',),
'fordum': ('fordum',),
'fore': ('fore',),
'forfra': ('forfra',),
'forhakkende': ('forhakkende',),
'forholdsvis': ('forholdsvis',),
'forhåpentlig': ('forhåpentlig',),
'forhåpentligvis': ('forhåpentligvis',),
'forlengs': ('forlengs',),
'formelig': ('formelig',),
'forover': ('forover',),
'forresten': ('forresten',),
'forsøksvis': ('forsøksvis',),
'fort': ('fort',),
'fortere': ('fort',),
'fortest': ('fort',),
'forte': ('forte',),
'fortfarende': ('fortfarende',),
'fortissimo': ('fortissimo',),
'fortrinnsvis': ('fortrinnsvis',),
'forut': ('forut',),
'fra borde': ('fra borde',),
'fram': ('fram',),
'framføre': ('framføre',),
'framleis': ('framleis',),
'framlengs': ('framlengs',),
'framme': ('framme',),
'framstupes': ('framstupes',),
'framstups': ('framstups',),
'franko': ('franko',),
'free on board': ('free on board',),
'free on rail': ('free on rail',),
'frem': ('frem',),
'fremad': ('fremad',),
'fremdeles': ('fremdeles',),
'fremlengs': ('fremlengs',),
'fremme': ('fremme',),
'fremstupes': ('fremstupes',),
'fremstups': ('fremstups',),
'furioso': ('furioso',),
'fylkesvis': ('fylkesvis',),
'følgelig': ('følgelig',),
'føre': ('føre',),
'først': ('først',),
'ganske': ('ganske',),
'gardimellom': ('gardimellom',),
'gatelangs': ('gatelangs',),
'gid': ('gid',),
'givetvis': ('givetvis',),
'gjerne': ('gjerne',),
'gladelig': ('gladelig',),
'glimtvis': ('glimtvis',),
'glissando': ('glissando',),
'glugg': ('glugg',),
'gorr': ('gorr',),
'gorrende': ('gorrende',),
'gradvis': ('gradvis',),
'grandioso': ('grandioso',),
'granngivelig': ('granngivelig',),
'grassat': ('grassat',),
'grave': ('grave',),
'gruppevis': ('gruppevis',),
'gudskjelov': ('gudskjelov',),
'gullende': ('gullende',),
'gørr': ('gørr',),
'gørrende': ('gørrende',),
'hakk': ('hakk',),
'hakkende': ('hakkende',),
'halvveges': ('halvveges',),
'halvvegs': ('halvvegs',),
'halvveis': ('halvveis',),
'haugevis': ('haugevis',),
'heden': ('heden',),
'heim': ('heim',),
'heim att': ('heim att',),
'heiman': ('heiman',),
'heime': ('heime',),
'heimefra': ('heimefra',),
'heimetter': ('heimetter',),
'heimom': ('heimom',),
'heimover': ('heimover',),
'heldigvis': ('heldigvis',),
'heller': ('heller',),
'helst': ('helst',),
'hen': ('hen',),
'henholdsvis': ('henholdsvis',),
'henne': ('henne',),
'her': ('her',),
'herav': ('herav',),
'heretter': ('heretter',),
'herfra': ('herfra',),
'heri': ('heri',),
'heriblant': ('heriblant',),
'herifra': ('herifra',),
'herigjennom': ('herigjennom',),
'herimot': ('herimot',),
'hermed': ('hermed',),
'herom': ('herom',),
'herover': ('herover',),
'herpå': ('herpå',),
'herre': ('herre',),
'hersens': ('hersens',),
'hertil': ('hertil',),
'herunder': ('herunder',),
'herved': ('herved',),
'himlende': ('himlende',),
'hisset': ('hisset',),
'hist': ('hist',),
'hit': ('hit',),
'hitover': ('hitover',),
'hittil': ('hittil',),
'hjem': ('hjem',),
'hjemad': ('hjemad',),
'hjemetter': ('hjemetter',),
'hjemme': ('hjemme',),
'hjemmefra': ('hjemmefra',),
'hjemom': ('hjemom',),
'hjemover': ('hjemover',),
'hodekulls': ('hodekulls',),
'hodestupes': ('hodestupes',),
'hodestups': ('hodestups',),
'hoggende': ('hoggende',),
'honoris causa': ('honoris causa',),
'hoppende': ('hoppende',),
'hulter': ('hulter',),
'hundretusenvis': ('hundretusenvis',),
'hundrevis': ('hundrevis',),
'hurra-meg-rundt': ('hurra-meg-rundt',),
'husimellom': ('husimellom',),
'hvi': ('hvi',),
'hvor': ('hvor',),
'hvor hen': ('hvor hen',),
'hvorav': ('hvorav',),
'hvordan': ('hvordan',),
'hvoretter': ('hvoretter',),
'hvorfor': ('hvorfor',),
'hvorfra': ('hvorfra',),
'hvori': ('hvori',),
'hvoriblant': ('hvoriblant',),
'hvorimot': ('hvorimot',),
'hvorledes': ('hvorledes',),
'hvormed': ('hvormed',),
'hvorom': ('hvorom',),
'hvorpå': ('hvorpå',),
'hånt': ('hånt',),
'høylig': ('høylig',),
'høyst': ('høyst',),
'i aften': ('i aften',),
'i aftes': ('i aftes',),
'i alle fall': ('i alle fall',),
'i dag': ('i dag',),
'i fjor': ('i fjor',),
'i fleng': ('i fleng',),
'i forfjor': ('i forfjor',),
'i forgårs': ('i forgårs',),
'i gjerde': ('i gjerde',),
'i gjære': ('i gjære',),
'i grunnen': ('i grunnen',),
'i går': ('i går',),
'i hende': ('i hende',),
'i hjel': ('i hjel',),
'i hug': ('i hug',),
'i huleste': ('i huleste',),
'i stedet': ('i stedet',),
'iallfall': ('iallfall',),
'ibidem': ('ibidem',),
'id est': ('id est',),
'igjen': ('igjen',),
'ikke': ('ikke',),
'ildende': ('ildende',),
'ille': ('ille',),
'imens': ('imens',),
'imidlertid': ('imidlertid',),
'in absentia': ('in absentia',),
'in absurdum': ('in absurdum',),
'in blanko': ('in blanko',),
'in casu': ('in casu',),
'in contumaciam': ('in contumaciam',),
'in corpore': ('in corpore',),
'in duplo': ('in duplo',),
'in extenso': ('in extenso',),
'in flagranti': ('in flagranti',),
'in honorem': ('in honorem',),
'in medias res': ('in medias res',),
'in memoriam': ('in memoriam',),
'in mente': ('in mente',),
'in natura': ('in natura',),
'in nuce': ('in nuce',),
'in persona': ('in persona',),
'in quarto': ('in quarto',),
'in saldo': ('in saldo',),
'in salvo': ('in salvo',),
'in situ': ('in situ',),
'in solidum': ('in solidum',),
'in spe': ('in spe',),
'in triplo': ('in triplo',),
'in vitro': ('in vitro',),
'in vivo': ('in vivo',),
'ingenlunde': ('ingenlunde',),
'ingensteds': ('ingensteds',),
'inklusiv': ('inklusiv',),
'inklusive': ('inklusive',),
'inkognito': ('inkognito',),
'inn': ('inn',),
'innad': ('innad',),
'innafra': ('innafra',),
'innalands': ('innalands',),
'innaskjærs': ('innaskjærs',),
'inne': ('inne',),
'innenat': ('innenat',),
'innenfra': ('innenfra',),
'innenlands': ('innenlands',),
'innenskjærs': ('innenskjærs',),
'innledningsvis': ('innledningsvis',),
'innleiingsvis': ('innleiingsvis',),
'innomhus': ('innomhus',),
'isteden': ('isteden',),
'især': ('især',),
'item': ('item',),
'ja menn': ('ja menn',),
'ja så menn': ('ja så menn',),
'jammen': ('jammen',),
'jamnlig': ('jamnlig',),
'jamsides': ('jamsides',),
'jamt over': ('jamt over',),
'jamvel': ('jamvel',),
'jaså': ('jaså',),
'jevnlig': ('jevnlig',),
'jevnsides': ('jevnsides',),
'jevnt over': ('jevnt over',),
'jo menn': ('jo menn',),
'jommen': ('jommen',),
'just': ('just',),
'kanon': ('kanon',),
'kanskje': ('kanskje',),
'kav': ('kav',),
'kavende': ('kavende',),
'kilovis': ('kilovis',),
'klin': ('klin',),
'klink': ('klink',),
'klinkende': ('klinkende',),
'klokelig': ('klokelig',),
'knakende': ('knakende',),
'knapt': ('knapt',),
'knasende': ('knasende',),
'knekkende': ('knekkende',),
'knøtrende': ('knøtrende',),
'knøttende': ('knøttende',),
'kolende': ('kolende',),
'kul': ('kul',),
'kuli': ('kuli',),
'kun': ('kun',),
'kvartalsvis': ('kvartalsvis',),
'kvekk': ('kvekk',),
'kølende': ('kølende',),
'lagerfritt': ('lagerfritt',),
'lagom': ('lagom',),
'lagvis': ('lagvis',),
'landimellom': ('landimellom',),
'landverts': ('landverts',),
'langt': ('langt',),
'lenger': ('langt',),
'lengst': ('langt',),
'langveges': ('langveges',),
'langvegesfra': ('langvegesfra',),
'langvegs': ('langvegs',),
'langvegsfra': ('langvegsfra',),
'langveis': ('langveis',),
'langveisfra': ('langveisfra',),
'larghetto': ('larghetto',),
'largo': ('largo',),
'lassevis': ('lassevis',),
'legato': ('legato',),
'leilighetsvis': ('leilighetsvis',),
'lell': ('lell',),
'lenge': ('lenge',),
'lenger': ('lenge',),
'lengst': ('lenge',),
'lenger': ('lenger',),
'liddelig': ('liddelig',),
'like': ('like',),
'likeledes': ('likeledes',),
'likeså': ('likeså',),
'likevel': ('likevel',),
'likså': ('likså',),
'lissom': ('lissom',),
'litervis': ('litervis',),
'livende': ('livende',),
'lovformelig': ('lovformelig',),
'lovlig': ('lovlig',),
'lukt': ('lukt',),
'lut': ('lut',),
'luta': ('luta',),
'lutende': ('lutende',),
'lykkeligvis': ('lykkeligvis',),
'lynfort': ('lynfort',),
'lys': ('lys',),
'maestoso': ('maestoso',),
'mala fide': ('mala fide',),
'malapropos': ('malapropos',),
'mannemellom': ('mannemellom',),
'massevis': ('massevis',),
'med rette': ('med rette',),
'medio': ('medio',),
'medium': ('medium',),
'medsols': ('medsols',),
'medstrøms': ('medstrøms',),
'meget': ('meget',),
'mengdevis': ('mengdevis',),
'metervis': ('metervis',),
'mezzoforte': ('mezzoforte',),
'midsommers': ('midsommers',),
'midt': ('midt',),
'midtfjords': ('midtfjords',),
'midtskips': ('midtskips',),
'midtsommers': ('midtsommers',),
'midtveges': ('midtveges',),
'midtvegs': ('midtvegs',),
'midtveis': ('midtveis',),
'midtvinters': ('midtvinters',),
'midvinters': ('midvinters',),
'milevis': ('milevis',),
'millionvis': ('millionvis',),
'min sann': ('min sann',),
'min sant': ('min sant',),
'min santen': ('min santen',),
'minus': ('minus',),
'mo': ('mo',),
'molto': ('molto',),
'motsols': ('motsols',),
'motstrøms': ('motstrøms',),
'mukk': ('mukk',),
'mukkende': ('mukkende',),
'muligens': ('muligens',),
'muligvis': ('muligvis',),
'murende': ('murende',),
'musende': ('musende',),
'mutters': ('mutters',),
'månedsvis': ('månedsvis',),
'naggende': ('naggende',),
'naturligvis': ('naturligvis',),
'nauende': ('nauende',),
'navnlig': ('navnlig',),
'ned': ('ned',),
'nedad': ('nedad',),
'nedatil': ('nedatil',),
'nede': ('nede',),
'nedentil': ('nedentil',),
'nedenunder': ('nedenunder',),
'nedstrøms': ('nedstrøms',),
'neigu': ('neigu',),
'neimen': ('neimen',),
'nemlig': ('nemlig',),
'neppe': ('neppe',),
'nesegrus': ('nesegrus',),
'nest': ('nest',),
'nesten': ('nesten',),
'nettopp': ('nettopp',),
'noenlunde': ('noenlunde',),
'noensinne': ('noensinne',),
'noensteds': ('noensteds',),
'nok': ('nok',),
'noksom': ('noksom',),
'nokså': ('nokså',),
'non stop': ('non stop',),
'nonstop': ('nonstop',),
'nord': ('nord',),
'nordafjells': ('nordafjells',),
'nordaust': ('nordaust',),
'nordenfjells': ('nordenfjells',),
'nordost': ('nordost',),
'nordvest': ('nordvest',),
'nordøst': ('nordøst',),
'notabene': ('notabene',),
'nyss': ('nyss',),
'nå': ('nå',),
'når': ('når',),
'nåvel': ('nåvel',),
'nær': ('nær',),
'nærere': ('nær',),
'nærmere': ('nær',),
'nærest': ('nær',),
'nærmest': ('nær',),
'nære': ('nære',),
'nærere': ('nærere',),
'nærest': ('nærest',),
'nærme': ('nærme',),
'nærmere': ('nærmere',),
'nærmest': ('nærmest',),
'nødig': ('nødig',),
'nødigere': ('nødig',),
'nødigst': ('nødig',),
'nødvendigvis': ('nødvendigvis',),
'offside': ('offside',),
'ofte': ('ofte',),
'oftere': ('ofte',),
'oftest': ('ofte',),
'også': ('også',),
'om att': ('om att',),
'om igjen': ('om igjen',),
'omme': ('omme',),
'omsider': ('omsider',),
'omsonst': ('omsonst',),
'omtrent': ('omtrent',),
'onnimellom': ('onnimellom',),
'opp': ('opp',),
'opp att': ('opp att',),
'opp ned': ('opp ned',),
'oppad': ('oppad',),
'oppe': ('oppe',),
'oppstrøms': ('oppstrøms',),
'ost': ('ost',),
'ovabords': ('ovabords',),
'ovatil': ('ovatil',),
'oven': ('oven',),
'ovenbords': ('ovenbords',),
'oventil': ('oventil',),
'overalt': ('overalt',),
'overens': ('overens',),
'overhodet': ('overhodet',),
'overlag': ('overlag',),
'overmorgen': ('overmorgen',),
'overmåte': ('overmåte',),
'overvettes': ('overvettes',),
'pakkende': ('pakkende',),
'pal': ('pal',),
'par avion': ('par avion',),
'par excellence': ('par excellence',),
'parlando': ('parlando',),
'pars pro toto': ('pars pro toto',),
'partout': ('partout',),
'parvis': ('parvis',),
'per capita': ('per capita',),
'pianissimo': ('pianissimo',),
'piano': ('piano',),
'pinende': ('pinende',),
'pinnende': ('pinnende',),
'pist': ('pist',),
'pizzicato': ('pizzicato',),
'pladask': ('pladask',),
'plent': ('plent',),
'plenty': ('plenty',),
'pluss': ('pluss',),
'porsjonsvis': ('porsjonsvis',),
'portamento': ('portamento',),
'portato': ('portato',),
'post festum': ('post festum',),
'post meridiem': ('post meridiem',),
'post mortem': ('post mortem',),
'prestissimo': ('prestissimo',),
'presto': ('presto',),
'prima vista': ('prima vista',),
'primo': ('primo',),
'pro anno': ('pro anno',),
'pro persona': ('pro persona',),
'pro tempore': ('pro tempore',),
'proforma': ('proforma',),
'prompt': ('prompt',),
'prompte': ('prompte',),
'proppende': ('proppende',),
'prosentvis': ('prosentvis',),
'pukka': ('pukka',),
'puljevis': ('puljevis',),
'punktvis': ('punktvis',),
'pyton': ('pyton',),
'pø om pø': ('pø om pø',),
'quantum satis': ('quantum satis',),
'rammende': ('rammende',),
'rangsøles': ('rangsøles',),
'rasende': ('rasende',),
'ratevis': ('ratevis',),
'ratt': ('ratt',),
'rav': ('rav',),
'ravende': ('ravende',),
'reint': ('reint',),
'rent': ('rent',),
'respektive': ('respektive',),
'rettsøles': ('rettsøles',),
'reverenter': ('reverenter',),
'riktignok': ('riktignok',),
'rimeligvis': ('rimeligvis',),
'ringside': ('ringside',),
'rispende': ('rispende',),
'ritardando': ('ritardando',),
'riv': ('riv',),
'rubato': ('rubato',),
'ruskende': ('ruskende',),
'rykkevis': ('rykkevis',),
'saktelig': ('saktelig',),
'saktens': ('saktens',),
'sammen': ('sammen',),
'sammesteds': ('sammesteds',),
'sammestedsfra': ('sammestedsfra',),
'samstundes': ('samstundes',),
'samt': ('samt',),
'sann': ('sann',),
'sannelig': ('sannelig',),
'sannsynligvis': ('sannsynligvis',),
'sans phrase': ('sans phrase',),
'scilicet': ('scilicet',),
'seinhøstes': ('seinhøstes',),
'senhøstes': ('senhøstes',),
'sia': ('sia',),
'sic': ('sic',),
'sidelangs': ('sidelangs',),
'sidelengs': ('sidelengs',),
'siden': ('siden',),
'sideveges': ('sideveges',),
'sidevegs': ('sidevegs',),
'sideveis': ('sideveis',),
'sikkerlig': ('sikkerlig',),
'silde': ('silde',),
'simpelthen': ('simpelthen',),
'sine anno': ('sine anno',),
'sistpå': ('sistpå',),
'sjelden': ('sjelden',),
'sjøleies': ('sjøleies',),
'sjøverts': ('sjøverts',),
'skeis': ('skeis',),
'skiftevis': ('skiftevis',),
'skita': ('skita',),
'skjøns': ('skjøns',),
'skogleies': ('skogleies',),
'skokkevis': ('skokkevis',),
'skrevs': ('skrevs',),
'skrittvis': ('skrittvis',),
'skrås': ('skrås',),
'skyllende': ('skyllende',),
'skåldende': ('skåldende',),
'slettes': ('slettes',),
'sluttelig': ('sluttelig',),
'smekk': ('smekk',),
'smellende': ('smellende',),
'småningom': ('småningom',),
'snart': ('snart',),
'snarere': ('snart',),
'snarest': ('snart',),
'sneisevis': ('sneisevis',),
'snesevis': ('snesevis',),
'snuft': ('snuft',),
'snupt': ('snupt',),
'snyt': ('snyt',),
'snyta': ('snyta',),
'snyte': ('snyte',),
'solo': ('solo',),
'sommerstid': ('sommerstid',),
'sommesteds': ('sommesteds',),
'spenna': ('spenna',),
'spent': ('spent',),
'spika': ('spika',),
'spikende': ('spikende',),
'spildrende': ('spildrende',),
'spill': ('spill',),
'splinter': ('splinter',),
'splitter': ('splitter',),
'sporenstreks': ('sporenstreks',),
'sprangvis': ('sprangvis',),
'sprell': ('sprell',),
'sprut': ('sprut',),
'sprutende': ('sprutende',),
'sprøyte': ('sprøyte',),
'stakkato': ('stakkato',),
'stapp': ('stapp',),
'stappa': ('stappa',),
'stappende': ('stappende',),
'staurende': ('staurende',),
'stedvis': ('stedvis',),
'steika': ('steika',),
'stein': ('stein',),
'steinsens': ('steinsens',),
'stokk': ('stokk',),
'stokkende': ('stokkende',),
'straks': ('straks',),
'stringendo': ('stringendo',),
'stummende': ('stummende',),
'stundimellom': ('stundimellom',),
'stundom': ('stundom',),
'stundomtil': ('stundomtil',),
'stupende': ('stupende',),
'styggelig': ('styggelig',),
'styggende': ('styggende',),
'stykkevis': ('stykkevis',),
'styrbord': ('styrbord',),
'støtt': ('støtt',),
'støtvis': ('støtvis',),
'støytvis': ('støytvis',),
'sub rosa': ('sub rosa',),
'summa summarum': ('summa summarum',),
'surr': ('surr',),
'svinaktig': ('svinaktig',),
'svint': ('svint',),
'svintere': ('svint',),
'svintest': ('svint',),
'syd': ('syd',),
'sydost': ('sydost',),
'sydvest': ('sydvest',),
'sydøst': ('sydøst',),
'synderlig': ('synderlig',),
'så': ('så',),
'så pass': ('så pass',),
'sågar': ('sågar',),
'således': ('således',),
'såleis': ('såleis',),
'såpass': ('såpass',),
'såre': ('såre',),
'særdeles': ('særdeles',),
'særs': ('særs',),
'søkk': ('søkk',),
'søkkende': ('søkkende',),
'sønder': ('sønder',),
'sønna': ('sønna',),
'sønnafjells': ('sønnafjells',),
'sønnenfjells': ('sønnenfjells',),
'sør': ('sør',),
'søraust': ('søraust',),
'sørvest': ('sørvest',),
'sørøst': ('sørøst',),
'takimellom': ('takimellom',),
'takomtil': ('takomtil',),
'temmelig': ('temmelig',),
'ti': ('ti',),
'tidligdags': ('tidligdags',),
'tidsnok': ('tidsnok',),
'tidvis': ('tidvis',),
'til like': ('til like',),
'tilbake': ('tilbake',),
'tilfeldigvis': ('tilfeldigvis',),
'tilmed': ('tilmed',),
'tilnærmelsesvis': ('tilnærmelsesvis',),
'timevis': ('timevis',),
'titt': ('titt',),
'tiere': ('titt',),
'tiest': ('titt',),
'tjokkende': ('tjokkende',),
'tomreipes': ('tomreipes',),
'tott': ('tott',),
'trill': ('trill',),
'trillende': ('trillende',),
'trinnvis': ('trinnvis',),
'troppevis': ('troppevis',),
'troppo': ('troppo',),
'troppsvis': ('troppsvis',),
'trutt': ('trutt',),
'turevis': ('turevis',),
'turvis': ('turvis',),
'tusenvis': ('tusenvis',),
'tvers': ('tvers',),
'tvert': ('tvert',),
'tydeligvis': ('tydeligvis',),
'tålig': ('tålig',),
'tønnevis': ('tønnevis',),
'ufravendt': ('ufravendt',),
'ugjerne': ('ugjerne',),
'uheldigvis': ('uheldigvis',),
'ukevis': ('ukevis',),
'ultimo': ('ultimo',),
'ulykkeligvis': ('ulykkeligvis',),
'uløyves': ('uløyves',),
'undas': ('undas',),
'underhånden': ('underhånden',),
'undertiden': ('undertiden',),
'undervegs': ('undervegs',),
'underveis': ('underveis',),
'unntakelsesvis': ('unntakelsesvis',),
'unntaksvis': ('unntaksvis',),
'ustyggelig': ('ustyggelig',),
'ut': ('ut',),
'utaboks': ('utaboks',),
'utad': ('utad',),
'utalands': ('utalands',),
'utbygdes': ('utbygdes',),
'utdragsvis': ('utdragsvis',),
'ute': ('ute',),
'utelukkende': ('utelukkende',),
'utenat': ('utenat',),
'utenboks': ('utenboks',),
'utenlands': ('utenlands',),
'utomhus': ('utomhus',),
'uvegerlig': ('uvegerlig',),
'uviselig': ('uviselig',),
'uvislig': ('uvislig',),
'va banque': ('va banque',),
'vanligvis': ('vanligvis',),
'vann': ('vann',),
'ved like': ('ved like',),
'veggimellom': ('veggimellom',),
'vekk': ('vekk',),
'vekke': ('vekke',),
'vekselvis': ('vekselvis',),
'vel': ('vel',),
'vest': ('vest',),
'vesta': ('vesta',),
'vestafjells': ('vestafjells',),
'vestenfjells': ('vestenfjells',),
'vibrato': ('vibrato',),
'vice versa': ('vice versa',),
'vide': ('vide',),
'viden': ('viden',),
'vinterstid': ('vinterstid',),
'viselig': ('viselig',),
'visselig': ('visselig',),
'visst': ('visst',),
'visstnok': ('visstnok',),
'vivace': ('vivace',),
'vonlig': ('vonlig',),
'vonom': ('vonom',),
'vonoms': ('vonoms',),
'vrangsøles': ('vrangsøles',),
'ytterlig': ('ytterlig',),
'åkkesom': ('åkkesom',),
'årevis': ('årevis',),
'årlig års': ('årlig års',),
'åssen': ('åssen',),
'ørende': ('ørende',),
'øst': ('øst',),
'østa': ('østa',),
'østafjells': ('østafjells',),
'østenfjells': ('østenfjells',),
'øyensynlig': ('øyensynlig',),
'antageligvis': ('antageligvis',),
'overimorgen': ('overimorgen',),
'unntagelsesvis': ('unntagelsesvis',),
'sist': ('sist',),
'stetse': ('stetse',),
'stikk': ('stikk',),
'storlig': ('storlig',),
'still going strong': ('still going strong',),
'til og med': ('til og med',),
'i hu': ('i hu',),
'dengang': ('dengang',),
'derborte': ('derborte',),
'derefter': ('derefter',),
'derinne': ('derinne',),
'dernede': ('dernede',),
'deromkring': ('deromkring',),
'etterhvert': ('etterhvert',),
'fordømrade': ('fordømrade',),
'foreksempel': ('foreksempel',),
'forsåvidt': ('forsåvidt',),
'forøvrig': ('forøvrig',),
'herefter': ('herefter',),
'hvertfall': ('hvertfall',),
'idag': ('idag',),
'ifjor': ('ifjor',),
'i gang': ('i gang',),
'igår': ('igår',),
'ihvertfall': ('ihvertfall',),
'ikveld': ('ikveld',),
'iland': ('iland',),
'imorgen': ('imorgen',),
'imøte': ('imøte',),
'inatt': ('inatt',),
'iorden': ('iorden',),
'istand': ('istand',),
'istedet': ('istedet',),
'javisst': ('javisst',),
'neivisst': ('neivisst',),
'fortsatt': ('fortsatt',),
'slik': ('slik',),
'sådan': ('sådan',),
'sånn': ('sånn',),
'for eksempel': ('for eksempel',),
'fra barnsbein av': ('fra barnsbein av',),
'fra barnsben av': ('fra barnsben av',),
'fra oven': ('fra oven',),
'på vidvanke': ('på vidvanke',),
'rubb og stubb': ('rubb og stubb',),
'akterifra': ('akterifra',),
'andsynes': ('andsynes',),
'austenom': ('austenom',),
'avslutningsvis': ('avslutningsvis',),
'bøttevis': ('bøttevis',),
'bakenfra': ('bakenfra',),
'bakenom': ('bakenom',),
'baki': ('baki',),
'bedriftsvis': ('bedriftsvis',),
'beklageligvis': ('beklageligvis',),
'benveges': ('benveges',),
'benveies': ('benveies',),
'bistrende': ('bistrende',),
'bitvis': ('bitvis',),
'bortenom': ('bortenom',),
'bortmed': ('bortmed',),
'bråfort': ('bråfort',),
'bunkevis': ('bunkevis',),
'ca': ('ca',),
'derigjennom': ('derigjennom',),
'derover': ('derover',),
'dessuaktet': ('dessuaktet',),
'distriktsvis': ('distriktsvis',),
'doloroso': ('doloroso',),
'erfaringsvis': ('erfaringsvis',),
'falskelig': ('falskelig',),
'fjellstøtt': ('fjellstøtt',),
'flekkvis': ('flekkvis',),
'flerveis': ('flerveis',),
'forholdvis': ('forholdvis',),
'fornemmelig': ('fornemmelig',),
'fornuftigvis': ('fornuftigvis',),
'forsiktigvis': ('forsiktigvis',),
'forskottsvis': ('forskottsvis',),
'forskuddsvis': ('forskuddsvis',),
'forutsetningsvis': ('forutsetningsvis',),
'framt': ('framt',),
'fremt': ('fremt',),
'godhetsfullt': ('godhetsfullt',),
'hvortil': ('hvortil',),
'hvorunder': ('hvorunder',),
'hvorved': ('hvorved',),
'iltrende': ('iltrende',),
'innatil': ('innatil',),
'innentil': ('innentil',),
'innigjennom': ('innigjennom',),
'kilometervis': ('kilometervis',),
'klattvis': ('klattvis',),
'kolonnevis': ('kolonnevis',),
'kommunevis': ('kommunevis',),
'listelig': ('listelig',),
'lusende': ('lusende',),
'mildelig': ('mildelig',),
'milevidt': ('milevidt',),
'nordøstover': ('nordøstover',),
'ovenover': ('ovenover',),
'periodevis': ('periodevis',),
'pirende': ('pirende',),
'priori': ('priori',),
'rettnok': ('rettnok',),
'rykkvis': ('rykkvis',),
'sørøstover': ('sørøstover',),
'sørvestover': ('sørvestover',),
'sedvanligvis': ('sedvanligvis',),
'seksjonsvis': ('seksjonsvis',),
'styggfort': ('styggfort',),
'stykkomtil': ('stykkomtil',),
'sydvestover': ('sydvestover',),
'terminvis': ('terminvis',),
'tertialvis': ('tertialvis',),
'utdannelsesmessig': ('utdannelsesmessig',),
'vis-à-vis': ('vis-à-vis',),
'før': ('før',),
'jo': ('jo',),
'såvel': ('såvel',),
'efterhvert': ('efterhvert',),
'liksom': ('liksom',),
'dann og vann': ('dann og vann',),
'jaggu': ('jaggu',),
'joggu': ('joggu',),
'knekk': ('knekk',),
'live': ('live',),
'og': ('og',),
'sabla': ('sabla',),
'sikksakk': ('sikksakk',),
'stadig': ('stadig',),
'rett og slett': ('rett og slett',),
'såvidt': ('såvidt',),
'for moro skyld': ('for moro skyld',),
'omlag': ('omlag',),
'nattestid': ('nattestid',),
'sørpe': ('sørpe',),
'A.': ('A.',),
'selv': ('selv',),
'forlengst': ('forlengst',),
'sjøl': ('sjøl',),
'drita': ('drita',),
'ennu': ('ennu',),
'skauleies': ('skauleies',),
'iallefall': ('iallefall',),
'til alters': ('til alters',),
'pokka': ('pokka',),
'tilslutt': ('tilslutt',),
'i steden': ('i steden',),
'm.a.': ('m.a.',),
'til syvende og sist': ('til syvende og sist',),
'i en fei': ('i en fei',),
'ender og da': ('ender og da',),
'ender og gang': ('ender og gang',),
'fra arilds tid': ('fra arilds tid',),
'i hør og heim': ('i hør og heim',),
'for fote': ('for fote',),
'natterstid': ('natterstid',),
'natterstider': ('natterstider',),
'høgstdags': ('høgstdags',),
'høgstnattes': ('høgstnattes',),
'beint frem': ('beint frem',),
'beinveges': ('beinveges',),
'beinvegs': ('beinvegs',),
'beinveis': ('beinveis',),
'benvegs': ('benvegs',),
'benveis': ('benveis',),
'en garde': ('en garde',),
'etter hvert': ('etter hvert',),
'framåt': ('framåt',),
'krittende': ('krittende',),
'kvivitt': ('kvivitt',),
'maksis': ('maksis',),
'mangesteds': ('mangesteds',),
'møkka': ('møkka',),
'pill': ('pill',),
'sellende': ('sellende',),
'sirka': ('sirka',),
'subito': ('subito',),
'til sammen': ('til sammen',),
'tomrepes': ('tomrepes',),
'medurs': ('medurs',),
'moturs': ('moturs',),
'til ansvar': ('til ansvar',),
'til ansvars': ('til ansvars',),
'til fullnads': ('til fullnads',),
'concertando': ('concertando',),
'lesto': ('lesto',),
'tardando': ('tardando',),
'natters tid': ('natters tid',),
'natters tider': ('natters tider',),
'snydens': ('snydens',)
}
