"""
The module contains the conversion functions to be
used by the rpy2.robjects functions and methods.

These functions are initially empty place-holders,
raising a NotImplementedError exception.
"""

def ri2ro(obj):
    """ Dummy function for ri2ro.

    This function will convert rpy2.rinterface (ri) low-level objects
    into rpy2.robjects (ro) higher-level objects.
    """
    raise NotImplementedError("Conversion function undefined")

def py2ri(obj):
    """ Dummy function for py2ri.

    This function will convert Python objects into rpy2.rinterface
    (ri) objects.
    """
    raise NotImplementedError("Conversion function undefined")

def py2ro(obj):
    """ Dummy function for py2ro.

    This function will convert Python objects into rpy2.robjects
    (ro) objects.
    """
    raise NotImplementedError("Conversion function undefined")


